# coding: utf-8

"""
    The version of the OpenAPI document: 1.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

# CUSTOMIZED: Added pydantic_encoder import (not in default OpenAPI Generator template)
# pydantic_encoder is needed to address serialization issues with datetime and other non-primitive fields,
# which are not handled by the default JSON encoder.
from pydantic.json import pydantic_encoder


from typing import Optional
from pydantic import BaseModel, Field, StrictStr

class FeeParameters(BaseModel):
    """
    FeeParameters
    """
    gas_price: Optional[StrictStr] = Field(None, alias="gasPrice", description="For blockchains without EIP-1559 support, the maximum price of gas, in gwei, to use per each unit of gas (see `gasLimit`). Requires `gasLimit`. Cannot be used with `feeLevel`, `priorityFee`, or `maxFee`. Estimates for this fee can be obtained through the [`POST /transactions/transfer/estimateFee`](/api-reference/w3s/developer-controlled-wallets/create-transfer-estimate-fee) API. ")
    max_fee: Optional[StrictStr] = Field(None, alias="maxFee", description="For blockchains with EIP-1559 support, the maximum price per unit of gas (see `gasLimit`), in gwei. Requires `priorityFee`, and `gasLimit` to be present. Cannot be used with `feeLevel` or `gasPrice`. Estimates for this fee can be obtained through the [`POST /transactions/transfer/estimateFee`](/api-reference/w3s/developer-controlled-wallets/create-transfer-estimate-fee) API. ")
    priority_fee: Optional[StrictStr] = Field(None, alias="priorityFee", description="For blockchains with EIP-1559 support, the “tip”, in gwei, to add to the base fee as an incentive for validators. Please note that the `maxFee` and `gasLimit` parameters are required alongside the `priorityFee`. The `feeLevel` and `gasPrice` parameters cannot be used with the `priorityFee`.  Estimations for this fee can be obtained through the [`POST /transactions/transfer/estimateFee`](/api-reference/w3s/developer-controlled-wallets/create-transfer-estimate-fee) API. ")
    base_fee: Optional[StrictStr] = Field(None, alias="baseFee", description="For blockchains with EIP-1559 support, the estimated base fee represents the minimum fee required for a transaction to be included in a block on the blockchain.  It is measured in gwei and compensates for the computational resources validators consume to process the transaction.  The base fee is supplemented by a separate \"tip\" called the priority fee, which acts as an extra incentive for validators to prioritize the transaction.  The priority fee is added to the base fee to calculate the final transaction fee. ")
    __properties = ["gasPrice", "maxFee", "priorityFee", "baseFee"]

    def __init__(self, **kwargs):
        if "idempotencyKey" in self.__properties and not kwargs.get("idempotency_key"):
            kwargs["idempotency_key"] = "#REFILL_PLACEHOLDER"

        if "entitySecretCiphertext" in self.__properties and not kwargs.get("entity_secret_ciphertext"):
            kwargs["entity_secret_ciphertext"] = "#REFILL_PLACEHOLDER"
        super().__init__(**kwargs)


    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Return JSON string of the model (handles datetime/UUID/Decimal/Enum, etc.)"""
        # CUSTOMIZED: Added default=pydantic_encoder to handle complex types (datetime, UUID, Enum, etc.)
        # This differs from the default OpenAPI Generator template which doesn't handle these types properly
        return json.dumps(self.to_dict(), default=pydantic_encoder)

    @classmethod
    def from_json(cls, json_str: str) -> FeeParameters:
        """Create an instance of FeeParameters from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> FeeParameters:
        """Create an instance of FeeParameters from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return FeeParameters.parse_obj(obj)

        # fill idempotency_key and ciphertext with placeholder for auto_fill
        if "idempotencyKey" in cls.__properties and not obj.get("idempotencyKey"):
            obj["idempotencyKey"] = "#REFILL_PLACEHOLDER"

        if "entitySecretCiphertext" in cls.__properties and not obj.get("entitySecretCiphertext"):
            obj["entitySecretCiphertext"] = "#REFILL_PLACEHOLDER"

        _obj = FeeParameters.parse_obj({
            "gas_price": obj.get("gasPrice"),
                        "max_fee": obj.get("maxFee"),
                        "priority_fee": obj.get("priorityFee"),
                        "base_fee": obj.get("baseFee")
            
        })
        return _obj


