#!/usr/bin/python
# -*- coding: utf-8 -*-

# Hive Dropbox API
# Copyright (c) 2008-2016 Hive Solutions Lda.
#
# This file is part of Hive Dropbox API.
#
# Hive Dropbox API is free software: you can redistribute it and/or modify
# it under the terms of the Apache License as published by the Apache
# Foundation, either version 2.0 of the License, or (at your option) any
# later version.
#
# Hive Dropbox API is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# Apache License for more details.
#
# You should have received a copy of the Apache License along with
# Hive Dropbox API. If not, see <http://www.apache.org/licenses/>.

__author__ = "João Magalhães <joamag@hive.pt>"
""" The author(s) of the module """

__version__ = "1.0.0"
""" The version of the module """

__revision__ = "$LastChangedRevision$"
""" The revision number of the module """

__date__ = "$LastChangedDate$"
""" The last change date of the module """

__copyright__ = "Copyright (c) 2008-2016 Hive Solutions Lda."
""" The copyright for the module """

__license__ = "Apache License, Version 2.0"
""" The license for the module """

import json

class FileApi(object):

    def session_start_file(self):
        url = self.content_url + "files/upload_session/start"
        contents = self.post(url, headers = {
            "Content-Type" : "application/octet-stream"
        })
        return contents

    def session_finish_file(
        self,
        session_id,
        data = b"",
        offset = 0,
        path = "/file",
        mode = "add",
        autorename = True,
        mute = False
    ):
        url = self.content_url + "files/upload_session/finish"
        params = dict(
            cursor = dict(
                session_id = session_id,
                offset = offset,
            ),
            commit = dict(
                path = path,
                mode = mode,
                autorename = autorename,
                mute = mute
            )
        )
        contents = self.post(
            url,
            data = data,
            headers = {
                "Content-Type" : "application/octet-stream",
                "Dropbox-API-Arg" : json.dumps(params)
            }
        )
        return contents

    def session_append_file_v2(self, session_id, data, offset = 0, close = True):
        url = self.content_url + "files/upload_session/start"
        params = dict(
            cursor = dict(
                session_id = session_id,
                offset = offset,
            ),
            close = close
        )
        contents = self.post(
            url,
            data = data,
            headers = {
                "Content-Type" : "application/octet-stream",
                "Dropbox-API-Arg" : json.dumps(params)
            }
        )
        return contents
