"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
"""
import builtins
import collections.abc
import google.protobuf.descriptor
import google.protobuf.internal.containers
import google.protobuf.internal.enum_type_wrapper
import google.protobuf.message
import google.protobuf.struct_pb2
import sys
import typing

if sys.version_info >= (3, 10):
    import typing as typing_extensions
else:
    import typing_extensions

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

@typing_extensions.final
class OperatorSpec(google.protobuf.message.Message):
    """OperatorSpec represents a specification data model."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    COMPONENT_SPECIFICATION_FIELD_NUMBER: builtins.int
    OPENAPI_SPECIFICATIONS_FIELD_NUMBER: builtins.int
    @property
    def component_specification(self) -> google.protobuf.struct_pb2.Struct:
        """Component specification."""
    @property
    def openapi_specifications(self) -> google.protobuf.struct_pb2.Struct:
        """OpenAPI specification."""
    def __init__(
        self,
        *,
        component_specification: google.protobuf.struct_pb2.Struct | None = ...,
        openapi_specifications: google.protobuf.struct_pb2.Struct | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["component_specification", b"component_specification", "openapi_specifications", b"openapi_specifications"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["component_specification", b"component_specification", "openapi_specifications", b"openapi_specifications"]) -> None: ...

global___OperatorSpec = OperatorSpec

@typing_extensions.final
class OperatorDefinition(google.protobuf.message.Message):
    """////////////////////////////////////////////////////////////////////////

    An Operator is a type of pipeline component that performs data injection and
    manipulation. OperatorDefinition describes a certain type of operator.

    For more information, see
    [Component](https://www.instill.tech/docs/latest/core/concepts/pipeline#pipeline-component)
    in the official documentation.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class _View:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _ViewEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[OperatorDefinition._View.ValueType], builtins.type):
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        VIEW_UNSPECIFIED: OperatorDefinition._View.ValueType  # 0
        """Unspecified, equivalent to BASIC."""
        VIEW_BASIC: OperatorDefinition._View.ValueType  # 1
        """Default view, only includes basic information."""
        VIEW_FULL: OperatorDefinition._View.ValueType  # 2
        """Full representation."""

    class View(_View, metaclass=_ViewEnumTypeWrapper):
        """View defines how an operator definition is presented."""

    VIEW_UNSPECIFIED: OperatorDefinition.View.ValueType  # 0
    """Unspecified, equivalent to BASIC."""
    VIEW_BASIC: OperatorDefinition.View.ValueType  # 1
    """Default view, only includes basic information."""
    VIEW_FULL: OperatorDefinition.View.ValueType  # 2
    """Full representation."""

    NAME_FIELD_NUMBER: builtins.int
    UID_FIELD_NUMBER: builtins.int
    ID_FIELD_NUMBER: builtins.int
    TITLE_FIELD_NUMBER: builtins.int
    DOCUMENTATION_URL_FIELD_NUMBER: builtins.int
    ICON_FIELD_NUMBER: builtins.int
    SPEC_FIELD_NUMBER: builtins.int
    TOMBSTONE_FIELD_NUMBER: builtins.int
    PUBLIC_FIELD_NUMBER: builtins.int
    CUSTOM_FIELD_NUMBER: builtins.int
    ICON_URL_FIELD_NUMBER: builtins.int
    name: builtins.str
    """The name of the operator definition.
    - Format: `operator-definitions/*`
    """
    uid: builtins.str
    """Operator definition UUID."""
    id: builtins.str
    """Operator definition resource ID (used in `name` as the last segment).
    This conforms to RFC-1034, which restricts to letters, numbers, and
    hyphen, with the first character a letter, the last a letter or a number,
    and a 63 character maximum.
    """
    title: builtins.str
    """Operator definition title."""
    documentation_url: builtins.str
    """Operator definition documentation URL."""
    icon: builtins.str
    """Operator definition icon."""
    @property
    def spec(self) -> global___OperatorSpec:
        """Operator definition specification."""
    tombstone: builtins.bool
    """Operator definition tombstone. If true, this configuration is permanently
    off. Otherwise, the configuration is active.
    """
    public: builtins.bool
    """The public flag determines whether this operator definition is available
    to all workspaces.
    """
    custom: builtins.bool
    """The custom flag determines whether this is a custom operator definition."""
    icon_url: builtins.str
    """Operator definition icon URL."""
    def __init__(
        self,
        *,
        name: builtins.str = ...,
        uid: builtins.str = ...,
        id: builtins.str = ...,
        title: builtins.str = ...,
        documentation_url: builtins.str = ...,
        icon: builtins.str = ...,
        spec: global___OperatorSpec | None = ...,
        tombstone: builtins.bool = ...,
        public: builtins.bool = ...,
        custom: builtins.bool = ...,
        icon_url: builtins.str = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["spec", b"spec"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["custom", b"custom", "documentation_url", b"documentation_url", "icon", b"icon", "icon_url", b"icon_url", "id", b"id", "name", b"name", "public", b"public", "spec", b"spec", "title", b"title", "tombstone", b"tombstone", "uid", b"uid"]) -> None: ...

global___OperatorDefinition = OperatorDefinition

@typing_extensions.final
class ListOperatorDefinitionsRequest(google.protobuf.message.Message):
    """/////////////////////////////////////////////////////////////////////
    RPC messages
    /////////////////////////////////////////////////////////////////////

    ListOperatorDefinitionsRequest represents a request to list operator
    definitions.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PAGE_SIZE_FIELD_NUMBER: builtins.int
    PAGE_TOKEN_FIELD_NUMBER: builtins.int
    VIEW_FIELD_NUMBER: builtins.int
    FILTER_FIELD_NUMBER: builtins.int
    page_size: builtins.int
    """The maximum number of OperatorDefinitions to return. The
    service may return fewer than this value. If unspecified, at most 10
    OperatorDefinitions will be returned. The maximum value is 100;
    values above 100 will be coerced to 100.
    """
    page_token: builtins.str
    """Page token."""
    view: global___OperatorDefinition.View.ValueType
    """View allows clients to specify the desired resource view in the response."""
    filter: builtins.str
    """Filter can hold an [AIP-160](https://google.aip.dev/160)-compliant filter
    expression.
    - Example: `create_time>timestamp("2000-06-19T23:31:08.657Z")`.
    """
    def __init__(
        self,
        *,
        page_size: builtins.int | None = ...,
        page_token: builtins.str | None = ...,
        view: global___OperatorDefinition.View.ValueType | None = ...,
        filter: builtins.str | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["_filter", b"_filter", "_page_size", b"_page_size", "_page_token", b"_page_token", "_view", b"_view", "filter", b"filter", "page_size", b"page_size", "page_token", b"page_token", "view", b"view"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["_filter", b"_filter", "_page_size", b"_page_size", "_page_token", b"_page_token", "_view", b"_view", "filter", b"filter", "page_size", b"page_size", "page_token", b"page_token", "view", b"view"]) -> None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_filter", b"_filter"]) -> typing_extensions.Literal["filter"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_page_size", b"_page_size"]) -> typing_extensions.Literal["page_size"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_page_token", b"_page_token"]) -> typing_extensions.Literal["page_token"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_view", b"_view"]) -> typing_extensions.Literal["view"] | None: ...

global___ListOperatorDefinitionsRequest = ListOperatorDefinitionsRequest

@typing_extensions.final
class ListOperatorDefinitionsResponse(google.protobuf.message.Message):
    """ListOperatorDefinitionsResponse contains a list of operator definitions."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    OPERATOR_DEFINITIONS_FIELD_NUMBER: builtins.int
    NEXT_PAGE_TOKEN_FIELD_NUMBER: builtins.int
    TOTAL_SIZE_FIELD_NUMBER: builtins.int
    @property
    def operator_definitions(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___OperatorDefinition]:
        """A list of operator definition resources."""
    next_page_token: builtins.str
    """Next page token."""
    total_size: builtins.int
    """Total number of operator definitions."""
    def __init__(
        self,
        *,
        operator_definitions: collections.abc.Iterable[global___OperatorDefinition] | None = ...,
        next_page_token: builtins.str = ...,
        total_size: builtins.int = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["next_page_token", b"next_page_token", "operator_definitions", b"operator_definitions", "total_size", b"total_size"]) -> None: ...

global___ListOperatorDefinitionsResponse = ListOperatorDefinitionsResponse

@typing_extensions.final
class GetOperatorDefinitionRequest(google.protobuf.message.Message):
    """GetOperatorDefinitionRequest represents a request to fetch the details of a
    operator definition.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAME_FIELD_NUMBER: builtins.int
    VIEW_FIELD_NUMBER: builtins.int
    name: builtins.str
    """The resource name of the operator definition, which allows its access by ID.
    - Format: `operator-definitions/{id}`.
    """
    view: global___OperatorDefinition.View.ValueType
    """View allows clients to specify the desired resource view in the response."""
    def __init__(
        self,
        *,
        name: builtins.str = ...,
        view: global___OperatorDefinition.View.ValueType | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["_view", b"_view", "view", b"view"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["_view", b"_view", "name", b"name", "view", b"view"]) -> None: ...
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_view", b"_view"]) -> typing_extensions.Literal["view"] | None: ...

global___GetOperatorDefinitionRequest = GetOperatorDefinitionRequest

@typing_extensions.final
class GetOperatorDefinitionResponse(google.protobuf.message.Message):
    """GetOperatorDefinitionResponse contains the requested operator definition."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    OPERATOR_DEFINITION_FIELD_NUMBER: builtins.int
    @property
    def operator_definition(self) -> global___OperatorDefinition:
        """The operator definition resource."""
    def __init__(
        self,
        *,
        operator_definition: global___OperatorDefinition | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["operator_definition", b"operator_definition"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["operator_definition", b"operator_definition"]) -> None: ...

global___GetOperatorDefinitionResponse = GetOperatorDefinitionResponse

@typing_extensions.final
class LookUpOperatorDefinitionAdminRequest(google.protobuf.message.Message):
    """LookUpOperatorDefinitionAdminRequest represents a request by an admin to
    query an operator definition by its UID.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PERMALINK_FIELD_NUMBER: builtins.int
    VIEW_FIELD_NUMBER: builtins.int
    permalink: builtins.str
    """The permalink of the operator definition, which allows its access by UID.
    - Format: `operator-definitions/{uid}`.
    """
    view: global___OperatorDefinition.View.ValueType
    """View allows clients to specify the desired operator definition view in the
    response.
    """
    def __init__(
        self,
        *,
        permalink: builtins.str = ...,
        view: global___OperatorDefinition.View.ValueType | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["_view", b"_view", "view", b"view"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["_view", b"_view", "permalink", b"permalink", "view", b"view"]) -> None: ...
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_view", b"_view"]) -> typing_extensions.Literal["view"] | None: ...

global___LookUpOperatorDefinitionAdminRequest = LookUpOperatorDefinitionAdminRequest

@typing_extensions.final
class LookUpOperatorDefinitionAdminResponse(google.protobuf.message.Message):
    """LookUpOperatorDefinitionAdminResponse represents a response for an operator
    definition.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    OPERATOR_DEFINITION_FIELD_NUMBER: builtins.int
    @property
    def operator_definition(self) -> global___OperatorDefinition:
        """The requested operator definition."""
    def __init__(
        self,
        *,
        operator_definition: global___OperatorDefinition | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["operator_definition", b"operator_definition"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["operator_definition", b"operator_definition"]) -> None: ...

global___LookUpOperatorDefinitionAdminResponse = LookUpOperatorDefinitionAdminResponse
