"""
    Nuaudit

    Managed Audit Trail for Cloud Applications  # noqa: E501

    The version of the OpenAPI document: 0.8.0
    Contact: support@nuaudit.com
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from nuaudit_python_autogen.api_client import ApiClient, Endpoint as _Endpoint
from nuaudit_python_autogen.model_utils import (  # noqa: F401
    check_allowed_values,
    check_validations,
    date,
    datetime,
    file_type,
    none_type,
    validate_and_convert_types
)
from nuaudit_python_autogen.model.error_message import ErrorMessage
from nuaudit_python_autogen.model.http_validation_error import HTTPValidationError
from nuaudit_python_autogen.model.permission_deletion import PermissionDeletion
from nuaudit_python_autogen.model.permission_mutation import PermissionMutation
from nuaudit_python_autogen.model.role import Role


class PermissionsApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

        def __add_permissions(
            self,
            organization_id,
            role_id,
            permission_mutation,
            **kwargs
        ):
            """Add Permissions  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.add_permissions(organization_id, role_id, permission_mutation, async_req=True)
            >>> result = thread.get()

            Args:
                organization_id (str):
                role_id (str):
                permission_mutation ([PermissionMutation]):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                Role
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['organization_id'] = \
                organization_id
            kwargs['role_id'] = \
                role_id
            kwargs['permission_mutation'] = \
                permission_mutation
            return self.call_with_http_info(**kwargs)

        self.add_permissions = _Endpoint(
            settings={
                'response_type': (Role,),
                'auth': [
                    'APIKeyHeader'
                ],
                'endpoint_path': '/{organization_id}/roles/{role_id}/permissions',
                'operation_id': 'add_permissions',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'organization_id',
                    'role_id',
                    'permission_mutation',
                ],
                'required': [
                    'organization_id',
                    'role_id',
                    'permission_mutation',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'organization_id':
                        (str,),
                    'role_id':
                        (str,),
                    'permission_mutation':
                        ([PermissionMutation],),
                },
                'attribute_map': {
                    'organization_id': 'organization_id',
                    'role_id': 'role_id',
                },
                'location_map': {
                    'organization_id': 'path',
                    'role_id': 'path',
                    'permission_mutation': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__add_permissions
        )

        def __remove_permissions(
            self,
            organization_id,
            role_id,
            permission_deletion,
            **kwargs
        ):
            """Remove Permissions  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.remove_permissions(organization_id, role_id, permission_deletion, async_req=True)
            >>> result = thread.get()

            Args:
                organization_id (str):
                role_id (str):
                permission_deletion ([PermissionDeletion]):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                Role
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['organization_id'] = \
                organization_id
            kwargs['role_id'] = \
                role_id
            kwargs['permission_deletion'] = \
                permission_deletion
            return self.call_with_http_info(**kwargs)

        self.remove_permissions = _Endpoint(
            settings={
                'response_type': (Role,),
                'auth': [
                    'APIKeyHeader'
                ],
                'endpoint_path': '/{organization_id}/roles/{role_id}/permissions',
                'operation_id': 'remove_permissions',
                'http_method': 'DELETE',
                'servers': None,
            },
            params_map={
                'all': [
                    'organization_id',
                    'role_id',
                    'permission_deletion',
                ],
                'required': [
                    'organization_id',
                    'role_id',
                    'permission_deletion',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'organization_id':
                        (str,),
                    'role_id':
                        (str,),
                    'permission_deletion':
                        ([PermissionDeletion],),
                },
                'attribute_map': {
                    'organization_id': 'organization_id',
                    'role_id': 'role_id',
                },
                'location_map': {
                    'organization_id': 'path',
                    'role_id': 'path',
                    'permission_deletion': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__remove_permissions
        )
