/*
 * Decompiled with CFR 0.152.
 */
package io.ray.runtime.util;

import io.ray.shaded.com.google.common.base.Preconditions;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.nio.channels.FileLock;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.SystemUtils;

public class BinaryFileUtil {
    public static final String CORE_WORKER_JAVA_LIBRARY = "core_worker_library_java";

    /*
     * Enabled aggressive exception aggregation
     */
    public static File getNativeFile(String destDir, String fileName) {
        File dir = new File(destDir);
        if (!dir.exists()) {
            try {
                FileUtils.forceMkdir(dir);
            }
            catch (IOException e) {
                throw new RuntimeException("Couldn't make directory: " + dir.getAbsolutePath(), e);
            }
        }
        String lockFilePath = destDir + File.separator + "file_lock";
        try (FileLock ignored = new RandomAccessFile(lockFilePath, "rw").getChannel().lock();){
            File file;
            block26: {
                String resourceDir;
                if (SystemUtils.IS_OS_MAC) {
                    resourceDir = "native/darwin/";
                } else if (SystemUtils.IS_OS_LINUX) {
                    resourceDir = "native/linux/";
                } else {
                    throw new UnsupportedOperationException("Unsupported os " + SystemUtils.OS_NAME);
                }
                String tempFilePath = String.format("%s/%s.tmp", destDir, fileName);
                File tempFile = new File(tempFilePath);
                String resourcePath = resourceDir + fileName;
                File destFile = new File(String.format("%s/%s", destDir, fileName));
                if (destFile.exists()) {
                    File file2 = destFile;
                    return file2;
                }
                InputStream is = BinaryFileUtil.class.getResourceAsStream("/" + resourcePath);
                try {
                    Preconditions.checkNotNull(is, "{} doesn't exist.", (Object)resourcePath);
                    Files.copy(is, Paths.get(tempFile.getCanonicalPath(), new String[0]), StandardCopyOption.REPLACE_EXISTING);
                    if (!tempFile.renameTo(destFile)) {
                        throw new RuntimeException(String.format("Couldn't rename temp file(%s) to %s", tempFile.getAbsolutePath(), destFile.getAbsolutePath()));
                    }
                    file = destFile;
                    if (is == null) break block26;
                }
                catch (Throwable throwable) {
                    try {
                        if (is != null) {
                            try {
                                is.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        throw new RuntimeException("Couldn't get temp file from resource " + resourcePath, e);
                    }
                }
                is.close();
            }
            return file;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

