# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import json
import warnings
import pulumi
import pulumi.runtime
from typing import Union
from . import utilities, tables

class Route(pulumi.CustomResource):
    actions: pulumi.Output[list]
    description: pulumi.Output[str]
    expression: pulumi.Output[str]
    """
    A filter expression like `match_recipient('.*@gmail.com')`
    """
    priority: pulumi.Output[float]
    """
    Smaller number indicates higher priority. Higher priority routes are handled first.
    """
    region: pulumi.Output[str]
    """
    The region where domain will be created. Default value is `us`.
    """
    def __init__(__self__, resource_name, opts=None, actions=None, description=None, expression=None, priority=None, region=None, __props__=None, __name__=None, __opts__=None):
        """
        Provides a Mailgun Route resource. This can be used to create and manage routes on Mailgun.

        ## Example Usage



        ```python
        import pulumi
        import pulumi_mailgun as mailgun

        # Create a new Mailgun route
        default = mailgun.Route("default",
            actions=[
                "forward('http://example.com/api/v1/foos/')",
                "stop()",
            ],
            description="inbound",
            expression="match_recipient('.*@foo.example.com')",
            priority="0")
        ```


        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] expression: A filter expression like `match_recipient('.*@gmail.com')`
        :param pulumi.Input[float] priority: Smaller number indicates higher priority. Higher priority routes are handled first.
        :param pulumi.Input[str] region: The region where domain will be created. Default value is `us`.
        """
        if __name__ is not None:
            warnings.warn("explicit use of __name__ is deprecated", DeprecationWarning)
            resource_name = __name__
        if __opts__ is not None:
            warnings.warn("explicit use of __opts__ is deprecated, use 'opts' instead", DeprecationWarning)
            opts = __opts__
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = dict()

            if actions is None:
                raise TypeError("Missing required property 'actions'")
            __props__['actions'] = actions
            __props__['description'] = description
            if expression is None:
                raise TypeError("Missing required property 'expression'")
            __props__['expression'] = expression
            if priority is None:
                raise TypeError("Missing required property 'priority'")
            __props__['priority'] = priority
            __props__['region'] = region
        super(Route, __self__).__init__(
            'mailgun:index/route:Route',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name, id, opts=None, actions=None, description=None, expression=None, priority=None, region=None):
        """
        Get an existing Route resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param str id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] expression: A filter expression like `match_recipient('.*@gmail.com')`
        :param pulumi.Input[float] priority: Smaller number indicates higher priority. Higher priority routes are handled first.
        :param pulumi.Input[str] region: The region where domain will be created. Default value is `us`.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = dict()

        __props__["actions"] = actions
        __props__["description"] = description
        __props__["expression"] = expression
        __props__["priority"] = priority
        __props__["region"] = region
        return Route(resource_name, opts=opts, __props__=__props__)
    def translate_output_property(self, prop):
        return tables._CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop

    def translate_input_property(self, prop):
        return tables._SNAKE_TO_CAMEL_CASE_TABLE.get(prop) or prop

