from typing import Final
from typing import Literal
from typing import TypeAlias

T_Inputs: TypeAlias = list[Literal['Down', 'Left', 'Up', 'Right']]

T_Stratagems: TypeAlias = Literal[
    'resupply',
    'orbital illumination flare',
    'hellbomb',
    'reinforce',
    'machine gun',
    'anti-material rifle',
    'stalwart',
    'expendable anti-tank',
    'recoilless rifle',
    'flamethrower',
    'autocannon',
    'railgun',
    'spear',
    'eagle strafing run',
    'eagle airstrike',
    'eagle cluster bomb',
    'eagle napalm airstrike',
    'jump pack',
    'eagle smoke strike',
    'eagle 110mm rocket pods',
    'eagle 500kg bomb',
    'orbital gatling barrage',
    'orbital airburst strike',
    'orbital 120mm he barrage',
    'orbital walking barrage',
    'orbital 380mm he barrage',
    'orbital lasers',
    'orbital railcannon strike',
    'orbital precision strike',
    'orbital gas strike',
    'orbital ems strike',
    'orbital smoke strike',
    'hmg emplacement',
    'shield generation relay',
    'tesla tower',
    'machine gun sentry',
    'gatling sentry',
    'mortar sentry',
    'guard dog',
    'autocannon sentry',
    'rocket sentry',
    'ems mortar sentry',
    'anti-personnel minefield',
    'supply pack',
    'grenade launcher',
    'laser cannon',
    'incendiary mines',
    'guard dog rover',
    'ballistic shield backpack',
    'arc thrower',
    'shield generator pack',
    'patriot exosuit',
]

STRATAGEMS: dict[T_Stratagems, T_Inputs] = {
    'resupply': ['Down', 'Down', 'Up', 'Right'],
    'orbital illumination flare': ['Right', 'Right', 'Left', 'Left'],
    'hellbomb': ['Down', 'Up', 'Left', 'Down', 'Up', 'Right', 'Down', 'Up'],
    'reinforce': ['Up', 'Down', 'Right', 'Left', 'Up'],
    'machine gun': ['Down', 'Left', 'Down', 'Up', 'Right'],
    'anti-material rifle': ['Down', 'Left', 'Right', 'Up', 'Down'],
    'stalwart': ['Down', 'Left', 'Down', 'Up', 'Up', 'Left'],
    'expendable anti-tank': ['Down', 'Down', 'Left', 'Up', 'Right'],
    'recoilless rifle': ['Down', 'Left', 'Right', 'Right', 'Left'],
    'flamethrower': ['Down', 'Left', 'Up', 'Down', 'Up'],
    'autocannon': ['Down', 'Left', 'Down', 'Up', 'Up', 'Right'],
    'railgun': ['Down', 'Right', 'Down', 'Up', 'Left', 'Right'],
    'spear': ['Down', 'Down', 'Up', 'Down', 'Down'],
    'eagle strafing run': ['Up', 'Right', 'Right'],
    'eagle airstrike': ['Up', 'Right', 'Down', 'Right'],
    'eagle cluster bomb': ['Up', 'Right', 'Down', 'Down', 'Right'],
    'eagle napalm airstrike': ['Up', 'Right', 'Down', 'Up'],
    'jump pack': ['Down', 'Up', 'Up', 'Down', 'Up'],
    'eagle smoke strike': ['Up', 'Right', 'Up', 'Down'],
    'eagle 110mm rocket pods': ['Up', 'Right', 'Up', 'Left'],
    'eagle 500kg bomb': ['Up', 'Right', 'Down', 'Down', 'Down'],
    'orbital gatling barrage': ['Right', 'Down', 'Left', 'Up', 'Up'],
    'orbital airburst strike': ['Right', 'Right', 'Right'],
    'orbital 120mm he barrage': ['Right', 'Right', 'Down', 'Left', 'Right', 'Down'],
    'orbital walking barrage': ['Right', 'Down', 'Up', 'Up', 'Left', 'Down', 'Down'],
    'orbital 380mm he barrage': ['Right', 'Down', 'Up', 'Up', 'Left', 'Down', 'Down'],
    'orbital lasers': ['Right', 'Down', 'Up', 'Right', 'Down'],
    'orbital railcannon strike': ['Right', 'Up', 'Down', 'Down', 'Right'],
    'orbital precision strike': ['Right', 'Right', 'Up'],
    'orbital gas strike': ['Right', 'Right', 'Down', 'Right'],
    'orbital ems strike': ['Right', 'Right', 'Left', 'Down'],
    'orbital smoke strike': ['Right', 'Right', 'Down', 'Up'],
    'hmg emplacement': ['Down', 'Up', 'Left', 'Right', 'Right', 'Left'],
    'shield generation relay': ['Down', 'Down', 'Left', 'Right', 'Left', 'Right'],
    'tesla tower': ['Down', 'Up', 'Right', 'Up', 'Left', 'Right'],
    'machine gun sentry': ['Down', 'Up', 'Right', 'Right', 'Up'],
    'gatling sentry': ['Down', 'Up', 'Right', 'Left'],
    'mortar sentry': ['Down', 'Up', 'Right', 'Right', 'Down'],
    'guard dog': ['Down', 'Up', 'Left', 'Up', 'Right', 'Down'],
    'autocannon sentry': ['Down', 'Up', 'Right', 'Up', 'Left', 'Up'],
    'rocket sentry': ['Down', 'Up', 'Right', 'Right', 'Left'],
    'ems mortar sentry': ['Down', 'Up', 'Right', 'Down', 'Right'],
    'anti-personnel minefield': ['Down', 'Left', 'Up', 'Right'],
    'supply pack': ['Down', 'Left', 'Down', 'Up', 'Up', 'Down'],
    'grenade launcher': ['Down', 'Left', 'Up', 'Left', 'Down'],
    'laser cannon': ['Down', 'Left', 'Down', 'Up', 'Left'],
    'incendiary mines': ['Down', 'Left', 'Left', 'Down'],
    'guard dog rover': ['Down', 'Up', 'Left', 'Up', 'Right', 'Right'],
    'ballistic shield backpack': ['Down', 'Left', 'Up', 'Up', 'Right'],
    'arc thrower': ['Down', 'Right', 'Up', 'Left', 'Down'],
    'shield generator pack': ['Down', 'Up', 'Left', 'Right', 'Left', 'Right'],
    'patriot exosuit': ['Left', 'Down', 'Right', 'Up', 'Left', 'Down', 'Down'],
}

INPUT_MAPPING: Final[dict[str, str]] = {'Down': 'S', 'Up': 'W', 'Left': 'A', 'Right': 'D'}
