/*
 * hddm_r++.cpp - DO NOT EDIT THIS FILE
 *
 * This file was generated automatically by hddm-cpp from the file
 * rest.xml

 * This c++ source implements the methods for the classes 
 * described in the data model (from rest.xml). 
 *
 * The hddm data model tool set was written by
 * Richard Jones, University of Connecticut.
 *
 * For more information see the documentation at
 * http://github.com/rjones30/HDDM
 */

#include <sstream>
#include "hddm_r.hpp"

#ifndef _FILE_OFFSET_BITS
# define _FILE_OFFSET_BITS 64
# define _LARGEFILE64_SOURCE 1
#endif

using namespace hddm_r;

std::atomic<int> threads::next_unique_ID(0);
thread_local int threads::ID(0);

static int tags_match(const std::string &a, const std::string &b)
{
   if (a == b) {
      return true;
   }
   else if (a.find("<HDDM ") == 0 && b.find("<HDDM ") == 0) {
      return true;
   }
   else {
      size_t len = a.length();
      int ia=0;
      int ib=0;
      for (; a[ia] == b[ib]; ++ia, ++ib, --len) {}
      for (; a[ia] == ' '; ++ia, --len) {}
      for (; a[ia] == '/'; ++ia, --len) {}
      for (; b[ib] == ' '; ++ib) {}
      for (; b[ib] == '/'; ++ib) {}
      return (a.substr(ia) == b.substr(ib));
   }
}

std::string Comment::toString(int indent) {
   std::stringstream ostr;
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "comment"
        << " text=" << "\"" << m_text << "\""
             << std::endl;
   return ostr.str();
}

std::string Comment::toXML(int indent) {
   std::stringstream ostr;
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "<comment"
        << " text=" << "\"" << getText() << "\""
        << " />" << std::endl;
   return ostr.str();
}

#ifdef HDF5_SUPPORT
hid_t Comment::hdf5Datatype(int inmemory, int verbose)
{
   std::string tname("comment");
   if (inmemory) {
      if (HDDM::s_hdf5_memorytype.find(tname) != HDDM::s_hdf5_memorytype.end())
         return HDDM::s_hdf5_memorytype[tname];
   }
   else {
      if (HDDM::s_hdf5_datatype.find(tname) != HDDM::s_hdf5_datatype.end())
         return HDDM::s_hdf5_datatype[tname];
   }
   hid_t tid = H5Tcreate(H5T_COMPOUND, sizeof(*this));
   hid_t vl_string_tid = H5Tcopy(H5T_C_S1);
   H5Tset_size(vl_string_tid, H5T_VARIABLE);
   H5Tinsert(tid, "text", (char*)&mx_text - (char*)this, vl_string_tid);
   if (inmemory) {
      HDDM::s_hdf5_memorytype["comment"] = tid;
   }
   else {
      HDDM::s_hdf5_datatype["comment"] = tid;
   }
   if (verbose) {
      size_t slen;
      H5LTdtype_to_text(tid, 0, H5LT_DDL, &slen);
      char *ddlstring = (char*)malloc(slen);
      H5LTdtype_to_text(tid, ddlstring, H5LT_DDL, &slen);
      if (inmemory)
         printf("=== in-memory datatype %ld for %s is:\n %s\n", (long int)tid, "comment", ddlstring);
      else
         printf("=== on-disk datatype %ld for %s is:\n %s\n", (long int)tid, "comment", ddlstring);
      free(ddlstring);
   }
   return tid;
}
void Comment::hdf5DataPack()
{
   mx_text = m_text.c_str();
}
void Comment::hdf5DataUnpack()
{
   new(&m_text) std::string();
   if (mx_text != 0) {
      m_text = mx_text;
      m_host->m_hdf5_strings.push_back(&m_text);
   }
}
#endif

std::string DataVersionString::toString(int indent) {
   std::stringstream ostr;
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "dataVersionString"
        << " text=" << "\"" << m_text << "\""
             << std::endl;
   return ostr.str();
}

std::string DataVersionString::toXML(int indent) {
   std::stringstream ostr;
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "<dataVersionString"
        << " text=" << "\"" << getText() << "\""
        << " />" << std::endl;
   return ostr.str();
}

#ifdef HDF5_SUPPORT
hid_t DataVersionString::hdf5Datatype(int inmemory, int verbose)
{
   std::string tname("dataVersionString");
   if (inmemory) {
      if (HDDM::s_hdf5_memorytype.find(tname) != HDDM::s_hdf5_memorytype.end())
         return HDDM::s_hdf5_memorytype[tname];
   }
   else {
      if (HDDM::s_hdf5_datatype.find(tname) != HDDM::s_hdf5_datatype.end())
         return HDDM::s_hdf5_datatype[tname];
   }
   hid_t tid = H5Tcreate(H5T_COMPOUND, sizeof(*this));
   hid_t vl_string_tid = H5Tcopy(H5T_C_S1);
   H5Tset_size(vl_string_tid, H5T_VARIABLE);
   H5Tinsert(tid, "text", (char*)&mx_text - (char*)this, vl_string_tid);
   if (inmemory) {
      HDDM::s_hdf5_memorytype["dataVersionString"] = tid;
   }
   else {
      HDDM::s_hdf5_datatype["dataVersionString"] = tid;
   }
   if (verbose) {
      size_t slen;
      H5LTdtype_to_text(tid, 0, H5LT_DDL, &slen);
      char *ddlstring = (char*)malloc(slen);
      H5LTdtype_to_text(tid, ddlstring, H5LT_DDL, &slen);
      if (inmemory)
         printf("=== in-memory datatype %ld for %s is:\n %s\n", (long int)tid, "dataVersionString", ddlstring);
      else
         printf("=== on-disk datatype %ld for %s is:\n %s\n", (long int)tid, "dataVersionString", ddlstring);
      free(ddlstring);
   }
   return tid;
}
void DataVersionString::hdf5DataPack()
{
   mx_text = m_text.c_str();
}
void DataVersionString::hdf5DataUnpack()
{
   new(&m_text) std::string();
   if (mx_text != 0) {
      m_text = mx_text;
      m_host->m_hdf5_strings.push_back(&m_text);
   }
}
#endif

std::string CcdbContext::toString(int indent) {
   std::stringstream ostr;
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "ccdbContext"
        << " text=" << "\"" << m_text << "\""
             << std::endl;
   return ostr.str();
}

std::string CcdbContext::toXML(int indent) {
   std::stringstream ostr;
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "<ccdbContext"
        << " text=" << "\"" << getText() << "\""
        << " />" << std::endl;
   return ostr.str();
}

#ifdef HDF5_SUPPORT
hid_t CcdbContext::hdf5Datatype(int inmemory, int verbose)
{
   std::string tname("ccdbContext");
   if (inmemory) {
      if (HDDM::s_hdf5_memorytype.find(tname) != HDDM::s_hdf5_memorytype.end())
         return HDDM::s_hdf5_memorytype[tname];
   }
   else {
      if (HDDM::s_hdf5_datatype.find(tname) != HDDM::s_hdf5_datatype.end())
         return HDDM::s_hdf5_datatype[tname];
   }
   hid_t tid = H5Tcreate(H5T_COMPOUND, sizeof(*this));
   hid_t vl_string_tid = H5Tcopy(H5T_C_S1);
   H5Tset_size(vl_string_tid, H5T_VARIABLE);
   H5Tinsert(tid, "text", (char*)&mx_text - (char*)this, vl_string_tid);
   if (inmemory) {
      HDDM::s_hdf5_memorytype["ccdbContext"] = tid;
   }
   else {
      HDDM::s_hdf5_datatype["ccdbContext"] = tid;
   }
   if (verbose) {
      size_t slen;
      H5LTdtype_to_text(tid, 0, H5LT_DDL, &slen);
      char *ddlstring = (char*)malloc(slen);
      H5LTdtype_to_text(tid, ddlstring, H5LT_DDL, &slen);
      if (inmemory)
         printf("=== in-memory datatype %ld for %s is:\n %s\n", (long int)tid, "ccdbContext", ddlstring);
      else
         printf("=== on-disk datatype %ld for %s is:\n %s\n", (long int)tid, "ccdbContext", ddlstring);
      free(ddlstring);
   }
   return tid;
}
void CcdbContext::hdf5DataPack()
{
   mx_text = m_text.c_str();
}
void CcdbContext::hdf5DataUnpack()
{
   new(&m_text) std::string();
   if (mx_text != 0) {
      m_text = mx_text;
      m_host->m_hdf5_strings.push_back(&m_text);
   }
}
#endif

std::string Origin::toString(int indent) {
   std::stringstream ostr;
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "origin"
        << " t=" << m_t
        << " vx=" << m_vx
        << " vy=" << m_vy
        << " vz=" << m_vz
             << std::endl;
   return ostr.str();
}

std::string Origin::toXML(int indent) {
   std::stringstream ostr;
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "<origin"
        << " lunit=" << "\"" << getLunit() << "\""
        << " t=" << "\"" << getT() << "\""
        << " vx=" << "\"" << getVx() << "\""
        << " vy=" << "\"" << getVy() << "\""
        << " vz=" << "\"" << getVz() << "\""
        << " />" << std::endl;
   return ostr.str();
}

#ifdef HDF5_SUPPORT
hid_t Origin::hdf5Datatype(int inmemory, int verbose)
{
   std::string tname("origin");
   if (inmemory) {
      if (HDDM::s_hdf5_memorytype.find(tname) != HDDM::s_hdf5_memorytype.end())
         return HDDM::s_hdf5_memorytype[tname];
   }
   else {
      if (HDDM::s_hdf5_datatype.find(tname) != HDDM::s_hdf5_datatype.end())
         return HDDM::s_hdf5_datatype[tname];
   }
   hid_t tid = H5Tcreate(H5T_COMPOUND, sizeof(*this));
   hid_t vl_string_tid = H5Tcopy(H5T_C_S1);
   H5Tset_size(vl_string_tid, H5T_VARIABLE);
   H5Tinsert(tid, "t", (char*)&m_t - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   H5Tinsert(tid, "vx", (char*)&m_vx - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   H5Tinsert(tid, "vy", (char*)&m_vy - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   H5Tinsert(tid, "vz", (char*)&m_vz - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   if (inmemory) {
      HDDM::s_hdf5_memorytype["origin"] = tid;
   }
   else {
      HDDM::s_hdf5_datatype["origin"] = tid;
   }
   if (verbose) {
      size_t slen;
      H5LTdtype_to_text(tid, 0, H5LT_DDL, &slen);
      char *ddlstring = (char*)malloc(slen);
      H5LTdtype_to_text(tid, ddlstring, H5LT_DDL, &slen);
      if (inmemory)
         printf("=== in-memory datatype %ld for %s is:\n %s\n", (long int)tid, "origin", ddlstring);
      else
         printf("=== on-disk datatype %ld for %s is:\n %s\n", (long int)tid, "origin", ddlstring);
      free(ddlstring);
   }
   return tid;
}
void Origin::hdf5DataPack()
{
}
void Origin::hdf5DataUnpack()
{
}
#endif

std::string Momentum::toString(int indent) {
   std::stringstream ostr;
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "momentum"
        << " E=" << m_E
        << " px=" << m_px
        << " py=" << m_py
        << " pz=" << m_pz
             << std::endl;
   return ostr.str();
}

std::string Momentum::toXML(int indent) {
   std::stringstream ostr;
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "<momentum"
        << " E=" << "\"" << getE() << "\""
        << " Eunit=" << "\"" << getEunit() << "\""
        << " punit=" << "\"" << getPunit() << "\""
        << " px=" << "\"" << getPx() << "\""
        << " py=" << "\"" << getPy() << "\""
        << " pz=" << "\"" << getPz() << "\""
        << " />" << std::endl;
   return ostr.str();
}

#ifdef HDF5_SUPPORT
hid_t Momentum::hdf5Datatype(int inmemory, int verbose)
{
   std::string tname("momentum");
   if (inmemory) {
      if (HDDM::s_hdf5_memorytype.find(tname) != HDDM::s_hdf5_memorytype.end())
         return HDDM::s_hdf5_memorytype[tname];
   }
   else {
      if (HDDM::s_hdf5_datatype.find(tname) != HDDM::s_hdf5_datatype.end())
         return HDDM::s_hdf5_datatype[tname];
   }
   hid_t tid = H5Tcreate(H5T_COMPOUND, sizeof(*this));
   hid_t vl_string_tid = H5Tcopy(H5T_C_S1);
   H5Tset_size(vl_string_tid, H5T_VARIABLE);
   H5Tinsert(tid, "E", (char*)&m_E - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   H5Tinsert(tid, "px", (char*)&m_px - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   H5Tinsert(tid, "py", (char*)&m_py - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   H5Tinsert(tid, "pz", (char*)&m_pz - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   if (inmemory) {
      HDDM::s_hdf5_memorytype["momentum"] = tid;
   }
   else {
      HDDM::s_hdf5_datatype["momentum"] = tid;
   }
   if (verbose) {
      size_t slen;
      H5LTdtype_to_text(tid, 0, H5LT_DDL, &slen);
      char *ddlstring = (char*)malloc(slen);
      H5LTdtype_to_text(tid, ddlstring, H5LT_DDL, &slen);
      if (inmemory)
         printf("=== in-memory datatype %ld for %s is:\n %s\n", (long int)tid, "momentum", ddlstring);
      else
         printf("=== on-disk datatype %ld for %s is:\n %s\n", (long int)tid, "momentum", ddlstring);
      free(ddlstring);
   }
   return tid;
}
void Momentum::hdf5DataPack()
{
}
void Momentum::hdf5DataUnpack()
{
}
#endif

std::string Product::toString(int indent) {
   std::stringstream ostr;
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "product"
        << " id=" << m_id
        << " parentId=" << m_parentId
        << " pdgtype=" << m_pdgtype
             << std::endl;
   if (! m_momentum_link.empty()) {
      ostr << m_momentum_link.begin()->toString(indent + 2);
   }
   return ostr.str();
}

std::string Product::toXML(int indent) {
   std::stringstream ostr;
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "<product"
        << " id=" << "\"" << getId() << "\""
        << " parentId=" << "\"" << getParentId() << "\""
        << " pdgtype=" << "\"" << getPdgtype() << "\""
        << ">" << std::endl;
   if (! m_momentum_link.empty()) {
      ostr << m_momentum_link.begin()->toXML(indent + 2);
   }
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "</product>"
        << std::endl;
   return ostr.str();
}

#ifdef HDF5_SUPPORT
hid_t Product::hdf5Datatype(int inmemory, int verbose)
{
   std::string tname("product");
   if (inmemory) {
      if (HDDM::s_hdf5_memorytype.find(tname) != HDDM::s_hdf5_memorytype.end())
         return HDDM::s_hdf5_memorytype[tname];
   }
   else {
      if (HDDM::s_hdf5_datatype.find(tname) != HDDM::s_hdf5_datatype.end())
         return HDDM::s_hdf5_datatype[tname];
   }
   hid_t tid = H5Tcreate(H5T_COMPOUND, sizeof(*this));
   hid_t vl_string_tid = H5Tcopy(H5T_C_S1);
   H5Tset_size(vl_string_tid, H5T_VARIABLE);
   H5Tinsert(tid, "id", (char*)&m_id - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I32LE));
   H5Tinsert(tid, "parentId", (char*)&m_parentId - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I32LE));
   H5Tinsert(tid, "pdgtype", (char*)&m_pdgtype - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I32LE));
   H5Tinsert(tid, "MomentumList_size", (char*)&m_momentum_link.m_size - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   H5Tinsert(tid, "MomentumList_offset", (char*)&m_momentum_link.m_ref - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   if (inmemory) {
      HDDM::s_hdf5_memorytype["product"] = tid;
   }
   else {
      HDDM::s_hdf5_datatype["product"] = tid;
   }
   if (verbose) {
      size_t slen;
      H5LTdtype_to_text(tid, 0, H5LT_DDL, &slen);
      char *ddlstring = (char*)malloc(slen);
      H5LTdtype_to_text(tid, ddlstring, H5LT_DDL, &slen);
      if (inmemory)
         printf("=== in-memory datatype %ld for %s is:\n %s\n", (long int)tid, "product", ddlstring);
      else
         printf("=== on-disk datatype %ld for %s is:\n %s\n", (long int)tid, "product", ddlstring);
      free(ddlstring);
   }
   return tid;
}
void Product::hdf5DataPack()
{
   m_momentum_link.deflate();
}
void Product::hdf5DataUnpack()
{
   {
      std::list<Momentum*> *host_plist = &m_host->m_momentum_plist;
      m_momentum_link.inflate(m_host, host_plist, this);
      MomentumList::iterator iter;
      for (iter = m_momentum_link.begin();
           iter != m_momentum_link.end(); ++iter)
      {
         iter->hdf5DataUnpack();
      }
   }
}
#endif

std::string Vertex::toString(int indent) {
   std::stringstream ostr;
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "vertex"
             << std::endl;
   if (! m_origin_link.empty()) {
      ostr << m_origin_link.begin()->toString(indent + 2);
   }
   int ProductListCount=0;
   for (ProductList::iterator it = m_product_list.begin();
        it != m_product_list.end(); ++it)
   {
      if (++ProductListCount > m_product_list.size()) {
         throw std::runtime_error("hddm_r::toString error - list improperly terminated!");
      }
      ostr << it->toString(indent + 2);
   }
   return ostr.str();
}

std::string Vertex::toXML(int indent) {
   std::stringstream ostr;
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "<vertex"
        << ">" << std::endl;
   if (! m_origin_link.empty()) {
      ostr << m_origin_link.begin()->toXML(indent + 2);
   }
   int ProductListCount=0;
   for (ProductList::iterator it = m_product_list.begin();
        it != m_product_list.end(); ++it)
   {
      if (++ProductListCount > m_product_list.size()) {
         throw std::runtime_error("hddm_r::toXML error - list improperly terminated!");
      }
      ostr << it->toXML(indent + 2);
   }
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "</vertex>"
        << std::endl;
   return ostr.str();
}

#ifdef HDF5_SUPPORT
hid_t Vertex::hdf5Datatype(int inmemory, int verbose)
{
   std::string tname("vertex");
   if (inmemory) {
      if (HDDM::s_hdf5_memorytype.find(tname) != HDDM::s_hdf5_memorytype.end())
         return HDDM::s_hdf5_memorytype[tname];
   }
   else {
      if (HDDM::s_hdf5_datatype.find(tname) != HDDM::s_hdf5_datatype.end())
         return HDDM::s_hdf5_datatype[tname];
   }
   hid_t tid = H5Tcreate(H5T_COMPOUND, sizeof(*this));
   hid_t vl_string_tid = H5Tcopy(H5T_C_S1);
   H5Tset_size(vl_string_tid, H5T_VARIABLE);
   H5Tinsert(tid, "OriginList_size", (char*)&m_origin_link.m_size - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   H5Tinsert(tid, "OriginList_offset", (char*)&m_origin_link.m_ref - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   H5Tinsert(tid, "ProductList_size", (char*)&m_product_list.m_size - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   H5Tinsert(tid, "ProductList_offset", (char*)&m_product_list.m_ref - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   if (inmemory) {
      HDDM::s_hdf5_memorytype["vertex"] = tid;
   }
   else {
      HDDM::s_hdf5_datatype["vertex"] = tid;
   }
   if (verbose) {
      size_t slen;
      H5LTdtype_to_text(tid, 0, H5LT_DDL, &slen);
      char *ddlstring = (char*)malloc(slen);
      H5LTdtype_to_text(tid, ddlstring, H5LT_DDL, &slen);
      if (inmemory)
         printf("=== in-memory datatype %ld for %s is:\n %s\n", (long int)tid, "vertex", ddlstring);
      else
         printf("=== on-disk datatype %ld for %s is:\n %s\n", (long int)tid, "vertex", ddlstring);
      free(ddlstring);
   }
   return tid;
}
void Vertex::hdf5DataPack()
{
   m_origin_link.deflate();
   m_product_list.deflate();
}
void Vertex::hdf5DataUnpack()
{
   {
      std::list<Origin*> *host_plist = &m_host->m_origin_plist;
      m_origin_link.inflate(m_host, host_plist, this);
      OriginList::iterator iter;
      for (iter = m_origin_link.begin();
           iter != m_origin_link.end(); ++iter)
      {
         iter->hdf5DataUnpack();
      }
   }
   {
      std::list<Product*> *host_plist = &m_host->m_product_plist;
      m_product_list.inflate(m_host, host_plist, this);
      ProductList::iterator iter;
      for (iter = m_product_list.begin();
           iter != m_product_list.end(); ++iter)
      {
         iter->hdf5DataUnpack();
      }
   }
}
#endif

std::string Reaction::toString(int indent) {
   std::stringstream ostr;
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "reaction"
        << " Ebeam=" << m_Ebeam
        << " jtag=" << "\"" << m_jtag << "\""
        << " targetType=" << ParticleType((Particle_t)m_targetType)
        << " type=" << m_type
        << " weight=" << m_weight
             << std::endl;
   int VertexListCount=0;
   for (VertexList::iterator it = m_vertex_list.begin();
        it != m_vertex_list.end(); ++it)
   {
      if (++VertexListCount > m_vertex_list.size()) {
         throw std::runtime_error("hddm_r::toString error - list improperly terminated!");
      }
      ostr << it->toString(indent + 2);
   }
   return ostr.str();
}

std::string Reaction::toXML(int indent) {
   std::stringstream ostr;
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "<reaction"
        << " Ebeam=" << "\"" << getEbeam() << "\""
        << " Eunit=" << "\"" << getEunit() << "\""
        << " jtag=" << "\"" << getJtag() << "\""
        << " targetType=\"" << ParticleType((Particle_t)m_targetType) << "\""
        << " type=" << "\"" << getType() << "\""
        << " weight=" << "\"" << getWeight() << "\""
        << ">" << std::endl;
   int VertexListCount=0;
   for (VertexList::iterator it = m_vertex_list.begin();
        it != m_vertex_list.end(); ++it)
   {
      if (++VertexListCount > m_vertex_list.size()) {
         throw std::runtime_error("hddm_r::toXML error - list improperly terminated!");
      }
      ostr << it->toXML(indent + 2);
   }
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "</reaction>"
        << std::endl;
   return ostr.str();
}

#ifdef HDF5_SUPPORT
hid_t Reaction::hdf5Datatype(int inmemory, int verbose)
{
   std::string tname("reaction");
   if (inmemory) {
      if (HDDM::s_hdf5_memorytype.find(tname) != HDDM::s_hdf5_memorytype.end())
         return HDDM::s_hdf5_memorytype[tname];
   }
   else {
      if (HDDM::s_hdf5_datatype.find(tname) != HDDM::s_hdf5_datatype.end())
         return HDDM::s_hdf5_datatype[tname];
   }
   hid_t tid = H5Tcreate(H5T_COMPOUND, sizeof(*this));
   hid_t vl_string_tid = H5Tcopy(H5T_C_S1);
   H5Tset_size(vl_string_tid, H5T_VARIABLE);
   H5Tinsert(tid, "Ebeam", (char*)&m_Ebeam - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   H5Tinsert(tid, "jtag", (char*)&mx_jtag - (char*)this, vl_string_tid);
   H5Tinsert(tid, "targetType", (char*)&m_targetType - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I32LE));
   H5Tinsert(tid, "type", (char*)&m_type - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I32LE));
   H5Tinsert(tid, "weight", (char*)&m_weight - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   H5Tinsert(tid, "VertexList_size", (char*)&m_vertex_list.m_size - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   H5Tinsert(tid, "VertexList_offset", (char*)&m_vertex_list.m_ref - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   if (inmemory) {
      HDDM::s_hdf5_memorytype["reaction"] = tid;
   }
   else {
      HDDM::s_hdf5_datatype["reaction"] = tid;
   }
   if (verbose) {
      size_t slen;
      H5LTdtype_to_text(tid, 0, H5LT_DDL, &slen);
      char *ddlstring = (char*)malloc(slen);
      H5LTdtype_to_text(tid, ddlstring, H5LT_DDL, &slen);
      if (inmemory)
         printf("=== in-memory datatype %ld for %s is:\n %s\n", (long int)tid, "reaction", ddlstring);
      else
         printf("=== on-disk datatype %ld for %s is:\n %s\n", (long int)tid, "reaction", ddlstring);
      free(ddlstring);
   }
   return tid;
}
void Reaction::hdf5DataPack()
{
   mx_jtag = m_jtag.c_str();
   m_vertex_list.deflate();
}
void Reaction::hdf5DataUnpack()
{
   new(&m_jtag) std::string();
   if (mx_jtag != 0) {
      m_jtag = mx_jtag;
      m_host->m_hdf5_strings.push_back(&m_jtag);
   }
   {
      std::list<Vertex*> *host_plist = &m_host->m_vertex_plist;
      m_vertex_list.inflate(m_host, host_plist, this);
      VertexList::iterator iter;
      for (iter = m_vertex_list.begin();
           iter != m_vertex_list.end(); ++iter)
      {
         iter->hdf5DataUnpack();
      }
   }
}
#endif

std::string TagmChannel::toString(int indent) {
   std::stringstream ostr;
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "tagmChannel"
        << " column=" << m_column
             << std::endl;
   return ostr.str();
}

std::string TagmChannel::toXML(int indent) {
   std::stringstream ostr;
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "<tagmChannel"
        << " column=" << "\"" << getColumn() << "\""
        << " />" << std::endl;
   return ostr.str();
}

#ifdef HDF5_SUPPORT
hid_t TagmChannel::hdf5Datatype(int inmemory, int verbose)
{
   std::string tname("tagmChannel");
   if (inmemory) {
      if (HDDM::s_hdf5_memorytype.find(tname) != HDDM::s_hdf5_memorytype.end())
         return HDDM::s_hdf5_memorytype[tname];
   }
   else {
      if (HDDM::s_hdf5_datatype.find(tname) != HDDM::s_hdf5_datatype.end())
         return HDDM::s_hdf5_datatype[tname];
   }
   hid_t tid = H5Tcreate(H5T_COMPOUND, sizeof(*this));
   hid_t vl_string_tid = H5Tcopy(H5T_C_S1);
   H5Tset_size(vl_string_tid, H5T_VARIABLE);
   H5Tinsert(tid, "column", (char*)&m_column - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I32LE));
   if (inmemory) {
      HDDM::s_hdf5_memorytype["tagmChannel"] = tid;
   }
   else {
      HDDM::s_hdf5_datatype["tagmChannel"] = tid;
   }
   if (verbose) {
      size_t slen;
      H5LTdtype_to_text(tid, 0, H5LT_DDL, &slen);
      char *ddlstring = (char*)malloc(slen);
      H5LTdtype_to_text(tid, ddlstring, H5LT_DDL, &slen);
      if (inmemory)
         printf("=== in-memory datatype %ld for %s is:\n %s\n", (long int)tid, "tagmChannel", ddlstring);
      else
         printf("=== on-disk datatype %ld for %s is:\n %s\n", (long int)tid, "tagmChannel", ddlstring);
      free(ddlstring);
   }
   return tid;
}
void TagmChannel::hdf5DataPack()
{
}
void TagmChannel::hdf5DataUnpack()
{
}
#endif

std::string TagmBeamPhoton::toString(int indent) {
   std::stringstream ostr;
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "tagmBeamPhoton"
        << " E=" << m_E
        << " jtag=" << "\"" << m_jtag << "\""
        << " t=" << m_t
             << std::endl;
   if (! m_tagmChannel_link.empty()) {
      ostr << m_tagmChannel_link.begin()->toString(indent + 2);
   }
   return ostr.str();
}

std::string TagmBeamPhoton::toXML(int indent) {
   std::stringstream ostr;
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "<tagmBeamPhoton"
        << " E=" << "\"" << getE() << "\""
        << " Eunit=" << "\"" << getEunit() << "\""
        << " jtag=" << "\"" << getJtag() << "\""
        << " t=" << "\"" << getT() << "\""
        << " tunit=" << "\"" << getTunit() << "\""
        << ">" << std::endl;
   if (! m_tagmChannel_link.empty()) {
      ostr << m_tagmChannel_link.begin()->toXML(indent + 2);
   }
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "</tagmBeamPhoton>"
        << std::endl;
   return ostr.str();
}

#ifdef HDF5_SUPPORT
hid_t TagmBeamPhoton::hdf5Datatype(int inmemory, int verbose)
{
   std::string tname("tagmBeamPhoton");
   if (inmemory) {
      if (HDDM::s_hdf5_memorytype.find(tname) != HDDM::s_hdf5_memorytype.end())
         return HDDM::s_hdf5_memorytype[tname];
   }
   else {
      if (HDDM::s_hdf5_datatype.find(tname) != HDDM::s_hdf5_datatype.end())
         return HDDM::s_hdf5_datatype[tname];
   }
   hid_t tid = H5Tcreate(H5T_COMPOUND, sizeof(*this));
   hid_t vl_string_tid = H5Tcopy(H5T_C_S1);
   H5Tset_size(vl_string_tid, H5T_VARIABLE);
   H5Tinsert(tid, "E", (char*)&m_E - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   H5Tinsert(tid, "jtag", (char*)&mx_jtag - (char*)this, vl_string_tid);
   H5Tinsert(tid, "t", (char*)&m_t - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   H5Tinsert(tid, "TagmChannelList_size", (char*)&m_tagmChannel_link.m_size - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   H5Tinsert(tid, "TagmChannelList_offset", (char*)&m_tagmChannel_link.m_ref - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   if (inmemory) {
      HDDM::s_hdf5_memorytype["tagmBeamPhoton"] = tid;
   }
   else {
      HDDM::s_hdf5_datatype["tagmBeamPhoton"] = tid;
   }
   if (verbose) {
      size_t slen;
      H5LTdtype_to_text(tid, 0, H5LT_DDL, &slen);
      char *ddlstring = (char*)malloc(slen);
      H5LTdtype_to_text(tid, ddlstring, H5LT_DDL, &slen);
      if (inmemory)
         printf("=== in-memory datatype %ld for %s is:\n %s\n", (long int)tid, "tagmBeamPhoton", ddlstring);
      else
         printf("=== on-disk datatype %ld for %s is:\n %s\n", (long int)tid, "tagmBeamPhoton", ddlstring);
      free(ddlstring);
   }
   return tid;
}
void TagmBeamPhoton::hdf5DataPack()
{
   mx_jtag = m_jtag.c_str();
   m_tagmChannel_link.deflate();
}
void TagmBeamPhoton::hdf5DataUnpack()
{
   new(&m_jtag) std::string();
   if (mx_jtag != 0) {
      m_jtag = mx_jtag;
      m_host->m_hdf5_strings.push_back(&m_jtag);
   }
   {
      std::list<TagmChannel*> *host_plist = &m_host->m_tagmChannel_plist;
      m_tagmChannel_link.inflate(m_host, host_plist, this);
      TagmChannelList::iterator iter;
      for (iter = m_tagmChannel_link.begin();
           iter != m_tagmChannel_link.end(); ++iter)
      {
         iter->hdf5DataUnpack();
      }
   }
}
#endif

std::string TaghChannel::toString(int indent) {
   std::stringstream ostr;
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "taghChannel"
        << " counter=" << m_counter
             << std::endl;
   return ostr.str();
}

std::string TaghChannel::toXML(int indent) {
   std::stringstream ostr;
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "<taghChannel"
        << " counter=" << "\"" << getCounter() << "\""
        << " />" << std::endl;
   return ostr.str();
}

#ifdef HDF5_SUPPORT
hid_t TaghChannel::hdf5Datatype(int inmemory, int verbose)
{
   std::string tname("taghChannel");
   if (inmemory) {
      if (HDDM::s_hdf5_memorytype.find(tname) != HDDM::s_hdf5_memorytype.end())
         return HDDM::s_hdf5_memorytype[tname];
   }
   else {
      if (HDDM::s_hdf5_datatype.find(tname) != HDDM::s_hdf5_datatype.end())
         return HDDM::s_hdf5_datatype[tname];
   }
   hid_t tid = H5Tcreate(H5T_COMPOUND, sizeof(*this));
   hid_t vl_string_tid = H5Tcopy(H5T_C_S1);
   H5Tset_size(vl_string_tid, H5T_VARIABLE);
   H5Tinsert(tid, "counter", (char*)&m_counter - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I32LE));
   if (inmemory) {
      HDDM::s_hdf5_memorytype["taghChannel"] = tid;
   }
   else {
      HDDM::s_hdf5_datatype["taghChannel"] = tid;
   }
   if (verbose) {
      size_t slen;
      H5LTdtype_to_text(tid, 0, H5LT_DDL, &slen);
      char *ddlstring = (char*)malloc(slen);
      H5LTdtype_to_text(tid, ddlstring, H5LT_DDL, &slen);
      if (inmemory)
         printf("=== in-memory datatype %ld for %s is:\n %s\n", (long int)tid, "taghChannel", ddlstring);
      else
         printf("=== on-disk datatype %ld for %s is:\n %s\n", (long int)tid, "taghChannel", ddlstring);
      free(ddlstring);
   }
   return tid;
}
void TaghChannel::hdf5DataPack()
{
}
void TaghChannel::hdf5DataUnpack()
{
}
#endif

std::string TaghBeamPhoton::toString(int indent) {
   std::stringstream ostr;
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "taghBeamPhoton"
        << " E=" << m_E
        << " jtag=" << "\"" << m_jtag << "\""
        << " t=" << m_t
             << std::endl;
   if (! m_taghChannel_link.empty()) {
      ostr << m_taghChannel_link.begin()->toString(indent + 2);
   }
   return ostr.str();
}

std::string TaghBeamPhoton::toXML(int indent) {
   std::stringstream ostr;
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "<taghBeamPhoton"
        << " E=" << "\"" << getE() << "\""
        << " Eunit=" << "\"" << getEunit() << "\""
        << " jtag=" << "\"" << getJtag() << "\""
        << " t=" << "\"" << getT() << "\""
        << " tunit=" << "\"" << getTunit() << "\""
        << ">" << std::endl;
   if (! m_taghChannel_link.empty()) {
      ostr << m_taghChannel_link.begin()->toXML(indent + 2);
   }
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "</taghBeamPhoton>"
        << std::endl;
   return ostr.str();
}

#ifdef HDF5_SUPPORT
hid_t TaghBeamPhoton::hdf5Datatype(int inmemory, int verbose)
{
   std::string tname("taghBeamPhoton");
   if (inmemory) {
      if (HDDM::s_hdf5_memorytype.find(tname) != HDDM::s_hdf5_memorytype.end())
         return HDDM::s_hdf5_memorytype[tname];
   }
   else {
      if (HDDM::s_hdf5_datatype.find(tname) != HDDM::s_hdf5_datatype.end())
         return HDDM::s_hdf5_datatype[tname];
   }
   hid_t tid = H5Tcreate(H5T_COMPOUND, sizeof(*this));
   hid_t vl_string_tid = H5Tcopy(H5T_C_S1);
   H5Tset_size(vl_string_tid, H5T_VARIABLE);
   H5Tinsert(tid, "E", (char*)&m_E - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   H5Tinsert(tid, "jtag", (char*)&mx_jtag - (char*)this, vl_string_tid);
   H5Tinsert(tid, "t", (char*)&m_t - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   H5Tinsert(tid, "TaghChannelList_size", (char*)&m_taghChannel_link.m_size - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   H5Tinsert(tid, "TaghChannelList_offset", (char*)&m_taghChannel_link.m_ref - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   if (inmemory) {
      HDDM::s_hdf5_memorytype["taghBeamPhoton"] = tid;
   }
   else {
      HDDM::s_hdf5_datatype["taghBeamPhoton"] = tid;
   }
   if (verbose) {
      size_t slen;
      H5LTdtype_to_text(tid, 0, H5LT_DDL, &slen);
      char *ddlstring = (char*)malloc(slen);
      H5LTdtype_to_text(tid, ddlstring, H5LT_DDL, &slen);
      if (inmemory)
         printf("=== in-memory datatype %ld for %s is:\n %s\n", (long int)tid, "taghBeamPhoton", ddlstring);
      else
         printf("=== on-disk datatype %ld for %s is:\n %s\n", (long int)tid, "taghBeamPhoton", ddlstring);
      free(ddlstring);
   }
   return tid;
}
void TaghBeamPhoton::hdf5DataPack()
{
   mx_jtag = m_jtag.c_str();
   m_taghChannel_link.deflate();
}
void TaghBeamPhoton::hdf5DataUnpack()
{
   new(&m_jtag) std::string();
   if (mx_jtag != 0) {
      m_jtag = mx_jtag;
      m_host->m_hdf5_strings.push_back(&m_jtag);
   }
   {
      std::list<TaghChannel*> *host_plist = &m_host->m_taghChannel_plist;
      m_taghChannel_link.inflate(m_host, host_plist, this);
      TaghChannelList::iterator iter;
      for (iter = m_taghChannel_link.begin();
           iter != m_taghChannel_link.end(); ++iter)
      {
         iter->hdf5DataUnpack();
      }
   }
}
#endif

std::string FcalCorrelations::toString(int indent) {
   std::stringstream ostr;
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "fcalCorrelations"
        << " Etcorr=" << m_Etcorr
        << " Excorr=" << m_Excorr
        << " Eycorr=" << m_Eycorr
        << " txcorr=" << m_txcorr
        << " tycorr=" << m_tycorr
             << std::endl;
   return ostr.str();
}

std::string FcalCorrelations::toXML(int indent) {
   std::stringstream ostr;
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "<fcalCorrelations"
        << " Etcorr=" << "\"" << getEtcorr() << "\""
        << " Excorr=" << "\"" << getExcorr() << "\""
        << " Eycorr=" << "\"" << getEycorr() << "\""
        << " txcorr=" << "\"" << getTxcorr() << "\""
        << " tycorr=" << "\"" << getTycorr() << "\""
        << " />" << std::endl;
   return ostr.str();
}

#ifdef HDF5_SUPPORT
hid_t FcalCorrelations::hdf5Datatype(int inmemory, int verbose)
{
   std::string tname("fcalCorrelations");
   if (inmemory) {
      if (HDDM::s_hdf5_memorytype.find(tname) != HDDM::s_hdf5_memorytype.end())
         return HDDM::s_hdf5_memorytype[tname];
   }
   else {
      if (HDDM::s_hdf5_datatype.find(tname) != HDDM::s_hdf5_datatype.end())
         return HDDM::s_hdf5_datatype[tname];
   }
   hid_t tid = H5Tcreate(H5T_COMPOUND, sizeof(*this));
   hid_t vl_string_tid = H5Tcopy(H5T_C_S1);
   H5Tset_size(vl_string_tid, H5T_VARIABLE);
   H5Tinsert(tid, "Etcorr", (char*)&m_Etcorr - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   H5Tinsert(tid, "Excorr", (char*)&m_Excorr - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   H5Tinsert(tid, "Eycorr", (char*)&m_Eycorr - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   H5Tinsert(tid, "txcorr", (char*)&m_txcorr - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   H5Tinsert(tid, "tycorr", (char*)&m_tycorr - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   if (inmemory) {
      HDDM::s_hdf5_memorytype["fcalCorrelations"] = tid;
   }
   else {
      HDDM::s_hdf5_datatype["fcalCorrelations"] = tid;
   }
   if (verbose) {
      size_t slen;
      H5LTdtype_to_text(tid, 0, H5LT_DDL, &slen);
      char *ddlstring = (char*)malloc(slen);
      H5LTdtype_to_text(tid, ddlstring, H5LT_DDL, &slen);
      if (inmemory)
         printf("=== in-memory datatype %ld for %s is:\n %s\n", (long int)tid, "fcalCorrelations", ddlstring);
      else
         printf("=== on-disk datatype %ld for %s is:\n %s\n", (long int)tid, "fcalCorrelations", ddlstring);
      free(ddlstring);
   }
   return tid;
}
void FcalCorrelations::hdf5DataPack()
{
}
void FcalCorrelations::hdf5DataUnpack()
{
}
#endif

std::string FcalShowerClassification::toString(int indent) {
   std::stringstream ostr;
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "fcalShowerClassification"
        << " classifierOuput=" << m_classifierOuput
             << std::endl;
   return ostr.str();
}

std::string FcalShowerClassification::toXML(int indent) {
   std::stringstream ostr;
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "<fcalShowerClassification"
        << " classifierOuput=" << "\"" << getClassifierOuput() << "\""
        << " />" << std::endl;
   return ostr.str();
}

#ifdef HDF5_SUPPORT
hid_t FcalShowerClassification::hdf5Datatype(int inmemory, int verbose)
{
   std::string tname("fcalShowerClassification");
   if (inmemory) {
      if (HDDM::s_hdf5_memorytype.find(tname) != HDDM::s_hdf5_memorytype.end())
         return HDDM::s_hdf5_memorytype[tname];
   }
   else {
      if (HDDM::s_hdf5_datatype.find(tname) != HDDM::s_hdf5_datatype.end())
         return HDDM::s_hdf5_datatype[tname];
   }
   hid_t tid = H5Tcreate(H5T_COMPOUND, sizeof(*this));
   hid_t vl_string_tid = H5Tcopy(H5T_C_S1);
   H5Tset_size(vl_string_tid, H5T_VARIABLE);
   H5Tinsert(tid, "classifierOuput", (char*)&m_classifierOuput - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   if (inmemory) {
      HDDM::s_hdf5_memorytype["fcalShowerClassification"] = tid;
   }
   else {
      HDDM::s_hdf5_datatype["fcalShowerClassification"] = tid;
   }
   if (verbose) {
      size_t slen;
      H5LTdtype_to_text(tid, 0, H5LT_DDL, &slen);
      char *ddlstring = (char*)malloc(slen);
      H5LTdtype_to_text(tid, ddlstring, H5LT_DDL, &slen);
      if (inmemory)
         printf("=== in-memory datatype %ld for %s is:\n %s\n", (long int)tid, "fcalShowerClassification", ddlstring);
      else
         printf("=== on-disk datatype %ld for %s is:\n %s\n", (long int)tid, "fcalShowerClassification", ddlstring);
      free(ddlstring);
   }
   return tid;
}
void FcalShowerClassification::hdf5DataPack()
{
}
void FcalShowerClassification::hdf5DataUnpack()
{
}
#endif

std::string FcalShowerProperties::toString(int indent) {
   std::stringstream ostr;
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "fcalShowerProperties"
        << " E1E9=" << m_E1E9
        << " E9E25=" << m_E9E25
        << " docaTrack=" << m_docaTrack
        << " sumU=" << m_sumU
        << " sumV=" << m_sumV
        << " timeTrack=" << m_timeTrack
             << std::endl;
   return ostr.str();
}

std::string FcalShowerProperties::toXML(int indent) {
   std::stringstream ostr;
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "<fcalShowerProperties"
        << " E1E9=" << "\"" << getE1E9() << "\""
        << " E9E25=" << "\"" << getE9E25() << "\""
        << " docaTrack=" << "\"" << getDocaTrack() << "\""
        << " sumU=" << "\"" << getSumU() << "\""
        << " sumV=" << "\"" << getSumV() << "\""
        << " timeTrack=" << "\"" << getTimeTrack() << "\""
        << " />" << std::endl;
   return ostr.str();
}

#ifdef HDF5_SUPPORT
hid_t FcalShowerProperties::hdf5Datatype(int inmemory, int verbose)
{
   std::string tname("fcalShowerProperties");
   if (inmemory) {
      if (HDDM::s_hdf5_memorytype.find(tname) != HDDM::s_hdf5_memorytype.end())
         return HDDM::s_hdf5_memorytype[tname];
   }
   else {
      if (HDDM::s_hdf5_datatype.find(tname) != HDDM::s_hdf5_datatype.end())
         return HDDM::s_hdf5_datatype[tname];
   }
   hid_t tid = H5Tcreate(H5T_COMPOUND, sizeof(*this));
   hid_t vl_string_tid = H5Tcopy(H5T_C_S1);
   H5Tset_size(vl_string_tid, H5T_VARIABLE);
   H5Tinsert(tid, "E1E9", (char*)&m_E1E9 - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   H5Tinsert(tid, "E9E25", (char*)&m_E9E25 - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   H5Tinsert(tid, "docaTrack", (char*)&m_docaTrack - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   H5Tinsert(tid, "sumU", (char*)&m_sumU - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   H5Tinsert(tid, "sumV", (char*)&m_sumV - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   H5Tinsert(tid, "timeTrack", (char*)&m_timeTrack - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   if (inmemory) {
      HDDM::s_hdf5_memorytype["fcalShowerProperties"] = tid;
   }
   else {
      HDDM::s_hdf5_datatype["fcalShowerProperties"] = tid;
   }
   if (verbose) {
      size_t slen;
      H5LTdtype_to_text(tid, 0, H5LT_DDL, &slen);
      char *ddlstring = (char*)malloc(slen);
      H5LTdtype_to_text(tid, ddlstring, H5LT_DDL, &slen);
      if (inmemory)
         printf("=== in-memory datatype %ld for %s is:\n %s\n", (long int)tid, "fcalShowerProperties", ddlstring);
      else
         printf("=== on-disk datatype %ld for %s is:\n %s\n", (long int)tid, "fcalShowerProperties", ddlstring);
      free(ddlstring);
   }
   return tid;
}
void FcalShowerProperties::hdf5DataPack()
{
}
void FcalShowerProperties::hdf5DataUnpack()
{
}
#endif

std::string FcalShowerNBlocks::toString(int indent) {
   std::stringstream ostr;
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "fcalShowerNBlocks"
        << " numBlocks=" << m_numBlocks
             << std::endl;
   return ostr.str();
}

std::string FcalShowerNBlocks::toXML(int indent) {
   std::stringstream ostr;
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "<fcalShowerNBlocks"
        << " numBlocks=" << "\"" << getNumBlocks() << "\""
        << " />" << std::endl;
   return ostr.str();
}

#ifdef HDF5_SUPPORT
hid_t FcalShowerNBlocks::hdf5Datatype(int inmemory, int verbose)
{
   std::string tname("fcalShowerNBlocks");
   if (inmemory) {
      if (HDDM::s_hdf5_memorytype.find(tname) != HDDM::s_hdf5_memorytype.end())
         return HDDM::s_hdf5_memorytype[tname];
   }
   else {
      if (HDDM::s_hdf5_datatype.find(tname) != HDDM::s_hdf5_datatype.end())
         return HDDM::s_hdf5_datatype[tname];
   }
   hid_t tid = H5Tcreate(H5T_COMPOUND, sizeof(*this));
   hid_t vl_string_tid = H5Tcopy(H5T_C_S1);
   H5Tset_size(vl_string_tid, H5T_VARIABLE);
   H5Tinsert(tid, "numBlocks", (char*)&m_numBlocks - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I32LE));
   if (inmemory) {
      HDDM::s_hdf5_memorytype["fcalShowerNBlocks"] = tid;
   }
   else {
      HDDM::s_hdf5_datatype["fcalShowerNBlocks"] = tid;
   }
   if (verbose) {
      size_t slen;
      H5LTdtype_to_text(tid, 0, H5LT_DDL, &slen);
      char *ddlstring = (char*)malloc(slen);
      H5LTdtype_to_text(tid, ddlstring, H5LT_DDL, &slen);
      if (inmemory)
         printf("=== in-memory datatype %ld for %s is:\n %s\n", (long int)tid, "fcalShowerNBlocks", ddlstring);
      else
         printf("=== on-disk datatype %ld for %s is:\n %s\n", (long int)tid, "fcalShowerNBlocks", ddlstring);
      free(ddlstring);
   }
   return tid;
}
void FcalShowerNBlocks::hdf5DataPack()
{
}
void FcalShowerNBlocks::hdf5DataUnpack()
{
}
#endif

std::string FcalShower::toString(int indent) {
   std::stringstream ostr;
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "fcalShower"
        << " E=" << m_E
        << " Eerr=" << m_Eerr
        << " Ezcorr=" << m_Ezcorr
        << " jtag=" << "\"" << m_jtag << "\""
        << " t=" << m_t
        << " terr=" << m_terr
        << " tzcorr=" << m_tzcorr
        << " x=" << m_x
        << " xerr=" << m_xerr
        << " xycorr=" << m_xycorr
        << " xzcorr=" << m_xzcorr
        << " y=" << m_y
        << " yerr=" << m_yerr
        << " yzcorr=" << m_yzcorr
        << " z=" << m_z
        << " zerr=" << m_zerr
             << std::endl;
   if (! m_fcalCorrelations_link.empty()) {
      ostr << m_fcalCorrelations_link.begin()->toString(indent + 2);
   }
   if (! m_fcalShowerClassification_link.empty()) {
      ostr << m_fcalShowerClassification_link.begin()->toString(indent + 2);
   }
   if (! m_fcalShowerProperties_link.empty()) {
      ostr << m_fcalShowerProperties_link.begin()->toString(indent + 2);
   }
   if (! m_fcalShowerNBlocks_link.empty()) {
      ostr << m_fcalShowerNBlocks_link.begin()->toString(indent + 2);
   }
   return ostr.str();
}

std::string FcalShower::toXML(int indent) {
   std::stringstream ostr;
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "<fcalShower"
        << " E=" << "\"" << getE() << "\""
        << " Eerr=" << "\"" << getEerr() << "\""
        << " Eunit=" << "\"" << getEunit() << "\""
        << " Ezcorr=" << "\"" << getEzcorr() << "\""
        << " jtag=" << "\"" << getJtag() << "\""
        << " lunit=" << "\"" << getLunit() << "\""
        << " t=" << "\"" << getT() << "\""
        << " terr=" << "\"" << getTerr() << "\""
        << " tunit=" << "\"" << getTunit() << "\""
        << " tzcorr=" << "\"" << getTzcorr() << "\""
        << " x=" << "\"" << getX() << "\""
        << " xerr=" << "\"" << getXerr() << "\""
        << " xycorr=" << "\"" << getXycorr() << "\""
        << " xzcorr=" << "\"" << getXzcorr() << "\""
        << " y=" << "\"" << getY() << "\""
        << " yerr=" << "\"" << getYerr() << "\""
        << " yzcorr=" << "\"" << getYzcorr() << "\""
        << " z=" << "\"" << getZ() << "\""
        << " zerr=" << "\"" << getZerr() << "\""
        << ">" << std::endl;
   if (! m_fcalCorrelations_link.empty()) {
      ostr << m_fcalCorrelations_link.begin()->toXML(indent + 2);
   }
   if (! m_fcalShowerClassification_link.empty()) {
      ostr << m_fcalShowerClassification_link.begin()->toXML(indent + 2);
   }
   if (! m_fcalShowerProperties_link.empty()) {
      ostr << m_fcalShowerProperties_link.begin()->toXML(indent + 2);
   }
   if (! m_fcalShowerNBlocks_link.empty()) {
      ostr << m_fcalShowerNBlocks_link.begin()->toXML(indent + 2);
   }
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "</fcalShower>"
        << std::endl;
   return ostr.str();
}

#ifdef HDF5_SUPPORT
hid_t FcalShower::hdf5Datatype(int inmemory, int verbose)
{
   std::string tname("fcalShower");
   if (inmemory) {
      if (HDDM::s_hdf5_memorytype.find(tname) != HDDM::s_hdf5_memorytype.end())
         return HDDM::s_hdf5_memorytype[tname];
   }
   else {
      if (HDDM::s_hdf5_datatype.find(tname) != HDDM::s_hdf5_datatype.end())
         return HDDM::s_hdf5_datatype[tname];
   }
   hid_t tid = H5Tcreate(H5T_COMPOUND, sizeof(*this));
   hid_t vl_string_tid = H5Tcopy(H5T_C_S1);
   H5Tset_size(vl_string_tid, H5T_VARIABLE);
   H5Tinsert(tid, "E", (char*)&m_E - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   H5Tinsert(tid, "Eerr", (char*)&m_Eerr - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   H5Tinsert(tid, "Ezcorr", (char*)&m_Ezcorr - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   H5Tinsert(tid, "jtag", (char*)&mx_jtag - (char*)this, vl_string_tid);
   H5Tinsert(tid, "t", (char*)&m_t - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   H5Tinsert(tid, "terr", (char*)&m_terr - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   H5Tinsert(tid, "tzcorr", (char*)&m_tzcorr - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   H5Tinsert(tid, "x", (char*)&m_x - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   H5Tinsert(tid, "xerr", (char*)&m_xerr - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   H5Tinsert(tid, "xycorr", (char*)&m_xycorr - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   H5Tinsert(tid, "xzcorr", (char*)&m_xzcorr - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   H5Tinsert(tid, "y", (char*)&m_y - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   H5Tinsert(tid, "yerr", (char*)&m_yerr - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   H5Tinsert(tid, "yzcorr", (char*)&m_yzcorr - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   H5Tinsert(tid, "z", (char*)&m_z - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   H5Tinsert(tid, "zerr", (char*)&m_zerr - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   H5Tinsert(tid, "FcalCorrelationsList_size", (char*)&m_fcalCorrelations_link.m_size - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   H5Tinsert(tid, "FcalCorrelationsList_offset", (char*)&m_fcalCorrelations_link.m_ref - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   H5Tinsert(tid, "FcalShowerClassificationList_size", (char*)&m_fcalShowerClassification_link.m_size - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   H5Tinsert(tid, "FcalShowerClassificationList_offset", (char*)&m_fcalShowerClassification_link.m_ref - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   H5Tinsert(tid, "FcalShowerPropertiesList_size", (char*)&m_fcalShowerProperties_link.m_size - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   H5Tinsert(tid, "FcalShowerPropertiesList_offset", (char*)&m_fcalShowerProperties_link.m_ref - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   H5Tinsert(tid, "FcalShowerNBlocksList_size", (char*)&m_fcalShowerNBlocks_link.m_size - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   H5Tinsert(tid, "FcalShowerNBlocksList_offset", (char*)&m_fcalShowerNBlocks_link.m_ref - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   if (inmemory) {
      HDDM::s_hdf5_memorytype["fcalShower"] = tid;
   }
   else {
      HDDM::s_hdf5_datatype["fcalShower"] = tid;
   }
   if (verbose) {
      size_t slen;
      H5LTdtype_to_text(tid, 0, H5LT_DDL, &slen);
      char *ddlstring = (char*)malloc(slen);
      H5LTdtype_to_text(tid, ddlstring, H5LT_DDL, &slen);
      if (inmemory)
         printf("=== in-memory datatype %ld for %s is:\n %s\n", (long int)tid, "fcalShower", ddlstring);
      else
         printf("=== on-disk datatype %ld for %s is:\n %s\n", (long int)tid, "fcalShower", ddlstring);
      free(ddlstring);
   }
   return tid;
}
void FcalShower::hdf5DataPack()
{
   mx_jtag = m_jtag.c_str();
   m_fcalCorrelations_link.deflate();
   m_fcalShowerClassification_link.deflate();
   m_fcalShowerProperties_link.deflate();
   m_fcalShowerNBlocks_link.deflate();
}
void FcalShower::hdf5DataUnpack()
{
   new(&m_jtag) std::string();
   if (mx_jtag != 0) {
      m_jtag = mx_jtag;
      m_host->m_hdf5_strings.push_back(&m_jtag);
   }
   {
      std::list<FcalCorrelations*> *host_plist = &m_host->m_fcalCorrelations_plist;
      m_fcalCorrelations_link.inflate(m_host, host_plist, this);
      FcalCorrelationsList::iterator iter;
      for (iter = m_fcalCorrelations_link.begin();
           iter != m_fcalCorrelations_link.end(); ++iter)
      {
         iter->hdf5DataUnpack();
      }
   }
   {
      std::list<FcalShowerClassification*> *host_plist = &m_host->m_fcalShowerClassification_plist;
      m_fcalShowerClassification_link.inflate(m_host, host_plist, this);
      FcalShowerClassificationList::iterator iter;
      for (iter = m_fcalShowerClassification_link.begin();
           iter != m_fcalShowerClassification_link.end(); ++iter)
      {
         iter->hdf5DataUnpack();
      }
   }
   {
      std::list<FcalShowerProperties*> *host_plist = &m_host->m_fcalShowerProperties_plist;
      m_fcalShowerProperties_link.inflate(m_host, host_plist, this);
      FcalShowerPropertiesList::iterator iter;
      for (iter = m_fcalShowerProperties_link.begin();
           iter != m_fcalShowerProperties_link.end(); ++iter)
      {
         iter->hdf5DataUnpack();
      }
   }
   {
      std::list<FcalShowerNBlocks*> *host_plist = &m_host->m_fcalShowerNBlocks_plist;
      m_fcalShowerNBlocks_link.inflate(m_host, host_plist, this);
      FcalShowerNBlocksList::iterator iter;
      for (iter = m_fcalShowerNBlocks_link.begin();
           iter != m_fcalShowerNBlocks_link.end(); ++iter)
      {
         iter->hdf5DataUnpack();
      }
   }
}
#endif

std::string FcalHit::toString(int indent) {
   std::stringstream ostr;
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "fcalHit"
        << " E=" << m_E
        << " column=" << m_column
        << " intOverPeak=" << m_intOverPeak
        << " jtag=" << "\"" << m_jtag << "\""
        << " row=" << m_row
        << " t=" << m_t
        << " x=" << m_x
        << " y=" << m_y
             << std::endl;
   return ostr.str();
}

std::string FcalHit::toXML(int indent) {
   std::stringstream ostr;
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "<fcalHit"
        << " E=" << "\"" << getE() << "\""
        << " Eunit=" << "\"" << getEunit() << "\""
        << " column=" << "\"" << getColumn() << "\""
        << " intOverPeak=" << "\"" << getIntOverPeak() << "\""
        << " jtag=" << "\"" << getJtag() << "\""
        << " row=" << "\"" << getRow() << "\""
        << " t=" << "\"" << getT() << "\""
        << " tunit=" << "\"" << getTunit() << "\""
        << " x=" << "\"" << getX() << "\""
        << " y=" << "\"" << getY() << "\""
        << " />" << std::endl;
   return ostr.str();
}

#ifdef HDF5_SUPPORT
hid_t FcalHit::hdf5Datatype(int inmemory, int verbose)
{
   std::string tname("fcalHit");
   if (inmemory) {
      if (HDDM::s_hdf5_memorytype.find(tname) != HDDM::s_hdf5_memorytype.end())
         return HDDM::s_hdf5_memorytype[tname];
   }
   else {
      if (HDDM::s_hdf5_datatype.find(tname) != HDDM::s_hdf5_datatype.end())
         return HDDM::s_hdf5_datatype[tname];
   }
   hid_t tid = H5Tcreate(H5T_COMPOUND, sizeof(*this));
   hid_t vl_string_tid = H5Tcopy(H5T_C_S1);
   H5Tset_size(vl_string_tid, H5T_VARIABLE);
   H5Tinsert(tid, "E", (char*)&m_E - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   H5Tinsert(tid, "column", (char*)&m_column - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I32LE));
   H5Tinsert(tid, "intOverPeak", (char*)&m_intOverPeak - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   H5Tinsert(tid, "jtag", (char*)&mx_jtag - (char*)this, vl_string_tid);
   H5Tinsert(tid, "row", (char*)&m_row - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I32LE));
   H5Tinsert(tid, "t", (char*)&m_t - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   H5Tinsert(tid, "x", (char*)&m_x - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   H5Tinsert(tid, "y", (char*)&m_y - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   if (inmemory) {
      HDDM::s_hdf5_memorytype["fcalHit"] = tid;
   }
   else {
      HDDM::s_hdf5_datatype["fcalHit"] = tid;
   }
   if (verbose) {
      size_t slen;
      H5LTdtype_to_text(tid, 0, H5LT_DDL, &slen);
      char *ddlstring = (char*)malloc(slen);
      H5LTdtype_to_text(tid, ddlstring, H5LT_DDL, &slen);
      if (inmemory)
         printf("=== in-memory datatype %ld for %s is:\n %s\n", (long int)tid, "fcalHit", ddlstring);
      else
         printf("=== on-disk datatype %ld for %s is:\n %s\n", (long int)tid, "fcalHit", ddlstring);
      free(ddlstring);
   }
   return tid;
}
void FcalHit::hdf5DataPack()
{
   mx_jtag = m_jtag.c_str();
}
void FcalHit::hdf5DataUnpack()
{
   new(&m_jtag) std::string();
   if (mx_jtag != 0) {
      m_jtag = mx_jtag;
      m_host->m_hdf5_strings.push_back(&m_jtag);
   }
}
#endif

std::string Preshower::toString(int indent) {
   std::stringstream ostr;
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "preshower"
        << " preshowerE=" << m_preshowerE
             << std::endl;
   return ostr.str();
}

std::string Preshower::toXML(int indent) {
   std::stringstream ostr;
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "<preshower"
        << " preshowerE=" << "\"" << getPreshowerE() << "\""
        << " />" << std::endl;
   return ostr.str();
}

#ifdef HDF5_SUPPORT
hid_t Preshower::hdf5Datatype(int inmemory, int verbose)
{
   std::string tname("preshower");
   if (inmemory) {
      if (HDDM::s_hdf5_memorytype.find(tname) != HDDM::s_hdf5_memorytype.end())
         return HDDM::s_hdf5_memorytype[tname];
   }
   else {
      if (HDDM::s_hdf5_datatype.find(tname) != HDDM::s_hdf5_datatype.end())
         return HDDM::s_hdf5_datatype[tname];
   }
   hid_t tid = H5Tcreate(H5T_COMPOUND, sizeof(*this));
   hid_t vl_string_tid = H5Tcopy(H5T_C_S1);
   H5Tset_size(vl_string_tid, H5T_VARIABLE);
   H5Tinsert(tid, "preshowerE", (char*)&m_preshowerE - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   if (inmemory) {
      HDDM::s_hdf5_memorytype["preshower"] = tid;
   }
   else {
      HDDM::s_hdf5_datatype["preshower"] = tid;
   }
   if (verbose) {
      size_t slen;
      H5LTdtype_to_text(tid, 0, H5LT_DDL, &slen);
      char *ddlstring = (char*)malloc(slen);
      H5LTdtype_to_text(tid, ddlstring, H5LT_DDL, &slen);
      if (inmemory)
         printf("=== in-memory datatype %ld for %s is:\n %s\n", (long int)tid, "preshower", ddlstring);
      else
         printf("=== on-disk datatype %ld for %s is:\n %s\n", (long int)tid, "preshower", ddlstring);
      free(ddlstring);
   }
   return tid;
}
void Preshower::hdf5DataPack()
{
}
void Preshower::hdf5DataUnpack()
{
}
#endif

std::string Width::toString(int indent) {
   std::stringstream ostr;
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "width"
        << " sigLong=" << m_sigLong
        << " sigTheta=" << m_sigTheta
        << " sigTrans=" << m_sigTrans
             << std::endl;
   return ostr.str();
}

std::string Width::toXML(int indent) {
   std::stringstream ostr;
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "<width"
        << " sigLong=" << "\"" << getSigLong() << "\""
        << " sigTheta=" << "\"" << getSigTheta() << "\""
        << " sigTrans=" << "\"" << getSigTrans() << "\""
        << " />" << std::endl;
   return ostr.str();
}

#ifdef HDF5_SUPPORT
hid_t Width::hdf5Datatype(int inmemory, int verbose)
{
   std::string tname("width");
   if (inmemory) {
      if (HDDM::s_hdf5_memorytype.find(tname) != HDDM::s_hdf5_memorytype.end())
         return HDDM::s_hdf5_memorytype[tname];
   }
   else {
      if (HDDM::s_hdf5_datatype.find(tname) != HDDM::s_hdf5_datatype.end())
         return HDDM::s_hdf5_datatype[tname];
   }
   hid_t tid = H5Tcreate(H5T_COMPOUND, sizeof(*this));
   hid_t vl_string_tid = H5Tcopy(H5T_C_S1);
   H5Tset_size(vl_string_tid, H5T_VARIABLE);
   H5Tinsert(tid, "sigLong", (char*)&m_sigLong - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   H5Tinsert(tid, "sigTheta", (char*)&m_sigTheta - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   H5Tinsert(tid, "sigTrans", (char*)&m_sigTrans - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   if (inmemory) {
      HDDM::s_hdf5_memorytype["width"] = tid;
   }
   else {
      HDDM::s_hdf5_datatype["width"] = tid;
   }
   if (verbose) {
      size_t slen;
      H5LTdtype_to_text(tid, 0, H5LT_DDL, &slen);
      char *ddlstring = (char*)malloc(slen);
      H5LTdtype_to_text(tid, ddlstring, H5LT_DDL, &slen);
      if (inmemory)
         printf("=== in-memory datatype %ld for %s is:\n %s\n", (long int)tid, "width", ddlstring);
      else
         printf("=== on-disk datatype %ld for %s is:\n %s\n", (long int)tid, "width", ddlstring);
      free(ddlstring);
   }
   return tid;
}
void Width::hdf5DataPack()
{
}
void Width::hdf5DataUnpack()
{
}
#endif

std::string BcalCluster::toString(int indent) {
   std::stringstream ostr;
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "bcalCluster"
        << " ncell=" << m_ncell
             << std::endl;
   return ostr.str();
}

std::string BcalCluster::toXML(int indent) {
   std::stringstream ostr;
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "<bcalCluster"
        << " ncell=" << "\"" << getNcell() << "\""
        << " />" << std::endl;
   return ostr.str();
}

#ifdef HDF5_SUPPORT
hid_t BcalCluster::hdf5Datatype(int inmemory, int verbose)
{
   std::string tname("bcalCluster");
   if (inmemory) {
      if (HDDM::s_hdf5_memorytype.find(tname) != HDDM::s_hdf5_memorytype.end())
         return HDDM::s_hdf5_memorytype[tname];
   }
   else {
      if (HDDM::s_hdf5_datatype.find(tname) != HDDM::s_hdf5_datatype.end())
         return HDDM::s_hdf5_datatype[tname];
   }
   hid_t tid = H5Tcreate(H5T_COMPOUND, sizeof(*this));
   hid_t vl_string_tid = H5Tcopy(H5T_C_S1);
   H5Tset_size(vl_string_tid, H5T_VARIABLE);
   H5Tinsert(tid, "ncell", (char*)&m_ncell - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I32LE));
   if (inmemory) {
      HDDM::s_hdf5_memorytype["bcalCluster"] = tid;
   }
   else {
      HDDM::s_hdf5_datatype["bcalCluster"] = tid;
   }
   if (verbose) {
      size_t slen;
      H5LTdtype_to_text(tid, 0, H5LT_DDL, &slen);
      char *ddlstring = (char*)malloc(slen);
      H5LTdtype_to_text(tid, ddlstring, H5LT_DDL, &slen);
      if (inmemory)
         printf("=== in-memory datatype %ld for %s is:\n %s\n", (long int)tid, "bcalCluster", ddlstring);
      else
         printf("=== on-disk datatype %ld for %s is:\n %s\n", (long int)tid, "bcalCluster", ddlstring);
      free(ddlstring);
   }
   return tid;
}
void BcalCluster::hdf5DataPack()
{
}
void BcalCluster::hdf5DataUnpack()
{
}
#endif

std::string BcalCorrelations::toString(int indent) {
   std::stringstream ostr;
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "bcalCorrelations"
        << " Etcorr=" << m_Etcorr
        << " Excorr=" << m_Excorr
        << " Eycorr=" << m_Eycorr
        << " txcorr=" << m_txcorr
        << " tycorr=" << m_tycorr
             << std::endl;
   return ostr.str();
}

std::string BcalCorrelations::toXML(int indent) {
   std::stringstream ostr;
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "<bcalCorrelations"
        << " Etcorr=" << "\"" << getEtcorr() << "\""
        << " Excorr=" << "\"" << getExcorr() << "\""
        << " Eycorr=" << "\"" << getEycorr() << "\""
        << " txcorr=" << "\"" << getTxcorr() << "\""
        << " tycorr=" << "\"" << getTycorr() << "\""
        << " />" << std::endl;
   return ostr.str();
}

#ifdef HDF5_SUPPORT
hid_t BcalCorrelations::hdf5Datatype(int inmemory, int verbose)
{
   std::string tname("bcalCorrelations");
   if (inmemory) {
      if (HDDM::s_hdf5_memorytype.find(tname) != HDDM::s_hdf5_memorytype.end())
         return HDDM::s_hdf5_memorytype[tname];
   }
   else {
      if (HDDM::s_hdf5_datatype.find(tname) != HDDM::s_hdf5_datatype.end())
         return HDDM::s_hdf5_datatype[tname];
   }
   hid_t tid = H5Tcreate(H5T_COMPOUND, sizeof(*this));
   hid_t vl_string_tid = H5Tcopy(H5T_C_S1);
   H5Tset_size(vl_string_tid, H5T_VARIABLE);
   H5Tinsert(tid, "Etcorr", (char*)&m_Etcorr - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   H5Tinsert(tid, "Excorr", (char*)&m_Excorr - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   H5Tinsert(tid, "Eycorr", (char*)&m_Eycorr - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   H5Tinsert(tid, "txcorr", (char*)&m_txcorr - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   H5Tinsert(tid, "tycorr", (char*)&m_tycorr - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   if (inmemory) {
      HDDM::s_hdf5_memorytype["bcalCorrelations"] = tid;
   }
   else {
      HDDM::s_hdf5_datatype["bcalCorrelations"] = tid;
   }
   if (verbose) {
      size_t slen;
      H5LTdtype_to_text(tid, 0, H5LT_DDL, &slen);
      char *ddlstring = (char*)malloc(slen);
      H5LTdtype_to_text(tid, ddlstring, H5LT_DDL, &slen);
      if (inmemory)
         printf("=== in-memory datatype %ld for %s is:\n %s\n", (long int)tid, "bcalCorrelations", ddlstring);
      else
         printf("=== on-disk datatype %ld for %s is:\n %s\n", (long int)tid, "bcalCorrelations", ddlstring);
      free(ddlstring);
   }
   return tid;
}
void BcalCorrelations::hdf5DataPack()
{
}
void BcalCorrelations::hdf5DataUnpack()
{
}
#endif

std::string BcalLayers::toString(int indent) {
   std::stringstream ostr;
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "bcalLayers"
        << " E_L2=" << m_E_L2
        << " E_L3=" << m_E_L3
        << " E_L4=" << m_E_L4
        << " rmsTime=" << m_rmsTime
             << std::endl;
   return ostr.str();
}

std::string BcalLayers::toXML(int indent) {
   std::stringstream ostr;
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "<bcalLayers"
        << " E_L2=" << "\"" << getE_L2() << "\""
        << " E_L3=" << "\"" << getE_L3() << "\""
        << " E_L4=" << "\"" << getE_L4() << "\""
        << " rmsTime=" << "\"" << getRmsTime() << "\""
        << " />" << std::endl;
   return ostr.str();
}

#ifdef HDF5_SUPPORT
hid_t BcalLayers::hdf5Datatype(int inmemory, int verbose)
{
   std::string tname("bcalLayers");
   if (inmemory) {
      if (HDDM::s_hdf5_memorytype.find(tname) != HDDM::s_hdf5_memorytype.end())
         return HDDM::s_hdf5_memorytype[tname];
   }
   else {
      if (HDDM::s_hdf5_datatype.find(tname) != HDDM::s_hdf5_datatype.end())
         return HDDM::s_hdf5_datatype[tname];
   }
   hid_t tid = H5Tcreate(H5T_COMPOUND, sizeof(*this));
   hid_t vl_string_tid = H5Tcopy(H5T_C_S1);
   H5Tset_size(vl_string_tid, H5T_VARIABLE);
   H5Tinsert(tid, "E_L2", (char*)&m_E_L2 - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   H5Tinsert(tid, "E_L3", (char*)&m_E_L3 - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   H5Tinsert(tid, "E_L4", (char*)&m_E_L4 - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   H5Tinsert(tid, "rmsTime", (char*)&m_rmsTime - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   if (inmemory) {
      HDDM::s_hdf5_memorytype["bcalLayers"] = tid;
   }
   else {
      HDDM::s_hdf5_datatype["bcalLayers"] = tid;
   }
   if (verbose) {
      size_t slen;
      H5LTdtype_to_text(tid, 0, H5LT_DDL, &slen);
      char *ddlstring = (char*)malloc(slen);
      H5LTdtype_to_text(tid, ddlstring, H5LT_DDL, &slen);
      if (inmemory)
         printf("=== in-memory datatype %ld for %s is:\n %s\n", (long int)tid, "bcalLayers", ddlstring);
      else
         printf("=== on-disk datatype %ld for %s is:\n %s\n", (long int)tid, "bcalLayers", ddlstring);
      free(ddlstring);
   }
   return tid;
}
void BcalLayers::hdf5DataPack()
{
}
void BcalLayers::hdf5DataUnpack()
{
}
#endif

std::string BcalShower::toString(int indent) {
   std::stringstream ostr;
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "bcalShower"
        << " E=" << m_E
        << " Eerr=" << m_Eerr
        << " Ezcorr=" << m_Ezcorr
        << " jtag=" << "\"" << m_jtag << "\""
        << " t=" << m_t
        << " terr=" << m_terr
        << " tzcorr=" << m_tzcorr
        << " x=" << m_x
        << " xerr=" << m_xerr
        << " xycorr=" << m_xycorr
        << " xzcorr=" << m_xzcorr
        << " y=" << m_y
        << " yerr=" << m_yerr
        << " yzcorr=" << m_yzcorr
        << " z=" << m_z
        << " zerr=" << m_zerr
             << std::endl;
   if (! m_preshower_link.empty()) {
      ostr << m_preshower_link.begin()->toString(indent + 2);
   }
   if (! m_width_link.empty()) {
      ostr << m_width_link.begin()->toString(indent + 2);
   }
   if (! m_bcalCluster_link.empty()) {
      ostr << m_bcalCluster_link.begin()->toString(indent + 2);
   }
   if (! m_bcalCorrelations_link.empty()) {
      ostr << m_bcalCorrelations_link.begin()->toString(indent + 2);
   }
   if (! m_bcalLayers_link.empty()) {
      ostr << m_bcalLayers_link.begin()->toString(indent + 2);
   }
   return ostr.str();
}

std::string BcalShower::toXML(int indent) {
   std::stringstream ostr;
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "<bcalShower"
        << " E=" << "\"" << getE() << "\""
        << " Eerr=" << "\"" << getEerr() << "\""
        << " Eunit=" << "\"" << getEunit() << "\""
        << " Ezcorr=" << "\"" << getEzcorr() << "\""
        << " jtag=" << "\"" << getJtag() << "\""
        << " lunit=" << "\"" << getLunit() << "\""
        << " t=" << "\"" << getT() << "\""
        << " terr=" << "\"" << getTerr() << "\""
        << " tunit=" << "\"" << getTunit() << "\""
        << " tzcorr=" << "\"" << getTzcorr() << "\""
        << " x=" << "\"" << getX() << "\""
        << " xerr=" << "\"" << getXerr() << "\""
        << " xycorr=" << "\"" << getXycorr() << "\""
        << " xzcorr=" << "\"" << getXzcorr() << "\""
        << " y=" << "\"" << getY() << "\""
        << " yerr=" << "\"" << getYerr() << "\""
        << " yzcorr=" << "\"" << getYzcorr() << "\""
        << " z=" << "\"" << getZ() << "\""
        << " zerr=" << "\"" << getZerr() << "\""
        << ">" << std::endl;
   if (! m_preshower_link.empty()) {
      ostr << m_preshower_link.begin()->toXML(indent + 2);
   }
   if (! m_width_link.empty()) {
      ostr << m_width_link.begin()->toXML(indent + 2);
   }
   if (! m_bcalCluster_link.empty()) {
      ostr << m_bcalCluster_link.begin()->toXML(indent + 2);
   }
   if (! m_bcalCorrelations_link.empty()) {
      ostr << m_bcalCorrelations_link.begin()->toXML(indent + 2);
   }
   if (! m_bcalLayers_link.empty()) {
      ostr << m_bcalLayers_link.begin()->toXML(indent + 2);
   }
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "</bcalShower>"
        << std::endl;
   return ostr.str();
}

#ifdef HDF5_SUPPORT
hid_t BcalShower::hdf5Datatype(int inmemory, int verbose)
{
   std::string tname("bcalShower");
   if (inmemory) {
      if (HDDM::s_hdf5_memorytype.find(tname) != HDDM::s_hdf5_memorytype.end())
         return HDDM::s_hdf5_memorytype[tname];
   }
   else {
      if (HDDM::s_hdf5_datatype.find(tname) != HDDM::s_hdf5_datatype.end())
         return HDDM::s_hdf5_datatype[tname];
   }
   hid_t tid = H5Tcreate(H5T_COMPOUND, sizeof(*this));
   hid_t vl_string_tid = H5Tcopy(H5T_C_S1);
   H5Tset_size(vl_string_tid, H5T_VARIABLE);
   H5Tinsert(tid, "E", (char*)&m_E - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   H5Tinsert(tid, "Eerr", (char*)&m_Eerr - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   H5Tinsert(tid, "Ezcorr", (char*)&m_Ezcorr - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   H5Tinsert(tid, "jtag", (char*)&mx_jtag - (char*)this, vl_string_tid);
   H5Tinsert(tid, "t", (char*)&m_t - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   H5Tinsert(tid, "terr", (char*)&m_terr - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   H5Tinsert(tid, "tzcorr", (char*)&m_tzcorr - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   H5Tinsert(tid, "x", (char*)&m_x - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   H5Tinsert(tid, "xerr", (char*)&m_xerr - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   H5Tinsert(tid, "xycorr", (char*)&m_xycorr - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   H5Tinsert(tid, "xzcorr", (char*)&m_xzcorr - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   H5Tinsert(tid, "y", (char*)&m_y - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   H5Tinsert(tid, "yerr", (char*)&m_yerr - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   H5Tinsert(tid, "yzcorr", (char*)&m_yzcorr - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   H5Tinsert(tid, "z", (char*)&m_z - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   H5Tinsert(tid, "zerr", (char*)&m_zerr - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   H5Tinsert(tid, "PreshowerList_size", (char*)&m_preshower_link.m_size - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   H5Tinsert(tid, "PreshowerList_offset", (char*)&m_preshower_link.m_ref - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   H5Tinsert(tid, "WidthList_size", (char*)&m_width_link.m_size - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   H5Tinsert(tid, "WidthList_offset", (char*)&m_width_link.m_ref - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   H5Tinsert(tid, "BcalClusterList_size", (char*)&m_bcalCluster_link.m_size - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   H5Tinsert(tid, "BcalClusterList_offset", (char*)&m_bcalCluster_link.m_ref - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   H5Tinsert(tid, "BcalCorrelationsList_size", (char*)&m_bcalCorrelations_link.m_size - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   H5Tinsert(tid, "BcalCorrelationsList_offset", (char*)&m_bcalCorrelations_link.m_ref - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   H5Tinsert(tid, "BcalLayersList_size", (char*)&m_bcalLayers_link.m_size - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   H5Tinsert(tid, "BcalLayersList_offset", (char*)&m_bcalLayers_link.m_ref - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   if (inmemory) {
      HDDM::s_hdf5_memorytype["bcalShower"] = tid;
   }
   else {
      HDDM::s_hdf5_datatype["bcalShower"] = tid;
   }
   if (verbose) {
      size_t slen;
      H5LTdtype_to_text(tid, 0, H5LT_DDL, &slen);
      char *ddlstring = (char*)malloc(slen);
      H5LTdtype_to_text(tid, ddlstring, H5LT_DDL, &slen);
      if (inmemory)
         printf("=== in-memory datatype %ld for %s is:\n %s\n", (long int)tid, "bcalShower", ddlstring);
      else
         printf("=== on-disk datatype %ld for %s is:\n %s\n", (long int)tid, "bcalShower", ddlstring);
      free(ddlstring);
   }
   return tid;
}
void BcalShower::hdf5DataPack()
{
   mx_jtag = m_jtag.c_str();
   m_preshower_link.deflate();
   m_width_link.deflate();
   m_bcalCluster_link.deflate();
   m_bcalCorrelations_link.deflate();
   m_bcalLayers_link.deflate();
}
void BcalShower::hdf5DataUnpack()
{
   new(&m_jtag) std::string();
   if (mx_jtag != 0) {
      m_jtag = mx_jtag;
      m_host->m_hdf5_strings.push_back(&m_jtag);
   }
   {
      std::list<Preshower*> *host_plist = &m_host->m_preshower_plist;
      m_preshower_link.inflate(m_host, host_plist, this);
      PreshowerList::iterator iter;
      for (iter = m_preshower_link.begin();
           iter != m_preshower_link.end(); ++iter)
      {
         iter->hdf5DataUnpack();
      }
   }
   {
      std::list<Width*> *host_plist = &m_host->m_width_plist;
      m_width_link.inflate(m_host, host_plist, this);
      WidthList::iterator iter;
      for (iter = m_width_link.begin();
           iter != m_width_link.end(); ++iter)
      {
         iter->hdf5DataUnpack();
      }
   }
   {
      std::list<BcalCluster*> *host_plist = &m_host->m_bcalCluster_plist;
      m_bcalCluster_link.inflate(m_host, host_plist, this);
      BcalClusterList::iterator iter;
      for (iter = m_bcalCluster_link.begin();
           iter != m_bcalCluster_link.end(); ++iter)
      {
         iter->hdf5DataUnpack();
      }
   }
   {
      std::list<BcalCorrelations*> *host_plist = &m_host->m_bcalCorrelations_plist;
      m_bcalCorrelations_link.inflate(m_host, host_plist, this);
      BcalCorrelationsList::iterator iter;
      for (iter = m_bcalCorrelations_link.begin();
           iter != m_bcalCorrelations_link.end(); ++iter)
      {
         iter->hdf5DataUnpack();
      }
   }
   {
      std::list<BcalLayers*> *host_plist = &m_host->m_bcalLayers_plist;
      m_bcalLayers_link.inflate(m_host, host_plist, this);
      BcalLayersList::iterator iter;
      for (iter = m_bcalLayers_link.begin();
           iter != m_bcalLayers_link.end(); ++iter)
      {
         iter->hdf5DataUnpack();
      }
   }
}
#endif

std::string CcalShower::toString(int indent) {
   std::stringstream ostr;
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "ccalShower"
        << " E=" << m_E
        << " Eerr=" << m_Eerr
        << " Emax=" << m_Emax
        << " chi2=" << m_chi2
        << " dime=" << m_dime
        << " id=" << m_id
        << " idmax=" << m_idmax
        << " jtag=" << "\"" << m_jtag << "\""
        << " t=" << m_t
        << " terr=" << m_terr
        << " type=" << m_type
        << " x=" << m_x
        << " x1=" << m_x1
        << " y=" << m_y
        << " y1=" << m_y1
        << " z=" << m_z
             << std::endl;
   return ostr.str();
}

std::string CcalShower::toXML(int indent) {
   std::stringstream ostr;
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "<ccalShower"
        << " E=" << "\"" << getE() << "\""
        << " Eerr=" << "\"" << getEerr() << "\""
        << " Emax=" << "\"" << getEmax() << "\""
        << " Eunit=" << "\"" << getEunit() << "\""
        << " chi2=" << "\"" << getChi2() << "\""
        << " dime=" << "\"" << getDime() << "\""
        << " id=" << "\"" << getId() << "\""
        << " idmax=" << "\"" << getIdmax() << "\""
        << " jtag=" << "\"" << getJtag() << "\""
        << " lunit=" << "\"" << getLunit() << "\""
        << " t=" << "\"" << getT() << "\""
        << " terr=" << "\"" << getTerr() << "\""
        << " tunit=" << "\"" << getTunit() << "\""
        << " type=" << "\"" << getType() << "\""
        << " x=" << "\"" << getX() << "\""
        << " x1=" << "\"" << getX1() << "\""
        << " y=" << "\"" << getY() << "\""
        << " y1=" << "\"" << getY1() << "\""
        << " z=" << "\"" << getZ() << "\""
        << " />" << std::endl;
   return ostr.str();
}

#ifdef HDF5_SUPPORT
hid_t CcalShower::hdf5Datatype(int inmemory, int verbose)
{
   std::string tname("ccalShower");
   if (inmemory) {
      if (HDDM::s_hdf5_memorytype.find(tname) != HDDM::s_hdf5_memorytype.end())
         return HDDM::s_hdf5_memorytype[tname];
   }
   else {
      if (HDDM::s_hdf5_datatype.find(tname) != HDDM::s_hdf5_datatype.end())
         return HDDM::s_hdf5_datatype[tname];
   }
   hid_t tid = H5Tcreate(H5T_COMPOUND, sizeof(*this));
   hid_t vl_string_tid = H5Tcopy(H5T_C_S1);
   H5Tset_size(vl_string_tid, H5T_VARIABLE);
   H5Tinsert(tid, "E", (char*)&m_E - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   H5Tinsert(tid, "Eerr", (char*)&m_Eerr - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   H5Tinsert(tid, "Emax", (char*)&m_Emax - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   H5Tinsert(tid, "chi2", (char*)&m_chi2 - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   H5Tinsert(tid, "dime", (char*)&m_dime - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I32LE));
   H5Tinsert(tid, "id", (char*)&m_id - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I32LE));
   H5Tinsert(tid, "idmax", (char*)&m_idmax - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I32LE));
   H5Tinsert(tid, "jtag", (char*)&mx_jtag - (char*)this, vl_string_tid);
   H5Tinsert(tid, "t", (char*)&m_t - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   H5Tinsert(tid, "terr", (char*)&m_terr - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   H5Tinsert(tid, "type", (char*)&m_type - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I32LE));
   H5Tinsert(tid, "x", (char*)&m_x - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   H5Tinsert(tid, "x1", (char*)&m_x1 - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   H5Tinsert(tid, "y", (char*)&m_y - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   H5Tinsert(tid, "y1", (char*)&m_y1 - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   H5Tinsert(tid, "z", (char*)&m_z - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   if (inmemory) {
      HDDM::s_hdf5_memorytype["ccalShower"] = tid;
   }
   else {
      HDDM::s_hdf5_datatype["ccalShower"] = tid;
   }
   if (verbose) {
      size_t slen;
      H5LTdtype_to_text(tid, 0, H5LT_DDL, &slen);
      char *ddlstring = (char*)malloc(slen);
      H5LTdtype_to_text(tid, ddlstring, H5LT_DDL, &slen);
      if (inmemory)
         printf("=== in-memory datatype %ld for %s is:\n %s\n", (long int)tid, "ccalShower", ddlstring);
      else
         printf("=== on-disk datatype %ld for %s is:\n %s\n", (long int)tid, "ccalShower", ddlstring);
      free(ddlstring);
   }
   return tid;
}
void CcalShower::hdf5DataPack()
{
   mx_jtag = m_jtag.c_str();
}
void CcalShower::hdf5DataUnpack()
{
   new(&m_jtag) std::string();
   if (mx_jtag != 0) {
      m_jtag = mx_jtag;
      m_host->m_hdf5_strings.push_back(&m_jtag);
   }
}
#endif

std::string TrackFit::toString(int indent) {
   std::stringstream ostr;
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "trackFit"
        << " Ndof=" << m_Ndof
        << " chisq=" << m_chisq
        << " e11=" << m_e11
        << " e12=" << m_e12
        << " e13=" << m_e13
        << " e14=" << m_e14
        << " e15=" << m_e15
        << " e22=" << m_e22
        << " e23=" << m_e23
        << " e24=" << m_e24
        << " e25=" << m_e25
        << " e33=" << m_e33
        << " e34=" << m_e34
        << " e35=" << m_e35
        << " e44=" << m_e44
        << " e45=" << m_e45
        << " e55=" << m_e55
        << " px=" << m_px
        << " py=" << m_py
        << " pz=" << m_pz
        << " t0=" << m_t0
        << " t0det=" << m_t0det
        << " t0err=" << m_t0err
        << " x0=" << m_x0
        << " y0=" << m_y0
        << " z0=" << m_z0
             << std::endl;
   return ostr.str();
}

std::string TrackFit::toXML(int indent) {
   std::stringstream ostr;
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "<trackFit"
        << " Ndof=" << "\"" << getNdof() << "\""
        << " chisq=" << "\"" << getChisq() << "\""
        << " e11=" << "\"" << getE11() << "\""
        << " e12=" << "\"" << getE12() << "\""
        << " e13=" << "\"" << getE13() << "\""
        << " e14=" << "\"" << getE14() << "\""
        << " e15=" << "\"" << getE15() << "\""
        << " e22=" << "\"" << getE22() << "\""
        << " e23=" << "\"" << getE23() << "\""
        << " e24=" << "\"" << getE24() << "\""
        << " e25=" << "\"" << getE25() << "\""
        << " e33=" << "\"" << getE33() << "\""
        << " e34=" << "\"" << getE34() << "\""
        << " e35=" << "\"" << getE35() << "\""
        << " e44=" << "\"" << getE44() << "\""
        << " e45=" << "\"" << getE45() << "\""
        << " e55=" << "\"" << getE55() << "\""
        << " lunit=" << "\"" << getLunit() << "\""
        << " punit=" << "\"" << getPunit() << "\""
        << " px=" << "\"" << getPx() << "\""
        << " py=" << "\"" << getPy() << "\""
        << " pz=" << "\"" << getPz() << "\""
        << " t0=" << "\"" << getT0() << "\""
        << " t0det=" << "\"" << getT0det() << "\""
        << " t0err=" << "\"" << getT0err() << "\""
        << " tunit=" << "\"" << getTunit() << "\""
        << " x0=" << "\"" << getX0() << "\""
        << " y0=" << "\"" << getY0() << "\""
        << " z0=" << "\"" << getZ0() << "\""
        << " />" << std::endl;
   return ostr.str();
}

#ifdef HDF5_SUPPORT
hid_t TrackFit::hdf5Datatype(int inmemory, int verbose)
{
   std::string tname("trackFit");
   if (inmemory) {
      if (HDDM::s_hdf5_memorytype.find(tname) != HDDM::s_hdf5_memorytype.end())
         return HDDM::s_hdf5_memorytype[tname];
   }
   else {
      if (HDDM::s_hdf5_datatype.find(tname) != HDDM::s_hdf5_datatype.end())
         return HDDM::s_hdf5_datatype[tname];
   }
   hid_t tid = H5Tcreate(H5T_COMPOUND, sizeof(*this));
   hid_t vl_string_tid = H5Tcopy(H5T_C_S1);
   H5Tset_size(vl_string_tid, H5T_VARIABLE);
   H5Tinsert(tid, "Ndof", (char*)&m_Ndof - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I32LE));
   H5Tinsert(tid, "chisq", (char*)&m_chisq - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   H5Tinsert(tid, "e11", (char*)&m_e11 - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   H5Tinsert(tid, "e12", (char*)&m_e12 - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   H5Tinsert(tid, "e13", (char*)&m_e13 - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   H5Tinsert(tid, "e14", (char*)&m_e14 - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   H5Tinsert(tid, "e15", (char*)&m_e15 - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   H5Tinsert(tid, "e22", (char*)&m_e22 - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   H5Tinsert(tid, "e23", (char*)&m_e23 - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   H5Tinsert(tid, "e24", (char*)&m_e24 - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   H5Tinsert(tid, "e25", (char*)&m_e25 - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   H5Tinsert(tid, "e33", (char*)&m_e33 - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   H5Tinsert(tid, "e34", (char*)&m_e34 - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   H5Tinsert(tid, "e35", (char*)&m_e35 - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   H5Tinsert(tid, "e44", (char*)&m_e44 - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   H5Tinsert(tid, "e45", (char*)&m_e45 - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   H5Tinsert(tid, "e55", (char*)&m_e55 - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   H5Tinsert(tid, "px", (char*)&m_px - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   H5Tinsert(tid, "py", (char*)&m_py - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   H5Tinsert(tid, "pz", (char*)&m_pz - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   H5Tinsert(tid, "t0", (char*)&m_t0 - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   H5Tinsert(tid, "t0det", (char*)&m_t0det - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I32LE));
   H5Tinsert(tid, "t0err", (char*)&m_t0err - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   H5Tinsert(tid, "x0", (char*)&m_x0 - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   H5Tinsert(tid, "y0", (char*)&m_y0 - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   H5Tinsert(tid, "z0", (char*)&m_z0 - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   if (inmemory) {
      HDDM::s_hdf5_memorytype["trackFit"] = tid;
   }
   else {
      HDDM::s_hdf5_datatype["trackFit"] = tid;
   }
   if (verbose) {
      size_t slen;
      H5LTdtype_to_text(tid, 0, H5LT_DDL, &slen);
      char *ddlstring = (char*)malloc(slen);
      H5LTdtype_to_text(tid, ddlstring, H5LT_DDL, &slen);
      if (inmemory)
         printf("=== in-memory datatype %ld for %s is:\n %s\n", (long int)tid, "trackFit", ddlstring);
      else
         printf("=== on-disk datatype %ld for %s is:\n %s\n", (long int)tid, "trackFit", ddlstring);
      free(ddlstring);
   }
   return tid;
}
void TrackFit::hdf5DataPack()
{
}
void TrackFit::hdf5DataUnpack()
{
}
#endif

std::string TrackFlags::toString(int indent) {
   std::stringstream ostr;
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "trackFlags"
        << " flags=" << m_flags
             << std::endl;
   return ostr.str();
}

std::string TrackFlags::toXML(int indent) {
   std::stringstream ostr;
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "<trackFlags"
        << " flags=" << "\"" << getFlags() << "\""
        << " />" << std::endl;
   return ostr.str();
}

#ifdef HDF5_SUPPORT
hid_t TrackFlags::hdf5Datatype(int inmemory, int verbose)
{
   std::string tname("trackFlags");
   if (inmemory) {
      if (HDDM::s_hdf5_memorytype.find(tname) != HDDM::s_hdf5_memorytype.end())
         return HDDM::s_hdf5_memorytype[tname];
   }
   else {
      if (HDDM::s_hdf5_datatype.find(tname) != HDDM::s_hdf5_datatype.end())
         return HDDM::s_hdf5_datatype[tname];
   }
   hid_t tid = H5Tcreate(H5T_COMPOUND, sizeof(*this));
   hid_t vl_string_tid = H5Tcopy(H5T_C_S1);
   H5Tset_size(vl_string_tid, H5T_VARIABLE);
   H5Tinsert(tid, "flags", (char*)&m_flags - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I32LE));
   if (inmemory) {
      HDDM::s_hdf5_memorytype["trackFlags"] = tid;
   }
   else {
      HDDM::s_hdf5_datatype["trackFlags"] = tid;
   }
   if (verbose) {
      size_t slen;
      H5LTdtype_to_text(tid, 0, H5LT_DDL, &slen);
      char *ddlstring = (char*)malloc(slen);
      H5LTdtype_to_text(tid, ddlstring, H5LT_DDL, &slen);
      if (inmemory)
         printf("=== in-memory datatype %ld for %s is:\n %s\n", (long int)tid, "trackFlags", ddlstring);
      else
         printf("=== on-disk datatype %ld for %s is:\n %s\n", (long int)tid, "trackFlags", ddlstring);
      free(ddlstring);
   }
   return tid;
}
void TrackFlags::hdf5DataPack()
{
}
void TrackFlags::hdf5DataUnpack()
{
}
#endif

std::string Hitlayers::toString(int indent) {
   std::stringstream ostr;
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "hitlayers"
        << " CDCrings=" << m_CDCrings
        << " FDCplanes=" << m_FDCplanes
             << std::endl;
   return ostr.str();
}

std::string Hitlayers::toXML(int indent) {
   std::stringstream ostr;
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "<hitlayers"
        << " CDCrings=" << "\"" << getCDCrings() << "\""
        << " FDCplanes=" << "\"" << getFDCplanes() << "\""
        << " />" << std::endl;
   return ostr.str();
}

#ifdef HDF5_SUPPORT
hid_t Hitlayers::hdf5Datatype(int inmemory, int verbose)
{
   std::string tname("hitlayers");
   if (inmemory) {
      if (HDDM::s_hdf5_memorytype.find(tname) != HDDM::s_hdf5_memorytype.end())
         return HDDM::s_hdf5_memorytype[tname];
   }
   else {
      if (HDDM::s_hdf5_datatype.find(tname) != HDDM::s_hdf5_datatype.end())
         return HDDM::s_hdf5_datatype[tname];
   }
   hid_t tid = H5Tcreate(H5T_COMPOUND, sizeof(*this));
   hid_t vl_string_tid = H5Tcopy(H5T_C_S1);
   H5Tset_size(vl_string_tid, H5T_VARIABLE);
   H5Tinsert(tid, "CDCrings", (char*)&m_CDCrings - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I32LE));
   H5Tinsert(tid, "FDCplanes", (char*)&m_FDCplanes - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I32LE));
   if (inmemory) {
      HDDM::s_hdf5_memorytype["hitlayers"] = tid;
   }
   else {
      HDDM::s_hdf5_datatype["hitlayers"] = tid;
   }
   if (verbose) {
      size_t slen;
      H5LTdtype_to_text(tid, 0, H5LT_DDL, &slen);
      char *ddlstring = (char*)malloc(slen);
      H5LTdtype_to_text(tid, ddlstring, H5LT_DDL, &slen);
      if (inmemory)
         printf("=== in-memory datatype %ld for %s is:\n %s\n", (long int)tid, "hitlayers", ddlstring);
      else
         printf("=== on-disk datatype %ld for %s is:\n %s\n", (long int)tid, "hitlayers", ddlstring);
      free(ddlstring);
   }
   return tid;
}
void Hitlayers::hdf5DataPack()
{
}
void Hitlayers::hdf5DataUnpack()
{
}
#endif

std::string Expectedhits::toString(int indent) {
   std::stringstream ostr;
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "expectedhits"
        << " expectedCDChits=" << m_expectedCDChits
        << " expectedFDChits=" << m_expectedFDChits
        << " measuredCDChits=" << m_measuredCDChits
        << " measuredFDChits=" << m_measuredFDChits
             << std::endl;
   return ostr.str();
}

std::string Expectedhits::toXML(int indent) {
   std::stringstream ostr;
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "<expectedhits"
        << " expectedCDChits=" << "\"" << getExpectedCDChits() << "\""
        << " expectedFDChits=" << "\"" << getExpectedFDChits() << "\""
        << " measuredCDChits=" << "\"" << getMeasuredCDChits() << "\""
        << " measuredFDChits=" << "\"" << getMeasuredFDChits() << "\""
        << " />" << std::endl;
   return ostr.str();
}

#ifdef HDF5_SUPPORT
hid_t Expectedhits::hdf5Datatype(int inmemory, int verbose)
{
   std::string tname("expectedhits");
   if (inmemory) {
      if (HDDM::s_hdf5_memorytype.find(tname) != HDDM::s_hdf5_memorytype.end())
         return HDDM::s_hdf5_memorytype[tname];
   }
   else {
      if (HDDM::s_hdf5_datatype.find(tname) != HDDM::s_hdf5_datatype.end())
         return HDDM::s_hdf5_datatype[tname];
   }
   hid_t tid = H5Tcreate(H5T_COMPOUND, sizeof(*this));
   hid_t vl_string_tid = H5Tcopy(H5T_C_S1);
   H5Tset_size(vl_string_tid, H5T_VARIABLE);
   H5Tinsert(tid, "expectedCDChits", (char*)&m_expectedCDChits - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I32LE));
   H5Tinsert(tid, "expectedFDChits", (char*)&m_expectedFDChits - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I32LE));
   H5Tinsert(tid, "measuredCDChits", (char*)&m_measuredCDChits - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I32LE));
   H5Tinsert(tid, "measuredFDChits", (char*)&m_measuredFDChits - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I32LE));
   if (inmemory) {
      HDDM::s_hdf5_memorytype["expectedhits"] = tid;
   }
   else {
      HDDM::s_hdf5_datatype["expectedhits"] = tid;
   }
   if (verbose) {
      size_t slen;
      H5LTdtype_to_text(tid, 0, H5LT_DDL, &slen);
      char *ddlstring = (char*)malloc(slen);
      H5LTdtype_to_text(tid, ddlstring, H5LT_DDL, &slen);
      if (inmemory)
         printf("=== in-memory datatype %ld for %s is:\n %s\n", (long int)tid, "expectedhits", ddlstring);
      else
         printf("=== on-disk datatype %ld for %s is:\n %s\n", (long int)tid, "expectedhits", ddlstring);
      free(ddlstring);
   }
   return tid;
}
void Expectedhits::hdf5DataPack()
{
}
void Expectedhits::hdf5DataUnpack()
{
}
#endif

std::string Mcmatch::toString(int indent) {
   std::stringstream ostr;
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "mcmatch"
        << " ithrown=" << m_ithrown
        << " numhitsmatch=" << m_numhitsmatch
             << std::endl;
   return ostr.str();
}

std::string Mcmatch::toXML(int indent) {
   std::stringstream ostr;
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "<mcmatch"
        << " ithrown=" << "\"" << getIthrown() << "\""
        << " numhitsmatch=" << "\"" << getNumhitsmatch() << "\""
        << " />" << std::endl;
   return ostr.str();
}

#ifdef HDF5_SUPPORT
hid_t Mcmatch::hdf5Datatype(int inmemory, int verbose)
{
   std::string tname("mcmatch");
   if (inmemory) {
      if (HDDM::s_hdf5_memorytype.find(tname) != HDDM::s_hdf5_memorytype.end())
         return HDDM::s_hdf5_memorytype[tname];
   }
   else {
      if (HDDM::s_hdf5_datatype.find(tname) != HDDM::s_hdf5_datatype.end())
         return HDDM::s_hdf5_datatype[tname];
   }
   hid_t tid = H5Tcreate(H5T_COMPOUND, sizeof(*this));
   hid_t vl_string_tid = H5Tcopy(H5T_C_S1);
   H5Tset_size(vl_string_tid, H5T_VARIABLE);
   H5Tinsert(tid, "ithrown", (char*)&m_ithrown - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I32LE));
   H5Tinsert(tid, "numhitsmatch", (char*)&m_numhitsmatch - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I32LE));
   if (inmemory) {
      HDDM::s_hdf5_memorytype["mcmatch"] = tid;
   }
   else {
      HDDM::s_hdf5_datatype["mcmatch"] = tid;
   }
   if (verbose) {
      size_t slen;
      H5LTdtype_to_text(tid, 0, H5LT_DDL, &slen);
      char *ddlstring = (char*)malloc(slen);
      H5LTdtype_to_text(tid, ddlstring, H5LT_DDL, &slen);
      if (inmemory)
         printf("=== in-memory datatype %ld for %s is:\n %s\n", (long int)tid, "mcmatch", ddlstring);
      else
         printf("=== on-disk datatype %ld for %s is:\n %s\n", (long int)tid, "mcmatch", ddlstring);
      free(ddlstring);
   }
   return tid;
}
void Mcmatch::hdf5DataPack()
{
}
void Mcmatch::hdf5DataUnpack()
{
}
#endif

std::string CDCAmpdEdx::toString(int indent) {
   std::stringstream ostr;
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "CDCAmpdEdx"
        << " dEdxCDCAmp=" << m_dEdxCDCAmp
        << " dxCDCAmp=" << m_dxCDCAmp
             << std::endl;
   return ostr.str();
}

std::string CDCAmpdEdx::toXML(int indent) {
   std::stringstream ostr;
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "<CDCAmpdEdx"
        << " dEdxCDCAmp=" << "\"" << getDEdxCDCAmp() << "\""
        << " dxCDCAmp=" << "\"" << getDxCDCAmp() << "\""
        << " />" << std::endl;
   return ostr.str();
}

#ifdef HDF5_SUPPORT
hid_t CDCAmpdEdx::hdf5Datatype(int inmemory, int verbose)
{
   std::string tname("CDCAmpdEdx");
   if (inmemory) {
      if (HDDM::s_hdf5_memorytype.find(tname) != HDDM::s_hdf5_memorytype.end())
         return HDDM::s_hdf5_memorytype[tname];
   }
   else {
      if (HDDM::s_hdf5_datatype.find(tname) != HDDM::s_hdf5_datatype.end())
         return HDDM::s_hdf5_datatype[tname];
   }
   hid_t tid = H5Tcreate(H5T_COMPOUND, sizeof(*this));
   hid_t vl_string_tid = H5Tcopy(H5T_C_S1);
   H5Tset_size(vl_string_tid, H5T_VARIABLE);
   H5Tinsert(tid, "dEdxCDCAmp", (char*)&m_dEdxCDCAmp - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   H5Tinsert(tid, "dxCDCAmp", (char*)&m_dxCDCAmp - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   if (inmemory) {
      HDDM::s_hdf5_memorytype["CDCAmpdEdx"] = tid;
   }
   else {
      HDDM::s_hdf5_datatype["CDCAmpdEdx"] = tid;
   }
   if (verbose) {
      size_t slen;
      H5LTdtype_to_text(tid, 0, H5LT_DDL, &slen);
      char *ddlstring = (char*)malloc(slen);
      H5LTdtype_to_text(tid, ddlstring, H5LT_DDL, &slen);
      if (inmemory)
         printf("=== in-memory datatype %ld for %s is:\n %s\n", (long int)tid, "CDCAmpdEdx", ddlstring);
      else
         printf("=== on-disk datatype %ld for %s is:\n %s\n", (long int)tid, "CDCAmpdEdx", ddlstring);
      free(ddlstring);
   }
   return tid;
}
void CDCAmpdEdx::hdf5DataPack()
{
}
void CDCAmpdEdx::hdf5DataUnpack()
{
}
#endif

std::string CDCdEdxTrunc::toString(int indent) {
   std::stringstream ostr;
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "CDCdEdxTrunc"
        << " dEdx=" << m_dEdx
        << " dEdxAmp=" << m_dEdxAmp
        << " dx=" << m_dx
        << " dxAmp=" << m_dxAmp
        << " ntrunc=" << m_ntrunc
             << std::endl;
   return ostr.str();
}

std::string CDCdEdxTrunc::toXML(int indent) {
   std::stringstream ostr;
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "<CDCdEdxTrunc"
        << " dEdx=" << "\"" << getDEdx() << "\""
        << " dEdxAmp=" << "\"" << getDEdxAmp() << "\""
        << " dEdx_unit=" << "\"" << getDEdx_unit() << "\""
        << " dx=" << "\"" << getDx() << "\""
        << " dxAmp=" << "\"" << getDxAmp() << "\""
        << " lunit=" << "\"" << getLunit() << "\""
        << " ntrunc=" << "\"" << getNtrunc() << "\""
        << " />" << std::endl;
   return ostr.str();
}

#ifdef HDF5_SUPPORT
hid_t CDCdEdxTrunc::hdf5Datatype(int inmemory, int verbose)
{
   std::string tname("CDCdEdxTrunc");
   if (inmemory) {
      if (HDDM::s_hdf5_memorytype.find(tname) != HDDM::s_hdf5_memorytype.end())
         return HDDM::s_hdf5_memorytype[tname];
   }
   else {
      if (HDDM::s_hdf5_datatype.find(tname) != HDDM::s_hdf5_datatype.end())
         return HDDM::s_hdf5_datatype[tname];
   }
   hid_t tid = H5Tcreate(H5T_COMPOUND, sizeof(*this));
   hid_t vl_string_tid = H5Tcopy(H5T_C_S1);
   H5Tset_size(vl_string_tid, H5T_VARIABLE);
   H5Tinsert(tid, "dEdx", (char*)&m_dEdx - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   H5Tinsert(tid, "dEdxAmp", (char*)&m_dEdxAmp - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   H5Tinsert(tid, "dx", (char*)&m_dx - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   H5Tinsert(tid, "dxAmp", (char*)&m_dxAmp - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   H5Tinsert(tid, "ntrunc", (char*)&m_ntrunc - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I32LE));
   if (inmemory) {
      HDDM::s_hdf5_memorytype["CDCdEdxTrunc"] = tid;
   }
   else {
      HDDM::s_hdf5_datatype["CDCdEdxTrunc"] = tid;
   }
   if (verbose) {
      size_t slen;
      H5LTdtype_to_text(tid, 0, H5LT_DDL, &slen);
      char *ddlstring = (char*)malloc(slen);
      H5LTdtype_to_text(tid, ddlstring, H5LT_DDL, &slen);
      if (inmemory)
         printf("=== in-memory datatype %ld for %s is:\n %s\n", (long int)tid, "CDCdEdxTrunc", ddlstring);
      else
         printf("=== on-disk datatype %ld for %s is:\n %s\n", (long int)tid, "CDCdEdxTrunc", ddlstring);
      free(ddlstring);
   }
   return tid;
}
void CDCdEdxTrunc::hdf5DataPack()
{
}
void CDCdEdxTrunc::hdf5DataUnpack()
{
}
#endif

std::string FDCdEdxTrunc::toString(int indent) {
   std::stringstream ostr;
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "FDCdEdxTrunc"
        << " dEdx=" << m_dEdx
        << " dEdxAmp=" << m_dEdxAmp
        << " dx=" << m_dx
        << " dxAmp=" << m_dxAmp
        << " ntrunc=" << m_ntrunc
             << std::endl;
   return ostr.str();
}

std::string FDCdEdxTrunc::toXML(int indent) {
   std::stringstream ostr;
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "<FDCdEdxTrunc"
        << " dEdx=" << "\"" << getDEdx() << "\""
        << " dEdxAmp=" << "\"" << getDEdxAmp() << "\""
        << " dEdx_unit=" << "\"" << getDEdx_unit() << "\""
        << " dx=" << "\"" << getDx() << "\""
        << " dxAmp=" << "\"" << getDxAmp() << "\""
        << " lunit=" << "\"" << getLunit() << "\""
        << " ntrunc=" << "\"" << getNtrunc() << "\""
        << " />" << std::endl;
   return ostr.str();
}

#ifdef HDF5_SUPPORT
hid_t FDCdEdxTrunc::hdf5Datatype(int inmemory, int verbose)
{
   std::string tname("FDCdEdxTrunc");
   if (inmemory) {
      if (HDDM::s_hdf5_memorytype.find(tname) != HDDM::s_hdf5_memorytype.end())
         return HDDM::s_hdf5_memorytype[tname];
   }
   else {
      if (HDDM::s_hdf5_datatype.find(tname) != HDDM::s_hdf5_datatype.end())
         return HDDM::s_hdf5_datatype[tname];
   }
   hid_t tid = H5Tcreate(H5T_COMPOUND, sizeof(*this));
   hid_t vl_string_tid = H5Tcopy(H5T_C_S1);
   H5Tset_size(vl_string_tid, H5T_VARIABLE);
   H5Tinsert(tid, "dEdx", (char*)&m_dEdx - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   H5Tinsert(tid, "dEdxAmp", (char*)&m_dEdxAmp - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   H5Tinsert(tid, "dx", (char*)&m_dx - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   H5Tinsert(tid, "dxAmp", (char*)&m_dxAmp - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   H5Tinsert(tid, "ntrunc", (char*)&m_ntrunc - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I32LE));
   if (inmemory) {
      HDDM::s_hdf5_memorytype["FDCdEdxTrunc"] = tid;
   }
   else {
      HDDM::s_hdf5_datatype["FDCdEdxTrunc"] = tid;
   }
   if (verbose) {
      size_t slen;
      H5LTdtype_to_text(tid, 0, H5LT_DDL, &slen);
      char *ddlstring = (char*)malloc(slen);
      H5LTdtype_to_text(tid, ddlstring, H5LT_DDL, &slen);
      if (inmemory)
         printf("=== in-memory datatype %ld for %s is:\n %s\n", (long int)tid, "FDCdEdxTrunc", ddlstring);
      else
         printf("=== on-disk datatype %ld for %s is:\n %s\n", (long int)tid, "FDCdEdxTrunc", ddlstring);
      free(ddlstring);
   }
   return tid;
}
void FDCdEdxTrunc::hdf5DataPack()
{
}
void FDCdEdxTrunc::hdf5DataUnpack()
{
}
#endif

std::string DEdxDC::toString(int indent) {
   std::stringstream ostr;
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "dEdxDC"
        << " NsampleCDC=" << m_NsampleCDC
        << " NsampleFDC=" << m_NsampleFDC
        << " dEdxCDC=" << m_dEdxCDC
        << " dEdxFDC=" << m_dEdxFDC
        << " dxCDC=" << m_dxCDC
        << " dxFDC=" << m_dxFDC
             << std::endl;
   if (! m_CDCAmpdEdx_link.empty()) {
      ostr << m_CDCAmpdEdx_link.begin()->toString(indent + 2);
   }
   int CDCdEdxTruncListCount=0;
   for (CDCdEdxTruncList::iterator it = m_CDCdEdxTrunc_list.begin();
        it != m_CDCdEdxTrunc_list.end(); ++it)
   {
      if (++CDCdEdxTruncListCount > m_CDCdEdxTrunc_list.size()) {
         throw std::runtime_error("hddm_r::toString error - list improperly terminated!");
      }
      ostr << it->toString(indent + 2);
   }
   int FDCdEdxTruncListCount=0;
   for (FDCdEdxTruncList::iterator it = m_FDCdEdxTrunc_list.begin();
        it != m_FDCdEdxTrunc_list.end(); ++it)
   {
      if (++FDCdEdxTruncListCount > m_FDCdEdxTrunc_list.size()) {
         throw std::runtime_error("hddm_r::toString error - list improperly terminated!");
      }
      ostr << it->toString(indent + 2);
   }
   return ostr.str();
}

std::string DEdxDC::toXML(int indent) {
   std::stringstream ostr;
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "<dEdxDC"
        << " NsampleCDC=" << "\"" << getNsampleCDC() << "\""
        << " NsampleFDC=" << "\"" << getNsampleFDC() << "\""
        << " dEdxCDC=" << "\"" << getDEdxCDC() << "\""
        << " dEdxFDC=" << "\"" << getDEdxFDC() << "\""
        << " dEdx_unit=" << "\"" << getDEdx_unit() << "\""
        << " dxCDC=" << "\"" << getDxCDC() << "\""
        << " dxFDC=" << "\"" << getDxFDC() << "\""
        << " lunit=" << "\"" << getLunit() << "\""
        << ">" << std::endl;
   if (! m_CDCAmpdEdx_link.empty()) {
      ostr << m_CDCAmpdEdx_link.begin()->toXML(indent + 2);
   }
   int CDCdEdxTruncListCount=0;
   for (CDCdEdxTruncList::iterator it = m_CDCdEdxTrunc_list.begin();
        it != m_CDCdEdxTrunc_list.end(); ++it)
   {
      if (++CDCdEdxTruncListCount > m_CDCdEdxTrunc_list.size()) {
         throw std::runtime_error("hddm_r::toXML error - list improperly terminated!");
      }
      ostr << it->toXML(indent + 2);
   }
   int FDCdEdxTruncListCount=0;
   for (FDCdEdxTruncList::iterator it = m_FDCdEdxTrunc_list.begin();
        it != m_FDCdEdxTrunc_list.end(); ++it)
   {
      if (++FDCdEdxTruncListCount > m_FDCdEdxTrunc_list.size()) {
         throw std::runtime_error("hddm_r::toXML error - list improperly terminated!");
      }
      ostr << it->toXML(indent + 2);
   }
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "</dEdxDC>"
        << std::endl;
   return ostr.str();
}

#ifdef HDF5_SUPPORT
hid_t DEdxDC::hdf5Datatype(int inmemory, int verbose)
{
   std::string tname("dEdxDC");
   if (inmemory) {
      if (HDDM::s_hdf5_memorytype.find(tname) != HDDM::s_hdf5_memorytype.end())
         return HDDM::s_hdf5_memorytype[tname];
   }
   else {
      if (HDDM::s_hdf5_datatype.find(tname) != HDDM::s_hdf5_datatype.end())
         return HDDM::s_hdf5_datatype[tname];
   }
   hid_t tid = H5Tcreate(H5T_COMPOUND, sizeof(*this));
   hid_t vl_string_tid = H5Tcopy(H5T_C_S1);
   H5Tset_size(vl_string_tid, H5T_VARIABLE);
   H5Tinsert(tid, "NsampleCDC", (char*)&m_NsampleCDC - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I32LE));
   H5Tinsert(tid, "NsampleFDC", (char*)&m_NsampleFDC - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I32LE));
   H5Tinsert(tid, "dEdxCDC", (char*)&m_dEdxCDC - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   H5Tinsert(tid, "dEdxFDC", (char*)&m_dEdxFDC - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   H5Tinsert(tid, "dxCDC", (char*)&m_dxCDC - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   H5Tinsert(tid, "dxFDC", (char*)&m_dxFDC - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   H5Tinsert(tid, "CDCAmpdEdxList_size", (char*)&m_CDCAmpdEdx_link.m_size - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   H5Tinsert(tid, "CDCAmpdEdxList_offset", (char*)&m_CDCAmpdEdx_link.m_ref - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   H5Tinsert(tid, "CDCdEdxTruncList_size", (char*)&m_CDCdEdxTrunc_list.m_size - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   H5Tinsert(tid, "CDCdEdxTruncList_offset", (char*)&m_CDCdEdxTrunc_list.m_ref - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   H5Tinsert(tid, "FDCdEdxTruncList_size", (char*)&m_FDCdEdxTrunc_list.m_size - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   H5Tinsert(tid, "FDCdEdxTruncList_offset", (char*)&m_FDCdEdxTrunc_list.m_ref - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   if (inmemory) {
      HDDM::s_hdf5_memorytype["dEdxDC"] = tid;
   }
   else {
      HDDM::s_hdf5_datatype["dEdxDC"] = tid;
   }
   if (verbose) {
      size_t slen;
      H5LTdtype_to_text(tid, 0, H5LT_DDL, &slen);
      char *ddlstring = (char*)malloc(slen);
      H5LTdtype_to_text(tid, ddlstring, H5LT_DDL, &slen);
      if (inmemory)
         printf("=== in-memory datatype %ld for %s is:\n %s\n", (long int)tid, "dEdxDC", ddlstring);
      else
         printf("=== on-disk datatype %ld for %s is:\n %s\n", (long int)tid, "dEdxDC", ddlstring);
      free(ddlstring);
   }
   return tid;
}
void DEdxDC::hdf5DataPack()
{
   m_CDCAmpdEdx_link.deflate();
   m_CDCdEdxTrunc_list.deflate();
   m_FDCdEdxTrunc_list.deflate();
}
void DEdxDC::hdf5DataUnpack()
{
   {
      std::list<CDCAmpdEdx*> *host_plist = &m_host->m_CDCAmpdEdx_plist;
      m_CDCAmpdEdx_link.inflate(m_host, host_plist, this);
      CDCAmpdEdxList::iterator iter;
      for (iter = m_CDCAmpdEdx_link.begin();
           iter != m_CDCAmpdEdx_link.end(); ++iter)
      {
         iter->hdf5DataUnpack();
      }
   }
   {
      std::list<CDCdEdxTrunc*> *host_plist = &m_host->m_CDCdEdxTrunc_plist;
      m_CDCdEdxTrunc_list.inflate(m_host, host_plist, this);
      CDCdEdxTruncList::iterator iter;
      for (iter = m_CDCdEdxTrunc_list.begin();
           iter != m_CDCdEdxTrunc_list.end(); ++iter)
      {
         iter->hdf5DataUnpack();
      }
   }
   {
      std::list<FDCdEdxTrunc*> *host_plist = &m_host->m_FDCdEdxTrunc_plist;
      m_FDCdEdxTrunc_list.inflate(m_host, host_plist, this);
      FDCdEdxTruncList::iterator iter;
      for (iter = m_FDCdEdxTrunc_list.begin();
           iter != m_FDCdEdxTrunc_list.end(); ++iter)
      {
         iter->hdf5DataUnpack();
      }
   }
}
#endif

std::string ExitParams::toString(int indent) {
   std::stringstream ostr;
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "exitParams"
        << " px1=" << m_px1
        << " py1=" << m_py1
        << " pz1=" << m_pz1
        << " t1=" << m_t1
        << " x1=" << m_x1
        << " y1=" << m_y1
        << " z1=" << m_z1
             << std::endl;
   return ostr.str();
}

std::string ExitParams::toXML(int indent) {
   std::stringstream ostr;
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "<exitParams"
        << " lunit=" << "\"" << getLunit() << "\""
        << " punit=" << "\"" << getPunit() << "\""
        << " px1=" << "\"" << getPx1() << "\""
        << " py1=" << "\"" << getPy1() << "\""
        << " pz1=" << "\"" << getPz1() << "\""
        << " t1=" << "\"" << getT1() << "\""
        << " tunit=" << "\"" << getTunit() << "\""
        << " x1=" << "\"" << getX1() << "\""
        << " y1=" << "\"" << getY1() << "\""
        << " z1=" << "\"" << getZ1() << "\""
        << " />" << std::endl;
   return ostr.str();
}

#ifdef HDF5_SUPPORT
hid_t ExitParams::hdf5Datatype(int inmemory, int verbose)
{
   std::string tname("exitParams");
   if (inmemory) {
      if (HDDM::s_hdf5_memorytype.find(tname) != HDDM::s_hdf5_memorytype.end())
         return HDDM::s_hdf5_memorytype[tname];
   }
   else {
      if (HDDM::s_hdf5_datatype.find(tname) != HDDM::s_hdf5_datatype.end())
         return HDDM::s_hdf5_datatype[tname];
   }
   hid_t tid = H5Tcreate(H5T_COMPOUND, sizeof(*this));
   hid_t vl_string_tid = H5Tcopy(H5T_C_S1);
   H5Tset_size(vl_string_tid, H5T_VARIABLE);
   H5Tinsert(tid, "px1", (char*)&m_px1 - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   H5Tinsert(tid, "py1", (char*)&m_py1 - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   H5Tinsert(tid, "pz1", (char*)&m_pz1 - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   H5Tinsert(tid, "t1", (char*)&m_t1 - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   H5Tinsert(tid, "x1", (char*)&m_x1 - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   H5Tinsert(tid, "y1", (char*)&m_y1 - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   H5Tinsert(tid, "z1", (char*)&m_z1 - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   if (inmemory) {
      HDDM::s_hdf5_memorytype["exitParams"] = tid;
   }
   else {
      HDDM::s_hdf5_datatype["exitParams"] = tid;
   }
   if (verbose) {
      size_t slen;
      H5LTdtype_to_text(tid, 0, H5LT_DDL, &slen);
      char *ddlstring = (char*)malloc(slen);
      H5LTdtype_to_text(tid, ddlstring, H5LT_DDL, &slen);
      if (inmemory)
         printf("=== in-memory datatype %ld for %s is:\n %s\n", (long int)tid, "exitParams", ddlstring);
      else
         printf("=== on-disk datatype %ld for %s is:\n %s\n", (long int)tid, "exitParams", ddlstring);
      free(ddlstring);
   }
   return tid;
}
void ExitParams::hdf5DataPack()
{
}
void ExitParams::hdf5DataUnpack()
{
}
#endif

std::string ChargedTrack::toString(int indent) {
   std::stringstream ostr;
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "chargedTrack"
        << " candidateId=" << m_candidateId
        << " jtag=" << "\"" << m_jtag << "\""
        << " ptype=" << ParticleType((Particle_t)m_ptype)
             << std::endl;
   if (! m_trackFit_link.empty()) {
      ostr << m_trackFit_link.begin()->toString(indent + 2);
   }
   if (! m_trackFlags_link.empty()) {
      ostr << m_trackFlags_link.begin()->toString(indent + 2);
   }
   if (! m_hitlayers_link.empty()) {
      ostr << m_hitlayers_link.begin()->toString(indent + 2);
   }
   if (! m_expectedhits_link.empty()) {
      ostr << m_expectedhits_link.begin()->toString(indent + 2);
   }
   if (! m_mcmatch_link.empty()) {
      ostr << m_mcmatch_link.begin()->toString(indent + 2);
   }
   if (! m_dEdxDC_link.empty()) {
      ostr << m_dEdxDC_link.begin()->toString(indent + 2);
   }
   if (! m_exitParams_link.empty()) {
      ostr << m_exitParams_link.begin()->toString(indent + 2);
   }
   return ostr.str();
}

std::string ChargedTrack::toXML(int indent) {
   std::stringstream ostr;
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "<chargedTrack"
        << " candidateId=" << "\"" << getCandidateId() << "\""
        << " jtag=" << "\"" << getJtag() << "\""
        << " ptype=\"" << ParticleType((Particle_t)m_ptype) << "\""
        << ">" << std::endl;
   if (! m_trackFit_link.empty()) {
      ostr << m_trackFit_link.begin()->toXML(indent + 2);
   }
   if (! m_trackFlags_link.empty()) {
      ostr << m_trackFlags_link.begin()->toXML(indent + 2);
   }
   if (! m_hitlayers_link.empty()) {
      ostr << m_hitlayers_link.begin()->toXML(indent + 2);
   }
   if (! m_expectedhits_link.empty()) {
      ostr << m_expectedhits_link.begin()->toXML(indent + 2);
   }
   if (! m_mcmatch_link.empty()) {
      ostr << m_mcmatch_link.begin()->toXML(indent + 2);
   }
   if (! m_dEdxDC_link.empty()) {
      ostr << m_dEdxDC_link.begin()->toXML(indent + 2);
   }
   if (! m_exitParams_link.empty()) {
      ostr << m_exitParams_link.begin()->toXML(indent + 2);
   }
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "</chargedTrack>"
        << std::endl;
   return ostr.str();
}

#ifdef HDF5_SUPPORT
hid_t ChargedTrack::hdf5Datatype(int inmemory, int verbose)
{
   std::string tname("chargedTrack");
   if (inmemory) {
      if (HDDM::s_hdf5_memorytype.find(tname) != HDDM::s_hdf5_memorytype.end())
         return HDDM::s_hdf5_memorytype[tname];
   }
   else {
      if (HDDM::s_hdf5_datatype.find(tname) != HDDM::s_hdf5_datatype.end())
         return HDDM::s_hdf5_datatype[tname];
   }
   hid_t tid = H5Tcreate(H5T_COMPOUND, sizeof(*this));
   hid_t vl_string_tid = H5Tcopy(H5T_C_S1);
   H5Tset_size(vl_string_tid, H5T_VARIABLE);
   H5Tinsert(tid, "candidateId", (char*)&m_candidateId - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I32LE));
   H5Tinsert(tid, "jtag", (char*)&mx_jtag - (char*)this, vl_string_tid);
   H5Tinsert(tid, "ptype", (char*)&m_ptype - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I32LE));
   H5Tinsert(tid, "TrackFitList_size", (char*)&m_trackFit_link.m_size - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   H5Tinsert(tid, "TrackFitList_offset", (char*)&m_trackFit_link.m_ref - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   H5Tinsert(tid, "TrackFlagsList_size", (char*)&m_trackFlags_link.m_size - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   H5Tinsert(tid, "TrackFlagsList_offset", (char*)&m_trackFlags_link.m_ref - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   H5Tinsert(tid, "HitlayersList_size", (char*)&m_hitlayers_link.m_size - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   H5Tinsert(tid, "HitlayersList_offset", (char*)&m_hitlayers_link.m_ref - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   H5Tinsert(tid, "ExpectedhitsList_size", (char*)&m_expectedhits_link.m_size - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   H5Tinsert(tid, "ExpectedhitsList_offset", (char*)&m_expectedhits_link.m_ref - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   H5Tinsert(tid, "McmatchList_size", (char*)&m_mcmatch_link.m_size - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   H5Tinsert(tid, "McmatchList_offset", (char*)&m_mcmatch_link.m_ref - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   H5Tinsert(tid, "DEdxDCList_size", (char*)&m_dEdxDC_link.m_size - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   H5Tinsert(tid, "DEdxDCList_offset", (char*)&m_dEdxDC_link.m_ref - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   H5Tinsert(tid, "ExitParamsList_size", (char*)&m_exitParams_link.m_size - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   H5Tinsert(tid, "ExitParamsList_offset", (char*)&m_exitParams_link.m_ref - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   if (inmemory) {
      HDDM::s_hdf5_memorytype["chargedTrack"] = tid;
   }
   else {
      HDDM::s_hdf5_datatype["chargedTrack"] = tid;
   }
   if (verbose) {
      size_t slen;
      H5LTdtype_to_text(tid, 0, H5LT_DDL, &slen);
      char *ddlstring = (char*)malloc(slen);
      H5LTdtype_to_text(tid, ddlstring, H5LT_DDL, &slen);
      if (inmemory)
         printf("=== in-memory datatype %ld for %s is:\n %s\n", (long int)tid, "chargedTrack", ddlstring);
      else
         printf("=== on-disk datatype %ld for %s is:\n %s\n", (long int)tid, "chargedTrack", ddlstring);
      free(ddlstring);
   }
   return tid;
}
void ChargedTrack::hdf5DataPack()
{
   mx_jtag = m_jtag.c_str();
   m_trackFit_link.deflate();
   m_trackFlags_link.deflate();
   m_hitlayers_link.deflate();
   m_expectedhits_link.deflate();
   m_mcmatch_link.deflate();
   m_dEdxDC_link.deflate();
   m_exitParams_link.deflate();
}
void ChargedTrack::hdf5DataUnpack()
{
   new(&m_jtag) std::string();
   if (mx_jtag != 0) {
      m_jtag = mx_jtag;
      m_host->m_hdf5_strings.push_back(&m_jtag);
   }
   {
      std::list<TrackFit*> *host_plist = &m_host->m_trackFit_plist;
      m_trackFit_link.inflate(m_host, host_plist, this);
      TrackFitList::iterator iter;
      for (iter = m_trackFit_link.begin();
           iter != m_trackFit_link.end(); ++iter)
      {
         iter->hdf5DataUnpack();
      }
   }
   {
      std::list<TrackFlags*> *host_plist = &m_host->m_trackFlags_plist;
      m_trackFlags_link.inflate(m_host, host_plist, this);
      TrackFlagsList::iterator iter;
      for (iter = m_trackFlags_link.begin();
           iter != m_trackFlags_link.end(); ++iter)
      {
         iter->hdf5DataUnpack();
      }
   }
   {
      std::list<Hitlayers*> *host_plist = &m_host->m_hitlayers_plist;
      m_hitlayers_link.inflate(m_host, host_plist, this);
      HitlayersList::iterator iter;
      for (iter = m_hitlayers_link.begin();
           iter != m_hitlayers_link.end(); ++iter)
      {
         iter->hdf5DataUnpack();
      }
   }
   {
      std::list<Expectedhits*> *host_plist = &m_host->m_expectedhits_plist;
      m_expectedhits_link.inflate(m_host, host_plist, this);
      ExpectedhitsList::iterator iter;
      for (iter = m_expectedhits_link.begin();
           iter != m_expectedhits_link.end(); ++iter)
      {
         iter->hdf5DataUnpack();
      }
   }
   {
      std::list<Mcmatch*> *host_plist = &m_host->m_mcmatch_plist;
      m_mcmatch_link.inflate(m_host, host_plist, this);
      McmatchList::iterator iter;
      for (iter = m_mcmatch_link.begin();
           iter != m_mcmatch_link.end(); ++iter)
      {
         iter->hdf5DataUnpack();
      }
   }
   {
      std::list<DEdxDC*> *host_plist = &m_host->m_dEdxDC_plist;
      m_dEdxDC_link.inflate(m_host, host_plist, this);
      DEdxDCList::iterator iter;
      for (iter = m_dEdxDC_link.begin();
           iter != m_dEdxDC_link.end(); ++iter)
      {
         iter->hdf5DataUnpack();
      }
   }
   {
      std::list<ExitParams*> *host_plist = &m_host->m_exitParams_plist;
      m_exitParams_link.inflate(m_host, host_plist, this);
      ExitParamsList::iterator iter;
      for (iter = m_exitParams_link.begin();
           iter != m_exitParams_link.end(); ++iter)
      {
         iter->hdf5DataUnpack();
      }
   }
}
#endif

std::string StartHit::toString(int indent) {
   std::stringstream ostr;
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "startHit"
        << " dE=" << m_dE
        << " jtag=" << "\"" << m_jtag << "\""
        << " sector=" << m_sector
        << " t=" << m_t
             << std::endl;
   return ostr.str();
}

std::string StartHit::toXML(int indent) {
   std::stringstream ostr;
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "<startHit"
        << " Eunit=" << "\"" << getEunit() << "\""
        << " dE=" << "\"" << getDE() << "\""
        << " jtag=" << "\"" << getJtag() << "\""
        << " sector=" << "\"" << getSector() << "\""
        << " t=" << "\"" << getT() << "\""
        << " tunit=" << "\"" << getTunit() << "\""
        << " />" << std::endl;
   return ostr.str();
}

#ifdef HDF5_SUPPORT
hid_t StartHit::hdf5Datatype(int inmemory, int verbose)
{
   std::string tname("startHit");
   if (inmemory) {
      if (HDDM::s_hdf5_memorytype.find(tname) != HDDM::s_hdf5_memorytype.end())
         return HDDM::s_hdf5_memorytype[tname];
   }
   else {
      if (HDDM::s_hdf5_datatype.find(tname) != HDDM::s_hdf5_datatype.end())
         return HDDM::s_hdf5_datatype[tname];
   }
   hid_t tid = H5Tcreate(H5T_COMPOUND, sizeof(*this));
   hid_t vl_string_tid = H5Tcopy(H5T_C_S1);
   H5Tset_size(vl_string_tid, H5T_VARIABLE);
   H5Tinsert(tid, "dE", (char*)&m_dE - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   H5Tinsert(tid, "jtag", (char*)&mx_jtag - (char*)this, vl_string_tid);
   H5Tinsert(tid, "sector", (char*)&m_sector - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I32LE));
   H5Tinsert(tid, "t", (char*)&m_t - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   if (inmemory) {
      HDDM::s_hdf5_memorytype["startHit"] = tid;
   }
   else {
      HDDM::s_hdf5_datatype["startHit"] = tid;
   }
   if (verbose) {
      size_t slen;
      H5LTdtype_to_text(tid, 0, H5LT_DDL, &slen);
      char *ddlstring = (char*)malloc(slen);
      H5LTdtype_to_text(tid, ddlstring, H5LT_DDL, &slen);
      if (inmemory)
         printf("=== in-memory datatype %ld for %s is:\n %s\n", (long int)tid, "startHit", ddlstring);
      else
         printf("=== on-disk datatype %ld for %s is:\n %s\n", (long int)tid, "startHit", ddlstring);
      free(ddlstring);
   }
   return tid;
}
void StartHit::hdf5DataPack()
{
   mx_jtag = m_jtag.c_str();
}
void StartHit::hdf5DataUnpack()
{
   new(&m_jtag) std::string();
   if (mx_jtag != 0) {
      m_jtag = mx_jtag;
      m_host->m_hdf5_strings.push_back(&m_jtag);
   }
}
#endif

std::string CtofPoint::toString(int indent) {
   std::stringstream ostr;
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "ctofPoint"
        << " bar=" << m_bar
        << " dE=" << m_dE
        << " jtag=" << "\"" << m_jtag << "\""
        << " t=" << m_t
        << " x=" << m_x
        << " y=" << m_y
        << " z=" << m_z
             << std::endl;
   return ostr.str();
}

std::string CtofPoint::toXML(int indent) {
   std::stringstream ostr;
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "<ctofPoint"
        << " Eunit=" << "\"" << getEunit() << "\""
        << " bar=" << "\"" << getBar() << "\""
        << " dE=" << "\"" << getDE() << "\""
        << " jtag=" << "\"" << getJtag() << "\""
        << " lunit=" << "\"" << getLunit() << "\""
        << " t=" << "\"" << getT() << "\""
        << " tunit=" << "\"" << getTunit() << "\""
        << " x=" << "\"" << getX() << "\""
        << " y=" << "\"" << getY() << "\""
        << " z=" << "\"" << getZ() << "\""
        << " />" << std::endl;
   return ostr.str();
}

#ifdef HDF5_SUPPORT
hid_t CtofPoint::hdf5Datatype(int inmemory, int verbose)
{
   std::string tname("ctofPoint");
   if (inmemory) {
      if (HDDM::s_hdf5_memorytype.find(tname) != HDDM::s_hdf5_memorytype.end())
         return HDDM::s_hdf5_memorytype[tname];
   }
   else {
      if (HDDM::s_hdf5_datatype.find(tname) != HDDM::s_hdf5_datatype.end())
         return HDDM::s_hdf5_datatype[tname];
   }
   hid_t tid = H5Tcreate(H5T_COMPOUND, sizeof(*this));
   hid_t vl_string_tid = H5Tcopy(H5T_C_S1);
   H5Tset_size(vl_string_tid, H5T_VARIABLE);
   H5Tinsert(tid, "bar", (char*)&m_bar - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I32LE));
   H5Tinsert(tid, "dE", (char*)&m_dE - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   H5Tinsert(tid, "jtag", (char*)&mx_jtag - (char*)this, vl_string_tid);
   H5Tinsert(tid, "t", (char*)&m_t - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   H5Tinsert(tid, "x", (char*)&m_x - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   H5Tinsert(tid, "y", (char*)&m_y - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   H5Tinsert(tid, "z", (char*)&m_z - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   if (inmemory) {
      HDDM::s_hdf5_memorytype["ctofPoint"] = tid;
   }
   else {
      HDDM::s_hdf5_datatype["ctofPoint"] = tid;
   }
   if (verbose) {
      size_t slen;
      H5LTdtype_to_text(tid, 0, H5LT_DDL, &slen);
      char *ddlstring = (char*)malloc(slen);
      H5LTdtype_to_text(tid, ddlstring, H5LT_DDL, &slen);
      if (inmemory)
         printf("=== in-memory datatype %ld for %s is:\n %s\n", (long int)tid, "ctofPoint", ddlstring);
      else
         printf("=== on-disk datatype %ld for %s is:\n %s\n", (long int)tid, "ctofPoint", ddlstring);
      free(ddlstring);
   }
   return tid;
}
void CtofPoint::hdf5DataPack()
{
   mx_jtag = m_jtag.c_str();
}
void CtofPoint::hdf5DataUnpack()
{
   new(&m_jtag) std::string();
   if (mx_jtag != 0) {
      m_jtag = mx_jtag;
      m_host->m_hdf5_strings.push_back(&m_jtag);
   }
}
#endif

std::string TofStatus::toString(int indent) {
   std::stringstream ostr;
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "tofStatus"
        << " status=" << m_status
             << std::endl;
   return ostr.str();
}

std::string TofStatus::toXML(int indent) {
   std::stringstream ostr;
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "<tofStatus"
        << " status=" << "\"" << getStatus() << "\""
        << " />" << std::endl;
   return ostr.str();
}

#ifdef HDF5_SUPPORT
hid_t TofStatus::hdf5Datatype(int inmemory, int verbose)
{
   std::string tname("tofStatus");
   if (inmemory) {
      if (HDDM::s_hdf5_memorytype.find(tname) != HDDM::s_hdf5_memorytype.end())
         return HDDM::s_hdf5_memorytype[tname];
   }
   else {
      if (HDDM::s_hdf5_datatype.find(tname) != HDDM::s_hdf5_datatype.end())
         return HDDM::s_hdf5_datatype[tname];
   }
   hid_t tid = H5Tcreate(H5T_COMPOUND, sizeof(*this));
   hid_t vl_string_tid = H5Tcopy(H5T_C_S1);
   H5Tset_size(vl_string_tid, H5T_VARIABLE);
   H5Tinsert(tid, "status", (char*)&m_status - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I32LE));
   if (inmemory) {
      HDDM::s_hdf5_memorytype["tofStatus"] = tid;
   }
   else {
      HDDM::s_hdf5_datatype["tofStatus"] = tid;
   }
   if (verbose) {
      size_t slen;
      H5LTdtype_to_text(tid, 0, H5LT_DDL, &slen);
      char *ddlstring = (char*)malloc(slen);
      H5LTdtype_to_text(tid, ddlstring, H5LT_DDL, &slen);
      if (inmemory)
         printf("=== in-memory datatype %ld for %s is:\n %s\n", (long int)tid, "tofStatus", ddlstring);
      else
         printf("=== on-disk datatype %ld for %s is:\n %s\n", (long int)tid, "tofStatus", ddlstring);
      free(ddlstring);
   }
   return tid;
}
void TofStatus::hdf5DataPack()
{
}
void TofStatus::hdf5DataUnpack()
{
}
#endif

std::string TofEnergyDeposition::toString(int indent) {
   std::stringstream ostr;
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "tofEnergyDeposition"
        << " dE1=" << m_dE1
        << " dE2=" << m_dE2
             << std::endl;
   return ostr.str();
}

std::string TofEnergyDeposition::toXML(int indent) {
   std::stringstream ostr;
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "<tofEnergyDeposition"
        << " dE1=" << "\"" << getDE1() << "\""
        << " dE2=" << "\"" << getDE2() << "\""
        << " />" << std::endl;
   return ostr.str();
}

#ifdef HDF5_SUPPORT
hid_t TofEnergyDeposition::hdf5Datatype(int inmemory, int verbose)
{
   std::string tname("tofEnergyDeposition");
   if (inmemory) {
      if (HDDM::s_hdf5_memorytype.find(tname) != HDDM::s_hdf5_memorytype.end())
         return HDDM::s_hdf5_memorytype[tname];
   }
   else {
      if (HDDM::s_hdf5_datatype.find(tname) != HDDM::s_hdf5_datatype.end())
         return HDDM::s_hdf5_datatype[tname];
   }
   hid_t tid = H5Tcreate(H5T_COMPOUND, sizeof(*this));
   hid_t vl_string_tid = H5Tcopy(H5T_C_S1);
   H5Tset_size(vl_string_tid, H5T_VARIABLE);
   H5Tinsert(tid, "dE1", (char*)&m_dE1 - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   H5Tinsert(tid, "dE2", (char*)&m_dE2 - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   if (inmemory) {
      HDDM::s_hdf5_memorytype["tofEnergyDeposition"] = tid;
   }
   else {
      HDDM::s_hdf5_datatype["tofEnergyDeposition"] = tid;
   }
   if (verbose) {
      size_t slen;
      H5LTdtype_to_text(tid, 0, H5LT_DDL, &slen);
      char *ddlstring = (char*)malloc(slen);
      H5LTdtype_to_text(tid, ddlstring, H5LT_DDL, &slen);
      if (inmemory)
         printf("=== in-memory datatype %ld for %s is:\n %s\n", (long int)tid, "tofEnergyDeposition", ddlstring);
      else
         printf("=== on-disk datatype %ld for %s is:\n %s\n", (long int)tid, "tofEnergyDeposition", ddlstring);
      free(ddlstring);
   }
   return tid;
}
void TofEnergyDeposition::hdf5DataPack()
{
}
void TofEnergyDeposition::hdf5DataUnpack()
{
}
#endif

std::string TofPoint::toString(int indent) {
   std::stringstream ostr;
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "tofPoint"
        << " dE=" << m_dE
        << " jtag=" << "\"" << m_jtag << "\""
        << " t=" << m_t
        << " terr=" << m_terr
        << " x=" << m_x
        << " y=" << m_y
        << " z=" << m_z
             << std::endl;
   if (! m_tofStatus_link.empty()) {
      ostr << m_tofStatus_link.begin()->toString(indent + 2);
   }
   if (! m_tofEnergyDeposition_link.empty()) {
      ostr << m_tofEnergyDeposition_link.begin()->toString(indent + 2);
   }
   return ostr.str();
}

std::string TofPoint::toXML(int indent) {
   std::stringstream ostr;
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "<tofPoint"
        << " Eunit=" << "\"" << getEunit() << "\""
        << " dE=" << "\"" << getDE() << "\""
        << " jtag=" << "\"" << getJtag() << "\""
        << " lunit=" << "\"" << getLunit() << "\""
        << " t=" << "\"" << getT() << "\""
        << " terr=" << "\"" << getTerr() << "\""
        << " tunit=" << "\"" << getTunit() << "\""
        << " x=" << "\"" << getX() << "\""
        << " y=" << "\"" << getY() << "\""
        << " z=" << "\"" << getZ() << "\""
        << ">" << std::endl;
   if (! m_tofStatus_link.empty()) {
      ostr << m_tofStatus_link.begin()->toXML(indent + 2);
   }
   if (! m_tofEnergyDeposition_link.empty()) {
      ostr << m_tofEnergyDeposition_link.begin()->toXML(indent + 2);
   }
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "</tofPoint>"
        << std::endl;
   return ostr.str();
}

#ifdef HDF5_SUPPORT
hid_t TofPoint::hdf5Datatype(int inmemory, int verbose)
{
   std::string tname("tofPoint");
   if (inmemory) {
      if (HDDM::s_hdf5_memorytype.find(tname) != HDDM::s_hdf5_memorytype.end())
         return HDDM::s_hdf5_memorytype[tname];
   }
   else {
      if (HDDM::s_hdf5_datatype.find(tname) != HDDM::s_hdf5_datatype.end())
         return HDDM::s_hdf5_datatype[tname];
   }
   hid_t tid = H5Tcreate(H5T_COMPOUND, sizeof(*this));
   hid_t vl_string_tid = H5Tcopy(H5T_C_S1);
   H5Tset_size(vl_string_tid, H5T_VARIABLE);
   H5Tinsert(tid, "dE", (char*)&m_dE - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   H5Tinsert(tid, "jtag", (char*)&mx_jtag - (char*)this, vl_string_tid);
   H5Tinsert(tid, "t", (char*)&m_t - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   H5Tinsert(tid, "terr", (char*)&m_terr - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   H5Tinsert(tid, "x", (char*)&m_x - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   H5Tinsert(tid, "y", (char*)&m_y - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   H5Tinsert(tid, "z", (char*)&m_z - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   H5Tinsert(tid, "TofStatusList_size", (char*)&m_tofStatus_link.m_size - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   H5Tinsert(tid, "TofStatusList_offset", (char*)&m_tofStatus_link.m_ref - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   H5Tinsert(tid, "TofEnergyDepositionList_size", (char*)&m_tofEnergyDeposition_link.m_size - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   H5Tinsert(tid, "TofEnergyDepositionList_offset", (char*)&m_tofEnergyDeposition_link.m_ref - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   if (inmemory) {
      HDDM::s_hdf5_memorytype["tofPoint"] = tid;
   }
   else {
      HDDM::s_hdf5_datatype["tofPoint"] = tid;
   }
   if (verbose) {
      size_t slen;
      H5LTdtype_to_text(tid, 0, H5LT_DDL, &slen);
      char *ddlstring = (char*)malloc(slen);
      H5LTdtype_to_text(tid, ddlstring, H5LT_DDL, &slen);
      if (inmemory)
         printf("=== in-memory datatype %ld for %s is:\n %s\n", (long int)tid, "tofPoint", ddlstring);
      else
         printf("=== on-disk datatype %ld for %s is:\n %s\n", (long int)tid, "tofPoint", ddlstring);
      free(ddlstring);
   }
   return tid;
}
void TofPoint::hdf5DataPack()
{
   mx_jtag = m_jtag.c_str();
   m_tofStatus_link.deflate();
   m_tofEnergyDeposition_link.deflate();
}
void TofPoint::hdf5DataUnpack()
{
   new(&m_jtag) std::string();
   if (mx_jtag != 0) {
      m_jtag = mx_jtag;
      m_host->m_hdf5_strings.push_back(&m_jtag);
   }
   {
      std::list<TofStatus*> *host_plist = &m_host->m_tofStatus_plist;
      m_tofStatus_link.inflate(m_host, host_plist, this);
      TofStatusList::iterator iter;
      for (iter = m_tofStatus_link.begin();
           iter != m_tofStatus_link.end(); ++iter)
      {
         iter->hdf5DataUnpack();
      }
   }
   {
      std::list<TofEnergyDeposition*> *host_plist = &m_host->m_tofEnergyDeposition_plist;
      m_tofEnergyDeposition_link.inflate(m_host, host_plist, this);
      TofEnergyDepositionList::iterator iter;
      for (iter = m_tofEnergyDeposition_link.begin();
           iter != m_tofEnergyDeposition_link.end(); ++iter)
      {
         iter->hdf5DataUnpack();
      }
   }
}
#endif

std::string DircHit::toString(int indent) {
   std::stringstream ostr;
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "dircHit"
        << " ch=" << m_ch
        << " jtag=" << "\"" << m_jtag << "\""
        << " t=" << m_t
        << " tot=" << m_tot
             << std::endl;
   return ostr.str();
}

std::string DircHit::toXML(int indent) {
   std::stringstream ostr;
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "<dircHit"
        << " ch=" << "\"" << getCh() << "\""
        << " jtag=" << "\"" << getJtag() << "\""
        << " t=" << "\"" << getT() << "\""
        << " tot=" << "\"" << getTot() << "\""
        << " tunit=" << "\"" << getTunit() << "\""
        << " />" << std::endl;
   return ostr.str();
}

#ifdef HDF5_SUPPORT
hid_t DircHit::hdf5Datatype(int inmemory, int verbose)
{
   std::string tname("dircHit");
   if (inmemory) {
      if (HDDM::s_hdf5_memorytype.find(tname) != HDDM::s_hdf5_memorytype.end())
         return HDDM::s_hdf5_memorytype[tname];
   }
   else {
      if (HDDM::s_hdf5_datatype.find(tname) != HDDM::s_hdf5_datatype.end())
         return HDDM::s_hdf5_datatype[tname];
   }
   hid_t tid = H5Tcreate(H5T_COMPOUND, sizeof(*this));
   hid_t vl_string_tid = H5Tcopy(H5T_C_S1);
   H5Tset_size(vl_string_tid, H5T_VARIABLE);
   H5Tinsert(tid, "ch", (char*)&m_ch - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I32LE));
   H5Tinsert(tid, "jtag", (char*)&mx_jtag - (char*)this, vl_string_tid);
   H5Tinsert(tid, "t", (char*)&m_t - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   H5Tinsert(tid, "tot", (char*)&m_tot - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   if (inmemory) {
      HDDM::s_hdf5_memorytype["dircHit"] = tid;
   }
   else {
      HDDM::s_hdf5_datatype["dircHit"] = tid;
   }
   if (verbose) {
      size_t slen;
      H5LTdtype_to_text(tid, 0, H5LT_DDL, &slen);
      char *ddlstring = (char*)malloc(slen);
      H5LTdtype_to_text(tid, ddlstring, H5LT_DDL, &slen);
      if (inmemory)
         printf("=== in-memory datatype %ld for %s is:\n %s\n", (long int)tid, "dircHit", ddlstring);
      else
         printf("=== on-disk datatype %ld for %s is:\n %s\n", (long int)tid, "dircHit", ddlstring);
      free(ddlstring);
   }
   return tid;
}
void DircHit::hdf5DataPack()
{
   mx_jtag = m_jtag.c_str();
}
void DircHit::hdf5DataUnpack()
{
   new(&m_jtag) std::string();
   if (mx_jtag != 0) {
      m_jtag = mx_jtag;
      m_host->m_hdf5_strings.push_back(&m_jtag);
   }
}
#endif

std::string FmwpcHit::toString(int indent) {
   std::stringstream ostr;
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "fmwpcHit"
        << " amp=" << m_amp
        << " jtag=" << "\"" << m_jtag << "\""
        << " layer=" << m_layer
        << " ped=" << m_ped
        << " q=" << m_q
        << " qf=" << m_qf
        << " t=" << m_t
        << " wire=" << m_wire
             << std::endl;
   return ostr.str();
}

std::string FmwpcHit::toXML(int indent) {
   std::stringstream ostr;
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "<fmwpcHit"
        << " amp=" << "\"" << getAmp() << "\""
        << " jtag=" << "\"" << getJtag() << "\""
        << " layer=" << "\"" << getLayer() << "\""
        << " ped=" << "\"" << getPed() << "\""
        << " q=" << "\"" << getQ() << "\""
        << " qf=" << "\"" << getQf() << "\""
        << " t=" << "\"" << getT() << "\""
        << " tunit=" << "\"" << getTunit() << "\""
        << " wire=" << "\"" << getWire() << "\""
        << " />" << std::endl;
   return ostr.str();
}

#ifdef HDF5_SUPPORT
hid_t FmwpcHit::hdf5Datatype(int inmemory, int verbose)
{
   std::string tname("fmwpcHit");
   if (inmemory) {
      if (HDDM::s_hdf5_memorytype.find(tname) != HDDM::s_hdf5_memorytype.end())
         return HDDM::s_hdf5_memorytype[tname];
   }
   else {
      if (HDDM::s_hdf5_datatype.find(tname) != HDDM::s_hdf5_datatype.end())
         return HDDM::s_hdf5_datatype[tname];
   }
   hid_t tid = H5Tcreate(H5T_COMPOUND, sizeof(*this));
   hid_t vl_string_tid = H5Tcopy(H5T_C_S1);
   H5Tset_size(vl_string_tid, H5T_VARIABLE);
   H5Tinsert(tid, "amp", (char*)&m_amp - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   H5Tinsert(tid, "jtag", (char*)&mx_jtag - (char*)this, vl_string_tid);
   H5Tinsert(tid, "layer", (char*)&m_layer - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I32LE));
   H5Tinsert(tid, "ped", (char*)&m_ped - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   H5Tinsert(tid, "q", (char*)&m_q - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   H5Tinsert(tid, "qf", (char*)&m_qf - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I32LE));
   H5Tinsert(tid, "t", (char*)&m_t - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   H5Tinsert(tid, "wire", (char*)&m_wire - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I32LE));
   if (inmemory) {
      HDDM::s_hdf5_memorytype["fmwpcHit"] = tid;
   }
   else {
      HDDM::s_hdf5_datatype["fmwpcHit"] = tid;
   }
   if (verbose) {
      size_t slen;
      H5LTdtype_to_text(tid, 0, H5LT_DDL, &slen);
      char *ddlstring = (char*)malloc(slen);
      H5LTdtype_to_text(tid, ddlstring, H5LT_DDL, &slen);
      if (inmemory)
         printf("=== in-memory datatype %ld for %s is:\n %s\n", (long int)tid, "fmwpcHit", ddlstring);
      else
         printf("=== on-disk datatype %ld for %s is:\n %s\n", (long int)tid, "fmwpcHit", ddlstring);
      free(ddlstring);
   }
   return tid;
}
void FmwpcHit::hdf5DataPack()
{
   mx_jtag = m_jtag.c_str();
}
void FmwpcHit::hdf5DataUnpack()
{
   new(&m_jtag) std::string();
   if (mx_jtag != 0) {
      m_jtag = mx_jtag;
      m_host->m_hdf5_strings.push_back(&m_jtag);
   }
}
#endif

std::string RFtime::toString(int indent) {
   std::stringstream ostr;
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "RFtime"
        << " jtag=" << "\"" << m_jtag << "\""
        << " tsync=" << m_tsync
             << std::endl;
   return ostr.str();
}

std::string RFtime::toXML(int indent) {
   std::stringstream ostr;
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "<RFtime"
        << " jtag=" << "\"" << getJtag() << "\""
        << " tsync=" << "\"" << getTsync() << "\""
        << " tunit=" << "\"" << getTunit() << "\""
        << " />" << std::endl;
   return ostr.str();
}

#ifdef HDF5_SUPPORT
hid_t RFtime::hdf5Datatype(int inmemory, int verbose)
{
   std::string tname("RFtime");
   if (inmemory) {
      if (HDDM::s_hdf5_memorytype.find(tname) != HDDM::s_hdf5_memorytype.end())
         return HDDM::s_hdf5_memorytype[tname];
   }
   else {
      if (HDDM::s_hdf5_datatype.find(tname) != HDDM::s_hdf5_datatype.end())
         return HDDM::s_hdf5_datatype[tname];
   }
   hid_t tid = H5Tcreate(H5T_COMPOUND, sizeof(*this));
   hid_t vl_string_tid = H5Tcopy(H5T_C_S1);
   H5Tset_size(vl_string_tid, H5T_VARIABLE);
   H5Tinsert(tid, "jtag", (char*)&mx_jtag - (char*)this, vl_string_tid);
   H5Tinsert(tid, "tsync", (char*)&m_tsync - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   if (inmemory) {
      HDDM::s_hdf5_memorytype["RFtime"] = tid;
   }
   else {
      HDDM::s_hdf5_datatype["RFtime"] = tid;
   }
   if (verbose) {
      size_t slen;
      H5LTdtype_to_text(tid, 0, H5LT_DDL, &slen);
      char *ddlstring = (char*)malloc(slen);
      H5LTdtype_to_text(tid, ddlstring, H5LT_DDL, &slen);
      if (inmemory)
         printf("=== in-memory datatype %ld for %s is:\n %s\n", (long int)tid, "RFtime", ddlstring);
      else
         printf("=== on-disk datatype %ld for %s is:\n %s\n", (long int)tid, "RFtime", ddlstring);
      free(ddlstring);
   }
   return tid;
}
void RFtime::hdf5DataPack()
{
   mx_jtag = m_jtag.c_str();
}
void RFtime::hdf5DataUnpack()
{
   new(&m_jtag) std::string();
   if (mx_jtag != 0) {
      m_jtag = mx_jtag;
      m_host->m_hdf5_strings.push_back(&m_jtag);
   }
}
#endif

std::string TriggerEnergySums::toString(int indent) {
   std::stringstream ostr;
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "triggerEnergySums"
        << " BCALEnergySum=" << m_BCALEnergySum
        << " FCALEnergySum=" << m_FCALEnergySum
             << std::endl;
   return ostr.str();
}

std::string TriggerEnergySums::toXML(int indent) {
   std::stringstream ostr;
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "<triggerEnergySums"
        << " BCALEnergySum=" << "\"" << getBCALEnergySum() << "\""
        << " FCALEnergySum=" << "\"" << getFCALEnergySum() << "\""
        << " />" << std::endl;
   return ostr.str();
}

#ifdef HDF5_SUPPORT
hid_t TriggerEnergySums::hdf5Datatype(int inmemory, int verbose)
{
   std::string tname("triggerEnergySums");
   if (inmemory) {
      if (HDDM::s_hdf5_memorytype.find(tname) != HDDM::s_hdf5_memorytype.end())
         return HDDM::s_hdf5_memorytype[tname];
   }
   else {
      if (HDDM::s_hdf5_datatype.find(tname) != HDDM::s_hdf5_datatype.end())
         return HDDM::s_hdf5_datatype[tname];
   }
   hid_t tid = H5Tcreate(H5T_COMPOUND, sizeof(*this));
   hid_t vl_string_tid = H5Tcopy(H5T_C_S1);
   H5Tset_size(vl_string_tid, H5T_VARIABLE);
   H5Tinsert(tid, "BCALEnergySum", (char*)&m_BCALEnergySum - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   H5Tinsert(tid, "FCALEnergySum", (char*)&m_FCALEnergySum - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   if (inmemory) {
      HDDM::s_hdf5_memorytype["triggerEnergySums"] = tid;
   }
   else {
      HDDM::s_hdf5_datatype["triggerEnergySums"] = tid;
   }
   if (verbose) {
      size_t slen;
      H5LTdtype_to_text(tid, 0, H5LT_DDL, &slen);
      char *ddlstring = (char*)malloc(slen);
      H5LTdtype_to_text(tid, ddlstring, H5LT_DDL, &slen);
      if (inmemory)
         printf("=== in-memory datatype %ld for %s is:\n %s\n", (long int)tid, "triggerEnergySums", ddlstring);
      else
         printf("=== on-disk datatype %ld for %s is:\n %s\n", (long int)tid, "triggerEnergySums", ddlstring);
      free(ddlstring);
   }
   return tid;
}
void TriggerEnergySums::hdf5DataPack()
{
}
void TriggerEnergySums::hdf5DataUnpack()
{
}
#endif

std::string Trigger::toString(int indent) {
   std::stringstream ostr;
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "trigger"
        << " jtag=" << "\"" << m_jtag << "\""
        << " l1_fp_trig_bits=" << m_l1_fp_trig_bits
        << " l1_trig_bits=" << m_l1_trig_bits
             << std::endl;
   if (! m_triggerEnergySums_link.empty()) {
      ostr << m_triggerEnergySums_link.begin()->toString(indent + 2);
   }
   return ostr.str();
}

std::string Trigger::toXML(int indent) {
   std::stringstream ostr;
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "<trigger"
        << " jtag=" << "\"" << getJtag() << "\""
        << " l1_fp_trig_bits=" << "\"" << getL1_fp_trig_bits() << "\""
        << " l1_trig_bits=" << "\"" << getL1_trig_bits() << "\""
        << ">" << std::endl;
   if (! m_triggerEnergySums_link.empty()) {
      ostr << m_triggerEnergySums_link.begin()->toXML(indent + 2);
   }
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "</trigger>"
        << std::endl;
   return ostr.str();
}

#ifdef HDF5_SUPPORT
hid_t Trigger::hdf5Datatype(int inmemory, int verbose)
{
   std::string tname("trigger");
   if (inmemory) {
      if (HDDM::s_hdf5_memorytype.find(tname) != HDDM::s_hdf5_memorytype.end())
         return HDDM::s_hdf5_memorytype[tname];
   }
   else {
      if (HDDM::s_hdf5_datatype.find(tname) != HDDM::s_hdf5_datatype.end())
         return HDDM::s_hdf5_datatype[tname];
   }
   hid_t tid = H5Tcreate(H5T_COMPOUND, sizeof(*this));
   hid_t vl_string_tid = H5Tcopy(H5T_C_S1);
   H5Tset_size(vl_string_tid, H5T_VARIABLE);
   H5Tinsert(tid, "jtag", (char*)&mx_jtag - (char*)this, vl_string_tid);
   H5Tinsert(tid, "l1_fp_trig_bits", (char*)&m_l1_fp_trig_bits - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I32LE));
   H5Tinsert(tid, "l1_trig_bits", (char*)&m_l1_trig_bits - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I32LE));
   H5Tinsert(tid, "TriggerEnergySumsList_size", (char*)&m_triggerEnergySums_link.m_size - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   H5Tinsert(tid, "TriggerEnergySumsList_offset", (char*)&m_triggerEnergySums_link.m_ref - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   if (inmemory) {
      HDDM::s_hdf5_memorytype["trigger"] = tid;
   }
   else {
      HDDM::s_hdf5_datatype["trigger"] = tid;
   }
   if (verbose) {
      size_t slen;
      H5LTdtype_to_text(tid, 0, H5LT_DDL, &slen);
      char *ddlstring = (char*)malloc(slen);
      H5LTdtype_to_text(tid, ddlstring, H5LT_DDL, &slen);
      if (inmemory)
         printf("=== in-memory datatype %ld for %s is:\n %s\n", (long int)tid, "trigger", ddlstring);
      else
         printf("=== on-disk datatype %ld for %s is:\n %s\n", (long int)tid, "trigger", ddlstring);
      free(ddlstring);
   }
   return tid;
}
void Trigger::hdf5DataPack()
{
   mx_jtag = m_jtag.c_str();
   m_triggerEnergySums_link.deflate();
}
void Trigger::hdf5DataUnpack()
{
   new(&m_jtag) std::string();
   if (mx_jtag != 0) {
      m_jtag = mx_jtag;
      m_host->m_hdf5_strings.push_back(&m_jtag);
   }
   {
      std::list<TriggerEnergySums*> *host_plist = &m_host->m_triggerEnergySums_plist;
      m_triggerEnergySums_link.inflate(m_host, host_plist, this);
      TriggerEnergySumsList::iterator iter;
      for (iter = m_triggerEnergySums_link.begin();
           iter != m_triggerEnergySums_link.end(); ++iter)
      {
         iter->hdf5DataUnpack();
      }
   }
}
#endif

std::string BcalMatchParams::toString(int indent) {
   std::stringstream ostr;
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "bcalMatchParams"
        << " deltaphi=" << m_deltaphi
        << " deltaz=" << m_deltaz
        << " dx=" << m_dx
        << " pathlength=" << m_pathlength
        << " shower=" << m_shower
        << " tflight=" << m_tflight
        << " tflightvar=" << m_tflightvar
        << " track=" << m_track
             << std::endl;
   return ostr.str();
}

std::string BcalMatchParams::toXML(int indent) {
   std::stringstream ostr;
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "<bcalMatchParams"
        << " deltaphi=" << "\"" << getDeltaphi() << "\""
        << " deltaz=" << "\"" << getDeltaz() << "\""
        << " dx=" << "\"" << getDx() << "\""
        << " lunit=" << "\"" << getLunit() << "\""
        << " pathlength=" << "\"" << getPathlength() << "\""
        << " shower=" << "\"" << getShower() << "\""
        << " tflight=" << "\"" << getTflight() << "\""
        << " tflightvar=" << "\"" << getTflightvar() << "\""
        << " track=" << "\"" << getTrack() << "\""
        << " tunit=" << "\"" << getTunit() << "\""
        << " />" << std::endl;
   return ostr.str();
}

#ifdef HDF5_SUPPORT
hid_t BcalMatchParams::hdf5Datatype(int inmemory, int verbose)
{
   std::string tname("bcalMatchParams");
   if (inmemory) {
      if (HDDM::s_hdf5_memorytype.find(tname) != HDDM::s_hdf5_memorytype.end())
         return HDDM::s_hdf5_memorytype[tname];
   }
   else {
      if (HDDM::s_hdf5_datatype.find(tname) != HDDM::s_hdf5_datatype.end())
         return HDDM::s_hdf5_datatype[tname];
   }
   hid_t tid = H5Tcreate(H5T_COMPOUND, sizeof(*this));
   hid_t vl_string_tid = H5Tcopy(H5T_C_S1);
   H5Tset_size(vl_string_tid, H5T_VARIABLE);
   H5Tinsert(tid, "deltaphi", (char*)&m_deltaphi - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   H5Tinsert(tid, "deltaz", (char*)&m_deltaz - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   H5Tinsert(tid, "dx", (char*)&m_dx - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   H5Tinsert(tid, "pathlength", (char*)&m_pathlength - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   H5Tinsert(tid, "shower", (char*)&m_shower - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I32LE));
   H5Tinsert(tid, "tflight", (char*)&m_tflight - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   H5Tinsert(tid, "tflightvar", (char*)&m_tflightvar - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   H5Tinsert(tid, "track", (char*)&m_track - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I32LE));
   if (inmemory) {
      HDDM::s_hdf5_memorytype["bcalMatchParams"] = tid;
   }
   else {
      HDDM::s_hdf5_datatype["bcalMatchParams"] = tid;
   }
   if (verbose) {
      size_t slen;
      H5LTdtype_to_text(tid, 0, H5LT_DDL, &slen);
      char *ddlstring = (char*)malloc(slen);
      H5LTdtype_to_text(tid, ddlstring, H5LT_DDL, &slen);
      if (inmemory)
         printf("=== in-memory datatype %ld for %s is:\n %s\n", (long int)tid, "bcalMatchParams", ddlstring);
      else
         printf("=== on-disk datatype %ld for %s is:\n %s\n", (long int)tid, "bcalMatchParams", ddlstring);
      free(ddlstring);
   }
   return tid;
}
void BcalMatchParams::hdf5DataPack()
{
}
void BcalMatchParams::hdf5DataUnpack()
{
}
#endif

std::string FcalEnergyParams::toString(int indent) {
   std::stringstream ostr;
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "fcalEnergyParams"
        << " E3x3=" << m_E3x3
        << " E5x5=" << m_E5x5
        << " Ecenter=" << m_Ecenter
             << std::endl;
   return ostr.str();
}

std::string FcalEnergyParams::toXML(int indent) {
   std::stringstream ostr;
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "<fcalEnergyParams"
        << " E3x3=" << "\"" << getE3x3() << "\""
        << " E5x5=" << "\"" << getE5x5() << "\""
        << " Ecenter=" << "\"" << getEcenter() << "\""
        << " />" << std::endl;
   return ostr.str();
}

#ifdef HDF5_SUPPORT
hid_t FcalEnergyParams::hdf5Datatype(int inmemory, int verbose)
{
   std::string tname("fcalEnergyParams");
   if (inmemory) {
      if (HDDM::s_hdf5_memorytype.find(tname) != HDDM::s_hdf5_memorytype.end())
         return HDDM::s_hdf5_memorytype[tname];
   }
   else {
      if (HDDM::s_hdf5_datatype.find(tname) != HDDM::s_hdf5_datatype.end())
         return HDDM::s_hdf5_datatype[tname];
   }
   hid_t tid = H5Tcreate(H5T_COMPOUND, sizeof(*this));
   hid_t vl_string_tid = H5Tcopy(H5T_C_S1);
   H5Tset_size(vl_string_tid, H5T_VARIABLE);
   H5Tinsert(tid, "E3x3", (char*)&m_E3x3 - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   H5Tinsert(tid, "E5x5", (char*)&m_E5x5 - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   H5Tinsert(tid, "Ecenter", (char*)&m_Ecenter - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   if (inmemory) {
      HDDM::s_hdf5_memorytype["fcalEnergyParams"] = tid;
   }
   else {
      HDDM::s_hdf5_datatype["fcalEnergyParams"] = tid;
   }
   if (verbose) {
      size_t slen;
      H5LTdtype_to_text(tid, 0, H5LT_DDL, &slen);
      char *ddlstring = (char*)malloc(slen);
      H5LTdtype_to_text(tid, ddlstring, H5LT_DDL, &slen);
      if (inmemory)
         printf("=== in-memory datatype %ld for %s is:\n %s\n", (long int)tid, "fcalEnergyParams", ddlstring);
      else
         printf("=== on-disk datatype %ld for %s is:\n %s\n", (long int)tid, "fcalEnergyParams", ddlstring);
      free(ddlstring);
   }
   return tid;
}
void FcalEnergyParams::hdf5DataPack()
{
}
void FcalEnergyParams::hdf5DataUnpack()
{
}
#endif

std::string FcalMatchParams::toString(int indent) {
   std::stringstream ostr;
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "fcalMatchParams"
        << " doca=" << m_doca
        << " dx=" << m_dx
        << " pathlength=" << m_pathlength
        << " shower=" << m_shower
        << " tflight=" << m_tflight
        << " tflightvar=" << m_tflightvar
        << " track=" << m_track
             << std::endl;
   if (! m_fcalEnergyParams_link.empty()) {
      ostr << m_fcalEnergyParams_link.begin()->toString(indent + 2);
   }
   return ostr.str();
}

std::string FcalMatchParams::toXML(int indent) {
   std::stringstream ostr;
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "<fcalMatchParams"
        << " doca=" << "\"" << getDoca() << "\""
        << " dx=" << "\"" << getDx() << "\""
        << " lunit=" << "\"" << getLunit() << "\""
        << " pathlength=" << "\"" << getPathlength() << "\""
        << " shower=" << "\"" << getShower() << "\""
        << " tflight=" << "\"" << getTflight() << "\""
        << " tflightvar=" << "\"" << getTflightvar() << "\""
        << " track=" << "\"" << getTrack() << "\""
        << " tunit=" << "\"" << getTunit() << "\""
        << ">" << std::endl;
   if (! m_fcalEnergyParams_link.empty()) {
      ostr << m_fcalEnergyParams_link.begin()->toXML(indent + 2);
   }
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "</fcalMatchParams>"
        << std::endl;
   return ostr.str();
}

#ifdef HDF5_SUPPORT
hid_t FcalMatchParams::hdf5Datatype(int inmemory, int verbose)
{
   std::string tname("fcalMatchParams");
   if (inmemory) {
      if (HDDM::s_hdf5_memorytype.find(tname) != HDDM::s_hdf5_memorytype.end())
         return HDDM::s_hdf5_memorytype[tname];
   }
   else {
      if (HDDM::s_hdf5_datatype.find(tname) != HDDM::s_hdf5_datatype.end())
         return HDDM::s_hdf5_datatype[tname];
   }
   hid_t tid = H5Tcreate(H5T_COMPOUND, sizeof(*this));
   hid_t vl_string_tid = H5Tcopy(H5T_C_S1);
   H5Tset_size(vl_string_tid, H5T_VARIABLE);
   H5Tinsert(tid, "doca", (char*)&m_doca - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   H5Tinsert(tid, "dx", (char*)&m_dx - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   H5Tinsert(tid, "pathlength", (char*)&m_pathlength - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   H5Tinsert(tid, "shower", (char*)&m_shower - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I32LE));
   H5Tinsert(tid, "tflight", (char*)&m_tflight - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   H5Tinsert(tid, "tflightvar", (char*)&m_tflightvar - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   H5Tinsert(tid, "track", (char*)&m_track - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I32LE));
   H5Tinsert(tid, "FcalEnergyParamsList_size", (char*)&m_fcalEnergyParams_link.m_size - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   H5Tinsert(tid, "FcalEnergyParamsList_offset", (char*)&m_fcalEnergyParams_link.m_ref - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   if (inmemory) {
      HDDM::s_hdf5_memorytype["fcalMatchParams"] = tid;
   }
   else {
      HDDM::s_hdf5_datatype["fcalMatchParams"] = tid;
   }
   if (verbose) {
      size_t slen;
      H5LTdtype_to_text(tid, 0, H5LT_DDL, &slen);
      char *ddlstring = (char*)malloc(slen);
      H5LTdtype_to_text(tid, ddlstring, H5LT_DDL, &slen);
      if (inmemory)
         printf("=== in-memory datatype %ld for %s is:\n %s\n", (long int)tid, "fcalMatchParams", ddlstring);
      else
         printf("=== on-disk datatype %ld for %s is:\n %s\n", (long int)tid, "fcalMatchParams", ddlstring);
      free(ddlstring);
   }
   return tid;
}
void FcalMatchParams::hdf5DataPack()
{
   m_fcalEnergyParams_link.deflate();
}
void FcalMatchParams::hdf5DataUnpack()
{
   {
      std::list<FcalEnergyParams*> *host_plist = &m_host->m_fcalEnergyParams_plist;
      m_fcalEnergyParams_link.inflate(m_host, host_plist, this);
      FcalEnergyParamsList::iterator iter;
      for (iter = m_fcalEnergyParams_link.begin();
           iter != m_fcalEnergyParams_link.end(); ++iter)
      {
         iter->hdf5DataUnpack();
      }
   }
}
#endif

std::string FcalSingleHitMatchParams::toString(int indent) {
   std::stringstream ostr;
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "fcalSingleHitMatchParams"
        << " doca=" << m_doca
        << " dx=" << m_dx
        << " ehit=" << m_ehit
        << " pathlength=" << m_pathlength
        << " tflight=" << m_tflight
        << " tflightvar=" << m_tflightvar
        << " thit=" << m_thit
        << " track=" << m_track
             << std::endl;
   return ostr.str();
}

std::string FcalSingleHitMatchParams::toXML(int indent) {
   std::stringstream ostr;
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "<fcalSingleHitMatchParams"
        << " doca=" << "\"" << getDoca() << "\""
        << " dx=" << "\"" << getDx() << "\""
        << " ehit=" << "\"" << getEhit() << "\""
        << " lunit=" << "\"" << getLunit() << "\""
        << " pathlength=" << "\"" << getPathlength() << "\""
        << " tflight=" << "\"" << getTflight() << "\""
        << " tflightvar=" << "\"" << getTflightvar() << "\""
        << " thit=" << "\"" << getThit() << "\""
        << " track=" << "\"" << getTrack() << "\""
        << " tunit=" << "\"" << getTunit() << "\""
        << " />" << std::endl;
   return ostr.str();
}

#ifdef HDF5_SUPPORT
hid_t FcalSingleHitMatchParams::hdf5Datatype(int inmemory, int verbose)
{
   std::string tname("fcalSingleHitMatchParams");
   if (inmemory) {
      if (HDDM::s_hdf5_memorytype.find(tname) != HDDM::s_hdf5_memorytype.end())
         return HDDM::s_hdf5_memorytype[tname];
   }
   else {
      if (HDDM::s_hdf5_datatype.find(tname) != HDDM::s_hdf5_datatype.end())
         return HDDM::s_hdf5_datatype[tname];
   }
   hid_t tid = H5Tcreate(H5T_COMPOUND, sizeof(*this));
   hid_t vl_string_tid = H5Tcopy(H5T_C_S1);
   H5Tset_size(vl_string_tid, H5T_VARIABLE);
   H5Tinsert(tid, "doca", (char*)&m_doca - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   H5Tinsert(tid, "dx", (char*)&m_dx - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   H5Tinsert(tid, "ehit", (char*)&m_ehit - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   H5Tinsert(tid, "pathlength", (char*)&m_pathlength - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   H5Tinsert(tid, "tflight", (char*)&m_tflight - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   H5Tinsert(tid, "tflightvar", (char*)&m_tflightvar - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   H5Tinsert(tid, "thit", (char*)&m_thit - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   H5Tinsert(tid, "track", (char*)&m_track - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I32LE));
   if (inmemory) {
      HDDM::s_hdf5_memorytype["fcalSingleHitMatchParams"] = tid;
   }
   else {
      HDDM::s_hdf5_datatype["fcalSingleHitMatchParams"] = tid;
   }
   if (verbose) {
      size_t slen;
      H5LTdtype_to_text(tid, 0, H5LT_DDL, &slen);
      char *ddlstring = (char*)malloc(slen);
      H5LTdtype_to_text(tid, ddlstring, H5LT_DDL, &slen);
      if (inmemory)
         printf("=== in-memory datatype %ld for %s is:\n %s\n", (long int)tid, "fcalSingleHitMatchParams", ddlstring);
      else
         printf("=== on-disk datatype %ld for %s is:\n %s\n", (long int)tid, "fcalSingleHitMatchParams", ddlstring);
      free(ddlstring);
   }
   return tid;
}
void FcalSingleHitMatchParams::hdf5DataPack()
{
}
void FcalSingleHitMatchParams::hdf5DataUnpack()
{
}
#endif

std::string CtofMatchParams::toString(int indent) {
   std::stringstream ostr;
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "ctofMatchParams"
        << " dEdx=" << m_dEdx
        << " deltax=" << m_deltax
        << " deltay=" << m_deltay
        << " hit=" << m_hit
        << " tflight=" << m_tflight
        << " track=" << m_track
             << std::endl;
   return ostr.str();
}

std::string CtofMatchParams::toXML(int indent) {
   std::stringstream ostr;
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "<ctofMatchParams"
        << " dEdx=" << "\"" << getDEdx() << "\""
        << " dEdx_unit=" << "\"" << getDEdx_unit() << "\""
        << " deltax=" << "\"" << getDeltax() << "\""
        << " deltay=" << "\"" << getDeltay() << "\""
        << " hit=" << "\"" << getHit() << "\""
        << " lunit=" << "\"" << getLunit() << "\""
        << " tflight=" << "\"" << getTflight() << "\""
        << " track=" << "\"" << getTrack() << "\""
        << " tunit=" << "\"" << getTunit() << "\""
        << " />" << std::endl;
   return ostr.str();
}

#ifdef HDF5_SUPPORT
hid_t CtofMatchParams::hdf5Datatype(int inmemory, int verbose)
{
   std::string tname("ctofMatchParams");
   if (inmemory) {
      if (HDDM::s_hdf5_memorytype.find(tname) != HDDM::s_hdf5_memorytype.end())
         return HDDM::s_hdf5_memorytype[tname];
   }
   else {
      if (HDDM::s_hdf5_datatype.find(tname) != HDDM::s_hdf5_datatype.end())
         return HDDM::s_hdf5_datatype[tname];
   }
   hid_t tid = H5Tcreate(H5T_COMPOUND, sizeof(*this));
   hid_t vl_string_tid = H5Tcopy(H5T_C_S1);
   H5Tset_size(vl_string_tid, H5T_VARIABLE);
   H5Tinsert(tid, "dEdx", (char*)&m_dEdx - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   H5Tinsert(tid, "deltax", (char*)&m_deltax - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   H5Tinsert(tid, "deltay", (char*)&m_deltay - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   H5Tinsert(tid, "hit", (char*)&m_hit - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I32LE));
   H5Tinsert(tid, "tflight", (char*)&m_tflight - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   H5Tinsert(tid, "track", (char*)&m_track - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I32LE));
   if (inmemory) {
      HDDM::s_hdf5_memorytype["ctofMatchParams"] = tid;
   }
   else {
      HDDM::s_hdf5_datatype["ctofMatchParams"] = tid;
   }
   if (verbose) {
      size_t slen;
      H5LTdtype_to_text(tid, 0, H5LT_DDL, &slen);
      char *ddlstring = (char*)malloc(slen);
      H5LTdtype_to_text(tid, ddlstring, H5LT_DDL, &slen);
      if (inmemory)
         printf("=== in-memory datatype %ld for %s is:\n %s\n", (long int)tid, "ctofMatchParams", ddlstring);
      else
         printf("=== on-disk datatype %ld for %s is:\n %s\n", (long int)tid, "ctofMatchParams", ddlstring);
      free(ddlstring);
   }
   return tid;
}
void CtofMatchParams::hdf5DataPack()
{
}
void CtofMatchParams::hdf5DataUnpack()
{
}
#endif

std::string FmwpcData::toString(int indent) {
   std::stringstream ostr;
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "fmwpcData"
        << " closestwire=" << m_closestwire
        << " dist=" << m_dist
        << " layer=" << m_layer
        << " nhits=" << m_nhits
             << std::endl;
   return ostr.str();
}

std::string FmwpcData::toXML(int indent) {
   std::stringstream ostr;
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "<fmwpcData"
        << " closestwire=" << "\"" << getClosestwire() << "\""
        << " dist=" << "\"" << getDist() << "\""
        << " layer=" << "\"" << getLayer() << "\""
        << " nhits=" << "\"" << getNhits() << "\""
        << " />" << std::endl;
   return ostr.str();
}

#ifdef HDF5_SUPPORT
hid_t FmwpcData::hdf5Datatype(int inmemory, int verbose)
{
   std::string tname("fmwpcData");
   if (inmemory) {
      if (HDDM::s_hdf5_memorytype.find(tname) != HDDM::s_hdf5_memorytype.end())
         return HDDM::s_hdf5_memorytype[tname];
   }
   else {
      if (HDDM::s_hdf5_datatype.find(tname) != HDDM::s_hdf5_datatype.end())
         return HDDM::s_hdf5_datatype[tname];
   }
   hid_t tid = H5Tcreate(H5T_COMPOUND, sizeof(*this));
   hid_t vl_string_tid = H5Tcopy(H5T_C_S1);
   H5Tset_size(vl_string_tid, H5T_VARIABLE);
   H5Tinsert(tid, "closestwire", (char*)&m_closestwire - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I32LE));
   H5Tinsert(tid, "dist", (char*)&m_dist - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I32LE));
   H5Tinsert(tid, "layer", (char*)&m_layer - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I32LE));
   H5Tinsert(tid, "nhits", (char*)&m_nhits - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I32LE));
   if (inmemory) {
      HDDM::s_hdf5_memorytype["fmwpcData"] = tid;
   }
   else {
      HDDM::s_hdf5_datatype["fmwpcData"] = tid;
   }
   if (verbose) {
      size_t slen;
      H5LTdtype_to_text(tid, 0, H5LT_DDL, &slen);
      char *ddlstring = (char*)malloc(slen);
      H5LTdtype_to_text(tid, ddlstring, H5LT_DDL, &slen);
      if (inmemory)
         printf("=== in-memory datatype %ld for %s is:\n %s\n", (long int)tid, "fmwpcData", ddlstring);
      else
         printf("=== on-disk datatype %ld for %s is:\n %s\n", (long int)tid, "fmwpcData", ddlstring);
      free(ddlstring);
   }
   return tid;
}
void FmwpcData::hdf5DataPack()
{
}
void FmwpcData::hdf5DataUnpack()
{
}
#endif

std::string FmwpcMatchParams::toString(int indent) {
   std::stringstream ostr;
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "fmwpcMatchParams"
        << " track=" << m_track
             << std::endl;
   int FmwpcDataListCount=0;
   for (FmwpcDataList::iterator it = m_fmwpcData_list.begin();
        it != m_fmwpcData_list.end(); ++it)
   {
      if (++FmwpcDataListCount > m_fmwpcData_list.size()) {
         throw std::runtime_error("hddm_r::toString error - list improperly terminated!");
      }
      ostr << it->toString(indent + 2);
   }
   return ostr.str();
}

std::string FmwpcMatchParams::toXML(int indent) {
   std::stringstream ostr;
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "<fmwpcMatchParams"
        << " track=" << "\"" << getTrack() << "\""
        << ">" << std::endl;
   int FmwpcDataListCount=0;
   for (FmwpcDataList::iterator it = m_fmwpcData_list.begin();
        it != m_fmwpcData_list.end(); ++it)
   {
      if (++FmwpcDataListCount > m_fmwpcData_list.size()) {
         throw std::runtime_error("hddm_r::toXML error - list improperly terminated!");
      }
      ostr << it->toXML(indent + 2);
   }
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "</fmwpcMatchParams>"
        << std::endl;
   return ostr.str();
}

#ifdef HDF5_SUPPORT
hid_t FmwpcMatchParams::hdf5Datatype(int inmemory, int verbose)
{
   std::string tname("fmwpcMatchParams");
   if (inmemory) {
      if (HDDM::s_hdf5_memorytype.find(tname) != HDDM::s_hdf5_memorytype.end())
         return HDDM::s_hdf5_memorytype[tname];
   }
   else {
      if (HDDM::s_hdf5_datatype.find(tname) != HDDM::s_hdf5_datatype.end())
         return HDDM::s_hdf5_datatype[tname];
   }
   hid_t tid = H5Tcreate(H5T_COMPOUND, sizeof(*this));
   hid_t vl_string_tid = H5Tcopy(H5T_C_S1);
   H5Tset_size(vl_string_tid, H5T_VARIABLE);
   H5Tinsert(tid, "track", (char*)&m_track - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I32LE));
   H5Tinsert(tid, "FmwpcDataList_size", (char*)&m_fmwpcData_list.m_size - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   H5Tinsert(tid, "FmwpcDataList_offset", (char*)&m_fmwpcData_list.m_ref - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   if (inmemory) {
      HDDM::s_hdf5_memorytype["fmwpcMatchParams"] = tid;
   }
   else {
      HDDM::s_hdf5_datatype["fmwpcMatchParams"] = tid;
   }
   if (verbose) {
      size_t slen;
      H5LTdtype_to_text(tid, 0, H5LT_DDL, &slen);
      char *ddlstring = (char*)malloc(slen);
      H5LTdtype_to_text(tid, ddlstring, H5LT_DDL, &slen);
      if (inmemory)
         printf("=== in-memory datatype %ld for %s is:\n %s\n", (long int)tid, "fmwpcMatchParams", ddlstring);
      else
         printf("=== on-disk datatype %ld for %s is:\n %s\n", (long int)tid, "fmwpcMatchParams", ddlstring);
      free(ddlstring);
   }
   return tid;
}
void FmwpcMatchParams::hdf5DataPack()
{
   m_fmwpcData_list.deflate();
}
void FmwpcMatchParams::hdf5DataUnpack()
{
   {
      std::list<FmwpcData*> *host_plist = &m_host->m_fmwpcData_plist;
      m_fmwpcData_list.inflate(m_host, host_plist, this);
      FmwpcDataList::iterator iter;
      for (iter = m_fmwpcData_list.begin();
           iter != m_fmwpcData_list.end(); ++iter)
      {
         iter->hdf5DataUnpack();
      }
   }
}
#endif

std::string TofDedx::toString(int indent) {
   std::stringstream ostr;
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "tofDedx"
        << " dEdx1=" << m_dEdx1
        << " dEdx2=" << m_dEdx2
             << std::endl;
   return ostr.str();
}

std::string TofDedx::toXML(int indent) {
   std::stringstream ostr;
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "<tofDedx"
        << " dEdx1=" << "\"" << getDEdx1() << "\""
        << " dEdx2=" << "\"" << getDEdx2() << "\""
        << " />" << std::endl;
   return ostr.str();
}

#ifdef HDF5_SUPPORT
hid_t TofDedx::hdf5Datatype(int inmemory, int verbose)
{
   std::string tname("tofDedx");
   if (inmemory) {
      if (HDDM::s_hdf5_memorytype.find(tname) != HDDM::s_hdf5_memorytype.end())
         return HDDM::s_hdf5_memorytype[tname];
   }
   else {
      if (HDDM::s_hdf5_datatype.find(tname) != HDDM::s_hdf5_datatype.end())
         return HDDM::s_hdf5_datatype[tname];
   }
   hid_t tid = H5Tcreate(H5T_COMPOUND, sizeof(*this));
   hid_t vl_string_tid = H5Tcopy(H5T_C_S1);
   H5Tset_size(vl_string_tid, H5T_VARIABLE);
   H5Tinsert(tid, "dEdx1", (char*)&m_dEdx1 - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   H5Tinsert(tid, "dEdx2", (char*)&m_dEdx2 - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   if (inmemory) {
      HDDM::s_hdf5_memorytype["tofDedx"] = tid;
   }
   else {
      HDDM::s_hdf5_datatype["tofDedx"] = tid;
   }
   if (verbose) {
      size_t slen;
      H5LTdtype_to_text(tid, 0, H5LT_DDL, &slen);
      char *ddlstring = (char*)malloc(slen);
      H5LTdtype_to_text(tid, ddlstring, H5LT_DDL, &slen);
      if (inmemory)
         printf("=== in-memory datatype %ld for %s is:\n %s\n", (long int)tid, "tofDedx", ddlstring);
      else
         printf("=== on-disk datatype %ld for %s is:\n %s\n", (long int)tid, "tofDedx", ddlstring);
      free(ddlstring);
   }
   return tid;
}
void TofDedx::hdf5DataPack()
{
}
void TofDedx::hdf5DataUnpack()
{
}
#endif

std::string TofMatchParams::toString(int indent) {
   std::stringstream ostr;
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "tofMatchParams"
        << " dEdx=" << m_dEdx
        << " deltax=" << m_deltax
        << " deltay=" << m_deltay
        << " ehit=" << m_ehit
        << " hit=" << m_hit
        << " pathlength=" << m_pathlength
        << " tflight=" << m_tflight
        << " tflightvar=" << m_tflightvar
        << " thit=" << m_thit
        << " thitvar=" << m_thitvar
        << " track=" << m_track
             << std::endl;
   if (! m_tofDedx_link.empty()) {
      ostr << m_tofDedx_link.begin()->toString(indent + 2);
   }
   return ostr.str();
}

std::string TofMatchParams::toXML(int indent) {
   std::stringstream ostr;
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "<tofMatchParams"
        << " dEdx=" << "\"" << getDEdx() << "\""
        << " dEdx_unit=" << "\"" << getDEdx_unit() << "\""
        << " deltax=" << "\"" << getDeltax() << "\""
        << " deltay=" << "\"" << getDeltay() << "\""
        << " ehit=" << "\"" << getEhit() << "\""
        << " hit=" << "\"" << getHit() << "\""
        << " lunit=" << "\"" << getLunit() << "\""
        << " pathlength=" << "\"" << getPathlength() << "\""
        << " tflight=" << "\"" << getTflight() << "\""
        << " tflightvar=" << "\"" << getTflightvar() << "\""
        << " thit=" << "\"" << getThit() << "\""
        << " thitvar=" << "\"" << getThitvar() << "\""
        << " track=" << "\"" << getTrack() << "\""
        << " tunit=" << "\"" << getTunit() << "\""
        << ">" << std::endl;
   if (! m_tofDedx_link.empty()) {
      ostr << m_tofDedx_link.begin()->toXML(indent + 2);
   }
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "</tofMatchParams>"
        << std::endl;
   return ostr.str();
}

#ifdef HDF5_SUPPORT
hid_t TofMatchParams::hdf5Datatype(int inmemory, int verbose)
{
   std::string tname("tofMatchParams");
   if (inmemory) {
      if (HDDM::s_hdf5_memorytype.find(tname) != HDDM::s_hdf5_memorytype.end())
         return HDDM::s_hdf5_memorytype[tname];
   }
   else {
      if (HDDM::s_hdf5_datatype.find(tname) != HDDM::s_hdf5_datatype.end())
         return HDDM::s_hdf5_datatype[tname];
   }
   hid_t tid = H5Tcreate(H5T_COMPOUND, sizeof(*this));
   hid_t vl_string_tid = H5Tcopy(H5T_C_S1);
   H5Tset_size(vl_string_tid, H5T_VARIABLE);
   H5Tinsert(tid, "dEdx", (char*)&m_dEdx - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   H5Tinsert(tid, "deltax", (char*)&m_deltax - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   H5Tinsert(tid, "deltay", (char*)&m_deltay - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   H5Tinsert(tid, "ehit", (char*)&m_ehit - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   H5Tinsert(tid, "hit", (char*)&m_hit - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I32LE));
   H5Tinsert(tid, "pathlength", (char*)&m_pathlength - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   H5Tinsert(tid, "tflight", (char*)&m_tflight - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   H5Tinsert(tid, "tflightvar", (char*)&m_tflightvar - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   H5Tinsert(tid, "thit", (char*)&m_thit - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   H5Tinsert(tid, "thitvar", (char*)&m_thitvar - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   H5Tinsert(tid, "track", (char*)&m_track - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I32LE));
   H5Tinsert(tid, "TofDedxList_size", (char*)&m_tofDedx_link.m_size - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   H5Tinsert(tid, "TofDedxList_offset", (char*)&m_tofDedx_link.m_ref - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   if (inmemory) {
      HDDM::s_hdf5_memorytype["tofMatchParams"] = tid;
   }
   else {
      HDDM::s_hdf5_datatype["tofMatchParams"] = tid;
   }
   if (verbose) {
      size_t slen;
      H5LTdtype_to_text(tid, 0, H5LT_DDL, &slen);
      char *ddlstring = (char*)malloc(slen);
      H5LTdtype_to_text(tid, ddlstring, H5LT_DDL, &slen);
      if (inmemory)
         printf("=== in-memory datatype %ld for %s is:\n %s\n", (long int)tid, "tofMatchParams", ddlstring);
      else
         printf("=== on-disk datatype %ld for %s is:\n %s\n", (long int)tid, "tofMatchParams", ddlstring);
      free(ddlstring);
   }
   return tid;
}
void TofMatchParams::hdf5DataPack()
{
   m_tofDedx_link.deflate();
}
void TofMatchParams::hdf5DataUnpack()
{
   {
      std::list<TofDedx*> *host_plist = &m_host->m_tofDedx_plist;
      m_tofDedx_link.inflate(m_host, host_plist, this);
      TofDedxList::iterator iter;
      for (iter = m_tofDedx_link.begin();
           iter != m_tofDedx_link.end(); ++iter)
      {
         iter->hdf5DataUnpack();
      }
   }
}
#endif

std::string ScMatchParams::toString(int indent) {
   std::stringstream ostr;
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "scMatchParams"
        << " dEdx=" << m_dEdx
        << " deltaphi=" << m_deltaphi
        << " ehit=" << m_ehit
        << " hit=" << m_hit
        << " pathlength=" << m_pathlength
        << " tflight=" << m_tflight
        << " tflightvar=" << m_tflightvar
        << " thit=" << m_thit
        << " thitvar=" << m_thitvar
        << " track=" << m_track
             << std::endl;
   return ostr.str();
}

std::string ScMatchParams::toXML(int indent) {
   std::stringstream ostr;
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "<scMatchParams"
        << " Eunit=" << "\"" << getEunit() << "\""
        << " aunit=" << "\"" << getAunit() << "\""
        << " dEdx=" << "\"" << getDEdx() << "\""
        << " dEdx_unit=" << "\"" << getDEdx_unit() << "\""
        << " deltaphi=" << "\"" << getDeltaphi() << "\""
        << " ehit=" << "\"" << getEhit() << "\""
        << " hit=" << "\"" << getHit() << "\""
        << " lunit=" << "\"" << getLunit() << "\""
        << " pathlength=" << "\"" << getPathlength() << "\""
        << " tflight=" << "\"" << getTflight() << "\""
        << " tflightvar=" << "\"" << getTflightvar() << "\""
        << " thit=" << "\"" << getThit() << "\""
        << " thitvar=" << "\"" << getThitvar() << "\""
        << " track=" << "\"" << getTrack() << "\""
        << " tunit=" << "\"" << getTunit() << "\""
        << " />" << std::endl;
   return ostr.str();
}

#ifdef HDF5_SUPPORT
hid_t ScMatchParams::hdf5Datatype(int inmemory, int verbose)
{
   std::string tname("scMatchParams");
   if (inmemory) {
      if (HDDM::s_hdf5_memorytype.find(tname) != HDDM::s_hdf5_memorytype.end())
         return HDDM::s_hdf5_memorytype[tname];
   }
   else {
      if (HDDM::s_hdf5_datatype.find(tname) != HDDM::s_hdf5_datatype.end())
         return HDDM::s_hdf5_datatype[tname];
   }
   hid_t tid = H5Tcreate(H5T_COMPOUND, sizeof(*this));
   hid_t vl_string_tid = H5Tcopy(H5T_C_S1);
   H5Tset_size(vl_string_tid, H5T_VARIABLE);
   H5Tinsert(tid, "dEdx", (char*)&m_dEdx - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   H5Tinsert(tid, "deltaphi", (char*)&m_deltaphi - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   H5Tinsert(tid, "ehit", (char*)&m_ehit - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   H5Tinsert(tid, "hit", (char*)&m_hit - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I32LE));
   H5Tinsert(tid, "pathlength", (char*)&m_pathlength - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   H5Tinsert(tid, "tflight", (char*)&m_tflight - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   H5Tinsert(tid, "tflightvar", (char*)&m_tflightvar - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   H5Tinsert(tid, "thit", (char*)&m_thit - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   H5Tinsert(tid, "thitvar", (char*)&m_thitvar - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   H5Tinsert(tid, "track", (char*)&m_track - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I32LE));
   if (inmemory) {
      HDDM::s_hdf5_memorytype["scMatchParams"] = tid;
   }
   else {
      HDDM::s_hdf5_datatype["scMatchParams"] = tid;
   }
   if (verbose) {
      size_t slen;
      H5LTdtype_to_text(tid, 0, H5LT_DDL, &slen);
      char *ddlstring = (char*)malloc(slen);
      H5LTdtype_to_text(tid, ddlstring, H5LT_DDL, &slen);
      if (inmemory)
         printf("=== in-memory datatype %ld for %s is:\n %s\n", (long int)tid, "scMatchParams", ddlstring);
      else
         printf("=== on-disk datatype %ld for %s is:\n %s\n", (long int)tid, "scMatchParams", ddlstring);
      free(ddlstring);
   }
   return tid;
}
void ScMatchParams::hdf5DataPack()
{
}
void ScMatchParams::hdf5DataUnpack()
{
}
#endif

std::string DircMatchParams::toString(int indent) {
   std::stringstream ostr;
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "dircMatchParams"
        << " deltat=" << m_deltat
        << " expectthetac=" << m_expectthetac
        << " lele=" << m_lele
        << " lk=" << m_lk
        << " lp=" << m_lp
        << " lpi=" << m_lpi
        << " nphotons=" << m_nphotons
        << " px=" << m_px
        << " py=" << m_py
        << " pz=" << m_pz
        << " t=" << m_t
        << " thetac=" << m_thetac
        << " track=" << m_track
        << " x=" << m_x
        << " y=" << m_y
        << " z=" << m_z
             << std::endl;
   return ostr.str();
}

std::string DircMatchParams::toXML(int indent) {
   std::stringstream ostr;
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "<dircMatchParams"
        << " deltat=" << "\"" << getDeltat() << "\""
        << " expectthetac=" << "\"" << getExpectthetac() << "\""
        << " lele=" << "\"" << getLele() << "\""
        << " lk=" << "\"" << getLk() << "\""
        << " lp=" << "\"" << getLp() << "\""
        << " lpi=" << "\"" << getLpi() << "\""
        << " nphotons=" << "\"" << getNphotons() << "\""
        << " px=" << "\"" << getPx() << "\""
        << " py=" << "\"" << getPy() << "\""
        << " pz=" << "\"" << getPz() << "\""
        << " t=" << "\"" << getT() << "\""
        << " thetac=" << "\"" << getThetac() << "\""
        << " track=" << "\"" << getTrack() << "\""
        << " x=" << "\"" << getX() << "\""
        << " y=" << "\"" << getY() << "\""
        << " z=" << "\"" << getZ() << "\""
        << " />" << std::endl;
   return ostr.str();
}

#ifdef HDF5_SUPPORT
hid_t DircMatchParams::hdf5Datatype(int inmemory, int verbose)
{
   std::string tname("dircMatchParams");
   if (inmemory) {
      if (HDDM::s_hdf5_memorytype.find(tname) != HDDM::s_hdf5_memorytype.end())
         return HDDM::s_hdf5_memorytype[tname];
   }
   else {
      if (HDDM::s_hdf5_datatype.find(tname) != HDDM::s_hdf5_datatype.end())
         return HDDM::s_hdf5_datatype[tname];
   }
   hid_t tid = H5Tcreate(H5T_COMPOUND, sizeof(*this));
   hid_t vl_string_tid = H5Tcopy(H5T_C_S1);
   H5Tset_size(vl_string_tid, H5T_VARIABLE);
   H5Tinsert(tid, "deltat", (char*)&m_deltat - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   H5Tinsert(tid, "expectthetac", (char*)&m_expectthetac - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   H5Tinsert(tid, "lele", (char*)&m_lele - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   H5Tinsert(tid, "lk", (char*)&m_lk - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   H5Tinsert(tid, "lp", (char*)&m_lp - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   H5Tinsert(tid, "lpi", (char*)&m_lpi - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   H5Tinsert(tid, "nphotons", (char*)&m_nphotons - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I32LE));
   H5Tinsert(tid, "px", (char*)&m_px - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   H5Tinsert(tid, "py", (char*)&m_py - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   H5Tinsert(tid, "pz", (char*)&m_pz - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   H5Tinsert(tid, "t", (char*)&m_t - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   H5Tinsert(tid, "thetac", (char*)&m_thetac - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   H5Tinsert(tid, "track", (char*)&m_track - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I32LE));
   H5Tinsert(tid, "x", (char*)&m_x - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   H5Tinsert(tid, "y", (char*)&m_y - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   H5Tinsert(tid, "z", (char*)&m_z - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   if (inmemory) {
      HDDM::s_hdf5_memorytype["dircMatchParams"] = tid;
   }
   else {
      HDDM::s_hdf5_datatype["dircMatchParams"] = tid;
   }
   if (verbose) {
      size_t slen;
      H5LTdtype_to_text(tid, 0, H5LT_DDL, &slen);
      char *ddlstring = (char*)malloc(slen);
      H5LTdtype_to_text(tid, ddlstring, H5LT_DDL, &slen);
      if (inmemory)
         printf("=== in-memory datatype %ld for %s is:\n %s\n", (long int)tid, "dircMatchParams", ddlstring);
      else
         printf("=== on-disk datatype %ld for %s is:\n %s\n", (long int)tid, "dircMatchParams", ddlstring);
      free(ddlstring);
   }
   return tid;
}
void DircMatchParams::hdf5DataPack()
{
}
void DircMatchParams::hdf5DataUnpack()
{
}
#endif

std::string DircMatchHit::toString(int indent) {
   std::stringstream ostr;
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "dircMatchHit"
        << " hit=" << m_hit
        << " track=" << m_track
             << std::endl;
   return ostr.str();
}

std::string DircMatchHit::toXML(int indent) {
   std::stringstream ostr;
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "<dircMatchHit"
        << " hit=" << "\"" << getHit() << "\""
        << " track=" << "\"" << getTrack() << "\""
        << " />" << std::endl;
   return ostr.str();
}

#ifdef HDF5_SUPPORT
hid_t DircMatchHit::hdf5Datatype(int inmemory, int verbose)
{
   std::string tname("dircMatchHit");
   if (inmemory) {
      if (HDDM::s_hdf5_memorytype.find(tname) != HDDM::s_hdf5_memorytype.end())
         return HDDM::s_hdf5_memorytype[tname];
   }
   else {
      if (HDDM::s_hdf5_datatype.find(tname) != HDDM::s_hdf5_datatype.end())
         return HDDM::s_hdf5_datatype[tname];
   }
   hid_t tid = H5Tcreate(H5T_COMPOUND, sizeof(*this));
   hid_t vl_string_tid = H5Tcopy(H5T_C_S1);
   H5Tset_size(vl_string_tid, H5T_VARIABLE);
   H5Tinsert(tid, "hit", (char*)&m_hit - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I32LE));
   H5Tinsert(tid, "track", (char*)&m_track - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I32LE));
   if (inmemory) {
      HDDM::s_hdf5_memorytype["dircMatchHit"] = tid;
   }
   else {
      HDDM::s_hdf5_datatype["dircMatchHit"] = tid;
   }
   if (verbose) {
      size_t slen;
      H5LTdtype_to_text(tid, 0, H5LT_DDL, &slen);
      char *ddlstring = (char*)malloc(slen);
      H5LTdtype_to_text(tid, ddlstring, H5LT_DDL, &slen);
      if (inmemory)
         printf("=== in-memory datatype %ld for %s is:\n %s\n", (long int)tid, "dircMatchHit", ddlstring);
      else
         printf("=== on-disk datatype %ld for %s is:\n %s\n", (long int)tid, "dircMatchHit", ddlstring);
      free(ddlstring);
   }
   return tid;
}
void DircMatchHit::hdf5DataPack()
{
}
void DircMatchHit::hdf5DataUnpack()
{
}
#endif

std::string BcalDOCAtoTrack::toString(int indent) {
   std::stringstream ostr;
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "bcalDOCAtoTrack"
        << " deltaphi=" << m_deltaphi
        << " deltaz=" << m_deltaz
        << " shower=" << m_shower
             << std::endl;
   return ostr.str();
}

std::string BcalDOCAtoTrack::toXML(int indent) {
   std::stringstream ostr;
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "<bcalDOCAtoTrack"
        << " deltaphi=" << "\"" << getDeltaphi() << "\""
        << " deltaz=" << "\"" << getDeltaz() << "\""
        << " lunit=" << "\"" << getLunit() << "\""
        << " shower=" << "\"" << getShower() << "\""
        << " />" << std::endl;
   return ostr.str();
}

#ifdef HDF5_SUPPORT
hid_t BcalDOCAtoTrack::hdf5Datatype(int inmemory, int verbose)
{
   std::string tname("bcalDOCAtoTrack");
   if (inmemory) {
      if (HDDM::s_hdf5_memorytype.find(tname) != HDDM::s_hdf5_memorytype.end())
         return HDDM::s_hdf5_memorytype[tname];
   }
   else {
      if (HDDM::s_hdf5_datatype.find(tname) != HDDM::s_hdf5_datatype.end())
         return HDDM::s_hdf5_datatype[tname];
   }
   hid_t tid = H5Tcreate(H5T_COMPOUND, sizeof(*this));
   hid_t vl_string_tid = H5Tcopy(H5T_C_S1);
   H5Tset_size(vl_string_tid, H5T_VARIABLE);
   H5Tinsert(tid, "deltaphi", (char*)&m_deltaphi - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   H5Tinsert(tid, "deltaz", (char*)&m_deltaz - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   H5Tinsert(tid, "shower", (char*)&m_shower - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I32LE));
   if (inmemory) {
      HDDM::s_hdf5_memorytype["bcalDOCAtoTrack"] = tid;
   }
   else {
      HDDM::s_hdf5_datatype["bcalDOCAtoTrack"] = tid;
   }
   if (verbose) {
      size_t slen;
      H5LTdtype_to_text(tid, 0, H5LT_DDL, &slen);
      char *ddlstring = (char*)malloc(slen);
      H5LTdtype_to_text(tid, ddlstring, H5LT_DDL, &slen);
      if (inmemory)
         printf("=== in-memory datatype %ld for %s is:\n %s\n", (long int)tid, "bcalDOCAtoTrack", ddlstring);
      else
         printf("=== on-disk datatype %ld for %s is:\n %s\n", (long int)tid, "bcalDOCAtoTrack", ddlstring);
      free(ddlstring);
   }
   return tid;
}
void BcalDOCAtoTrack::hdf5DataPack()
{
}
void BcalDOCAtoTrack::hdf5DataUnpack()
{
}
#endif

std::string FcalDOCAtoTrack::toString(int indent) {
   std::stringstream ostr;
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "fcalDOCAtoTrack"
        << " doca=" << m_doca
        << " shower=" << m_shower
             << std::endl;
   return ostr.str();
}

std::string FcalDOCAtoTrack::toXML(int indent) {
   std::stringstream ostr;
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "<fcalDOCAtoTrack"
        << " doca=" << "\"" << getDoca() << "\""
        << " lunit=" << "\"" << getLunit() << "\""
        << " shower=" << "\"" << getShower() << "\""
        << " />" << std::endl;
   return ostr.str();
}

#ifdef HDF5_SUPPORT
hid_t FcalDOCAtoTrack::hdf5Datatype(int inmemory, int verbose)
{
   std::string tname("fcalDOCAtoTrack");
   if (inmemory) {
      if (HDDM::s_hdf5_memorytype.find(tname) != HDDM::s_hdf5_memorytype.end())
         return HDDM::s_hdf5_memorytype[tname];
   }
   else {
      if (HDDM::s_hdf5_datatype.find(tname) != HDDM::s_hdf5_datatype.end())
         return HDDM::s_hdf5_datatype[tname];
   }
   hid_t tid = H5Tcreate(H5T_COMPOUND, sizeof(*this));
   hid_t vl_string_tid = H5Tcopy(H5T_C_S1);
   H5Tset_size(vl_string_tid, H5T_VARIABLE);
   H5Tinsert(tid, "doca", (char*)&m_doca - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   H5Tinsert(tid, "shower", (char*)&m_shower - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I32LE));
   if (inmemory) {
      HDDM::s_hdf5_memorytype["fcalDOCAtoTrack"] = tid;
   }
   else {
      HDDM::s_hdf5_datatype["fcalDOCAtoTrack"] = tid;
   }
   if (verbose) {
      size_t slen;
      H5LTdtype_to_text(tid, 0, H5LT_DDL, &slen);
      char *ddlstring = (char*)malloc(slen);
      H5LTdtype_to_text(tid, ddlstring, H5LT_DDL, &slen);
      if (inmemory)
         printf("=== in-memory datatype %ld for %s is:\n %s\n", (long int)tid, "fcalDOCAtoTrack", ddlstring);
      else
         printf("=== on-disk datatype %ld for %s is:\n %s\n", (long int)tid, "fcalDOCAtoTrack", ddlstring);
      free(ddlstring);
   }
   return tid;
}
void FcalDOCAtoTrack::hdf5DataPack()
{
}
void FcalDOCAtoTrack::hdf5DataUnpack()
{
}
#endif

std::string TflightPCorrelation::toString(int indent) {
   std::stringstream ostr;
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "tflightPCorrelation"
        << " correlation=" << m_correlation
        << " system=" << m_system
        << " track=" << m_track
             << std::endl;
   return ostr.str();
}

std::string TflightPCorrelation::toXML(int indent) {
   std::stringstream ostr;
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "<tflightPCorrelation"
        << " correlation=" << "\"" << getCorrelation() << "\""
        << " punit=" << "\"" << getPunit() << "\""
        << " system=" << "\"" << getSystem() << "\""
        << " track=" << "\"" << getTrack() << "\""
        << " tunit=" << "\"" << getTunit() << "\""
        << " />" << std::endl;
   return ostr.str();
}

#ifdef HDF5_SUPPORT
hid_t TflightPCorrelation::hdf5Datatype(int inmemory, int verbose)
{
   std::string tname("tflightPCorrelation");
   if (inmemory) {
      if (HDDM::s_hdf5_memorytype.find(tname) != HDDM::s_hdf5_memorytype.end())
         return HDDM::s_hdf5_memorytype[tname];
   }
   else {
      if (HDDM::s_hdf5_datatype.find(tname) != HDDM::s_hdf5_datatype.end())
         return HDDM::s_hdf5_datatype[tname];
   }
   hid_t tid = H5Tcreate(H5T_COMPOUND, sizeof(*this));
   hid_t vl_string_tid = H5Tcopy(H5T_C_S1);
   H5Tset_size(vl_string_tid, H5T_VARIABLE);
   H5Tinsert(tid, "correlation", (char*)&m_correlation - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   H5Tinsert(tid, "system", (char*)&m_system - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I32LE));
   H5Tinsert(tid, "track", (char*)&m_track - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I32LE));
   if (inmemory) {
      HDDM::s_hdf5_memorytype["tflightPCorrelation"] = tid;
   }
   else {
      HDDM::s_hdf5_datatype["tflightPCorrelation"] = tid;
   }
   if (verbose) {
      size_t slen;
      H5LTdtype_to_text(tid, 0, H5LT_DDL, &slen);
      char *ddlstring = (char*)malloc(slen);
      H5LTdtype_to_text(tid, ddlstring, H5LT_DDL, &slen);
      if (inmemory)
         printf("=== in-memory datatype %ld for %s is:\n %s\n", (long int)tid, "tflightPCorrelation", ddlstring);
      else
         printf("=== on-disk datatype %ld for %s is:\n %s\n", (long int)tid, "tflightPCorrelation", ddlstring);
      free(ddlstring);
   }
   return tid;
}
void TflightPCorrelation::hdf5DataPack()
{
}
void TflightPCorrelation::hdf5DataUnpack()
{
}
#endif

std::string DetectorMatches::toString(int indent) {
   std::stringstream ostr;
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "detectorMatches"
        << " jtag=" << "\"" << m_jtag << "\""
             << std::endl;
   int BcalMatchParamsListCount=0;
   for (BcalMatchParamsList::iterator it = m_bcalMatchParams_list.begin();
        it != m_bcalMatchParams_list.end(); ++it)
   {
      if (++BcalMatchParamsListCount > m_bcalMatchParams_list.size()) {
         throw std::runtime_error("hddm_r::toString error - list improperly terminated!");
      }
      ostr << it->toString(indent + 2);
   }
   int FcalMatchParamsListCount=0;
   for (FcalMatchParamsList::iterator it = m_fcalMatchParams_list.begin();
        it != m_fcalMatchParams_list.end(); ++it)
   {
      if (++FcalMatchParamsListCount > m_fcalMatchParams_list.size()) {
         throw std::runtime_error("hddm_r::toString error - list improperly terminated!");
      }
      ostr << it->toString(indent + 2);
   }
   int FcalSingleHitMatchParamsListCount=0;
   for (FcalSingleHitMatchParamsList::iterator it = m_fcalSingleHitMatchParams_list.begin();
        it != m_fcalSingleHitMatchParams_list.end(); ++it)
   {
      if (++FcalSingleHitMatchParamsListCount > m_fcalSingleHitMatchParams_list.size()) {
         throw std::runtime_error("hddm_r::toString error - list improperly terminated!");
      }
      ostr << it->toString(indent + 2);
   }
   int CtofMatchParamsListCount=0;
   for (CtofMatchParamsList::iterator it = m_ctofMatchParams_list.begin();
        it != m_ctofMatchParams_list.end(); ++it)
   {
      if (++CtofMatchParamsListCount > m_ctofMatchParams_list.size()) {
         throw std::runtime_error("hddm_r::toString error - list improperly terminated!");
      }
      ostr << it->toString(indent + 2);
   }
   int FmwpcMatchParamsListCount=0;
   for (FmwpcMatchParamsList::iterator it = m_fmwpcMatchParams_list.begin();
        it != m_fmwpcMatchParams_list.end(); ++it)
   {
      if (++FmwpcMatchParamsListCount > m_fmwpcMatchParams_list.size()) {
         throw std::runtime_error("hddm_r::toString error - list improperly terminated!");
      }
      ostr << it->toString(indent + 2);
   }
   int TofMatchParamsListCount=0;
   for (TofMatchParamsList::iterator it = m_tofMatchParams_list.begin();
        it != m_tofMatchParams_list.end(); ++it)
   {
      if (++TofMatchParamsListCount > m_tofMatchParams_list.size()) {
         throw std::runtime_error("hddm_r::toString error - list improperly terminated!");
      }
      ostr << it->toString(indent + 2);
   }
   int ScMatchParamsListCount=0;
   for (ScMatchParamsList::iterator it = m_scMatchParams_list.begin();
        it != m_scMatchParams_list.end(); ++it)
   {
      if (++ScMatchParamsListCount > m_scMatchParams_list.size()) {
         throw std::runtime_error("hddm_r::toString error - list improperly terminated!");
      }
      ostr << it->toString(indent + 2);
   }
   int DircMatchParamsListCount=0;
   for (DircMatchParamsList::iterator it = m_dircMatchParams_list.begin();
        it != m_dircMatchParams_list.end(); ++it)
   {
      if (++DircMatchParamsListCount > m_dircMatchParams_list.size()) {
         throw std::runtime_error("hddm_r::toString error - list improperly terminated!");
      }
      ostr << it->toString(indent + 2);
   }
   int DircMatchHitListCount=0;
   for (DircMatchHitList::iterator it = m_dircMatchHit_list.begin();
        it != m_dircMatchHit_list.end(); ++it)
   {
      if (++DircMatchHitListCount > m_dircMatchHit_list.size()) {
         throw std::runtime_error("hddm_r::toString error - list improperly terminated!");
      }
      ostr << it->toString(indent + 2);
   }
   int BcalDOCAtoTrackListCount=0;
   for (BcalDOCAtoTrackList::iterator it = m_bcalDOCAtoTrack_list.begin();
        it != m_bcalDOCAtoTrack_list.end(); ++it)
   {
      if (++BcalDOCAtoTrackListCount > m_bcalDOCAtoTrack_list.size()) {
         throw std::runtime_error("hddm_r::toString error - list improperly terminated!");
      }
      ostr << it->toString(indent + 2);
   }
   int FcalDOCAtoTrackListCount=0;
   for (FcalDOCAtoTrackList::iterator it = m_fcalDOCAtoTrack_list.begin();
        it != m_fcalDOCAtoTrack_list.end(); ++it)
   {
      if (++FcalDOCAtoTrackListCount > m_fcalDOCAtoTrack_list.size()) {
         throw std::runtime_error("hddm_r::toString error - list improperly terminated!");
      }
      ostr << it->toString(indent + 2);
   }
   int TflightPCorrelationListCount=0;
   for (TflightPCorrelationList::iterator it = m_tflightPCorrelation_list.begin();
        it != m_tflightPCorrelation_list.end(); ++it)
   {
      if (++TflightPCorrelationListCount > m_tflightPCorrelation_list.size()) {
         throw std::runtime_error("hddm_r::toString error - list improperly terminated!");
      }
      ostr << it->toString(indent + 2);
   }
   return ostr.str();
}

std::string DetectorMatches::toXML(int indent) {
   std::stringstream ostr;
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "<detectorMatches"
        << " jtag=" << "\"" << getJtag() << "\""
        << ">" << std::endl;
   int BcalMatchParamsListCount=0;
   for (BcalMatchParamsList::iterator it = m_bcalMatchParams_list.begin();
        it != m_bcalMatchParams_list.end(); ++it)
   {
      if (++BcalMatchParamsListCount > m_bcalMatchParams_list.size()) {
         throw std::runtime_error("hddm_r::toXML error - list improperly terminated!");
      }
      ostr << it->toXML(indent + 2);
   }
   int FcalMatchParamsListCount=0;
   for (FcalMatchParamsList::iterator it = m_fcalMatchParams_list.begin();
        it != m_fcalMatchParams_list.end(); ++it)
   {
      if (++FcalMatchParamsListCount > m_fcalMatchParams_list.size()) {
         throw std::runtime_error("hddm_r::toXML error - list improperly terminated!");
      }
      ostr << it->toXML(indent + 2);
   }
   int FcalSingleHitMatchParamsListCount=0;
   for (FcalSingleHitMatchParamsList::iterator it = m_fcalSingleHitMatchParams_list.begin();
        it != m_fcalSingleHitMatchParams_list.end(); ++it)
   {
      if (++FcalSingleHitMatchParamsListCount > m_fcalSingleHitMatchParams_list.size()) {
         throw std::runtime_error("hddm_r::toXML error - list improperly terminated!");
      }
      ostr << it->toXML(indent + 2);
   }
   int CtofMatchParamsListCount=0;
   for (CtofMatchParamsList::iterator it = m_ctofMatchParams_list.begin();
        it != m_ctofMatchParams_list.end(); ++it)
   {
      if (++CtofMatchParamsListCount > m_ctofMatchParams_list.size()) {
         throw std::runtime_error("hddm_r::toXML error - list improperly terminated!");
      }
      ostr << it->toXML(indent + 2);
   }
   int FmwpcMatchParamsListCount=0;
   for (FmwpcMatchParamsList::iterator it = m_fmwpcMatchParams_list.begin();
        it != m_fmwpcMatchParams_list.end(); ++it)
   {
      if (++FmwpcMatchParamsListCount > m_fmwpcMatchParams_list.size()) {
         throw std::runtime_error("hddm_r::toXML error - list improperly terminated!");
      }
      ostr << it->toXML(indent + 2);
   }
   int TofMatchParamsListCount=0;
   for (TofMatchParamsList::iterator it = m_tofMatchParams_list.begin();
        it != m_tofMatchParams_list.end(); ++it)
   {
      if (++TofMatchParamsListCount > m_tofMatchParams_list.size()) {
         throw std::runtime_error("hddm_r::toXML error - list improperly terminated!");
      }
      ostr << it->toXML(indent + 2);
   }
   int ScMatchParamsListCount=0;
   for (ScMatchParamsList::iterator it = m_scMatchParams_list.begin();
        it != m_scMatchParams_list.end(); ++it)
   {
      if (++ScMatchParamsListCount > m_scMatchParams_list.size()) {
         throw std::runtime_error("hddm_r::toXML error - list improperly terminated!");
      }
      ostr << it->toXML(indent + 2);
   }
   int DircMatchParamsListCount=0;
   for (DircMatchParamsList::iterator it = m_dircMatchParams_list.begin();
        it != m_dircMatchParams_list.end(); ++it)
   {
      if (++DircMatchParamsListCount > m_dircMatchParams_list.size()) {
         throw std::runtime_error("hddm_r::toXML error - list improperly terminated!");
      }
      ostr << it->toXML(indent + 2);
   }
   int DircMatchHitListCount=0;
   for (DircMatchHitList::iterator it = m_dircMatchHit_list.begin();
        it != m_dircMatchHit_list.end(); ++it)
   {
      if (++DircMatchHitListCount > m_dircMatchHit_list.size()) {
         throw std::runtime_error("hddm_r::toXML error - list improperly terminated!");
      }
      ostr << it->toXML(indent + 2);
   }
   int BcalDOCAtoTrackListCount=0;
   for (BcalDOCAtoTrackList::iterator it = m_bcalDOCAtoTrack_list.begin();
        it != m_bcalDOCAtoTrack_list.end(); ++it)
   {
      if (++BcalDOCAtoTrackListCount > m_bcalDOCAtoTrack_list.size()) {
         throw std::runtime_error("hddm_r::toXML error - list improperly terminated!");
      }
      ostr << it->toXML(indent + 2);
   }
   int FcalDOCAtoTrackListCount=0;
   for (FcalDOCAtoTrackList::iterator it = m_fcalDOCAtoTrack_list.begin();
        it != m_fcalDOCAtoTrack_list.end(); ++it)
   {
      if (++FcalDOCAtoTrackListCount > m_fcalDOCAtoTrack_list.size()) {
         throw std::runtime_error("hddm_r::toXML error - list improperly terminated!");
      }
      ostr << it->toXML(indent + 2);
   }
   int TflightPCorrelationListCount=0;
   for (TflightPCorrelationList::iterator it = m_tflightPCorrelation_list.begin();
        it != m_tflightPCorrelation_list.end(); ++it)
   {
      if (++TflightPCorrelationListCount > m_tflightPCorrelation_list.size()) {
         throw std::runtime_error("hddm_r::toXML error - list improperly terminated!");
      }
      ostr << it->toXML(indent + 2);
   }
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "</detectorMatches>"
        << std::endl;
   return ostr.str();
}

#ifdef HDF5_SUPPORT
hid_t DetectorMatches::hdf5Datatype(int inmemory, int verbose)
{
   std::string tname("detectorMatches");
   if (inmemory) {
      if (HDDM::s_hdf5_memorytype.find(tname) != HDDM::s_hdf5_memorytype.end())
         return HDDM::s_hdf5_memorytype[tname];
   }
   else {
      if (HDDM::s_hdf5_datatype.find(tname) != HDDM::s_hdf5_datatype.end())
         return HDDM::s_hdf5_datatype[tname];
   }
   hid_t tid = H5Tcreate(H5T_COMPOUND, sizeof(*this));
   hid_t vl_string_tid = H5Tcopy(H5T_C_S1);
   H5Tset_size(vl_string_tid, H5T_VARIABLE);
   H5Tinsert(tid, "jtag", (char*)&mx_jtag - (char*)this, vl_string_tid);
   H5Tinsert(tid, "BcalMatchParamsList_size", (char*)&m_bcalMatchParams_list.m_size - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   H5Tinsert(tid, "BcalMatchParamsList_offset", (char*)&m_bcalMatchParams_list.m_ref - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   H5Tinsert(tid, "FcalMatchParamsList_size", (char*)&m_fcalMatchParams_list.m_size - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   H5Tinsert(tid, "FcalMatchParamsList_offset", (char*)&m_fcalMatchParams_list.m_ref - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   H5Tinsert(tid, "FcalSingleHitMatchParamsList_size", (char*)&m_fcalSingleHitMatchParams_list.m_size - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   H5Tinsert(tid, "FcalSingleHitMatchParamsList_offset", (char*)&m_fcalSingleHitMatchParams_list.m_ref - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   H5Tinsert(tid, "CtofMatchParamsList_size", (char*)&m_ctofMatchParams_list.m_size - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   H5Tinsert(tid, "CtofMatchParamsList_offset", (char*)&m_ctofMatchParams_list.m_ref - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   H5Tinsert(tid, "FmwpcMatchParamsList_size", (char*)&m_fmwpcMatchParams_list.m_size - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   H5Tinsert(tid, "FmwpcMatchParamsList_offset", (char*)&m_fmwpcMatchParams_list.m_ref - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   H5Tinsert(tid, "TofMatchParamsList_size", (char*)&m_tofMatchParams_list.m_size - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   H5Tinsert(tid, "TofMatchParamsList_offset", (char*)&m_tofMatchParams_list.m_ref - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   H5Tinsert(tid, "ScMatchParamsList_size", (char*)&m_scMatchParams_list.m_size - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   H5Tinsert(tid, "ScMatchParamsList_offset", (char*)&m_scMatchParams_list.m_ref - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   H5Tinsert(tid, "DircMatchParamsList_size", (char*)&m_dircMatchParams_list.m_size - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   H5Tinsert(tid, "DircMatchParamsList_offset", (char*)&m_dircMatchParams_list.m_ref - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   H5Tinsert(tid, "DircMatchHitList_size", (char*)&m_dircMatchHit_list.m_size - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   H5Tinsert(tid, "DircMatchHitList_offset", (char*)&m_dircMatchHit_list.m_ref - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   H5Tinsert(tid, "BcalDOCAtoTrackList_size", (char*)&m_bcalDOCAtoTrack_list.m_size - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   H5Tinsert(tid, "BcalDOCAtoTrackList_offset", (char*)&m_bcalDOCAtoTrack_list.m_ref - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   H5Tinsert(tid, "FcalDOCAtoTrackList_size", (char*)&m_fcalDOCAtoTrack_list.m_size - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   H5Tinsert(tid, "FcalDOCAtoTrackList_offset", (char*)&m_fcalDOCAtoTrack_list.m_ref - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   H5Tinsert(tid, "TflightPCorrelationList_size", (char*)&m_tflightPCorrelation_list.m_size - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   H5Tinsert(tid, "TflightPCorrelationList_offset", (char*)&m_tflightPCorrelation_list.m_ref - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   if (inmemory) {
      HDDM::s_hdf5_memorytype["detectorMatches"] = tid;
   }
   else {
      HDDM::s_hdf5_datatype["detectorMatches"] = tid;
   }
   if (verbose) {
      size_t slen;
      H5LTdtype_to_text(tid, 0, H5LT_DDL, &slen);
      char *ddlstring = (char*)malloc(slen);
      H5LTdtype_to_text(tid, ddlstring, H5LT_DDL, &slen);
      if (inmemory)
         printf("=== in-memory datatype %ld for %s is:\n %s\n", (long int)tid, "detectorMatches", ddlstring);
      else
         printf("=== on-disk datatype %ld for %s is:\n %s\n", (long int)tid, "detectorMatches", ddlstring);
      free(ddlstring);
   }
   return tid;
}
void DetectorMatches::hdf5DataPack()
{
   mx_jtag = m_jtag.c_str();
   m_bcalMatchParams_list.deflate();
   m_fcalMatchParams_list.deflate();
   m_fcalSingleHitMatchParams_list.deflate();
   m_ctofMatchParams_list.deflate();
   m_fmwpcMatchParams_list.deflate();
   m_tofMatchParams_list.deflate();
   m_scMatchParams_list.deflate();
   m_dircMatchParams_list.deflate();
   m_dircMatchHit_list.deflate();
   m_bcalDOCAtoTrack_list.deflate();
   m_fcalDOCAtoTrack_list.deflate();
   m_tflightPCorrelation_list.deflate();
}
void DetectorMatches::hdf5DataUnpack()
{
   new(&m_jtag) std::string();
   if (mx_jtag != 0) {
      m_jtag = mx_jtag;
      m_host->m_hdf5_strings.push_back(&m_jtag);
   }
   {
      std::list<BcalMatchParams*> *host_plist = &m_host->m_bcalMatchParams_plist;
      m_bcalMatchParams_list.inflate(m_host, host_plist, this);
      BcalMatchParamsList::iterator iter;
      for (iter = m_bcalMatchParams_list.begin();
           iter != m_bcalMatchParams_list.end(); ++iter)
      {
         iter->hdf5DataUnpack();
      }
   }
   {
      std::list<FcalMatchParams*> *host_plist = &m_host->m_fcalMatchParams_plist;
      m_fcalMatchParams_list.inflate(m_host, host_plist, this);
      FcalMatchParamsList::iterator iter;
      for (iter = m_fcalMatchParams_list.begin();
           iter != m_fcalMatchParams_list.end(); ++iter)
      {
         iter->hdf5DataUnpack();
      }
   }
   {
      std::list<FcalSingleHitMatchParams*> *host_plist = &m_host->m_fcalSingleHitMatchParams_plist;
      m_fcalSingleHitMatchParams_list.inflate(m_host, host_plist, this);
      FcalSingleHitMatchParamsList::iterator iter;
      for (iter = m_fcalSingleHitMatchParams_list.begin();
           iter != m_fcalSingleHitMatchParams_list.end(); ++iter)
      {
         iter->hdf5DataUnpack();
      }
   }
   {
      std::list<CtofMatchParams*> *host_plist = &m_host->m_ctofMatchParams_plist;
      m_ctofMatchParams_list.inflate(m_host, host_plist, this);
      CtofMatchParamsList::iterator iter;
      for (iter = m_ctofMatchParams_list.begin();
           iter != m_ctofMatchParams_list.end(); ++iter)
      {
         iter->hdf5DataUnpack();
      }
   }
   {
      std::list<FmwpcMatchParams*> *host_plist = &m_host->m_fmwpcMatchParams_plist;
      m_fmwpcMatchParams_list.inflate(m_host, host_plist, this);
      FmwpcMatchParamsList::iterator iter;
      for (iter = m_fmwpcMatchParams_list.begin();
           iter != m_fmwpcMatchParams_list.end(); ++iter)
      {
         iter->hdf5DataUnpack();
      }
   }
   {
      std::list<TofMatchParams*> *host_plist = &m_host->m_tofMatchParams_plist;
      m_tofMatchParams_list.inflate(m_host, host_plist, this);
      TofMatchParamsList::iterator iter;
      for (iter = m_tofMatchParams_list.begin();
           iter != m_tofMatchParams_list.end(); ++iter)
      {
         iter->hdf5DataUnpack();
      }
   }
   {
      std::list<ScMatchParams*> *host_plist = &m_host->m_scMatchParams_plist;
      m_scMatchParams_list.inflate(m_host, host_plist, this);
      ScMatchParamsList::iterator iter;
      for (iter = m_scMatchParams_list.begin();
           iter != m_scMatchParams_list.end(); ++iter)
      {
         iter->hdf5DataUnpack();
      }
   }
   {
      std::list<DircMatchParams*> *host_plist = &m_host->m_dircMatchParams_plist;
      m_dircMatchParams_list.inflate(m_host, host_plist, this);
      DircMatchParamsList::iterator iter;
      for (iter = m_dircMatchParams_list.begin();
           iter != m_dircMatchParams_list.end(); ++iter)
      {
         iter->hdf5DataUnpack();
      }
   }
   {
      std::list<DircMatchHit*> *host_plist = &m_host->m_dircMatchHit_plist;
      m_dircMatchHit_list.inflate(m_host, host_plist, this);
      DircMatchHitList::iterator iter;
      for (iter = m_dircMatchHit_list.begin();
           iter != m_dircMatchHit_list.end(); ++iter)
      {
         iter->hdf5DataUnpack();
      }
   }
   {
      std::list<BcalDOCAtoTrack*> *host_plist = &m_host->m_bcalDOCAtoTrack_plist;
      m_bcalDOCAtoTrack_list.inflate(m_host, host_plist, this);
      BcalDOCAtoTrackList::iterator iter;
      for (iter = m_bcalDOCAtoTrack_list.begin();
           iter != m_bcalDOCAtoTrack_list.end(); ++iter)
      {
         iter->hdf5DataUnpack();
      }
   }
   {
      std::list<FcalDOCAtoTrack*> *host_plist = &m_host->m_fcalDOCAtoTrack_plist;
      m_fcalDOCAtoTrack_list.inflate(m_host, host_plist, this);
      FcalDOCAtoTrackList::iterator iter;
      for (iter = m_fcalDOCAtoTrack_list.begin();
           iter != m_fcalDOCAtoTrack_list.end(); ++iter)
      {
         iter->hdf5DataUnpack();
      }
   }
   {
      std::list<TflightPCorrelation*> *host_plist = &m_host->m_tflightPCorrelation_plist;
      m_tflightPCorrelation_list.inflate(m_host, host_plist, this);
      TflightPCorrelationList::iterator iter;
      for (iter = m_tflightPCorrelation_list.begin();
           iter != m_tflightPCorrelation_list.end(); ++iter)
      {
         iter->hdf5DataUnpack();
      }
   }
}
#endif

std::string StartCounters::toString(int indent) {
   std::stringstream ostr;
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "startCounters"
        << " count=" << m_count
             << std::endl;
   return ostr.str();
}

std::string StartCounters::toXML(int indent) {
   std::stringstream ostr;
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "<startCounters"
        << " count=" << "\"" << getCount() << "\""
        << " />" << std::endl;
   return ostr.str();
}

#ifdef HDF5_SUPPORT
hid_t StartCounters::hdf5Datatype(int inmemory, int verbose)
{
   std::string tname("startCounters");
   if (inmemory) {
      if (HDDM::s_hdf5_memorytype.find(tname) != HDDM::s_hdf5_memorytype.end())
         return HDDM::s_hdf5_memorytype[tname];
   }
   else {
      if (HDDM::s_hdf5_datatype.find(tname) != HDDM::s_hdf5_datatype.end())
         return HDDM::s_hdf5_datatype[tname];
   }
   hid_t tid = H5Tcreate(H5T_COMPOUND, sizeof(*this));
   hid_t vl_string_tid = H5Tcopy(H5T_C_S1);
   H5Tset_size(vl_string_tid, H5T_VARIABLE);
   H5Tinsert(tid, "count", (char*)&m_count - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I32LE));
   if (inmemory) {
      HDDM::s_hdf5_memorytype["startCounters"] = tid;
   }
   else {
      HDDM::s_hdf5_datatype["startCounters"] = tid;
   }
   if (verbose) {
      size_t slen;
      H5LTdtype_to_text(tid, 0, H5LT_DDL, &slen);
      char *ddlstring = (char*)malloc(slen);
      H5LTdtype_to_text(tid, ddlstring, H5LT_DDL, &slen);
      if (inmemory)
         printf("=== in-memory datatype %ld for %s is:\n %s\n", (long int)tid, "startCounters", ddlstring);
      else
         printf("=== on-disk datatype %ld for %s is:\n %s\n", (long int)tid, "startCounters", ddlstring);
      free(ddlstring);
   }
   return tid;
}
void StartCounters::hdf5DataPack()
{
}
void StartCounters::hdf5DataUnpack()
{
}
#endif

std::string CdcStraws::toString(int indent) {
   std::stringstream ostr;
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "cdcStraws"
        << " count=" << m_count
             << std::endl;
   return ostr.str();
}

std::string CdcStraws::toXML(int indent) {
   std::stringstream ostr;
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "<cdcStraws"
        << " count=" << "\"" << getCount() << "\""
        << " />" << std::endl;
   return ostr.str();
}

#ifdef HDF5_SUPPORT
hid_t CdcStraws::hdf5Datatype(int inmemory, int verbose)
{
   std::string tname("cdcStraws");
   if (inmemory) {
      if (HDDM::s_hdf5_memorytype.find(tname) != HDDM::s_hdf5_memorytype.end())
         return HDDM::s_hdf5_memorytype[tname];
   }
   else {
      if (HDDM::s_hdf5_datatype.find(tname) != HDDM::s_hdf5_datatype.end())
         return HDDM::s_hdf5_datatype[tname];
   }
   hid_t tid = H5Tcreate(H5T_COMPOUND, sizeof(*this));
   hid_t vl_string_tid = H5Tcopy(H5T_C_S1);
   H5Tset_size(vl_string_tid, H5T_VARIABLE);
   H5Tinsert(tid, "count", (char*)&m_count - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I32LE));
   if (inmemory) {
      HDDM::s_hdf5_memorytype["cdcStraws"] = tid;
   }
   else {
      HDDM::s_hdf5_datatype["cdcStraws"] = tid;
   }
   if (verbose) {
      size_t slen;
      H5LTdtype_to_text(tid, 0, H5LT_DDL, &slen);
      char *ddlstring = (char*)malloc(slen);
      H5LTdtype_to_text(tid, ddlstring, H5LT_DDL, &slen);
      if (inmemory)
         printf("=== in-memory datatype %ld for %s is:\n %s\n", (long int)tid, "cdcStraws", ddlstring);
      else
         printf("=== on-disk datatype %ld for %s is:\n %s\n", (long int)tid, "cdcStraws", ddlstring);
      free(ddlstring);
   }
   return tid;
}
void CdcStraws::hdf5DataPack()
{
}
void CdcStraws::hdf5DataUnpack()
{
}
#endif

std::string FdcPseudos::toString(int indent) {
   std::stringstream ostr;
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "fdcPseudos"
        << " count=" << m_count
             << std::endl;
   return ostr.str();
}

std::string FdcPseudos::toXML(int indent) {
   std::stringstream ostr;
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "<fdcPseudos"
        << " count=" << "\"" << getCount() << "\""
        << " />" << std::endl;
   return ostr.str();
}

#ifdef HDF5_SUPPORT
hid_t FdcPseudos::hdf5Datatype(int inmemory, int verbose)
{
   std::string tname("fdcPseudos");
   if (inmemory) {
      if (HDDM::s_hdf5_memorytype.find(tname) != HDDM::s_hdf5_memorytype.end())
         return HDDM::s_hdf5_memorytype[tname];
   }
   else {
      if (HDDM::s_hdf5_datatype.find(tname) != HDDM::s_hdf5_datatype.end())
         return HDDM::s_hdf5_datatype[tname];
   }
   hid_t tid = H5Tcreate(H5T_COMPOUND, sizeof(*this));
   hid_t vl_string_tid = H5Tcopy(H5T_C_S1);
   H5Tset_size(vl_string_tid, H5T_VARIABLE);
   H5Tinsert(tid, "count", (char*)&m_count - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I32LE));
   if (inmemory) {
      HDDM::s_hdf5_memorytype["fdcPseudos"] = tid;
   }
   else {
      HDDM::s_hdf5_datatype["fdcPseudos"] = tid;
   }
   if (verbose) {
      size_t slen;
      H5LTdtype_to_text(tid, 0, H5LT_DDL, &slen);
      char *ddlstring = (char*)malloc(slen);
      H5LTdtype_to_text(tid, ddlstring, H5LT_DDL, &slen);
      if (inmemory)
         printf("=== in-memory datatype %ld for %s is:\n %s\n", (long int)tid, "fdcPseudos", ddlstring);
      else
         printf("=== on-disk datatype %ld for %s is:\n %s\n", (long int)tid, "fdcPseudos", ddlstring);
      free(ddlstring);
   }
   return tid;
}
void FdcPseudos::hdf5DataPack()
{
}
void FdcPseudos::hdf5DataUnpack()
{
}
#endif

std::string BcalCells::toString(int indent) {
   std::stringstream ostr;
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "bcalCells"
        << " count=" << m_count
             << std::endl;
   return ostr.str();
}

std::string BcalCells::toXML(int indent) {
   std::stringstream ostr;
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "<bcalCells"
        << " count=" << "\"" << getCount() << "\""
        << " />" << std::endl;
   return ostr.str();
}

#ifdef HDF5_SUPPORT
hid_t BcalCells::hdf5Datatype(int inmemory, int verbose)
{
   std::string tname("bcalCells");
   if (inmemory) {
      if (HDDM::s_hdf5_memorytype.find(tname) != HDDM::s_hdf5_memorytype.end())
         return HDDM::s_hdf5_memorytype[tname];
   }
   else {
      if (HDDM::s_hdf5_datatype.find(tname) != HDDM::s_hdf5_datatype.end())
         return HDDM::s_hdf5_datatype[tname];
   }
   hid_t tid = H5Tcreate(H5T_COMPOUND, sizeof(*this));
   hid_t vl_string_tid = H5Tcopy(H5T_C_S1);
   H5Tset_size(vl_string_tid, H5T_VARIABLE);
   H5Tinsert(tid, "count", (char*)&m_count - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I32LE));
   if (inmemory) {
      HDDM::s_hdf5_memorytype["bcalCells"] = tid;
   }
   else {
      HDDM::s_hdf5_datatype["bcalCells"] = tid;
   }
   if (verbose) {
      size_t slen;
      H5LTdtype_to_text(tid, 0, H5LT_DDL, &slen);
      char *ddlstring = (char*)malloc(slen);
      H5LTdtype_to_text(tid, ddlstring, H5LT_DDL, &slen);
      if (inmemory)
         printf("=== in-memory datatype %ld for %s is:\n %s\n", (long int)tid, "bcalCells", ddlstring);
      else
         printf("=== on-disk datatype %ld for %s is:\n %s\n", (long int)tid, "bcalCells", ddlstring);
      free(ddlstring);
   }
   return tid;
}
void BcalCells::hdf5DataPack()
{
}
void BcalCells::hdf5DataUnpack()
{
}
#endif

std::string FcalBlocks::toString(int indent) {
   std::stringstream ostr;
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "fcalBlocks"
        << " count=" << m_count
             << std::endl;
   return ostr.str();
}

std::string FcalBlocks::toXML(int indent) {
   std::stringstream ostr;
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "<fcalBlocks"
        << " count=" << "\"" << getCount() << "\""
        << " />" << std::endl;
   return ostr.str();
}

#ifdef HDF5_SUPPORT
hid_t FcalBlocks::hdf5Datatype(int inmemory, int verbose)
{
   std::string tname("fcalBlocks");
   if (inmemory) {
      if (HDDM::s_hdf5_memorytype.find(tname) != HDDM::s_hdf5_memorytype.end())
         return HDDM::s_hdf5_memorytype[tname];
   }
   else {
      if (HDDM::s_hdf5_datatype.find(tname) != HDDM::s_hdf5_datatype.end())
         return HDDM::s_hdf5_datatype[tname];
   }
   hid_t tid = H5Tcreate(H5T_COMPOUND, sizeof(*this));
   hid_t vl_string_tid = H5Tcopy(H5T_C_S1);
   H5Tset_size(vl_string_tid, H5T_VARIABLE);
   H5Tinsert(tid, "count", (char*)&m_count - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I32LE));
   if (inmemory) {
      HDDM::s_hdf5_memorytype["fcalBlocks"] = tid;
   }
   else {
      HDDM::s_hdf5_datatype["fcalBlocks"] = tid;
   }
   if (verbose) {
      size_t slen;
      H5LTdtype_to_text(tid, 0, H5LT_DDL, &slen);
      char *ddlstring = (char*)malloc(slen);
      H5LTdtype_to_text(tid, ddlstring, H5LT_DDL, &slen);
      if (inmemory)
         printf("=== in-memory datatype %ld for %s is:\n %s\n", (long int)tid, "fcalBlocks", ddlstring);
      else
         printf("=== on-disk datatype %ld for %s is:\n %s\n", (long int)tid, "fcalBlocks", ddlstring);
      free(ddlstring);
   }
   return tid;
}
void FcalBlocks::hdf5DataPack()
{
}
void FcalBlocks::hdf5DataUnpack()
{
}
#endif

std::string TofPaddles::toString(int indent) {
   std::stringstream ostr;
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "tofPaddles"
        << " count=" << m_count
             << std::endl;
   return ostr.str();
}

std::string TofPaddles::toXML(int indent) {
   std::stringstream ostr;
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "<tofPaddles"
        << " count=" << "\"" << getCount() << "\""
        << " />" << std::endl;
   return ostr.str();
}

#ifdef HDF5_SUPPORT
hid_t TofPaddles::hdf5Datatype(int inmemory, int verbose)
{
   std::string tname("tofPaddles");
   if (inmemory) {
      if (HDDM::s_hdf5_memorytype.find(tname) != HDDM::s_hdf5_memorytype.end())
         return HDDM::s_hdf5_memorytype[tname];
   }
   else {
      if (HDDM::s_hdf5_datatype.find(tname) != HDDM::s_hdf5_datatype.end())
         return HDDM::s_hdf5_datatype[tname];
   }
   hid_t tid = H5Tcreate(H5T_COMPOUND, sizeof(*this));
   hid_t vl_string_tid = H5Tcopy(H5T_C_S1);
   H5Tset_size(vl_string_tid, H5T_VARIABLE);
   H5Tinsert(tid, "count", (char*)&m_count - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I32LE));
   if (inmemory) {
      HDDM::s_hdf5_memorytype["tofPaddles"] = tid;
   }
   else {
      HDDM::s_hdf5_datatype["tofPaddles"] = tid;
   }
   if (verbose) {
      size_t slen;
      H5LTdtype_to_text(tid, 0, H5LT_DDL, &slen);
      char *ddlstring = (char*)malloc(slen);
      H5LTdtype_to_text(tid, ddlstring, H5LT_DDL, &slen);
      if (inmemory)
         printf("=== in-memory datatype %ld for %s is:\n %s\n", (long int)tid, "tofPaddles", ddlstring);
      else
         printf("=== on-disk datatype %ld for %s is:\n %s\n", (long int)tid, "tofPaddles", ddlstring);
      free(ddlstring);
   }
   return tid;
}
void TofPaddles::hdf5DataPack()
{
}
void TofPaddles::hdf5DataUnpack()
{
}
#endif

std::string CcalBlocks::toString(int indent) {
   std::stringstream ostr;
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "ccalBlocks"
        << " count=" << m_count
             << std::endl;
   return ostr.str();
}

std::string CcalBlocks::toXML(int indent) {
   std::stringstream ostr;
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "<ccalBlocks"
        << " count=" << "\"" << getCount() << "\""
        << " />" << std::endl;
   return ostr.str();
}

#ifdef HDF5_SUPPORT
hid_t CcalBlocks::hdf5Datatype(int inmemory, int verbose)
{
   std::string tname("ccalBlocks");
   if (inmemory) {
      if (HDDM::s_hdf5_memorytype.find(tname) != HDDM::s_hdf5_memorytype.end())
         return HDDM::s_hdf5_memorytype[tname];
   }
   else {
      if (HDDM::s_hdf5_datatype.find(tname) != HDDM::s_hdf5_datatype.end())
         return HDDM::s_hdf5_datatype[tname];
   }
   hid_t tid = H5Tcreate(H5T_COMPOUND, sizeof(*this));
   hid_t vl_string_tid = H5Tcopy(H5T_C_S1);
   H5Tset_size(vl_string_tid, H5T_VARIABLE);
   H5Tinsert(tid, "count", (char*)&m_count - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I32LE));
   if (inmemory) {
      HDDM::s_hdf5_memorytype["ccalBlocks"] = tid;
   }
   else {
      HDDM::s_hdf5_datatype["ccalBlocks"] = tid;
   }
   if (verbose) {
      size_t slen;
      H5LTdtype_to_text(tid, 0, H5LT_DDL, &slen);
      char *ddlstring = (char*)malloc(slen);
      H5LTdtype_to_text(tid, ddlstring, H5LT_DDL, &slen);
      if (inmemory)
         printf("=== in-memory datatype %ld for %s is:\n %s\n", (long int)tid, "ccalBlocks", ddlstring);
      else
         printf("=== on-disk datatype %ld for %s is:\n %s\n", (long int)tid, "ccalBlocks", ddlstring);
      free(ddlstring);
   }
   return tid;
}
void CcalBlocks::hdf5DataPack()
{
}
void CcalBlocks::hdf5DataUnpack()
{
}
#endif

std::string DircPMTs::toString(int indent) {
   std::stringstream ostr;
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "dircPMTs"
        << " count=" << m_count
             << std::endl;
   return ostr.str();
}

std::string DircPMTs::toXML(int indent) {
   std::stringstream ostr;
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "<dircPMTs"
        << " count=" << "\"" << getCount() << "\""
        << " />" << std::endl;
   return ostr.str();
}

#ifdef HDF5_SUPPORT
hid_t DircPMTs::hdf5Datatype(int inmemory, int verbose)
{
   std::string tname("dircPMTs");
   if (inmemory) {
      if (HDDM::s_hdf5_memorytype.find(tname) != HDDM::s_hdf5_memorytype.end())
         return HDDM::s_hdf5_memorytype[tname];
   }
   else {
      if (HDDM::s_hdf5_datatype.find(tname) != HDDM::s_hdf5_datatype.end())
         return HDDM::s_hdf5_datatype[tname];
   }
   hid_t tid = H5Tcreate(H5T_COMPOUND, sizeof(*this));
   hid_t vl_string_tid = H5Tcopy(H5T_C_S1);
   H5Tset_size(vl_string_tid, H5T_VARIABLE);
   H5Tinsert(tid, "count", (char*)&m_count - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I32LE));
   if (inmemory) {
      HDDM::s_hdf5_memorytype["dircPMTs"] = tid;
   }
   else {
      HDDM::s_hdf5_datatype["dircPMTs"] = tid;
   }
   if (verbose) {
      size_t slen;
      H5LTdtype_to_text(tid, 0, H5LT_DDL, &slen);
      char *ddlstring = (char*)malloc(slen);
      H5LTdtype_to_text(tid, ddlstring, H5LT_DDL, &slen);
      if (inmemory)
         printf("=== in-memory datatype %ld for %s is:\n %s\n", (long int)tid, "dircPMTs", ddlstring);
      else
         printf("=== on-disk datatype %ld for %s is:\n %s\n", (long int)tid, "dircPMTs", ddlstring);
      free(ddlstring);
   }
   return tid;
}
void DircPMTs::hdf5DataPack()
{
}
void DircPMTs::hdf5DataUnpack()
{
}
#endif

std::string HitStatistics::toString(int indent) {
   std::stringstream ostr;
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "hitStatistics"
        << " jtag=" << "\"" << m_jtag << "\""
             << std::endl;
   if (! m_startCounters_link.empty()) {
      ostr << m_startCounters_link.begin()->toString(indent + 2);
   }
   if (! m_cdcStraws_link.empty()) {
      ostr << m_cdcStraws_link.begin()->toString(indent + 2);
   }
   if (! m_fdcPseudos_link.empty()) {
      ostr << m_fdcPseudos_link.begin()->toString(indent + 2);
   }
   if (! m_bcalCells_link.empty()) {
      ostr << m_bcalCells_link.begin()->toString(indent + 2);
   }
   if (! m_fcalBlocks_link.empty()) {
      ostr << m_fcalBlocks_link.begin()->toString(indent + 2);
   }
   if (! m_tofPaddles_link.empty()) {
      ostr << m_tofPaddles_link.begin()->toString(indent + 2);
   }
   if (! m_ccalBlocks_link.empty()) {
      ostr << m_ccalBlocks_link.begin()->toString(indent + 2);
   }
   if (! m_dircPMTs_link.empty()) {
      ostr << m_dircPMTs_link.begin()->toString(indent + 2);
   }
   return ostr.str();
}

std::string HitStatistics::toXML(int indent) {
   std::stringstream ostr;
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "<hitStatistics"
        << " jtag=" << "\"" << getJtag() << "\""
        << ">" << std::endl;
   if (! m_startCounters_link.empty()) {
      ostr << m_startCounters_link.begin()->toXML(indent + 2);
   }
   if (! m_cdcStraws_link.empty()) {
      ostr << m_cdcStraws_link.begin()->toXML(indent + 2);
   }
   if (! m_fdcPseudos_link.empty()) {
      ostr << m_fdcPseudos_link.begin()->toXML(indent + 2);
   }
   if (! m_bcalCells_link.empty()) {
      ostr << m_bcalCells_link.begin()->toXML(indent + 2);
   }
   if (! m_fcalBlocks_link.empty()) {
      ostr << m_fcalBlocks_link.begin()->toXML(indent + 2);
   }
   if (! m_tofPaddles_link.empty()) {
      ostr << m_tofPaddles_link.begin()->toXML(indent + 2);
   }
   if (! m_ccalBlocks_link.empty()) {
      ostr << m_ccalBlocks_link.begin()->toXML(indent + 2);
   }
   if (! m_dircPMTs_link.empty()) {
      ostr << m_dircPMTs_link.begin()->toXML(indent + 2);
   }
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "</hitStatistics>"
        << std::endl;
   return ostr.str();
}

#ifdef HDF5_SUPPORT
hid_t HitStatistics::hdf5Datatype(int inmemory, int verbose)
{
   std::string tname("hitStatistics");
   if (inmemory) {
      if (HDDM::s_hdf5_memorytype.find(tname) != HDDM::s_hdf5_memorytype.end())
         return HDDM::s_hdf5_memorytype[tname];
   }
   else {
      if (HDDM::s_hdf5_datatype.find(tname) != HDDM::s_hdf5_datatype.end())
         return HDDM::s_hdf5_datatype[tname];
   }
   hid_t tid = H5Tcreate(H5T_COMPOUND, sizeof(*this));
   hid_t vl_string_tid = H5Tcopy(H5T_C_S1);
   H5Tset_size(vl_string_tid, H5T_VARIABLE);
   H5Tinsert(tid, "jtag", (char*)&mx_jtag - (char*)this, vl_string_tid);
   H5Tinsert(tid, "StartCountersList_size", (char*)&m_startCounters_link.m_size - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   H5Tinsert(tid, "StartCountersList_offset", (char*)&m_startCounters_link.m_ref - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   H5Tinsert(tid, "CdcStrawsList_size", (char*)&m_cdcStraws_link.m_size - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   H5Tinsert(tid, "CdcStrawsList_offset", (char*)&m_cdcStraws_link.m_ref - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   H5Tinsert(tid, "FdcPseudosList_size", (char*)&m_fdcPseudos_link.m_size - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   H5Tinsert(tid, "FdcPseudosList_offset", (char*)&m_fdcPseudos_link.m_ref - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   H5Tinsert(tid, "BcalCellsList_size", (char*)&m_bcalCells_link.m_size - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   H5Tinsert(tid, "BcalCellsList_offset", (char*)&m_bcalCells_link.m_ref - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   H5Tinsert(tid, "FcalBlocksList_size", (char*)&m_fcalBlocks_link.m_size - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   H5Tinsert(tid, "FcalBlocksList_offset", (char*)&m_fcalBlocks_link.m_ref - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   H5Tinsert(tid, "TofPaddlesList_size", (char*)&m_tofPaddles_link.m_size - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   H5Tinsert(tid, "TofPaddlesList_offset", (char*)&m_tofPaddles_link.m_ref - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   H5Tinsert(tid, "CcalBlocksList_size", (char*)&m_ccalBlocks_link.m_size - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   H5Tinsert(tid, "CcalBlocksList_offset", (char*)&m_ccalBlocks_link.m_ref - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   H5Tinsert(tid, "DircPMTsList_size", (char*)&m_dircPMTs_link.m_size - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   H5Tinsert(tid, "DircPMTsList_offset", (char*)&m_dircPMTs_link.m_ref - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   if (inmemory) {
      HDDM::s_hdf5_memorytype["hitStatistics"] = tid;
   }
   else {
      HDDM::s_hdf5_datatype["hitStatistics"] = tid;
   }
   if (verbose) {
      size_t slen;
      H5LTdtype_to_text(tid, 0, H5LT_DDL, &slen);
      char *ddlstring = (char*)malloc(slen);
      H5LTdtype_to_text(tid, ddlstring, H5LT_DDL, &slen);
      if (inmemory)
         printf("=== in-memory datatype %ld for %s is:\n %s\n", (long int)tid, "hitStatistics", ddlstring);
      else
         printf("=== on-disk datatype %ld for %s is:\n %s\n", (long int)tid, "hitStatistics", ddlstring);
      free(ddlstring);
   }
   return tid;
}
void HitStatistics::hdf5DataPack()
{
   mx_jtag = m_jtag.c_str();
   m_startCounters_link.deflate();
   m_cdcStraws_link.deflate();
   m_fdcPseudos_link.deflate();
   m_bcalCells_link.deflate();
   m_fcalBlocks_link.deflate();
   m_tofPaddles_link.deflate();
   m_ccalBlocks_link.deflate();
   m_dircPMTs_link.deflate();
}
void HitStatistics::hdf5DataUnpack()
{
   new(&m_jtag) std::string();
   if (mx_jtag != 0) {
      m_jtag = mx_jtag;
      m_host->m_hdf5_strings.push_back(&m_jtag);
   }
   {
      std::list<StartCounters*> *host_plist = &m_host->m_startCounters_plist;
      m_startCounters_link.inflate(m_host, host_plist, this);
      StartCountersList::iterator iter;
      for (iter = m_startCounters_link.begin();
           iter != m_startCounters_link.end(); ++iter)
      {
         iter->hdf5DataUnpack();
      }
   }
   {
      std::list<CdcStraws*> *host_plist = &m_host->m_cdcStraws_plist;
      m_cdcStraws_link.inflate(m_host, host_plist, this);
      CdcStrawsList::iterator iter;
      for (iter = m_cdcStraws_link.begin();
           iter != m_cdcStraws_link.end(); ++iter)
      {
         iter->hdf5DataUnpack();
      }
   }
   {
      std::list<FdcPseudos*> *host_plist = &m_host->m_fdcPseudos_plist;
      m_fdcPseudos_link.inflate(m_host, host_plist, this);
      FdcPseudosList::iterator iter;
      for (iter = m_fdcPseudos_link.begin();
           iter != m_fdcPseudos_link.end(); ++iter)
      {
         iter->hdf5DataUnpack();
      }
   }
   {
      std::list<BcalCells*> *host_plist = &m_host->m_bcalCells_plist;
      m_bcalCells_link.inflate(m_host, host_plist, this);
      BcalCellsList::iterator iter;
      for (iter = m_bcalCells_link.begin();
           iter != m_bcalCells_link.end(); ++iter)
      {
         iter->hdf5DataUnpack();
      }
   }
   {
      std::list<FcalBlocks*> *host_plist = &m_host->m_fcalBlocks_plist;
      m_fcalBlocks_link.inflate(m_host, host_plist, this);
      FcalBlocksList::iterator iter;
      for (iter = m_fcalBlocks_link.begin();
           iter != m_fcalBlocks_link.end(); ++iter)
      {
         iter->hdf5DataUnpack();
      }
   }
   {
      std::list<TofPaddles*> *host_plist = &m_host->m_tofPaddles_plist;
      m_tofPaddles_link.inflate(m_host, host_plist, this);
      TofPaddlesList::iterator iter;
      for (iter = m_tofPaddles_link.begin();
           iter != m_tofPaddles_link.end(); ++iter)
      {
         iter->hdf5DataUnpack();
      }
   }
   {
      std::list<CcalBlocks*> *host_plist = &m_host->m_ccalBlocks_plist;
      m_ccalBlocks_link.inflate(m_host, host_plist, this);
      CcalBlocksList::iterator iter;
      for (iter = m_ccalBlocks_link.begin();
           iter != m_ccalBlocks_link.end(); ++iter)
      {
         iter->hdf5DataUnpack();
      }
   }
   {
      std::list<DircPMTs*> *host_plist = &m_host->m_dircPMTs_plist;
      m_dircPMTs_link.inflate(m_host, host_plist, this);
      DircPMTsList::iterator iter;
      for (iter = m_dircPMTs_link.begin();
           iter != m_dircPMTs_link.end(); ++iter)
      {
         iter->hdf5DataUnpack();
      }
   }
}
#endif

std::string ReconstructedPhysicsEvent::toString(int indent) {
   std::stringstream ostr;
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "reconstructedPhysicsEvent"
        << " eventNo=" << m_eventNo
        << " runNo=" << m_runNo
             << std::endl;
   int CommentListCount=0;
   for (CommentList::iterator it = m_comment_list.begin();
        it != m_comment_list.end(); ++it)
   {
      if (++CommentListCount > m_comment_list.size()) {
         throw std::runtime_error("hddm_r::toString error - list improperly terminated!");
      }
      ostr << it->toString(indent + 2);
   }
   int DataVersionStringListCount=0;
   for (DataVersionStringList::iterator it = m_dataVersionString_list.begin();
        it != m_dataVersionString_list.end(); ++it)
   {
      if (++DataVersionStringListCount > m_dataVersionString_list.size()) {
         throw std::runtime_error("hddm_r::toString error - list improperly terminated!");
      }
      ostr << it->toString(indent + 2);
   }
   int CcdbContextListCount=0;
   for (CcdbContextList::iterator it = m_ccdbContext_list.begin();
        it != m_ccdbContext_list.end(); ++it)
   {
      if (++CcdbContextListCount > m_ccdbContext_list.size()) {
         throw std::runtime_error("hddm_r::toString error - list improperly terminated!");
      }
      ostr << it->toString(indent + 2);
   }
   int ReactionListCount=0;
   for (ReactionList::iterator it = m_reaction_list.begin();
        it != m_reaction_list.end(); ++it)
   {
      if (++ReactionListCount > m_reaction_list.size()) {
         throw std::runtime_error("hddm_r::toString error - list improperly terminated!");
      }
      ostr << it->toString(indent + 2);
   }
   int TagmBeamPhotonListCount=0;
   for (TagmBeamPhotonList::iterator it = m_tagmBeamPhoton_list.begin();
        it != m_tagmBeamPhoton_list.end(); ++it)
   {
      if (++TagmBeamPhotonListCount > m_tagmBeamPhoton_list.size()) {
         throw std::runtime_error("hddm_r::toString error - list improperly terminated!");
      }
      ostr << it->toString(indent + 2);
   }
   int TaghBeamPhotonListCount=0;
   for (TaghBeamPhotonList::iterator it = m_taghBeamPhoton_list.begin();
        it != m_taghBeamPhoton_list.end(); ++it)
   {
      if (++TaghBeamPhotonListCount > m_taghBeamPhoton_list.size()) {
         throw std::runtime_error("hddm_r::toString error - list improperly terminated!");
      }
      ostr << it->toString(indent + 2);
   }
   int FcalShowerListCount=0;
   for (FcalShowerList::iterator it = m_fcalShower_list.begin();
        it != m_fcalShower_list.end(); ++it)
   {
      if (++FcalShowerListCount > m_fcalShower_list.size()) {
         throw std::runtime_error("hddm_r::toString error - list improperly terminated!");
      }
      ostr << it->toString(indent + 2);
   }
   int FcalHitListCount=0;
   for (FcalHitList::iterator it = m_fcalHit_list.begin();
        it != m_fcalHit_list.end(); ++it)
   {
      if (++FcalHitListCount > m_fcalHit_list.size()) {
         throw std::runtime_error("hddm_r::toString error - list improperly terminated!");
      }
      ostr << it->toString(indent + 2);
   }
   int BcalShowerListCount=0;
   for (BcalShowerList::iterator it = m_bcalShower_list.begin();
        it != m_bcalShower_list.end(); ++it)
   {
      if (++BcalShowerListCount > m_bcalShower_list.size()) {
         throw std::runtime_error("hddm_r::toString error - list improperly terminated!");
      }
      ostr << it->toString(indent + 2);
   }
   int CcalShowerListCount=0;
   for (CcalShowerList::iterator it = m_ccalShower_list.begin();
        it != m_ccalShower_list.end(); ++it)
   {
      if (++CcalShowerListCount > m_ccalShower_list.size()) {
         throw std::runtime_error("hddm_r::toString error - list improperly terminated!");
      }
      ostr << it->toString(indent + 2);
   }
   int ChargedTrackListCount=0;
   for (ChargedTrackList::iterator it = m_chargedTrack_list.begin();
        it != m_chargedTrack_list.end(); ++it)
   {
      if (++ChargedTrackListCount > m_chargedTrack_list.size()) {
         throw std::runtime_error("hddm_r::toString error - list improperly terminated!");
      }
      ostr << it->toString(indent + 2);
   }
   int StartHitListCount=0;
   for (StartHitList::iterator it = m_startHit_list.begin();
        it != m_startHit_list.end(); ++it)
   {
      if (++StartHitListCount > m_startHit_list.size()) {
         throw std::runtime_error("hddm_r::toString error - list improperly terminated!");
      }
      ostr << it->toString(indent + 2);
   }
   int CtofPointListCount=0;
   for (CtofPointList::iterator it = m_ctofPoint_list.begin();
        it != m_ctofPoint_list.end(); ++it)
   {
      if (++CtofPointListCount > m_ctofPoint_list.size()) {
         throw std::runtime_error("hddm_r::toString error - list improperly terminated!");
      }
      ostr << it->toString(indent + 2);
   }
   int TofPointListCount=0;
   for (TofPointList::iterator it = m_tofPoint_list.begin();
        it != m_tofPoint_list.end(); ++it)
   {
      if (++TofPointListCount > m_tofPoint_list.size()) {
         throw std::runtime_error("hddm_r::toString error - list improperly terminated!");
      }
      ostr << it->toString(indent + 2);
   }
   int DircHitListCount=0;
   for (DircHitList::iterator it = m_dircHit_list.begin();
        it != m_dircHit_list.end(); ++it)
   {
      if (++DircHitListCount > m_dircHit_list.size()) {
         throw std::runtime_error("hddm_r::toString error - list improperly terminated!");
      }
      ostr << it->toString(indent + 2);
   }
   int FmwpcHitListCount=0;
   for (FmwpcHitList::iterator it = m_fmwpcHit_list.begin();
        it != m_fmwpcHit_list.end(); ++it)
   {
      if (++FmwpcHitListCount > m_fmwpcHit_list.size()) {
         throw std::runtime_error("hddm_r::toString error - list improperly terminated!");
      }
      ostr << it->toString(indent + 2);
   }
   if (! m_RFtime_link.empty()) {
      ostr << m_RFtime_link.begin()->toString(indent + 2);
   }
   if (! m_trigger_link.empty()) {
      ostr << m_trigger_link.begin()->toString(indent + 2);
   }
   if (! m_detectorMatches_link.empty()) {
      ostr << m_detectorMatches_link.begin()->toString(indent + 2);
   }
   if (! m_hitStatistics_link.empty()) {
      ostr << m_hitStatistics_link.begin()->toString(indent + 2);
   }
   return ostr.str();
}

std::string ReconstructedPhysicsEvent::toXML(int indent) {
   std::stringstream ostr;
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "<reconstructedPhysicsEvent"
        << " eventNo=" << "\"" << getEventNo() << "\""
        << " runNo=" << "\"" << getRunNo() << "\""
        << ">" << std::endl;
   int CommentListCount=0;
   for (CommentList::iterator it = m_comment_list.begin();
        it != m_comment_list.end(); ++it)
   {
      if (++CommentListCount > m_comment_list.size()) {
         throw std::runtime_error("hddm_r::toXML error - list improperly terminated!");
      }
      ostr << it->toXML(indent + 2);
   }
   int DataVersionStringListCount=0;
   for (DataVersionStringList::iterator it = m_dataVersionString_list.begin();
        it != m_dataVersionString_list.end(); ++it)
   {
      if (++DataVersionStringListCount > m_dataVersionString_list.size()) {
         throw std::runtime_error("hddm_r::toXML error - list improperly terminated!");
      }
      ostr << it->toXML(indent + 2);
   }
   int CcdbContextListCount=0;
   for (CcdbContextList::iterator it = m_ccdbContext_list.begin();
        it != m_ccdbContext_list.end(); ++it)
   {
      if (++CcdbContextListCount > m_ccdbContext_list.size()) {
         throw std::runtime_error("hddm_r::toXML error - list improperly terminated!");
      }
      ostr << it->toXML(indent + 2);
   }
   int ReactionListCount=0;
   for (ReactionList::iterator it = m_reaction_list.begin();
        it != m_reaction_list.end(); ++it)
   {
      if (++ReactionListCount > m_reaction_list.size()) {
         throw std::runtime_error("hddm_r::toXML error - list improperly terminated!");
      }
      ostr << it->toXML(indent + 2);
   }
   int TagmBeamPhotonListCount=0;
   for (TagmBeamPhotonList::iterator it = m_tagmBeamPhoton_list.begin();
        it != m_tagmBeamPhoton_list.end(); ++it)
   {
      if (++TagmBeamPhotonListCount > m_tagmBeamPhoton_list.size()) {
         throw std::runtime_error("hddm_r::toXML error - list improperly terminated!");
      }
      ostr << it->toXML(indent + 2);
   }
   int TaghBeamPhotonListCount=0;
   for (TaghBeamPhotonList::iterator it = m_taghBeamPhoton_list.begin();
        it != m_taghBeamPhoton_list.end(); ++it)
   {
      if (++TaghBeamPhotonListCount > m_taghBeamPhoton_list.size()) {
         throw std::runtime_error("hddm_r::toXML error - list improperly terminated!");
      }
      ostr << it->toXML(indent + 2);
   }
   int FcalShowerListCount=0;
   for (FcalShowerList::iterator it = m_fcalShower_list.begin();
        it != m_fcalShower_list.end(); ++it)
   {
      if (++FcalShowerListCount > m_fcalShower_list.size()) {
         throw std::runtime_error("hddm_r::toXML error - list improperly terminated!");
      }
      ostr << it->toXML(indent + 2);
   }
   int FcalHitListCount=0;
   for (FcalHitList::iterator it = m_fcalHit_list.begin();
        it != m_fcalHit_list.end(); ++it)
   {
      if (++FcalHitListCount > m_fcalHit_list.size()) {
         throw std::runtime_error("hddm_r::toXML error - list improperly terminated!");
      }
      ostr << it->toXML(indent + 2);
   }
   int BcalShowerListCount=0;
   for (BcalShowerList::iterator it = m_bcalShower_list.begin();
        it != m_bcalShower_list.end(); ++it)
   {
      if (++BcalShowerListCount > m_bcalShower_list.size()) {
         throw std::runtime_error("hddm_r::toXML error - list improperly terminated!");
      }
      ostr << it->toXML(indent + 2);
   }
   int CcalShowerListCount=0;
   for (CcalShowerList::iterator it = m_ccalShower_list.begin();
        it != m_ccalShower_list.end(); ++it)
   {
      if (++CcalShowerListCount > m_ccalShower_list.size()) {
         throw std::runtime_error("hddm_r::toXML error - list improperly terminated!");
      }
      ostr << it->toXML(indent + 2);
   }
   int ChargedTrackListCount=0;
   for (ChargedTrackList::iterator it = m_chargedTrack_list.begin();
        it != m_chargedTrack_list.end(); ++it)
   {
      if (++ChargedTrackListCount > m_chargedTrack_list.size()) {
         throw std::runtime_error("hddm_r::toXML error - list improperly terminated!");
      }
      ostr << it->toXML(indent + 2);
   }
   int StartHitListCount=0;
   for (StartHitList::iterator it = m_startHit_list.begin();
        it != m_startHit_list.end(); ++it)
   {
      if (++StartHitListCount > m_startHit_list.size()) {
         throw std::runtime_error("hddm_r::toXML error - list improperly terminated!");
      }
      ostr << it->toXML(indent + 2);
   }
   int CtofPointListCount=0;
   for (CtofPointList::iterator it = m_ctofPoint_list.begin();
        it != m_ctofPoint_list.end(); ++it)
   {
      if (++CtofPointListCount > m_ctofPoint_list.size()) {
         throw std::runtime_error("hddm_r::toXML error - list improperly terminated!");
      }
      ostr << it->toXML(indent + 2);
   }
   int TofPointListCount=0;
   for (TofPointList::iterator it = m_tofPoint_list.begin();
        it != m_tofPoint_list.end(); ++it)
   {
      if (++TofPointListCount > m_tofPoint_list.size()) {
         throw std::runtime_error("hddm_r::toXML error - list improperly terminated!");
      }
      ostr << it->toXML(indent + 2);
   }
   int DircHitListCount=0;
   for (DircHitList::iterator it = m_dircHit_list.begin();
        it != m_dircHit_list.end(); ++it)
   {
      if (++DircHitListCount > m_dircHit_list.size()) {
         throw std::runtime_error("hddm_r::toXML error - list improperly terminated!");
      }
      ostr << it->toXML(indent + 2);
   }
   int FmwpcHitListCount=0;
   for (FmwpcHitList::iterator it = m_fmwpcHit_list.begin();
        it != m_fmwpcHit_list.end(); ++it)
   {
      if (++FmwpcHitListCount > m_fmwpcHit_list.size()) {
         throw std::runtime_error("hddm_r::toXML error - list improperly terminated!");
      }
      ostr << it->toXML(indent + 2);
   }
   if (! m_RFtime_link.empty()) {
      ostr << m_RFtime_link.begin()->toXML(indent + 2);
   }
   if (! m_trigger_link.empty()) {
      ostr << m_trigger_link.begin()->toXML(indent + 2);
   }
   if (! m_detectorMatches_link.empty()) {
      ostr << m_detectorMatches_link.begin()->toXML(indent + 2);
   }
   if (! m_hitStatistics_link.empty()) {
      ostr << m_hitStatistics_link.begin()->toXML(indent + 2);
   }
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "</reconstructedPhysicsEvent>"
        << std::endl;
   return ostr.str();
}

#ifdef HDF5_SUPPORT
hid_t ReconstructedPhysicsEvent::hdf5Datatype(int inmemory, int verbose)
{
   std::string tname("reconstructedPhysicsEvent");
   if (inmemory) {
      if (HDDM::s_hdf5_memorytype.find(tname) != HDDM::s_hdf5_memorytype.end())
         return HDDM::s_hdf5_memorytype[tname];
   }
   else {
      if (HDDM::s_hdf5_datatype.find(tname) != HDDM::s_hdf5_datatype.end())
         return HDDM::s_hdf5_datatype[tname];
   }
   hid_t tid = H5Tcreate(H5T_COMPOUND, sizeof(*this));
   hid_t vl_string_tid = H5Tcopy(H5T_C_S1);
   H5Tset_size(vl_string_tid, H5T_VARIABLE);
   H5Tinsert(tid, "eventNo", (char*)&m_eventNo - (char*)this, ((inmemory)? H5T_NATIVE_LONG : H5T_STD_I64LE));
   H5Tinsert(tid, "runNo", (char*)&m_runNo - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I32LE));
   H5Tinsert(tid, "CommentList_size", (char*)&m_comment_list.m_size - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   H5Tinsert(tid, "CommentList_offset", (char*)&m_comment_list.m_ref - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   H5Tinsert(tid, "DataVersionStringList_size", (char*)&m_dataVersionString_list.m_size - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   H5Tinsert(tid, "DataVersionStringList_offset", (char*)&m_dataVersionString_list.m_ref - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   H5Tinsert(tid, "CcdbContextList_size", (char*)&m_ccdbContext_list.m_size - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   H5Tinsert(tid, "CcdbContextList_offset", (char*)&m_ccdbContext_list.m_ref - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   H5Tinsert(tid, "ReactionList_size", (char*)&m_reaction_list.m_size - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   H5Tinsert(tid, "ReactionList_offset", (char*)&m_reaction_list.m_ref - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   H5Tinsert(tid, "TagmBeamPhotonList_size", (char*)&m_tagmBeamPhoton_list.m_size - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   H5Tinsert(tid, "TagmBeamPhotonList_offset", (char*)&m_tagmBeamPhoton_list.m_ref - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   H5Tinsert(tid, "TaghBeamPhotonList_size", (char*)&m_taghBeamPhoton_list.m_size - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   H5Tinsert(tid, "TaghBeamPhotonList_offset", (char*)&m_taghBeamPhoton_list.m_ref - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   H5Tinsert(tid, "FcalShowerList_size", (char*)&m_fcalShower_list.m_size - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   H5Tinsert(tid, "FcalShowerList_offset", (char*)&m_fcalShower_list.m_ref - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   H5Tinsert(tid, "FcalHitList_size", (char*)&m_fcalHit_list.m_size - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   H5Tinsert(tid, "FcalHitList_offset", (char*)&m_fcalHit_list.m_ref - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   H5Tinsert(tid, "BcalShowerList_size", (char*)&m_bcalShower_list.m_size - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   H5Tinsert(tid, "BcalShowerList_offset", (char*)&m_bcalShower_list.m_ref - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   H5Tinsert(tid, "CcalShowerList_size", (char*)&m_ccalShower_list.m_size - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   H5Tinsert(tid, "CcalShowerList_offset", (char*)&m_ccalShower_list.m_ref - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   H5Tinsert(tid, "ChargedTrackList_size", (char*)&m_chargedTrack_list.m_size - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   H5Tinsert(tid, "ChargedTrackList_offset", (char*)&m_chargedTrack_list.m_ref - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   H5Tinsert(tid, "StartHitList_size", (char*)&m_startHit_list.m_size - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   H5Tinsert(tid, "StartHitList_offset", (char*)&m_startHit_list.m_ref - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   H5Tinsert(tid, "CtofPointList_size", (char*)&m_ctofPoint_list.m_size - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   H5Tinsert(tid, "CtofPointList_offset", (char*)&m_ctofPoint_list.m_ref - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   H5Tinsert(tid, "TofPointList_size", (char*)&m_tofPoint_list.m_size - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   H5Tinsert(tid, "TofPointList_offset", (char*)&m_tofPoint_list.m_ref - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   H5Tinsert(tid, "DircHitList_size", (char*)&m_dircHit_list.m_size - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   H5Tinsert(tid, "DircHitList_offset", (char*)&m_dircHit_list.m_ref - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   H5Tinsert(tid, "FmwpcHitList_size", (char*)&m_fmwpcHit_list.m_size - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   H5Tinsert(tid, "FmwpcHitList_offset", (char*)&m_fmwpcHit_list.m_ref - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   H5Tinsert(tid, "RFtimeList_size", (char*)&m_RFtime_link.m_size - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   H5Tinsert(tid, "RFtimeList_offset", (char*)&m_RFtime_link.m_ref - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   H5Tinsert(tid, "TriggerList_size", (char*)&m_trigger_link.m_size - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   H5Tinsert(tid, "TriggerList_offset", (char*)&m_trigger_link.m_ref - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   H5Tinsert(tid, "DetectorMatchesList_size", (char*)&m_detectorMatches_link.m_size - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   H5Tinsert(tid, "DetectorMatchesList_offset", (char*)&m_detectorMatches_link.m_ref - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   H5Tinsert(tid, "HitStatisticsList_size", (char*)&m_hitStatistics_link.m_size - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   H5Tinsert(tid, "HitStatisticsList_offset", (char*)&m_hitStatistics_link.m_ref - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   if (inmemory) {
      HDDM::s_hdf5_memorytype["reconstructedPhysicsEvent"] = tid;
   }
   else {
      HDDM::s_hdf5_datatype["reconstructedPhysicsEvent"] = tid;
   }
   if (verbose) {
      size_t slen;
      H5LTdtype_to_text(tid, 0, H5LT_DDL, &slen);
      char *ddlstring = (char*)malloc(slen);
      H5LTdtype_to_text(tid, ddlstring, H5LT_DDL, &slen);
      if (inmemory)
         printf("=== in-memory datatype %ld for %s is:\n %s\n", (long int)tid, "reconstructedPhysicsEvent", ddlstring);
      else
         printf("=== on-disk datatype %ld for %s is:\n %s\n", (long int)tid, "reconstructedPhysicsEvent", ddlstring);
      free(ddlstring);
   }
   return tid;
}
void ReconstructedPhysicsEvent::hdf5DataPack()
{
   m_comment_list.deflate();
   m_dataVersionString_list.deflate();
   m_ccdbContext_list.deflate();
   m_reaction_list.deflate();
   m_tagmBeamPhoton_list.deflate();
   m_taghBeamPhoton_list.deflate();
   m_fcalShower_list.deflate();
   m_fcalHit_list.deflate();
   m_bcalShower_list.deflate();
   m_ccalShower_list.deflate();
   m_chargedTrack_list.deflate();
   m_startHit_list.deflate();
   m_ctofPoint_list.deflate();
   m_tofPoint_list.deflate();
   m_dircHit_list.deflate();
   m_fmwpcHit_list.deflate();
   m_RFtime_link.deflate();
   m_trigger_link.deflate();
   m_detectorMatches_link.deflate();
   m_hitStatistics_link.deflate();
}
void ReconstructedPhysicsEvent::hdf5DataUnpack()
{
   {
      std::list<Comment*> *host_plist = &m_host->m_comment_plist;
      m_comment_list.inflate(m_host, host_plist, this);
      CommentList::iterator iter;
      for (iter = m_comment_list.begin();
           iter != m_comment_list.end(); ++iter)
      {
         iter->hdf5DataUnpack();
      }
   }
   {
      std::list<DataVersionString*> *host_plist = &m_host->m_dataVersionString_plist;
      m_dataVersionString_list.inflate(m_host, host_plist, this);
      DataVersionStringList::iterator iter;
      for (iter = m_dataVersionString_list.begin();
           iter != m_dataVersionString_list.end(); ++iter)
      {
         iter->hdf5DataUnpack();
      }
   }
   {
      std::list<CcdbContext*> *host_plist = &m_host->m_ccdbContext_plist;
      m_ccdbContext_list.inflate(m_host, host_plist, this);
      CcdbContextList::iterator iter;
      for (iter = m_ccdbContext_list.begin();
           iter != m_ccdbContext_list.end(); ++iter)
      {
         iter->hdf5DataUnpack();
      }
   }
   {
      std::list<Reaction*> *host_plist = &m_host->m_reaction_plist;
      m_reaction_list.inflate(m_host, host_plist, this);
      ReactionList::iterator iter;
      for (iter = m_reaction_list.begin();
           iter != m_reaction_list.end(); ++iter)
      {
         iter->hdf5DataUnpack();
      }
   }
   {
      std::list<TagmBeamPhoton*> *host_plist = &m_host->m_tagmBeamPhoton_plist;
      m_tagmBeamPhoton_list.inflate(m_host, host_plist, this);
      TagmBeamPhotonList::iterator iter;
      for (iter = m_tagmBeamPhoton_list.begin();
           iter != m_tagmBeamPhoton_list.end(); ++iter)
      {
         iter->hdf5DataUnpack();
      }
   }
   {
      std::list<TaghBeamPhoton*> *host_plist = &m_host->m_taghBeamPhoton_plist;
      m_taghBeamPhoton_list.inflate(m_host, host_plist, this);
      TaghBeamPhotonList::iterator iter;
      for (iter = m_taghBeamPhoton_list.begin();
           iter != m_taghBeamPhoton_list.end(); ++iter)
      {
         iter->hdf5DataUnpack();
      }
   }
   {
      std::list<FcalShower*> *host_plist = &m_host->m_fcalShower_plist;
      m_fcalShower_list.inflate(m_host, host_plist, this);
      FcalShowerList::iterator iter;
      for (iter = m_fcalShower_list.begin();
           iter != m_fcalShower_list.end(); ++iter)
      {
         iter->hdf5DataUnpack();
      }
   }
   {
      std::list<FcalHit*> *host_plist = &m_host->m_fcalHit_plist;
      m_fcalHit_list.inflate(m_host, host_plist, this);
      FcalHitList::iterator iter;
      for (iter = m_fcalHit_list.begin();
           iter != m_fcalHit_list.end(); ++iter)
      {
         iter->hdf5DataUnpack();
      }
   }
   {
      std::list<BcalShower*> *host_plist = &m_host->m_bcalShower_plist;
      m_bcalShower_list.inflate(m_host, host_plist, this);
      BcalShowerList::iterator iter;
      for (iter = m_bcalShower_list.begin();
           iter != m_bcalShower_list.end(); ++iter)
      {
         iter->hdf5DataUnpack();
      }
   }
   {
      std::list<CcalShower*> *host_plist = &m_host->m_ccalShower_plist;
      m_ccalShower_list.inflate(m_host, host_plist, this);
      CcalShowerList::iterator iter;
      for (iter = m_ccalShower_list.begin();
           iter != m_ccalShower_list.end(); ++iter)
      {
         iter->hdf5DataUnpack();
      }
   }
   {
      std::list<ChargedTrack*> *host_plist = &m_host->m_chargedTrack_plist;
      m_chargedTrack_list.inflate(m_host, host_plist, this);
      ChargedTrackList::iterator iter;
      for (iter = m_chargedTrack_list.begin();
           iter != m_chargedTrack_list.end(); ++iter)
      {
         iter->hdf5DataUnpack();
      }
   }
   {
      std::list<StartHit*> *host_plist = &m_host->m_startHit_plist;
      m_startHit_list.inflate(m_host, host_plist, this);
      StartHitList::iterator iter;
      for (iter = m_startHit_list.begin();
           iter != m_startHit_list.end(); ++iter)
      {
         iter->hdf5DataUnpack();
      }
   }
   {
      std::list<CtofPoint*> *host_plist = &m_host->m_ctofPoint_plist;
      m_ctofPoint_list.inflate(m_host, host_plist, this);
      CtofPointList::iterator iter;
      for (iter = m_ctofPoint_list.begin();
           iter != m_ctofPoint_list.end(); ++iter)
      {
         iter->hdf5DataUnpack();
      }
   }
   {
      std::list<TofPoint*> *host_plist = &m_host->m_tofPoint_plist;
      m_tofPoint_list.inflate(m_host, host_plist, this);
      TofPointList::iterator iter;
      for (iter = m_tofPoint_list.begin();
           iter != m_tofPoint_list.end(); ++iter)
      {
         iter->hdf5DataUnpack();
      }
   }
   {
      std::list<DircHit*> *host_plist = &m_host->m_dircHit_plist;
      m_dircHit_list.inflate(m_host, host_plist, this);
      DircHitList::iterator iter;
      for (iter = m_dircHit_list.begin();
           iter != m_dircHit_list.end(); ++iter)
      {
         iter->hdf5DataUnpack();
      }
   }
   {
      std::list<FmwpcHit*> *host_plist = &m_host->m_fmwpcHit_plist;
      m_fmwpcHit_list.inflate(m_host, host_plist, this);
      FmwpcHitList::iterator iter;
      for (iter = m_fmwpcHit_list.begin();
           iter != m_fmwpcHit_list.end(); ++iter)
      {
         iter->hdf5DataUnpack();
      }
   }
   {
      std::list<RFtime*> *host_plist = &m_host->m_RFtime_plist;
      m_RFtime_link.inflate(m_host, host_plist, this);
      RFtimeList::iterator iter;
      for (iter = m_RFtime_link.begin();
           iter != m_RFtime_link.end(); ++iter)
      {
         iter->hdf5DataUnpack();
      }
   }
   {
      std::list<Trigger*> *host_plist = &m_host->m_trigger_plist;
      m_trigger_link.inflate(m_host, host_plist, this);
      TriggerList::iterator iter;
      for (iter = m_trigger_link.begin();
           iter != m_trigger_link.end(); ++iter)
      {
         iter->hdf5DataUnpack();
      }
   }
   {
      std::list<DetectorMatches*> *host_plist = &m_host->m_detectorMatches_plist;
      m_detectorMatches_link.inflate(m_host, host_plist, this);
      DetectorMatchesList::iterator iter;
      for (iter = m_detectorMatches_link.begin();
           iter != m_detectorMatches_link.end(); ++iter)
      {
         iter->hdf5DataUnpack();
      }
   }
   {
      std::list<HitStatistics*> *host_plist = &m_host->m_hitStatistics_plist;
      m_hitStatistics_link.inflate(m_host, host_plist, this);
      HitStatisticsList::iterator iter;
      for (iter = m_hitStatistics_link.begin();
           iter != m_hitStatistics_link.end(); ++iter)
      {
         iter->hdf5DataUnpack();
      }
   }
}
#endif

std::string HDDM::toString(int indent) {
   std::stringstream ostr;
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "HDDM"
             << std::endl;
   if (! m_reconstructedPhysicsEvent_link.empty()) {
      ostr << m_reconstructedPhysicsEvent_link.begin()->toString(indent + 2);
   }
   return ostr.str();
}

std::string HDDM::toXML(int indent) {
   std::stringstream ostr;
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "<HDDM"
        << " class=" << "\"" << getClass() << "\""
        << " version=" << "\"" << getVersion() << "\""
        << " xmlns=" << "\"" << getXmlns() << "\""
        << ">" << std::endl;
   if (! m_reconstructedPhysicsEvent_link.empty()) {
      ostr << m_reconstructedPhysicsEvent_link.begin()->toXML(indent + 2);
   }
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "</HDDM>"
        << std::endl;
   return ostr.str();
}

#ifdef HDF5_SUPPORT
hid_t HDDM::hdf5Datatype(int inmemory, int verbose)
{
   std::string tname("HDDM");
   if (inmemory) {
      if (HDDM::s_hdf5_memorytype.find(tname) != HDDM::s_hdf5_memorytype.end())
         return HDDM::s_hdf5_memorytype[tname];
   }
   else {
      if (HDDM::s_hdf5_datatype.find(tname) != HDDM::s_hdf5_datatype.end())
         return HDDM::s_hdf5_datatype[tname];
   }
   hid_t tid = H5Tcreate(H5T_COMPOUND, sizeof(*this));
   hid_t vl_string_tid = H5Tcopy(H5T_C_S1);
   H5Tset_size(vl_string_tid, H5T_VARIABLE);
   hid_t vl_tid;
   CDCAmpdEdx l_CDCAmpdEdx;
   vl_tid = H5Tvlen_create(l_CDCAmpdEdx.hdf5Datatype(inmemory));
   H5Tinsert(tid, "vl_CDCAmpdEdx", (char*)&m_hdf5_record.vl_CDCAmpdEdx - (char*)&m_hdf5_record, vl_tid);
   CDCdEdxTrunc l_CDCdEdxTrunc;
   vl_tid = H5Tvlen_create(l_CDCdEdxTrunc.hdf5Datatype(inmemory));
   H5Tinsert(tid, "vl_CDCdEdxTrunc", (char*)&m_hdf5_record.vl_CDCdEdxTrunc - (char*)&m_hdf5_record, vl_tid);
   FDCdEdxTrunc l_FDCdEdxTrunc;
   vl_tid = H5Tvlen_create(l_FDCdEdxTrunc.hdf5Datatype(inmemory));
   H5Tinsert(tid, "vl_FDCdEdxTrunc", (char*)&m_hdf5_record.vl_FDCdEdxTrunc - (char*)&m_hdf5_record, vl_tid);
   RFtime l_RFtime;
   vl_tid = H5Tvlen_create(l_RFtime.hdf5Datatype(inmemory));
   H5Tinsert(tid, "vl_RFtime", (char*)&m_hdf5_record.vl_RFtime - (char*)&m_hdf5_record, vl_tid);
   BcalCells l_bcalCells;
   vl_tid = H5Tvlen_create(l_bcalCells.hdf5Datatype(inmemory));
   H5Tinsert(tid, "vl_bcalCells", (char*)&m_hdf5_record.vl_bcalCells - (char*)&m_hdf5_record, vl_tid);
   BcalCluster l_bcalCluster;
   vl_tid = H5Tvlen_create(l_bcalCluster.hdf5Datatype(inmemory));
   H5Tinsert(tid, "vl_bcalCluster", (char*)&m_hdf5_record.vl_bcalCluster - (char*)&m_hdf5_record, vl_tid);
   BcalCorrelations l_bcalCorrelations;
   vl_tid = H5Tvlen_create(l_bcalCorrelations.hdf5Datatype(inmemory));
   H5Tinsert(tid, "vl_bcalCorrelations", (char*)&m_hdf5_record.vl_bcalCorrelations - (char*)&m_hdf5_record, vl_tid);
   BcalDOCAtoTrack l_bcalDOCAtoTrack;
   vl_tid = H5Tvlen_create(l_bcalDOCAtoTrack.hdf5Datatype(inmemory));
   H5Tinsert(tid, "vl_bcalDOCAtoTrack", (char*)&m_hdf5_record.vl_bcalDOCAtoTrack - (char*)&m_hdf5_record, vl_tid);
   BcalLayers l_bcalLayers;
   vl_tid = H5Tvlen_create(l_bcalLayers.hdf5Datatype(inmemory));
   H5Tinsert(tid, "vl_bcalLayers", (char*)&m_hdf5_record.vl_bcalLayers - (char*)&m_hdf5_record, vl_tid);
   BcalMatchParams l_bcalMatchParams;
   vl_tid = H5Tvlen_create(l_bcalMatchParams.hdf5Datatype(inmemory));
   H5Tinsert(tid, "vl_bcalMatchParams", (char*)&m_hdf5_record.vl_bcalMatchParams - (char*)&m_hdf5_record, vl_tid);
   BcalShower l_bcalShower;
   vl_tid = H5Tvlen_create(l_bcalShower.hdf5Datatype(inmemory));
   H5Tinsert(tid, "vl_bcalShower", (char*)&m_hdf5_record.vl_bcalShower - (char*)&m_hdf5_record, vl_tid);
   CcalBlocks l_ccalBlocks;
   vl_tid = H5Tvlen_create(l_ccalBlocks.hdf5Datatype(inmemory));
   H5Tinsert(tid, "vl_ccalBlocks", (char*)&m_hdf5_record.vl_ccalBlocks - (char*)&m_hdf5_record, vl_tid);
   CcalShower l_ccalShower;
   vl_tid = H5Tvlen_create(l_ccalShower.hdf5Datatype(inmemory));
   H5Tinsert(tid, "vl_ccalShower", (char*)&m_hdf5_record.vl_ccalShower - (char*)&m_hdf5_record, vl_tid);
   CcdbContext l_ccdbContext;
   vl_tid = H5Tvlen_create(l_ccdbContext.hdf5Datatype(inmemory));
   H5Tinsert(tid, "vl_ccdbContext", (char*)&m_hdf5_record.vl_ccdbContext - (char*)&m_hdf5_record, vl_tid);
   CdcStraws l_cdcStraws;
   vl_tid = H5Tvlen_create(l_cdcStraws.hdf5Datatype(inmemory));
   H5Tinsert(tid, "vl_cdcStraws", (char*)&m_hdf5_record.vl_cdcStraws - (char*)&m_hdf5_record, vl_tid);
   ChargedTrack l_chargedTrack;
   vl_tid = H5Tvlen_create(l_chargedTrack.hdf5Datatype(inmemory));
   H5Tinsert(tid, "vl_chargedTrack", (char*)&m_hdf5_record.vl_chargedTrack - (char*)&m_hdf5_record, vl_tid);
   Comment l_comment;
   vl_tid = H5Tvlen_create(l_comment.hdf5Datatype(inmemory));
   H5Tinsert(tid, "vl_comment", (char*)&m_hdf5_record.vl_comment - (char*)&m_hdf5_record, vl_tid);
   CtofMatchParams l_ctofMatchParams;
   vl_tid = H5Tvlen_create(l_ctofMatchParams.hdf5Datatype(inmemory));
   H5Tinsert(tid, "vl_ctofMatchParams", (char*)&m_hdf5_record.vl_ctofMatchParams - (char*)&m_hdf5_record, vl_tid);
   CtofPoint l_ctofPoint;
   vl_tid = H5Tvlen_create(l_ctofPoint.hdf5Datatype(inmemory));
   H5Tinsert(tid, "vl_ctofPoint", (char*)&m_hdf5_record.vl_ctofPoint - (char*)&m_hdf5_record, vl_tid);
   DEdxDC l_dEdxDC;
   vl_tid = H5Tvlen_create(l_dEdxDC.hdf5Datatype(inmemory));
   H5Tinsert(tid, "vl_dEdxDC", (char*)&m_hdf5_record.vl_dEdxDC - (char*)&m_hdf5_record, vl_tid);
   DataVersionString l_dataVersionString;
   vl_tid = H5Tvlen_create(l_dataVersionString.hdf5Datatype(inmemory));
   H5Tinsert(tid, "vl_dataVersionString", (char*)&m_hdf5_record.vl_dataVersionString - (char*)&m_hdf5_record, vl_tid);
   DetectorMatches l_detectorMatches;
   vl_tid = H5Tvlen_create(l_detectorMatches.hdf5Datatype(inmemory));
   H5Tinsert(tid, "vl_detectorMatches", (char*)&m_hdf5_record.vl_detectorMatches - (char*)&m_hdf5_record, vl_tid);
   DircHit l_dircHit;
   vl_tid = H5Tvlen_create(l_dircHit.hdf5Datatype(inmemory));
   H5Tinsert(tid, "vl_dircHit", (char*)&m_hdf5_record.vl_dircHit - (char*)&m_hdf5_record, vl_tid);
   DircMatchHit l_dircMatchHit;
   vl_tid = H5Tvlen_create(l_dircMatchHit.hdf5Datatype(inmemory));
   H5Tinsert(tid, "vl_dircMatchHit", (char*)&m_hdf5_record.vl_dircMatchHit - (char*)&m_hdf5_record, vl_tid);
   DircMatchParams l_dircMatchParams;
   vl_tid = H5Tvlen_create(l_dircMatchParams.hdf5Datatype(inmemory));
   H5Tinsert(tid, "vl_dircMatchParams", (char*)&m_hdf5_record.vl_dircMatchParams - (char*)&m_hdf5_record, vl_tid);
   DircPMTs l_dircPMTs;
   vl_tid = H5Tvlen_create(l_dircPMTs.hdf5Datatype(inmemory));
   H5Tinsert(tid, "vl_dircPMTs", (char*)&m_hdf5_record.vl_dircPMTs - (char*)&m_hdf5_record, vl_tid);
   ExitParams l_exitParams;
   vl_tid = H5Tvlen_create(l_exitParams.hdf5Datatype(inmemory));
   H5Tinsert(tid, "vl_exitParams", (char*)&m_hdf5_record.vl_exitParams - (char*)&m_hdf5_record, vl_tid);
   Expectedhits l_expectedhits;
   vl_tid = H5Tvlen_create(l_expectedhits.hdf5Datatype(inmemory));
   H5Tinsert(tid, "vl_expectedhits", (char*)&m_hdf5_record.vl_expectedhits - (char*)&m_hdf5_record, vl_tid);
   FcalBlocks l_fcalBlocks;
   vl_tid = H5Tvlen_create(l_fcalBlocks.hdf5Datatype(inmemory));
   H5Tinsert(tid, "vl_fcalBlocks", (char*)&m_hdf5_record.vl_fcalBlocks - (char*)&m_hdf5_record, vl_tid);
   FcalCorrelations l_fcalCorrelations;
   vl_tid = H5Tvlen_create(l_fcalCorrelations.hdf5Datatype(inmemory));
   H5Tinsert(tid, "vl_fcalCorrelations", (char*)&m_hdf5_record.vl_fcalCorrelations - (char*)&m_hdf5_record, vl_tid);
   FcalDOCAtoTrack l_fcalDOCAtoTrack;
   vl_tid = H5Tvlen_create(l_fcalDOCAtoTrack.hdf5Datatype(inmemory));
   H5Tinsert(tid, "vl_fcalDOCAtoTrack", (char*)&m_hdf5_record.vl_fcalDOCAtoTrack - (char*)&m_hdf5_record, vl_tid);
   FcalEnergyParams l_fcalEnergyParams;
   vl_tid = H5Tvlen_create(l_fcalEnergyParams.hdf5Datatype(inmemory));
   H5Tinsert(tid, "vl_fcalEnergyParams", (char*)&m_hdf5_record.vl_fcalEnergyParams - (char*)&m_hdf5_record, vl_tid);
   FcalHit l_fcalHit;
   vl_tid = H5Tvlen_create(l_fcalHit.hdf5Datatype(inmemory));
   H5Tinsert(tid, "vl_fcalHit", (char*)&m_hdf5_record.vl_fcalHit - (char*)&m_hdf5_record, vl_tid);
   FcalMatchParams l_fcalMatchParams;
   vl_tid = H5Tvlen_create(l_fcalMatchParams.hdf5Datatype(inmemory));
   H5Tinsert(tid, "vl_fcalMatchParams", (char*)&m_hdf5_record.vl_fcalMatchParams - (char*)&m_hdf5_record, vl_tid);
   FcalShower l_fcalShower;
   vl_tid = H5Tvlen_create(l_fcalShower.hdf5Datatype(inmemory));
   H5Tinsert(tid, "vl_fcalShower", (char*)&m_hdf5_record.vl_fcalShower - (char*)&m_hdf5_record, vl_tid);
   FcalShowerClassification l_fcalShowerClassification;
   vl_tid = H5Tvlen_create(l_fcalShowerClassification.hdf5Datatype(inmemory));
   H5Tinsert(tid, "vl_fcalShowerClassification", (char*)&m_hdf5_record.vl_fcalShowerClassification - (char*)&m_hdf5_record, vl_tid);
   FcalShowerNBlocks l_fcalShowerNBlocks;
   vl_tid = H5Tvlen_create(l_fcalShowerNBlocks.hdf5Datatype(inmemory));
   H5Tinsert(tid, "vl_fcalShowerNBlocks", (char*)&m_hdf5_record.vl_fcalShowerNBlocks - (char*)&m_hdf5_record, vl_tid);
   FcalShowerProperties l_fcalShowerProperties;
   vl_tid = H5Tvlen_create(l_fcalShowerProperties.hdf5Datatype(inmemory));
   H5Tinsert(tid, "vl_fcalShowerProperties", (char*)&m_hdf5_record.vl_fcalShowerProperties - (char*)&m_hdf5_record, vl_tid);
   FcalSingleHitMatchParams l_fcalSingleHitMatchParams;
   vl_tid = H5Tvlen_create(l_fcalSingleHitMatchParams.hdf5Datatype(inmemory));
   H5Tinsert(tid, "vl_fcalSingleHitMatchParams", (char*)&m_hdf5_record.vl_fcalSingleHitMatchParams - (char*)&m_hdf5_record, vl_tid);
   FdcPseudos l_fdcPseudos;
   vl_tid = H5Tvlen_create(l_fdcPseudos.hdf5Datatype(inmemory));
   H5Tinsert(tid, "vl_fdcPseudos", (char*)&m_hdf5_record.vl_fdcPseudos - (char*)&m_hdf5_record, vl_tid);
   FmwpcData l_fmwpcData;
   vl_tid = H5Tvlen_create(l_fmwpcData.hdf5Datatype(inmemory));
   H5Tinsert(tid, "vl_fmwpcData", (char*)&m_hdf5_record.vl_fmwpcData - (char*)&m_hdf5_record, vl_tid);
   FmwpcHit l_fmwpcHit;
   vl_tid = H5Tvlen_create(l_fmwpcHit.hdf5Datatype(inmemory));
   H5Tinsert(tid, "vl_fmwpcHit", (char*)&m_hdf5_record.vl_fmwpcHit - (char*)&m_hdf5_record, vl_tid);
   FmwpcMatchParams l_fmwpcMatchParams;
   vl_tid = H5Tvlen_create(l_fmwpcMatchParams.hdf5Datatype(inmemory));
   H5Tinsert(tid, "vl_fmwpcMatchParams", (char*)&m_hdf5_record.vl_fmwpcMatchParams - (char*)&m_hdf5_record, vl_tid);
   HitStatistics l_hitStatistics;
   vl_tid = H5Tvlen_create(l_hitStatistics.hdf5Datatype(inmemory));
   H5Tinsert(tid, "vl_hitStatistics", (char*)&m_hdf5_record.vl_hitStatistics - (char*)&m_hdf5_record, vl_tid);
   Hitlayers l_hitlayers;
   vl_tid = H5Tvlen_create(l_hitlayers.hdf5Datatype(inmemory));
   H5Tinsert(tid, "vl_hitlayers", (char*)&m_hdf5_record.vl_hitlayers - (char*)&m_hdf5_record, vl_tid);
   Mcmatch l_mcmatch;
   vl_tid = H5Tvlen_create(l_mcmatch.hdf5Datatype(inmemory));
   H5Tinsert(tid, "vl_mcmatch", (char*)&m_hdf5_record.vl_mcmatch - (char*)&m_hdf5_record, vl_tid);
   Momentum l_momentum;
   vl_tid = H5Tvlen_create(l_momentum.hdf5Datatype(inmemory));
   H5Tinsert(tid, "vl_momentum", (char*)&m_hdf5_record.vl_momentum - (char*)&m_hdf5_record, vl_tid);
   Origin l_origin;
   vl_tid = H5Tvlen_create(l_origin.hdf5Datatype(inmemory));
   H5Tinsert(tid, "vl_origin", (char*)&m_hdf5_record.vl_origin - (char*)&m_hdf5_record, vl_tid);
   Preshower l_preshower;
   vl_tid = H5Tvlen_create(l_preshower.hdf5Datatype(inmemory));
   H5Tinsert(tid, "vl_preshower", (char*)&m_hdf5_record.vl_preshower - (char*)&m_hdf5_record, vl_tid);
   Product l_product;
   vl_tid = H5Tvlen_create(l_product.hdf5Datatype(inmemory));
   H5Tinsert(tid, "vl_product", (char*)&m_hdf5_record.vl_product - (char*)&m_hdf5_record, vl_tid);
   Reaction l_reaction;
   vl_tid = H5Tvlen_create(l_reaction.hdf5Datatype(inmemory));
   H5Tinsert(tid, "vl_reaction", (char*)&m_hdf5_record.vl_reaction - (char*)&m_hdf5_record, vl_tid);
   ReconstructedPhysicsEvent l_reconstructedPhysicsEvent;
   vl_tid = H5Tvlen_create(l_reconstructedPhysicsEvent.hdf5Datatype(inmemory));
   H5Tinsert(tid, "vl_reconstructedPhysicsEvent", (char*)&m_hdf5_record.vl_reconstructedPhysicsEvent - (char*)&m_hdf5_record, vl_tid);
   ScMatchParams l_scMatchParams;
   vl_tid = H5Tvlen_create(l_scMatchParams.hdf5Datatype(inmemory));
   H5Tinsert(tid, "vl_scMatchParams", (char*)&m_hdf5_record.vl_scMatchParams - (char*)&m_hdf5_record, vl_tid);
   StartCounters l_startCounters;
   vl_tid = H5Tvlen_create(l_startCounters.hdf5Datatype(inmemory));
   H5Tinsert(tid, "vl_startCounters", (char*)&m_hdf5_record.vl_startCounters - (char*)&m_hdf5_record, vl_tid);
   StartHit l_startHit;
   vl_tid = H5Tvlen_create(l_startHit.hdf5Datatype(inmemory));
   H5Tinsert(tid, "vl_startHit", (char*)&m_hdf5_record.vl_startHit - (char*)&m_hdf5_record, vl_tid);
   TaghBeamPhoton l_taghBeamPhoton;
   vl_tid = H5Tvlen_create(l_taghBeamPhoton.hdf5Datatype(inmemory));
   H5Tinsert(tid, "vl_taghBeamPhoton", (char*)&m_hdf5_record.vl_taghBeamPhoton - (char*)&m_hdf5_record, vl_tid);
   TaghChannel l_taghChannel;
   vl_tid = H5Tvlen_create(l_taghChannel.hdf5Datatype(inmemory));
   H5Tinsert(tid, "vl_taghChannel", (char*)&m_hdf5_record.vl_taghChannel - (char*)&m_hdf5_record, vl_tid);
   TagmBeamPhoton l_tagmBeamPhoton;
   vl_tid = H5Tvlen_create(l_tagmBeamPhoton.hdf5Datatype(inmemory));
   H5Tinsert(tid, "vl_tagmBeamPhoton", (char*)&m_hdf5_record.vl_tagmBeamPhoton - (char*)&m_hdf5_record, vl_tid);
   TagmChannel l_tagmChannel;
   vl_tid = H5Tvlen_create(l_tagmChannel.hdf5Datatype(inmemory));
   H5Tinsert(tid, "vl_tagmChannel", (char*)&m_hdf5_record.vl_tagmChannel - (char*)&m_hdf5_record, vl_tid);
   TflightPCorrelation l_tflightPCorrelation;
   vl_tid = H5Tvlen_create(l_tflightPCorrelation.hdf5Datatype(inmemory));
   H5Tinsert(tid, "vl_tflightPCorrelation", (char*)&m_hdf5_record.vl_tflightPCorrelation - (char*)&m_hdf5_record, vl_tid);
   TofDedx l_tofDedx;
   vl_tid = H5Tvlen_create(l_tofDedx.hdf5Datatype(inmemory));
   H5Tinsert(tid, "vl_tofDedx", (char*)&m_hdf5_record.vl_tofDedx - (char*)&m_hdf5_record, vl_tid);
   TofEnergyDeposition l_tofEnergyDeposition;
   vl_tid = H5Tvlen_create(l_tofEnergyDeposition.hdf5Datatype(inmemory));
   H5Tinsert(tid, "vl_tofEnergyDeposition", (char*)&m_hdf5_record.vl_tofEnergyDeposition - (char*)&m_hdf5_record, vl_tid);
   TofMatchParams l_tofMatchParams;
   vl_tid = H5Tvlen_create(l_tofMatchParams.hdf5Datatype(inmemory));
   H5Tinsert(tid, "vl_tofMatchParams", (char*)&m_hdf5_record.vl_tofMatchParams - (char*)&m_hdf5_record, vl_tid);
   TofPaddles l_tofPaddles;
   vl_tid = H5Tvlen_create(l_tofPaddles.hdf5Datatype(inmemory));
   H5Tinsert(tid, "vl_tofPaddles", (char*)&m_hdf5_record.vl_tofPaddles - (char*)&m_hdf5_record, vl_tid);
   TofPoint l_tofPoint;
   vl_tid = H5Tvlen_create(l_tofPoint.hdf5Datatype(inmemory));
   H5Tinsert(tid, "vl_tofPoint", (char*)&m_hdf5_record.vl_tofPoint - (char*)&m_hdf5_record, vl_tid);
   TofStatus l_tofStatus;
   vl_tid = H5Tvlen_create(l_tofStatus.hdf5Datatype(inmemory));
   H5Tinsert(tid, "vl_tofStatus", (char*)&m_hdf5_record.vl_tofStatus - (char*)&m_hdf5_record, vl_tid);
   TrackFit l_trackFit;
   vl_tid = H5Tvlen_create(l_trackFit.hdf5Datatype(inmemory));
   H5Tinsert(tid, "vl_trackFit", (char*)&m_hdf5_record.vl_trackFit - (char*)&m_hdf5_record, vl_tid);
   TrackFlags l_trackFlags;
   vl_tid = H5Tvlen_create(l_trackFlags.hdf5Datatype(inmemory));
   H5Tinsert(tid, "vl_trackFlags", (char*)&m_hdf5_record.vl_trackFlags - (char*)&m_hdf5_record, vl_tid);
   Trigger l_trigger;
   vl_tid = H5Tvlen_create(l_trigger.hdf5Datatype(inmemory));
   H5Tinsert(tid, "vl_trigger", (char*)&m_hdf5_record.vl_trigger - (char*)&m_hdf5_record, vl_tid);
   TriggerEnergySums l_triggerEnergySums;
   vl_tid = H5Tvlen_create(l_triggerEnergySums.hdf5Datatype(inmemory));
   H5Tinsert(tid, "vl_triggerEnergySums", (char*)&m_hdf5_record.vl_triggerEnergySums - (char*)&m_hdf5_record, vl_tid);
   Vertex l_vertex;
   vl_tid = H5Tvlen_create(l_vertex.hdf5Datatype(inmemory));
   H5Tinsert(tid, "vl_vertex", (char*)&m_hdf5_record.vl_vertex - (char*)&m_hdf5_record, vl_tid);
   Width l_width;
   vl_tid = H5Tvlen_create(l_width.hdf5Datatype(inmemory));
   H5Tinsert(tid, "vl_width", (char*)&m_hdf5_record.vl_width - (char*)&m_hdf5_record, vl_tid);
   if (inmemory == 0)
      H5Tpack(tid);
   if (inmemory) {
      HDDM::s_hdf5_memorytype["HDDM"] = tid;
   }
   else {
      HDDM::s_hdf5_datatype["HDDM"] = tid;
   }
   if (verbose) {
      size_t slen;
      H5LTdtype_to_text(tid, 0, H5LT_DDL, &slen);
      char *ddlstring = (char*)malloc(slen);
      H5LTdtype_to_text(tid, ddlstring, H5LT_DDL, &slen);
      if (inmemory)
         printf("=== in-memory datatype %ld for %s is:\n %s\n", (long int)tid, "HDDM", ddlstring);
      else
         printf("=== on-disk datatype %ld for %s is:\n %s\n", (long int)tid, "HDDM", ddlstring);
      free(ddlstring);
   }
   return tid;
}
herr_t HDDM::hdf5FileStamp(hid_t file_id, char **tags)
{
   std::string stamp(DocumentString());
   while (tags != 0 && *tags != 0) {
      stamp += "<stamptag>";
      stamp += *tags;
      stamp += "</stamptag>\n";
      ++tags;
   }
   hid_t stamp_tid = H5Tcopy(H5T_C_S1);
   H5Tset_size(stamp_tid, H5T_VARIABLE);
   hsize_t dims[1] = {1};
   hsize_t maxdims[1] = {1};
   hid_t stamp_sid = H5Screate_simple(1, dims, maxdims);
   char *pstamp = (char*)stamp.c_str();
   hid_t stamp_id = H5Lexists(file_id, "HDDMstamp", H5P_DEFAULT);
   if (stamp_id > 0) {
      stamp_id = H5Dopen(file_id, "HDDMstamp", H5P_DEFAULT);
   }
   else {
      stamp_id = H5Dcreate(file_id, "HDDMstamp",
                           stamp_tid, stamp_sid,
                           H5P_DEFAULT, H5P_DEFAULT,
                           H5P_DEFAULT);
   }
   herr_t res = H5Dwrite(stamp_id, stamp_tid,
                         H5S_ALL, H5S_ALL,
                         H5P_DEFAULT, &pstamp);
   return res;
}
herr_t HDDM::hdf5FileCheck(hid_t file_id, char **tags)
{
   char *pstamp;
   hid_t stamp_id = H5Dopen(file_id, "HDDMstamp", H5P_DEFAULT);
   hid_t stamp_sid = H5Dget_space(stamp_id);
   hid_t stamp_tid = H5Dget_type(stamp_id);
   stamp_tid = H5Tget_native_type(stamp_tid, H5T_DIR_DEFAULT);
   herr_t res = H5Dread(stamp_id, stamp_tid,
                        H5S_ALL, H5S_ALL,
                        H5P_DEFAULT, &pstamp);
   std::string sstamp(pstamp);
   H5Dvlen_reclaim(stamp_tid, stamp_sid,
                   H5P_DEFAULT, &pstamp);
   if (sstamp.find(DocumentString()) != 0) {
      throw std::runtime_error("hddm_r::hdf5FileCheck - "
                  "HDF5 input record format mismatch!");
   }
   while (tags != 0 && *tags != 0) {
      std::string stag("<stamptag>");
      stag += *tags;
      stag += "</stamptag>";
      if (sstamp.find(stag) == sstamp.npos) {
         throw std::runtime_error("hddm_r::hdf5FileCheck - "
                  "HDF5 input record tag is missing!");
      }
      ++tags;
   }
   H5Dclose(stamp_id);
   return res;
}
std::string HDDM::hdf5DocumentString(hid_t file_id)
{
   char *pstamp;
   hid_t stamp_id = H5Dopen(file_id, "HDDMstamp", H5P_DEFAULT);
   hid_t stamp_sid = H5Dget_space(stamp_id);
   hid_t stamp_tid = H5Dget_type(stamp_id);
   stamp_tid = H5Tget_native_type(stamp_tid, H5T_DIR_DEFAULT);
   H5Dread(stamp_id, stamp_tid,
           H5S_ALL, H5S_ALL, H5P_DEFAULT, &pstamp);
   std::string sstamp(pstamp);
   H5Dvlen_reclaim(stamp_tid, stamp_sid,
                   H5P_DEFAULT, &pstamp);
   H5Dclose(stamp_id);
   return sstamp;
}
hsize_t HDDM::hdf5GetEntries(hid_t file_id)
{
   hid_t eventspace_id;
   hid_t eventdata_id;
   hid_t chunking_id;
   htri_t exists =   H5Lexists(file_id, "HDDMevents", H5P_DEFAULT);
   if (exists <= 0)
      return exists;
   if (s_hdf5_dataset.find(file_id) == s_hdf5_dataset.end()) {

      eventdata_id = H5Dopen(file_id, "HDDMevents",
                               H5P_DEFAULT);
      chunking_id = H5Dget_create_plist(eventdata_id);
      eventspace_id = H5Dget_space(eventdata_id);
      s_hdf5_dataset[file_id] = eventdata_id;
      s_hdf5_chunking[file_id] = chunking_id;
      s_hdf5_dataspace[file_id] = eventspace_id;
   }
   else {
      eventdata_id = s_hdf5_dataset[file_id];
      chunking_id = s_hdf5_chunking[file_id];
      eventspace_id = s_hdf5_dataspace[file_id];
   }
   hsize_t dims;
   hsize_t maxdims;
   H5Sget_simple_extent_dims(eventspace_id, &dims, &maxdims);
   return dims;
}
herr_t HDDM::hdf5SetChunksize(hid_t file_id, hsize_t chunksize)
{
   hid_t chunking_id;
   if (s_hdf5_chunking.find(file_id) == s_hdf5_chunking.end()) {
      chunking_id = H5Pcreate(H5P_DATASET_CREATE);
      s_hdf5_chunking[file_id] = chunking_id;
   }
   else {
      chunking_id = s_hdf5_chunking[file_id];
   }
   hsize_t chunks[1] = {chunksize};
   return H5Pset_chunk(chunking_id, 1, chunks);
}
hsize_t HDDM::hdf5GetChunksize(hid_t file_id)
{
   if (s_hdf5_chunking.find(file_id) == s_hdf5_chunking.end()) {
      return HDF5_DEFAULT_CHUNK_SIZE;
   }
   hid_t chunking_id = s_hdf5_chunking[file_id];
   hsize_t dims[1];
   H5Pget_chunk(chunking_id, 1, dims);
   return dims[0];
}
herr_t HDDM::hdf5SetFilters(hid_t file_id, std::vector<H5Z_filter_t> &filters)
{
   hid_t chunking_id;
   if (s_hdf5_chunking.find(file_id) == s_hdf5_chunking.end()) {
      chunking_id = H5Pcreate(H5P_DATASET_CREATE);
      s_hdf5_chunking[file_id] = chunking_id;
   }
   else {
      chunking_id = s_hdf5_chunking[file_id];
   }
   for (auto filter : filters) {
      if (filter == H5Z_FILTER_DEFLATE) {
         H5Pset_deflate(chunking_id, 9);
      }
      else if (filter == H5Z_FILTER_SZIP) {
         H5Pset_szip(chunking_id, H5_SZIP_NN_OPTION_MASK, 8);
      }
      else if (filter == H5Z_FILTER_SHUFFLE) {
         H5Pset_shuffle(chunking_id);
      }
      else if (filter == H5Z_FILTER_SCALEOFFSET) {
         H5Pset_scaleoffset(chunking_id, H5Z_SO_INT,
                            H5Z_SO_INT_MINBITS_DEFAULT);
      }
      else if (filter == H5Z_FILTER_NBIT) {
         H5Pset_nbit(chunking_id);
      }
      else if (filter == H5Z_FILTER_FLETCHER32) {
         H5Pset_fletcher32(chunking_id);
      }
      else {
         unsigned int cd_values[] = {6};
         H5Pset_filter(chunking_id, filter,
                       H5Z_FLAG_MANDATORY, (size_t)1, cd_values);      }

   }
   return 0;
}
herr_t HDDM::hdf5GetFilters(hid_t file_id, std::vector<H5Z_filter_t> &filters)
{
   filters.clear();
   if (s_hdf5_chunking.find(file_id) == s_hdf5_chunking.end()) {
      return 0;
   }
   hid_t chunking_id = s_hdf5_chunking[file_id];
   for (int i=0; i < H5Pget_nfilters(chunking_id); ++i) {
      unsigned int flags;
      size_t cd_nelmts = 9;
      unsigned int cd_values[9];
      size_t namelen = 99;
      char name[99];
      unsigned int filter_config;
      filters.push_back(H5Pget_filter2(chunking_id, i,
                        &flags, &cd_nelmts, cd_values,
                        namelen, name, &filter_config));
   }
   return 0;
}
herr_t HDDM::hdf5FileWrite(hid_t file_id, long int entry)
{
   hdf5_record_t hdf5_record;
   int size;

   size_t len;

   if ((len = hdf5_record.vl_CDCAmpdEdx.len = m_CDCAmpdEdx_plist.size()) > 0) {
      size = sizeof(CDCAmpdEdx);
      hdf5_record.vl_CDCAmpdEdx.p = malloc(len * size);
      std::list<CDCAmpdEdx*>::iterator iter = m_CDCAmpdEdx_plist.begin();
      CDCAmpdEdx *p = (CDCAmpdEdx*)hdf5_record.vl_CDCAmpdEdx.p;
      for (int i=0; i < (int)len; ++i, ++iter) {
         hdf5_memcpy(p+i, *iter, size);
         p[i].hdf5DataPack();
      }
   }
   if ((len = hdf5_record.vl_CDCdEdxTrunc.len = m_CDCdEdxTrunc_plist.size()) > 0) {
      size = sizeof(CDCdEdxTrunc);
      hdf5_record.vl_CDCdEdxTrunc.p = malloc(len * size);
      std::list<CDCdEdxTrunc*>::iterator iter = m_CDCdEdxTrunc_plist.begin();
      CDCdEdxTrunc *p = (CDCdEdxTrunc*)hdf5_record.vl_CDCdEdxTrunc.p;
      for (int i=0; i < (int)len; ++i, ++iter) {
         hdf5_memcpy(p+i, *iter, size);
         p[i].hdf5DataPack();
      }
   }
   if ((len = hdf5_record.vl_FDCdEdxTrunc.len = m_FDCdEdxTrunc_plist.size()) > 0) {
      size = sizeof(FDCdEdxTrunc);
      hdf5_record.vl_FDCdEdxTrunc.p = malloc(len * size);
      std::list<FDCdEdxTrunc*>::iterator iter = m_FDCdEdxTrunc_plist.begin();
      FDCdEdxTrunc *p = (FDCdEdxTrunc*)hdf5_record.vl_FDCdEdxTrunc.p;
      for (int i=0; i < (int)len; ++i, ++iter) {
         hdf5_memcpy(p+i, *iter, size);
         p[i].hdf5DataPack();
      }
   }
   if ((len = hdf5_record.vl_RFtime.len = m_RFtime_plist.size()) > 0) {
      size = sizeof(RFtime);
      hdf5_record.vl_RFtime.p = malloc(len * size);
      std::list<RFtime*>::iterator iter = m_RFtime_plist.begin();
      RFtime *p = (RFtime*)hdf5_record.vl_RFtime.p;
      for (int i=0; i < (int)len; ++i, ++iter) {
         hdf5_memcpy(p+i, *iter, size);
         p[i].hdf5DataPack();
      }
   }
   if ((len = hdf5_record.vl_bcalCells.len = m_bcalCells_plist.size()) > 0) {
      size = sizeof(BcalCells);
      hdf5_record.vl_bcalCells.p = malloc(len * size);
      std::list<BcalCells*>::iterator iter = m_bcalCells_plist.begin();
      BcalCells *p = (BcalCells*)hdf5_record.vl_bcalCells.p;
      for (int i=0; i < (int)len; ++i, ++iter) {
         hdf5_memcpy(p+i, *iter, size);
         p[i].hdf5DataPack();
      }
   }
   if ((len = hdf5_record.vl_bcalCluster.len = m_bcalCluster_plist.size()) > 0) {
      size = sizeof(BcalCluster);
      hdf5_record.vl_bcalCluster.p = malloc(len * size);
      std::list<BcalCluster*>::iterator iter = m_bcalCluster_plist.begin();
      BcalCluster *p = (BcalCluster*)hdf5_record.vl_bcalCluster.p;
      for (int i=0; i < (int)len; ++i, ++iter) {
         hdf5_memcpy(p+i, *iter, size);
         p[i].hdf5DataPack();
      }
   }
   if ((len = hdf5_record.vl_bcalCorrelations.len = m_bcalCorrelations_plist.size()) > 0) {
      size = sizeof(BcalCorrelations);
      hdf5_record.vl_bcalCorrelations.p = malloc(len * size);
      std::list<BcalCorrelations*>::iterator iter = m_bcalCorrelations_plist.begin();
      BcalCorrelations *p = (BcalCorrelations*)hdf5_record.vl_bcalCorrelations.p;
      for (int i=0; i < (int)len; ++i, ++iter) {
         hdf5_memcpy(p+i, *iter, size);
         p[i].hdf5DataPack();
      }
   }
   if ((len = hdf5_record.vl_bcalDOCAtoTrack.len = m_bcalDOCAtoTrack_plist.size()) > 0) {
      size = sizeof(BcalDOCAtoTrack);
      hdf5_record.vl_bcalDOCAtoTrack.p = malloc(len * size);
      std::list<BcalDOCAtoTrack*>::iterator iter = m_bcalDOCAtoTrack_plist.begin();
      BcalDOCAtoTrack *p = (BcalDOCAtoTrack*)hdf5_record.vl_bcalDOCAtoTrack.p;
      for (int i=0; i < (int)len; ++i, ++iter) {
         hdf5_memcpy(p+i, *iter, size);
         p[i].hdf5DataPack();
      }
   }
   if ((len = hdf5_record.vl_bcalLayers.len = m_bcalLayers_plist.size()) > 0) {
      size = sizeof(BcalLayers);
      hdf5_record.vl_bcalLayers.p = malloc(len * size);
      std::list<BcalLayers*>::iterator iter = m_bcalLayers_plist.begin();
      BcalLayers *p = (BcalLayers*)hdf5_record.vl_bcalLayers.p;
      for (int i=0; i < (int)len; ++i, ++iter) {
         hdf5_memcpy(p+i, *iter, size);
         p[i].hdf5DataPack();
      }
   }
   if ((len = hdf5_record.vl_bcalMatchParams.len = m_bcalMatchParams_plist.size()) > 0) {
      size = sizeof(BcalMatchParams);
      hdf5_record.vl_bcalMatchParams.p = malloc(len * size);
      std::list<BcalMatchParams*>::iterator iter = m_bcalMatchParams_plist.begin();
      BcalMatchParams *p = (BcalMatchParams*)hdf5_record.vl_bcalMatchParams.p;
      for (int i=0; i < (int)len; ++i, ++iter) {
         hdf5_memcpy(p+i, *iter, size);
         p[i].hdf5DataPack();
      }
   }
   if ((len = hdf5_record.vl_bcalShower.len = m_bcalShower_plist.size()) > 0) {
      size = sizeof(BcalShower);
      hdf5_record.vl_bcalShower.p = malloc(len * size);
      std::list<BcalShower*>::iterator iter = m_bcalShower_plist.begin();
      BcalShower *p = (BcalShower*)hdf5_record.vl_bcalShower.p;
      for (int i=0; i < (int)len; ++i, ++iter) {
         hdf5_memcpy(p+i, *iter, size);
         p[i].hdf5DataPack();
      }
   }
   if ((len = hdf5_record.vl_ccalBlocks.len = m_ccalBlocks_plist.size()) > 0) {
      size = sizeof(CcalBlocks);
      hdf5_record.vl_ccalBlocks.p = malloc(len * size);
      std::list<CcalBlocks*>::iterator iter = m_ccalBlocks_plist.begin();
      CcalBlocks *p = (CcalBlocks*)hdf5_record.vl_ccalBlocks.p;
      for (int i=0; i < (int)len; ++i, ++iter) {
         hdf5_memcpy(p+i, *iter, size);
         p[i].hdf5DataPack();
      }
   }
   if ((len = hdf5_record.vl_ccalShower.len = m_ccalShower_plist.size()) > 0) {
      size = sizeof(CcalShower);
      hdf5_record.vl_ccalShower.p = malloc(len * size);
      std::list<CcalShower*>::iterator iter = m_ccalShower_plist.begin();
      CcalShower *p = (CcalShower*)hdf5_record.vl_ccalShower.p;
      for (int i=0; i < (int)len; ++i, ++iter) {
         hdf5_memcpy(p+i, *iter, size);
         p[i].hdf5DataPack();
      }
   }
   if ((len = hdf5_record.vl_ccdbContext.len = m_ccdbContext_plist.size()) > 0) {
      size = sizeof(CcdbContext);
      hdf5_record.vl_ccdbContext.p = malloc(len * size);
      std::list<CcdbContext*>::iterator iter = m_ccdbContext_plist.begin();
      CcdbContext *p = (CcdbContext*)hdf5_record.vl_ccdbContext.p;
      for (int i=0; i < (int)len; ++i, ++iter) {
         hdf5_memcpy(p+i, *iter, size);
         p[i].hdf5DataPack();
      }
   }
   if ((len = hdf5_record.vl_cdcStraws.len = m_cdcStraws_plist.size()) > 0) {
      size = sizeof(CdcStraws);
      hdf5_record.vl_cdcStraws.p = malloc(len * size);
      std::list<CdcStraws*>::iterator iter = m_cdcStraws_plist.begin();
      CdcStraws *p = (CdcStraws*)hdf5_record.vl_cdcStraws.p;
      for (int i=0; i < (int)len; ++i, ++iter) {
         hdf5_memcpy(p+i, *iter, size);
         p[i].hdf5DataPack();
      }
   }
   if ((len = hdf5_record.vl_chargedTrack.len = m_chargedTrack_plist.size()) > 0) {
      size = sizeof(ChargedTrack);
      hdf5_record.vl_chargedTrack.p = malloc(len * size);
      std::list<ChargedTrack*>::iterator iter = m_chargedTrack_plist.begin();
      ChargedTrack *p = (ChargedTrack*)hdf5_record.vl_chargedTrack.p;
      for (int i=0; i < (int)len; ++i, ++iter) {
         hdf5_memcpy(p+i, *iter, size);
         p[i].hdf5DataPack();
      }
   }
   if ((len = hdf5_record.vl_comment.len = m_comment_plist.size()) > 0) {
      size = sizeof(Comment);
      hdf5_record.vl_comment.p = malloc(len * size);
      std::list<Comment*>::iterator iter = m_comment_plist.begin();
      Comment *p = (Comment*)hdf5_record.vl_comment.p;
      for (int i=0; i < (int)len; ++i, ++iter) {
         hdf5_memcpy(p+i, *iter, size);
         p[i].hdf5DataPack();
      }
   }
   if ((len = hdf5_record.vl_ctofMatchParams.len = m_ctofMatchParams_plist.size()) > 0) {
      size = sizeof(CtofMatchParams);
      hdf5_record.vl_ctofMatchParams.p = malloc(len * size);
      std::list<CtofMatchParams*>::iterator iter = m_ctofMatchParams_plist.begin();
      CtofMatchParams *p = (CtofMatchParams*)hdf5_record.vl_ctofMatchParams.p;
      for (int i=0; i < (int)len; ++i, ++iter) {
         hdf5_memcpy(p+i, *iter, size);
         p[i].hdf5DataPack();
      }
   }
   if ((len = hdf5_record.vl_ctofPoint.len = m_ctofPoint_plist.size()) > 0) {
      size = sizeof(CtofPoint);
      hdf5_record.vl_ctofPoint.p = malloc(len * size);
      std::list<CtofPoint*>::iterator iter = m_ctofPoint_plist.begin();
      CtofPoint *p = (CtofPoint*)hdf5_record.vl_ctofPoint.p;
      for (int i=0; i < (int)len; ++i, ++iter) {
         hdf5_memcpy(p+i, *iter, size);
         p[i].hdf5DataPack();
      }
   }
   if ((len = hdf5_record.vl_dEdxDC.len = m_dEdxDC_plist.size()) > 0) {
      size = sizeof(DEdxDC);
      hdf5_record.vl_dEdxDC.p = malloc(len * size);
      std::list<DEdxDC*>::iterator iter = m_dEdxDC_plist.begin();
      DEdxDC *p = (DEdxDC*)hdf5_record.vl_dEdxDC.p;
      for (int i=0; i < (int)len; ++i, ++iter) {
         hdf5_memcpy(p+i, *iter, size);
         p[i].hdf5DataPack();
      }
   }
   if ((len = hdf5_record.vl_dataVersionString.len = m_dataVersionString_plist.size()) > 0) {
      size = sizeof(DataVersionString);
      hdf5_record.vl_dataVersionString.p = malloc(len * size);
      std::list<DataVersionString*>::iterator iter = m_dataVersionString_plist.begin();
      DataVersionString *p = (DataVersionString*)hdf5_record.vl_dataVersionString.p;
      for (int i=0; i < (int)len; ++i, ++iter) {
         hdf5_memcpy(p+i, *iter, size);
         p[i].hdf5DataPack();
      }
   }
   if ((len = hdf5_record.vl_detectorMatches.len = m_detectorMatches_plist.size()) > 0) {
      size = sizeof(DetectorMatches);
      hdf5_record.vl_detectorMatches.p = malloc(len * size);
      std::list<DetectorMatches*>::iterator iter = m_detectorMatches_plist.begin();
      DetectorMatches *p = (DetectorMatches*)hdf5_record.vl_detectorMatches.p;
      for (int i=0; i < (int)len; ++i, ++iter) {
         hdf5_memcpy(p+i, *iter, size);
         p[i].hdf5DataPack();
      }
   }
   if ((len = hdf5_record.vl_dircHit.len = m_dircHit_plist.size()) > 0) {
      size = sizeof(DircHit);
      hdf5_record.vl_dircHit.p = malloc(len * size);
      std::list<DircHit*>::iterator iter = m_dircHit_plist.begin();
      DircHit *p = (DircHit*)hdf5_record.vl_dircHit.p;
      for (int i=0; i < (int)len; ++i, ++iter) {
         hdf5_memcpy(p+i, *iter, size);
         p[i].hdf5DataPack();
      }
   }
   if ((len = hdf5_record.vl_dircMatchHit.len = m_dircMatchHit_plist.size()) > 0) {
      size = sizeof(DircMatchHit);
      hdf5_record.vl_dircMatchHit.p = malloc(len * size);
      std::list<DircMatchHit*>::iterator iter = m_dircMatchHit_plist.begin();
      DircMatchHit *p = (DircMatchHit*)hdf5_record.vl_dircMatchHit.p;
      for (int i=0; i < (int)len; ++i, ++iter) {
         hdf5_memcpy(p+i, *iter, size);
         p[i].hdf5DataPack();
      }
   }
   if ((len = hdf5_record.vl_dircMatchParams.len = m_dircMatchParams_plist.size()) > 0) {
      size = sizeof(DircMatchParams);
      hdf5_record.vl_dircMatchParams.p = malloc(len * size);
      std::list<DircMatchParams*>::iterator iter = m_dircMatchParams_plist.begin();
      DircMatchParams *p = (DircMatchParams*)hdf5_record.vl_dircMatchParams.p;
      for (int i=0; i < (int)len; ++i, ++iter) {
         hdf5_memcpy(p+i, *iter, size);
         p[i].hdf5DataPack();
      }
   }
   if ((len = hdf5_record.vl_dircPMTs.len = m_dircPMTs_plist.size()) > 0) {
      size = sizeof(DircPMTs);
      hdf5_record.vl_dircPMTs.p = malloc(len * size);
      std::list<DircPMTs*>::iterator iter = m_dircPMTs_plist.begin();
      DircPMTs *p = (DircPMTs*)hdf5_record.vl_dircPMTs.p;
      for (int i=0; i < (int)len; ++i, ++iter) {
         hdf5_memcpy(p+i, *iter, size);
         p[i].hdf5DataPack();
      }
   }
   if ((len = hdf5_record.vl_exitParams.len = m_exitParams_plist.size()) > 0) {
      size = sizeof(ExitParams);
      hdf5_record.vl_exitParams.p = malloc(len * size);
      std::list<ExitParams*>::iterator iter = m_exitParams_plist.begin();
      ExitParams *p = (ExitParams*)hdf5_record.vl_exitParams.p;
      for (int i=0; i < (int)len; ++i, ++iter) {
         hdf5_memcpy(p+i, *iter, size);
         p[i].hdf5DataPack();
      }
   }
   if ((len = hdf5_record.vl_expectedhits.len = m_expectedhits_plist.size()) > 0) {
      size = sizeof(Expectedhits);
      hdf5_record.vl_expectedhits.p = malloc(len * size);
      std::list<Expectedhits*>::iterator iter = m_expectedhits_plist.begin();
      Expectedhits *p = (Expectedhits*)hdf5_record.vl_expectedhits.p;
      for (int i=0; i < (int)len; ++i, ++iter) {
         hdf5_memcpy(p+i, *iter, size);
         p[i].hdf5DataPack();
      }
   }
   if ((len = hdf5_record.vl_fcalBlocks.len = m_fcalBlocks_plist.size()) > 0) {
      size = sizeof(FcalBlocks);
      hdf5_record.vl_fcalBlocks.p = malloc(len * size);
      std::list<FcalBlocks*>::iterator iter = m_fcalBlocks_plist.begin();
      FcalBlocks *p = (FcalBlocks*)hdf5_record.vl_fcalBlocks.p;
      for (int i=0; i < (int)len; ++i, ++iter) {
         hdf5_memcpy(p+i, *iter, size);
         p[i].hdf5DataPack();
      }
   }
   if ((len = hdf5_record.vl_fcalCorrelations.len = m_fcalCorrelations_plist.size()) > 0) {
      size = sizeof(FcalCorrelations);
      hdf5_record.vl_fcalCorrelations.p = malloc(len * size);
      std::list<FcalCorrelations*>::iterator iter = m_fcalCorrelations_plist.begin();
      FcalCorrelations *p = (FcalCorrelations*)hdf5_record.vl_fcalCorrelations.p;
      for (int i=0; i < (int)len; ++i, ++iter) {
         hdf5_memcpy(p+i, *iter, size);
         p[i].hdf5DataPack();
      }
   }
   if ((len = hdf5_record.vl_fcalDOCAtoTrack.len = m_fcalDOCAtoTrack_plist.size()) > 0) {
      size = sizeof(FcalDOCAtoTrack);
      hdf5_record.vl_fcalDOCAtoTrack.p = malloc(len * size);
      std::list<FcalDOCAtoTrack*>::iterator iter = m_fcalDOCAtoTrack_plist.begin();
      FcalDOCAtoTrack *p = (FcalDOCAtoTrack*)hdf5_record.vl_fcalDOCAtoTrack.p;
      for (int i=0; i < (int)len; ++i, ++iter) {
         hdf5_memcpy(p+i, *iter, size);
         p[i].hdf5DataPack();
      }
   }
   if ((len = hdf5_record.vl_fcalEnergyParams.len = m_fcalEnergyParams_plist.size()) > 0) {
      size = sizeof(FcalEnergyParams);
      hdf5_record.vl_fcalEnergyParams.p = malloc(len * size);
      std::list<FcalEnergyParams*>::iterator iter = m_fcalEnergyParams_plist.begin();
      FcalEnergyParams *p = (FcalEnergyParams*)hdf5_record.vl_fcalEnergyParams.p;
      for (int i=0; i < (int)len; ++i, ++iter) {
         hdf5_memcpy(p+i, *iter, size);
         p[i].hdf5DataPack();
      }
   }
   if ((len = hdf5_record.vl_fcalHit.len = m_fcalHit_plist.size()) > 0) {
      size = sizeof(FcalHit);
      hdf5_record.vl_fcalHit.p = malloc(len * size);
      std::list<FcalHit*>::iterator iter = m_fcalHit_plist.begin();
      FcalHit *p = (FcalHit*)hdf5_record.vl_fcalHit.p;
      for (int i=0; i < (int)len; ++i, ++iter) {
         hdf5_memcpy(p+i, *iter, size);
         p[i].hdf5DataPack();
      }
   }
   if ((len = hdf5_record.vl_fcalMatchParams.len = m_fcalMatchParams_plist.size()) > 0) {
      size = sizeof(FcalMatchParams);
      hdf5_record.vl_fcalMatchParams.p = malloc(len * size);
      std::list<FcalMatchParams*>::iterator iter = m_fcalMatchParams_plist.begin();
      FcalMatchParams *p = (FcalMatchParams*)hdf5_record.vl_fcalMatchParams.p;
      for (int i=0; i < (int)len; ++i, ++iter) {
         hdf5_memcpy(p+i, *iter, size);
         p[i].hdf5DataPack();
      }
   }
   if ((len = hdf5_record.vl_fcalShower.len = m_fcalShower_plist.size()) > 0) {
      size = sizeof(FcalShower);
      hdf5_record.vl_fcalShower.p = malloc(len * size);
      std::list<FcalShower*>::iterator iter = m_fcalShower_plist.begin();
      FcalShower *p = (FcalShower*)hdf5_record.vl_fcalShower.p;
      for (int i=0; i < (int)len; ++i, ++iter) {
         hdf5_memcpy(p+i, *iter, size);
         p[i].hdf5DataPack();
      }
   }
   if ((len = hdf5_record.vl_fcalShowerClassification.len = m_fcalShowerClassification_plist.size()) > 0) {
      size = sizeof(FcalShowerClassification);
      hdf5_record.vl_fcalShowerClassification.p = malloc(len * size);
      std::list<FcalShowerClassification*>::iterator iter = m_fcalShowerClassification_plist.begin();
      FcalShowerClassification *p = (FcalShowerClassification*)hdf5_record.vl_fcalShowerClassification.p;
      for (int i=0; i < (int)len; ++i, ++iter) {
         hdf5_memcpy(p+i, *iter, size);
         p[i].hdf5DataPack();
      }
   }
   if ((len = hdf5_record.vl_fcalShowerNBlocks.len = m_fcalShowerNBlocks_plist.size()) > 0) {
      size = sizeof(FcalShowerNBlocks);
      hdf5_record.vl_fcalShowerNBlocks.p = malloc(len * size);
      std::list<FcalShowerNBlocks*>::iterator iter = m_fcalShowerNBlocks_plist.begin();
      FcalShowerNBlocks *p = (FcalShowerNBlocks*)hdf5_record.vl_fcalShowerNBlocks.p;
      for (int i=0; i < (int)len; ++i, ++iter) {
         hdf5_memcpy(p+i, *iter, size);
         p[i].hdf5DataPack();
      }
   }
   if ((len = hdf5_record.vl_fcalShowerProperties.len = m_fcalShowerProperties_plist.size()) > 0) {
      size = sizeof(FcalShowerProperties);
      hdf5_record.vl_fcalShowerProperties.p = malloc(len * size);
      std::list<FcalShowerProperties*>::iterator iter = m_fcalShowerProperties_plist.begin();
      FcalShowerProperties *p = (FcalShowerProperties*)hdf5_record.vl_fcalShowerProperties.p;
      for (int i=0; i < (int)len; ++i, ++iter) {
         hdf5_memcpy(p+i, *iter, size);
         p[i].hdf5DataPack();
      }
   }
   if ((len = hdf5_record.vl_fcalSingleHitMatchParams.len = m_fcalSingleHitMatchParams_plist.size()) > 0) {
      size = sizeof(FcalSingleHitMatchParams);
      hdf5_record.vl_fcalSingleHitMatchParams.p = malloc(len * size);
      std::list<FcalSingleHitMatchParams*>::iterator iter = m_fcalSingleHitMatchParams_plist.begin();
      FcalSingleHitMatchParams *p = (FcalSingleHitMatchParams*)hdf5_record.vl_fcalSingleHitMatchParams.p;
      for (int i=0; i < (int)len; ++i, ++iter) {
         hdf5_memcpy(p+i, *iter, size);
         p[i].hdf5DataPack();
      }
   }
   if ((len = hdf5_record.vl_fdcPseudos.len = m_fdcPseudos_plist.size()) > 0) {
      size = sizeof(FdcPseudos);
      hdf5_record.vl_fdcPseudos.p = malloc(len * size);
      std::list<FdcPseudos*>::iterator iter = m_fdcPseudos_plist.begin();
      FdcPseudos *p = (FdcPseudos*)hdf5_record.vl_fdcPseudos.p;
      for (int i=0; i < (int)len; ++i, ++iter) {
         hdf5_memcpy(p+i, *iter, size);
         p[i].hdf5DataPack();
      }
   }
   if ((len = hdf5_record.vl_fmwpcData.len = m_fmwpcData_plist.size()) > 0) {
      size = sizeof(FmwpcData);
      hdf5_record.vl_fmwpcData.p = malloc(len * size);
      std::list<FmwpcData*>::iterator iter = m_fmwpcData_plist.begin();
      FmwpcData *p = (FmwpcData*)hdf5_record.vl_fmwpcData.p;
      for (int i=0; i < (int)len; ++i, ++iter) {
         hdf5_memcpy(p+i, *iter, size);
         p[i].hdf5DataPack();
      }
   }
   if ((len = hdf5_record.vl_fmwpcHit.len = m_fmwpcHit_plist.size()) > 0) {
      size = sizeof(FmwpcHit);
      hdf5_record.vl_fmwpcHit.p = malloc(len * size);
      std::list<FmwpcHit*>::iterator iter = m_fmwpcHit_plist.begin();
      FmwpcHit *p = (FmwpcHit*)hdf5_record.vl_fmwpcHit.p;
      for (int i=0; i < (int)len; ++i, ++iter) {
         hdf5_memcpy(p+i, *iter, size);
         p[i].hdf5DataPack();
      }
   }
   if ((len = hdf5_record.vl_fmwpcMatchParams.len = m_fmwpcMatchParams_plist.size()) > 0) {
      size = sizeof(FmwpcMatchParams);
      hdf5_record.vl_fmwpcMatchParams.p = malloc(len * size);
      std::list<FmwpcMatchParams*>::iterator iter = m_fmwpcMatchParams_plist.begin();
      FmwpcMatchParams *p = (FmwpcMatchParams*)hdf5_record.vl_fmwpcMatchParams.p;
      for (int i=0; i < (int)len; ++i, ++iter) {
         hdf5_memcpy(p+i, *iter, size);
         p[i].hdf5DataPack();
      }
   }
   if ((len = hdf5_record.vl_hitStatistics.len = m_hitStatistics_plist.size()) > 0) {
      size = sizeof(HitStatistics);
      hdf5_record.vl_hitStatistics.p = malloc(len * size);
      std::list<HitStatistics*>::iterator iter = m_hitStatistics_plist.begin();
      HitStatistics *p = (HitStatistics*)hdf5_record.vl_hitStatistics.p;
      for (int i=0; i < (int)len; ++i, ++iter) {
         hdf5_memcpy(p+i, *iter, size);
         p[i].hdf5DataPack();
      }
   }
   if ((len = hdf5_record.vl_hitlayers.len = m_hitlayers_plist.size()) > 0) {
      size = sizeof(Hitlayers);
      hdf5_record.vl_hitlayers.p = malloc(len * size);
      std::list<Hitlayers*>::iterator iter = m_hitlayers_plist.begin();
      Hitlayers *p = (Hitlayers*)hdf5_record.vl_hitlayers.p;
      for (int i=0; i < (int)len; ++i, ++iter) {
         hdf5_memcpy(p+i, *iter, size);
         p[i].hdf5DataPack();
      }
   }
   if ((len = hdf5_record.vl_mcmatch.len = m_mcmatch_plist.size()) > 0) {
      size = sizeof(Mcmatch);
      hdf5_record.vl_mcmatch.p = malloc(len * size);
      std::list<Mcmatch*>::iterator iter = m_mcmatch_plist.begin();
      Mcmatch *p = (Mcmatch*)hdf5_record.vl_mcmatch.p;
      for (int i=0; i < (int)len; ++i, ++iter) {
         hdf5_memcpy(p+i, *iter, size);
         p[i].hdf5DataPack();
      }
   }
   if ((len = hdf5_record.vl_momentum.len = m_momentum_plist.size()) > 0) {
      size = sizeof(Momentum);
      hdf5_record.vl_momentum.p = malloc(len * size);
      std::list<Momentum*>::iterator iter = m_momentum_plist.begin();
      Momentum *p = (Momentum*)hdf5_record.vl_momentum.p;
      for (int i=0; i < (int)len; ++i, ++iter) {
         hdf5_memcpy(p+i, *iter, size);
         p[i].hdf5DataPack();
      }
   }
   if ((len = hdf5_record.vl_origin.len = m_origin_plist.size()) > 0) {
      size = sizeof(Origin);
      hdf5_record.vl_origin.p = malloc(len * size);
      std::list<Origin*>::iterator iter = m_origin_plist.begin();
      Origin *p = (Origin*)hdf5_record.vl_origin.p;
      for (int i=0; i < (int)len; ++i, ++iter) {
         hdf5_memcpy(p+i, *iter, size);
         p[i].hdf5DataPack();
      }
   }
   if ((len = hdf5_record.vl_preshower.len = m_preshower_plist.size()) > 0) {
      size = sizeof(Preshower);
      hdf5_record.vl_preshower.p = malloc(len * size);
      std::list<Preshower*>::iterator iter = m_preshower_plist.begin();
      Preshower *p = (Preshower*)hdf5_record.vl_preshower.p;
      for (int i=0; i < (int)len; ++i, ++iter) {
         hdf5_memcpy(p+i, *iter, size);
         p[i].hdf5DataPack();
      }
   }
   if ((len = hdf5_record.vl_product.len = m_product_plist.size()) > 0) {
      size = sizeof(Product);
      hdf5_record.vl_product.p = malloc(len * size);
      std::list<Product*>::iterator iter = m_product_plist.begin();
      Product *p = (Product*)hdf5_record.vl_product.p;
      for (int i=0; i < (int)len; ++i, ++iter) {
         hdf5_memcpy(p+i, *iter, size);
         p[i].hdf5DataPack();
      }
   }
   if ((len = hdf5_record.vl_reaction.len = m_reaction_plist.size()) > 0) {
      size = sizeof(Reaction);
      hdf5_record.vl_reaction.p = malloc(len * size);
      std::list<Reaction*>::iterator iter = m_reaction_plist.begin();
      Reaction *p = (Reaction*)hdf5_record.vl_reaction.p;
      for (int i=0; i < (int)len; ++i, ++iter) {
         hdf5_memcpy(p+i, *iter, size);
         p[i].hdf5DataPack();
      }
   }
   if ((len = hdf5_record.vl_reconstructedPhysicsEvent.len = m_reconstructedPhysicsEvent_plist.size()) > 0) {
      size = sizeof(ReconstructedPhysicsEvent);
      hdf5_record.vl_reconstructedPhysicsEvent.p = malloc(len * size);
      std::list<ReconstructedPhysicsEvent*>::iterator iter = m_reconstructedPhysicsEvent_plist.begin();
      ReconstructedPhysicsEvent *p = (ReconstructedPhysicsEvent*)hdf5_record.vl_reconstructedPhysicsEvent.p;
      for (int i=0; i < (int)len; ++i, ++iter) {
         hdf5_memcpy(p+i, *iter, size);
         p[i].hdf5DataPack();
      }
   }
   if ((len = hdf5_record.vl_scMatchParams.len = m_scMatchParams_plist.size()) > 0) {
      size = sizeof(ScMatchParams);
      hdf5_record.vl_scMatchParams.p = malloc(len * size);
      std::list<ScMatchParams*>::iterator iter = m_scMatchParams_plist.begin();
      ScMatchParams *p = (ScMatchParams*)hdf5_record.vl_scMatchParams.p;
      for (int i=0; i < (int)len; ++i, ++iter) {
         hdf5_memcpy(p+i, *iter, size);
         p[i].hdf5DataPack();
      }
   }
   if ((len = hdf5_record.vl_startCounters.len = m_startCounters_plist.size()) > 0) {
      size = sizeof(StartCounters);
      hdf5_record.vl_startCounters.p = malloc(len * size);
      std::list<StartCounters*>::iterator iter = m_startCounters_plist.begin();
      StartCounters *p = (StartCounters*)hdf5_record.vl_startCounters.p;
      for (int i=0; i < (int)len; ++i, ++iter) {
         hdf5_memcpy(p+i, *iter, size);
         p[i].hdf5DataPack();
      }
   }
   if ((len = hdf5_record.vl_startHit.len = m_startHit_plist.size()) > 0) {
      size = sizeof(StartHit);
      hdf5_record.vl_startHit.p = malloc(len * size);
      std::list<StartHit*>::iterator iter = m_startHit_plist.begin();
      StartHit *p = (StartHit*)hdf5_record.vl_startHit.p;
      for (int i=0; i < (int)len; ++i, ++iter) {
         hdf5_memcpy(p+i, *iter, size);
         p[i].hdf5DataPack();
      }
   }
   if ((len = hdf5_record.vl_taghBeamPhoton.len = m_taghBeamPhoton_plist.size()) > 0) {
      size = sizeof(TaghBeamPhoton);
      hdf5_record.vl_taghBeamPhoton.p = malloc(len * size);
      std::list<TaghBeamPhoton*>::iterator iter = m_taghBeamPhoton_plist.begin();
      TaghBeamPhoton *p = (TaghBeamPhoton*)hdf5_record.vl_taghBeamPhoton.p;
      for (int i=0; i < (int)len; ++i, ++iter) {
         hdf5_memcpy(p+i, *iter, size);
         p[i].hdf5DataPack();
      }
   }
   if ((len = hdf5_record.vl_taghChannel.len = m_taghChannel_plist.size()) > 0) {
      size = sizeof(TaghChannel);
      hdf5_record.vl_taghChannel.p = malloc(len * size);
      std::list<TaghChannel*>::iterator iter = m_taghChannel_plist.begin();
      TaghChannel *p = (TaghChannel*)hdf5_record.vl_taghChannel.p;
      for (int i=0; i < (int)len; ++i, ++iter) {
         hdf5_memcpy(p+i, *iter, size);
         p[i].hdf5DataPack();
      }
   }
   if ((len = hdf5_record.vl_tagmBeamPhoton.len = m_tagmBeamPhoton_plist.size()) > 0) {
      size = sizeof(TagmBeamPhoton);
      hdf5_record.vl_tagmBeamPhoton.p = malloc(len * size);
      std::list<TagmBeamPhoton*>::iterator iter = m_tagmBeamPhoton_plist.begin();
      TagmBeamPhoton *p = (TagmBeamPhoton*)hdf5_record.vl_tagmBeamPhoton.p;
      for (int i=0; i < (int)len; ++i, ++iter) {
         hdf5_memcpy(p+i, *iter, size);
         p[i].hdf5DataPack();
      }
   }
   if ((len = hdf5_record.vl_tagmChannel.len = m_tagmChannel_plist.size()) > 0) {
      size = sizeof(TagmChannel);
      hdf5_record.vl_tagmChannel.p = malloc(len * size);
      std::list<TagmChannel*>::iterator iter = m_tagmChannel_plist.begin();
      TagmChannel *p = (TagmChannel*)hdf5_record.vl_tagmChannel.p;
      for (int i=0; i < (int)len; ++i, ++iter) {
         hdf5_memcpy(p+i, *iter, size);
         p[i].hdf5DataPack();
      }
   }
   if ((len = hdf5_record.vl_tflightPCorrelation.len = m_tflightPCorrelation_plist.size()) > 0) {
      size = sizeof(TflightPCorrelation);
      hdf5_record.vl_tflightPCorrelation.p = malloc(len * size);
      std::list<TflightPCorrelation*>::iterator iter = m_tflightPCorrelation_plist.begin();
      TflightPCorrelation *p = (TflightPCorrelation*)hdf5_record.vl_tflightPCorrelation.p;
      for (int i=0; i < (int)len; ++i, ++iter) {
         hdf5_memcpy(p+i, *iter, size);
         p[i].hdf5DataPack();
      }
   }
   if ((len = hdf5_record.vl_tofDedx.len = m_tofDedx_plist.size()) > 0) {
      size = sizeof(TofDedx);
      hdf5_record.vl_tofDedx.p = malloc(len * size);
      std::list<TofDedx*>::iterator iter = m_tofDedx_plist.begin();
      TofDedx *p = (TofDedx*)hdf5_record.vl_tofDedx.p;
      for (int i=0; i < (int)len; ++i, ++iter) {
         hdf5_memcpy(p+i, *iter, size);
         p[i].hdf5DataPack();
      }
   }
   if ((len = hdf5_record.vl_tofEnergyDeposition.len = m_tofEnergyDeposition_plist.size()) > 0) {
      size = sizeof(TofEnergyDeposition);
      hdf5_record.vl_tofEnergyDeposition.p = malloc(len * size);
      std::list<TofEnergyDeposition*>::iterator iter = m_tofEnergyDeposition_plist.begin();
      TofEnergyDeposition *p = (TofEnergyDeposition*)hdf5_record.vl_tofEnergyDeposition.p;
      for (int i=0; i < (int)len; ++i, ++iter) {
         hdf5_memcpy(p+i, *iter, size);
         p[i].hdf5DataPack();
      }
   }
   if ((len = hdf5_record.vl_tofMatchParams.len = m_tofMatchParams_plist.size()) > 0) {
      size = sizeof(TofMatchParams);
      hdf5_record.vl_tofMatchParams.p = malloc(len * size);
      std::list<TofMatchParams*>::iterator iter = m_tofMatchParams_plist.begin();
      TofMatchParams *p = (TofMatchParams*)hdf5_record.vl_tofMatchParams.p;
      for (int i=0; i < (int)len; ++i, ++iter) {
         hdf5_memcpy(p+i, *iter, size);
         p[i].hdf5DataPack();
      }
   }
   if ((len = hdf5_record.vl_tofPaddles.len = m_tofPaddles_plist.size()) > 0) {
      size = sizeof(TofPaddles);
      hdf5_record.vl_tofPaddles.p = malloc(len * size);
      std::list<TofPaddles*>::iterator iter = m_tofPaddles_plist.begin();
      TofPaddles *p = (TofPaddles*)hdf5_record.vl_tofPaddles.p;
      for (int i=0; i < (int)len; ++i, ++iter) {
         hdf5_memcpy(p+i, *iter, size);
         p[i].hdf5DataPack();
      }
   }
   if ((len = hdf5_record.vl_tofPoint.len = m_tofPoint_plist.size()) > 0) {
      size = sizeof(TofPoint);
      hdf5_record.vl_tofPoint.p = malloc(len * size);
      std::list<TofPoint*>::iterator iter = m_tofPoint_plist.begin();
      TofPoint *p = (TofPoint*)hdf5_record.vl_tofPoint.p;
      for (int i=0; i < (int)len; ++i, ++iter) {
         hdf5_memcpy(p+i, *iter, size);
         p[i].hdf5DataPack();
      }
   }
   if ((len = hdf5_record.vl_tofStatus.len = m_tofStatus_plist.size()) > 0) {
      size = sizeof(TofStatus);
      hdf5_record.vl_tofStatus.p = malloc(len * size);
      std::list<TofStatus*>::iterator iter = m_tofStatus_plist.begin();
      TofStatus *p = (TofStatus*)hdf5_record.vl_tofStatus.p;
      for (int i=0; i < (int)len; ++i, ++iter) {
         hdf5_memcpy(p+i, *iter, size);
         p[i].hdf5DataPack();
      }
   }
   if ((len = hdf5_record.vl_trackFit.len = m_trackFit_plist.size()) > 0) {
      size = sizeof(TrackFit);
      hdf5_record.vl_trackFit.p = malloc(len * size);
      std::list<TrackFit*>::iterator iter = m_trackFit_plist.begin();
      TrackFit *p = (TrackFit*)hdf5_record.vl_trackFit.p;
      for (int i=0; i < (int)len; ++i, ++iter) {
         hdf5_memcpy(p+i, *iter, size);
         p[i].hdf5DataPack();
      }
   }
   if ((len = hdf5_record.vl_trackFlags.len = m_trackFlags_plist.size()) > 0) {
      size = sizeof(TrackFlags);
      hdf5_record.vl_trackFlags.p = malloc(len * size);
      std::list<TrackFlags*>::iterator iter = m_trackFlags_plist.begin();
      TrackFlags *p = (TrackFlags*)hdf5_record.vl_trackFlags.p;
      for (int i=0; i < (int)len; ++i, ++iter) {
         hdf5_memcpy(p+i, *iter, size);
         p[i].hdf5DataPack();
      }
   }
   if ((len = hdf5_record.vl_trigger.len = m_trigger_plist.size()) > 0) {
      size = sizeof(Trigger);
      hdf5_record.vl_trigger.p = malloc(len * size);
      std::list<Trigger*>::iterator iter = m_trigger_plist.begin();
      Trigger *p = (Trigger*)hdf5_record.vl_trigger.p;
      for (int i=0; i < (int)len; ++i, ++iter) {
         hdf5_memcpy(p+i, *iter, size);
         p[i].hdf5DataPack();
      }
   }
   if ((len = hdf5_record.vl_triggerEnergySums.len = m_triggerEnergySums_plist.size()) > 0) {
      size = sizeof(TriggerEnergySums);
      hdf5_record.vl_triggerEnergySums.p = malloc(len * size);
      std::list<TriggerEnergySums*>::iterator iter = m_triggerEnergySums_plist.begin();
      TriggerEnergySums *p = (TriggerEnergySums*)hdf5_record.vl_triggerEnergySums.p;
      for (int i=0; i < (int)len; ++i, ++iter) {
         hdf5_memcpy(p+i, *iter, size);
         p[i].hdf5DataPack();
      }
   }
   if ((len = hdf5_record.vl_vertex.len = m_vertex_plist.size()) > 0) {
      size = sizeof(Vertex);
      hdf5_record.vl_vertex.p = malloc(len * size);
      std::list<Vertex*>::iterator iter = m_vertex_plist.begin();
      Vertex *p = (Vertex*)hdf5_record.vl_vertex.p;
      for (int i=0; i < (int)len; ++i, ++iter) {
         hdf5_memcpy(p+i, *iter, size);
         p[i].hdf5DataPack();
      }
   }
   if ((len = hdf5_record.vl_width.len = m_width_plist.size()) > 0) {
      size = sizeof(Width);
      hdf5_record.vl_width.p = malloc(len * size);
      std::list<Width*>::iterator iter = m_width_plist.begin();
      Width *p = (Width*)hdf5_record.vl_width.p;
      for (int i=0; i < (int)len; ++i, ++iter) {
         hdf5_memcpy(p+i, *iter, size);
         p[i].hdf5DataPack();
      }
   }
   hid_t eventtype_id = hdf5Datatype();
   hid_t memorytype_id = hdf5Datatype(1);
   hid_t chunking_id;
   if (s_hdf5_chunking.find(file_id) == s_hdf5_chunking.end()) {
      hdf5SetChunksize(file_id, HDF5_DEFAULT_CHUNK_SIZE);
   }
   chunking_id = s_hdf5_chunking[file_id];
   hid_t memoryspace_id;
   if (s_hdf5_memoryspace.find("HDDM") == s_hdf5_memoryspace.end()) {
      hsize_t dims[1] = {1};
      hsize_t maxdims[1] = {H5S_UNLIMITED};
      memoryspace_id = H5Screate_simple(1, dims, maxdims);
      s_hdf5_memoryspace["HDDM"] = memoryspace_id;
   }
   else {
      memoryspace_id = s_hdf5_memoryspace["HDDM"];
   }
   hid_t eventspace_id;
   if (s_hdf5_dataspace.find(file_id) == s_hdf5_dataspace.end()) {
      hsize_t dims[1] = {1};
      hsize_t maxdims[1] = {H5S_UNLIMITED};
      eventspace_id = H5Screate_simple(1, dims, maxdims);
      s_hdf5_dataspace[file_id] = eventspace_id;
   }
   else {
      eventspace_id = HDDM::s_hdf5_dataspace[file_id];
   }
   hid_t eventdata_id;
   if (s_hdf5_dataset.find(file_id) == s_hdf5_dataset.end()) {
      eventdata_id = H5Dcreate(file_id, "HDDMevents",
                               eventtype_id, eventspace_id,
                               H5P_DEFAULT, chunking_id,
                               H5P_DEFAULT);
      s_hdf5_dataset[file_id] = eventdata_id;
      m_hdf5_record_extent = 0;
      m_hdf5_record_offset = 0;
   }
   else {
      eventdata_id = s_hdf5_dataset[file_id];
      hsize_t maxdims;
      H5Sget_simple_extent_dims(eventspace_id, &m_hdf5_record_extent, &maxdims);
      H5Sget_select_bounds(eventspace_id, &m_hdf5_record_offset, &maxdims);
      ++m_hdf5_record_offset;
   }
   if (entry >= 0) {
      m_hdf5_record_offset = entry;
   }
   if (m_hdf5_record_offset >= m_hdf5_record_extent) {
      m_hdf5_record_extent = m_hdf5_record_offset + 1;
      H5Dset_extent(eventdata_id, &m_hdf5_record_extent);
      H5Sclose(eventspace_id);
      eventspace_id = H5Dget_space(eventdata_id);
      s_hdf5_dataspace[file_id] = eventspace_id;
   }
   hsize_t hdf5_record_count = 1;
   H5Sselect_hyperslab(eventspace_id, H5S_SELECT_SET,
                       &m_hdf5_record_offset, NULL,
                       &hdf5_record_count, NULL);
   herr_t res = H5Dwrite(eventdata_id, memorytype_id,
                         memoryspace_id, eventspace_id,
                         H5P_DEFAULT, &hdf5_record);
   if ((len = hdf5_record.vl_CDCAmpdEdx.len = m_CDCAmpdEdx_plist.size()) > 0) {
      free(hdf5_record.vl_CDCAmpdEdx.p);
   }
   if ((len = hdf5_record.vl_CDCdEdxTrunc.len = m_CDCdEdxTrunc_plist.size()) > 0) {
      free(hdf5_record.vl_CDCdEdxTrunc.p);
   }
   if ((len = hdf5_record.vl_FDCdEdxTrunc.len = m_FDCdEdxTrunc_plist.size()) > 0) {
      free(hdf5_record.vl_FDCdEdxTrunc.p);
   }
   if ((len = hdf5_record.vl_RFtime.len = m_RFtime_plist.size()) > 0) {
      free(hdf5_record.vl_RFtime.p);
   }
   if ((len = hdf5_record.vl_bcalCells.len = m_bcalCells_plist.size()) > 0) {
      free(hdf5_record.vl_bcalCells.p);
   }
   if ((len = hdf5_record.vl_bcalCluster.len = m_bcalCluster_plist.size()) > 0) {
      free(hdf5_record.vl_bcalCluster.p);
   }
   if ((len = hdf5_record.vl_bcalCorrelations.len = m_bcalCorrelations_plist.size()) > 0) {
      free(hdf5_record.vl_bcalCorrelations.p);
   }
   if ((len = hdf5_record.vl_bcalDOCAtoTrack.len = m_bcalDOCAtoTrack_plist.size()) > 0) {
      free(hdf5_record.vl_bcalDOCAtoTrack.p);
   }
   if ((len = hdf5_record.vl_bcalLayers.len = m_bcalLayers_plist.size()) > 0) {
      free(hdf5_record.vl_bcalLayers.p);
   }
   if ((len = hdf5_record.vl_bcalMatchParams.len = m_bcalMatchParams_plist.size()) > 0) {
      free(hdf5_record.vl_bcalMatchParams.p);
   }
   if ((len = hdf5_record.vl_bcalShower.len = m_bcalShower_plist.size()) > 0) {
      free(hdf5_record.vl_bcalShower.p);
   }
   if ((len = hdf5_record.vl_ccalBlocks.len = m_ccalBlocks_plist.size()) > 0) {
      free(hdf5_record.vl_ccalBlocks.p);
   }
   if ((len = hdf5_record.vl_ccalShower.len = m_ccalShower_plist.size()) > 0) {
      free(hdf5_record.vl_ccalShower.p);
   }
   if ((len = hdf5_record.vl_ccdbContext.len = m_ccdbContext_plist.size()) > 0) {
      free(hdf5_record.vl_ccdbContext.p);
   }
   if ((len = hdf5_record.vl_cdcStraws.len = m_cdcStraws_plist.size()) > 0) {
      free(hdf5_record.vl_cdcStraws.p);
   }
   if ((len = hdf5_record.vl_chargedTrack.len = m_chargedTrack_plist.size()) > 0) {
      free(hdf5_record.vl_chargedTrack.p);
   }
   if ((len = hdf5_record.vl_comment.len = m_comment_plist.size()) > 0) {
      free(hdf5_record.vl_comment.p);
   }
   if ((len = hdf5_record.vl_ctofMatchParams.len = m_ctofMatchParams_plist.size()) > 0) {
      free(hdf5_record.vl_ctofMatchParams.p);
   }
   if ((len = hdf5_record.vl_ctofPoint.len = m_ctofPoint_plist.size()) > 0) {
      free(hdf5_record.vl_ctofPoint.p);
   }
   if ((len = hdf5_record.vl_dEdxDC.len = m_dEdxDC_plist.size()) > 0) {
      free(hdf5_record.vl_dEdxDC.p);
   }
   if ((len = hdf5_record.vl_dataVersionString.len = m_dataVersionString_plist.size()) > 0) {
      free(hdf5_record.vl_dataVersionString.p);
   }
   if ((len = hdf5_record.vl_detectorMatches.len = m_detectorMatches_plist.size()) > 0) {
      free(hdf5_record.vl_detectorMatches.p);
   }
   if ((len = hdf5_record.vl_dircHit.len = m_dircHit_plist.size()) > 0) {
      free(hdf5_record.vl_dircHit.p);
   }
   if ((len = hdf5_record.vl_dircMatchHit.len = m_dircMatchHit_plist.size()) > 0) {
      free(hdf5_record.vl_dircMatchHit.p);
   }
   if ((len = hdf5_record.vl_dircMatchParams.len = m_dircMatchParams_plist.size()) > 0) {
      free(hdf5_record.vl_dircMatchParams.p);
   }
   if ((len = hdf5_record.vl_dircPMTs.len = m_dircPMTs_plist.size()) > 0) {
      free(hdf5_record.vl_dircPMTs.p);
   }
   if ((len = hdf5_record.vl_exitParams.len = m_exitParams_plist.size()) > 0) {
      free(hdf5_record.vl_exitParams.p);
   }
   if ((len = hdf5_record.vl_expectedhits.len = m_expectedhits_plist.size()) > 0) {
      free(hdf5_record.vl_expectedhits.p);
   }
   if ((len = hdf5_record.vl_fcalBlocks.len = m_fcalBlocks_plist.size()) > 0) {
      free(hdf5_record.vl_fcalBlocks.p);
   }
   if ((len = hdf5_record.vl_fcalCorrelations.len = m_fcalCorrelations_plist.size()) > 0) {
      free(hdf5_record.vl_fcalCorrelations.p);
   }
   if ((len = hdf5_record.vl_fcalDOCAtoTrack.len = m_fcalDOCAtoTrack_plist.size()) > 0) {
      free(hdf5_record.vl_fcalDOCAtoTrack.p);
   }
   if ((len = hdf5_record.vl_fcalEnergyParams.len = m_fcalEnergyParams_plist.size()) > 0) {
      free(hdf5_record.vl_fcalEnergyParams.p);
   }
   if ((len = hdf5_record.vl_fcalHit.len = m_fcalHit_plist.size()) > 0) {
      free(hdf5_record.vl_fcalHit.p);
   }
   if ((len = hdf5_record.vl_fcalMatchParams.len = m_fcalMatchParams_plist.size()) > 0) {
      free(hdf5_record.vl_fcalMatchParams.p);
   }
   if ((len = hdf5_record.vl_fcalShower.len = m_fcalShower_plist.size()) > 0) {
      free(hdf5_record.vl_fcalShower.p);
   }
   if ((len = hdf5_record.vl_fcalShowerClassification.len = m_fcalShowerClassification_plist.size()) > 0) {
      free(hdf5_record.vl_fcalShowerClassification.p);
   }
   if ((len = hdf5_record.vl_fcalShowerNBlocks.len = m_fcalShowerNBlocks_plist.size()) > 0) {
      free(hdf5_record.vl_fcalShowerNBlocks.p);
   }
   if ((len = hdf5_record.vl_fcalShowerProperties.len = m_fcalShowerProperties_plist.size()) > 0) {
      free(hdf5_record.vl_fcalShowerProperties.p);
   }
   if ((len = hdf5_record.vl_fcalSingleHitMatchParams.len = m_fcalSingleHitMatchParams_plist.size()) > 0) {
      free(hdf5_record.vl_fcalSingleHitMatchParams.p);
   }
   if ((len = hdf5_record.vl_fdcPseudos.len = m_fdcPseudos_plist.size()) > 0) {
      free(hdf5_record.vl_fdcPseudos.p);
   }
   if ((len = hdf5_record.vl_fmwpcData.len = m_fmwpcData_plist.size()) > 0) {
      free(hdf5_record.vl_fmwpcData.p);
   }
   if ((len = hdf5_record.vl_fmwpcHit.len = m_fmwpcHit_plist.size()) > 0) {
      free(hdf5_record.vl_fmwpcHit.p);
   }
   if ((len = hdf5_record.vl_fmwpcMatchParams.len = m_fmwpcMatchParams_plist.size()) > 0) {
      free(hdf5_record.vl_fmwpcMatchParams.p);
   }
   if ((len = hdf5_record.vl_hitStatistics.len = m_hitStatistics_plist.size()) > 0) {
      free(hdf5_record.vl_hitStatistics.p);
   }
   if ((len = hdf5_record.vl_hitlayers.len = m_hitlayers_plist.size()) > 0) {
      free(hdf5_record.vl_hitlayers.p);
   }
   if ((len = hdf5_record.vl_mcmatch.len = m_mcmatch_plist.size()) > 0) {
      free(hdf5_record.vl_mcmatch.p);
   }
   if ((len = hdf5_record.vl_momentum.len = m_momentum_plist.size()) > 0) {
      free(hdf5_record.vl_momentum.p);
   }
   if ((len = hdf5_record.vl_origin.len = m_origin_plist.size()) > 0) {
      free(hdf5_record.vl_origin.p);
   }
   if ((len = hdf5_record.vl_preshower.len = m_preshower_plist.size()) > 0) {
      free(hdf5_record.vl_preshower.p);
   }
   if ((len = hdf5_record.vl_product.len = m_product_plist.size()) > 0) {
      free(hdf5_record.vl_product.p);
   }
   if ((len = hdf5_record.vl_reaction.len = m_reaction_plist.size()) > 0) {
      free(hdf5_record.vl_reaction.p);
   }
   if ((len = hdf5_record.vl_reconstructedPhysicsEvent.len = m_reconstructedPhysicsEvent_plist.size()) > 0) {
      free(hdf5_record.vl_reconstructedPhysicsEvent.p);
   }
   if ((len = hdf5_record.vl_scMatchParams.len = m_scMatchParams_plist.size()) > 0) {
      free(hdf5_record.vl_scMatchParams.p);
   }
   if ((len = hdf5_record.vl_startCounters.len = m_startCounters_plist.size()) > 0) {
      free(hdf5_record.vl_startCounters.p);
   }
   if ((len = hdf5_record.vl_startHit.len = m_startHit_plist.size()) > 0) {
      free(hdf5_record.vl_startHit.p);
   }
   if ((len = hdf5_record.vl_taghBeamPhoton.len = m_taghBeamPhoton_plist.size()) > 0) {
      free(hdf5_record.vl_taghBeamPhoton.p);
   }
   if ((len = hdf5_record.vl_taghChannel.len = m_taghChannel_plist.size()) > 0) {
      free(hdf5_record.vl_taghChannel.p);
   }
   if ((len = hdf5_record.vl_tagmBeamPhoton.len = m_tagmBeamPhoton_plist.size()) > 0) {
      free(hdf5_record.vl_tagmBeamPhoton.p);
   }
   if ((len = hdf5_record.vl_tagmChannel.len = m_tagmChannel_plist.size()) > 0) {
      free(hdf5_record.vl_tagmChannel.p);
   }
   if ((len = hdf5_record.vl_tflightPCorrelation.len = m_tflightPCorrelation_plist.size()) > 0) {
      free(hdf5_record.vl_tflightPCorrelation.p);
   }
   if ((len = hdf5_record.vl_tofDedx.len = m_tofDedx_plist.size()) > 0) {
      free(hdf5_record.vl_tofDedx.p);
   }
   if ((len = hdf5_record.vl_tofEnergyDeposition.len = m_tofEnergyDeposition_plist.size()) > 0) {
      free(hdf5_record.vl_tofEnergyDeposition.p);
   }
   if ((len = hdf5_record.vl_tofMatchParams.len = m_tofMatchParams_plist.size()) > 0) {
      free(hdf5_record.vl_tofMatchParams.p);
   }
   if ((len = hdf5_record.vl_tofPaddles.len = m_tofPaddles_plist.size()) > 0) {
      free(hdf5_record.vl_tofPaddles.p);
   }
   if ((len = hdf5_record.vl_tofPoint.len = m_tofPoint_plist.size()) > 0) {
      free(hdf5_record.vl_tofPoint.p);
   }
   if ((len = hdf5_record.vl_tofStatus.len = m_tofStatus_plist.size()) > 0) {
      free(hdf5_record.vl_tofStatus.p);
   }
   if ((len = hdf5_record.vl_trackFit.len = m_trackFit_plist.size()) > 0) {
      free(hdf5_record.vl_trackFit.p);
   }
   if ((len = hdf5_record.vl_trackFlags.len = m_trackFlags_plist.size()) > 0) {
      free(hdf5_record.vl_trackFlags.p);
   }
   if ((len = hdf5_record.vl_trigger.len = m_trigger_plist.size()) > 0) {
      free(hdf5_record.vl_trigger.p);
   }
   if ((len = hdf5_record.vl_triggerEnergySums.len = m_triggerEnergySums_plist.size()) > 0) {
      free(hdf5_record.vl_triggerEnergySums.p);
   }
   if ((len = hdf5_record.vl_vertex.len = m_vertex_plist.size()) > 0) {
      free(hdf5_record.vl_vertex.p);
   }
   if ((len = hdf5_record.vl_width.len = m_width_plist.size()) > 0) {
      free(hdf5_record.vl_width.p);
   }
   return res;
}
herr_t HDDM::hdf5FileRead(hid_t file_id, long int entry)
{
   clear();
   hid_t memorytype_id = hdf5Datatype(1);
   hid_t memoryspace_id;
   if (s_hdf5_memoryspace.find("HDDM") == s_hdf5_memoryspace.end()) {
      hsize_t dims[1] = {1};
      hsize_t maxdims[1] = {H5S_UNLIMITED};
      memoryspace_id = H5Screate_simple(1, dims, maxdims);
      s_hdf5_memoryspace["HDDM"] = memoryspace_id;
   }
   else {
      memoryspace_id = s_hdf5_memoryspace["HDDM"];
   }
   hid_t eventdata_id;
   hid_t chunking_id;
   if (s_hdf5_dataset.find(file_id) == s_hdf5_dataset.end()) {

      eventdata_id = H5Dopen(file_id, "HDDMevents",
                               H5P_DEFAULT);
      chunking_id = H5Dget_create_plist(eventdata_id);
      s_hdf5_dataset[file_id] = eventdata_id;      s_hdf5_chunking[file_id] = chunking_id;
   }
   else {
      eventdata_id = s_hdf5_dataset[file_id];
      chunking_id = s_hdf5_chunking[file_id];
   }
   hid_t eventspace_id;
   if (s_hdf5_dataspace.find(file_id) == s_hdf5_dataspace.end()) {
      eventspace_id = H5Dget_space(eventdata_id);
      s_hdf5_dataspace[file_id] = eventspace_id;
      hsize_t maxdims;
      H5Sget_simple_extent_dims(eventspace_id, &m_hdf5_record_extent, &maxdims);
      m_hdf5_record_offset = 0;
   }
   else {
      eventspace_id = HDDM::s_hdf5_dataspace[file_id];
      hsize_t maxdims;
      H5Sget_simple_extent_dims(eventspace_id, &m_hdf5_record_extent, &maxdims);
      H5Sget_select_bounds(eventspace_id, &m_hdf5_record_offset, &maxdims);
      ++m_hdf5_record_offset;
   }
   if (entry >= 0) {
      m_hdf5_record_offset = entry;
   }
   if (m_hdf5_record_offset >= m_hdf5_record_extent)
      return -1;
   m_hdf5_record_count = 1;
   H5Sselect_hyperslab(eventspace_id, H5S_SELECT_SET,
                       &m_hdf5_record_offset, NULL,
                       &m_hdf5_record_count, NULL);
   herr_t res = H5Dread(eventdata_id, memorytype_id,
                        memoryspace_id, eventspace_id,
                        H5P_DEFAULT, &m_hdf5_record);
   size_t len;
   if ((len = m_hdf5_record.vl_CDCAmpdEdx.len) > 0) {
      CDCAmpdEdx *p =(CDCAmpdEdx*)m_hdf5_record.vl_CDCAmpdEdx.p;
      for (int i=0; i < (int)len; ++i ) {
         m_CDCAmpdEdx_plist.push_back(new(p+i) CDCAmpdEdx);
      }
   }
   if ((len = m_hdf5_record.vl_CDCdEdxTrunc.len) > 0) {
      CDCdEdxTrunc *p =(CDCdEdxTrunc*)m_hdf5_record.vl_CDCdEdxTrunc.p;
      for (int i=0; i < (int)len; ++i ) {
         m_CDCdEdxTrunc_plist.push_back(new(p+i) CDCdEdxTrunc);
      }
   }
   if ((len = m_hdf5_record.vl_FDCdEdxTrunc.len) > 0) {
      FDCdEdxTrunc *p =(FDCdEdxTrunc*)m_hdf5_record.vl_FDCdEdxTrunc.p;
      for (int i=0; i < (int)len; ++i ) {
         m_FDCdEdxTrunc_plist.push_back(new(p+i) FDCdEdxTrunc);
      }
   }
   if ((len = m_hdf5_record.vl_RFtime.len) > 0) {
      RFtime *p =(RFtime*)m_hdf5_record.vl_RFtime.p;
      for (int i=0; i < (int)len; ++i ) {
         m_RFtime_plist.push_back(new(p+i) RFtime);
      }
   }
   if ((len = m_hdf5_record.vl_bcalCells.len) > 0) {
      BcalCells *p =(BcalCells*)m_hdf5_record.vl_bcalCells.p;
      for (int i=0; i < (int)len; ++i ) {
         m_bcalCells_plist.push_back(new(p+i) BcalCells);
      }
   }
   if ((len = m_hdf5_record.vl_bcalCluster.len) > 0) {
      BcalCluster *p =(BcalCluster*)m_hdf5_record.vl_bcalCluster.p;
      for (int i=0; i < (int)len; ++i ) {
         m_bcalCluster_plist.push_back(new(p+i) BcalCluster);
      }
   }
   if ((len = m_hdf5_record.vl_bcalCorrelations.len) > 0) {
      BcalCorrelations *p =(BcalCorrelations*)m_hdf5_record.vl_bcalCorrelations.p;
      for (int i=0; i < (int)len; ++i ) {
         m_bcalCorrelations_plist.push_back(new(p+i) BcalCorrelations);
      }
   }
   if ((len = m_hdf5_record.vl_bcalDOCAtoTrack.len) > 0) {
      BcalDOCAtoTrack *p =(BcalDOCAtoTrack*)m_hdf5_record.vl_bcalDOCAtoTrack.p;
      for (int i=0; i < (int)len; ++i ) {
         m_bcalDOCAtoTrack_plist.push_back(new(p+i) BcalDOCAtoTrack);
      }
   }
   if ((len = m_hdf5_record.vl_bcalLayers.len) > 0) {
      BcalLayers *p =(BcalLayers*)m_hdf5_record.vl_bcalLayers.p;
      for (int i=0; i < (int)len; ++i ) {
         m_bcalLayers_plist.push_back(new(p+i) BcalLayers);
      }
   }
   if ((len = m_hdf5_record.vl_bcalMatchParams.len) > 0) {
      BcalMatchParams *p =(BcalMatchParams*)m_hdf5_record.vl_bcalMatchParams.p;
      for (int i=0; i < (int)len; ++i ) {
         m_bcalMatchParams_plist.push_back(new(p+i) BcalMatchParams);
      }
   }
   if ((len = m_hdf5_record.vl_bcalShower.len) > 0) {
      BcalShower *p =(BcalShower*)m_hdf5_record.vl_bcalShower.p;
      for (int i=0; i < (int)len; ++i ) {
         m_bcalShower_plist.push_back(new(p+i) BcalShower);
      }
   }
   if ((len = m_hdf5_record.vl_ccalBlocks.len) > 0) {
      CcalBlocks *p =(CcalBlocks*)m_hdf5_record.vl_ccalBlocks.p;
      for (int i=0; i < (int)len; ++i ) {
         m_ccalBlocks_plist.push_back(new(p+i) CcalBlocks);
      }
   }
   if ((len = m_hdf5_record.vl_ccalShower.len) > 0) {
      CcalShower *p =(CcalShower*)m_hdf5_record.vl_ccalShower.p;
      for (int i=0; i < (int)len; ++i ) {
         m_ccalShower_plist.push_back(new(p+i) CcalShower);
      }
   }
   if ((len = m_hdf5_record.vl_ccdbContext.len) > 0) {
      CcdbContext *p =(CcdbContext*)m_hdf5_record.vl_ccdbContext.p;
      for (int i=0; i < (int)len; ++i ) {
         m_ccdbContext_plist.push_back(new(p+i) CcdbContext);
      }
   }
   if ((len = m_hdf5_record.vl_cdcStraws.len) > 0) {
      CdcStraws *p =(CdcStraws*)m_hdf5_record.vl_cdcStraws.p;
      for (int i=0; i < (int)len; ++i ) {
         m_cdcStraws_plist.push_back(new(p+i) CdcStraws);
      }
   }
   if ((len = m_hdf5_record.vl_chargedTrack.len) > 0) {
      ChargedTrack *p =(ChargedTrack*)m_hdf5_record.vl_chargedTrack.p;
      for (int i=0; i < (int)len; ++i ) {
         m_chargedTrack_plist.push_back(new(p+i) ChargedTrack);
      }
   }
   if ((len = m_hdf5_record.vl_comment.len) > 0) {
      Comment *p =(Comment*)m_hdf5_record.vl_comment.p;
      for (int i=0; i < (int)len; ++i ) {
         m_comment_plist.push_back(new(p+i) Comment);
      }
   }
   if ((len = m_hdf5_record.vl_ctofMatchParams.len) > 0) {
      CtofMatchParams *p =(CtofMatchParams*)m_hdf5_record.vl_ctofMatchParams.p;
      for (int i=0; i < (int)len; ++i ) {
         m_ctofMatchParams_plist.push_back(new(p+i) CtofMatchParams);
      }
   }
   if ((len = m_hdf5_record.vl_ctofPoint.len) > 0) {
      CtofPoint *p =(CtofPoint*)m_hdf5_record.vl_ctofPoint.p;
      for (int i=0; i < (int)len; ++i ) {
         m_ctofPoint_plist.push_back(new(p+i) CtofPoint);
      }
   }
   if ((len = m_hdf5_record.vl_dEdxDC.len) > 0) {
      DEdxDC *p =(DEdxDC*)m_hdf5_record.vl_dEdxDC.p;
      for (int i=0; i < (int)len; ++i ) {
         m_dEdxDC_plist.push_back(new(p+i) DEdxDC);
      }
   }
   if ((len = m_hdf5_record.vl_dataVersionString.len) > 0) {
      DataVersionString *p =(DataVersionString*)m_hdf5_record.vl_dataVersionString.p;
      for (int i=0; i < (int)len; ++i ) {
         m_dataVersionString_plist.push_back(new(p+i) DataVersionString);
      }
   }
   if ((len = m_hdf5_record.vl_detectorMatches.len) > 0) {
      DetectorMatches *p =(DetectorMatches*)m_hdf5_record.vl_detectorMatches.p;
      for (int i=0; i < (int)len; ++i ) {
         m_detectorMatches_plist.push_back(new(p+i) DetectorMatches);
      }
   }
   if ((len = m_hdf5_record.vl_dircHit.len) > 0) {
      DircHit *p =(DircHit*)m_hdf5_record.vl_dircHit.p;
      for (int i=0; i < (int)len; ++i ) {
         m_dircHit_plist.push_back(new(p+i) DircHit);
      }
   }
   if ((len = m_hdf5_record.vl_dircMatchHit.len) > 0) {
      DircMatchHit *p =(DircMatchHit*)m_hdf5_record.vl_dircMatchHit.p;
      for (int i=0; i < (int)len; ++i ) {
         m_dircMatchHit_plist.push_back(new(p+i) DircMatchHit);
      }
   }
   if ((len = m_hdf5_record.vl_dircMatchParams.len) > 0) {
      DircMatchParams *p =(DircMatchParams*)m_hdf5_record.vl_dircMatchParams.p;
      for (int i=0; i < (int)len; ++i ) {
         m_dircMatchParams_plist.push_back(new(p+i) DircMatchParams);
      }
   }
   if ((len = m_hdf5_record.vl_dircPMTs.len) > 0) {
      DircPMTs *p =(DircPMTs*)m_hdf5_record.vl_dircPMTs.p;
      for (int i=0; i < (int)len; ++i ) {
         m_dircPMTs_plist.push_back(new(p+i) DircPMTs);
      }
   }
   if ((len = m_hdf5_record.vl_exitParams.len) > 0) {
      ExitParams *p =(ExitParams*)m_hdf5_record.vl_exitParams.p;
      for (int i=0; i < (int)len; ++i ) {
         m_exitParams_plist.push_back(new(p+i) ExitParams);
      }
   }
   if ((len = m_hdf5_record.vl_expectedhits.len) > 0) {
      Expectedhits *p =(Expectedhits*)m_hdf5_record.vl_expectedhits.p;
      for (int i=0; i < (int)len; ++i ) {
         m_expectedhits_plist.push_back(new(p+i) Expectedhits);
      }
   }
   if ((len = m_hdf5_record.vl_fcalBlocks.len) > 0) {
      FcalBlocks *p =(FcalBlocks*)m_hdf5_record.vl_fcalBlocks.p;
      for (int i=0; i < (int)len; ++i ) {
         m_fcalBlocks_plist.push_back(new(p+i) FcalBlocks);
      }
   }
   if ((len = m_hdf5_record.vl_fcalCorrelations.len) > 0) {
      FcalCorrelations *p =(FcalCorrelations*)m_hdf5_record.vl_fcalCorrelations.p;
      for (int i=0; i < (int)len; ++i ) {
         m_fcalCorrelations_plist.push_back(new(p+i) FcalCorrelations);
      }
   }
   if ((len = m_hdf5_record.vl_fcalDOCAtoTrack.len) > 0) {
      FcalDOCAtoTrack *p =(FcalDOCAtoTrack*)m_hdf5_record.vl_fcalDOCAtoTrack.p;
      for (int i=0; i < (int)len; ++i ) {
         m_fcalDOCAtoTrack_plist.push_back(new(p+i) FcalDOCAtoTrack);
      }
   }
   if ((len = m_hdf5_record.vl_fcalEnergyParams.len) > 0) {
      FcalEnergyParams *p =(FcalEnergyParams*)m_hdf5_record.vl_fcalEnergyParams.p;
      for (int i=0; i < (int)len; ++i ) {
         m_fcalEnergyParams_plist.push_back(new(p+i) FcalEnergyParams);
      }
   }
   if ((len = m_hdf5_record.vl_fcalHit.len) > 0) {
      FcalHit *p =(FcalHit*)m_hdf5_record.vl_fcalHit.p;
      for (int i=0; i < (int)len; ++i ) {
         m_fcalHit_plist.push_back(new(p+i) FcalHit);
      }
   }
   if ((len = m_hdf5_record.vl_fcalMatchParams.len) > 0) {
      FcalMatchParams *p =(FcalMatchParams*)m_hdf5_record.vl_fcalMatchParams.p;
      for (int i=0; i < (int)len; ++i ) {
         m_fcalMatchParams_plist.push_back(new(p+i) FcalMatchParams);
      }
   }
   if ((len = m_hdf5_record.vl_fcalShower.len) > 0) {
      FcalShower *p =(FcalShower*)m_hdf5_record.vl_fcalShower.p;
      for (int i=0; i < (int)len; ++i ) {
         m_fcalShower_plist.push_back(new(p+i) FcalShower);
      }
   }
   if ((len = m_hdf5_record.vl_fcalShowerClassification.len) > 0) {
      FcalShowerClassification *p =(FcalShowerClassification*)m_hdf5_record.vl_fcalShowerClassification.p;
      for (int i=0; i < (int)len; ++i ) {
         m_fcalShowerClassification_plist.push_back(new(p+i) FcalShowerClassification);
      }
   }
   if ((len = m_hdf5_record.vl_fcalShowerNBlocks.len) > 0) {
      FcalShowerNBlocks *p =(FcalShowerNBlocks*)m_hdf5_record.vl_fcalShowerNBlocks.p;
      for (int i=0; i < (int)len; ++i ) {
         m_fcalShowerNBlocks_plist.push_back(new(p+i) FcalShowerNBlocks);
      }
   }
   if ((len = m_hdf5_record.vl_fcalShowerProperties.len) > 0) {
      FcalShowerProperties *p =(FcalShowerProperties*)m_hdf5_record.vl_fcalShowerProperties.p;
      for (int i=0; i < (int)len; ++i ) {
         m_fcalShowerProperties_plist.push_back(new(p+i) FcalShowerProperties);
      }
   }
   if ((len = m_hdf5_record.vl_fcalSingleHitMatchParams.len) > 0) {
      FcalSingleHitMatchParams *p =(FcalSingleHitMatchParams*)m_hdf5_record.vl_fcalSingleHitMatchParams.p;
      for (int i=0; i < (int)len; ++i ) {
         m_fcalSingleHitMatchParams_plist.push_back(new(p+i) FcalSingleHitMatchParams);
      }
   }
   if ((len = m_hdf5_record.vl_fdcPseudos.len) > 0) {
      FdcPseudos *p =(FdcPseudos*)m_hdf5_record.vl_fdcPseudos.p;
      for (int i=0; i < (int)len; ++i ) {
         m_fdcPseudos_plist.push_back(new(p+i) FdcPseudos);
      }
   }
   if ((len = m_hdf5_record.vl_fmwpcData.len) > 0) {
      FmwpcData *p =(FmwpcData*)m_hdf5_record.vl_fmwpcData.p;
      for (int i=0; i < (int)len; ++i ) {
         m_fmwpcData_plist.push_back(new(p+i) FmwpcData);
      }
   }
   if ((len = m_hdf5_record.vl_fmwpcHit.len) > 0) {
      FmwpcHit *p =(FmwpcHit*)m_hdf5_record.vl_fmwpcHit.p;
      for (int i=0; i < (int)len; ++i ) {
         m_fmwpcHit_plist.push_back(new(p+i) FmwpcHit);
      }
   }
   if ((len = m_hdf5_record.vl_fmwpcMatchParams.len) > 0) {
      FmwpcMatchParams *p =(FmwpcMatchParams*)m_hdf5_record.vl_fmwpcMatchParams.p;
      for (int i=0; i < (int)len; ++i ) {
         m_fmwpcMatchParams_plist.push_back(new(p+i) FmwpcMatchParams);
      }
   }
   if ((len = m_hdf5_record.vl_hitStatistics.len) > 0) {
      HitStatistics *p =(HitStatistics*)m_hdf5_record.vl_hitStatistics.p;
      for (int i=0; i < (int)len; ++i ) {
         m_hitStatistics_plist.push_back(new(p+i) HitStatistics);
      }
   }
   if ((len = m_hdf5_record.vl_hitlayers.len) > 0) {
      Hitlayers *p =(Hitlayers*)m_hdf5_record.vl_hitlayers.p;
      for (int i=0; i < (int)len; ++i ) {
         m_hitlayers_plist.push_back(new(p+i) Hitlayers);
      }
   }
   if ((len = m_hdf5_record.vl_mcmatch.len) > 0) {
      Mcmatch *p =(Mcmatch*)m_hdf5_record.vl_mcmatch.p;
      for (int i=0; i < (int)len; ++i ) {
         m_mcmatch_plist.push_back(new(p+i) Mcmatch);
      }
   }
   if ((len = m_hdf5_record.vl_momentum.len) > 0) {
      Momentum *p =(Momentum*)m_hdf5_record.vl_momentum.p;
      for (int i=0; i < (int)len; ++i ) {
         m_momentum_plist.push_back(new(p+i) Momentum);
      }
   }
   if ((len = m_hdf5_record.vl_origin.len) > 0) {
      Origin *p =(Origin*)m_hdf5_record.vl_origin.p;
      for (int i=0; i < (int)len; ++i ) {
         m_origin_plist.push_back(new(p+i) Origin);
      }
   }
   if ((len = m_hdf5_record.vl_preshower.len) > 0) {
      Preshower *p =(Preshower*)m_hdf5_record.vl_preshower.p;
      for (int i=0; i < (int)len; ++i ) {
         m_preshower_plist.push_back(new(p+i) Preshower);
      }
   }
   if ((len = m_hdf5_record.vl_product.len) > 0) {
      Product *p =(Product*)m_hdf5_record.vl_product.p;
      for (int i=0; i < (int)len; ++i ) {
         m_product_plist.push_back(new(p+i) Product);
      }
   }
   if ((len = m_hdf5_record.vl_reaction.len) > 0) {
      Reaction *p =(Reaction*)m_hdf5_record.vl_reaction.p;
      for (int i=0; i < (int)len; ++i ) {
         m_reaction_plist.push_back(new(p+i) Reaction);
      }
   }
   if ((len = m_hdf5_record.vl_reconstructedPhysicsEvent.len) > 0) {
      ReconstructedPhysicsEvent *p =(ReconstructedPhysicsEvent*)m_hdf5_record.vl_reconstructedPhysicsEvent.p;
      for (int i=0; i < (int)len; ++i ) {
         m_reconstructedPhysicsEvent_plist.push_back(new(p+i) ReconstructedPhysicsEvent);
      }
   }
   if ((len = m_hdf5_record.vl_scMatchParams.len) > 0) {
      ScMatchParams *p =(ScMatchParams*)m_hdf5_record.vl_scMatchParams.p;
      for (int i=0; i < (int)len; ++i ) {
         m_scMatchParams_plist.push_back(new(p+i) ScMatchParams);
      }
   }
   if ((len = m_hdf5_record.vl_startCounters.len) > 0) {
      StartCounters *p =(StartCounters*)m_hdf5_record.vl_startCounters.p;
      for (int i=0; i < (int)len; ++i ) {
         m_startCounters_plist.push_back(new(p+i) StartCounters);
      }
   }
   if ((len = m_hdf5_record.vl_startHit.len) > 0) {
      StartHit *p =(StartHit*)m_hdf5_record.vl_startHit.p;
      for (int i=0; i < (int)len; ++i ) {
         m_startHit_plist.push_back(new(p+i) StartHit);
      }
   }
   if ((len = m_hdf5_record.vl_taghBeamPhoton.len) > 0) {
      TaghBeamPhoton *p =(TaghBeamPhoton*)m_hdf5_record.vl_taghBeamPhoton.p;
      for (int i=0; i < (int)len; ++i ) {
         m_taghBeamPhoton_plist.push_back(new(p+i) TaghBeamPhoton);
      }
   }
   if ((len = m_hdf5_record.vl_taghChannel.len) > 0) {
      TaghChannel *p =(TaghChannel*)m_hdf5_record.vl_taghChannel.p;
      for (int i=0; i < (int)len; ++i ) {
         m_taghChannel_plist.push_back(new(p+i) TaghChannel);
      }
   }
   if ((len = m_hdf5_record.vl_tagmBeamPhoton.len) > 0) {
      TagmBeamPhoton *p =(TagmBeamPhoton*)m_hdf5_record.vl_tagmBeamPhoton.p;
      for (int i=0; i < (int)len; ++i ) {
         m_tagmBeamPhoton_plist.push_back(new(p+i) TagmBeamPhoton);
      }
   }
   if ((len = m_hdf5_record.vl_tagmChannel.len) > 0) {
      TagmChannel *p =(TagmChannel*)m_hdf5_record.vl_tagmChannel.p;
      for (int i=0; i < (int)len; ++i ) {
         m_tagmChannel_plist.push_back(new(p+i) TagmChannel);
      }
   }
   if ((len = m_hdf5_record.vl_tflightPCorrelation.len) > 0) {
      TflightPCorrelation *p =(TflightPCorrelation*)m_hdf5_record.vl_tflightPCorrelation.p;
      for (int i=0; i < (int)len; ++i ) {
         m_tflightPCorrelation_plist.push_back(new(p+i) TflightPCorrelation);
      }
   }
   if ((len = m_hdf5_record.vl_tofDedx.len) > 0) {
      TofDedx *p =(TofDedx*)m_hdf5_record.vl_tofDedx.p;
      for (int i=0; i < (int)len; ++i ) {
         m_tofDedx_plist.push_back(new(p+i) TofDedx);
      }
   }
   if ((len = m_hdf5_record.vl_tofEnergyDeposition.len) > 0) {
      TofEnergyDeposition *p =(TofEnergyDeposition*)m_hdf5_record.vl_tofEnergyDeposition.p;
      for (int i=0; i < (int)len; ++i ) {
         m_tofEnergyDeposition_plist.push_back(new(p+i) TofEnergyDeposition);
      }
   }
   if ((len = m_hdf5_record.vl_tofMatchParams.len) > 0) {
      TofMatchParams *p =(TofMatchParams*)m_hdf5_record.vl_tofMatchParams.p;
      for (int i=0; i < (int)len; ++i ) {
         m_tofMatchParams_plist.push_back(new(p+i) TofMatchParams);
      }
   }
   if ((len = m_hdf5_record.vl_tofPaddles.len) > 0) {
      TofPaddles *p =(TofPaddles*)m_hdf5_record.vl_tofPaddles.p;
      for (int i=0; i < (int)len; ++i ) {
         m_tofPaddles_plist.push_back(new(p+i) TofPaddles);
      }
   }
   if ((len = m_hdf5_record.vl_tofPoint.len) > 0) {
      TofPoint *p =(TofPoint*)m_hdf5_record.vl_tofPoint.p;
      for (int i=0; i < (int)len; ++i ) {
         m_tofPoint_plist.push_back(new(p+i) TofPoint);
      }
   }
   if ((len = m_hdf5_record.vl_tofStatus.len) > 0) {
      TofStatus *p =(TofStatus*)m_hdf5_record.vl_tofStatus.p;
      for (int i=0; i < (int)len; ++i ) {
         m_tofStatus_plist.push_back(new(p+i) TofStatus);
      }
   }
   if ((len = m_hdf5_record.vl_trackFit.len) > 0) {
      TrackFit *p =(TrackFit*)m_hdf5_record.vl_trackFit.p;
      for (int i=0; i < (int)len; ++i ) {
         m_trackFit_plist.push_back(new(p+i) TrackFit);
      }
   }
   if ((len = m_hdf5_record.vl_trackFlags.len) > 0) {
      TrackFlags *p =(TrackFlags*)m_hdf5_record.vl_trackFlags.p;
      for (int i=0; i < (int)len; ++i ) {
         m_trackFlags_plist.push_back(new(p+i) TrackFlags);
      }
   }
   if ((len = m_hdf5_record.vl_trigger.len) > 0) {
      Trigger *p =(Trigger*)m_hdf5_record.vl_trigger.p;
      for (int i=0; i < (int)len; ++i ) {
         m_trigger_plist.push_back(new(p+i) Trigger);
      }
   }
   if ((len = m_hdf5_record.vl_triggerEnergySums.len) > 0) {
      TriggerEnergySums *p =(TriggerEnergySums*)m_hdf5_record.vl_triggerEnergySums.p;
      for (int i=0; i < (int)len; ++i ) {
         m_triggerEnergySums_plist.push_back(new(p+i) TriggerEnergySums);
      }
   }
   if ((len = m_hdf5_record.vl_vertex.len) > 0) {
      Vertex *p =(Vertex*)m_hdf5_record.vl_vertex.p;
      for (int i=0; i < (int)len; ++i ) {
         m_vertex_plist.push_back(new(p+i) Vertex);
      }
   }
   if ((len = m_hdf5_record.vl_width.len) > 0) {
      Width *p =(Width*)m_hdf5_record.vl_width.p;
      for (int i=0; i < (int)len; ++i ) {
         m_width_plist.push_back(new(p+i) Width);
      }
   }
   new(&m_reconstructedPhysicsEvent_link) ReconstructedPhysicsEventLink(&m_reconstructedPhysicsEvent_plist,
            m_reconstructedPhysicsEvent_plist.begin(),
            m_reconstructedPhysicsEvent_plist.end(),
            this);
   hdf5DataUnpack();
   return res;
}
hid_t HDDM::hdf5FileCreate(std::string name, unsigned int flags)
{
   hid_t file_id = H5Fcreate(name.c_str(), flags, H5P_DEFAULT, H5P_DEFAULT);
   hdf5FileStamp(file_id);
   return file_id;
}
hid_t HDDM::hdf5FileOpen(std::string name, unsigned int flags)
{
   hid_t file_id = H5Fopen(name.c_str(), flags, H5P_DEFAULT);
   hdf5FileCheck(file_id);
   return file_id;
}
herr_t HDDM::hdf5FileClose(hid_t file_id)
{
   herr_t res = H5Fclose(file_id);
   if (HDDM::s_hdf5_dataspace.find(file_id) != HDDM::s_hdf5_dataspace.end()) {
        H5Sclose(s_hdf5_dataspace[file_id]);
        s_hdf5_dataspace.erase(file_id);
   }
   if (s_hdf5_chunking.find(file_id) != s_hdf5_chunking.end()) {
       H5Pclose(s_hdf5_chunking[file_id]);
       s_hdf5_chunking.erase(file_id);
   }
   if (s_hdf5_dataset.find(file_id) != s_hdf5_dataset.end()) {
       H5Dclose(s_hdf5_dataset[file_id]);
       s_hdf5_dataset.erase(file_id);
   }
   return res;
}

void HDDM::hdf5DataPack()
{
   m_reconstructedPhysicsEvent_link.deflate();
}
void HDDM::hdf5DataUnpack()
{
   {
      std::list<ReconstructedPhysicsEvent*> *host_plist = &m_host->m_reconstructedPhysicsEvent_plist;
      m_reconstructedPhysicsEvent_link.inflate(m_host, host_plist, this);
      ReconstructedPhysicsEventList::iterator iter;
      for (iter = m_reconstructedPhysicsEvent_link.begin();
           iter != m_reconstructedPhysicsEvent_link.end(); ++iter)
      {
         iter->hdf5DataUnpack();
      }
   }
}
#endif


void debug_print(CDCAmpdEdxList &list) {
   list.debug_print();
}

void debug_print(CDCdEdxTruncList &list) {
   list.debug_print();
}

void debug_print(FDCdEdxTruncList &list) {
   list.debug_print();
}

void debug_print(RFtimeList &list) {
   list.debug_print();
}

void debug_print(BcalCellsList &list) {
   list.debug_print();
}

void debug_print(BcalClusterList &list) {
   list.debug_print();
}

void debug_print(BcalCorrelationsList &list) {
   list.debug_print();
}

void debug_print(BcalDOCAtoTrackList &list) {
   list.debug_print();
}

void debug_print(BcalLayersList &list) {
   list.debug_print();
}

void debug_print(BcalMatchParamsList &list) {
   list.debug_print();
}

void debug_print(BcalShowerList &list) {
   list.debug_print();
}

void debug_print(CcalBlocksList &list) {
   list.debug_print();
}

void debug_print(CcalShowerList &list) {
   list.debug_print();
}

void debug_print(CcdbContextList &list) {
   list.debug_print();
}

void debug_print(CdcStrawsList &list) {
   list.debug_print();
}

void debug_print(ChargedTrackList &list) {
   list.debug_print();
}

void debug_print(CommentList &list) {
   list.debug_print();
}

void debug_print(CtofMatchParamsList &list) {
   list.debug_print();
}

void debug_print(CtofPointList &list) {
   list.debug_print();
}

void debug_print(DEdxDCList &list) {
   list.debug_print();
}

void debug_print(DataVersionStringList &list) {
   list.debug_print();
}

void debug_print(DetectorMatchesList &list) {
   list.debug_print();
}

void debug_print(DircHitList &list) {
   list.debug_print();
}

void debug_print(DircMatchHitList &list) {
   list.debug_print();
}

void debug_print(DircMatchParamsList &list) {
   list.debug_print();
}

void debug_print(DircPMTsList &list) {
   list.debug_print();
}

void debug_print(ExitParamsList &list) {
   list.debug_print();
}

void debug_print(ExpectedhitsList &list) {
   list.debug_print();
}

void debug_print(FcalBlocksList &list) {
   list.debug_print();
}

void debug_print(FcalCorrelationsList &list) {
   list.debug_print();
}

void debug_print(FcalDOCAtoTrackList &list) {
   list.debug_print();
}

void debug_print(FcalEnergyParamsList &list) {
   list.debug_print();
}

void debug_print(FcalHitList &list) {
   list.debug_print();
}

void debug_print(FcalMatchParamsList &list) {
   list.debug_print();
}

void debug_print(FcalShowerList &list) {
   list.debug_print();
}

void debug_print(FcalShowerClassificationList &list) {
   list.debug_print();
}

void debug_print(FcalShowerNBlocksList &list) {
   list.debug_print();
}

void debug_print(FcalShowerPropertiesList &list) {
   list.debug_print();
}

void debug_print(FcalSingleHitMatchParamsList &list) {
   list.debug_print();
}

void debug_print(FdcPseudosList &list) {
   list.debug_print();
}

void debug_print(FmwpcDataList &list) {
   list.debug_print();
}

void debug_print(FmwpcHitList &list) {
   list.debug_print();
}

void debug_print(FmwpcMatchParamsList &list) {
   list.debug_print();
}

void debug_print(HitStatisticsList &list) {
   list.debug_print();
}

void debug_print(HitlayersList &list) {
   list.debug_print();
}

void debug_print(McmatchList &list) {
   list.debug_print();
}

void debug_print(MomentumList &list) {
   list.debug_print();
}

void debug_print(OriginList &list) {
   list.debug_print();
}

void debug_print(PreshowerList &list) {
   list.debug_print();
}

void debug_print(ProductList &list) {
   list.debug_print();
}

void debug_print(ReactionList &list) {
   list.debug_print();
}

void debug_print(ReconstructedPhysicsEventList &list) {
   list.debug_print();
}

void debug_print(ScMatchParamsList &list) {
   list.debug_print();
}

void debug_print(StartCountersList &list) {
   list.debug_print();
}

void debug_print(StartHitList &list) {
   list.debug_print();
}

void debug_print(TaghBeamPhotonList &list) {
   list.debug_print();
}

void debug_print(TaghChannelList &list) {
   list.debug_print();
}

void debug_print(TagmBeamPhotonList &list) {
   list.debug_print();
}

void debug_print(TagmChannelList &list) {
   list.debug_print();
}

void debug_print(TflightPCorrelationList &list) {
   list.debug_print();
}

void debug_print(TofDedxList &list) {
   list.debug_print();
}

void debug_print(TofEnergyDepositionList &list) {
   list.debug_print();
}

void debug_print(TofMatchParamsList &list) {
   list.debug_print();
}

void debug_print(TofPaddlesList &list) {
   list.debug_print();
}

void debug_print(TofPointList &list) {
   list.debug_print();
}

void debug_print(TofStatusList &list) {
   list.debug_print();
}

void debug_print(TrackFitList &list) {
   list.debug_print();
}

void debug_print(TrackFlagsList &list) {
   list.debug_print();
}

void debug_print(TriggerList &list) {
   list.debug_print();
}

void debug_print(TriggerEnergySumsList &list) {
   list.debug_print();
}

void debug_print(VertexList &list) {
   list.debug_print();
}

void debug_print(WidthList &list) {
   list.debug_print();
}

streamposition::streamposition()
 : block_start(), block_offset(), block_status() {}

streamposition::streamposition(uint64_t start, uint32_t offset, uint32_t status)
 : block_start(start), block_offset(offset), block_status(status) {}

istream::istream(std::istream &src)
 : m_istr(src),
   m_status_bits(0)
{
   char hdr[1000];
   src.getline(hdr,7);
   m_documentString = hdr;
   while (m_documentString != "<HDDM ") {
      if (m_documentString == "<?xml ") {
         src.clear();
         src.getline(hdr,1000);
         src.getline(hdr,7);
         m_documentString = hdr;
         continue;
      }
      throw std::runtime_error("hddm_r::istream::istream error - invalid hddm header");
   }
   src.clear();
   std::string line;
   while (std::getline(src,line).good()) {
      m_documentString += line + "\n";
      if (line == "</HDDM>") {
         break;
      }
   }
   if (src.bad()) {
      throw std::runtime_error("hddm_r::istream::istream error - hddm header invalid");
   }
   pthread_mutex_init(&m_streambuf_mutex,0);
   for (int i=0; i<threads::max_threads; ++i) {
      my_thread_private[i] = 0;
   }
   m_leftovers[0] = 0;
   init_private_data();
}

istream::~istream() {
   pthread_mutex_destroy(&m_streambuf_mutex);
   for (int i=0; i<threads::max_threads; ++i) {
      thread_private_data *my_private = my_thread_private[i];
      if (my_private != 0) {
         if (MY(istr))
            delete MY(istr);
         if (MY(xcmp))
            delete MY(xcmp);
         if (MY(xstr))
            delete MY(xstr);
         if (MY(sbuf))
            delete MY(sbuf);
         delete [] MY(event_buffer);
         delete my_private;
      }
   }
}

void istream::init_private_data() {
   int threadID = threads::getID();
   if (my_thread_private[threadID] == 0) {
      my_thread_private[threadID] = new thread_private_data;
   }
   MY_SETUP
   MY(genome).m_tagname = "HDDM";
   MY(genome).m_sequence = synthesize(m_documentString,0,HDDM::DocumentString(),0);
   MY(event_buffer) = new char[MY(event_buffer_size) = 100000];
   MY(sbuf) = new istreambuffer(MY(event_buffer),MY(event_buffer_size));
   MY(xstr) = new xstream::xdr::istream(MY(sbuf));
   MY(istr) = new std::istream(m_istr.rdbuf());
   MY(xcmp) = 0;
   MY(event_size) = 0;
   MY(last_start) = 0;
   MY(last_offset) = 0;
   MY(next_start) = 0;
   MY(events_to_skip) = 0;
   MY(status_bits) = 0;
   MY(mutex_lock) = 0;
   MY(bytes_read) = 0;
   MY(records_read) = 0;
   MY(sequencing) = 0;
   MY(hit_eof) = 0;
}

streamposition istream::getPosition() {
   MY_SETUP
   streamposition pos;
   pos.block_start = MY(last_start);
   pos.block_offset = MY(last_offset);
   pos.block_status = MY(status_bits);
   return pos;
}

void istream::setPosition(const streamposition &pos) {
   MY_SETUP
   m_status_bits = pos.block_status;
   lock_streambufs();
   update_streambufs();
   unlock_streambufs();
   if (MY(status_bits) & (k_bz2_compression | k_z_compression)) {
      if (((int)m_status_bits & k_bits_compression) != 0 &&
          ((int)m_status_bits & k_can_reposition) == 0)
      {
         throw std::runtime_error("hddm_r::istream::setPosition error - "
                                  "old-format hddm input file does not support repositioning.");
      }
      else if (MY(xcmp) == 0) {
         throw std::runtime_error("hddm_r::istream::setPosition error - "
                                  "compressed stream encountered but no decompressor configured.");
      }
      if (MY(status_bits) & k_z_compression) {
         ((xstream::z::istreambuf*)MY(xcmp))->
             set_new_position(pos.block_start, pos.block_offset);
      }
      else if (MY(status_bits) & k_bz2_compression) {
         ((xstream::bz::istreambuf*)MY(xcmp))->
             set_new_position(pos.block_start, pos.block_offset);
      }
   }
   else {
      MY(next_start) = pos.block_start;
   }
}

void istream::update_streambufs() {
   MY_SETUP
   if ((int)m_status_bits != MY(status_bits)) {
      configure_streambufs();
   }
}

void istream::configure_streambufs() {
   MY_SETUP
   int oldcmp = MY(status_bits) & k_bits_compression;
   int newcmp = (int)m_status_bits & k_bits_compression;
   if (oldcmp != newcmp) {
      if (oldcmp != k_no_compression) {
         MY(istr)->rdbuf(m_istr.rdbuf());
         delete MY(xcmp);
         MY(xcmp) = 0;
      }
      if (newcmp == k_z_compression) {
         //std::cerr << "input switched on z compression" << std::endl;
         MY(xcmp) = new xstream::z::istreambuf(m_istr.rdbuf(), m_leftovers,
                                                        sizeof(m_leftovers));
         MY(istr)->rdbuf(MY(xcmp));
      }
      else if (newcmp == k_bz2_compression) {
         //std::cerr << "input switched on bz2 compression" << std::endl;
         MY(xcmp) = new xstream::bz::istreambuf(m_istr.rdbuf(), m_leftovers,
                                                         sizeof(m_leftovers));
         MY(istr)->rdbuf(MY(xcmp));
      }
      else if (newcmp != k_no_compression) {
         throw std::runtime_error("hddm_r::istream::configure_streambufs error - "
                                  "unrecognized compression flag requested.");
      }
   }
   MY(status_bits) = m_status_bits;
}

void istream::lock_streambufs() {
   MY_SETUP
   if (MY(mutex_lock) != 0) {
      unlock_streambufs();
      throw std::runtime_error("hddm_r::istream::lock_streambufs error - "
                               "mutex lock requested when lock already held.");
   }
   if ((MY(status_bits) & k_bits_compression) == k_no_compression) {
      pthread_mutex_lock(&m_streambuf_mutex);
      MY(mutex_lock) = 1;
   }
   else if ((MY(status_bits) & k_bits_compression) == k_z_compression) {
      ((xstream::z::istreambuf*)MY(xcmp))->set_streambuf_mutex(&m_streambuf_mutex);
      MY(mutex_lock) = 2;
   }
   else if ((MY(status_bits) & k_bits_compression) == k_bz2_compression) {
      ((xstream::bz::istreambuf*)MY(xcmp))->set_streambuf_mutex(&m_streambuf_mutex);
      MY(mutex_lock) = 3;
   }
   else {
      MY(mutex_lock) = -1;
   }
}

void istream::unlock_streambufs() {
   MY_SETUP
   if (MY(mutex_lock) == 0) {
      throw std::runtime_error("hddm_r::istream::unlock_streambufs error - "
                               "mutex unlock requested when lock not held.");
   }
   else if (MY(mutex_lock) == 1) {
      pthread_mutex_unlock(&m_streambuf_mutex);
   }
   else if (MY(mutex_lock) == 2) {
      ((xstream::z::istreambuf*)MY(xcmp))->set_streambuf_mutex(0);
   }
   else if (MY(mutex_lock) == 3) {
      ((xstream::bz::istreambuf*)MY(xcmp))->set_streambuf_mutex(0);
   }
   MY(mutex_lock) = 0;
}

istream &istream::operator>>(HDDM &record) {
   MY_SETUP
   while (1 == 1) {
      lock_streambufs();
      MY(event_size) = 0;
      while (MY(event_size) == 0) {
         update_streambufs();
         if (MY(status_bits) & (k_bz2_compression | k_z_compression)) {
            if (MY(status_bits) & k_can_reposition) {
               MY(istr)->clear();
               MY(istr)->read(MY(event_buffer),4);
               MY(bytes_read) += MY(istr)->gcount();
               if (!MY(istr)->good()) {
                  unlock_streambufs();
                  MY(hit_eof) = 1;
                  return *this;
               }
               if (MY(status_bits) & k_bz2_compression) {
                  MY(last_start)  = dynamic_cast<xstream::bz::istreambuf*>
                                    (MY(xcmp))->get_block_start();
                  MY(last_offset) = dynamic_cast<xstream::bz::istreambuf*>
                                    (MY(xcmp))->get_block_offset();
               }
               else {
                  MY(last_start)  = dynamic_cast<xstream::z::istreambuf*>
                                    (MY(xcmp))->get_block_start();
                  MY(last_offset) = dynamic_cast<xstream::z::istreambuf*>
                                    (MY(xcmp))->get_block_offset();
               }
               MY(last_offset) -= 4;
            }
            else {
               MY(last_start) = 0;
               MY(last_offset) = 0;
            }
         }
         else {
            if (MY(next_start) > 0) {
               m_istr.seekg(MY(next_start), std::ios_base::beg);
               MY(istr)->clear();
               MY(last_start) = MY(next_start);
               MY(last_offset) = 0;
               MY(next_start) = 0;
            }
            else {
               MY(last_start) = m_istr.tellg();
               MY(last_offset) = 0;
            }
            MY(istr)->read(MY(event_buffer),4);
            MY(bytes_read) += MY(istr)->gcount();
            if (!MY(istr)->good()) {
               unlock_streambufs();
               MY(hit_eof) = 1;
               return *this;
            }
         }
         MY(hit_eof) = 0;
         MY(sbuf)->reset();
         *MY(xstr) >> MY(event_size);
         if (MY(event_size) == 1) {
            MY(istr)->read(MY(event_buffer)+4,4);
            MY(bytes_read) += MY(istr)->gcount();
            if (!MY(istr)->good()) {
               unlock_streambufs();
               throw std::runtime_error("hddm_r::istream::operator>> error -"
                                        " read error on token input!");
            }
            int size;
            *MY(xstr) >> size;
            MY(istr)->read(MY(event_buffer)+8,size);
            MY(bytes_read) += MY(istr)->gcount();
            if (!MY(istr)->good()) {
               unlock_streambufs();
               throw std::runtime_error("hddm_r::istream::operator>> error -"
                                        " read error on token input!");
            }
            int format, flags;
            *MY(xstr) >> format >> flags;
            if (format != 0) {
               unlock_streambufs();
               throw std::runtime_error("hddm_r::istream::operator>> error - "
                                        "unsupported compression format!");
            }
            m_status_bits.store(flags);
            MY(event_size) = 0;
         }
      }
      if (MY(event_size)+8 > MY(event_buffer_size)) {
         delete MY(xstr);
         delete MY(sbuf);
         char *newbuf = new char[MY(event_buffer_size) = MY(event_size)+1000];
         MY(sbuf) = new istreambuffer(newbuf, MY(event_buffer_size));
         MY(xstr) = new xstream::xdr::istream(MY(sbuf));
         memcpy(newbuf,MY(event_buffer),4);
         delete [] MY(event_buffer);
         MY(event_buffer) = newbuf;
      }
      MY(istr)->read(MY(event_buffer)+4,MY(event_size));
      MY(bytes_read) += MY(istr)->gcount();
      MY(records_read)++;
      if (!MY(istr)->good()) {
         unlock_streambufs();
         throw std::runtime_error("hddm_r::istream::operator>> error -"
                                  " read error in mid-record!");
      }
      if ((MY(status_bits) & k_crc32_integrity) != 0) {
         unsigned int recorded_crc;
         char crcbuf[10];
         istreambuffer sbuf(crcbuf,10);
         xstream::xdr::istream xstr(&sbuf);
         MY(istr)->read(crcbuf,4);
         MY(bytes_read) += MY(istr)->gcount();
         xstr >> recorded_crc;
         xstream::digest::crc32 crc;
         std::ostream out(&crc);
         out.write(MY(event_buffer),MY(event_size)+4);
         out.flush();
         if (crc.digest() != recorded_crc) {
            char errmsg[] = 
                 "WARNING: crc data integrity check failed"
                 " on hddm_r input stream!";
            if ((MY(status_bits) & 0x02) == 0) {
               std::cerr << errmsg << std::endl;
               MY(status_bits) |= 0x02;
            }
            //unlock_streambufs();
            //throw std::runtime_error("hddm_r::istream::operator>> error -"
            //                 " crc check error on input stream!");
         }
      }
      unlock_streambufs();
      if (MY(events_to_skip) > 0) {
         --MY(events_to_skip);
      }
      else {
         break;
      }
   }
   MY(sbuf)->reset();
   MY(sequencing) = 0;
   MY(codon) = &MY(genome);
   record.clear();
   *this >> (streamable&)record;
   return *this;
}

ostream::ostream(std::ostream &src)
 : m_ostr(src),
   m_status_bits(k_default_status)
{
   m_ostr << HDDM::DocumentString();
   if (!m_ostr.good()) {
      throw std::runtime_error("hddm_r::ostream::ostream(ostream) "
                               "error - write error on header output!");
   }
   pthread_mutex_init(&m_streambuf_mutex,0);
   for (int i=0; i<threads::max_threads; ++i) {
      my_thread_private[i] = 0;
   }
   init_private_data();
}

ostream::~ostream() {
   pthread_mutex_destroy(&m_streambuf_mutex);
   for (int i=0; i<threads::max_threads; ++i) {
      thread_private_data *my_private = my_thread_private[i];
      if (my_private != 0) {
         if (MY(xstr)) {
            delete MY(xstr);
         }
         if (MY(sbuf)) {
            delete MY(sbuf);
         }
         if (MY(xcmp)) {
            MY(xcmp)->pubsync();
            MY(ostr)->rdbuf(m_ostr.rdbuf());
            delete MY(xcmp);
         }
         if (MY(ostr)) {
            MY(ostr)->flush();
            delete MY(ostr);
         }
         delete [] MY(event_buffer);
         delete my_private;
      }
   }
}

void ostream::init_private_data() {
   int threadID = threads::getID();
   if (my_thread_private[threadID] == 0) {
      my_thread_private[threadID] = new thread_private_data;
   }
   MY_SETUP
   MY(event_buffer) = new char[MY(event_buffer_size) = 100000];
   MY(sbuf) = new ostreambuffer(MY(event_buffer),MY(event_buffer_size));
   MY(xstr) = new xstream::xdr::ostream(MY(sbuf));
   MY(ostr) = new std::ostream(m_ostr.rdbuf());
   MY(xcmp) = 0;
   MY(last_start) = 0;
   MY(last_offset) = 0;
   MY(records_written) = 0;
   MY(bytes_written) = 0;
   MY(status_bits) = 0;
   MY(mutex_lock) = 0;
}

void ostream::setCompression(int flags) {
   MY_SETUP
   int oldcmp = (int)m_status_bits & k_bits_compression;
   int newcmp = flags & k_bits_compression;
   if (oldcmp != newcmp) {
      m_status_bits.fetch_and(~k_bits_compression | flags);
      m_status_bits.fetch_or(k_bits_compression & flags);
      if (newcmp != 0)
         m_status_bits.fetch_or(k_can_reposition);
      MY(sbuf)->reset();
      *MY(xstr) << 1 << 8 << 0 << (int)m_status_bits;
      lock_streambufs();
      MY(ostr)->write(MY(sbuf)->getbuf(),MY(sbuf)->size());
      if (!MY(ostr)->good()) {
         unlock_streambufs();
         throw std::runtime_error("hddm_r::ostream::setCompression"
                                  " error - write error on token output!");
      }
      MY(ostr)->flush();
      update_streambufs();
      unlock_streambufs();
   }
}

void ostream::setIntegrityChecks(int flags) {
   MY_SETUP
   int oldint = (int)m_status_bits & k_bits_integrity;
   int newint = flags & k_bits_integrity;
   if (oldint != newint) {
      m_status_bits.fetch_and(~k_bits_integrity | flags);
      m_status_bits.fetch_or(k_bits_integrity & flags);
      MY(sbuf)->reset();
      *MY(xstr) << 1 << 8 << 0 << (int)m_status_bits;
      lock_streambufs();
      MY(ostr)->write(MY(sbuf)->getbuf(),MY(sbuf)->size());
      if (!MY(ostr)->good()) {
         unlock_streambufs();
         throw std::runtime_error("hddm_r::ostream::setIntegrityChecks"
                                 " error - write error on token output!");
      }
      MY(ostr)->flush();
      update_streambufs();
      unlock_streambufs();
   }
}

streamposition ostream::getPosition() {
   MY_SETUP
   streamposition pos;
   pos.block_start = MY(last_start);
   pos.block_start = MY(last_offset);
   pos.block_status = MY(status_bits);
   return pos;
}

void ostream::update_streambufs() {
   MY_SETUP
   if ((int)m_status_bits != MY(status_bits)) {
      configure_streambufs();
   }
}

void ostream::configure_streambufs() {
   MY_SETUP
   int oldcmp = MY(status_bits) & k_bits_compression;
   int newcmp = (int)m_status_bits & k_bits_compression;
   if (oldcmp != newcmp) {
      if (oldcmp != k_no_compression) {
         MY(ostr)->rdbuf(m_ostr.rdbuf());
         delete MY(xcmp);
         MY(xcmp) = 0;
      }
      if (newcmp == k_z_compression) {
         //std::cerr << "output switched on z compression" << std::endl;
         MY(xcmp) = new xstream::z::ostreambuf(m_ostr.rdbuf());
         MY(ostr)->rdbuf(MY(xcmp));
      }
      else if (newcmp == k_bz2_compression) {
         //std::cerr << "output switched on bz2 compression" << std::endl;
         MY(xcmp )= new xstream::bz::ostreambuf(m_ostr.rdbuf());
         MY(ostr)->rdbuf(MY(xcmp));
      }
      else if (newcmp != k_no_compression) {
         throw std::runtime_error("hddm_r::ostream::configure_streambufs error - "
                                  "unrecognized compression flag requested.");
      }
   }
   MY(status_bits) = m_status_bits;
}

void ostream::lock_streambufs() {
   MY_SETUP
   if (MY(mutex_lock) != 0) {
      unlock_streambufs();
      throw std::runtime_error("hddm_r::ostream::lock_streambufs error - "
                               "mutex lock requested when lock already held.");
   }
   if ((MY(status_bits) & k_bits_compression) == k_no_compression) {
      pthread_mutex_lock(&m_streambuf_mutex);
      MY(mutex_lock) = 1;
   }
   else if ((MY(status_bits) & k_bits_compression) == k_z_compression) {
      ((xstream::z::ostreambuf*)MY(xcmp))->set_streambuf_mutex(&m_streambuf_mutex);
      MY(mutex_lock) = 2;
   }
   else if ((MY(status_bits) & k_bits_compression) == k_bz2_compression) {
      ((xstream::bz::ostreambuf*)MY(xcmp))->set_streambuf_mutex(&m_streambuf_mutex);
      MY(mutex_lock) = 3;
   }
   else {
      MY(mutex_lock) = -1;
   }
}

void ostream::unlock_streambufs() {
   MY_SETUP
   if (MY(mutex_lock) == 0) {
      throw std::runtime_error("hddm_r::ostream::unlock_streambufs error - "
                               "mutex unlock requested when lock not held.");
   }
   else if (MY(mutex_lock) == 1) {
      pthread_mutex_unlock(&m_streambuf_mutex);
   }
   else if (MY(mutex_lock) == 2) {
      ((xstream::z::ostreambuf*)MY(xcmp))->set_streambuf_mutex(0);
   }
   else if (MY(mutex_lock) == 3) {
      ((xstream::bz::ostreambuf*)MY(xcmp))->set_streambuf_mutex(0);
   }
   MY(mutex_lock) = 0;
}

size_t istream::getTag(const std::string &src, size_t start,
                       std::string &tag, int &level)
{
   tag = "";
   size_t p_btag = src.find("<",start);
   size_t p_bline = src.find_last_of("\n",p_btag);
   if (p_bline == std::string::npos)
   {
      p_bline = 0;
   }
   else
   {
      ++p_bline;
   }
   level = int(p_btag-p_bline)/2;
   size_t p_etag = p_btag;
   for (size_t quotes=0; p_etag < src.size(); ++p_etag) {
      if (src[p_etag] == '"') {
         tag += "\"";
         ++quotes;
      }
      else if (quotes/2*2 != quotes) {
         tag += src[p_etag];
      }
      else if (src.find_first_of(" \t\n",p_etag) == 0) {
         tag += " ";
         p_etag = src.find_first_not_of(" \t\n",p_etag)-1;
      }
      else if (src[p_etag] == '>') {
         tag += ">";
         break;
      }
      else {
         tag += src[p_etag];
      }
   }
   if (p_etag == src.size()) {
      std::stringstream sstr;
      sstr << "hddm_r::istream::getTag"
           << " error - bad header format" << std::endl
           << "   tag " << tag << " at position " << start
           << std::endl;
      throw std::runtime_error(sstr.str());
   }
   return p_etag+2;
}

size_t istream::getEndTag(const std::string &src, size_t start,
                          const std::string &tag)
{
   if (tag.rfind("/>") == tag.size()-2) {
      return src.find(tag,start) + tag.size()+1;
   }
   else {
      std::string etag = "</";
      etag += tag.substr(1,tag.find_first_of(' ')-1) + ">";
      size_t p_etag = src.find(etag,start);
      size_t p_quote = src.find_first_of('"',start);
      while (p_quote != std::string::npos && p_quote < p_etag) {
         p_quote = src.find_first_of('"',p_quote+1);
         if (p_quote > p_etag) {
            p_etag = src.find(etag,p_quote+1);
         }
         p_quote = src.find_first_of('"',p_quote+1);
      }
      if (p_etag == std::string::npos) {
         std::stringstream sstr;
         sstr << "hddm_r::istream::getEndTag"
              << " error - bad header format" << std::endl
              << "   tag " << tag << " at position " << start
              << std::endl
              << "   end tag " << etag << " not found."
              << std::endl;
         throw std::runtime_error(sstr.str());
      }
      return p_etag + etag.size()+1;
   }
}

void istream::collide(const std::string &itag, const std::string &rtag) {
   std::string itagname = itag.substr(1,itag.find(" ")-1);
   std::string rtagname = rtag.substr(1,rtag.find(" ")-1);
   std::string errmsg = "hddm_r::istream::collide warning:\n"
         "tag " + itagname + " in input file "
         "does not match c++ header hddm_r.hpp\n"
         "  input file: " + itag + "\n"
         "  c++ header: " + rtag + "\n"
         "  === Tag " + itagname + " will be ignored,"
         " rebuild to cure the problem ===";
   if (itagname != "HDDM") {
      std::cerr << errmsg << std::endl;
   }
   else {
      throw std::runtime_error(errmsg);
   }
}

chromosome istream::synthesize(const std::string &src, size_t p_src,
                               const std::string &ref, size_t p_ref)
{
   chromosome chrom;
   int slevel, rlevel;
   std::string stag, rtag;
   p_src = getTag(src,p_src,stag,slevel);
   p_ref = getTag(ref,p_ref,rtag,rlevel);
   std::string stagname = stag.substr(1,stag.find(" ")-1);
   std::string rtagname = rtag.substr(1,rtag.find(" ")-1);
   if (stagname != rtagname) {
      throw std::runtime_error("hddm_r::istream::synthesize error - matching algorithm error #2");
   }
   else if (!tags_match(stag,rtag)) {
      collide(stag,rtag);
      return chrom;
   }

   size_t p2_src, p2_ref;
   int s2level, r2level;
   std::string s2tag, r2tag;
   getTag(src,p2_src=p_src,s2tag,s2level);
   while (s2level > slevel) {
      codon *gene = new codon();
      std::string s2tagname = s2tag.substr(1,s2tag.find(" ")-1);
      getTag(ref,p2_ref=p_ref,r2tag,r2level);
      int order_of_this_tag_in_ref = 1;
      while (r2level == s2level) {
         std::string r2tagname = r2tag.substr(1,r2tag.find(" ")-1);
         if (s2tagname == r2tagname) {
            if (!tags_match(s2tag,r2tag)) {
               collide(s2tag,r2tag);
               break;
            }
            else {
               gene->m_order = order_of_this_tag_in_ref;
            }
            gene->m_sequence = synthesize(src,p2_src,ref,p2_ref);
            break;
         }
         p2_ref = getEndTag(ref,p2_ref,r2tag);
         getTag(ref,p2_ref,r2tag,r2level);
         ++order_of_this_tag_in_ref;
      }
      gene->m_tagname = s2tagname;
      chrom.push_back(*gene);
      delete gene;
      p2_src = getEndTag(src,p2_src,s2tag);
      getTag(src,p2_src,s2tag,s2level);
   }
   return chrom;
}

#ifdef HDF5_SUPPORT
std::map<std::string, hid_t> HDDM::s_hdf5_datatype;
std::map<std::string, hid_t> HDDM::s_hdf5_memorytype;
std::map<std::string, hid_t> HDDM::s_hdf5_memoryspace;
std::map<hid_t, hid_t> HDDM::s_hdf5_dataspace;
std::map<hid_t, hid_t> HDDM::s_hdf5_chunking;
std::map<hid_t, hid_t> HDDM::s_hdf5_dataset;
#endif
