/*
 * pyhddm_r.cpy - DO NOT EDIT THIS FILE
 *
 * This file was generated automatically by hddm-py from the file
 * rest.xml

 * This source file contains the Python/C++ API wrappers that
 * provide a python interface to the hddm classes and methods
 * generated by hddm-cpp from rest.xml.
 *
 * The hddm data model tool set was written by
 * Richard Jones, University of Connecticut.
 *
 * For more information see the documentation at
 * http://github.com/rjones30/HDDM
 *
 */

#include <Python.h>
#include <structmember.h>

#include <hddm_r.hpp>
#include <fstream>
#include <iostream>
#include <exception>
#include <particleType.h>
#ifdef ISTREAM_OVER_HTTP
#include <httpstream.hpp>
#endif
#ifdef ISTREAM_OVER_XROOTD
#include <xrootdstream.hpp>
#endif

using namespace hddm_r;

#if PY_MAJOR_VERSION >= 3
   #define PyInt_FromLong PyLong_FromLong
   #define PyInt_AsLong PyLong_AsLong
#endif


inline void LOG_NEW(PyTypeObject *t, PyTypeObject *subt=0, int own=0) {
#if 0
   if (subt == 0)
      std::cout << "creating a new element of " << t->tp_name
                << " " << ((own == 0)? "(borrowed)" : "(owned)")
                << std::endl;
   else
      std::cout << "creating a new list of " << subt->tp_name
                << " " << ((own == 0)? "(borrowed)" : "(owned)")
                << std::endl;
#endif
}

inline void LOG_DEALLOC(PyTypeObject *t, PyTypeObject *subt=0, int own=0) {
#if 0
   if (subt == 0)
      std::cout << "destroying an element of " << t->tp_name
                << " " << ((own == 0)? "(borrowed)" : "(owned)")
                << std::endl;
   else
      std::cout << "destroying a list of " << subt->tp_name
                << " " << ((own == 0)? "(borrowed)" : "(owned)")
                << std::endl;
#endif
}

inline void My_INCREF(PyObject *o) {
   //std::cout << "incrementing reference at " << o << std::endl;
   Py_INCREF(o);
}

inline void My_DECREF(PyObject *o) {
   //std::cout << "decrementing reference at " << o << std::endl;
   Py_DECREF(o);
}

// wrap base class hddm_r::HDDM_Element as hddm_r.HDDM_Element

typedef struct {
   PyObject_HEAD
   HDDM_Element *elem;
   PyObject *host;
} _HDDM_Element;

static void
_HDDM_Element_dealloc(_HDDM_Element* self)
{
   if (self->elem != 0) {
      LOG_DEALLOC(Py_TYPE(self), 0, self->host == (PyObject*)self);
      if (self->host == (PyObject*)self)
         delete self->elem;
      else
         My_DECREF(self->host);
   }
   Py_TYPE(self)->tp_free((PyObject*)self);
}

static PyObject*
_HDDM_Element_new(PyTypeObject *type, PyObject *args, PyObject *kwds)
{
   _HDDM_Element *self;
   self = (_HDDM_Element*)type->tp_alloc(type, 0);
   if (self != NULL) {
      self->elem = 0;
      self->host = 0;
   }
   return (PyObject*)self;
}

static int
_HDDM_Element_init(_HDDM_Element *self, PyObject *args, PyObject *kwds)
{
   PyErr_SetString(PyExc_RuntimeError, "illegal constructor");
   return -1;
}

static PyObject*
_HDDM_Element_getAttribute(PyObject *self, PyObject *args)
{
   char *attr;
   if (! PyArg_ParseTuple(args, "s", &attr)) {
      return NULL;
   }
   _HDDM_Element *me = (_HDDM_Element*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid element");
      return NULL;
   }
   hddm_type atype;
   void *val((int*)me->elem->getAttribute(std::string(attr),&atype));
   if (val == 0) {
      Py_INCREF(Py_None);
      return Py_None;
   }
   else if (atype == k_hddm_int) {
      return PyLong_FromLong(*(int*)val);
   }
   else if (atype == k_hddm_long) {
      return PyLong_FromLongLong(*(long long*)val);
   }
   else if (atype == k_hddm_float) {
      return PyFloat_FromDouble(double(*(float*)val));
   }
   else if (atype == k_hddm_double) {
      return PyFloat_FromDouble(*(double*)val);
   }
   else if (atype == k_hddm_boolean) {
      if (*(bool*)val == 0) {
         Py_INCREF(Py_False);
         return Py_False;
      }
      else {
         Py_INCREF(Py_True);
         return Py_True;
      }
   }
   else if (atype == k_hddm_string) {
      return PyUnicode_FromString(((std::string*)val)->c_str());
   }
   else if (atype == k_hddm_anyURI) {
      return PyUnicode_FromString(((std::string*)val)->c_str());
   }
   else if (atype == k_hddm_Particle_t) {
      return PyUnicode_FromString(ParticleType(*(Particle_t*)val));
   }
   return PyUnicode_FromString(((std::string*)val)->c_str());
}

static PyMemberDef _HDDM_Element_members[] = {
   {NULL}  /* Sentinel */
};

static PyMethodDef _HDDM_Element_methods[] = {
   {"getAttribute", _HDDM_Element_getAttribute, METH_VARARGS,
    "look up named attribute in this element"},
   {NULL}  /* Sentinel */
};

static PyTypeObject _HDDM_Element_type = {
    PyVarObject_HEAD_INIT(NULL,0)
    "hddm_r.HDDM_Element",     /*tp_name*/
    sizeof(_HDDM_Element),     /*tp_basicsize*/
    0,                         /*tp_itemsize*/
    (destructor)_HDDM_Element_dealloc, /*tp_dealloc*/
    0,                         /*tp_print*/
    0,                         /*tp_getattr*/
    0,                         /*tp_setattr*/
    0,                         /*tp_compare*/
    0,                         /*tp_repr*/
    0,                         /*tp_as_number*/
    0,                         /*tp_as_sequence*/
    0,                         /*tp_as_mapping*/
    0,                         /*tp_hash */
    0,                         /*tp_call*/
    0,                         /*tp_str*/
    0,                         /*tp_getattro*/
    0,                         /*tp_setattro*/
    0,                         /*tp_as_buffer*/
    Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE, /*tp_flags*/
    "hddm_r basic element",    /* tp_doc */
    0,                         /* tp_traverse */
    0,                         /* tp_clear */
    0,                         /* tp_richcompare */
    0,                         /* tp_weaklistoffset */
    0,                         /* tp_iter */
    0,                         /* tp_iternext */
    _HDDM_Element_methods,     /* tp_methods */
    _HDDM_Element_members,     /* tp_members */
    0,                         /* tp_getset */
    0,                         /* tp_base */
    0,                         /* tp_dict */
    0,                         /* tp_descr_get */
    0,                         /* tp_descr_set */
    0,                         /* tp_dictoffset */
    (initproc)_HDDM_Element_init, /* tp_init */
    0,                         /* tp_alloc */
    _HDDM_Element_new,         /* tp_new */
};


// wrap base class hddm_r::HDDM_ElementList as hddm_r.HDDM_ElementList

typedef struct {
   PyObject_HEAD
   PyTypeObject *subtype; // type of wrapper derived from _HDDM_Element
   HDDM_ElementList<HDDM_Element> *list;
   PyObject *host;
   int borrowed;
} _HDDM_ElementList;

static void
_HDDM_ElementList_dealloc(_HDDM_ElementList* self)
{
   if (self->list != 0) {
      LOG_DEALLOC(Py_TYPE(self), self->subtype, self->borrowed == 0);
      if (self->borrowed == 0)
         delete self->list;
      My_DECREF(self->host);
   }
   Py_TYPE(self)->tp_free((PyObject*)self);
}

static PyObject*
_HDDM_ElementList_new(PyTypeObject *type, PyObject *args, PyObject *kwds)
{
   _HDDM_ElementList *self;
   self = (_HDDM_ElementList*)type->tp_alloc(type, 0);
   if (self != NULL) {
      self->subtype = 0;
      self->borrowed = 0;
      self->host = 0;
   }
   return (PyObject*)self;
}

static int
_HDDM_ElementList_init(_HDDM_ElementList *self, PyObject *args, PyObject *kwds)
{
   PyErr_SetString(PyExc_RuntimeError, "illegal constructor");
   return -1;
}

static Py_ssize_t
_HDDM_ElementList_size(_HDDM_ElementList *self, void *closure)
{
   if (self->list == 0) {
      PyErr_SetString(PyExc_RuntimeError, "size attempted on invalid list");
      return -1;
   }
   return self->list->size();
}

static PyObject*
_HDDM_ElementList_item(_HDDM_ElementList *self, Py_ssize_t i)
{
   if (self->list == 0)
      return NULL;
   int len = self->list->size();
   if (i < 0 || i >= len) {
      PyErr_Format(PyExc_IndexError, "index %ld out of bounds.", i);
      return NULL;
   }
   PyObject *elem_obj = _HDDM_Element_new(self->subtype, 0, 0);
   ((_HDDM_Element*)elem_obj)->elem = &(HDDM_Element&)(*self->list)((int)i);
   ((_HDDM_Element*)elem_obj)->host = self->host;
   My_INCREF(self->host);
   LOG_NEW(self->subtype);
   return elem_obj;
}

extern PyTypeObject _HDDM_ElementList_type;

static PyObject *
_HDDM_ElementList_add(PyObject *self, PyObject *args)
{
   int count=0;
   int start=-1;
   if (! PyArg_ParseTuple(args, "i|i", &count, &start)) {
      return NULL;
   }
   _HDDM_ElementList *me = (_HDDM_ElementList*)self;
   if (me->list == 0) {
      PyErr_SetString(PyExc_RuntimeError, "add attempted on invalid list");
      return NULL;
   }
   PyObject *list = _HDDM_ElementList_new(&_HDDM_ElementList_type, 0, 0);
   ((_HDDM_ElementList*)list)->subtype = me->subtype;
   ((_HDDM_ElementList*)list)->list = (HDDM_ElementList<HDDM_Element>*)
    new HDDM_ElementList<HDDM_Element>(me->list->add(count, start));
   ((_HDDM_ElementList*)list)->borrowed = 0;
   ((_HDDM_ElementList*)list)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(self), me->subtype, 1);
   return list;
}

static PyObject *
_HDDM_ElementList_del(PyObject *self, PyObject *args)
{
   int start=0;
   int count=-1;
   if (! PyArg_ParseTuple(args, "|ii", &count, &start)) {
      return NULL;
   }
   _HDDM_ElementList *list_obj;
   list_obj = (_HDDM_ElementList*)self;
   if (list_obj->list == 0) {
      PyErr_SetString(PyExc_RuntimeError, "del attempted on invalid list");
      return NULL;
   }
   list_obj->list->del(count, start);
   Py_INCREF(self);
   return self;
}

static PyObject *
_HDDM_ElementList_clear(PyObject *self, PyObject *args)
{
   _HDDM_ElementList *list_obj;
   list_obj = (_HDDM_ElementList*)self;
   if (list_obj->list == 0) {
      PyErr_SetString(PyExc_RuntimeError, "clear attempted on invalid list");
      return NULL;
   }
   list_obj->list->clear();
   Py_INCREF(self);
   return self;
}

static PyMemberDef _HDDM_ElementList_members[] = {
   {NULL}  /* Sentinel */
};

static PyMethodDef _HDDM_ElementList_methods[] = {
   {"add",  _HDDM_ElementList_add, METH_VARARGS,
    "add (or insert) a new element to the list."},
   {"del",  _HDDM_ElementList_del, METH_VARARGS,
    "delete an existing element from the list."},
   {"clear",  _HDDM_ElementList_clear, METH_NOARGS,
    "reset the list to zero elements."},
   {NULL}  /* Sentinel */
};

static PySequenceMethods _HDDM_ElementList_as_sequence = {
    (lenfunc)_HDDM_ElementList_size,            /* sq_length */
    0,                                          /* sq_concat */
    0,                                          /* sq_repeat */
    (ssizeargfunc)_HDDM_ElementList_item,       /* sq_item */
    0,                                          /* sq_slice */
    0,                                          /* sq_ass_item */
    0,                                          /* sq_ass_slice */
    0,                                          /* sq_contains */
    0,                                          /* sq_inplace_concat */
    0,                                          /* sq_inplace_repeat */
};

PyTypeObject _HDDM_ElementList_type = {
    PyVarObject_HEAD_INIT(NULL,0)
    "hddm_r.HDDM_ElementList", /*tp_name*/
    sizeof(_HDDM_ElementList), /*tp_basicsize*/
    0,                         /*tp_itemsize*/
    (destructor)_HDDM_ElementList_dealloc, /*tp_dealloc*/
    0,                         /*tp_print*/
    0,                         /*tp_getattr*/
    0,                         /*tp_setattr*/
    0,                         /*tp_compare*/
    0,                         /*tp_repr*/
    0,                         /*tp_as_number*/
    &_HDDM_ElementList_as_sequence, /*tp_as_sequence*/
    0,                         /*tp_as_mapping*/
    0,                         /*tp_hash */
    0,                         /*tp_call*/
    0,                         /*tp_str*/
    0,                         /*tp_getattro*/
    0,                         /*tp_setattro*/
    0,                         /*tp_as_buffer*/
    Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE, /*tp_flags*/
    "hddm_r element list",    /* tp_doc */
    0,                         /* tp_traverse */
    0,                         /* tp_clear */
    0,                         /* tp_richcompare */
    0,                         /* tp_weaklistoffset */
    0,                         /* tp_iter */
    0,                         /* tp_iternext */
    _HDDM_ElementList_methods, /* tp_methods */
    _HDDM_ElementList_members, /* tp_members */
    0,                         /* tp_getset */
    0,                         /* tp_base */
    0,                         /* tp_dict */
    0,                         /* tp_descr_get */
    0,                         /* tp_descr_set */
    0,                         /* tp_dictoffset */
    (initproc)_HDDM_ElementList_init,   /* tp_init */
    0,                         /* tp_alloc */
    _HDDM_ElementList_new,     /* tp_new */
};


// wrap element class hddm_r::Comment as hddm_r.Comment

typedef struct {
   PyObject_HEAD
   Comment *elem;
   PyObject *host;
} _Comment;

static void
_Comment_dealloc(_Comment* self)
{
   if (self->elem != 0) {
      LOG_DEALLOC(Py_TYPE(self), 0, self->host == (PyObject*)self);
      if (self->host == (PyObject*)self)
         delete self->elem;
      else
         My_DECREF(self->host);
   }
   Py_TYPE(self)->tp_free((PyObject*)self);
}

static PyObject*
_Comment_new(PyTypeObject *type, PyObject *args, PyObject *kwds)
{
   _Comment *self;
   self = (_Comment*)type->tp_alloc(type, 0);
   if (self != NULL) {
      self->elem = 0;
      self->host = 0;
   }
   return (PyObject*)self;
}

static int
_Comment_init(_Comment *self, PyObject *args, PyObject *kwds)
{
   PyErr_SetString(PyExc_RuntimeError, "illegal constructor");
   return -1;
}

static PyObject*
_Comment_getClass(_Comment *self, void *closure)
{
   std::string val(self->elem->getClass());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_Comment_getVersion(_Comment *self, void *closure)
{
   std::string val(self->elem->getVersion());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_Comment_getXmlns(_Comment *self, void *closure)
{
   std::string val(self->elem->getXmlns());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_Comment_getEventNo(_Comment *self, void *closure)
{
   return PyLong_FromLongLong(self->elem->getEventNo());
}

static PyObject*
_Comment_getRunNo(_Comment *self, void *closure)
{
   return PyLong_FromLong(self->elem->getRunNo());
}

static PyObject*
_Comment_getMaxOccurs(_Comment *self, void *closure)
{
   std::string val(self->elem->getMaxOccurs());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_Comment_getMinOccurs(_Comment *self, void *closure)
{
   return PyLong_FromLong(self->elem->getMinOccurs());
}

static PyObject*
_Comment_getText(_Comment *self, void *closure)
{
   std::string val(self->elem->getText());
   return PyUnicode_FromString(val.c_str());
}

static int
_Comment_setText(_Comment *self, PyObject *value, void *closure)
{
   PyObject *str=0;
   if (PyUnicode_Check(value))
      str = PyUnicode_AsEncodedString(value, "ASCII", "strict");
   else
      str = value;
#if PY_MAJOR_VERSION < 3
   char *var = PyString_AsString(str);
#else
   char *var = PyBytes_AsString(str);
#endif
   if (var == 0) {
      return -1;
   }
   self->elem->setText(std::string(var));
   if (str != value) {
      Py_DECREF(str);
   }
   return 0;
}

static PyObject*
_Comment_toString(PyObject *self, PyObject *args=0)
{
   _Comment *me = (_Comment*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid comment element");
      return NULL;
   }
   std::string str(me->elem->toString());
   return PyUnicode_FromString(str.c_str());
}

static PyObject*
_Comment_toXML(PyObject *self, PyObject *args=0)
{
   _Comment *me = (_Comment*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid comment element");
      return NULL;
   }
   std::string str(me->elem->toXML());
   return PyUnicode_FromString(str.c_str());
}

static PyGetSetDef _Comment_getsetters[] = {
   {(char*)"class",
    (getter)_Comment_getClass, 0,
    (char*)"class string",
    NULL},
   {(char*)"eventNo",
    (getter)_Comment_getEventNo, 0,
    (char*)"eventNo value",
    NULL},
   {(char*)"maxOccurs",
    (getter)_Comment_getMaxOccurs, 0,
    (char*)"maxOccurs value",
    NULL},
   {(char*)"minOccurs",
    (getter)_Comment_getMinOccurs, 0,
    (char*)"minOccurs value",
    NULL},
   {(char*)"runNo",
    (getter)_Comment_getRunNo, 0,
    (char*)"runNo value",
    NULL},
   {(char*)"text",
    (getter)_Comment_getText, (setter)_Comment_setText,
    (char*)"text string",
    NULL},
   {(char*)"version",
    (getter)_Comment_getVersion, 0,
    (char*)"version string",
    NULL},
   {(char*)"xmlns",
    (getter)_Comment_getXmlns, 0,
    (char*)"xmlns string",
    NULL},
   {NULL}  /* Sentinel */
};

static PyMemberDef _Comment_members[] = {
   {NULL}  /* Sentinel */
};

static PyMethodDef _Comment_methods[] = {
   {"toString", _Comment_toString, METH_NOARGS,
    "show element as a human-readable string"},
   {"toXML", _Comment_toXML, METH_NOARGS,
    "show element as a XML fragment"},
   {NULL}  /* Sentinel */
};

static PyTypeObject _Comment_type = {
    PyVarObject_HEAD_INIT(NULL,0)
    "hddm_r.Comment",         /*tp_name*/
    sizeof(_Comment),          /*tp_basicsize*/
    0,                         /*tp_itemsize*/
    (destructor)_Comment_dealloc, /*tp_dealloc*/
    0,                         /*tp_print*/
    0,                         /*tp_getattr*/
    0,                         /*tp_setattr*/
    0,                         /*tp_compare*/
    0,                         /*tp_repr*/
    0,                         /*tp_as_number*/
    0,                         /*tp_as_sequence*/
    0,                         /*tp_as_mapping*/
    0,                         /*tp_hash */
    0,                         /*tp_call*/
    (reprfunc)_Comment_toString,         /*tp_str*/
    0,                         /*tp_getattro*/
    0,                         /*tp_setattro*/
    0,                         /*tp_as_buffer*/
    Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE, /*tp_flags*/
    "hddm_r comment element",  /* tp_doc */
    0,                         /* tp_traverse */
    0,                         /* tp_clear */
    0,                         /* tp_richcompare */
    0,                         /* tp_weaklistoffset */
    0,                         /* tp_iter */
    0,                         /* tp_iternext */
    _Comment_methods,          /* tp_methods */
    _Comment_members,          /* tp_members */
    _Comment_getsetters,       /* tp_getset */
    &_HDDM_Element_type,       /* tp_base */
    0,                         /* tp_dict */
    0,                         /* tp_descr_get */
    0,                         /* tp_descr_set */
    0,                         /* tp_dictoffset */
    (initproc)_Comment_init,   /* tp_init */
    0,                         /* tp_alloc */
    _Comment_new,              /* tp_new */
};



// wrap element class hddm_r::DataVersionString as hddm_r.DataVersionString

typedef struct {
   PyObject_HEAD
   DataVersionString *elem;
   PyObject *host;
} _DataVersionString;

static void
_DataVersionString_dealloc(_DataVersionString* self)
{
   if (self->elem != 0) {
      LOG_DEALLOC(Py_TYPE(self), 0, self->host == (PyObject*)self);
      if (self->host == (PyObject*)self)
         delete self->elem;
      else
         My_DECREF(self->host);
   }
   Py_TYPE(self)->tp_free((PyObject*)self);
}

static PyObject*
_DataVersionString_new(PyTypeObject *type, PyObject *args, PyObject *kwds)
{
   _DataVersionString *self;
   self = (_DataVersionString*)type->tp_alloc(type, 0);
   if (self != NULL) {
      self->elem = 0;
      self->host = 0;
   }
   return (PyObject*)self;
}

static int
_DataVersionString_init(_DataVersionString *self, PyObject *args, PyObject *kwds)
{
   PyErr_SetString(PyExc_RuntimeError, "illegal constructor");
   return -1;
}

static PyObject*
_DataVersionString_getClass(_DataVersionString *self, void *closure)
{
   std::string val(self->elem->getClass());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_DataVersionString_getVersion(_DataVersionString *self, void *closure)
{
   std::string val(self->elem->getVersion());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_DataVersionString_getXmlns(_DataVersionString *self, void *closure)
{
   std::string val(self->elem->getXmlns());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_DataVersionString_getEventNo(_DataVersionString *self, void *closure)
{
   return PyLong_FromLongLong(self->elem->getEventNo());
}

static PyObject*
_DataVersionString_getRunNo(_DataVersionString *self, void *closure)
{
   return PyLong_FromLong(self->elem->getRunNo());
}

static PyObject*
_DataVersionString_getMaxOccurs(_DataVersionString *self, void *closure)
{
   std::string val(self->elem->getMaxOccurs());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_DataVersionString_getMinOccurs(_DataVersionString *self, void *closure)
{
   return PyLong_FromLong(self->elem->getMinOccurs());
}

static PyObject*
_DataVersionString_getText(_DataVersionString *self, void *closure)
{
   std::string val(self->elem->getText());
   return PyUnicode_FromString(val.c_str());
}

static int
_DataVersionString_setText(_DataVersionString *self, PyObject *value, void *closure)
{
   PyObject *str=0;
   if (PyUnicode_Check(value))
      str = PyUnicode_AsEncodedString(value, "ASCII", "strict");
   else
      str = value;
#if PY_MAJOR_VERSION < 3
   char *var = PyString_AsString(str);
#else
   char *var = PyBytes_AsString(str);
#endif
   if (var == 0) {
      return -1;
   }
   self->elem->setText(std::string(var));
   if (str != value) {
      Py_DECREF(str);
   }
   return 0;
}

static PyObject*
_DataVersionString_toString(PyObject *self, PyObject *args=0)
{
   _DataVersionString *me = (_DataVersionString*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid dataVersionString element");
      return NULL;
   }
   std::string str(me->elem->toString());
   return PyUnicode_FromString(str.c_str());
}

static PyObject*
_DataVersionString_toXML(PyObject *self, PyObject *args=0)
{
   _DataVersionString *me = (_DataVersionString*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid dataVersionString element");
      return NULL;
   }
   std::string str(me->elem->toXML());
   return PyUnicode_FromString(str.c_str());
}

static PyGetSetDef _DataVersionString_getsetters[] = {
   {(char*)"class",
    (getter)_DataVersionString_getClass, 0,
    (char*)"class string",
    NULL},
   {(char*)"eventNo",
    (getter)_DataVersionString_getEventNo, 0,
    (char*)"eventNo value",
    NULL},
   {(char*)"maxOccurs",
    (getter)_DataVersionString_getMaxOccurs, 0,
    (char*)"maxOccurs value",
    NULL},
   {(char*)"minOccurs",
    (getter)_DataVersionString_getMinOccurs, 0,
    (char*)"minOccurs value",
    NULL},
   {(char*)"runNo",
    (getter)_DataVersionString_getRunNo, 0,
    (char*)"runNo value",
    NULL},
   {(char*)"text",
    (getter)_DataVersionString_getText, (setter)_DataVersionString_setText,
    (char*)"text string",
    NULL},
   {(char*)"version",
    (getter)_DataVersionString_getVersion, 0,
    (char*)"version string",
    NULL},
   {(char*)"xmlns",
    (getter)_DataVersionString_getXmlns, 0,
    (char*)"xmlns string",
    NULL},
   {NULL}  /* Sentinel */
};

static PyMemberDef _DataVersionString_members[] = {
   {NULL}  /* Sentinel */
};

static PyMethodDef _DataVersionString_methods[] = {
   {"toString", _DataVersionString_toString, METH_NOARGS,
    "show element as a human-readable string"},
   {"toXML", _DataVersionString_toXML, METH_NOARGS,
    "show element as a XML fragment"},
   {NULL}  /* Sentinel */
};

static PyTypeObject _DataVersionString_type = {
    PyVarObject_HEAD_INIT(NULL,0)
    "hddm_r.DataVersionString",         /*tp_name*/
    sizeof(_DataVersionString),          /*tp_basicsize*/
    0,                         /*tp_itemsize*/
    (destructor)_DataVersionString_dealloc, /*tp_dealloc*/
    0,                         /*tp_print*/
    0,                         /*tp_getattr*/
    0,                         /*tp_setattr*/
    0,                         /*tp_compare*/
    0,                         /*tp_repr*/
    0,                         /*tp_as_number*/
    0,                         /*tp_as_sequence*/
    0,                         /*tp_as_mapping*/
    0,                         /*tp_hash */
    0,                         /*tp_call*/
    (reprfunc)_DataVersionString_toString,         /*tp_str*/
    0,                         /*tp_getattro*/
    0,                         /*tp_setattro*/
    0,                         /*tp_as_buffer*/
    Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE, /*tp_flags*/
    "hddm_r dataVersionString element",  /* tp_doc */
    0,                         /* tp_traverse */
    0,                         /* tp_clear */
    0,                         /* tp_richcompare */
    0,                         /* tp_weaklistoffset */
    0,                         /* tp_iter */
    0,                         /* tp_iternext */
    _DataVersionString_methods,          /* tp_methods */
    _DataVersionString_members,          /* tp_members */
    _DataVersionString_getsetters,       /* tp_getset */
    &_HDDM_Element_type,       /* tp_base */
    0,                         /* tp_dict */
    0,                         /* tp_descr_get */
    0,                         /* tp_descr_set */
    0,                         /* tp_dictoffset */
    (initproc)_DataVersionString_init,   /* tp_init */
    0,                         /* tp_alloc */
    _DataVersionString_new,              /* tp_new */
};



// wrap element class hddm_r::CcdbContext as hddm_r.CcdbContext

typedef struct {
   PyObject_HEAD
   CcdbContext *elem;
   PyObject *host;
} _CcdbContext;

static void
_CcdbContext_dealloc(_CcdbContext* self)
{
   if (self->elem != 0) {
      LOG_DEALLOC(Py_TYPE(self), 0, self->host == (PyObject*)self);
      if (self->host == (PyObject*)self)
         delete self->elem;
      else
         My_DECREF(self->host);
   }
   Py_TYPE(self)->tp_free((PyObject*)self);
}

static PyObject*
_CcdbContext_new(PyTypeObject *type, PyObject *args, PyObject *kwds)
{
   _CcdbContext *self;
   self = (_CcdbContext*)type->tp_alloc(type, 0);
   if (self != NULL) {
      self->elem = 0;
      self->host = 0;
   }
   return (PyObject*)self;
}

static int
_CcdbContext_init(_CcdbContext *self, PyObject *args, PyObject *kwds)
{
   PyErr_SetString(PyExc_RuntimeError, "illegal constructor");
   return -1;
}

static PyObject*
_CcdbContext_getClass(_CcdbContext *self, void *closure)
{
   std::string val(self->elem->getClass());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_CcdbContext_getVersion(_CcdbContext *self, void *closure)
{
   std::string val(self->elem->getVersion());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_CcdbContext_getXmlns(_CcdbContext *self, void *closure)
{
   std::string val(self->elem->getXmlns());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_CcdbContext_getEventNo(_CcdbContext *self, void *closure)
{
   return PyLong_FromLongLong(self->elem->getEventNo());
}

static PyObject*
_CcdbContext_getRunNo(_CcdbContext *self, void *closure)
{
   return PyLong_FromLong(self->elem->getRunNo());
}

static PyObject*
_CcdbContext_getMaxOccurs(_CcdbContext *self, void *closure)
{
   std::string val(self->elem->getMaxOccurs());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_CcdbContext_getMinOccurs(_CcdbContext *self, void *closure)
{
   return PyLong_FromLong(self->elem->getMinOccurs());
}

static PyObject*
_CcdbContext_getText(_CcdbContext *self, void *closure)
{
   std::string val(self->elem->getText());
   return PyUnicode_FromString(val.c_str());
}

static int
_CcdbContext_setText(_CcdbContext *self, PyObject *value, void *closure)
{
   PyObject *str=0;
   if (PyUnicode_Check(value))
      str = PyUnicode_AsEncodedString(value, "ASCII", "strict");
   else
      str = value;
#if PY_MAJOR_VERSION < 3
   char *var = PyString_AsString(str);
#else
   char *var = PyBytes_AsString(str);
#endif
   if (var == 0) {
      return -1;
   }
   self->elem->setText(std::string(var));
   if (str != value) {
      Py_DECREF(str);
   }
   return 0;
}

static PyObject*
_CcdbContext_toString(PyObject *self, PyObject *args=0)
{
   _CcdbContext *me = (_CcdbContext*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid ccdbContext element");
      return NULL;
   }
   std::string str(me->elem->toString());
   return PyUnicode_FromString(str.c_str());
}

static PyObject*
_CcdbContext_toXML(PyObject *self, PyObject *args=0)
{
   _CcdbContext *me = (_CcdbContext*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid ccdbContext element");
      return NULL;
   }
   std::string str(me->elem->toXML());
   return PyUnicode_FromString(str.c_str());
}

static PyGetSetDef _CcdbContext_getsetters[] = {
   {(char*)"class",
    (getter)_CcdbContext_getClass, 0,
    (char*)"class string",
    NULL},
   {(char*)"eventNo",
    (getter)_CcdbContext_getEventNo, 0,
    (char*)"eventNo value",
    NULL},
   {(char*)"maxOccurs",
    (getter)_CcdbContext_getMaxOccurs, 0,
    (char*)"maxOccurs value",
    NULL},
   {(char*)"minOccurs",
    (getter)_CcdbContext_getMinOccurs, 0,
    (char*)"minOccurs value",
    NULL},
   {(char*)"runNo",
    (getter)_CcdbContext_getRunNo, 0,
    (char*)"runNo value",
    NULL},
   {(char*)"text",
    (getter)_CcdbContext_getText, (setter)_CcdbContext_setText,
    (char*)"text string",
    NULL},
   {(char*)"version",
    (getter)_CcdbContext_getVersion, 0,
    (char*)"version string",
    NULL},
   {(char*)"xmlns",
    (getter)_CcdbContext_getXmlns, 0,
    (char*)"xmlns string",
    NULL},
   {NULL}  /* Sentinel */
};

static PyMemberDef _CcdbContext_members[] = {
   {NULL}  /* Sentinel */
};

static PyMethodDef _CcdbContext_methods[] = {
   {"toString", _CcdbContext_toString, METH_NOARGS,
    "show element as a human-readable string"},
   {"toXML", _CcdbContext_toXML, METH_NOARGS,
    "show element as a XML fragment"},
   {NULL}  /* Sentinel */
};

static PyTypeObject _CcdbContext_type = {
    PyVarObject_HEAD_INIT(NULL,0)
    "hddm_r.CcdbContext",         /*tp_name*/
    sizeof(_CcdbContext),          /*tp_basicsize*/
    0,                         /*tp_itemsize*/
    (destructor)_CcdbContext_dealloc, /*tp_dealloc*/
    0,                         /*tp_print*/
    0,                         /*tp_getattr*/
    0,                         /*tp_setattr*/
    0,                         /*tp_compare*/
    0,                         /*tp_repr*/
    0,                         /*tp_as_number*/
    0,                         /*tp_as_sequence*/
    0,                         /*tp_as_mapping*/
    0,                         /*tp_hash */
    0,                         /*tp_call*/
    (reprfunc)_CcdbContext_toString,         /*tp_str*/
    0,                         /*tp_getattro*/
    0,                         /*tp_setattro*/
    0,                         /*tp_as_buffer*/
    Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE, /*tp_flags*/
    "hddm_r ccdbContext element",  /* tp_doc */
    0,                         /* tp_traverse */
    0,                         /* tp_clear */
    0,                         /* tp_richcompare */
    0,                         /* tp_weaklistoffset */
    0,                         /* tp_iter */
    0,                         /* tp_iternext */
    _CcdbContext_methods,          /* tp_methods */
    _CcdbContext_members,          /* tp_members */
    _CcdbContext_getsetters,       /* tp_getset */
    &_HDDM_Element_type,       /* tp_base */
    0,                         /* tp_dict */
    0,                         /* tp_descr_get */
    0,                         /* tp_descr_set */
    0,                         /* tp_dictoffset */
    (initproc)_CcdbContext_init,   /* tp_init */
    0,                         /* tp_alloc */
    _CcdbContext_new,              /* tp_new */
};



// wrap element class hddm_r::Origin as hddm_r.Origin

typedef struct {
   PyObject_HEAD
   Origin *elem;
   PyObject *host;
} _Origin;

static void
_Origin_dealloc(_Origin* self)
{
   if (self->elem != 0) {
      LOG_DEALLOC(Py_TYPE(self), 0, self->host == (PyObject*)self);
      if (self->host == (PyObject*)self)
         delete self->elem;
      else
         My_DECREF(self->host);
   }
   Py_TYPE(self)->tp_free((PyObject*)self);
}

static PyObject*
_Origin_new(PyTypeObject *type, PyObject *args, PyObject *kwds)
{
   _Origin *self;
   self = (_Origin*)type->tp_alloc(type, 0);
   if (self != NULL) {
      self->elem = 0;
      self->host = 0;
   }
   return (PyObject*)self;
}

static int
_Origin_init(_Origin *self, PyObject *args, PyObject *kwds)
{
   PyErr_SetString(PyExc_RuntimeError, "illegal constructor");
   return -1;
}

static PyObject*
_Origin_getClass(_Origin *self, void *closure)
{
   std::string val(self->elem->getClass());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_Origin_getVersion(_Origin *self, void *closure)
{
   std::string val(self->elem->getVersion());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_Origin_getXmlns(_Origin *self, void *closure)
{
   std::string val(self->elem->getXmlns());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_Origin_getEventNo(_Origin *self, void *closure)
{
   return PyLong_FromLongLong(self->elem->getEventNo());
}

static PyObject*
_Origin_getRunNo(_Origin *self, void *closure)
{
   return PyLong_FromLong(self->elem->getRunNo());
}

static PyObject*
_Origin_getEbeam(_Origin *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getEbeam());
}

static PyObject*
_Origin_getEunit(_Origin *self, void *closure)
{
   std::string val(self->elem->getEunit());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_Origin_getJtag(_Origin *self, void *closure)
{
   std::string val(self->elem->getJtag());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_Origin_getMaxOccurs(_Origin *self, void *closure)
{
   std::string val(self->elem->getMaxOccurs());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_Origin_getMinOccurs(_Origin *self, void *closure)
{
   return PyLong_FromLong(self->elem->getMinOccurs());
}

static PyObject*
_Origin_getTargetType(_Origin *self, void *closure)
{
   Particle_t p(self->elem->getTargetType());
   std::string val(ParticleType(p));
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_Origin_getType(_Origin *self, void *closure)
{
   return PyLong_FromLong(self->elem->getType());
}

static PyObject*
_Origin_getWeight(_Origin *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getWeight());
}

static PyObject*
_Origin_getLunit(_Origin *self, void *closure)
{
   std::string val(self->elem->getLunit());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_Origin_getT(_Origin *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getT());
}

static int
_Origin_setT(_Origin *self, PyObject *value, void *closure)
{
   double var = PyFloat_AsDouble(value);
   if (var == -1 && PyErr_Occurred()) {
      return 1;
   }
   self->elem->setT((float)var);
   return 0;
}

static PyObject*
_Origin_getVx(_Origin *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getVx());
}

static int
_Origin_setVx(_Origin *self, PyObject *value, void *closure)
{
   double var = PyFloat_AsDouble(value);
   if (var == -1 && PyErr_Occurred()) {
      return 1;
   }
   self->elem->setVx((float)var);
   return 0;
}

static PyObject*
_Origin_getVy(_Origin *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getVy());
}

static int
_Origin_setVy(_Origin *self, PyObject *value, void *closure)
{
   double var = PyFloat_AsDouble(value);
   if (var == -1 && PyErr_Occurred()) {
      return 1;
   }
   self->elem->setVy((float)var);
   return 0;
}

static PyObject*
_Origin_getVz(_Origin *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getVz());
}

static int
_Origin_setVz(_Origin *self, PyObject *value, void *closure)
{
   double var = PyFloat_AsDouble(value);
   if (var == -1 && PyErr_Occurred()) {
      return 1;
   }
   self->elem->setVz((float)var);
   return 0;
}

static PyObject*
_Origin_toString(PyObject *self, PyObject *args=0)
{
   _Origin *me = (_Origin*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid origin element");
      return NULL;
   }
   std::string str(me->elem->toString());
   return PyUnicode_FromString(str.c_str());
}

static PyObject*
_Origin_toXML(PyObject *self, PyObject *args=0)
{
   _Origin *me = (_Origin*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid origin element");
      return NULL;
   }
   std::string str(me->elem->toXML());
   return PyUnicode_FromString(str.c_str());
}

static PyGetSetDef _Origin_getsetters[] = {
   {(char*)"Ebeam",
    (getter)_Origin_getEbeam, 0,
    (char*)"Ebeam value",
    NULL},
   {(char*)"Eunit",
    (getter)_Origin_getEunit, 0,
    (char*)"Eunit string",
    NULL},
   {(char*)"class",
    (getter)_Origin_getClass, 0,
    (char*)"class string",
    NULL},
   {(char*)"eventNo",
    (getter)_Origin_getEventNo, 0,
    (char*)"eventNo value",
    NULL},
   {(char*)"jtag",
    (getter)_Origin_getJtag, 0,
    (char*)"jtag string",
    NULL},
   {(char*)"lunit",
    (getter)_Origin_getLunit, 0,
    (char*)"lunit value",
    NULL},
   {(char*)"maxOccurs",
    (getter)_Origin_getMaxOccurs, 0,
    (char*)"maxOccurs string",
    NULL},
   {(char*)"minOccurs",
    (getter)_Origin_getMinOccurs, 0,
    (char*)"minOccurs value",
    NULL},
   {(char*)"runNo",
    (getter)_Origin_getRunNo, 0,
    (char*)"runNo value",
    NULL},
   {(char*)"t",
    (getter)_Origin_getT, (setter)_Origin_setT,
    (char*)"t value",
    NULL},
   {(char*)"targetType",
    (getter)_Origin_getTargetType, 0,
    (char*)"targetType value",
    NULL},
   {(char*)"type",
    (getter)_Origin_getType, 0,
    (char*)"type value",
    NULL},
   {(char*)"version",
    (getter)_Origin_getVersion, 0,
    (char*)"version string",
    NULL},
   {(char*)"vx",
    (getter)_Origin_getVx, (setter)_Origin_setVx,
    (char*)"vx value",
    NULL},
   {(char*)"vy",
    (getter)_Origin_getVy, (setter)_Origin_setVy,
    (char*)"vy value",
    NULL},
   {(char*)"vz",
    (getter)_Origin_getVz, (setter)_Origin_setVz,
    (char*)"vz value",
    NULL},
   {(char*)"weight",
    (getter)_Origin_getWeight, 0,
    (char*)"weight value",
    NULL},
   {(char*)"xmlns",
    (getter)_Origin_getXmlns, 0,
    (char*)"xmlns string",
    NULL},
   {NULL}  /* Sentinel */
};

static PyMemberDef _Origin_members[] = {
   {NULL}  /* Sentinel */
};

static PyMethodDef _Origin_methods[] = {
   {"toString", _Origin_toString, METH_NOARGS,
    "show element as a human-readable string"},
   {"toXML", _Origin_toXML, METH_NOARGS,
    "show element as a XML fragment"},
   {NULL}  /* Sentinel */
};

static PyTypeObject _Origin_type = {
    PyVarObject_HEAD_INIT(NULL,0)
    "hddm_r.Origin",         /*tp_name*/
    sizeof(_Origin),          /*tp_basicsize*/
    0,                         /*tp_itemsize*/
    (destructor)_Origin_dealloc, /*tp_dealloc*/
    0,                         /*tp_print*/
    0,                         /*tp_getattr*/
    0,                         /*tp_setattr*/
    0,                         /*tp_compare*/
    0,                         /*tp_repr*/
    0,                         /*tp_as_number*/
    0,                         /*tp_as_sequence*/
    0,                         /*tp_as_mapping*/
    0,                         /*tp_hash */
    0,                         /*tp_call*/
    (reprfunc)_Origin_toString,         /*tp_str*/
    0,                         /*tp_getattro*/
    0,                         /*tp_setattro*/
    0,                         /*tp_as_buffer*/
    Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE, /*tp_flags*/
    "hddm_r origin element",  /* tp_doc */
    0,                         /* tp_traverse */
    0,                         /* tp_clear */
    0,                         /* tp_richcompare */
    0,                         /* tp_weaklistoffset */
    0,                         /* tp_iter */
    0,                         /* tp_iternext */
    _Origin_methods,          /* tp_methods */
    _Origin_members,          /* tp_members */
    _Origin_getsetters,       /* tp_getset */
    &_HDDM_Element_type,       /* tp_base */
    0,                         /* tp_dict */
    0,                         /* tp_descr_get */
    0,                         /* tp_descr_set */
    0,                         /* tp_dictoffset */
    (initproc)_Origin_init,   /* tp_init */
    0,                         /* tp_alloc */
    _Origin_new,              /* tp_new */
};



// wrap element class hddm_r::Momentum as hddm_r.Momentum

typedef struct {
   PyObject_HEAD
   Momentum *elem;
   PyObject *host;
} _Momentum;

static void
_Momentum_dealloc(_Momentum* self)
{
   if (self->elem != 0) {
      LOG_DEALLOC(Py_TYPE(self), 0, self->host == (PyObject*)self);
      if (self->host == (PyObject*)self)
         delete self->elem;
      else
         My_DECREF(self->host);
   }
   Py_TYPE(self)->tp_free((PyObject*)self);
}

static PyObject*
_Momentum_new(PyTypeObject *type, PyObject *args, PyObject *kwds)
{
   _Momentum *self;
   self = (_Momentum*)type->tp_alloc(type, 0);
   if (self != NULL) {
      self->elem = 0;
      self->host = 0;
   }
   return (PyObject*)self;
}

static int
_Momentum_init(_Momentum *self, PyObject *args, PyObject *kwds)
{
   PyErr_SetString(PyExc_RuntimeError, "illegal constructor");
   return -1;
}

static PyObject*
_Momentum_getClass(_Momentum *self, void *closure)
{
   std::string val(self->elem->getClass());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_Momentum_getVersion(_Momentum *self, void *closure)
{
   std::string val(self->elem->getVersion());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_Momentum_getXmlns(_Momentum *self, void *closure)
{
   std::string val(self->elem->getXmlns());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_Momentum_getEventNo(_Momentum *self, void *closure)
{
   return PyLong_FromLongLong(self->elem->getEventNo());
}

static PyObject*
_Momentum_getRunNo(_Momentum *self, void *closure)
{
   return PyLong_FromLong(self->elem->getRunNo());
}

static PyObject*
_Momentum_getEbeam(_Momentum *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getEbeam());
}

static PyObject*
_Momentum_getJtag(_Momentum *self, void *closure)
{
   std::string val(self->elem->getJtag());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_Momentum_getMaxOccurs(_Momentum *self, void *closure)
{
   std::string val(self->elem->getMaxOccurs());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_Momentum_getMinOccurs(_Momentum *self, void *closure)
{
   return PyLong_FromLong(self->elem->getMinOccurs());
}

static PyObject*
_Momentum_getTargetType(_Momentum *self, void *closure)
{
   Particle_t p(self->elem->getTargetType());
   std::string val(ParticleType(p));
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_Momentum_getType(_Momentum *self, void *closure)
{
   return PyLong_FromLong(self->elem->getType());
}

static PyObject*
_Momentum_getWeight(_Momentum *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getWeight());
}

static PyObject*
_Momentum_getId(_Momentum *self, void *closure)
{
   return PyLong_FromLong(self->elem->getId());
}

static PyObject*
_Momentum_getParentId(_Momentum *self, void *closure)
{
   return PyLong_FromLong(self->elem->getParentId());
}

static PyObject*
_Momentum_getPdgtype(_Momentum *self, void *closure)
{
   return PyLong_FromLong(self->elem->getPdgtype());
}

static PyObject*
_Momentum_getE(_Momentum *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getE());
}

static int
_Momentum_setE(_Momentum *self, PyObject *value, void *closure)
{
   double var = PyFloat_AsDouble(value);
   if (var == -1 && PyErr_Occurred()) {
      return 1;
   }
   self->elem->setE((float)var);
   return 0;
}

static PyObject*
_Momentum_getEunit(_Momentum *self, void *closure)
{
   std::string val(self->elem->getEunit());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_Momentum_getPunit(_Momentum *self, void *closure)
{
   std::string val(self->elem->getPunit());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_Momentum_getPx(_Momentum *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getPx());
}

static int
_Momentum_setPx(_Momentum *self, PyObject *value, void *closure)
{
   double var = PyFloat_AsDouble(value);
   if (var == -1 && PyErr_Occurred()) {
      return 1;
   }
   self->elem->setPx((float)var);
   return 0;
}

static PyObject*
_Momentum_getPy(_Momentum *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getPy());
}

static int
_Momentum_setPy(_Momentum *self, PyObject *value, void *closure)
{
   double var = PyFloat_AsDouble(value);
   if (var == -1 && PyErr_Occurred()) {
      return 1;
   }
   self->elem->setPy((float)var);
   return 0;
}

static PyObject*
_Momentum_getPz(_Momentum *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getPz());
}

static int
_Momentum_setPz(_Momentum *self, PyObject *value, void *closure)
{
   double var = PyFloat_AsDouble(value);
   if (var == -1 && PyErr_Occurred()) {
      return 1;
   }
   self->elem->setPz((float)var);
   return 0;
}

static PyObject*
_Momentum_toString(PyObject *self, PyObject *args=0)
{
   _Momentum *me = (_Momentum*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid momentum element");
      return NULL;
   }
   std::string str(me->elem->toString());
   return PyUnicode_FromString(str.c_str());
}

static PyObject*
_Momentum_toXML(PyObject *self, PyObject *args=0)
{
   _Momentum *me = (_Momentum*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid momentum element");
      return NULL;
   }
   std::string str(me->elem->toXML());
   return PyUnicode_FromString(str.c_str());
}

static PyGetSetDef _Momentum_getsetters[] = {
   {(char*)"E",
    (getter)_Momentum_getE, (setter)_Momentum_setE,
    (char*)"E value",
    NULL},
   {(char*)"Ebeam",
    (getter)_Momentum_getEbeam, 0,
    (char*)"Ebeam value",
    NULL},
   {(char*)"Eunit",
    (getter)_Momentum_getEunit, 0,
    (char*)"Eunit value",
    NULL},
   {(char*)"class",
    (getter)_Momentum_getClass, 0,
    (char*)"class string",
    NULL},
   {(char*)"eventNo",
    (getter)_Momentum_getEventNo, 0,
    (char*)"eventNo value",
    NULL},
   {(char*)"id",
    (getter)_Momentum_getId, 0,
    (char*)"id value",
    NULL},
   {(char*)"jtag",
    (getter)_Momentum_getJtag, 0,
    (char*)"jtag string",
    NULL},
   {(char*)"maxOccurs",
    (getter)_Momentum_getMaxOccurs, 0,
    (char*)"maxOccurs string",
    NULL},
   {(char*)"minOccurs",
    (getter)_Momentum_getMinOccurs, 0,
    (char*)"minOccurs value",
    NULL},
   {(char*)"parentId",
    (getter)_Momentum_getParentId, 0,
    (char*)"parentId value",
    NULL},
   {(char*)"pdgtype",
    (getter)_Momentum_getPdgtype, 0,
    (char*)"pdgtype value",
    NULL},
   {(char*)"punit",
    (getter)_Momentum_getPunit, 0,
    (char*)"punit value",
    NULL},
   {(char*)"px",
    (getter)_Momentum_getPx, (setter)_Momentum_setPx,
    (char*)"px value",
    NULL},
   {(char*)"py",
    (getter)_Momentum_getPy, (setter)_Momentum_setPy,
    (char*)"py value",
    NULL},
   {(char*)"pz",
    (getter)_Momentum_getPz, (setter)_Momentum_setPz,
    (char*)"pz value",
    NULL},
   {(char*)"runNo",
    (getter)_Momentum_getRunNo, 0,
    (char*)"runNo value",
    NULL},
   {(char*)"targetType",
    (getter)_Momentum_getTargetType, 0,
    (char*)"targetType value",
    NULL},
   {(char*)"type",
    (getter)_Momentum_getType, 0,
    (char*)"type value",
    NULL},
   {(char*)"version",
    (getter)_Momentum_getVersion, 0,
    (char*)"version string",
    NULL},
   {(char*)"weight",
    (getter)_Momentum_getWeight, 0,
    (char*)"weight value",
    NULL},
   {(char*)"xmlns",
    (getter)_Momentum_getXmlns, 0,
    (char*)"xmlns string",
    NULL},
   {NULL}  /* Sentinel */
};

static PyMemberDef _Momentum_members[] = {
   {NULL}  /* Sentinel */
};

static PyMethodDef _Momentum_methods[] = {
   {"toString", _Momentum_toString, METH_NOARGS,
    "show element as a human-readable string"},
   {"toXML", _Momentum_toXML, METH_NOARGS,
    "show element as a XML fragment"},
   {NULL}  /* Sentinel */
};

static PyTypeObject _Momentum_type = {
    PyVarObject_HEAD_INIT(NULL,0)
    "hddm_r.Momentum",         /*tp_name*/
    sizeof(_Momentum),          /*tp_basicsize*/
    0,                         /*tp_itemsize*/
    (destructor)_Momentum_dealloc, /*tp_dealloc*/
    0,                         /*tp_print*/
    0,                         /*tp_getattr*/
    0,                         /*tp_setattr*/
    0,                         /*tp_compare*/
    0,                         /*tp_repr*/
    0,                         /*tp_as_number*/
    0,                         /*tp_as_sequence*/
    0,                         /*tp_as_mapping*/
    0,                         /*tp_hash */
    0,                         /*tp_call*/
    (reprfunc)_Momentum_toString,         /*tp_str*/
    0,                         /*tp_getattro*/
    0,                         /*tp_setattro*/
    0,                         /*tp_as_buffer*/
    Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE, /*tp_flags*/
    "hddm_r momentum element",  /* tp_doc */
    0,                         /* tp_traverse */
    0,                         /* tp_clear */
    0,                         /* tp_richcompare */
    0,                         /* tp_weaklistoffset */
    0,                         /* tp_iter */
    0,                         /* tp_iternext */
    _Momentum_methods,          /* tp_methods */
    _Momentum_members,          /* tp_members */
    _Momentum_getsetters,       /* tp_getset */
    &_HDDM_Element_type,       /* tp_base */
    0,                         /* tp_dict */
    0,                         /* tp_descr_get */
    0,                         /* tp_descr_set */
    0,                         /* tp_dictoffset */
    (initproc)_Momentum_init,   /* tp_init */
    0,                         /* tp_alloc */
    _Momentum_new,              /* tp_new */
};



// wrap element class hddm_r::Product as hddm_r.Product

typedef struct {
   PyObject_HEAD
   Product *elem;
   PyObject *host;
} _Product;

static void
_Product_dealloc(_Product* self)
{
   if (self->elem != 0) {
      LOG_DEALLOC(Py_TYPE(self), 0, self->host == (PyObject*)self);
      if (self->host == (PyObject*)self)
         delete self->elem;
      else
         My_DECREF(self->host);
   }
   Py_TYPE(self)->tp_free((PyObject*)self);
}

static PyObject*
_Product_new(PyTypeObject *type, PyObject *args, PyObject *kwds)
{
   _Product *self;
   self = (_Product*)type->tp_alloc(type, 0);
   if (self != NULL) {
      self->elem = 0;
      self->host = 0;
   }
   return (PyObject*)self;
}

static int
_Product_init(_Product *self, PyObject *args, PyObject *kwds)
{
   PyErr_SetString(PyExc_RuntimeError, "illegal constructor");
   return -1;
}

static PyObject*
_Product_getClass(_Product *self, void *closure)
{
   std::string val(self->elem->getClass());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_Product_getVersion(_Product *self, void *closure)
{
   std::string val(self->elem->getVersion());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_Product_getXmlns(_Product *self, void *closure)
{
   std::string val(self->elem->getXmlns());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_Product_getEventNo(_Product *self, void *closure)
{
   return PyLong_FromLongLong(self->elem->getEventNo());
}

static PyObject*
_Product_getRunNo(_Product *self, void *closure)
{
   return PyLong_FromLong(self->elem->getRunNo());
}

static PyObject*
_Product_getEbeam(_Product *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getEbeam());
}

static PyObject*
_Product_getEunit(_Product *self, void *closure)
{
   std::string val(self->elem->getEunit());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_Product_getJtag(_Product *self, void *closure)
{
   std::string val(self->elem->getJtag());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_Product_getMinOccurs(_Product *self, void *closure)
{
   return PyLong_FromLong(self->elem->getMinOccurs());
}

static PyObject*
_Product_getTargetType(_Product *self, void *closure)
{
   Particle_t p(self->elem->getTargetType());
   std::string val(ParticleType(p));
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_Product_getType(_Product *self, void *closure)
{
   return PyLong_FromLong(self->elem->getType());
}

static PyObject*
_Product_getWeight(_Product *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getWeight());
}

static PyObject*
_Product_getId(_Product *self, void *closure)
{
   return PyLong_FromLong(self->elem->getId());
}

static int
_Product_setId(_Product *self, PyObject *value, void *closure)
{
   long var = PyInt_AsLong(value);
   if (var == -1 && PyErr_Occurred()) {
      return -1;
   }
   self->elem->setId(var);
   return 0;
}

static PyObject*
_Product_getMaxOccurs(_Product *self, void *closure)
{
   std::string val(self->elem->getMaxOccurs());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_Product_getParentId(_Product *self, void *closure)
{
   return PyLong_FromLong(self->elem->getParentId());
}

static int
_Product_setParentId(_Product *self, PyObject *value, void *closure)
{
   long var = PyInt_AsLong(value);
   if (var == -1 && PyErr_Occurred()) {
      return -1;
   }
   self->elem->setParentId(var);
   return 0;
}

static PyObject*
_Product_getPdgtype(_Product *self, void *closure)
{
   return PyLong_FromLong(self->elem->getPdgtype());
}

static int
_Product_setPdgtype(_Product *self, PyObject *value, void *closure)
{
   long var = PyInt_AsLong(value);
   if (var == -1 && PyErr_Occurred()) {
      return -1;
   }
   self->elem->setPdgtype(var);
   return 0;
}

static PyObject*
_Product_getMomentum(PyObject *self, PyObject *args)
{
   int index=0;
   if (! PyArg_ParseTuple(args, "|i", &index)) {
      return NULL;
   }
   _Product *me = (_Product*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid product element");
      return NULL;
   }
   PyObject *obj = _Momentum_new(&_Momentum_type, 0, 0);
   ((_Momentum*)obj)->elem = &me->elem->getMomentum();
   ((_Momentum*)obj)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(obj));
   return obj;
}

static PyObject*
_Product_getMomenta(PyObject *self, PyObject *args)
{
   _Product *me = (_Product*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid product element");
      return NULL;
   }
   PyObject *list = _HDDM_ElementList_new(&_HDDM_ElementList_type, 0, 0);
   ((_HDDM_ElementList*)list)->subtype = &_Momentum_type;
   ((_HDDM_ElementList*)list)->list = (HDDM_ElementList<HDDM_Element>*)
    &me->elem->getMomenta();
   ((_HDDM_ElementList*)list)->borrowed = 1;
   ((_HDDM_ElementList*)list)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(list), ((_HDDM_ElementList*)list)->subtype, 0);
   return list;
}

static PyObject*
_Product_addMomenta(PyObject *self, PyObject *args)
{
   int count=1;
   int start=-1;
   if (! PyArg_ParseTuple(args, "|ii", &count, &start)) {
      return NULL;
   }
   _Product *me = (_Product*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "add attempted on invalid product element");
      return NULL;
   }
   PyObject *list = _HDDM_ElementList_new(&_HDDM_ElementList_type, 0, 0);
   ((_HDDM_ElementList*)list)->subtype = &_Momentum_type;
   ((_HDDM_ElementList*)list)->list = (HDDM_ElementList<HDDM_Element>*)
    new MomentumList(me->elem->addMomenta(count, start));
   ((_HDDM_ElementList*)list)->borrowed = 0;
   ((_HDDM_ElementList*)list)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(list), ((_HDDM_ElementList*)list)->subtype, 1);
   return list;
}

static PyObject*
_Product_deleteMomenta(PyObject *self, PyObject *args)
{
   int count=-1;
   int start=0;
   if (! PyArg_ParseTuple(args, "|ii", &count, &start)) {
      return NULL;
   }
   _Product *me = (_Product*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "delete attempted on invalid product element");
      return NULL;
   }
   me->elem->deleteMomenta(count, start);
   Py_INCREF(Py_None);
   return Py_None;
}

static PyObject*
_Product_toString(PyObject *self, PyObject *args=0)
{
   _Product *me = (_Product*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid product element");
      return NULL;
   }
   std::string str(me->elem->toString());
   return PyUnicode_FromString(str.c_str());
}

static PyObject*
_Product_toXML(PyObject *self, PyObject *args=0)
{
   _Product *me = (_Product*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid product element");
      return NULL;
   }
   std::string str(me->elem->toXML());
   return PyUnicode_FromString(str.c_str());
}

static PyGetSetDef _Product_getsetters[] = {
   {(char*)"Ebeam",
    (getter)_Product_getEbeam, 0,
    (char*)"Ebeam value",
    NULL},
   {(char*)"Eunit",
    (getter)_Product_getEunit, 0,
    (char*)"Eunit string",
    NULL},
   {(char*)"class",
    (getter)_Product_getClass, 0,
    (char*)"class string",
    NULL},
   {(char*)"eventNo",
    (getter)_Product_getEventNo, 0,
    (char*)"eventNo value",
    NULL},
   {(char*)"id",
    (getter)_Product_getId, (setter)_Product_setId,
    (char*)"id value",
    NULL},
   {(char*)"jtag",
    (getter)_Product_getJtag, 0,
    (char*)"jtag string",
    NULL},
   {(char*)"maxOccurs",
    (getter)_Product_getMaxOccurs, 0,
    (char*)"maxOccurs value",
    NULL},
   {(char*)"minOccurs",
    (getter)_Product_getMinOccurs, 0,
    (char*)"minOccurs value",
    NULL},
   {(char*)"parentId",
    (getter)_Product_getParentId, (setter)_Product_setParentId,
    (char*)"parentId value",
    NULL},
   {(char*)"pdgtype",
    (getter)_Product_getPdgtype, (setter)_Product_setPdgtype,
    (char*)"pdgtype value",
    NULL},
   {(char*)"runNo",
    (getter)_Product_getRunNo, 0,
    (char*)"runNo value",
    NULL},
   {(char*)"targetType",
    (getter)_Product_getTargetType, 0,
    (char*)"targetType value",
    NULL},
   {(char*)"type",
    (getter)_Product_getType, 0,
    (char*)"type value",
    NULL},
   {(char*)"version",
    (getter)_Product_getVersion, 0,
    (char*)"version string",
    NULL},
   {(char*)"weight",
    (getter)_Product_getWeight, 0,
    (char*)"weight value",
    NULL},
   {(char*)"xmlns",
    (getter)_Product_getXmlns, 0,
    (char*)"xmlns string",
    NULL},
   {NULL}  /* Sentinel */
};

static PyMemberDef _Product_members[] = {
   {NULL}  /* Sentinel */
};

static PyMethodDef _Product_methods[] = {
   {"addMomenta", _Product_addMomenta, METH_VARARGS,
    "extend (or insert into) the list of momentum objects for this product"},
   {"deleteMomenta", _Product_deleteMomenta, METH_VARARGS,
    "delete momentum objects for this product"},
   {"getMomenta", _Product_getMomenta, METH_NOARGS,
    "get list of momentum objects for this product"},
   {"getMomentum", _Product_getMomentum, METH_VARARGS,
    "get an individual momentum object from this product"},
   {"toString", _Product_toString, METH_NOARGS,
    "show element as a human-readable string"},
   {"toXML", _Product_toXML, METH_NOARGS,
    "show element as a XML fragment"},
   {NULL}  /* Sentinel */
};

static PyTypeObject _Product_type = {
    PyVarObject_HEAD_INIT(NULL,0)
    "hddm_r.Product",         /*tp_name*/
    sizeof(_Product),          /*tp_basicsize*/
    0,                         /*tp_itemsize*/
    (destructor)_Product_dealloc, /*tp_dealloc*/
    0,                         /*tp_print*/
    0,                         /*tp_getattr*/
    0,                         /*tp_setattr*/
    0,                         /*tp_compare*/
    0,                         /*tp_repr*/
    0,                         /*tp_as_number*/
    0,                         /*tp_as_sequence*/
    0,                         /*tp_as_mapping*/
    0,                         /*tp_hash */
    0,                         /*tp_call*/
    (reprfunc)_Product_toString,         /*tp_str*/
    0,                         /*tp_getattro*/
    0,                         /*tp_setattro*/
    0,                         /*tp_as_buffer*/
    Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE, /*tp_flags*/
    "hddm_r product element",  /* tp_doc */
    0,                         /* tp_traverse */
    0,                         /* tp_clear */
    0,                         /* tp_richcompare */
    0,                         /* tp_weaklistoffset */
    0,                         /* tp_iter */
    0,                         /* tp_iternext */
    _Product_methods,          /* tp_methods */
    _Product_members,          /* tp_members */
    _Product_getsetters,       /* tp_getset */
    &_HDDM_Element_type,       /* tp_base */
    0,                         /* tp_dict */
    0,                         /* tp_descr_get */
    0,                         /* tp_descr_set */
    0,                         /* tp_dictoffset */
    (initproc)_Product_init,   /* tp_init */
    0,                         /* tp_alloc */
    _Product_new,              /* tp_new */
};



// wrap element class hddm_r::Vertex as hddm_r.Vertex

typedef struct {
   PyObject_HEAD
   Vertex *elem;
   PyObject *host;
} _Vertex;

static void
_Vertex_dealloc(_Vertex* self)
{
   if (self->elem != 0) {
      LOG_DEALLOC(Py_TYPE(self), 0, self->host == (PyObject*)self);
      if (self->host == (PyObject*)self)
         delete self->elem;
      else
         My_DECREF(self->host);
   }
   Py_TYPE(self)->tp_free((PyObject*)self);
}

static PyObject*
_Vertex_new(PyTypeObject *type, PyObject *args, PyObject *kwds)
{
   _Vertex *self;
   self = (_Vertex*)type->tp_alloc(type, 0);
   if (self != NULL) {
      self->elem = 0;
      self->host = 0;
   }
   return (PyObject*)self;
}

static int
_Vertex_init(_Vertex *self, PyObject *args, PyObject *kwds)
{
   PyErr_SetString(PyExc_RuntimeError, "illegal constructor");
   return -1;
}

static PyObject*
_Vertex_getClass(_Vertex *self, void *closure)
{
   std::string val(self->elem->getClass());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_Vertex_getVersion(_Vertex *self, void *closure)
{
   std::string val(self->elem->getVersion());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_Vertex_getXmlns(_Vertex *self, void *closure)
{
   std::string val(self->elem->getXmlns());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_Vertex_getEventNo(_Vertex *self, void *closure)
{
   return PyLong_FromLongLong(self->elem->getEventNo());
}

static PyObject*
_Vertex_getRunNo(_Vertex *self, void *closure)
{
   return PyLong_FromLong(self->elem->getRunNo());
}

static PyObject*
_Vertex_getEbeam(_Vertex *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getEbeam());
}

static PyObject*
_Vertex_getEunit(_Vertex *self, void *closure)
{
   std::string val(self->elem->getEunit());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_Vertex_getJtag(_Vertex *self, void *closure)
{
   std::string val(self->elem->getJtag());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_Vertex_getMinOccurs(_Vertex *self, void *closure)
{
   return PyLong_FromLong(self->elem->getMinOccurs());
}

static PyObject*
_Vertex_getTargetType(_Vertex *self, void *closure)
{
   Particle_t p(self->elem->getTargetType());
   std::string val(ParticleType(p));
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_Vertex_getType(_Vertex *self, void *closure)
{
   return PyLong_FromLong(self->elem->getType());
}

static PyObject*
_Vertex_getWeight(_Vertex *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getWeight());
}

static PyObject*
_Vertex_getMaxOccurs(_Vertex *self, void *closure)
{
   std::string val(self->elem->getMaxOccurs());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_Vertex_getOrigin(PyObject *self, PyObject *args)
{
   int index=0;
   if (! PyArg_ParseTuple(args, "|i", &index)) {
      return NULL;
   }
   _Vertex *me = (_Vertex*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid vertex element");
      return NULL;
   }
   PyObject *obj = _Origin_new(&_Origin_type, 0, 0);
   ((_Origin*)obj)->elem = &me->elem->getOrigin();
   ((_Origin*)obj)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(obj));
   return obj;
}

static PyObject*
_Vertex_getOrigins(PyObject *self, PyObject *args)
{
   _Vertex *me = (_Vertex*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid vertex element");
      return NULL;
   }
   PyObject *list = _HDDM_ElementList_new(&_HDDM_ElementList_type, 0, 0);
   ((_HDDM_ElementList*)list)->subtype = &_Origin_type;
   ((_HDDM_ElementList*)list)->list = (HDDM_ElementList<HDDM_Element>*)
    &me->elem->getOrigins();
   ((_HDDM_ElementList*)list)->borrowed = 1;
   ((_HDDM_ElementList*)list)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(list), ((_HDDM_ElementList*)list)->subtype, 0);
   return list;
}

static PyObject*
_Vertex_addOrigins(PyObject *self, PyObject *args)
{
   int count=1;
   int start=-1;
   if (! PyArg_ParseTuple(args, "|ii", &count, &start)) {
      return NULL;
   }
   _Vertex *me = (_Vertex*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "add attempted on invalid vertex element");
      return NULL;
   }
   PyObject *list = _HDDM_ElementList_new(&_HDDM_ElementList_type, 0, 0);
   ((_HDDM_ElementList*)list)->subtype = &_Origin_type;
   ((_HDDM_ElementList*)list)->list = (HDDM_ElementList<HDDM_Element>*)
    new OriginList(me->elem->addOrigins(count, start));
   ((_HDDM_ElementList*)list)->borrowed = 0;
   ((_HDDM_ElementList*)list)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(list), ((_HDDM_ElementList*)list)->subtype, 1);
   return list;
}

static PyObject*
_Vertex_deleteOrigins(PyObject *self, PyObject *args)
{
   int count=-1;
   int start=0;
   if (! PyArg_ParseTuple(args, "|ii", &count, &start)) {
      return NULL;
   }
   _Vertex *me = (_Vertex*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "delete attempted on invalid vertex element");
      return NULL;
   }
   me->elem->deleteOrigins(count, start);
   Py_INCREF(Py_None);
   return Py_None;
}

static PyObject*
_Vertex_getProduct(PyObject *self, PyObject *args)
{
   int index=0;
   if (! PyArg_ParseTuple(args, "|i", &index)) {
      return NULL;
   }
   _Vertex *me = (_Vertex*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid vertex element");
      return NULL;
   }
   PyObject *obj = _Product_new(&_Product_type, 0, 0);
   ((_Product*)obj)->elem = &me->elem->getProduct(index);
   ((_Product*)obj)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(obj));
   return obj;
}

static PyObject*
_Vertex_getProducts(PyObject *self, PyObject *args)
{
   _Vertex *me = (_Vertex*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid vertex element");
      return NULL;
   }
   PyObject *list = _HDDM_ElementList_new(&_HDDM_ElementList_type, 0, 0);
   ((_HDDM_ElementList*)list)->subtype = &_Product_type;
   ((_HDDM_ElementList*)list)->list = (HDDM_ElementList<HDDM_Element>*)
    &me->elem->getProducts();
   ((_HDDM_ElementList*)list)->borrowed = 1;
   ((_HDDM_ElementList*)list)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(list), ((_HDDM_ElementList*)list)->subtype, 0);
   return list;
}

static PyObject*
_Vertex_addProducts(PyObject *self, PyObject *args)
{
   int count=1;
   int start=-1;
   if (! PyArg_ParseTuple(args, "|ii", &count, &start)) {
      return NULL;
   }
   _Vertex *me = (_Vertex*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "add attempted on invalid vertex element");
      return NULL;
   }
   PyObject *list = _HDDM_ElementList_new(&_HDDM_ElementList_type, 0, 0);
   ((_HDDM_ElementList*)list)->subtype = &_Product_type;
   ((_HDDM_ElementList*)list)->list = (HDDM_ElementList<HDDM_Element>*)
    new ProductList(me->elem->addProducts(count, start));
   ((_HDDM_ElementList*)list)->borrowed = 0;
   ((_HDDM_ElementList*)list)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(list), ((_HDDM_ElementList*)list)->subtype, 1);
   return list;
}

static PyObject*
_Vertex_deleteProducts(PyObject *self, PyObject *args)
{
   int count=-1;
   int start=0;
   if (! PyArg_ParseTuple(args, "|ii", &count, &start)) {
      return NULL;
   }
   _Vertex *me = (_Vertex*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "delete attempted on invalid vertex element");
      return NULL;
   }
   me->elem->deleteProducts(count, start);
   Py_INCREF(Py_None);
   return Py_None;
}

static PyObject*
_Vertex_toString(PyObject *self, PyObject *args=0)
{
   _Vertex *me = (_Vertex*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid vertex element");
      return NULL;
   }
   std::string str(me->elem->toString());
   return PyUnicode_FromString(str.c_str());
}

static PyObject*
_Vertex_toXML(PyObject *self, PyObject *args=0)
{
   _Vertex *me = (_Vertex*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid vertex element");
      return NULL;
   }
   std::string str(me->elem->toXML());
   return PyUnicode_FromString(str.c_str());
}

static PyGetSetDef _Vertex_getsetters[] = {
   {(char*)"Ebeam",
    (getter)_Vertex_getEbeam, 0,
    (char*)"Ebeam value",
    NULL},
   {(char*)"Eunit",
    (getter)_Vertex_getEunit, 0,
    (char*)"Eunit string",
    NULL},
   {(char*)"class",
    (getter)_Vertex_getClass, 0,
    (char*)"class string",
    NULL},
   {(char*)"eventNo",
    (getter)_Vertex_getEventNo, 0,
    (char*)"eventNo value",
    NULL},
   {(char*)"jtag",
    (getter)_Vertex_getJtag, 0,
    (char*)"jtag string",
    NULL},
   {(char*)"maxOccurs",
    (getter)_Vertex_getMaxOccurs, 0,
    (char*)"maxOccurs value",
    NULL},
   {(char*)"minOccurs",
    (getter)_Vertex_getMinOccurs, 0,
    (char*)"minOccurs value",
    NULL},
   {(char*)"runNo",
    (getter)_Vertex_getRunNo, 0,
    (char*)"runNo value",
    NULL},
   {(char*)"targetType",
    (getter)_Vertex_getTargetType, 0,
    (char*)"targetType value",
    NULL},
   {(char*)"type",
    (getter)_Vertex_getType, 0,
    (char*)"type value",
    NULL},
   {(char*)"version",
    (getter)_Vertex_getVersion, 0,
    (char*)"version string",
    NULL},
   {(char*)"weight",
    (getter)_Vertex_getWeight, 0,
    (char*)"weight value",
    NULL},
   {(char*)"xmlns",
    (getter)_Vertex_getXmlns, 0,
    (char*)"xmlns string",
    NULL},
   {NULL}  /* Sentinel */
};

static PyMemberDef _Vertex_members[] = {
   {NULL}  /* Sentinel */
};

static PyMethodDef _Vertex_methods[] = {
   {"addOrigins", _Vertex_addOrigins, METH_VARARGS,
    "extend (or insert into) the list of origin objects for this vertex"},
   {"addProducts", _Vertex_addProducts, METH_VARARGS,
    "extend (or insert into) the list of product objects for this vertex"},
   {"deleteOrigins", _Vertex_deleteOrigins, METH_VARARGS,
    "delete origin objects for this vertex"},
   {"deleteProducts", _Vertex_deleteProducts, METH_VARARGS,
    "delete product objects for this vertex"},
   {"getOrigin", _Vertex_getOrigin, METH_VARARGS,
    "get an individual origin object from this vertex"},
   {"getOrigins", _Vertex_getOrigins, METH_NOARGS,
    "get list of origin objects for this vertex"},
   {"getProduct", _Vertex_getProduct, METH_VARARGS,
    "get an individual product object from this vertex"},
   {"getProducts", _Vertex_getProducts, METH_NOARGS,
    "get list of product objects for this vertex"},
   {"toString", _Vertex_toString, METH_NOARGS,
    "show element as a human-readable string"},
   {"toXML", _Vertex_toXML, METH_NOARGS,
    "show element as a XML fragment"},
   {NULL}  /* Sentinel */
};

static PyTypeObject _Vertex_type = {
    PyVarObject_HEAD_INIT(NULL,0)
    "hddm_r.Vertex",         /*tp_name*/
    sizeof(_Vertex),          /*tp_basicsize*/
    0,                         /*tp_itemsize*/
    (destructor)_Vertex_dealloc, /*tp_dealloc*/
    0,                         /*tp_print*/
    0,                         /*tp_getattr*/
    0,                         /*tp_setattr*/
    0,                         /*tp_compare*/
    0,                         /*tp_repr*/
    0,                         /*tp_as_number*/
    0,                         /*tp_as_sequence*/
    0,                         /*tp_as_mapping*/
    0,                         /*tp_hash */
    0,                         /*tp_call*/
    (reprfunc)_Vertex_toString,         /*tp_str*/
    0,                         /*tp_getattro*/
    0,                         /*tp_setattro*/
    0,                         /*tp_as_buffer*/
    Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE, /*tp_flags*/
    "hddm_r vertex element",  /* tp_doc */
    0,                         /* tp_traverse */
    0,                         /* tp_clear */
    0,                         /* tp_richcompare */
    0,                         /* tp_weaklistoffset */
    0,                         /* tp_iter */
    0,                         /* tp_iternext */
    _Vertex_methods,          /* tp_methods */
    _Vertex_members,          /* tp_members */
    _Vertex_getsetters,       /* tp_getset */
    &_HDDM_Element_type,       /* tp_base */
    0,                         /* tp_dict */
    0,                         /* tp_descr_get */
    0,                         /* tp_descr_set */
    0,                         /* tp_dictoffset */
    (initproc)_Vertex_init,   /* tp_init */
    0,                         /* tp_alloc */
    _Vertex_new,              /* tp_new */
};



// wrap element class hddm_r::Reaction as hddm_r.Reaction

typedef struct {
   PyObject_HEAD
   Reaction *elem;
   PyObject *host;
} _Reaction;

static void
_Reaction_dealloc(_Reaction* self)
{
   if (self->elem != 0) {
      LOG_DEALLOC(Py_TYPE(self), 0, self->host == (PyObject*)self);
      if (self->host == (PyObject*)self)
         delete self->elem;
      else
         My_DECREF(self->host);
   }
   Py_TYPE(self)->tp_free((PyObject*)self);
}

static PyObject*
_Reaction_new(PyTypeObject *type, PyObject *args, PyObject *kwds)
{
   _Reaction *self;
   self = (_Reaction*)type->tp_alloc(type, 0);
   if (self != NULL) {
      self->elem = 0;
      self->host = 0;
   }
   return (PyObject*)self;
}

static int
_Reaction_init(_Reaction *self, PyObject *args, PyObject *kwds)
{
   PyErr_SetString(PyExc_RuntimeError, "illegal constructor");
   return -1;
}

static PyObject*
_Reaction_getClass(_Reaction *self, void *closure)
{
   std::string val(self->elem->getClass());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_Reaction_getVersion(_Reaction *self, void *closure)
{
   std::string val(self->elem->getVersion());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_Reaction_getXmlns(_Reaction *self, void *closure)
{
   std::string val(self->elem->getXmlns());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_Reaction_getEventNo(_Reaction *self, void *closure)
{
   return PyLong_FromLongLong(self->elem->getEventNo());
}

static PyObject*
_Reaction_getRunNo(_Reaction *self, void *closure)
{
   return PyLong_FromLong(self->elem->getRunNo());
}

static PyObject*
_Reaction_getEbeam(_Reaction *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getEbeam());
}

static int
_Reaction_setEbeam(_Reaction *self, PyObject *value, void *closure)
{
   double var = PyFloat_AsDouble(value);
   if (var == -1 && PyErr_Occurred()) {
      return 1;
   }
   self->elem->setEbeam((float)var);
   return 0;
}

static PyObject*
_Reaction_getEunit(_Reaction *self, void *closure)
{
   std::string val(self->elem->getEunit());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_Reaction_getJtag(_Reaction *self, void *closure)
{
   std::string val(self->elem->getJtag());
   return PyUnicode_FromString(val.c_str());
}

static int
_Reaction_setJtag(_Reaction *self, PyObject *value, void *closure)
{
   PyObject *str=0;
   if (PyUnicode_Check(value))
      str = PyUnicode_AsEncodedString(value, "ASCII", "strict");
   else
      str = value;
#if PY_MAJOR_VERSION < 3
   char *var = PyString_AsString(str);
#else
   char *var = PyBytes_AsString(str);
#endif
   if (var == 0) {
      return -1;
   }
   self->elem->setJtag(std::string(var));
   if (str != value) {
      Py_DECREF(str);
   }
   return 0;
}

static PyObject*
_Reaction_getMaxOccurs(_Reaction *self, void *closure)
{
   std::string val(self->elem->getMaxOccurs());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_Reaction_getMinOccurs(_Reaction *self, void *closure)
{
   return PyLong_FromLong(self->elem->getMinOccurs());
}

static PyObject*
_Reaction_getTargetType(_Reaction *self, void *closure)
{
   Particle_t p(self->elem->getTargetType());
   std::string val(ParticleType(p));
   return PyUnicode_FromString(val.c_str());
}

static int
_Reaction_setTargetType(_Reaction *self, PyObject *value, void *closure)
{
   long var = PyInt_AsLong(value);
   if (var == -1 && PyErr_Occurred()) {
      return -1;
   }
   self->elem->setTargetType((Particle_t)var);
   return 0;
}

static PyObject*
_Reaction_getType(_Reaction *self, void *closure)
{
   return PyLong_FromLong(self->elem->getType());
}

static int
_Reaction_setType(_Reaction *self, PyObject *value, void *closure)
{
   long var = PyInt_AsLong(value);
   if (var == -1 && PyErr_Occurred()) {
      return -1;
   }
   self->elem->setType(var);
   return 0;
}

static PyObject*
_Reaction_getWeight(_Reaction *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getWeight());
}

static int
_Reaction_setWeight(_Reaction *self, PyObject *value, void *closure)
{
   double var = PyFloat_AsDouble(value);
   if (var == -1 && PyErr_Occurred()) {
      return 1;
   }
   self->elem->setWeight((float)var);
   return 0;
}

static PyObject*
_Reaction_getVertex(PyObject *self, PyObject *args)
{
   int index=0;
   if (! PyArg_ParseTuple(args, "|i", &index)) {
      return NULL;
   }
   _Reaction *me = (_Reaction*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid reaction element");
      return NULL;
   }
   PyObject *obj = _Vertex_new(&_Vertex_type, 0, 0);
   ((_Vertex*)obj)->elem = &me->elem->getVertex(index);
   ((_Vertex*)obj)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(obj));
   return obj;
}

static PyObject*
_Reaction_getVertices(PyObject *self, PyObject *args)
{
   _Reaction *me = (_Reaction*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid reaction element");
      return NULL;
   }
   PyObject *list = _HDDM_ElementList_new(&_HDDM_ElementList_type, 0, 0);
   ((_HDDM_ElementList*)list)->subtype = &_Vertex_type;
   ((_HDDM_ElementList*)list)->list = (HDDM_ElementList<HDDM_Element>*)
    &me->elem->getVertices();
   ((_HDDM_ElementList*)list)->borrowed = 1;
   ((_HDDM_ElementList*)list)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(list), ((_HDDM_ElementList*)list)->subtype, 0);
   return list;
}

static PyObject*
_Reaction_addVertices(PyObject *self, PyObject *args)
{
   int count=1;
   int start=-1;
   if (! PyArg_ParseTuple(args, "|ii", &count, &start)) {
      return NULL;
   }
   _Reaction *me = (_Reaction*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "add attempted on invalid reaction element");
      return NULL;
   }
   PyObject *list = _HDDM_ElementList_new(&_HDDM_ElementList_type, 0, 0);
   ((_HDDM_ElementList*)list)->subtype = &_Vertex_type;
   ((_HDDM_ElementList*)list)->list = (HDDM_ElementList<HDDM_Element>*)
    new VertexList(me->elem->addVertices(count, start));
   ((_HDDM_ElementList*)list)->borrowed = 0;
   ((_HDDM_ElementList*)list)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(list), ((_HDDM_ElementList*)list)->subtype, 1);
   return list;
}

static PyObject*
_Reaction_deleteVertices(PyObject *self, PyObject *args)
{
   int count=-1;
   int start=0;
   if (! PyArg_ParseTuple(args, "|ii", &count, &start)) {
      return NULL;
   }
   _Reaction *me = (_Reaction*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "delete attempted on invalid reaction element");
      return NULL;
   }
   me->elem->deleteVertices(count, start);
   Py_INCREF(Py_None);
   return Py_None;
}

static PyObject*
_Reaction_toString(PyObject *self, PyObject *args=0)
{
   _Reaction *me = (_Reaction*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid reaction element");
      return NULL;
   }
   std::string str(me->elem->toString());
   return PyUnicode_FromString(str.c_str());
}

static PyObject*
_Reaction_toXML(PyObject *self, PyObject *args=0)
{
   _Reaction *me = (_Reaction*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid reaction element");
      return NULL;
   }
   std::string str(me->elem->toXML());
   return PyUnicode_FromString(str.c_str());
}

static PyGetSetDef _Reaction_getsetters[] = {
   {(char*)"Ebeam",
    (getter)_Reaction_getEbeam, (setter)_Reaction_setEbeam,
    (char*)"Ebeam value",
    NULL},
   {(char*)"Eunit",
    (getter)_Reaction_getEunit, 0,
    (char*)"Eunit value",
    NULL},
   {(char*)"class",
    (getter)_Reaction_getClass, 0,
    (char*)"class string",
    NULL},
   {(char*)"eventNo",
    (getter)_Reaction_getEventNo, 0,
    (char*)"eventNo value",
    NULL},
   {(char*)"jtag",
    (getter)_Reaction_getJtag, (setter)_Reaction_setJtag,
    (char*)"jtag string",
    NULL},
   {(char*)"maxOccurs",
    (getter)_Reaction_getMaxOccurs, 0,
    (char*)"maxOccurs value",
    NULL},
   {(char*)"minOccurs",
    (getter)_Reaction_getMinOccurs, 0,
    (char*)"minOccurs value",
    NULL},
   {(char*)"runNo",
    (getter)_Reaction_getRunNo, 0,
    (char*)"runNo value",
    NULL},
   {(char*)"targetType",
    (getter)_Reaction_getTargetType, (setter)_Reaction_setTargetType,
    (char*)"targetType value",
    NULL},
   {(char*)"type",
    (getter)_Reaction_getType, (setter)_Reaction_setType,
    (char*)"type value",
    NULL},
   {(char*)"version",
    (getter)_Reaction_getVersion, 0,
    (char*)"version string",
    NULL},
   {(char*)"weight",
    (getter)_Reaction_getWeight, (setter)_Reaction_setWeight,
    (char*)"weight value",
    NULL},
   {(char*)"xmlns",
    (getter)_Reaction_getXmlns, 0,
    (char*)"xmlns string",
    NULL},
   {NULL}  /* Sentinel */
};

static PyMemberDef _Reaction_members[] = {
   {NULL}  /* Sentinel */
};

static PyMethodDef _Reaction_methods[] = {
   {"addVertices", _Reaction_addVertices, METH_VARARGS,
    "extend (or insert into) the list of vertex objects for this reaction"},
   {"deleteVertices", _Reaction_deleteVertices, METH_VARARGS,
    "delete vertex objects for this reaction"},
   {"getVertex", _Reaction_getVertex, METH_VARARGS,
    "get an individual vertex object from this reaction"},
   {"getVertices", _Reaction_getVertices, METH_NOARGS,
    "get list of vertex objects for this reaction"},
   {"toString", _Reaction_toString, METH_NOARGS,
    "show element as a human-readable string"},
   {"toXML", _Reaction_toXML, METH_NOARGS,
    "show element as a XML fragment"},
   {NULL}  /* Sentinel */
};

static PyTypeObject _Reaction_type = {
    PyVarObject_HEAD_INIT(NULL,0)
    "hddm_r.Reaction",         /*tp_name*/
    sizeof(_Reaction),          /*tp_basicsize*/
    0,                         /*tp_itemsize*/
    (destructor)_Reaction_dealloc, /*tp_dealloc*/
    0,                         /*tp_print*/
    0,                         /*tp_getattr*/
    0,                         /*tp_setattr*/
    0,                         /*tp_compare*/
    0,                         /*tp_repr*/
    0,                         /*tp_as_number*/
    0,                         /*tp_as_sequence*/
    0,                         /*tp_as_mapping*/
    0,                         /*tp_hash */
    0,                         /*tp_call*/
    (reprfunc)_Reaction_toString,         /*tp_str*/
    0,                         /*tp_getattro*/
    0,                         /*tp_setattro*/
    0,                         /*tp_as_buffer*/
    Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE, /*tp_flags*/
    "hddm_r reaction element",  /* tp_doc */
    0,                         /* tp_traverse */
    0,                         /* tp_clear */
    0,                         /* tp_richcompare */
    0,                         /* tp_weaklistoffset */
    0,                         /* tp_iter */
    0,                         /* tp_iternext */
    _Reaction_methods,          /* tp_methods */
    _Reaction_members,          /* tp_members */
    _Reaction_getsetters,       /* tp_getset */
    &_HDDM_Element_type,       /* tp_base */
    0,                         /* tp_dict */
    0,                         /* tp_descr_get */
    0,                         /* tp_descr_set */
    0,                         /* tp_dictoffset */
    (initproc)_Reaction_init,   /* tp_init */
    0,                         /* tp_alloc */
    _Reaction_new,              /* tp_new */
};



// wrap element class hddm_r::TagmChannel as hddm_r.TagmChannel

typedef struct {
   PyObject_HEAD
   TagmChannel *elem;
   PyObject *host;
} _TagmChannel;

static void
_TagmChannel_dealloc(_TagmChannel* self)
{
   if (self->elem != 0) {
      LOG_DEALLOC(Py_TYPE(self), 0, self->host == (PyObject*)self);
      if (self->host == (PyObject*)self)
         delete self->elem;
      else
         My_DECREF(self->host);
   }
   Py_TYPE(self)->tp_free((PyObject*)self);
}

static PyObject*
_TagmChannel_new(PyTypeObject *type, PyObject *args, PyObject *kwds)
{
   _TagmChannel *self;
   self = (_TagmChannel*)type->tp_alloc(type, 0);
   if (self != NULL) {
      self->elem = 0;
      self->host = 0;
   }
   return (PyObject*)self;
}

static int
_TagmChannel_init(_TagmChannel *self, PyObject *args, PyObject *kwds)
{
   PyErr_SetString(PyExc_RuntimeError, "illegal constructor");
   return -1;
}

static PyObject*
_TagmChannel_getClass(_TagmChannel *self, void *closure)
{
   std::string val(self->elem->getClass());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_TagmChannel_getVersion(_TagmChannel *self, void *closure)
{
   std::string val(self->elem->getVersion());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_TagmChannel_getXmlns(_TagmChannel *self, void *closure)
{
   std::string val(self->elem->getXmlns());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_TagmChannel_getEventNo(_TagmChannel *self, void *closure)
{
   return PyLong_FromLongLong(self->elem->getEventNo());
}

static PyObject*
_TagmChannel_getRunNo(_TagmChannel *self, void *closure)
{
   return PyLong_FromLong(self->elem->getRunNo());
}

static PyObject*
_TagmChannel_getE(_TagmChannel *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getE());
}

static PyObject*
_TagmChannel_getEunit(_TagmChannel *self, void *closure)
{
   std::string val(self->elem->getEunit());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_TagmChannel_getJtag(_TagmChannel *self, void *closure)
{
   std::string val(self->elem->getJtag());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_TagmChannel_getMaxOccurs(_TagmChannel *self, void *closure)
{
   std::string val(self->elem->getMaxOccurs());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_TagmChannel_getT(_TagmChannel *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getT());
}

static PyObject*
_TagmChannel_getTunit(_TagmChannel *self, void *closure)
{
   std::string val(self->elem->getTunit());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_TagmChannel_getColumn(_TagmChannel *self, void *closure)
{
   return PyLong_FromLong(self->elem->getColumn());
}

static int
_TagmChannel_setColumn(_TagmChannel *self, PyObject *value, void *closure)
{
   long var = PyInt_AsLong(value);
   if (var == -1 && PyErr_Occurred()) {
      return -1;
   }
   self->elem->setColumn(var);
   return 0;
}

static PyObject*
_TagmChannel_getMinOccurs(_TagmChannel *self, void *closure)
{
   return PyLong_FromLong(self->elem->getMinOccurs());
}

static PyObject*
_TagmChannel_toString(PyObject *self, PyObject *args=0)
{
   _TagmChannel *me = (_TagmChannel*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid tagmChannel element");
      return NULL;
   }
   std::string str(me->elem->toString());
   return PyUnicode_FromString(str.c_str());
}

static PyObject*
_TagmChannel_toXML(PyObject *self, PyObject *args=0)
{
   _TagmChannel *me = (_TagmChannel*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid tagmChannel element");
      return NULL;
   }
   std::string str(me->elem->toXML());
   return PyUnicode_FromString(str.c_str());
}

static PyGetSetDef _TagmChannel_getsetters[] = {
   {(char*)"E",
    (getter)_TagmChannel_getE, 0,
    (char*)"E value",
    NULL},
   {(char*)"Eunit",
    (getter)_TagmChannel_getEunit, 0,
    (char*)"Eunit string",
    NULL},
   {(char*)"class",
    (getter)_TagmChannel_getClass, 0,
    (char*)"class string",
    NULL},
   {(char*)"column",
    (getter)_TagmChannel_getColumn, (setter)_TagmChannel_setColumn,
    (char*)"column value",
    NULL},
   {(char*)"eventNo",
    (getter)_TagmChannel_getEventNo, 0,
    (char*)"eventNo value",
    NULL},
   {(char*)"jtag",
    (getter)_TagmChannel_getJtag, 0,
    (char*)"jtag string",
    NULL},
   {(char*)"maxOccurs",
    (getter)_TagmChannel_getMaxOccurs, 0,
    (char*)"maxOccurs string",
    NULL},
   {(char*)"minOccurs",
    (getter)_TagmChannel_getMinOccurs, 0,
    (char*)"minOccurs value",
    NULL},
   {(char*)"runNo",
    (getter)_TagmChannel_getRunNo, 0,
    (char*)"runNo value",
    NULL},
   {(char*)"t",
    (getter)_TagmChannel_getT, 0,
    (char*)"t value",
    NULL},
   {(char*)"tunit",
    (getter)_TagmChannel_getTunit, 0,
    (char*)"tunit string",
    NULL},
   {(char*)"version",
    (getter)_TagmChannel_getVersion, 0,
    (char*)"version string",
    NULL},
   {(char*)"xmlns",
    (getter)_TagmChannel_getXmlns, 0,
    (char*)"xmlns string",
    NULL},
   {NULL}  /* Sentinel */
};

static PyMemberDef _TagmChannel_members[] = {
   {NULL}  /* Sentinel */
};

static PyMethodDef _TagmChannel_methods[] = {
   {"toString", _TagmChannel_toString, METH_NOARGS,
    "show element as a human-readable string"},
   {"toXML", _TagmChannel_toXML, METH_NOARGS,
    "show element as a XML fragment"},
   {NULL}  /* Sentinel */
};

static PyTypeObject _TagmChannel_type = {
    PyVarObject_HEAD_INIT(NULL,0)
    "hddm_r.TagmChannel",         /*tp_name*/
    sizeof(_TagmChannel),          /*tp_basicsize*/
    0,                         /*tp_itemsize*/
    (destructor)_TagmChannel_dealloc, /*tp_dealloc*/
    0,                         /*tp_print*/
    0,                         /*tp_getattr*/
    0,                         /*tp_setattr*/
    0,                         /*tp_compare*/
    0,                         /*tp_repr*/
    0,                         /*tp_as_number*/
    0,                         /*tp_as_sequence*/
    0,                         /*tp_as_mapping*/
    0,                         /*tp_hash */
    0,                         /*tp_call*/
    (reprfunc)_TagmChannel_toString,         /*tp_str*/
    0,                         /*tp_getattro*/
    0,                         /*tp_setattro*/
    0,                         /*tp_as_buffer*/
    Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE, /*tp_flags*/
    "hddm_r tagmChannel element",  /* tp_doc */
    0,                         /* tp_traverse */
    0,                         /* tp_clear */
    0,                         /* tp_richcompare */
    0,                         /* tp_weaklistoffset */
    0,                         /* tp_iter */
    0,                         /* tp_iternext */
    _TagmChannel_methods,          /* tp_methods */
    _TagmChannel_members,          /* tp_members */
    _TagmChannel_getsetters,       /* tp_getset */
    &_HDDM_Element_type,       /* tp_base */
    0,                         /* tp_dict */
    0,                         /* tp_descr_get */
    0,                         /* tp_descr_set */
    0,                         /* tp_dictoffset */
    (initproc)_TagmChannel_init,   /* tp_init */
    0,                         /* tp_alloc */
    _TagmChannel_new,              /* tp_new */
};



// wrap element class hddm_r::TagmBeamPhoton as hddm_r.TagmBeamPhoton

typedef struct {
   PyObject_HEAD
   TagmBeamPhoton *elem;
   PyObject *host;
} _TagmBeamPhoton;

static void
_TagmBeamPhoton_dealloc(_TagmBeamPhoton* self)
{
   if (self->elem != 0) {
      LOG_DEALLOC(Py_TYPE(self), 0, self->host == (PyObject*)self);
      if (self->host == (PyObject*)self)
         delete self->elem;
      else
         My_DECREF(self->host);
   }
   Py_TYPE(self)->tp_free((PyObject*)self);
}

static PyObject*
_TagmBeamPhoton_new(PyTypeObject *type, PyObject *args, PyObject *kwds)
{
   _TagmBeamPhoton *self;
   self = (_TagmBeamPhoton*)type->tp_alloc(type, 0);
   if (self != NULL) {
      self->elem = 0;
      self->host = 0;
   }
   return (PyObject*)self;
}

static int
_TagmBeamPhoton_init(_TagmBeamPhoton *self, PyObject *args, PyObject *kwds)
{
   PyErr_SetString(PyExc_RuntimeError, "illegal constructor");
   return -1;
}

static PyObject*
_TagmBeamPhoton_getClass(_TagmBeamPhoton *self, void *closure)
{
   std::string val(self->elem->getClass());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_TagmBeamPhoton_getVersion(_TagmBeamPhoton *self, void *closure)
{
   std::string val(self->elem->getVersion());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_TagmBeamPhoton_getXmlns(_TagmBeamPhoton *self, void *closure)
{
   std::string val(self->elem->getXmlns());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_TagmBeamPhoton_getEventNo(_TagmBeamPhoton *self, void *closure)
{
   return PyLong_FromLongLong(self->elem->getEventNo());
}

static PyObject*
_TagmBeamPhoton_getRunNo(_TagmBeamPhoton *self, void *closure)
{
   return PyLong_FromLong(self->elem->getRunNo());
}

static PyObject*
_TagmBeamPhoton_getE(_TagmBeamPhoton *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getE());
}

static int
_TagmBeamPhoton_setE(_TagmBeamPhoton *self, PyObject *value, void *closure)
{
   double var = PyFloat_AsDouble(value);
   if (var == -1 && PyErr_Occurred()) {
      return 1;
   }
   self->elem->setE((float)var);
   return 0;
}

static PyObject*
_TagmBeamPhoton_getEunit(_TagmBeamPhoton *self, void *closure)
{
   std::string val(self->elem->getEunit());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_TagmBeamPhoton_getJtag(_TagmBeamPhoton *self, void *closure)
{
   std::string val(self->elem->getJtag());
   return PyUnicode_FromString(val.c_str());
}

static int
_TagmBeamPhoton_setJtag(_TagmBeamPhoton *self, PyObject *value, void *closure)
{
   PyObject *str=0;
   if (PyUnicode_Check(value))
      str = PyUnicode_AsEncodedString(value, "ASCII", "strict");
   else
      str = value;
#if PY_MAJOR_VERSION < 3
   char *var = PyString_AsString(str);
#else
   char *var = PyBytes_AsString(str);
#endif
   if (var == 0) {
      return -1;
   }
   self->elem->setJtag(std::string(var));
   if (str != value) {
      Py_DECREF(str);
   }
   return 0;
}

static PyObject*
_TagmBeamPhoton_getMaxOccurs(_TagmBeamPhoton *self, void *closure)
{
   std::string val(self->elem->getMaxOccurs());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_TagmBeamPhoton_getMinOccurs(_TagmBeamPhoton *self, void *closure)
{
   return PyLong_FromLong(self->elem->getMinOccurs());
}

static PyObject*
_TagmBeamPhoton_getT(_TagmBeamPhoton *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getT());
}

static int
_TagmBeamPhoton_setT(_TagmBeamPhoton *self, PyObject *value, void *closure)
{
   double var = PyFloat_AsDouble(value);
   if (var == -1 && PyErr_Occurred()) {
      return 1;
   }
   self->elem->setT((float)var);
   return 0;
}

static PyObject*
_TagmBeamPhoton_getTunit(_TagmBeamPhoton *self, void *closure)
{
   std::string val(self->elem->getTunit());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_TagmBeamPhoton_getTagmChannel(PyObject *self, PyObject *args)
{
   int index=0;
   if (! PyArg_ParseTuple(args, "|i", &index)) {
      return NULL;
   }
   _TagmBeamPhoton *me = (_TagmBeamPhoton*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid tagmBeamPhoton element");
      return NULL;
   }
   PyObject *obj = _TagmChannel_new(&_TagmChannel_type, 0, 0);
   ((_TagmChannel*)obj)->elem = &me->elem->getTagmChannel();
   ((_TagmChannel*)obj)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(obj));
   return obj;
}

static PyObject*
_TagmBeamPhoton_getTagmChannels(PyObject *self, PyObject *args)
{
   _TagmBeamPhoton *me = (_TagmBeamPhoton*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid tagmBeamPhoton element");
      return NULL;
   }
   PyObject *list = _HDDM_ElementList_new(&_HDDM_ElementList_type, 0, 0);
   ((_HDDM_ElementList*)list)->subtype = &_TagmChannel_type;
   ((_HDDM_ElementList*)list)->list = (HDDM_ElementList<HDDM_Element>*)
    &me->elem->getTagmChannels();
   ((_HDDM_ElementList*)list)->borrowed = 1;
   ((_HDDM_ElementList*)list)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(list), ((_HDDM_ElementList*)list)->subtype, 0);
   return list;
}

static PyObject*
_TagmBeamPhoton_addTagmChannels(PyObject *self, PyObject *args)
{
   int count=1;
   int start=-1;
   if (! PyArg_ParseTuple(args, "|ii", &count, &start)) {
      return NULL;
   }
   _TagmBeamPhoton *me = (_TagmBeamPhoton*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "add attempted on invalid tagmBeamPhoton element");
      return NULL;
   }
   PyObject *list = _HDDM_ElementList_new(&_HDDM_ElementList_type, 0, 0);
   ((_HDDM_ElementList*)list)->subtype = &_TagmChannel_type;
   ((_HDDM_ElementList*)list)->list = (HDDM_ElementList<HDDM_Element>*)
    new TagmChannelList(me->elem->addTagmChannels(count, start));
   ((_HDDM_ElementList*)list)->borrowed = 0;
   ((_HDDM_ElementList*)list)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(list), ((_HDDM_ElementList*)list)->subtype, 1);
   return list;
}

static PyObject*
_TagmBeamPhoton_deleteTagmChannels(PyObject *self, PyObject *args)
{
   int count=-1;
   int start=0;
   if (! PyArg_ParseTuple(args, "|ii", &count, &start)) {
      return NULL;
   }
   _TagmBeamPhoton *me = (_TagmBeamPhoton*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "delete attempted on invalid tagmBeamPhoton element");
      return NULL;
   }
   me->elem->deleteTagmChannels(count, start);
   Py_INCREF(Py_None);
   return Py_None;
}

static PyObject*
_TagmBeamPhoton_toString(PyObject *self, PyObject *args=0)
{
   _TagmBeamPhoton *me = (_TagmBeamPhoton*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid tagmBeamPhoton element");
      return NULL;
   }
   std::string str(me->elem->toString());
   return PyUnicode_FromString(str.c_str());
}

static PyObject*
_TagmBeamPhoton_toXML(PyObject *self, PyObject *args=0)
{
   _TagmBeamPhoton *me = (_TagmBeamPhoton*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid tagmBeamPhoton element");
      return NULL;
   }
   std::string str(me->elem->toXML());
   return PyUnicode_FromString(str.c_str());
}

static PyGetSetDef _TagmBeamPhoton_getsetters[] = {
   {(char*)"E",
    (getter)_TagmBeamPhoton_getE, (setter)_TagmBeamPhoton_setE,
    (char*)"E value",
    NULL},
   {(char*)"Eunit",
    (getter)_TagmBeamPhoton_getEunit, 0,
    (char*)"Eunit value",
    NULL},
   {(char*)"class",
    (getter)_TagmBeamPhoton_getClass, 0,
    (char*)"class string",
    NULL},
   {(char*)"eventNo",
    (getter)_TagmBeamPhoton_getEventNo, 0,
    (char*)"eventNo value",
    NULL},
   {(char*)"jtag",
    (getter)_TagmBeamPhoton_getJtag, (setter)_TagmBeamPhoton_setJtag,
    (char*)"jtag string",
    NULL},
   {(char*)"maxOccurs",
    (getter)_TagmBeamPhoton_getMaxOccurs, 0,
    (char*)"maxOccurs value",
    NULL},
   {(char*)"minOccurs",
    (getter)_TagmBeamPhoton_getMinOccurs, 0,
    (char*)"minOccurs value",
    NULL},
   {(char*)"runNo",
    (getter)_TagmBeamPhoton_getRunNo, 0,
    (char*)"runNo value",
    NULL},
   {(char*)"t",
    (getter)_TagmBeamPhoton_getT, (setter)_TagmBeamPhoton_setT,
    (char*)"t value",
    NULL},
   {(char*)"tunit",
    (getter)_TagmBeamPhoton_getTunit, 0,
    (char*)"tunit value",
    NULL},
   {(char*)"version",
    (getter)_TagmBeamPhoton_getVersion, 0,
    (char*)"version string",
    NULL},
   {(char*)"xmlns",
    (getter)_TagmBeamPhoton_getXmlns, 0,
    (char*)"xmlns string",
    NULL},
   {NULL}  /* Sentinel */
};

static PyMemberDef _TagmBeamPhoton_members[] = {
   {NULL}  /* Sentinel */
};

static PyMethodDef _TagmBeamPhoton_methods[] = {
   {"addTagmChannels", _TagmBeamPhoton_addTagmChannels, METH_VARARGS,
    "extend (or insert into) the list of tagmChannel objects for this tagmBeamPhoton"},
   {"deleteTagmChannels", _TagmBeamPhoton_deleteTagmChannels, METH_VARARGS,
    "delete tagmChannel objects for this tagmBeamPhoton"},
   {"getTagmChannel", _TagmBeamPhoton_getTagmChannel, METH_VARARGS,
    "get an individual tagmChannel object from this tagmBeamPhoton"},
   {"getTagmChannels", _TagmBeamPhoton_getTagmChannels, METH_NOARGS,
    "get list of tagmChannel objects for this tagmBeamPhoton"},
   {"toString", _TagmBeamPhoton_toString, METH_NOARGS,
    "show element as a human-readable string"},
   {"toXML", _TagmBeamPhoton_toXML, METH_NOARGS,
    "show element as a XML fragment"},
   {NULL}  /* Sentinel */
};

static PyTypeObject _TagmBeamPhoton_type = {
    PyVarObject_HEAD_INIT(NULL,0)
    "hddm_r.TagmBeamPhoton",         /*tp_name*/
    sizeof(_TagmBeamPhoton),          /*tp_basicsize*/
    0,                         /*tp_itemsize*/
    (destructor)_TagmBeamPhoton_dealloc, /*tp_dealloc*/
    0,                         /*tp_print*/
    0,                         /*tp_getattr*/
    0,                         /*tp_setattr*/
    0,                         /*tp_compare*/
    0,                         /*tp_repr*/
    0,                         /*tp_as_number*/
    0,                         /*tp_as_sequence*/
    0,                         /*tp_as_mapping*/
    0,                         /*tp_hash */
    0,                         /*tp_call*/
    (reprfunc)_TagmBeamPhoton_toString,         /*tp_str*/
    0,                         /*tp_getattro*/
    0,                         /*tp_setattro*/
    0,                         /*tp_as_buffer*/
    Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE, /*tp_flags*/
    "hddm_r tagmBeamPhoton element",  /* tp_doc */
    0,                         /* tp_traverse */
    0,                         /* tp_clear */
    0,                         /* tp_richcompare */
    0,                         /* tp_weaklistoffset */
    0,                         /* tp_iter */
    0,                         /* tp_iternext */
    _TagmBeamPhoton_methods,          /* tp_methods */
    _TagmBeamPhoton_members,          /* tp_members */
    _TagmBeamPhoton_getsetters,       /* tp_getset */
    &_HDDM_Element_type,       /* tp_base */
    0,                         /* tp_dict */
    0,                         /* tp_descr_get */
    0,                         /* tp_descr_set */
    0,                         /* tp_dictoffset */
    (initproc)_TagmBeamPhoton_init,   /* tp_init */
    0,                         /* tp_alloc */
    _TagmBeamPhoton_new,              /* tp_new */
};



// wrap element class hddm_r::TaghChannel as hddm_r.TaghChannel

typedef struct {
   PyObject_HEAD
   TaghChannel *elem;
   PyObject *host;
} _TaghChannel;

static void
_TaghChannel_dealloc(_TaghChannel* self)
{
   if (self->elem != 0) {
      LOG_DEALLOC(Py_TYPE(self), 0, self->host == (PyObject*)self);
      if (self->host == (PyObject*)self)
         delete self->elem;
      else
         My_DECREF(self->host);
   }
   Py_TYPE(self)->tp_free((PyObject*)self);
}

static PyObject*
_TaghChannel_new(PyTypeObject *type, PyObject *args, PyObject *kwds)
{
   _TaghChannel *self;
   self = (_TaghChannel*)type->tp_alloc(type, 0);
   if (self != NULL) {
      self->elem = 0;
      self->host = 0;
   }
   return (PyObject*)self;
}

static int
_TaghChannel_init(_TaghChannel *self, PyObject *args, PyObject *kwds)
{
   PyErr_SetString(PyExc_RuntimeError, "illegal constructor");
   return -1;
}

static PyObject*
_TaghChannel_getClass(_TaghChannel *self, void *closure)
{
   std::string val(self->elem->getClass());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_TaghChannel_getVersion(_TaghChannel *self, void *closure)
{
   std::string val(self->elem->getVersion());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_TaghChannel_getXmlns(_TaghChannel *self, void *closure)
{
   std::string val(self->elem->getXmlns());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_TaghChannel_getEventNo(_TaghChannel *self, void *closure)
{
   return PyLong_FromLongLong(self->elem->getEventNo());
}

static PyObject*
_TaghChannel_getRunNo(_TaghChannel *self, void *closure)
{
   return PyLong_FromLong(self->elem->getRunNo());
}

static PyObject*
_TaghChannel_getE(_TaghChannel *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getE());
}

static PyObject*
_TaghChannel_getEunit(_TaghChannel *self, void *closure)
{
   std::string val(self->elem->getEunit());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_TaghChannel_getJtag(_TaghChannel *self, void *closure)
{
   std::string val(self->elem->getJtag());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_TaghChannel_getMaxOccurs(_TaghChannel *self, void *closure)
{
   std::string val(self->elem->getMaxOccurs());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_TaghChannel_getT(_TaghChannel *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getT());
}

static PyObject*
_TaghChannel_getTunit(_TaghChannel *self, void *closure)
{
   std::string val(self->elem->getTunit());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_TaghChannel_getCounter(_TaghChannel *self, void *closure)
{
   return PyLong_FromLong(self->elem->getCounter());
}

static int
_TaghChannel_setCounter(_TaghChannel *self, PyObject *value, void *closure)
{
   long var = PyInt_AsLong(value);
   if (var == -1 && PyErr_Occurred()) {
      return -1;
   }
   self->elem->setCounter(var);
   return 0;
}

static PyObject*
_TaghChannel_getMinOccurs(_TaghChannel *self, void *closure)
{
   return PyLong_FromLong(self->elem->getMinOccurs());
}

static PyObject*
_TaghChannel_toString(PyObject *self, PyObject *args=0)
{
   _TaghChannel *me = (_TaghChannel*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid taghChannel element");
      return NULL;
   }
   std::string str(me->elem->toString());
   return PyUnicode_FromString(str.c_str());
}

static PyObject*
_TaghChannel_toXML(PyObject *self, PyObject *args=0)
{
   _TaghChannel *me = (_TaghChannel*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid taghChannel element");
      return NULL;
   }
   std::string str(me->elem->toXML());
   return PyUnicode_FromString(str.c_str());
}

static PyGetSetDef _TaghChannel_getsetters[] = {
   {(char*)"E",
    (getter)_TaghChannel_getE, 0,
    (char*)"E value",
    NULL},
   {(char*)"Eunit",
    (getter)_TaghChannel_getEunit, 0,
    (char*)"Eunit string",
    NULL},
   {(char*)"class",
    (getter)_TaghChannel_getClass, 0,
    (char*)"class string",
    NULL},
   {(char*)"counter",
    (getter)_TaghChannel_getCounter, (setter)_TaghChannel_setCounter,
    (char*)"counter value",
    NULL},
   {(char*)"eventNo",
    (getter)_TaghChannel_getEventNo, 0,
    (char*)"eventNo value",
    NULL},
   {(char*)"jtag",
    (getter)_TaghChannel_getJtag, 0,
    (char*)"jtag string",
    NULL},
   {(char*)"maxOccurs",
    (getter)_TaghChannel_getMaxOccurs, 0,
    (char*)"maxOccurs string",
    NULL},
   {(char*)"minOccurs",
    (getter)_TaghChannel_getMinOccurs, 0,
    (char*)"minOccurs value",
    NULL},
   {(char*)"runNo",
    (getter)_TaghChannel_getRunNo, 0,
    (char*)"runNo value",
    NULL},
   {(char*)"t",
    (getter)_TaghChannel_getT, 0,
    (char*)"t value",
    NULL},
   {(char*)"tunit",
    (getter)_TaghChannel_getTunit, 0,
    (char*)"tunit string",
    NULL},
   {(char*)"version",
    (getter)_TaghChannel_getVersion, 0,
    (char*)"version string",
    NULL},
   {(char*)"xmlns",
    (getter)_TaghChannel_getXmlns, 0,
    (char*)"xmlns string",
    NULL},
   {NULL}  /* Sentinel */
};

static PyMemberDef _TaghChannel_members[] = {
   {NULL}  /* Sentinel */
};

static PyMethodDef _TaghChannel_methods[] = {
   {"toString", _TaghChannel_toString, METH_NOARGS,
    "show element as a human-readable string"},
   {"toXML", _TaghChannel_toXML, METH_NOARGS,
    "show element as a XML fragment"},
   {NULL}  /* Sentinel */
};

static PyTypeObject _TaghChannel_type = {
    PyVarObject_HEAD_INIT(NULL,0)
    "hddm_r.TaghChannel",         /*tp_name*/
    sizeof(_TaghChannel),          /*tp_basicsize*/
    0,                         /*tp_itemsize*/
    (destructor)_TaghChannel_dealloc, /*tp_dealloc*/
    0,                         /*tp_print*/
    0,                         /*tp_getattr*/
    0,                         /*tp_setattr*/
    0,                         /*tp_compare*/
    0,                         /*tp_repr*/
    0,                         /*tp_as_number*/
    0,                         /*tp_as_sequence*/
    0,                         /*tp_as_mapping*/
    0,                         /*tp_hash */
    0,                         /*tp_call*/
    (reprfunc)_TaghChannel_toString,         /*tp_str*/
    0,                         /*tp_getattro*/
    0,                         /*tp_setattro*/
    0,                         /*tp_as_buffer*/
    Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE, /*tp_flags*/
    "hddm_r taghChannel element",  /* tp_doc */
    0,                         /* tp_traverse */
    0,                         /* tp_clear */
    0,                         /* tp_richcompare */
    0,                         /* tp_weaklistoffset */
    0,                         /* tp_iter */
    0,                         /* tp_iternext */
    _TaghChannel_methods,          /* tp_methods */
    _TaghChannel_members,          /* tp_members */
    _TaghChannel_getsetters,       /* tp_getset */
    &_HDDM_Element_type,       /* tp_base */
    0,                         /* tp_dict */
    0,                         /* tp_descr_get */
    0,                         /* tp_descr_set */
    0,                         /* tp_dictoffset */
    (initproc)_TaghChannel_init,   /* tp_init */
    0,                         /* tp_alloc */
    _TaghChannel_new,              /* tp_new */
};



// wrap element class hddm_r::TaghBeamPhoton as hddm_r.TaghBeamPhoton

typedef struct {
   PyObject_HEAD
   TaghBeamPhoton *elem;
   PyObject *host;
} _TaghBeamPhoton;

static void
_TaghBeamPhoton_dealloc(_TaghBeamPhoton* self)
{
   if (self->elem != 0) {
      LOG_DEALLOC(Py_TYPE(self), 0, self->host == (PyObject*)self);
      if (self->host == (PyObject*)self)
         delete self->elem;
      else
         My_DECREF(self->host);
   }
   Py_TYPE(self)->tp_free((PyObject*)self);
}

static PyObject*
_TaghBeamPhoton_new(PyTypeObject *type, PyObject *args, PyObject *kwds)
{
   _TaghBeamPhoton *self;
   self = (_TaghBeamPhoton*)type->tp_alloc(type, 0);
   if (self != NULL) {
      self->elem = 0;
      self->host = 0;
   }
   return (PyObject*)self;
}

static int
_TaghBeamPhoton_init(_TaghBeamPhoton *self, PyObject *args, PyObject *kwds)
{
   PyErr_SetString(PyExc_RuntimeError, "illegal constructor");
   return -1;
}

static PyObject*
_TaghBeamPhoton_getClass(_TaghBeamPhoton *self, void *closure)
{
   std::string val(self->elem->getClass());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_TaghBeamPhoton_getVersion(_TaghBeamPhoton *self, void *closure)
{
   std::string val(self->elem->getVersion());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_TaghBeamPhoton_getXmlns(_TaghBeamPhoton *self, void *closure)
{
   std::string val(self->elem->getXmlns());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_TaghBeamPhoton_getEventNo(_TaghBeamPhoton *self, void *closure)
{
   return PyLong_FromLongLong(self->elem->getEventNo());
}

static PyObject*
_TaghBeamPhoton_getRunNo(_TaghBeamPhoton *self, void *closure)
{
   return PyLong_FromLong(self->elem->getRunNo());
}

static PyObject*
_TaghBeamPhoton_getE(_TaghBeamPhoton *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getE());
}

static int
_TaghBeamPhoton_setE(_TaghBeamPhoton *self, PyObject *value, void *closure)
{
   double var = PyFloat_AsDouble(value);
   if (var == -1 && PyErr_Occurred()) {
      return 1;
   }
   self->elem->setE((float)var);
   return 0;
}

static PyObject*
_TaghBeamPhoton_getEunit(_TaghBeamPhoton *self, void *closure)
{
   std::string val(self->elem->getEunit());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_TaghBeamPhoton_getJtag(_TaghBeamPhoton *self, void *closure)
{
   std::string val(self->elem->getJtag());
   return PyUnicode_FromString(val.c_str());
}

static int
_TaghBeamPhoton_setJtag(_TaghBeamPhoton *self, PyObject *value, void *closure)
{
   PyObject *str=0;
   if (PyUnicode_Check(value))
      str = PyUnicode_AsEncodedString(value, "ASCII", "strict");
   else
      str = value;
#if PY_MAJOR_VERSION < 3
   char *var = PyString_AsString(str);
#else
   char *var = PyBytes_AsString(str);
#endif
   if (var == 0) {
      return -1;
   }
   self->elem->setJtag(std::string(var));
   if (str != value) {
      Py_DECREF(str);
   }
   return 0;
}

static PyObject*
_TaghBeamPhoton_getMaxOccurs(_TaghBeamPhoton *self, void *closure)
{
   std::string val(self->elem->getMaxOccurs());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_TaghBeamPhoton_getMinOccurs(_TaghBeamPhoton *self, void *closure)
{
   return PyLong_FromLong(self->elem->getMinOccurs());
}

static PyObject*
_TaghBeamPhoton_getT(_TaghBeamPhoton *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getT());
}

static int
_TaghBeamPhoton_setT(_TaghBeamPhoton *self, PyObject *value, void *closure)
{
   double var = PyFloat_AsDouble(value);
   if (var == -1 && PyErr_Occurred()) {
      return 1;
   }
   self->elem->setT((float)var);
   return 0;
}

static PyObject*
_TaghBeamPhoton_getTunit(_TaghBeamPhoton *self, void *closure)
{
   std::string val(self->elem->getTunit());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_TaghBeamPhoton_getTaghChannel(PyObject *self, PyObject *args)
{
   int index=0;
   if (! PyArg_ParseTuple(args, "|i", &index)) {
      return NULL;
   }
   _TaghBeamPhoton *me = (_TaghBeamPhoton*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid taghBeamPhoton element");
      return NULL;
   }
   PyObject *obj = _TaghChannel_new(&_TaghChannel_type, 0, 0);
   ((_TaghChannel*)obj)->elem = &me->elem->getTaghChannel();
   ((_TaghChannel*)obj)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(obj));
   return obj;
}

static PyObject*
_TaghBeamPhoton_getTaghChannels(PyObject *self, PyObject *args)
{
   _TaghBeamPhoton *me = (_TaghBeamPhoton*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid taghBeamPhoton element");
      return NULL;
   }
   PyObject *list = _HDDM_ElementList_new(&_HDDM_ElementList_type, 0, 0);
   ((_HDDM_ElementList*)list)->subtype = &_TaghChannel_type;
   ((_HDDM_ElementList*)list)->list = (HDDM_ElementList<HDDM_Element>*)
    &me->elem->getTaghChannels();
   ((_HDDM_ElementList*)list)->borrowed = 1;
   ((_HDDM_ElementList*)list)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(list), ((_HDDM_ElementList*)list)->subtype, 0);
   return list;
}

static PyObject*
_TaghBeamPhoton_addTaghChannels(PyObject *self, PyObject *args)
{
   int count=1;
   int start=-1;
   if (! PyArg_ParseTuple(args, "|ii", &count, &start)) {
      return NULL;
   }
   _TaghBeamPhoton *me = (_TaghBeamPhoton*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "add attempted on invalid taghBeamPhoton element");
      return NULL;
   }
   PyObject *list = _HDDM_ElementList_new(&_HDDM_ElementList_type, 0, 0);
   ((_HDDM_ElementList*)list)->subtype = &_TaghChannel_type;
   ((_HDDM_ElementList*)list)->list = (HDDM_ElementList<HDDM_Element>*)
    new TaghChannelList(me->elem->addTaghChannels(count, start));
   ((_HDDM_ElementList*)list)->borrowed = 0;
   ((_HDDM_ElementList*)list)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(list), ((_HDDM_ElementList*)list)->subtype, 1);
   return list;
}

static PyObject*
_TaghBeamPhoton_deleteTaghChannels(PyObject *self, PyObject *args)
{
   int count=-1;
   int start=0;
   if (! PyArg_ParseTuple(args, "|ii", &count, &start)) {
      return NULL;
   }
   _TaghBeamPhoton *me = (_TaghBeamPhoton*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "delete attempted on invalid taghBeamPhoton element");
      return NULL;
   }
   me->elem->deleteTaghChannels(count, start);
   Py_INCREF(Py_None);
   return Py_None;
}

static PyObject*
_TaghBeamPhoton_toString(PyObject *self, PyObject *args=0)
{
   _TaghBeamPhoton *me = (_TaghBeamPhoton*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid taghBeamPhoton element");
      return NULL;
   }
   std::string str(me->elem->toString());
   return PyUnicode_FromString(str.c_str());
}

static PyObject*
_TaghBeamPhoton_toXML(PyObject *self, PyObject *args=0)
{
   _TaghBeamPhoton *me = (_TaghBeamPhoton*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid taghBeamPhoton element");
      return NULL;
   }
   std::string str(me->elem->toXML());
   return PyUnicode_FromString(str.c_str());
}

static PyGetSetDef _TaghBeamPhoton_getsetters[] = {
   {(char*)"E",
    (getter)_TaghBeamPhoton_getE, (setter)_TaghBeamPhoton_setE,
    (char*)"E value",
    NULL},
   {(char*)"Eunit",
    (getter)_TaghBeamPhoton_getEunit, 0,
    (char*)"Eunit value",
    NULL},
   {(char*)"class",
    (getter)_TaghBeamPhoton_getClass, 0,
    (char*)"class string",
    NULL},
   {(char*)"eventNo",
    (getter)_TaghBeamPhoton_getEventNo, 0,
    (char*)"eventNo value",
    NULL},
   {(char*)"jtag",
    (getter)_TaghBeamPhoton_getJtag, (setter)_TaghBeamPhoton_setJtag,
    (char*)"jtag string",
    NULL},
   {(char*)"maxOccurs",
    (getter)_TaghBeamPhoton_getMaxOccurs, 0,
    (char*)"maxOccurs value",
    NULL},
   {(char*)"minOccurs",
    (getter)_TaghBeamPhoton_getMinOccurs, 0,
    (char*)"minOccurs value",
    NULL},
   {(char*)"runNo",
    (getter)_TaghBeamPhoton_getRunNo, 0,
    (char*)"runNo value",
    NULL},
   {(char*)"t",
    (getter)_TaghBeamPhoton_getT, (setter)_TaghBeamPhoton_setT,
    (char*)"t value",
    NULL},
   {(char*)"tunit",
    (getter)_TaghBeamPhoton_getTunit, 0,
    (char*)"tunit value",
    NULL},
   {(char*)"version",
    (getter)_TaghBeamPhoton_getVersion, 0,
    (char*)"version string",
    NULL},
   {(char*)"xmlns",
    (getter)_TaghBeamPhoton_getXmlns, 0,
    (char*)"xmlns string",
    NULL},
   {NULL}  /* Sentinel */
};

static PyMemberDef _TaghBeamPhoton_members[] = {
   {NULL}  /* Sentinel */
};

static PyMethodDef _TaghBeamPhoton_methods[] = {
   {"addTaghChannels", _TaghBeamPhoton_addTaghChannels, METH_VARARGS,
    "extend (or insert into) the list of taghChannel objects for this taghBeamPhoton"},
   {"deleteTaghChannels", _TaghBeamPhoton_deleteTaghChannels, METH_VARARGS,
    "delete taghChannel objects for this taghBeamPhoton"},
   {"getTaghChannel", _TaghBeamPhoton_getTaghChannel, METH_VARARGS,
    "get an individual taghChannel object from this taghBeamPhoton"},
   {"getTaghChannels", _TaghBeamPhoton_getTaghChannels, METH_NOARGS,
    "get list of taghChannel objects for this taghBeamPhoton"},
   {"toString", _TaghBeamPhoton_toString, METH_NOARGS,
    "show element as a human-readable string"},
   {"toXML", _TaghBeamPhoton_toXML, METH_NOARGS,
    "show element as a XML fragment"},
   {NULL}  /* Sentinel */
};

static PyTypeObject _TaghBeamPhoton_type = {
    PyVarObject_HEAD_INIT(NULL,0)
    "hddm_r.TaghBeamPhoton",         /*tp_name*/
    sizeof(_TaghBeamPhoton),          /*tp_basicsize*/
    0,                         /*tp_itemsize*/
    (destructor)_TaghBeamPhoton_dealloc, /*tp_dealloc*/
    0,                         /*tp_print*/
    0,                         /*tp_getattr*/
    0,                         /*tp_setattr*/
    0,                         /*tp_compare*/
    0,                         /*tp_repr*/
    0,                         /*tp_as_number*/
    0,                         /*tp_as_sequence*/
    0,                         /*tp_as_mapping*/
    0,                         /*tp_hash */
    0,                         /*tp_call*/
    (reprfunc)_TaghBeamPhoton_toString,         /*tp_str*/
    0,                         /*tp_getattro*/
    0,                         /*tp_setattro*/
    0,                         /*tp_as_buffer*/
    Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE, /*tp_flags*/
    "hddm_r taghBeamPhoton element",  /* tp_doc */
    0,                         /* tp_traverse */
    0,                         /* tp_clear */
    0,                         /* tp_richcompare */
    0,                         /* tp_weaklistoffset */
    0,                         /* tp_iter */
    0,                         /* tp_iternext */
    _TaghBeamPhoton_methods,          /* tp_methods */
    _TaghBeamPhoton_members,          /* tp_members */
    _TaghBeamPhoton_getsetters,       /* tp_getset */
    &_HDDM_Element_type,       /* tp_base */
    0,                         /* tp_dict */
    0,                         /* tp_descr_get */
    0,                         /* tp_descr_set */
    0,                         /* tp_dictoffset */
    (initproc)_TaghBeamPhoton_init,   /* tp_init */
    0,                         /* tp_alloc */
    _TaghBeamPhoton_new,              /* tp_new */
};



// wrap element class hddm_r::FcalCorrelations as hddm_r.FcalCorrelations

typedef struct {
   PyObject_HEAD
   FcalCorrelations *elem;
   PyObject *host;
} _FcalCorrelations;

static void
_FcalCorrelations_dealloc(_FcalCorrelations* self)
{
   if (self->elem != 0) {
      LOG_DEALLOC(Py_TYPE(self), 0, self->host == (PyObject*)self);
      if (self->host == (PyObject*)self)
         delete self->elem;
      else
         My_DECREF(self->host);
   }
   Py_TYPE(self)->tp_free((PyObject*)self);
}

static PyObject*
_FcalCorrelations_new(PyTypeObject *type, PyObject *args, PyObject *kwds)
{
   _FcalCorrelations *self;
   self = (_FcalCorrelations*)type->tp_alloc(type, 0);
   if (self != NULL) {
      self->elem = 0;
      self->host = 0;
   }
   return (PyObject*)self;
}

static int
_FcalCorrelations_init(_FcalCorrelations *self, PyObject *args, PyObject *kwds)
{
   PyErr_SetString(PyExc_RuntimeError, "illegal constructor");
   return -1;
}

static PyObject*
_FcalCorrelations_getClass(_FcalCorrelations *self, void *closure)
{
   std::string val(self->elem->getClass());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_FcalCorrelations_getVersion(_FcalCorrelations *self, void *closure)
{
   std::string val(self->elem->getVersion());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_FcalCorrelations_getXmlns(_FcalCorrelations *self, void *closure)
{
   std::string val(self->elem->getXmlns());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_FcalCorrelations_getEventNo(_FcalCorrelations *self, void *closure)
{
   return PyLong_FromLongLong(self->elem->getEventNo());
}

static PyObject*
_FcalCorrelations_getRunNo(_FcalCorrelations *self, void *closure)
{
   return PyLong_FromLong(self->elem->getRunNo());
}

static PyObject*
_FcalCorrelations_getE(_FcalCorrelations *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getE());
}

static PyObject*
_FcalCorrelations_getEerr(_FcalCorrelations *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getEerr());
}

static PyObject*
_FcalCorrelations_getEunit(_FcalCorrelations *self, void *closure)
{
   std::string val(self->elem->getEunit());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_FcalCorrelations_getEzcorr(_FcalCorrelations *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getEzcorr());
}

static PyObject*
_FcalCorrelations_getJtag(_FcalCorrelations *self, void *closure)
{
   std::string val(self->elem->getJtag());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_FcalCorrelations_getLunit(_FcalCorrelations *self, void *closure)
{
   std::string val(self->elem->getLunit());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_FcalCorrelations_getT(_FcalCorrelations *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getT());
}

static PyObject*
_FcalCorrelations_getTerr(_FcalCorrelations *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getTerr());
}

static PyObject*
_FcalCorrelations_getTunit(_FcalCorrelations *self, void *closure)
{
   std::string val(self->elem->getTunit());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_FcalCorrelations_getTzcorr(_FcalCorrelations *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getTzcorr());
}

static PyObject*
_FcalCorrelations_getX(_FcalCorrelations *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getX());
}

static PyObject*
_FcalCorrelations_getXerr(_FcalCorrelations *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getXerr());
}

static PyObject*
_FcalCorrelations_getXycorr(_FcalCorrelations *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getXycorr());
}

static PyObject*
_FcalCorrelations_getXzcorr(_FcalCorrelations *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getXzcorr());
}

static PyObject*
_FcalCorrelations_getY(_FcalCorrelations *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getY());
}

static PyObject*
_FcalCorrelations_getYerr(_FcalCorrelations *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getYerr());
}

static PyObject*
_FcalCorrelations_getYzcorr(_FcalCorrelations *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getYzcorr());
}

static PyObject*
_FcalCorrelations_getZ(_FcalCorrelations *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getZ());
}

static PyObject*
_FcalCorrelations_getZerr(_FcalCorrelations *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getZerr());
}

static PyObject*
_FcalCorrelations_getEtcorr(_FcalCorrelations *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getEtcorr());
}

static int
_FcalCorrelations_setEtcorr(_FcalCorrelations *self, PyObject *value, void *closure)
{
   double var = PyFloat_AsDouble(value);
   if (var == -1 && PyErr_Occurred()) {
      return 1;
   }
   self->elem->setEtcorr((float)var);
   return 0;
}

static PyObject*
_FcalCorrelations_getExcorr(_FcalCorrelations *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getExcorr());
}

static int
_FcalCorrelations_setExcorr(_FcalCorrelations *self, PyObject *value, void *closure)
{
   double var = PyFloat_AsDouble(value);
   if (var == -1 && PyErr_Occurred()) {
      return 1;
   }
   self->elem->setExcorr((float)var);
   return 0;
}

static PyObject*
_FcalCorrelations_getEycorr(_FcalCorrelations *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getEycorr());
}

static int
_FcalCorrelations_setEycorr(_FcalCorrelations *self, PyObject *value, void *closure)
{
   double var = PyFloat_AsDouble(value);
   if (var == -1 && PyErr_Occurred()) {
      return 1;
   }
   self->elem->setEycorr((float)var);
   return 0;
}

static PyObject*
_FcalCorrelations_getMaxOccurs(_FcalCorrelations *self, void *closure)
{
   return PyLong_FromLong(self->elem->getMaxOccurs());
}

static PyObject*
_FcalCorrelations_getMinOccurs(_FcalCorrelations *self, void *closure)
{
   return PyLong_FromLong(self->elem->getMinOccurs());
}

static PyObject*
_FcalCorrelations_getTxcorr(_FcalCorrelations *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getTxcorr());
}

static int
_FcalCorrelations_setTxcorr(_FcalCorrelations *self, PyObject *value, void *closure)
{
   double var = PyFloat_AsDouble(value);
   if (var == -1 && PyErr_Occurred()) {
      return 1;
   }
   self->elem->setTxcorr((float)var);
   return 0;
}

static PyObject*
_FcalCorrelations_getTycorr(_FcalCorrelations *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getTycorr());
}

static int
_FcalCorrelations_setTycorr(_FcalCorrelations *self, PyObject *value, void *closure)
{
   double var = PyFloat_AsDouble(value);
   if (var == -1 && PyErr_Occurred()) {
      return 1;
   }
   self->elem->setTycorr((float)var);
   return 0;
}

static PyObject*
_FcalCorrelations_toString(PyObject *self, PyObject *args=0)
{
   _FcalCorrelations *me = (_FcalCorrelations*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid fcalCorrelations element");
      return NULL;
   }
   std::string str(me->elem->toString());
   return PyUnicode_FromString(str.c_str());
}

static PyObject*
_FcalCorrelations_toXML(PyObject *self, PyObject *args=0)
{
   _FcalCorrelations *me = (_FcalCorrelations*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid fcalCorrelations element");
      return NULL;
   }
   std::string str(me->elem->toXML());
   return PyUnicode_FromString(str.c_str());
}

static PyGetSetDef _FcalCorrelations_getsetters[] = {
   {(char*)"E",
    (getter)_FcalCorrelations_getE, 0,
    (char*)"E value",
    NULL},
   {(char*)"Eerr",
    (getter)_FcalCorrelations_getEerr, 0,
    (char*)"Eerr value",
    NULL},
   {(char*)"Etcorr",
    (getter)_FcalCorrelations_getEtcorr, (setter)_FcalCorrelations_setEtcorr,
    (char*)"Etcorr value",
    NULL},
   {(char*)"Eunit",
    (getter)_FcalCorrelations_getEunit, 0,
    (char*)"Eunit string",
    NULL},
   {(char*)"Excorr",
    (getter)_FcalCorrelations_getExcorr, (setter)_FcalCorrelations_setExcorr,
    (char*)"Excorr value",
    NULL},
   {(char*)"Eycorr",
    (getter)_FcalCorrelations_getEycorr, (setter)_FcalCorrelations_setEycorr,
    (char*)"Eycorr value",
    NULL},
   {(char*)"Ezcorr",
    (getter)_FcalCorrelations_getEzcorr, 0,
    (char*)"Ezcorr value",
    NULL},
   {(char*)"class",
    (getter)_FcalCorrelations_getClass, 0,
    (char*)"class string",
    NULL},
   {(char*)"eventNo",
    (getter)_FcalCorrelations_getEventNo, 0,
    (char*)"eventNo value",
    NULL},
   {(char*)"jtag",
    (getter)_FcalCorrelations_getJtag, 0,
    (char*)"jtag string",
    NULL},
   {(char*)"lunit",
    (getter)_FcalCorrelations_getLunit, 0,
    (char*)"lunit string",
    NULL},
   {(char*)"maxOccurs",
    (getter)_FcalCorrelations_getMaxOccurs, 0,
    (char*)"maxOccurs value",
    NULL},
   {(char*)"minOccurs",
    (getter)_FcalCorrelations_getMinOccurs, 0,
    (char*)"minOccurs value",
    NULL},
   {(char*)"runNo",
    (getter)_FcalCorrelations_getRunNo, 0,
    (char*)"runNo value",
    NULL},
   {(char*)"t",
    (getter)_FcalCorrelations_getT, 0,
    (char*)"t value",
    NULL},
   {(char*)"terr",
    (getter)_FcalCorrelations_getTerr, 0,
    (char*)"terr value",
    NULL},
   {(char*)"tunit",
    (getter)_FcalCorrelations_getTunit, 0,
    (char*)"tunit string",
    NULL},
   {(char*)"txcorr",
    (getter)_FcalCorrelations_getTxcorr, (setter)_FcalCorrelations_setTxcorr,
    (char*)"txcorr value",
    NULL},
   {(char*)"tycorr",
    (getter)_FcalCorrelations_getTycorr, (setter)_FcalCorrelations_setTycorr,
    (char*)"tycorr value",
    NULL},
   {(char*)"tzcorr",
    (getter)_FcalCorrelations_getTzcorr, 0,
    (char*)"tzcorr value",
    NULL},
   {(char*)"version",
    (getter)_FcalCorrelations_getVersion, 0,
    (char*)"version string",
    NULL},
   {(char*)"x",
    (getter)_FcalCorrelations_getX, 0,
    (char*)"x value",
    NULL},
   {(char*)"xerr",
    (getter)_FcalCorrelations_getXerr, 0,
    (char*)"xerr value",
    NULL},
   {(char*)"xmlns",
    (getter)_FcalCorrelations_getXmlns, 0,
    (char*)"xmlns string",
    NULL},
   {(char*)"xycorr",
    (getter)_FcalCorrelations_getXycorr, 0,
    (char*)"xycorr value",
    NULL},
   {(char*)"xzcorr",
    (getter)_FcalCorrelations_getXzcorr, 0,
    (char*)"xzcorr value",
    NULL},
   {(char*)"y",
    (getter)_FcalCorrelations_getY, 0,
    (char*)"y value",
    NULL},
   {(char*)"yerr",
    (getter)_FcalCorrelations_getYerr, 0,
    (char*)"yerr value",
    NULL},
   {(char*)"yzcorr",
    (getter)_FcalCorrelations_getYzcorr, 0,
    (char*)"yzcorr value",
    NULL},
   {(char*)"z",
    (getter)_FcalCorrelations_getZ, 0,
    (char*)"z value",
    NULL},
   {(char*)"zerr",
    (getter)_FcalCorrelations_getZerr, 0,
    (char*)"zerr value",
    NULL},
   {NULL}  /* Sentinel */
};

static PyMemberDef _FcalCorrelations_members[] = {
   {NULL}  /* Sentinel */
};

static PyMethodDef _FcalCorrelations_methods[] = {
   {"toString", _FcalCorrelations_toString, METH_NOARGS,
    "show element as a human-readable string"},
   {"toXML", _FcalCorrelations_toXML, METH_NOARGS,
    "show element as a XML fragment"},
   {NULL}  /* Sentinel */
};

static PyTypeObject _FcalCorrelations_type = {
    PyVarObject_HEAD_INIT(NULL,0)
    "hddm_r.FcalCorrelations",         /*tp_name*/
    sizeof(_FcalCorrelations),          /*tp_basicsize*/
    0,                         /*tp_itemsize*/
    (destructor)_FcalCorrelations_dealloc, /*tp_dealloc*/
    0,                         /*tp_print*/
    0,                         /*tp_getattr*/
    0,                         /*tp_setattr*/
    0,                         /*tp_compare*/
    0,                         /*tp_repr*/
    0,                         /*tp_as_number*/
    0,                         /*tp_as_sequence*/
    0,                         /*tp_as_mapping*/
    0,                         /*tp_hash */
    0,                         /*tp_call*/
    (reprfunc)_FcalCorrelations_toString,         /*tp_str*/
    0,                         /*tp_getattro*/
    0,                         /*tp_setattro*/
    0,                         /*tp_as_buffer*/
    Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE, /*tp_flags*/
    "hddm_r fcalCorrelations element",  /* tp_doc */
    0,                         /* tp_traverse */
    0,                         /* tp_clear */
    0,                         /* tp_richcompare */
    0,                         /* tp_weaklistoffset */
    0,                         /* tp_iter */
    0,                         /* tp_iternext */
    _FcalCorrelations_methods,          /* tp_methods */
    _FcalCorrelations_members,          /* tp_members */
    _FcalCorrelations_getsetters,       /* tp_getset */
    &_HDDM_Element_type,       /* tp_base */
    0,                         /* tp_dict */
    0,                         /* tp_descr_get */
    0,                         /* tp_descr_set */
    0,                         /* tp_dictoffset */
    (initproc)_FcalCorrelations_init,   /* tp_init */
    0,                         /* tp_alloc */
    _FcalCorrelations_new,              /* tp_new */
};



// wrap element class hddm_r::FcalShowerClassification as hddm_r.FcalShowerClassification

typedef struct {
   PyObject_HEAD
   FcalShowerClassification *elem;
   PyObject *host;
} _FcalShowerClassification;

static void
_FcalShowerClassification_dealloc(_FcalShowerClassification* self)
{
   if (self->elem != 0) {
      LOG_DEALLOC(Py_TYPE(self), 0, self->host == (PyObject*)self);
      if (self->host == (PyObject*)self)
         delete self->elem;
      else
         My_DECREF(self->host);
   }
   Py_TYPE(self)->tp_free((PyObject*)self);
}

static PyObject*
_FcalShowerClassification_new(PyTypeObject *type, PyObject *args, PyObject *kwds)
{
   _FcalShowerClassification *self;
   self = (_FcalShowerClassification*)type->tp_alloc(type, 0);
   if (self != NULL) {
      self->elem = 0;
      self->host = 0;
   }
   return (PyObject*)self;
}

static int
_FcalShowerClassification_init(_FcalShowerClassification *self, PyObject *args, PyObject *kwds)
{
   PyErr_SetString(PyExc_RuntimeError, "illegal constructor");
   return -1;
}

static PyObject*
_FcalShowerClassification_getClass(_FcalShowerClassification *self, void *closure)
{
   std::string val(self->elem->getClass());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_FcalShowerClassification_getVersion(_FcalShowerClassification *self, void *closure)
{
   std::string val(self->elem->getVersion());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_FcalShowerClassification_getXmlns(_FcalShowerClassification *self, void *closure)
{
   std::string val(self->elem->getXmlns());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_FcalShowerClassification_getEventNo(_FcalShowerClassification *self, void *closure)
{
   return PyLong_FromLongLong(self->elem->getEventNo());
}

static PyObject*
_FcalShowerClassification_getRunNo(_FcalShowerClassification *self, void *closure)
{
   return PyLong_FromLong(self->elem->getRunNo());
}

static PyObject*
_FcalShowerClassification_getE(_FcalShowerClassification *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getE());
}

static PyObject*
_FcalShowerClassification_getEerr(_FcalShowerClassification *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getEerr());
}

static PyObject*
_FcalShowerClassification_getEunit(_FcalShowerClassification *self, void *closure)
{
   std::string val(self->elem->getEunit());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_FcalShowerClassification_getEzcorr(_FcalShowerClassification *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getEzcorr());
}

static PyObject*
_FcalShowerClassification_getJtag(_FcalShowerClassification *self, void *closure)
{
   std::string val(self->elem->getJtag());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_FcalShowerClassification_getLunit(_FcalShowerClassification *self, void *closure)
{
   std::string val(self->elem->getLunit());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_FcalShowerClassification_getMaxOccurs(_FcalShowerClassification *self, void *closure)
{
   std::string val(self->elem->getMaxOccurs());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_FcalShowerClassification_getT(_FcalShowerClassification *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getT());
}

static PyObject*
_FcalShowerClassification_getTerr(_FcalShowerClassification *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getTerr());
}

static PyObject*
_FcalShowerClassification_getTunit(_FcalShowerClassification *self, void *closure)
{
   std::string val(self->elem->getTunit());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_FcalShowerClassification_getTzcorr(_FcalShowerClassification *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getTzcorr());
}

static PyObject*
_FcalShowerClassification_getX(_FcalShowerClassification *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getX());
}

static PyObject*
_FcalShowerClassification_getXerr(_FcalShowerClassification *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getXerr());
}

static PyObject*
_FcalShowerClassification_getXycorr(_FcalShowerClassification *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getXycorr());
}

static PyObject*
_FcalShowerClassification_getXzcorr(_FcalShowerClassification *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getXzcorr());
}

static PyObject*
_FcalShowerClassification_getY(_FcalShowerClassification *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getY());
}

static PyObject*
_FcalShowerClassification_getYerr(_FcalShowerClassification *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getYerr());
}

static PyObject*
_FcalShowerClassification_getYzcorr(_FcalShowerClassification *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getYzcorr());
}

static PyObject*
_FcalShowerClassification_getZ(_FcalShowerClassification *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getZ());
}

static PyObject*
_FcalShowerClassification_getZerr(_FcalShowerClassification *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getZerr());
}

static PyObject*
_FcalShowerClassification_getClassifierOuput(_FcalShowerClassification *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getClassifierOuput());
}

static int
_FcalShowerClassification_setClassifierOuput(_FcalShowerClassification *self, PyObject *value, void *closure)
{
   double var = PyFloat_AsDouble(value);
   if (var == -1 && PyErr_Occurred()) {
      return 1;
   }
   self->elem->setClassifierOuput((float)var);
   return 0;
}

static PyObject*
_FcalShowerClassification_getMinOccurs(_FcalShowerClassification *self, void *closure)
{
   return PyLong_FromLong(self->elem->getMinOccurs());
}

static PyObject*
_FcalShowerClassification_toString(PyObject *self, PyObject *args=0)
{
   _FcalShowerClassification *me = (_FcalShowerClassification*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid fcalShowerClassification element");
      return NULL;
   }
   std::string str(me->elem->toString());
   return PyUnicode_FromString(str.c_str());
}

static PyObject*
_FcalShowerClassification_toXML(PyObject *self, PyObject *args=0)
{
   _FcalShowerClassification *me = (_FcalShowerClassification*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid fcalShowerClassification element");
      return NULL;
   }
   std::string str(me->elem->toXML());
   return PyUnicode_FromString(str.c_str());
}

static PyGetSetDef _FcalShowerClassification_getsetters[] = {
   {(char*)"E",
    (getter)_FcalShowerClassification_getE, 0,
    (char*)"E value",
    NULL},
   {(char*)"Eerr",
    (getter)_FcalShowerClassification_getEerr, 0,
    (char*)"Eerr value",
    NULL},
   {(char*)"Eunit",
    (getter)_FcalShowerClassification_getEunit, 0,
    (char*)"Eunit string",
    NULL},
   {(char*)"Ezcorr",
    (getter)_FcalShowerClassification_getEzcorr, 0,
    (char*)"Ezcorr value",
    NULL},
   {(char*)"class",
    (getter)_FcalShowerClassification_getClass, 0,
    (char*)"class string",
    NULL},
   {(char*)"classifierOuput",
    (getter)_FcalShowerClassification_getClassifierOuput, (setter)_FcalShowerClassification_setClassifierOuput,
    (char*)"classifierOuput value",
    NULL},
   {(char*)"eventNo",
    (getter)_FcalShowerClassification_getEventNo, 0,
    (char*)"eventNo value",
    NULL},
   {(char*)"jtag",
    (getter)_FcalShowerClassification_getJtag, 0,
    (char*)"jtag string",
    NULL},
   {(char*)"lunit",
    (getter)_FcalShowerClassification_getLunit, 0,
    (char*)"lunit string",
    NULL},
   {(char*)"maxOccurs",
    (getter)_FcalShowerClassification_getMaxOccurs, 0,
    (char*)"maxOccurs string",
    NULL},
   {(char*)"minOccurs",
    (getter)_FcalShowerClassification_getMinOccurs, 0,
    (char*)"minOccurs value",
    NULL},
   {(char*)"runNo",
    (getter)_FcalShowerClassification_getRunNo, 0,
    (char*)"runNo value",
    NULL},
   {(char*)"t",
    (getter)_FcalShowerClassification_getT, 0,
    (char*)"t value",
    NULL},
   {(char*)"terr",
    (getter)_FcalShowerClassification_getTerr, 0,
    (char*)"terr value",
    NULL},
   {(char*)"tunit",
    (getter)_FcalShowerClassification_getTunit, 0,
    (char*)"tunit string",
    NULL},
   {(char*)"tzcorr",
    (getter)_FcalShowerClassification_getTzcorr, 0,
    (char*)"tzcorr value",
    NULL},
   {(char*)"version",
    (getter)_FcalShowerClassification_getVersion, 0,
    (char*)"version string",
    NULL},
   {(char*)"x",
    (getter)_FcalShowerClassification_getX, 0,
    (char*)"x value",
    NULL},
   {(char*)"xerr",
    (getter)_FcalShowerClassification_getXerr, 0,
    (char*)"xerr value",
    NULL},
   {(char*)"xmlns",
    (getter)_FcalShowerClassification_getXmlns, 0,
    (char*)"xmlns string",
    NULL},
   {(char*)"xycorr",
    (getter)_FcalShowerClassification_getXycorr, 0,
    (char*)"xycorr value",
    NULL},
   {(char*)"xzcorr",
    (getter)_FcalShowerClassification_getXzcorr, 0,
    (char*)"xzcorr value",
    NULL},
   {(char*)"y",
    (getter)_FcalShowerClassification_getY, 0,
    (char*)"y value",
    NULL},
   {(char*)"yerr",
    (getter)_FcalShowerClassification_getYerr, 0,
    (char*)"yerr value",
    NULL},
   {(char*)"yzcorr",
    (getter)_FcalShowerClassification_getYzcorr, 0,
    (char*)"yzcorr value",
    NULL},
   {(char*)"z",
    (getter)_FcalShowerClassification_getZ, 0,
    (char*)"z value",
    NULL},
   {(char*)"zerr",
    (getter)_FcalShowerClassification_getZerr, 0,
    (char*)"zerr value",
    NULL},
   {NULL}  /* Sentinel */
};

static PyMemberDef _FcalShowerClassification_members[] = {
   {NULL}  /* Sentinel */
};

static PyMethodDef _FcalShowerClassification_methods[] = {
   {"toString", _FcalShowerClassification_toString, METH_NOARGS,
    "show element as a human-readable string"},
   {"toXML", _FcalShowerClassification_toXML, METH_NOARGS,
    "show element as a XML fragment"},
   {NULL}  /* Sentinel */
};

static PyTypeObject _FcalShowerClassification_type = {
    PyVarObject_HEAD_INIT(NULL,0)
    "hddm_r.FcalShowerClassification",         /*tp_name*/
    sizeof(_FcalShowerClassification),          /*tp_basicsize*/
    0,                         /*tp_itemsize*/
    (destructor)_FcalShowerClassification_dealloc, /*tp_dealloc*/
    0,                         /*tp_print*/
    0,                         /*tp_getattr*/
    0,                         /*tp_setattr*/
    0,                         /*tp_compare*/
    0,                         /*tp_repr*/
    0,                         /*tp_as_number*/
    0,                         /*tp_as_sequence*/
    0,                         /*tp_as_mapping*/
    0,                         /*tp_hash */
    0,                         /*tp_call*/
    (reprfunc)_FcalShowerClassification_toString,         /*tp_str*/
    0,                         /*tp_getattro*/
    0,                         /*tp_setattro*/
    0,                         /*tp_as_buffer*/
    Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE, /*tp_flags*/
    "hddm_r fcalShowerClassification element",  /* tp_doc */
    0,                         /* tp_traverse */
    0,                         /* tp_clear */
    0,                         /* tp_richcompare */
    0,                         /* tp_weaklistoffset */
    0,                         /* tp_iter */
    0,                         /* tp_iternext */
    _FcalShowerClassification_methods,          /* tp_methods */
    _FcalShowerClassification_members,          /* tp_members */
    _FcalShowerClassification_getsetters,       /* tp_getset */
    &_HDDM_Element_type,       /* tp_base */
    0,                         /* tp_dict */
    0,                         /* tp_descr_get */
    0,                         /* tp_descr_set */
    0,                         /* tp_dictoffset */
    (initproc)_FcalShowerClassification_init,   /* tp_init */
    0,                         /* tp_alloc */
    _FcalShowerClassification_new,              /* tp_new */
};



// wrap element class hddm_r::FcalShowerProperties as hddm_r.FcalShowerProperties

typedef struct {
   PyObject_HEAD
   FcalShowerProperties *elem;
   PyObject *host;
} _FcalShowerProperties;

static void
_FcalShowerProperties_dealloc(_FcalShowerProperties* self)
{
   if (self->elem != 0) {
      LOG_DEALLOC(Py_TYPE(self), 0, self->host == (PyObject*)self);
      if (self->host == (PyObject*)self)
         delete self->elem;
      else
         My_DECREF(self->host);
   }
   Py_TYPE(self)->tp_free((PyObject*)self);
}

static PyObject*
_FcalShowerProperties_new(PyTypeObject *type, PyObject *args, PyObject *kwds)
{
   _FcalShowerProperties *self;
   self = (_FcalShowerProperties*)type->tp_alloc(type, 0);
   if (self != NULL) {
      self->elem = 0;
      self->host = 0;
   }
   return (PyObject*)self;
}

static int
_FcalShowerProperties_init(_FcalShowerProperties *self, PyObject *args, PyObject *kwds)
{
   PyErr_SetString(PyExc_RuntimeError, "illegal constructor");
   return -1;
}

static PyObject*
_FcalShowerProperties_getClass(_FcalShowerProperties *self, void *closure)
{
   std::string val(self->elem->getClass());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_FcalShowerProperties_getVersion(_FcalShowerProperties *self, void *closure)
{
   std::string val(self->elem->getVersion());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_FcalShowerProperties_getXmlns(_FcalShowerProperties *self, void *closure)
{
   std::string val(self->elem->getXmlns());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_FcalShowerProperties_getEventNo(_FcalShowerProperties *self, void *closure)
{
   return PyLong_FromLongLong(self->elem->getEventNo());
}

static PyObject*
_FcalShowerProperties_getRunNo(_FcalShowerProperties *self, void *closure)
{
   return PyLong_FromLong(self->elem->getRunNo());
}

static PyObject*
_FcalShowerProperties_getE(_FcalShowerProperties *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getE());
}

static PyObject*
_FcalShowerProperties_getEerr(_FcalShowerProperties *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getEerr());
}

static PyObject*
_FcalShowerProperties_getEunit(_FcalShowerProperties *self, void *closure)
{
   std::string val(self->elem->getEunit());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_FcalShowerProperties_getEzcorr(_FcalShowerProperties *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getEzcorr());
}

static PyObject*
_FcalShowerProperties_getJtag(_FcalShowerProperties *self, void *closure)
{
   std::string val(self->elem->getJtag());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_FcalShowerProperties_getLunit(_FcalShowerProperties *self, void *closure)
{
   std::string val(self->elem->getLunit());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_FcalShowerProperties_getT(_FcalShowerProperties *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getT());
}

static PyObject*
_FcalShowerProperties_getTerr(_FcalShowerProperties *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getTerr());
}

static PyObject*
_FcalShowerProperties_getTunit(_FcalShowerProperties *self, void *closure)
{
   std::string val(self->elem->getTunit());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_FcalShowerProperties_getTzcorr(_FcalShowerProperties *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getTzcorr());
}

static PyObject*
_FcalShowerProperties_getX(_FcalShowerProperties *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getX());
}

static PyObject*
_FcalShowerProperties_getXerr(_FcalShowerProperties *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getXerr());
}

static PyObject*
_FcalShowerProperties_getXycorr(_FcalShowerProperties *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getXycorr());
}

static PyObject*
_FcalShowerProperties_getXzcorr(_FcalShowerProperties *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getXzcorr());
}

static PyObject*
_FcalShowerProperties_getY(_FcalShowerProperties *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getY());
}

static PyObject*
_FcalShowerProperties_getYerr(_FcalShowerProperties *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getYerr());
}

static PyObject*
_FcalShowerProperties_getYzcorr(_FcalShowerProperties *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getYzcorr());
}

static PyObject*
_FcalShowerProperties_getZ(_FcalShowerProperties *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getZ());
}

static PyObject*
_FcalShowerProperties_getZerr(_FcalShowerProperties *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getZerr());
}

static PyObject*
_FcalShowerProperties_getE1E9(_FcalShowerProperties *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getE1E9());
}

static int
_FcalShowerProperties_setE1E9(_FcalShowerProperties *self, PyObject *value, void *closure)
{
   double var = PyFloat_AsDouble(value);
   if (var == -1 && PyErr_Occurred()) {
      return 1;
   }
   self->elem->setE1E9((float)var);
   return 0;
}

static PyObject*
_FcalShowerProperties_getE9E25(_FcalShowerProperties *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getE9E25());
}

static int
_FcalShowerProperties_setE9E25(_FcalShowerProperties *self, PyObject *value, void *closure)
{
   double var = PyFloat_AsDouble(value);
   if (var == -1 && PyErr_Occurred()) {
      return 1;
   }
   self->elem->setE9E25((float)var);
   return 0;
}

static PyObject*
_FcalShowerProperties_getDocaTrack(_FcalShowerProperties *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getDocaTrack());
}

static int
_FcalShowerProperties_setDocaTrack(_FcalShowerProperties *self, PyObject *value, void *closure)
{
   double var = PyFloat_AsDouble(value);
   if (var == -1 && PyErr_Occurred()) {
      return 1;
   }
   self->elem->setDocaTrack((float)var);
   return 0;
}

static PyObject*
_FcalShowerProperties_getMaxOccurs(_FcalShowerProperties *self, void *closure)
{
   return PyLong_FromLong(self->elem->getMaxOccurs());
}

static PyObject*
_FcalShowerProperties_getMinOccurs(_FcalShowerProperties *self, void *closure)
{
   return PyLong_FromLong(self->elem->getMinOccurs());
}

static PyObject*
_FcalShowerProperties_getSumU(_FcalShowerProperties *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getSumU());
}

static int
_FcalShowerProperties_setSumU(_FcalShowerProperties *self, PyObject *value, void *closure)
{
   double var = PyFloat_AsDouble(value);
   if (var == -1 && PyErr_Occurred()) {
      return 1;
   }
   self->elem->setSumU((float)var);
   return 0;
}

static PyObject*
_FcalShowerProperties_getSumV(_FcalShowerProperties *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getSumV());
}

static int
_FcalShowerProperties_setSumV(_FcalShowerProperties *self, PyObject *value, void *closure)
{
   double var = PyFloat_AsDouble(value);
   if (var == -1 && PyErr_Occurred()) {
      return 1;
   }
   self->elem->setSumV((float)var);
   return 0;
}

static PyObject*
_FcalShowerProperties_getTimeTrack(_FcalShowerProperties *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getTimeTrack());
}

static int
_FcalShowerProperties_setTimeTrack(_FcalShowerProperties *self, PyObject *value, void *closure)
{
   double var = PyFloat_AsDouble(value);
   if (var == -1 && PyErr_Occurred()) {
      return 1;
   }
   self->elem->setTimeTrack((float)var);
   return 0;
}

static PyObject*
_FcalShowerProperties_toString(PyObject *self, PyObject *args=0)
{
   _FcalShowerProperties *me = (_FcalShowerProperties*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid fcalShowerProperties element");
      return NULL;
   }
   std::string str(me->elem->toString());
   return PyUnicode_FromString(str.c_str());
}

static PyObject*
_FcalShowerProperties_toXML(PyObject *self, PyObject *args=0)
{
   _FcalShowerProperties *me = (_FcalShowerProperties*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid fcalShowerProperties element");
      return NULL;
   }
   std::string str(me->elem->toXML());
   return PyUnicode_FromString(str.c_str());
}

static PyGetSetDef _FcalShowerProperties_getsetters[] = {
   {(char*)"E",
    (getter)_FcalShowerProperties_getE, 0,
    (char*)"E value",
    NULL},
   {(char*)"E1E9",
    (getter)_FcalShowerProperties_getE1E9, (setter)_FcalShowerProperties_setE1E9,
    (char*)"E1E9 value",
    NULL},
   {(char*)"E9E25",
    (getter)_FcalShowerProperties_getE9E25, (setter)_FcalShowerProperties_setE9E25,
    (char*)"E9E25 value",
    NULL},
   {(char*)"Eerr",
    (getter)_FcalShowerProperties_getEerr, 0,
    (char*)"Eerr value",
    NULL},
   {(char*)"Eunit",
    (getter)_FcalShowerProperties_getEunit, 0,
    (char*)"Eunit string",
    NULL},
   {(char*)"Ezcorr",
    (getter)_FcalShowerProperties_getEzcorr, 0,
    (char*)"Ezcorr value",
    NULL},
   {(char*)"class",
    (getter)_FcalShowerProperties_getClass, 0,
    (char*)"class string",
    NULL},
   {(char*)"docaTrack",
    (getter)_FcalShowerProperties_getDocaTrack, (setter)_FcalShowerProperties_setDocaTrack,
    (char*)"docaTrack value",
    NULL},
   {(char*)"eventNo",
    (getter)_FcalShowerProperties_getEventNo, 0,
    (char*)"eventNo value",
    NULL},
   {(char*)"jtag",
    (getter)_FcalShowerProperties_getJtag, 0,
    (char*)"jtag string",
    NULL},
   {(char*)"lunit",
    (getter)_FcalShowerProperties_getLunit, 0,
    (char*)"lunit string",
    NULL},
   {(char*)"maxOccurs",
    (getter)_FcalShowerProperties_getMaxOccurs, 0,
    (char*)"maxOccurs value",
    NULL},
   {(char*)"minOccurs",
    (getter)_FcalShowerProperties_getMinOccurs, 0,
    (char*)"minOccurs value",
    NULL},
   {(char*)"runNo",
    (getter)_FcalShowerProperties_getRunNo, 0,
    (char*)"runNo value",
    NULL},
   {(char*)"sumU",
    (getter)_FcalShowerProperties_getSumU, (setter)_FcalShowerProperties_setSumU,
    (char*)"sumU value",
    NULL},
   {(char*)"sumV",
    (getter)_FcalShowerProperties_getSumV, (setter)_FcalShowerProperties_setSumV,
    (char*)"sumV value",
    NULL},
   {(char*)"t",
    (getter)_FcalShowerProperties_getT, 0,
    (char*)"t value",
    NULL},
   {(char*)"terr",
    (getter)_FcalShowerProperties_getTerr, 0,
    (char*)"terr value",
    NULL},
   {(char*)"timeTrack",
    (getter)_FcalShowerProperties_getTimeTrack, (setter)_FcalShowerProperties_setTimeTrack,
    (char*)"timeTrack value",
    NULL},
   {(char*)"tunit",
    (getter)_FcalShowerProperties_getTunit, 0,
    (char*)"tunit string",
    NULL},
   {(char*)"tzcorr",
    (getter)_FcalShowerProperties_getTzcorr, 0,
    (char*)"tzcorr value",
    NULL},
   {(char*)"version",
    (getter)_FcalShowerProperties_getVersion, 0,
    (char*)"version string",
    NULL},
   {(char*)"x",
    (getter)_FcalShowerProperties_getX, 0,
    (char*)"x value",
    NULL},
   {(char*)"xerr",
    (getter)_FcalShowerProperties_getXerr, 0,
    (char*)"xerr value",
    NULL},
   {(char*)"xmlns",
    (getter)_FcalShowerProperties_getXmlns, 0,
    (char*)"xmlns string",
    NULL},
   {(char*)"xycorr",
    (getter)_FcalShowerProperties_getXycorr, 0,
    (char*)"xycorr value",
    NULL},
   {(char*)"xzcorr",
    (getter)_FcalShowerProperties_getXzcorr, 0,
    (char*)"xzcorr value",
    NULL},
   {(char*)"y",
    (getter)_FcalShowerProperties_getY, 0,
    (char*)"y value",
    NULL},
   {(char*)"yerr",
    (getter)_FcalShowerProperties_getYerr, 0,
    (char*)"yerr value",
    NULL},
   {(char*)"yzcorr",
    (getter)_FcalShowerProperties_getYzcorr, 0,
    (char*)"yzcorr value",
    NULL},
   {(char*)"z",
    (getter)_FcalShowerProperties_getZ, 0,
    (char*)"z value",
    NULL},
   {(char*)"zerr",
    (getter)_FcalShowerProperties_getZerr, 0,
    (char*)"zerr value",
    NULL},
   {NULL}  /* Sentinel */
};

static PyMemberDef _FcalShowerProperties_members[] = {
   {NULL}  /* Sentinel */
};

static PyMethodDef _FcalShowerProperties_methods[] = {
   {"toString", _FcalShowerProperties_toString, METH_NOARGS,
    "show element as a human-readable string"},
   {"toXML", _FcalShowerProperties_toXML, METH_NOARGS,
    "show element as a XML fragment"},
   {NULL}  /* Sentinel */
};

static PyTypeObject _FcalShowerProperties_type = {
    PyVarObject_HEAD_INIT(NULL,0)
    "hddm_r.FcalShowerProperties",         /*tp_name*/
    sizeof(_FcalShowerProperties),          /*tp_basicsize*/
    0,                         /*tp_itemsize*/
    (destructor)_FcalShowerProperties_dealloc, /*tp_dealloc*/
    0,                         /*tp_print*/
    0,                         /*tp_getattr*/
    0,                         /*tp_setattr*/
    0,                         /*tp_compare*/
    0,                         /*tp_repr*/
    0,                         /*tp_as_number*/
    0,                         /*tp_as_sequence*/
    0,                         /*tp_as_mapping*/
    0,                         /*tp_hash */
    0,                         /*tp_call*/
    (reprfunc)_FcalShowerProperties_toString,         /*tp_str*/
    0,                         /*tp_getattro*/
    0,                         /*tp_setattro*/
    0,                         /*tp_as_buffer*/
    Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE, /*tp_flags*/
    "hddm_r fcalShowerProperties element",  /* tp_doc */
    0,                         /* tp_traverse */
    0,                         /* tp_clear */
    0,                         /* tp_richcompare */
    0,                         /* tp_weaklistoffset */
    0,                         /* tp_iter */
    0,                         /* tp_iternext */
    _FcalShowerProperties_methods,          /* tp_methods */
    _FcalShowerProperties_members,          /* tp_members */
    _FcalShowerProperties_getsetters,       /* tp_getset */
    &_HDDM_Element_type,       /* tp_base */
    0,                         /* tp_dict */
    0,                         /* tp_descr_get */
    0,                         /* tp_descr_set */
    0,                         /* tp_dictoffset */
    (initproc)_FcalShowerProperties_init,   /* tp_init */
    0,                         /* tp_alloc */
    _FcalShowerProperties_new,              /* tp_new */
};



// wrap element class hddm_r::FcalShowerNBlocks as hddm_r.FcalShowerNBlocks

typedef struct {
   PyObject_HEAD
   FcalShowerNBlocks *elem;
   PyObject *host;
} _FcalShowerNBlocks;

static void
_FcalShowerNBlocks_dealloc(_FcalShowerNBlocks* self)
{
   if (self->elem != 0) {
      LOG_DEALLOC(Py_TYPE(self), 0, self->host == (PyObject*)self);
      if (self->host == (PyObject*)self)
         delete self->elem;
      else
         My_DECREF(self->host);
   }
   Py_TYPE(self)->tp_free((PyObject*)self);
}

static PyObject*
_FcalShowerNBlocks_new(PyTypeObject *type, PyObject *args, PyObject *kwds)
{
   _FcalShowerNBlocks *self;
   self = (_FcalShowerNBlocks*)type->tp_alloc(type, 0);
   if (self != NULL) {
      self->elem = 0;
      self->host = 0;
   }
   return (PyObject*)self;
}

static int
_FcalShowerNBlocks_init(_FcalShowerNBlocks *self, PyObject *args, PyObject *kwds)
{
   PyErr_SetString(PyExc_RuntimeError, "illegal constructor");
   return -1;
}

static PyObject*
_FcalShowerNBlocks_getClass(_FcalShowerNBlocks *self, void *closure)
{
   std::string val(self->elem->getClass());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_FcalShowerNBlocks_getVersion(_FcalShowerNBlocks *self, void *closure)
{
   std::string val(self->elem->getVersion());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_FcalShowerNBlocks_getXmlns(_FcalShowerNBlocks *self, void *closure)
{
   std::string val(self->elem->getXmlns());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_FcalShowerNBlocks_getEventNo(_FcalShowerNBlocks *self, void *closure)
{
   return PyLong_FromLongLong(self->elem->getEventNo());
}

static PyObject*
_FcalShowerNBlocks_getRunNo(_FcalShowerNBlocks *self, void *closure)
{
   return PyLong_FromLong(self->elem->getRunNo());
}

static PyObject*
_FcalShowerNBlocks_getE(_FcalShowerNBlocks *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getE());
}

static PyObject*
_FcalShowerNBlocks_getEerr(_FcalShowerNBlocks *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getEerr());
}

static PyObject*
_FcalShowerNBlocks_getEunit(_FcalShowerNBlocks *self, void *closure)
{
   std::string val(self->elem->getEunit());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_FcalShowerNBlocks_getEzcorr(_FcalShowerNBlocks *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getEzcorr());
}

static PyObject*
_FcalShowerNBlocks_getJtag(_FcalShowerNBlocks *self, void *closure)
{
   std::string val(self->elem->getJtag());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_FcalShowerNBlocks_getLunit(_FcalShowerNBlocks *self, void *closure)
{
   std::string val(self->elem->getLunit());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_FcalShowerNBlocks_getMaxOccurs(_FcalShowerNBlocks *self, void *closure)
{
   std::string val(self->elem->getMaxOccurs());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_FcalShowerNBlocks_getT(_FcalShowerNBlocks *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getT());
}

static PyObject*
_FcalShowerNBlocks_getTerr(_FcalShowerNBlocks *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getTerr());
}

static PyObject*
_FcalShowerNBlocks_getTunit(_FcalShowerNBlocks *self, void *closure)
{
   std::string val(self->elem->getTunit());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_FcalShowerNBlocks_getTzcorr(_FcalShowerNBlocks *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getTzcorr());
}

static PyObject*
_FcalShowerNBlocks_getX(_FcalShowerNBlocks *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getX());
}

static PyObject*
_FcalShowerNBlocks_getXerr(_FcalShowerNBlocks *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getXerr());
}

static PyObject*
_FcalShowerNBlocks_getXycorr(_FcalShowerNBlocks *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getXycorr());
}

static PyObject*
_FcalShowerNBlocks_getXzcorr(_FcalShowerNBlocks *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getXzcorr());
}

static PyObject*
_FcalShowerNBlocks_getY(_FcalShowerNBlocks *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getY());
}

static PyObject*
_FcalShowerNBlocks_getYerr(_FcalShowerNBlocks *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getYerr());
}

static PyObject*
_FcalShowerNBlocks_getYzcorr(_FcalShowerNBlocks *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getYzcorr());
}

static PyObject*
_FcalShowerNBlocks_getZ(_FcalShowerNBlocks *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getZ());
}

static PyObject*
_FcalShowerNBlocks_getZerr(_FcalShowerNBlocks *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getZerr());
}

static PyObject*
_FcalShowerNBlocks_getMinOccurs(_FcalShowerNBlocks *self, void *closure)
{
   return PyLong_FromLong(self->elem->getMinOccurs());
}

static PyObject*
_FcalShowerNBlocks_getNumBlocks(_FcalShowerNBlocks *self, void *closure)
{
   return PyLong_FromLong(self->elem->getNumBlocks());
}

static int
_FcalShowerNBlocks_setNumBlocks(_FcalShowerNBlocks *self, PyObject *value, void *closure)
{
   long var = PyInt_AsLong(value);
   if (var == -1 && PyErr_Occurred()) {
      return -1;
   }
   self->elem->setNumBlocks(var);
   return 0;
}

static PyObject*
_FcalShowerNBlocks_toString(PyObject *self, PyObject *args=0)
{
   _FcalShowerNBlocks *me = (_FcalShowerNBlocks*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid fcalShowerNBlocks element");
      return NULL;
   }
   std::string str(me->elem->toString());
   return PyUnicode_FromString(str.c_str());
}

static PyObject*
_FcalShowerNBlocks_toXML(PyObject *self, PyObject *args=0)
{
   _FcalShowerNBlocks *me = (_FcalShowerNBlocks*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid fcalShowerNBlocks element");
      return NULL;
   }
   std::string str(me->elem->toXML());
   return PyUnicode_FromString(str.c_str());
}

static PyGetSetDef _FcalShowerNBlocks_getsetters[] = {
   {(char*)"E",
    (getter)_FcalShowerNBlocks_getE, 0,
    (char*)"E value",
    NULL},
   {(char*)"Eerr",
    (getter)_FcalShowerNBlocks_getEerr, 0,
    (char*)"Eerr value",
    NULL},
   {(char*)"Eunit",
    (getter)_FcalShowerNBlocks_getEunit, 0,
    (char*)"Eunit string",
    NULL},
   {(char*)"Ezcorr",
    (getter)_FcalShowerNBlocks_getEzcorr, 0,
    (char*)"Ezcorr value",
    NULL},
   {(char*)"class",
    (getter)_FcalShowerNBlocks_getClass, 0,
    (char*)"class string",
    NULL},
   {(char*)"eventNo",
    (getter)_FcalShowerNBlocks_getEventNo, 0,
    (char*)"eventNo value",
    NULL},
   {(char*)"jtag",
    (getter)_FcalShowerNBlocks_getJtag, 0,
    (char*)"jtag string",
    NULL},
   {(char*)"lunit",
    (getter)_FcalShowerNBlocks_getLunit, 0,
    (char*)"lunit string",
    NULL},
   {(char*)"maxOccurs",
    (getter)_FcalShowerNBlocks_getMaxOccurs, 0,
    (char*)"maxOccurs string",
    NULL},
   {(char*)"minOccurs",
    (getter)_FcalShowerNBlocks_getMinOccurs, 0,
    (char*)"minOccurs value",
    NULL},
   {(char*)"numBlocks",
    (getter)_FcalShowerNBlocks_getNumBlocks, (setter)_FcalShowerNBlocks_setNumBlocks,
    (char*)"numBlocks value",
    NULL},
   {(char*)"runNo",
    (getter)_FcalShowerNBlocks_getRunNo, 0,
    (char*)"runNo value",
    NULL},
   {(char*)"t",
    (getter)_FcalShowerNBlocks_getT, 0,
    (char*)"t value",
    NULL},
   {(char*)"terr",
    (getter)_FcalShowerNBlocks_getTerr, 0,
    (char*)"terr value",
    NULL},
   {(char*)"tunit",
    (getter)_FcalShowerNBlocks_getTunit, 0,
    (char*)"tunit string",
    NULL},
   {(char*)"tzcorr",
    (getter)_FcalShowerNBlocks_getTzcorr, 0,
    (char*)"tzcorr value",
    NULL},
   {(char*)"version",
    (getter)_FcalShowerNBlocks_getVersion, 0,
    (char*)"version string",
    NULL},
   {(char*)"x",
    (getter)_FcalShowerNBlocks_getX, 0,
    (char*)"x value",
    NULL},
   {(char*)"xerr",
    (getter)_FcalShowerNBlocks_getXerr, 0,
    (char*)"xerr value",
    NULL},
   {(char*)"xmlns",
    (getter)_FcalShowerNBlocks_getXmlns, 0,
    (char*)"xmlns string",
    NULL},
   {(char*)"xycorr",
    (getter)_FcalShowerNBlocks_getXycorr, 0,
    (char*)"xycorr value",
    NULL},
   {(char*)"xzcorr",
    (getter)_FcalShowerNBlocks_getXzcorr, 0,
    (char*)"xzcorr value",
    NULL},
   {(char*)"y",
    (getter)_FcalShowerNBlocks_getY, 0,
    (char*)"y value",
    NULL},
   {(char*)"yerr",
    (getter)_FcalShowerNBlocks_getYerr, 0,
    (char*)"yerr value",
    NULL},
   {(char*)"yzcorr",
    (getter)_FcalShowerNBlocks_getYzcorr, 0,
    (char*)"yzcorr value",
    NULL},
   {(char*)"z",
    (getter)_FcalShowerNBlocks_getZ, 0,
    (char*)"z value",
    NULL},
   {(char*)"zerr",
    (getter)_FcalShowerNBlocks_getZerr, 0,
    (char*)"zerr value",
    NULL},
   {NULL}  /* Sentinel */
};

static PyMemberDef _FcalShowerNBlocks_members[] = {
   {NULL}  /* Sentinel */
};

static PyMethodDef _FcalShowerNBlocks_methods[] = {
   {"toString", _FcalShowerNBlocks_toString, METH_NOARGS,
    "show element as a human-readable string"},
   {"toXML", _FcalShowerNBlocks_toXML, METH_NOARGS,
    "show element as a XML fragment"},
   {NULL}  /* Sentinel */
};

static PyTypeObject _FcalShowerNBlocks_type = {
    PyVarObject_HEAD_INIT(NULL,0)
    "hddm_r.FcalShowerNBlocks",         /*tp_name*/
    sizeof(_FcalShowerNBlocks),          /*tp_basicsize*/
    0,                         /*tp_itemsize*/
    (destructor)_FcalShowerNBlocks_dealloc, /*tp_dealloc*/
    0,                         /*tp_print*/
    0,                         /*tp_getattr*/
    0,                         /*tp_setattr*/
    0,                         /*tp_compare*/
    0,                         /*tp_repr*/
    0,                         /*tp_as_number*/
    0,                         /*tp_as_sequence*/
    0,                         /*tp_as_mapping*/
    0,                         /*tp_hash */
    0,                         /*tp_call*/
    (reprfunc)_FcalShowerNBlocks_toString,         /*tp_str*/
    0,                         /*tp_getattro*/
    0,                         /*tp_setattro*/
    0,                         /*tp_as_buffer*/
    Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE, /*tp_flags*/
    "hddm_r fcalShowerNBlocks element",  /* tp_doc */
    0,                         /* tp_traverse */
    0,                         /* tp_clear */
    0,                         /* tp_richcompare */
    0,                         /* tp_weaklistoffset */
    0,                         /* tp_iter */
    0,                         /* tp_iternext */
    _FcalShowerNBlocks_methods,          /* tp_methods */
    _FcalShowerNBlocks_members,          /* tp_members */
    _FcalShowerNBlocks_getsetters,       /* tp_getset */
    &_HDDM_Element_type,       /* tp_base */
    0,                         /* tp_dict */
    0,                         /* tp_descr_get */
    0,                         /* tp_descr_set */
    0,                         /* tp_dictoffset */
    (initproc)_FcalShowerNBlocks_init,   /* tp_init */
    0,                         /* tp_alloc */
    _FcalShowerNBlocks_new,              /* tp_new */
};



// wrap element class hddm_r::FcalShower as hddm_r.FcalShower

typedef struct {
   PyObject_HEAD
   FcalShower *elem;
   PyObject *host;
} _FcalShower;

static void
_FcalShower_dealloc(_FcalShower* self)
{
   if (self->elem != 0) {
      LOG_DEALLOC(Py_TYPE(self), 0, self->host == (PyObject*)self);
      if (self->host == (PyObject*)self)
         delete self->elem;
      else
         My_DECREF(self->host);
   }
   Py_TYPE(self)->tp_free((PyObject*)self);
}

static PyObject*
_FcalShower_new(PyTypeObject *type, PyObject *args, PyObject *kwds)
{
   _FcalShower *self;
   self = (_FcalShower*)type->tp_alloc(type, 0);
   if (self != NULL) {
      self->elem = 0;
      self->host = 0;
   }
   return (PyObject*)self;
}

static int
_FcalShower_init(_FcalShower *self, PyObject *args, PyObject *kwds)
{
   PyErr_SetString(PyExc_RuntimeError, "illegal constructor");
   return -1;
}

static PyObject*
_FcalShower_getClass(_FcalShower *self, void *closure)
{
   std::string val(self->elem->getClass());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_FcalShower_getVersion(_FcalShower *self, void *closure)
{
   std::string val(self->elem->getVersion());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_FcalShower_getXmlns(_FcalShower *self, void *closure)
{
   std::string val(self->elem->getXmlns());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_FcalShower_getEventNo(_FcalShower *self, void *closure)
{
   return PyLong_FromLongLong(self->elem->getEventNo());
}

static PyObject*
_FcalShower_getRunNo(_FcalShower *self, void *closure)
{
   return PyLong_FromLong(self->elem->getRunNo());
}

static PyObject*
_FcalShower_getE(_FcalShower *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getE());
}

static int
_FcalShower_setE(_FcalShower *self, PyObject *value, void *closure)
{
   double var = PyFloat_AsDouble(value);
   if (var == -1 && PyErr_Occurred()) {
      return 1;
   }
   self->elem->setE((float)var);
   return 0;
}

static PyObject*
_FcalShower_getEerr(_FcalShower *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getEerr());
}

static int
_FcalShower_setEerr(_FcalShower *self, PyObject *value, void *closure)
{
   double var = PyFloat_AsDouble(value);
   if (var == -1 && PyErr_Occurred()) {
      return 1;
   }
   self->elem->setEerr((float)var);
   return 0;
}

static PyObject*
_FcalShower_getEunit(_FcalShower *self, void *closure)
{
   std::string val(self->elem->getEunit());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_FcalShower_getEzcorr(_FcalShower *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getEzcorr());
}

static int
_FcalShower_setEzcorr(_FcalShower *self, PyObject *value, void *closure)
{
   double var = PyFloat_AsDouble(value);
   if (var == -1 && PyErr_Occurred()) {
      return 1;
   }
   self->elem->setEzcorr((float)var);
   return 0;
}

static PyObject*
_FcalShower_getJtag(_FcalShower *self, void *closure)
{
   std::string val(self->elem->getJtag());
   return PyUnicode_FromString(val.c_str());
}

static int
_FcalShower_setJtag(_FcalShower *self, PyObject *value, void *closure)
{
   PyObject *str=0;
   if (PyUnicode_Check(value))
      str = PyUnicode_AsEncodedString(value, "ASCII", "strict");
   else
      str = value;
#if PY_MAJOR_VERSION < 3
   char *var = PyString_AsString(str);
#else
   char *var = PyBytes_AsString(str);
#endif
   if (var == 0) {
      return -1;
   }
   self->elem->setJtag(std::string(var));
   if (str != value) {
      Py_DECREF(str);
   }
   return 0;
}

static PyObject*
_FcalShower_getLunit(_FcalShower *self, void *closure)
{
   std::string val(self->elem->getLunit());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_FcalShower_getMaxOccurs(_FcalShower *self, void *closure)
{
   std::string val(self->elem->getMaxOccurs());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_FcalShower_getMinOccurs(_FcalShower *self, void *closure)
{
   return PyLong_FromLong(self->elem->getMinOccurs());
}

static PyObject*
_FcalShower_getT(_FcalShower *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getT());
}

static int
_FcalShower_setT(_FcalShower *self, PyObject *value, void *closure)
{
   double var = PyFloat_AsDouble(value);
   if (var == -1 && PyErr_Occurred()) {
      return 1;
   }
   self->elem->setT((float)var);
   return 0;
}

static PyObject*
_FcalShower_getTerr(_FcalShower *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getTerr());
}

static int
_FcalShower_setTerr(_FcalShower *self, PyObject *value, void *closure)
{
   double var = PyFloat_AsDouble(value);
   if (var == -1 && PyErr_Occurred()) {
      return 1;
   }
   self->elem->setTerr((float)var);
   return 0;
}

static PyObject*
_FcalShower_getTunit(_FcalShower *self, void *closure)
{
   std::string val(self->elem->getTunit());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_FcalShower_getTzcorr(_FcalShower *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getTzcorr());
}

static int
_FcalShower_setTzcorr(_FcalShower *self, PyObject *value, void *closure)
{
   double var = PyFloat_AsDouble(value);
   if (var == -1 && PyErr_Occurred()) {
      return 1;
   }
   self->elem->setTzcorr((float)var);
   return 0;
}

static PyObject*
_FcalShower_getX(_FcalShower *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getX());
}

static int
_FcalShower_setX(_FcalShower *self, PyObject *value, void *closure)
{
   double var = PyFloat_AsDouble(value);
   if (var == -1 && PyErr_Occurred()) {
      return 1;
   }
   self->elem->setX((float)var);
   return 0;
}

static PyObject*
_FcalShower_getXerr(_FcalShower *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getXerr());
}

static int
_FcalShower_setXerr(_FcalShower *self, PyObject *value, void *closure)
{
   double var = PyFloat_AsDouble(value);
   if (var == -1 && PyErr_Occurred()) {
      return 1;
   }
   self->elem->setXerr((float)var);
   return 0;
}

static PyObject*
_FcalShower_getXycorr(_FcalShower *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getXycorr());
}

static int
_FcalShower_setXycorr(_FcalShower *self, PyObject *value, void *closure)
{
   double var = PyFloat_AsDouble(value);
   if (var == -1 && PyErr_Occurred()) {
      return 1;
   }
   self->elem->setXycorr((float)var);
   return 0;
}

static PyObject*
_FcalShower_getXzcorr(_FcalShower *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getXzcorr());
}

static int
_FcalShower_setXzcorr(_FcalShower *self, PyObject *value, void *closure)
{
   double var = PyFloat_AsDouble(value);
   if (var == -1 && PyErr_Occurred()) {
      return 1;
   }
   self->elem->setXzcorr((float)var);
   return 0;
}

static PyObject*
_FcalShower_getY(_FcalShower *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getY());
}

static int
_FcalShower_setY(_FcalShower *self, PyObject *value, void *closure)
{
   double var = PyFloat_AsDouble(value);
   if (var == -1 && PyErr_Occurred()) {
      return 1;
   }
   self->elem->setY((float)var);
   return 0;
}

static PyObject*
_FcalShower_getYerr(_FcalShower *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getYerr());
}

static int
_FcalShower_setYerr(_FcalShower *self, PyObject *value, void *closure)
{
   double var = PyFloat_AsDouble(value);
   if (var == -1 && PyErr_Occurred()) {
      return 1;
   }
   self->elem->setYerr((float)var);
   return 0;
}

static PyObject*
_FcalShower_getYzcorr(_FcalShower *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getYzcorr());
}

static int
_FcalShower_setYzcorr(_FcalShower *self, PyObject *value, void *closure)
{
   double var = PyFloat_AsDouble(value);
   if (var == -1 && PyErr_Occurred()) {
      return 1;
   }
   self->elem->setYzcorr((float)var);
   return 0;
}

static PyObject*
_FcalShower_getZ(_FcalShower *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getZ());
}

static int
_FcalShower_setZ(_FcalShower *self, PyObject *value, void *closure)
{
   double var = PyFloat_AsDouble(value);
   if (var == -1 && PyErr_Occurred()) {
      return 1;
   }
   self->elem->setZ((float)var);
   return 0;
}

static PyObject*
_FcalShower_getZerr(_FcalShower *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getZerr());
}

static int
_FcalShower_setZerr(_FcalShower *self, PyObject *value, void *closure)
{
   double var = PyFloat_AsDouble(value);
   if (var == -1 && PyErr_Occurred()) {
      return 1;
   }
   self->elem->setZerr((float)var);
   return 0;
}

static PyObject*
_FcalShower_getFcalCorrelations(PyObject *self, PyObject *args)
{
   int index=0;
   if (! PyArg_ParseTuple(args, "|i", &index)) {
      return NULL;
   }
   _FcalShower *me = (_FcalShower*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid fcalShower element");
      return NULL;
   }
   PyObject *obj = _FcalCorrelations_new(&_FcalCorrelations_type, 0, 0);
   ((_FcalCorrelations*)obj)->elem = &me->elem->getFcalCorrelations();
   ((_FcalCorrelations*)obj)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(obj));
   return obj;
}

static PyObject*
_FcalShower_getFcalCorrelationses(PyObject *self, PyObject *args)
{
   _FcalShower *me = (_FcalShower*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid fcalShower element");
      return NULL;
   }
   PyObject *list = _HDDM_ElementList_new(&_HDDM_ElementList_type, 0, 0);
   ((_HDDM_ElementList*)list)->subtype = &_FcalCorrelations_type;
   ((_HDDM_ElementList*)list)->list = (HDDM_ElementList<HDDM_Element>*)
    &me->elem->getFcalCorrelationses();
   ((_HDDM_ElementList*)list)->borrowed = 1;
   ((_HDDM_ElementList*)list)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(list), ((_HDDM_ElementList*)list)->subtype, 0);
   return list;
}

static PyObject*
_FcalShower_addFcalCorrelationses(PyObject *self, PyObject *args)
{
   int count=1;
   int start=-1;
   if (! PyArg_ParseTuple(args, "|ii", &count, &start)) {
      return NULL;
   }
   _FcalShower *me = (_FcalShower*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "add attempted on invalid fcalShower element");
      return NULL;
   }
   PyObject *list = _HDDM_ElementList_new(&_HDDM_ElementList_type, 0, 0);
   ((_HDDM_ElementList*)list)->subtype = &_FcalCorrelations_type;
   ((_HDDM_ElementList*)list)->list = (HDDM_ElementList<HDDM_Element>*)
    new FcalCorrelationsList(me->elem->addFcalCorrelationses(count, start));
   ((_HDDM_ElementList*)list)->borrowed = 0;
   ((_HDDM_ElementList*)list)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(list), ((_HDDM_ElementList*)list)->subtype, 1);
   return list;
}

static PyObject*
_FcalShower_deleteFcalCorrelationses(PyObject *self, PyObject *args)
{
   int count=-1;
   int start=0;
   if (! PyArg_ParseTuple(args, "|ii", &count, &start)) {
      return NULL;
   }
   _FcalShower *me = (_FcalShower*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "delete attempted on invalid fcalShower element");
      return NULL;
   }
   me->elem->deleteFcalCorrelationses(count, start);
   Py_INCREF(Py_None);
   return Py_None;
}

static PyObject*
_FcalShower_getFcalShowerClassification(PyObject *self, PyObject *args)
{
   int index=0;
   if (! PyArg_ParseTuple(args, "|i", &index)) {
      return NULL;
   }
   _FcalShower *me = (_FcalShower*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid fcalShower element");
      return NULL;
   }
   PyObject *obj = _FcalShowerClassification_new(&_FcalShowerClassification_type, 0, 0);
   ((_FcalShowerClassification*)obj)->elem = &me->elem->getFcalShowerClassification();
   ((_FcalShowerClassification*)obj)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(obj));
   return obj;
}

static PyObject*
_FcalShower_getFcalShowerClassifications(PyObject *self, PyObject *args)
{
   _FcalShower *me = (_FcalShower*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid fcalShower element");
      return NULL;
   }
   PyObject *list = _HDDM_ElementList_new(&_HDDM_ElementList_type, 0, 0);
   ((_HDDM_ElementList*)list)->subtype = &_FcalShowerClassification_type;
   ((_HDDM_ElementList*)list)->list = (HDDM_ElementList<HDDM_Element>*)
    &me->elem->getFcalShowerClassifications();
   ((_HDDM_ElementList*)list)->borrowed = 1;
   ((_HDDM_ElementList*)list)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(list), ((_HDDM_ElementList*)list)->subtype, 0);
   return list;
}

static PyObject*
_FcalShower_addFcalShowerClassifications(PyObject *self, PyObject *args)
{
   int count=1;
   int start=-1;
   if (! PyArg_ParseTuple(args, "|ii", &count, &start)) {
      return NULL;
   }
   _FcalShower *me = (_FcalShower*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "add attempted on invalid fcalShower element");
      return NULL;
   }
   PyObject *list = _HDDM_ElementList_new(&_HDDM_ElementList_type, 0, 0);
   ((_HDDM_ElementList*)list)->subtype = &_FcalShowerClassification_type;
   ((_HDDM_ElementList*)list)->list = (HDDM_ElementList<HDDM_Element>*)
    new FcalShowerClassificationList(me->elem->addFcalShowerClassifications(count, start));
   ((_HDDM_ElementList*)list)->borrowed = 0;
   ((_HDDM_ElementList*)list)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(list), ((_HDDM_ElementList*)list)->subtype, 1);
   return list;
}

static PyObject*
_FcalShower_deleteFcalShowerClassifications(PyObject *self, PyObject *args)
{
   int count=-1;
   int start=0;
   if (! PyArg_ParseTuple(args, "|ii", &count, &start)) {
      return NULL;
   }
   _FcalShower *me = (_FcalShower*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "delete attempted on invalid fcalShower element");
      return NULL;
   }
   me->elem->deleteFcalShowerClassifications(count, start);
   Py_INCREF(Py_None);
   return Py_None;
}

static PyObject*
_FcalShower_getFcalShowerProperties(PyObject *self, PyObject *args)
{
   int index=0;
   if (! PyArg_ParseTuple(args, "|i", &index)) {
      return NULL;
   }
   _FcalShower *me = (_FcalShower*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid fcalShower element");
      return NULL;
   }
   PyObject *obj = _FcalShowerProperties_new(&_FcalShowerProperties_type, 0, 0);
   ((_FcalShowerProperties*)obj)->elem = &me->elem->getFcalShowerProperties();
   ((_FcalShowerProperties*)obj)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(obj));
   return obj;
}

static PyObject*
_FcalShower_getFcalShowerPropertiesList(PyObject *self, PyObject *args)
{
   _FcalShower *me = (_FcalShower*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid fcalShower element");
      return NULL;
   }
   PyObject *list = _HDDM_ElementList_new(&_HDDM_ElementList_type, 0, 0);
   ((_HDDM_ElementList*)list)->subtype = &_FcalShowerProperties_type;
   ((_HDDM_ElementList*)list)->list = (HDDM_ElementList<HDDM_Element>*)
    &me->elem->getFcalShowerPropertiesList();
   ((_HDDM_ElementList*)list)->borrowed = 1;
   ((_HDDM_ElementList*)list)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(list), ((_HDDM_ElementList*)list)->subtype, 0);
   return list;
}

static PyObject*
_FcalShower_addFcalShowerPropertiesList(PyObject *self, PyObject *args)
{
   int count=1;
   int start=-1;
   if (! PyArg_ParseTuple(args, "|ii", &count, &start)) {
      return NULL;
   }
   _FcalShower *me = (_FcalShower*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "add attempted on invalid fcalShower element");
      return NULL;
   }
   PyObject *list = _HDDM_ElementList_new(&_HDDM_ElementList_type, 0, 0);
   ((_HDDM_ElementList*)list)->subtype = &_FcalShowerProperties_type;
   ((_HDDM_ElementList*)list)->list = (HDDM_ElementList<HDDM_Element>*)
    new FcalShowerPropertiesList(me->elem->addFcalShowerPropertiesList(count, start));
   ((_HDDM_ElementList*)list)->borrowed = 0;
   ((_HDDM_ElementList*)list)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(list), ((_HDDM_ElementList*)list)->subtype, 1);
   return list;
}

static PyObject*
_FcalShower_deleteFcalShowerPropertiesList(PyObject *self, PyObject *args)
{
   int count=-1;
   int start=0;
   if (! PyArg_ParseTuple(args, "|ii", &count, &start)) {
      return NULL;
   }
   _FcalShower *me = (_FcalShower*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "delete attempted on invalid fcalShower element");
      return NULL;
   }
   me->elem->deleteFcalShowerPropertiesList(count, start);
   Py_INCREF(Py_None);
   return Py_None;
}

static PyObject*
_FcalShower_getFcalShowerNBlocks(PyObject *self, PyObject *args)
{
   int index=0;
   if (! PyArg_ParseTuple(args, "|i", &index)) {
      return NULL;
   }
   _FcalShower *me = (_FcalShower*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid fcalShower element");
      return NULL;
   }
   PyObject *obj = _FcalShowerNBlocks_new(&_FcalShowerNBlocks_type, 0, 0);
   ((_FcalShowerNBlocks*)obj)->elem = &me->elem->getFcalShowerNBlocks();
   ((_FcalShowerNBlocks*)obj)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(obj));
   return obj;
}

static PyObject*
_FcalShower_getFcalShowerNBlockses(PyObject *self, PyObject *args)
{
   _FcalShower *me = (_FcalShower*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid fcalShower element");
      return NULL;
   }
   PyObject *list = _HDDM_ElementList_new(&_HDDM_ElementList_type, 0, 0);
   ((_HDDM_ElementList*)list)->subtype = &_FcalShowerNBlocks_type;
   ((_HDDM_ElementList*)list)->list = (HDDM_ElementList<HDDM_Element>*)
    &me->elem->getFcalShowerNBlockses();
   ((_HDDM_ElementList*)list)->borrowed = 1;
   ((_HDDM_ElementList*)list)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(list), ((_HDDM_ElementList*)list)->subtype, 0);
   return list;
}

static PyObject*
_FcalShower_addFcalShowerNBlockses(PyObject *self, PyObject *args)
{
   int count=1;
   int start=-1;
   if (! PyArg_ParseTuple(args, "|ii", &count, &start)) {
      return NULL;
   }
   _FcalShower *me = (_FcalShower*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "add attempted on invalid fcalShower element");
      return NULL;
   }
   PyObject *list = _HDDM_ElementList_new(&_HDDM_ElementList_type, 0, 0);
   ((_HDDM_ElementList*)list)->subtype = &_FcalShowerNBlocks_type;
   ((_HDDM_ElementList*)list)->list = (HDDM_ElementList<HDDM_Element>*)
    new FcalShowerNBlocksList(me->elem->addFcalShowerNBlockses(count, start));
   ((_HDDM_ElementList*)list)->borrowed = 0;
   ((_HDDM_ElementList*)list)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(list), ((_HDDM_ElementList*)list)->subtype, 1);
   return list;
}

static PyObject*
_FcalShower_deleteFcalShowerNBlockses(PyObject *self, PyObject *args)
{
   int count=-1;
   int start=0;
   if (! PyArg_ParseTuple(args, "|ii", &count, &start)) {
      return NULL;
   }
   _FcalShower *me = (_FcalShower*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "delete attempted on invalid fcalShower element");
      return NULL;
   }
   me->elem->deleteFcalShowerNBlockses(count, start);
   Py_INCREF(Py_None);
   return Py_None;
}

static PyObject*
_FcalShower_toString(PyObject *self, PyObject *args=0)
{
   _FcalShower *me = (_FcalShower*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid fcalShower element");
      return NULL;
   }
   std::string str(me->elem->toString());
   return PyUnicode_FromString(str.c_str());
}

static PyObject*
_FcalShower_toXML(PyObject *self, PyObject *args=0)
{
   _FcalShower *me = (_FcalShower*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid fcalShower element");
      return NULL;
   }
   std::string str(me->elem->toXML());
   return PyUnicode_FromString(str.c_str());
}

static PyGetSetDef _FcalShower_getsetters[] = {
   {(char*)"E",
    (getter)_FcalShower_getE, (setter)_FcalShower_setE,
    (char*)"E value",
    NULL},
   {(char*)"Eerr",
    (getter)_FcalShower_getEerr, (setter)_FcalShower_setEerr,
    (char*)"Eerr value",
    NULL},
   {(char*)"Eunit",
    (getter)_FcalShower_getEunit, 0,
    (char*)"Eunit value",
    NULL},
   {(char*)"Ezcorr",
    (getter)_FcalShower_getEzcorr, (setter)_FcalShower_setEzcorr,
    (char*)"Ezcorr value",
    NULL},
   {(char*)"class",
    (getter)_FcalShower_getClass, 0,
    (char*)"class string",
    NULL},
   {(char*)"eventNo",
    (getter)_FcalShower_getEventNo, 0,
    (char*)"eventNo value",
    NULL},
   {(char*)"jtag",
    (getter)_FcalShower_getJtag, (setter)_FcalShower_setJtag,
    (char*)"jtag string",
    NULL},
   {(char*)"lunit",
    (getter)_FcalShower_getLunit, 0,
    (char*)"lunit value",
    NULL},
   {(char*)"maxOccurs",
    (getter)_FcalShower_getMaxOccurs, 0,
    (char*)"maxOccurs value",
    NULL},
   {(char*)"minOccurs",
    (getter)_FcalShower_getMinOccurs, 0,
    (char*)"minOccurs value",
    NULL},
   {(char*)"runNo",
    (getter)_FcalShower_getRunNo, 0,
    (char*)"runNo value",
    NULL},
   {(char*)"t",
    (getter)_FcalShower_getT, (setter)_FcalShower_setT,
    (char*)"t value",
    NULL},
   {(char*)"terr",
    (getter)_FcalShower_getTerr, (setter)_FcalShower_setTerr,
    (char*)"terr value",
    NULL},
   {(char*)"tunit",
    (getter)_FcalShower_getTunit, 0,
    (char*)"tunit value",
    NULL},
   {(char*)"tzcorr",
    (getter)_FcalShower_getTzcorr, (setter)_FcalShower_setTzcorr,
    (char*)"tzcorr value",
    NULL},
   {(char*)"version",
    (getter)_FcalShower_getVersion, 0,
    (char*)"version string",
    NULL},
   {(char*)"x",
    (getter)_FcalShower_getX, (setter)_FcalShower_setX,
    (char*)"x value",
    NULL},
   {(char*)"xerr",
    (getter)_FcalShower_getXerr, (setter)_FcalShower_setXerr,
    (char*)"xerr value",
    NULL},
   {(char*)"xmlns",
    (getter)_FcalShower_getXmlns, 0,
    (char*)"xmlns string",
    NULL},
   {(char*)"xycorr",
    (getter)_FcalShower_getXycorr, (setter)_FcalShower_setXycorr,
    (char*)"xycorr value",
    NULL},
   {(char*)"xzcorr",
    (getter)_FcalShower_getXzcorr, (setter)_FcalShower_setXzcorr,
    (char*)"xzcorr value",
    NULL},
   {(char*)"y",
    (getter)_FcalShower_getY, (setter)_FcalShower_setY,
    (char*)"y value",
    NULL},
   {(char*)"yerr",
    (getter)_FcalShower_getYerr, (setter)_FcalShower_setYerr,
    (char*)"yerr value",
    NULL},
   {(char*)"yzcorr",
    (getter)_FcalShower_getYzcorr, (setter)_FcalShower_setYzcorr,
    (char*)"yzcorr value",
    NULL},
   {(char*)"z",
    (getter)_FcalShower_getZ, (setter)_FcalShower_setZ,
    (char*)"z value",
    NULL},
   {(char*)"zerr",
    (getter)_FcalShower_getZerr, (setter)_FcalShower_setZerr,
    (char*)"zerr value",
    NULL},
   {NULL}  /* Sentinel */
};

static PyMemberDef _FcalShower_members[] = {
   {NULL}  /* Sentinel */
};

static PyMethodDef _FcalShower_methods[] = {
   {"addFcalCorrelationses", _FcalShower_addFcalCorrelationses, METH_VARARGS,
    "extend (or insert into) the list of fcalCorrelations objects for this fcalShower"},
   {"addFcalShowerClassifications", _FcalShower_addFcalShowerClassifications, METH_VARARGS,
    "extend (or insert into) the list of fcalShowerClassification objects for this fcalShower"},
   {"addFcalShowerNBlockses", _FcalShower_addFcalShowerNBlockses, METH_VARARGS,
    "extend (or insert into) the list of fcalShowerNBlocks objects for this fcalShower"},
   {"addFcalShowerPropertiesList", _FcalShower_addFcalShowerPropertiesList, METH_VARARGS,
    "extend (or insert into) the list of fcalShowerProperties objects for this fcalShower"},
   {"deleteFcalCorrelationses", _FcalShower_deleteFcalCorrelationses, METH_VARARGS,
    "delete fcalCorrelations objects for this fcalShower"},
   {"deleteFcalShowerClassifications", _FcalShower_deleteFcalShowerClassifications, METH_VARARGS,
    "delete fcalShowerClassification objects for this fcalShower"},
   {"deleteFcalShowerNBlockses", _FcalShower_deleteFcalShowerNBlockses, METH_VARARGS,
    "delete fcalShowerNBlocks objects for this fcalShower"},
   {"deleteFcalShowerPropertiesList", _FcalShower_deleteFcalShowerPropertiesList, METH_VARARGS,
    "delete fcalShowerProperties objects for this fcalShower"},
   {"getFcalCorrelations", _FcalShower_getFcalCorrelations, METH_VARARGS,
    "get an individual fcalCorrelations object from this fcalShower"},
   {"getFcalCorrelationses", _FcalShower_getFcalCorrelationses, METH_NOARGS,
    "get list of fcalCorrelations objects for this fcalShower"},
   {"getFcalShowerClassification", _FcalShower_getFcalShowerClassification, METH_VARARGS,
    "get an individual fcalShowerClassification object from this fcalShower"},
   {"getFcalShowerClassifications", _FcalShower_getFcalShowerClassifications, METH_NOARGS,
    "get list of fcalShowerClassification objects for this fcalShower"},
   {"getFcalShowerNBlocks", _FcalShower_getFcalShowerNBlocks, METH_VARARGS,
    "get an individual fcalShowerNBlocks object from this fcalShower"},
   {"getFcalShowerNBlockses", _FcalShower_getFcalShowerNBlockses, METH_NOARGS,
    "get list of fcalShowerNBlocks objects for this fcalShower"},
   {"getFcalShowerProperties", _FcalShower_getFcalShowerProperties, METH_VARARGS,
    "get an individual fcalShowerProperties object from this fcalShower"},
   {"getFcalShowerPropertiesList", _FcalShower_getFcalShowerPropertiesList, METH_NOARGS,
    "get list of fcalShowerProperties objects for this fcalShower"},
   {"toString", _FcalShower_toString, METH_NOARGS,
    "show element as a human-readable string"},
   {"toXML", _FcalShower_toXML, METH_NOARGS,
    "show element as a XML fragment"},
   {NULL}  /* Sentinel */
};

static PyTypeObject _FcalShower_type = {
    PyVarObject_HEAD_INIT(NULL,0)
    "hddm_r.FcalShower",         /*tp_name*/
    sizeof(_FcalShower),          /*tp_basicsize*/
    0,                         /*tp_itemsize*/
    (destructor)_FcalShower_dealloc, /*tp_dealloc*/
    0,                         /*tp_print*/
    0,                         /*tp_getattr*/
    0,                         /*tp_setattr*/
    0,                         /*tp_compare*/
    0,                         /*tp_repr*/
    0,                         /*tp_as_number*/
    0,                         /*tp_as_sequence*/
    0,                         /*tp_as_mapping*/
    0,                         /*tp_hash */
    0,                         /*tp_call*/
    (reprfunc)_FcalShower_toString,         /*tp_str*/
    0,                         /*tp_getattro*/
    0,                         /*tp_setattro*/
    0,                         /*tp_as_buffer*/
    Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE, /*tp_flags*/
    "hddm_r fcalShower element",  /* tp_doc */
    0,                         /* tp_traverse */
    0,                         /* tp_clear */
    0,                         /* tp_richcompare */
    0,                         /* tp_weaklistoffset */
    0,                         /* tp_iter */
    0,                         /* tp_iternext */
    _FcalShower_methods,          /* tp_methods */
    _FcalShower_members,          /* tp_members */
    _FcalShower_getsetters,       /* tp_getset */
    &_HDDM_Element_type,       /* tp_base */
    0,                         /* tp_dict */
    0,                         /* tp_descr_get */
    0,                         /* tp_descr_set */
    0,                         /* tp_dictoffset */
    (initproc)_FcalShower_init,   /* tp_init */
    0,                         /* tp_alloc */
    _FcalShower_new,              /* tp_new */
};



// wrap element class hddm_r::FcalHit as hddm_r.FcalHit

typedef struct {
   PyObject_HEAD
   FcalHit *elem;
   PyObject *host;
} _FcalHit;

static void
_FcalHit_dealloc(_FcalHit* self)
{
   if (self->elem != 0) {
      LOG_DEALLOC(Py_TYPE(self), 0, self->host == (PyObject*)self);
      if (self->host == (PyObject*)self)
         delete self->elem;
      else
         My_DECREF(self->host);
   }
   Py_TYPE(self)->tp_free((PyObject*)self);
}

static PyObject*
_FcalHit_new(PyTypeObject *type, PyObject *args, PyObject *kwds)
{
   _FcalHit *self;
   self = (_FcalHit*)type->tp_alloc(type, 0);
   if (self != NULL) {
      self->elem = 0;
      self->host = 0;
   }
   return (PyObject*)self;
}

static int
_FcalHit_init(_FcalHit *self, PyObject *args, PyObject *kwds)
{
   PyErr_SetString(PyExc_RuntimeError, "illegal constructor");
   return -1;
}

static PyObject*
_FcalHit_getClass(_FcalHit *self, void *closure)
{
   std::string val(self->elem->getClass());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_FcalHit_getVersion(_FcalHit *self, void *closure)
{
   std::string val(self->elem->getVersion());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_FcalHit_getXmlns(_FcalHit *self, void *closure)
{
   std::string val(self->elem->getXmlns());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_FcalHit_getEventNo(_FcalHit *self, void *closure)
{
   return PyLong_FromLongLong(self->elem->getEventNo());
}

static PyObject*
_FcalHit_getRunNo(_FcalHit *self, void *closure)
{
   return PyLong_FromLong(self->elem->getRunNo());
}

static PyObject*
_FcalHit_getE(_FcalHit *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getE());
}

static int
_FcalHit_setE(_FcalHit *self, PyObject *value, void *closure)
{
   double var = PyFloat_AsDouble(value);
   if (var == -1 && PyErr_Occurred()) {
      return 1;
   }
   self->elem->setE((float)var);
   return 0;
}

static PyObject*
_FcalHit_getEunit(_FcalHit *self, void *closure)
{
   std::string val(self->elem->getEunit());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_FcalHit_getColumn(_FcalHit *self, void *closure)
{
   return PyLong_FromLong(self->elem->getColumn());
}

static int
_FcalHit_setColumn(_FcalHit *self, PyObject *value, void *closure)
{
   long var = PyInt_AsLong(value);
   if (var == -1 && PyErr_Occurred()) {
      return -1;
   }
   self->elem->setColumn(var);
   return 0;
}

static PyObject*
_FcalHit_getIntOverPeak(_FcalHit *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getIntOverPeak());
}

static int
_FcalHit_setIntOverPeak(_FcalHit *self, PyObject *value, void *closure)
{
   double var = PyFloat_AsDouble(value);
   if (var == -1 && PyErr_Occurred()) {
      return 1;
   }
   self->elem->setIntOverPeak((float)var);
   return 0;
}

static PyObject*
_FcalHit_getJtag(_FcalHit *self, void *closure)
{
   std::string val(self->elem->getJtag());
   return PyUnicode_FromString(val.c_str());
}

static int
_FcalHit_setJtag(_FcalHit *self, PyObject *value, void *closure)
{
   PyObject *str=0;
   if (PyUnicode_Check(value))
      str = PyUnicode_AsEncodedString(value, "ASCII", "strict");
   else
      str = value;
#if PY_MAJOR_VERSION < 3
   char *var = PyString_AsString(str);
#else
   char *var = PyBytes_AsString(str);
#endif
   if (var == 0) {
      return -1;
   }
   self->elem->setJtag(std::string(var));
   if (str != value) {
      Py_DECREF(str);
   }
   return 0;
}

static PyObject*
_FcalHit_getMaxOccurs(_FcalHit *self, void *closure)
{
   std::string val(self->elem->getMaxOccurs());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_FcalHit_getMinOccurs(_FcalHit *self, void *closure)
{
   return PyLong_FromLong(self->elem->getMinOccurs());
}

static PyObject*
_FcalHit_getRow(_FcalHit *self, void *closure)
{
   return PyLong_FromLong(self->elem->getRow());
}

static int
_FcalHit_setRow(_FcalHit *self, PyObject *value, void *closure)
{
   long var = PyInt_AsLong(value);
   if (var == -1 && PyErr_Occurred()) {
      return -1;
   }
   self->elem->setRow(var);
   return 0;
}

static PyObject*
_FcalHit_getT(_FcalHit *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getT());
}

static int
_FcalHit_setT(_FcalHit *self, PyObject *value, void *closure)
{
   double var = PyFloat_AsDouble(value);
   if (var == -1 && PyErr_Occurred()) {
      return 1;
   }
   self->elem->setT((float)var);
   return 0;
}

static PyObject*
_FcalHit_getTunit(_FcalHit *self, void *closure)
{
   std::string val(self->elem->getTunit());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_FcalHit_getX(_FcalHit *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getX());
}

static int
_FcalHit_setX(_FcalHit *self, PyObject *value, void *closure)
{
   double var = PyFloat_AsDouble(value);
   if (var == -1 && PyErr_Occurred()) {
      return 1;
   }
   self->elem->setX((float)var);
   return 0;
}

static PyObject*
_FcalHit_getY(_FcalHit *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getY());
}

static int
_FcalHit_setY(_FcalHit *self, PyObject *value, void *closure)
{
   double var = PyFloat_AsDouble(value);
   if (var == -1 && PyErr_Occurred()) {
      return 1;
   }
   self->elem->setY((float)var);
   return 0;
}

static PyObject*
_FcalHit_toString(PyObject *self, PyObject *args=0)
{
   _FcalHit *me = (_FcalHit*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid fcalHit element");
      return NULL;
   }
   std::string str(me->elem->toString());
   return PyUnicode_FromString(str.c_str());
}

static PyObject*
_FcalHit_toXML(PyObject *self, PyObject *args=0)
{
   _FcalHit *me = (_FcalHit*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid fcalHit element");
      return NULL;
   }
   std::string str(me->elem->toXML());
   return PyUnicode_FromString(str.c_str());
}

static PyGetSetDef _FcalHit_getsetters[] = {
   {(char*)"E",
    (getter)_FcalHit_getE, (setter)_FcalHit_setE,
    (char*)"E value",
    NULL},
   {(char*)"Eunit",
    (getter)_FcalHit_getEunit, 0,
    (char*)"Eunit value",
    NULL},
   {(char*)"class",
    (getter)_FcalHit_getClass, 0,
    (char*)"class string",
    NULL},
   {(char*)"column",
    (getter)_FcalHit_getColumn, (setter)_FcalHit_setColumn,
    (char*)"column value",
    NULL},
   {(char*)"eventNo",
    (getter)_FcalHit_getEventNo, 0,
    (char*)"eventNo value",
    NULL},
   {(char*)"intOverPeak",
    (getter)_FcalHit_getIntOverPeak, (setter)_FcalHit_setIntOverPeak,
    (char*)"intOverPeak value",
    NULL},
   {(char*)"jtag",
    (getter)_FcalHit_getJtag, (setter)_FcalHit_setJtag,
    (char*)"jtag string",
    NULL},
   {(char*)"maxOccurs",
    (getter)_FcalHit_getMaxOccurs, 0,
    (char*)"maxOccurs value",
    NULL},
   {(char*)"minOccurs",
    (getter)_FcalHit_getMinOccurs, 0,
    (char*)"minOccurs value",
    NULL},
   {(char*)"row",
    (getter)_FcalHit_getRow, (setter)_FcalHit_setRow,
    (char*)"row value",
    NULL},
   {(char*)"runNo",
    (getter)_FcalHit_getRunNo, 0,
    (char*)"runNo value",
    NULL},
   {(char*)"t",
    (getter)_FcalHit_getT, (setter)_FcalHit_setT,
    (char*)"t value",
    NULL},
   {(char*)"tunit",
    (getter)_FcalHit_getTunit, 0,
    (char*)"tunit value",
    NULL},
   {(char*)"version",
    (getter)_FcalHit_getVersion, 0,
    (char*)"version string",
    NULL},
   {(char*)"x",
    (getter)_FcalHit_getX, (setter)_FcalHit_setX,
    (char*)"x value",
    NULL},
   {(char*)"xmlns",
    (getter)_FcalHit_getXmlns, 0,
    (char*)"xmlns string",
    NULL},
   {(char*)"y",
    (getter)_FcalHit_getY, (setter)_FcalHit_setY,
    (char*)"y value",
    NULL},
   {NULL}  /* Sentinel */
};

static PyMemberDef _FcalHit_members[] = {
   {NULL}  /* Sentinel */
};

static PyMethodDef _FcalHit_methods[] = {
   {"toString", _FcalHit_toString, METH_NOARGS,
    "show element as a human-readable string"},
   {"toXML", _FcalHit_toXML, METH_NOARGS,
    "show element as a XML fragment"},
   {NULL}  /* Sentinel */
};

static PyTypeObject _FcalHit_type = {
    PyVarObject_HEAD_INIT(NULL,0)
    "hddm_r.FcalHit",         /*tp_name*/
    sizeof(_FcalHit),          /*tp_basicsize*/
    0,                         /*tp_itemsize*/
    (destructor)_FcalHit_dealloc, /*tp_dealloc*/
    0,                         /*tp_print*/
    0,                         /*tp_getattr*/
    0,                         /*tp_setattr*/
    0,                         /*tp_compare*/
    0,                         /*tp_repr*/
    0,                         /*tp_as_number*/
    0,                         /*tp_as_sequence*/
    0,                         /*tp_as_mapping*/
    0,                         /*tp_hash */
    0,                         /*tp_call*/
    (reprfunc)_FcalHit_toString,         /*tp_str*/
    0,                         /*tp_getattro*/
    0,                         /*tp_setattro*/
    0,                         /*tp_as_buffer*/
    Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE, /*tp_flags*/
    "hddm_r fcalHit element",  /* tp_doc */
    0,                         /* tp_traverse */
    0,                         /* tp_clear */
    0,                         /* tp_richcompare */
    0,                         /* tp_weaklistoffset */
    0,                         /* tp_iter */
    0,                         /* tp_iternext */
    _FcalHit_methods,          /* tp_methods */
    _FcalHit_members,          /* tp_members */
    _FcalHit_getsetters,       /* tp_getset */
    &_HDDM_Element_type,       /* tp_base */
    0,                         /* tp_dict */
    0,                         /* tp_descr_get */
    0,                         /* tp_descr_set */
    0,                         /* tp_dictoffset */
    (initproc)_FcalHit_init,   /* tp_init */
    0,                         /* tp_alloc */
    _FcalHit_new,              /* tp_new */
};



// wrap element class hddm_r::Preshower as hddm_r.Preshower

typedef struct {
   PyObject_HEAD
   Preshower *elem;
   PyObject *host;
} _Preshower;

static void
_Preshower_dealloc(_Preshower* self)
{
   if (self->elem != 0) {
      LOG_DEALLOC(Py_TYPE(self), 0, self->host == (PyObject*)self);
      if (self->host == (PyObject*)self)
         delete self->elem;
      else
         My_DECREF(self->host);
   }
   Py_TYPE(self)->tp_free((PyObject*)self);
}

static PyObject*
_Preshower_new(PyTypeObject *type, PyObject *args, PyObject *kwds)
{
   _Preshower *self;
   self = (_Preshower*)type->tp_alloc(type, 0);
   if (self != NULL) {
      self->elem = 0;
      self->host = 0;
   }
   return (PyObject*)self;
}

static int
_Preshower_init(_Preshower *self, PyObject *args, PyObject *kwds)
{
   PyErr_SetString(PyExc_RuntimeError, "illegal constructor");
   return -1;
}

static PyObject*
_Preshower_getClass(_Preshower *self, void *closure)
{
   std::string val(self->elem->getClass());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_Preshower_getVersion(_Preshower *self, void *closure)
{
   std::string val(self->elem->getVersion());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_Preshower_getXmlns(_Preshower *self, void *closure)
{
   std::string val(self->elem->getXmlns());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_Preshower_getEventNo(_Preshower *self, void *closure)
{
   return PyLong_FromLongLong(self->elem->getEventNo());
}

static PyObject*
_Preshower_getRunNo(_Preshower *self, void *closure)
{
   return PyLong_FromLong(self->elem->getRunNo());
}

static PyObject*
_Preshower_getE(_Preshower *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getE());
}

static PyObject*
_Preshower_getEerr(_Preshower *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getEerr());
}

static PyObject*
_Preshower_getEunit(_Preshower *self, void *closure)
{
   std::string val(self->elem->getEunit());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_Preshower_getEzcorr(_Preshower *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getEzcorr());
}

static PyObject*
_Preshower_getJtag(_Preshower *self, void *closure)
{
   std::string val(self->elem->getJtag());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_Preshower_getLunit(_Preshower *self, void *closure)
{
   std::string val(self->elem->getLunit());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_Preshower_getT(_Preshower *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getT());
}

static PyObject*
_Preshower_getTerr(_Preshower *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getTerr());
}

static PyObject*
_Preshower_getTunit(_Preshower *self, void *closure)
{
   std::string val(self->elem->getTunit());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_Preshower_getTzcorr(_Preshower *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getTzcorr());
}

static PyObject*
_Preshower_getX(_Preshower *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getX());
}

static PyObject*
_Preshower_getXerr(_Preshower *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getXerr());
}

static PyObject*
_Preshower_getXycorr(_Preshower *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getXycorr());
}

static PyObject*
_Preshower_getXzcorr(_Preshower *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getXzcorr());
}

static PyObject*
_Preshower_getY(_Preshower *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getY());
}

static PyObject*
_Preshower_getYerr(_Preshower *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getYerr());
}

static PyObject*
_Preshower_getYzcorr(_Preshower *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getYzcorr());
}

static PyObject*
_Preshower_getZ(_Preshower *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getZ());
}

static PyObject*
_Preshower_getZerr(_Preshower *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getZerr());
}

static PyObject*
_Preshower_getMaxOccurs(_Preshower *self, void *closure)
{
   return PyLong_FromLong(self->elem->getMaxOccurs());
}

static PyObject*
_Preshower_getMinOccurs(_Preshower *self, void *closure)
{
   return PyLong_FromLong(self->elem->getMinOccurs());
}

static PyObject*
_Preshower_getPreshowerE(_Preshower *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getPreshowerE());
}

static int
_Preshower_setPreshowerE(_Preshower *self, PyObject *value, void *closure)
{
   double var = PyFloat_AsDouble(value);
   if (var == -1 && PyErr_Occurred()) {
      return 1;
   }
   self->elem->setPreshowerE((float)var);
   return 0;
}

static PyObject*
_Preshower_toString(PyObject *self, PyObject *args=0)
{
   _Preshower *me = (_Preshower*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid preshower element");
      return NULL;
   }
   std::string str(me->elem->toString());
   return PyUnicode_FromString(str.c_str());
}

static PyObject*
_Preshower_toXML(PyObject *self, PyObject *args=0)
{
   _Preshower *me = (_Preshower*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid preshower element");
      return NULL;
   }
   std::string str(me->elem->toXML());
   return PyUnicode_FromString(str.c_str());
}

static PyGetSetDef _Preshower_getsetters[] = {
   {(char*)"E",
    (getter)_Preshower_getE, 0,
    (char*)"E value",
    NULL},
   {(char*)"Eerr",
    (getter)_Preshower_getEerr, 0,
    (char*)"Eerr value",
    NULL},
   {(char*)"Eunit",
    (getter)_Preshower_getEunit, 0,
    (char*)"Eunit string",
    NULL},
   {(char*)"Ezcorr",
    (getter)_Preshower_getEzcorr, 0,
    (char*)"Ezcorr value",
    NULL},
   {(char*)"class",
    (getter)_Preshower_getClass, 0,
    (char*)"class string",
    NULL},
   {(char*)"eventNo",
    (getter)_Preshower_getEventNo, 0,
    (char*)"eventNo value",
    NULL},
   {(char*)"jtag",
    (getter)_Preshower_getJtag, 0,
    (char*)"jtag string",
    NULL},
   {(char*)"lunit",
    (getter)_Preshower_getLunit, 0,
    (char*)"lunit string",
    NULL},
   {(char*)"maxOccurs",
    (getter)_Preshower_getMaxOccurs, 0,
    (char*)"maxOccurs value",
    NULL},
   {(char*)"minOccurs",
    (getter)_Preshower_getMinOccurs, 0,
    (char*)"minOccurs value",
    NULL},
   {(char*)"preshowerE",
    (getter)_Preshower_getPreshowerE, (setter)_Preshower_setPreshowerE,
    (char*)"preshowerE value",
    NULL},
   {(char*)"runNo",
    (getter)_Preshower_getRunNo, 0,
    (char*)"runNo value",
    NULL},
   {(char*)"t",
    (getter)_Preshower_getT, 0,
    (char*)"t value",
    NULL},
   {(char*)"terr",
    (getter)_Preshower_getTerr, 0,
    (char*)"terr value",
    NULL},
   {(char*)"tunit",
    (getter)_Preshower_getTunit, 0,
    (char*)"tunit string",
    NULL},
   {(char*)"tzcorr",
    (getter)_Preshower_getTzcorr, 0,
    (char*)"tzcorr value",
    NULL},
   {(char*)"version",
    (getter)_Preshower_getVersion, 0,
    (char*)"version string",
    NULL},
   {(char*)"x",
    (getter)_Preshower_getX, 0,
    (char*)"x value",
    NULL},
   {(char*)"xerr",
    (getter)_Preshower_getXerr, 0,
    (char*)"xerr value",
    NULL},
   {(char*)"xmlns",
    (getter)_Preshower_getXmlns, 0,
    (char*)"xmlns string",
    NULL},
   {(char*)"xycorr",
    (getter)_Preshower_getXycorr, 0,
    (char*)"xycorr value",
    NULL},
   {(char*)"xzcorr",
    (getter)_Preshower_getXzcorr, 0,
    (char*)"xzcorr value",
    NULL},
   {(char*)"y",
    (getter)_Preshower_getY, 0,
    (char*)"y value",
    NULL},
   {(char*)"yerr",
    (getter)_Preshower_getYerr, 0,
    (char*)"yerr value",
    NULL},
   {(char*)"yzcorr",
    (getter)_Preshower_getYzcorr, 0,
    (char*)"yzcorr value",
    NULL},
   {(char*)"z",
    (getter)_Preshower_getZ, 0,
    (char*)"z value",
    NULL},
   {(char*)"zerr",
    (getter)_Preshower_getZerr, 0,
    (char*)"zerr value",
    NULL},
   {NULL}  /* Sentinel */
};

static PyMemberDef _Preshower_members[] = {
   {NULL}  /* Sentinel */
};

static PyMethodDef _Preshower_methods[] = {
   {"toString", _Preshower_toString, METH_NOARGS,
    "show element as a human-readable string"},
   {"toXML", _Preshower_toXML, METH_NOARGS,
    "show element as a XML fragment"},
   {NULL}  /* Sentinel */
};

static PyTypeObject _Preshower_type = {
    PyVarObject_HEAD_INIT(NULL,0)
    "hddm_r.Preshower",         /*tp_name*/
    sizeof(_Preshower),          /*tp_basicsize*/
    0,                         /*tp_itemsize*/
    (destructor)_Preshower_dealloc, /*tp_dealloc*/
    0,                         /*tp_print*/
    0,                         /*tp_getattr*/
    0,                         /*tp_setattr*/
    0,                         /*tp_compare*/
    0,                         /*tp_repr*/
    0,                         /*tp_as_number*/
    0,                         /*tp_as_sequence*/
    0,                         /*tp_as_mapping*/
    0,                         /*tp_hash */
    0,                         /*tp_call*/
    (reprfunc)_Preshower_toString,         /*tp_str*/
    0,                         /*tp_getattro*/
    0,                         /*tp_setattro*/
    0,                         /*tp_as_buffer*/
    Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE, /*tp_flags*/
    "hddm_r preshower element",  /* tp_doc */
    0,                         /* tp_traverse */
    0,                         /* tp_clear */
    0,                         /* tp_richcompare */
    0,                         /* tp_weaklistoffset */
    0,                         /* tp_iter */
    0,                         /* tp_iternext */
    _Preshower_methods,          /* tp_methods */
    _Preshower_members,          /* tp_members */
    _Preshower_getsetters,       /* tp_getset */
    &_HDDM_Element_type,       /* tp_base */
    0,                         /* tp_dict */
    0,                         /* tp_descr_get */
    0,                         /* tp_descr_set */
    0,                         /* tp_dictoffset */
    (initproc)_Preshower_init,   /* tp_init */
    0,                         /* tp_alloc */
    _Preshower_new,              /* tp_new */
};



// wrap element class hddm_r::Width as hddm_r.Width

typedef struct {
   PyObject_HEAD
   Width *elem;
   PyObject *host;
} _Width;

static void
_Width_dealloc(_Width* self)
{
   if (self->elem != 0) {
      LOG_DEALLOC(Py_TYPE(self), 0, self->host == (PyObject*)self);
      if (self->host == (PyObject*)self)
         delete self->elem;
      else
         My_DECREF(self->host);
   }
   Py_TYPE(self)->tp_free((PyObject*)self);
}

static PyObject*
_Width_new(PyTypeObject *type, PyObject *args, PyObject *kwds)
{
   _Width *self;
   self = (_Width*)type->tp_alloc(type, 0);
   if (self != NULL) {
      self->elem = 0;
      self->host = 0;
   }
   return (PyObject*)self;
}

static int
_Width_init(_Width *self, PyObject *args, PyObject *kwds)
{
   PyErr_SetString(PyExc_RuntimeError, "illegal constructor");
   return -1;
}

static PyObject*
_Width_getClass(_Width *self, void *closure)
{
   std::string val(self->elem->getClass());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_Width_getVersion(_Width *self, void *closure)
{
   std::string val(self->elem->getVersion());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_Width_getXmlns(_Width *self, void *closure)
{
   std::string val(self->elem->getXmlns());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_Width_getEventNo(_Width *self, void *closure)
{
   return PyLong_FromLongLong(self->elem->getEventNo());
}

static PyObject*
_Width_getRunNo(_Width *self, void *closure)
{
   return PyLong_FromLong(self->elem->getRunNo());
}

static PyObject*
_Width_getE(_Width *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getE());
}

static PyObject*
_Width_getEerr(_Width *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getEerr());
}

static PyObject*
_Width_getEunit(_Width *self, void *closure)
{
   std::string val(self->elem->getEunit());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_Width_getEzcorr(_Width *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getEzcorr());
}

static PyObject*
_Width_getJtag(_Width *self, void *closure)
{
   std::string val(self->elem->getJtag());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_Width_getLunit(_Width *self, void *closure)
{
   std::string val(self->elem->getLunit());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_Width_getT(_Width *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getT());
}

static PyObject*
_Width_getTerr(_Width *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getTerr());
}

static PyObject*
_Width_getTunit(_Width *self, void *closure)
{
   std::string val(self->elem->getTunit());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_Width_getTzcorr(_Width *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getTzcorr());
}

static PyObject*
_Width_getX(_Width *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getX());
}

static PyObject*
_Width_getXerr(_Width *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getXerr());
}

static PyObject*
_Width_getXycorr(_Width *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getXycorr());
}

static PyObject*
_Width_getXzcorr(_Width *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getXzcorr());
}

static PyObject*
_Width_getY(_Width *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getY());
}

static PyObject*
_Width_getYerr(_Width *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getYerr());
}

static PyObject*
_Width_getYzcorr(_Width *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getYzcorr());
}

static PyObject*
_Width_getZ(_Width *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getZ());
}

static PyObject*
_Width_getZerr(_Width *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getZerr());
}

static PyObject*
_Width_getMaxOccurs(_Width *self, void *closure)
{
   return PyLong_FromLong(self->elem->getMaxOccurs());
}

static PyObject*
_Width_getMinOccurs(_Width *self, void *closure)
{
   return PyLong_FromLong(self->elem->getMinOccurs());
}

static PyObject*
_Width_getSigLong(_Width *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getSigLong());
}

static int
_Width_setSigLong(_Width *self, PyObject *value, void *closure)
{
   double var = PyFloat_AsDouble(value);
   if (var == -1 && PyErr_Occurred()) {
      return 1;
   }
   self->elem->setSigLong((float)var);
   return 0;
}

static PyObject*
_Width_getSigTheta(_Width *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getSigTheta());
}

static int
_Width_setSigTheta(_Width *self, PyObject *value, void *closure)
{
   double var = PyFloat_AsDouble(value);
   if (var == -1 && PyErr_Occurred()) {
      return 1;
   }
   self->elem->setSigTheta((float)var);
   return 0;
}

static PyObject*
_Width_getSigTrans(_Width *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getSigTrans());
}

static int
_Width_setSigTrans(_Width *self, PyObject *value, void *closure)
{
   double var = PyFloat_AsDouble(value);
   if (var == -1 && PyErr_Occurred()) {
      return 1;
   }
   self->elem->setSigTrans((float)var);
   return 0;
}

static PyObject*
_Width_toString(PyObject *self, PyObject *args=0)
{
   _Width *me = (_Width*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid width element");
      return NULL;
   }
   std::string str(me->elem->toString());
   return PyUnicode_FromString(str.c_str());
}

static PyObject*
_Width_toXML(PyObject *self, PyObject *args=0)
{
   _Width *me = (_Width*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid width element");
      return NULL;
   }
   std::string str(me->elem->toXML());
   return PyUnicode_FromString(str.c_str());
}

static PyGetSetDef _Width_getsetters[] = {
   {(char*)"E",
    (getter)_Width_getE, 0,
    (char*)"E value",
    NULL},
   {(char*)"Eerr",
    (getter)_Width_getEerr, 0,
    (char*)"Eerr value",
    NULL},
   {(char*)"Eunit",
    (getter)_Width_getEunit, 0,
    (char*)"Eunit string",
    NULL},
   {(char*)"Ezcorr",
    (getter)_Width_getEzcorr, 0,
    (char*)"Ezcorr value",
    NULL},
   {(char*)"class",
    (getter)_Width_getClass, 0,
    (char*)"class string",
    NULL},
   {(char*)"eventNo",
    (getter)_Width_getEventNo, 0,
    (char*)"eventNo value",
    NULL},
   {(char*)"jtag",
    (getter)_Width_getJtag, 0,
    (char*)"jtag string",
    NULL},
   {(char*)"lunit",
    (getter)_Width_getLunit, 0,
    (char*)"lunit string",
    NULL},
   {(char*)"maxOccurs",
    (getter)_Width_getMaxOccurs, 0,
    (char*)"maxOccurs value",
    NULL},
   {(char*)"minOccurs",
    (getter)_Width_getMinOccurs, 0,
    (char*)"minOccurs value",
    NULL},
   {(char*)"runNo",
    (getter)_Width_getRunNo, 0,
    (char*)"runNo value",
    NULL},
   {(char*)"sigLong",
    (getter)_Width_getSigLong, (setter)_Width_setSigLong,
    (char*)"sigLong value",
    NULL},
   {(char*)"sigTheta",
    (getter)_Width_getSigTheta, (setter)_Width_setSigTheta,
    (char*)"sigTheta value",
    NULL},
   {(char*)"sigTrans",
    (getter)_Width_getSigTrans, (setter)_Width_setSigTrans,
    (char*)"sigTrans value",
    NULL},
   {(char*)"t",
    (getter)_Width_getT, 0,
    (char*)"t value",
    NULL},
   {(char*)"terr",
    (getter)_Width_getTerr, 0,
    (char*)"terr value",
    NULL},
   {(char*)"tunit",
    (getter)_Width_getTunit, 0,
    (char*)"tunit string",
    NULL},
   {(char*)"tzcorr",
    (getter)_Width_getTzcorr, 0,
    (char*)"tzcorr value",
    NULL},
   {(char*)"version",
    (getter)_Width_getVersion, 0,
    (char*)"version string",
    NULL},
   {(char*)"x",
    (getter)_Width_getX, 0,
    (char*)"x value",
    NULL},
   {(char*)"xerr",
    (getter)_Width_getXerr, 0,
    (char*)"xerr value",
    NULL},
   {(char*)"xmlns",
    (getter)_Width_getXmlns, 0,
    (char*)"xmlns string",
    NULL},
   {(char*)"xycorr",
    (getter)_Width_getXycorr, 0,
    (char*)"xycorr value",
    NULL},
   {(char*)"xzcorr",
    (getter)_Width_getXzcorr, 0,
    (char*)"xzcorr value",
    NULL},
   {(char*)"y",
    (getter)_Width_getY, 0,
    (char*)"y value",
    NULL},
   {(char*)"yerr",
    (getter)_Width_getYerr, 0,
    (char*)"yerr value",
    NULL},
   {(char*)"yzcorr",
    (getter)_Width_getYzcorr, 0,
    (char*)"yzcorr value",
    NULL},
   {(char*)"z",
    (getter)_Width_getZ, 0,
    (char*)"z value",
    NULL},
   {(char*)"zerr",
    (getter)_Width_getZerr, 0,
    (char*)"zerr value",
    NULL},
   {NULL}  /* Sentinel */
};

static PyMemberDef _Width_members[] = {
   {NULL}  /* Sentinel */
};

static PyMethodDef _Width_methods[] = {
   {"toString", _Width_toString, METH_NOARGS,
    "show element as a human-readable string"},
   {"toXML", _Width_toXML, METH_NOARGS,
    "show element as a XML fragment"},
   {NULL}  /* Sentinel */
};

static PyTypeObject _Width_type = {
    PyVarObject_HEAD_INIT(NULL,0)
    "hddm_r.Width",         /*tp_name*/
    sizeof(_Width),          /*tp_basicsize*/
    0,                         /*tp_itemsize*/
    (destructor)_Width_dealloc, /*tp_dealloc*/
    0,                         /*tp_print*/
    0,                         /*tp_getattr*/
    0,                         /*tp_setattr*/
    0,                         /*tp_compare*/
    0,                         /*tp_repr*/
    0,                         /*tp_as_number*/
    0,                         /*tp_as_sequence*/
    0,                         /*tp_as_mapping*/
    0,                         /*tp_hash */
    0,                         /*tp_call*/
    (reprfunc)_Width_toString,         /*tp_str*/
    0,                         /*tp_getattro*/
    0,                         /*tp_setattro*/
    0,                         /*tp_as_buffer*/
    Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE, /*tp_flags*/
    "hddm_r width element",  /* tp_doc */
    0,                         /* tp_traverse */
    0,                         /* tp_clear */
    0,                         /* tp_richcompare */
    0,                         /* tp_weaklistoffset */
    0,                         /* tp_iter */
    0,                         /* tp_iternext */
    _Width_methods,          /* tp_methods */
    _Width_members,          /* tp_members */
    _Width_getsetters,       /* tp_getset */
    &_HDDM_Element_type,       /* tp_base */
    0,                         /* tp_dict */
    0,                         /* tp_descr_get */
    0,                         /* tp_descr_set */
    0,                         /* tp_dictoffset */
    (initproc)_Width_init,   /* tp_init */
    0,                         /* tp_alloc */
    _Width_new,              /* tp_new */
};



// wrap element class hddm_r::BcalCluster as hddm_r.BcalCluster

typedef struct {
   PyObject_HEAD
   BcalCluster *elem;
   PyObject *host;
} _BcalCluster;

static void
_BcalCluster_dealloc(_BcalCluster* self)
{
   if (self->elem != 0) {
      LOG_DEALLOC(Py_TYPE(self), 0, self->host == (PyObject*)self);
      if (self->host == (PyObject*)self)
         delete self->elem;
      else
         My_DECREF(self->host);
   }
   Py_TYPE(self)->tp_free((PyObject*)self);
}

static PyObject*
_BcalCluster_new(PyTypeObject *type, PyObject *args, PyObject *kwds)
{
   _BcalCluster *self;
   self = (_BcalCluster*)type->tp_alloc(type, 0);
   if (self != NULL) {
      self->elem = 0;
      self->host = 0;
   }
   return (PyObject*)self;
}

static int
_BcalCluster_init(_BcalCluster *self, PyObject *args, PyObject *kwds)
{
   PyErr_SetString(PyExc_RuntimeError, "illegal constructor");
   return -1;
}

static PyObject*
_BcalCluster_getClass(_BcalCluster *self, void *closure)
{
   std::string val(self->elem->getClass());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_BcalCluster_getVersion(_BcalCluster *self, void *closure)
{
   std::string val(self->elem->getVersion());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_BcalCluster_getXmlns(_BcalCluster *self, void *closure)
{
   std::string val(self->elem->getXmlns());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_BcalCluster_getEventNo(_BcalCluster *self, void *closure)
{
   return PyLong_FromLongLong(self->elem->getEventNo());
}

static PyObject*
_BcalCluster_getRunNo(_BcalCluster *self, void *closure)
{
   return PyLong_FromLong(self->elem->getRunNo());
}

static PyObject*
_BcalCluster_getE(_BcalCluster *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getE());
}

static PyObject*
_BcalCluster_getEerr(_BcalCluster *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getEerr());
}

static PyObject*
_BcalCluster_getEunit(_BcalCluster *self, void *closure)
{
   std::string val(self->elem->getEunit());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_BcalCluster_getEzcorr(_BcalCluster *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getEzcorr());
}

static PyObject*
_BcalCluster_getJtag(_BcalCluster *self, void *closure)
{
   std::string val(self->elem->getJtag());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_BcalCluster_getLunit(_BcalCluster *self, void *closure)
{
   std::string val(self->elem->getLunit());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_BcalCluster_getT(_BcalCluster *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getT());
}

static PyObject*
_BcalCluster_getTerr(_BcalCluster *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getTerr());
}

static PyObject*
_BcalCluster_getTunit(_BcalCluster *self, void *closure)
{
   std::string val(self->elem->getTunit());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_BcalCluster_getTzcorr(_BcalCluster *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getTzcorr());
}

static PyObject*
_BcalCluster_getX(_BcalCluster *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getX());
}

static PyObject*
_BcalCluster_getXerr(_BcalCluster *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getXerr());
}

static PyObject*
_BcalCluster_getXycorr(_BcalCluster *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getXycorr());
}

static PyObject*
_BcalCluster_getXzcorr(_BcalCluster *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getXzcorr());
}

static PyObject*
_BcalCluster_getY(_BcalCluster *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getY());
}

static PyObject*
_BcalCluster_getYerr(_BcalCluster *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getYerr());
}

static PyObject*
_BcalCluster_getYzcorr(_BcalCluster *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getYzcorr());
}

static PyObject*
_BcalCluster_getZ(_BcalCluster *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getZ());
}

static PyObject*
_BcalCluster_getZerr(_BcalCluster *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getZerr());
}

static PyObject*
_BcalCluster_getMaxOccurs(_BcalCluster *self, void *closure)
{
   return PyLong_FromLong(self->elem->getMaxOccurs());
}

static PyObject*
_BcalCluster_getMinOccurs(_BcalCluster *self, void *closure)
{
   return PyLong_FromLong(self->elem->getMinOccurs());
}

static PyObject*
_BcalCluster_getNcell(_BcalCluster *self, void *closure)
{
   return PyLong_FromLong(self->elem->getNcell());
}

static int
_BcalCluster_setNcell(_BcalCluster *self, PyObject *value, void *closure)
{
   long var = PyInt_AsLong(value);
   if (var == -1 && PyErr_Occurred()) {
      return -1;
   }
   self->elem->setNcell(var);
   return 0;
}

static PyObject*
_BcalCluster_toString(PyObject *self, PyObject *args=0)
{
   _BcalCluster *me = (_BcalCluster*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid bcalCluster element");
      return NULL;
   }
   std::string str(me->elem->toString());
   return PyUnicode_FromString(str.c_str());
}

static PyObject*
_BcalCluster_toXML(PyObject *self, PyObject *args=0)
{
   _BcalCluster *me = (_BcalCluster*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid bcalCluster element");
      return NULL;
   }
   std::string str(me->elem->toXML());
   return PyUnicode_FromString(str.c_str());
}

static PyGetSetDef _BcalCluster_getsetters[] = {
   {(char*)"E",
    (getter)_BcalCluster_getE, 0,
    (char*)"E value",
    NULL},
   {(char*)"Eerr",
    (getter)_BcalCluster_getEerr, 0,
    (char*)"Eerr value",
    NULL},
   {(char*)"Eunit",
    (getter)_BcalCluster_getEunit, 0,
    (char*)"Eunit string",
    NULL},
   {(char*)"Ezcorr",
    (getter)_BcalCluster_getEzcorr, 0,
    (char*)"Ezcorr value",
    NULL},
   {(char*)"class",
    (getter)_BcalCluster_getClass, 0,
    (char*)"class string",
    NULL},
   {(char*)"eventNo",
    (getter)_BcalCluster_getEventNo, 0,
    (char*)"eventNo value",
    NULL},
   {(char*)"jtag",
    (getter)_BcalCluster_getJtag, 0,
    (char*)"jtag string",
    NULL},
   {(char*)"lunit",
    (getter)_BcalCluster_getLunit, 0,
    (char*)"lunit string",
    NULL},
   {(char*)"maxOccurs",
    (getter)_BcalCluster_getMaxOccurs, 0,
    (char*)"maxOccurs value",
    NULL},
   {(char*)"minOccurs",
    (getter)_BcalCluster_getMinOccurs, 0,
    (char*)"minOccurs value",
    NULL},
   {(char*)"ncell",
    (getter)_BcalCluster_getNcell, (setter)_BcalCluster_setNcell,
    (char*)"ncell value",
    NULL},
   {(char*)"runNo",
    (getter)_BcalCluster_getRunNo, 0,
    (char*)"runNo value",
    NULL},
   {(char*)"t",
    (getter)_BcalCluster_getT, 0,
    (char*)"t value",
    NULL},
   {(char*)"terr",
    (getter)_BcalCluster_getTerr, 0,
    (char*)"terr value",
    NULL},
   {(char*)"tunit",
    (getter)_BcalCluster_getTunit, 0,
    (char*)"tunit string",
    NULL},
   {(char*)"tzcorr",
    (getter)_BcalCluster_getTzcorr, 0,
    (char*)"tzcorr value",
    NULL},
   {(char*)"version",
    (getter)_BcalCluster_getVersion, 0,
    (char*)"version string",
    NULL},
   {(char*)"x",
    (getter)_BcalCluster_getX, 0,
    (char*)"x value",
    NULL},
   {(char*)"xerr",
    (getter)_BcalCluster_getXerr, 0,
    (char*)"xerr value",
    NULL},
   {(char*)"xmlns",
    (getter)_BcalCluster_getXmlns, 0,
    (char*)"xmlns string",
    NULL},
   {(char*)"xycorr",
    (getter)_BcalCluster_getXycorr, 0,
    (char*)"xycorr value",
    NULL},
   {(char*)"xzcorr",
    (getter)_BcalCluster_getXzcorr, 0,
    (char*)"xzcorr value",
    NULL},
   {(char*)"y",
    (getter)_BcalCluster_getY, 0,
    (char*)"y value",
    NULL},
   {(char*)"yerr",
    (getter)_BcalCluster_getYerr, 0,
    (char*)"yerr value",
    NULL},
   {(char*)"yzcorr",
    (getter)_BcalCluster_getYzcorr, 0,
    (char*)"yzcorr value",
    NULL},
   {(char*)"z",
    (getter)_BcalCluster_getZ, 0,
    (char*)"z value",
    NULL},
   {(char*)"zerr",
    (getter)_BcalCluster_getZerr, 0,
    (char*)"zerr value",
    NULL},
   {NULL}  /* Sentinel */
};

static PyMemberDef _BcalCluster_members[] = {
   {NULL}  /* Sentinel */
};

static PyMethodDef _BcalCluster_methods[] = {
   {"toString", _BcalCluster_toString, METH_NOARGS,
    "show element as a human-readable string"},
   {"toXML", _BcalCluster_toXML, METH_NOARGS,
    "show element as a XML fragment"},
   {NULL}  /* Sentinel */
};

static PyTypeObject _BcalCluster_type = {
    PyVarObject_HEAD_INIT(NULL,0)
    "hddm_r.BcalCluster",         /*tp_name*/
    sizeof(_BcalCluster),          /*tp_basicsize*/
    0,                         /*tp_itemsize*/
    (destructor)_BcalCluster_dealloc, /*tp_dealloc*/
    0,                         /*tp_print*/
    0,                         /*tp_getattr*/
    0,                         /*tp_setattr*/
    0,                         /*tp_compare*/
    0,                         /*tp_repr*/
    0,                         /*tp_as_number*/
    0,                         /*tp_as_sequence*/
    0,                         /*tp_as_mapping*/
    0,                         /*tp_hash */
    0,                         /*tp_call*/
    (reprfunc)_BcalCluster_toString,         /*tp_str*/
    0,                         /*tp_getattro*/
    0,                         /*tp_setattro*/
    0,                         /*tp_as_buffer*/
    Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE, /*tp_flags*/
    "hddm_r bcalCluster element",  /* tp_doc */
    0,                         /* tp_traverse */
    0,                         /* tp_clear */
    0,                         /* tp_richcompare */
    0,                         /* tp_weaklistoffset */
    0,                         /* tp_iter */
    0,                         /* tp_iternext */
    _BcalCluster_methods,          /* tp_methods */
    _BcalCluster_members,          /* tp_members */
    _BcalCluster_getsetters,       /* tp_getset */
    &_HDDM_Element_type,       /* tp_base */
    0,                         /* tp_dict */
    0,                         /* tp_descr_get */
    0,                         /* tp_descr_set */
    0,                         /* tp_dictoffset */
    (initproc)_BcalCluster_init,   /* tp_init */
    0,                         /* tp_alloc */
    _BcalCluster_new,              /* tp_new */
};



// wrap element class hddm_r::BcalCorrelations as hddm_r.BcalCorrelations

typedef struct {
   PyObject_HEAD
   BcalCorrelations *elem;
   PyObject *host;
} _BcalCorrelations;

static void
_BcalCorrelations_dealloc(_BcalCorrelations* self)
{
   if (self->elem != 0) {
      LOG_DEALLOC(Py_TYPE(self), 0, self->host == (PyObject*)self);
      if (self->host == (PyObject*)self)
         delete self->elem;
      else
         My_DECREF(self->host);
   }
   Py_TYPE(self)->tp_free((PyObject*)self);
}

static PyObject*
_BcalCorrelations_new(PyTypeObject *type, PyObject *args, PyObject *kwds)
{
   _BcalCorrelations *self;
   self = (_BcalCorrelations*)type->tp_alloc(type, 0);
   if (self != NULL) {
      self->elem = 0;
      self->host = 0;
   }
   return (PyObject*)self;
}

static int
_BcalCorrelations_init(_BcalCorrelations *self, PyObject *args, PyObject *kwds)
{
   PyErr_SetString(PyExc_RuntimeError, "illegal constructor");
   return -1;
}

static PyObject*
_BcalCorrelations_getClass(_BcalCorrelations *self, void *closure)
{
   std::string val(self->elem->getClass());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_BcalCorrelations_getVersion(_BcalCorrelations *self, void *closure)
{
   std::string val(self->elem->getVersion());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_BcalCorrelations_getXmlns(_BcalCorrelations *self, void *closure)
{
   std::string val(self->elem->getXmlns());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_BcalCorrelations_getEventNo(_BcalCorrelations *self, void *closure)
{
   return PyLong_FromLongLong(self->elem->getEventNo());
}

static PyObject*
_BcalCorrelations_getRunNo(_BcalCorrelations *self, void *closure)
{
   return PyLong_FromLong(self->elem->getRunNo());
}

static PyObject*
_BcalCorrelations_getE(_BcalCorrelations *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getE());
}

static PyObject*
_BcalCorrelations_getEerr(_BcalCorrelations *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getEerr());
}

static PyObject*
_BcalCorrelations_getEunit(_BcalCorrelations *self, void *closure)
{
   std::string val(self->elem->getEunit());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_BcalCorrelations_getEzcorr(_BcalCorrelations *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getEzcorr());
}

static PyObject*
_BcalCorrelations_getJtag(_BcalCorrelations *self, void *closure)
{
   std::string val(self->elem->getJtag());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_BcalCorrelations_getLunit(_BcalCorrelations *self, void *closure)
{
   std::string val(self->elem->getLunit());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_BcalCorrelations_getT(_BcalCorrelations *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getT());
}

static PyObject*
_BcalCorrelations_getTerr(_BcalCorrelations *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getTerr());
}

static PyObject*
_BcalCorrelations_getTunit(_BcalCorrelations *self, void *closure)
{
   std::string val(self->elem->getTunit());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_BcalCorrelations_getTzcorr(_BcalCorrelations *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getTzcorr());
}

static PyObject*
_BcalCorrelations_getX(_BcalCorrelations *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getX());
}

static PyObject*
_BcalCorrelations_getXerr(_BcalCorrelations *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getXerr());
}

static PyObject*
_BcalCorrelations_getXycorr(_BcalCorrelations *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getXycorr());
}

static PyObject*
_BcalCorrelations_getXzcorr(_BcalCorrelations *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getXzcorr());
}

static PyObject*
_BcalCorrelations_getY(_BcalCorrelations *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getY());
}

static PyObject*
_BcalCorrelations_getYerr(_BcalCorrelations *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getYerr());
}

static PyObject*
_BcalCorrelations_getYzcorr(_BcalCorrelations *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getYzcorr());
}

static PyObject*
_BcalCorrelations_getZ(_BcalCorrelations *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getZ());
}

static PyObject*
_BcalCorrelations_getZerr(_BcalCorrelations *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getZerr());
}

static PyObject*
_BcalCorrelations_getEtcorr(_BcalCorrelations *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getEtcorr());
}

static int
_BcalCorrelations_setEtcorr(_BcalCorrelations *self, PyObject *value, void *closure)
{
   double var = PyFloat_AsDouble(value);
   if (var == -1 && PyErr_Occurred()) {
      return 1;
   }
   self->elem->setEtcorr((float)var);
   return 0;
}

static PyObject*
_BcalCorrelations_getExcorr(_BcalCorrelations *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getExcorr());
}

static int
_BcalCorrelations_setExcorr(_BcalCorrelations *self, PyObject *value, void *closure)
{
   double var = PyFloat_AsDouble(value);
   if (var == -1 && PyErr_Occurred()) {
      return 1;
   }
   self->elem->setExcorr((float)var);
   return 0;
}

static PyObject*
_BcalCorrelations_getEycorr(_BcalCorrelations *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getEycorr());
}

static int
_BcalCorrelations_setEycorr(_BcalCorrelations *self, PyObject *value, void *closure)
{
   double var = PyFloat_AsDouble(value);
   if (var == -1 && PyErr_Occurred()) {
      return 1;
   }
   self->elem->setEycorr((float)var);
   return 0;
}

static PyObject*
_BcalCorrelations_getMaxOccurs(_BcalCorrelations *self, void *closure)
{
   return PyLong_FromLong(self->elem->getMaxOccurs());
}

static PyObject*
_BcalCorrelations_getMinOccurs(_BcalCorrelations *self, void *closure)
{
   return PyLong_FromLong(self->elem->getMinOccurs());
}

static PyObject*
_BcalCorrelations_getTxcorr(_BcalCorrelations *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getTxcorr());
}

static int
_BcalCorrelations_setTxcorr(_BcalCorrelations *self, PyObject *value, void *closure)
{
   double var = PyFloat_AsDouble(value);
   if (var == -1 && PyErr_Occurred()) {
      return 1;
   }
   self->elem->setTxcorr((float)var);
   return 0;
}

static PyObject*
_BcalCorrelations_getTycorr(_BcalCorrelations *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getTycorr());
}

static int
_BcalCorrelations_setTycorr(_BcalCorrelations *self, PyObject *value, void *closure)
{
   double var = PyFloat_AsDouble(value);
   if (var == -1 && PyErr_Occurred()) {
      return 1;
   }
   self->elem->setTycorr((float)var);
   return 0;
}

static PyObject*
_BcalCorrelations_toString(PyObject *self, PyObject *args=0)
{
   _BcalCorrelations *me = (_BcalCorrelations*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid bcalCorrelations element");
      return NULL;
   }
   std::string str(me->elem->toString());
   return PyUnicode_FromString(str.c_str());
}

static PyObject*
_BcalCorrelations_toXML(PyObject *self, PyObject *args=0)
{
   _BcalCorrelations *me = (_BcalCorrelations*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid bcalCorrelations element");
      return NULL;
   }
   std::string str(me->elem->toXML());
   return PyUnicode_FromString(str.c_str());
}

static PyGetSetDef _BcalCorrelations_getsetters[] = {
   {(char*)"E",
    (getter)_BcalCorrelations_getE, 0,
    (char*)"E value",
    NULL},
   {(char*)"Eerr",
    (getter)_BcalCorrelations_getEerr, 0,
    (char*)"Eerr value",
    NULL},
   {(char*)"Etcorr",
    (getter)_BcalCorrelations_getEtcorr, (setter)_BcalCorrelations_setEtcorr,
    (char*)"Etcorr value",
    NULL},
   {(char*)"Eunit",
    (getter)_BcalCorrelations_getEunit, 0,
    (char*)"Eunit string",
    NULL},
   {(char*)"Excorr",
    (getter)_BcalCorrelations_getExcorr, (setter)_BcalCorrelations_setExcorr,
    (char*)"Excorr value",
    NULL},
   {(char*)"Eycorr",
    (getter)_BcalCorrelations_getEycorr, (setter)_BcalCorrelations_setEycorr,
    (char*)"Eycorr value",
    NULL},
   {(char*)"Ezcorr",
    (getter)_BcalCorrelations_getEzcorr, 0,
    (char*)"Ezcorr value",
    NULL},
   {(char*)"class",
    (getter)_BcalCorrelations_getClass, 0,
    (char*)"class string",
    NULL},
   {(char*)"eventNo",
    (getter)_BcalCorrelations_getEventNo, 0,
    (char*)"eventNo value",
    NULL},
   {(char*)"jtag",
    (getter)_BcalCorrelations_getJtag, 0,
    (char*)"jtag string",
    NULL},
   {(char*)"lunit",
    (getter)_BcalCorrelations_getLunit, 0,
    (char*)"lunit string",
    NULL},
   {(char*)"maxOccurs",
    (getter)_BcalCorrelations_getMaxOccurs, 0,
    (char*)"maxOccurs value",
    NULL},
   {(char*)"minOccurs",
    (getter)_BcalCorrelations_getMinOccurs, 0,
    (char*)"minOccurs value",
    NULL},
   {(char*)"runNo",
    (getter)_BcalCorrelations_getRunNo, 0,
    (char*)"runNo value",
    NULL},
   {(char*)"t",
    (getter)_BcalCorrelations_getT, 0,
    (char*)"t value",
    NULL},
   {(char*)"terr",
    (getter)_BcalCorrelations_getTerr, 0,
    (char*)"terr value",
    NULL},
   {(char*)"tunit",
    (getter)_BcalCorrelations_getTunit, 0,
    (char*)"tunit string",
    NULL},
   {(char*)"txcorr",
    (getter)_BcalCorrelations_getTxcorr, (setter)_BcalCorrelations_setTxcorr,
    (char*)"txcorr value",
    NULL},
   {(char*)"tycorr",
    (getter)_BcalCorrelations_getTycorr, (setter)_BcalCorrelations_setTycorr,
    (char*)"tycorr value",
    NULL},
   {(char*)"tzcorr",
    (getter)_BcalCorrelations_getTzcorr, 0,
    (char*)"tzcorr value",
    NULL},
   {(char*)"version",
    (getter)_BcalCorrelations_getVersion, 0,
    (char*)"version string",
    NULL},
   {(char*)"x",
    (getter)_BcalCorrelations_getX, 0,
    (char*)"x value",
    NULL},
   {(char*)"xerr",
    (getter)_BcalCorrelations_getXerr, 0,
    (char*)"xerr value",
    NULL},
   {(char*)"xmlns",
    (getter)_BcalCorrelations_getXmlns, 0,
    (char*)"xmlns string",
    NULL},
   {(char*)"xycorr",
    (getter)_BcalCorrelations_getXycorr, 0,
    (char*)"xycorr value",
    NULL},
   {(char*)"xzcorr",
    (getter)_BcalCorrelations_getXzcorr, 0,
    (char*)"xzcorr value",
    NULL},
   {(char*)"y",
    (getter)_BcalCorrelations_getY, 0,
    (char*)"y value",
    NULL},
   {(char*)"yerr",
    (getter)_BcalCorrelations_getYerr, 0,
    (char*)"yerr value",
    NULL},
   {(char*)"yzcorr",
    (getter)_BcalCorrelations_getYzcorr, 0,
    (char*)"yzcorr value",
    NULL},
   {(char*)"z",
    (getter)_BcalCorrelations_getZ, 0,
    (char*)"z value",
    NULL},
   {(char*)"zerr",
    (getter)_BcalCorrelations_getZerr, 0,
    (char*)"zerr value",
    NULL},
   {NULL}  /* Sentinel */
};

static PyMemberDef _BcalCorrelations_members[] = {
   {NULL}  /* Sentinel */
};

static PyMethodDef _BcalCorrelations_methods[] = {
   {"toString", _BcalCorrelations_toString, METH_NOARGS,
    "show element as a human-readable string"},
   {"toXML", _BcalCorrelations_toXML, METH_NOARGS,
    "show element as a XML fragment"},
   {NULL}  /* Sentinel */
};

static PyTypeObject _BcalCorrelations_type = {
    PyVarObject_HEAD_INIT(NULL,0)
    "hddm_r.BcalCorrelations",         /*tp_name*/
    sizeof(_BcalCorrelations),          /*tp_basicsize*/
    0,                         /*tp_itemsize*/
    (destructor)_BcalCorrelations_dealloc, /*tp_dealloc*/
    0,                         /*tp_print*/
    0,                         /*tp_getattr*/
    0,                         /*tp_setattr*/
    0,                         /*tp_compare*/
    0,                         /*tp_repr*/
    0,                         /*tp_as_number*/
    0,                         /*tp_as_sequence*/
    0,                         /*tp_as_mapping*/
    0,                         /*tp_hash */
    0,                         /*tp_call*/
    (reprfunc)_BcalCorrelations_toString,         /*tp_str*/
    0,                         /*tp_getattro*/
    0,                         /*tp_setattro*/
    0,                         /*tp_as_buffer*/
    Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE, /*tp_flags*/
    "hddm_r bcalCorrelations element",  /* tp_doc */
    0,                         /* tp_traverse */
    0,                         /* tp_clear */
    0,                         /* tp_richcompare */
    0,                         /* tp_weaklistoffset */
    0,                         /* tp_iter */
    0,                         /* tp_iternext */
    _BcalCorrelations_methods,          /* tp_methods */
    _BcalCorrelations_members,          /* tp_members */
    _BcalCorrelations_getsetters,       /* tp_getset */
    &_HDDM_Element_type,       /* tp_base */
    0,                         /* tp_dict */
    0,                         /* tp_descr_get */
    0,                         /* tp_descr_set */
    0,                         /* tp_dictoffset */
    (initproc)_BcalCorrelations_init,   /* tp_init */
    0,                         /* tp_alloc */
    _BcalCorrelations_new,              /* tp_new */
};



// wrap element class hddm_r::BcalLayers as hddm_r.BcalLayers

typedef struct {
   PyObject_HEAD
   BcalLayers *elem;
   PyObject *host;
} _BcalLayers;

static void
_BcalLayers_dealloc(_BcalLayers* self)
{
   if (self->elem != 0) {
      LOG_DEALLOC(Py_TYPE(self), 0, self->host == (PyObject*)self);
      if (self->host == (PyObject*)self)
         delete self->elem;
      else
         My_DECREF(self->host);
   }
   Py_TYPE(self)->tp_free((PyObject*)self);
}

static PyObject*
_BcalLayers_new(PyTypeObject *type, PyObject *args, PyObject *kwds)
{
   _BcalLayers *self;
   self = (_BcalLayers*)type->tp_alloc(type, 0);
   if (self != NULL) {
      self->elem = 0;
      self->host = 0;
   }
   return (PyObject*)self;
}

static int
_BcalLayers_init(_BcalLayers *self, PyObject *args, PyObject *kwds)
{
   PyErr_SetString(PyExc_RuntimeError, "illegal constructor");
   return -1;
}

static PyObject*
_BcalLayers_getClass(_BcalLayers *self, void *closure)
{
   std::string val(self->elem->getClass());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_BcalLayers_getVersion(_BcalLayers *self, void *closure)
{
   std::string val(self->elem->getVersion());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_BcalLayers_getXmlns(_BcalLayers *self, void *closure)
{
   std::string val(self->elem->getXmlns());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_BcalLayers_getEventNo(_BcalLayers *self, void *closure)
{
   return PyLong_FromLongLong(self->elem->getEventNo());
}

static PyObject*
_BcalLayers_getRunNo(_BcalLayers *self, void *closure)
{
   return PyLong_FromLong(self->elem->getRunNo());
}

static PyObject*
_BcalLayers_getE(_BcalLayers *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getE());
}

static PyObject*
_BcalLayers_getEerr(_BcalLayers *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getEerr());
}

static PyObject*
_BcalLayers_getEunit(_BcalLayers *self, void *closure)
{
   std::string val(self->elem->getEunit());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_BcalLayers_getEzcorr(_BcalLayers *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getEzcorr());
}

static PyObject*
_BcalLayers_getJtag(_BcalLayers *self, void *closure)
{
   std::string val(self->elem->getJtag());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_BcalLayers_getLunit(_BcalLayers *self, void *closure)
{
   std::string val(self->elem->getLunit());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_BcalLayers_getT(_BcalLayers *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getT());
}

static PyObject*
_BcalLayers_getTerr(_BcalLayers *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getTerr());
}

static PyObject*
_BcalLayers_getTunit(_BcalLayers *self, void *closure)
{
   std::string val(self->elem->getTunit());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_BcalLayers_getTzcorr(_BcalLayers *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getTzcorr());
}

static PyObject*
_BcalLayers_getX(_BcalLayers *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getX());
}

static PyObject*
_BcalLayers_getXerr(_BcalLayers *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getXerr());
}

static PyObject*
_BcalLayers_getXycorr(_BcalLayers *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getXycorr());
}

static PyObject*
_BcalLayers_getXzcorr(_BcalLayers *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getXzcorr());
}

static PyObject*
_BcalLayers_getY(_BcalLayers *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getY());
}

static PyObject*
_BcalLayers_getYerr(_BcalLayers *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getYerr());
}

static PyObject*
_BcalLayers_getYzcorr(_BcalLayers *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getYzcorr());
}

static PyObject*
_BcalLayers_getZ(_BcalLayers *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getZ());
}

static PyObject*
_BcalLayers_getZerr(_BcalLayers *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getZerr());
}

static PyObject*
_BcalLayers_getE_L2(_BcalLayers *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getE_L2());
}

static int
_BcalLayers_setE_L2(_BcalLayers *self, PyObject *value, void *closure)
{
   double var = PyFloat_AsDouble(value);
   if (var == -1 && PyErr_Occurred()) {
      return 1;
   }
   self->elem->setE_L2((float)var);
   return 0;
}

static PyObject*
_BcalLayers_getE_L3(_BcalLayers *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getE_L3());
}

static int
_BcalLayers_setE_L3(_BcalLayers *self, PyObject *value, void *closure)
{
   double var = PyFloat_AsDouble(value);
   if (var == -1 && PyErr_Occurred()) {
      return 1;
   }
   self->elem->setE_L3((float)var);
   return 0;
}

static PyObject*
_BcalLayers_getE_L4(_BcalLayers *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getE_L4());
}

static int
_BcalLayers_setE_L4(_BcalLayers *self, PyObject *value, void *closure)
{
   double var = PyFloat_AsDouble(value);
   if (var == -1 && PyErr_Occurred()) {
      return 1;
   }
   self->elem->setE_L4((float)var);
   return 0;
}

static PyObject*
_BcalLayers_getMaxOccurs(_BcalLayers *self, void *closure)
{
   return PyLong_FromLong(self->elem->getMaxOccurs());
}

static PyObject*
_BcalLayers_getMinOccurs(_BcalLayers *self, void *closure)
{
   return PyLong_FromLong(self->elem->getMinOccurs());
}

static PyObject*
_BcalLayers_getRmsTime(_BcalLayers *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getRmsTime());
}

static int
_BcalLayers_setRmsTime(_BcalLayers *self, PyObject *value, void *closure)
{
   double var = PyFloat_AsDouble(value);
   if (var == -1 && PyErr_Occurred()) {
      return 1;
   }
   self->elem->setRmsTime((float)var);
   return 0;
}

static PyObject*
_BcalLayers_toString(PyObject *self, PyObject *args=0)
{
   _BcalLayers *me = (_BcalLayers*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid bcalLayers element");
      return NULL;
   }
   std::string str(me->elem->toString());
   return PyUnicode_FromString(str.c_str());
}

static PyObject*
_BcalLayers_toXML(PyObject *self, PyObject *args=0)
{
   _BcalLayers *me = (_BcalLayers*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid bcalLayers element");
      return NULL;
   }
   std::string str(me->elem->toXML());
   return PyUnicode_FromString(str.c_str());
}

static PyGetSetDef _BcalLayers_getsetters[] = {
   {(char*)"E",
    (getter)_BcalLayers_getE, 0,
    (char*)"E value",
    NULL},
   {(char*)"E_L2",
    (getter)_BcalLayers_getE_L2, (setter)_BcalLayers_setE_L2,
    (char*)"E_L2 value",
    NULL},
   {(char*)"E_L3",
    (getter)_BcalLayers_getE_L3, (setter)_BcalLayers_setE_L3,
    (char*)"E_L3 value",
    NULL},
   {(char*)"E_L4",
    (getter)_BcalLayers_getE_L4, (setter)_BcalLayers_setE_L4,
    (char*)"E_L4 value",
    NULL},
   {(char*)"Eerr",
    (getter)_BcalLayers_getEerr, 0,
    (char*)"Eerr value",
    NULL},
   {(char*)"Eunit",
    (getter)_BcalLayers_getEunit, 0,
    (char*)"Eunit string",
    NULL},
   {(char*)"Ezcorr",
    (getter)_BcalLayers_getEzcorr, 0,
    (char*)"Ezcorr value",
    NULL},
   {(char*)"class",
    (getter)_BcalLayers_getClass, 0,
    (char*)"class string",
    NULL},
   {(char*)"eventNo",
    (getter)_BcalLayers_getEventNo, 0,
    (char*)"eventNo value",
    NULL},
   {(char*)"jtag",
    (getter)_BcalLayers_getJtag, 0,
    (char*)"jtag string",
    NULL},
   {(char*)"lunit",
    (getter)_BcalLayers_getLunit, 0,
    (char*)"lunit string",
    NULL},
   {(char*)"maxOccurs",
    (getter)_BcalLayers_getMaxOccurs, 0,
    (char*)"maxOccurs value",
    NULL},
   {(char*)"minOccurs",
    (getter)_BcalLayers_getMinOccurs, 0,
    (char*)"minOccurs value",
    NULL},
   {(char*)"rmsTime",
    (getter)_BcalLayers_getRmsTime, (setter)_BcalLayers_setRmsTime,
    (char*)"rmsTime value",
    NULL},
   {(char*)"runNo",
    (getter)_BcalLayers_getRunNo, 0,
    (char*)"runNo value",
    NULL},
   {(char*)"t",
    (getter)_BcalLayers_getT, 0,
    (char*)"t value",
    NULL},
   {(char*)"terr",
    (getter)_BcalLayers_getTerr, 0,
    (char*)"terr value",
    NULL},
   {(char*)"tunit",
    (getter)_BcalLayers_getTunit, 0,
    (char*)"tunit string",
    NULL},
   {(char*)"tzcorr",
    (getter)_BcalLayers_getTzcorr, 0,
    (char*)"tzcorr value",
    NULL},
   {(char*)"version",
    (getter)_BcalLayers_getVersion, 0,
    (char*)"version string",
    NULL},
   {(char*)"x",
    (getter)_BcalLayers_getX, 0,
    (char*)"x value",
    NULL},
   {(char*)"xerr",
    (getter)_BcalLayers_getXerr, 0,
    (char*)"xerr value",
    NULL},
   {(char*)"xmlns",
    (getter)_BcalLayers_getXmlns, 0,
    (char*)"xmlns string",
    NULL},
   {(char*)"xycorr",
    (getter)_BcalLayers_getXycorr, 0,
    (char*)"xycorr value",
    NULL},
   {(char*)"xzcorr",
    (getter)_BcalLayers_getXzcorr, 0,
    (char*)"xzcorr value",
    NULL},
   {(char*)"y",
    (getter)_BcalLayers_getY, 0,
    (char*)"y value",
    NULL},
   {(char*)"yerr",
    (getter)_BcalLayers_getYerr, 0,
    (char*)"yerr value",
    NULL},
   {(char*)"yzcorr",
    (getter)_BcalLayers_getYzcorr, 0,
    (char*)"yzcorr value",
    NULL},
   {(char*)"z",
    (getter)_BcalLayers_getZ, 0,
    (char*)"z value",
    NULL},
   {(char*)"zerr",
    (getter)_BcalLayers_getZerr, 0,
    (char*)"zerr value",
    NULL},
   {NULL}  /* Sentinel */
};

static PyMemberDef _BcalLayers_members[] = {
   {NULL}  /* Sentinel */
};

static PyMethodDef _BcalLayers_methods[] = {
   {"toString", _BcalLayers_toString, METH_NOARGS,
    "show element as a human-readable string"},
   {"toXML", _BcalLayers_toXML, METH_NOARGS,
    "show element as a XML fragment"},
   {NULL}  /* Sentinel */
};

static PyTypeObject _BcalLayers_type = {
    PyVarObject_HEAD_INIT(NULL,0)
    "hddm_r.BcalLayers",         /*tp_name*/
    sizeof(_BcalLayers),          /*tp_basicsize*/
    0,                         /*tp_itemsize*/
    (destructor)_BcalLayers_dealloc, /*tp_dealloc*/
    0,                         /*tp_print*/
    0,                         /*tp_getattr*/
    0,                         /*tp_setattr*/
    0,                         /*tp_compare*/
    0,                         /*tp_repr*/
    0,                         /*tp_as_number*/
    0,                         /*tp_as_sequence*/
    0,                         /*tp_as_mapping*/
    0,                         /*tp_hash */
    0,                         /*tp_call*/
    (reprfunc)_BcalLayers_toString,         /*tp_str*/
    0,                         /*tp_getattro*/
    0,                         /*tp_setattro*/
    0,                         /*tp_as_buffer*/
    Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE, /*tp_flags*/
    "hddm_r bcalLayers element",  /* tp_doc */
    0,                         /* tp_traverse */
    0,                         /* tp_clear */
    0,                         /* tp_richcompare */
    0,                         /* tp_weaklistoffset */
    0,                         /* tp_iter */
    0,                         /* tp_iternext */
    _BcalLayers_methods,          /* tp_methods */
    _BcalLayers_members,          /* tp_members */
    _BcalLayers_getsetters,       /* tp_getset */
    &_HDDM_Element_type,       /* tp_base */
    0,                         /* tp_dict */
    0,                         /* tp_descr_get */
    0,                         /* tp_descr_set */
    0,                         /* tp_dictoffset */
    (initproc)_BcalLayers_init,   /* tp_init */
    0,                         /* tp_alloc */
    _BcalLayers_new,              /* tp_new */
};



// wrap element class hddm_r::BcalShower as hddm_r.BcalShower

typedef struct {
   PyObject_HEAD
   BcalShower *elem;
   PyObject *host;
} _BcalShower;

static void
_BcalShower_dealloc(_BcalShower* self)
{
   if (self->elem != 0) {
      LOG_DEALLOC(Py_TYPE(self), 0, self->host == (PyObject*)self);
      if (self->host == (PyObject*)self)
         delete self->elem;
      else
         My_DECREF(self->host);
   }
   Py_TYPE(self)->tp_free((PyObject*)self);
}

static PyObject*
_BcalShower_new(PyTypeObject *type, PyObject *args, PyObject *kwds)
{
   _BcalShower *self;
   self = (_BcalShower*)type->tp_alloc(type, 0);
   if (self != NULL) {
      self->elem = 0;
      self->host = 0;
   }
   return (PyObject*)self;
}

static int
_BcalShower_init(_BcalShower *self, PyObject *args, PyObject *kwds)
{
   PyErr_SetString(PyExc_RuntimeError, "illegal constructor");
   return -1;
}

static PyObject*
_BcalShower_getClass(_BcalShower *self, void *closure)
{
   std::string val(self->elem->getClass());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_BcalShower_getVersion(_BcalShower *self, void *closure)
{
   std::string val(self->elem->getVersion());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_BcalShower_getXmlns(_BcalShower *self, void *closure)
{
   std::string val(self->elem->getXmlns());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_BcalShower_getEventNo(_BcalShower *self, void *closure)
{
   return PyLong_FromLongLong(self->elem->getEventNo());
}

static PyObject*
_BcalShower_getRunNo(_BcalShower *self, void *closure)
{
   return PyLong_FromLong(self->elem->getRunNo());
}

static PyObject*
_BcalShower_getE(_BcalShower *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getE());
}

static int
_BcalShower_setE(_BcalShower *self, PyObject *value, void *closure)
{
   double var = PyFloat_AsDouble(value);
   if (var == -1 && PyErr_Occurred()) {
      return 1;
   }
   self->elem->setE((float)var);
   return 0;
}

static PyObject*
_BcalShower_getEerr(_BcalShower *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getEerr());
}

static int
_BcalShower_setEerr(_BcalShower *self, PyObject *value, void *closure)
{
   double var = PyFloat_AsDouble(value);
   if (var == -1 && PyErr_Occurred()) {
      return 1;
   }
   self->elem->setEerr((float)var);
   return 0;
}

static PyObject*
_BcalShower_getEunit(_BcalShower *self, void *closure)
{
   std::string val(self->elem->getEunit());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_BcalShower_getEzcorr(_BcalShower *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getEzcorr());
}

static int
_BcalShower_setEzcorr(_BcalShower *self, PyObject *value, void *closure)
{
   double var = PyFloat_AsDouble(value);
   if (var == -1 && PyErr_Occurred()) {
      return 1;
   }
   self->elem->setEzcorr((float)var);
   return 0;
}

static PyObject*
_BcalShower_getJtag(_BcalShower *self, void *closure)
{
   std::string val(self->elem->getJtag());
   return PyUnicode_FromString(val.c_str());
}

static int
_BcalShower_setJtag(_BcalShower *self, PyObject *value, void *closure)
{
   PyObject *str=0;
   if (PyUnicode_Check(value))
      str = PyUnicode_AsEncodedString(value, "ASCII", "strict");
   else
      str = value;
#if PY_MAJOR_VERSION < 3
   char *var = PyString_AsString(str);
#else
   char *var = PyBytes_AsString(str);
#endif
   if (var == 0) {
      return -1;
   }
   self->elem->setJtag(std::string(var));
   if (str != value) {
      Py_DECREF(str);
   }
   return 0;
}

static PyObject*
_BcalShower_getLunit(_BcalShower *self, void *closure)
{
   std::string val(self->elem->getLunit());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_BcalShower_getMaxOccurs(_BcalShower *self, void *closure)
{
   std::string val(self->elem->getMaxOccurs());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_BcalShower_getMinOccurs(_BcalShower *self, void *closure)
{
   return PyLong_FromLong(self->elem->getMinOccurs());
}

static PyObject*
_BcalShower_getT(_BcalShower *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getT());
}

static int
_BcalShower_setT(_BcalShower *self, PyObject *value, void *closure)
{
   double var = PyFloat_AsDouble(value);
   if (var == -1 && PyErr_Occurred()) {
      return 1;
   }
   self->elem->setT((float)var);
   return 0;
}

static PyObject*
_BcalShower_getTerr(_BcalShower *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getTerr());
}

static int
_BcalShower_setTerr(_BcalShower *self, PyObject *value, void *closure)
{
   double var = PyFloat_AsDouble(value);
   if (var == -1 && PyErr_Occurred()) {
      return 1;
   }
   self->elem->setTerr((float)var);
   return 0;
}

static PyObject*
_BcalShower_getTunit(_BcalShower *self, void *closure)
{
   std::string val(self->elem->getTunit());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_BcalShower_getTzcorr(_BcalShower *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getTzcorr());
}

static int
_BcalShower_setTzcorr(_BcalShower *self, PyObject *value, void *closure)
{
   double var = PyFloat_AsDouble(value);
   if (var == -1 && PyErr_Occurred()) {
      return 1;
   }
   self->elem->setTzcorr((float)var);
   return 0;
}

static PyObject*
_BcalShower_getX(_BcalShower *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getX());
}

static int
_BcalShower_setX(_BcalShower *self, PyObject *value, void *closure)
{
   double var = PyFloat_AsDouble(value);
   if (var == -1 && PyErr_Occurred()) {
      return 1;
   }
   self->elem->setX((float)var);
   return 0;
}

static PyObject*
_BcalShower_getXerr(_BcalShower *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getXerr());
}

static int
_BcalShower_setXerr(_BcalShower *self, PyObject *value, void *closure)
{
   double var = PyFloat_AsDouble(value);
   if (var == -1 && PyErr_Occurred()) {
      return 1;
   }
   self->elem->setXerr((float)var);
   return 0;
}

static PyObject*
_BcalShower_getXycorr(_BcalShower *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getXycorr());
}

static int
_BcalShower_setXycorr(_BcalShower *self, PyObject *value, void *closure)
{
   double var = PyFloat_AsDouble(value);
   if (var == -1 && PyErr_Occurred()) {
      return 1;
   }
   self->elem->setXycorr((float)var);
   return 0;
}

static PyObject*
_BcalShower_getXzcorr(_BcalShower *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getXzcorr());
}

static int
_BcalShower_setXzcorr(_BcalShower *self, PyObject *value, void *closure)
{
   double var = PyFloat_AsDouble(value);
   if (var == -1 && PyErr_Occurred()) {
      return 1;
   }
   self->elem->setXzcorr((float)var);
   return 0;
}

static PyObject*
_BcalShower_getY(_BcalShower *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getY());
}

static int
_BcalShower_setY(_BcalShower *self, PyObject *value, void *closure)
{
   double var = PyFloat_AsDouble(value);
   if (var == -1 && PyErr_Occurred()) {
      return 1;
   }
   self->elem->setY((float)var);
   return 0;
}

static PyObject*
_BcalShower_getYerr(_BcalShower *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getYerr());
}

static int
_BcalShower_setYerr(_BcalShower *self, PyObject *value, void *closure)
{
   double var = PyFloat_AsDouble(value);
   if (var == -1 && PyErr_Occurred()) {
      return 1;
   }
   self->elem->setYerr((float)var);
   return 0;
}

static PyObject*
_BcalShower_getYzcorr(_BcalShower *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getYzcorr());
}

static int
_BcalShower_setYzcorr(_BcalShower *self, PyObject *value, void *closure)
{
   double var = PyFloat_AsDouble(value);
   if (var == -1 && PyErr_Occurred()) {
      return 1;
   }
   self->elem->setYzcorr((float)var);
   return 0;
}

static PyObject*
_BcalShower_getZ(_BcalShower *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getZ());
}

static int
_BcalShower_setZ(_BcalShower *self, PyObject *value, void *closure)
{
   double var = PyFloat_AsDouble(value);
   if (var == -1 && PyErr_Occurred()) {
      return 1;
   }
   self->elem->setZ((float)var);
   return 0;
}

static PyObject*
_BcalShower_getZerr(_BcalShower *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getZerr());
}

static int
_BcalShower_setZerr(_BcalShower *self, PyObject *value, void *closure)
{
   double var = PyFloat_AsDouble(value);
   if (var == -1 && PyErr_Occurred()) {
      return 1;
   }
   self->elem->setZerr((float)var);
   return 0;
}

static PyObject*
_BcalShower_getPreshower(PyObject *self, PyObject *args)
{
   int index=0;
   if (! PyArg_ParseTuple(args, "|i", &index)) {
      return NULL;
   }
   _BcalShower *me = (_BcalShower*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid bcalShower element");
      return NULL;
   }
   PyObject *obj = _Preshower_new(&_Preshower_type, 0, 0);
   ((_Preshower*)obj)->elem = &me->elem->getPreshower();
   ((_Preshower*)obj)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(obj));
   return obj;
}

static PyObject*
_BcalShower_getPreshowers(PyObject *self, PyObject *args)
{
   _BcalShower *me = (_BcalShower*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid bcalShower element");
      return NULL;
   }
   PyObject *list = _HDDM_ElementList_new(&_HDDM_ElementList_type, 0, 0);
   ((_HDDM_ElementList*)list)->subtype = &_Preshower_type;
   ((_HDDM_ElementList*)list)->list = (HDDM_ElementList<HDDM_Element>*)
    &me->elem->getPreshowers();
   ((_HDDM_ElementList*)list)->borrowed = 1;
   ((_HDDM_ElementList*)list)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(list), ((_HDDM_ElementList*)list)->subtype, 0);
   return list;
}

static PyObject*
_BcalShower_addPreshowers(PyObject *self, PyObject *args)
{
   int count=1;
   int start=-1;
   if (! PyArg_ParseTuple(args, "|ii", &count, &start)) {
      return NULL;
   }
   _BcalShower *me = (_BcalShower*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "add attempted on invalid bcalShower element");
      return NULL;
   }
   PyObject *list = _HDDM_ElementList_new(&_HDDM_ElementList_type, 0, 0);
   ((_HDDM_ElementList*)list)->subtype = &_Preshower_type;
   ((_HDDM_ElementList*)list)->list = (HDDM_ElementList<HDDM_Element>*)
    new PreshowerList(me->elem->addPreshowers(count, start));
   ((_HDDM_ElementList*)list)->borrowed = 0;
   ((_HDDM_ElementList*)list)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(list), ((_HDDM_ElementList*)list)->subtype, 1);
   return list;
}

static PyObject*
_BcalShower_deletePreshowers(PyObject *self, PyObject *args)
{
   int count=-1;
   int start=0;
   if (! PyArg_ParseTuple(args, "|ii", &count, &start)) {
      return NULL;
   }
   _BcalShower *me = (_BcalShower*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "delete attempted on invalid bcalShower element");
      return NULL;
   }
   me->elem->deletePreshowers(count, start);
   Py_INCREF(Py_None);
   return Py_None;
}

static PyObject*
_BcalShower_getWidth(PyObject *self, PyObject *args)
{
   int index=0;
   if (! PyArg_ParseTuple(args, "|i", &index)) {
      return NULL;
   }
   _BcalShower *me = (_BcalShower*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid bcalShower element");
      return NULL;
   }
   PyObject *obj = _Width_new(&_Width_type, 0, 0);
   ((_Width*)obj)->elem = &me->elem->getWidth();
   ((_Width*)obj)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(obj));
   return obj;
}

static PyObject*
_BcalShower_getWidths(PyObject *self, PyObject *args)
{
   _BcalShower *me = (_BcalShower*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid bcalShower element");
      return NULL;
   }
   PyObject *list = _HDDM_ElementList_new(&_HDDM_ElementList_type, 0, 0);
   ((_HDDM_ElementList*)list)->subtype = &_Width_type;
   ((_HDDM_ElementList*)list)->list = (HDDM_ElementList<HDDM_Element>*)
    &me->elem->getWidths();
   ((_HDDM_ElementList*)list)->borrowed = 1;
   ((_HDDM_ElementList*)list)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(list), ((_HDDM_ElementList*)list)->subtype, 0);
   return list;
}

static PyObject*
_BcalShower_addWidths(PyObject *self, PyObject *args)
{
   int count=1;
   int start=-1;
   if (! PyArg_ParseTuple(args, "|ii", &count, &start)) {
      return NULL;
   }
   _BcalShower *me = (_BcalShower*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "add attempted on invalid bcalShower element");
      return NULL;
   }
   PyObject *list = _HDDM_ElementList_new(&_HDDM_ElementList_type, 0, 0);
   ((_HDDM_ElementList*)list)->subtype = &_Width_type;
   ((_HDDM_ElementList*)list)->list = (HDDM_ElementList<HDDM_Element>*)
    new WidthList(me->elem->addWidths(count, start));
   ((_HDDM_ElementList*)list)->borrowed = 0;
   ((_HDDM_ElementList*)list)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(list), ((_HDDM_ElementList*)list)->subtype, 1);
   return list;
}

static PyObject*
_BcalShower_deleteWidths(PyObject *self, PyObject *args)
{
   int count=-1;
   int start=0;
   if (! PyArg_ParseTuple(args, "|ii", &count, &start)) {
      return NULL;
   }
   _BcalShower *me = (_BcalShower*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "delete attempted on invalid bcalShower element");
      return NULL;
   }
   me->elem->deleteWidths(count, start);
   Py_INCREF(Py_None);
   return Py_None;
}

static PyObject*
_BcalShower_getBcalCluster(PyObject *self, PyObject *args)
{
   int index=0;
   if (! PyArg_ParseTuple(args, "|i", &index)) {
      return NULL;
   }
   _BcalShower *me = (_BcalShower*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid bcalShower element");
      return NULL;
   }
   PyObject *obj = _BcalCluster_new(&_BcalCluster_type, 0, 0);
   ((_BcalCluster*)obj)->elem = &me->elem->getBcalCluster();
   ((_BcalCluster*)obj)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(obj));
   return obj;
}

static PyObject*
_BcalShower_getBcalClusters(PyObject *self, PyObject *args)
{
   _BcalShower *me = (_BcalShower*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid bcalShower element");
      return NULL;
   }
   PyObject *list = _HDDM_ElementList_new(&_HDDM_ElementList_type, 0, 0);
   ((_HDDM_ElementList*)list)->subtype = &_BcalCluster_type;
   ((_HDDM_ElementList*)list)->list = (HDDM_ElementList<HDDM_Element>*)
    &me->elem->getBcalClusters();
   ((_HDDM_ElementList*)list)->borrowed = 1;
   ((_HDDM_ElementList*)list)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(list), ((_HDDM_ElementList*)list)->subtype, 0);
   return list;
}

static PyObject*
_BcalShower_addBcalClusters(PyObject *self, PyObject *args)
{
   int count=1;
   int start=-1;
   if (! PyArg_ParseTuple(args, "|ii", &count, &start)) {
      return NULL;
   }
   _BcalShower *me = (_BcalShower*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "add attempted on invalid bcalShower element");
      return NULL;
   }
   PyObject *list = _HDDM_ElementList_new(&_HDDM_ElementList_type, 0, 0);
   ((_HDDM_ElementList*)list)->subtype = &_BcalCluster_type;
   ((_HDDM_ElementList*)list)->list = (HDDM_ElementList<HDDM_Element>*)
    new BcalClusterList(me->elem->addBcalClusters(count, start));
   ((_HDDM_ElementList*)list)->borrowed = 0;
   ((_HDDM_ElementList*)list)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(list), ((_HDDM_ElementList*)list)->subtype, 1);
   return list;
}

static PyObject*
_BcalShower_deleteBcalClusters(PyObject *self, PyObject *args)
{
   int count=-1;
   int start=0;
   if (! PyArg_ParseTuple(args, "|ii", &count, &start)) {
      return NULL;
   }
   _BcalShower *me = (_BcalShower*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "delete attempted on invalid bcalShower element");
      return NULL;
   }
   me->elem->deleteBcalClusters(count, start);
   Py_INCREF(Py_None);
   return Py_None;
}

static PyObject*
_BcalShower_getBcalCorrelations(PyObject *self, PyObject *args)
{
   int index=0;
   if (! PyArg_ParseTuple(args, "|i", &index)) {
      return NULL;
   }
   _BcalShower *me = (_BcalShower*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid bcalShower element");
      return NULL;
   }
   PyObject *obj = _BcalCorrelations_new(&_BcalCorrelations_type, 0, 0);
   ((_BcalCorrelations*)obj)->elem = &me->elem->getBcalCorrelations();
   ((_BcalCorrelations*)obj)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(obj));
   return obj;
}

static PyObject*
_BcalShower_getBcalCorrelationses(PyObject *self, PyObject *args)
{
   _BcalShower *me = (_BcalShower*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid bcalShower element");
      return NULL;
   }
   PyObject *list = _HDDM_ElementList_new(&_HDDM_ElementList_type, 0, 0);
   ((_HDDM_ElementList*)list)->subtype = &_BcalCorrelations_type;
   ((_HDDM_ElementList*)list)->list = (HDDM_ElementList<HDDM_Element>*)
    &me->elem->getBcalCorrelationses();
   ((_HDDM_ElementList*)list)->borrowed = 1;
   ((_HDDM_ElementList*)list)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(list), ((_HDDM_ElementList*)list)->subtype, 0);
   return list;
}

static PyObject*
_BcalShower_addBcalCorrelationses(PyObject *self, PyObject *args)
{
   int count=1;
   int start=-1;
   if (! PyArg_ParseTuple(args, "|ii", &count, &start)) {
      return NULL;
   }
   _BcalShower *me = (_BcalShower*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "add attempted on invalid bcalShower element");
      return NULL;
   }
   PyObject *list = _HDDM_ElementList_new(&_HDDM_ElementList_type, 0, 0);
   ((_HDDM_ElementList*)list)->subtype = &_BcalCorrelations_type;
   ((_HDDM_ElementList*)list)->list = (HDDM_ElementList<HDDM_Element>*)
    new BcalCorrelationsList(me->elem->addBcalCorrelationses(count, start));
   ((_HDDM_ElementList*)list)->borrowed = 0;
   ((_HDDM_ElementList*)list)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(list), ((_HDDM_ElementList*)list)->subtype, 1);
   return list;
}

static PyObject*
_BcalShower_deleteBcalCorrelationses(PyObject *self, PyObject *args)
{
   int count=-1;
   int start=0;
   if (! PyArg_ParseTuple(args, "|ii", &count, &start)) {
      return NULL;
   }
   _BcalShower *me = (_BcalShower*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "delete attempted on invalid bcalShower element");
      return NULL;
   }
   me->elem->deleteBcalCorrelationses(count, start);
   Py_INCREF(Py_None);
   return Py_None;
}

static PyObject*
_BcalShower_getBcalLayers(PyObject *self, PyObject *args)
{
   int index=0;
   if (! PyArg_ParseTuple(args, "|i", &index)) {
      return NULL;
   }
   _BcalShower *me = (_BcalShower*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid bcalShower element");
      return NULL;
   }
   PyObject *obj = _BcalLayers_new(&_BcalLayers_type, 0, 0);
   ((_BcalLayers*)obj)->elem = &me->elem->getBcalLayers();
   ((_BcalLayers*)obj)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(obj));
   return obj;
}

static PyObject*
_BcalShower_getBcalLayerses(PyObject *self, PyObject *args)
{
   _BcalShower *me = (_BcalShower*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid bcalShower element");
      return NULL;
   }
   PyObject *list = _HDDM_ElementList_new(&_HDDM_ElementList_type, 0, 0);
   ((_HDDM_ElementList*)list)->subtype = &_BcalLayers_type;
   ((_HDDM_ElementList*)list)->list = (HDDM_ElementList<HDDM_Element>*)
    &me->elem->getBcalLayerses();
   ((_HDDM_ElementList*)list)->borrowed = 1;
   ((_HDDM_ElementList*)list)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(list), ((_HDDM_ElementList*)list)->subtype, 0);
   return list;
}

static PyObject*
_BcalShower_addBcalLayerses(PyObject *self, PyObject *args)
{
   int count=1;
   int start=-1;
   if (! PyArg_ParseTuple(args, "|ii", &count, &start)) {
      return NULL;
   }
   _BcalShower *me = (_BcalShower*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "add attempted on invalid bcalShower element");
      return NULL;
   }
   PyObject *list = _HDDM_ElementList_new(&_HDDM_ElementList_type, 0, 0);
   ((_HDDM_ElementList*)list)->subtype = &_BcalLayers_type;
   ((_HDDM_ElementList*)list)->list = (HDDM_ElementList<HDDM_Element>*)
    new BcalLayersList(me->elem->addBcalLayerses(count, start));
   ((_HDDM_ElementList*)list)->borrowed = 0;
   ((_HDDM_ElementList*)list)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(list), ((_HDDM_ElementList*)list)->subtype, 1);
   return list;
}

static PyObject*
_BcalShower_deleteBcalLayerses(PyObject *self, PyObject *args)
{
   int count=-1;
   int start=0;
   if (! PyArg_ParseTuple(args, "|ii", &count, &start)) {
      return NULL;
   }
   _BcalShower *me = (_BcalShower*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "delete attempted on invalid bcalShower element");
      return NULL;
   }
   me->elem->deleteBcalLayerses(count, start);
   Py_INCREF(Py_None);
   return Py_None;
}

static PyObject*
_BcalShower_toString(PyObject *self, PyObject *args=0)
{
   _BcalShower *me = (_BcalShower*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid bcalShower element");
      return NULL;
   }
   std::string str(me->elem->toString());
   return PyUnicode_FromString(str.c_str());
}

static PyObject*
_BcalShower_toXML(PyObject *self, PyObject *args=0)
{
   _BcalShower *me = (_BcalShower*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid bcalShower element");
      return NULL;
   }
   std::string str(me->elem->toXML());
   return PyUnicode_FromString(str.c_str());
}

static PyGetSetDef _BcalShower_getsetters[] = {
   {(char*)"E",
    (getter)_BcalShower_getE, (setter)_BcalShower_setE,
    (char*)"E value",
    NULL},
   {(char*)"Eerr",
    (getter)_BcalShower_getEerr, (setter)_BcalShower_setEerr,
    (char*)"Eerr value",
    NULL},
   {(char*)"Eunit",
    (getter)_BcalShower_getEunit, 0,
    (char*)"Eunit value",
    NULL},
   {(char*)"Ezcorr",
    (getter)_BcalShower_getEzcorr, (setter)_BcalShower_setEzcorr,
    (char*)"Ezcorr value",
    NULL},
   {(char*)"class",
    (getter)_BcalShower_getClass, 0,
    (char*)"class string",
    NULL},
   {(char*)"eventNo",
    (getter)_BcalShower_getEventNo, 0,
    (char*)"eventNo value",
    NULL},
   {(char*)"jtag",
    (getter)_BcalShower_getJtag, (setter)_BcalShower_setJtag,
    (char*)"jtag string",
    NULL},
   {(char*)"lunit",
    (getter)_BcalShower_getLunit, 0,
    (char*)"lunit value",
    NULL},
   {(char*)"maxOccurs",
    (getter)_BcalShower_getMaxOccurs, 0,
    (char*)"maxOccurs value",
    NULL},
   {(char*)"minOccurs",
    (getter)_BcalShower_getMinOccurs, 0,
    (char*)"minOccurs value",
    NULL},
   {(char*)"runNo",
    (getter)_BcalShower_getRunNo, 0,
    (char*)"runNo value",
    NULL},
   {(char*)"t",
    (getter)_BcalShower_getT, (setter)_BcalShower_setT,
    (char*)"t value",
    NULL},
   {(char*)"terr",
    (getter)_BcalShower_getTerr, (setter)_BcalShower_setTerr,
    (char*)"terr value",
    NULL},
   {(char*)"tunit",
    (getter)_BcalShower_getTunit, 0,
    (char*)"tunit value",
    NULL},
   {(char*)"tzcorr",
    (getter)_BcalShower_getTzcorr, (setter)_BcalShower_setTzcorr,
    (char*)"tzcorr value",
    NULL},
   {(char*)"version",
    (getter)_BcalShower_getVersion, 0,
    (char*)"version string",
    NULL},
   {(char*)"x",
    (getter)_BcalShower_getX, (setter)_BcalShower_setX,
    (char*)"x value",
    NULL},
   {(char*)"xerr",
    (getter)_BcalShower_getXerr, (setter)_BcalShower_setXerr,
    (char*)"xerr value",
    NULL},
   {(char*)"xmlns",
    (getter)_BcalShower_getXmlns, 0,
    (char*)"xmlns string",
    NULL},
   {(char*)"xycorr",
    (getter)_BcalShower_getXycorr, (setter)_BcalShower_setXycorr,
    (char*)"xycorr value",
    NULL},
   {(char*)"xzcorr",
    (getter)_BcalShower_getXzcorr, (setter)_BcalShower_setXzcorr,
    (char*)"xzcorr value",
    NULL},
   {(char*)"y",
    (getter)_BcalShower_getY, (setter)_BcalShower_setY,
    (char*)"y value",
    NULL},
   {(char*)"yerr",
    (getter)_BcalShower_getYerr, (setter)_BcalShower_setYerr,
    (char*)"yerr value",
    NULL},
   {(char*)"yzcorr",
    (getter)_BcalShower_getYzcorr, (setter)_BcalShower_setYzcorr,
    (char*)"yzcorr value",
    NULL},
   {(char*)"z",
    (getter)_BcalShower_getZ, (setter)_BcalShower_setZ,
    (char*)"z value",
    NULL},
   {(char*)"zerr",
    (getter)_BcalShower_getZerr, (setter)_BcalShower_setZerr,
    (char*)"zerr value",
    NULL},
   {NULL}  /* Sentinel */
};

static PyMemberDef _BcalShower_members[] = {
   {NULL}  /* Sentinel */
};

static PyMethodDef _BcalShower_methods[] = {
   {"addBcalClusters", _BcalShower_addBcalClusters, METH_VARARGS,
    "extend (or insert into) the list of bcalCluster objects for this bcalShower"},
   {"addBcalCorrelationses", _BcalShower_addBcalCorrelationses, METH_VARARGS,
    "extend (or insert into) the list of bcalCorrelations objects for this bcalShower"},
   {"addBcalLayerses", _BcalShower_addBcalLayerses, METH_VARARGS,
    "extend (or insert into) the list of bcalLayers objects for this bcalShower"},
   {"addPreshowers", _BcalShower_addPreshowers, METH_VARARGS,
    "extend (or insert into) the list of preshower objects for this bcalShower"},
   {"addWidths", _BcalShower_addWidths, METH_VARARGS,
    "extend (or insert into) the list of width objects for this bcalShower"},
   {"deleteBcalClusters", _BcalShower_deleteBcalClusters, METH_VARARGS,
    "delete bcalCluster objects for this bcalShower"},
   {"deleteBcalCorrelationses", _BcalShower_deleteBcalCorrelationses, METH_VARARGS,
    "delete bcalCorrelations objects for this bcalShower"},
   {"deleteBcalLayerses", _BcalShower_deleteBcalLayerses, METH_VARARGS,
    "delete bcalLayers objects for this bcalShower"},
   {"deletePreshowers", _BcalShower_deletePreshowers, METH_VARARGS,
    "delete preshower objects for this bcalShower"},
   {"deleteWidths", _BcalShower_deleteWidths, METH_VARARGS,
    "delete width objects for this bcalShower"},
   {"getBcalCluster", _BcalShower_getBcalCluster, METH_VARARGS,
    "get an individual bcalCluster object from this bcalShower"},
   {"getBcalClusters", _BcalShower_getBcalClusters, METH_NOARGS,
    "get list of bcalCluster objects for this bcalShower"},
   {"getBcalCorrelations", _BcalShower_getBcalCorrelations, METH_VARARGS,
    "get an individual bcalCorrelations object from this bcalShower"},
   {"getBcalCorrelationses", _BcalShower_getBcalCorrelationses, METH_NOARGS,
    "get list of bcalCorrelations objects for this bcalShower"},
   {"getBcalLayers", _BcalShower_getBcalLayers, METH_VARARGS,
    "get an individual bcalLayers object from this bcalShower"},
   {"getBcalLayerses", _BcalShower_getBcalLayerses, METH_NOARGS,
    "get list of bcalLayers objects for this bcalShower"},
   {"getPreshower", _BcalShower_getPreshower, METH_VARARGS,
    "get an individual preshower object from this bcalShower"},
   {"getPreshowers", _BcalShower_getPreshowers, METH_NOARGS,
    "get list of preshower objects for this bcalShower"},
   {"getWidth", _BcalShower_getWidth, METH_VARARGS,
    "get an individual width object from this bcalShower"},
   {"getWidths", _BcalShower_getWidths, METH_NOARGS,
    "get list of width objects for this bcalShower"},
   {"toString", _BcalShower_toString, METH_NOARGS,
    "show element as a human-readable string"},
   {"toXML", _BcalShower_toXML, METH_NOARGS,
    "show element as a XML fragment"},
   {NULL}  /* Sentinel */
};

static PyTypeObject _BcalShower_type = {
    PyVarObject_HEAD_INIT(NULL,0)
    "hddm_r.BcalShower",         /*tp_name*/
    sizeof(_BcalShower),          /*tp_basicsize*/
    0,                         /*tp_itemsize*/
    (destructor)_BcalShower_dealloc, /*tp_dealloc*/
    0,                         /*tp_print*/
    0,                         /*tp_getattr*/
    0,                         /*tp_setattr*/
    0,                         /*tp_compare*/
    0,                         /*tp_repr*/
    0,                         /*tp_as_number*/
    0,                         /*tp_as_sequence*/
    0,                         /*tp_as_mapping*/
    0,                         /*tp_hash */
    0,                         /*tp_call*/
    (reprfunc)_BcalShower_toString,         /*tp_str*/
    0,                         /*tp_getattro*/
    0,                         /*tp_setattro*/
    0,                         /*tp_as_buffer*/
    Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE, /*tp_flags*/
    "hddm_r bcalShower element",  /* tp_doc */
    0,                         /* tp_traverse */
    0,                         /* tp_clear */
    0,                         /* tp_richcompare */
    0,                         /* tp_weaklistoffset */
    0,                         /* tp_iter */
    0,                         /* tp_iternext */
    _BcalShower_methods,          /* tp_methods */
    _BcalShower_members,          /* tp_members */
    _BcalShower_getsetters,       /* tp_getset */
    &_HDDM_Element_type,       /* tp_base */
    0,                         /* tp_dict */
    0,                         /* tp_descr_get */
    0,                         /* tp_descr_set */
    0,                         /* tp_dictoffset */
    (initproc)_BcalShower_init,   /* tp_init */
    0,                         /* tp_alloc */
    _BcalShower_new,              /* tp_new */
};



// wrap element class hddm_r::CcalShower as hddm_r.CcalShower

typedef struct {
   PyObject_HEAD
   CcalShower *elem;
   PyObject *host;
} _CcalShower;

static void
_CcalShower_dealloc(_CcalShower* self)
{
   if (self->elem != 0) {
      LOG_DEALLOC(Py_TYPE(self), 0, self->host == (PyObject*)self);
      if (self->host == (PyObject*)self)
         delete self->elem;
      else
         My_DECREF(self->host);
   }
   Py_TYPE(self)->tp_free((PyObject*)self);
}

static PyObject*
_CcalShower_new(PyTypeObject *type, PyObject *args, PyObject *kwds)
{
   _CcalShower *self;
   self = (_CcalShower*)type->tp_alloc(type, 0);
   if (self != NULL) {
      self->elem = 0;
      self->host = 0;
   }
   return (PyObject*)self;
}

static int
_CcalShower_init(_CcalShower *self, PyObject *args, PyObject *kwds)
{
   PyErr_SetString(PyExc_RuntimeError, "illegal constructor");
   return -1;
}

static PyObject*
_CcalShower_getClass(_CcalShower *self, void *closure)
{
   std::string val(self->elem->getClass());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_CcalShower_getVersion(_CcalShower *self, void *closure)
{
   std::string val(self->elem->getVersion());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_CcalShower_getXmlns(_CcalShower *self, void *closure)
{
   std::string val(self->elem->getXmlns());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_CcalShower_getEventNo(_CcalShower *self, void *closure)
{
   return PyLong_FromLongLong(self->elem->getEventNo());
}

static PyObject*
_CcalShower_getRunNo(_CcalShower *self, void *closure)
{
   return PyLong_FromLong(self->elem->getRunNo());
}

static PyObject*
_CcalShower_getE(_CcalShower *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getE());
}

static int
_CcalShower_setE(_CcalShower *self, PyObject *value, void *closure)
{
   double var = PyFloat_AsDouble(value);
   if (var == -1 && PyErr_Occurred()) {
      return 1;
   }
   self->elem->setE((float)var);
   return 0;
}

static PyObject*
_CcalShower_getEerr(_CcalShower *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getEerr());
}

static int
_CcalShower_setEerr(_CcalShower *self, PyObject *value, void *closure)
{
   double var = PyFloat_AsDouble(value);
   if (var == -1 && PyErr_Occurred()) {
      return 1;
   }
   self->elem->setEerr((float)var);
   return 0;
}

static PyObject*
_CcalShower_getEmax(_CcalShower *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getEmax());
}

static int
_CcalShower_setEmax(_CcalShower *self, PyObject *value, void *closure)
{
   double var = PyFloat_AsDouble(value);
   if (var == -1 && PyErr_Occurred()) {
      return 1;
   }
   self->elem->setEmax((float)var);
   return 0;
}

static PyObject*
_CcalShower_getEunit(_CcalShower *self, void *closure)
{
   std::string val(self->elem->getEunit());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_CcalShower_getChi2(_CcalShower *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getChi2());
}

static int
_CcalShower_setChi2(_CcalShower *self, PyObject *value, void *closure)
{
   double var = PyFloat_AsDouble(value);
   if (var == -1 && PyErr_Occurred()) {
      return 1;
   }
   self->elem->setChi2((float)var);
   return 0;
}

static PyObject*
_CcalShower_getDime(_CcalShower *self, void *closure)
{
   return PyLong_FromLong(self->elem->getDime());
}

static int
_CcalShower_setDime(_CcalShower *self, PyObject *value, void *closure)
{
   long var = PyInt_AsLong(value);
   if (var == -1 && PyErr_Occurred()) {
      return -1;
   }
   self->elem->setDime(var);
   return 0;
}

static PyObject*
_CcalShower_getId(_CcalShower *self, void *closure)
{
   return PyLong_FromLong(self->elem->getId());
}

static int
_CcalShower_setId(_CcalShower *self, PyObject *value, void *closure)
{
   long var = PyInt_AsLong(value);
   if (var == -1 && PyErr_Occurred()) {
      return -1;
   }
   self->elem->setId(var);
   return 0;
}

static PyObject*
_CcalShower_getIdmax(_CcalShower *self, void *closure)
{
   return PyLong_FromLong(self->elem->getIdmax());
}

static int
_CcalShower_setIdmax(_CcalShower *self, PyObject *value, void *closure)
{
   long var = PyInt_AsLong(value);
   if (var == -1 && PyErr_Occurred()) {
      return -1;
   }
   self->elem->setIdmax(var);
   return 0;
}

static PyObject*
_CcalShower_getJtag(_CcalShower *self, void *closure)
{
   std::string val(self->elem->getJtag());
   return PyUnicode_FromString(val.c_str());
}

static int
_CcalShower_setJtag(_CcalShower *self, PyObject *value, void *closure)
{
   PyObject *str=0;
   if (PyUnicode_Check(value))
      str = PyUnicode_AsEncodedString(value, "ASCII", "strict");
   else
      str = value;
#if PY_MAJOR_VERSION < 3
   char *var = PyString_AsString(str);
#else
   char *var = PyBytes_AsString(str);
#endif
   if (var == 0) {
      return -1;
   }
   self->elem->setJtag(std::string(var));
   if (str != value) {
      Py_DECREF(str);
   }
   return 0;
}

static PyObject*
_CcalShower_getLunit(_CcalShower *self, void *closure)
{
   std::string val(self->elem->getLunit());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_CcalShower_getMaxOccurs(_CcalShower *self, void *closure)
{
   std::string val(self->elem->getMaxOccurs());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_CcalShower_getMinOccurs(_CcalShower *self, void *closure)
{
   return PyLong_FromLong(self->elem->getMinOccurs());
}

static PyObject*
_CcalShower_getT(_CcalShower *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getT());
}

static int
_CcalShower_setT(_CcalShower *self, PyObject *value, void *closure)
{
   double var = PyFloat_AsDouble(value);
   if (var == -1 && PyErr_Occurred()) {
      return 1;
   }
   self->elem->setT((float)var);
   return 0;
}

static PyObject*
_CcalShower_getTerr(_CcalShower *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getTerr());
}

static int
_CcalShower_setTerr(_CcalShower *self, PyObject *value, void *closure)
{
   double var = PyFloat_AsDouble(value);
   if (var == -1 && PyErr_Occurred()) {
      return 1;
   }
   self->elem->setTerr((float)var);
   return 0;
}

static PyObject*
_CcalShower_getTunit(_CcalShower *self, void *closure)
{
   std::string val(self->elem->getTunit());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_CcalShower_getType(_CcalShower *self, void *closure)
{
   return PyLong_FromLong(self->elem->getType());
}

static int
_CcalShower_setType(_CcalShower *self, PyObject *value, void *closure)
{
   long var = PyInt_AsLong(value);
   if (var == -1 && PyErr_Occurred()) {
      return -1;
   }
   self->elem->setType(var);
   return 0;
}

static PyObject*
_CcalShower_getX(_CcalShower *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getX());
}

static int
_CcalShower_setX(_CcalShower *self, PyObject *value, void *closure)
{
   double var = PyFloat_AsDouble(value);
   if (var == -1 && PyErr_Occurred()) {
      return 1;
   }
   self->elem->setX((float)var);
   return 0;
}

static PyObject*
_CcalShower_getX1(_CcalShower *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getX1());
}

static int
_CcalShower_setX1(_CcalShower *self, PyObject *value, void *closure)
{
   double var = PyFloat_AsDouble(value);
   if (var == -1 && PyErr_Occurred()) {
      return 1;
   }
   self->elem->setX1((float)var);
   return 0;
}

static PyObject*
_CcalShower_getY(_CcalShower *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getY());
}

static int
_CcalShower_setY(_CcalShower *self, PyObject *value, void *closure)
{
   double var = PyFloat_AsDouble(value);
   if (var == -1 && PyErr_Occurred()) {
      return 1;
   }
   self->elem->setY((float)var);
   return 0;
}

static PyObject*
_CcalShower_getY1(_CcalShower *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getY1());
}

static int
_CcalShower_setY1(_CcalShower *self, PyObject *value, void *closure)
{
   double var = PyFloat_AsDouble(value);
   if (var == -1 && PyErr_Occurred()) {
      return 1;
   }
   self->elem->setY1((float)var);
   return 0;
}

static PyObject*
_CcalShower_getZ(_CcalShower *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getZ());
}

static int
_CcalShower_setZ(_CcalShower *self, PyObject *value, void *closure)
{
   double var = PyFloat_AsDouble(value);
   if (var == -1 && PyErr_Occurred()) {
      return 1;
   }
   self->elem->setZ((float)var);
   return 0;
}

static PyObject*
_CcalShower_toString(PyObject *self, PyObject *args=0)
{
   _CcalShower *me = (_CcalShower*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid ccalShower element");
      return NULL;
   }
   std::string str(me->elem->toString());
   return PyUnicode_FromString(str.c_str());
}

static PyObject*
_CcalShower_toXML(PyObject *self, PyObject *args=0)
{
   _CcalShower *me = (_CcalShower*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid ccalShower element");
      return NULL;
   }
   std::string str(me->elem->toXML());
   return PyUnicode_FromString(str.c_str());
}

static PyGetSetDef _CcalShower_getsetters[] = {
   {(char*)"E",
    (getter)_CcalShower_getE, (setter)_CcalShower_setE,
    (char*)"E value",
    NULL},
   {(char*)"Eerr",
    (getter)_CcalShower_getEerr, (setter)_CcalShower_setEerr,
    (char*)"Eerr value",
    NULL},
   {(char*)"Emax",
    (getter)_CcalShower_getEmax, (setter)_CcalShower_setEmax,
    (char*)"Emax value",
    NULL},
   {(char*)"Eunit",
    (getter)_CcalShower_getEunit, 0,
    (char*)"Eunit value",
    NULL},
   {(char*)"chi2",
    (getter)_CcalShower_getChi2, (setter)_CcalShower_setChi2,
    (char*)"chi2 value",
    NULL},
   {(char*)"class",
    (getter)_CcalShower_getClass, 0,
    (char*)"class string",
    NULL},
   {(char*)"dime",
    (getter)_CcalShower_getDime, (setter)_CcalShower_setDime,
    (char*)"dime value",
    NULL},
   {(char*)"eventNo",
    (getter)_CcalShower_getEventNo, 0,
    (char*)"eventNo value",
    NULL},
   {(char*)"id",
    (getter)_CcalShower_getId, (setter)_CcalShower_setId,
    (char*)"id value",
    NULL},
   {(char*)"idmax",
    (getter)_CcalShower_getIdmax, (setter)_CcalShower_setIdmax,
    (char*)"idmax value",
    NULL},
   {(char*)"jtag",
    (getter)_CcalShower_getJtag, (setter)_CcalShower_setJtag,
    (char*)"jtag string",
    NULL},
   {(char*)"lunit",
    (getter)_CcalShower_getLunit, 0,
    (char*)"lunit value",
    NULL},
   {(char*)"maxOccurs",
    (getter)_CcalShower_getMaxOccurs, 0,
    (char*)"maxOccurs value",
    NULL},
   {(char*)"minOccurs",
    (getter)_CcalShower_getMinOccurs, 0,
    (char*)"minOccurs value",
    NULL},
   {(char*)"runNo",
    (getter)_CcalShower_getRunNo, 0,
    (char*)"runNo value",
    NULL},
   {(char*)"t",
    (getter)_CcalShower_getT, (setter)_CcalShower_setT,
    (char*)"t value",
    NULL},
   {(char*)"terr",
    (getter)_CcalShower_getTerr, (setter)_CcalShower_setTerr,
    (char*)"terr value",
    NULL},
   {(char*)"tunit",
    (getter)_CcalShower_getTunit, 0,
    (char*)"tunit value",
    NULL},
   {(char*)"type",
    (getter)_CcalShower_getType, (setter)_CcalShower_setType,
    (char*)"type value",
    NULL},
   {(char*)"version",
    (getter)_CcalShower_getVersion, 0,
    (char*)"version string",
    NULL},
   {(char*)"x",
    (getter)_CcalShower_getX, (setter)_CcalShower_setX,
    (char*)"x value",
    NULL},
   {(char*)"x1",
    (getter)_CcalShower_getX1, (setter)_CcalShower_setX1,
    (char*)"x1 value",
    NULL},
   {(char*)"xmlns",
    (getter)_CcalShower_getXmlns, 0,
    (char*)"xmlns string",
    NULL},
   {(char*)"y",
    (getter)_CcalShower_getY, (setter)_CcalShower_setY,
    (char*)"y value",
    NULL},
   {(char*)"y1",
    (getter)_CcalShower_getY1, (setter)_CcalShower_setY1,
    (char*)"y1 value",
    NULL},
   {(char*)"z",
    (getter)_CcalShower_getZ, (setter)_CcalShower_setZ,
    (char*)"z value",
    NULL},
   {NULL}  /* Sentinel */
};

static PyMemberDef _CcalShower_members[] = {
   {NULL}  /* Sentinel */
};

static PyMethodDef _CcalShower_methods[] = {
   {"toString", _CcalShower_toString, METH_NOARGS,
    "show element as a human-readable string"},
   {"toXML", _CcalShower_toXML, METH_NOARGS,
    "show element as a XML fragment"},
   {NULL}  /* Sentinel */
};

static PyTypeObject _CcalShower_type = {
    PyVarObject_HEAD_INIT(NULL,0)
    "hddm_r.CcalShower",         /*tp_name*/
    sizeof(_CcalShower),          /*tp_basicsize*/
    0,                         /*tp_itemsize*/
    (destructor)_CcalShower_dealloc, /*tp_dealloc*/
    0,                         /*tp_print*/
    0,                         /*tp_getattr*/
    0,                         /*tp_setattr*/
    0,                         /*tp_compare*/
    0,                         /*tp_repr*/
    0,                         /*tp_as_number*/
    0,                         /*tp_as_sequence*/
    0,                         /*tp_as_mapping*/
    0,                         /*tp_hash */
    0,                         /*tp_call*/
    (reprfunc)_CcalShower_toString,         /*tp_str*/
    0,                         /*tp_getattro*/
    0,                         /*tp_setattro*/
    0,                         /*tp_as_buffer*/
    Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE, /*tp_flags*/
    "hddm_r ccalShower element",  /* tp_doc */
    0,                         /* tp_traverse */
    0,                         /* tp_clear */
    0,                         /* tp_richcompare */
    0,                         /* tp_weaklistoffset */
    0,                         /* tp_iter */
    0,                         /* tp_iternext */
    _CcalShower_methods,          /* tp_methods */
    _CcalShower_members,          /* tp_members */
    _CcalShower_getsetters,       /* tp_getset */
    &_HDDM_Element_type,       /* tp_base */
    0,                         /* tp_dict */
    0,                         /* tp_descr_get */
    0,                         /* tp_descr_set */
    0,                         /* tp_dictoffset */
    (initproc)_CcalShower_init,   /* tp_init */
    0,                         /* tp_alloc */
    _CcalShower_new,              /* tp_new */
};



// wrap element class hddm_r::TrackFit as hddm_r.TrackFit

typedef struct {
   PyObject_HEAD
   TrackFit *elem;
   PyObject *host;
} _TrackFit;

static void
_TrackFit_dealloc(_TrackFit* self)
{
   if (self->elem != 0) {
      LOG_DEALLOC(Py_TYPE(self), 0, self->host == (PyObject*)self);
      if (self->host == (PyObject*)self)
         delete self->elem;
      else
         My_DECREF(self->host);
   }
   Py_TYPE(self)->tp_free((PyObject*)self);
}

static PyObject*
_TrackFit_new(PyTypeObject *type, PyObject *args, PyObject *kwds)
{
   _TrackFit *self;
   self = (_TrackFit*)type->tp_alloc(type, 0);
   if (self != NULL) {
      self->elem = 0;
      self->host = 0;
   }
   return (PyObject*)self;
}

static int
_TrackFit_init(_TrackFit *self, PyObject *args, PyObject *kwds)
{
   PyErr_SetString(PyExc_RuntimeError, "illegal constructor");
   return -1;
}

static PyObject*
_TrackFit_getClass(_TrackFit *self, void *closure)
{
   std::string val(self->elem->getClass());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_TrackFit_getVersion(_TrackFit *self, void *closure)
{
   std::string val(self->elem->getVersion());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_TrackFit_getXmlns(_TrackFit *self, void *closure)
{
   std::string val(self->elem->getXmlns());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_TrackFit_getEventNo(_TrackFit *self, void *closure)
{
   return PyLong_FromLongLong(self->elem->getEventNo());
}

static PyObject*
_TrackFit_getRunNo(_TrackFit *self, void *closure)
{
   return PyLong_FromLong(self->elem->getRunNo());
}

static PyObject*
_TrackFit_getCandidateId(_TrackFit *self, void *closure)
{
   return PyLong_FromLong(self->elem->getCandidateId());
}

static PyObject*
_TrackFit_getJtag(_TrackFit *self, void *closure)
{
   std::string val(self->elem->getJtag());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_TrackFit_getMaxOccurs(_TrackFit *self, void *closure)
{
   std::string val(self->elem->getMaxOccurs());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_TrackFit_getMinOccurs(_TrackFit *self, void *closure)
{
   return PyLong_FromLong(self->elem->getMinOccurs());
}

static PyObject*
_TrackFit_getPtype(_TrackFit *self, void *closure)
{
   Particle_t p(self->elem->getPtype());
   std::string val(ParticleType(p));
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_TrackFit_getNdof(_TrackFit *self, void *closure)
{
   return PyLong_FromLong(self->elem->getNdof());
}

static int
_TrackFit_setNdof(_TrackFit *self, PyObject *value, void *closure)
{
   long var = PyInt_AsLong(value);
   if (var == -1 && PyErr_Occurred()) {
      return -1;
   }
   self->elem->setNdof(var);
   return 0;
}

static PyObject*
_TrackFit_getChisq(_TrackFit *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getChisq());
}

static int
_TrackFit_setChisq(_TrackFit *self, PyObject *value, void *closure)
{
   double var = PyFloat_AsDouble(value);
   if (var == -1 && PyErr_Occurred()) {
      return 1;
   }
   self->elem->setChisq((float)var);
   return 0;
}

static PyObject*
_TrackFit_getE11(_TrackFit *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getE11());
}

static int
_TrackFit_setE11(_TrackFit *self, PyObject *value, void *closure)
{
   double var = PyFloat_AsDouble(value);
   if (var == -1 && PyErr_Occurred()) {
      return 1;
   }
   self->elem->setE11((float)var);
   return 0;
}

static PyObject*
_TrackFit_getE12(_TrackFit *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getE12());
}

static int
_TrackFit_setE12(_TrackFit *self, PyObject *value, void *closure)
{
   double var = PyFloat_AsDouble(value);
   if (var == -1 && PyErr_Occurred()) {
      return 1;
   }
   self->elem->setE12((float)var);
   return 0;
}

static PyObject*
_TrackFit_getE13(_TrackFit *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getE13());
}

static int
_TrackFit_setE13(_TrackFit *self, PyObject *value, void *closure)
{
   double var = PyFloat_AsDouble(value);
   if (var == -1 && PyErr_Occurred()) {
      return 1;
   }
   self->elem->setE13((float)var);
   return 0;
}

static PyObject*
_TrackFit_getE14(_TrackFit *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getE14());
}

static int
_TrackFit_setE14(_TrackFit *self, PyObject *value, void *closure)
{
   double var = PyFloat_AsDouble(value);
   if (var == -1 && PyErr_Occurred()) {
      return 1;
   }
   self->elem->setE14((float)var);
   return 0;
}

static PyObject*
_TrackFit_getE15(_TrackFit *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getE15());
}

static int
_TrackFit_setE15(_TrackFit *self, PyObject *value, void *closure)
{
   double var = PyFloat_AsDouble(value);
   if (var == -1 && PyErr_Occurred()) {
      return 1;
   }
   self->elem->setE15((float)var);
   return 0;
}

static PyObject*
_TrackFit_getE22(_TrackFit *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getE22());
}

static int
_TrackFit_setE22(_TrackFit *self, PyObject *value, void *closure)
{
   double var = PyFloat_AsDouble(value);
   if (var == -1 && PyErr_Occurred()) {
      return 1;
   }
   self->elem->setE22((float)var);
   return 0;
}

static PyObject*
_TrackFit_getE23(_TrackFit *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getE23());
}

static int
_TrackFit_setE23(_TrackFit *self, PyObject *value, void *closure)
{
   double var = PyFloat_AsDouble(value);
   if (var == -1 && PyErr_Occurred()) {
      return 1;
   }
   self->elem->setE23((float)var);
   return 0;
}

static PyObject*
_TrackFit_getE24(_TrackFit *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getE24());
}

static int
_TrackFit_setE24(_TrackFit *self, PyObject *value, void *closure)
{
   double var = PyFloat_AsDouble(value);
   if (var == -1 && PyErr_Occurred()) {
      return 1;
   }
   self->elem->setE24((float)var);
   return 0;
}

static PyObject*
_TrackFit_getE25(_TrackFit *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getE25());
}

static int
_TrackFit_setE25(_TrackFit *self, PyObject *value, void *closure)
{
   double var = PyFloat_AsDouble(value);
   if (var == -1 && PyErr_Occurred()) {
      return 1;
   }
   self->elem->setE25((float)var);
   return 0;
}

static PyObject*
_TrackFit_getE33(_TrackFit *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getE33());
}

static int
_TrackFit_setE33(_TrackFit *self, PyObject *value, void *closure)
{
   double var = PyFloat_AsDouble(value);
   if (var == -1 && PyErr_Occurred()) {
      return 1;
   }
   self->elem->setE33((float)var);
   return 0;
}

static PyObject*
_TrackFit_getE34(_TrackFit *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getE34());
}

static int
_TrackFit_setE34(_TrackFit *self, PyObject *value, void *closure)
{
   double var = PyFloat_AsDouble(value);
   if (var == -1 && PyErr_Occurred()) {
      return 1;
   }
   self->elem->setE34((float)var);
   return 0;
}

static PyObject*
_TrackFit_getE35(_TrackFit *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getE35());
}

static int
_TrackFit_setE35(_TrackFit *self, PyObject *value, void *closure)
{
   double var = PyFloat_AsDouble(value);
   if (var == -1 && PyErr_Occurred()) {
      return 1;
   }
   self->elem->setE35((float)var);
   return 0;
}

static PyObject*
_TrackFit_getE44(_TrackFit *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getE44());
}

static int
_TrackFit_setE44(_TrackFit *self, PyObject *value, void *closure)
{
   double var = PyFloat_AsDouble(value);
   if (var == -1 && PyErr_Occurred()) {
      return 1;
   }
   self->elem->setE44((float)var);
   return 0;
}

static PyObject*
_TrackFit_getE45(_TrackFit *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getE45());
}

static int
_TrackFit_setE45(_TrackFit *self, PyObject *value, void *closure)
{
   double var = PyFloat_AsDouble(value);
   if (var == -1 && PyErr_Occurred()) {
      return 1;
   }
   self->elem->setE45((float)var);
   return 0;
}

static PyObject*
_TrackFit_getE55(_TrackFit *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getE55());
}

static int
_TrackFit_setE55(_TrackFit *self, PyObject *value, void *closure)
{
   double var = PyFloat_AsDouble(value);
   if (var == -1 && PyErr_Occurred()) {
      return 1;
   }
   self->elem->setE55((float)var);
   return 0;
}

static PyObject*
_TrackFit_getLunit(_TrackFit *self, void *closure)
{
   std::string val(self->elem->getLunit());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_TrackFit_getPunit(_TrackFit *self, void *closure)
{
   std::string val(self->elem->getPunit());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_TrackFit_getPx(_TrackFit *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getPx());
}

static int
_TrackFit_setPx(_TrackFit *self, PyObject *value, void *closure)
{
   double var = PyFloat_AsDouble(value);
   if (var == -1 && PyErr_Occurred()) {
      return 1;
   }
   self->elem->setPx((float)var);
   return 0;
}

static PyObject*
_TrackFit_getPy(_TrackFit *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getPy());
}

static int
_TrackFit_setPy(_TrackFit *self, PyObject *value, void *closure)
{
   double var = PyFloat_AsDouble(value);
   if (var == -1 && PyErr_Occurred()) {
      return 1;
   }
   self->elem->setPy((float)var);
   return 0;
}

static PyObject*
_TrackFit_getPz(_TrackFit *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getPz());
}

static int
_TrackFit_setPz(_TrackFit *self, PyObject *value, void *closure)
{
   double var = PyFloat_AsDouble(value);
   if (var == -1 && PyErr_Occurred()) {
      return 1;
   }
   self->elem->setPz((float)var);
   return 0;
}

static PyObject*
_TrackFit_getT0(_TrackFit *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getT0());
}

static int
_TrackFit_setT0(_TrackFit *self, PyObject *value, void *closure)
{
   double var = PyFloat_AsDouble(value);
   if (var == -1 && PyErr_Occurred()) {
      return 1;
   }
   self->elem->setT0((float)var);
   return 0;
}

static PyObject*
_TrackFit_getT0det(_TrackFit *self, void *closure)
{
   return PyLong_FromLong(self->elem->getT0det());
}

static int
_TrackFit_setT0det(_TrackFit *self, PyObject *value, void *closure)
{
   long var = PyInt_AsLong(value);
   if (var == -1 && PyErr_Occurred()) {
      return -1;
   }
   self->elem->setT0det(var);
   return 0;
}

static PyObject*
_TrackFit_getT0err(_TrackFit *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getT0err());
}

static int
_TrackFit_setT0err(_TrackFit *self, PyObject *value, void *closure)
{
   double var = PyFloat_AsDouble(value);
   if (var == -1 && PyErr_Occurred()) {
      return 1;
   }
   self->elem->setT0err((float)var);
   return 0;
}

static PyObject*
_TrackFit_getTunit(_TrackFit *self, void *closure)
{
   std::string val(self->elem->getTunit());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_TrackFit_getX0(_TrackFit *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getX0());
}

static int
_TrackFit_setX0(_TrackFit *self, PyObject *value, void *closure)
{
   double var = PyFloat_AsDouble(value);
   if (var == -1 && PyErr_Occurred()) {
      return 1;
   }
   self->elem->setX0((float)var);
   return 0;
}

static PyObject*
_TrackFit_getY0(_TrackFit *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getY0());
}

static int
_TrackFit_setY0(_TrackFit *self, PyObject *value, void *closure)
{
   double var = PyFloat_AsDouble(value);
   if (var == -1 && PyErr_Occurred()) {
      return 1;
   }
   self->elem->setY0((float)var);
   return 0;
}

static PyObject*
_TrackFit_getZ0(_TrackFit *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getZ0());
}

static int
_TrackFit_setZ0(_TrackFit *self, PyObject *value, void *closure)
{
   double var = PyFloat_AsDouble(value);
   if (var == -1 && PyErr_Occurred()) {
      return 1;
   }
   self->elem->setZ0((float)var);
   return 0;
}

static PyObject*
_TrackFit_toString(PyObject *self, PyObject *args=0)
{
   _TrackFit *me = (_TrackFit*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid trackFit element");
      return NULL;
   }
   std::string str(me->elem->toString());
   return PyUnicode_FromString(str.c_str());
}

static PyObject*
_TrackFit_toXML(PyObject *self, PyObject *args=0)
{
   _TrackFit *me = (_TrackFit*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid trackFit element");
      return NULL;
   }
   std::string str(me->elem->toXML());
   return PyUnicode_FromString(str.c_str());
}

static PyGetSetDef _TrackFit_getsetters[] = {
   {(char*)"Ndof",
    (getter)_TrackFit_getNdof, (setter)_TrackFit_setNdof,
    (char*)"Ndof value",
    NULL},
   {(char*)"candidateId",
    (getter)_TrackFit_getCandidateId, 0,
    (char*)"candidateId value",
    NULL},
   {(char*)"chisq",
    (getter)_TrackFit_getChisq, (setter)_TrackFit_setChisq,
    (char*)"chisq value",
    NULL},
   {(char*)"class",
    (getter)_TrackFit_getClass, 0,
    (char*)"class string",
    NULL},
   {(char*)"e11",
    (getter)_TrackFit_getE11, (setter)_TrackFit_setE11,
    (char*)"e11 value",
    NULL},
   {(char*)"e12",
    (getter)_TrackFit_getE12, (setter)_TrackFit_setE12,
    (char*)"e12 value",
    NULL},
   {(char*)"e13",
    (getter)_TrackFit_getE13, (setter)_TrackFit_setE13,
    (char*)"e13 value",
    NULL},
   {(char*)"e14",
    (getter)_TrackFit_getE14, (setter)_TrackFit_setE14,
    (char*)"e14 value",
    NULL},
   {(char*)"e15",
    (getter)_TrackFit_getE15, (setter)_TrackFit_setE15,
    (char*)"e15 value",
    NULL},
   {(char*)"e22",
    (getter)_TrackFit_getE22, (setter)_TrackFit_setE22,
    (char*)"e22 value",
    NULL},
   {(char*)"e23",
    (getter)_TrackFit_getE23, (setter)_TrackFit_setE23,
    (char*)"e23 value",
    NULL},
   {(char*)"e24",
    (getter)_TrackFit_getE24, (setter)_TrackFit_setE24,
    (char*)"e24 value",
    NULL},
   {(char*)"e25",
    (getter)_TrackFit_getE25, (setter)_TrackFit_setE25,
    (char*)"e25 value",
    NULL},
   {(char*)"e33",
    (getter)_TrackFit_getE33, (setter)_TrackFit_setE33,
    (char*)"e33 value",
    NULL},
   {(char*)"e34",
    (getter)_TrackFit_getE34, (setter)_TrackFit_setE34,
    (char*)"e34 value",
    NULL},
   {(char*)"e35",
    (getter)_TrackFit_getE35, (setter)_TrackFit_setE35,
    (char*)"e35 value",
    NULL},
   {(char*)"e44",
    (getter)_TrackFit_getE44, (setter)_TrackFit_setE44,
    (char*)"e44 value",
    NULL},
   {(char*)"e45",
    (getter)_TrackFit_getE45, (setter)_TrackFit_setE45,
    (char*)"e45 value",
    NULL},
   {(char*)"e55",
    (getter)_TrackFit_getE55, (setter)_TrackFit_setE55,
    (char*)"e55 value",
    NULL},
   {(char*)"eventNo",
    (getter)_TrackFit_getEventNo, 0,
    (char*)"eventNo value",
    NULL},
   {(char*)"jtag",
    (getter)_TrackFit_getJtag, 0,
    (char*)"jtag string",
    NULL},
   {(char*)"lunit",
    (getter)_TrackFit_getLunit, 0,
    (char*)"lunit value",
    NULL},
   {(char*)"maxOccurs",
    (getter)_TrackFit_getMaxOccurs, 0,
    (char*)"maxOccurs string",
    NULL},
   {(char*)"minOccurs",
    (getter)_TrackFit_getMinOccurs, 0,
    (char*)"minOccurs value",
    NULL},
   {(char*)"ptype",
    (getter)_TrackFit_getPtype, 0,
    (char*)"ptype value",
    NULL},
   {(char*)"punit",
    (getter)_TrackFit_getPunit, 0,
    (char*)"punit value",
    NULL},
   {(char*)"px",
    (getter)_TrackFit_getPx, (setter)_TrackFit_setPx,
    (char*)"px value",
    NULL},
   {(char*)"py",
    (getter)_TrackFit_getPy, (setter)_TrackFit_setPy,
    (char*)"py value",
    NULL},
   {(char*)"pz",
    (getter)_TrackFit_getPz, (setter)_TrackFit_setPz,
    (char*)"pz value",
    NULL},
   {(char*)"runNo",
    (getter)_TrackFit_getRunNo, 0,
    (char*)"runNo value",
    NULL},
   {(char*)"t0",
    (getter)_TrackFit_getT0, (setter)_TrackFit_setT0,
    (char*)"t0 value",
    NULL},
   {(char*)"t0det",
    (getter)_TrackFit_getT0det, (setter)_TrackFit_setT0det,
    (char*)"t0det value",
    NULL},
   {(char*)"t0err",
    (getter)_TrackFit_getT0err, (setter)_TrackFit_setT0err,
    (char*)"t0err value",
    NULL},
   {(char*)"tunit",
    (getter)_TrackFit_getTunit, 0,
    (char*)"tunit value",
    NULL},
   {(char*)"version",
    (getter)_TrackFit_getVersion, 0,
    (char*)"version string",
    NULL},
   {(char*)"x0",
    (getter)_TrackFit_getX0, (setter)_TrackFit_setX0,
    (char*)"x0 value",
    NULL},
   {(char*)"xmlns",
    (getter)_TrackFit_getXmlns, 0,
    (char*)"xmlns string",
    NULL},
   {(char*)"y0",
    (getter)_TrackFit_getY0, (setter)_TrackFit_setY0,
    (char*)"y0 value",
    NULL},
   {(char*)"z0",
    (getter)_TrackFit_getZ0, (setter)_TrackFit_setZ0,
    (char*)"z0 value",
    NULL},
   {NULL}  /* Sentinel */
};

static PyMemberDef _TrackFit_members[] = {
   {NULL}  /* Sentinel */
};

static PyMethodDef _TrackFit_methods[] = {
   {"toString", _TrackFit_toString, METH_NOARGS,
    "show element as a human-readable string"},
   {"toXML", _TrackFit_toXML, METH_NOARGS,
    "show element as a XML fragment"},
   {NULL}  /* Sentinel */
};

static PyTypeObject _TrackFit_type = {
    PyVarObject_HEAD_INIT(NULL,0)
    "hddm_r.TrackFit",         /*tp_name*/
    sizeof(_TrackFit),          /*tp_basicsize*/
    0,                         /*tp_itemsize*/
    (destructor)_TrackFit_dealloc, /*tp_dealloc*/
    0,                         /*tp_print*/
    0,                         /*tp_getattr*/
    0,                         /*tp_setattr*/
    0,                         /*tp_compare*/
    0,                         /*tp_repr*/
    0,                         /*tp_as_number*/
    0,                         /*tp_as_sequence*/
    0,                         /*tp_as_mapping*/
    0,                         /*tp_hash */
    0,                         /*tp_call*/
    (reprfunc)_TrackFit_toString,         /*tp_str*/
    0,                         /*tp_getattro*/
    0,                         /*tp_setattro*/
    0,                         /*tp_as_buffer*/
    Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE, /*tp_flags*/
    "hddm_r trackFit element",  /* tp_doc */
    0,                         /* tp_traverse */
    0,                         /* tp_clear */
    0,                         /* tp_richcompare */
    0,                         /* tp_weaklistoffset */
    0,                         /* tp_iter */
    0,                         /* tp_iternext */
    _TrackFit_methods,          /* tp_methods */
    _TrackFit_members,          /* tp_members */
    _TrackFit_getsetters,       /* tp_getset */
    &_HDDM_Element_type,       /* tp_base */
    0,                         /* tp_dict */
    0,                         /* tp_descr_get */
    0,                         /* tp_descr_set */
    0,                         /* tp_dictoffset */
    (initproc)_TrackFit_init,   /* tp_init */
    0,                         /* tp_alloc */
    _TrackFit_new,              /* tp_new */
};



// wrap element class hddm_r::TrackFlags as hddm_r.TrackFlags

typedef struct {
   PyObject_HEAD
   TrackFlags *elem;
   PyObject *host;
} _TrackFlags;

static void
_TrackFlags_dealloc(_TrackFlags* self)
{
   if (self->elem != 0) {
      LOG_DEALLOC(Py_TYPE(self), 0, self->host == (PyObject*)self);
      if (self->host == (PyObject*)self)
         delete self->elem;
      else
         My_DECREF(self->host);
   }
   Py_TYPE(self)->tp_free((PyObject*)self);
}

static PyObject*
_TrackFlags_new(PyTypeObject *type, PyObject *args, PyObject *kwds)
{
   _TrackFlags *self;
   self = (_TrackFlags*)type->tp_alloc(type, 0);
   if (self != NULL) {
      self->elem = 0;
      self->host = 0;
   }
   return (PyObject*)self;
}

static int
_TrackFlags_init(_TrackFlags *self, PyObject *args, PyObject *kwds)
{
   PyErr_SetString(PyExc_RuntimeError, "illegal constructor");
   return -1;
}

static PyObject*
_TrackFlags_getClass(_TrackFlags *self, void *closure)
{
   std::string val(self->elem->getClass());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_TrackFlags_getVersion(_TrackFlags *self, void *closure)
{
   std::string val(self->elem->getVersion());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_TrackFlags_getXmlns(_TrackFlags *self, void *closure)
{
   std::string val(self->elem->getXmlns());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_TrackFlags_getEventNo(_TrackFlags *self, void *closure)
{
   return PyLong_FromLongLong(self->elem->getEventNo());
}

static PyObject*
_TrackFlags_getRunNo(_TrackFlags *self, void *closure)
{
   return PyLong_FromLong(self->elem->getRunNo());
}

static PyObject*
_TrackFlags_getCandidateId(_TrackFlags *self, void *closure)
{
   return PyLong_FromLong(self->elem->getCandidateId());
}

static PyObject*
_TrackFlags_getJtag(_TrackFlags *self, void *closure)
{
   std::string val(self->elem->getJtag());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_TrackFlags_getPtype(_TrackFlags *self, void *closure)
{
   Particle_t p(self->elem->getPtype());
   std::string val(ParticleType(p));
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_TrackFlags_getFlags(_TrackFlags *self, void *closure)
{
   return PyLong_FromLong(self->elem->getFlags());
}

static int
_TrackFlags_setFlags(_TrackFlags *self, PyObject *value, void *closure)
{
   long var = PyInt_AsLong(value);
   if (var == -1 && PyErr_Occurred()) {
      return -1;
   }
   self->elem->setFlags(var);
   return 0;
}

static PyObject*
_TrackFlags_getMaxOccurs(_TrackFlags *self, void *closure)
{
   return PyLong_FromLong(self->elem->getMaxOccurs());
}

static PyObject*
_TrackFlags_getMinOccurs(_TrackFlags *self, void *closure)
{
   return PyLong_FromLong(self->elem->getMinOccurs());
}

static PyObject*
_TrackFlags_toString(PyObject *self, PyObject *args=0)
{
   _TrackFlags *me = (_TrackFlags*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid trackFlags element");
      return NULL;
   }
   std::string str(me->elem->toString());
   return PyUnicode_FromString(str.c_str());
}

static PyObject*
_TrackFlags_toXML(PyObject *self, PyObject *args=0)
{
   _TrackFlags *me = (_TrackFlags*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid trackFlags element");
      return NULL;
   }
   std::string str(me->elem->toXML());
   return PyUnicode_FromString(str.c_str());
}

static PyGetSetDef _TrackFlags_getsetters[] = {
   {(char*)"candidateId",
    (getter)_TrackFlags_getCandidateId, 0,
    (char*)"candidateId value",
    NULL},
   {(char*)"class",
    (getter)_TrackFlags_getClass, 0,
    (char*)"class string",
    NULL},
   {(char*)"eventNo",
    (getter)_TrackFlags_getEventNo, 0,
    (char*)"eventNo value",
    NULL},
   {(char*)"flags",
    (getter)_TrackFlags_getFlags, (setter)_TrackFlags_setFlags,
    (char*)"flags value",
    NULL},
   {(char*)"jtag",
    (getter)_TrackFlags_getJtag, 0,
    (char*)"jtag string",
    NULL},
   {(char*)"maxOccurs",
    (getter)_TrackFlags_getMaxOccurs, 0,
    (char*)"maxOccurs value",
    NULL},
   {(char*)"minOccurs",
    (getter)_TrackFlags_getMinOccurs, 0,
    (char*)"minOccurs value",
    NULL},
   {(char*)"ptype",
    (getter)_TrackFlags_getPtype, 0,
    (char*)"ptype value",
    NULL},
   {(char*)"runNo",
    (getter)_TrackFlags_getRunNo, 0,
    (char*)"runNo value",
    NULL},
   {(char*)"version",
    (getter)_TrackFlags_getVersion, 0,
    (char*)"version string",
    NULL},
   {(char*)"xmlns",
    (getter)_TrackFlags_getXmlns, 0,
    (char*)"xmlns string",
    NULL},
   {NULL}  /* Sentinel */
};

static PyMemberDef _TrackFlags_members[] = {
   {NULL}  /* Sentinel */
};

static PyMethodDef _TrackFlags_methods[] = {
   {"toString", _TrackFlags_toString, METH_NOARGS,
    "show element as a human-readable string"},
   {"toXML", _TrackFlags_toXML, METH_NOARGS,
    "show element as a XML fragment"},
   {NULL}  /* Sentinel */
};

static PyTypeObject _TrackFlags_type = {
    PyVarObject_HEAD_INIT(NULL,0)
    "hddm_r.TrackFlags",         /*tp_name*/
    sizeof(_TrackFlags),          /*tp_basicsize*/
    0,                         /*tp_itemsize*/
    (destructor)_TrackFlags_dealloc, /*tp_dealloc*/
    0,                         /*tp_print*/
    0,                         /*tp_getattr*/
    0,                         /*tp_setattr*/
    0,                         /*tp_compare*/
    0,                         /*tp_repr*/
    0,                         /*tp_as_number*/
    0,                         /*tp_as_sequence*/
    0,                         /*tp_as_mapping*/
    0,                         /*tp_hash */
    0,                         /*tp_call*/
    (reprfunc)_TrackFlags_toString,         /*tp_str*/
    0,                         /*tp_getattro*/
    0,                         /*tp_setattro*/
    0,                         /*tp_as_buffer*/
    Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE, /*tp_flags*/
    "hddm_r trackFlags element",  /* tp_doc */
    0,                         /* tp_traverse */
    0,                         /* tp_clear */
    0,                         /* tp_richcompare */
    0,                         /* tp_weaklistoffset */
    0,                         /* tp_iter */
    0,                         /* tp_iternext */
    _TrackFlags_methods,          /* tp_methods */
    _TrackFlags_members,          /* tp_members */
    _TrackFlags_getsetters,       /* tp_getset */
    &_HDDM_Element_type,       /* tp_base */
    0,                         /* tp_dict */
    0,                         /* tp_descr_get */
    0,                         /* tp_descr_set */
    0,                         /* tp_dictoffset */
    (initproc)_TrackFlags_init,   /* tp_init */
    0,                         /* tp_alloc */
    _TrackFlags_new,              /* tp_new */
};



// wrap element class hddm_r::Hitlayers as hddm_r.Hitlayers

typedef struct {
   PyObject_HEAD
   Hitlayers *elem;
   PyObject *host;
} _Hitlayers;

static void
_Hitlayers_dealloc(_Hitlayers* self)
{
   if (self->elem != 0) {
      LOG_DEALLOC(Py_TYPE(self), 0, self->host == (PyObject*)self);
      if (self->host == (PyObject*)self)
         delete self->elem;
      else
         My_DECREF(self->host);
   }
   Py_TYPE(self)->tp_free((PyObject*)self);
}

static PyObject*
_Hitlayers_new(PyTypeObject *type, PyObject *args, PyObject *kwds)
{
   _Hitlayers *self;
   self = (_Hitlayers*)type->tp_alloc(type, 0);
   if (self != NULL) {
      self->elem = 0;
      self->host = 0;
   }
   return (PyObject*)self;
}

static int
_Hitlayers_init(_Hitlayers *self, PyObject *args, PyObject *kwds)
{
   PyErr_SetString(PyExc_RuntimeError, "illegal constructor");
   return -1;
}

static PyObject*
_Hitlayers_getClass(_Hitlayers *self, void *closure)
{
   std::string val(self->elem->getClass());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_Hitlayers_getVersion(_Hitlayers *self, void *closure)
{
   std::string val(self->elem->getVersion());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_Hitlayers_getXmlns(_Hitlayers *self, void *closure)
{
   std::string val(self->elem->getXmlns());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_Hitlayers_getEventNo(_Hitlayers *self, void *closure)
{
   return PyLong_FromLongLong(self->elem->getEventNo());
}

static PyObject*
_Hitlayers_getRunNo(_Hitlayers *self, void *closure)
{
   return PyLong_FromLong(self->elem->getRunNo());
}

static PyObject*
_Hitlayers_getCandidateId(_Hitlayers *self, void *closure)
{
   return PyLong_FromLong(self->elem->getCandidateId());
}

static PyObject*
_Hitlayers_getJtag(_Hitlayers *self, void *closure)
{
   std::string val(self->elem->getJtag());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_Hitlayers_getPtype(_Hitlayers *self, void *closure)
{
   Particle_t p(self->elem->getPtype());
   std::string val(ParticleType(p));
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_Hitlayers_getCDCrings(_Hitlayers *self, void *closure)
{
   return PyLong_FromLong(self->elem->getCDCrings());
}

static int
_Hitlayers_setCDCrings(_Hitlayers *self, PyObject *value, void *closure)
{
   long var = PyInt_AsLong(value);
   if (var == -1 && PyErr_Occurred()) {
      return -1;
   }
   self->elem->setCDCrings(var);
   return 0;
}

static PyObject*
_Hitlayers_getFDCplanes(_Hitlayers *self, void *closure)
{
   return PyLong_FromLong(self->elem->getFDCplanes());
}

static int
_Hitlayers_setFDCplanes(_Hitlayers *self, PyObject *value, void *closure)
{
   long var = PyInt_AsLong(value);
   if (var == -1 && PyErr_Occurred()) {
      return -1;
   }
   self->elem->setFDCplanes(var);
   return 0;
}

static PyObject*
_Hitlayers_getMaxOccurs(_Hitlayers *self, void *closure)
{
   return PyLong_FromLong(self->elem->getMaxOccurs());
}

static PyObject*
_Hitlayers_getMinOccurs(_Hitlayers *self, void *closure)
{
   return PyLong_FromLong(self->elem->getMinOccurs());
}

static PyObject*
_Hitlayers_toString(PyObject *self, PyObject *args=0)
{
   _Hitlayers *me = (_Hitlayers*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid hitlayers element");
      return NULL;
   }
   std::string str(me->elem->toString());
   return PyUnicode_FromString(str.c_str());
}

static PyObject*
_Hitlayers_toXML(PyObject *self, PyObject *args=0)
{
   _Hitlayers *me = (_Hitlayers*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid hitlayers element");
      return NULL;
   }
   std::string str(me->elem->toXML());
   return PyUnicode_FromString(str.c_str());
}

static PyGetSetDef _Hitlayers_getsetters[] = {
   {(char*)"CDCrings",
    (getter)_Hitlayers_getCDCrings, (setter)_Hitlayers_setCDCrings,
    (char*)"CDCrings value",
    NULL},
   {(char*)"FDCplanes",
    (getter)_Hitlayers_getFDCplanes, (setter)_Hitlayers_setFDCplanes,
    (char*)"FDCplanes value",
    NULL},
   {(char*)"candidateId",
    (getter)_Hitlayers_getCandidateId, 0,
    (char*)"candidateId value",
    NULL},
   {(char*)"class",
    (getter)_Hitlayers_getClass, 0,
    (char*)"class string",
    NULL},
   {(char*)"eventNo",
    (getter)_Hitlayers_getEventNo, 0,
    (char*)"eventNo value",
    NULL},
   {(char*)"jtag",
    (getter)_Hitlayers_getJtag, 0,
    (char*)"jtag string",
    NULL},
   {(char*)"maxOccurs",
    (getter)_Hitlayers_getMaxOccurs, 0,
    (char*)"maxOccurs value",
    NULL},
   {(char*)"minOccurs",
    (getter)_Hitlayers_getMinOccurs, 0,
    (char*)"minOccurs value",
    NULL},
   {(char*)"ptype",
    (getter)_Hitlayers_getPtype, 0,
    (char*)"ptype value",
    NULL},
   {(char*)"runNo",
    (getter)_Hitlayers_getRunNo, 0,
    (char*)"runNo value",
    NULL},
   {(char*)"version",
    (getter)_Hitlayers_getVersion, 0,
    (char*)"version string",
    NULL},
   {(char*)"xmlns",
    (getter)_Hitlayers_getXmlns, 0,
    (char*)"xmlns string",
    NULL},
   {NULL}  /* Sentinel */
};

static PyMemberDef _Hitlayers_members[] = {
   {NULL}  /* Sentinel */
};

static PyMethodDef _Hitlayers_methods[] = {
   {"toString", _Hitlayers_toString, METH_NOARGS,
    "show element as a human-readable string"},
   {"toXML", _Hitlayers_toXML, METH_NOARGS,
    "show element as a XML fragment"},
   {NULL}  /* Sentinel */
};

static PyTypeObject _Hitlayers_type = {
    PyVarObject_HEAD_INIT(NULL,0)
    "hddm_r.Hitlayers",         /*tp_name*/
    sizeof(_Hitlayers),          /*tp_basicsize*/
    0,                         /*tp_itemsize*/
    (destructor)_Hitlayers_dealloc, /*tp_dealloc*/
    0,                         /*tp_print*/
    0,                         /*tp_getattr*/
    0,                         /*tp_setattr*/
    0,                         /*tp_compare*/
    0,                         /*tp_repr*/
    0,                         /*tp_as_number*/
    0,                         /*tp_as_sequence*/
    0,                         /*tp_as_mapping*/
    0,                         /*tp_hash */
    0,                         /*tp_call*/
    (reprfunc)_Hitlayers_toString,         /*tp_str*/
    0,                         /*tp_getattro*/
    0,                         /*tp_setattro*/
    0,                         /*tp_as_buffer*/
    Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE, /*tp_flags*/
    "hddm_r hitlayers element",  /* tp_doc */
    0,                         /* tp_traverse */
    0,                         /* tp_clear */
    0,                         /* tp_richcompare */
    0,                         /* tp_weaklistoffset */
    0,                         /* tp_iter */
    0,                         /* tp_iternext */
    _Hitlayers_methods,          /* tp_methods */
    _Hitlayers_members,          /* tp_members */
    _Hitlayers_getsetters,       /* tp_getset */
    &_HDDM_Element_type,       /* tp_base */
    0,                         /* tp_dict */
    0,                         /* tp_descr_get */
    0,                         /* tp_descr_set */
    0,                         /* tp_dictoffset */
    (initproc)_Hitlayers_init,   /* tp_init */
    0,                         /* tp_alloc */
    _Hitlayers_new,              /* tp_new */
};



// wrap element class hddm_r::Expectedhits as hddm_r.Expectedhits

typedef struct {
   PyObject_HEAD
   Expectedhits *elem;
   PyObject *host;
} _Expectedhits;

static void
_Expectedhits_dealloc(_Expectedhits* self)
{
   if (self->elem != 0) {
      LOG_DEALLOC(Py_TYPE(self), 0, self->host == (PyObject*)self);
      if (self->host == (PyObject*)self)
         delete self->elem;
      else
         My_DECREF(self->host);
   }
   Py_TYPE(self)->tp_free((PyObject*)self);
}

static PyObject*
_Expectedhits_new(PyTypeObject *type, PyObject *args, PyObject *kwds)
{
   _Expectedhits *self;
   self = (_Expectedhits*)type->tp_alloc(type, 0);
   if (self != NULL) {
      self->elem = 0;
      self->host = 0;
   }
   return (PyObject*)self;
}

static int
_Expectedhits_init(_Expectedhits *self, PyObject *args, PyObject *kwds)
{
   PyErr_SetString(PyExc_RuntimeError, "illegal constructor");
   return -1;
}

static PyObject*
_Expectedhits_getClass(_Expectedhits *self, void *closure)
{
   std::string val(self->elem->getClass());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_Expectedhits_getVersion(_Expectedhits *self, void *closure)
{
   std::string val(self->elem->getVersion());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_Expectedhits_getXmlns(_Expectedhits *self, void *closure)
{
   std::string val(self->elem->getXmlns());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_Expectedhits_getEventNo(_Expectedhits *self, void *closure)
{
   return PyLong_FromLongLong(self->elem->getEventNo());
}

static PyObject*
_Expectedhits_getRunNo(_Expectedhits *self, void *closure)
{
   return PyLong_FromLong(self->elem->getRunNo());
}

static PyObject*
_Expectedhits_getCandidateId(_Expectedhits *self, void *closure)
{
   return PyLong_FromLong(self->elem->getCandidateId());
}

static PyObject*
_Expectedhits_getJtag(_Expectedhits *self, void *closure)
{
   std::string val(self->elem->getJtag());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_Expectedhits_getPtype(_Expectedhits *self, void *closure)
{
   Particle_t p(self->elem->getPtype());
   std::string val(ParticleType(p));
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_Expectedhits_getExpectedCDChits(_Expectedhits *self, void *closure)
{
   return PyLong_FromLong(self->elem->getExpectedCDChits());
}

static int
_Expectedhits_setExpectedCDChits(_Expectedhits *self, PyObject *value, void *closure)
{
   long var = PyInt_AsLong(value);
   if (var == -1 && PyErr_Occurred()) {
      return -1;
   }
   self->elem->setExpectedCDChits(var);
   return 0;
}

static PyObject*
_Expectedhits_getExpectedFDChits(_Expectedhits *self, void *closure)
{
   return PyLong_FromLong(self->elem->getExpectedFDChits());
}

static int
_Expectedhits_setExpectedFDChits(_Expectedhits *self, PyObject *value, void *closure)
{
   long var = PyInt_AsLong(value);
   if (var == -1 && PyErr_Occurred()) {
      return -1;
   }
   self->elem->setExpectedFDChits(var);
   return 0;
}

static PyObject*
_Expectedhits_getMaxOccurs(_Expectedhits *self, void *closure)
{
   return PyLong_FromLong(self->elem->getMaxOccurs());
}

static PyObject*
_Expectedhits_getMeasuredCDChits(_Expectedhits *self, void *closure)
{
   return PyLong_FromLong(self->elem->getMeasuredCDChits());
}

static int
_Expectedhits_setMeasuredCDChits(_Expectedhits *self, PyObject *value, void *closure)
{
   long var = PyInt_AsLong(value);
   if (var == -1 && PyErr_Occurred()) {
      return -1;
   }
   self->elem->setMeasuredCDChits(var);
   return 0;
}

static PyObject*
_Expectedhits_getMeasuredFDChits(_Expectedhits *self, void *closure)
{
   return PyLong_FromLong(self->elem->getMeasuredFDChits());
}

static int
_Expectedhits_setMeasuredFDChits(_Expectedhits *self, PyObject *value, void *closure)
{
   long var = PyInt_AsLong(value);
   if (var == -1 && PyErr_Occurred()) {
      return -1;
   }
   self->elem->setMeasuredFDChits(var);
   return 0;
}

static PyObject*
_Expectedhits_getMinOccurs(_Expectedhits *self, void *closure)
{
   return PyLong_FromLong(self->elem->getMinOccurs());
}

static PyObject*
_Expectedhits_toString(PyObject *self, PyObject *args=0)
{
   _Expectedhits *me = (_Expectedhits*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid expectedhits element");
      return NULL;
   }
   std::string str(me->elem->toString());
   return PyUnicode_FromString(str.c_str());
}

static PyObject*
_Expectedhits_toXML(PyObject *self, PyObject *args=0)
{
   _Expectedhits *me = (_Expectedhits*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid expectedhits element");
      return NULL;
   }
   std::string str(me->elem->toXML());
   return PyUnicode_FromString(str.c_str());
}

static PyGetSetDef _Expectedhits_getsetters[] = {
   {(char*)"candidateId",
    (getter)_Expectedhits_getCandidateId, 0,
    (char*)"candidateId value",
    NULL},
   {(char*)"class",
    (getter)_Expectedhits_getClass, 0,
    (char*)"class string",
    NULL},
   {(char*)"eventNo",
    (getter)_Expectedhits_getEventNo, 0,
    (char*)"eventNo value",
    NULL},
   {(char*)"expectedCDChits",
    (getter)_Expectedhits_getExpectedCDChits, (setter)_Expectedhits_setExpectedCDChits,
    (char*)"expectedCDChits value",
    NULL},
   {(char*)"expectedFDChits",
    (getter)_Expectedhits_getExpectedFDChits, (setter)_Expectedhits_setExpectedFDChits,
    (char*)"expectedFDChits value",
    NULL},
   {(char*)"jtag",
    (getter)_Expectedhits_getJtag, 0,
    (char*)"jtag string",
    NULL},
   {(char*)"maxOccurs",
    (getter)_Expectedhits_getMaxOccurs, 0,
    (char*)"maxOccurs value",
    NULL},
   {(char*)"measuredCDChits",
    (getter)_Expectedhits_getMeasuredCDChits, (setter)_Expectedhits_setMeasuredCDChits,
    (char*)"measuredCDChits value",
    NULL},
   {(char*)"measuredFDChits",
    (getter)_Expectedhits_getMeasuredFDChits, (setter)_Expectedhits_setMeasuredFDChits,
    (char*)"measuredFDChits value",
    NULL},
   {(char*)"minOccurs",
    (getter)_Expectedhits_getMinOccurs, 0,
    (char*)"minOccurs value",
    NULL},
   {(char*)"ptype",
    (getter)_Expectedhits_getPtype, 0,
    (char*)"ptype value",
    NULL},
   {(char*)"runNo",
    (getter)_Expectedhits_getRunNo, 0,
    (char*)"runNo value",
    NULL},
   {(char*)"version",
    (getter)_Expectedhits_getVersion, 0,
    (char*)"version string",
    NULL},
   {(char*)"xmlns",
    (getter)_Expectedhits_getXmlns, 0,
    (char*)"xmlns string",
    NULL},
   {NULL}  /* Sentinel */
};

static PyMemberDef _Expectedhits_members[] = {
   {NULL}  /* Sentinel */
};

static PyMethodDef _Expectedhits_methods[] = {
   {"toString", _Expectedhits_toString, METH_NOARGS,
    "show element as a human-readable string"},
   {"toXML", _Expectedhits_toXML, METH_NOARGS,
    "show element as a XML fragment"},
   {NULL}  /* Sentinel */
};

static PyTypeObject _Expectedhits_type = {
    PyVarObject_HEAD_INIT(NULL,0)
    "hddm_r.Expectedhits",         /*tp_name*/
    sizeof(_Expectedhits),          /*tp_basicsize*/
    0,                         /*tp_itemsize*/
    (destructor)_Expectedhits_dealloc, /*tp_dealloc*/
    0,                         /*tp_print*/
    0,                         /*tp_getattr*/
    0,                         /*tp_setattr*/
    0,                         /*tp_compare*/
    0,                         /*tp_repr*/
    0,                         /*tp_as_number*/
    0,                         /*tp_as_sequence*/
    0,                         /*tp_as_mapping*/
    0,                         /*tp_hash */
    0,                         /*tp_call*/
    (reprfunc)_Expectedhits_toString,         /*tp_str*/
    0,                         /*tp_getattro*/
    0,                         /*tp_setattro*/
    0,                         /*tp_as_buffer*/
    Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE, /*tp_flags*/
    "hddm_r expectedhits element",  /* tp_doc */
    0,                         /* tp_traverse */
    0,                         /* tp_clear */
    0,                         /* tp_richcompare */
    0,                         /* tp_weaklistoffset */
    0,                         /* tp_iter */
    0,                         /* tp_iternext */
    _Expectedhits_methods,          /* tp_methods */
    _Expectedhits_members,          /* tp_members */
    _Expectedhits_getsetters,       /* tp_getset */
    &_HDDM_Element_type,       /* tp_base */
    0,                         /* tp_dict */
    0,                         /* tp_descr_get */
    0,                         /* tp_descr_set */
    0,                         /* tp_dictoffset */
    (initproc)_Expectedhits_init,   /* tp_init */
    0,                         /* tp_alloc */
    _Expectedhits_new,              /* tp_new */
};



// wrap element class hddm_r::Mcmatch as hddm_r.Mcmatch

typedef struct {
   PyObject_HEAD
   Mcmatch *elem;
   PyObject *host;
} _Mcmatch;

static void
_Mcmatch_dealloc(_Mcmatch* self)
{
   if (self->elem != 0) {
      LOG_DEALLOC(Py_TYPE(self), 0, self->host == (PyObject*)self);
      if (self->host == (PyObject*)self)
         delete self->elem;
      else
         My_DECREF(self->host);
   }
   Py_TYPE(self)->tp_free((PyObject*)self);
}

static PyObject*
_Mcmatch_new(PyTypeObject *type, PyObject *args, PyObject *kwds)
{
   _Mcmatch *self;
   self = (_Mcmatch*)type->tp_alloc(type, 0);
   if (self != NULL) {
      self->elem = 0;
      self->host = 0;
   }
   return (PyObject*)self;
}

static int
_Mcmatch_init(_Mcmatch *self, PyObject *args, PyObject *kwds)
{
   PyErr_SetString(PyExc_RuntimeError, "illegal constructor");
   return -1;
}

static PyObject*
_Mcmatch_getClass(_Mcmatch *self, void *closure)
{
   std::string val(self->elem->getClass());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_Mcmatch_getVersion(_Mcmatch *self, void *closure)
{
   std::string val(self->elem->getVersion());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_Mcmatch_getXmlns(_Mcmatch *self, void *closure)
{
   std::string val(self->elem->getXmlns());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_Mcmatch_getEventNo(_Mcmatch *self, void *closure)
{
   return PyLong_FromLongLong(self->elem->getEventNo());
}

static PyObject*
_Mcmatch_getRunNo(_Mcmatch *self, void *closure)
{
   return PyLong_FromLong(self->elem->getRunNo());
}

static PyObject*
_Mcmatch_getCandidateId(_Mcmatch *self, void *closure)
{
   return PyLong_FromLong(self->elem->getCandidateId());
}

static PyObject*
_Mcmatch_getJtag(_Mcmatch *self, void *closure)
{
   std::string val(self->elem->getJtag());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_Mcmatch_getPtype(_Mcmatch *self, void *closure)
{
   Particle_t p(self->elem->getPtype());
   std::string val(ParticleType(p));
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_Mcmatch_getIthrown(_Mcmatch *self, void *closure)
{
   return PyLong_FromLong(self->elem->getIthrown());
}

static int
_Mcmatch_setIthrown(_Mcmatch *self, PyObject *value, void *closure)
{
   long var = PyInt_AsLong(value);
   if (var == -1 && PyErr_Occurred()) {
      return -1;
   }
   self->elem->setIthrown(var);
   return 0;
}

static PyObject*
_Mcmatch_getMaxOccurs(_Mcmatch *self, void *closure)
{
   return PyLong_FromLong(self->elem->getMaxOccurs());
}

static PyObject*
_Mcmatch_getMinOccurs(_Mcmatch *self, void *closure)
{
   return PyLong_FromLong(self->elem->getMinOccurs());
}

static PyObject*
_Mcmatch_getNumhitsmatch(_Mcmatch *self, void *closure)
{
   return PyLong_FromLong(self->elem->getNumhitsmatch());
}

static int
_Mcmatch_setNumhitsmatch(_Mcmatch *self, PyObject *value, void *closure)
{
   long var = PyInt_AsLong(value);
   if (var == -1 && PyErr_Occurred()) {
      return -1;
   }
   self->elem->setNumhitsmatch(var);
   return 0;
}

static PyObject*
_Mcmatch_toString(PyObject *self, PyObject *args=0)
{
   _Mcmatch *me = (_Mcmatch*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid mcmatch element");
      return NULL;
   }
   std::string str(me->elem->toString());
   return PyUnicode_FromString(str.c_str());
}

static PyObject*
_Mcmatch_toXML(PyObject *self, PyObject *args=0)
{
   _Mcmatch *me = (_Mcmatch*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid mcmatch element");
      return NULL;
   }
   std::string str(me->elem->toXML());
   return PyUnicode_FromString(str.c_str());
}

static PyGetSetDef _Mcmatch_getsetters[] = {
   {(char*)"candidateId",
    (getter)_Mcmatch_getCandidateId, 0,
    (char*)"candidateId value",
    NULL},
   {(char*)"class",
    (getter)_Mcmatch_getClass, 0,
    (char*)"class string",
    NULL},
   {(char*)"eventNo",
    (getter)_Mcmatch_getEventNo, 0,
    (char*)"eventNo value",
    NULL},
   {(char*)"ithrown",
    (getter)_Mcmatch_getIthrown, (setter)_Mcmatch_setIthrown,
    (char*)"ithrown value",
    NULL},
   {(char*)"jtag",
    (getter)_Mcmatch_getJtag, 0,
    (char*)"jtag string",
    NULL},
   {(char*)"maxOccurs",
    (getter)_Mcmatch_getMaxOccurs, 0,
    (char*)"maxOccurs value",
    NULL},
   {(char*)"minOccurs",
    (getter)_Mcmatch_getMinOccurs, 0,
    (char*)"minOccurs value",
    NULL},
   {(char*)"numhitsmatch",
    (getter)_Mcmatch_getNumhitsmatch, (setter)_Mcmatch_setNumhitsmatch,
    (char*)"numhitsmatch value",
    NULL},
   {(char*)"ptype",
    (getter)_Mcmatch_getPtype, 0,
    (char*)"ptype value",
    NULL},
   {(char*)"runNo",
    (getter)_Mcmatch_getRunNo, 0,
    (char*)"runNo value",
    NULL},
   {(char*)"version",
    (getter)_Mcmatch_getVersion, 0,
    (char*)"version string",
    NULL},
   {(char*)"xmlns",
    (getter)_Mcmatch_getXmlns, 0,
    (char*)"xmlns string",
    NULL},
   {NULL}  /* Sentinel */
};

static PyMemberDef _Mcmatch_members[] = {
   {NULL}  /* Sentinel */
};

static PyMethodDef _Mcmatch_methods[] = {
   {"toString", _Mcmatch_toString, METH_NOARGS,
    "show element as a human-readable string"},
   {"toXML", _Mcmatch_toXML, METH_NOARGS,
    "show element as a XML fragment"},
   {NULL}  /* Sentinel */
};

static PyTypeObject _Mcmatch_type = {
    PyVarObject_HEAD_INIT(NULL,0)
    "hddm_r.Mcmatch",         /*tp_name*/
    sizeof(_Mcmatch),          /*tp_basicsize*/
    0,                         /*tp_itemsize*/
    (destructor)_Mcmatch_dealloc, /*tp_dealloc*/
    0,                         /*tp_print*/
    0,                         /*tp_getattr*/
    0,                         /*tp_setattr*/
    0,                         /*tp_compare*/
    0,                         /*tp_repr*/
    0,                         /*tp_as_number*/
    0,                         /*tp_as_sequence*/
    0,                         /*tp_as_mapping*/
    0,                         /*tp_hash */
    0,                         /*tp_call*/
    (reprfunc)_Mcmatch_toString,         /*tp_str*/
    0,                         /*tp_getattro*/
    0,                         /*tp_setattro*/
    0,                         /*tp_as_buffer*/
    Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE, /*tp_flags*/
    "hddm_r mcmatch element",  /* tp_doc */
    0,                         /* tp_traverse */
    0,                         /* tp_clear */
    0,                         /* tp_richcompare */
    0,                         /* tp_weaklistoffset */
    0,                         /* tp_iter */
    0,                         /* tp_iternext */
    _Mcmatch_methods,          /* tp_methods */
    _Mcmatch_members,          /* tp_members */
    _Mcmatch_getsetters,       /* tp_getset */
    &_HDDM_Element_type,       /* tp_base */
    0,                         /* tp_dict */
    0,                         /* tp_descr_get */
    0,                         /* tp_descr_set */
    0,                         /* tp_dictoffset */
    (initproc)_Mcmatch_init,   /* tp_init */
    0,                         /* tp_alloc */
    _Mcmatch_new,              /* tp_new */
};



// wrap element class hddm_r::CDCAmpdEdx as hddm_r.CDCAmpdEdx

typedef struct {
   PyObject_HEAD
   CDCAmpdEdx *elem;
   PyObject *host;
} _CDCAmpdEdx;

static void
_CDCAmpdEdx_dealloc(_CDCAmpdEdx* self)
{
   if (self->elem != 0) {
      LOG_DEALLOC(Py_TYPE(self), 0, self->host == (PyObject*)self);
      if (self->host == (PyObject*)self)
         delete self->elem;
      else
         My_DECREF(self->host);
   }
   Py_TYPE(self)->tp_free((PyObject*)self);
}

static PyObject*
_CDCAmpdEdx_new(PyTypeObject *type, PyObject *args, PyObject *kwds)
{
   _CDCAmpdEdx *self;
   self = (_CDCAmpdEdx*)type->tp_alloc(type, 0);
   if (self != NULL) {
      self->elem = 0;
      self->host = 0;
   }
   return (PyObject*)self;
}

static int
_CDCAmpdEdx_init(_CDCAmpdEdx *self, PyObject *args, PyObject *kwds)
{
   PyErr_SetString(PyExc_RuntimeError, "illegal constructor");
   return -1;
}

static PyObject*
_CDCAmpdEdx_getClass(_CDCAmpdEdx *self, void *closure)
{
   std::string val(self->elem->getClass());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_CDCAmpdEdx_getVersion(_CDCAmpdEdx *self, void *closure)
{
   std::string val(self->elem->getVersion());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_CDCAmpdEdx_getXmlns(_CDCAmpdEdx *self, void *closure)
{
   std::string val(self->elem->getXmlns());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_CDCAmpdEdx_getEventNo(_CDCAmpdEdx *self, void *closure)
{
   return PyLong_FromLongLong(self->elem->getEventNo());
}

static PyObject*
_CDCAmpdEdx_getRunNo(_CDCAmpdEdx *self, void *closure)
{
   return PyLong_FromLong(self->elem->getRunNo());
}

static PyObject*
_CDCAmpdEdx_getCandidateId(_CDCAmpdEdx *self, void *closure)
{
   return PyLong_FromLong(self->elem->getCandidateId());
}

static PyObject*
_CDCAmpdEdx_getJtag(_CDCAmpdEdx *self, void *closure)
{
   std::string val(self->elem->getJtag());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_CDCAmpdEdx_getMaxOccurs(_CDCAmpdEdx *self, void *closure)
{
   std::string val(self->elem->getMaxOccurs());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_CDCAmpdEdx_getPtype(_CDCAmpdEdx *self, void *closure)
{
   Particle_t p(self->elem->getPtype());
   std::string val(ParticleType(p));
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_CDCAmpdEdx_getNsampleCDC(_CDCAmpdEdx *self, void *closure)
{
   return PyLong_FromLong(self->elem->getNsampleCDC());
}

static PyObject*
_CDCAmpdEdx_getNsampleFDC(_CDCAmpdEdx *self, void *closure)
{
   return PyLong_FromLong(self->elem->getNsampleFDC());
}

static PyObject*
_CDCAmpdEdx_getDEdxCDC(_CDCAmpdEdx *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getDEdxCDC());
}

static PyObject*
_CDCAmpdEdx_getDEdxFDC(_CDCAmpdEdx *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getDEdxFDC());
}

static PyObject*
_CDCAmpdEdx_getDEdx_unit(_CDCAmpdEdx *self, void *closure)
{
   std::string val(self->elem->getDEdx_unit());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_CDCAmpdEdx_getDxCDC(_CDCAmpdEdx *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getDxCDC());
}

static PyObject*
_CDCAmpdEdx_getDxFDC(_CDCAmpdEdx *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getDxFDC());
}

static PyObject*
_CDCAmpdEdx_getLunit(_CDCAmpdEdx *self, void *closure)
{
   std::string val(self->elem->getLunit());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_CDCAmpdEdx_getDEdxCDCAmp(_CDCAmpdEdx *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getDEdxCDCAmp());
}

static int
_CDCAmpdEdx_setDEdxCDCAmp(_CDCAmpdEdx *self, PyObject *value, void *closure)
{
   double var = PyFloat_AsDouble(value);
   if (var == -1 && PyErr_Occurred()) {
      return 1;
   }
   self->elem->setDEdxCDCAmp((float)var);
   return 0;
}

static PyObject*
_CDCAmpdEdx_getDxCDCAmp(_CDCAmpdEdx *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getDxCDCAmp());
}

static int
_CDCAmpdEdx_setDxCDCAmp(_CDCAmpdEdx *self, PyObject *value, void *closure)
{
   double var = PyFloat_AsDouble(value);
   if (var == -1 && PyErr_Occurred()) {
      return 1;
   }
   self->elem->setDxCDCAmp((float)var);
   return 0;
}

static PyObject*
_CDCAmpdEdx_getMinOccurs(_CDCAmpdEdx *self, void *closure)
{
   return PyLong_FromLong(self->elem->getMinOccurs());
}

static PyObject*
_CDCAmpdEdx_toString(PyObject *self, PyObject *args=0)
{
   _CDCAmpdEdx *me = (_CDCAmpdEdx*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid CDCAmpdEdx element");
      return NULL;
   }
   std::string str(me->elem->toString());
   return PyUnicode_FromString(str.c_str());
}

static PyObject*
_CDCAmpdEdx_toXML(PyObject *self, PyObject *args=0)
{
   _CDCAmpdEdx *me = (_CDCAmpdEdx*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid CDCAmpdEdx element");
      return NULL;
   }
   std::string str(me->elem->toXML());
   return PyUnicode_FromString(str.c_str());
}

static PyGetSetDef _CDCAmpdEdx_getsetters[] = {
   {(char*)"NsampleCDC",
    (getter)_CDCAmpdEdx_getNsampleCDC, 0,
    (char*)"NsampleCDC value",
    NULL},
   {(char*)"NsampleFDC",
    (getter)_CDCAmpdEdx_getNsampleFDC, 0,
    (char*)"NsampleFDC value",
    NULL},
   {(char*)"candidateId",
    (getter)_CDCAmpdEdx_getCandidateId, 0,
    (char*)"candidateId value",
    NULL},
   {(char*)"class",
    (getter)_CDCAmpdEdx_getClass, 0,
    (char*)"class string",
    NULL},
   {(char*)"dEdxCDC",
    (getter)_CDCAmpdEdx_getDEdxCDC, 0,
    (char*)"dEdxCDC value",
    NULL},
   {(char*)"dEdxCDCAmp",
    (getter)_CDCAmpdEdx_getDEdxCDCAmp, (setter)_CDCAmpdEdx_setDEdxCDCAmp,
    (char*)"dEdxCDCAmp value",
    NULL},
   {(char*)"dEdxFDC",
    (getter)_CDCAmpdEdx_getDEdxFDC, 0,
    (char*)"dEdxFDC value",
    NULL},
   {(char*)"dEdx_unit",
    (getter)_CDCAmpdEdx_getDEdx_unit, 0,
    (char*)"dEdx_unit string",
    NULL},
   {(char*)"dxCDC",
    (getter)_CDCAmpdEdx_getDxCDC, 0,
    (char*)"dxCDC value",
    NULL},
   {(char*)"dxCDCAmp",
    (getter)_CDCAmpdEdx_getDxCDCAmp, (setter)_CDCAmpdEdx_setDxCDCAmp,
    (char*)"dxCDCAmp value",
    NULL},
   {(char*)"dxFDC",
    (getter)_CDCAmpdEdx_getDxFDC, 0,
    (char*)"dxFDC value",
    NULL},
   {(char*)"eventNo",
    (getter)_CDCAmpdEdx_getEventNo, 0,
    (char*)"eventNo value",
    NULL},
   {(char*)"jtag",
    (getter)_CDCAmpdEdx_getJtag, 0,
    (char*)"jtag string",
    NULL},
   {(char*)"lunit",
    (getter)_CDCAmpdEdx_getLunit, 0,
    (char*)"lunit string",
    NULL},
   {(char*)"maxOccurs",
    (getter)_CDCAmpdEdx_getMaxOccurs, 0,
    (char*)"maxOccurs string",
    NULL},
   {(char*)"minOccurs",
    (getter)_CDCAmpdEdx_getMinOccurs, 0,
    (char*)"minOccurs value",
    NULL},
   {(char*)"ptype",
    (getter)_CDCAmpdEdx_getPtype, 0,
    (char*)"ptype value",
    NULL},
   {(char*)"runNo",
    (getter)_CDCAmpdEdx_getRunNo, 0,
    (char*)"runNo value",
    NULL},
   {(char*)"version",
    (getter)_CDCAmpdEdx_getVersion, 0,
    (char*)"version string",
    NULL},
   {(char*)"xmlns",
    (getter)_CDCAmpdEdx_getXmlns, 0,
    (char*)"xmlns string",
    NULL},
   {NULL}  /* Sentinel */
};

static PyMemberDef _CDCAmpdEdx_members[] = {
   {NULL}  /* Sentinel */
};

static PyMethodDef _CDCAmpdEdx_methods[] = {
   {"toString", _CDCAmpdEdx_toString, METH_NOARGS,
    "show element as a human-readable string"},
   {"toXML", _CDCAmpdEdx_toXML, METH_NOARGS,
    "show element as a XML fragment"},
   {NULL}  /* Sentinel */
};

static PyTypeObject _CDCAmpdEdx_type = {
    PyVarObject_HEAD_INIT(NULL,0)
    "hddm_r.CDCAmpdEdx",         /*tp_name*/
    sizeof(_CDCAmpdEdx),          /*tp_basicsize*/
    0,                         /*tp_itemsize*/
    (destructor)_CDCAmpdEdx_dealloc, /*tp_dealloc*/
    0,                         /*tp_print*/
    0,                         /*tp_getattr*/
    0,                         /*tp_setattr*/
    0,                         /*tp_compare*/
    0,                         /*tp_repr*/
    0,                         /*tp_as_number*/
    0,                         /*tp_as_sequence*/
    0,                         /*tp_as_mapping*/
    0,                         /*tp_hash */
    0,                         /*tp_call*/
    (reprfunc)_CDCAmpdEdx_toString,         /*tp_str*/
    0,                         /*tp_getattro*/
    0,                         /*tp_setattro*/
    0,                         /*tp_as_buffer*/
    Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE, /*tp_flags*/
    "hddm_r CDCAmpdEdx element",  /* tp_doc */
    0,                         /* tp_traverse */
    0,                         /* tp_clear */
    0,                         /* tp_richcompare */
    0,                         /* tp_weaklistoffset */
    0,                         /* tp_iter */
    0,                         /* tp_iternext */
    _CDCAmpdEdx_methods,          /* tp_methods */
    _CDCAmpdEdx_members,          /* tp_members */
    _CDCAmpdEdx_getsetters,       /* tp_getset */
    &_HDDM_Element_type,       /* tp_base */
    0,                         /* tp_dict */
    0,                         /* tp_descr_get */
    0,                         /* tp_descr_set */
    0,                         /* tp_dictoffset */
    (initproc)_CDCAmpdEdx_init,   /* tp_init */
    0,                         /* tp_alloc */
    _CDCAmpdEdx_new,              /* tp_new */
};



// wrap element class hddm_r::CDCdEdxTrunc as hddm_r.CDCdEdxTrunc

typedef struct {
   PyObject_HEAD
   CDCdEdxTrunc *elem;
   PyObject *host;
} _CDCdEdxTrunc;

static void
_CDCdEdxTrunc_dealloc(_CDCdEdxTrunc* self)
{
   if (self->elem != 0) {
      LOG_DEALLOC(Py_TYPE(self), 0, self->host == (PyObject*)self);
      if (self->host == (PyObject*)self)
         delete self->elem;
      else
         My_DECREF(self->host);
   }
   Py_TYPE(self)->tp_free((PyObject*)self);
}

static PyObject*
_CDCdEdxTrunc_new(PyTypeObject *type, PyObject *args, PyObject *kwds)
{
   _CDCdEdxTrunc *self;
   self = (_CDCdEdxTrunc*)type->tp_alloc(type, 0);
   if (self != NULL) {
      self->elem = 0;
      self->host = 0;
   }
   return (PyObject*)self;
}

static int
_CDCdEdxTrunc_init(_CDCdEdxTrunc *self, PyObject *args, PyObject *kwds)
{
   PyErr_SetString(PyExc_RuntimeError, "illegal constructor");
   return -1;
}

static PyObject*
_CDCdEdxTrunc_getClass(_CDCdEdxTrunc *self, void *closure)
{
   std::string val(self->elem->getClass());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_CDCdEdxTrunc_getVersion(_CDCdEdxTrunc *self, void *closure)
{
   std::string val(self->elem->getVersion());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_CDCdEdxTrunc_getXmlns(_CDCdEdxTrunc *self, void *closure)
{
   std::string val(self->elem->getXmlns());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_CDCdEdxTrunc_getEventNo(_CDCdEdxTrunc *self, void *closure)
{
   return PyLong_FromLongLong(self->elem->getEventNo());
}

static PyObject*
_CDCdEdxTrunc_getRunNo(_CDCdEdxTrunc *self, void *closure)
{
   return PyLong_FromLong(self->elem->getRunNo());
}

static PyObject*
_CDCdEdxTrunc_getCandidateId(_CDCdEdxTrunc *self, void *closure)
{
   return PyLong_FromLong(self->elem->getCandidateId());
}

static PyObject*
_CDCdEdxTrunc_getJtag(_CDCdEdxTrunc *self, void *closure)
{
   std::string val(self->elem->getJtag());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_CDCdEdxTrunc_getPtype(_CDCdEdxTrunc *self, void *closure)
{
   Particle_t p(self->elem->getPtype());
   std::string val(ParticleType(p));
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_CDCdEdxTrunc_getNsampleCDC(_CDCdEdxTrunc *self, void *closure)
{
   return PyLong_FromLong(self->elem->getNsampleCDC());
}

static PyObject*
_CDCdEdxTrunc_getNsampleFDC(_CDCdEdxTrunc *self, void *closure)
{
   return PyLong_FromLong(self->elem->getNsampleFDC());
}

static PyObject*
_CDCdEdxTrunc_getDEdxCDC(_CDCdEdxTrunc *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getDEdxCDC());
}

static PyObject*
_CDCdEdxTrunc_getDEdxFDC(_CDCdEdxTrunc *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getDEdxFDC());
}

static PyObject*
_CDCdEdxTrunc_getDxCDC(_CDCdEdxTrunc *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getDxCDC());
}

static PyObject*
_CDCdEdxTrunc_getDxFDC(_CDCdEdxTrunc *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getDxFDC());
}

static PyObject*
_CDCdEdxTrunc_getDEdx(_CDCdEdxTrunc *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getDEdx());
}

static int
_CDCdEdxTrunc_setDEdx(_CDCdEdxTrunc *self, PyObject *value, void *closure)
{
   double var = PyFloat_AsDouble(value);
   if (var == -1 && PyErr_Occurred()) {
      return 1;
   }
   self->elem->setDEdx((float)var);
   return 0;
}

static PyObject*
_CDCdEdxTrunc_getDEdxAmp(_CDCdEdxTrunc *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getDEdxAmp());
}

static int
_CDCdEdxTrunc_setDEdxAmp(_CDCdEdxTrunc *self, PyObject *value, void *closure)
{
   double var = PyFloat_AsDouble(value);
   if (var == -1 && PyErr_Occurred()) {
      return 1;
   }
   self->elem->setDEdxAmp((float)var);
   return 0;
}

static PyObject*
_CDCdEdxTrunc_getDEdx_unit(_CDCdEdxTrunc *self, void *closure)
{
   std::string val(self->elem->getDEdx_unit());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_CDCdEdxTrunc_getDx(_CDCdEdxTrunc *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getDx());
}

static int
_CDCdEdxTrunc_setDx(_CDCdEdxTrunc *self, PyObject *value, void *closure)
{
   double var = PyFloat_AsDouble(value);
   if (var == -1 && PyErr_Occurred()) {
      return 1;
   }
   self->elem->setDx((float)var);
   return 0;
}

static PyObject*
_CDCdEdxTrunc_getDxAmp(_CDCdEdxTrunc *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getDxAmp());
}

static int
_CDCdEdxTrunc_setDxAmp(_CDCdEdxTrunc *self, PyObject *value, void *closure)
{
   double var = PyFloat_AsDouble(value);
   if (var == -1 && PyErr_Occurred()) {
      return 1;
   }
   self->elem->setDxAmp((float)var);
   return 0;
}

static PyObject*
_CDCdEdxTrunc_getLunit(_CDCdEdxTrunc *self, void *closure)
{
   std::string val(self->elem->getLunit());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_CDCdEdxTrunc_getMaxOccurs(_CDCdEdxTrunc *self, void *closure)
{
   std::string val(self->elem->getMaxOccurs());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_CDCdEdxTrunc_getMinOccurs(_CDCdEdxTrunc *self, void *closure)
{
   return PyLong_FromLong(self->elem->getMinOccurs());
}

static PyObject*
_CDCdEdxTrunc_getNtrunc(_CDCdEdxTrunc *self, void *closure)
{
   return PyLong_FromLong(self->elem->getNtrunc());
}

static int
_CDCdEdxTrunc_setNtrunc(_CDCdEdxTrunc *self, PyObject *value, void *closure)
{
   long var = PyInt_AsLong(value);
   if (var == -1 && PyErr_Occurred()) {
      return -1;
   }
   self->elem->setNtrunc(var);
   return 0;
}

static PyObject*
_CDCdEdxTrunc_toString(PyObject *self, PyObject *args=0)
{
   _CDCdEdxTrunc *me = (_CDCdEdxTrunc*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid CDCdEdxTrunc element");
      return NULL;
   }
   std::string str(me->elem->toString());
   return PyUnicode_FromString(str.c_str());
}

static PyObject*
_CDCdEdxTrunc_toXML(PyObject *self, PyObject *args=0)
{
   _CDCdEdxTrunc *me = (_CDCdEdxTrunc*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid CDCdEdxTrunc element");
      return NULL;
   }
   std::string str(me->elem->toXML());
   return PyUnicode_FromString(str.c_str());
}

static PyGetSetDef _CDCdEdxTrunc_getsetters[] = {
   {(char*)"NsampleCDC",
    (getter)_CDCdEdxTrunc_getNsampleCDC, 0,
    (char*)"NsampleCDC value",
    NULL},
   {(char*)"NsampleFDC",
    (getter)_CDCdEdxTrunc_getNsampleFDC, 0,
    (char*)"NsampleFDC value",
    NULL},
   {(char*)"candidateId",
    (getter)_CDCdEdxTrunc_getCandidateId, 0,
    (char*)"candidateId value",
    NULL},
   {(char*)"class",
    (getter)_CDCdEdxTrunc_getClass, 0,
    (char*)"class string",
    NULL},
   {(char*)"dEdx",
    (getter)_CDCdEdxTrunc_getDEdx, (setter)_CDCdEdxTrunc_setDEdx,
    (char*)"dEdx value",
    NULL},
   {(char*)"dEdxAmp",
    (getter)_CDCdEdxTrunc_getDEdxAmp, (setter)_CDCdEdxTrunc_setDEdxAmp,
    (char*)"dEdxAmp value",
    NULL},
   {(char*)"dEdxCDC",
    (getter)_CDCdEdxTrunc_getDEdxCDC, 0,
    (char*)"dEdxCDC value",
    NULL},
   {(char*)"dEdxFDC",
    (getter)_CDCdEdxTrunc_getDEdxFDC, 0,
    (char*)"dEdxFDC value",
    NULL},
   {(char*)"dEdx_unit",
    (getter)_CDCdEdxTrunc_getDEdx_unit, 0,
    (char*)"dEdx_unit value",
    NULL},
   {(char*)"dx",
    (getter)_CDCdEdxTrunc_getDx, (setter)_CDCdEdxTrunc_setDx,
    (char*)"dx value",
    NULL},
   {(char*)"dxAmp",
    (getter)_CDCdEdxTrunc_getDxAmp, (setter)_CDCdEdxTrunc_setDxAmp,
    (char*)"dxAmp value",
    NULL},
   {(char*)"dxCDC",
    (getter)_CDCdEdxTrunc_getDxCDC, 0,
    (char*)"dxCDC value",
    NULL},
   {(char*)"dxFDC",
    (getter)_CDCdEdxTrunc_getDxFDC, 0,
    (char*)"dxFDC value",
    NULL},
   {(char*)"eventNo",
    (getter)_CDCdEdxTrunc_getEventNo, 0,
    (char*)"eventNo value",
    NULL},
   {(char*)"jtag",
    (getter)_CDCdEdxTrunc_getJtag, 0,
    (char*)"jtag string",
    NULL},
   {(char*)"lunit",
    (getter)_CDCdEdxTrunc_getLunit, 0,
    (char*)"lunit value",
    NULL},
   {(char*)"maxOccurs",
    (getter)_CDCdEdxTrunc_getMaxOccurs, 0,
    (char*)"maxOccurs value",
    NULL},
   {(char*)"minOccurs",
    (getter)_CDCdEdxTrunc_getMinOccurs, 0,
    (char*)"minOccurs value",
    NULL},
   {(char*)"ntrunc",
    (getter)_CDCdEdxTrunc_getNtrunc, (setter)_CDCdEdxTrunc_setNtrunc,
    (char*)"ntrunc value",
    NULL},
   {(char*)"ptype",
    (getter)_CDCdEdxTrunc_getPtype, 0,
    (char*)"ptype value",
    NULL},
   {(char*)"runNo",
    (getter)_CDCdEdxTrunc_getRunNo, 0,
    (char*)"runNo value",
    NULL},
   {(char*)"version",
    (getter)_CDCdEdxTrunc_getVersion, 0,
    (char*)"version string",
    NULL},
   {(char*)"xmlns",
    (getter)_CDCdEdxTrunc_getXmlns, 0,
    (char*)"xmlns string",
    NULL},
   {NULL}  /* Sentinel */
};

static PyMemberDef _CDCdEdxTrunc_members[] = {
   {NULL}  /* Sentinel */
};

static PyMethodDef _CDCdEdxTrunc_methods[] = {
   {"toString", _CDCdEdxTrunc_toString, METH_NOARGS,
    "show element as a human-readable string"},
   {"toXML", _CDCdEdxTrunc_toXML, METH_NOARGS,
    "show element as a XML fragment"},
   {NULL}  /* Sentinel */
};

static PyTypeObject _CDCdEdxTrunc_type = {
    PyVarObject_HEAD_INIT(NULL,0)
    "hddm_r.CDCdEdxTrunc",         /*tp_name*/
    sizeof(_CDCdEdxTrunc),          /*tp_basicsize*/
    0,                         /*tp_itemsize*/
    (destructor)_CDCdEdxTrunc_dealloc, /*tp_dealloc*/
    0,                         /*tp_print*/
    0,                         /*tp_getattr*/
    0,                         /*tp_setattr*/
    0,                         /*tp_compare*/
    0,                         /*tp_repr*/
    0,                         /*tp_as_number*/
    0,                         /*tp_as_sequence*/
    0,                         /*tp_as_mapping*/
    0,                         /*tp_hash */
    0,                         /*tp_call*/
    (reprfunc)_CDCdEdxTrunc_toString,         /*tp_str*/
    0,                         /*tp_getattro*/
    0,                         /*tp_setattro*/
    0,                         /*tp_as_buffer*/
    Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE, /*tp_flags*/
    "hddm_r CDCdEdxTrunc element",  /* tp_doc */
    0,                         /* tp_traverse */
    0,                         /* tp_clear */
    0,                         /* tp_richcompare */
    0,                         /* tp_weaklistoffset */
    0,                         /* tp_iter */
    0,                         /* tp_iternext */
    _CDCdEdxTrunc_methods,          /* tp_methods */
    _CDCdEdxTrunc_members,          /* tp_members */
    _CDCdEdxTrunc_getsetters,       /* tp_getset */
    &_HDDM_Element_type,       /* tp_base */
    0,                         /* tp_dict */
    0,                         /* tp_descr_get */
    0,                         /* tp_descr_set */
    0,                         /* tp_dictoffset */
    (initproc)_CDCdEdxTrunc_init,   /* tp_init */
    0,                         /* tp_alloc */
    _CDCdEdxTrunc_new,              /* tp_new */
};



// wrap element class hddm_r::FDCdEdxTrunc as hddm_r.FDCdEdxTrunc

typedef struct {
   PyObject_HEAD
   FDCdEdxTrunc *elem;
   PyObject *host;
} _FDCdEdxTrunc;

static void
_FDCdEdxTrunc_dealloc(_FDCdEdxTrunc* self)
{
   if (self->elem != 0) {
      LOG_DEALLOC(Py_TYPE(self), 0, self->host == (PyObject*)self);
      if (self->host == (PyObject*)self)
         delete self->elem;
      else
         My_DECREF(self->host);
   }
   Py_TYPE(self)->tp_free((PyObject*)self);
}

static PyObject*
_FDCdEdxTrunc_new(PyTypeObject *type, PyObject *args, PyObject *kwds)
{
   _FDCdEdxTrunc *self;
   self = (_FDCdEdxTrunc*)type->tp_alloc(type, 0);
   if (self != NULL) {
      self->elem = 0;
      self->host = 0;
   }
   return (PyObject*)self;
}

static int
_FDCdEdxTrunc_init(_FDCdEdxTrunc *self, PyObject *args, PyObject *kwds)
{
   PyErr_SetString(PyExc_RuntimeError, "illegal constructor");
   return -1;
}

static PyObject*
_FDCdEdxTrunc_getClass(_FDCdEdxTrunc *self, void *closure)
{
   std::string val(self->elem->getClass());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_FDCdEdxTrunc_getVersion(_FDCdEdxTrunc *self, void *closure)
{
   std::string val(self->elem->getVersion());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_FDCdEdxTrunc_getXmlns(_FDCdEdxTrunc *self, void *closure)
{
   std::string val(self->elem->getXmlns());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_FDCdEdxTrunc_getEventNo(_FDCdEdxTrunc *self, void *closure)
{
   return PyLong_FromLongLong(self->elem->getEventNo());
}

static PyObject*
_FDCdEdxTrunc_getRunNo(_FDCdEdxTrunc *self, void *closure)
{
   return PyLong_FromLong(self->elem->getRunNo());
}

static PyObject*
_FDCdEdxTrunc_getCandidateId(_FDCdEdxTrunc *self, void *closure)
{
   return PyLong_FromLong(self->elem->getCandidateId());
}

static PyObject*
_FDCdEdxTrunc_getJtag(_FDCdEdxTrunc *self, void *closure)
{
   std::string val(self->elem->getJtag());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_FDCdEdxTrunc_getPtype(_FDCdEdxTrunc *self, void *closure)
{
   Particle_t p(self->elem->getPtype());
   std::string val(ParticleType(p));
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_FDCdEdxTrunc_getNsampleCDC(_FDCdEdxTrunc *self, void *closure)
{
   return PyLong_FromLong(self->elem->getNsampleCDC());
}

static PyObject*
_FDCdEdxTrunc_getNsampleFDC(_FDCdEdxTrunc *self, void *closure)
{
   return PyLong_FromLong(self->elem->getNsampleFDC());
}

static PyObject*
_FDCdEdxTrunc_getDEdxCDC(_FDCdEdxTrunc *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getDEdxCDC());
}

static PyObject*
_FDCdEdxTrunc_getDEdxFDC(_FDCdEdxTrunc *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getDEdxFDC());
}

static PyObject*
_FDCdEdxTrunc_getDxCDC(_FDCdEdxTrunc *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getDxCDC());
}

static PyObject*
_FDCdEdxTrunc_getDxFDC(_FDCdEdxTrunc *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getDxFDC());
}

static PyObject*
_FDCdEdxTrunc_getDEdx(_FDCdEdxTrunc *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getDEdx());
}

static int
_FDCdEdxTrunc_setDEdx(_FDCdEdxTrunc *self, PyObject *value, void *closure)
{
   double var = PyFloat_AsDouble(value);
   if (var == -1 && PyErr_Occurred()) {
      return 1;
   }
   self->elem->setDEdx((float)var);
   return 0;
}

static PyObject*
_FDCdEdxTrunc_getDEdxAmp(_FDCdEdxTrunc *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getDEdxAmp());
}

static int
_FDCdEdxTrunc_setDEdxAmp(_FDCdEdxTrunc *self, PyObject *value, void *closure)
{
   double var = PyFloat_AsDouble(value);
   if (var == -1 && PyErr_Occurred()) {
      return 1;
   }
   self->elem->setDEdxAmp((float)var);
   return 0;
}

static PyObject*
_FDCdEdxTrunc_getDEdx_unit(_FDCdEdxTrunc *self, void *closure)
{
   std::string val(self->elem->getDEdx_unit());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_FDCdEdxTrunc_getDx(_FDCdEdxTrunc *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getDx());
}

static int
_FDCdEdxTrunc_setDx(_FDCdEdxTrunc *self, PyObject *value, void *closure)
{
   double var = PyFloat_AsDouble(value);
   if (var == -1 && PyErr_Occurred()) {
      return 1;
   }
   self->elem->setDx((float)var);
   return 0;
}

static PyObject*
_FDCdEdxTrunc_getDxAmp(_FDCdEdxTrunc *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getDxAmp());
}

static int
_FDCdEdxTrunc_setDxAmp(_FDCdEdxTrunc *self, PyObject *value, void *closure)
{
   double var = PyFloat_AsDouble(value);
   if (var == -1 && PyErr_Occurred()) {
      return 1;
   }
   self->elem->setDxAmp((float)var);
   return 0;
}

static PyObject*
_FDCdEdxTrunc_getLunit(_FDCdEdxTrunc *self, void *closure)
{
   std::string val(self->elem->getLunit());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_FDCdEdxTrunc_getMaxOccurs(_FDCdEdxTrunc *self, void *closure)
{
   std::string val(self->elem->getMaxOccurs());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_FDCdEdxTrunc_getMinOccurs(_FDCdEdxTrunc *self, void *closure)
{
   return PyLong_FromLong(self->elem->getMinOccurs());
}

static PyObject*
_FDCdEdxTrunc_getNtrunc(_FDCdEdxTrunc *self, void *closure)
{
   return PyLong_FromLong(self->elem->getNtrunc());
}

static int
_FDCdEdxTrunc_setNtrunc(_FDCdEdxTrunc *self, PyObject *value, void *closure)
{
   long var = PyInt_AsLong(value);
   if (var == -1 && PyErr_Occurred()) {
      return -1;
   }
   self->elem->setNtrunc(var);
   return 0;
}

static PyObject*
_FDCdEdxTrunc_toString(PyObject *self, PyObject *args=0)
{
   _FDCdEdxTrunc *me = (_FDCdEdxTrunc*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid FDCdEdxTrunc element");
      return NULL;
   }
   std::string str(me->elem->toString());
   return PyUnicode_FromString(str.c_str());
}

static PyObject*
_FDCdEdxTrunc_toXML(PyObject *self, PyObject *args=0)
{
   _FDCdEdxTrunc *me = (_FDCdEdxTrunc*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid FDCdEdxTrunc element");
      return NULL;
   }
   std::string str(me->elem->toXML());
   return PyUnicode_FromString(str.c_str());
}

static PyGetSetDef _FDCdEdxTrunc_getsetters[] = {
   {(char*)"NsampleCDC",
    (getter)_FDCdEdxTrunc_getNsampleCDC, 0,
    (char*)"NsampleCDC value",
    NULL},
   {(char*)"NsampleFDC",
    (getter)_FDCdEdxTrunc_getNsampleFDC, 0,
    (char*)"NsampleFDC value",
    NULL},
   {(char*)"candidateId",
    (getter)_FDCdEdxTrunc_getCandidateId, 0,
    (char*)"candidateId value",
    NULL},
   {(char*)"class",
    (getter)_FDCdEdxTrunc_getClass, 0,
    (char*)"class string",
    NULL},
   {(char*)"dEdx",
    (getter)_FDCdEdxTrunc_getDEdx, (setter)_FDCdEdxTrunc_setDEdx,
    (char*)"dEdx value",
    NULL},
   {(char*)"dEdxAmp",
    (getter)_FDCdEdxTrunc_getDEdxAmp, (setter)_FDCdEdxTrunc_setDEdxAmp,
    (char*)"dEdxAmp value",
    NULL},
   {(char*)"dEdxCDC",
    (getter)_FDCdEdxTrunc_getDEdxCDC, 0,
    (char*)"dEdxCDC value",
    NULL},
   {(char*)"dEdxFDC",
    (getter)_FDCdEdxTrunc_getDEdxFDC, 0,
    (char*)"dEdxFDC value",
    NULL},
   {(char*)"dEdx_unit",
    (getter)_FDCdEdxTrunc_getDEdx_unit, 0,
    (char*)"dEdx_unit value",
    NULL},
   {(char*)"dx",
    (getter)_FDCdEdxTrunc_getDx, (setter)_FDCdEdxTrunc_setDx,
    (char*)"dx value",
    NULL},
   {(char*)"dxAmp",
    (getter)_FDCdEdxTrunc_getDxAmp, (setter)_FDCdEdxTrunc_setDxAmp,
    (char*)"dxAmp value",
    NULL},
   {(char*)"dxCDC",
    (getter)_FDCdEdxTrunc_getDxCDC, 0,
    (char*)"dxCDC value",
    NULL},
   {(char*)"dxFDC",
    (getter)_FDCdEdxTrunc_getDxFDC, 0,
    (char*)"dxFDC value",
    NULL},
   {(char*)"eventNo",
    (getter)_FDCdEdxTrunc_getEventNo, 0,
    (char*)"eventNo value",
    NULL},
   {(char*)"jtag",
    (getter)_FDCdEdxTrunc_getJtag, 0,
    (char*)"jtag string",
    NULL},
   {(char*)"lunit",
    (getter)_FDCdEdxTrunc_getLunit, 0,
    (char*)"lunit value",
    NULL},
   {(char*)"maxOccurs",
    (getter)_FDCdEdxTrunc_getMaxOccurs, 0,
    (char*)"maxOccurs value",
    NULL},
   {(char*)"minOccurs",
    (getter)_FDCdEdxTrunc_getMinOccurs, 0,
    (char*)"minOccurs value",
    NULL},
   {(char*)"ntrunc",
    (getter)_FDCdEdxTrunc_getNtrunc, (setter)_FDCdEdxTrunc_setNtrunc,
    (char*)"ntrunc value",
    NULL},
   {(char*)"ptype",
    (getter)_FDCdEdxTrunc_getPtype, 0,
    (char*)"ptype value",
    NULL},
   {(char*)"runNo",
    (getter)_FDCdEdxTrunc_getRunNo, 0,
    (char*)"runNo value",
    NULL},
   {(char*)"version",
    (getter)_FDCdEdxTrunc_getVersion, 0,
    (char*)"version string",
    NULL},
   {(char*)"xmlns",
    (getter)_FDCdEdxTrunc_getXmlns, 0,
    (char*)"xmlns string",
    NULL},
   {NULL}  /* Sentinel */
};

static PyMemberDef _FDCdEdxTrunc_members[] = {
   {NULL}  /* Sentinel */
};

static PyMethodDef _FDCdEdxTrunc_methods[] = {
   {"toString", _FDCdEdxTrunc_toString, METH_NOARGS,
    "show element as a human-readable string"},
   {"toXML", _FDCdEdxTrunc_toXML, METH_NOARGS,
    "show element as a XML fragment"},
   {NULL}  /* Sentinel */
};

static PyTypeObject _FDCdEdxTrunc_type = {
    PyVarObject_HEAD_INIT(NULL,0)
    "hddm_r.FDCdEdxTrunc",         /*tp_name*/
    sizeof(_FDCdEdxTrunc),          /*tp_basicsize*/
    0,                         /*tp_itemsize*/
    (destructor)_FDCdEdxTrunc_dealloc, /*tp_dealloc*/
    0,                         /*tp_print*/
    0,                         /*tp_getattr*/
    0,                         /*tp_setattr*/
    0,                         /*tp_compare*/
    0,                         /*tp_repr*/
    0,                         /*tp_as_number*/
    0,                         /*tp_as_sequence*/
    0,                         /*tp_as_mapping*/
    0,                         /*tp_hash */
    0,                         /*tp_call*/
    (reprfunc)_FDCdEdxTrunc_toString,         /*tp_str*/
    0,                         /*tp_getattro*/
    0,                         /*tp_setattro*/
    0,                         /*tp_as_buffer*/
    Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE, /*tp_flags*/
    "hddm_r FDCdEdxTrunc element",  /* tp_doc */
    0,                         /* tp_traverse */
    0,                         /* tp_clear */
    0,                         /* tp_richcompare */
    0,                         /* tp_weaklistoffset */
    0,                         /* tp_iter */
    0,                         /* tp_iternext */
    _FDCdEdxTrunc_methods,          /* tp_methods */
    _FDCdEdxTrunc_members,          /* tp_members */
    _FDCdEdxTrunc_getsetters,       /* tp_getset */
    &_HDDM_Element_type,       /* tp_base */
    0,                         /* tp_dict */
    0,                         /* tp_descr_get */
    0,                         /* tp_descr_set */
    0,                         /* tp_dictoffset */
    (initproc)_FDCdEdxTrunc_init,   /* tp_init */
    0,                         /* tp_alloc */
    _FDCdEdxTrunc_new,              /* tp_new */
};



// wrap element class hddm_r::DEdxDC as hddm_r.DEdxDC

typedef struct {
   PyObject_HEAD
   DEdxDC *elem;
   PyObject *host;
} _DEdxDC;

static void
_DEdxDC_dealloc(_DEdxDC* self)
{
   if (self->elem != 0) {
      LOG_DEALLOC(Py_TYPE(self), 0, self->host == (PyObject*)self);
      if (self->host == (PyObject*)self)
         delete self->elem;
      else
         My_DECREF(self->host);
   }
   Py_TYPE(self)->tp_free((PyObject*)self);
}

static PyObject*
_DEdxDC_new(PyTypeObject *type, PyObject *args, PyObject *kwds)
{
   _DEdxDC *self;
   self = (_DEdxDC*)type->tp_alloc(type, 0);
   if (self != NULL) {
      self->elem = 0;
      self->host = 0;
   }
   return (PyObject*)self;
}

static int
_DEdxDC_init(_DEdxDC *self, PyObject *args, PyObject *kwds)
{
   PyErr_SetString(PyExc_RuntimeError, "illegal constructor");
   return -1;
}

static PyObject*
_DEdxDC_getClass(_DEdxDC *self, void *closure)
{
   std::string val(self->elem->getClass());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_DEdxDC_getVersion(_DEdxDC *self, void *closure)
{
   std::string val(self->elem->getVersion());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_DEdxDC_getXmlns(_DEdxDC *self, void *closure)
{
   std::string val(self->elem->getXmlns());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_DEdxDC_getEventNo(_DEdxDC *self, void *closure)
{
   return PyLong_FromLongLong(self->elem->getEventNo());
}

static PyObject*
_DEdxDC_getRunNo(_DEdxDC *self, void *closure)
{
   return PyLong_FromLong(self->elem->getRunNo());
}

static PyObject*
_DEdxDC_getCandidateId(_DEdxDC *self, void *closure)
{
   return PyLong_FromLong(self->elem->getCandidateId());
}

static PyObject*
_DEdxDC_getJtag(_DEdxDC *self, void *closure)
{
   std::string val(self->elem->getJtag());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_DEdxDC_getMaxOccurs(_DEdxDC *self, void *closure)
{
   std::string val(self->elem->getMaxOccurs());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_DEdxDC_getPtype(_DEdxDC *self, void *closure)
{
   Particle_t p(self->elem->getPtype());
   std::string val(ParticleType(p));
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_DEdxDC_getNsampleCDC(_DEdxDC *self, void *closure)
{
   return PyLong_FromLong(self->elem->getNsampleCDC());
}

static int
_DEdxDC_setNsampleCDC(_DEdxDC *self, PyObject *value, void *closure)
{
   long var = PyInt_AsLong(value);
   if (var == -1 && PyErr_Occurred()) {
      return -1;
   }
   self->elem->setNsampleCDC(var);
   return 0;
}

static PyObject*
_DEdxDC_getNsampleFDC(_DEdxDC *self, void *closure)
{
   return PyLong_FromLong(self->elem->getNsampleFDC());
}

static int
_DEdxDC_setNsampleFDC(_DEdxDC *self, PyObject *value, void *closure)
{
   long var = PyInt_AsLong(value);
   if (var == -1 && PyErr_Occurred()) {
      return -1;
   }
   self->elem->setNsampleFDC(var);
   return 0;
}

static PyObject*
_DEdxDC_getDEdxCDC(_DEdxDC *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getDEdxCDC());
}

static int
_DEdxDC_setDEdxCDC(_DEdxDC *self, PyObject *value, void *closure)
{
   double var = PyFloat_AsDouble(value);
   if (var == -1 && PyErr_Occurred()) {
      return 1;
   }
   self->elem->setDEdxCDC((float)var);
   return 0;
}

static PyObject*
_DEdxDC_getDEdxFDC(_DEdxDC *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getDEdxFDC());
}

static int
_DEdxDC_setDEdxFDC(_DEdxDC *self, PyObject *value, void *closure)
{
   double var = PyFloat_AsDouble(value);
   if (var == -1 && PyErr_Occurred()) {
      return 1;
   }
   self->elem->setDEdxFDC((float)var);
   return 0;
}

static PyObject*
_DEdxDC_getDEdx_unit(_DEdxDC *self, void *closure)
{
   std::string val(self->elem->getDEdx_unit());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_DEdxDC_getDxCDC(_DEdxDC *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getDxCDC());
}

static int
_DEdxDC_setDxCDC(_DEdxDC *self, PyObject *value, void *closure)
{
   double var = PyFloat_AsDouble(value);
   if (var == -1 && PyErr_Occurred()) {
      return 1;
   }
   self->elem->setDxCDC((float)var);
   return 0;
}

static PyObject*
_DEdxDC_getDxFDC(_DEdxDC *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getDxFDC());
}

static int
_DEdxDC_setDxFDC(_DEdxDC *self, PyObject *value, void *closure)
{
   double var = PyFloat_AsDouble(value);
   if (var == -1 && PyErr_Occurred()) {
      return 1;
   }
   self->elem->setDxFDC((float)var);
   return 0;
}

static PyObject*
_DEdxDC_getLunit(_DEdxDC *self, void *closure)
{
   std::string val(self->elem->getLunit());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_DEdxDC_getMinOccurs(_DEdxDC *self, void *closure)
{
   return PyLong_FromLong(self->elem->getMinOccurs());
}

static PyObject*
_DEdxDC_getCDCAmpdEdx(PyObject *self, PyObject *args)
{
   int index=0;
   if (! PyArg_ParseTuple(args, "|i", &index)) {
      return NULL;
   }
   _DEdxDC *me = (_DEdxDC*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid dEdxDC element");
      return NULL;
   }
   PyObject *obj = _CDCAmpdEdx_new(&_CDCAmpdEdx_type, 0, 0);
   ((_CDCAmpdEdx*)obj)->elem = &me->elem->getCDCAmpdEdx();
   ((_CDCAmpdEdx*)obj)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(obj));
   return obj;
}

static PyObject*
_DEdxDC_getCDCAmpdEdxs(PyObject *self, PyObject *args)
{
   _DEdxDC *me = (_DEdxDC*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid dEdxDC element");
      return NULL;
   }
   PyObject *list = _HDDM_ElementList_new(&_HDDM_ElementList_type, 0, 0);
   ((_HDDM_ElementList*)list)->subtype = &_CDCAmpdEdx_type;
   ((_HDDM_ElementList*)list)->list = (HDDM_ElementList<HDDM_Element>*)
    &me->elem->getCDCAmpdEdxs();
   ((_HDDM_ElementList*)list)->borrowed = 1;
   ((_HDDM_ElementList*)list)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(list), ((_HDDM_ElementList*)list)->subtype, 0);
   return list;
}

static PyObject*
_DEdxDC_addCDCAmpdEdxs(PyObject *self, PyObject *args)
{
   int count=1;
   int start=-1;
   if (! PyArg_ParseTuple(args, "|ii", &count, &start)) {
      return NULL;
   }
   _DEdxDC *me = (_DEdxDC*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "add attempted on invalid dEdxDC element");
      return NULL;
   }
   PyObject *list = _HDDM_ElementList_new(&_HDDM_ElementList_type, 0, 0);
   ((_HDDM_ElementList*)list)->subtype = &_CDCAmpdEdx_type;
   ((_HDDM_ElementList*)list)->list = (HDDM_ElementList<HDDM_Element>*)
    new CDCAmpdEdxList(me->elem->addCDCAmpdEdxs(count, start));
   ((_HDDM_ElementList*)list)->borrowed = 0;
   ((_HDDM_ElementList*)list)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(list), ((_HDDM_ElementList*)list)->subtype, 1);
   return list;
}

static PyObject*
_DEdxDC_deleteCDCAmpdEdxs(PyObject *self, PyObject *args)
{
   int count=-1;
   int start=0;
   if (! PyArg_ParseTuple(args, "|ii", &count, &start)) {
      return NULL;
   }
   _DEdxDC *me = (_DEdxDC*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "delete attempted on invalid dEdxDC element");
      return NULL;
   }
   me->elem->deleteCDCAmpdEdxs(count, start);
   Py_INCREF(Py_None);
   return Py_None;
}

static PyObject*
_DEdxDC_getCDCdEdxTrunc(PyObject *self, PyObject *args)
{
   int index=0;
   if (! PyArg_ParseTuple(args, "|i", &index)) {
      return NULL;
   }
   _DEdxDC *me = (_DEdxDC*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid dEdxDC element");
      return NULL;
   }
   PyObject *obj = _CDCdEdxTrunc_new(&_CDCdEdxTrunc_type, 0, 0);
   ((_CDCdEdxTrunc*)obj)->elem = &me->elem->getCDCdEdxTrunc(index);
   ((_CDCdEdxTrunc*)obj)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(obj));
   return obj;
}

static PyObject*
_DEdxDC_getCDCdEdxTruncs(PyObject *self, PyObject *args)
{
   _DEdxDC *me = (_DEdxDC*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid dEdxDC element");
      return NULL;
   }
   PyObject *list = _HDDM_ElementList_new(&_HDDM_ElementList_type, 0, 0);
   ((_HDDM_ElementList*)list)->subtype = &_CDCdEdxTrunc_type;
   ((_HDDM_ElementList*)list)->list = (HDDM_ElementList<HDDM_Element>*)
    &me->elem->getCDCdEdxTruncs();
   ((_HDDM_ElementList*)list)->borrowed = 1;
   ((_HDDM_ElementList*)list)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(list), ((_HDDM_ElementList*)list)->subtype, 0);
   return list;
}

static PyObject*
_DEdxDC_addCDCdEdxTruncs(PyObject *self, PyObject *args)
{
   int count=1;
   int start=-1;
   if (! PyArg_ParseTuple(args, "|ii", &count, &start)) {
      return NULL;
   }
   _DEdxDC *me = (_DEdxDC*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "add attempted on invalid dEdxDC element");
      return NULL;
   }
   PyObject *list = _HDDM_ElementList_new(&_HDDM_ElementList_type, 0, 0);
   ((_HDDM_ElementList*)list)->subtype = &_CDCdEdxTrunc_type;
   ((_HDDM_ElementList*)list)->list = (HDDM_ElementList<HDDM_Element>*)
    new CDCdEdxTruncList(me->elem->addCDCdEdxTruncs(count, start));
   ((_HDDM_ElementList*)list)->borrowed = 0;
   ((_HDDM_ElementList*)list)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(list), ((_HDDM_ElementList*)list)->subtype, 1);
   return list;
}

static PyObject*
_DEdxDC_deleteCDCdEdxTruncs(PyObject *self, PyObject *args)
{
   int count=-1;
   int start=0;
   if (! PyArg_ParseTuple(args, "|ii", &count, &start)) {
      return NULL;
   }
   _DEdxDC *me = (_DEdxDC*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "delete attempted on invalid dEdxDC element");
      return NULL;
   }
   me->elem->deleteCDCdEdxTruncs(count, start);
   Py_INCREF(Py_None);
   return Py_None;
}

static PyObject*
_DEdxDC_getFDCdEdxTrunc(PyObject *self, PyObject *args)
{
   int index=0;
   if (! PyArg_ParseTuple(args, "|i", &index)) {
      return NULL;
   }
   _DEdxDC *me = (_DEdxDC*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid dEdxDC element");
      return NULL;
   }
   PyObject *obj = _FDCdEdxTrunc_new(&_FDCdEdxTrunc_type, 0, 0);
   ((_FDCdEdxTrunc*)obj)->elem = &me->elem->getFDCdEdxTrunc(index);
   ((_FDCdEdxTrunc*)obj)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(obj));
   return obj;
}

static PyObject*
_DEdxDC_getFDCdEdxTruncs(PyObject *self, PyObject *args)
{
   _DEdxDC *me = (_DEdxDC*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid dEdxDC element");
      return NULL;
   }
   PyObject *list = _HDDM_ElementList_new(&_HDDM_ElementList_type, 0, 0);
   ((_HDDM_ElementList*)list)->subtype = &_FDCdEdxTrunc_type;
   ((_HDDM_ElementList*)list)->list = (HDDM_ElementList<HDDM_Element>*)
    &me->elem->getFDCdEdxTruncs();
   ((_HDDM_ElementList*)list)->borrowed = 1;
   ((_HDDM_ElementList*)list)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(list), ((_HDDM_ElementList*)list)->subtype, 0);
   return list;
}

static PyObject*
_DEdxDC_addFDCdEdxTruncs(PyObject *self, PyObject *args)
{
   int count=1;
   int start=-1;
   if (! PyArg_ParseTuple(args, "|ii", &count, &start)) {
      return NULL;
   }
   _DEdxDC *me = (_DEdxDC*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "add attempted on invalid dEdxDC element");
      return NULL;
   }
   PyObject *list = _HDDM_ElementList_new(&_HDDM_ElementList_type, 0, 0);
   ((_HDDM_ElementList*)list)->subtype = &_FDCdEdxTrunc_type;
   ((_HDDM_ElementList*)list)->list = (HDDM_ElementList<HDDM_Element>*)
    new FDCdEdxTruncList(me->elem->addFDCdEdxTruncs(count, start));
   ((_HDDM_ElementList*)list)->borrowed = 0;
   ((_HDDM_ElementList*)list)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(list), ((_HDDM_ElementList*)list)->subtype, 1);
   return list;
}

static PyObject*
_DEdxDC_deleteFDCdEdxTruncs(PyObject *self, PyObject *args)
{
   int count=-1;
   int start=0;
   if (! PyArg_ParseTuple(args, "|ii", &count, &start)) {
      return NULL;
   }
   _DEdxDC *me = (_DEdxDC*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "delete attempted on invalid dEdxDC element");
      return NULL;
   }
   me->elem->deleteFDCdEdxTruncs(count, start);
   Py_INCREF(Py_None);
   return Py_None;
}

static PyObject*
_DEdxDC_toString(PyObject *self, PyObject *args=0)
{
   _DEdxDC *me = (_DEdxDC*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid dEdxDC element");
      return NULL;
   }
   std::string str(me->elem->toString());
   return PyUnicode_FromString(str.c_str());
}

static PyObject*
_DEdxDC_toXML(PyObject *self, PyObject *args=0)
{
   _DEdxDC *me = (_DEdxDC*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid dEdxDC element");
      return NULL;
   }
   std::string str(me->elem->toXML());
   return PyUnicode_FromString(str.c_str());
}

static PyGetSetDef _DEdxDC_getsetters[] = {
   {(char*)"NsampleCDC",
    (getter)_DEdxDC_getNsampleCDC, (setter)_DEdxDC_setNsampleCDC,
    (char*)"NsampleCDC value",
    NULL},
   {(char*)"NsampleFDC",
    (getter)_DEdxDC_getNsampleFDC, (setter)_DEdxDC_setNsampleFDC,
    (char*)"NsampleFDC value",
    NULL},
   {(char*)"candidateId",
    (getter)_DEdxDC_getCandidateId, 0,
    (char*)"candidateId value",
    NULL},
   {(char*)"class",
    (getter)_DEdxDC_getClass, 0,
    (char*)"class string",
    NULL},
   {(char*)"dEdxCDC",
    (getter)_DEdxDC_getDEdxCDC, (setter)_DEdxDC_setDEdxCDC,
    (char*)"dEdxCDC value",
    NULL},
   {(char*)"dEdxFDC",
    (getter)_DEdxDC_getDEdxFDC, (setter)_DEdxDC_setDEdxFDC,
    (char*)"dEdxFDC value",
    NULL},
   {(char*)"dEdx_unit",
    (getter)_DEdxDC_getDEdx_unit, 0,
    (char*)"dEdx_unit value",
    NULL},
   {(char*)"dxCDC",
    (getter)_DEdxDC_getDxCDC, (setter)_DEdxDC_setDxCDC,
    (char*)"dxCDC value",
    NULL},
   {(char*)"dxFDC",
    (getter)_DEdxDC_getDxFDC, (setter)_DEdxDC_setDxFDC,
    (char*)"dxFDC value",
    NULL},
   {(char*)"eventNo",
    (getter)_DEdxDC_getEventNo, 0,
    (char*)"eventNo value",
    NULL},
   {(char*)"jtag",
    (getter)_DEdxDC_getJtag, 0,
    (char*)"jtag string",
    NULL},
   {(char*)"lunit",
    (getter)_DEdxDC_getLunit, 0,
    (char*)"lunit value",
    NULL},
   {(char*)"maxOccurs",
    (getter)_DEdxDC_getMaxOccurs, 0,
    (char*)"maxOccurs string",
    NULL},
   {(char*)"minOccurs",
    (getter)_DEdxDC_getMinOccurs, 0,
    (char*)"minOccurs value",
    NULL},
   {(char*)"ptype",
    (getter)_DEdxDC_getPtype, 0,
    (char*)"ptype value",
    NULL},
   {(char*)"runNo",
    (getter)_DEdxDC_getRunNo, 0,
    (char*)"runNo value",
    NULL},
   {(char*)"version",
    (getter)_DEdxDC_getVersion, 0,
    (char*)"version string",
    NULL},
   {(char*)"xmlns",
    (getter)_DEdxDC_getXmlns, 0,
    (char*)"xmlns string",
    NULL},
   {NULL}  /* Sentinel */
};

static PyMemberDef _DEdxDC_members[] = {
   {NULL}  /* Sentinel */
};

static PyMethodDef _DEdxDC_methods[] = {
   {"addCDCAmpdEdxs", _DEdxDC_addCDCAmpdEdxs, METH_VARARGS,
    "extend (or insert into) the list of CDCAmpdEdx objects for this dEdxDC"},
   {"addCDCdEdxTruncs", _DEdxDC_addCDCdEdxTruncs, METH_VARARGS,
    "extend (or insert into) the list of CDCdEdxTrunc objects for this dEdxDC"},
   {"addFDCdEdxTruncs", _DEdxDC_addFDCdEdxTruncs, METH_VARARGS,
    "extend (or insert into) the list of FDCdEdxTrunc objects for this dEdxDC"},
   {"deleteCDCAmpdEdxs", _DEdxDC_deleteCDCAmpdEdxs, METH_VARARGS,
    "delete CDCAmpdEdx objects for this dEdxDC"},
   {"deleteCDCdEdxTruncs", _DEdxDC_deleteCDCdEdxTruncs, METH_VARARGS,
    "delete CDCdEdxTrunc objects for this dEdxDC"},
   {"deleteFDCdEdxTruncs", _DEdxDC_deleteFDCdEdxTruncs, METH_VARARGS,
    "delete FDCdEdxTrunc objects for this dEdxDC"},
   {"getCDCAmpdEdx", _DEdxDC_getCDCAmpdEdx, METH_VARARGS,
    "get an individual CDCAmpdEdx object from this dEdxDC"},
   {"getCDCAmpdEdxs", _DEdxDC_getCDCAmpdEdxs, METH_NOARGS,
    "get list of CDCAmpdEdx objects for this dEdxDC"},
   {"getCDCdEdxTrunc", _DEdxDC_getCDCdEdxTrunc, METH_VARARGS,
    "get an individual CDCdEdxTrunc object from this dEdxDC"},
   {"getCDCdEdxTruncs", _DEdxDC_getCDCdEdxTruncs, METH_NOARGS,
    "get list of CDCdEdxTrunc objects for this dEdxDC"},
   {"getFDCdEdxTrunc", _DEdxDC_getFDCdEdxTrunc, METH_VARARGS,
    "get an individual FDCdEdxTrunc object from this dEdxDC"},
   {"getFDCdEdxTruncs", _DEdxDC_getFDCdEdxTruncs, METH_NOARGS,
    "get list of FDCdEdxTrunc objects for this dEdxDC"},
   {"toString", _DEdxDC_toString, METH_NOARGS,
    "show element as a human-readable string"},
   {"toXML", _DEdxDC_toXML, METH_NOARGS,
    "show element as a XML fragment"},
   {NULL}  /* Sentinel */
};

static PyTypeObject _DEdxDC_type = {
    PyVarObject_HEAD_INIT(NULL,0)
    "hddm_r.DEdxDC",         /*tp_name*/
    sizeof(_DEdxDC),          /*tp_basicsize*/
    0,                         /*tp_itemsize*/
    (destructor)_DEdxDC_dealloc, /*tp_dealloc*/
    0,                         /*tp_print*/
    0,                         /*tp_getattr*/
    0,                         /*tp_setattr*/
    0,                         /*tp_compare*/
    0,                         /*tp_repr*/
    0,                         /*tp_as_number*/
    0,                         /*tp_as_sequence*/
    0,                         /*tp_as_mapping*/
    0,                         /*tp_hash */
    0,                         /*tp_call*/
    (reprfunc)_DEdxDC_toString,         /*tp_str*/
    0,                         /*tp_getattro*/
    0,                         /*tp_setattro*/
    0,                         /*tp_as_buffer*/
    Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE, /*tp_flags*/
    "hddm_r dEdxDC element",  /* tp_doc */
    0,                         /* tp_traverse */
    0,                         /* tp_clear */
    0,                         /* tp_richcompare */
    0,                         /* tp_weaklistoffset */
    0,                         /* tp_iter */
    0,                         /* tp_iternext */
    _DEdxDC_methods,          /* tp_methods */
    _DEdxDC_members,          /* tp_members */
    _DEdxDC_getsetters,       /* tp_getset */
    &_HDDM_Element_type,       /* tp_base */
    0,                         /* tp_dict */
    0,                         /* tp_descr_get */
    0,                         /* tp_descr_set */
    0,                         /* tp_dictoffset */
    (initproc)_DEdxDC_init,   /* tp_init */
    0,                         /* tp_alloc */
    _DEdxDC_new,              /* tp_new */
};



// wrap element class hddm_r::ExitParams as hddm_r.ExitParams

typedef struct {
   PyObject_HEAD
   ExitParams *elem;
   PyObject *host;
} _ExitParams;

static void
_ExitParams_dealloc(_ExitParams* self)
{
   if (self->elem != 0) {
      LOG_DEALLOC(Py_TYPE(self), 0, self->host == (PyObject*)self);
      if (self->host == (PyObject*)self)
         delete self->elem;
      else
         My_DECREF(self->host);
   }
   Py_TYPE(self)->tp_free((PyObject*)self);
}

static PyObject*
_ExitParams_new(PyTypeObject *type, PyObject *args, PyObject *kwds)
{
   _ExitParams *self;
   self = (_ExitParams*)type->tp_alloc(type, 0);
   if (self != NULL) {
      self->elem = 0;
      self->host = 0;
   }
   return (PyObject*)self;
}

static int
_ExitParams_init(_ExitParams *self, PyObject *args, PyObject *kwds)
{
   PyErr_SetString(PyExc_RuntimeError, "illegal constructor");
   return -1;
}

static PyObject*
_ExitParams_getClass(_ExitParams *self, void *closure)
{
   std::string val(self->elem->getClass());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_ExitParams_getVersion(_ExitParams *self, void *closure)
{
   std::string val(self->elem->getVersion());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_ExitParams_getXmlns(_ExitParams *self, void *closure)
{
   std::string val(self->elem->getXmlns());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_ExitParams_getEventNo(_ExitParams *self, void *closure)
{
   return PyLong_FromLongLong(self->elem->getEventNo());
}

static PyObject*
_ExitParams_getRunNo(_ExitParams *self, void *closure)
{
   return PyLong_FromLong(self->elem->getRunNo());
}

static PyObject*
_ExitParams_getCandidateId(_ExitParams *self, void *closure)
{
   return PyLong_FromLong(self->elem->getCandidateId());
}

static PyObject*
_ExitParams_getJtag(_ExitParams *self, void *closure)
{
   std::string val(self->elem->getJtag());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_ExitParams_getPtype(_ExitParams *self, void *closure)
{
   Particle_t p(self->elem->getPtype());
   std::string val(ParticleType(p));
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_ExitParams_getLunit(_ExitParams *self, void *closure)
{
   std::string val(self->elem->getLunit());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_ExitParams_getMaxOccurs(_ExitParams *self, void *closure)
{
   return PyLong_FromLong(self->elem->getMaxOccurs());
}

static PyObject*
_ExitParams_getMinOccurs(_ExitParams *self, void *closure)
{
   return PyLong_FromLong(self->elem->getMinOccurs());
}

static PyObject*
_ExitParams_getPunit(_ExitParams *self, void *closure)
{
   std::string val(self->elem->getPunit());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_ExitParams_getPx1(_ExitParams *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getPx1());
}

static int
_ExitParams_setPx1(_ExitParams *self, PyObject *value, void *closure)
{
   double var = PyFloat_AsDouble(value);
   if (var == -1 && PyErr_Occurred()) {
      return 1;
   }
   self->elem->setPx1((float)var);
   return 0;
}

static PyObject*
_ExitParams_getPy1(_ExitParams *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getPy1());
}

static int
_ExitParams_setPy1(_ExitParams *self, PyObject *value, void *closure)
{
   double var = PyFloat_AsDouble(value);
   if (var == -1 && PyErr_Occurred()) {
      return 1;
   }
   self->elem->setPy1((float)var);
   return 0;
}

static PyObject*
_ExitParams_getPz1(_ExitParams *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getPz1());
}

static int
_ExitParams_setPz1(_ExitParams *self, PyObject *value, void *closure)
{
   double var = PyFloat_AsDouble(value);
   if (var == -1 && PyErr_Occurred()) {
      return 1;
   }
   self->elem->setPz1((float)var);
   return 0;
}

static PyObject*
_ExitParams_getT1(_ExitParams *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getT1());
}

static int
_ExitParams_setT1(_ExitParams *self, PyObject *value, void *closure)
{
   double var = PyFloat_AsDouble(value);
   if (var == -1 && PyErr_Occurred()) {
      return 1;
   }
   self->elem->setT1((float)var);
   return 0;
}

static PyObject*
_ExitParams_getTunit(_ExitParams *self, void *closure)
{
   std::string val(self->elem->getTunit());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_ExitParams_getX1(_ExitParams *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getX1());
}

static int
_ExitParams_setX1(_ExitParams *self, PyObject *value, void *closure)
{
   double var = PyFloat_AsDouble(value);
   if (var == -1 && PyErr_Occurred()) {
      return 1;
   }
   self->elem->setX1((float)var);
   return 0;
}

static PyObject*
_ExitParams_getY1(_ExitParams *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getY1());
}

static int
_ExitParams_setY1(_ExitParams *self, PyObject *value, void *closure)
{
   double var = PyFloat_AsDouble(value);
   if (var == -1 && PyErr_Occurred()) {
      return 1;
   }
   self->elem->setY1((float)var);
   return 0;
}

static PyObject*
_ExitParams_getZ1(_ExitParams *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getZ1());
}

static int
_ExitParams_setZ1(_ExitParams *self, PyObject *value, void *closure)
{
   double var = PyFloat_AsDouble(value);
   if (var == -1 && PyErr_Occurred()) {
      return 1;
   }
   self->elem->setZ1((float)var);
   return 0;
}

static PyObject*
_ExitParams_toString(PyObject *self, PyObject *args=0)
{
   _ExitParams *me = (_ExitParams*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid exitParams element");
      return NULL;
   }
   std::string str(me->elem->toString());
   return PyUnicode_FromString(str.c_str());
}

static PyObject*
_ExitParams_toXML(PyObject *self, PyObject *args=0)
{
   _ExitParams *me = (_ExitParams*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid exitParams element");
      return NULL;
   }
   std::string str(me->elem->toXML());
   return PyUnicode_FromString(str.c_str());
}

static PyGetSetDef _ExitParams_getsetters[] = {
   {(char*)"candidateId",
    (getter)_ExitParams_getCandidateId, 0,
    (char*)"candidateId value",
    NULL},
   {(char*)"class",
    (getter)_ExitParams_getClass, 0,
    (char*)"class string",
    NULL},
   {(char*)"eventNo",
    (getter)_ExitParams_getEventNo, 0,
    (char*)"eventNo value",
    NULL},
   {(char*)"jtag",
    (getter)_ExitParams_getJtag, 0,
    (char*)"jtag string",
    NULL},
   {(char*)"lunit",
    (getter)_ExitParams_getLunit, 0,
    (char*)"lunit value",
    NULL},
   {(char*)"maxOccurs",
    (getter)_ExitParams_getMaxOccurs, 0,
    (char*)"maxOccurs value",
    NULL},
   {(char*)"minOccurs",
    (getter)_ExitParams_getMinOccurs, 0,
    (char*)"minOccurs value",
    NULL},
   {(char*)"ptype",
    (getter)_ExitParams_getPtype, 0,
    (char*)"ptype value",
    NULL},
   {(char*)"punit",
    (getter)_ExitParams_getPunit, 0,
    (char*)"punit value",
    NULL},
   {(char*)"px1",
    (getter)_ExitParams_getPx1, (setter)_ExitParams_setPx1,
    (char*)"px1 value",
    NULL},
   {(char*)"py1",
    (getter)_ExitParams_getPy1, (setter)_ExitParams_setPy1,
    (char*)"py1 value",
    NULL},
   {(char*)"pz1",
    (getter)_ExitParams_getPz1, (setter)_ExitParams_setPz1,
    (char*)"pz1 value",
    NULL},
   {(char*)"runNo",
    (getter)_ExitParams_getRunNo, 0,
    (char*)"runNo value",
    NULL},
   {(char*)"t1",
    (getter)_ExitParams_getT1, (setter)_ExitParams_setT1,
    (char*)"t1 value",
    NULL},
   {(char*)"tunit",
    (getter)_ExitParams_getTunit, 0,
    (char*)"tunit value",
    NULL},
   {(char*)"version",
    (getter)_ExitParams_getVersion, 0,
    (char*)"version string",
    NULL},
   {(char*)"x1",
    (getter)_ExitParams_getX1, (setter)_ExitParams_setX1,
    (char*)"x1 value",
    NULL},
   {(char*)"xmlns",
    (getter)_ExitParams_getXmlns, 0,
    (char*)"xmlns string",
    NULL},
   {(char*)"y1",
    (getter)_ExitParams_getY1, (setter)_ExitParams_setY1,
    (char*)"y1 value",
    NULL},
   {(char*)"z1",
    (getter)_ExitParams_getZ1, (setter)_ExitParams_setZ1,
    (char*)"z1 value",
    NULL},
   {NULL}  /* Sentinel */
};

static PyMemberDef _ExitParams_members[] = {
   {NULL}  /* Sentinel */
};

static PyMethodDef _ExitParams_methods[] = {
   {"toString", _ExitParams_toString, METH_NOARGS,
    "show element as a human-readable string"},
   {"toXML", _ExitParams_toXML, METH_NOARGS,
    "show element as a XML fragment"},
   {NULL}  /* Sentinel */
};

static PyTypeObject _ExitParams_type = {
    PyVarObject_HEAD_INIT(NULL,0)
    "hddm_r.ExitParams",         /*tp_name*/
    sizeof(_ExitParams),          /*tp_basicsize*/
    0,                         /*tp_itemsize*/
    (destructor)_ExitParams_dealloc, /*tp_dealloc*/
    0,                         /*tp_print*/
    0,                         /*tp_getattr*/
    0,                         /*tp_setattr*/
    0,                         /*tp_compare*/
    0,                         /*tp_repr*/
    0,                         /*tp_as_number*/
    0,                         /*tp_as_sequence*/
    0,                         /*tp_as_mapping*/
    0,                         /*tp_hash */
    0,                         /*tp_call*/
    (reprfunc)_ExitParams_toString,         /*tp_str*/
    0,                         /*tp_getattro*/
    0,                         /*tp_setattro*/
    0,                         /*tp_as_buffer*/
    Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE, /*tp_flags*/
    "hddm_r exitParams element",  /* tp_doc */
    0,                         /* tp_traverse */
    0,                         /* tp_clear */
    0,                         /* tp_richcompare */
    0,                         /* tp_weaklistoffset */
    0,                         /* tp_iter */
    0,                         /* tp_iternext */
    _ExitParams_methods,          /* tp_methods */
    _ExitParams_members,          /* tp_members */
    _ExitParams_getsetters,       /* tp_getset */
    &_HDDM_Element_type,       /* tp_base */
    0,                         /* tp_dict */
    0,                         /* tp_descr_get */
    0,                         /* tp_descr_set */
    0,                         /* tp_dictoffset */
    (initproc)_ExitParams_init,   /* tp_init */
    0,                         /* tp_alloc */
    _ExitParams_new,              /* tp_new */
};



// wrap element class hddm_r::ChargedTrack as hddm_r.ChargedTrack

typedef struct {
   PyObject_HEAD
   ChargedTrack *elem;
   PyObject *host;
} _ChargedTrack;

static void
_ChargedTrack_dealloc(_ChargedTrack* self)
{
   if (self->elem != 0) {
      LOG_DEALLOC(Py_TYPE(self), 0, self->host == (PyObject*)self);
      if (self->host == (PyObject*)self)
         delete self->elem;
      else
         My_DECREF(self->host);
   }
   Py_TYPE(self)->tp_free((PyObject*)self);
}

static PyObject*
_ChargedTrack_new(PyTypeObject *type, PyObject *args, PyObject *kwds)
{
   _ChargedTrack *self;
   self = (_ChargedTrack*)type->tp_alloc(type, 0);
   if (self != NULL) {
      self->elem = 0;
      self->host = 0;
   }
   return (PyObject*)self;
}

static int
_ChargedTrack_init(_ChargedTrack *self, PyObject *args, PyObject *kwds)
{
   PyErr_SetString(PyExc_RuntimeError, "illegal constructor");
   return -1;
}

static PyObject*
_ChargedTrack_getClass(_ChargedTrack *self, void *closure)
{
   std::string val(self->elem->getClass());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_ChargedTrack_getVersion(_ChargedTrack *self, void *closure)
{
   std::string val(self->elem->getVersion());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_ChargedTrack_getXmlns(_ChargedTrack *self, void *closure)
{
   std::string val(self->elem->getXmlns());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_ChargedTrack_getEventNo(_ChargedTrack *self, void *closure)
{
   return PyLong_FromLongLong(self->elem->getEventNo());
}

static PyObject*
_ChargedTrack_getRunNo(_ChargedTrack *self, void *closure)
{
   return PyLong_FromLong(self->elem->getRunNo());
}

static PyObject*
_ChargedTrack_getCandidateId(_ChargedTrack *self, void *closure)
{
   return PyLong_FromLong(self->elem->getCandidateId());
}

static int
_ChargedTrack_setCandidateId(_ChargedTrack *self, PyObject *value, void *closure)
{
   long var = PyInt_AsLong(value);
   if (var == -1 && PyErr_Occurred()) {
      return -1;
   }
   self->elem->setCandidateId(var);
   return 0;
}

static PyObject*
_ChargedTrack_getJtag(_ChargedTrack *self, void *closure)
{
   std::string val(self->elem->getJtag());
   return PyUnicode_FromString(val.c_str());
}

static int
_ChargedTrack_setJtag(_ChargedTrack *self, PyObject *value, void *closure)
{
   PyObject *str=0;
   if (PyUnicode_Check(value))
      str = PyUnicode_AsEncodedString(value, "ASCII", "strict");
   else
      str = value;
#if PY_MAJOR_VERSION < 3
   char *var = PyString_AsString(str);
#else
   char *var = PyBytes_AsString(str);
#endif
   if (var == 0) {
      return -1;
   }
   self->elem->setJtag(std::string(var));
   if (str != value) {
      Py_DECREF(str);
   }
   return 0;
}

static PyObject*
_ChargedTrack_getMaxOccurs(_ChargedTrack *self, void *closure)
{
   std::string val(self->elem->getMaxOccurs());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_ChargedTrack_getMinOccurs(_ChargedTrack *self, void *closure)
{
   return PyLong_FromLong(self->elem->getMinOccurs());
}

static PyObject*
_ChargedTrack_getPtype(_ChargedTrack *self, void *closure)
{
   Particle_t p(self->elem->getPtype());
   std::string val(ParticleType(p));
   return PyUnicode_FromString(val.c_str());
}

static int
_ChargedTrack_setPtype(_ChargedTrack *self, PyObject *value, void *closure)
{
   long var = PyInt_AsLong(value);
   if (var == -1 && PyErr_Occurred()) {
      return -1;
   }
   self->elem->setPtype((Particle_t)var);
   return 0;
}

static PyObject*
_ChargedTrack_getTrackFit(PyObject *self, PyObject *args)
{
   int index=0;
   if (! PyArg_ParseTuple(args, "|i", &index)) {
      return NULL;
   }
   _ChargedTrack *me = (_ChargedTrack*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid chargedTrack element");
      return NULL;
   }
   PyObject *obj = _TrackFit_new(&_TrackFit_type, 0, 0);
   ((_TrackFit*)obj)->elem = &me->elem->getTrackFit();
   ((_TrackFit*)obj)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(obj));
   return obj;
}

static PyObject*
_ChargedTrack_getTrackFits(PyObject *self, PyObject *args)
{
   _ChargedTrack *me = (_ChargedTrack*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid chargedTrack element");
      return NULL;
   }
   PyObject *list = _HDDM_ElementList_new(&_HDDM_ElementList_type, 0, 0);
   ((_HDDM_ElementList*)list)->subtype = &_TrackFit_type;
   ((_HDDM_ElementList*)list)->list = (HDDM_ElementList<HDDM_Element>*)
    &me->elem->getTrackFits();
   ((_HDDM_ElementList*)list)->borrowed = 1;
   ((_HDDM_ElementList*)list)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(list), ((_HDDM_ElementList*)list)->subtype, 0);
   return list;
}

static PyObject*
_ChargedTrack_addTrackFits(PyObject *self, PyObject *args)
{
   int count=1;
   int start=-1;
   if (! PyArg_ParseTuple(args, "|ii", &count, &start)) {
      return NULL;
   }
   _ChargedTrack *me = (_ChargedTrack*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "add attempted on invalid chargedTrack element");
      return NULL;
   }
   PyObject *list = _HDDM_ElementList_new(&_HDDM_ElementList_type, 0, 0);
   ((_HDDM_ElementList*)list)->subtype = &_TrackFit_type;
   ((_HDDM_ElementList*)list)->list = (HDDM_ElementList<HDDM_Element>*)
    new TrackFitList(me->elem->addTrackFits(count, start));
   ((_HDDM_ElementList*)list)->borrowed = 0;
   ((_HDDM_ElementList*)list)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(list), ((_HDDM_ElementList*)list)->subtype, 1);
   return list;
}

static PyObject*
_ChargedTrack_deleteTrackFits(PyObject *self, PyObject *args)
{
   int count=-1;
   int start=0;
   if (! PyArg_ParseTuple(args, "|ii", &count, &start)) {
      return NULL;
   }
   _ChargedTrack *me = (_ChargedTrack*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "delete attempted on invalid chargedTrack element");
      return NULL;
   }
   me->elem->deleteTrackFits(count, start);
   Py_INCREF(Py_None);
   return Py_None;
}

static PyObject*
_ChargedTrack_getTrackFlags(PyObject *self, PyObject *args)
{
   int index=0;
   if (! PyArg_ParseTuple(args, "|i", &index)) {
      return NULL;
   }
   _ChargedTrack *me = (_ChargedTrack*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid chargedTrack element");
      return NULL;
   }
   PyObject *obj = _TrackFlags_new(&_TrackFlags_type, 0, 0);
   ((_TrackFlags*)obj)->elem = &me->elem->getTrackFlags();
   ((_TrackFlags*)obj)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(obj));
   return obj;
}

static PyObject*
_ChargedTrack_getTrackFlagses(PyObject *self, PyObject *args)
{
   _ChargedTrack *me = (_ChargedTrack*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid chargedTrack element");
      return NULL;
   }
   PyObject *list = _HDDM_ElementList_new(&_HDDM_ElementList_type, 0, 0);
   ((_HDDM_ElementList*)list)->subtype = &_TrackFlags_type;
   ((_HDDM_ElementList*)list)->list = (HDDM_ElementList<HDDM_Element>*)
    &me->elem->getTrackFlagses();
   ((_HDDM_ElementList*)list)->borrowed = 1;
   ((_HDDM_ElementList*)list)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(list), ((_HDDM_ElementList*)list)->subtype, 0);
   return list;
}

static PyObject*
_ChargedTrack_addTrackFlagses(PyObject *self, PyObject *args)
{
   int count=1;
   int start=-1;
   if (! PyArg_ParseTuple(args, "|ii", &count, &start)) {
      return NULL;
   }
   _ChargedTrack *me = (_ChargedTrack*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "add attempted on invalid chargedTrack element");
      return NULL;
   }
   PyObject *list = _HDDM_ElementList_new(&_HDDM_ElementList_type, 0, 0);
   ((_HDDM_ElementList*)list)->subtype = &_TrackFlags_type;
   ((_HDDM_ElementList*)list)->list = (HDDM_ElementList<HDDM_Element>*)
    new TrackFlagsList(me->elem->addTrackFlagses(count, start));
   ((_HDDM_ElementList*)list)->borrowed = 0;
   ((_HDDM_ElementList*)list)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(list), ((_HDDM_ElementList*)list)->subtype, 1);
   return list;
}

static PyObject*
_ChargedTrack_deleteTrackFlagses(PyObject *self, PyObject *args)
{
   int count=-1;
   int start=0;
   if (! PyArg_ParseTuple(args, "|ii", &count, &start)) {
      return NULL;
   }
   _ChargedTrack *me = (_ChargedTrack*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "delete attempted on invalid chargedTrack element");
      return NULL;
   }
   me->elem->deleteTrackFlagses(count, start);
   Py_INCREF(Py_None);
   return Py_None;
}

static PyObject*
_ChargedTrack_getHitlayers(PyObject *self, PyObject *args)
{
   int index=0;
   if (! PyArg_ParseTuple(args, "|i", &index)) {
      return NULL;
   }
   _ChargedTrack *me = (_ChargedTrack*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid chargedTrack element");
      return NULL;
   }
   PyObject *obj = _Hitlayers_new(&_Hitlayers_type, 0, 0);
   ((_Hitlayers*)obj)->elem = &me->elem->getHitlayers();
   ((_Hitlayers*)obj)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(obj));
   return obj;
}

static PyObject*
_ChargedTrack_getHitlayerses(PyObject *self, PyObject *args)
{
   _ChargedTrack *me = (_ChargedTrack*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid chargedTrack element");
      return NULL;
   }
   PyObject *list = _HDDM_ElementList_new(&_HDDM_ElementList_type, 0, 0);
   ((_HDDM_ElementList*)list)->subtype = &_Hitlayers_type;
   ((_HDDM_ElementList*)list)->list = (HDDM_ElementList<HDDM_Element>*)
    &me->elem->getHitlayerses();
   ((_HDDM_ElementList*)list)->borrowed = 1;
   ((_HDDM_ElementList*)list)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(list), ((_HDDM_ElementList*)list)->subtype, 0);
   return list;
}

static PyObject*
_ChargedTrack_addHitlayerses(PyObject *self, PyObject *args)
{
   int count=1;
   int start=-1;
   if (! PyArg_ParseTuple(args, "|ii", &count, &start)) {
      return NULL;
   }
   _ChargedTrack *me = (_ChargedTrack*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "add attempted on invalid chargedTrack element");
      return NULL;
   }
   PyObject *list = _HDDM_ElementList_new(&_HDDM_ElementList_type, 0, 0);
   ((_HDDM_ElementList*)list)->subtype = &_Hitlayers_type;
   ((_HDDM_ElementList*)list)->list = (HDDM_ElementList<HDDM_Element>*)
    new HitlayersList(me->elem->addHitlayerses(count, start));
   ((_HDDM_ElementList*)list)->borrowed = 0;
   ((_HDDM_ElementList*)list)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(list), ((_HDDM_ElementList*)list)->subtype, 1);
   return list;
}

static PyObject*
_ChargedTrack_deleteHitlayerses(PyObject *self, PyObject *args)
{
   int count=-1;
   int start=0;
   if (! PyArg_ParseTuple(args, "|ii", &count, &start)) {
      return NULL;
   }
   _ChargedTrack *me = (_ChargedTrack*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "delete attempted on invalid chargedTrack element");
      return NULL;
   }
   me->elem->deleteHitlayerses(count, start);
   Py_INCREF(Py_None);
   return Py_None;
}

static PyObject*
_ChargedTrack_getExpectedhits(PyObject *self, PyObject *args)
{
   int index=0;
   if (! PyArg_ParseTuple(args, "|i", &index)) {
      return NULL;
   }
   _ChargedTrack *me = (_ChargedTrack*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid chargedTrack element");
      return NULL;
   }
   PyObject *obj = _Expectedhits_new(&_Expectedhits_type, 0, 0);
   ((_Expectedhits*)obj)->elem = &me->elem->getExpectedhits();
   ((_Expectedhits*)obj)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(obj));
   return obj;
}

static PyObject*
_ChargedTrack_getExpectedhitses(PyObject *self, PyObject *args)
{
   _ChargedTrack *me = (_ChargedTrack*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid chargedTrack element");
      return NULL;
   }
   PyObject *list = _HDDM_ElementList_new(&_HDDM_ElementList_type, 0, 0);
   ((_HDDM_ElementList*)list)->subtype = &_Expectedhits_type;
   ((_HDDM_ElementList*)list)->list = (HDDM_ElementList<HDDM_Element>*)
    &me->elem->getExpectedhitses();
   ((_HDDM_ElementList*)list)->borrowed = 1;
   ((_HDDM_ElementList*)list)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(list), ((_HDDM_ElementList*)list)->subtype, 0);
   return list;
}

static PyObject*
_ChargedTrack_addExpectedhitses(PyObject *self, PyObject *args)
{
   int count=1;
   int start=-1;
   if (! PyArg_ParseTuple(args, "|ii", &count, &start)) {
      return NULL;
   }
   _ChargedTrack *me = (_ChargedTrack*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "add attempted on invalid chargedTrack element");
      return NULL;
   }
   PyObject *list = _HDDM_ElementList_new(&_HDDM_ElementList_type, 0, 0);
   ((_HDDM_ElementList*)list)->subtype = &_Expectedhits_type;
   ((_HDDM_ElementList*)list)->list = (HDDM_ElementList<HDDM_Element>*)
    new ExpectedhitsList(me->elem->addExpectedhitses(count, start));
   ((_HDDM_ElementList*)list)->borrowed = 0;
   ((_HDDM_ElementList*)list)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(list), ((_HDDM_ElementList*)list)->subtype, 1);
   return list;
}

static PyObject*
_ChargedTrack_deleteExpectedhitses(PyObject *self, PyObject *args)
{
   int count=-1;
   int start=0;
   if (! PyArg_ParseTuple(args, "|ii", &count, &start)) {
      return NULL;
   }
   _ChargedTrack *me = (_ChargedTrack*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "delete attempted on invalid chargedTrack element");
      return NULL;
   }
   me->elem->deleteExpectedhitses(count, start);
   Py_INCREF(Py_None);
   return Py_None;
}

static PyObject*
_ChargedTrack_getMcmatch(PyObject *self, PyObject *args)
{
   int index=0;
   if (! PyArg_ParseTuple(args, "|i", &index)) {
      return NULL;
   }
   _ChargedTrack *me = (_ChargedTrack*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid chargedTrack element");
      return NULL;
   }
   PyObject *obj = _Mcmatch_new(&_Mcmatch_type, 0, 0);
   ((_Mcmatch*)obj)->elem = &me->elem->getMcmatch();
   ((_Mcmatch*)obj)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(obj));
   return obj;
}

static PyObject*
_ChargedTrack_getMcmatchs(PyObject *self, PyObject *args)
{
   _ChargedTrack *me = (_ChargedTrack*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid chargedTrack element");
      return NULL;
   }
   PyObject *list = _HDDM_ElementList_new(&_HDDM_ElementList_type, 0, 0);
   ((_HDDM_ElementList*)list)->subtype = &_Mcmatch_type;
   ((_HDDM_ElementList*)list)->list = (HDDM_ElementList<HDDM_Element>*)
    &me->elem->getMcmatchs();
   ((_HDDM_ElementList*)list)->borrowed = 1;
   ((_HDDM_ElementList*)list)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(list), ((_HDDM_ElementList*)list)->subtype, 0);
   return list;
}

static PyObject*
_ChargedTrack_addMcmatchs(PyObject *self, PyObject *args)
{
   int count=1;
   int start=-1;
   if (! PyArg_ParseTuple(args, "|ii", &count, &start)) {
      return NULL;
   }
   _ChargedTrack *me = (_ChargedTrack*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "add attempted on invalid chargedTrack element");
      return NULL;
   }
   PyObject *list = _HDDM_ElementList_new(&_HDDM_ElementList_type, 0, 0);
   ((_HDDM_ElementList*)list)->subtype = &_Mcmatch_type;
   ((_HDDM_ElementList*)list)->list = (HDDM_ElementList<HDDM_Element>*)
    new McmatchList(me->elem->addMcmatchs(count, start));
   ((_HDDM_ElementList*)list)->borrowed = 0;
   ((_HDDM_ElementList*)list)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(list), ((_HDDM_ElementList*)list)->subtype, 1);
   return list;
}

static PyObject*
_ChargedTrack_deleteMcmatchs(PyObject *self, PyObject *args)
{
   int count=-1;
   int start=0;
   if (! PyArg_ParseTuple(args, "|ii", &count, &start)) {
      return NULL;
   }
   _ChargedTrack *me = (_ChargedTrack*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "delete attempted on invalid chargedTrack element");
      return NULL;
   }
   me->elem->deleteMcmatchs(count, start);
   Py_INCREF(Py_None);
   return Py_None;
}

static PyObject*
_ChargedTrack_getDEdxDC(PyObject *self, PyObject *args)
{
   int index=0;
   if (! PyArg_ParseTuple(args, "|i", &index)) {
      return NULL;
   }
   _ChargedTrack *me = (_ChargedTrack*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid chargedTrack element");
      return NULL;
   }
   PyObject *obj = _DEdxDC_new(&_DEdxDC_type, 0, 0);
   ((_DEdxDC*)obj)->elem = &me->elem->getDEdxDC();
   ((_DEdxDC*)obj)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(obj));
   return obj;
}

static PyObject*
_ChargedTrack_getDEdxDCs(PyObject *self, PyObject *args)
{
   _ChargedTrack *me = (_ChargedTrack*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid chargedTrack element");
      return NULL;
   }
   PyObject *list = _HDDM_ElementList_new(&_HDDM_ElementList_type, 0, 0);
   ((_HDDM_ElementList*)list)->subtype = &_DEdxDC_type;
   ((_HDDM_ElementList*)list)->list = (HDDM_ElementList<HDDM_Element>*)
    &me->elem->getDEdxDCs();
   ((_HDDM_ElementList*)list)->borrowed = 1;
   ((_HDDM_ElementList*)list)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(list), ((_HDDM_ElementList*)list)->subtype, 0);
   return list;
}

static PyObject*
_ChargedTrack_addDEdxDCs(PyObject *self, PyObject *args)
{
   int count=1;
   int start=-1;
   if (! PyArg_ParseTuple(args, "|ii", &count, &start)) {
      return NULL;
   }
   _ChargedTrack *me = (_ChargedTrack*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "add attempted on invalid chargedTrack element");
      return NULL;
   }
   PyObject *list = _HDDM_ElementList_new(&_HDDM_ElementList_type, 0, 0);
   ((_HDDM_ElementList*)list)->subtype = &_DEdxDC_type;
   ((_HDDM_ElementList*)list)->list = (HDDM_ElementList<HDDM_Element>*)
    new DEdxDCList(me->elem->addDEdxDCs(count, start));
   ((_HDDM_ElementList*)list)->borrowed = 0;
   ((_HDDM_ElementList*)list)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(list), ((_HDDM_ElementList*)list)->subtype, 1);
   return list;
}

static PyObject*
_ChargedTrack_deleteDEdxDCs(PyObject *self, PyObject *args)
{
   int count=-1;
   int start=0;
   if (! PyArg_ParseTuple(args, "|ii", &count, &start)) {
      return NULL;
   }
   _ChargedTrack *me = (_ChargedTrack*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "delete attempted on invalid chargedTrack element");
      return NULL;
   }
   me->elem->deleteDEdxDCs(count, start);
   Py_INCREF(Py_None);
   return Py_None;
}

static PyObject*
_ChargedTrack_getExitParams(PyObject *self, PyObject *args)
{
   int index=0;
   if (! PyArg_ParseTuple(args, "|i", &index)) {
      return NULL;
   }
   _ChargedTrack *me = (_ChargedTrack*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid chargedTrack element");
      return NULL;
   }
   PyObject *obj = _ExitParams_new(&_ExitParams_type, 0, 0);
   ((_ExitParams*)obj)->elem = &me->elem->getExitParams();
   ((_ExitParams*)obj)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(obj));
   return obj;
}

static PyObject*
_ChargedTrack_getExitParamses(PyObject *self, PyObject *args)
{
   _ChargedTrack *me = (_ChargedTrack*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid chargedTrack element");
      return NULL;
   }
   PyObject *list = _HDDM_ElementList_new(&_HDDM_ElementList_type, 0, 0);
   ((_HDDM_ElementList*)list)->subtype = &_ExitParams_type;
   ((_HDDM_ElementList*)list)->list = (HDDM_ElementList<HDDM_Element>*)
    &me->elem->getExitParamses();
   ((_HDDM_ElementList*)list)->borrowed = 1;
   ((_HDDM_ElementList*)list)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(list), ((_HDDM_ElementList*)list)->subtype, 0);
   return list;
}

static PyObject*
_ChargedTrack_addExitParamses(PyObject *self, PyObject *args)
{
   int count=1;
   int start=-1;
   if (! PyArg_ParseTuple(args, "|ii", &count, &start)) {
      return NULL;
   }
   _ChargedTrack *me = (_ChargedTrack*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "add attempted on invalid chargedTrack element");
      return NULL;
   }
   PyObject *list = _HDDM_ElementList_new(&_HDDM_ElementList_type, 0, 0);
   ((_HDDM_ElementList*)list)->subtype = &_ExitParams_type;
   ((_HDDM_ElementList*)list)->list = (HDDM_ElementList<HDDM_Element>*)
    new ExitParamsList(me->elem->addExitParamses(count, start));
   ((_HDDM_ElementList*)list)->borrowed = 0;
   ((_HDDM_ElementList*)list)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(list), ((_HDDM_ElementList*)list)->subtype, 1);
   return list;
}

static PyObject*
_ChargedTrack_deleteExitParamses(PyObject *self, PyObject *args)
{
   int count=-1;
   int start=0;
   if (! PyArg_ParseTuple(args, "|ii", &count, &start)) {
      return NULL;
   }
   _ChargedTrack *me = (_ChargedTrack*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "delete attempted on invalid chargedTrack element");
      return NULL;
   }
   me->elem->deleteExitParamses(count, start);
   Py_INCREF(Py_None);
   return Py_None;
}

static PyObject*
_ChargedTrack_toString(PyObject *self, PyObject *args=0)
{
   _ChargedTrack *me = (_ChargedTrack*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid chargedTrack element");
      return NULL;
   }
   std::string str(me->elem->toString());
   return PyUnicode_FromString(str.c_str());
}

static PyObject*
_ChargedTrack_toXML(PyObject *self, PyObject *args=0)
{
   _ChargedTrack *me = (_ChargedTrack*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid chargedTrack element");
      return NULL;
   }
   std::string str(me->elem->toXML());
   return PyUnicode_FromString(str.c_str());
}

static PyGetSetDef _ChargedTrack_getsetters[] = {
   {(char*)"candidateId",
    (getter)_ChargedTrack_getCandidateId, (setter)_ChargedTrack_setCandidateId,
    (char*)"candidateId value",
    NULL},
   {(char*)"class",
    (getter)_ChargedTrack_getClass, 0,
    (char*)"class string",
    NULL},
   {(char*)"eventNo",
    (getter)_ChargedTrack_getEventNo, 0,
    (char*)"eventNo value",
    NULL},
   {(char*)"jtag",
    (getter)_ChargedTrack_getJtag, (setter)_ChargedTrack_setJtag,
    (char*)"jtag string",
    NULL},
   {(char*)"maxOccurs",
    (getter)_ChargedTrack_getMaxOccurs, 0,
    (char*)"maxOccurs value",
    NULL},
   {(char*)"minOccurs",
    (getter)_ChargedTrack_getMinOccurs, 0,
    (char*)"minOccurs value",
    NULL},
   {(char*)"ptype",
    (getter)_ChargedTrack_getPtype, (setter)_ChargedTrack_setPtype,
    (char*)"ptype value",
    NULL},
   {(char*)"runNo",
    (getter)_ChargedTrack_getRunNo, 0,
    (char*)"runNo value",
    NULL},
   {(char*)"version",
    (getter)_ChargedTrack_getVersion, 0,
    (char*)"version string",
    NULL},
   {(char*)"xmlns",
    (getter)_ChargedTrack_getXmlns, 0,
    (char*)"xmlns string",
    NULL},
   {NULL}  /* Sentinel */
};

static PyMemberDef _ChargedTrack_members[] = {
   {NULL}  /* Sentinel */
};

static PyMethodDef _ChargedTrack_methods[] = {
   {"addDEdxDCs", _ChargedTrack_addDEdxDCs, METH_VARARGS,
    "extend (or insert into) the list of dEdxDC objects for this chargedTrack"},
   {"addExitParamses", _ChargedTrack_addExitParamses, METH_VARARGS,
    "extend (or insert into) the list of exitParams objects for this chargedTrack"},
   {"addExpectedhitses", _ChargedTrack_addExpectedhitses, METH_VARARGS,
    "extend (or insert into) the list of expectedhits objects for this chargedTrack"},
   {"addHitlayerses", _ChargedTrack_addHitlayerses, METH_VARARGS,
    "extend (or insert into) the list of hitlayers objects for this chargedTrack"},
   {"addMcmatchs", _ChargedTrack_addMcmatchs, METH_VARARGS,
    "extend (or insert into) the list of mcmatch objects for this chargedTrack"},
   {"addTrackFits", _ChargedTrack_addTrackFits, METH_VARARGS,
    "extend (or insert into) the list of trackFit objects for this chargedTrack"},
   {"addTrackFlagses", _ChargedTrack_addTrackFlagses, METH_VARARGS,
    "extend (or insert into) the list of trackFlags objects for this chargedTrack"},
   {"deleteDEdxDCs", _ChargedTrack_deleteDEdxDCs, METH_VARARGS,
    "delete dEdxDC objects for this chargedTrack"},
   {"deleteExitParamses", _ChargedTrack_deleteExitParamses, METH_VARARGS,
    "delete exitParams objects for this chargedTrack"},
   {"deleteExpectedhitses", _ChargedTrack_deleteExpectedhitses, METH_VARARGS,
    "delete expectedhits objects for this chargedTrack"},
   {"deleteHitlayerses", _ChargedTrack_deleteHitlayerses, METH_VARARGS,
    "delete hitlayers objects for this chargedTrack"},
   {"deleteMcmatchs", _ChargedTrack_deleteMcmatchs, METH_VARARGS,
    "delete mcmatch objects for this chargedTrack"},
   {"deleteTrackFits", _ChargedTrack_deleteTrackFits, METH_VARARGS,
    "delete trackFit objects for this chargedTrack"},
   {"deleteTrackFlagses", _ChargedTrack_deleteTrackFlagses, METH_VARARGS,
    "delete trackFlags objects for this chargedTrack"},
   {"getDEdxDC", _ChargedTrack_getDEdxDC, METH_VARARGS,
    "get an individual dEdxDC object from this chargedTrack"},
   {"getDEdxDCs", _ChargedTrack_getDEdxDCs, METH_NOARGS,
    "get list of dEdxDC objects for this chargedTrack"},
   {"getExitParams", _ChargedTrack_getExitParams, METH_VARARGS,
    "get an individual exitParams object from this chargedTrack"},
   {"getExitParamses", _ChargedTrack_getExitParamses, METH_NOARGS,
    "get list of exitParams objects for this chargedTrack"},
   {"getExpectedhits", _ChargedTrack_getExpectedhits, METH_VARARGS,
    "get an individual expectedhits object from this chargedTrack"},
   {"getExpectedhitses", _ChargedTrack_getExpectedhitses, METH_NOARGS,
    "get list of expectedhits objects for this chargedTrack"},
   {"getHitlayers", _ChargedTrack_getHitlayers, METH_VARARGS,
    "get an individual hitlayers object from this chargedTrack"},
   {"getHitlayerses", _ChargedTrack_getHitlayerses, METH_NOARGS,
    "get list of hitlayers objects for this chargedTrack"},
   {"getMcmatch", _ChargedTrack_getMcmatch, METH_VARARGS,
    "get an individual mcmatch object from this chargedTrack"},
   {"getMcmatchs", _ChargedTrack_getMcmatchs, METH_NOARGS,
    "get list of mcmatch objects for this chargedTrack"},
   {"getTrackFit", _ChargedTrack_getTrackFit, METH_VARARGS,
    "get an individual trackFit object from this chargedTrack"},
   {"getTrackFits", _ChargedTrack_getTrackFits, METH_NOARGS,
    "get list of trackFit objects for this chargedTrack"},
   {"getTrackFlags", _ChargedTrack_getTrackFlags, METH_VARARGS,
    "get an individual trackFlags object from this chargedTrack"},
   {"getTrackFlagses", _ChargedTrack_getTrackFlagses, METH_NOARGS,
    "get list of trackFlags objects for this chargedTrack"},
   {"toString", _ChargedTrack_toString, METH_NOARGS,
    "show element as a human-readable string"},
   {"toXML", _ChargedTrack_toXML, METH_NOARGS,
    "show element as a XML fragment"},
   {NULL}  /* Sentinel */
};

static PyTypeObject _ChargedTrack_type = {
    PyVarObject_HEAD_INIT(NULL,0)
    "hddm_r.ChargedTrack",         /*tp_name*/
    sizeof(_ChargedTrack),          /*tp_basicsize*/
    0,                         /*tp_itemsize*/
    (destructor)_ChargedTrack_dealloc, /*tp_dealloc*/
    0,                         /*tp_print*/
    0,                         /*tp_getattr*/
    0,                         /*tp_setattr*/
    0,                         /*tp_compare*/
    0,                         /*tp_repr*/
    0,                         /*tp_as_number*/
    0,                         /*tp_as_sequence*/
    0,                         /*tp_as_mapping*/
    0,                         /*tp_hash */
    0,                         /*tp_call*/
    (reprfunc)_ChargedTrack_toString,         /*tp_str*/
    0,                         /*tp_getattro*/
    0,                         /*tp_setattro*/
    0,                         /*tp_as_buffer*/
    Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE, /*tp_flags*/
    "hddm_r chargedTrack element",  /* tp_doc */
    0,                         /* tp_traverse */
    0,                         /* tp_clear */
    0,                         /* tp_richcompare */
    0,                         /* tp_weaklistoffset */
    0,                         /* tp_iter */
    0,                         /* tp_iternext */
    _ChargedTrack_methods,          /* tp_methods */
    _ChargedTrack_members,          /* tp_members */
    _ChargedTrack_getsetters,       /* tp_getset */
    &_HDDM_Element_type,       /* tp_base */
    0,                         /* tp_dict */
    0,                         /* tp_descr_get */
    0,                         /* tp_descr_set */
    0,                         /* tp_dictoffset */
    (initproc)_ChargedTrack_init,   /* tp_init */
    0,                         /* tp_alloc */
    _ChargedTrack_new,              /* tp_new */
};



// wrap element class hddm_r::StartHit as hddm_r.StartHit

typedef struct {
   PyObject_HEAD
   StartHit *elem;
   PyObject *host;
} _StartHit;

static void
_StartHit_dealloc(_StartHit* self)
{
   if (self->elem != 0) {
      LOG_DEALLOC(Py_TYPE(self), 0, self->host == (PyObject*)self);
      if (self->host == (PyObject*)self)
         delete self->elem;
      else
         My_DECREF(self->host);
   }
   Py_TYPE(self)->tp_free((PyObject*)self);
}

static PyObject*
_StartHit_new(PyTypeObject *type, PyObject *args, PyObject *kwds)
{
   _StartHit *self;
   self = (_StartHit*)type->tp_alloc(type, 0);
   if (self != NULL) {
      self->elem = 0;
      self->host = 0;
   }
   return (PyObject*)self;
}

static int
_StartHit_init(_StartHit *self, PyObject *args, PyObject *kwds)
{
   PyErr_SetString(PyExc_RuntimeError, "illegal constructor");
   return -1;
}

static PyObject*
_StartHit_getClass(_StartHit *self, void *closure)
{
   std::string val(self->elem->getClass());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_StartHit_getVersion(_StartHit *self, void *closure)
{
   std::string val(self->elem->getVersion());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_StartHit_getXmlns(_StartHit *self, void *closure)
{
   std::string val(self->elem->getXmlns());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_StartHit_getEventNo(_StartHit *self, void *closure)
{
   return PyLong_FromLongLong(self->elem->getEventNo());
}

static PyObject*
_StartHit_getRunNo(_StartHit *self, void *closure)
{
   return PyLong_FromLong(self->elem->getRunNo());
}

static PyObject*
_StartHit_getEunit(_StartHit *self, void *closure)
{
   std::string val(self->elem->getEunit());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_StartHit_getDE(_StartHit *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getDE());
}

static int
_StartHit_setDE(_StartHit *self, PyObject *value, void *closure)
{
   double var = PyFloat_AsDouble(value);
   if (var == -1 && PyErr_Occurred()) {
      return 1;
   }
   self->elem->setDE((float)var);
   return 0;
}

static PyObject*
_StartHit_getJtag(_StartHit *self, void *closure)
{
   std::string val(self->elem->getJtag());
   return PyUnicode_FromString(val.c_str());
}

static int
_StartHit_setJtag(_StartHit *self, PyObject *value, void *closure)
{
   PyObject *str=0;
   if (PyUnicode_Check(value))
      str = PyUnicode_AsEncodedString(value, "ASCII", "strict");
   else
      str = value;
#if PY_MAJOR_VERSION < 3
   char *var = PyString_AsString(str);
#else
   char *var = PyBytes_AsString(str);
#endif
   if (var == 0) {
      return -1;
   }
   self->elem->setJtag(std::string(var));
   if (str != value) {
      Py_DECREF(str);
   }
   return 0;
}

static PyObject*
_StartHit_getMaxOccurs(_StartHit *self, void *closure)
{
   std::string val(self->elem->getMaxOccurs());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_StartHit_getMinOccurs(_StartHit *self, void *closure)
{
   return PyLong_FromLong(self->elem->getMinOccurs());
}

static PyObject*
_StartHit_getSector(_StartHit *self, void *closure)
{
   return PyLong_FromLong(self->elem->getSector());
}

static int
_StartHit_setSector(_StartHit *self, PyObject *value, void *closure)
{
   long var = PyInt_AsLong(value);
   if (var == -1 && PyErr_Occurred()) {
      return -1;
   }
   self->elem->setSector(var);
   return 0;
}

static PyObject*
_StartHit_getT(_StartHit *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getT());
}

static int
_StartHit_setT(_StartHit *self, PyObject *value, void *closure)
{
   double var = PyFloat_AsDouble(value);
   if (var == -1 && PyErr_Occurred()) {
      return 1;
   }
   self->elem->setT((float)var);
   return 0;
}

static PyObject*
_StartHit_getTunit(_StartHit *self, void *closure)
{
   std::string val(self->elem->getTunit());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_StartHit_toString(PyObject *self, PyObject *args=0)
{
   _StartHit *me = (_StartHit*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid startHit element");
      return NULL;
   }
   std::string str(me->elem->toString());
   return PyUnicode_FromString(str.c_str());
}

static PyObject*
_StartHit_toXML(PyObject *self, PyObject *args=0)
{
   _StartHit *me = (_StartHit*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid startHit element");
      return NULL;
   }
   std::string str(me->elem->toXML());
   return PyUnicode_FromString(str.c_str());
}

static PyGetSetDef _StartHit_getsetters[] = {
   {(char*)"Eunit",
    (getter)_StartHit_getEunit, 0,
    (char*)"Eunit value",
    NULL},
   {(char*)"class",
    (getter)_StartHit_getClass, 0,
    (char*)"class string",
    NULL},
   {(char*)"dE",
    (getter)_StartHit_getDE, (setter)_StartHit_setDE,
    (char*)"dE value",
    NULL},
   {(char*)"eventNo",
    (getter)_StartHit_getEventNo, 0,
    (char*)"eventNo value",
    NULL},
   {(char*)"jtag",
    (getter)_StartHit_getJtag, (setter)_StartHit_setJtag,
    (char*)"jtag string",
    NULL},
   {(char*)"maxOccurs",
    (getter)_StartHit_getMaxOccurs, 0,
    (char*)"maxOccurs value",
    NULL},
   {(char*)"minOccurs",
    (getter)_StartHit_getMinOccurs, 0,
    (char*)"minOccurs value",
    NULL},
   {(char*)"runNo",
    (getter)_StartHit_getRunNo, 0,
    (char*)"runNo value",
    NULL},
   {(char*)"sector",
    (getter)_StartHit_getSector, (setter)_StartHit_setSector,
    (char*)"sector value",
    NULL},
   {(char*)"t",
    (getter)_StartHit_getT, (setter)_StartHit_setT,
    (char*)"t value",
    NULL},
   {(char*)"tunit",
    (getter)_StartHit_getTunit, 0,
    (char*)"tunit value",
    NULL},
   {(char*)"version",
    (getter)_StartHit_getVersion, 0,
    (char*)"version string",
    NULL},
   {(char*)"xmlns",
    (getter)_StartHit_getXmlns, 0,
    (char*)"xmlns string",
    NULL},
   {NULL}  /* Sentinel */
};

static PyMemberDef _StartHit_members[] = {
   {NULL}  /* Sentinel */
};

static PyMethodDef _StartHit_methods[] = {
   {"toString", _StartHit_toString, METH_NOARGS,
    "show element as a human-readable string"},
   {"toXML", _StartHit_toXML, METH_NOARGS,
    "show element as a XML fragment"},
   {NULL}  /* Sentinel */
};

static PyTypeObject _StartHit_type = {
    PyVarObject_HEAD_INIT(NULL,0)
    "hddm_r.StartHit",         /*tp_name*/
    sizeof(_StartHit),          /*tp_basicsize*/
    0,                         /*tp_itemsize*/
    (destructor)_StartHit_dealloc, /*tp_dealloc*/
    0,                         /*tp_print*/
    0,                         /*tp_getattr*/
    0,                         /*tp_setattr*/
    0,                         /*tp_compare*/
    0,                         /*tp_repr*/
    0,                         /*tp_as_number*/
    0,                         /*tp_as_sequence*/
    0,                         /*tp_as_mapping*/
    0,                         /*tp_hash */
    0,                         /*tp_call*/
    (reprfunc)_StartHit_toString,         /*tp_str*/
    0,                         /*tp_getattro*/
    0,                         /*tp_setattro*/
    0,                         /*tp_as_buffer*/
    Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE, /*tp_flags*/
    "hddm_r startHit element",  /* tp_doc */
    0,                         /* tp_traverse */
    0,                         /* tp_clear */
    0,                         /* tp_richcompare */
    0,                         /* tp_weaklistoffset */
    0,                         /* tp_iter */
    0,                         /* tp_iternext */
    _StartHit_methods,          /* tp_methods */
    _StartHit_members,          /* tp_members */
    _StartHit_getsetters,       /* tp_getset */
    &_HDDM_Element_type,       /* tp_base */
    0,                         /* tp_dict */
    0,                         /* tp_descr_get */
    0,                         /* tp_descr_set */
    0,                         /* tp_dictoffset */
    (initproc)_StartHit_init,   /* tp_init */
    0,                         /* tp_alloc */
    _StartHit_new,              /* tp_new */
};



// wrap element class hddm_r::CtofPoint as hddm_r.CtofPoint

typedef struct {
   PyObject_HEAD
   CtofPoint *elem;
   PyObject *host;
} _CtofPoint;

static void
_CtofPoint_dealloc(_CtofPoint* self)
{
   if (self->elem != 0) {
      LOG_DEALLOC(Py_TYPE(self), 0, self->host == (PyObject*)self);
      if (self->host == (PyObject*)self)
         delete self->elem;
      else
         My_DECREF(self->host);
   }
   Py_TYPE(self)->tp_free((PyObject*)self);
}

static PyObject*
_CtofPoint_new(PyTypeObject *type, PyObject *args, PyObject *kwds)
{
   _CtofPoint *self;
   self = (_CtofPoint*)type->tp_alloc(type, 0);
   if (self != NULL) {
      self->elem = 0;
      self->host = 0;
   }
   return (PyObject*)self;
}

static int
_CtofPoint_init(_CtofPoint *self, PyObject *args, PyObject *kwds)
{
   PyErr_SetString(PyExc_RuntimeError, "illegal constructor");
   return -1;
}

static PyObject*
_CtofPoint_getClass(_CtofPoint *self, void *closure)
{
   std::string val(self->elem->getClass());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_CtofPoint_getVersion(_CtofPoint *self, void *closure)
{
   std::string val(self->elem->getVersion());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_CtofPoint_getXmlns(_CtofPoint *self, void *closure)
{
   std::string val(self->elem->getXmlns());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_CtofPoint_getEventNo(_CtofPoint *self, void *closure)
{
   return PyLong_FromLongLong(self->elem->getEventNo());
}

static PyObject*
_CtofPoint_getRunNo(_CtofPoint *self, void *closure)
{
   return PyLong_FromLong(self->elem->getRunNo());
}

static PyObject*
_CtofPoint_getEunit(_CtofPoint *self, void *closure)
{
   std::string val(self->elem->getEunit());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_CtofPoint_getBar(_CtofPoint *self, void *closure)
{
   return PyLong_FromLong(self->elem->getBar());
}

static int
_CtofPoint_setBar(_CtofPoint *self, PyObject *value, void *closure)
{
   long var = PyInt_AsLong(value);
   if (var == -1 && PyErr_Occurred()) {
      return -1;
   }
   self->elem->setBar(var);
   return 0;
}

static PyObject*
_CtofPoint_getDE(_CtofPoint *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getDE());
}

static int
_CtofPoint_setDE(_CtofPoint *self, PyObject *value, void *closure)
{
   double var = PyFloat_AsDouble(value);
   if (var == -1 && PyErr_Occurred()) {
      return 1;
   }
   self->elem->setDE((float)var);
   return 0;
}

static PyObject*
_CtofPoint_getJtag(_CtofPoint *self, void *closure)
{
   std::string val(self->elem->getJtag());
   return PyUnicode_FromString(val.c_str());
}

static int
_CtofPoint_setJtag(_CtofPoint *self, PyObject *value, void *closure)
{
   PyObject *str=0;
   if (PyUnicode_Check(value))
      str = PyUnicode_AsEncodedString(value, "ASCII", "strict");
   else
      str = value;
#if PY_MAJOR_VERSION < 3
   char *var = PyString_AsString(str);
#else
   char *var = PyBytes_AsString(str);
#endif
   if (var == 0) {
      return -1;
   }
   self->elem->setJtag(std::string(var));
   if (str != value) {
      Py_DECREF(str);
   }
   return 0;
}

static PyObject*
_CtofPoint_getLunit(_CtofPoint *self, void *closure)
{
   std::string val(self->elem->getLunit());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_CtofPoint_getMaxOccurs(_CtofPoint *self, void *closure)
{
   std::string val(self->elem->getMaxOccurs());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_CtofPoint_getMinOccurs(_CtofPoint *self, void *closure)
{
   return PyLong_FromLong(self->elem->getMinOccurs());
}

static PyObject*
_CtofPoint_getT(_CtofPoint *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getT());
}

static int
_CtofPoint_setT(_CtofPoint *self, PyObject *value, void *closure)
{
   double var = PyFloat_AsDouble(value);
   if (var == -1 && PyErr_Occurred()) {
      return 1;
   }
   self->elem->setT((float)var);
   return 0;
}

static PyObject*
_CtofPoint_getTunit(_CtofPoint *self, void *closure)
{
   std::string val(self->elem->getTunit());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_CtofPoint_getX(_CtofPoint *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getX());
}

static int
_CtofPoint_setX(_CtofPoint *self, PyObject *value, void *closure)
{
   double var = PyFloat_AsDouble(value);
   if (var == -1 && PyErr_Occurred()) {
      return 1;
   }
   self->elem->setX((float)var);
   return 0;
}

static PyObject*
_CtofPoint_getY(_CtofPoint *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getY());
}

static int
_CtofPoint_setY(_CtofPoint *self, PyObject *value, void *closure)
{
   double var = PyFloat_AsDouble(value);
   if (var == -1 && PyErr_Occurred()) {
      return 1;
   }
   self->elem->setY((float)var);
   return 0;
}

static PyObject*
_CtofPoint_getZ(_CtofPoint *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getZ());
}

static int
_CtofPoint_setZ(_CtofPoint *self, PyObject *value, void *closure)
{
   double var = PyFloat_AsDouble(value);
   if (var == -1 && PyErr_Occurred()) {
      return 1;
   }
   self->elem->setZ((float)var);
   return 0;
}

static PyObject*
_CtofPoint_toString(PyObject *self, PyObject *args=0)
{
   _CtofPoint *me = (_CtofPoint*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid ctofPoint element");
      return NULL;
   }
   std::string str(me->elem->toString());
   return PyUnicode_FromString(str.c_str());
}

static PyObject*
_CtofPoint_toXML(PyObject *self, PyObject *args=0)
{
   _CtofPoint *me = (_CtofPoint*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid ctofPoint element");
      return NULL;
   }
   std::string str(me->elem->toXML());
   return PyUnicode_FromString(str.c_str());
}

static PyGetSetDef _CtofPoint_getsetters[] = {
   {(char*)"Eunit",
    (getter)_CtofPoint_getEunit, 0,
    (char*)"Eunit value",
    NULL},
   {(char*)"bar",
    (getter)_CtofPoint_getBar, (setter)_CtofPoint_setBar,
    (char*)"bar value",
    NULL},
   {(char*)"class",
    (getter)_CtofPoint_getClass, 0,
    (char*)"class string",
    NULL},
   {(char*)"dE",
    (getter)_CtofPoint_getDE, (setter)_CtofPoint_setDE,
    (char*)"dE value",
    NULL},
   {(char*)"eventNo",
    (getter)_CtofPoint_getEventNo, 0,
    (char*)"eventNo value",
    NULL},
   {(char*)"jtag",
    (getter)_CtofPoint_getJtag, (setter)_CtofPoint_setJtag,
    (char*)"jtag string",
    NULL},
   {(char*)"lunit",
    (getter)_CtofPoint_getLunit, 0,
    (char*)"lunit value",
    NULL},
   {(char*)"maxOccurs",
    (getter)_CtofPoint_getMaxOccurs, 0,
    (char*)"maxOccurs value",
    NULL},
   {(char*)"minOccurs",
    (getter)_CtofPoint_getMinOccurs, 0,
    (char*)"minOccurs value",
    NULL},
   {(char*)"runNo",
    (getter)_CtofPoint_getRunNo, 0,
    (char*)"runNo value",
    NULL},
   {(char*)"t",
    (getter)_CtofPoint_getT, (setter)_CtofPoint_setT,
    (char*)"t value",
    NULL},
   {(char*)"tunit",
    (getter)_CtofPoint_getTunit, 0,
    (char*)"tunit value",
    NULL},
   {(char*)"version",
    (getter)_CtofPoint_getVersion, 0,
    (char*)"version string",
    NULL},
   {(char*)"x",
    (getter)_CtofPoint_getX, (setter)_CtofPoint_setX,
    (char*)"x value",
    NULL},
   {(char*)"xmlns",
    (getter)_CtofPoint_getXmlns, 0,
    (char*)"xmlns string",
    NULL},
   {(char*)"y",
    (getter)_CtofPoint_getY, (setter)_CtofPoint_setY,
    (char*)"y value",
    NULL},
   {(char*)"z",
    (getter)_CtofPoint_getZ, (setter)_CtofPoint_setZ,
    (char*)"z value",
    NULL},
   {NULL}  /* Sentinel */
};

static PyMemberDef _CtofPoint_members[] = {
   {NULL}  /* Sentinel */
};

static PyMethodDef _CtofPoint_methods[] = {
   {"toString", _CtofPoint_toString, METH_NOARGS,
    "show element as a human-readable string"},
   {"toXML", _CtofPoint_toXML, METH_NOARGS,
    "show element as a XML fragment"},
   {NULL}  /* Sentinel */
};

static PyTypeObject _CtofPoint_type = {
    PyVarObject_HEAD_INIT(NULL,0)
    "hddm_r.CtofPoint",         /*tp_name*/
    sizeof(_CtofPoint),          /*tp_basicsize*/
    0,                         /*tp_itemsize*/
    (destructor)_CtofPoint_dealloc, /*tp_dealloc*/
    0,                         /*tp_print*/
    0,                         /*tp_getattr*/
    0,                         /*tp_setattr*/
    0,                         /*tp_compare*/
    0,                         /*tp_repr*/
    0,                         /*tp_as_number*/
    0,                         /*tp_as_sequence*/
    0,                         /*tp_as_mapping*/
    0,                         /*tp_hash */
    0,                         /*tp_call*/
    (reprfunc)_CtofPoint_toString,         /*tp_str*/
    0,                         /*tp_getattro*/
    0,                         /*tp_setattro*/
    0,                         /*tp_as_buffer*/
    Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE, /*tp_flags*/
    "hddm_r ctofPoint element",  /* tp_doc */
    0,                         /* tp_traverse */
    0,                         /* tp_clear */
    0,                         /* tp_richcompare */
    0,                         /* tp_weaklistoffset */
    0,                         /* tp_iter */
    0,                         /* tp_iternext */
    _CtofPoint_methods,          /* tp_methods */
    _CtofPoint_members,          /* tp_members */
    _CtofPoint_getsetters,       /* tp_getset */
    &_HDDM_Element_type,       /* tp_base */
    0,                         /* tp_dict */
    0,                         /* tp_descr_get */
    0,                         /* tp_descr_set */
    0,                         /* tp_dictoffset */
    (initproc)_CtofPoint_init,   /* tp_init */
    0,                         /* tp_alloc */
    _CtofPoint_new,              /* tp_new */
};



// wrap element class hddm_r::TofStatus as hddm_r.TofStatus

typedef struct {
   PyObject_HEAD
   TofStatus *elem;
   PyObject *host;
} _TofStatus;

static void
_TofStatus_dealloc(_TofStatus* self)
{
   if (self->elem != 0) {
      LOG_DEALLOC(Py_TYPE(self), 0, self->host == (PyObject*)self);
      if (self->host == (PyObject*)self)
         delete self->elem;
      else
         My_DECREF(self->host);
   }
   Py_TYPE(self)->tp_free((PyObject*)self);
}

static PyObject*
_TofStatus_new(PyTypeObject *type, PyObject *args, PyObject *kwds)
{
   _TofStatus *self;
   self = (_TofStatus*)type->tp_alloc(type, 0);
   if (self != NULL) {
      self->elem = 0;
      self->host = 0;
   }
   return (PyObject*)self;
}

static int
_TofStatus_init(_TofStatus *self, PyObject *args, PyObject *kwds)
{
   PyErr_SetString(PyExc_RuntimeError, "illegal constructor");
   return -1;
}

static PyObject*
_TofStatus_getClass(_TofStatus *self, void *closure)
{
   std::string val(self->elem->getClass());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_TofStatus_getVersion(_TofStatus *self, void *closure)
{
   std::string val(self->elem->getVersion());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_TofStatus_getXmlns(_TofStatus *self, void *closure)
{
   std::string val(self->elem->getXmlns());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_TofStatus_getEventNo(_TofStatus *self, void *closure)
{
   return PyLong_FromLongLong(self->elem->getEventNo());
}

static PyObject*
_TofStatus_getRunNo(_TofStatus *self, void *closure)
{
   return PyLong_FromLong(self->elem->getRunNo());
}

static PyObject*
_TofStatus_getEunit(_TofStatus *self, void *closure)
{
   std::string val(self->elem->getEunit());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_TofStatus_getDE(_TofStatus *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getDE());
}

static PyObject*
_TofStatus_getJtag(_TofStatus *self, void *closure)
{
   std::string val(self->elem->getJtag());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_TofStatus_getLunit(_TofStatus *self, void *closure)
{
   std::string val(self->elem->getLunit());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_TofStatus_getT(_TofStatus *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getT());
}

static PyObject*
_TofStatus_getTerr(_TofStatus *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getTerr());
}

static PyObject*
_TofStatus_getTunit(_TofStatus *self, void *closure)
{
   std::string val(self->elem->getTunit());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_TofStatus_getX(_TofStatus *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getX());
}

static PyObject*
_TofStatus_getY(_TofStatus *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getY());
}

static PyObject*
_TofStatus_getZ(_TofStatus *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getZ());
}

static PyObject*
_TofStatus_getMaxOccurs(_TofStatus *self, void *closure)
{
   return PyLong_FromLong(self->elem->getMaxOccurs());
}

static PyObject*
_TofStatus_getMinOccurs(_TofStatus *self, void *closure)
{
   return PyLong_FromLong(self->elem->getMinOccurs());
}

static PyObject*
_TofStatus_getStatus(_TofStatus *self, void *closure)
{
   return PyLong_FromLong(self->elem->getStatus());
}

static int
_TofStatus_setStatus(_TofStatus *self, PyObject *value, void *closure)
{
   long var = PyInt_AsLong(value);
   if (var == -1 && PyErr_Occurred()) {
      return -1;
   }
   self->elem->setStatus(var);
   return 0;
}

static PyObject*
_TofStatus_toString(PyObject *self, PyObject *args=0)
{
   _TofStatus *me = (_TofStatus*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid tofStatus element");
      return NULL;
   }
   std::string str(me->elem->toString());
   return PyUnicode_FromString(str.c_str());
}

static PyObject*
_TofStatus_toXML(PyObject *self, PyObject *args=0)
{
   _TofStatus *me = (_TofStatus*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid tofStatus element");
      return NULL;
   }
   std::string str(me->elem->toXML());
   return PyUnicode_FromString(str.c_str());
}

static PyGetSetDef _TofStatus_getsetters[] = {
   {(char*)"Eunit",
    (getter)_TofStatus_getEunit, 0,
    (char*)"Eunit string",
    NULL},
   {(char*)"class",
    (getter)_TofStatus_getClass, 0,
    (char*)"class string",
    NULL},
   {(char*)"dE",
    (getter)_TofStatus_getDE, 0,
    (char*)"dE value",
    NULL},
   {(char*)"eventNo",
    (getter)_TofStatus_getEventNo, 0,
    (char*)"eventNo value",
    NULL},
   {(char*)"jtag",
    (getter)_TofStatus_getJtag, 0,
    (char*)"jtag string",
    NULL},
   {(char*)"lunit",
    (getter)_TofStatus_getLunit, 0,
    (char*)"lunit string",
    NULL},
   {(char*)"maxOccurs",
    (getter)_TofStatus_getMaxOccurs, 0,
    (char*)"maxOccurs value",
    NULL},
   {(char*)"minOccurs",
    (getter)_TofStatus_getMinOccurs, 0,
    (char*)"minOccurs value",
    NULL},
   {(char*)"runNo",
    (getter)_TofStatus_getRunNo, 0,
    (char*)"runNo value",
    NULL},
   {(char*)"status",
    (getter)_TofStatus_getStatus, (setter)_TofStatus_setStatus,
    (char*)"status value",
    NULL},
   {(char*)"t",
    (getter)_TofStatus_getT, 0,
    (char*)"t value",
    NULL},
   {(char*)"terr",
    (getter)_TofStatus_getTerr, 0,
    (char*)"terr value",
    NULL},
   {(char*)"tunit",
    (getter)_TofStatus_getTunit, 0,
    (char*)"tunit string",
    NULL},
   {(char*)"version",
    (getter)_TofStatus_getVersion, 0,
    (char*)"version string",
    NULL},
   {(char*)"x",
    (getter)_TofStatus_getX, 0,
    (char*)"x value",
    NULL},
   {(char*)"xmlns",
    (getter)_TofStatus_getXmlns, 0,
    (char*)"xmlns string",
    NULL},
   {(char*)"y",
    (getter)_TofStatus_getY, 0,
    (char*)"y value",
    NULL},
   {(char*)"z",
    (getter)_TofStatus_getZ, 0,
    (char*)"z value",
    NULL},
   {NULL}  /* Sentinel */
};

static PyMemberDef _TofStatus_members[] = {
   {NULL}  /* Sentinel */
};

static PyMethodDef _TofStatus_methods[] = {
   {"toString", _TofStatus_toString, METH_NOARGS,
    "show element as a human-readable string"},
   {"toXML", _TofStatus_toXML, METH_NOARGS,
    "show element as a XML fragment"},
   {NULL}  /* Sentinel */
};

static PyTypeObject _TofStatus_type = {
    PyVarObject_HEAD_INIT(NULL,0)
    "hddm_r.TofStatus",         /*tp_name*/
    sizeof(_TofStatus),          /*tp_basicsize*/
    0,                         /*tp_itemsize*/
    (destructor)_TofStatus_dealloc, /*tp_dealloc*/
    0,                         /*tp_print*/
    0,                         /*tp_getattr*/
    0,                         /*tp_setattr*/
    0,                         /*tp_compare*/
    0,                         /*tp_repr*/
    0,                         /*tp_as_number*/
    0,                         /*tp_as_sequence*/
    0,                         /*tp_as_mapping*/
    0,                         /*tp_hash */
    0,                         /*tp_call*/
    (reprfunc)_TofStatus_toString,         /*tp_str*/
    0,                         /*tp_getattro*/
    0,                         /*tp_setattro*/
    0,                         /*tp_as_buffer*/
    Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE, /*tp_flags*/
    "hddm_r tofStatus element",  /* tp_doc */
    0,                         /* tp_traverse */
    0,                         /* tp_clear */
    0,                         /* tp_richcompare */
    0,                         /* tp_weaklistoffset */
    0,                         /* tp_iter */
    0,                         /* tp_iternext */
    _TofStatus_methods,          /* tp_methods */
    _TofStatus_members,          /* tp_members */
    _TofStatus_getsetters,       /* tp_getset */
    &_HDDM_Element_type,       /* tp_base */
    0,                         /* tp_dict */
    0,                         /* tp_descr_get */
    0,                         /* tp_descr_set */
    0,                         /* tp_dictoffset */
    (initproc)_TofStatus_init,   /* tp_init */
    0,                         /* tp_alloc */
    _TofStatus_new,              /* tp_new */
};



// wrap element class hddm_r::TofEnergyDeposition as hddm_r.TofEnergyDeposition

typedef struct {
   PyObject_HEAD
   TofEnergyDeposition *elem;
   PyObject *host;
} _TofEnergyDeposition;

static void
_TofEnergyDeposition_dealloc(_TofEnergyDeposition* self)
{
   if (self->elem != 0) {
      LOG_DEALLOC(Py_TYPE(self), 0, self->host == (PyObject*)self);
      if (self->host == (PyObject*)self)
         delete self->elem;
      else
         My_DECREF(self->host);
   }
   Py_TYPE(self)->tp_free((PyObject*)self);
}

static PyObject*
_TofEnergyDeposition_new(PyTypeObject *type, PyObject *args, PyObject *kwds)
{
   _TofEnergyDeposition *self;
   self = (_TofEnergyDeposition*)type->tp_alloc(type, 0);
   if (self != NULL) {
      self->elem = 0;
      self->host = 0;
   }
   return (PyObject*)self;
}

static int
_TofEnergyDeposition_init(_TofEnergyDeposition *self, PyObject *args, PyObject *kwds)
{
   PyErr_SetString(PyExc_RuntimeError, "illegal constructor");
   return -1;
}

static PyObject*
_TofEnergyDeposition_getClass(_TofEnergyDeposition *self, void *closure)
{
   std::string val(self->elem->getClass());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_TofEnergyDeposition_getVersion(_TofEnergyDeposition *self, void *closure)
{
   std::string val(self->elem->getVersion());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_TofEnergyDeposition_getXmlns(_TofEnergyDeposition *self, void *closure)
{
   std::string val(self->elem->getXmlns());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_TofEnergyDeposition_getEventNo(_TofEnergyDeposition *self, void *closure)
{
   return PyLong_FromLongLong(self->elem->getEventNo());
}

static PyObject*
_TofEnergyDeposition_getRunNo(_TofEnergyDeposition *self, void *closure)
{
   return PyLong_FromLong(self->elem->getRunNo());
}

static PyObject*
_TofEnergyDeposition_getEunit(_TofEnergyDeposition *self, void *closure)
{
   std::string val(self->elem->getEunit());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_TofEnergyDeposition_getDE(_TofEnergyDeposition *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getDE());
}

static PyObject*
_TofEnergyDeposition_getJtag(_TofEnergyDeposition *self, void *closure)
{
   std::string val(self->elem->getJtag());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_TofEnergyDeposition_getLunit(_TofEnergyDeposition *self, void *closure)
{
   std::string val(self->elem->getLunit());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_TofEnergyDeposition_getT(_TofEnergyDeposition *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getT());
}

static PyObject*
_TofEnergyDeposition_getTerr(_TofEnergyDeposition *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getTerr());
}

static PyObject*
_TofEnergyDeposition_getTunit(_TofEnergyDeposition *self, void *closure)
{
   std::string val(self->elem->getTunit());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_TofEnergyDeposition_getX(_TofEnergyDeposition *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getX());
}

static PyObject*
_TofEnergyDeposition_getY(_TofEnergyDeposition *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getY());
}

static PyObject*
_TofEnergyDeposition_getZ(_TofEnergyDeposition *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getZ());
}

static PyObject*
_TofEnergyDeposition_getDE1(_TofEnergyDeposition *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getDE1());
}

static int
_TofEnergyDeposition_setDE1(_TofEnergyDeposition *self, PyObject *value, void *closure)
{
   double var = PyFloat_AsDouble(value);
   if (var == -1 && PyErr_Occurred()) {
      return 1;
   }
   self->elem->setDE1((float)var);
   return 0;
}

static PyObject*
_TofEnergyDeposition_getDE2(_TofEnergyDeposition *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getDE2());
}

static int
_TofEnergyDeposition_setDE2(_TofEnergyDeposition *self, PyObject *value, void *closure)
{
   double var = PyFloat_AsDouble(value);
   if (var == -1 && PyErr_Occurred()) {
      return 1;
   }
   self->elem->setDE2((float)var);
   return 0;
}

static PyObject*
_TofEnergyDeposition_getMaxOccurs(_TofEnergyDeposition *self, void *closure)
{
   return PyLong_FromLong(self->elem->getMaxOccurs());
}

static PyObject*
_TofEnergyDeposition_getMinOccurs(_TofEnergyDeposition *self, void *closure)
{
   return PyLong_FromLong(self->elem->getMinOccurs());
}

static PyObject*
_TofEnergyDeposition_toString(PyObject *self, PyObject *args=0)
{
   _TofEnergyDeposition *me = (_TofEnergyDeposition*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid tofEnergyDeposition element");
      return NULL;
   }
   std::string str(me->elem->toString());
   return PyUnicode_FromString(str.c_str());
}

static PyObject*
_TofEnergyDeposition_toXML(PyObject *self, PyObject *args=0)
{
   _TofEnergyDeposition *me = (_TofEnergyDeposition*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid tofEnergyDeposition element");
      return NULL;
   }
   std::string str(me->elem->toXML());
   return PyUnicode_FromString(str.c_str());
}

static PyGetSetDef _TofEnergyDeposition_getsetters[] = {
   {(char*)"Eunit",
    (getter)_TofEnergyDeposition_getEunit, 0,
    (char*)"Eunit string",
    NULL},
   {(char*)"class",
    (getter)_TofEnergyDeposition_getClass, 0,
    (char*)"class string",
    NULL},
   {(char*)"dE",
    (getter)_TofEnergyDeposition_getDE, 0,
    (char*)"dE value",
    NULL},
   {(char*)"dE1",
    (getter)_TofEnergyDeposition_getDE1, (setter)_TofEnergyDeposition_setDE1,
    (char*)"dE1 value",
    NULL},
   {(char*)"dE2",
    (getter)_TofEnergyDeposition_getDE2, (setter)_TofEnergyDeposition_setDE2,
    (char*)"dE2 value",
    NULL},
   {(char*)"eventNo",
    (getter)_TofEnergyDeposition_getEventNo, 0,
    (char*)"eventNo value",
    NULL},
   {(char*)"jtag",
    (getter)_TofEnergyDeposition_getJtag, 0,
    (char*)"jtag string",
    NULL},
   {(char*)"lunit",
    (getter)_TofEnergyDeposition_getLunit, 0,
    (char*)"lunit string",
    NULL},
   {(char*)"maxOccurs",
    (getter)_TofEnergyDeposition_getMaxOccurs, 0,
    (char*)"maxOccurs value",
    NULL},
   {(char*)"minOccurs",
    (getter)_TofEnergyDeposition_getMinOccurs, 0,
    (char*)"minOccurs value",
    NULL},
   {(char*)"runNo",
    (getter)_TofEnergyDeposition_getRunNo, 0,
    (char*)"runNo value",
    NULL},
   {(char*)"t",
    (getter)_TofEnergyDeposition_getT, 0,
    (char*)"t value",
    NULL},
   {(char*)"terr",
    (getter)_TofEnergyDeposition_getTerr, 0,
    (char*)"terr value",
    NULL},
   {(char*)"tunit",
    (getter)_TofEnergyDeposition_getTunit, 0,
    (char*)"tunit string",
    NULL},
   {(char*)"version",
    (getter)_TofEnergyDeposition_getVersion, 0,
    (char*)"version string",
    NULL},
   {(char*)"x",
    (getter)_TofEnergyDeposition_getX, 0,
    (char*)"x value",
    NULL},
   {(char*)"xmlns",
    (getter)_TofEnergyDeposition_getXmlns, 0,
    (char*)"xmlns string",
    NULL},
   {(char*)"y",
    (getter)_TofEnergyDeposition_getY, 0,
    (char*)"y value",
    NULL},
   {(char*)"z",
    (getter)_TofEnergyDeposition_getZ, 0,
    (char*)"z value",
    NULL},
   {NULL}  /* Sentinel */
};

static PyMemberDef _TofEnergyDeposition_members[] = {
   {NULL}  /* Sentinel */
};

static PyMethodDef _TofEnergyDeposition_methods[] = {
   {"toString", _TofEnergyDeposition_toString, METH_NOARGS,
    "show element as a human-readable string"},
   {"toXML", _TofEnergyDeposition_toXML, METH_NOARGS,
    "show element as a XML fragment"},
   {NULL}  /* Sentinel */
};

static PyTypeObject _TofEnergyDeposition_type = {
    PyVarObject_HEAD_INIT(NULL,0)
    "hddm_r.TofEnergyDeposition",         /*tp_name*/
    sizeof(_TofEnergyDeposition),          /*tp_basicsize*/
    0,                         /*tp_itemsize*/
    (destructor)_TofEnergyDeposition_dealloc, /*tp_dealloc*/
    0,                         /*tp_print*/
    0,                         /*tp_getattr*/
    0,                         /*tp_setattr*/
    0,                         /*tp_compare*/
    0,                         /*tp_repr*/
    0,                         /*tp_as_number*/
    0,                         /*tp_as_sequence*/
    0,                         /*tp_as_mapping*/
    0,                         /*tp_hash */
    0,                         /*tp_call*/
    (reprfunc)_TofEnergyDeposition_toString,         /*tp_str*/
    0,                         /*tp_getattro*/
    0,                         /*tp_setattro*/
    0,                         /*tp_as_buffer*/
    Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE, /*tp_flags*/
    "hddm_r tofEnergyDeposition element",  /* tp_doc */
    0,                         /* tp_traverse */
    0,                         /* tp_clear */
    0,                         /* tp_richcompare */
    0,                         /* tp_weaklistoffset */
    0,                         /* tp_iter */
    0,                         /* tp_iternext */
    _TofEnergyDeposition_methods,          /* tp_methods */
    _TofEnergyDeposition_members,          /* tp_members */
    _TofEnergyDeposition_getsetters,       /* tp_getset */
    &_HDDM_Element_type,       /* tp_base */
    0,                         /* tp_dict */
    0,                         /* tp_descr_get */
    0,                         /* tp_descr_set */
    0,                         /* tp_dictoffset */
    (initproc)_TofEnergyDeposition_init,   /* tp_init */
    0,                         /* tp_alloc */
    _TofEnergyDeposition_new,              /* tp_new */
};



// wrap element class hddm_r::TofPoint as hddm_r.TofPoint

typedef struct {
   PyObject_HEAD
   TofPoint *elem;
   PyObject *host;
} _TofPoint;

static void
_TofPoint_dealloc(_TofPoint* self)
{
   if (self->elem != 0) {
      LOG_DEALLOC(Py_TYPE(self), 0, self->host == (PyObject*)self);
      if (self->host == (PyObject*)self)
         delete self->elem;
      else
         My_DECREF(self->host);
   }
   Py_TYPE(self)->tp_free((PyObject*)self);
}

static PyObject*
_TofPoint_new(PyTypeObject *type, PyObject *args, PyObject *kwds)
{
   _TofPoint *self;
   self = (_TofPoint*)type->tp_alloc(type, 0);
   if (self != NULL) {
      self->elem = 0;
      self->host = 0;
   }
   return (PyObject*)self;
}

static int
_TofPoint_init(_TofPoint *self, PyObject *args, PyObject *kwds)
{
   PyErr_SetString(PyExc_RuntimeError, "illegal constructor");
   return -1;
}

static PyObject*
_TofPoint_getClass(_TofPoint *self, void *closure)
{
   std::string val(self->elem->getClass());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_TofPoint_getVersion(_TofPoint *self, void *closure)
{
   std::string val(self->elem->getVersion());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_TofPoint_getXmlns(_TofPoint *self, void *closure)
{
   std::string val(self->elem->getXmlns());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_TofPoint_getEventNo(_TofPoint *self, void *closure)
{
   return PyLong_FromLongLong(self->elem->getEventNo());
}

static PyObject*
_TofPoint_getRunNo(_TofPoint *self, void *closure)
{
   return PyLong_FromLong(self->elem->getRunNo());
}

static PyObject*
_TofPoint_getEunit(_TofPoint *self, void *closure)
{
   std::string val(self->elem->getEunit());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_TofPoint_getDE(_TofPoint *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getDE());
}

static int
_TofPoint_setDE(_TofPoint *self, PyObject *value, void *closure)
{
   double var = PyFloat_AsDouble(value);
   if (var == -1 && PyErr_Occurred()) {
      return 1;
   }
   self->elem->setDE((float)var);
   return 0;
}

static PyObject*
_TofPoint_getJtag(_TofPoint *self, void *closure)
{
   std::string val(self->elem->getJtag());
   return PyUnicode_FromString(val.c_str());
}

static int
_TofPoint_setJtag(_TofPoint *self, PyObject *value, void *closure)
{
   PyObject *str=0;
   if (PyUnicode_Check(value))
      str = PyUnicode_AsEncodedString(value, "ASCII", "strict");
   else
      str = value;
#if PY_MAJOR_VERSION < 3
   char *var = PyString_AsString(str);
#else
   char *var = PyBytes_AsString(str);
#endif
   if (var == 0) {
      return -1;
   }
   self->elem->setJtag(std::string(var));
   if (str != value) {
      Py_DECREF(str);
   }
   return 0;
}

static PyObject*
_TofPoint_getLunit(_TofPoint *self, void *closure)
{
   std::string val(self->elem->getLunit());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_TofPoint_getMaxOccurs(_TofPoint *self, void *closure)
{
   std::string val(self->elem->getMaxOccurs());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_TofPoint_getMinOccurs(_TofPoint *self, void *closure)
{
   return PyLong_FromLong(self->elem->getMinOccurs());
}

static PyObject*
_TofPoint_getT(_TofPoint *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getT());
}

static int
_TofPoint_setT(_TofPoint *self, PyObject *value, void *closure)
{
   double var = PyFloat_AsDouble(value);
   if (var == -1 && PyErr_Occurred()) {
      return 1;
   }
   self->elem->setT((float)var);
   return 0;
}

static PyObject*
_TofPoint_getTerr(_TofPoint *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getTerr());
}

static int
_TofPoint_setTerr(_TofPoint *self, PyObject *value, void *closure)
{
   double var = PyFloat_AsDouble(value);
   if (var == -1 && PyErr_Occurred()) {
      return 1;
   }
   self->elem->setTerr((float)var);
   return 0;
}

static PyObject*
_TofPoint_getTunit(_TofPoint *self, void *closure)
{
   std::string val(self->elem->getTunit());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_TofPoint_getX(_TofPoint *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getX());
}

static int
_TofPoint_setX(_TofPoint *self, PyObject *value, void *closure)
{
   double var = PyFloat_AsDouble(value);
   if (var == -1 && PyErr_Occurred()) {
      return 1;
   }
   self->elem->setX((float)var);
   return 0;
}

static PyObject*
_TofPoint_getY(_TofPoint *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getY());
}

static int
_TofPoint_setY(_TofPoint *self, PyObject *value, void *closure)
{
   double var = PyFloat_AsDouble(value);
   if (var == -1 && PyErr_Occurred()) {
      return 1;
   }
   self->elem->setY((float)var);
   return 0;
}

static PyObject*
_TofPoint_getZ(_TofPoint *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getZ());
}

static int
_TofPoint_setZ(_TofPoint *self, PyObject *value, void *closure)
{
   double var = PyFloat_AsDouble(value);
   if (var == -1 && PyErr_Occurred()) {
      return 1;
   }
   self->elem->setZ((float)var);
   return 0;
}

static PyObject*
_TofPoint_getTofStatus(PyObject *self, PyObject *args)
{
   int index=0;
   if (! PyArg_ParseTuple(args, "|i", &index)) {
      return NULL;
   }
   _TofPoint *me = (_TofPoint*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid tofPoint element");
      return NULL;
   }
   PyObject *obj = _TofStatus_new(&_TofStatus_type, 0, 0);
   ((_TofStatus*)obj)->elem = &me->elem->getTofStatus();
   ((_TofStatus*)obj)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(obj));
   return obj;
}

static PyObject*
_TofPoint_getTofStatuses(PyObject *self, PyObject *args)
{
   _TofPoint *me = (_TofPoint*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid tofPoint element");
      return NULL;
   }
   PyObject *list = _HDDM_ElementList_new(&_HDDM_ElementList_type, 0, 0);
   ((_HDDM_ElementList*)list)->subtype = &_TofStatus_type;
   ((_HDDM_ElementList*)list)->list = (HDDM_ElementList<HDDM_Element>*)
    &me->elem->getTofStatuses();
   ((_HDDM_ElementList*)list)->borrowed = 1;
   ((_HDDM_ElementList*)list)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(list), ((_HDDM_ElementList*)list)->subtype, 0);
   return list;
}

static PyObject*
_TofPoint_addTofStatuses(PyObject *self, PyObject *args)
{
   int count=1;
   int start=-1;
   if (! PyArg_ParseTuple(args, "|ii", &count, &start)) {
      return NULL;
   }
   _TofPoint *me = (_TofPoint*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "add attempted on invalid tofPoint element");
      return NULL;
   }
   PyObject *list = _HDDM_ElementList_new(&_HDDM_ElementList_type, 0, 0);
   ((_HDDM_ElementList*)list)->subtype = &_TofStatus_type;
   ((_HDDM_ElementList*)list)->list = (HDDM_ElementList<HDDM_Element>*)
    new TofStatusList(me->elem->addTofStatuses(count, start));
   ((_HDDM_ElementList*)list)->borrowed = 0;
   ((_HDDM_ElementList*)list)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(list), ((_HDDM_ElementList*)list)->subtype, 1);
   return list;
}

static PyObject*
_TofPoint_deleteTofStatuses(PyObject *self, PyObject *args)
{
   int count=-1;
   int start=0;
   if (! PyArg_ParseTuple(args, "|ii", &count, &start)) {
      return NULL;
   }
   _TofPoint *me = (_TofPoint*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "delete attempted on invalid tofPoint element");
      return NULL;
   }
   me->elem->deleteTofStatuses(count, start);
   Py_INCREF(Py_None);
   return Py_None;
}

static PyObject*
_TofPoint_getTofEnergyDeposition(PyObject *self, PyObject *args)
{
   int index=0;
   if (! PyArg_ParseTuple(args, "|i", &index)) {
      return NULL;
   }
   _TofPoint *me = (_TofPoint*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid tofPoint element");
      return NULL;
   }
   PyObject *obj = _TofEnergyDeposition_new(&_TofEnergyDeposition_type, 0, 0);
   ((_TofEnergyDeposition*)obj)->elem = &me->elem->getTofEnergyDeposition();
   ((_TofEnergyDeposition*)obj)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(obj));
   return obj;
}

static PyObject*
_TofPoint_getTofEnergyDepositions(PyObject *self, PyObject *args)
{
   _TofPoint *me = (_TofPoint*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid tofPoint element");
      return NULL;
   }
   PyObject *list = _HDDM_ElementList_new(&_HDDM_ElementList_type, 0, 0);
   ((_HDDM_ElementList*)list)->subtype = &_TofEnergyDeposition_type;
   ((_HDDM_ElementList*)list)->list = (HDDM_ElementList<HDDM_Element>*)
    &me->elem->getTofEnergyDepositions();
   ((_HDDM_ElementList*)list)->borrowed = 1;
   ((_HDDM_ElementList*)list)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(list), ((_HDDM_ElementList*)list)->subtype, 0);
   return list;
}

static PyObject*
_TofPoint_addTofEnergyDepositions(PyObject *self, PyObject *args)
{
   int count=1;
   int start=-1;
   if (! PyArg_ParseTuple(args, "|ii", &count, &start)) {
      return NULL;
   }
   _TofPoint *me = (_TofPoint*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "add attempted on invalid tofPoint element");
      return NULL;
   }
   PyObject *list = _HDDM_ElementList_new(&_HDDM_ElementList_type, 0, 0);
   ((_HDDM_ElementList*)list)->subtype = &_TofEnergyDeposition_type;
   ((_HDDM_ElementList*)list)->list = (HDDM_ElementList<HDDM_Element>*)
    new TofEnergyDepositionList(me->elem->addTofEnergyDepositions(count, start));
   ((_HDDM_ElementList*)list)->borrowed = 0;
   ((_HDDM_ElementList*)list)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(list), ((_HDDM_ElementList*)list)->subtype, 1);
   return list;
}

static PyObject*
_TofPoint_deleteTofEnergyDepositions(PyObject *self, PyObject *args)
{
   int count=-1;
   int start=0;
   if (! PyArg_ParseTuple(args, "|ii", &count, &start)) {
      return NULL;
   }
   _TofPoint *me = (_TofPoint*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "delete attempted on invalid tofPoint element");
      return NULL;
   }
   me->elem->deleteTofEnergyDepositions(count, start);
   Py_INCREF(Py_None);
   return Py_None;
}

static PyObject*
_TofPoint_toString(PyObject *self, PyObject *args=0)
{
   _TofPoint *me = (_TofPoint*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid tofPoint element");
      return NULL;
   }
   std::string str(me->elem->toString());
   return PyUnicode_FromString(str.c_str());
}

static PyObject*
_TofPoint_toXML(PyObject *self, PyObject *args=0)
{
   _TofPoint *me = (_TofPoint*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid tofPoint element");
      return NULL;
   }
   std::string str(me->elem->toXML());
   return PyUnicode_FromString(str.c_str());
}

static PyGetSetDef _TofPoint_getsetters[] = {
   {(char*)"Eunit",
    (getter)_TofPoint_getEunit, 0,
    (char*)"Eunit value",
    NULL},
   {(char*)"class",
    (getter)_TofPoint_getClass, 0,
    (char*)"class string",
    NULL},
   {(char*)"dE",
    (getter)_TofPoint_getDE, (setter)_TofPoint_setDE,
    (char*)"dE value",
    NULL},
   {(char*)"eventNo",
    (getter)_TofPoint_getEventNo, 0,
    (char*)"eventNo value",
    NULL},
   {(char*)"jtag",
    (getter)_TofPoint_getJtag, (setter)_TofPoint_setJtag,
    (char*)"jtag string",
    NULL},
   {(char*)"lunit",
    (getter)_TofPoint_getLunit, 0,
    (char*)"lunit value",
    NULL},
   {(char*)"maxOccurs",
    (getter)_TofPoint_getMaxOccurs, 0,
    (char*)"maxOccurs value",
    NULL},
   {(char*)"minOccurs",
    (getter)_TofPoint_getMinOccurs, 0,
    (char*)"minOccurs value",
    NULL},
   {(char*)"runNo",
    (getter)_TofPoint_getRunNo, 0,
    (char*)"runNo value",
    NULL},
   {(char*)"t",
    (getter)_TofPoint_getT, (setter)_TofPoint_setT,
    (char*)"t value",
    NULL},
   {(char*)"terr",
    (getter)_TofPoint_getTerr, (setter)_TofPoint_setTerr,
    (char*)"terr value",
    NULL},
   {(char*)"tunit",
    (getter)_TofPoint_getTunit, 0,
    (char*)"tunit value",
    NULL},
   {(char*)"version",
    (getter)_TofPoint_getVersion, 0,
    (char*)"version string",
    NULL},
   {(char*)"x",
    (getter)_TofPoint_getX, (setter)_TofPoint_setX,
    (char*)"x value",
    NULL},
   {(char*)"xmlns",
    (getter)_TofPoint_getXmlns, 0,
    (char*)"xmlns string",
    NULL},
   {(char*)"y",
    (getter)_TofPoint_getY, (setter)_TofPoint_setY,
    (char*)"y value",
    NULL},
   {(char*)"z",
    (getter)_TofPoint_getZ, (setter)_TofPoint_setZ,
    (char*)"z value",
    NULL},
   {NULL}  /* Sentinel */
};

static PyMemberDef _TofPoint_members[] = {
   {NULL}  /* Sentinel */
};

static PyMethodDef _TofPoint_methods[] = {
   {"addTofEnergyDepositions", _TofPoint_addTofEnergyDepositions, METH_VARARGS,
    "extend (or insert into) the list of tofEnergyDeposition objects for this tofPoint"},
   {"addTofStatuses", _TofPoint_addTofStatuses, METH_VARARGS,
    "extend (or insert into) the list of tofStatus objects for this tofPoint"},
   {"deleteTofEnergyDepositions", _TofPoint_deleteTofEnergyDepositions, METH_VARARGS,
    "delete tofEnergyDeposition objects for this tofPoint"},
   {"deleteTofStatuses", _TofPoint_deleteTofStatuses, METH_VARARGS,
    "delete tofStatus objects for this tofPoint"},
   {"getTofEnergyDeposition", _TofPoint_getTofEnergyDeposition, METH_VARARGS,
    "get an individual tofEnergyDeposition object from this tofPoint"},
   {"getTofEnergyDepositions", _TofPoint_getTofEnergyDepositions, METH_NOARGS,
    "get list of tofEnergyDeposition objects for this tofPoint"},
   {"getTofStatus", _TofPoint_getTofStatus, METH_VARARGS,
    "get an individual tofStatus object from this tofPoint"},
   {"getTofStatuses", _TofPoint_getTofStatuses, METH_NOARGS,
    "get list of tofStatus objects for this tofPoint"},
   {"toString", _TofPoint_toString, METH_NOARGS,
    "show element as a human-readable string"},
   {"toXML", _TofPoint_toXML, METH_NOARGS,
    "show element as a XML fragment"},
   {NULL}  /* Sentinel */
};

static PyTypeObject _TofPoint_type = {
    PyVarObject_HEAD_INIT(NULL,0)
    "hddm_r.TofPoint",         /*tp_name*/
    sizeof(_TofPoint),          /*tp_basicsize*/
    0,                         /*tp_itemsize*/
    (destructor)_TofPoint_dealloc, /*tp_dealloc*/
    0,                         /*tp_print*/
    0,                         /*tp_getattr*/
    0,                         /*tp_setattr*/
    0,                         /*tp_compare*/
    0,                         /*tp_repr*/
    0,                         /*tp_as_number*/
    0,                         /*tp_as_sequence*/
    0,                         /*tp_as_mapping*/
    0,                         /*tp_hash */
    0,                         /*tp_call*/
    (reprfunc)_TofPoint_toString,         /*tp_str*/
    0,                         /*tp_getattro*/
    0,                         /*tp_setattro*/
    0,                         /*tp_as_buffer*/
    Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE, /*tp_flags*/
    "hddm_r tofPoint element",  /* tp_doc */
    0,                         /* tp_traverse */
    0,                         /* tp_clear */
    0,                         /* tp_richcompare */
    0,                         /* tp_weaklistoffset */
    0,                         /* tp_iter */
    0,                         /* tp_iternext */
    _TofPoint_methods,          /* tp_methods */
    _TofPoint_members,          /* tp_members */
    _TofPoint_getsetters,       /* tp_getset */
    &_HDDM_Element_type,       /* tp_base */
    0,                         /* tp_dict */
    0,                         /* tp_descr_get */
    0,                         /* tp_descr_set */
    0,                         /* tp_dictoffset */
    (initproc)_TofPoint_init,   /* tp_init */
    0,                         /* tp_alloc */
    _TofPoint_new,              /* tp_new */
};



// wrap element class hddm_r::DircHit as hddm_r.DircHit

typedef struct {
   PyObject_HEAD
   DircHit *elem;
   PyObject *host;
} _DircHit;

static void
_DircHit_dealloc(_DircHit* self)
{
   if (self->elem != 0) {
      LOG_DEALLOC(Py_TYPE(self), 0, self->host == (PyObject*)self);
      if (self->host == (PyObject*)self)
         delete self->elem;
      else
         My_DECREF(self->host);
   }
   Py_TYPE(self)->tp_free((PyObject*)self);
}

static PyObject*
_DircHit_new(PyTypeObject *type, PyObject *args, PyObject *kwds)
{
   _DircHit *self;
   self = (_DircHit*)type->tp_alloc(type, 0);
   if (self != NULL) {
      self->elem = 0;
      self->host = 0;
   }
   return (PyObject*)self;
}

static int
_DircHit_init(_DircHit *self, PyObject *args, PyObject *kwds)
{
   PyErr_SetString(PyExc_RuntimeError, "illegal constructor");
   return -1;
}

static PyObject*
_DircHit_getClass(_DircHit *self, void *closure)
{
   std::string val(self->elem->getClass());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_DircHit_getVersion(_DircHit *self, void *closure)
{
   std::string val(self->elem->getVersion());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_DircHit_getXmlns(_DircHit *self, void *closure)
{
   std::string val(self->elem->getXmlns());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_DircHit_getEventNo(_DircHit *self, void *closure)
{
   return PyLong_FromLongLong(self->elem->getEventNo());
}

static PyObject*
_DircHit_getRunNo(_DircHit *self, void *closure)
{
   return PyLong_FromLong(self->elem->getRunNo());
}

static PyObject*
_DircHit_getCh(_DircHit *self, void *closure)
{
   return PyLong_FromLong(self->elem->getCh());
}

static int
_DircHit_setCh(_DircHit *self, PyObject *value, void *closure)
{
   long var = PyInt_AsLong(value);
   if (var == -1 && PyErr_Occurred()) {
      return -1;
   }
   self->elem->setCh(var);
   return 0;
}

static PyObject*
_DircHit_getJtag(_DircHit *self, void *closure)
{
   std::string val(self->elem->getJtag());
   return PyUnicode_FromString(val.c_str());
}

static int
_DircHit_setJtag(_DircHit *self, PyObject *value, void *closure)
{
   PyObject *str=0;
   if (PyUnicode_Check(value))
      str = PyUnicode_AsEncodedString(value, "ASCII", "strict");
   else
      str = value;
#if PY_MAJOR_VERSION < 3
   char *var = PyString_AsString(str);
#else
   char *var = PyBytes_AsString(str);
#endif
   if (var == 0) {
      return -1;
   }
   self->elem->setJtag(std::string(var));
   if (str != value) {
      Py_DECREF(str);
   }
   return 0;
}

static PyObject*
_DircHit_getMaxOccurs(_DircHit *self, void *closure)
{
   std::string val(self->elem->getMaxOccurs());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_DircHit_getMinOccurs(_DircHit *self, void *closure)
{
   return PyLong_FromLong(self->elem->getMinOccurs());
}

static PyObject*
_DircHit_getT(_DircHit *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getT());
}

static int
_DircHit_setT(_DircHit *self, PyObject *value, void *closure)
{
   double var = PyFloat_AsDouble(value);
   if (var == -1 && PyErr_Occurred()) {
      return 1;
   }
   self->elem->setT((float)var);
   return 0;
}

static PyObject*
_DircHit_getTot(_DircHit *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getTot());
}

static int
_DircHit_setTot(_DircHit *self, PyObject *value, void *closure)
{
   double var = PyFloat_AsDouble(value);
   if (var == -1 && PyErr_Occurred()) {
      return 1;
   }
   self->elem->setTot((float)var);
   return 0;
}

static PyObject*
_DircHit_getTunit(_DircHit *self, void *closure)
{
   std::string val(self->elem->getTunit());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_DircHit_toString(PyObject *self, PyObject *args=0)
{
   _DircHit *me = (_DircHit*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid dircHit element");
      return NULL;
   }
   std::string str(me->elem->toString());
   return PyUnicode_FromString(str.c_str());
}

static PyObject*
_DircHit_toXML(PyObject *self, PyObject *args=0)
{
   _DircHit *me = (_DircHit*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid dircHit element");
      return NULL;
   }
   std::string str(me->elem->toXML());
   return PyUnicode_FromString(str.c_str());
}

static PyGetSetDef _DircHit_getsetters[] = {
   {(char*)"ch",
    (getter)_DircHit_getCh, (setter)_DircHit_setCh,
    (char*)"ch value",
    NULL},
   {(char*)"class",
    (getter)_DircHit_getClass, 0,
    (char*)"class string",
    NULL},
   {(char*)"eventNo",
    (getter)_DircHit_getEventNo, 0,
    (char*)"eventNo value",
    NULL},
   {(char*)"jtag",
    (getter)_DircHit_getJtag, (setter)_DircHit_setJtag,
    (char*)"jtag string",
    NULL},
   {(char*)"maxOccurs",
    (getter)_DircHit_getMaxOccurs, 0,
    (char*)"maxOccurs value",
    NULL},
   {(char*)"minOccurs",
    (getter)_DircHit_getMinOccurs, 0,
    (char*)"minOccurs value",
    NULL},
   {(char*)"runNo",
    (getter)_DircHit_getRunNo, 0,
    (char*)"runNo value",
    NULL},
   {(char*)"t",
    (getter)_DircHit_getT, (setter)_DircHit_setT,
    (char*)"t value",
    NULL},
   {(char*)"tot",
    (getter)_DircHit_getTot, (setter)_DircHit_setTot,
    (char*)"tot value",
    NULL},
   {(char*)"tunit",
    (getter)_DircHit_getTunit, 0,
    (char*)"tunit value",
    NULL},
   {(char*)"version",
    (getter)_DircHit_getVersion, 0,
    (char*)"version string",
    NULL},
   {(char*)"xmlns",
    (getter)_DircHit_getXmlns, 0,
    (char*)"xmlns string",
    NULL},
   {NULL}  /* Sentinel */
};

static PyMemberDef _DircHit_members[] = {
   {NULL}  /* Sentinel */
};

static PyMethodDef _DircHit_methods[] = {
   {"toString", _DircHit_toString, METH_NOARGS,
    "show element as a human-readable string"},
   {"toXML", _DircHit_toXML, METH_NOARGS,
    "show element as a XML fragment"},
   {NULL}  /* Sentinel */
};

static PyTypeObject _DircHit_type = {
    PyVarObject_HEAD_INIT(NULL,0)
    "hddm_r.DircHit",         /*tp_name*/
    sizeof(_DircHit),          /*tp_basicsize*/
    0,                         /*tp_itemsize*/
    (destructor)_DircHit_dealloc, /*tp_dealloc*/
    0,                         /*tp_print*/
    0,                         /*tp_getattr*/
    0,                         /*tp_setattr*/
    0,                         /*tp_compare*/
    0,                         /*tp_repr*/
    0,                         /*tp_as_number*/
    0,                         /*tp_as_sequence*/
    0,                         /*tp_as_mapping*/
    0,                         /*tp_hash */
    0,                         /*tp_call*/
    (reprfunc)_DircHit_toString,         /*tp_str*/
    0,                         /*tp_getattro*/
    0,                         /*tp_setattro*/
    0,                         /*tp_as_buffer*/
    Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE, /*tp_flags*/
    "hddm_r dircHit element",  /* tp_doc */
    0,                         /* tp_traverse */
    0,                         /* tp_clear */
    0,                         /* tp_richcompare */
    0,                         /* tp_weaklistoffset */
    0,                         /* tp_iter */
    0,                         /* tp_iternext */
    _DircHit_methods,          /* tp_methods */
    _DircHit_members,          /* tp_members */
    _DircHit_getsetters,       /* tp_getset */
    &_HDDM_Element_type,       /* tp_base */
    0,                         /* tp_dict */
    0,                         /* tp_descr_get */
    0,                         /* tp_descr_set */
    0,                         /* tp_dictoffset */
    (initproc)_DircHit_init,   /* tp_init */
    0,                         /* tp_alloc */
    _DircHit_new,              /* tp_new */
};



// wrap element class hddm_r::FmwpcHit as hddm_r.FmwpcHit

typedef struct {
   PyObject_HEAD
   FmwpcHit *elem;
   PyObject *host;
} _FmwpcHit;

static void
_FmwpcHit_dealloc(_FmwpcHit* self)
{
   if (self->elem != 0) {
      LOG_DEALLOC(Py_TYPE(self), 0, self->host == (PyObject*)self);
      if (self->host == (PyObject*)self)
         delete self->elem;
      else
         My_DECREF(self->host);
   }
   Py_TYPE(self)->tp_free((PyObject*)self);
}

static PyObject*
_FmwpcHit_new(PyTypeObject *type, PyObject *args, PyObject *kwds)
{
   _FmwpcHit *self;
   self = (_FmwpcHit*)type->tp_alloc(type, 0);
   if (self != NULL) {
      self->elem = 0;
      self->host = 0;
   }
   return (PyObject*)self;
}

static int
_FmwpcHit_init(_FmwpcHit *self, PyObject *args, PyObject *kwds)
{
   PyErr_SetString(PyExc_RuntimeError, "illegal constructor");
   return -1;
}

static PyObject*
_FmwpcHit_getClass(_FmwpcHit *self, void *closure)
{
   std::string val(self->elem->getClass());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_FmwpcHit_getVersion(_FmwpcHit *self, void *closure)
{
   std::string val(self->elem->getVersion());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_FmwpcHit_getXmlns(_FmwpcHit *self, void *closure)
{
   std::string val(self->elem->getXmlns());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_FmwpcHit_getEventNo(_FmwpcHit *self, void *closure)
{
   return PyLong_FromLongLong(self->elem->getEventNo());
}

static PyObject*
_FmwpcHit_getRunNo(_FmwpcHit *self, void *closure)
{
   return PyLong_FromLong(self->elem->getRunNo());
}

static PyObject*
_FmwpcHit_getAmp(_FmwpcHit *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getAmp());
}

static int
_FmwpcHit_setAmp(_FmwpcHit *self, PyObject *value, void *closure)
{
   double var = PyFloat_AsDouble(value);
   if (var == -1 && PyErr_Occurred()) {
      return 1;
   }
   self->elem->setAmp((float)var);
   return 0;
}

static PyObject*
_FmwpcHit_getJtag(_FmwpcHit *self, void *closure)
{
   std::string val(self->elem->getJtag());
   return PyUnicode_FromString(val.c_str());
}

static int
_FmwpcHit_setJtag(_FmwpcHit *self, PyObject *value, void *closure)
{
   PyObject *str=0;
   if (PyUnicode_Check(value))
      str = PyUnicode_AsEncodedString(value, "ASCII", "strict");
   else
      str = value;
#if PY_MAJOR_VERSION < 3
   char *var = PyString_AsString(str);
#else
   char *var = PyBytes_AsString(str);
#endif
   if (var == 0) {
      return -1;
   }
   self->elem->setJtag(std::string(var));
   if (str != value) {
      Py_DECREF(str);
   }
   return 0;
}

static PyObject*
_FmwpcHit_getLayer(_FmwpcHit *self, void *closure)
{
   return PyLong_FromLong(self->elem->getLayer());
}

static int
_FmwpcHit_setLayer(_FmwpcHit *self, PyObject *value, void *closure)
{
   long var = PyInt_AsLong(value);
   if (var == -1 && PyErr_Occurred()) {
      return -1;
   }
   self->elem->setLayer(var);
   return 0;
}

static PyObject*
_FmwpcHit_getMaxOccurs(_FmwpcHit *self, void *closure)
{
   std::string val(self->elem->getMaxOccurs());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_FmwpcHit_getMinOccurs(_FmwpcHit *self, void *closure)
{
   return PyLong_FromLong(self->elem->getMinOccurs());
}

static PyObject*
_FmwpcHit_getPed(_FmwpcHit *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getPed());
}

static int
_FmwpcHit_setPed(_FmwpcHit *self, PyObject *value, void *closure)
{
   double var = PyFloat_AsDouble(value);
   if (var == -1 && PyErr_Occurred()) {
      return 1;
   }
   self->elem->setPed((float)var);
   return 0;
}

static PyObject*
_FmwpcHit_getQ(_FmwpcHit *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getQ());
}

static int
_FmwpcHit_setQ(_FmwpcHit *self, PyObject *value, void *closure)
{
   double var = PyFloat_AsDouble(value);
   if (var == -1 && PyErr_Occurred()) {
      return 1;
   }
   self->elem->setQ((float)var);
   return 0;
}

static PyObject*
_FmwpcHit_getQf(_FmwpcHit *self, void *closure)
{
   return PyLong_FromLong(self->elem->getQf());
}

static int
_FmwpcHit_setQf(_FmwpcHit *self, PyObject *value, void *closure)
{
   long var = PyInt_AsLong(value);
   if (var == -1 && PyErr_Occurred()) {
      return -1;
   }
   self->elem->setQf(var);
   return 0;
}

static PyObject*
_FmwpcHit_getT(_FmwpcHit *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getT());
}

static int
_FmwpcHit_setT(_FmwpcHit *self, PyObject *value, void *closure)
{
   double var = PyFloat_AsDouble(value);
   if (var == -1 && PyErr_Occurred()) {
      return 1;
   }
   self->elem->setT((float)var);
   return 0;
}

static PyObject*
_FmwpcHit_getTunit(_FmwpcHit *self, void *closure)
{
   std::string val(self->elem->getTunit());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_FmwpcHit_getWire(_FmwpcHit *self, void *closure)
{
   return PyLong_FromLong(self->elem->getWire());
}

static int
_FmwpcHit_setWire(_FmwpcHit *self, PyObject *value, void *closure)
{
   long var = PyInt_AsLong(value);
   if (var == -1 && PyErr_Occurred()) {
      return -1;
   }
   self->elem->setWire(var);
   return 0;
}

static PyObject*
_FmwpcHit_toString(PyObject *self, PyObject *args=0)
{
   _FmwpcHit *me = (_FmwpcHit*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid fmwpcHit element");
      return NULL;
   }
   std::string str(me->elem->toString());
   return PyUnicode_FromString(str.c_str());
}

static PyObject*
_FmwpcHit_toXML(PyObject *self, PyObject *args=0)
{
   _FmwpcHit *me = (_FmwpcHit*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid fmwpcHit element");
      return NULL;
   }
   std::string str(me->elem->toXML());
   return PyUnicode_FromString(str.c_str());
}

static PyGetSetDef _FmwpcHit_getsetters[] = {
   {(char*)"amp",
    (getter)_FmwpcHit_getAmp, (setter)_FmwpcHit_setAmp,
    (char*)"amp value",
    NULL},
   {(char*)"class",
    (getter)_FmwpcHit_getClass, 0,
    (char*)"class string",
    NULL},
   {(char*)"eventNo",
    (getter)_FmwpcHit_getEventNo, 0,
    (char*)"eventNo value",
    NULL},
   {(char*)"jtag",
    (getter)_FmwpcHit_getJtag, (setter)_FmwpcHit_setJtag,
    (char*)"jtag string",
    NULL},
   {(char*)"layer",
    (getter)_FmwpcHit_getLayer, (setter)_FmwpcHit_setLayer,
    (char*)"layer value",
    NULL},
   {(char*)"maxOccurs",
    (getter)_FmwpcHit_getMaxOccurs, 0,
    (char*)"maxOccurs value",
    NULL},
   {(char*)"minOccurs",
    (getter)_FmwpcHit_getMinOccurs, 0,
    (char*)"minOccurs value",
    NULL},
   {(char*)"ped",
    (getter)_FmwpcHit_getPed, (setter)_FmwpcHit_setPed,
    (char*)"ped value",
    NULL},
   {(char*)"q",
    (getter)_FmwpcHit_getQ, (setter)_FmwpcHit_setQ,
    (char*)"q value",
    NULL},
   {(char*)"qf",
    (getter)_FmwpcHit_getQf, (setter)_FmwpcHit_setQf,
    (char*)"qf value",
    NULL},
   {(char*)"runNo",
    (getter)_FmwpcHit_getRunNo, 0,
    (char*)"runNo value",
    NULL},
   {(char*)"t",
    (getter)_FmwpcHit_getT, (setter)_FmwpcHit_setT,
    (char*)"t value",
    NULL},
   {(char*)"tunit",
    (getter)_FmwpcHit_getTunit, 0,
    (char*)"tunit value",
    NULL},
   {(char*)"version",
    (getter)_FmwpcHit_getVersion, 0,
    (char*)"version string",
    NULL},
   {(char*)"wire",
    (getter)_FmwpcHit_getWire, (setter)_FmwpcHit_setWire,
    (char*)"wire value",
    NULL},
   {(char*)"xmlns",
    (getter)_FmwpcHit_getXmlns, 0,
    (char*)"xmlns string",
    NULL},
   {NULL}  /* Sentinel */
};

static PyMemberDef _FmwpcHit_members[] = {
   {NULL}  /* Sentinel */
};

static PyMethodDef _FmwpcHit_methods[] = {
   {"toString", _FmwpcHit_toString, METH_NOARGS,
    "show element as a human-readable string"},
   {"toXML", _FmwpcHit_toXML, METH_NOARGS,
    "show element as a XML fragment"},
   {NULL}  /* Sentinel */
};

static PyTypeObject _FmwpcHit_type = {
    PyVarObject_HEAD_INIT(NULL,0)
    "hddm_r.FmwpcHit",         /*tp_name*/
    sizeof(_FmwpcHit),          /*tp_basicsize*/
    0,                         /*tp_itemsize*/
    (destructor)_FmwpcHit_dealloc, /*tp_dealloc*/
    0,                         /*tp_print*/
    0,                         /*tp_getattr*/
    0,                         /*tp_setattr*/
    0,                         /*tp_compare*/
    0,                         /*tp_repr*/
    0,                         /*tp_as_number*/
    0,                         /*tp_as_sequence*/
    0,                         /*tp_as_mapping*/
    0,                         /*tp_hash */
    0,                         /*tp_call*/
    (reprfunc)_FmwpcHit_toString,         /*tp_str*/
    0,                         /*tp_getattro*/
    0,                         /*tp_setattro*/
    0,                         /*tp_as_buffer*/
    Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE, /*tp_flags*/
    "hddm_r fmwpcHit element",  /* tp_doc */
    0,                         /* tp_traverse */
    0,                         /* tp_clear */
    0,                         /* tp_richcompare */
    0,                         /* tp_weaklistoffset */
    0,                         /* tp_iter */
    0,                         /* tp_iternext */
    _FmwpcHit_methods,          /* tp_methods */
    _FmwpcHit_members,          /* tp_members */
    _FmwpcHit_getsetters,       /* tp_getset */
    &_HDDM_Element_type,       /* tp_base */
    0,                         /* tp_dict */
    0,                         /* tp_descr_get */
    0,                         /* tp_descr_set */
    0,                         /* tp_dictoffset */
    (initproc)_FmwpcHit_init,   /* tp_init */
    0,                         /* tp_alloc */
    _FmwpcHit_new,              /* tp_new */
};



// wrap element class hddm_r::RFtime as hddm_r.RFtime

typedef struct {
   PyObject_HEAD
   RFtime *elem;
   PyObject *host;
} _RFtime;

static void
_RFtime_dealloc(_RFtime* self)
{
   if (self->elem != 0) {
      LOG_DEALLOC(Py_TYPE(self), 0, self->host == (PyObject*)self);
      if (self->host == (PyObject*)self)
         delete self->elem;
      else
         My_DECREF(self->host);
   }
   Py_TYPE(self)->tp_free((PyObject*)self);
}

static PyObject*
_RFtime_new(PyTypeObject *type, PyObject *args, PyObject *kwds)
{
   _RFtime *self;
   self = (_RFtime*)type->tp_alloc(type, 0);
   if (self != NULL) {
      self->elem = 0;
      self->host = 0;
   }
   return (PyObject*)self;
}

static int
_RFtime_init(_RFtime *self, PyObject *args, PyObject *kwds)
{
   PyErr_SetString(PyExc_RuntimeError, "illegal constructor");
   return -1;
}

static PyObject*
_RFtime_getClass(_RFtime *self, void *closure)
{
   std::string val(self->elem->getClass());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_RFtime_getVersion(_RFtime *self, void *closure)
{
   std::string val(self->elem->getVersion());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_RFtime_getXmlns(_RFtime *self, void *closure)
{
   std::string val(self->elem->getXmlns());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_RFtime_getEventNo(_RFtime *self, void *closure)
{
   return PyLong_FromLongLong(self->elem->getEventNo());
}

static PyObject*
_RFtime_getRunNo(_RFtime *self, void *closure)
{
   return PyLong_FromLong(self->elem->getRunNo());
}

static PyObject*
_RFtime_getJtag(_RFtime *self, void *closure)
{
   std::string val(self->elem->getJtag());
   return PyUnicode_FromString(val.c_str());
}

static int
_RFtime_setJtag(_RFtime *self, PyObject *value, void *closure)
{
   PyObject *str=0;
   if (PyUnicode_Check(value))
      str = PyUnicode_AsEncodedString(value, "ASCII", "strict");
   else
      str = value;
#if PY_MAJOR_VERSION < 3
   char *var = PyString_AsString(str);
#else
   char *var = PyBytes_AsString(str);
#endif
   if (var == 0) {
      return -1;
   }
   self->elem->setJtag(std::string(var));
   if (str != value) {
      Py_DECREF(str);
   }
   return 0;
}

static PyObject*
_RFtime_getMinOccurs(_RFtime *self, void *closure)
{
   return PyLong_FromLong(self->elem->getMinOccurs());
}

static PyObject*
_RFtime_getTsync(_RFtime *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getTsync());
}

static int
_RFtime_setTsync(_RFtime *self, PyObject *value, void *closure)
{
   double var = PyFloat_AsDouble(value);
   if (var == -1 && PyErr_Occurred()) {
      return 1;
   }
   self->elem->setTsync((float)var);
   return 0;
}

static PyObject*
_RFtime_getTunit(_RFtime *self, void *closure)
{
   std::string val(self->elem->getTunit());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_RFtime_toString(PyObject *self, PyObject *args=0)
{
   _RFtime *me = (_RFtime*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid RFtime element");
      return NULL;
   }
   std::string str(me->elem->toString());
   return PyUnicode_FromString(str.c_str());
}

static PyObject*
_RFtime_toXML(PyObject *self, PyObject *args=0)
{
   _RFtime *me = (_RFtime*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid RFtime element");
      return NULL;
   }
   std::string str(me->elem->toXML());
   return PyUnicode_FromString(str.c_str());
}

static PyGetSetDef _RFtime_getsetters[] = {
   {(char*)"class",
    (getter)_RFtime_getClass, 0,
    (char*)"class string",
    NULL},
   {(char*)"eventNo",
    (getter)_RFtime_getEventNo, 0,
    (char*)"eventNo value",
    NULL},
   {(char*)"jtag",
    (getter)_RFtime_getJtag, (setter)_RFtime_setJtag,
    (char*)"jtag string",
    NULL},
   {(char*)"minOccurs",
    (getter)_RFtime_getMinOccurs, 0,
    (char*)"minOccurs value",
    NULL},
   {(char*)"runNo",
    (getter)_RFtime_getRunNo, 0,
    (char*)"runNo value",
    NULL},
   {(char*)"tsync",
    (getter)_RFtime_getTsync, (setter)_RFtime_setTsync,
    (char*)"tsync value",
    NULL},
   {(char*)"tunit",
    (getter)_RFtime_getTunit, 0,
    (char*)"tunit value",
    NULL},
   {(char*)"version",
    (getter)_RFtime_getVersion, 0,
    (char*)"version string",
    NULL},
   {(char*)"xmlns",
    (getter)_RFtime_getXmlns, 0,
    (char*)"xmlns string",
    NULL},
   {NULL}  /* Sentinel */
};

static PyMemberDef _RFtime_members[] = {
   {NULL}  /* Sentinel */
};

static PyMethodDef _RFtime_methods[] = {
   {"toString", _RFtime_toString, METH_NOARGS,
    "show element as a human-readable string"},
   {"toXML", _RFtime_toXML, METH_NOARGS,
    "show element as a XML fragment"},
   {NULL}  /* Sentinel */
};

static PyTypeObject _RFtime_type = {
    PyVarObject_HEAD_INIT(NULL,0)
    "hddm_r.RFtime",         /*tp_name*/
    sizeof(_RFtime),          /*tp_basicsize*/
    0,                         /*tp_itemsize*/
    (destructor)_RFtime_dealloc, /*tp_dealloc*/
    0,                         /*tp_print*/
    0,                         /*tp_getattr*/
    0,                         /*tp_setattr*/
    0,                         /*tp_compare*/
    0,                         /*tp_repr*/
    0,                         /*tp_as_number*/
    0,                         /*tp_as_sequence*/
    0,                         /*tp_as_mapping*/
    0,                         /*tp_hash */
    0,                         /*tp_call*/
    (reprfunc)_RFtime_toString,         /*tp_str*/
    0,                         /*tp_getattro*/
    0,                         /*tp_setattro*/
    0,                         /*tp_as_buffer*/
    Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE, /*tp_flags*/
    "hddm_r RFtime element",  /* tp_doc */
    0,                         /* tp_traverse */
    0,                         /* tp_clear */
    0,                         /* tp_richcompare */
    0,                         /* tp_weaklistoffset */
    0,                         /* tp_iter */
    0,                         /* tp_iternext */
    _RFtime_methods,          /* tp_methods */
    _RFtime_members,          /* tp_members */
    _RFtime_getsetters,       /* tp_getset */
    &_HDDM_Element_type,       /* tp_base */
    0,                         /* tp_dict */
    0,                         /* tp_descr_get */
    0,                         /* tp_descr_set */
    0,                         /* tp_dictoffset */
    (initproc)_RFtime_init,   /* tp_init */
    0,                         /* tp_alloc */
    _RFtime_new,              /* tp_new */
};



// wrap element class hddm_r::TriggerEnergySums as hddm_r.TriggerEnergySums

typedef struct {
   PyObject_HEAD
   TriggerEnergySums *elem;
   PyObject *host;
} _TriggerEnergySums;

static void
_TriggerEnergySums_dealloc(_TriggerEnergySums* self)
{
   if (self->elem != 0) {
      LOG_DEALLOC(Py_TYPE(self), 0, self->host == (PyObject*)self);
      if (self->host == (PyObject*)self)
         delete self->elem;
      else
         My_DECREF(self->host);
   }
   Py_TYPE(self)->tp_free((PyObject*)self);
}

static PyObject*
_TriggerEnergySums_new(PyTypeObject *type, PyObject *args, PyObject *kwds)
{
   _TriggerEnergySums *self;
   self = (_TriggerEnergySums*)type->tp_alloc(type, 0);
   if (self != NULL) {
      self->elem = 0;
      self->host = 0;
   }
   return (PyObject*)self;
}

static int
_TriggerEnergySums_init(_TriggerEnergySums *self, PyObject *args, PyObject *kwds)
{
   PyErr_SetString(PyExc_RuntimeError, "illegal constructor");
   return -1;
}

static PyObject*
_TriggerEnergySums_getClass(_TriggerEnergySums *self, void *closure)
{
   std::string val(self->elem->getClass());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_TriggerEnergySums_getVersion(_TriggerEnergySums *self, void *closure)
{
   std::string val(self->elem->getVersion());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_TriggerEnergySums_getXmlns(_TriggerEnergySums *self, void *closure)
{
   std::string val(self->elem->getXmlns());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_TriggerEnergySums_getEventNo(_TriggerEnergySums *self, void *closure)
{
   return PyLong_FromLongLong(self->elem->getEventNo());
}

static PyObject*
_TriggerEnergySums_getRunNo(_TriggerEnergySums *self, void *closure)
{
   return PyLong_FromLong(self->elem->getRunNo());
}

static PyObject*
_TriggerEnergySums_getJtag(_TriggerEnergySums *self, void *closure)
{
   std::string val(self->elem->getJtag());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_TriggerEnergySums_getL1_fp_trig_bits(_TriggerEnergySums *self, void *closure)
{
   return PyLong_FromLong(self->elem->getL1_fp_trig_bits());
}

static PyObject*
_TriggerEnergySums_getL1_trig_bits(_TriggerEnergySums *self, void *closure)
{
   return PyLong_FromLong(self->elem->getL1_trig_bits());
}

static PyObject*
_TriggerEnergySums_getMaxOccurs(_TriggerEnergySums *self, void *closure)
{
   return PyLong_FromLong(self->elem->getMaxOccurs());
}

static PyObject*
_TriggerEnergySums_getBCALEnergySum(_TriggerEnergySums *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getBCALEnergySum());
}

static int
_TriggerEnergySums_setBCALEnergySum(_TriggerEnergySums *self, PyObject *value, void *closure)
{
   double var = PyFloat_AsDouble(value);
   if (var == -1 && PyErr_Occurred()) {
      return 1;
   }
   self->elem->setBCALEnergySum((float)var);
   return 0;
}

static PyObject*
_TriggerEnergySums_getFCALEnergySum(_TriggerEnergySums *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getFCALEnergySum());
}

static int
_TriggerEnergySums_setFCALEnergySum(_TriggerEnergySums *self, PyObject *value, void *closure)
{
   double var = PyFloat_AsDouble(value);
   if (var == -1 && PyErr_Occurred()) {
      return 1;
   }
   self->elem->setFCALEnergySum((float)var);
   return 0;
}

static PyObject*
_TriggerEnergySums_getMinOccurs(_TriggerEnergySums *self, void *closure)
{
   return PyLong_FromLong(self->elem->getMinOccurs());
}

static PyObject*
_TriggerEnergySums_toString(PyObject *self, PyObject *args=0)
{
   _TriggerEnergySums *me = (_TriggerEnergySums*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid triggerEnergySums element");
      return NULL;
   }
   std::string str(me->elem->toString());
   return PyUnicode_FromString(str.c_str());
}

static PyObject*
_TriggerEnergySums_toXML(PyObject *self, PyObject *args=0)
{
   _TriggerEnergySums *me = (_TriggerEnergySums*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid triggerEnergySums element");
      return NULL;
   }
   std::string str(me->elem->toXML());
   return PyUnicode_FromString(str.c_str());
}

static PyGetSetDef _TriggerEnergySums_getsetters[] = {
   {(char*)"BCALEnergySum",
    (getter)_TriggerEnergySums_getBCALEnergySum, (setter)_TriggerEnergySums_setBCALEnergySum,
    (char*)"BCALEnergySum value",
    NULL},
   {(char*)"FCALEnergySum",
    (getter)_TriggerEnergySums_getFCALEnergySum, (setter)_TriggerEnergySums_setFCALEnergySum,
    (char*)"FCALEnergySum value",
    NULL},
   {(char*)"class",
    (getter)_TriggerEnergySums_getClass, 0,
    (char*)"class string",
    NULL},
   {(char*)"eventNo",
    (getter)_TriggerEnergySums_getEventNo, 0,
    (char*)"eventNo value",
    NULL},
   {(char*)"jtag",
    (getter)_TriggerEnergySums_getJtag, 0,
    (char*)"jtag string",
    NULL},
   {(char*)"l1_fp_trig_bits",
    (getter)_TriggerEnergySums_getL1_fp_trig_bits, 0,
    (char*)"l1_fp_trig_bits value",
    NULL},
   {(char*)"l1_trig_bits",
    (getter)_TriggerEnergySums_getL1_trig_bits, 0,
    (char*)"l1_trig_bits value",
    NULL},
   {(char*)"maxOccurs",
    (getter)_TriggerEnergySums_getMaxOccurs, 0,
    (char*)"maxOccurs value",
    NULL},
   {(char*)"minOccurs",
    (getter)_TriggerEnergySums_getMinOccurs, 0,
    (char*)"minOccurs value",
    NULL},
   {(char*)"runNo",
    (getter)_TriggerEnergySums_getRunNo, 0,
    (char*)"runNo value",
    NULL},
   {(char*)"version",
    (getter)_TriggerEnergySums_getVersion, 0,
    (char*)"version string",
    NULL},
   {(char*)"xmlns",
    (getter)_TriggerEnergySums_getXmlns, 0,
    (char*)"xmlns string",
    NULL},
   {NULL}  /* Sentinel */
};

static PyMemberDef _TriggerEnergySums_members[] = {
   {NULL}  /* Sentinel */
};

static PyMethodDef _TriggerEnergySums_methods[] = {
   {"toString", _TriggerEnergySums_toString, METH_NOARGS,
    "show element as a human-readable string"},
   {"toXML", _TriggerEnergySums_toXML, METH_NOARGS,
    "show element as a XML fragment"},
   {NULL}  /* Sentinel */
};

static PyTypeObject _TriggerEnergySums_type = {
    PyVarObject_HEAD_INIT(NULL,0)
    "hddm_r.TriggerEnergySums",         /*tp_name*/
    sizeof(_TriggerEnergySums),          /*tp_basicsize*/
    0,                         /*tp_itemsize*/
    (destructor)_TriggerEnergySums_dealloc, /*tp_dealloc*/
    0,                         /*tp_print*/
    0,                         /*tp_getattr*/
    0,                         /*tp_setattr*/
    0,                         /*tp_compare*/
    0,                         /*tp_repr*/
    0,                         /*tp_as_number*/
    0,                         /*tp_as_sequence*/
    0,                         /*tp_as_mapping*/
    0,                         /*tp_hash */
    0,                         /*tp_call*/
    (reprfunc)_TriggerEnergySums_toString,         /*tp_str*/
    0,                         /*tp_getattro*/
    0,                         /*tp_setattro*/
    0,                         /*tp_as_buffer*/
    Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE, /*tp_flags*/
    "hddm_r triggerEnergySums element",  /* tp_doc */
    0,                         /* tp_traverse */
    0,                         /* tp_clear */
    0,                         /* tp_richcompare */
    0,                         /* tp_weaklistoffset */
    0,                         /* tp_iter */
    0,                         /* tp_iternext */
    _TriggerEnergySums_methods,          /* tp_methods */
    _TriggerEnergySums_members,          /* tp_members */
    _TriggerEnergySums_getsetters,       /* tp_getset */
    &_HDDM_Element_type,       /* tp_base */
    0,                         /* tp_dict */
    0,                         /* tp_descr_get */
    0,                         /* tp_descr_set */
    0,                         /* tp_dictoffset */
    (initproc)_TriggerEnergySums_init,   /* tp_init */
    0,                         /* tp_alloc */
    _TriggerEnergySums_new,              /* tp_new */
};



// wrap element class hddm_r::Trigger as hddm_r.Trigger

typedef struct {
   PyObject_HEAD
   Trigger *elem;
   PyObject *host;
} _Trigger;

static void
_Trigger_dealloc(_Trigger* self)
{
   if (self->elem != 0) {
      LOG_DEALLOC(Py_TYPE(self), 0, self->host == (PyObject*)self);
      if (self->host == (PyObject*)self)
         delete self->elem;
      else
         My_DECREF(self->host);
   }
   Py_TYPE(self)->tp_free((PyObject*)self);
}

static PyObject*
_Trigger_new(PyTypeObject *type, PyObject *args, PyObject *kwds)
{
   _Trigger *self;
   self = (_Trigger*)type->tp_alloc(type, 0);
   if (self != NULL) {
      self->elem = 0;
      self->host = 0;
   }
   return (PyObject*)self;
}

static int
_Trigger_init(_Trigger *self, PyObject *args, PyObject *kwds)
{
   PyErr_SetString(PyExc_RuntimeError, "illegal constructor");
   return -1;
}

static PyObject*
_Trigger_getClass(_Trigger *self, void *closure)
{
   std::string val(self->elem->getClass());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_Trigger_getVersion(_Trigger *self, void *closure)
{
   std::string val(self->elem->getVersion());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_Trigger_getXmlns(_Trigger *self, void *closure)
{
   std::string val(self->elem->getXmlns());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_Trigger_getEventNo(_Trigger *self, void *closure)
{
   return PyLong_FromLongLong(self->elem->getEventNo());
}

static PyObject*
_Trigger_getRunNo(_Trigger *self, void *closure)
{
   return PyLong_FromLong(self->elem->getRunNo());
}

static PyObject*
_Trigger_getJtag(_Trigger *self, void *closure)
{
   std::string val(self->elem->getJtag());
   return PyUnicode_FromString(val.c_str());
}

static int
_Trigger_setJtag(_Trigger *self, PyObject *value, void *closure)
{
   PyObject *str=0;
   if (PyUnicode_Check(value))
      str = PyUnicode_AsEncodedString(value, "ASCII", "strict");
   else
      str = value;
#if PY_MAJOR_VERSION < 3
   char *var = PyString_AsString(str);
#else
   char *var = PyBytes_AsString(str);
#endif
   if (var == 0) {
      return -1;
   }
   self->elem->setJtag(std::string(var));
   if (str != value) {
      Py_DECREF(str);
   }
   return 0;
}

static PyObject*
_Trigger_getL1_fp_trig_bits(_Trigger *self, void *closure)
{
   return PyLong_FromLong(self->elem->getL1_fp_trig_bits());
}

static int
_Trigger_setL1_fp_trig_bits(_Trigger *self, PyObject *value, void *closure)
{
   long var = PyInt_AsLong(value);
   if (var == -1 && PyErr_Occurred()) {
      return -1;
   }
   self->elem->setL1_fp_trig_bits(var);
   return 0;
}

static PyObject*
_Trigger_getL1_trig_bits(_Trigger *self, void *closure)
{
   return PyLong_FromLong(self->elem->getL1_trig_bits());
}

static int
_Trigger_setL1_trig_bits(_Trigger *self, PyObject *value, void *closure)
{
   long var = PyInt_AsLong(value);
   if (var == -1 && PyErr_Occurred()) {
      return -1;
   }
   self->elem->setL1_trig_bits(var);
   return 0;
}

static PyObject*
_Trigger_getMaxOccurs(_Trigger *self, void *closure)
{
   return PyLong_FromLong(self->elem->getMaxOccurs());
}

static PyObject*
_Trigger_getMinOccurs(_Trigger *self, void *closure)
{
   return PyLong_FromLong(self->elem->getMinOccurs());
}

static PyObject*
_Trigger_getTriggerEnergySums(PyObject *self, PyObject *args)
{
   int index=0;
   if (! PyArg_ParseTuple(args, "|i", &index)) {
      return NULL;
   }
   _Trigger *me = (_Trigger*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid trigger element");
      return NULL;
   }
   PyObject *obj = _TriggerEnergySums_new(&_TriggerEnergySums_type, 0, 0);
   ((_TriggerEnergySums*)obj)->elem = &me->elem->getTriggerEnergySums();
   ((_TriggerEnergySums*)obj)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(obj));
   return obj;
}

static PyObject*
_Trigger_getTriggerEnergySumses(PyObject *self, PyObject *args)
{
   _Trigger *me = (_Trigger*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid trigger element");
      return NULL;
   }
   PyObject *list = _HDDM_ElementList_new(&_HDDM_ElementList_type, 0, 0);
   ((_HDDM_ElementList*)list)->subtype = &_TriggerEnergySums_type;
   ((_HDDM_ElementList*)list)->list = (HDDM_ElementList<HDDM_Element>*)
    &me->elem->getTriggerEnergySumses();
   ((_HDDM_ElementList*)list)->borrowed = 1;
   ((_HDDM_ElementList*)list)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(list), ((_HDDM_ElementList*)list)->subtype, 0);
   return list;
}

static PyObject*
_Trigger_addTriggerEnergySumses(PyObject *self, PyObject *args)
{
   int count=1;
   int start=-1;
   if (! PyArg_ParseTuple(args, "|ii", &count, &start)) {
      return NULL;
   }
   _Trigger *me = (_Trigger*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "add attempted on invalid trigger element");
      return NULL;
   }
   PyObject *list = _HDDM_ElementList_new(&_HDDM_ElementList_type, 0, 0);
   ((_HDDM_ElementList*)list)->subtype = &_TriggerEnergySums_type;
   ((_HDDM_ElementList*)list)->list = (HDDM_ElementList<HDDM_Element>*)
    new TriggerEnergySumsList(me->elem->addTriggerEnergySumses(count, start));
   ((_HDDM_ElementList*)list)->borrowed = 0;
   ((_HDDM_ElementList*)list)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(list), ((_HDDM_ElementList*)list)->subtype, 1);
   return list;
}

static PyObject*
_Trigger_deleteTriggerEnergySumses(PyObject *self, PyObject *args)
{
   int count=-1;
   int start=0;
   if (! PyArg_ParseTuple(args, "|ii", &count, &start)) {
      return NULL;
   }
   _Trigger *me = (_Trigger*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "delete attempted on invalid trigger element");
      return NULL;
   }
   me->elem->deleteTriggerEnergySumses(count, start);
   Py_INCREF(Py_None);
   return Py_None;
}

static PyObject*
_Trigger_toString(PyObject *self, PyObject *args=0)
{
   _Trigger *me = (_Trigger*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid trigger element");
      return NULL;
   }
   std::string str(me->elem->toString());
   return PyUnicode_FromString(str.c_str());
}

static PyObject*
_Trigger_toXML(PyObject *self, PyObject *args=0)
{
   _Trigger *me = (_Trigger*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid trigger element");
      return NULL;
   }
   std::string str(me->elem->toXML());
   return PyUnicode_FromString(str.c_str());
}

static PyGetSetDef _Trigger_getsetters[] = {
   {(char*)"class",
    (getter)_Trigger_getClass, 0,
    (char*)"class string",
    NULL},
   {(char*)"eventNo",
    (getter)_Trigger_getEventNo, 0,
    (char*)"eventNo value",
    NULL},
   {(char*)"jtag",
    (getter)_Trigger_getJtag, (setter)_Trigger_setJtag,
    (char*)"jtag string",
    NULL},
   {(char*)"l1_fp_trig_bits",
    (getter)_Trigger_getL1_fp_trig_bits, (setter)_Trigger_setL1_fp_trig_bits,
    (char*)"l1_fp_trig_bits value",
    NULL},
   {(char*)"l1_trig_bits",
    (getter)_Trigger_getL1_trig_bits, (setter)_Trigger_setL1_trig_bits,
    (char*)"l1_trig_bits value",
    NULL},
   {(char*)"maxOccurs",
    (getter)_Trigger_getMaxOccurs, 0,
    (char*)"maxOccurs value",
    NULL},
   {(char*)"minOccurs",
    (getter)_Trigger_getMinOccurs, 0,
    (char*)"minOccurs value",
    NULL},
   {(char*)"runNo",
    (getter)_Trigger_getRunNo, 0,
    (char*)"runNo value",
    NULL},
   {(char*)"version",
    (getter)_Trigger_getVersion, 0,
    (char*)"version string",
    NULL},
   {(char*)"xmlns",
    (getter)_Trigger_getXmlns, 0,
    (char*)"xmlns string",
    NULL},
   {NULL}  /* Sentinel */
};

static PyMemberDef _Trigger_members[] = {
   {NULL}  /* Sentinel */
};

static PyMethodDef _Trigger_methods[] = {
   {"addTriggerEnergySumses", _Trigger_addTriggerEnergySumses, METH_VARARGS,
    "extend (or insert into) the list of triggerEnergySums objects for this trigger"},
   {"deleteTriggerEnergySumses", _Trigger_deleteTriggerEnergySumses, METH_VARARGS,
    "delete triggerEnergySums objects for this trigger"},
   {"getTriggerEnergySums", _Trigger_getTriggerEnergySums, METH_VARARGS,
    "get an individual triggerEnergySums object from this trigger"},
   {"getTriggerEnergySumses", _Trigger_getTriggerEnergySumses, METH_NOARGS,
    "get list of triggerEnergySums objects for this trigger"},
   {"toString", _Trigger_toString, METH_NOARGS,
    "show element as a human-readable string"},
   {"toXML", _Trigger_toXML, METH_NOARGS,
    "show element as a XML fragment"},
   {NULL}  /* Sentinel */
};

static PyTypeObject _Trigger_type = {
    PyVarObject_HEAD_INIT(NULL,0)
    "hddm_r.Trigger",         /*tp_name*/
    sizeof(_Trigger),          /*tp_basicsize*/
    0,                         /*tp_itemsize*/
    (destructor)_Trigger_dealloc, /*tp_dealloc*/
    0,                         /*tp_print*/
    0,                         /*tp_getattr*/
    0,                         /*tp_setattr*/
    0,                         /*tp_compare*/
    0,                         /*tp_repr*/
    0,                         /*tp_as_number*/
    0,                         /*tp_as_sequence*/
    0,                         /*tp_as_mapping*/
    0,                         /*tp_hash */
    0,                         /*tp_call*/
    (reprfunc)_Trigger_toString,         /*tp_str*/
    0,                         /*tp_getattro*/
    0,                         /*tp_setattro*/
    0,                         /*tp_as_buffer*/
    Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE, /*tp_flags*/
    "hddm_r trigger element",  /* tp_doc */
    0,                         /* tp_traverse */
    0,                         /* tp_clear */
    0,                         /* tp_richcompare */
    0,                         /* tp_weaklistoffset */
    0,                         /* tp_iter */
    0,                         /* tp_iternext */
    _Trigger_methods,          /* tp_methods */
    _Trigger_members,          /* tp_members */
    _Trigger_getsetters,       /* tp_getset */
    &_HDDM_Element_type,       /* tp_base */
    0,                         /* tp_dict */
    0,                         /* tp_descr_get */
    0,                         /* tp_descr_set */
    0,                         /* tp_dictoffset */
    (initproc)_Trigger_init,   /* tp_init */
    0,                         /* tp_alloc */
    _Trigger_new,              /* tp_new */
};



// wrap element class hddm_r::BcalMatchParams as hddm_r.BcalMatchParams

typedef struct {
   PyObject_HEAD
   BcalMatchParams *elem;
   PyObject *host;
} _BcalMatchParams;

static void
_BcalMatchParams_dealloc(_BcalMatchParams* self)
{
   if (self->elem != 0) {
      LOG_DEALLOC(Py_TYPE(self), 0, self->host == (PyObject*)self);
      if (self->host == (PyObject*)self)
         delete self->elem;
      else
         My_DECREF(self->host);
   }
   Py_TYPE(self)->tp_free((PyObject*)self);
}

static PyObject*
_BcalMatchParams_new(PyTypeObject *type, PyObject *args, PyObject *kwds)
{
   _BcalMatchParams *self;
   self = (_BcalMatchParams*)type->tp_alloc(type, 0);
   if (self != NULL) {
      self->elem = 0;
      self->host = 0;
   }
   return (PyObject*)self;
}

static int
_BcalMatchParams_init(_BcalMatchParams *self, PyObject *args, PyObject *kwds)
{
   PyErr_SetString(PyExc_RuntimeError, "illegal constructor");
   return -1;
}

static PyObject*
_BcalMatchParams_getClass(_BcalMatchParams *self, void *closure)
{
   std::string val(self->elem->getClass());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_BcalMatchParams_getVersion(_BcalMatchParams *self, void *closure)
{
   std::string val(self->elem->getVersion());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_BcalMatchParams_getXmlns(_BcalMatchParams *self, void *closure)
{
   std::string val(self->elem->getXmlns());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_BcalMatchParams_getEventNo(_BcalMatchParams *self, void *closure)
{
   return PyLong_FromLongLong(self->elem->getEventNo());
}

static PyObject*
_BcalMatchParams_getRunNo(_BcalMatchParams *self, void *closure)
{
   return PyLong_FromLong(self->elem->getRunNo());
}

static PyObject*
_BcalMatchParams_getJtag(_BcalMatchParams *self, void *closure)
{
   std::string val(self->elem->getJtag());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_BcalMatchParams_getDeltaphi(_BcalMatchParams *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getDeltaphi());
}

static int
_BcalMatchParams_setDeltaphi(_BcalMatchParams *self, PyObject *value, void *closure)
{
   double var = PyFloat_AsDouble(value);
   if (var == -1 && PyErr_Occurred()) {
      return 1;
   }
   self->elem->setDeltaphi((float)var);
   return 0;
}

static PyObject*
_BcalMatchParams_getDeltaz(_BcalMatchParams *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getDeltaz());
}

static int
_BcalMatchParams_setDeltaz(_BcalMatchParams *self, PyObject *value, void *closure)
{
   double var = PyFloat_AsDouble(value);
   if (var == -1 && PyErr_Occurred()) {
      return 1;
   }
   self->elem->setDeltaz((float)var);
   return 0;
}

static PyObject*
_BcalMatchParams_getDx(_BcalMatchParams *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getDx());
}

static int
_BcalMatchParams_setDx(_BcalMatchParams *self, PyObject *value, void *closure)
{
   double var = PyFloat_AsDouble(value);
   if (var == -1 && PyErr_Occurred()) {
      return 1;
   }
   self->elem->setDx((float)var);
   return 0;
}

static PyObject*
_BcalMatchParams_getLunit(_BcalMatchParams *self, void *closure)
{
   std::string val(self->elem->getLunit());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_BcalMatchParams_getMaxOccurs(_BcalMatchParams *self, void *closure)
{
   std::string val(self->elem->getMaxOccurs());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_BcalMatchParams_getMinOccurs(_BcalMatchParams *self, void *closure)
{
   return PyLong_FromLong(self->elem->getMinOccurs());
}

static PyObject*
_BcalMatchParams_getPathlength(_BcalMatchParams *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getPathlength());
}

static int
_BcalMatchParams_setPathlength(_BcalMatchParams *self, PyObject *value, void *closure)
{
   double var = PyFloat_AsDouble(value);
   if (var == -1 && PyErr_Occurred()) {
      return 1;
   }
   self->elem->setPathlength((float)var);
   return 0;
}

static PyObject*
_BcalMatchParams_getShower(_BcalMatchParams *self, void *closure)
{
   return PyLong_FromLong(self->elem->getShower());
}

static int
_BcalMatchParams_setShower(_BcalMatchParams *self, PyObject *value, void *closure)
{
   long var = PyInt_AsLong(value);
   if (var == -1 && PyErr_Occurred()) {
      return -1;
   }
   self->elem->setShower(var);
   return 0;
}

static PyObject*
_BcalMatchParams_getTflight(_BcalMatchParams *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getTflight());
}

static int
_BcalMatchParams_setTflight(_BcalMatchParams *self, PyObject *value, void *closure)
{
   double var = PyFloat_AsDouble(value);
   if (var == -1 && PyErr_Occurred()) {
      return 1;
   }
   self->elem->setTflight((float)var);
   return 0;
}

static PyObject*
_BcalMatchParams_getTflightvar(_BcalMatchParams *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getTflightvar());
}

static int
_BcalMatchParams_setTflightvar(_BcalMatchParams *self, PyObject *value, void *closure)
{
   double var = PyFloat_AsDouble(value);
   if (var == -1 && PyErr_Occurred()) {
      return 1;
   }
   self->elem->setTflightvar((float)var);
   return 0;
}

static PyObject*
_BcalMatchParams_getTrack(_BcalMatchParams *self, void *closure)
{
   return PyLong_FromLong(self->elem->getTrack());
}

static int
_BcalMatchParams_setTrack(_BcalMatchParams *self, PyObject *value, void *closure)
{
   long var = PyInt_AsLong(value);
   if (var == -1 && PyErr_Occurred()) {
      return -1;
   }
   self->elem->setTrack(var);
   return 0;
}

static PyObject*
_BcalMatchParams_getTunit(_BcalMatchParams *self, void *closure)
{
   std::string val(self->elem->getTunit());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_BcalMatchParams_toString(PyObject *self, PyObject *args=0)
{
   _BcalMatchParams *me = (_BcalMatchParams*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid bcalMatchParams element");
      return NULL;
   }
   std::string str(me->elem->toString());
   return PyUnicode_FromString(str.c_str());
}

static PyObject*
_BcalMatchParams_toXML(PyObject *self, PyObject *args=0)
{
   _BcalMatchParams *me = (_BcalMatchParams*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid bcalMatchParams element");
      return NULL;
   }
   std::string str(me->elem->toXML());
   return PyUnicode_FromString(str.c_str());
}

static PyGetSetDef _BcalMatchParams_getsetters[] = {
   {(char*)"class",
    (getter)_BcalMatchParams_getClass, 0,
    (char*)"class string",
    NULL},
   {(char*)"deltaphi",
    (getter)_BcalMatchParams_getDeltaphi, (setter)_BcalMatchParams_setDeltaphi,
    (char*)"deltaphi value",
    NULL},
   {(char*)"deltaz",
    (getter)_BcalMatchParams_getDeltaz, (setter)_BcalMatchParams_setDeltaz,
    (char*)"deltaz value",
    NULL},
   {(char*)"dx",
    (getter)_BcalMatchParams_getDx, (setter)_BcalMatchParams_setDx,
    (char*)"dx value",
    NULL},
   {(char*)"eventNo",
    (getter)_BcalMatchParams_getEventNo, 0,
    (char*)"eventNo value",
    NULL},
   {(char*)"jtag",
    (getter)_BcalMatchParams_getJtag, 0,
    (char*)"jtag string",
    NULL},
   {(char*)"lunit",
    (getter)_BcalMatchParams_getLunit, 0,
    (char*)"lunit value",
    NULL},
   {(char*)"maxOccurs",
    (getter)_BcalMatchParams_getMaxOccurs, 0,
    (char*)"maxOccurs value",
    NULL},
   {(char*)"minOccurs",
    (getter)_BcalMatchParams_getMinOccurs, 0,
    (char*)"minOccurs value",
    NULL},
   {(char*)"pathlength",
    (getter)_BcalMatchParams_getPathlength, (setter)_BcalMatchParams_setPathlength,
    (char*)"pathlength value",
    NULL},
   {(char*)"runNo",
    (getter)_BcalMatchParams_getRunNo, 0,
    (char*)"runNo value",
    NULL},
   {(char*)"shower",
    (getter)_BcalMatchParams_getShower, (setter)_BcalMatchParams_setShower,
    (char*)"shower value",
    NULL},
   {(char*)"tflight",
    (getter)_BcalMatchParams_getTflight, (setter)_BcalMatchParams_setTflight,
    (char*)"tflight value",
    NULL},
   {(char*)"tflightvar",
    (getter)_BcalMatchParams_getTflightvar, (setter)_BcalMatchParams_setTflightvar,
    (char*)"tflightvar value",
    NULL},
   {(char*)"track",
    (getter)_BcalMatchParams_getTrack, (setter)_BcalMatchParams_setTrack,
    (char*)"track value",
    NULL},
   {(char*)"tunit",
    (getter)_BcalMatchParams_getTunit, 0,
    (char*)"tunit value",
    NULL},
   {(char*)"version",
    (getter)_BcalMatchParams_getVersion, 0,
    (char*)"version string",
    NULL},
   {(char*)"xmlns",
    (getter)_BcalMatchParams_getXmlns, 0,
    (char*)"xmlns string",
    NULL},
   {NULL}  /* Sentinel */
};

static PyMemberDef _BcalMatchParams_members[] = {
   {NULL}  /* Sentinel */
};

static PyMethodDef _BcalMatchParams_methods[] = {
   {"toString", _BcalMatchParams_toString, METH_NOARGS,
    "show element as a human-readable string"},
   {"toXML", _BcalMatchParams_toXML, METH_NOARGS,
    "show element as a XML fragment"},
   {NULL}  /* Sentinel */
};

static PyTypeObject _BcalMatchParams_type = {
    PyVarObject_HEAD_INIT(NULL,0)
    "hddm_r.BcalMatchParams",         /*tp_name*/
    sizeof(_BcalMatchParams),          /*tp_basicsize*/
    0,                         /*tp_itemsize*/
    (destructor)_BcalMatchParams_dealloc, /*tp_dealloc*/
    0,                         /*tp_print*/
    0,                         /*tp_getattr*/
    0,                         /*tp_setattr*/
    0,                         /*tp_compare*/
    0,                         /*tp_repr*/
    0,                         /*tp_as_number*/
    0,                         /*tp_as_sequence*/
    0,                         /*tp_as_mapping*/
    0,                         /*tp_hash */
    0,                         /*tp_call*/
    (reprfunc)_BcalMatchParams_toString,         /*tp_str*/
    0,                         /*tp_getattro*/
    0,                         /*tp_setattro*/
    0,                         /*tp_as_buffer*/
    Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE, /*tp_flags*/
    "hddm_r bcalMatchParams element",  /* tp_doc */
    0,                         /* tp_traverse */
    0,                         /* tp_clear */
    0,                         /* tp_richcompare */
    0,                         /* tp_weaklistoffset */
    0,                         /* tp_iter */
    0,                         /* tp_iternext */
    _BcalMatchParams_methods,          /* tp_methods */
    _BcalMatchParams_members,          /* tp_members */
    _BcalMatchParams_getsetters,       /* tp_getset */
    &_HDDM_Element_type,       /* tp_base */
    0,                         /* tp_dict */
    0,                         /* tp_descr_get */
    0,                         /* tp_descr_set */
    0,                         /* tp_dictoffset */
    (initproc)_BcalMatchParams_init,   /* tp_init */
    0,                         /* tp_alloc */
    _BcalMatchParams_new,              /* tp_new */
};



// wrap element class hddm_r::FcalEnergyParams as hddm_r.FcalEnergyParams

typedef struct {
   PyObject_HEAD
   FcalEnergyParams *elem;
   PyObject *host;
} _FcalEnergyParams;

static void
_FcalEnergyParams_dealloc(_FcalEnergyParams* self)
{
   if (self->elem != 0) {
      LOG_DEALLOC(Py_TYPE(self), 0, self->host == (PyObject*)self);
      if (self->host == (PyObject*)self)
         delete self->elem;
      else
         My_DECREF(self->host);
   }
   Py_TYPE(self)->tp_free((PyObject*)self);
}

static PyObject*
_FcalEnergyParams_new(PyTypeObject *type, PyObject *args, PyObject *kwds)
{
   _FcalEnergyParams *self;
   self = (_FcalEnergyParams*)type->tp_alloc(type, 0);
   if (self != NULL) {
      self->elem = 0;
      self->host = 0;
   }
   return (PyObject*)self;
}

static int
_FcalEnergyParams_init(_FcalEnergyParams *self, PyObject *args, PyObject *kwds)
{
   PyErr_SetString(PyExc_RuntimeError, "illegal constructor");
   return -1;
}

static PyObject*
_FcalEnergyParams_getClass(_FcalEnergyParams *self, void *closure)
{
   std::string val(self->elem->getClass());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_FcalEnergyParams_getVersion(_FcalEnergyParams *self, void *closure)
{
   std::string val(self->elem->getVersion());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_FcalEnergyParams_getXmlns(_FcalEnergyParams *self, void *closure)
{
   std::string val(self->elem->getXmlns());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_FcalEnergyParams_getEventNo(_FcalEnergyParams *self, void *closure)
{
   return PyLong_FromLongLong(self->elem->getEventNo());
}

static PyObject*
_FcalEnergyParams_getRunNo(_FcalEnergyParams *self, void *closure)
{
   return PyLong_FromLong(self->elem->getRunNo());
}

static PyObject*
_FcalEnergyParams_getJtag(_FcalEnergyParams *self, void *closure)
{
   std::string val(self->elem->getJtag());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_FcalEnergyParams_getDoca(_FcalEnergyParams *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getDoca());
}

static PyObject*
_FcalEnergyParams_getDx(_FcalEnergyParams *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getDx());
}

static PyObject*
_FcalEnergyParams_getLunit(_FcalEnergyParams *self, void *closure)
{
   std::string val(self->elem->getLunit());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_FcalEnergyParams_getPathlength(_FcalEnergyParams *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getPathlength());
}

static PyObject*
_FcalEnergyParams_getShower(_FcalEnergyParams *self, void *closure)
{
   return PyLong_FromLong(self->elem->getShower());
}

static PyObject*
_FcalEnergyParams_getTflight(_FcalEnergyParams *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getTflight());
}

static PyObject*
_FcalEnergyParams_getTflightvar(_FcalEnergyParams *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getTflightvar());
}

static PyObject*
_FcalEnergyParams_getTrack(_FcalEnergyParams *self, void *closure)
{
   return PyLong_FromLong(self->elem->getTrack());
}

static PyObject*
_FcalEnergyParams_getTunit(_FcalEnergyParams *self, void *closure)
{
   std::string val(self->elem->getTunit());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_FcalEnergyParams_getE3x3(_FcalEnergyParams *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getE3x3());
}

static int
_FcalEnergyParams_setE3x3(_FcalEnergyParams *self, PyObject *value, void *closure)
{
   double var = PyFloat_AsDouble(value);
   if (var == -1 && PyErr_Occurred()) {
      return 1;
   }
   self->elem->setE3x3((float)var);
   return 0;
}

static PyObject*
_FcalEnergyParams_getE5x5(_FcalEnergyParams *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getE5x5());
}

static int
_FcalEnergyParams_setE5x5(_FcalEnergyParams *self, PyObject *value, void *closure)
{
   double var = PyFloat_AsDouble(value);
   if (var == -1 && PyErr_Occurred()) {
      return 1;
   }
   self->elem->setE5x5((float)var);
   return 0;
}

static PyObject*
_FcalEnergyParams_getEcenter(_FcalEnergyParams *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getEcenter());
}

static int
_FcalEnergyParams_setEcenter(_FcalEnergyParams *self, PyObject *value, void *closure)
{
   double var = PyFloat_AsDouble(value);
   if (var == -1 && PyErr_Occurred()) {
      return 1;
   }
   self->elem->setEcenter((float)var);
   return 0;
}

static PyObject*
_FcalEnergyParams_getMaxOccurs(_FcalEnergyParams *self, void *closure)
{
   return PyLong_FromLong(self->elem->getMaxOccurs());
}

static PyObject*
_FcalEnergyParams_getMinOccurs(_FcalEnergyParams *self, void *closure)
{
   return PyLong_FromLong(self->elem->getMinOccurs());
}

static PyObject*
_FcalEnergyParams_toString(PyObject *self, PyObject *args=0)
{
   _FcalEnergyParams *me = (_FcalEnergyParams*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid fcalEnergyParams element");
      return NULL;
   }
   std::string str(me->elem->toString());
   return PyUnicode_FromString(str.c_str());
}

static PyObject*
_FcalEnergyParams_toXML(PyObject *self, PyObject *args=0)
{
   _FcalEnergyParams *me = (_FcalEnergyParams*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid fcalEnergyParams element");
      return NULL;
   }
   std::string str(me->elem->toXML());
   return PyUnicode_FromString(str.c_str());
}

static PyGetSetDef _FcalEnergyParams_getsetters[] = {
   {(char*)"E3x3",
    (getter)_FcalEnergyParams_getE3x3, (setter)_FcalEnergyParams_setE3x3,
    (char*)"E3x3 value",
    NULL},
   {(char*)"E5x5",
    (getter)_FcalEnergyParams_getE5x5, (setter)_FcalEnergyParams_setE5x5,
    (char*)"E5x5 value",
    NULL},
   {(char*)"Ecenter",
    (getter)_FcalEnergyParams_getEcenter, (setter)_FcalEnergyParams_setEcenter,
    (char*)"Ecenter value",
    NULL},
   {(char*)"class",
    (getter)_FcalEnergyParams_getClass, 0,
    (char*)"class string",
    NULL},
   {(char*)"doca",
    (getter)_FcalEnergyParams_getDoca, 0,
    (char*)"doca value",
    NULL},
   {(char*)"dx",
    (getter)_FcalEnergyParams_getDx, 0,
    (char*)"dx value",
    NULL},
   {(char*)"eventNo",
    (getter)_FcalEnergyParams_getEventNo, 0,
    (char*)"eventNo value",
    NULL},
   {(char*)"jtag",
    (getter)_FcalEnergyParams_getJtag, 0,
    (char*)"jtag string",
    NULL},
   {(char*)"lunit",
    (getter)_FcalEnergyParams_getLunit, 0,
    (char*)"lunit string",
    NULL},
   {(char*)"maxOccurs",
    (getter)_FcalEnergyParams_getMaxOccurs, 0,
    (char*)"maxOccurs value",
    NULL},
   {(char*)"minOccurs",
    (getter)_FcalEnergyParams_getMinOccurs, 0,
    (char*)"minOccurs value",
    NULL},
   {(char*)"pathlength",
    (getter)_FcalEnergyParams_getPathlength, 0,
    (char*)"pathlength value",
    NULL},
   {(char*)"runNo",
    (getter)_FcalEnergyParams_getRunNo, 0,
    (char*)"runNo value",
    NULL},
   {(char*)"shower",
    (getter)_FcalEnergyParams_getShower, 0,
    (char*)"shower value",
    NULL},
   {(char*)"tflight",
    (getter)_FcalEnergyParams_getTflight, 0,
    (char*)"tflight value",
    NULL},
   {(char*)"tflightvar",
    (getter)_FcalEnergyParams_getTflightvar, 0,
    (char*)"tflightvar value",
    NULL},
   {(char*)"track",
    (getter)_FcalEnergyParams_getTrack, 0,
    (char*)"track value",
    NULL},
   {(char*)"tunit",
    (getter)_FcalEnergyParams_getTunit, 0,
    (char*)"tunit string",
    NULL},
   {(char*)"version",
    (getter)_FcalEnergyParams_getVersion, 0,
    (char*)"version string",
    NULL},
   {(char*)"xmlns",
    (getter)_FcalEnergyParams_getXmlns, 0,
    (char*)"xmlns string",
    NULL},
   {NULL}  /* Sentinel */
};

static PyMemberDef _FcalEnergyParams_members[] = {
   {NULL}  /* Sentinel */
};

static PyMethodDef _FcalEnergyParams_methods[] = {
   {"toString", _FcalEnergyParams_toString, METH_NOARGS,
    "show element as a human-readable string"},
   {"toXML", _FcalEnergyParams_toXML, METH_NOARGS,
    "show element as a XML fragment"},
   {NULL}  /* Sentinel */
};

static PyTypeObject _FcalEnergyParams_type = {
    PyVarObject_HEAD_INIT(NULL,0)
    "hddm_r.FcalEnergyParams",         /*tp_name*/
    sizeof(_FcalEnergyParams),          /*tp_basicsize*/
    0,                         /*tp_itemsize*/
    (destructor)_FcalEnergyParams_dealloc, /*tp_dealloc*/
    0,                         /*tp_print*/
    0,                         /*tp_getattr*/
    0,                         /*tp_setattr*/
    0,                         /*tp_compare*/
    0,                         /*tp_repr*/
    0,                         /*tp_as_number*/
    0,                         /*tp_as_sequence*/
    0,                         /*tp_as_mapping*/
    0,                         /*tp_hash */
    0,                         /*tp_call*/
    (reprfunc)_FcalEnergyParams_toString,         /*tp_str*/
    0,                         /*tp_getattro*/
    0,                         /*tp_setattro*/
    0,                         /*tp_as_buffer*/
    Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE, /*tp_flags*/
    "hddm_r fcalEnergyParams element",  /* tp_doc */
    0,                         /* tp_traverse */
    0,                         /* tp_clear */
    0,                         /* tp_richcompare */
    0,                         /* tp_weaklistoffset */
    0,                         /* tp_iter */
    0,                         /* tp_iternext */
    _FcalEnergyParams_methods,          /* tp_methods */
    _FcalEnergyParams_members,          /* tp_members */
    _FcalEnergyParams_getsetters,       /* tp_getset */
    &_HDDM_Element_type,       /* tp_base */
    0,                         /* tp_dict */
    0,                         /* tp_descr_get */
    0,                         /* tp_descr_set */
    0,                         /* tp_dictoffset */
    (initproc)_FcalEnergyParams_init,   /* tp_init */
    0,                         /* tp_alloc */
    _FcalEnergyParams_new,              /* tp_new */
};



// wrap element class hddm_r::FcalMatchParams as hddm_r.FcalMatchParams

typedef struct {
   PyObject_HEAD
   FcalMatchParams *elem;
   PyObject *host;
} _FcalMatchParams;

static void
_FcalMatchParams_dealloc(_FcalMatchParams* self)
{
   if (self->elem != 0) {
      LOG_DEALLOC(Py_TYPE(self), 0, self->host == (PyObject*)self);
      if (self->host == (PyObject*)self)
         delete self->elem;
      else
         My_DECREF(self->host);
   }
   Py_TYPE(self)->tp_free((PyObject*)self);
}

static PyObject*
_FcalMatchParams_new(PyTypeObject *type, PyObject *args, PyObject *kwds)
{
   _FcalMatchParams *self;
   self = (_FcalMatchParams*)type->tp_alloc(type, 0);
   if (self != NULL) {
      self->elem = 0;
      self->host = 0;
   }
   return (PyObject*)self;
}

static int
_FcalMatchParams_init(_FcalMatchParams *self, PyObject *args, PyObject *kwds)
{
   PyErr_SetString(PyExc_RuntimeError, "illegal constructor");
   return -1;
}

static PyObject*
_FcalMatchParams_getClass(_FcalMatchParams *self, void *closure)
{
   std::string val(self->elem->getClass());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_FcalMatchParams_getVersion(_FcalMatchParams *self, void *closure)
{
   std::string val(self->elem->getVersion());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_FcalMatchParams_getXmlns(_FcalMatchParams *self, void *closure)
{
   std::string val(self->elem->getXmlns());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_FcalMatchParams_getEventNo(_FcalMatchParams *self, void *closure)
{
   return PyLong_FromLongLong(self->elem->getEventNo());
}

static PyObject*
_FcalMatchParams_getRunNo(_FcalMatchParams *self, void *closure)
{
   return PyLong_FromLong(self->elem->getRunNo());
}

static PyObject*
_FcalMatchParams_getJtag(_FcalMatchParams *self, void *closure)
{
   std::string val(self->elem->getJtag());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_FcalMatchParams_getDoca(_FcalMatchParams *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getDoca());
}

static int
_FcalMatchParams_setDoca(_FcalMatchParams *self, PyObject *value, void *closure)
{
   double var = PyFloat_AsDouble(value);
   if (var == -1 && PyErr_Occurred()) {
      return 1;
   }
   self->elem->setDoca((float)var);
   return 0;
}

static PyObject*
_FcalMatchParams_getDx(_FcalMatchParams *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getDx());
}

static int
_FcalMatchParams_setDx(_FcalMatchParams *self, PyObject *value, void *closure)
{
   double var = PyFloat_AsDouble(value);
   if (var == -1 && PyErr_Occurred()) {
      return 1;
   }
   self->elem->setDx((float)var);
   return 0;
}

static PyObject*
_FcalMatchParams_getLunit(_FcalMatchParams *self, void *closure)
{
   std::string val(self->elem->getLunit());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_FcalMatchParams_getMaxOccurs(_FcalMatchParams *self, void *closure)
{
   std::string val(self->elem->getMaxOccurs());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_FcalMatchParams_getMinOccurs(_FcalMatchParams *self, void *closure)
{
   return PyLong_FromLong(self->elem->getMinOccurs());
}

static PyObject*
_FcalMatchParams_getPathlength(_FcalMatchParams *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getPathlength());
}

static int
_FcalMatchParams_setPathlength(_FcalMatchParams *self, PyObject *value, void *closure)
{
   double var = PyFloat_AsDouble(value);
   if (var == -1 && PyErr_Occurred()) {
      return 1;
   }
   self->elem->setPathlength((float)var);
   return 0;
}

static PyObject*
_FcalMatchParams_getShower(_FcalMatchParams *self, void *closure)
{
   return PyLong_FromLong(self->elem->getShower());
}

static int
_FcalMatchParams_setShower(_FcalMatchParams *self, PyObject *value, void *closure)
{
   long var = PyInt_AsLong(value);
   if (var == -1 && PyErr_Occurred()) {
      return -1;
   }
   self->elem->setShower(var);
   return 0;
}

static PyObject*
_FcalMatchParams_getTflight(_FcalMatchParams *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getTflight());
}

static int
_FcalMatchParams_setTflight(_FcalMatchParams *self, PyObject *value, void *closure)
{
   double var = PyFloat_AsDouble(value);
   if (var == -1 && PyErr_Occurred()) {
      return 1;
   }
   self->elem->setTflight((float)var);
   return 0;
}

static PyObject*
_FcalMatchParams_getTflightvar(_FcalMatchParams *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getTflightvar());
}

static int
_FcalMatchParams_setTflightvar(_FcalMatchParams *self, PyObject *value, void *closure)
{
   double var = PyFloat_AsDouble(value);
   if (var == -1 && PyErr_Occurred()) {
      return 1;
   }
   self->elem->setTflightvar((float)var);
   return 0;
}

static PyObject*
_FcalMatchParams_getTrack(_FcalMatchParams *self, void *closure)
{
   return PyLong_FromLong(self->elem->getTrack());
}

static int
_FcalMatchParams_setTrack(_FcalMatchParams *self, PyObject *value, void *closure)
{
   long var = PyInt_AsLong(value);
   if (var == -1 && PyErr_Occurred()) {
      return -1;
   }
   self->elem->setTrack(var);
   return 0;
}

static PyObject*
_FcalMatchParams_getTunit(_FcalMatchParams *self, void *closure)
{
   std::string val(self->elem->getTunit());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_FcalMatchParams_getFcalEnergyParams(PyObject *self, PyObject *args)
{
   int index=0;
   if (! PyArg_ParseTuple(args, "|i", &index)) {
      return NULL;
   }
   _FcalMatchParams *me = (_FcalMatchParams*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid fcalMatchParams element");
      return NULL;
   }
   PyObject *obj = _FcalEnergyParams_new(&_FcalEnergyParams_type, 0, 0);
   ((_FcalEnergyParams*)obj)->elem = &me->elem->getFcalEnergyParams();
   ((_FcalEnergyParams*)obj)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(obj));
   return obj;
}

static PyObject*
_FcalMatchParams_getFcalEnergyParamses(PyObject *self, PyObject *args)
{
   _FcalMatchParams *me = (_FcalMatchParams*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid fcalMatchParams element");
      return NULL;
   }
   PyObject *list = _HDDM_ElementList_new(&_HDDM_ElementList_type, 0, 0);
   ((_HDDM_ElementList*)list)->subtype = &_FcalEnergyParams_type;
   ((_HDDM_ElementList*)list)->list = (HDDM_ElementList<HDDM_Element>*)
    &me->elem->getFcalEnergyParamses();
   ((_HDDM_ElementList*)list)->borrowed = 1;
   ((_HDDM_ElementList*)list)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(list), ((_HDDM_ElementList*)list)->subtype, 0);
   return list;
}

static PyObject*
_FcalMatchParams_addFcalEnergyParamses(PyObject *self, PyObject *args)
{
   int count=1;
   int start=-1;
   if (! PyArg_ParseTuple(args, "|ii", &count, &start)) {
      return NULL;
   }
   _FcalMatchParams *me = (_FcalMatchParams*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "add attempted on invalid fcalMatchParams element");
      return NULL;
   }
   PyObject *list = _HDDM_ElementList_new(&_HDDM_ElementList_type, 0, 0);
   ((_HDDM_ElementList*)list)->subtype = &_FcalEnergyParams_type;
   ((_HDDM_ElementList*)list)->list = (HDDM_ElementList<HDDM_Element>*)
    new FcalEnergyParamsList(me->elem->addFcalEnergyParamses(count, start));
   ((_HDDM_ElementList*)list)->borrowed = 0;
   ((_HDDM_ElementList*)list)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(list), ((_HDDM_ElementList*)list)->subtype, 1);
   return list;
}

static PyObject*
_FcalMatchParams_deleteFcalEnergyParamses(PyObject *self, PyObject *args)
{
   int count=-1;
   int start=0;
   if (! PyArg_ParseTuple(args, "|ii", &count, &start)) {
      return NULL;
   }
   _FcalMatchParams *me = (_FcalMatchParams*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "delete attempted on invalid fcalMatchParams element");
      return NULL;
   }
   me->elem->deleteFcalEnergyParamses(count, start);
   Py_INCREF(Py_None);
   return Py_None;
}

static PyObject*
_FcalMatchParams_toString(PyObject *self, PyObject *args=0)
{
   _FcalMatchParams *me = (_FcalMatchParams*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid fcalMatchParams element");
      return NULL;
   }
   std::string str(me->elem->toString());
   return PyUnicode_FromString(str.c_str());
}

static PyObject*
_FcalMatchParams_toXML(PyObject *self, PyObject *args=0)
{
   _FcalMatchParams *me = (_FcalMatchParams*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid fcalMatchParams element");
      return NULL;
   }
   std::string str(me->elem->toXML());
   return PyUnicode_FromString(str.c_str());
}

static PyGetSetDef _FcalMatchParams_getsetters[] = {
   {(char*)"class",
    (getter)_FcalMatchParams_getClass, 0,
    (char*)"class string",
    NULL},
   {(char*)"doca",
    (getter)_FcalMatchParams_getDoca, (setter)_FcalMatchParams_setDoca,
    (char*)"doca value",
    NULL},
   {(char*)"dx",
    (getter)_FcalMatchParams_getDx, (setter)_FcalMatchParams_setDx,
    (char*)"dx value",
    NULL},
   {(char*)"eventNo",
    (getter)_FcalMatchParams_getEventNo, 0,
    (char*)"eventNo value",
    NULL},
   {(char*)"jtag",
    (getter)_FcalMatchParams_getJtag, 0,
    (char*)"jtag string",
    NULL},
   {(char*)"lunit",
    (getter)_FcalMatchParams_getLunit, 0,
    (char*)"lunit value",
    NULL},
   {(char*)"maxOccurs",
    (getter)_FcalMatchParams_getMaxOccurs, 0,
    (char*)"maxOccurs value",
    NULL},
   {(char*)"minOccurs",
    (getter)_FcalMatchParams_getMinOccurs, 0,
    (char*)"minOccurs value",
    NULL},
   {(char*)"pathlength",
    (getter)_FcalMatchParams_getPathlength, (setter)_FcalMatchParams_setPathlength,
    (char*)"pathlength value",
    NULL},
   {(char*)"runNo",
    (getter)_FcalMatchParams_getRunNo, 0,
    (char*)"runNo value",
    NULL},
   {(char*)"shower",
    (getter)_FcalMatchParams_getShower, (setter)_FcalMatchParams_setShower,
    (char*)"shower value",
    NULL},
   {(char*)"tflight",
    (getter)_FcalMatchParams_getTflight, (setter)_FcalMatchParams_setTflight,
    (char*)"tflight value",
    NULL},
   {(char*)"tflightvar",
    (getter)_FcalMatchParams_getTflightvar, (setter)_FcalMatchParams_setTflightvar,
    (char*)"tflightvar value",
    NULL},
   {(char*)"track",
    (getter)_FcalMatchParams_getTrack, (setter)_FcalMatchParams_setTrack,
    (char*)"track value",
    NULL},
   {(char*)"tunit",
    (getter)_FcalMatchParams_getTunit, 0,
    (char*)"tunit value",
    NULL},
   {(char*)"version",
    (getter)_FcalMatchParams_getVersion, 0,
    (char*)"version string",
    NULL},
   {(char*)"xmlns",
    (getter)_FcalMatchParams_getXmlns, 0,
    (char*)"xmlns string",
    NULL},
   {NULL}  /* Sentinel */
};

static PyMemberDef _FcalMatchParams_members[] = {
   {NULL}  /* Sentinel */
};

static PyMethodDef _FcalMatchParams_methods[] = {
   {"addFcalEnergyParamses", _FcalMatchParams_addFcalEnergyParamses, METH_VARARGS,
    "extend (or insert into) the list of fcalEnergyParams objects for this fcalMatchParams"},
   {"deleteFcalEnergyParamses", _FcalMatchParams_deleteFcalEnergyParamses, METH_VARARGS,
    "delete fcalEnergyParams objects for this fcalMatchParams"},
   {"getFcalEnergyParams", _FcalMatchParams_getFcalEnergyParams, METH_VARARGS,
    "get an individual fcalEnergyParams object from this fcalMatchParams"},
   {"getFcalEnergyParamses", _FcalMatchParams_getFcalEnergyParamses, METH_NOARGS,
    "get list of fcalEnergyParams objects for this fcalMatchParams"},
   {"toString", _FcalMatchParams_toString, METH_NOARGS,
    "show element as a human-readable string"},
   {"toXML", _FcalMatchParams_toXML, METH_NOARGS,
    "show element as a XML fragment"},
   {NULL}  /* Sentinel */
};

static PyTypeObject _FcalMatchParams_type = {
    PyVarObject_HEAD_INIT(NULL,0)
    "hddm_r.FcalMatchParams",         /*tp_name*/
    sizeof(_FcalMatchParams),          /*tp_basicsize*/
    0,                         /*tp_itemsize*/
    (destructor)_FcalMatchParams_dealloc, /*tp_dealloc*/
    0,                         /*tp_print*/
    0,                         /*tp_getattr*/
    0,                         /*tp_setattr*/
    0,                         /*tp_compare*/
    0,                         /*tp_repr*/
    0,                         /*tp_as_number*/
    0,                         /*tp_as_sequence*/
    0,                         /*tp_as_mapping*/
    0,                         /*tp_hash */
    0,                         /*tp_call*/
    (reprfunc)_FcalMatchParams_toString,         /*tp_str*/
    0,                         /*tp_getattro*/
    0,                         /*tp_setattro*/
    0,                         /*tp_as_buffer*/
    Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE, /*tp_flags*/
    "hddm_r fcalMatchParams element",  /* tp_doc */
    0,                         /* tp_traverse */
    0,                         /* tp_clear */
    0,                         /* tp_richcompare */
    0,                         /* tp_weaklistoffset */
    0,                         /* tp_iter */
    0,                         /* tp_iternext */
    _FcalMatchParams_methods,          /* tp_methods */
    _FcalMatchParams_members,          /* tp_members */
    _FcalMatchParams_getsetters,       /* tp_getset */
    &_HDDM_Element_type,       /* tp_base */
    0,                         /* tp_dict */
    0,                         /* tp_descr_get */
    0,                         /* tp_descr_set */
    0,                         /* tp_dictoffset */
    (initproc)_FcalMatchParams_init,   /* tp_init */
    0,                         /* tp_alloc */
    _FcalMatchParams_new,              /* tp_new */
};



// wrap element class hddm_r::FcalSingleHitMatchParams as hddm_r.FcalSingleHitMatchParams

typedef struct {
   PyObject_HEAD
   FcalSingleHitMatchParams *elem;
   PyObject *host;
} _FcalSingleHitMatchParams;

static void
_FcalSingleHitMatchParams_dealloc(_FcalSingleHitMatchParams* self)
{
   if (self->elem != 0) {
      LOG_DEALLOC(Py_TYPE(self), 0, self->host == (PyObject*)self);
      if (self->host == (PyObject*)self)
         delete self->elem;
      else
         My_DECREF(self->host);
   }
   Py_TYPE(self)->tp_free((PyObject*)self);
}

static PyObject*
_FcalSingleHitMatchParams_new(PyTypeObject *type, PyObject *args, PyObject *kwds)
{
   _FcalSingleHitMatchParams *self;
   self = (_FcalSingleHitMatchParams*)type->tp_alloc(type, 0);
   if (self != NULL) {
      self->elem = 0;
      self->host = 0;
   }
   return (PyObject*)self;
}

static int
_FcalSingleHitMatchParams_init(_FcalSingleHitMatchParams *self, PyObject *args, PyObject *kwds)
{
   PyErr_SetString(PyExc_RuntimeError, "illegal constructor");
   return -1;
}

static PyObject*
_FcalSingleHitMatchParams_getClass(_FcalSingleHitMatchParams *self, void *closure)
{
   std::string val(self->elem->getClass());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_FcalSingleHitMatchParams_getVersion(_FcalSingleHitMatchParams *self, void *closure)
{
   std::string val(self->elem->getVersion());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_FcalSingleHitMatchParams_getXmlns(_FcalSingleHitMatchParams *self, void *closure)
{
   std::string val(self->elem->getXmlns());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_FcalSingleHitMatchParams_getEventNo(_FcalSingleHitMatchParams *self, void *closure)
{
   return PyLong_FromLongLong(self->elem->getEventNo());
}

static PyObject*
_FcalSingleHitMatchParams_getRunNo(_FcalSingleHitMatchParams *self, void *closure)
{
   return PyLong_FromLong(self->elem->getRunNo());
}

static PyObject*
_FcalSingleHitMatchParams_getJtag(_FcalSingleHitMatchParams *self, void *closure)
{
   std::string val(self->elem->getJtag());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_FcalSingleHitMatchParams_getDoca(_FcalSingleHitMatchParams *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getDoca());
}

static int
_FcalSingleHitMatchParams_setDoca(_FcalSingleHitMatchParams *self, PyObject *value, void *closure)
{
   double var = PyFloat_AsDouble(value);
   if (var == -1 && PyErr_Occurred()) {
      return 1;
   }
   self->elem->setDoca((float)var);
   return 0;
}

static PyObject*
_FcalSingleHitMatchParams_getDx(_FcalSingleHitMatchParams *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getDx());
}

static int
_FcalSingleHitMatchParams_setDx(_FcalSingleHitMatchParams *self, PyObject *value, void *closure)
{
   double var = PyFloat_AsDouble(value);
   if (var == -1 && PyErr_Occurred()) {
      return 1;
   }
   self->elem->setDx((float)var);
   return 0;
}

static PyObject*
_FcalSingleHitMatchParams_getEhit(_FcalSingleHitMatchParams *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getEhit());
}

static int
_FcalSingleHitMatchParams_setEhit(_FcalSingleHitMatchParams *self, PyObject *value, void *closure)
{
   double var = PyFloat_AsDouble(value);
   if (var == -1 && PyErr_Occurred()) {
      return 1;
   }
   self->elem->setEhit((float)var);
   return 0;
}

static PyObject*
_FcalSingleHitMatchParams_getLunit(_FcalSingleHitMatchParams *self, void *closure)
{
   std::string val(self->elem->getLunit());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_FcalSingleHitMatchParams_getMaxOccurs(_FcalSingleHitMatchParams *self, void *closure)
{
   std::string val(self->elem->getMaxOccurs());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_FcalSingleHitMatchParams_getMinOccurs(_FcalSingleHitMatchParams *self, void *closure)
{
   return PyLong_FromLong(self->elem->getMinOccurs());
}

static PyObject*
_FcalSingleHitMatchParams_getPathlength(_FcalSingleHitMatchParams *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getPathlength());
}

static int
_FcalSingleHitMatchParams_setPathlength(_FcalSingleHitMatchParams *self, PyObject *value, void *closure)
{
   double var = PyFloat_AsDouble(value);
   if (var == -1 && PyErr_Occurred()) {
      return 1;
   }
   self->elem->setPathlength((float)var);
   return 0;
}

static PyObject*
_FcalSingleHitMatchParams_getTflight(_FcalSingleHitMatchParams *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getTflight());
}

static int
_FcalSingleHitMatchParams_setTflight(_FcalSingleHitMatchParams *self, PyObject *value, void *closure)
{
   double var = PyFloat_AsDouble(value);
   if (var == -1 && PyErr_Occurred()) {
      return 1;
   }
   self->elem->setTflight((float)var);
   return 0;
}

static PyObject*
_FcalSingleHitMatchParams_getTflightvar(_FcalSingleHitMatchParams *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getTflightvar());
}

static int
_FcalSingleHitMatchParams_setTflightvar(_FcalSingleHitMatchParams *self, PyObject *value, void *closure)
{
   double var = PyFloat_AsDouble(value);
   if (var == -1 && PyErr_Occurred()) {
      return 1;
   }
   self->elem->setTflightvar((float)var);
   return 0;
}

static PyObject*
_FcalSingleHitMatchParams_getThit(_FcalSingleHitMatchParams *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getThit());
}

static int
_FcalSingleHitMatchParams_setThit(_FcalSingleHitMatchParams *self, PyObject *value, void *closure)
{
   double var = PyFloat_AsDouble(value);
   if (var == -1 && PyErr_Occurred()) {
      return 1;
   }
   self->elem->setThit((float)var);
   return 0;
}

static PyObject*
_FcalSingleHitMatchParams_getTrack(_FcalSingleHitMatchParams *self, void *closure)
{
   return PyLong_FromLong(self->elem->getTrack());
}

static int
_FcalSingleHitMatchParams_setTrack(_FcalSingleHitMatchParams *self, PyObject *value, void *closure)
{
   long var = PyInt_AsLong(value);
   if (var == -1 && PyErr_Occurred()) {
      return -1;
   }
   self->elem->setTrack(var);
   return 0;
}

static PyObject*
_FcalSingleHitMatchParams_getTunit(_FcalSingleHitMatchParams *self, void *closure)
{
   std::string val(self->elem->getTunit());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_FcalSingleHitMatchParams_toString(PyObject *self, PyObject *args=0)
{
   _FcalSingleHitMatchParams *me = (_FcalSingleHitMatchParams*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid fcalSingleHitMatchParams element");
      return NULL;
   }
   std::string str(me->elem->toString());
   return PyUnicode_FromString(str.c_str());
}

static PyObject*
_FcalSingleHitMatchParams_toXML(PyObject *self, PyObject *args=0)
{
   _FcalSingleHitMatchParams *me = (_FcalSingleHitMatchParams*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid fcalSingleHitMatchParams element");
      return NULL;
   }
   std::string str(me->elem->toXML());
   return PyUnicode_FromString(str.c_str());
}

static PyGetSetDef _FcalSingleHitMatchParams_getsetters[] = {
   {(char*)"class",
    (getter)_FcalSingleHitMatchParams_getClass, 0,
    (char*)"class string",
    NULL},
   {(char*)"doca",
    (getter)_FcalSingleHitMatchParams_getDoca, (setter)_FcalSingleHitMatchParams_setDoca,
    (char*)"doca value",
    NULL},
   {(char*)"dx",
    (getter)_FcalSingleHitMatchParams_getDx, (setter)_FcalSingleHitMatchParams_setDx,
    (char*)"dx value",
    NULL},
   {(char*)"ehit",
    (getter)_FcalSingleHitMatchParams_getEhit, (setter)_FcalSingleHitMatchParams_setEhit,
    (char*)"ehit value",
    NULL},
   {(char*)"eventNo",
    (getter)_FcalSingleHitMatchParams_getEventNo, 0,
    (char*)"eventNo value",
    NULL},
   {(char*)"jtag",
    (getter)_FcalSingleHitMatchParams_getJtag, 0,
    (char*)"jtag string",
    NULL},
   {(char*)"lunit",
    (getter)_FcalSingleHitMatchParams_getLunit, 0,
    (char*)"lunit value",
    NULL},
   {(char*)"maxOccurs",
    (getter)_FcalSingleHitMatchParams_getMaxOccurs, 0,
    (char*)"maxOccurs value",
    NULL},
   {(char*)"minOccurs",
    (getter)_FcalSingleHitMatchParams_getMinOccurs, 0,
    (char*)"minOccurs value",
    NULL},
   {(char*)"pathlength",
    (getter)_FcalSingleHitMatchParams_getPathlength, (setter)_FcalSingleHitMatchParams_setPathlength,
    (char*)"pathlength value",
    NULL},
   {(char*)"runNo",
    (getter)_FcalSingleHitMatchParams_getRunNo, 0,
    (char*)"runNo value",
    NULL},
   {(char*)"tflight",
    (getter)_FcalSingleHitMatchParams_getTflight, (setter)_FcalSingleHitMatchParams_setTflight,
    (char*)"tflight value",
    NULL},
   {(char*)"tflightvar",
    (getter)_FcalSingleHitMatchParams_getTflightvar, (setter)_FcalSingleHitMatchParams_setTflightvar,
    (char*)"tflightvar value",
    NULL},
   {(char*)"thit",
    (getter)_FcalSingleHitMatchParams_getThit, (setter)_FcalSingleHitMatchParams_setThit,
    (char*)"thit value",
    NULL},
   {(char*)"track",
    (getter)_FcalSingleHitMatchParams_getTrack, (setter)_FcalSingleHitMatchParams_setTrack,
    (char*)"track value",
    NULL},
   {(char*)"tunit",
    (getter)_FcalSingleHitMatchParams_getTunit, 0,
    (char*)"tunit value",
    NULL},
   {(char*)"version",
    (getter)_FcalSingleHitMatchParams_getVersion, 0,
    (char*)"version string",
    NULL},
   {(char*)"xmlns",
    (getter)_FcalSingleHitMatchParams_getXmlns, 0,
    (char*)"xmlns string",
    NULL},
   {NULL}  /* Sentinel */
};

static PyMemberDef _FcalSingleHitMatchParams_members[] = {
   {NULL}  /* Sentinel */
};

static PyMethodDef _FcalSingleHitMatchParams_methods[] = {
   {"toString", _FcalSingleHitMatchParams_toString, METH_NOARGS,
    "show element as a human-readable string"},
   {"toXML", _FcalSingleHitMatchParams_toXML, METH_NOARGS,
    "show element as a XML fragment"},
   {NULL}  /* Sentinel */
};

static PyTypeObject _FcalSingleHitMatchParams_type = {
    PyVarObject_HEAD_INIT(NULL,0)
    "hddm_r.FcalSingleHitMatchParams",         /*tp_name*/
    sizeof(_FcalSingleHitMatchParams),          /*tp_basicsize*/
    0,                         /*tp_itemsize*/
    (destructor)_FcalSingleHitMatchParams_dealloc, /*tp_dealloc*/
    0,                         /*tp_print*/
    0,                         /*tp_getattr*/
    0,                         /*tp_setattr*/
    0,                         /*tp_compare*/
    0,                         /*tp_repr*/
    0,                         /*tp_as_number*/
    0,                         /*tp_as_sequence*/
    0,                         /*tp_as_mapping*/
    0,                         /*tp_hash */
    0,                         /*tp_call*/
    (reprfunc)_FcalSingleHitMatchParams_toString,         /*tp_str*/
    0,                         /*tp_getattro*/
    0,                         /*tp_setattro*/
    0,                         /*tp_as_buffer*/
    Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE, /*tp_flags*/
    "hddm_r fcalSingleHitMatchParams element",  /* tp_doc */
    0,                         /* tp_traverse */
    0,                         /* tp_clear */
    0,                         /* tp_richcompare */
    0,                         /* tp_weaklistoffset */
    0,                         /* tp_iter */
    0,                         /* tp_iternext */
    _FcalSingleHitMatchParams_methods,          /* tp_methods */
    _FcalSingleHitMatchParams_members,          /* tp_members */
    _FcalSingleHitMatchParams_getsetters,       /* tp_getset */
    &_HDDM_Element_type,       /* tp_base */
    0,                         /* tp_dict */
    0,                         /* tp_descr_get */
    0,                         /* tp_descr_set */
    0,                         /* tp_dictoffset */
    (initproc)_FcalSingleHitMatchParams_init,   /* tp_init */
    0,                         /* tp_alloc */
    _FcalSingleHitMatchParams_new,              /* tp_new */
};



// wrap element class hddm_r::CtofMatchParams as hddm_r.CtofMatchParams

typedef struct {
   PyObject_HEAD
   CtofMatchParams *elem;
   PyObject *host;
} _CtofMatchParams;

static void
_CtofMatchParams_dealloc(_CtofMatchParams* self)
{
   if (self->elem != 0) {
      LOG_DEALLOC(Py_TYPE(self), 0, self->host == (PyObject*)self);
      if (self->host == (PyObject*)self)
         delete self->elem;
      else
         My_DECREF(self->host);
   }
   Py_TYPE(self)->tp_free((PyObject*)self);
}

static PyObject*
_CtofMatchParams_new(PyTypeObject *type, PyObject *args, PyObject *kwds)
{
   _CtofMatchParams *self;
   self = (_CtofMatchParams*)type->tp_alloc(type, 0);
   if (self != NULL) {
      self->elem = 0;
      self->host = 0;
   }
   return (PyObject*)self;
}

static int
_CtofMatchParams_init(_CtofMatchParams *self, PyObject *args, PyObject *kwds)
{
   PyErr_SetString(PyExc_RuntimeError, "illegal constructor");
   return -1;
}

static PyObject*
_CtofMatchParams_getClass(_CtofMatchParams *self, void *closure)
{
   std::string val(self->elem->getClass());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_CtofMatchParams_getVersion(_CtofMatchParams *self, void *closure)
{
   std::string val(self->elem->getVersion());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_CtofMatchParams_getXmlns(_CtofMatchParams *self, void *closure)
{
   std::string val(self->elem->getXmlns());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_CtofMatchParams_getEventNo(_CtofMatchParams *self, void *closure)
{
   return PyLong_FromLongLong(self->elem->getEventNo());
}

static PyObject*
_CtofMatchParams_getRunNo(_CtofMatchParams *self, void *closure)
{
   return PyLong_FromLong(self->elem->getRunNo());
}

static PyObject*
_CtofMatchParams_getJtag(_CtofMatchParams *self, void *closure)
{
   std::string val(self->elem->getJtag());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_CtofMatchParams_getDEdx(_CtofMatchParams *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getDEdx());
}

static int
_CtofMatchParams_setDEdx(_CtofMatchParams *self, PyObject *value, void *closure)
{
   double var = PyFloat_AsDouble(value);
   if (var == -1 && PyErr_Occurred()) {
      return 1;
   }
   self->elem->setDEdx((float)var);
   return 0;
}

static PyObject*
_CtofMatchParams_getDEdx_unit(_CtofMatchParams *self, void *closure)
{
   std::string val(self->elem->getDEdx_unit());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_CtofMatchParams_getDeltax(_CtofMatchParams *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getDeltax());
}

static int
_CtofMatchParams_setDeltax(_CtofMatchParams *self, PyObject *value, void *closure)
{
   double var = PyFloat_AsDouble(value);
   if (var == -1 && PyErr_Occurred()) {
      return 1;
   }
   self->elem->setDeltax((float)var);
   return 0;
}

static PyObject*
_CtofMatchParams_getDeltay(_CtofMatchParams *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getDeltay());
}

static int
_CtofMatchParams_setDeltay(_CtofMatchParams *self, PyObject *value, void *closure)
{
   double var = PyFloat_AsDouble(value);
   if (var == -1 && PyErr_Occurred()) {
      return 1;
   }
   self->elem->setDeltay((float)var);
   return 0;
}

static PyObject*
_CtofMatchParams_getHit(_CtofMatchParams *self, void *closure)
{
   return PyLong_FromLong(self->elem->getHit());
}

static int
_CtofMatchParams_setHit(_CtofMatchParams *self, PyObject *value, void *closure)
{
   long var = PyInt_AsLong(value);
   if (var == -1 && PyErr_Occurred()) {
      return -1;
   }
   self->elem->setHit(var);
   return 0;
}

static PyObject*
_CtofMatchParams_getLunit(_CtofMatchParams *self, void *closure)
{
   std::string val(self->elem->getLunit());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_CtofMatchParams_getMaxOccurs(_CtofMatchParams *self, void *closure)
{
   std::string val(self->elem->getMaxOccurs());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_CtofMatchParams_getMinOccurs(_CtofMatchParams *self, void *closure)
{
   return PyLong_FromLong(self->elem->getMinOccurs());
}

static PyObject*
_CtofMatchParams_getTflight(_CtofMatchParams *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getTflight());
}

static int
_CtofMatchParams_setTflight(_CtofMatchParams *self, PyObject *value, void *closure)
{
   double var = PyFloat_AsDouble(value);
   if (var == -1 && PyErr_Occurred()) {
      return 1;
   }
   self->elem->setTflight((float)var);
   return 0;
}

static PyObject*
_CtofMatchParams_getTrack(_CtofMatchParams *self, void *closure)
{
   return PyLong_FromLong(self->elem->getTrack());
}

static int
_CtofMatchParams_setTrack(_CtofMatchParams *self, PyObject *value, void *closure)
{
   long var = PyInt_AsLong(value);
   if (var == -1 && PyErr_Occurred()) {
      return -1;
   }
   self->elem->setTrack(var);
   return 0;
}

static PyObject*
_CtofMatchParams_getTunit(_CtofMatchParams *self, void *closure)
{
   std::string val(self->elem->getTunit());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_CtofMatchParams_toString(PyObject *self, PyObject *args=0)
{
   _CtofMatchParams *me = (_CtofMatchParams*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid ctofMatchParams element");
      return NULL;
   }
   std::string str(me->elem->toString());
   return PyUnicode_FromString(str.c_str());
}

static PyObject*
_CtofMatchParams_toXML(PyObject *self, PyObject *args=0)
{
   _CtofMatchParams *me = (_CtofMatchParams*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid ctofMatchParams element");
      return NULL;
   }
   std::string str(me->elem->toXML());
   return PyUnicode_FromString(str.c_str());
}

static PyGetSetDef _CtofMatchParams_getsetters[] = {
   {(char*)"class",
    (getter)_CtofMatchParams_getClass, 0,
    (char*)"class string",
    NULL},
   {(char*)"dEdx",
    (getter)_CtofMatchParams_getDEdx, (setter)_CtofMatchParams_setDEdx,
    (char*)"dEdx value",
    NULL},
   {(char*)"dEdx_unit",
    (getter)_CtofMatchParams_getDEdx_unit, 0,
    (char*)"dEdx_unit value",
    NULL},
   {(char*)"deltax",
    (getter)_CtofMatchParams_getDeltax, (setter)_CtofMatchParams_setDeltax,
    (char*)"deltax value",
    NULL},
   {(char*)"deltay",
    (getter)_CtofMatchParams_getDeltay, (setter)_CtofMatchParams_setDeltay,
    (char*)"deltay value",
    NULL},
   {(char*)"eventNo",
    (getter)_CtofMatchParams_getEventNo, 0,
    (char*)"eventNo value",
    NULL},
   {(char*)"hit",
    (getter)_CtofMatchParams_getHit, (setter)_CtofMatchParams_setHit,
    (char*)"hit value",
    NULL},
   {(char*)"jtag",
    (getter)_CtofMatchParams_getJtag, 0,
    (char*)"jtag string",
    NULL},
   {(char*)"lunit",
    (getter)_CtofMatchParams_getLunit, 0,
    (char*)"lunit value",
    NULL},
   {(char*)"maxOccurs",
    (getter)_CtofMatchParams_getMaxOccurs, 0,
    (char*)"maxOccurs value",
    NULL},
   {(char*)"minOccurs",
    (getter)_CtofMatchParams_getMinOccurs, 0,
    (char*)"minOccurs value",
    NULL},
   {(char*)"runNo",
    (getter)_CtofMatchParams_getRunNo, 0,
    (char*)"runNo value",
    NULL},
   {(char*)"tflight",
    (getter)_CtofMatchParams_getTflight, (setter)_CtofMatchParams_setTflight,
    (char*)"tflight value",
    NULL},
   {(char*)"track",
    (getter)_CtofMatchParams_getTrack, (setter)_CtofMatchParams_setTrack,
    (char*)"track value",
    NULL},
   {(char*)"tunit",
    (getter)_CtofMatchParams_getTunit, 0,
    (char*)"tunit value",
    NULL},
   {(char*)"version",
    (getter)_CtofMatchParams_getVersion, 0,
    (char*)"version string",
    NULL},
   {(char*)"xmlns",
    (getter)_CtofMatchParams_getXmlns, 0,
    (char*)"xmlns string",
    NULL},
   {NULL}  /* Sentinel */
};

static PyMemberDef _CtofMatchParams_members[] = {
   {NULL}  /* Sentinel */
};

static PyMethodDef _CtofMatchParams_methods[] = {
   {"toString", _CtofMatchParams_toString, METH_NOARGS,
    "show element as a human-readable string"},
   {"toXML", _CtofMatchParams_toXML, METH_NOARGS,
    "show element as a XML fragment"},
   {NULL}  /* Sentinel */
};

static PyTypeObject _CtofMatchParams_type = {
    PyVarObject_HEAD_INIT(NULL,0)
    "hddm_r.CtofMatchParams",         /*tp_name*/
    sizeof(_CtofMatchParams),          /*tp_basicsize*/
    0,                         /*tp_itemsize*/
    (destructor)_CtofMatchParams_dealloc, /*tp_dealloc*/
    0,                         /*tp_print*/
    0,                         /*tp_getattr*/
    0,                         /*tp_setattr*/
    0,                         /*tp_compare*/
    0,                         /*tp_repr*/
    0,                         /*tp_as_number*/
    0,                         /*tp_as_sequence*/
    0,                         /*tp_as_mapping*/
    0,                         /*tp_hash */
    0,                         /*tp_call*/
    (reprfunc)_CtofMatchParams_toString,         /*tp_str*/
    0,                         /*tp_getattro*/
    0,                         /*tp_setattro*/
    0,                         /*tp_as_buffer*/
    Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE, /*tp_flags*/
    "hddm_r ctofMatchParams element",  /* tp_doc */
    0,                         /* tp_traverse */
    0,                         /* tp_clear */
    0,                         /* tp_richcompare */
    0,                         /* tp_weaklistoffset */
    0,                         /* tp_iter */
    0,                         /* tp_iternext */
    _CtofMatchParams_methods,          /* tp_methods */
    _CtofMatchParams_members,          /* tp_members */
    _CtofMatchParams_getsetters,       /* tp_getset */
    &_HDDM_Element_type,       /* tp_base */
    0,                         /* tp_dict */
    0,                         /* tp_descr_get */
    0,                         /* tp_descr_set */
    0,                         /* tp_dictoffset */
    (initproc)_CtofMatchParams_init,   /* tp_init */
    0,                         /* tp_alloc */
    _CtofMatchParams_new,              /* tp_new */
};



// wrap element class hddm_r::FmwpcData as hddm_r.FmwpcData

typedef struct {
   PyObject_HEAD
   FmwpcData *elem;
   PyObject *host;
} _FmwpcData;

static void
_FmwpcData_dealloc(_FmwpcData* self)
{
   if (self->elem != 0) {
      LOG_DEALLOC(Py_TYPE(self), 0, self->host == (PyObject*)self);
      if (self->host == (PyObject*)self)
         delete self->elem;
      else
         My_DECREF(self->host);
   }
   Py_TYPE(self)->tp_free((PyObject*)self);
}

static PyObject*
_FmwpcData_new(PyTypeObject *type, PyObject *args, PyObject *kwds)
{
   _FmwpcData *self;
   self = (_FmwpcData*)type->tp_alloc(type, 0);
   if (self != NULL) {
      self->elem = 0;
      self->host = 0;
   }
   return (PyObject*)self;
}

static int
_FmwpcData_init(_FmwpcData *self, PyObject *args, PyObject *kwds)
{
   PyErr_SetString(PyExc_RuntimeError, "illegal constructor");
   return -1;
}

static PyObject*
_FmwpcData_getClass(_FmwpcData *self, void *closure)
{
   std::string val(self->elem->getClass());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_FmwpcData_getVersion(_FmwpcData *self, void *closure)
{
   std::string val(self->elem->getVersion());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_FmwpcData_getXmlns(_FmwpcData *self, void *closure)
{
   std::string val(self->elem->getXmlns());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_FmwpcData_getEventNo(_FmwpcData *self, void *closure)
{
   return PyLong_FromLongLong(self->elem->getEventNo());
}

static PyObject*
_FmwpcData_getRunNo(_FmwpcData *self, void *closure)
{
   return PyLong_FromLong(self->elem->getRunNo());
}

static PyObject*
_FmwpcData_getJtag(_FmwpcData *self, void *closure)
{
   std::string val(self->elem->getJtag());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_FmwpcData_getTrack(_FmwpcData *self, void *closure)
{
   return PyLong_FromLong(self->elem->getTrack());
}

static PyObject*
_FmwpcData_getClosestwire(_FmwpcData *self, void *closure)
{
   return PyLong_FromLong(self->elem->getClosestwire());
}

static int
_FmwpcData_setClosestwire(_FmwpcData *self, PyObject *value, void *closure)
{
   long var = PyInt_AsLong(value);
   if (var == -1 && PyErr_Occurred()) {
      return -1;
   }
   self->elem->setClosestwire(var);
   return 0;
}

static PyObject*
_FmwpcData_getDist(_FmwpcData *self, void *closure)
{
   return PyLong_FromLong(self->elem->getDist());
}

static int
_FmwpcData_setDist(_FmwpcData *self, PyObject *value, void *closure)
{
   long var = PyInt_AsLong(value);
   if (var == -1 && PyErr_Occurred()) {
      return -1;
   }
   self->elem->setDist(var);
   return 0;
}

static PyObject*
_FmwpcData_getLayer(_FmwpcData *self, void *closure)
{
   return PyLong_FromLong(self->elem->getLayer());
}

static int
_FmwpcData_setLayer(_FmwpcData *self, PyObject *value, void *closure)
{
   long var = PyInt_AsLong(value);
   if (var == -1 && PyErr_Occurred()) {
      return -1;
   }
   self->elem->setLayer(var);
   return 0;
}

static PyObject*
_FmwpcData_getMaxOccurs(_FmwpcData *self, void *closure)
{
   return PyLong_FromLong(self->elem->getMaxOccurs());
}

static PyObject*
_FmwpcData_getMinOccurs(_FmwpcData *self, void *closure)
{
   return PyLong_FromLong(self->elem->getMinOccurs());
}

static PyObject*
_FmwpcData_getNhits(_FmwpcData *self, void *closure)
{
   return PyLong_FromLong(self->elem->getNhits());
}

static int
_FmwpcData_setNhits(_FmwpcData *self, PyObject *value, void *closure)
{
   long var = PyInt_AsLong(value);
   if (var == -1 && PyErr_Occurred()) {
      return -1;
   }
   self->elem->setNhits(var);
   return 0;
}

static PyObject*
_FmwpcData_toString(PyObject *self, PyObject *args=0)
{
   _FmwpcData *me = (_FmwpcData*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid fmwpcData element");
      return NULL;
   }
   std::string str(me->elem->toString());
   return PyUnicode_FromString(str.c_str());
}

static PyObject*
_FmwpcData_toXML(PyObject *self, PyObject *args=0)
{
   _FmwpcData *me = (_FmwpcData*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid fmwpcData element");
      return NULL;
   }
   std::string str(me->elem->toXML());
   return PyUnicode_FromString(str.c_str());
}

static PyGetSetDef _FmwpcData_getsetters[] = {
   {(char*)"class",
    (getter)_FmwpcData_getClass, 0,
    (char*)"class string",
    NULL},
   {(char*)"closestwire",
    (getter)_FmwpcData_getClosestwire, (setter)_FmwpcData_setClosestwire,
    (char*)"closestwire value",
    NULL},
   {(char*)"dist",
    (getter)_FmwpcData_getDist, (setter)_FmwpcData_setDist,
    (char*)"dist value",
    NULL},
   {(char*)"eventNo",
    (getter)_FmwpcData_getEventNo, 0,
    (char*)"eventNo value",
    NULL},
   {(char*)"jtag",
    (getter)_FmwpcData_getJtag, 0,
    (char*)"jtag string",
    NULL},
   {(char*)"layer",
    (getter)_FmwpcData_getLayer, (setter)_FmwpcData_setLayer,
    (char*)"layer value",
    NULL},
   {(char*)"maxOccurs",
    (getter)_FmwpcData_getMaxOccurs, 0,
    (char*)"maxOccurs value",
    NULL},
   {(char*)"minOccurs",
    (getter)_FmwpcData_getMinOccurs, 0,
    (char*)"minOccurs value",
    NULL},
   {(char*)"nhits",
    (getter)_FmwpcData_getNhits, (setter)_FmwpcData_setNhits,
    (char*)"nhits value",
    NULL},
   {(char*)"runNo",
    (getter)_FmwpcData_getRunNo, 0,
    (char*)"runNo value",
    NULL},
   {(char*)"track",
    (getter)_FmwpcData_getTrack, 0,
    (char*)"track value",
    NULL},
   {(char*)"version",
    (getter)_FmwpcData_getVersion, 0,
    (char*)"version string",
    NULL},
   {(char*)"xmlns",
    (getter)_FmwpcData_getXmlns, 0,
    (char*)"xmlns string",
    NULL},
   {NULL}  /* Sentinel */
};

static PyMemberDef _FmwpcData_members[] = {
   {NULL}  /* Sentinel */
};

static PyMethodDef _FmwpcData_methods[] = {
   {"toString", _FmwpcData_toString, METH_NOARGS,
    "show element as a human-readable string"},
   {"toXML", _FmwpcData_toXML, METH_NOARGS,
    "show element as a XML fragment"},
   {NULL}  /* Sentinel */
};

static PyTypeObject _FmwpcData_type = {
    PyVarObject_HEAD_INIT(NULL,0)
    "hddm_r.FmwpcData",         /*tp_name*/
    sizeof(_FmwpcData),          /*tp_basicsize*/
    0,                         /*tp_itemsize*/
    (destructor)_FmwpcData_dealloc, /*tp_dealloc*/
    0,                         /*tp_print*/
    0,                         /*tp_getattr*/
    0,                         /*tp_setattr*/
    0,                         /*tp_compare*/
    0,                         /*tp_repr*/
    0,                         /*tp_as_number*/
    0,                         /*tp_as_sequence*/
    0,                         /*tp_as_mapping*/
    0,                         /*tp_hash */
    0,                         /*tp_call*/
    (reprfunc)_FmwpcData_toString,         /*tp_str*/
    0,                         /*tp_getattro*/
    0,                         /*tp_setattro*/
    0,                         /*tp_as_buffer*/
    Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE, /*tp_flags*/
    "hddm_r fmwpcData element",  /* tp_doc */
    0,                         /* tp_traverse */
    0,                         /* tp_clear */
    0,                         /* tp_richcompare */
    0,                         /* tp_weaklistoffset */
    0,                         /* tp_iter */
    0,                         /* tp_iternext */
    _FmwpcData_methods,          /* tp_methods */
    _FmwpcData_members,          /* tp_members */
    _FmwpcData_getsetters,       /* tp_getset */
    &_HDDM_Element_type,       /* tp_base */
    0,                         /* tp_dict */
    0,                         /* tp_descr_get */
    0,                         /* tp_descr_set */
    0,                         /* tp_dictoffset */
    (initproc)_FmwpcData_init,   /* tp_init */
    0,                         /* tp_alloc */
    _FmwpcData_new,              /* tp_new */
};



// wrap element class hddm_r::FmwpcMatchParams as hddm_r.FmwpcMatchParams

typedef struct {
   PyObject_HEAD
   FmwpcMatchParams *elem;
   PyObject *host;
} _FmwpcMatchParams;

static void
_FmwpcMatchParams_dealloc(_FmwpcMatchParams* self)
{
   if (self->elem != 0) {
      LOG_DEALLOC(Py_TYPE(self), 0, self->host == (PyObject*)self);
      if (self->host == (PyObject*)self)
         delete self->elem;
      else
         My_DECREF(self->host);
   }
   Py_TYPE(self)->tp_free((PyObject*)self);
}

static PyObject*
_FmwpcMatchParams_new(PyTypeObject *type, PyObject *args, PyObject *kwds)
{
   _FmwpcMatchParams *self;
   self = (_FmwpcMatchParams*)type->tp_alloc(type, 0);
   if (self != NULL) {
      self->elem = 0;
      self->host = 0;
   }
   return (PyObject*)self;
}

static int
_FmwpcMatchParams_init(_FmwpcMatchParams *self, PyObject *args, PyObject *kwds)
{
   PyErr_SetString(PyExc_RuntimeError, "illegal constructor");
   return -1;
}

static PyObject*
_FmwpcMatchParams_getClass(_FmwpcMatchParams *self, void *closure)
{
   std::string val(self->elem->getClass());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_FmwpcMatchParams_getVersion(_FmwpcMatchParams *self, void *closure)
{
   std::string val(self->elem->getVersion());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_FmwpcMatchParams_getXmlns(_FmwpcMatchParams *self, void *closure)
{
   std::string val(self->elem->getXmlns());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_FmwpcMatchParams_getEventNo(_FmwpcMatchParams *self, void *closure)
{
   return PyLong_FromLongLong(self->elem->getEventNo());
}

static PyObject*
_FmwpcMatchParams_getRunNo(_FmwpcMatchParams *self, void *closure)
{
   return PyLong_FromLong(self->elem->getRunNo());
}

static PyObject*
_FmwpcMatchParams_getJtag(_FmwpcMatchParams *self, void *closure)
{
   std::string val(self->elem->getJtag());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_FmwpcMatchParams_getMaxOccurs(_FmwpcMatchParams *self, void *closure)
{
   std::string val(self->elem->getMaxOccurs());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_FmwpcMatchParams_getMinOccurs(_FmwpcMatchParams *self, void *closure)
{
   return PyLong_FromLong(self->elem->getMinOccurs());
}

static PyObject*
_FmwpcMatchParams_getTrack(_FmwpcMatchParams *self, void *closure)
{
   return PyLong_FromLong(self->elem->getTrack());
}

static int
_FmwpcMatchParams_setTrack(_FmwpcMatchParams *self, PyObject *value, void *closure)
{
   long var = PyInt_AsLong(value);
   if (var == -1 && PyErr_Occurred()) {
      return -1;
   }
   self->elem->setTrack(var);
   return 0;
}

static PyObject*
_FmwpcMatchParams_getFmwpcData(PyObject *self, PyObject *args)
{
   int index=0;
   if (! PyArg_ParseTuple(args, "|i", &index)) {
      return NULL;
   }
   _FmwpcMatchParams *me = (_FmwpcMatchParams*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid fmwpcMatchParams element");
      return NULL;
   }
   PyObject *obj = _FmwpcData_new(&_FmwpcData_type, 0, 0);
   ((_FmwpcData*)obj)->elem = &me->elem->getFmwpcData(index);
   ((_FmwpcData*)obj)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(obj));
   return obj;
}

static PyObject*
_FmwpcMatchParams_getFmwpcDatas(PyObject *self, PyObject *args)
{
   _FmwpcMatchParams *me = (_FmwpcMatchParams*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid fmwpcMatchParams element");
      return NULL;
   }
   PyObject *list = _HDDM_ElementList_new(&_HDDM_ElementList_type, 0, 0);
   ((_HDDM_ElementList*)list)->subtype = &_FmwpcData_type;
   ((_HDDM_ElementList*)list)->list = (HDDM_ElementList<HDDM_Element>*)
    &me->elem->getFmwpcDatas();
   ((_HDDM_ElementList*)list)->borrowed = 1;
   ((_HDDM_ElementList*)list)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(list), ((_HDDM_ElementList*)list)->subtype, 0);
   return list;
}

static PyObject*
_FmwpcMatchParams_addFmwpcDatas(PyObject *self, PyObject *args)
{
   int count=1;
   int start=-1;
   if (! PyArg_ParseTuple(args, "|ii", &count, &start)) {
      return NULL;
   }
   _FmwpcMatchParams *me = (_FmwpcMatchParams*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "add attempted on invalid fmwpcMatchParams element");
      return NULL;
   }
   PyObject *list = _HDDM_ElementList_new(&_HDDM_ElementList_type, 0, 0);
   ((_HDDM_ElementList*)list)->subtype = &_FmwpcData_type;
   ((_HDDM_ElementList*)list)->list = (HDDM_ElementList<HDDM_Element>*)
    new FmwpcDataList(me->elem->addFmwpcDatas(count, start));
   ((_HDDM_ElementList*)list)->borrowed = 0;
   ((_HDDM_ElementList*)list)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(list), ((_HDDM_ElementList*)list)->subtype, 1);
   return list;
}

static PyObject*
_FmwpcMatchParams_deleteFmwpcDatas(PyObject *self, PyObject *args)
{
   int count=-1;
   int start=0;
   if (! PyArg_ParseTuple(args, "|ii", &count, &start)) {
      return NULL;
   }
   _FmwpcMatchParams *me = (_FmwpcMatchParams*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "delete attempted on invalid fmwpcMatchParams element");
      return NULL;
   }
   me->elem->deleteFmwpcDatas(count, start);
   Py_INCREF(Py_None);
   return Py_None;
}

static PyObject*
_FmwpcMatchParams_toString(PyObject *self, PyObject *args=0)
{
   _FmwpcMatchParams *me = (_FmwpcMatchParams*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid fmwpcMatchParams element");
      return NULL;
   }
   std::string str(me->elem->toString());
   return PyUnicode_FromString(str.c_str());
}

static PyObject*
_FmwpcMatchParams_toXML(PyObject *self, PyObject *args=0)
{
   _FmwpcMatchParams *me = (_FmwpcMatchParams*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid fmwpcMatchParams element");
      return NULL;
   }
   std::string str(me->elem->toXML());
   return PyUnicode_FromString(str.c_str());
}

static PyGetSetDef _FmwpcMatchParams_getsetters[] = {
   {(char*)"class",
    (getter)_FmwpcMatchParams_getClass, 0,
    (char*)"class string",
    NULL},
   {(char*)"eventNo",
    (getter)_FmwpcMatchParams_getEventNo, 0,
    (char*)"eventNo value",
    NULL},
   {(char*)"jtag",
    (getter)_FmwpcMatchParams_getJtag, 0,
    (char*)"jtag string",
    NULL},
   {(char*)"maxOccurs",
    (getter)_FmwpcMatchParams_getMaxOccurs, 0,
    (char*)"maxOccurs value",
    NULL},
   {(char*)"minOccurs",
    (getter)_FmwpcMatchParams_getMinOccurs, 0,
    (char*)"minOccurs value",
    NULL},
   {(char*)"runNo",
    (getter)_FmwpcMatchParams_getRunNo, 0,
    (char*)"runNo value",
    NULL},
   {(char*)"track",
    (getter)_FmwpcMatchParams_getTrack, (setter)_FmwpcMatchParams_setTrack,
    (char*)"track value",
    NULL},
   {(char*)"version",
    (getter)_FmwpcMatchParams_getVersion, 0,
    (char*)"version string",
    NULL},
   {(char*)"xmlns",
    (getter)_FmwpcMatchParams_getXmlns, 0,
    (char*)"xmlns string",
    NULL},
   {NULL}  /* Sentinel */
};

static PyMemberDef _FmwpcMatchParams_members[] = {
   {NULL}  /* Sentinel */
};

static PyMethodDef _FmwpcMatchParams_methods[] = {
   {"addFmwpcDatas", _FmwpcMatchParams_addFmwpcDatas, METH_VARARGS,
    "extend (or insert into) the list of fmwpcData objects for this fmwpcMatchParams"},
   {"deleteFmwpcDatas", _FmwpcMatchParams_deleteFmwpcDatas, METH_VARARGS,
    "delete fmwpcData objects for this fmwpcMatchParams"},
   {"getFmwpcData", _FmwpcMatchParams_getFmwpcData, METH_VARARGS,
    "get an individual fmwpcData object from this fmwpcMatchParams"},
   {"getFmwpcDatas", _FmwpcMatchParams_getFmwpcDatas, METH_NOARGS,
    "get list of fmwpcData objects for this fmwpcMatchParams"},
   {"toString", _FmwpcMatchParams_toString, METH_NOARGS,
    "show element as a human-readable string"},
   {"toXML", _FmwpcMatchParams_toXML, METH_NOARGS,
    "show element as a XML fragment"},
   {NULL}  /* Sentinel */
};

static PyTypeObject _FmwpcMatchParams_type = {
    PyVarObject_HEAD_INIT(NULL,0)
    "hddm_r.FmwpcMatchParams",         /*tp_name*/
    sizeof(_FmwpcMatchParams),          /*tp_basicsize*/
    0,                         /*tp_itemsize*/
    (destructor)_FmwpcMatchParams_dealloc, /*tp_dealloc*/
    0,                         /*tp_print*/
    0,                         /*tp_getattr*/
    0,                         /*tp_setattr*/
    0,                         /*tp_compare*/
    0,                         /*tp_repr*/
    0,                         /*tp_as_number*/
    0,                         /*tp_as_sequence*/
    0,                         /*tp_as_mapping*/
    0,                         /*tp_hash */
    0,                         /*tp_call*/
    (reprfunc)_FmwpcMatchParams_toString,         /*tp_str*/
    0,                         /*tp_getattro*/
    0,                         /*tp_setattro*/
    0,                         /*tp_as_buffer*/
    Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE, /*tp_flags*/
    "hddm_r fmwpcMatchParams element",  /* tp_doc */
    0,                         /* tp_traverse */
    0,                         /* tp_clear */
    0,                         /* tp_richcompare */
    0,                         /* tp_weaklistoffset */
    0,                         /* tp_iter */
    0,                         /* tp_iternext */
    _FmwpcMatchParams_methods,          /* tp_methods */
    _FmwpcMatchParams_members,          /* tp_members */
    _FmwpcMatchParams_getsetters,       /* tp_getset */
    &_HDDM_Element_type,       /* tp_base */
    0,                         /* tp_dict */
    0,                         /* tp_descr_get */
    0,                         /* tp_descr_set */
    0,                         /* tp_dictoffset */
    (initproc)_FmwpcMatchParams_init,   /* tp_init */
    0,                         /* tp_alloc */
    _FmwpcMatchParams_new,              /* tp_new */
};



// wrap element class hddm_r::TofDedx as hddm_r.TofDedx

typedef struct {
   PyObject_HEAD
   TofDedx *elem;
   PyObject *host;
} _TofDedx;

static void
_TofDedx_dealloc(_TofDedx* self)
{
   if (self->elem != 0) {
      LOG_DEALLOC(Py_TYPE(self), 0, self->host == (PyObject*)self);
      if (self->host == (PyObject*)self)
         delete self->elem;
      else
         My_DECREF(self->host);
   }
   Py_TYPE(self)->tp_free((PyObject*)self);
}

static PyObject*
_TofDedx_new(PyTypeObject *type, PyObject *args, PyObject *kwds)
{
   _TofDedx *self;
   self = (_TofDedx*)type->tp_alloc(type, 0);
   if (self != NULL) {
      self->elem = 0;
      self->host = 0;
   }
   return (PyObject*)self;
}

static int
_TofDedx_init(_TofDedx *self, PyObject *args, PyObject *kwds)
{
   PyErr_SetString(PyExc_RuntimeError, "illegal constructor");
   return -1;
}

static PyObject*
_TofDedx_getClass(_TofDedx *self, void *closure)
{
   std::string val(self->elem->getClass());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_TofDedx_getVersion(_TofDedx *self, void *closure)
{
   std::string val(self->elem->getVersion());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_TofDedx_getXmlns(_TofDedx *self, void *closure)
{
   std::string val(self->elem->getXmlns());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_TofDedx_getEventNo(_TofDedx *self, void *closure)
{
   return PyLong_FromLongLong(self->elem->getEventNo());
}

static PyObject*
_TofDedx_getRunNo(_TofDedx *self, void *closure)
{
   return PyLong_FromLong(self->elem->getRunNo());
}

static PyObject*
_TofDedx_getJtag(_TofDedx *self, void *closure)
{
   std::string val(self->elem->getJtag());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_TofDedx_getDEdx(_TofDedx *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getDEdx());
}

static PyObject*
_TofDedx_getDEdx_unit(_TofDedx *self, void *closure)
{
   std::string val(self->elem->getDEdx_unit());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_TofDedx_getDeltax(_TofDedx *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getDeltax());
}

static PyObject*
_TofDedx_getDeltay(_TofDedx *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getDeltay());
}

static PyObject*
_TofDedx_getEhit(_TofDedx *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getEhit());
}

static PyObject*
_TofDedx_getHit(_TofDedx *self, void *closure)
{
   return PyLong_FromLong(self->elem->getHit());
}

static PyObject*
_TofDedx_getLunit(_TofDedx *self, void *closure)
{
   std::string val(self->elem->getLunit());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_TofDedx_getPathlength(_TofDedx *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getPathlength());
}

static PyObject*
_TofDedx_getTflight(_TofDedx *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getTflight());
}

static PyObject*
_TofDedx_getTflightvar(_TofDedx *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getTflightvar());
}

static PyObject*
_TofDedx_getThit(_TofDedx *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getThit());
}

static PyObject*
_TofDedx_getThitvar(_TofDedx *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getThitvar());
}

static PyObject*
_TofDedx_getTrack(_TofDedx *self, void *closure)
{
   return PyLong_FromLong(self->elem->getTrack());
}

static PyObject*
_TofDedx_getTunit(_TofDedx *self, void *closure)
{
   std::string val(self->elem->getTunit());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_TofDedx_getDEdx1(_TofDedx *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getDEdx1());
}

static int
_TofDedx_setDEdx1(_TofDedx *self, PyObject *value, void *closure)
{
   double var = PyFloat_AsDouble(value);
   if (var == -1 && PyErr_Occurred()) {
      return 1;
   }
   self->elem->setDEdx1((float)var);
   return 0;
}

static PyObject*
_TofDedx_getDEdx2(_TofDedx *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getDEdx2());
}

static int
_TofDedx_setDEdx2(_TofDedx *self, PyObject *value, void *closure)
{
   double var = PyFloat_AsDouble(value);
   if (var == -1 && PyErr_Occurred()) {
      return 1;
   }
   self->elem->setDEdx2((float)var);
   return 0;
}

static PyObject*
_TofDedx_getMaxOccurs(_TofDedx *self, void *closure)
{
   return PyLong_FromLong(self->elem->getMaxOccurs());
}

static PyObject*
_TofDedx_getMinOccurs(_TofDedx *self, void *closure)
{
   return PyLong_FromLong(self->elem->getMinOccurs());
}

static PyObject*
_TofDedx_toString(PyObject *self, PyObject *args=0)
{
   _TofDedx *me = (_TofDedx*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid tofDedx element");
      return NULL;
   }
   std::string str(me->elem->toString());
   return PyUnicode_FromString(str.c_str());
}

static PyObject*
_TofDedx_toXML(PyObject *self, PyObject *args=0)
{
   _TofDedx *me = (_TofDedx*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid tofDedx element");
      return NULL;
   }
   std::string str(me->elem->toXML());
   return PyUnicode_FromString(str.c_str());
}

static PyGetSetDef _TofDedx_getsetters[] = {
   {(char*)"class",
    (getter)_TofDedx_getClass, 0,
    (char*)"class string",
    NULL},
   {(char*)"dEdx",
    (getter)_TofDedx_getDEdx, 0,
    (char*)"dEdx value",
    NULL},
   {(char*)"dEdx1",
    (getter)_TofDedx_getDEdx1, (setter)_TofDedx_setDEdx1,
    (char*)"dEdx1 value",
    NULL},
   {(char*)"dEdx2",
    (getter)_TofDedx_getDEdx2, (setter)_TofDedx_setDEdx2,
    (char*)"dEdx2 value",
    NULL},
   {(char*)"dEdx_unit",
    (getter)_TofDedx_getDEdx_unit, 0,
    (char*)"dEdx_unit string",
    NULL},
   {(char*)"deltax",
    (getter)_TofDedx_getDeltax, 0,
    (char*)"deltax value",
    NULL},
   {(char*)"deltay",
    (getter)_TofDedx_getDeltay, 0,
    (char*)"deltay value",
    NULL},
   {(char*)"ehit",
    (getter)_TofDedx_getEhit, 0,
    (char*)"ehit value",
    NULL},
   {(char*)"eventNo",
    (getter)_TofDedx_getEventNo, 0,
    (char*)"eventNo value",
    NULL},
   {(char*)"hit",
    (getter)_TofDedx_getHit, 0,
    (char*)"hit value",
    NULL},
   {(char*)"jtag",
    (getter)_TofDedx_getJtag, 0,
    (char*)"jtag string",
    NULL},
   {(char*)"lunit",
    (getter)_TofDedx_getLunit, 0,
    (char*)"lunit string",
    NULL},
   {(char*)"maxOccurs",
    (getter)_TofDedx_getMaxOccurs, 0,
    (char*)"maxOccurs value",
    NULL},
   {(char*)"minOccurs",
    (getter)_TofDedx_getMinOccurs, 0,
    (char*)"minOccurs value",
    NULL},
   {(char*)"pathlength",
    (getter)_TofDedx_getPathlength, 0,
    (char*)"pathlength value",
    NULL},
   {(char*)"runNo",
    (getter)_TofDedx_getRunNo, 0,
    (char*)"runNo value",
    NULL},
   {(char*)"tflight",
    (getter)_TofDedx_getTflight, 0,
    (char*)"tflight value",
    NULL},
   {(char*)"tflightvar",
    (getter)_TofDedx_getTflightvar, 0,
    (char*)"tflightvar value",
    NULL},
   {(char*)"thit",
    (getter)_TofDedx_getThit, 0,
    (char*)"thit value",
    NULL},
   {(char*)"thitvar",
    (getter)_TofDedx_getThitvar, 0,
    (char*)"thitvar value",
    NULL},
   {(char*)"track",
    (getter)_TofDedx_getTrack, 0,
    (char*)"track value",
    NULL},
   {(char*)"tunit",
    (getter)_TofDedx_getTunit, 0,
    (char*)"tunit string",
    NULL},
   {(char*)"version",
    (getter)_TofDedx_getVersion, 0,
    (char*)"version string",
    NULL},
   {(char*)"xmlns",
    (getter)_TofDedx_getXmlns, 0,
    (char*)"xmlns string",
    NULL},
   {NULL}  /* Sentinel */
};

static PyMemberDef _TofDedx_members[] = {
   {NULL}  /* Sentinel */
};

static PyMethodDef _TofDedx_methods[] = {
   {"toString", _TofDedx_toString, METH_NOARGS,
    "show element as a human-readable string"},
   {"toXML", _TofDedx_toXML, METH_NOARGS,
    "show element as a XML fragment"},
   {NULL}  /* Sentinel */
};

static PyTypeObject _TofDedx_type = {
    PyVarObject_HEAD_INIT(NULL,0)
    "hddm_r.TofDedx",         /*tp_name*/
    sizeof(_TofDedx),          /*tp_basicsize*/
    0,                         /*tp_itemsize*/
    (destructor)_TofDedx_dealloc, /*tp_dealloc*/
    0,                         /*tp_print*/
    0,                         /*tp_getattr*/
    0,                         /*tp_setattr*/
    0,                         /*tp_compare*/
    0,                         /*tp_repr*/
    0,                         /*tp_as_number*/
    0,                         /*tp_as_sequence*/
    0,                         /*tp_as_mapping*/
    0,                         /*tp_hash */
    0,                         /*tp_call*/
    (reprfunc)_TofDedx_toString,         /*tp_str*/
    0,                         /*tp_getattro*/
    0,                         /*tp_setattro*/
    0,                         /*tp_as_buffer*/
    Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE, /*tp_flags*/
    "hddm_r tofDedx element",  /* tp_doc */
    0,                         /* tp_traverse */
    0,                         /* tp_clear */
    0,                         /* tp_richcompare */
    0,                         /* tp_weaklistoffset */
    0,                         /* tp_iter */
    0,                         /* tp_iternext */
    _TofDedx_methods,          /* tp_methods */
    _TofDedx_members,          /* tp_members */
    _TofDedx_getsetters,       /* tp_getset */
    &_HDDM_Element_type,       /* tp_base */
    0,                         /* tp_dict */
    0,                         /* tp_descr_get */
    0,                         /* tp_descr_set */
    0,                         /* tp_dictoffset */
    (initproc)_TofDedx_init,   /* tp_init */
    0,                         /* tp_alloc */
    _TofDedx_new,              /* tp_new */
};



// wrap element class hddm_r::TofMatchParams as hddm_r.TofMatchParams

typedef struct {
   PyObject_HEAD
   TofMatchParams *elem;
   PyObject *host;
} _TofMatchParams;

static void
_TofMatchParams_dealloc(_TofMatchParams* self)
{
   if (self->elem != 0) {
      LOG_DEALLOC(Py_TYPE(self), 0, self->host == (PyObject*)self);
      if (self->host == (PyObject*)self)
         delete self->elem;
      else
         My_DECREF(self->host);
   }
   Py_TYPE(self)->tp_free((PyObject*)self);
}

static PyObject*
_TofMatchParams_new(PyTypeObject *type, PyObject *args, PyObject *kwds)
{
   _TofMatchParams *self;
   self = (_TofMatchParams*)type->tp_alloc(type, 0);
   if (self != NULL) {
      self->elem = 0;
      self->host = 0;
   }
   return (PyObject*)self;
}

static int
_TofMatchParams_init(_TofMatchParams *self, PyObject *args, PyObject *kwds)
{
   PyErr_SetString(PyExc_RuntimeError, "illegal constructor");
   return -1;
}

static PyObject*
_TofMatchParams_getClass(_TofMatchParams *self, void *closure)
{
   std::string val(self->elem->getClass());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_TofMatchParams_getVersion(_TofMatchParams *self, void *closure)
{
   std::string val(self->elem->getVersion());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_TofMatchParams_getXmlns(_TofMatchParams *self, void *closure)
{
   std::string val(self->elem->getXmlns());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_TofMatchParams_getEventNo(_TofMatchParams *self, void *closure)
{
   return PyLong_FromLongLong(self->elem->getEventNo());
}

static PyObject*
_TofMatchParams_getRunNo(_TofMatchParams *self, void *closure)
{
   return PyLong_FromLong(self->elem->getRunNo());
}

static PyObject*
_TofMatchParams_getJtag(_TofMatchParams *self, void *closure)
{
   std::string val(self->elem->getJtag());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_TofMatchParams_getDEdx(_TofMatchParams *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getDEdx());
}

static int
_TofMatchParams_setDEdx(_TofMatchParams *self, PyObject *value, void *closure)
{
   double var = PyFloat_AsDouble(value);
   if (var == -1 && PyErr_Occurred()) {
      return 1;
   }
   self->elem->setDEdx((float)var);
   return 0;
}

static PyObject*
_TofMatchParams_getDEdx_unit(_TofMatchParams *self, void *closure)
{
   std::string val(self->elem->getDEdx_unit());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_TofMatchParams_getDeltax(_TofMatchParams *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getDeltax());
}

static int
_TofMatchParams_setDeltax(_TofMatchParams *self, PyObject *value, void *closure)
{
   double var = PyFloat_AsDouble(value);
   if (var == -1 && PyErr_Occurred()) {
      return 1;
   }
   self->elem->setDeltax((float)var);
   return 0;
}

static PyObject*
_TofMatchParams_getDeltay(_TofMatchParams *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getDeltay());
}

static int
_TofMatchParams_setDeltay(_TofMatchParams *self, PyObject *value, void *closure)
{
   double var = PyFloat_AsDouble(value);
   if (var == -1 && PyErr_Occurred()) {
      return 1;
   }
   self->elem->setDeltay((float)var);
   return 0;
}

static PyObject*
_TofMatchParams_getEhit(_TofMatchParams *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getEhit());
}

static int
_TofMatchParams_setEhit(_TofMatchParams *self, PyObject *value, void *closure)
{
   double var = PyFloat_AsDouble(value);
   if (var == -1 && PyErr_Occurred()) {
      return 1;
   }
   self->elem->setEhit((float)var);
   return 0;
}

static PyObject*
_TofMatchParams_getHit(_TofMatchParams *self, void *closure)
{
   return PyLong_FromLong(self->elem->getHit());
}

static int
_TofMatchParams_setHit(_TofMatchParams *self, PyObject *value, void *closure)
{
   long var = PyInt_AsLong(value);
   if (var == -1 && PyErr_Occurred()) {
      return -1;
   }
   self->elem->setHit(var);
   return 0;
}

static PyObject*
_TofMatchParams_getLunit(_TofMatchParams *self, void *closure)
{
   std::string val(self->elem->getLunit());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_TofMatchParams_getMaxOccurs(_TofMatchParams *self, void *closure)
{
   std::string val(self->elem->getMaxOccurs());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_TofMatchParams_getMinOccurs(_TofMatchParams *self, void *closure)
{
   return PyLong_FromLong(self->elem->getMinOccurs());
}

static PyObject*
_TofMatchParams_getPathlength(_TofMatchParams *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getPathlength());
}

static int
_TofMatchParams_setPathlength(_TofMatchParams *self, PyObject *value, void *closure)
{
   double var = PyFloat_AsDouble(value);
   if (var == -1 && PyErr_Occurred()) {
      return 1;
   }
   self->elem->setPathlength((float)var);
   return 0;
}

static PyObject*
_TofMatchParams_getTflight(_TofMatchParams *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getTflight());
}

static int
_TofMatchParams_setTflight(_TofMatchParams *self, PyObject *value, void *closure)
{
   double var = PyFloat_AsDouble(value);
   if (var == -1 && PyErr_Occurred()) {
      return 1;
   }
   self->elem->setTflight((float)var);
   return 0;
}

static PyObject*
_TofMatchParams_getTflightvar(_TofMatchParams *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getTflightvar());
}

static int
_TofMatchParams_setTflightvar(_TofMatchParams *self, PyObject *value, void *closure)
{
   double var = PyFloat_AsDouble(value);
   if (var == -1 && PyErr_Occurred()) {
      return 1;
   }
   self->elem->setTflightvar((float)var);
   return 0;
}

static PyObject*
_TofMatchParams_getThit(_TofMatchParams *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getThit());
}

static int
_TofMatchParams_setThit(_TofMatchParams *self, PyObject *value, void *closure)
{
   double var = PyFloat_AsDouble(value);
   if (var == -1 && PyErr_Occurred()) {
      return 1;
   }
   self->elem->setThit((float)var);
   return 0;
}

static PyObject*
_TofMatchParams_getThitvar(_TofMatchParams *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getThitvar());
}

static int
_TofMatchParams_setThitvar(_TofMatchParams *self, PyObject *value, void *closure)
{
   double var = PyFloat_AsDouble(value);
   if (var == -1 && PyErr_Occurred()) {
      return 1;
   }
   self->elem->setThitvar((float)var);
   return 0;
}

static PyObject*
_TofMatchParams_getTrack(_TofMatchParams *self, void *closure)
{
   return PyLong_FromLong(self->elem->getTrack());
}

static int
_TofMatchParams_setTrack(_TofMatchParams *self, PyObject *value, void *closure)
{
   long var = PyInt_AsLong(value);
   if (var == -1 && PyErr_Occurred()) {
      return -1;
   }
   self->elem->setTrack(var);
   return 0;
}

static PyObject*
_TofMatchParams_getTunit(_TofMatchParams *self, void *closure)
{
   std::string val(self->elem->getTunit());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_TofMatchParams_getTofDedx(PyObject *self, PyObject *args)
{
   int index=0;
   if (! PyArg_ParseTuple(args, "|i", &index)) {
      return NULL;
   }
   _TofMatchParams *me = (_TofMatchParams*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid tofMatchParams element");
      return NULL;
   }
   PyObject *obj = _TofDedx_new(&_TofDedx_type, 0, 0);
   ((_TofDedx*)obj)->elem = &me->elem->getTofDedx();
   ((_TofDedx*)obj)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(obj));
   return obj;
}

static PyObject*
_TofMatchParams_getTofDedxs(PyObject *self, PyObject *args)
{
   _TofMatchParams *me = (_TofMatchParams*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid tofMatchParams element");
      return NULL;
   }
   PyObject *list = _HDDM_ElementList_new(&_HDDM_ElementList_type, 0, 0);
   ((_HDDM_ElementList*)list)->subtype = &_TofDedx_type;
   ((_HDDM_ElementList*)list)->list = (HDDM_ElementList<HDDM_Element>*)
    &me->elem->getTofDedxs();
   ((_HDDM_ElementList*)list)->borrowed = 1;
   ((_HDDM_ElementList*)list)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(list), ((_HDDM_ElementList*)list)->subtype, 0);
   return list;
}

static PyObject*
_TofMatchParams_addTofDedxs(PyObject *self, PyObject *args)
{
   int count=1;
   int start=-1;
   if (! PyArg_ParseTuple(args, "|ii", &count, &start)) {
      return NULL;
   }
   _TofMatchParams *me = (_TofMatchParams*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "add attempted on invalid tofMatchParams element");
      return NULL;
   }
   PyObject *list = _HDDM_ElementList_new(&_HDDM_ElementList_type, 0, 0);
   ((_HDDM_ElementList*)list)->subtype = &_TofDedx_type;
   ((_HDDM_ElementList*)list)->list = (HDDM_ElementList<HDDM_Element>*)
    new TofDedxList(me->elem->addTofDedxs(count, start));
   ((_HDDM_ElementList*)list)->borrowed = 0;
   ((_HDDM_ElementList*)list)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(list), ((_HDDM_ElementList*)list)->subtype, 1);
   return list;
}

static PyObject*
_TofMatchParams_deleteTofDedxs(PyObject *self, PyObject *args)
{
   int count=-1;
   int start=0;
   if (! PyArg_ParseTuple(args, "|ii", &count, &start)) {
      return NULL;
   }
   _TofMatchParams *me = (_TofMatchParams*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "delete attempted on invalid tofMatchParams element");
      return NULL;
   }
   me->elem->deleteTofDedxs(count, start);
   Py_INCREF(Py_None);
   return Py_None;
}

static PyObject*
_TofMatchParams_toString(PyObject *self, PyObject *args=0)
{
   _TofMatchParams *me = (_TofMatchParams*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid tofMatchParams element");
      return NULL;
   }
   std::string str(me->elem->toString());
   return PyUnicode_FromString(str.c_str());
}

static PyObject*
_TofMatchParams_toXML(PyObject *self, PyObject *args=0)
{
   _TofMatchParams *me = (_TofMatchParams*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid tofMatchParams element");
      return NULL;
   }
   std::string str(me->elem->toXML());
   return PyUnicode_FromString(str.c_str());
}

static PyGetSetDef _TofMatchParams_getsetters[] = {
   {(char*)"class",
    (getter)_TofMatchParams_getClass, 0,
    (char*)"class string",
    NULL},
   {(char*)"dEdx",
    (getter)_TofMatchParams_getDEdx, (setter)_TofMatchParams_setDEdx,
    (char*)"dEdx value",
    NULL},
   {(char*)"dEdx_unit",
    (getter)_TofMatchParams_getDEdx_unit, 0,
    (char*)"dEdx_unit value",
    NULL},
   {(char*)"deltax",
    (getter)_TofMatchParams_getDeltax, (setter)_TofMatchParams_setDeltax,
    (char*)"deltax value",
    NULL},
   {(char*)"deltay",
    (getter)_TofMatchParams_getDeltay, (setter)_TofMatchParams_setDeltay,
    (char*)"deltay value",
    NULL},
   {(char*)"ehit",
    (getter)_TofMatchParams_getEhit, (setter)_TofMatchParams_setEhit,
    (char*)"ehit value",
    NULL},
   {(char*)"eventNo",
    (getter)_TofMatchParams_getEventNo, 0,
    (char*)"eventNo value",
    NULL},
   {(char*)"hit",
    (getter)_TofMatchParams_getHit, (setter)_TofMatchParams_setHit,
    (char*)"hit value",
    NULL},
   {(char*)"jtag",
    (getter)_TofMatchParams_getJtag, 0,
    (char*)"jtag string",
    NULL},
   {(char*)"lunit",
    (getter)_TofMatchParams_getLunit, 0,
    (char*)"lunit value",
    NULL},
   {(char*)"maxOccurs",
    (getter)_TofMatchParams_getMaxOccurs, 0,
    (char*)"maxOccurs value",
    NULL},
   {(char*)"minOccurs",
    (getter)_TofMatchParams_getMinOccurs, 0,
    (char*)"minOccurs value",
    NULL},
   {(char*)"pathlength",
    (getter)_TofMatchParams_getPathlength, (setter)_TofMatchParams_setPathlength,
    (char*)"pathlength value",
    NULL},
   {(char*)"runNo",
    (getter)_TofMatchParams_getRunNo, 0,
    (char*)"runNo value",
    NULL},
   {(char*)"tflight",
    (getter)_TofMatchParams_getTflight, (setter)_TofMatchParams_setTflight,
    (char*)"tflight value",
    NULL},
   {(char*)"tflightvar",
    (getter)_TofMatchParams_getTflightvar, (setter)_TofMatchParams_setTflightvar,
    (char*)"tflightvar value",
    NULL},
   {(char*)"thit",
    (getter)_TofMatchParams_getThit, (setter)_TofMatchParams_setThit,
    (char*)"thit value",
    NULL},
   {(char*)"thitvar",
    (getter)_TofMatchParams_getThitvar, (setter)_TofMatchParams_setThitvar,
    (char*)"thitvar value",
    NULL},
   {(char*)"track",
    (getter)_TofMatchParams_getTrack, (setter)_TofMatchParams_setTrack,
    (char*)"track value",
    NULL},
   {(char*)"tunit",
    (getter)_TofMatchParams_getTunit, 0,
    (char*)"tunit value",
    NULL},
   {(char*)"version",
    (getter)_TofMatchParams_getVersion, 0,
    (char*)"version string",
    NULL},
   {(char*)"xmlns",
    (getter)_TofMatchParams_getXmlns, 0,
    (char*)"xmlns string",
    NULL},
   {NULL}  /* Sentinel */
};

static PyMemberDef _TofMatchParams_members[] = {
   {NULL}  /* Sentinel */
};

static PyMethodDef _TofMatchParams_methods[] = {
   {"addTofDedxs", _TofMatchParams_addTofDedxs, METH_VARARGS,
    "extend (or insert into) the list of tofDedx objects for this tofMatchParams"},
   {"deleteTofDedxs", _TofMatchParams_deleteTofDedxs, METH_VARARGS,
    "delete tofDedx objects for this tofMatchParams"},
   {"getTofDedx", _TofMatchParams_getTofDedx, METH_VARARGS,
    "get an individual tofDedx object from this tofMatchParams"},
   {"getTofDedxs", _TofMatchParams_getTofDedxs, METH_NOARGS,
    "get list of tofDedx objects for this tofMatchParams"},
   {"toString", _TofMatchParams_toString, METH_NOARGS,
    "show element as a human-readable string"},
   {"toXML", _TofMatchParams_toXML, METH_NOARGS,
    "show element as a XML fragment"},
   {NULL}  /* Sentinel */
};

static PyTypeObject _TofMatchParams_type = {
    PyVarObject_HEAD_INIT(NULL,0)
    "hddm_r.TofMatchParams",         /*tp_name*/
    sizeof(_TofMatchParams),          /*tp_basicsize*/
    0,                         /*tp_itemsize*/
    (destructor)_TofMatchParams_dealloc, /*tp_dealloc*/
    0,                         /*tp_print*/
    0,                         /*tp_getattr*/
    0,                         /*tp_setattr*/
    0,                         /*tp_compare*/
    0,                         /*tp_repr*/
    0,                         /*tp_as_number*/
    0,                         /*tp_as_sequence*/
    0,                         /*tp_as_mapping*/
    0,                         /*tp_hash */
    0,                         /*tp_call*/
    (reprfunc)_TofMatchParams_toString,         /*tp_str*/
    0,                         /*tp_getattro*/
    0,                         /*tp_setattro*/
    0,                         /*tp_as_buffer*/
    Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE, /*tp_flags*/
    "hddm_r tofMatchParams element",  /* tp_doc */
    0,                         /* tp_traverse */
    0,                         /* tp_clear */
    0,                         /* tp_richcompare */
    0,                         /* tp_weaklistoffset */
    0,                         /* tp_iter */
    0,                         /* tp_iternext */
    _TofMatchParams_methods,          /* tp_methods */
    _TofMatchParams_members,          /* tp_members */
    _TofMatchParams_getsetters,       /* tp_getset */
    &_HDDM_Element_type,       /* tp_base */
    0,                         /* tp_dict */
    0,                         /* tp_descr_get */
    0,                         /* tp_descr_set */
    0,                         /* tp_dictoffset */
    (initproc)_TofMatchParams_init,   /* tp_init */
    0,                         /* tp_alloc */
    _TofMatchParams_new,              /* tp_new */
};



// wrap element class hddm_r::ScMatchParams as hddm_r.ScMatchParams

typedef struct {
   PyObject_HEAD
   ScMatchParams *elem;
   PyObject *host;
} _ScMatchParams;

static void
_ScMatchParams_dealloc(_ScMatchParams* self)
{
   if (self->elem != 0) {
      LOG_DEALLOC(Py_TYPE(self), 0, self->host == (PyObject*)self);
      if (self->host == (PyObject*)self)
         delete self->elem;
      else
         My_DECREF(self->host);
   }
   Py_TYPE(self)->tp_free((PyObject*)self);
}

static PyObject*
_ScMatchParams_new(PyTypeObject *type, PyObject *args, PyObject *kwds)
{
   _ScMatchParams *self;
   self = (_ScMatchParams*)type->tp_alloc(type, 0);
   if (self != NULL) {
      self->elem = 0;
      self->host = 0;
   }
   return (PyObject*)self;
}

static int
_ScMatchParams_init(_ScMatchParams *self, PyObject *args, PyObject *kwds)
{
   PyErr_SetString(PyExc_RuntimeError, "illegal constructor");
   return -1;
}

static PyObject*
_ScMatchParams_getClass(_ScMatchParams *self, void *closure)
{
   std::string val(self->elem->getClass());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_ScMatchParams_getVersion(_ScMatchParams *self, void *closure)
{
   std::string val(self->elem->getVersion());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_ScMatchParams_getXmlns(_ScMatchParams *self, void *closure)
{
   std::string val(self->elem->getXmlns());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_ScMatchParams_getEventNo(_ScMatchParams *self, void *closure)
{
   return PyLong_FromLongLong(self->elem->getEventNo());
}

static PyObject*
_ScMatchParams_getRunNo(_ScMatchParams *self, void *closure)
{
   return PyLong_FromLong(self->elem->getRunNo());
}

static PyObject*
_ScMatchParams_getJtag(_ScMatchParams *self, void *closure)
{
   std::string val(self->elem->getJtag());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_ScMatchParams_getEunit(_ScMatchParams *self, void *closure)
{
   std::string val(self->elem->getEunit());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_ScMatchParams_getAunit(_ScMatchParams *self, void *closure)
{
   std::string val(self->elem->getAunit());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_ScMatchParams_getDEdx(_ScMatchParams *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getDEdx());
}

static int
_ScMatchParams_setDEdx(_ScMatchParams *self, PyObject *value, void *closure)
{
   double var = PyFloat_AsDouble(value);
   if (var == -1 && PyErr_Occurred()) {
      return 1;
   }
   self->elem->setDEdx((float)var);
   return 0;
}

static PyObject*
_ScMatchParams_getDEdx_unit(_ScMatchParams *self, void *closure)
{
   std::string val(self->elem->getDEdx_unit());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_ScMatchParams_getDeltaphi(_ScMatchParams *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getDeltaphi());
}

static int
_ScMatchParams_setDeltaphi(_ScMatchParams *self, PyObject *value, void *closure)
{
   double var = PyFloat_AsDouble(value);
   if (var == -1 && PyErr_Occurred()) {
      return 1;
   }
   self->elem->setDeltaphi((float)var);
   return 0;
}

static PyObject*
_ScMatchParams_getEhit(_ScMatchParams *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getEhit());
}

static int
_ScMatchParams_setEhit(_ScMatchParams *self, PyObject *value, void *closure)
{
   double var = PyFloat_AsDouble(value);
   if (var == -1 && PyErr_Occurred()) {
      return 1;
   }
   self->elem->setEhit((float)var);
   return 0;
}

static PyObject*
_ScMatchParams_getHit(_ScMatchParams *self, void *closure)
{
   return PyLong_FromLong(self->elem->getHit());
}

static int
_ScMatchParams_setHit(_ScMatchParams *self, PyObject *value, void *closure)
{
   long var = PyInt_AsLong(value);
   if (var == -1 && PyErr_Occurred()) {
      return -1;
   }
   self->elem->setHit(var);
   return 0;
}

static PyObject*
_ScMatchParams_getLunit(_ScMatchParams *self, void *closure)
{
   std::string val(self->elem->getLunit());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_ScMatchParams_getMaxOccurs(_ScMatchParams *self, void *closure)
{
   std::string val(self->elem->getMaxOccurs());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_ScMatchParams_getMinOccurs(_ScMatchParams *self, void *closure)
{
   return PyLong_FromLong(self->elem->getMinOccurs());
}

static PyObject*
_ScMatchParams_getPathlength(_ScMatchParams *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getPathlength());
}

static int
_ScMatchParams_setPathlength(_ScMatchParams *self, PyObject *value, void *closure)
{
   double var = PyFloat_AsDouble(value);
   if (var == -1 && PyErr_Occurred()) {
      return 1;
   }
   self->elem->setPathlength((float)var);
   return 0;
}

static PyObject*
_ScMatchParams_getTflight(_ScMatchParams *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getTflight());
}

static int
_ScMatchParams_setTflight(_ScMatchParams *self, PyObject *value, void *closure)
{
   double var = PyFloat_AsDouble(value);
   if (var == -1 && PyErr_Occurred()) {
      return 1;
   }
   self->elem->setTflight((float)var);
   return 0;
}

static PyObject*
_ScMatchParams_getTflightvar(_ScMatchParams *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getTflightvar());
}

static int
_ScMatchParams_setTflightvar(_ScMatchParams *self, PyObject *value, void *closure)
{
   double var = PyFloat_AsDouble(value);
   if (var == -1 && PyErr_Occurred()) {
      return 1;
   }
   self->elem->setTflightvar((float)var);
   return 0;
}

static PyObject*
_ScMatchParams_getThit(_ScMatchParams *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getThit());
}

static int
_ScMatchParams_setThit(_ScMatchParams *self, PyObject *value, void *closure)
{
   double var = PyFloat_AsDouble(value);
   if (var == -1 && PyErr_Occurred()) {
      return 1;
   }
   self->elem->setThit((float)var);
   return 0;
}

static PyObject*
_ScMatchParams_getThitvar(_ScMatchParams *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getThitvar());
}

static int
_ScMatchParams_setThitvar(_ScMatchParams *self, PyObject *value, void *closure)
{
   double var = PyFloat_AsDouble(value);
   if (var == -1 && PyErr_Occurred()) {
      return 1;
   }
   self->elem->setThitvar((float)var);
   return 0;
}

static PyObject*
_ScMatchParams_getTrack(_ScMatchParams *self, void *closure)
{
   return PyLong_FromLong(self->elem->getTrack());
}

static int
_ScMatchParams_setTrack(_ScMatchParams *self, PyObject *value, void *closure)
{
   long var = PyInt_AsLong(value);
   if (var == -1 && PyErr_Occurred()) {
      return -1;
   }
   self->elem->setTrack(var);
   return 0;
}

static PyObject*
_ScMatchParams_getTunit(_ScMatchParams *self, void *closure)
{
   std::string val(self->elem->getTunit());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_ScMatchParams_toString(PyObject *self, PyObject *args=0)
{
   _ScMatchParams *me = (_ScMatchParams*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid scMatchParams element");
      return NULL;
   }
   std::string str(me->elem->toString());
   return PyUnicode_FromString(str.c_str());
}

static PyObject*
_ScMatchParams_toXML(PyObject *self, PyObject *args=0)
{
   _ScMatchParams *me = (_ScMatchParams*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid scMatchParams element");
      return NULL;
   }
   std::string str(me->elem->toXML());
   return PyUnicode_FromString(str.c_str());
}

static PyGetSetDef _ScMatchParams_getsetters[] = {
   {(char*)"Eunit",
    (getter)_ScMatchParams_getEunit, 0,
    (char*)"Eunit value",
    NULL},
   {(char*)"aunit",
    (getter)_ScMatchParams_getAunit, 0,
    (char*)"aunit value",
    NULL},
   {(char*)"class",
    (getter)_ScMatchParams_getClass, 0,
    (char*)"class string",
    NULL},
   {(char*)"dEdx",
    (getter)_ScMatchParams_getDEdx, (setter)_ScMatchParams_setDEdx,
    (char*)"dEdx value",
    NULL},
   {(char*)"dEdx_unit",
    (getter)_ScMatchParams_getDEdx_unit, 0,
    (char*)"dEdx_unit value",
    NULL},
   {(char*)"deltaphi",
    (getter)_ScMatchParams_getDeltaphi, (setter)_ScMatchParams_setDeltaphi,
    (char*)"deltaphi value",
    NULL},
   {(char*)"ehit",
    (getter)_ScMatchParams_getEhit, (setter)_ScMatchParams_setEhit,
    (char*)"ehit value",
    NULL},
   {(char*)"eventNo",
    (getter)_ScMatchParams_getEventNo, 0,
    (char*)"eventNo value",
    NULL},
   {(char*)"hit",
    (getter)_ScMatchParams_getHit, (setter)_ScMatchParams_setHit,
    (char*)"hit value",
    NULL},
   {(char*)"jtag",
    (getter)_ScMatchParams_getJtag, 0,
    (char*)"jtag string",
    NULL},
   {(char*)"lunit",
    (getter)_ScMatchParams_getLunit, 0,
    (char*)"lunit value",
    NULL},
   {(char*)"maxOccurs",
    (getter)_ScMatchParams_getMaxOccurs, 0,
    (char*)"maxOccurs value",
    NULL},
   {(char*)"minOccurs",
    (getter)_ScMatchParams_getMinOccurs, 0,
    (char*)"minOccurs value",
    NULL},
   {(char*)"pathlength",
    (getter)_ScMatchParams_getPathlength, (setter)_ScMatchParams_setPathlength,
    (char*)"pathlength value",
    NULL},
   {(char*)"runNo",
    (getter)_ScMatchParams_getRunNo, 0,
    (char*)"runNo value",
    NULL},
   {(char*)"tflight",
    (getter)_ScMatchParams_getTflight, (setter)_ScMatchParams_setTflight,
    (char*)"tflight value",
    NULL},
   {(char*)"tflightvar",
    (getter)_ScMatchParams_getTflightvar, (setter)_ScMatchParams_setTflightvar,
    (char*)"tflightvar value",
    NULL},
   {(char*)"thit",
    (getter)_ScMatchParams_getThit, (setter)_ScMatchParams_setThit,
    (char*)"thit value",
    NULL},
   {(char*)"thitvar",
    (getter)_ScMatchParams_getThitvar, (setter)_ScMatchParams_setThitvar,
    (char*)"thitvar value",
    NULL},
   {(char*)"track",
    (getter)_ScMatchParams_getTrack, (setter)_ScMatchParams_setTrack,
    (char*)"track value",
    NULL},
   {(char*)"tunit",
    (getter)_ScMatchParams_getTunit, 0,
    (char*)"tunit value",
    NULL},
   {(char*)"version",
    (getter)_ScMatchParams_getVersion, 0,
    (char*)"version string",
    NULL},
   {(char*)"xmlns",
    (getter)_ScMatchParams_getXmlns, 0,
    (char*)"xmlns string",
    NULL},
   {NULL}  /* Sentinel */
};

static PyMemberDef _ScMatchParams_members[] = {
   {NULL}  /* Sentinel */
};

static PyMethodDef _ScMatchParams_methods[] = {
   {"toString", _ScMatchParams_toString, METH_NOARGS,
    "show element as a human-readable string"},
   {"toXML", _ScMatchParams_toXML, METH_NOARGS,
    "show element as a XML fragment"},
   {NULL}  /* Sentinel */
};

static PyTypeObject _ScMatchParams_type = {
    PyVarObject_HEAD_INIT(NULL,0)
    "hddm_r.ScMatchParams",         /*tp_name*/
    sizeof(_ScMatchParams),          /*tp_basicsize*/
    0,                         /*tp_itemsize*/
    (destructor)_ScMatchParams_dealloc, /*tp_dealloc*/
    0,                         /*tp_print*/
    0,                         /*tp_getattr*/
    0,                         /*tp_setattr*/
    0,                         /*tp_compare*/
    0,                         /*tp_repr*/
    0,                         /*tp_as_number*/
    0,                         /*tp_as_sequence*/
    0,                         /*tp_as_mapping*/
    0,                         /*tp_hash */
    0,                         /*tp_call*/
    (reprfunc)_ScMatchParams_toString,         /*tp_str*/
    0,                         /*tp_getattro*/
    0,                         /*tp_setattro*/
    0,                         /*tp_as_buffer*/
    Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE, /*tp_flags*/
    "hddm_r scMatchParams element",  /* tp_doc */
    0,                         /* tp_traverse */
    0,                         /* tp_clear */
    0,                         /* tp_richcompare */
    0,                         /* tp_weaklistoffset */
    0,                         /* tp_iter */
    0,                         /* tp_iternext */
    _ScMatchParams_methods,          /* tp_methods */
    _ScMatchParams_members,          /* tp_members */
    _ScMatchParams_getsetters,       /* tp_getset */
    &_HDDM_Element_type,       /* tp_base */
    0,                         /* tp_dict */
    0,                         /* tp_descr_get */
    0,                         /* tp_descr_set */
    0,                         /* tp_dictoffset */
    (initproc)_ScMatchParams_init,   /* tp_init */
    0,                         /* tp_alloc */
    _ScMatchParams_new,              /* tp_new */
};



// wrap element class hddm_r::DircMatchParams as hddm_r.DircMatchParams

typedef struct {
   PyObject_HEAD
   DircMatchParams *elem;
   PyObject *host;
} _DircMatchParams;

static void
_DircMatchParams_dealloc(_DircMatchParams* self)
{
   if (self->elem != 0) {
      LOG_DEALLOC(Py_TYPE(self), 0, self->host == (PyObject*)self);
      if (self->host == (PyObject*)self)
         delete self->elem;
      else
         My_DECREF(self->host);
   }
   Py_TYPE(self)->tp_free((PyObject*)self);
}

static PyObject*
_DircMatchParams_new(PyTypeObject *type, PyObject *args, PyObject *kwds)
{
   _DircMatchParams *self;
   self = (_DircMatchParams*)type->tp_alloc(type, 0);
   if (self != NULL) {
      self->elem = 0;
      self->host = 0;
   }
   return (PyObject*)self;
}

static int
_DircMatchParams_init(_DircMatchParams *self, PyObject *args, PyObject *kwds)
{
   PyErr_SetString(PyExc_RuntimeError, "illegal constructor");
   return -1;
}

static PyObject*
_DircMatchParams_getClass(_DircMatchParams *self, void *closure)
{
   std::string val(self->elem->getClass());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_DircMatchParams_getVersion(_DircMatchParams *self, void *closure)
{
   std::string val(self->elem->getVersion());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_DircMatchParams_getXmlns(_DircMatchParams *self, void *closure)
{
   std::string val(self->elem->getXmlns());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_DircMatchParams_getEventNo(_DircMatchParams *self, void *closure)
{
   return PyLong_FromLongLong(self->elem->getEventNo());
}

static PyObject*
_DircMatchParams_getRunNo(_DircMatchParams *self, void *closure)
{
   return PyLong_FromLong(self->elem->getRunNo());
}

static PyObject*
_DircMatchParams_getJtag(_DircMatchParams *self, void *closure)
{
   std::string val(self->elem->getJtag());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_DircMatchParams_getDeltat(_DircMatchParams *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getDeltat());
}

static int
_DircMatchParams_setDeltat(_DircMatchParams *self, PyObject *value, void *closure)
{
   double var = PyFloat_AsDouble(value);
   if (var == -1 && PyErr_Occurred()) {
      return 1;
   }
   self->elem->setDeltat((float)var);
   return 0;
}

static PyObject*
_DircMatchParams_getExpectthetac(_DircMatchParams *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getExpectthetac());
}

static int
_DircMatchParams_setExpectthetac(_DircMatchParams *self, PyObject *value, void *closure)
{
   double var = PyFloat_AsDouble(value);
   if (var == -1 && PyErr_Occurred()) {
      return 1;
   }
   self->elem->setExpectthetac((float)var);
   return 0;
}

static PyObject*
_DircMatchParams_getLele(_DircMatchParams *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getLele());
}

static int
_DircMatchParams_setLele(_DircMatchParams *self, PyObject *value, void *closure)
{
   double var = PyFloat_AsDouble(value);
   if (var == -1 && PyErr_Occurred()) {
      return 1;
   }
   self->elem->setLele((float)var);
   return 0;
}

static PyObject*
_DircMatchParams_getLk(_DircMatchParams *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getLk());
}

static int
_DircMatchParams_setLk(_DircMatchParams *self, PyObject *value, void *closure)
{
   double var = PyFloat_AsDouble(value);
   if (var == -1 && PyErr_Occurred()) {
      return 1;
   }
   self->elem->setLk((float)var);
   return 0;
}

static PyObject*
_DircMatchParams_getLp(_DircMatchParams *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getLp());
}

static int
_DircMatchParams_setLp(_DircMatchParams *self, PyObject *value, void *closure)
{
   double var = PyFloat_AsDouble(value);
   if (var == -1 && PyErr_Occurred()) {
      return 1;
   }
   self->elem->setLp((float)var);
   return 0;
}

static PyObject*
_DircMatchParams_getLpi(_DircMatchParams *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getLpi());
}

static int
_DircMatchParams_setLpi(_DircMatchParams *self, PyObject *value, void *closure)
{
   double var = PyFloat_AsDouble(value);
   if (var == -1 && PyErr_Occurred()) {
      return 1;
   }
   self->elem->setLpi((float)var);
   return 0;
}

static PyObject*
_DircMatchParams_getMaxOccurs(_DircMatchParams *self, void *closure)
{
   std::string val(self->elem->getMaxOccurs());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_DircMatchParams_getMinOccurs(_DircMatchParams *self, void *closure)
{
   return PyLong_FromLong(self->elem->getMinOccurs());
}

static PyObject*
_DircMatchParams_getNphotons(_DircMatchParams *self, void *closure)
{
   return PyLong_FromLong(self->elem->getNphotons());
}

static int
_DircMatchParams_setNphotons(_DircMatchParams *self, PyObject *value, void *closure)
{
   long var = PyInt_AsLong(value);
   if (var == -1 && PyErr_Occurred()) {
      return -1;
   }
   self->elem->setNphotons(var);
   return 0;
}

static PyObject*
_DircMatchParams_getPx(_DircMatchParams *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getPx());
}

static int
_DircMatchParams_setPx(_DircMatchParams *self, PyObject *value, void *closure)
{
   double var = PyFloat_AsDouble(value);
   if (var == -1 && PyErr_Occurred()) {
      return 1;
   }
   self->elem->setPx((float)var);
   return 0;
}

static PyObject*
_DircMatchParams_getPy(_DircMatchParams *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getPy());
}

static int
_DircMatchParams_setPy(_DircMatchParams *self, PyObject *value, void *closure)
{
   double var = PyFloat_AsDouble(value);
   if (var == -1 && PyErr_Occurred()) {
      return 1;
   }
   self->elem->setPy((float)var);
   return 0;
}

static PyObject*
_DircMatchParams_getPz(_DircMatchParams *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getPz());
}

static int
_DircMatchParams_setPz(_DircMatchParams *self, PyObject *value, void *closure)
{
   double var = PyFloat_AsDouble(value);
   if (var == -1 && PyErr_Occurred()) {
      return 1;
   }
   self->elem->setPz((float)var);
   return 0;
}

static PyObject*
_DircMatchParams_getT(_DircMatchParams *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getT());
}

static int
_DircMatchParams_setT(_DircMatchParams *self, PyObject *value, void *closure)
{
   double var = PyFloat_AsDouble(value);
   if (var == -1 && PyErr_Occurred()) {
      return 1;
   }
   self->elem->setT((float)var);
   return 0;
}

static PyObject*
_DircMatchParams_getThetac(_DircMatchParams *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getThetac());
}

static int
_DircMatchParams_setThetac(_DircMatchParams *self, PyObject *value, void *closure)
{
   double var = PyFloat_AsDouble(value);
   if (var == -1 && PyErr_Occurred()) {
      return 1;
   }
   self->elem->setThetac((float)var);
   return 0;
}

static PyObject*
_DircMatchParams_getTrack(_DircMatchParams *self, void *closure)
{
   return PyLong_FromLong(self->elem->getTrack());
}

static int
_DircMatchParams_setTrack(_DircMatchParams *self, PyObject *value, void *closure)
{
   long var = PyInt_AsLong(value);
   if (var == -1 && PyErr_Occurred()) {
      return -1;
   }
   self->elem->setTrack(var);
   return 0;
}

static PyObject*
_DircMatchParams_getX(_DircMatchParams *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getX());
}

static int
_DircMatchParams_setX(_DircMatchParams *self, PyObject *value, void *closure)
{
   double var = PyFloat_AsDouble(value);
   if (var == -1 && PyErr_Occurred()) {
      return 1;
   }
   self->elem->setX((float)var);
   return 0;
}

static PyObject*
_DircMatchParams_getY(_DircMatchParams *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getY());
}

static int
_DircMatchParams_setY(_DircMatchParams *self, PyObject *value, void *closure)
{
   double var = PyFloat_AsDouble(value);
   if (var == -1 && PyErr_Occurred()) {
      return 1;
   }
   self->elem->setY((float)var);
   return 0;
}

static PyObject*
_DircMatchParams_getZ(_DircMatchParams *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getZ());
}

static int
_DircMatchParams_setZ(_DircMatchParams *self, PyObject *value, void *closure)
{
   double var = PyFloat_AsDouble(value);
   if (var == -1 && PyErr_Occurred()) {
      return 1;
   }
   self->elem->setZ((float)var);
   return 0;
}

static PyObject*
_DircMatchParams_toString(PyObject *self, PyObject *args=0)
{
   _DircMatchParams *me = (_DircMatchParams*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid dircMatchParams element");
      return NULL;
   }
   std::string str(me->elem->toString());
   return PyUnicode_FromString(str.c_str());
}

static PyObject*
_DircMatchParams_toXML(PyObject *self, PyObject *args=0)
{
   _DircMatchParams *me = (_DircMatchParams*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid dircMatchParams element");
      return NULL;
   }
   std::string str(me->elem->toXML());
   return PyUnicode_FromString(str.c_str());
}

static PyGetSetDef _DircMatchParams_getsetters[] = {
   {(char*)"class",
    (getter)_DircMatchParams_getClass, 0,
    (char*)"class string",
    NULL},
   {(char*)"deltat",
    (getter)_DircMatchParams_getDeltat, (setter)_DircMatchParams_setDeltat,
    (char*)"deltat value",
    NULL},
   {(char*)"eventNo",
    (getter)_DircMatchParams_getEventNo, 0,
    (char*)"eventNo value",
    NULL},
   {(char*)"expectthetac",
    (getter)_DircMatchParams_getExpectthetac, (setter)_DircMatchParams_setExpectthetac,
    (char*)"expectthetac value",
    NULL},
   {(char*)"jtag",
    (getter)_DircMatchParams_getJtag, 0,
    (char*)"jtag string",
    NULL},
   {(char*)"lele",
    (getter)_DircMatchParams_getLele, (setter)_DircMatchParams_setLele,
    (char*)"lele value",
    NULL},
   {(char*)"lk",
    (getter)_DircMatchParams_getLk, (setter)_DircMatchParams_setLk,
    (char*)"lk value",
    NULL},
   {(char*)"lp",
    (getter)_DircMatchParams_getLp, (setter)_DircMatchParams_setLp,
    (char*)"lp value",
    NULL},
   {(char*)"lpi",
    (getter)_DircMatchParams_getLpi, (setter)_DircMatchParams_setLpi,
    (char*)"lpi value",
    NULL},
   {(char*)"maxOccurs",
    (getter)_DircMatchParams_getMaxOccurs, 0,
    (char*)"maxOccurs value",
    NULL},
   {(char*)"minOccurs",
    (getter)_DircMatchParams_getMinOccurs, 0,
    (char*)"minOccurs value",
    NULL},
   {(char*)"nphotons",
    (getter)_DircMatchParams_getNphotons, (setter)_DircMatchParams_setNphotons,
    (char*)"nphotons value",
    NULL},
   {(char*)"px",
    (getter)_DircMatchParams_getPx, (setter)_DircMatchParams_setPx,
    (char*)"px value",
    NULL},
   {(char*)"py",
    (getter)_DircMatchParams_getPy, (setter)_DircMatchParams_setPy,
    (char*)"py value",
    NULL},
   {(char*)"pz",
    (getter)_DircMatchParams_getPz, (setter)_DircMatchParams_setPz,
    (char*)"pz value",
    NULL},
   {(char*)"runNo",
    (getter)_DircMatchParams_getRunNo, 0,
    (char*)"runNo value",
    NULL},
   {(char*)"t",
    (getter)_DircMatchParams_getT, (setter)_DircMatchParams_setT,
    (char*)"t value",
    NULL},
   {(char*)"thetac",
    (getter)_DircMatchParams_getThetac, (setter)_DircMatchParams_setThetac,
    (char*)"thetac value",
    NULL},
   {(char*)"track",
    (getter)_DircMatchParams_getTrack, (setter)_DircMatchParams_setTrack,
    (char*)"track value",
    NULL},
   {(char*)"version",
    (getter)_DircMatchParams_getVersion, 0,
    (char*)"version string",
    NULL},
   {(char*)"x",
    (getter)_DircMatchParams_getX, (setter)_DircMatchParams_setX,
    (char*)"x value",
    NULL},
   {(char*)"xmlns",
    (getter)_DircMatchParams_getXmlns, 0,
    (char*)"xmlns string",
    NULL},
   {(char*)"y",
    (getter)_DircMatchParams_getY, (setter)_DircMatchParams_setY,
    (char*)"y value",
    NULL},
   {(char*)"z",
    (getter)_DircMatchParams_getZ, (setter)_DircMatchParams_setZ,
    (char*)"z value",
    NULL},
   {NULL}  /* Sentinel */
};

static PyMemberDef _DircMatchParams_members[] = {
   {NULL}  /* Sentinel */
};

static PyMethodDef _DircMatchParams_methods[] = {
   {"toString", _DircMatchParams_toString, METH_NOARGS,
    "show element as a human-readable string"},
   {"toXML", _DircMatchParams_toXML, METH_NOARGS,
    "show element as a XML fragment"},
   {NULL}  /* Sentinel */
};

static PyTypeObject _DircMatchParams_type = {
    PyVarObject_HEAD_INIT(NULL,0)
    "hddm_r.DircMatchParams",         /*tp_name*/
    sizeof(_DircMatchParams),          /*tp_basicsize*/
    0,                         /*tp_itemsize*/
    (destructor)_DircMatchParams_dealloc, /*tp_dealloc*/
    0,                         /*tp_print*/
    0,                         /*tp_getattr*/
    0,                         /*tp_setattr*/
    0,                         /*tp_compare*/
    0,                         /*tp_repr*/
    0,                         /*tp_as_number*/
    0,                         /*tp_as_sequence*/
    0,                         /*tp_as_mapping*/
    0,                         /*tp_hash */
    0,                         /*tp_call*/
    (reprfunc)_DircMatchParams_toString,         /*tp_str*/
    0,                         /*tp_getattro*/
    0,                         /*tp_setattro*/
    0,                         /*tp_as_buffer*/
    Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE, /*tp_flags*/
    "hddm_r dircMatchParams element",  /* tp_doc */
    0,                         /* tp_traverse */
    0,                         /* tp_clear */
    0,                         /* tp_richcompare */
    0,                         /* tp_weaklistoffset */
    0,                         /* tp_iter */
    0,                         /* tp_iternext */
    _DircMatchParams_methods,          /* tp_methods */
    _DircMatchParams_members,          /* tp_members */
    _DircMatchParams_getsetters,       /* tp_getset */
    &_HDDM_Element_type,       /* tp_base */
    0,                         /* tp_dict */
    0,                         /* tp_descr_get */
    0,                         /* tp_descr_set */
    0,                         /* tp_dictoffset */
    (initproc)_DircMatchParams_init,   /* tp_init */
    0,                         /* tp_alloc */
    _DircMatchParams_new,              /* tp_new */
};



// wrap element class hddm_r::DircMatchHit as hddm_r.DircMatchHit

typedef struct {
   PyObject_HEAD
   DircMatchHit *elem;
   PyObject *host;
} _DircMatchHit;

static void
_DircMatchHit_dealloc(_DircMatchHit* self)
{
   if (self->elem != 0) {
      LOG_DEALLOC(Py_TYPE(self), 0, self->host == (PyObject*)self);
      if (self->host == (PyObject*)self)
         delete self->elem;
      else
         My_DECREF(self->host);
   }
   Py_TYPE(self)->tp_free((PyObject*)self);
}

static PyObject*
_DircMatchHit_new(PyTypeObject *type, PyObject *args, PyObject *kwds)
{
   _DircMatchHit *self;
   self = (_DircMatchHit*)type->tp_alloc(type, 0);
   if (self != NULL) {
      self->elem = 0;
      self->host = 0;
   }
   return (PyObject*)self;
}

static int
_DircMatchHit_init(_DircMatchHit *self, PyObject *args, PyObject *kwds)
{
   PyErr_SetString(PyExc_RuntimeError, "illegal constructor");
   return -1;
}

static PyObject*
_DircMatchHit_getClass(_DircMatchHit *self, void *closure)
{
   std::string val(self->elem->getClass());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_DircMatchHit_getVersion(_DircMatchHit *self, void *closure)
{
   std::string val(self->elem->getVersion());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_DircMatchHit_getXmlns(_DircMatchHit *self, void *closure)
{
   std::string val(self->elem->getXmlns());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_DircMatchHit_getEventNo(_DircMatchHit *self, void *closure)
{
   return PyLong_FromLongLong(self->elem->getEventNo());
}

static PyObject*
_DircMatchHit_getRunNo(_DircMatchHit *self, void *closure)
{
   return PyLong_FromLong(self->elem->getRunNo());
}

static PyObject*
_DircMatchHit_getJtag(_DircMatchHit *self, void *closure)
{
   std::string val(self->elem->getJtag());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_DircMatchHit_getHit(_DircMatchHit *self, void *closure)
{
   return PyLong_FromLong(self->elem->getHit());
}

static int
_DircMatchHit_setHit(_DircMatchHit *self, PyObject *value, void *closure)
{
   long var = PyInt_AsLong(value);
   if (var == -1 && PyErr_Occurred()) {
      return -1;
   }
   self->elem->setHit(var);
   return 0;
}

static PyObject*
_DircMatchHit_getMaxOccurs(_DircMatchHit *self, void *closure)
{
   std::string val(self->elem->getMaxOccurs());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_DircMatchHit_getMinOccurs(_DircMatchHit *self, void *closure)
{
   return PyLong_FromLong(self->elem->getMinOccurs());
}

static PyObject*
_DircMatchHit_getTrack(_DircMatchHit *self, void *closure)
{
   return PyLong_FromLong(self->elem->getTrack());
}

static int
_DircMatchHit_setTrack(_DircMatchHit *self, PyObject *value, void *closure)
{
   long var = PyInt_AsLong(value);
   if (var == -1 && PyErr_Occurred()) {
      return -1;
   }
   self->elem->setTrack(var);
   return 0;
}

static PyObject*
_DircMatchHit_toString(PyObject *self, PyObject *args=0)
{
   _DircMatchHit *me = (_DircMatchHit*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid dircMatchHit element");
      return NULL;
   }
   std::string str(me->elem->toString());
   return PyUnicode_FromString(str.c_str());
}

static PyObject*
_DircMatchHit_toXML(PyObject *self, PyObject *args=0)
{
   _DircMatchHit *me = (_DircMatchHit*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid dircMatchHit element");
      return NULL;
   }
   std::string str(me->elem->toXML());
   return PyUnicode_FromString(str.c_str());
}

static PyGetSetDef _DircMatchHit_getsetters[] = {
   {(char*)"class",
    (getter)_DircMatchHit_getClass, 0,
    (char*)"class string",
    NULL},
   {(char*)"eventNo",
    (getter)_DircMatchHit_getEventNo, 0,
    (char*)"eventNo value",
    NULL},
   {(char*)"hit",
    (getter)_DircMatchHit_getHit, (setter)_DircMatchHit_setHit,
    (char*)"hit value",
    NULL},
   {(char*)"jtag",
    (getter)_DircMatchHit_getJtag, 0,
    (char*)"jtag string",
    NULL},
   {(char*)"maxOccurs",
    (getter)_DircMatchHit_getMaxOccurs, 0,
    (char*)"maxOccurs value",
    NULL},
   {(char*)"minOccurs",
    (getter)_DircMatchHit_getMinOccurs, 0,
    (char*)"minOccurs value",
    NULL},
   {(char*)"runNo",
    (getter)_DircMatchHit_getRunNo, 0,
    (char*)"runNo value",
    NULL},
   {(char*)"track",
    (getter)_DircMatchHit_getTrack, (setter)_DircMatchHit_setTrack,
    (char*)"track value",
    NULL},
   {(char*)"version",
    (getter)_DircMatchHit_getVersion, 0,
    (char*)"version string",
    NULL},
   {(char*)"xmlns",
    (getter)_DircMatchHit_getXmlns, 0,
    (char*)"xmlns string",
    NULL},
   {NULL}  /* Sentinel */
};

static PyMemberDef _DircMatchHit_members[] = {
   {NULL}  /* Sentinel */
};

static PyMethodDef _DircMatchHit_methods[] = {
   {"toString", _DircMatchHit_toString, METH_NOARGS,
    "show element as a human-readable string"},
   {"toXML", _DircMatchHit_toXML, METH_NOARGS,
    "show element as a XML fragment"},
   {NULL}  /* Sentinel */
};

static PyTypeObject _DircMatchHit_type = {
    PyVarObject_HEAD_INIT(NULL,0)
    "hddm_r.DircMatchHit",         /*tp_name*/
    sizeof(_DircMatchHit),          /*tp_basicsize*/
    0,                         /*tp_itemsize*/
    (destructor)_DircMatchHit_dealloc, /*tp_dealloc*/
    0,                         /*tp_print*/
    0,                         /*tp_getattr*/
    0,                         /*tp_setattr*/
    0,                         /*tp_compare*/
    0,                         /*tp_repr*/
    0,                         /*tp_as_number*/
    0,                         /*tp_as_sequence*/
    0,                         /*tp_as_mapping*/
    0,                         /*tp_hash */
    0,                         /*tp_call*/
    (reprfunc)_DircMatchHit_toString,         /*tp_str*/
    0,                         /*tp_getattro*/
    0,                         /*tp_setattro*/
    0,                         /*tp_as_buffer*/
    Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE, /*tp_flags*/
    "hddm_r dircMatchHit element",  /* tp_doc */
    0,                         /* tp_traverse */
    0,                         /* tp_clear */
    0,                         /* tp_richcompare */
    0,                         /* tp_weaklistoffset */
    0,                         /* tp_iter */
    0,                         /* tp_iternext */
    _DircMatchHit_methods,          /* tp_methods */
    _DircMatchHit_members,          /* tp_members */
    _DircMatchHit_getsetters,       /* tp_getset */
    &_HDDM_Element_type,       /* tp_base */
    0,                         /* tp_dict */
    0,                         /* tp_descr_get */
    0,                         /* tp_descr_set */
    0,                         /* tp_dictoffset */
    (initproc)_DircMatchHit_init,   /* tp_init */
    0,                         /* tp_alloc */
    _DircMatchHit_new,              /* tp_new */
};



// wrap element class hddm_r::BcalDOCAtoTrack as hddm_r.BcalDOCAtoTrack

typedef struct {
   PyObject_HEAD
   BcalDOCAtoTrack *elem;
   PyObject *host;
} _BcalDOCAtoTrack;

static void
_BcalDOCAtoTrack_dealloc(_BcalDOCAtoTrack* self)
{
   if (self->elem != 0) {
      LOG_DEALLOC(Py_TYPE(self), 0, self->host == (PyObject*)self);
      if (self->host == (PyObject*)self)
         delete self->elem;
      else
         My_DECREF(self->host);
   }
   Py_TYPE(self)->tp_free((PyObject*)self);
}

static PyObject*
_BcalDOCAtoTrack_new(PyTypeObject *type, PyObject *args, PyObject *kwds)
{
   _BcalDOCAtoTrack *self;
   self = (_BcalDOCAtoTrack*)type->tp_alloc(type, 0);
   if (self != NULL) {
      self->elem = 0;
      self->host = 0;
   }
   return (PyObject*)self;
}

static int
_BcalDOCAtoTrack_init(_BcalDOCAtoTrack *self, PyObject *args, PyObject *kwds)
{
   PyErr_SetString(PyExc_RuntimeError, "illegal constructor");
   return -1;
}

static PyObject*
_BcalDOCAtoTrack_getClass(_BcalDOCAtoTrack *self, void *closure)
{
   std::string val(self->elem->getClass());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_BcalDOCAtoTrack_getVersion(_BcalDOCAtoTrack *self, void *closure)
{
   std::string val(self->elem->getVersion());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_BcalDOCAtoTrack_getXmlns(_BcalDOCAtoTrack *self, void *closure)
{
   std::string val(self->elem->getXmlns());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_BcalDOCAtoTrack_getEventNo(_BcalDOCAtoTrack *self, void *closure)
{
   return PyLong_FromLongLong(self->elem->getEventNo());
}

static PyObject*
_BcalDOCAtoTrack_getRunNo(_BcalDOCAtoTrack *self, void *closure)
{
   return PyLong_FromLong(self->elem->getRunNo());
}

static PyObject*
_BcalDOCAtoTrack_getJtag(_BcalDOCAtoTrack *self, void *closure)
{
   std::string val(self->elem->getJtag());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_BcalDOCAtoTrack_getDeltaphi(_BcalDOCAtoTrack *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getDeltaphi());
}

static int
_BcalDOCAtoTrack_setDeltaphi(_BcalDOCAtoTrack *self, PyObject *value, void *closure)
{
   double var = PyFloat_AsDouble(value);
   if (var == -1 && PyErr_Occurred()) {
      return 1;
   }
   self->elem->setDeltaphi((float)var);
   return 0;
}

static PyObject*
_BcalDOCAtoTrack_getDeltaz(_BcalDOCAtoTrack *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getDeltaz());
}

static int
_BcalDOCAtoTrack_setDeltaz(_BcalDOCAtoTrack *self, PyObject *value, void *closure)
{
   double var = PyFloat_AsDouble(value);
   if (var == -1 && PyErr_Occurred()) {
      return 1;
   }
   self->elem->setDeltaz((float)var);
   return 0;
}

static PyObject*
_BcalDOCAtoTrack_getLunit(_BcalDOCAtoTrack *self, void *closure)
{
   std::string val(self->elem->getLunit());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_BcalDOCAtoTrack_getMaxOccurs(_BcalDOCAtoTrack *self, void *closure)
{
   std::string val(self->elem->getMaxOccurs());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_BcalDOCAtoTrack_getMinOccurs(_BcalDOCAtoTrack *self, void *closure)
{
   return PyLong_FromLong(self->elem->getMinOccurs());
}

static PyObject*
_BcalDOCAtoTrack_getShower(_BcalDOCAtoTrack *self, void *closure)
{
   return PyLong_FromLong(self->elem->getShower());
}

static int
_BcalDOCAtoTrack_setShower(_BcalDOCAtoTrack *self, PyObject *value, void *closure)
{
   long var = PyInt_AsLong(value);
   if (var == -1 && PyErr_Occurred()) {
      return -1;
   }
   self->elem->setShower(var);
   return 0;
}

static PyObject*
_BcalDOCAtoTrack_toString(PyObject *self, PyObject *args=0)
{
   _BcalDOCAtoTrack *me = (_BcalDOCAtoTrack*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid bcalDOCAtoTrack element");
      return NULL;
   }
   std::string str(me->elem->toString());
   return PyUnicode_FromString(str.c_str());
}

static PyObject*
_BcalDOCAtoTrack_toXML(PyObject *self, PyObject *args=0)
{
   _BcalDOCAtoTrack *me = (_BcalDOCAtoTrack*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid bcalDOCAtoTrack element");
      return NULL;
   }
   std::string str(me->elem->toXML());
   return PyUnicode_FromString(str.c_str());
}

static PyGetSetDef _BcalDOCAtoTrack_getsetters[] = {
   {(char*)"class",
    (getter)_BcalDOCAtoTrack_getClass, 0,
    (char*)"class string",
    NULL},
   {(char*)"deltaphi",
    (getter)_BcalDOCAtoTrack_getDeltaphi, (setter)_BcalDOCAtoTrack_setDeltaphi,
    (char*)"deltaphi value",
    NULL},
   {(char*)"deltaz",
    (getter)_BcalDOCAtoTrack_getDeltaz, (setter)_BcalDOCAtoTrack_setDeltaz,
    (char*)"deltaz value",
    NULL},
   {(char*)"eventNo",
    (getter)_BcalDOCAtoTrack_getEventNo, 0,
    (char*)"eventNo value",
    NULL},
   {(char*)"jtag",
    (getter)_BcalDOCAtoTrack_getJtag, 0,
    (char*)"jtag string",
    NULL},
   {(char*)"lunit",
    (getter)_BcalDOCAtoTrack_getLunit, 0,
    (char*)"lunit value",
    NULL},
   {(char*)"maxOccurs",
    (getter)_BcalDOCAtoTrack_getMaxOccurs, 0,
    (char*)"maxOccurs value",
    NULL},
   {(char*)"minOccurs",
    (getter)_BcalDOCAtoTrack_getMinOccurs, 0,
    (char*)"minOccurs value",
    NULL},
   {(char*)"runNo",
    (getter)_BcalDOCAtoTrack_getRunNo, 0,
    (char*)"runNo value",
    NULL},
   {(char*)"shower",
    (getter)_BcalDOCAtoTrack_getShower, (setter)_BcalDOCAtoTrack_setShower,
    (char*)"shower value",
    NULL},
   {(char*)"version",
    (getter)_BcalDOCAtoTrack_getVersion, 0,
    (char*)"version string",
    NULL},
   {(char*)"xmlns",
    (getter)_BcalDOCAtoTrack_getXmlns, 0,
    (char*)"xmlns string",
    NULL},
   {NULL}  /* Sentinel */
};

static PyMemberDef _BcalDOCAtoTrack_members[] = {
   {NULL}  /* Sentinel */
};

static PyMethodDef _BcalDOCAtoTrack_methods[] = {
   {"toString", _BcalDOCAtoTrack_toString, METH_NOARGS,
    "show element as a human-readable string"},
   {"toXML", _BcalDOCAtoTrack_toXML, METH_NOARGS,
    "show element as a XML fragment"},
   {NULL}  /* Sentinel */
};

static PyTypeObject _BcalDOCAtoTrack_type = {
    PyVarObject_HEAD_INIT(NULL,0)
    "hddm_r.BcalDOCAtoTrack",         /*tp_name*/
    sizeof(_BcalDOCAtoTrack),          /*tp_basicsize*/
    0,                         /*tp_itemsize*/
    (destructor)_BcalDOCAtoTrack_dealloc, /*tp_dealloc*/
    0,                         /*tp_print*/
    0,                         /*tp_getattr*/
    0,                         /*tp_setattr*/
    0,                         /*tp_compare*/
    0,                         /*tp_repr*/
    0,                         /*tp_as_number*/
    0,                         /*tp_as_sequence*/
    0,                         /*tp_as_mapping*/
    0,                         /*tp_hash */
    0,                         /*tp_call*/
    (reprfunc)_BcalDOCAtoTrack_toString,         /*tp_str*/
    0,                         /*tp_getattro*/
    0,                         /*tp_setattro*/
    0,                         /*tp_as_buffer*/
    Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE, /*tp_flags*/
    "hddm_r bcalDOCAtoTrack element",  /* tp_doc */
    0,                         /* tp_traverse */
    0,                         /* tp_clear */
    0,                         /* tp_richcompare */
    0,                         /* tp_weaklistoffset */
    0,                         /* tp_iter */
    0,                         /* tp_iternext */
    _BcalDOCAtoTrack_methods,          /* tp_methods */
    _BcalDOCAtoTrack_members,          /* tp_members */
    _BcalDOCAtoTrack_getsetters,       /* tp_getset */
    &_HDDM_Element_type,       /* tp_base */
    0,                         /* tp_dict */
    0,                         /* tp_descr_get */
    0,                         /* tp_descr_set */
    0,                         /* tp_dictoffset */
    (initproc)_BcalDOCAtoTrack_init,   /* tp_init */
    0,                         /* tp_alloc */
    _BcalDOCAtoTrack_new,              /* tp_new */
};



// wrap element class hddm_r::FcalDOCAtoTrack as hddm_r.FcalDOCAtoTrack

typedef struct {
   PyObject_HEAD
   FcalDOCAtoTrack *elem;
   PyObject *host;
} _FcalDOCAtoTrack;

static void
_FcalDOCAtoTrack_dealloc(_FcalDOCAtoTrack* self)
{
   if (self->elem != 0) {
      LOG_DEALLOC(Py_TYPE(self), 0, self->host == (PyObject*)self);
      if (self->host == (PyObject*)self)
         delete self->elem;
      else
         My_DECREF(self->host);
   }
   Py_TYPE(self)->tp_free((PyObject*)self);
}

static PyObject*
_FcalDOCAtoTrack_new(PyTypeObject *type, PyObject *args, PyObject *kwds)
{
   _FcalDOCAtoTrack *self;
   self = (_FcalDOCAtoTrack*)type->tp_alloc(type, 0);
   if (self != NULL) {
      self->elem = 0;
      self->host = 0;
   }
   return (PyObject*)self;
}

static int
_FcalDOCAtoTrack_init(_FcalDOCAtoTrack *self, PyObject *args, PyObject *kwds)
{
   PyErr_SetString(PyExc_RuntimeError, "illegal constructor");
   return -1;
}

static PyObject*
_FcalDOCAtoTrack_getClass(_FcalDOCAtoTrack *self, void *closure)
{
   std::string val(self->elem->getClass());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_FcalDOCAtoTrack_getVersion(_FcalDOCAtoTrack *self, void *closure)
{
   std::string val(self->elem->getVersion());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_FcalDOCAtoTrack_getXmlns(_FcalDOCAtoTrack *self, void *closure)
{
   std::string val(self->elem->getXmlns());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_FcalDOCAtoTrack_getEventNo(_FcalDOCAtoTrack *self, void *closure)
{
   return PyLong_FromLongLong(self->elem->getEventNo());
}

static PyObject*
_FcalDOCAtoTrack_getRunNo(_FcalDOCAtoTrack *self, void *closure)
{
   return PyLong_FromLong(self->elem->getRunNo());
}

static PyObject*
_FcalDOCAtoTrack_getJtag(_FcalDOCAtoTrack *self, void *closure)
{
   std::string val(self->elem->getJtag());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_FcalDOCAtoTrack_getDoca(_FcalDOCAtoTrack *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getDoca());
}

static int
_FcalDOCAtoTrack_setDoca(_FcalDOCAtoTrack *self, PyObject *value, void *closure)
{
   double var = PyFloat_AsDouble(value);
   if (var == -1 && PyErr_Occurred()) {
      return 1;
   }
   self->elem->setDoca((float)var);
   return 0;
}

static PyObject*
_FcalDOCAtoTrack_getLunit(_FcalDOCAtoTrack *self, void *closure)
{
   std::string val(self->elem->getLunit());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_FcalDOCAtoTrack_getMaxOccurs(_FcalDOCAtoTrack *self, void *closure)
{
   std::string val(self->elem->getMaxOccurs());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_FcalDOCAtoTrack_getMinOccurs(_FcalDOCAtoTrack *self, void *closure)
{
   return PyLong_FromLong(self->elem->getMinOccurs());
}

static PyObject*
_FcalDOCAtoTrack_getShower(_FcalDOCAtoTrack *self, void *closure)
{
   return PyLong_FromLong(self->elem->getShower());
}

static int
_FcalDOCAtoTrack_setShower(_FcalDOCAtoTrack *self, PyObject *value, void *closure)
{
   long var = PyInt_AsLong(value);
   if (var == -1 && PyErr_Occurred()) {
      return -1;
   }
   self->elem->setShower(var);
   return 0;
}

static PyObject*
_FcalDOCAtoTrack_toString(PyObject *self, PyObject *args=0)
{
   _FcalDOCAtoTrack *me = (_FcalDOCAtoTrack*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid fcalDOCAtoTrack element");
      return NULL;
   }
   std::string str(me->elem->toString());
   return PyUnicode_FromString(str.c_str());
}

static PyObject*
_FcalDOCAtoTrack_toXML(PyObject *self, PyObject *args=0)
{
   _FcalDOCAtoTrack *me = (_FcalDOCAtoTrack*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid fcalDOCAtoTrack element");
      return NULL;
   }
   std::string str(me->elem->toXML());
   return PyUnicode_FromString(str.c_str());
}

static PyGetSetDef _FcalDOCAtoTrack_getsetters[] = {
   {(char*)"class",
    (getter)_FcalDOCAtoTrack_getClass, 0,
    (char*)"class string",
    NULL},
   {(char*)"doca",
    (getter)_FcalDOCAtoTrack_getDoca, (setter)_FcalDOCAtoTrack_setDoca,
    (char*)"doca value",
    NULL},
   {(char*)"eventNo",
    (getter)_FcalDOCAtoTrack_getEventNo, 0,
    (char*)"eventNo value",
    NULL},
   {(char*)"jtag",
    (getter)_FcalDOCAtoTrack_getJtag, 0,
    (char*)"jtag string",
    NULL},
   {(char*)"lunit",
    (getter)_FcalDOCAtoTrack_getLunit, 0,
    (char*)"lunit value",
    NULL},
   {(char*)"maxOccurs",
    (getter)_FcalDOCAtoTrack_getMaxOccurs, 0,
    (char*)"maxOccurs value",
    NULL},
   {(char*)"minOccurs",
    (getter)_FcalDOCAtoTrack_getMinOccurs, 0,
    (char*)"minOccurs value",
    NULL},
   {(char*)"runNo",
    (getter)_FcalDOCAtoTrack_getRunNo, 0,
    (char*)"runNo value",
    NULL},
   {(char*)"shower",
    (getter)_FcalDOCAtoTrack_getShower, (setter)_FcalDOCAtoTrack_setShower,
    (char*)"shower value",
    NULL},
   {(char*)"version",
    (getter)_FcalDOCAtoTrack_getVersion, 0,
    (char*)"version string",
    NULL},
   {(char*)"xmlns",
    (getter)_FcalDOCAtoTrack_getXmlns, 0,
    (char*)"xmlns string",
    NULL},
   {NULL}  /* Sentinel */
};

static PyMemberDef _FcalDOCAtoTrack_members[] = {
   {NULL}  /* Sentinel */
};

static PyMethodDef _FcalDOCAtoTrack_methods[] = {
   {"toString", _FcalDOCAtoTrack_toString, METH_NOARGS,
    "show element as a human-readable string"},
   {"toXML", _FcalDOCAtoTrack_toXML, METH_NOARGS,
    "show element as a XML fragment"},
   {NULL}  /* Sentinel */
};

static PyTypeObject _FcalDOCAtoTrack_type = {
    PyVarObject_HEAD_INIT(NULL,0)
    "hddm_r.FcalDOCAtoTrack",         /*tp_name*/
    sizeof(_FcalDOCAtoTrack),          /*tp_basicsize*/
    0,                         /*tp_itemsize*/
    (destructor)_FcalDOCAtoTrack_dealloc, /*tp_dealloc*/
    0,                         /*tp_print*/
    0,                         /*tp_getattr*/
    0,                         /*tp_setattr*/
    0,                         /*tp_compare*/
    0,                         /*tp_repr*/
    0,                         /*tp_as_number*/
    0,                         /*tp_as_sequence*/
    0,                         /*tp_as_mapping*/
    0,                         /*tp_hash */
    0,                         /*tp_call*/
    (reprfunc)_FcalDOCAtoTrack_toString,         /*tp_str*/
    0,                         /*tp_getattro*/
    0,                         /*tp_setattro*/
    0,                         /*tp_as_buffer*/
    Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE, /*tp_flags*/
    "hddm_r fcalDOCAtoTrack element",  /* tp_doc */
    0,                         /* tp_traverse */
    0,                         /* tp_clear */
    0,                         /* tp_richcompare */
    0,                         /* tp_weaklistoffset */
    0,                         /* tp_iter */
    0,                         /* tp_iternext */
    _FcalDOCAtoTrack_methods,          /* tp_methods */
    _FcalDOCAtoTrack_members,          /* tp_members */
    _FcalDOCAtoTrack_getsetters,       /* tp_getset */
    &_HDDM_Element_type,       /* tp_base */
    0,                         /* tp_dict */
    0,                         /* tp_descr_get */
    0,                         /* tp_descr_set */
    0,                         /* tp_dictoffset */
    (initproc)_FcalDOCAtoTrack_init,   /* tp_init */
    0,                         /* tp_alloc */
    _FcalDOCAtoTrack_new,              /* tp_new */
};



// wrap element class hddm_r::TflightPCorrelation as hddm_r.TflightPCorrelation

typedef struct {
   PyObject_HEAD
   TflightPCorrelation *elem;
   PyObject *host;
} _TflightPCorrelation;

static void
_TflightPCorrelation_dealloc(_TflightPCorrelation* self)
{
   if (self->elem != 0) {
      LOG_DEALLOC(Py_TYPE(self), 0, self->host == (PyObject*)self);
      if (self->host == (PyObject*)self)
         delete self->elem;
      else
         My_DECREF(self->host);
   }
   Py_TYPE(self)->tp_free((PyObject*)self);
}

static PyObject*
_TflightPCorrelation_new(PyTypeObject *type, PyObject *args, PyObject *kwds)
{
   _TflightPCorrelation *self;
   self = (_TflightPCorrelation*)type->tp_alloc(type, 0);
   if (self != NULL) {
      self->elem = 0;
      self->host = 0;
   }
   return (PyObject*)self;
}

static int
_TflightPCorrelation_init(_TflightPCorrelation *self, PyObject *args, PyObject *kwds)
{
   PyErr_SetString(PyExc_RuntimeError, "illegal constructor");
   return -1;
}

static PyObject*
_TflightPCorrelation_getClass(_TflightPCorrelation *self, void *closure)
{
   std::string val(self->elem->getClass());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_TflightPCorrelation_getVersion(_TflightPCorrelation *self, void *closure)
{
   std::string val(self->elem->getVersion());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_TflightPCorrelation_getXmlns(_TflightPCorrelation *self, void *closure)
{
   std::string val(self->elem->getXmlns());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_TflightPCorrelation_getEventNo(_TflightPCorrelation *self, void *closure)
{
   return PyLong_FromLongLong(self->elem->getEventNo());
}

static PyObject*
_TflightPCorrelation_getRunNo(_TflightPCorrelation *self, void *closure)
{
   return PyLong_FromLong(self->elem->getRunNo());
}

static PyObject*
_TflightPCorrelation_getJtag(_TflightPCorrelation *self, void *closure)
{
   std::string val(self->elem->getJtag());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_TflightPCorrelation_getCorrelation(_TflightPCorrelation *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getCorrelation());
}

static int
_TflightPCorrelation_setCorrelation(_TflightPCorrelation *self, PyObject *value, void *closure)
{
   double var = PyFloat_AsDouble(value);
   if (var == -1 && PyErr_Occurred()) {
      return 1;
   }
   self->elem->setCorrelation((float)var);
   return 0;
}

static PyObject*
_TflightPCorrelation_getMaxOccurs(_TflightPCorrelation *self, void *closure)
{
   std::string val(self->elem->getMaxOccurs());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_TflightPCorrelation_getMinOccurs(_TflightPCorrelation *self, void *closure)
{
   return PyLong_FromLong(self->elem->getMinOccurs());
}

static PyObject*
_TflightPCorrelation_getPunit(_TflightPCorrelation *self, void *closure)
{
   std::string val(self->elem->getPunit());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_TflightPCorrelation_getSystem(_TflightPCorrelation *self, void *closure)
{
   return PyLong_FromLong(self->elem->getSystem());
}

static int
_TflightPCorrelation_setSystem(_TflightPCorrelation *self, PyObject *value, void *closure)
{
   long var = PyInt_AsLong(value);
   if (var == -1 && PyErr_Occurred()) {
      return -1;
   }
   self->elem->setSystem(var);
   return 0;
}

static PyObject*
_TflightPCorrelation_getTrack(_TflightPCorrelation *self, void *closure)
{
   return PyLong_FromLong(self->elem->getTrack());
}

static int
_TflightPCorrelation_setTrack(_TflightPCorrelation *self, PyObject *value, void *closure)
{
   long var = PyInt_AsLong(value);
   if (var == -1 && PyErr_Occurred()) {
      return -1;
   }
   self->elem->setTrack(var);
   return 0;
}

static PyObject*
_TflightPCorrelation_getTunit(_TflightPCorrelation *self, void *closure)
{
   std::string val(self->elem->getTunit());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_TflightPCorrelation_toString(PyObject *self, PyObject *args=0)
{
   _TflightPCorrelation *me = (_TflightPCorrelation*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid tflightPCorrelation element");
      return NULL;
   }
   std::string str(me->elem->toString());
   return PyUnicode_FromString(str.c_str());
}

static PyObject*
_TflightPCorrelation_toXML(PyObject *self, PyObject *args=0)
{
   _TflightPCorrelation *me = (_TflightPCorrelation*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid tflightPCorrelation element");
      return NULL;
   }
   std::string str(me->elem->toXML());
   return PyUnicode_FromString(str.c_str());
}

static PyGetSetDef _TflightPCorrelation_getsetters[] = {
   {(char*)"class",
    (getter)_TflightPCorrelation_getClass, 0,
    (char*)"class string",
    NULL},
   {(char*)"correlation",
    (getter)_TflightPCorrelation_getCorrelation, (setter)_TflightPCorrelation_setCorrelation,
    (char*)"correlation value",
    NULL},
   {(char*)"eventNo",
    (getter)_TflightPCorrelation_getEventNo, 0,
    (char*)"eventNo value",
    NULL},
   {(char*)"jtag",
    (getter)_TflightPCorrelation_getJtag, 0,
    (char*)"jtag string",
    NULL},
   {(char*)"maxOccurs",
    (getter)_TflightPCorrelation_getMaxOccurs, 0,
    (char*)"maxOccurs value",
    NULL},
   {(char*)"minOccurs",
    (getter)_TflightPCorrelation_getMinOccurs, 0,
    (char*)"minOccurs value",
    NULL},
   {(char*)"punit",
    (getter)_TflightPCorrelation_getPunit, 0,
    (char*)"punit value",
    NULL},
   {(char*)"runNo",
    (getter)_TflightPCorrelation_getRunNo, 0,
    (char*)"runNo value",
    NULL},
   {(char*)"system",
    (getter)_TflightPCorrelation_getSystem, (setter)_TflightPCorrelation_setSystem,
    (char*)"system value",
    NULL},
   {(char*)"track",
    (getter)_TflightPCorrelation_getTrack, (setter)_TflightPCorrelation_setTrack,
    (char*)"track value",
    NULL},
   {(char*)"tunit",
    (getter)_TflightPCorrelation_getTunit, 0,
    (char*)"tunit value",
    NULL},
   {(char*)"version",
    (getter)_TflightPCorrelation_getVersion, 0,
    (char*)"version string",
    NULL},
   {(char*)"xmlns",
    (getter)_TflightPCorrelation_getXmlns, 0,
    (char*)"xmlns string",
    NULL},
   {NULL}  /* Sentinel */
};

static PyMemberDef _TflightPCorrelation_members[] = {
   {NULL}  /* Sentinel */
};

static PyMethodDef _TflightPCorrelation_methods[] = {
   {"toString", _TflightPCorrelation_toString, METH_NOARGS,
    "show element as a human-readable string"},
   {"toXML", _TflightPCorrelation_toXML, METH_NOARGS,
    "show element as a XML fragment"},
   {NULL}  /* Sentinel */
};

static PyTypeObject _TflightPCorrelation_type = {
    PyVarObject_HEAD_INIT(NULL,0)
    "hddm_r.TflightPCorrelation",         /*tp_name*/
    sizeof(_TflightPCorrelation),          /*tp_basicsize*/
    0,                         /*tp_itemsize*/
    (destructor)_TflightPCorrelation_dealloc, /*tp_dealloc*/
    0,                         /*tp_print*/
    0,                         /*tp_getattr*/
    0,                         /*tp_setattr*/
    0,                         /*tp_compare*/
    0,                         /*tp_repr*/
    0,                         /*tp_as_number*/
    0,                         /*tp_as_sequence*/
    0,                         /*tp_as_mapping*/
    0,                         /*tp_hash */
    0,                         /*tp_call*/
    (reprfunc)_TflightPCorrelation_toString,         /*tp_str*/
    0,                         /*tp_getattro*/
    0,                         /*tp_setattro*/
    0,                         /*tp_as_buffer*/
    Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE, /*tp_flags*/
    "hddm_r tflightPCorrelation element",  /* tp_doc */
    0,                         /* tp_traverse */
    0,                         /* tp_clear */
    0,                         /* tp_richcompare */
    0,                         /* tp_weaklistoffset */
    0,                         /* tp_iter */
    0,                         /* tp_iternext */
    _TflightPCorrelation_methods,          /* tp_methods */
    _TflightPCorrelation_members,          /* tp_members */
    _TflightPCorrelation_getsetters,       /* tp_getset */
    &_HDDM_Element_type,       /* tp_base */
    0,                         /* tp_dict */
    0,                         /* tp_descr_get */
    0,                         /* tp_descr_set */
    0,                         /* tp_dictoffset */
    (initproc)_TflightPCorrelation_init,   /* tp_init */
    0,                         /* tp_alloc */
    _TflightPCorrelation_new,              /* tp_new */
};



// wrap element class hddm_r::DetectorMatches as hddm_r.DetectorMatches

typedef struct {
   PyObject_HEAD
   DetectorMatches *elem;
   PyObject *host;
} _DetectorMatches;

static void
_DetectorMatches_dealloc(_DetectorMatches* self)
{
   if (self->elem != 0) {
      LOG_DEALLOC(Py_TYPE(self), 0, self->host == (PyObject*)self);
      if (self->host == (PyObject*)self)
         delete self->elem;
      else
         My_DECREF(self->host);
   }
   Py_TYPE(self)->tp_free((PyObject*)self);
}

static PyObject*
_DetectorMatches_new(PyTypeObject *type, PyObject *args, PyObject *kwds)
{
   _DetectorMatches *self;
   self = (_DetectorMatches*)type->tp_alloc(type, 0);
   if (self != NULL) {
      self->elem = 0;
      self->host = 0;
   }
   return (PyObject*)self;
}

static int
_DetectorMatches_init(_DetectorMatches *self, PyObject *args, PyObject *kwds)
{
   PyErr_SetString(PyExc_RuntimeError, "illegal constructor");
   return -1;
}

static PyObject*
_DetectorMatches_getClass(_DetectorMatches *self, void *closure)
{
   std::string val(self->elem->getClass());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_DetectorMatches_getVersion(_DetectorMatches *self, void *closure)
{
   std::string val(self->elem->getVersion());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_DetectorMatches_getXmlns(_DetectorMatches *self, void *closure)
{
   std::string val(self->elem->getXmlns());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_DetectorMatches_getEventNo(_DetectorMatches *self, void *closure)
{
   return PyLong_FromLongLong(self->elem->getEventNo());
}

static PyObject*
_DetectorMatches_getRunNo(_DetectorMatches *self, void *closure)
{
   return PyLong_FromLong(self->elem->getRunNo());
}

static PyObject*
_DetectorMatches_getJtag(_DetectorMatches *self, void *closure)
{
   std::string val(self->elem->getJtag());
   return PyUnicode_FromString(val.c_str());
}

static int
_DetectorMatches_setJtag(_DetectorMatches *self, PyObject *value, void *closure)
{
   PyObject *str=0;
   if (PyUnicode_Check(value))
      str = PyUnicode_AsEncodedString(value, "ASCII", "strict");
   else
      str = value;
#if PY_MAJOR_VERSION < 3
   char *var = PyString_AsString(str);
#else
   char *var = PyBytes_AsString(str);
#endif
   if (var == 0) {
      return -1;
   }
   self->elem->setJtag(std::string(var));
   if (str != value) {
      Py_DECREF(str);
   }
   return 0;
}

static PyObject*
_DetectorMatches_getMaxOccurs(_DetectorMatches *self, void *closure)
{
   return PyLong_FromLong(self->elem->getMaxOccurs());
}

static PyObject*
_DetectorMatches_getMinOccurs(_DetectorMatches *self, void *closure)
{
   return PyLong_FromLong(self->elem->getMinOccurs());
}

static PyObject*
_DetectorMatches_getBcalMatchParams(PyObject *self, PyObject *args)
{
   int index=0;
   if (! PyArg_ParseTuple(args, "|i", &index)) {
      return NULL;
   }
   _DetectorMatches *me = (_DetectorMatches*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid detectorMatches element");
      return NULL;
   }
   PyObject *obj = _BcalMatchParams_new(&_BcalMatchParams_type, 0, 0);
   ((_BcalMatchParams*)obj)->elem = &me->elem->getBcalMatchParams(index);
   ((_BcalMatchParams*)obj)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(obj));
   return obj;
}

static PyObject*
_DetectorMatches_getBcalMatchParamses(PyObject *self, PyObject *args)
{
   _DetectorMatches *me = (_DetectorMatches*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid detectorMatches element");
      return NULL;
   }
   PyObject *list = _HDDM_ElementList_new(&_HDDM_ElementList_type, 0, 0);
   ((_HDDM_ElementList*)list)->subtype = &_BcalMatchParams_type;
   ((_HDDM_ElementList*)list)->list = (HDDM_ElementList<HDDM_Element>*)
    &me->elem->getBcalMatchParamses();
   ((_HDDM_ElementList*)list)->borrowed = 1;
   ((_HDDM_ElementList*)list)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(list), ((_HDDM_ElementList*)list)->subtype, 0);
   return list;
}

static PyObject*
_DetectorMatches_addBcalMatchParamses(PyObject *self, PyObject *args)
{
   int count=1;
   int start=-1;
   if (! PyArg_ParseTuple(args, "|ii", &count, &start)) {
      return NULL;
   }
   _DetectorMatches *me = (_DetectorMatches*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "add attempted on invalid detectorMatches element");
      return NULL;
   }
   PyObject *list = _HDDM_ElementList_new(&_HDDM_ElementList_type, 0, 0);
   ((_HDDM_ElementList*)list)->subtype = &_BcalMatchParams_type;
   ((_HDDM_ElementList*)list)->list = (HDDM_ElementList<HDDM_Element>*)
    new BcalMatchParamsList(me->elem->addBcalMatchParamses(count, start));
   ((_HDDM_ElementList*)list)->borrowed = 0;
   ((_HDDM_ElementList*)list)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(list), ((_HDDM_ElementList*)list)->subtype, 1);
   return list;
}

static PyObject*
_DetectorMatches_deleteBcalMatchParamses(PyObject *self, PyObject *args)
{
   int count=-1;
   int start=0;
   if (! PyArg_ParseTuple(args, "|ii", &count, &start)) {
      return NULL;
   }
   _DetectorMatches *me = (_DetectorMatches*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "delete attempted on invalid detectorMatches element");
      return NULL;
   }
   me->elem->deleteBcalMatchParamses(count, start);
   Py_INCREF(Py_None);
   return Py_None;
}

static PyObject*
_DetectorMatches_getFcalMatchParams(PyObject *self, PyObject *args)
{
   int index=0;
   if (! PyArg_ParseTuple(args, "|i", &index)) {
      return NULL;
   }
   _DetectorMatches *me = (_DetectorMatches*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid detectorMatches element");
      return NULL;
   }
   PyObject *obj = _FcalMatchParams_new(&_FcalMatchParams_type, 0, 0);
   ((_FcalMatchParams*)obj)->elem = &me->elem->getFcalMatchParams(index);
   ((_FcalMatchParams*)obj)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(obj));
   return obj;
}

static PyObject*
_DetectorMatches_getFcalMatchParamses(PyObject *self, PyObject *args)
{
   _DetectorMatches *me = (_DetectorMatches*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid detectorMatches element");
      return NULL;
   }
   PyObject *list = _HDDM_ElementList_new(&_HDDM_ElementList_type, 0, 0);
   ((_HDDM_ElementList*)list)->subtype = &_FcalMatchParams_type;
   ((_HDDM_ElementList*)list)->list = (HDDM_ElementList<HDDM_Element>*)
    &me->elem->getFcalMatchParamses();
   ((_HDDM_ElementList*)list)->borrowed = 1;
   ((_HDDM_ElementList*)list)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(list), ((_HDDM_ElementList*)list)->subtype, 0);
   return list;
}

static PyObject*
_DetectorMatches_addFcalMatchParamses(PyObject *self, PyObject *args)
{
   int count=1;
   int start=-1;
   if (! PyArg_ParseTuple(args, "|ii", &count, &start)) {
      return NULL;
   }
   _DetectorMatches *me = (_DetectorMatches*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "add attempted on invalid detectorMatches element");
      return NULL;
   }
   PyObject *list = _HDDM_ElementList_new(&_HDDM_ElementList_type, 0, 0);
   ((_HDDM_ElementList*)list)->subtype = &_FcalMatchParams_type;
   ((_HDDM_ElementList*)list)->list = (HDDM_ElementList<HDDM_Element>*)
    new FcalMatchParamsList(me->elem->addFcalMatchParamses(count, start));
   ((_HDDM_ElementList*)list)->borrowed = 0;
   ((_HDDM_ElementList*)list)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(list), ((_HDDM_ElementList*)list)->subtype, 1);
   return list;
}

static PyObject*
_DetectorMatches_deleteFcalMatchParamses(PyObject *self, PyObject *args)
{
   int count=-1;
   int start=0;
   if (! PyArg_ParseTuple(args, "|ii", &count, &start)) {
      return NULL;
   }
   _DetectorMatches *me = (_DetectorMatches*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "delete attempted on invalid detectorMatches element");
      return NULL;
   }
   me->elem->deleteFcalMatchParamses(count, start);
   Py_INCREF(Py_None);
   return Py_None;
}

static PyObject*
_DetectorMatches_getFcalSingleHitMatchParams(PyObject *self, PyObject *args)
{
   int index=0;
   if (! PyArg_ParseTuple(args, "|i", &index)) {
      return NULL;
   }
   _DetectorMatches *me = (_DetectorMatches*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid detectorMatches element");
      return NULL;
   }
   PyObject *obj = _FcalSingleHitMatchParams_new(&_FcalSingleHitMatchParams_type, 0, 0);
   ((_FcalSingleHitMatchParams*)obj)->elem = &me->elem->getFcalSingleHitMatchParams(index);
   ((_FcalSingleHitMatchParams*)obj)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(obj));
   return obj;
}

static PyObject*
_DetectorMatches_getFcalSingleHitMatchParamses(PyObject *self, PyObject *args)
{
   _DetectorMatches *me = (_DetectorMatches*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid detectorMatches element");
      return NULL;
   }
   PyObject *list = _HDDM_ElementList_new(&_HDDM_ElementList_type, 0, 0);
   ((_HDDM_ElementList*)list)->subtype = &_FcalSingleHitMatchParams_type;
   ((_HDDM_ElementList*)list)->list = (HDDM_ElementList<HDDM_Element>*)
    &me->elem->getFcalSingleHitMatchParamses();
   ((_HDDM_ElementList*)list)->borrowed = 1;
   ((_HDDM_ElementList*)list)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(list), ((_HDDM_ElementList*)list)->subtype, 0);
   return list;
}

static PyObject*
_DetectorMatches_addFcalSingleHitMatchParamses(PyObject *self, PyObject *args)
{
   int count=1;
   int start=-1;
   if (! PyArg_ParseTuple(args, "|ii", &count, &start)) {
      return NULL;
   }
   _DetectorMatches *me = (_DetectorMatches*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "add attempted on invalid detectorMatches element");
      return NULL;
   }
   PyObject *list = _HDDM_ElementList_new(&_HDDM_ElementList_type, 0, 0);
   ((_HDDM_ElementList*)list)->subtype = &_FcalSingleHitMatchParams_type;
   ((_HDDM_ElementList*)list)->list = (HDDM_ElementList<HDDM_Element>*)
    new FcalSingleHitMatchParamsList(me->elem->addFcalSingleHitMatchParamses(count, start));
   ((_HDDM_ElementList*)list)->borrowed = 0;
   ((_HDDM_ElementList*)list)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(list), ((_HDDM_ElementList*)list)->subtype, 1);
   return list;
}

static PyObject*
_DetectorMatches_deleteFcalSingleHitMatchParamses(PyObject *self, PyObject *args)
{
   int count=-1;
   int start=0;
   if (! PyArg_ParseTuple(args, "|ii", &count, &start)) {
      return NULL;
   }
   _DetectorMatches *me = (_DetectorMatches*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "delete attempted on invalid detectorMatches element");
      return NULL;
   }
   me->elem->deleteFcalSingleHitMatchParamses(count, start);
   Py_INCREF(Py_None);
   return Py_None;
}

static PyObject*
_DetectorMatches_getCtofMatchParams(PyObject *self, PyObject *args)
{
   int index=0;
   if (! PyArg_ParseTuple(args, "|i", &index)) {
      return NULL;
   }
   _DetectorMatches *me = (_DetectorMatches*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid detectorMatches element");
      return NULL;
   }
   PyObject *obj = _CtofMatchParams_new(&_CtofMatchParams_type, 0, 0);
   ((_CtofMatchParams*)obj)->elem = &me->elem->getCtofMatchParams(index);
   ((_CtofMatchParams*)obj)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(obj));
   return obj;
}

static PyObject*
_DetectorMatches_getCtofMatchParamses(PyObject *self, PyObject *args)
{
   _DetectorMatches *me = (_DetectorMatches*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid detectorMatches element");
      return NULL;
   }
   PyObject *list = _HDDM_ElementList_new(&_HDDM_ElementList_type, 0, 0);
   ((_HDDM_ElementList*)list)->subtype = &_CtofMatchParams_type;
   ((_HDDM_ElementList*)list)->list = (HDDM_ElementList<HDDM_Element>*)
    &me->elem->getCtofMatchParamses();
   ((_HDDM_ElementList*)list)->borrowed = 1;
   ((_HDDM_ElementList*)list)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(list), ((_HDDM_ElementList*)list)->subtype, 0);
   return list;
}

static PyObject*
_DetectorMatches_addCtofMatchParamses(PyObject *self, PyObject *args)
{
   int count=1;
   int start=-1;
   if (! PyArg_ParseTuple(args, "|ii", &count, &start)) {
      return NULL;
   }
   _DetectorMatches *me = (_DetectorMatches*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "add attempted on invalid detectorMatches element");
      return NULL;
   }
   PyObject *list = _HDDM_ElementList_new(&_HDDM_ElementList_type, 0, 0);
   ((_HDDM_ElementList*)list)->subtype = &_CtofMatchParams_type;
   ((_HDDM_ElementList*)list)->list = (HDDM_ElementList<HDDM_Element>*)
    new CtofMatchParamsList(me->elem->addCtofMatchParamses(count, start));
   ((_HDDM_ElementList*)list)->borrowed = 0;
   ((_HDDM_ElementList*)list)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(list), ((_HDDM_ElementList*)list)->subtype, 1);
   return list;
}

static PyObject*
_DetectorMatches_deleteCtofMatchParamses(PyObject *self, PyObject *args)
{
   int count=-1;
   int start=0;
   if (! PyArg_ParseTuple(args, "|ii", &count, &start)) {
      return NULL;
   }
   _DetectorMatches *me = (_DetectorMatches*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "delete attempted on invalid detectorMatches element");
      return NULL;
   }
   me->elem->deleteCtofMatchParamses(count, start);
   Py_INCREF(Py_None);
   return Py_None;
}

static PyObject*
_DetectorMatches_getFmwpcMatchParams(PyObject *self, PyObject *args)
{
   int index=0;
   if (! PyArg_ParseTuple(args, "|i", &index)) {
      return NULL;
   }
   _DetectorMatches *me = (_DetectorMatches*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid detectorMatches element");
      return NULL;
   }
   PyObject *obj = _FmwpcMatchParams_new(&_FmwpcMatchParams_type, 0, 0);
   ((_FmwpcMatchParams*)obj)->elem = &me->elem->getFmwpcMatchParams(index);
   ((_FmwpcMatchParams*)obj)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(obj));
   return obj;
}

static PyObject*
_DetectorMatches_getFmwpcMatchParamses(PyObject *self, PyObject *args)
{
   _DetectorMatches *me = (_DetectorMatches*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid detectorMatches element");
      return NULL;
   }
   PyObject *list = _HDDM_ElementList_new(&_HDDM_ElementList_type, 0, 0);
   ((_HDDM_ElementList*)list)->subtype = &_FmwpcMatchParams_type;
   ((_HDDM_ElementList*)list)->list = (HDDM_ElementList<HDDM_Element>*)
    &me->elem->getFmwpcMatchParamses();
   ((_HDDM_ElementList*)list)->borrowed = 1;
   ((_HDDM_ElementList*)list)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(list), ((_HDDM_ElementList*)list)->subtype, 0);
   return list;
}

static PyObject*
_DetectorMatches_addFmwpcMatchParamses(PyObject *self, PyObject *args)
{
   int count=1;
   int start=-1;
   if (! PyArg_ParseTuple(args, "|ii", &count, &start)) {
      return NULL;
   }
   _DetectorMatches *me = (_DetectorMatches*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "add attempted on invalid detectorMatches element");
      return NULL;
   }
   PyObject *list = _HDDM_ElementList_new(&_HDDM_ElementList_type, 0, 0);
   ((_HDDM_ElementList*)list)->subtype = &_FmwpcMatchParams_type;
   ((_HDDM_ElementList*)list)->list = (HDDM_ElementList<HDDM_Element>*)
    new FmwpcMatchParamsList(me->elem->addFmwpcMatchParamses(count, start));
   ((_HDDM_ElementList*)list)->borrowed = 0;
   ((_HDDM_ElementList*)list)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(list), ((_HDDM_ElementList*)list)->subtype, 1);
   return list;
}

static PyObject*
_DetectorMatches_deleteFmwpcMatchParamses(PyObject *self, PyObject *args)
{
   int count=-1;
   int start=0;
   if (! PyArg_ParseTuple(args, "|ii", &count, &start)) {
      return NULL;
   }
   _DetectorMatches *me = (_DetectorMatches*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "delete attempted on invalid detectorMatches element");
      return NULL;
   }
   me->elem->deleteFmwpcMatchParamses(count, start);
   Py_INCREF(Py_None);
   return Py_None;
}

static PyObject*
_DetectorMatches_getTofMatchParams(PyObject *self, PyObject *args)
{
   int index=0;
   if (! PyArg_ParseTuple(args, "|i", &index)) {
      return NULL;
   }
   _DetectorMatches *me = (_DetectorMatches*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid detectorMatches element");
      return NULL;
   }
   PyObject *obj = _TofMatchParams_new(&_TofMatchParams_type, 0, 0);
   ((_TofMatchParams*)obj)->elem = &me->elem->getTofMatchParams(index);
   ((_TofMatchParams*)obj)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(obj));
   return obj;
}

static PyObject*
_DetectorMatches_getTofMatchParamses(PyObject *self, PyObject *args)
{
   _DetectorMatches *me = (_DetectorMatches*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid detectorMatches element");
      return NULL;
   }
   PyObject *list = _HDDM_ElementList_new(&_HDDM_ElementList_type, 0, 0);
   ((_HDDM_ElementList*)list)->subtype = &_TofMatchParams_type;
   ((_HDDM_ElementList*)list)->list = (HDDM_ElementList<HDDM_Element>*)
    &me->elem->getTofMatchParamses();
   ((_HDDM_ElementList*)list)->borrowed = 1;
   ((_HDDM_ElementList*)list)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(list), ((_HDDM_ElementList*)list)->subtype, 0);
   return list;
}

static PyObject*
_DetectorMatches_addTofMatchParamses(PyObject *self, PyObject *args)
{
   int count=1;
   int start=-1;
   if (! PyArg_ParseTuple(args, "|ii", &count, &start)) {
      return NULL;
   }
   _DetectorMatches *me = (_DetectorMatches*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "add attempted on invalid detectorMatches element");
      return NULL;
   }
   PyObject *list = _HDDM_ElementList_new(&_HDDM_ElementList_type, 0, 0);
   ((_HDDM_ElementList*)list)->subtype = &_TofMatchParams_type;
   ((_HDDM_ElementList*)list)->list = (HDDM_ElementList<HDDM_Element>*)
    new TofMatchParamsList(me->elem->addTofMatchParamses(count, start));
   ((_HDDM_ElementList*)list)->borrowed = 0;
   ((_HDDM_ElementList*)list)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(list), ((_HDDM_ElementList*)list)->subtype, 1);
   return list;
}

static PyObject*
_DetectorMatches_deleteTofMatchParamses(PyObject *self, PyObject *args)
{
   int count=-1;
   int start=0;
   if (! PyArg_ParseTuple(args, "|ii", &count, &start)) {
      return NULL;
   }
   _DetectorMatches *me = (_DetectorMatches*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "delete attempted on invalid detectorMatches element");
      return NULL;
   }
   me->elem->deleteTofMatchParamses(count, start);
   Py_INCREF(Py_None);
   return Py_None;
}

static PyObject*
_DetectorMatches_getScMatchParams(PyObject *self, PyObject *args)
{
   int index=0;
   if (! PyArg_ParseTuple(args, "|i", &index)) {
      return NULL;
   }
   _DetectorMatches *me = (_DetectorMatches*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid detectorMatches element");
      return NULL;
   }
   PyObject *obj = _ScMatchParams_new(&_ScMatchParams_type, 0, 0);
   ((_ScMatchParams*)obj)->elem = &me->elem->getScMatchParams(index);
   ((_ScMatchParams*)obj)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(obj));
   return obj;
}

static PyObject*
_DetectorMatches_getScMatchParamses(PyObject *self, PyObject *args)
{
   _DetectorMatches *me = (_DetectorMatches*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid detectorMatches element");
      return NULL;
   }
   PyObject *list = _HDDM_ElementList_new(&_HDDM_ElementList_type, 0, 0);
   ((_HDDM_ElementList*)list)->subtype = &_ScMatchParams_type;
   ((_HDDM_ElementList*)list)->list = (HDDM_ElementList<HDDM_Element>*)
    &me->elem->getScMatchParamses();
   ((_HDDM_ElementList*)list)->borrowed = 1;
   ((_HDDM_ElementList*)list)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(list), ((_HDDM_ElementList*)list)->subtype, 0);
   return list;
}

static PyObject*
_DetectorMatches_addScMatchParamses(PyObject *self, PyObject *args)
{
   int count=1;
   int start=-1;
   if (! PyArg_ParseTuple(args, "|ii", &count, &start)) {
      return NULL;
   }
   _DetectorMatches *me = (_DetectorMatches*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "add attempted on invalid detectorMatches element");
      return NULL;
   }
   PyObject *list = _HDDM_ElementList_new(&_HDDM_ElementList_type, 0, 0);
   ((_HDDM_ElementList*)list)->subtype = &_ScMatchParams_type;
   ((_HDDM_ElementList*)list)->list = (HDDM_ElementList<HDDM_Element>*)
    new ScMatchParamsList(me->elem->addScMatchParamses(count, start));
   ((_HDDM_ElementList*)list)->borrowed = 0;
   ((_HDDM_ElementList*)list)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(list), ((_HDDM_ElementList*)list)->subtype, 1);
   return list;
}

static PyObject*
_DetectorMatches_deleteScMatchParamses(PyObject *self, PyObject *args)
{
   int count=-1;
   int start=0;
   if (! PyArg_ParseTuple(args, "|ii", &count, &start)) {
      return NULL;
   }
   _DetectorMatches *me = (_DetectorMatches*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "delete attempted on invalid detectorMatches element");
      return NULL;
   }
   me->elem->deleteScMatchParamses(count, start);
   Py_INCREF(Py_None);
   return Py_None;
}

static PyObject*
_DetectorMatches_getDircMatchParams(PyObject *self, PyObject *args)
{
   int index=0;
   if (! PyArg_ParseTuple(args, "|i", &index)) {
      return NULL;
   }
   _DetectorMatches *me = (_DetectorMatches*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid detectorMatches element");
      return NULL;
   }
   PyObject *obj = _DircMatchParams_new(&_DircMatchParams_type, 0, 0);
   ((_DircMatchParams*)obj)->elem = &me->elem->getDircMatchParams(index);
   ((_DircMatchParams*)obj)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(obj));
   return obj;
}

static PyObject*
_DetectorMatches_getDircMatchParamses(PyObject *self, PyObject *args)
{
   _DetectorMatches *me = (_DetectorMatches*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid detectorMatches element");
      return NULL;
   }
   PyObject *list = _HDDM_ElementList_new(&_HDDM_ElementList_type, 0, 0);
   ((_HDDM_ElementList*)list)->subtype = &_DircMatchParams_type;
   ((_HDDM_ElementList*)list)->list = (HDDM_ElementList<HDDM_Element>*)
    &me->elem->getDircMatchParamses();
   ((_HDDM_ElementList*)list)->borrowed = 1;
   ((_HDDM_ElementList*)list)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(list), ((_HDDM_ElementList*)list)->subtype, 0);
   return list;
}

static PyObject*
_DetectorMatches_addDircMatchParamses(PyObject *self, PyObject *args)
{
   int count=1;
   int start=-1;
   if (! PyArg_ParseTuple(args, "|ii", &count, &start)) {
      return NULL;
   }
   _DetectorMatches *me = (_DetectorMatches*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "add attempted on invalid detectorMatches element");
      return NULL;
   }
   PyObject *list = _HDDM_ElementList_new(&_HDDM_ElementList_type, 0, 0);
   ((_HDDM_ElementList*)list)->subtype = &_DircMatchParams_type;
   ((_HDDM_ElementList*)list)->list = (HDDM_ElementList<HDDM_Element>*)
    new DircMatchParamsList(me->elem->addDircMatchParamses(count, start));
   ((_HDDM_ElementList*)list)->borrowed = 0;
   ((_HDDM_ElementList*)list)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(list), ((_HDDM_ElementList*)list)->subtype, 1);
   return list;
}

static PyObject*
_DetectorMatches_deleteDircMatchParamses(PyObject *self, PyObject *args)
{
   int count=-1;
   int start=0;
   if (! PyArg_ParseTuple(args, "|ii", &count, &start)) {
      return NULL;
   }
   _DetectorMatches *me = (_DetectorMatches*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "delete attempted on invalid detectorMatches element");
      return NULL;
   }
   me->elem->deleteDircMatchParamses(count, start);
   Py_INCREF(Py_None);
   return Py_None;
}

static PyObject*
_DetectorMatches_getDircMatchHit(PyObject *self, PyObject *args)
{
   int index=0;
   if (! PyArg_ParseTuple(args, "|i", &index)) {
      return NULL;
   }
   _DetectorMatches *me = (_DetectorMatches*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid detectorMatches element");
      return NULL;
   }
   PyObject *obj = _DircMatchHit_new(&_DircMatchHit_type, 0, 0);
   ((_DircMatchHit*)obj)->elem = &me->elem->getDircMatchHit(index);
   ((_DircMatchHit*)obj)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(obj));
   return obj;
}

static PyObject*
_DetectorMatches_getDircMatchHits(PyObject *self, PyObject *args)
{
   _DetectorMatches *me = (_DetectorMatches*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid detectorMatches element");
      return NULL;
   }
   PyObject *list = _HDDM_ElementList_new(&_HDDM_ElementList_type, 0, 0);
   ((_HDDM_ElementList*)list)->subtype = &_DircMatchHit_type;
   ((_HDDM_ElementList*)list)->list = (HDDM_ElementList<HDDM_Element>*)
    &me->elem->getDircMatchHits();
   ((_HDDM_ElementList*)list)->borrowed = 1;
   ((_HDDM_ElementList*)list)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(list), ((_HDDM_ElementList*)list)->subtype, 0);
   return list;
}

static PyObject*
_DetectorMatches_addDircMatchHits(PyObject *self, PyObject *args)
{
   int count=1;
   int start=-1;
   if (! PyArg_ParseTuple(args, "|ii", &count, &start)) {
      return NULL;
   }
   _DetectorMatches *me = (_DetectorMatches*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "add attempted on invalid detectorMatches element");
      return NULL;
   }
   PyObject *list = _HDDM_ElementList_new(&_HDDM_ElementList_type, 0, 0);
   ((_HDDM_ElementList*)list)->subtype = &_DircMatchHit_type;
   ((_HDDM_ElementList*)list)->list = (HDDM_ElementList<HDDM_Element>*)
    new DircMatchHitList(me->elem->addDircMatchHits(count, start));
   ((_HDDM_ElementList*)list)->borrowed = 0;
   ((_HDDM_ElementList*)list)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(list), ((_HDDM_ElementList*)list)->subtype, 1);
   return list;
}

static PyObject*
_DetectorMatches_deleteDircMatchHits(PyObject *self, PyObject *args)
{
   int count=-1;
   int start=0;
   if (! PyArg_ParseTuple(args, "|ii", &count, &start)) {
      return NULL;
   }
   _DetectorMatches *me = (_DetectorMatches*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "delete attempted on invalid detectorMatches element");
      return NULL;
   }
   me->elem->deleteDircMatchHits(count, start);
   Py_INCREF(Py_None);
   return Py_None;
}

static PyObject*
_DetectorMatches_getBcalDOCAtoTrack(PyObject *self, PyObject *args)
{
   int index=0;
   if (! PyArg_ParseTuple(args, "|i", &index)) {
      return NULL;
   }
   _DetectorMatches *me = (_DetectorMatches*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid detectorMatches element");
      return NULL;
   }
   PyObject *obj = _BcalDOCAtoTrack_new(&_BcalDOCAtoTrack_type, 0, 0);
   ((_BcalDOCAtoTrack*)obj)->elem = &me->elem->getBcalDOCAtoTrack(index);
   ((_BcalDOCAtoTrack*)obj)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(obj));
   return obj;
}

static PyObject*
_DetectorMatches_getBcalDOCAtoTracks(PyObject *self, PyObject *args)
{
   _DetectorMatches *me = (_DetectorMatches*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid detectorMatches element");
      return NULL;
   }
   PyObject *list = _HDDM_ElementList_new(&_HDDM_ElementList_type, 0, 0);
   ((_HDDM_ElementList*)list)->subtype = &_BcalDOCAtoTrack_type;
   ((_HDDM_ElementList*)list)->list = (HDDM_ElementList<HDDM_Element>*)
    &me->elem->getBcalDOCAtoTracks();
   ((_HDDM_ElementList*)list)->borrowed = 1;
   ((_HDDM_ElementList*)list)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(list), ((_HDDM_ElementList*)list)->subtype, 0);
   return list;
}

static PyObject*
_DetectorMatches_addBcalDOCAtoTracks(PyObject *self, PyObject *args)
{
   int count=1;
   int start=-1;
   if (! PyArg_ParseTuple(args, "|ii", &count, &start)) {
      return NULL;
   }
   _DetectorMatches *me = (_DetectorMatches*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "add attempted on invalid detectorMatches element");
      return NULL;
   }
   PyObject *list = _HDDM_ElementList_new(&_HDDM_ElementList_type, 0, 0);
   ((_HDDM_ElementList*)list)->subtype = &_BcalDOCAtoTrack_type;
   ((_HDDM_ElementList*)list)->list = (HDDM_ElementList<HDDM_Element>*)
    new BcalDOCAtoTrackList(me->elem->addBcalDOCAtoTracks(count, start));
   ((_HDDM_ElementList*)list)->borrowed = 0;
   ((_HDDM_ElementList*)list)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(list), ((_HDDM_ElementList*)list)->subtype, 1);
   return list;
}

static PyObject*
_DetectorMatches_deleteBcalDOCAtoTracks(PyObject *self, PyObject *args)
{
   int count=-1;
   int start=0;
   if (! PyArg_ParseTuple(args, "|ii", &count, &start)) {
      return NULL;
   }
   _DetectorMatches *me = (_DetectorMatches*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "delete attempted on invalid detectorMatches element");
      return NULL;
   }
   me->elem->deleteBcalDOCAtoTracks(count, start);
   Py_INCREF(Py_None);
   return Py_None;
}

static PyObject*
_DetectorMatches_getFcalDOCAtoTrack(PyObject *self, PyObject *args)
{
   int index=0;
   if (! PyArg_ParseTuple(args, "|i", &index)) {
      return NULL;
   }
   _DetectorMatches *me = (_DetectorMatches*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid detectorMatches element");
      return NULL;
   }
   PyObject *obj = _FcalDOCAtoTrack_new(&_FcalDOCAtoTrack_type, 0, 0);
   ((_FcalDOCAtoTrack*)obj)->elem = &me->elem->getFcalDOCAtoTrack(index);
   ((_FcalDOCAtoTrack*)obj)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(obj));
   return obj;
}

static PyObject*
_DetectorMatches_getFcalDOCAtoTracks(PyObject *self, PyObject *args)
{
   _DetectorMatches *me = (_DetectorMatches*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid detectorMatches element");
      return NULL;
   }
   PyObject *list = _HDDM_ElementList_new(&_HDDM_ElementList_type, 0, 0);
   ((_HDDM_ElementList*)list)->subtype = &_FcalDOCAtoTrack_type;
   ((_HDDM_ElementList*)list)->list = (HDDM_ElementList<HDDM_Element>*)
    &me->elem->getFcalDOCAtoTracks();
   ((_HDDM_ElementList*)list)->borrowed = 1;
   ((_HDDM_ElementList*)list)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(list), ((_HDDM_ElementList*)list)->subtype, 0);
   return list;
}

static PyObject*
_DetectorMatches_addFcalDOCAtoTracks(PyObject *self, PyObject *args)
{
   int count=1;
   int start=-1;
   if (! PyArg_ParseTuple(args, "|ii", &count, &start)) {
      return NULL;
   }
   _DetectorMatches *me = (_DetectorMatches*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "add attempted on invalid detectorMatches element");
      return NULL;
   }
   PyObject *list = _HDDM_ElementList_new(&_HDDM_ElementList_type, 0, 0);
   ((_HDDM_ElementList*)list)->subtype = &_FcalDOCAtoTrack_type;
   ((_HDDM_ElementList*)list)->list = (HDDM_ElementList<HDDM_Element>*)
    new FcalDOCAtoTrackList(me->elem->addFcalDOCAtoTracks(count, start));
   ((_HDDM_ElementList*)list)->borrowed = 0;
   ((_HDDM_ElementList*)list)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(list), ((_HDDM_ElementList*)list)->subtype, 1);
   return list;
}

static PyObject*
_DetectorMatches_deleteFcalDOCAtoTracks(PyObject *self, PyObject *args)
{
   int count=-1;
   int start=0;
   if (! PyArg_ParseTuple(args, "|ii", &count, &start)) {
      return NULL;
   }
   _DetectorMatches *me = (_DetectorMatches*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "delete attempted on invalid detectorMatches element");
      return NULL;
   }
   me->elem->deleteFcalDOCAtoTracks(count, start);
   Py_INCREF(Py_None);
   return Py_None;
}

static PyObject*
_DetectorMatches_getTflightPCorrelation(PyObject *self, PyObject *args)
{
   int index=0;
   if (! PyArg_ParseTuple(args, "|i", &index)) {
      return NULL;
   }
   _DetectorMatches *me = (_DetectorMatches*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid detectorMatches element");
      return NULL;
   }
   PyObject *obj = _TflightPCorrelation_new(&_TflightPCorrelation_type, 0, 0);
   ((_TflightPCorrelation*)obj)->elem = &me->elem->getTflightPCorrelation(index);
   ((_TflightPCorrelation*)obj)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(obj));
   return obj;
}

static PyObject*
_DetectorMatches_getTflightPCorrelations(PyObject *self, PyObject *args)
{
   _DetectorMatches *me = (_DetectorMatches*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid detectorMatches element");
      return NULL;
   }
   PyObject *list = _HDDM_ElementList_new(&_HDDM_ElementList_type, 0, 0);
   ((_HDDM_ElementList*)list)->subtype = &_TflightPCorrelation_type;
   ((_HDDM_ElementList*)list)->list = (HDDM_ElementList<HDDM_Element>*)
    &me->elem->getTflightPCorrelations();
   ((_HDDM_ElementList*)list)->borrowed = 1;
   ((_HDDM_ElementList*)list)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(list), ((_HDDM_ElementList*)list)->subtype, 0);
   return list;
}

static PyObject*
_DetectorMatches_addTflightPCorrelations(PyObject *self, PyObject *args)
{
   int count=1;
   int start=-1;
   if (! PyArg_ParseTuple(args, "|ii", &count, &start)) {
      return NULL;
   }
   _DetectorMatches *me = (_DetectorMatches*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "add attempted on invalid detectorMatches element");
      return NULL;
   }
   PyObject *list = _HDDM_ElementList_new(&_HDDM_ElementList_type, 0, 0);
   ((_HDDM_ElementList*)list)->subtype = &_TflightPCorrelation_type;
   ((_HDDM_ElementList*)list)->list = (HDDM_ElementList<HDDM_Element>*)
    new TflightPCorrelationList(me->elem->addTflightPCorrelations(count, start));
   ((_HDDM_ElementList*)list)->borrowed = 0;
   ((_HDDM_ElementList*)list)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(list), ((_HDDM_ElementList*)list)->subtype, 1);
   return list;
}

static PyObject*
_DetectorMatches_deleteTflightPCorrelations(PyObject *self, PyObject *args)
{
   int count=-1;
   int start=0;
   if (! PyArg_ParseTuple(args, "|ii", &count, &start)) {
      return NULL;
   }
   _DetectorMatches *me = (_DetectorMatches*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "delete attempted on invalid detectorMatches element");
      return NULL;
   }
   me->elem->deleteTflightPCorrelations(count, start);
   Py_INCREF(Py_None);
   return Py_None;
}

static PyObject*
_DetectorMatches_toString(PyObject *self, PyObject *args=0)
{
   _DetectorMatches *me = (_DetectorMatches*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid detectorMatches element");
      return NULL;
   }
   std::string str(me->elem->toString());
   return PyUnicode_FromString(str.c_str());
}

static PyObject*
_DetectorMatches_toXML(PyObject *self, PyObject *args=0)
{
   _DetectorMatches *me = (_DetectorMatches*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid detectorMatches element");
      return NULL;
   }
   std::string str(me->elem->toXML());
   return PyUnicode_FromString(str.c_str());
}

static PyGetSetDef _DetectorMatches_getsetters[] = {
   {(char*)"class",
    (getter)_DetectorMatches_getClass, 0,
    (char*)"class string",
    NULL},
   {(char*)"eventNo",
    (getter)_DetectorMatches_getEventNo, 0,
    (char*)"eventNo value",
    NULL},
   {(char*)"jtag",
    (getter)_DetectorMatches_getJtag, (setter)_DetectorMatches_setJtag,
    (char*)"jtag string",
    NULL},
   {(char*)"maxOccurs",
    (getter)_DetectorMatches_getMaxOccurs, 0,
    (char*)"maxOccurs value",
    NULL},
   {(char*)"minOccurs",
    (getter)_DetectorMatches_getMinOccurs, 0,
    (char*)"minOccurs value",
    NULL},
   {(char*)"runNo",
    (getter)_DetectorMatches_getRunNo, 0,
    (char*)"runNo value",
    NULL},
   {(char*)"version",
    (getter)_DetectorMatches_getVersion, 0,
    (char*)"version string",
    NULL},
   {(char*)"xmlns",
    (getter)_DetectorMatches_getXmlns, 0,
    (char*)"xmlns string",
    NULL},
   {NULL}  /* Sentinel */
};

static PyMemberDef _DetectorMatches_members[] = {
   {NULL}  /* Sentinel */
};

static PyMethodDef _DetectorMatches_methods[] = {
   {"addBcalDOCAtoTracks", _DetectorMatches_addBcalDOCAtoTracks, METH_VARARGS,
    "extend (or insert into) the list of bcalDOCAtoTrack objects for this detectorMatches"},
   {"addBcalMatchParamses", _DetectorMatches_addBcalMatchParamses, METH_VARARGS,
    "extend (or insert into) the list of bcalMatchParams objects for this detectorMatches"},
   {"addCtofMatchParamses", _DetectorMatches_addCtofMatchParamses, METH_VARARGS,
    "extend (or insert into) the list of ctofMatchParams objects for this detectorMatches"},
   {"addDircMatchHits", _DetectorMatches_addDircMatchHits, METH_VARARGS,
    "extend (or insert into) the list of dircMatchHit objects for this detectorMatches"},
   {"addDircMatchParamses", _DetectorMatches_addDircMatchParamses, METH_VARARGS,
    "extend (or insert into) the list of dircMatchParams objects for this detectorMatches"},
   {"addFcalDOCAtoTracks", _DetectorMatches_addFcalDOCAtoTracks, METH_VARARGS,
    "extend (or insert into) the list of fcalDOCAtoTrack objects for this detectorMatches"},
   {"addFcalMatchParamses", _DetectorMatches_addFcalMatchParamses, METH_VARARGS,
    "extend (or insert into) the list of fcalMatchParams objects for this detectorMatches"},
   {"addFcalSingleHitMatchParamses", _DetectorMatches_addFcalSingleHitMatchParamses, METH_VARARGS,
    "extend (or insert into) the list of fcalSingleHitMatchParams objects for this detectorMatches"},
   {"addFmwpcMatchParamses", _DetectorMatches_addFmwpcMatchParamses, METH_VARARGS,
    "extend (or insert into) the list of fmwpcMatchParams objects for this detectorMatches"},
   {"addScMatchParamses", _DetectorMatches_addScMatchParamses, METH_VARARGS,
    "extend (or insert into) the list of scMatchParams objects for this detectorMatches"},
   {"addTflightPCorrelations", _DetectorMatches_addTflightPCorrelations, METH_VARARGS,
    "extend (or insert into) the list of tflightPCorrelation objects for this detectorMatches"},
   {"addTofMatchParamses", _DetectorMatches_addTofMatchParamses, METH_VARARGS,
    "extend (or insert into) the list of tofMatchParams objects for this detectorMatches"},
   {"deleteBcalDOCAtoTracks", _DetectorMatches_deleteBcalDOCAtoTracks, METH_VARARGS,
    "delete bcalDOCAtoTrack objects for this detectorMatches"},
   {"deleteBcalMatchParamses", _DetectorMatches_deleteBcalMatchParamses, METH_VARARGS,
    "delete bcalMatchParams objects for this detectorMatches"},
   {"deleteCtofMatchParamses", _DetectorMatches_deleteCtofMatchParamses, METH_VARARGS,
    "delete ctofMatchParams objects for this detectorMatches"},
   {"deleteDircMatchHits", _DetectorMatches_deleteDircMatchHits, METH_VARARGS,
    "delete dircMatchHit objects for this detectorMatches"},
   {"deleteDircMatchParamses", _DetectorMatches_deleteDircMatchParamses, METH_VARARGS,
    "delete dircMatchParams objects for this detectorMatches"},
   {"deleteFcalDOCAtoTracks", _DetectorMatches_deleteFcalDOCAtoTracks, METH_VARARGS,
    "delete fcalDOCAtoTrack objects for this detectorMatches"},
   {"deleteFcalMatchParamses", _DetectorMatches_deleteFcalMatchParamses, METH_VARARGS,
    "delete fcalMatchParams objects for this detectorMatches"},
   {"deleteFcalSingleHitMatchParamses", _DetectorMatches_deleteFcalSingleHitMatchParamses, METH_VARARGS,
    "delete fcalSingleHitMatchParams objects for this detectorMatches"},
   {"deleteFmwpcMatchParamses", _DetectorMatches_deleteFmwpcMatchParamses, METH_VARARGS,
    "delete fmwpcMatchParams objects for this detectorMatches"},
   {"deleteScMatchParamses", _DetectorMatches_deleteScMatchParamses, METH_VARARGS,
    "delete scMatchParams objects for this detectorMatches"},
   {"deleteTflightPCorrelations", _DetectorMatches_deleteTflightPCorrelations, METH_VARARGS,
    "delete tflightPCorrelation objects for this detectorMatches"},
   {"deleteTofMatchParamses", _DetectorMatches_deleteTofMatchParamses, METH_VARARGS,
    "delete tofMatchParams objects for this detectorMatches"},
   {"getBcalDOCAtoTrack", _DetectorMatches_getBcalDOCAtoTrack, METH_VARARGS,
    "get an individual bcalDOCAtoTrack object from this detectorMatches"},
   {"getBcalDOCAtoTracks", _DetectorMatches_getBcalDOCAtoTracks, METH_NOARGS,
    "get list of bcalDOCAtoTrack objects for this detectorMatches"},
   {"getBcalMatchParams", _DetectorMatches_getBcalMatchParams, METH_VARARGS,
    "get an individual bcalMatchParams object from this detectorMatches"},
   {"getBcalMatchParamses", _DetectorMatches_getBcalMatchParamses, METH_NOARGS,
    "get list of bcalMatchParams objects for this detectorMatches"},
   {"getCtofMatchParams", _DetectorMatches_getCtofMatchParams, METH_VARARGS,
    "get an individual ctofMatchParams object from this detectorMatches"},
   {"getCtofMatchParamses", _DetectorMatches_getCtofMatchParamses, METH_NOARGS,
    "get list of ctofMatchParams objects for this detectorMatches"},
   {"getDircMatchHit", _DetectorMatches_getDircMatchHit, METH_VARARGS,
    "get an individual dircMatchHit object from this detectorMatches"},
   {"getDircMatchHits", _DetectorMatches_getDircMatchHits, METH_NOARGS,
    "get list of dircMatchHit objects for this detectorMatches"},
   {"getDircMatchParams", _DetectorMatches_getDircMatchParams, METH_VARARGS,
    "get an individual dircMatchParams object from this detectorMatches"},
   {"getDircMatchParamses", _DetectorMatches_getDircMatchParamses, METH_NOARGS,
    "get list of dircMatchParams objects for this detectorMatches"},
   {"getFcalDOCAtoTrack", _DetectorMatches_getFcalDOCAtoTrack, METH_VARARGS,
    "get an individual fcalDOCAtoTrack object from this detectorMatches"},
   {"getFcalDOCAtoTracks", _DetectorMatches_getFcalDOCAtoTracks, METH_NOARGS,
    "get list of fcalDOCAtoTrack objects for this detectorMatches"},
   {"getFcalMatchParams", _DetectorMatches_getFcalMatchParams, METH_VARARGS,
    "get an individual fcalMatchParams object from this detectorMatches"},
   {"getFcalMatchParamses", _DetectorMatches_getFcalMatchParamses, METH_NOARGS,
    "get list of fcalMatchParams objects for this detectorMatches"},
   {"getFcalSingleHitMatchParams", _DetectorMatches_getFcalSingleHitMatchParams, METH_VARARGS,
    "get an individual fcalSingleHitMatchParams object from this detectorMatches"},
   {"getFcalSingleHitMatchParamses", _DetectorMatches_getFcalSingleHitMatchParamses, METH_NOARGS,
    "get list of fcalSingleHitMatchParams objects for this detectorMatches"},
   {"getFmwpcMatchParams", _DetectorMatches_getFmwpcMatchParams, METH_VARARGS,
    "get an individual fmwpcMatchParams object from this detectorMatches"},
   {"getFmwpcMatchParamses", _DetectorMatches_getFmwpcMatchParamses, METH_NOARGS,
    "get list of fmwpcMatchParams objects for this detectorMatches"},
   {"getScMatchParams", _DetectorMatches_getScMatchParams, METH_VARARGS,
    "get an individual scMatchParams object from this detectorMatches"},
   {"getScMatchParamses", _DetectorMatches_getScMatchParamses, METH_NOARGS,
    "get list of scMatchParams objects for this detectorMatches"},
   {"getTflightPCorrelation", _DetectorMatches_getTflightPCorrelation, METH_VARARGS,
    "get an individual tflightPCorrelation object from this detectorMatches"},
   {"getTflightPCorrelations", _DetectorMatches_getTflightPCorrelations, METH_NOARGS,
    "get list of tflightPCorrelation objects for this detectorMatches"},
   {"getTofMatchParams", _DetectorMatches_getTofMatchParams, METH_VARARGS,
    "get an individual tofMatchParams object from this detectorMatches"},
   {"getTofMatchParamses", _DetectorMatches_getTofMatchParamses, METH_NOARGS,
    "get list of tofMatchParams objects for this detectorMatches"},
   {"toString", _DetectorMatches_toString, METH_NOARGS,
    "show element as a human-readable string"},
   {"toXML", _DetectorMatches_toXML, METH_NOARGS,
    "show element as a XML fragment"},
   {NULL}  /* Sentinel */
};

static PyTypeObject _DetectorMatches_type = {
    PyVarObject_HEAD_INIT(NULL,0)
    "hddm_r.DetectorMatches",         /*tp_name*/
    sizeof(_DetectorMatches),          /*tp_basicsize*/
    0,                         /*tp_itemsize*/
    (destructor)_DetectorMatches_dealloc, /*tp_dealloc*/
    0,                         /*tp_print*/
    0,                         /*tp_getattr*/
    0,                         /*tp_setattr*/
    0,                         /*tp_compare*/
    0,                         /*tp_repr*/
    0,                         /*tp_as_number*/
    0,                         /*tp_as_sequence*/
    0,                         /*tp_as_mapping*/
    0,                         /*tp_hash */
    0,                         /*tp_call*/
    (reprfunc)_DetectorMatches_toString,         /*tp_str*/
    0,                         /*tp_getattro*/
    0,                         /*tp_setattro*/
    0,                         /*tp_as_buffer*/
    Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE, /*tp_flags*/
    "hddm_r detectorMatches element",  /* tp_doc */
    0,                         /* tp_traverse */
    0,                         /* tp_clear */
    0,                         /* tp_richcompare */
    0,                         /* tp_weaklistoffset */
    0,                         /* tp_iter */
    0,                         /* tp_iternext */
    _DetectorMatches_methods,          /* tp_methods */
    _DetectorMatches_members,          /* tp_members */
    _DetectorMatches_getsetters,       /* tp_getset */
    &_HDDM_Element_type,       /* tp_base */
    0,                         /* tp_dict */
    0,                         /* tp_descr_get */
    0,                         /* tp_descr_set */
    0,                         /* tp_dictoffset */
    (initproc)_DetectorMatches_init,   /* tp_init */
    0,                         /* tp_alloc */
    _DetectorMatches_new,              /* tp_new */
};



// wrap element class hddm_r::StartCounters as hddm_r.StartCounters

typedef struct {
   PyObject_HEAD
   StartCounters *elem;
   PyObject *host;
} _StartCounters;

static void
_StartCounters_dealloc(_StartCounters* self)
{
   if (self->elem != 0) {
      LOG_DEALLOC(Py_TYPE(self), 0, self->host == (PyObject*)self);
      if (self->host == (PyObject*)self)
         delete self->elem;
      else
         My_DECREF(self->host);
   }
   Py_TYPE(self)->tp_free((PyObject*)self);
}

static PyObject*
_StartCounters_new(PyTypeObject *type, PyObject *args, PyObject *kwds)
{
   _StartCounters *self;
   self = (_StartCounters*)type->tp_alloc(type, 0);
   if (self != NULL) {
      self->elem = 0;
      self->host = 0;
   }
   return (PyObject*)self;
}

static int
_StartCounters_init(_StartCounters *self, PyObject *args, PyObject *kwds)
{
   PyErr_SetString(PyExc_RuntimeError, "illegal constructor");
   return -1;
}

static PyObject*
_StartCounters_getClass(_StartCounters *self, void *closure)
{
   std::string val(self->elem->getClass());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_StartCounters_getVersion(_StartCounters *self, void *closure)
{
   std::string val(self->elem->getVersion());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_StartCounters_getXmlns(_StartCounters *self, void *closure)
{
   std::string val(self->elem->getXmlns());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_StartCounters_getEventNo(_StartCounters *self, void *closure)
{
   return PyLong_FromLongLong(self->elem->getEventNo());
}

static PyObject*
_StartCounters_getRunNo(_StartCounters *self, void *closure)
{
   return PyLong_FromLong(self->elem->getRunNo());
}

static PyObject*
_StartCounters_getJtag(_StartCounters *self, void *closure)
{
   std::string val(self->elem->getJtag());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_StartCounters_getCount(_StartCounters *self, void *closure)
{
   return PyLong_FromLong(self->elem->getCount());
}

static int
_StartCounters_setCount(_StartCounters *self, PyObject *value, void *closure)
{
   long var = PyInt_AsLong(value);
   if (var == -1 && PyErr_Occurred()) {
      return -1;
   }
   self->elem->setCount(var);
   return 0;
}

static PyObject*
_StartCounters_getMinOccurs(_StartCounters *self, void *closure)
{
   return PyLong_FromLong(self->elem->getMinOccurs());
}

static PyObject*
_StartCounters_toString(PyObject *self, PyObject *args=0)
{
   _StartCounters *me = (_StartCounters*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid startCounters element");
      return NULL;
   }
   std::string str(me->elem->toString());
   return PyUnicode_FromString(str.c_str());
}

static PyObject*
_StartCounters_toXML(PyObject *self, PyObject *args=0)
{
   _StartCounters *me = (_StartCounters*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid startCounters element");
      return NULL;
   }
   std::string str(me->elem->toXML());
   return PyUnicode_FromString(str.c_str());
}

static PyGetSetDef _StartCounters_getsetters[] = {
   {(char*)"class",
    (getter)_StartCounters_getClass, 0,
    (char*)"class string",
    NULL},
   {(char*)"count",
    (getter)_StartCounters_getCount, (setter)_StartCounters_setCount,
    (char*)"count value",
    NULL},
   {(char*)"eventNo",
    (getter)_StartCounters_getEventNo, 0,
    (char*)"eventNo value",
    NULL},
   {(char*)"jtag",
    (getter)_StartCounters_getJtag, 0,
    (char*)"jtag string",
    NULL},
   {(char*)"minOccurs",
    (getter)_StartCounters_getMinOccurs, 0,
    (char*)"minOccurs value",
    NULL},
   {(char*)"runNo",
    (getter)_StartCounters_getRunNo, 0,
    (char*)"runNo value",
    NULL},
   {(char*)"version",
    (getter)_StartCounters_getVersion, 0,
    (char*)"version string",
    NULL},
   {(char*)"xmlns",
    (getter)_StartCounters_getXmlns, 0,
    (char*)"xmlns string",
    NULL},
   {NULL}  /* Sentinel */
};

static PyMemberDef _StartCounters_members[] = {
   {NULL}  /* Sentinel */
};

static PyMethodDef _StartCounters_methods[] = {
   {"toString", _StartCounters_toString, METH_NOARGS,
    "show element as a human-readable string"},
   {"toXML", _StartCounters_toXML, METH_NOARGS,
    "show element as a XML fragment"},
   {NULL}  /* Sentinel */
};

static PyTypeObject _StartCounters_type = {
    PyVarObject_HEAD_INIT(NULL,0)
    "hddm_r.StartCounters",         /*tp_name*/
    sizeof(_StartCounters),          /*tp_basicsize*/
    0,                         /*tp_itemsize*/
    (destructor)_StartCounters_dealloc, /*tp_dealloc*/
    0,                         /*tp_print*/
    0,                         /*tp_getattr*/
    0,                         /*tp_setattr*/
    0,                         /*tp_compare*/
    0,                         /*tp_repr*/
    0,                         /*tp_as_number*/
    0,                         /*tp_as_sequence*/
    0,                         /*tp_as_mapping*/
    0,                         /*tp_hash */
    0,                         /*tp_call*/
    (reprfunc)_StartCounters_toString,         /*tp_str*/
    0,                         /*tp_getattro*/
    0,                         /*tp_setattro*/
    0,                         /*tp_as_buffer*/
    Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE, /*tp_flags*/
    "hddm_r startCounters element",  /* tp_doc */
    0,                         /* tp_traverse */
    0,                         /* tp_clear */
    0,                         /* tp_richcompare */
    0,                         /* tp_weaklistoffset */
    0,                         /* tp_iter */
    0,                         /* tp_iternext */
    _StartCounters_methods,          /* tp_methods */
    _StartCounters_members,          /* tp_members */
    _StartCounters_getsetters,       /* tp_getset */
    &_HDDM_Element_type,       /* tp_base */
    0,                         /* tp_dict */
    0,                         /* tp_descr_get */
    0,                         /* tp_descr_set */
    0,                         /* tp_dictoffset */
    (initproc)_StartCounters_init,   /* tp_init */
    0,                         /* tp_alloc */
    _StartCounters_new,              /* tp_new */
};



// wrap element class hddm_r::CdcStraws as hddm_r.CdcStraws

typedef struct {
   PyObject_HEAD
   CdcStraws *elem;
   PyObject *host;
} _CdcStraws;

static void
_CdcStraws_dealloc(_CdcStraws* self)
{
   if (self->elem != 0) {
      LOG_DEALLOC(Py_TYPE(self), 0, self->host == (PyObject*)self);
      if (self->host == (PyObject*)self)
         delete self->elem;
      else
         My_DECREF(self->host);
   }
   Py_TYPE(self)->tp_free((PyObject*)self);
}

static PyObject*
_CdcStraws_new(PyTypeObject *type, PyObject *args, PyObject *kwds)
{
   _CdcStraws *self;
   self = (_CdcStraws*)type->tp_alloc(type, 0);
   if (self != NULL) {
      self->elem = 0;
      self->host = 0;
   }
   return (PyObject*)self;
}

static int
_CdcStraws_init(_CdcStraws *self, PyObject *args, PyObject *kwds)
{
   PyErr_SetString(PyExc_RuntimeError, "illegal constructor");
   return -1;
}

static PyObject*
_CdcStraws_getClass(_CdcStraws *self, void *closure)
{
   std::string val(self->elem->getClass());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_CdcStraws_getVersion(_CdcStraws *self, void *closure)
{
   std::string val(self->elem->getVersion());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_CdcStraws_getXmlns(_CdcStraws *self, void *closure)
{
   std::string val(self->elem->getXmlns());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_CdcStraws_getEventNo(_CdcStraws *self, void *closure)
{
   return PyLong_FromLongLong(self->elem->getEventNo());
}

static PyObject*
_CdcStraws_getRunNo(_CdcStraws *self, void *closure)
{
   return PyLong_FromLong(self->elem->getRunNo());
}

static PyObject*
_CdcStraws_getJtag(_CdcStraws *self, void *closure)
{
   std::string val(self->elem->getJtag());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_CdcStraws_getCount(_CdcStraws *self, void *closure)
{
   return PyLong_FromLong(self->elem->getCount());
}

static int
_CdcStraws_setCount(_CdcStraws *self, PyObject *value, void *closure)
{
   long var = PyInt_AsLong(value);
   if (var == -1 && PyErr_Occurred()) {
      return -1;
   }
   self->elem->setCount(var);
   return 0;
}

static PyObject*
_CdcStraws_getMinOccurs(_CdcStraws *self, void *closure)
{
   return PyLong_FromLong(self->elem->getMinOccurs());
}

static PyObject*
_CdcStraws_toString(PyObject *self, PyObject *args=0)
{
   _CdcStraws *me = (_CdcStraws*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid cdcStraws element");
      return NULL;
   }
   std::string str(me->elem->toString());
   return PyUnicode_FromString(str.c_str());
}

static PyObject*
_CdcStraws_toXML(PyObject *self, PyObject *args=0)
{
   _CdcStraws *me = (_CdcStraws*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid cdcStraws element");
      return NULL;
   }
   std::string str(me->elem->toXML());
   return PyUnicode_FromString(str.c_str());
}

static PyGetSetDef _CdcStraws_getsetters[] = {
   {(char*)"class",
    (getter)_CdcStraws_getClass, 0,
    (char*)"class string",
    NULL},
   {(char*)"count",
    (getter)_CdcStraws_getCount, (setter)_CdcStraws_setCount,
    (char*)"count value",
    NULL},
   {(char*)"eventNo",
    (getter)_CdcStraws_getEventNo, 0,
    (char*)"eventNo value",
    NULL},
   {(char*)"jtag",
    (getter)_CdcStraws_getJtag, 0,
    (char*)"jtag string",
    NULL},
   {(char*)"minOccurs",
    (getter)_CdcStraws_getMinOccurs, 0,
    (char*)"minOccurs value",
    NULL},
   {(char*)"runNo",
    (getter)_CdcStraws_getRunNo, 0,
    (char*)"runNo value",
    NULL},
   {(char*)"version",
    (getter)_CdcStraws_getVersion, 0,
    (char*)"version string",
    NULL},
   {(char*)"xmlns",
    (getter)_CdcStraws_getXmlns, 0,
    (char*)"xmlns string",
    NULL},
   {NULL}  /* Sentinel */
};

static PyMemberDef _CdcStraws_members[] = {
   {NULL}  /* Sentinel */
};

static PyMethodDef _CdcStraws_methods[] = {
   {"toString", _CdcStraws_toString, METH_NOARGS,
    "show element as a human-readable string"},
   {"toXML", _CdcStraws_toXML, METH_NOARGS,
    "show element as a XML fragment"},
   {NULL}  /* Sentinel */
};

static PyTypeObject _CdcStraws_type = {
    PyVarObject_HEAD_INIT(NULL,0)
    "hddm_r.CdcStraws",         /*tp_name*/
    sizeof(_CdcStraws),          /*tp_basicsize*/
    0,                         /*tp_itemsize*/
    (destructor)_CdcStraws_dealloc, /*tp_dealloc*/
    0,                         /*tp_print*/
    0,                         /*tp_getattr*/
    0,                         /*tp_setattr*/
    0,                         /*tp_compare*/
    0,                         /*tp_repr*/
    0,                         /*tp_as_number*/
    0,                         /*tp_as_sequence*/
    0,                         /*tp_as_mapping*/
    0,                         /*tp_hash */
    0,                         /*tp_call*/
    (reprfunc)_CdcStraws_toString,         /*tp_str*/
    0,                         /*tp_getattro*/
    0,                         /*tp_setattro*/
    0,                         /*tp_as_buffer*/
    Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE, /*tp_flags*/
    "hddm_r cdcStraws element",  /* tp_doc */
    0,                         /* tp_traverse */
    0,                         /* tp_clear */
    0,                         /* tp_richcompare */
    0,                         /* tp_weaklistoffset */
    0,                         /* tp_iter */
    0,                         /* tp_iternext */
    _CdcStraws_methods,          /* tp_methods */
    _CdcStraws_members,          /* tp_members */
    _CdcStraws_getsetters,       /* tp_getset */
    &_HDDM_Element_type,       /* tp_base */
    0,                         /* tp_dict */
    0,                         /* tp_descr_get */
    0,                         /* tp_descr_set */
    0,                         /* tp_dictoffset */
    (initproc)_CdcStraws_init,   /* tp_init */
    0,                         /* tp_alloc */
    _CdcStraws_new,              /* tp_new */
};



// wrap element class hddm_r::FdcPseudos as hddm_r.FdcPseudos

typedef struct {
   PyObject_HEAD
   FdcPseudos *elem;
   PyObject *host;
} _FdcPseudos;

static void
_FdcPseudos_dealloc(_FdcPseudos* self)
{
   if (self->elem != 0) {
      LOG_DEALLOC(Py_TYPE(self), 0, self->host == (PyObject*)self);
      if (self->host == (PyObject*)self)
         delete self->elem;
      else
         My_DECREF(self->host);
   }
   Py_TYPE(self)->tp_free((PyObject*)self);
}

static PyObject*
_FdcPseudos_new(PyTypeObject *type, PyObject *args, PyObject *kwds)
{
   _FdcPseudos *self;
   self = (_FdcPseudos*)type->tp_alloc(type, 0);
   if (self != NULL) {
      self->elem = 0;
      self->host = 0;
   }
   return (PyObject*)self;
}

static int
_FdcPseudos_init(_FdcPseudos *self, PyObject *args, PyObject *kwds)
{
   PyErr_SetString(PyExc_RuntimeError, "illegal constructor");
   return -1;
}

static PyObject*
_FdcPseudos_getClass(_FdcPseudos *self, void *closure)
{
   std::string val(self->elem->getClass());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_FdcPseudos_getVersion(_FdcPseudos *self, void *closure)
{
   std::string val(self->elem->getVersion());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_FdcPseudos_getXmlns(_FdcPseudos *self, void *closure)
{
   std::string val(self->elem->getXmlns());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_FdcPseudos_getEventNo(_FdcPseudos *self, void *closure)
{
   return PyLong_FromLongLong(self->elem->getEventNo());
}

static PyObject*
_FdcPseudos_getRunNo(_FdcPseudos *self, void *closure)
{
   return PyLong_FromLong(self->elem->getRunNo());
}

static PyObject*
_FdcPseudos_getJtag(_FdcPseudos *self, void *closure)
{
   std::string val(self->elem->getJtag());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_FdcPseudos_getCount(_FdcPseudos *self, void *closure)
{
   return PyLong_FromLong(self->elem->getCount());
}

static int
_FdcPseudos_setCount(_FdcPseudos *self, PyObject *value, void *closure)
{
   long var = PyInt_AsLong(value);
   if (var == -1 && PyErr_Occurred()) {
      return -1;
   }
   self->elem->setCount(var);
   return 0;
}

static PyObject*
_FdcPseudos_getMinOccurs(_FdcPseudos *self, void *closure)
{
   return PyLong_FromLong(self->elem->getMinOccurs());
}

static PyObject*
_FdcPseudos_toString(PyObject *self, PyObject *args=0)
{
   _FdcPseudos *me = (_FdcPseudos*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid fdcPseudos element");
      return NULL;
   }
   std::string str(me->elem->toString());
   return PyUnicode_FromString(str.c_str());
}

static PyObject*
_FdcPseudos_toXML(PyObject *self, PyObject *args=0)
{
   _FdcPseudos *me = (_FdcPseudos*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid fdcPseudos element");
      return NULL;
   }
   std::string str(me->elem->toXML());
   return PyUnicode_FromString(str.c_str());
}

static PyGetSetDef _FdcPseudos_getsetters[] = {
   {(char*)"class",
    (getter)_FdcPseudos_getClass, 0,
    (char*)"class string",
    NULL},
   {(char*)"count",
    (getter)_FdcPseudos_getCount, (setter)_FdcPseudos_setCount,
    (char*)"count value",
    NULL},
   {(char*)"eventNo",
    (getter)_FdcPseudos_getEventNo, 0,
    (char*)"eventNo value",
    NULL},
   {(char*)"jtag",
    (getter)_FdcPseudos_getJtag, 0,
    (char*)"jtag string",
    NULL},
   {(char*)"minOccurs",
    (getter)_FdcPseudos_getMinOccurs, 0,
    (char*)"minOccurs value",
    NULL},
   {(char*)"runNo",
    (getter)_FdcPseudos_getRunNo, 0,
    (char*)"runNo value",
    NULL},
   {(char*)"version",
    (getter)_FdcPseudos_getVersion, 0,
    (char*)"version string",
    NULL},
   {(char*)"xmlns",
    (getter)_FdcPseudos_getXmlns, 0,
    (char*)"xmlns string",
    NULL},
   {NULL}  /* Sentinel */
};

static PyMemberDef _FdcPseudos_members[] = {
   {NULL}  /* Sentinel */
};

static PyMethodDef _FdcPseudos_methods[] = {
   {"toString", _FdcPseudos_toString, METH_NOARGS,
    "show element as a human-readable string"},
   {"toXML", _FdcPseudos_toXML, METH_NOARGS,
    "show element as a XML fragment"},
   {NULL}  /* Sentinel */
};

static PyTypeObject _FdcPseudos_type = {
    PyVarObject_HEAD_INIT(NULL,0)
    "hddm_r.FdcPseudos",         /*tp_name*/
    sizeof(_FdcPseudos),          /*tp_basicsize*/
    0,                         /*tp_itemsize*/
    (destructor)_FdcPseudos_dealloc, /*tp_dealloc*/
    0,                         /*tp_print*/
    0,                         /*tp_getattr*/
    0,                         /*tp_setattr*/
    0,                         /*tp_compare*/
    0,                         /*tp_repr*/
    0,                         /*tp_as_number*/
    0,                         /*tp_as_sequence*/
    0,                         /*tp_as_mapping*/
    0,                         /*tp_hash */
    0,                         /*tp_call*/
    (reprfunc)_FdcPseudos_toString,         /*tp_str*/
    0,                         /*tp_getattro*/
    0,                         /*tp_setattro*/
    0,                         /*tp_as_buffer*/
    Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE, /*tp_flags*/
    "hddm_r fdcPseudos element",  /* tp_doc */
    0,                         /* tp_traverse */
    0,                         /* tp_clear */
    0,                         /* tp_richcompare */
    0,                         /* tp_weaklistoffset */
    0,                         /* tp_iter */
    0,                         /* tp_iternext */
    _FdcPseudos_methods,          /* tp_methods */
    _FdcPseudos_members,          /* tp_members */
    _FdcPseudos_getsetters,       /* tp_getset */
    &_HDDM_Element_type,       /* tp_base */
    0,                         /* tp_dict */
    0,                         /* tp_descr_get */
    0,                         /* tp_descr_set */
    0,                         /* tp_dictoffset */
    (initproc)_FdcPseudos_init,   /* tp_init */
    0,                         /* tp_alloc */
    _FdcPseudos_new,              /* tp_new */
};



// wrap element class hddm_r::BcalCells as hddm_r.BcalCells

typedef struct {
   PyObject_HEAD
   BcalCells *elem;
   PyObject *host;
} _BcalCells;

static void
_BcalCells_dealloc(_BcalCells* self)
{
   if (self->elem != 0) {
      LOG_DEALLOC(Py_TYPE(self), 0, self->host == (PyObject*)self);
      if (self->host == (PyObject*)self)
         delete self->elem;
      else
         My_DECREF(self->host);
   }
   Py_TYPE(self)->tp_free((PyObject*)self);
}

static PyObject*
_BcalCells_new(PyTypeObject *type, PyObject *args, PyObject *kwds)
{
   _BcalCells *self;
   self = (_BcalCells*)type->tp_alloc(type, 0);
   if (self != NULL) {
      self->elem = 0;
      self->host = 0;
   }
   return (PyObject*)self;
}

static int
_BcalCells_init(_BcalCells *self, PyObject *args, PyObject *kwds)
{
   PyErr_SetString(PyExc_RuntimeError, "illegal constructor");
   return -1;
}

static PyObject*
_BcalCells_getClass(_BcalCells *self, void *closure)
{
   std::string val(self->elem->getClass());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_BcalCells_getVersion(_BcalCells *self, void *closure)
{
   std::string val(self->elem->getVersion());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_BcalCells_getXmlns(_BcalCells *self, void *closure)
{
   std::string val(self->elem->getXmlns());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_BcalCells_getEventNo(_BcalCells *self, void *closure)
{
   return PyLong_FromLongLong(self->elem->getEventNo());
}

static PyObject*
_BcalCells_getRunNo(_BcalCells *self, void *closure)
{
   return PyLong_FromLong(self->elem->getRunNo());
}

static PyObject*
_BcalCells_getJtag(_BcalCells *self, void *closure)
{
   std::string val(self->elem->getJtag());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_BcalCells_getCount(_BcalCells *self, void *closure)
{
   return PyLong_FromLong(self->elem->getCount());
}

static int
_BcalCells_setCount(_BcalCells *self, PyObject *value, void *closure)
{
   long var = PyInt_AsLong(value);
   if (var == -1 && PyErr_Occurred()) {
      return -1;
   }
   self->elem->setCount(var);
   return 0;
}

static PyObject*
_BcalCells_getMinOccurs(_BcalCells *self, void *closure)
{
   return PyLong_FromLong(self->elem->getMinOccurs());
}

static PyObject*
_BcalCells_toString(PyObject *self, PyObject *args=0)
{
   _BcalCells *me = (_BcalCells*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid bcalCells element");
      return NULL;
   }
   std::string str(me->elem->toString());
   return PyUnicode_FromString(str.c_str());
}

static PyObject*
_BcalCells_toXML(PyObject *self, PyObject *args=0)
{
   _BcalCells *me = (_BcalCells*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid bcalCells element");
      return NULL;
   }
   std::string str(me->elem->toXML());
   return PyUnicode_FromString(str.c_str());
}

static PyGetSetDef _BcalCells_getsetters[] = {
   {(char*)"class",
    (getter)_BcalCells_getClass, 0,
    (char*)"class string",
    NULL},
   {(char*)"count",
    (getter)_BcalCells_getCount, (setter)_BcalCells_setCount,
    (char*)"count value",
    NULL},
   {(char*)"eventNo",
    (getter)_BcalCells_getEventNo, 0,
    (char*)"eventNo value",
    NULL},
   {(char*)"jtag",
    (getter)_BcalCells_getJtag, 0,
    (char*)"jtag string",
    NULL},
   {(char*)"minOccurs",
    (getter)_BcalCells_getMinOccurs, 0,
    (char*)"minOccurs value",
    NULL},
   {(char*)"runNo",
    (getter)_BcalCells_getRunNo, 0,
    (char*)"runNo value",
    NULL},
   {(char*)"version",
    (getter)_BcalCells_getVersion, 0,
    (char*)"version string",
    NULL},
   {(char*)"xmlns",
    (getter)_BcalCells_getXmlns, 0,
    (char*)"xmlns string",
    NULL},
   {NULL}  /* Sentinel */
};

static PyMemberDef _BcalCells_members[] = {
   {NULL}  /* Sentinel */
};

static PyMethodDef _BcalCells_methods[] = {
   {"toString", _BcalCells_toString, METH_NOARGS,
    "show element as a human-readable string"},
   {"toXML", _BcalCells_toXML, METH_NOARGS,
    "show element as a XML fragment"},
   {NULL}  /* Sentinel */
};

static PyTypeObject _BcalCells_type = {
    PyVarObject_HEAD_INIT(NULL,0)
    "hddm_r.BcalCells",         /*tp_name*/
    sizeof(_BcalCells),          /*tp_basicsize*/
    0,                         /*tp_itemsize*/
    (destructor)_BcalCells_dealloc, /*tp_dealloc*/
    0,                         /*tp_print*/
    0,                         /*tp_getattr*/
    0,                         /*tp_setattr*/
    0,                         /*tp_compare*/
    0,                         /*tp_repr*/
    0,                         /*tp_as_number*/
    0,                         /*tp_as_sequence*/
    0,                         /*tp_as_mapping*/
    0,                         /*tp_hash */
    0,                         /*tp_call*/
    (reprfunc)_BcalCells_toString,         /*tp_str*/
    0,                         /*tp_getattro*/
    0,                         /*tp_setattro*/
    0,                         /*tp_as_buffer*/
    Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE, /*tp_flags*/
    "hddm_r bcalCells element",  /* tp_doc */
    0,                         /* tp_traverse */
    0,                         /* tp_clear */
    0,                         /* tp_richcompare */
    0,                         /* tp_weaklistoffset */
    0,                         /* tp_iter */
    0,                         /* tp_iternext */
    _BcalCells_methods,          /* tp_methods */
    _BcalCells_members,          /* tp_members */
    _BcalCells_getsetters,       /* tp_getset */
    &_HDDM_Element_type,       /* tp_base */
    0,                         /* tp_dict */
    0,                         /* tp_descr_get */
    0,                         /* tp_descr_set */
    0,                         /* tp_dictoffset */
    (initproc)_BcalCells_init,   /* tp_init */
    0,                         /* tp_alloc */
    _BcalCells_new,              /* tp_new */
};



// wrap element class hddm_r::FcalBlocks as hddm_r.FcalBlocks

typedef struct {
   PyObject_HEAD
   FcalBlocks *elem;
   PyObject *host;
} _FcalBlocks;

static void
_FcalBlocks_dealloc(_FcalBlocks* self)
{
   if (self->elem != 0) {
      LOG_DEALLOC(Py_TYPE(self), 0, self->host == (PyObject*)self);
      if (self->host == (PyObject*)self)
         delete self->elem;
      else
         My_DECREF(self->host);
   }
   Py_TYPE(self)->tp_free((PyObject*)self);
}

static PyObject*
_FcalBlocks_new(PyTypeObject *type, PyObject *args, PyObject *kwds)
{
   _FcalBlocks *self;
   self = (_FcalBlocks*)type->tp_alloc(type, 0);
   if (self != NULL) {
      self->elem = 0;
      self->host = 0;
   }
   return (PyObject*)self;
}

static int
_FcalBlocks_init(_FcalBlocks *self, PyObject *args, PyObject *kwds)
{
   PyErr_SetString(PyExc_RuntimeError, "illegal constructor");
   return -1;
}

static PyObject*
_FcalBlocks_getClass(_FcalBlocks *self, void *closure)
{
   std::string val(self->elem->getClass());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_FcalBlocks_getVersion(_FcalBlocks *self, void *closure)
{
   std::string val(self->elem->getVersion());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_FcalBlocks_getXmlns(_FcalBlocks *self, void *closure)
{
   std::string val(self->elem->getXmlns());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_FcalBlocks_getEventNo(_FcalBlocks *self, void *closure)
{
   return PyLong_FromLongLong(self->elem->getEventNo());
}

static PyObject*
_FcalBlocks_getRunNo(_FcalBlocks *self, void *closure)
{
   return PyLong_FromLong(self->elem->getRunNo());
}

static PyObject*
_FcalBlocks_getJtag(_FcalBlocks *self, void *closure)
{
   std::string val(self->elem->getJtag());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_FcalBlocks_getCount(_FcalBlocks *self, void *closure)
{
   return PyLong_FromLong(self->elem->getCount());
}

static int
_FcalBlocks_setCount(_FcalBlocks *self, PyObject *value, void *closure)
{
   long var = PyInt_AsLong(value);
   if (var == -1 && PyErr_Occurred()) {
      return -1;
   }
   self->elem->setCount(var);
   return 0;
}

static PyObject*
_FcalBlocks_getMinOccurs(_FcalBlocks *self, void *closure)
{
   return PyLong_FromLong(self->elem->getMinOccurs());
}

static PyObject*
_FcalBlocks_toString(PyObject *self, PyObject *args=0)
{
   _FcalBlocks *me = (_FcalBlocks*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid fcalBlocks element");
      return NULL;
   }
   std::string str(me->elem->toString());
   return PyUnicode_FromString(str.c_str());
}

static PyObject*
_FcalBlocks_toXML(PyObject *self, PyObject *args=0)
{
   _FcalBlocks *me = (_FcalBlocks*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid fcalBlocks element");
      return NULL;
   }
   std::string str(me->elem->toXML());
   return PyUnicode_FromString(str.c_str());
}

static PyGetSetDef _FcalBlocks_getsetters[] = {
   {(char*)"class",
    (getter)_FcalBlocks_getClass, 0,
    (char*)"class string",
    NULL},
   {(char*)"count",
    (getter)_FcalBlocks_getCount, (setter)_FcalBlocks_setCount,
    (char*)"count value",
    NULL},
   {(char*)"eventNo",
    (getter)_FcalBlocks_getEventNo, 0,
    (char*)"eventNo value",
    NULL},
   {(char*)"jtag",
    (getter)_FcalBlocks_getJtag, 0,
    (char*)"jtag string",
    NULL},
   {(char*)"minOccurs",
    (getter)_FcalBlocks_getMinOccurs, 0,
    (char*)"minOccurs value",
    NULL},
   {(char*)"runNo",
    (getter)_FcalBlocks_getRunNo, 0,
    (char*)"runNo value",
    NULL},
   {(char*)"version",
    (getter)_FcalBlocks_getVersion, 0,
    (char*)"version string",
    NULL},
   {(char*)"xmlns",
    (getter)_FcalBlocks_getXmlns, 0,
    (char*)"xmlns string",
    NULL},
   {NULL}  /* Sentinel */
};

static PyMemberDef _FcalBlocks_members[] = {
   {NULL}  /* Sentinel */
};

static PyMethodDef _FcalBlocks_methods[] = {
   {"toString", _FcalBlocks_toString, METH_NOARGS,
    "show element as a human-readable string"},
   {"toXML", _FcalBlocks_toXML, METH_NOARGS,
    "show element as a XML fragment"},
   {NULL}  /* Sentinel */
};

static PyTypeObject _FcalBlocks_type = {
    PyVarObject_HEAD_INIT(NULL,0)
    "hddm_r.FcalBlocks",         /*tp_name*/
    sizeof(_FcalBlocks),          /*tp_basicsize*/
    0,                         /*tp_itemsize*/
    (destructor)_FcalBlocks_dealloc, /*tp_dealloc*/
    0,                         /*tp_print*/
    0,                         /*tp_getattr*/
    0,                         /*tp_setattr*/
    0,                         /*tp_compare*/
    0,                         /*tp_repr*/
    0,                         /*tp_as_number*/
    0,                         /*tp_as_sequence*/
    0,                         /*tp_as_mapping*/
    0,                         /*tp_hash */
    0,                         /*tp_call*/
    (reprfunc)_FcalBlocks_toString,         /*tp_str*/
    0,                         /*tp_getattro*/
    0,                         /*tp_setattro*/
    0,                         /*tp_as_buffer*/
    Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE, /*tp_flags*/
    "hddm_r fcalBlocks element",  /* tp_doc */
    0,                         /* tp_traverse */
    0,                         /* tp_clear */
    0,                         /* tp_richcompare */
    0,                         /* tp_weaklistoffset */
    0,                         /* tp_iter */
    0,                         /* tp_iternext */
    _FcalBlocks_methods,          /* tp_methods */
    _FcalBlocks_members,          /* tp_members */
    _FcalBlocks_getsetters,       /* tp_getset */
    &_HDDM_Element_type,       /* tp_base */
    0,                         /* tp_dict */
    0,                         /* tp_descr_get */
    0,                         /* tp_descr_set */
    0,                         /* tp_dictoffset */
    (initproc)_FcalBlocks_init,   /* tp_init */
    0,                         /* tp_alloc */
    _FcalBlocks_new,              /* tp_new */
};



// wrap element class hddm_r::TofPaddles as hddm_r.TofPaddles

typedef struct {
   PyObject_HEAD
   TofPaddles *elem;
   PyObject *host;
} _TofPaddles;

static void
_TofPaddles_dealloc(_TofPaddles* self)
{
   if (self->elem != 0) {
      LOG_DEALLOC(Py_TYPE(self), 0, self->host == (PyObject*)self);
      if (self->host == (PyObject*)self)
         delete self->elem;
      else
         My_DECREF(self->host);
   }
   Py_TYPE(self)->tp_free((PyObject*)self);
}

static PyObject*
_TofPaddles_new(PyTypeObject *type, PyObject *args, PyObject *kwds)
{
   _TofPaddles *self;
   self = (_TofPaddles*)type->tp_alloc(type, 0);
   if (self != NULL) {
      self->elem = 0;
      self->host = 0;
   }
   return (PyObject*)self;
}

static int
_TofPaddles_init(_TofPaddles *self, PyObject *args, PyObject *kwds)
{
   PyErr_SetString(PyExc_RuntimeError, "illegal constructor");
   return -1;
}

static PyObject*
_TofPaddles_getClass(_TofPaddles *self, void *closure)
{
   std::string val(self->elem->getClass());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_TofPaddles_getVersion(_TofPaddles *self, void *closure)
{
   std::string val(self->elem->getVersion());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_TofPaddles_getXmlns(_TofPaddles *self, void *closure)
{
   std::string val(self->elem->getXmlns());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_TofPaddles_getEventNo(_TofPaddles *self, void *closure)
{
   return PyLong_FromLongLong(self->elem->getEventNo());
}

static PyObject*
_TofPaddles_getRunNo(_TofPaddles *self, void *closure)
{
   return PyLong_FromLong(self->elem->getRunNo());
}

static PyObject*
_TofPaddles_getJtag(_TofPaddles *self, void *closure)
{
   std::string val(self->elem->getJtag());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_TofPaddles_getCount(_TofPaddles *self, void *closure)
{
   return PyLong_FromLong(self->elem->getCount());
}

static int
_TofPaddles_setCount(_TofPaddles *self, PyObject *value, void *closure)
{
   long var = PyInt_AsLong(value);
   if (var == -1 && PyErr_Occurred()) {
      return -1;
   }
   self->elem->setCount(var);
   return 0;
}

static PyObject*
_TofPaddles_getMinOccurs(_TofPaddles *self, void *closure)
{
   return PyLong_FromLong(self->elem->getMinOccurs());
}

static PyObject*
_TofPaddles_toString(PyObject *self, PyObject *args=0)
{
   _TofPaddles *me = (_TofPaddles*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid tofPaddles element");
      return NULL;
   }
   std::string str(me->elem->toString());
   return PyUnicode_FromString(str.c_str());
}

static PyObject*
_TofPaddles_toXML(PyObject *self, PyObject *args=0)
{
   _TofPaddles *me = (_TofPaddles*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid tofPaddles element");
      return NULL;
   }
   std::string str(me->elem->toXML());
   return PyUnicode_FromString(str.c_str());
}

static PyGetSetDef _TofPaddles_getsetters[] = {
   {(char*)"class",
    (getter)_TofPaddles_getClass, 0,
    (char*)"class string",
    NULL},
   {(char*)"count",
    (getter)_TofPaddles_getCount, (setter)_TofPaddles_setCount,
    (char*)"count value",
    NULL},
   {(char*)"eventNo",
    (getter)_TofPaddles_getEventNo, 0,
    (char*)"eventNo value",
    NULL},
   {(char*)"jtag",
    (getter)_TofPaddles_getJtag, 0,
    (char*)"jtag string",
    NULL},
   {(char*)"minOccurs",
    (getter)_TofPaddles_getMinOccurs, 0,
    (char*)"minOccurs value",
    NULL},
   {(char*)"runNo",
    (getter)_TofPaddles_getRunNo, 0,
    (char*)"runNo value",
    NULL},
   {(char*)"version",
    (getter)_TofPaddles_getVersion, 0,
    (char*)"version string",
    NULL},
   {(char*)"xmlns",
    (getter)_TofPaddles_getXmlns, 0,
    (char*)"xmlns string",
    NULL},
   {NULL}  /* Sentinel */
};

static PyMemberDef _TofPaddles_members[] = {
   {NULL}  /* Sentinel */
};

static PyMethodDef _TofPaddles_methods[] = {
   {"toString", _TofPaddles_toString, METH_NOARGS,
    "show element as a human-readable string"},
   {"toXML", _TofPaddles_toXML, METH_NOARGS,
    "show element as a XML fragment"},
   {NULL}  /* Sentinel */
};

static PyTypeObject _TofPaddles_type = {
    PyVarObject_HEAD_INIT(NULL,0)
    "hddm_r.TofPaddles",         /*tp_name*/
    sizeof(_TofPaddles),          /*tp_basicsize*/
    0,                         /*tp_itemsize*/
    (destructor)_TofPaddles_dealloc, /*tp_dealloc*/
    0,                         /*tp_print*/
    0,                         /*tp_getattr*/
    0,                         /*tp_setattr*/
    0,                         /*tp_compare*/
    0,                         /*tp_repr*/
    0,                         /*tp_as_number*/
    0,                         /*tp_as_sequence*/
    0,                         /*tp_as_mapping*/
    0,                         /*tp_hash */
    0,                         /*tp_call*/
    (reprfunc)_TofPaddles_toString,         /*tp_str*/
    0,                         /*tp_getattro*/
    0,                         /*tp_setattro*/
    0,                         /*tp_as_buffer*/
    Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE, /*tp_flags*/
    "hddm_r tofPaddles element",  /* tp_doc */
    0,                         /* tp_traverse */
    0,                         /* tp_clear */
    0,                         /* tp_richcompare */
    0,                         /* tp_weaklistoffset */
    0,                         /* tp_iter */
    0,                         /* tp_iternext */
    _TofPaddles_methods,          /* tp_methods */
    _TofPaddles_members,          /* tp_members */
    _TofPaddles_getsetters,       /* tp_getset */
    &_HDDM_Element_type,       /* tp_base */
    0,                         /* tp_dict */
    0,                         /* tp_descr_get */
    0,                         /* tp_descr_set */
    0,                         /* tp_dictoffset */
    (initproc)_TofPaddles_init,   /* tp_init */
    0,                         /* tp_alloc */
    _TofPaddles_new,              /* tp_new */
};



// wrap element class hddm_r::CcalBlocks as hddm_r.CcalBlocks

typedef struct {
   PyObject_HEAD
   CcalBlocks *elem;
   PyObject *host;
} _CcalBlocks;

static void
_CcalBlocks_dealloc(_CcalBlocks* self)
{
   if (self->elem != 0) {
      LOG_DEALLOC(Py_TYPE(self), 0, self->host == (PyObject*)self);
      if (self->host == (PyObject*)self)
         delete self->elem;
      else
         My_DECREF(self->host);
   }
   Py_TYPE(self)->tp_free((PyObject*)self);
}

static PyObject*
_CcalBlocks_new(PyTypeObject *type, PyObject *args, PyObject *kwds)
{
   _CcalBlocks *self;
   self = (_CcalBlocks*)type->tp_alloc(type, 0);
   if (self != NULL) {
      self->elem = 0;
      self->host = 0;
   }
   return (PyObject*)self;
}

static int
_CcalBlocks_init(_CcalBlocks *self, PyObject *args, PyObject *kwds)
{
   PyErr_SetString(PyExc_RuntimeError, "illegal constructor");
   return -1;
}

static PyObject*
_CcalBlocks_getClass(_CcalBlocks *self, void *closure)
{
   std::string val(self->elem->getClass());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_CcalBlocks_getVersion(_CcalBlocks *self, void *closure)
{
   std::string val(self->elem->getVersion());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_CcalBlocks_getXmlns(_CcalBlocks *self, void *closure)
{
   std::string val(self->elem->getXmlns());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_CcalBlocks_getEventNo(_CcalBlocks *self, void *closure)
{
   return PyLong_FromLongLong(self->elem->getEventNo());
}

static PyObject*
_CcalBlocks_getRunNo(_CcalBlocks *self, void *closure)
{
   return PyLong_FromLong(self->elem->getRunNo());
}

static PyObject*
_CcalBlocks_getJtag(_CcalBlocks *self, void *closure)
{
   std::string val(self->elem->getJtag());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_CcalBlocks_getCount(_CcalBlocks *self, void *closure)
{
   return PyLong_FromLong(self->elem->getCount());
}

static int
_CcalBlocks_setCount(_CcalBlocks *self, PyObject *value, void *closure)
{
   long var = PyInt_AsLong(value);
   if (var == -1 && PyErr_Occurred()) {
      return -1;
   }
   self->elem->setCount(var);
   return 0;
}

static PyObject*
_CcalBlocks_getMinOccurs(_CcalBlocks *self, void *closure)
{
   return PyLong_FromLong(self->elem->getMinOccurs());
}

static PyObject*
_CcalBlocks_toString(PyObject *self, PyObject *args=0)
{
   _CcalBlocks *me = (_CcalBlocks*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid ccalBlocks element");
      return NULL;
   }
   std::string str(me->elem->toString());
   return PyUnicode_FromString(str.c_str());
}

static PyObject*
_CcalBlocks_toXML(PyObject *self, PyObject *args=0)
{
   _CcalBlocks *me = (_CcalBlocks*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid ccalBlocks element");
      return NULL;
   }
   std::string str(me->elem->toXML());
   return PyUnicode_FromString(str.c_str());
}

static PyGetSetDef _CcalBlocks_getsetters[] = {
   {(char*)"class",
    (getter)_CcalBlocks_getClass, 0,
    (char*)"class string",
    NULL},
   {(char*)"count",
    (getter)_CcalBlocks_getCount, (setter)_CcalBlocks_setCount,
    (char*)"count value",
    NULL},
   {(char*)"eventNo",
    (getter)_CcalBlocks_getEventNo, 0,
    (char*)"eventNo value",
    NULL},
   {(char*)"jtag",
    (getter)_CcalBlocks_getJtag, 0,
    (char*)"jtag string",
    NULL},
   {(char*)"minOccurs",
    (getter)_CcalBlocks_getMinOccurs, 0,
    (char*)"minOccurs value",
    NULL},
   {(char*)"runNo",
    (getter)_CcalBlocks_getRunNo, 0,
    (char*)"runNo value",
    NULL},
   {(char*)"version",
    (getter)_CcalBlocks_getVersion, 0,
    (char*)"version string",
    NULL},
   {(char*)"xmlns",
    (getter)_CcalBlocks_getXmlns, 0,
    (char*)"xmlns string",
    NULL},
   {NULL}  /* Sentinel */
};

static PyMemberDef _CcalBlocks_members[] = {
   {NULL}  /* Sentinel */
};

static PyMethodDef _CcalBlocks_methods[] = {
   {"toString", _CcalBlocks_toString, METH_NOARGS,
    "show element as a human-readable string"},
   {"toXML", _CcalBlocks_toXML, METH_NOARGS,
    "show element as a XML fragment"},
   {NULL}  /* Sentinel */
};

static PyTypeObject _CcalBlocks_type = {
    PyVarObject_HEAD_INIT(NULL,0)
    "hddm_r.CcalBlocks",         /*tp_name*/
    sizeof(_CcalBlocks),          /*tp_basicsize*/
    0,                         /*tp_itemsize*/
    (destructor)_CcalBlocks_dealloc, /*tp_dealloc*/
    0,                         /*tp_print*/
    0,                         /*tp_getattr*/
    0,                         /*tp_setattr*/
    0,                         /*tp_compare*/
    0,                         /*tp_repr*/
    0,                         /*tp_as_number*/
    0,                         /*tp_as_sequence*/
    0,                         /*tp_as_mapping*/
    0,                         /*tp_hash */
    0,                         /*tp_call*/
    (reprfunc)_CcalBlocks_toString,         /*tp_str*/
    0,                         /*tp_getattro*/
    0,                         /*tp_setattro*/
    0,                         /*tp_as_buffer*/
    Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE, /*tp_flags*/
    "hddm_r ccalBlocks element",  /* tp_doc */
    0,                         /* tp_traverse */
    0,                         /* tp_clear */
    0,                         /* tp_richcompare */
    0,                         /* tp_weaklistoffset */
    0,                         /* tp_iter */
    0,                         /* tp_iternext */
    _CcalBlocks_methods,          /* tp_methods */
    _CcalBlocks_members,          /* tp_members */
    _CcalBlocks_getsetters,       /* tp_getset */
    &_HDDM_Element_type,       /* tp_base */
    0,                         /* tp_dict */
    0,                         /* tp_descr_get */
    0,                         /* tp_descr_set */
    0,                         /* tp_dictoffset */
    (initproc)_CcalBlocks_init,   /* tp_init */
    0,                         /* tp_alloc */
    _CcalBlocks_new,              /* tp_new */
};



// wrap element class hddm_r::DircPMTs as hddm_r.DircPMTs

typedef struct {
   PyObject_HEAD
   DircPMTs *elem;
   PyObject *host;
} _DircPMTs;

static void
_DircPMTs_dealloc(_DircPMTs* self)
{
   if (self->elem != 0) {
      LOG_DEALLOC(Py_TYPE(self), 0, self->host == (PyObject*)self);
      if (self->host == (PyObject*)self)
         delete self->elem;
      else
         My_DECREF(self->host);
   }
   Py_TYPE(self)->tp_free((PyObject*)self);
}

static PyObject*
_DircPMTs_new(PyTypeObject *type, PyObject *args, PyObject *kwds)
{
   _DircPMTs *self;
   self = (_DircPMTs*)type->tp_alloc(type, 0);
   if (self != NULL) {
      self->elem = 0;
      self->host = 0;
   }
   return (PyObject*)self;
}

static int
_DircPMTs_init(_DircPMTs *self, PyObject *args, PyObject *kwds)
{
   PyErr_SetString(PyExc_RuntimeError, "illegal constructor");
   return -1;
}

static PyObject*
_DircPMTs_getClass(_DircPMTs *self, void *closure)
{
   std::string val(self->elem->getClass());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_DircPMTs_getVersion(_DircPMTs *self, void *closure)
{
   std::string val(self->elem->getVersion());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_DircPMTs_getXmlns(_DircPMTs *self, void *closure)
{
   std::string val(self->elem->getXmlns());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_DircPMTs_getEventNo(_DircPMTs *self, void *closure)
{
   return PyLong_FromLongLong(self->elem->getEventNo());
}

static PyObject*
_DircPMTs_getRunNo(_DircPMTs *self, void *closure)
{
   return PyLong_FromLong(self->elem->getRunNo());
}

static PyObject*
_DircPMTs_getJtag(_DircPMTs *self, void *closure)
{
   std::string val(self->elem->getJtag());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_DircPMTs_getCount(_DircPMTs *self, void *closure)
{
   return PyLong_FromLong(self->elem->getCount());
}

static int
_DircPMTs_setCount(_DircPMTs *self, PyObject *value, void *closure)
{
   long var = PyInt_AsLong(value);
   if (var == -1 && PyErr_Occurred()) {
      return -1;
   }
   self->elem->setCount(var);
   return 0;
}

static PyObject*
_DircPMTs_getMinOccurs(_DircPMTs *self, void *closure)
{
   return PyLong_FromLong(self->elem->getMinOccurs());
}

static PyObject*
_DircPMTs_toString(PyObject *self, PyObject *args=0)
{
   _DircPMTs *me = (_DircPMTs*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid dircPMTs element");
      return NULL;
   }
   std::string str(me->elem->toString());
   return PyUnicode_FromString(str.c_str());
}

static PyObject*
_DircPMTs_toXML(PyObject *self, PyObject *args=0)
{
   _DircPMTs *me = (_DircPMTs*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid dircPMTs element");
      return NULL;
   }
   std::string str(me->elem->toXML());
   return PyUnicode_FromString(str.c_str());
}

static PyGetSetDef _DircPMTs_getsetters[] = {
   {(char*)"class",
    (getter)_DircPMTs_getClass, 0,
    (char*)"class string",
    NULL},
   {(char*)"count",
    (getter)_DircPMTs_getCount, (setter)_DircPMTs_setCount,
    (char*)"count value",
    NULL},
   {(char*)"eventNo",
    (getter)_DircPMTs_getEventNo, 0,
    (char*)"eventNo value",
    NULL},
   {(char*)"jtag",
    (getter)_DircPMTs_getJtag, 0,
    (char*)"jtag string",
    NULL},
   {(char*)"minOccurs",
    (getter)_DircPMTs_getMinOccurs, 0,
    (char*)"minOccurs value",
    NULL},
   {(char*)"runNo",
    (getter)_DircPMTs_getRunNo, 0,
    (char*)"runNo value",
    NULL},
   {(char*)"version",
    (getter)_DircPMTs_getVersion, 0,
    (char*)"version string",
    NULL},
   {(char*)"xmlns",
    (getter)_DircPMTs_getXmlns, 0,
    (char*)"xmlns string",
    NULL},
   {NULL}  /* Sentinel */
};

static PyMemberDef _DircPMTs_members[] = {
   {NULL}  /* Sentinel */
};

static PyMethodDef _DircPMTs_methods[] = {
   {"toString", _DircPMTs_toString, METH_NOARGS,
    "show element as a human-readable string"},
   {"toXML", _DircPMTs_toXML, METH_NOARGS,
    "show element as a XML fragment"},
   {NULL}  /* Sentinel */
};

static PyTypeObject _DircPMTs_type = {
    PyVarObject_HEAD_INIT(NULL,0)
    "hddm_r.DircPMTs",         /*tp_name*/
    sizeof(_DircPMTs),          /*tp_basicsize*/
    0,                         /*tp_itemsize*/
    (destructor)_DircPMTs_dealloc, /*tp_dealloc*/
    0,                         /*tp_print*/
    0,                         /*tp_getattr*/
    0,                         /*tp_setattr*/
    0,                         /*tp_compare*/
    0,                         /*tp_repr*/
    0,                         /*tp_as_number*/
    0,                         /*tp_as_sequence*/
    0,                         /*tp_as_mapping*/
    0,                         /*tp_hash */
    0,                         /*tp_call*/
    (reprfunc)_DircPMTs_toString,         /*tp_str*/
    0,                         /*tp_getattro*/
    0,                         /*tp_setattro*/
    0,                         /*tp_as_buffer*/
    Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE, /*tp_flags*/
    "hddm_r dircPMTs element",  /* tp_doc */
    0,                         /* tp_traverse */
    0,                         /* tp_clear */
    0,                         /* tp_richcompare */
    0,                         /* tp_weaklistoffset */
    0,                         /* tp_iter */
    0,                         /* tp_iternext */
    _DircPMTs_methods,          /* tp_methods */
    _DircPMTs_members,          /* tp_members */
    _DircPMTs_getsetters,       /* tp_getset */
    &_HDDM_Element_type,       /* tp_base */
    0,                         /* tp_dict */
    0,                         /* tp_descr_get */
    0,                         /* tp_descr_set */
    0,                         /* tp_dictoffset */
    (initproc)_DircPMTs_init,   /* tp_init */
    0,                         /* tp_alloc */
    _DircPMTs_new,              /* tp_new */
};



// wrap element class hddm_r::HitStatistics as hddm_r.HitStatistics

typedef struct {
   PyObject_HEAD
   HitStatistics *elem;
   PyObject *host;
} _HitStatistics;

static void
_HitStatistics_dealloc(_HitStatistics* self)
{
   if (self->elem != 0) {
      LOG_DEALLOC(Py_TYPE(self), 0, self->host == (PyObject*)self);
      if (self->host == (PyObject*)self)
         delete self->elem;
      else
         My_DECREF(self->host);
   }
   Py_TYPE(self)->tp_free((PyObject*)self);
}

static PyObject*
_HitStatistics_new(PyTypeObject *type, PyObject *args, PyObject *kwds)
{
   _HitStatistics *self;
   self = (_HitStatistics*)type->tp_alloc(type, 0);
   if (self != NULL) {
      self->elem = 0;
      self->host = 0;
   }
   return (PyObject*)self;
}

static int
_HitStatistics_init(_HitStatistics *self, PyObject *args, PyObject *kwds)
{
   PyErr_SetString(PyExc_RuntimeError, "illegal constructor");
   return -1;
}

static PyObject*
_HitStatistics_getClass(_HitStatistics *self, void *closure)
{
   std::string val(self->elem->getClass());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_HitStatistics_getVersion(_HitStatistics *self, void *closure)
{
   std::string val(self->elem->getVersion());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_HitStatistics_getXmlns(_HitStatistics *self, void *closure)
{
   std::string val(self->elem->getXmlns());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_HitStatistics_getEventNo(_HitStatistics *self, void *closure)
{
   return PyLong_FromLongLong(self->elem->getEventNo());
}

static PyObject*
_HitStatistics_getRunNo(_HitStatistics *self, void *closure)
{
   return PyLong_FromLong(self->elem->getRunNo());
}

static PyObject*
_HitStatistics_getJtag(_HitStatistics *self, void *closure)
{
   std::string val(self->elem->getJtag());
   return PyUnicode_FromString(val.c_str());
}

static int
_HitStatistics_setJtag(_HitStatistics *self, PyObject *value, void *closure)
{
   PyObject *str=0;
   if (PyUnicode_Check(value))
      str = PyUnicode_AsEncodedString(value, "ASCII", "strict");
   else
      str = value;
#if PY_MAJOR_VERSION < 3
   char *var = PyString_AsString(str);
#else
   char *var = PyBytes_AsString(str);
#endif
   if (var == 0) {
      return -1;
   }
   self->elem->setJtag(std::string(var));
   if (str != value) {
      Py_DECREF(str);
   }
   return 0;
}

static PyObject*
_HitStatistics_getMinOccurs(_HitStatistics *self, void *closure)
{
   return PyLong_FromLong(self->elem->getMinOccurs());
}

static PyObject*
_HitStatistics_getStartCounters(PyObject *self, PyObject *args)
{
   int index=0;
   if (! PyArg_ParseTuple(args, "|i", &index)) {
      return NULL;
   }
   _HitStatistics *me = (_HitStatistics*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid hitStatistics element");
      return NULL;
   }
   PyObject *obj = _StartCounters_new(&_StartCounters_type, 0, 0);
   ((_StartCounters*)obj)->elem = &me->elem->getStartCounters();
   ((_StartCounters*)obj)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(obj));
   return obj;
}

static PyObject*
_HitStatistics_getStartCounterses(PyObject *self, PyObject *args)
{
   _HitStatistics *me = (_HitStatistics*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid hitStatistics element");
      return NULL;
   }
   PyObject *list = _HDDM_ElementList_new(&_HDDM_ElementList_type, 0, 0);
   ((_HDDM_ElementList*)list)->subtype = &_StartCounters_type;
   ((_HDDM_ElementList*)list)->list = (HDDM_ElementList<HDDM_Element>*)
    &me->elem->getStartCounterses();
   ((_HDDM_ElementList*)list)->borrowed = 1;
   ((_HDDM_ElementList*)list)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(list), ((_HDDM_ElementList*)list)->subtype, 0);
   return list;
}

static PyObject*
_HitStatistics_addStartCounterses(PyObject *self, PyObject *args)
{
   int count=1;
   int start=-1;
   if (! PyArg_ParseTuple(args, "|ii", &count, &start)) {
      return NULL;
   }
   _HitStatistics *me = (_HitStatistics*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "add attempted on invalid hitStatistics element");
      return NULL;
   }
   PyObject *list = _HDDM_ElementList_new(&_HDDM_ElementList_type, 0, 0);
   ((_HDDM_ElementList*)list)->subtype = &_StartCounters_type;
   ((_HDDM_ElementList*)list)->list = (HDDM_ElementList<HDDM_Element>*)
    new StartCountersList(me->elem->addStartCounterses(count, start));
   ((_HDDM_ElementList*)list)->borrowed = 0;
   ((_HDDM_ElementList*)list)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(list), ((_HDDM_ElementList*)list)->subtype, 1);
   return list;
}

static PyObject*
_HitStatistics_deleteStartCounterses(PyObject *self, PyObject *args)
{
   int count=-1;
   int start=0;
   if (! PyArg_ParseTuple(args, "|ii", &count, &start)) {
      return NULL;
   }
   _HitStatistics *me = (_HitStatistics*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "delete attempted on invalid hitStatistics element");
      return NULL;
   }
   me->elem->deleteStartCounterses(count, start);
   Py_INCREF(Py_None);
   return Py_None;
}

static PyObject*
_HitStatistics_getCdcStraws(PyObject *self, PyObject *args)
{
   int index=0;
   if (! PyArg_ParseTuple(args, "|i", &index)) {
      return NULL;
   }
   _HitStatistics *me = (_HitStatistics*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid hitStatistics element");
      return NULL;
   }
   PyObject *obj = _CdcStraws_new(&_CdcStraws_type, 0, 0);
   ((_CdcStraws*)obj)->elem = &me->elem->getCdcStraws();
   ((_CdcStraws*)obj)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(obj));
   return obj;
}

static PyObject*
_HitStatistics_getCdcStrawses(PyObject *self, PyObject *args)
{
   _HitStatistics *me = (_HitStatistics*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid hitStatistics element");
      return NULL;
   }
   PyObject *list = _HDDM_ElementList_new(&_HDDM_ElementList_type, 0, 0);
   ((_HDDM_ElementList*)list)->subtype = &_CdcStraws_type;
   ((_HDDM_ElementList*)list)->list = (HDDM_ElementList<HDDM_Element>*)
    &me->elem->getCdcStrawses();
   ((_HDDM_ElementList*)list)->borrowed = 1;
   ((_HDDM_ElementList*)list)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(list), ((_HDDM_ElementList*)list)->subtype, 0);
   return list;
}

static PyObject*
_HitStatistics_addCdcStrawses(PyObject *self, PyObject *args)
{
   int count=1;
   int start=-1;
   if (! PyArg_ParseTuple(args, "|ii", &count, &start)) {
      return NULL;
   }
   _HitStatistics *me = (_HitStatistics*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "add attempted on invalid hitStatistics element");
      return NULL;
   }
   PyObject *list = _HDDM_ElementList_new(&_HDDM_ElementList_type, 0, 0);
   ((_HDDM_ElementList*)list)->subtype = &_CdcStraws_type;
   ((_HDDM_ElementList*)list)->list = (HDDM_ElementList<HDDM_Element>*)
    new CdcStrawsList(me->elem->addCdcStrawses(count, start));
   ((_HDDM_ElementList*)list)->borrowed = 0;
   ((_HDDM_ElementList*)list)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(list), ((_HDDM_ElementList*)list)->subtype, 1);
   return list;
}

static PyObject*
_HitStatistics_deleteCdcStrawses(PyObject *self, PyObject *args)
{
   int count=-1;
   int start=0;
   if (! PyArg_ParseTuple(args, "|ii", &count, &start)) {
      return NULL;
   }
   _HitStatistics *me = (_HitStatistics*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "delete attempted on invalid hitStatistics element");
      return NULL;
   }
   me->elem->deleteCdcStrawses(count, start);
   Py_INCREF(Py_None);
   return Py_None;
}

static PyObject*
_HitStatistics_getFdcPseudos(PyObject *self, PyObject *args)
{
   int index=0;
   if (! PyArg_ParseTuple(args, "|i", &index)) {
      return NULL;
   }
   _HitStatistics *me = (_HitStatistics*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid hitStatistics element");
      return NULL;
   }
   PyObject *obj = _FdcPseudos_new(&_FdcPseudos_type, 0, 0);
   ((_FdcPseudos*)obj)->elem = &me->elem->getFdcPseudos();
   ((_FdcPseudos*)obj)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(obj));
   return obj;
}

static PyObject*
_HitStatistics_getFdcPseudoses(PyObject *self, PyObject *args)
{
   _HitStatistics *me = (_HitStatistics*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid hitStatistics element");
      return NULL;
   }
   PyObject *list = _HDDM_ElementList_new(&_HDDM_ElementList_type, 0, 0);
   ((_HDDM_ElementList*)list)->subtype = &_FdcPseudos_type;
   ((_HDDM_ElementList*)list)->list = (HDDM_ElementList<HDDM_Element>*)
    &me->elem->getFdcPseudoses();
   ((_HDDM_ElementList*)list)->borrowed = 1;
   ((_HDDM_ElementList*)list)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(list), ((_HDDM_ElementList*)list)->subtype, 0);
   return list;
}

static PyObject*
_HitStatistics_addFdcPseudoses(PyObject *self, PyObject *args)
{
   int count=1;
   int start=-1;
   if (! PyArg_ParseTuple(args, "|ii", &count, &start)) {
      return NULL;
   }
   _HitStatistics *me = (_HitStatistics*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "add attempted on invalid hitStatistics element");
      return NULL;
   }
   PyObject *list = _HDDM_ElementList_new(&_HDDM_ElementList_type, 0, 0);
   ((_HDDM_ElementList*)list)->subtype = &_FdcPseudos_type;
   ((_HDDM_ElementList*)list)->list = (HDDM_ElementList<HDDM_Element>*)
    new FdcPseudosList(me->elem->addFdcPseudoses(count, start));
   ((_HDDM_ElementList*)list)->borrowed = 0;
   ((_HDDM_ElementList*)list)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(list), ((_HDDM_ElementList*)list)->subtype, 1);
   return list;
}

static PyObject*
_HitStatistics_deleteFdcPseudoses(PyObject *self, PyObject *args)
{
   int count=-1;
   int start=0;
   if (! PyArg_ParseTuple(args, "|ii", &count, &start)) {
      return NULL;
   }
   _HitStatistics *me = (_HitStatistics*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "delete attempted on invalid hitStatistics element");
      return NULL;
   }
   me->elem->deleteFdcPseudoses(count, start);
   Py_INCREF(Py_None);
   return Py_None;
}

static PyObject*
_HitStatistics_getBcalCells(PyObject *self, PyObject *args)
{
   int index=0;
   if (! PyArg_ParseTuple(args, "|i", &index)) {
      return NULL;
   }
   _HitStatistics *me = (_HitStatistics*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid hitStatistics element");
      return NULL;
   }
   PyObject *obj = _BcalCells_new(&_BcalCells_type, 0, 0);
   ((_BcalCells*)obj)->elem = &me->elem->getBcalCells();
   ((_BcalCells*)obj)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(obj));
   return obj;
}

static PyObject*
_HitStatistics_getBcalCellses(PyObject *self, PyObject *args)
{
   _HitStatistics *me = (_HitStatistics*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid hitStatistics element");
      return NULL;
   }
   PyObject *list = _HDDM_ElementList_new(&_HDDM_ElementList_type, 0, 0);
   ((_HDDM_ElementList*)list)->subtype = &_BcalCells_type;
   ((_HDDM_ElementList*)list)->list = (HDDM_ElementList<HDDM_Element>*)
    &me->elem->getBcalCellses();
   ((_HDDM_ElementList*)list)->borrowed = 1;
   ((_HDDM_ElementList*)list)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(list), ((_HDDM_ElementList*)list)->subtype, 0);
   return list;
}

static PyObject*
_HitStatistics_addBcalCellses(PyObject *self, PyObject *args)
{
   int count=1;
   int start=-1;
   if (! PyArg_ParseTuple(args, "|ii", &count, &start)) {
      return NULL;
   }
   _HitStatistics *me = (_HitStatistics*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "add attempted on invalid hitStatistics element");
      return NULL;
   }
   PyObject *list = _HDDM_ElementList_new(&_HDDM_ElementList_type, 0, 0);
   ((_HDDM_ElementList*)list)->subtype = &_BcalCells_type;
   ((_HDDM_ElementList*)list)->list = (HDDM_ElementList<HDDM_Element>*)
    new BcalCellsList(me->elem->addBcalCellses(count, start));
   ((_HDDM_ElementList*)list)->borrowed = 0;
   ((_HDDM_ElementList*)list)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(list), ((_HDDM_ElementList*)list)->subtype, 1);
   return list;
}

static PyObject*
_HitStatistics_deleteBcalCellses(PyObject *self, PyObject *args)
{
   int count=-1;
   int start=0;
   if (! PyArg_ParseTuple(args, "|ii", &count, &start)) {
      return NULL;
   }
   _HitStatistics *me = (_HitStatistics*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "delete attempted on invalid hitStatistics element");
      return NULL;
   }
   me->elem->deleteBcalCellses(count, start);
   Py_INCREF(Py_None);
   return Py_None;
}

static PyObject*
_HitStatistics_getFcalBlocks(PyObject *self, PyObject *args)
{
   int index=0;
   if (! PyArg_ParseTuple(args, "|i", &index)) {
      return NULL;
   }
   _HitStatistics *me = (_HitStatistics*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid hitStatistics element");
      return NULL;
   }
   PyObject *obj = _FcalBlocks_new(&_FcalBlocks_type, 0, 0);
   ((_FcalBlocks*)obj)->elem = &me->elem->getFcalBlocks();
   ((_FcalBlocks*)obj)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(obj));
   return obj;
}

static PyObject*
_HitStatistics_getFcalBlockses(PyObject *self, PyObject *args)
{
   _HitStatistics *me = (_HitStatistics*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid hitStatistics element");
      return NULL;
   }
   PyObject *list = _HDDM_ElementList_new(&_HDDM_ElementList_type, 0, 0);
   ((_HDDM_ElementList*)list)->subtype = &_FcalBlocks_type;
   ((_HDDM_ElementList*)list)->list = (HDDM_ElementList<HDDM_Element>*)
    &me->elem->getFcalBlockses();
   ((_HDDM_ElementList*)list)->borrowed = 1;
   ((_HDDM_ElementList*)list)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(list), ((_HDDM_ElementList*)list)->subtype, 0);
   return list;
}

static PyObject*
_HitStatistics_addFcalBlockses(PyObject *self, PyObject *args)
{
   int count=1;
   int start=-1;
   if (! PyArg_ParseTuple(args, "|ii", &count, &start)) {
      return NULL;
   }
   _HitStatistics *me = (_HitStatistics*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "add attempted on invalid hitStatistics element");
      return NULL;
   }
   PyObject *list = _HDDM_ElementList_new(&_HDDM_ElementList_type, 0, 0);
   ((_HDDM_ElementList*)list)->subtype = &_FcalBlocks_type;
   ((_HDDM_ElementList*)list)->list = (HDDM_ElementList<HDDM_Element>*)
    new FcalBlocksList(me->elem->addFcalBlockses(count, start));
   ((_HDDM_ElementList*)list)->borrowed = 0;
   ((_HDDM_ElementList*)list)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(list), ((_HDDM_ElementList*)list)->subtype, 1);
   return list;
}

static PyObject*
_HitStatistics_deleteFcalBlockses(PyObject *self, PyObject *args)
{
   int count=-1;
   int start=0;
   if (! PyArg_ParseTuple(args, "|ii", &count, &start)) {
      return NULL;
   }
   _HitStatistics *me = (_HitStatistics*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "delete attempted on invalid hitStatistics element");
      return NULL;
   }
   me->elem->deleteFcalBlockses(count, start);
   Py_INCREF(Py_None);
   return Py_None;
}

static PyObject*
_HitStatistics_getTofPaddles(PyObject *self, PyObject *args)
{
   int index=0;
   if (! PyArg_ParseTuple(args, "|i", &index)) {
      return NULL;
   }
   _HitStatistics *me = (_HitStatistics*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid hitStatistics element");
      return NULL;
   }
   PyObject *obj = _TofPaddles_new(&_TofPaddles_type, 0, 0);
   ((_TofPaddles*)obj)->elem = &me->elem->getTofPaddles();
   ((_TofPaddles*)obj)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(obj));
   return obj;
}

static PyObject*
_HitStatistics_getTofPaddleses(PyObject *self, PyObject *args)
{
   _HitStatistics *me = (_HitStatistics*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid hitStatistics element");
      return NULL;
   }
   PyObject *list = _HDDM_ElementList_new(&_HDDM_ElementList_type, 0, 0);
   ((_HDDM_ElementList*)list)->subtype = &_TofPaddles_type;
   ((_HDDM_ElementList*)list)->list = (HDDM_ElementList<HDDM_Element>*)
    &me->elem->getTofPaddleses();
   ((_HDDM_ElementList*)list)->borrowed = 1;
   ((_HDDM_ElementList*)list)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(list), ((_HDDM_ElementList*)list)->subtype, 0);
   return list;
}

static PyObject*
_HitStatistics_addTofPaddleses(PyObject *self, PyObject *args)
{
   int count=1;
   int start=-1;
   if (! PyArg_ParseTuple(args, "|ii", &count, &start)) {
      return NULL;
   }
   _HitStatistics *me = (_HitStatistics*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "add attempted on invalid hitStatistics element");
      return NULL;
   }
   PyObject *list = _HDDM_ElementList_new(&_HDDM_ElementList_type, 0, 0);
   ((_HDDM_ElementList*)list)->subtype = &_TofPaddles_type;
   ((_HDDM_ElementList*)list)->list = (HDDM_ElementList<HDDM_Element>*)
    new TofPaddlesList(me->elem->addTofPaddleses(count, start));
   ((_HDDM_ElementList*)list)->borrowed = 0;
   ((_HDDM_ElementList*)list)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(list), ((_HDDM_ElementList*)list)->subtype, 1);
   return list;
}

static PyObject*
_HitStatistics_deleteTofPaddleses(PyObject *self, PyObject *args)
{
   int count=-1;
   int start=0;
   if (! PyArg_ParseTuple(args, "|ii", &count, &start)) {
      return NULL;
   }
   _HitStatistics *me = (_HitStatistics*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "delete attempted on invalid hitStatistics element");
      return NULL;
   }
   me->elem->deleteTofPaddleses(count, start);
   Py_INCREF(Py_None);
   return Py_None;
}

static PyObject*
_HitStatistics_getCcalBlocks(PyObject *self, PyObject *args)
{
   int index=0;
   if (! PyArg_ParseTuple(args, "|i", &index)) {
      return NULL;
   }
   _HitStatistics *me = (_HitStatistics*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid hitStatistics element");
      return NULL;
   }
   PyObject *obj = _CcalBlocks_new(&_CcalBlocks_type, 0, 0);
   ((_CcalBlocks*)obj)->elem = &me->elem->getCcalBlocks();
   ((_CcalBlocks*)obj)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(obj));
   return obj;
}

static PyObject*
_HitStatistics_getCcalBlockses(PyObject *self, PyObject *args)
{
   _HitStatistics *me = (_HitStatistics*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid hitStatistics element");
      return NULL;
   }
   PyObject *list = _HDDM_ElementList_new(&_HDDM_ElementList_type, 0, 0);
   ((_HDDM_ElementList*)list)->subtype = &_CcalBlocks_type;
   ((_HDDM_ElementList*)list)->list = (HDDM_ElementList<HDDM_Element>*)
    &me->elem->getCcalBlockses();
   ((_HDDM_ElementList*)list)->borrowed = 1;
   ((_HDDM_ElementList*)list)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(list), ((_HDDM_ElementList*)list)->subtype, 0);
   return list;
}

static PyObject*
_HitStatistics_addCcalBlockses(PyObject *self, PyObject *args)
{
   int count=1;
   int start=-1;
   if (! PyArg_ParseTuple(args, "|ii", &count, &start)) {
      return NULL;
   }
   _HitStatistics *me = (_HitStatistics*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "add attempted on invalid hitStatistics element");
      return NULL;
   }
   PyObject *list = _HDDM_ElementList_new(&_HDDM_ElementList_type, 0, 0);
   ((_HDDM_ElementList*)list)->subtype = &_CcalBlocks_type;
   ((_HDDM_ElementList*)list)->list = (HDDM_ElementList<HDDM_Element>*)
    new CcalBlocksList(me->elem->addCcalBlockses(count, start));
   ((_HDDM_ElementList*)list)->borrowed = 0;
   ((_HDDM_ElementList*)list)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(list), ((_HDDM_ElementList*)list)->subtype, 1);
   return list;
}

static PyObject*
_HitStatistics_deleteCcalBlockses(PyObject *self, PyObject *args)
{
   int count=-1;
   int start=0;
   if (! PyArg_ParseTuple(args, "|ii", &count, &start)) {
      return NULL;
   }
   _HitStatistics *me = (_HitStatistics*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "delete attempted on invalid hitStatistics element");
      return NULL;
   }
   me->elem->deleteCcalBlockses(count, start);
   Py_INCREF(Py_None);
   return Py_None;
}

static PyObject*
_HitStatistics_getDircPMTs(PyObject *self, PyObject *args)
{
   int index=0;
   if (! PyArg_ParseTuple(args, "|i", &index)) {
      return NULL;
   }
   _HitStatistics *me = (_HitStatistics*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid hitStatistics element");
      return NULL;
   }
   PyObject *obj = _DircPMTs_new(&_DircPMTs_type, 0, 0);
   ((_DircPMTs*)obj)->elem = &me->elem->getDircPMTs();
   ((_DircPMTs*)obj)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(obj));
   return obj;
}

static PyObject*
_HitStatistics_getDircPMTses(PyObject *self, PyObject *args)
{
   _HitStatistics *me = (_HitStatistics*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid hitStatistics element");
      return NULL;
   }
   PyObject *list = _HDDM_ElementList_new(&_HDDM_ElementList_type, 0, 0);
   ((_HDDM_ElementList*)list)->subtype = &_DircPMTs_type;
   ((_HDDM_ElementList*)list)->list = (HDDM_ElementList<HDDM_Element>*)
    &me->elem->getDircPMTses();
   ((_HDDM_ElementList*)list)->borrowed = 1;
   ((_HDDM_ElementList*)list)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(list), ((_HDDM_ElementList*)list)->subtype, 0);
   return list;
}

static PyObject*
_HitStatistics_addDircPMTses(PyObject *self, PyObject *args)
{
   int count=1;
   int start=-1;
   if (! PyArg_ParseTuple(args, "|ii", &count, &start)) {
      return NULL;
   }
   _HitStatistics *me = (_HitStatistics*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "add attempted on invalid hitStatistics element");
      return NULL;
   }
   PyObject *list = _HDDM_ElementList_new(&_HDDM_ElementList_type, 0, 0);
   ((_HDDM_ElementList*)list)->subtype = &_DircPMTs_type;
   ((_HDDM_ElementList*)list)->list = (HDDM_ElementList<HDDM_Element>*)
    new DircPMTsList(me->elem->addDircPMTses(count, start));
   ((_HDDM_ElementList*)list)->borrowed = 0;
   ((_HDDM_ElementList*)list)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(list), ((_HDDM_ElementList*)list)->subtype, 1);
   return list;
}

static PyObject*
_HitStatistics_deleteDircPMTses(PyObject *self, PyObject *args)
{
   int count=-1;
   int start=0;
   if (! PyArg_ParseTuple(args, "|ii", &count, &start)) {
      return NULL;
   }
   _HitStatistics *me = (_HitStatistics*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "delete attempted on invalid hitStatistics element");
      return NULL;
   }
   me->elem->deleteDircPMTses(count, start);
   Py_INCREF(Py_None);
   return Py_None;
}

static PyObject*
_HitStatistics_toString(PyObject *self, PyObject *args=0)
{
   _HitStatistics *me = (_HitStatistics*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid hitStatistics element");
      return NULL;
   }
   std::string str(me->elem->toString());
   return PyUnicode_FromString(str.c_str());
}

static PyObject*
_HitStatistics_toXML(PyObject *self, PyObject *args=0)
{
   _HitStatistics *me = (_HitStatistics*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid hitStatistics element");
      return NULL;
   }
   std::string str(me->elem->toXML());
   return PyUnicode_FromString(str.c_str());
}

static PyGetSetDef _HitStatistics_getsetters[] = {
   {(char*)"class",
    (getter)_HitStatistics_getClass, 0,
    (char*)"class string",
    NULL},
   {(char*)"eventNo",
    (getter)_HitStatistics_getEventNo, 0,
    (char*)"eventNo value",
    NULL},
   {(char*)"jtag",
    (getter)_HitStatistics_getJtag, (setter)_HitStatistics_setJtag,
    (char*)"jtag string",
    NULL},
   {(char*)"minOccurs",
    (getter)_HitStatistics_getMinOccurs, 0,
    (char*)"minOccurs value",
    NULL},
   {(char*)"runNo",
    (getter)_HitStatistics_getRunNo, 0,
    (char*)"runNo value",
    NULL},
   {(char*)"version",
    (getter)_HitStatistics_getVersion, 0,
    (char*)"version string",
    NULL},
   {(char*)"xmlns",
    (getter)_HitStatistics_getXmlns, 0,
    (char*)"xmlns string",
    NULL},
   {NULL}  /* Sentinel */
};

static PyMemberDef _HitStatistics_members[] = {
   {NULL}  /* Sentinel */
};

static PyMethodDef _HitStatistics_methods[] = {
   {"addBcalCellses", _HitStatistics_addBcalCellses, METH_VARARGS,
    "extend (or insert into) the list of bcalCells objects for this hitStatistics"},
   {"addCcalBlockses", _HitStatistics_addCcalBlockses, METH_VARARGS,
    "extend (or insert into) the list of ccalBlocks objects for this hitStatistics"},
   {"addCdcStrawses", _HitStatistics_addCdcStrawses, METH_VARARGS,
    "extend (or insert into) the list of cdcStraws objects for this hitStatistics"},
   {"addDircPMTses", _HitStatistics_addDircPMTses, METH_VARARGS,
    "extend (or insert into) the list of dircPMTs objects for this hitStatistics"},
   {"addFcalBlockses", _HitStatistics_addFcalBlockses, METH_VARARGS,
    "extend (or insert into) the list of fcalBlocks objects for this hitStatistics"},
   {"addFdcPseudoses", _HitStatistics_addFdcPseudoses, METH_VARARGS,
    "extend (or insert into) the list of fdcPseudos objects for this hitStatistics"},
   {"addStartCounterses", _HitStatistics_addStartCounterses, METH_VARARGS,
    "extend (or insert into) the list of startCounters objects for this hitStatistics"},
   {"addTofPaddleses", _HitStatistics_addTofPaddleses, METH_VARARGS,
    "extend (or insert into) the list of tofPaddles objects for this hitStatistics"},
   {"deleteBcalCellses", _HitStatistics_deleteBcalCellses, METH_VARARGS,
    "delete bcalCells objects for this hitStatistics"},
   {"deleteCcalBlockses", _HitStatistics_deleteCcalBlockses, METH_VARARGS,
    "delete ccalBlocks objects for this hitStatistics"},
   {"deleteCdcStrawses", _HitStatistics_deleteCdcStrawses, METH_VARARGS,
    "delete cdcStraws objects for this hitStatistics"},
   {"deleteDircPMTses", _HitStatistics_deleteDircPMTses, METH_VARARGS,
    "delete dircPMTs objects for this hitStatistics"},
   {"deleteFcalBlockses", _HitStatistics_deleteFcalBlockses, METH_VARARGS,
    "delete fcalBlocks objects for this hitStatistics"},
   {"deleteFdcPseudoses", _HitStatistics_deleteFdcPseudoses, METH_VARARGS,
    "delete fdcPseudos objects for this hitStatistics"},
   {"deleteStartCounterses", _HitStatistics_deleteStartCounterses, METH_VARARGS,
    "delete startCounters objects for this hitStatistics"},
   {"deleteTofPaddleses", _HitStatistics_deleteTofPaddleses, METH_VARARGS,
    "delete tofPaddles objects for this hitStatistics"},
   {"getBcalCells", _HitStatistics_getBcalCells, METH_VARARGS,
    "get an individual bcalCells object from this hitStatistics"},
   {"getBcalCellses", _HitStatistics_getBcalCellses, METH_NOARGS,
    "get list of bcalCells objects for this hitStatistics"},
   {"getCcalBlocks", _HitStatistics_getCcalBlocks, METH_VARARGS,
    "get an individual ccalBlocks object from this hitStatistics"},
   {"getCcalBlockses", _HitStatistics_getCcalBlockses, METH_NOARGS,
    "get list of ccalBlocks objects for this hitStatistics"},
   {"getCdcStraws", _HitStatistics_getCdcStraws, METH_VARARGS,
    "get an individual cdcStraws object from this hitStatistics"},
   {"getCdcStrawses", _HitStatistics_getCdcStrawses, METH_NOARGS,
    "get list of cdcStraws objects for this hitStatistics"},
   {"getDircPMTs", _HitStatistics_getDircPMTs, METH_VARARGS,
    "get an individual dircPMTs object from this hitStatistics"},
   {"getDircPMTses", _HitStatistics_getDircPMTses, METH_NOARGS,
    "get list of dircPMTs objects for this hitStatistics"},
   {"getFcalBlocks", _HitStatistics_getFcalBlocks, METH_VARARGS,
    "get an individual fcalBlocks object from this hitStatistics"},
   {"getFcalBlockses", _HitStatistics_getFcalBlockses, METH_NOARGS,
    "get list of fcalBlocks objects for this hitStatistics"},
   {"getFdcPseudos", _HitStatistics_getFdcPseudos, METH_VARARGS,
    "get an individual fdcPseudos object from this hitStatistics"},
   {"getFdcPseudoses", _HitStatistics_getFdcPseudoses, METH_NOARGS,
    "get list of fdcPseudos objects for this hitStatistics"},
   {"getStartCounters", _HitStatistics_getStartCounters, METH_VARARGS,
    "get an individual startCounters object from this hitStatistics"},
   {"getStartCounterses", _HitStatistics_getStartCounterses, METH_NOARGS,
    "get list of startCounters objects for this hitStatistics"},
   {"getTofPaddles", _HitStatistics_getTofPaddles, METH_VARARGS,
    "get an individual tofPaddles object from this hitStatistics"},
   {"getTofPaddleses", _HitStatistics_getTofPaddleses, METH_NOARGS,
    "get list of tofPaddles objects for this hitStatistics"},
   {"toString", _HitStatistics_toString, METH_NOARGS,
    "show element as a human-readable string"},
   {"toXML", _HitStatistics_toXML, METH_NOARGS,
    "show element as a XML fragment"},
   {NULL}  /* Sentinel */
};

static PyTypeObject _HitStatistics_type = {
    PyVarObject_HEAD_INIT(NULL,0)
    "hddm_r.HitStatistics",         /*tp_name*/
    sizeof(_HitStatistics),          /*tp_basicsize*/
    0,                         /*tp_itemsize*/
    (destructor)_HitStatistics_dealloc, /*tp_dealloc*/
    0,                         /*tp_print*/
    0,                         /*tp_getattr*/
    0,                         /*tp_setattr*/
    0,                         /*tp_compare*/
    0,                         /*tp_repr*/
    0,                         /*tp_as_number*/
    0,                         /*tp_as_sequence*/
    0,                         /*tp_as_mapping*/
    0,                         /*tp_hash */
    0,                         /*tp_call*/
    (reprfunc)_HitStatistics_toString,         /*tp_str*/
    0,                         /*tp_getattro*/
    0,                         /*tp_setattro*/
    0,                         /*tp_as_buffer*/
    Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE, /*tp_flags*/
    "hddm_r hitStatistics element",  /* tp_doc */
    0,                         /* tp_traverse */
    0,                         /* tp_clear */
    0,                         /* tp_richcompare */
    0,                         /* tp_weaklistoffset */
    0,                         /* tp_iter */
    0,                         /* tp_iternext */
    _HitStatistics_methods,          /* tp_methods */
    _HitStatistics_members,          /* tp_members */
    _HitStatistics_getsetters,       /* tp_getset */
    &_HDDM_Element_type,       /* tp_base */
    0,                         /* tp_dict */
    0,                         /* tp_descr_get */
    0,                         /* tp_descr_set */
    0,                         /* tp_dictoffset */
    (initproc)_HitStatistics_init,   /* tp_init */
    0,                         /* tp_alloc */
    _HitStatistics_new,              /* tp_new */
};



// wrap element class hddm_r::ReconstructedPhysicsEvent as hddm_r.ReconstructedPhysicsEvent

typedef struct {
   PyObject_HEAD
   ReconstructedPhysicsEvent *elem;
   PyObject *host;
} _ReconstructedPhysicsEvent;

static void
_ReconstructedPhysicsEvent_dealloc(_ReconstructedPhysicsEvent* self)
{
   if (self->elem != 0) {
      LOG_DEALLOC(Py_TYPE(self), 0, self->host == (PyObject*)self);
      if (self->host == (PyObject*)self)
         delete self->elem;
      else
         My_DECREF(self->host);
   }
   Py_TYPE(self)->tp_free((PyObject*)self);
}

static PyObject*
_ReconstructedPhysicsEvent_new(PyTypeObject *type, PyObject *args, PyObject *kwds)
{
   _ReconstructedPhysicsEvent *self;
   self = (_ReconstructedPhysicsEvent*)type->tp_alloc(type, 0);
   if (self != NULL) {
      self->elem = 0;
      self->host = 0;
   }
   return (PyObject*)self;
}

static int
_ReconstructedPhysicsEvent_init(_ReconstructedPhysicsEvent *self, PyObject *args, PyObject *kwds)
{
   PyErr_SetString(PyExc_RuntimeError, "illegal constructor");
   return -1;
}

static PyObject*
_ReconstructedPhysicsEvent_getClass(_ReconstructedPhysicsEvent *self, void *closure)
{
   std::string val(self->elem->getClass());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_ReconstructedPhysicsEvent_getVersion(_ReconstructedPhysicsEvent *self, void *closure)
{
   std::string val(self->elem->getVersion());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_ReconstructedPhysicsEvent_getXmlns(_ReconstructedPhysicsEvent *self, void *closure)
{
   std::string val(self->elem->getXmlns());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_ReconstructedPhysicsEvent_getEventNo(_ReconstructedPhysicsEvent *self, void *closure)
{
   return PyLong_FromLongLong(self->elem->getEventNo());
}

static int
_ReconstructedPhysicsEvent_setEventNo(_ReconstructedPhysicsEvent *self, PyObject *value, void *closure)
{
   long var = PyInt_AsLong(value);
   if (var == -1 && PyErr_Occurred()) {
      return -1;
   }
   self->elem->setEventNo(var);
   return 0;
}

static PyObject*
_ReconstructedPhysicsEvent_getRunNo(_ReconstructedPhysicsEvent *self, void *closure)
{
   return PyLong_FromLong(self->elem->getRunNo());
}

static int
_ReconstructedPhysicsEvent_setRunNo(_ReconstructedPhysicsEvent *self, PyObject *value, void *closure)
{
   long var = PyInt_AsLong(value);
   if (var == -1 && PyErr_Occurred()) {
      return -1;
   }
   self->elem->setRunNo(var);
   return 0;
}

static PyObject*
_ReconstructedPhysicsEvent_getComment(PyObject *self, PyObject *args)
{
   int index=0;
   if (! PyArg_ParseTuple(args, "|i", &index)) {
      return NULL;
   }
   _ReconstructedPhysicsEvent *me = (_ReconstructedPhysicsEvent*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid reconstructedPhysicsEvent element");
      return NULL;
   }
   PyObject *obj = _Comment_new(&_Comment_type, 0, 0);
   ((_Comment*)obj)->elem = &me->elem->getComment(index);
   ((_Comment*)obj)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(obj));
   return obj;
}

static PyObject*
_ReconstructedPhysicsEvent_getComments(PyObject *self, PyObject *args)
{
   _ReconstructedPhysicsEvent *me = (_ReconstructedPhysicsEvent*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid reconstructedPhysicsEvent element");
      return NULL;
   }
   PyObject *list = _HDDM_ElementList_new(&_HDDM_ElementList_type, 0, 0);
   ((_HDDM_ElementList*)list)->subtype = &_Comment_type;
   ((_HDDM_ElementList*)list)->list = (HDDM_ElementList<HDDM_Element>*)
    &me->elem->getComments();
   ((_HDDM_ElementList*)list)->borrowed = 1;
   ((_HDDM_ElementList*)list)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(list), ((_HDDM_ElementList*)list)->subtype, 0);
   return list;
}

static PyObject*
_ReconstructedPhysicsEvent_addComments(PyObject *self, PyObject *args)
{
   int count=1;
   int start=-1;
   if (! PyArg_ParseTuple(args, "|ii", &count, &start)) {
      return NULL;
   }
   _ReconstructedPhysicsEvent *me = (_ReconstructedPhysicsEvent*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "add attempted on invalid reconstructedPhysicsEvent element");
      return NULL;
   }
   PyObject *list = _HDDM_ElementList_new(&_HDDM_ElementList_type, 0, 0);
   ((_HDDM_ElementList*)list)->subtype = &_Comment_type;
   ((_HDDM_ElementList*)list)->list = (HDDM_ElementList<HDDM_Element>*)
    new CommentList(me->elem->addComments(count, start));
   ((_HDDM_ElementList*)list)->borrowed = 0;
   ((_HDDM_ElementList*)list)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(list), ((_HDDM_ElementList*)list)->subtype, 1);
   return list;
}

static PyObject*
_ReconstructedPhysicsEvent_deleteComments(PyObject *self, PyObject *args)
{
   int count=-1;
   int start=0;
   if (! PyArg_ParseTuple(args, "|ii", &count, &start)) {
      return NULL;
   }
   _ReconstructedPhysicsEvent *me = (_ReconstructedPhysicsEvent*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "delete attempted on invalid reconstructedPhysicsEvent element");
      return NULL;
   }
   me->elem->deleteComments(count, start);
   Py_INCREF(Py_None);
   return Py_None;
}

static PyObject*
_ReconstructedPhysicsEvent_getDataVersionString(PyObject *self, PyObject *args)
{
   int index=0;
   if (! PyArg_ParseTuple(args, "|i", &index)) {
      return NULL;
   }
   _ReconstructedPhysicsEvent *me = (_ReconstructedPhysicsEvent*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid reconstructedPhysicsEvent element");
      return NULL;
   }
   PyObject *obj = _DataVersionString_new(&_DataVersionString_type, 0, 0);
   ((_DataVersionString*)obj)->elem = &me->elem->getDataVersionString(index);
   ((_DataVersionString*)obj)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(obj));
   return obj;
}

static PyObject*
_ReconstructedPhysicsEvent_getDataVersionStrings(PyObject *self, PyObject *args)
{
   _ReconstructedPhysicsEvent *me = (_ReconstructedPhysicsEvent*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid reconstructedPhysicsEvent element");
      return NULL;
   }
   PyObject *list = _HDDM_ElementList_new(&_HDDM_ElementList_type, 0, 0);
   ((_HDDM_ElementList*)list)->subtype = &_DataVersionString_type;
   ((_HDDM_ElementList*)list)->list = (HDDM_ElementList<HDDM_Element>*)
    &me->elem->getDataVersionStrings();
   ((_HDDM_ElementList*)list)->borrowed = 1;
   ((_HDDM_ElementList*)list)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(list), ((_HDDM_ElementList*)list)->subtype, 0);
   return list;
}

static PyObject*
_ReconstructedPhysicsEvent_addDataVersionStrings(PyObject *self, PyObject *args)
{
   int count=1;
   int start=-1;
   if (! PyArg_ParseTuple(args, "|ii", &count, &start)) {
      return NULL;
   }
   _ReconstructedPhysicsEvent *me = (_ReconstructedPhysicsEvent*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "add attempted on invalid reconstructedPhysicsEvent element");
      return NULL;
   }
   PyObject *list = _HDDM_ElementList_new(&_HDDM_ElementList_type, 0, 0);
   ((_HDDM_ElementList*)list)->subtype = &_DataVersionString_type;
   ((_HDDM_ElementList*)list)->list = (HDDM_ElementList<HDDM_Element>*)
    new DataVersionStringList(me->elem->addDataVersionStrings(count, start));
   ((_HDDM_ElementList*)list)->borrowed = 0;
   ((_HDDM_ElementList*)list)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(list), ((_HDDM_ElementList*)list)->subtype, 1);
   return list;
}

static PyObject*
_ReconstructedPhysicsEvent_deleteDataVersionStrings(PyObject *self, PyObject *args)
{
   int count=-1;
   int start=0;
   if (! PyArg_ParseTuple(args, "|ii", &count, &start)) {
      return NULL;
   }
   _ReconstructedPhysicsEvent *me = (_ReconstructedPhysicsEvent*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "delete attempted on invalid reconstructedPhysicsEvent element");
      return NULL;
   }
   me->elem->deleteDataVersionStrings(count, start);
   Py_INCREF(Py_None);
   return Py_None;
}

static PyObject*
_ReconstructedPhysicsEvent_getCcdbContext(PyObject *self, PyObject *args)
{
   int index=0;
   if (! PyArg_ParseTuple(args, "|i", &index)) {
      return NULL;
   }
   _ReconstructedPhysicsEvent *me = (_ReconstructedPhysicsEvent*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid reconstructedPhysicsEvent element");
      return NULL;
   }
   PyObject *obj = _CcdbContext_new(&_CcdbContext_type, 0, 0);
   ((_CcdbContext*)obj)->elem = &me->elem->getCcdbContext(index);
   ((_CcdbContext*)obj)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(obj));
   return obj;
}

static PyObject*
_ReconstructedPhysicsEvent_getCcdbContexts(PyObject *self, PyObject *args)
{
   _ReconstructedPhysicsEvent *me = (_ReconstructedPhysicsEvent*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid reconstructedPhysicsEvent element");
      return NULL;
   }
   PyObject *list = _HDDM_ElementList_new(&_HDDM_ElementList_type, 0, 0);
   ((_HDDM_ElementList*)list)->subtype = &_CcdbContext_type;
   ((_HDDM_ElementList*)list)->list = (HDDM_ElementList<HDDM_Element>*)
    &me->elem->getCcdbContexts();
   ((_HDDM_ElementList*)list)->borrowed = 1;
   ((_HDDM_ElementList*)list)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(list), ((_HDDM_ElementList*)list)->subtype, 0);
   return list;
}

static PyObject*
_ReconstructedPhysicsEvent_addCcdbContexts(PyObject *self, PyObject *args)
{
   int count=1;
   int start=-1;
   if (! PyArg_ParseTuple(args, "|ii", &count, &start)) {
      return NULL;
   }
   _ReconstructedPhysicsEvent *me = (_ReconstructedPhysicsEvent*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "add attempted on invalid reconstructedPhysicsEvent element");
      return NULL;
   }
   PyObject *list = _HDDM_ElementList_new(&_HDDM_ElementList_type, 0, 0);
   ((_HDDM_ElementList*)list)->subtype = &_CcdbContext_type;
   ((_HDDM_ElementList*)list)->list = (HDDM_ElementList<HDDM_Element>*)
    new CcdbContextList(me->elem->addCcdbContexts(count, start));
   ((_HDDM_ElementList*)list)->borrowed = 0;
   ((_HDDM_ElementList*)list)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(list), ((_HDDM_ElementList*)list)->subtype, 1);
   return list;
}

static PyObject*
_ReconstructedPhysicsEvent_deleteCcdbContexts(PyObject *self, PyObject *args)
{
   int count=-1;
   int start=0;
   if (! PyArg_ParseTuple(args, "|ii", &count, &start)) {
      return NULL;
   }
   _ReconstructedPhysicsEvent *me = (_ReconstructedPhysicsEvent*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "delete attempted on invalid reconstructedPhysicsEvent element");
      return NULL;
   }
   me->elem->deleteCcdbContexts(count, start);
   Py_INCREF(Py_None);
   return Py_None;
}

static PyObject*
_ReconstructedPhysicsEvent_getReaction(PyObject *self, PyObject *args)
{
   int index=0;
   if (! PyArg_ParseTuple(args, "|i", &index)) {
      return NULL;
   }
   _ReconstructedPhysicsEvent *me = (_ReconstructedPhysicsEvent*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid reconstructedPhysicsEvent element");
      return NULL;
   }
   PyObject *obj = _Reaction_new(&_Reaction_type, 0, 0);
   ((_Reaction*)obj)->elem = &me->elem->getReaction(index);
   ((_Reaction*)obj)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(obj));
   return obj;
}

static PyObject*
_ReconstructedPhysicsEvent_getReactions(PyObject *self, PyObject *args)
{
   _ReconstructedPhysicsEvent *me = (_ReconstructedPhysicsEvent*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid reconstructedPhysicsEvent element");
      return NULL;
   }
   PyObject *list = _HDDM_ElementList_new(&_HDDM_ElementList_type, 0, 0);
   ((_HDDM_ElementList*)list)->subtype = &_Reaction_type;
   ((_HDDM_ElementList*)list)->list = (HDDM_ElementList<HDDM_Element>*)
    &me->elem->getReactions();
   ((_HDDM_ElementList*)list)->borrowed = 1;
   ((_HDDM_ElementList*)list)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(list), ((_HDDM_ElementList*)list)->subtype, 0);
   return list;
}

static PyObject*
_ReconstructedPhysicsEvent_addReactions(PyObject *self, PyObject *args)
{
   int count=1;
   int start=-1;
   if (! PyArg_ParseTuple(args, "|ii", &count, &start)) {
      return NULL;
   }
   _ReconstructedPhysicsEvent *me = (_ReconstructedPhysicsEvent*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "add attempted on invalid reconstructedPhysicsEvent element");
      return NULL;
   }
   PyObject *list = _HDDM_ElementList_new(&_HDDM_ElementList_type, 0, 0);
   ((_HDDM_ElementList*)list)->subtype = &_Reaction_type;
   ((_HDDM_ElementList*)list)->list = (HDDM_ElementList<HDDM_Element>*)
    new ReactionList(me->elem->addReactions(count, start));
   ((_HDDM_ElementList*)list)->borrowed = 0;
   ((_HDDM_ElementList*)list)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(list), ((_HDDM_ElementList*)list)->subtype, 1);
   return list;
}

static PyObject*
_ReconstructedPhysicsEvent_deleteReactions(PyObject *self, PyObject *args)
{
   int count=-1;
   int start=0;
   if (! PyArg_ParseTuple(args, "|ii", &count, &start)) {
      return NULL;
   }
   _ReconstructedPhysicsEvent *me = (_ReconstructedPhysicsEvent*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "delete attempted on invalid reconstructedPhysicsEvent element");
      return NULL;
   }
   me->elem->deleteReactions(count, start);
   Py_INCREF(Py_None);
   return Py_None;
}

static PyObject*
_ReconstructedPhysicsEvent_getTagmBeamPhoton(PyObject *self, PyObject *args)
{
   int index=0;
   if (! PyArg_ParseTuple(args, "|i", &index)) {
      return NULL;
   }
   _ReconstructedPhysicsEvent *me = (_ReconstructedPhysicsEvent*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid reconstructedPhysicsEvent element");
      return NULL;
   }
   PyObject *obj = _TagmBeamPhoton_new(&_TagmBeamPhoton_type, 0, 0);
   ((_TagmBeamPhoton*)obj)->elem = &me->elem->getTagmBeamPhoton(index);
   ((_TagmBeamPhoton*)obj)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(obj));
   return obj;
}

static PyObject*
_ReconstructedPhysicsEvent_getTagmBeamPhotons(PyObject *self, PyObject *args)
{
   _ReconstructedPhysicsEvent *me = (_ReconstructedPhysicsEvent*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid reconstructedPhysicsEvent element");
      return NULL;
   }
   PyObject *list = _HDDM_ElementList_new(&_HDDM_ElementList_type, 0, 0);
   ((_HDDM_ElementList*)list)->subtype = &_TagmBeamPhoton_type;
   ((_HDDM_ElementList*)list)->list = (HDDM_ElementList<HDDM_Element>*)
    &me->elem->getTagmBeamPhotons();
   ((_HDDM_ElementList*)list)->borrowed = 1;
   ((_HDDM_ElementList*)list)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(list), ((_HDDM_ElementList*)list)->subtype, 0);
   return list;
}

static PyObject*
_ReconstructedPhysicsEvent_addTagmBeamPhotons(PyObject *self, PyObject *args)
{
   int count=1;
   int start=-1;
   if (! PyArg_ParseTuple(args, "|ii", &count, &start)) {
      return NULL;
   }
   _ReconstructedPhysicsEvent *me = (_ReconstructedPhysicsEvent*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "add attempted on invalid reconstructedPhysicsEvent element");
      return NULL;
   }
   PyObject *list = _HDDM_ElementList_new(&_HDDM_ElementList_type, 0, 0);
   ((_HDDM_ElementList*)list)->subtype = &_TagmBeamPhoton_type;
   ((_HDDM_ElementList*)list)->list = (HDDM_ElementList<HDDM_Element>*)
    new TagmBeamPhotonList(me->elem->addTagmBeamPhotons(count, start));
   ((_HDDM_ElementList*)list)->borrowed = 0;
   ((_HDDM_ElementList*)list)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(list), ((_HDDM_ElementList*)list)->subtype, 1);
   return list;
}

static PyObject*
_ReconstructedPhysicsEvent_deleteTagmBeamPhotons(PyObject *self, PyObject *args)
{
   int count=-1;
   int start=0;
   if (! PyArg_ParseTuple(args, "|ii", &count, &start)) {
      return NULL;
   }
   _ReconstructedPhysicsEvent *me = (_ReconstructedPhysicsEvent*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "delete attempted on invalid reconstructedPhysicsEvent element");
      return NULL;
   }
   me->elem->deleteTagmBeamPhotons(count, start);
   Py_INCREF(Py_None);
   return Py_None;
}

static PyObject*
_ReconstructedPhysicsEvent_getTaghBeamPhoton(PyObject *self, PyObject *args)
{
   int index=0;
   if (! PyArg_ParseTuple(args, "|i", &index)) {
      return NULL;
   }
   _ReconstructedPhysicsEvent *me = (_ReconstructedPhysicsEvent*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid reconstructedPhysicsEvent element");
      return NULL;
   }
   PyObject *obj = _TaghBeamPhoton_new(&_TaghBeamPhoton_type, 0, 0);
   ((_TaghBeamPhoton*)obj)->elem = &me->elem->getTaghBeamPhoton(index);
   ((_TaghBeamPhoton*)obj)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(obj));
   return obj;
}

static PyObject*
_ReconstructedPhysicsEvent_getTaghBeamPhotons(PyObject *self, PyObject *args)
{
   _ReconstructedPhysicsEvent *me = (_ReconstructedPhysicsEvent*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid reconstructedPhysicsEvent element");
      return NULL;
   }
   PyObject *list = _HDDM_ElementList_new(&_HDDM_ElementList_type, 0, 0);
   ((_HDDM_ElementList*)list)->subtype = &_TaghBeamPhoton_type;
   ((_HDDM_ElementList*)list)->list = (HDDM_ElementList<HDDM_Element>*)
    &me->elem->getTaghBeamPhotons();
   ((_HDDM_ElementList*)list)->borrowed = 1;
   ((_HDDM_ElementList*)list)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(list), ((_HDDM_ElementList*)list)->subtype, 0);
   return list;
}

static PyObject*
_ReconstructedPhysicsEvent_addTaghBeamPhotons(PyObject *self, PyObject *args)
{
   int count=1;
   int start=-1;
   if (! PyArg_ParseTuple(args, "|ii", &count, &start)) {
      return NULL;
   }
   _ReconstructedPhysicsEvent *me = (_ReconstructedPhysicsEvent*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "add attempted on invalid reconstructedPhysicsEvent element");
      return NULL;
   }
   PyObject *list = _HDDM_ElementList_new(&_HDDM_ElementList_type, 0, 0);
   ((_HDDM_ElementList*)list)->subtype = &_TaghBeamPhoton_type;
   ((_HDDM_ElementList*)list)->list = (HDDM_ElementList<HDDM_Element>*)
    new TaghBeamPhotonList(me->elem->addTaghBeamPhotons(count, start));
   ((_HDDM_ElementList*)list)->borrowed = 0;
   ((_HDDM_ElementList*)list)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(list), ((_HDDM_ElementList*)list)->subtype, 1);
   return list;
}

static PyObject*
_ReconstructedPhysicsEvent_deleteTaghBeamPhotons(PyObject *self, PyObject *args)
{
   int count=-1;
   int start=0;
   if (! PyArg_ParseTuple(args, "|ii", &count, &start)) {
      return NULL;
   }
   _ReconstructedPhysicsEvent *me = (_ReconstructedPhysicsEvent*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "delete attempted on invalid reconstructedPhysicsEvent element");
      return NULL;
   }
   me->elem->deleteTaghBeamPhotons(count, start);
   Py_INCREF(Py_None);
   return Py_None;
}

static PyObject*
_ReconstructedPhysicsEvent_getFcalShower(PyObject *self, PyObject *args)
{
   int index=0;
   if (! PyArg_ParseTuple(args, "|i", &index)) {
      return NULL;
   }
   _ReconstructedPhysicsEvent *me = (_ReconstructedPhysicsEvent*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid reconstructedPhysicsEvent element");
      return NULL;
   }
   PyObject *obj = _FcalShower_new(&_FcalShower_type, 0, 0);
   ((_FcalShower*)obj)->elem = &me->elem->getFcalShower(index);
   ((_FcalShower*)obj)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(obj));
   return obj;
}

static PyObject*
_ReconstructedPhysicsEvent_getFcalShowers(PyObject *self, PyObject *args)
{
   _ReconstructedPhysicsEvent *me = (_ReconstructedPhysicsEvent*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid reconstructedPhysicsEvent element");
      return NULL;
   }
   PyObject *list = _HDDM_ElementList_new(&_HDDM_ElementList_type, 0, 0);
   ((_HDDM_ElementList*)list)->subtype = &_FcalShower_type;
   ((_HDDM_ElementList*)list)->list = (HDDM_ElementList<HDDM_Element>*)
    &me->elem->getFcalShowers();
   ((_HDDM_ElementList*)list)->borrowed = 1;
   ((_HDDM_ElementList*)list)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(list), ((_HDDM_ElementList*)list)->subtype, 0);
   return list;
}

static PyObject*
_ReconstructedPhysicsEvent_addFcalShowers(PyObject *self, PyObject *args)
{
   int count=1;
   int start=-1;
   if (! PyArg_ParseTuple(args, "|ii", &count, &start)) {
      return NULL;
   }
   _ReconstructedPhysicsEvent *me = (_ReconstructedPhysicsEvent*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "add attempted on invalid reconstructedPhysicsEvent element");
      return NULL;
   }
   PyObject *list = _HDDM_ElementList_new(&_HDDM_ElementList_type, 0, 0);
   ((_HDDM_ElementList*)list)->subtype = &_FcalShower_type;
   ((_HDDM_ElementList*)list)->list = (HDDM_ElementList<HDDM_Element>*)
    new FcalShowerList(me->elem->addFcalShowers(count, start));
   ((_HDDM_ElementList*)list)->borrowed = 0;
   ((_HDDM_ElementList*)list)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(list), ((_HDDM_ElementList*)list)->subtype, 1);
   return list;
}

static PyObject*
_ReconstructedPhysicsEvent_deleteFcalShowers(PyObject *self, PyObject *args)
{
   int count=-1;
   int start=0;
   if (! PyArg_ParseTuple(args, "|ii", &count, &start)) {
      return NULL;
   }
   _ReconstructedPhysicsEvent *me = (_ReconstructedPhysicsEvent*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "delete attempted on invalid reconstructedPhysicsEvent element");
      return NULL;
   }
   me->elem->deleteFcalShowers(count, start);
   Py_INCREF(Py_None);
   return Py_None;
}

static PyObject*
_ReconstructedPhysicsEvent_getFcalHit(PyObject *self, PyObject *args)
{
   int index=0;
   if (! PyArg_ParseTuple(args, "|i", &index)) {
      return NULL;
   }
   _ReconstructedPhysicsEvent *me = (_ReconstructedPhysicsEvent*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid reconstructedPhysicsEvent element");
      return NULL;
   }
   PyObject *obj = _FcalHit_new(&_FcalHit_type, 0, 0);
   ((_FcalHit*)obj)->elem = &me->elem->getFcalHit(index);
   ((_FcalHit*)obj)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(obj));
   return obj;
}

static PyObject*
_ReconstructedPhysicsEvent_getFcalHits(PyObject *self, PyObject *args)
{
   _ReconstructedPhysicsEvent *me = (_ReconstructedPhysicsEvent*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid reconstructedPhysicsEvent element");
      return NULL;
   }
   PyObject *list = _HDDM_ElementList_new(&_HDDM_ElementList_type, 0, 0);
   ((_HDDM_ElementList*)list)->subtype = &_FcalHit_type;
   ((_HDDM_ElementList*)list)->list = (HDDM_ElementList<HDDM_Element>*)
    &me->elem->getFcalHits();
   ((_HDDM_ElementList*)list)->borrowed = 1;
   ((_HDDM_ElementList*)list)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(list), ((_HDDM_ElementList*)list)->subtype, 0);
   return list;
}

static PyObject*
_ReconstructedPhysicsEvent_addFcalHits(PyObject *self, PyObject *args)
{
   int count=1;
   int start=-1;
   if (! PyArg_ParseTuple(args, "|ii", &count, &start)) {
      return NULL;
   }
   _ReconstructedPhysicsEvent *me = (_ReconstructedPhysicsEvent*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "add attempted on invalid reconstructedPhysicsEvent element");
      return NULL;
   }
   PyObject *list = _HDDM_ElementList_new(&_HDDM_ElementList_type, 0, 0);
   ((_HDDM_ElementList*)list)->subtype = &_FcalHit_type;
   ((_HDDM_ElementList*)list)->list = (HDDM_ElementList<HDDM_Element>*)
    new FcalHitList(me->elem->addFcalHits(count, start));
   ((_HDDM_ElementList*)list)->borrowed = 0;
   ((_HDDM_ElementList*)list)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(list), ((_HDDM_ElementList*)list)->subtype, 1);
   return list;
}

static PyObject*
_ReconstructedPhysicsEvent_deleteFcalHits(PyObject *self, PyObject *args)
{
   int count=-1;
   int start=0;
   if (! PyArg_ParseTuple(args, "|ii", &count, &start)) {
      return NULL;
   }
   _ReconstructedPhysicsEvent *me = (_ReconstructedPhysicsEvent*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "delete attempted on invalid reconstructedPhysicsEvent element");
      return NULL;
   }
   me->elem->deleteFcalHits(count, start);
   Py_INCREF(Py_None);
   return Py_None;
}

static PyObject*
_ReconstructedPhysicsEvent_getBcalShower(PyObject *self, PyObject *args)
{
   int index=0;
   if (! PyArg_ParseTuple(args, "|i", &index)) {
      return NULL;
   }
   _ReconstructedPhysicsEvent *me = (_ReconstructedPhysicsEvent*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid reconstructedPhysicsEvent element");
      return NULL;
   }
   PyObject *obj = _BcalShower_new(&_BcalShower_type, 0, 0);
   ((_BcalShower*)obj)->elem = &me->elem->getBcalShower(index);
   ((_BcalShower*)obj)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(obj));
   return obj;
}

static PyObject*
_ReconstructedPhysicsEvent_getBcalShowers(PyObject *self, PyObject *args)
{
   _ReconstructedPhysicsEvent *me = (_ReconstructedPhysicsEvent*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid reconstructedPhysicsEvent element");
      return NULL;
   }
   PyObject *list = _HDDM_ElementList_new(&_HDDM_ElementList_type, 0, 0);
   ((_HDDM_ElementList*)list)->subtype = &_BcalShower_type;
   ((_HDDM_ElementList*)list)->list = (HDDM_ElementList<HDDM_Element>*)
    &me->elem->getBcalShowers();
   ((_HDDM_ElementList*)list)->borrowed = 1;
   ((_HDDM_ElementList*)list)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(list), ((_HDDM_ElementList*)list)->subtype, 0);
   return list;
}

static PyObject*
_ReconstructedPhysicsEvent_addBcalShowers(PyObject *self, PyObject *args)
{
   int count=1;
   int start=-1;
   if (! PyArg_ParseTuple(args, "|ii", &count, &start)) {
      return NULL;
   }
   _ReconstructedPhysicsEvent *me = (_ReconstructedPhysicsEvent*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "add attempted on invalid reconstructedPhysicsEvent element");
      return NULL;
   }
   PyObject *list = _HDDM_ElementList_new(&_HDDM_ElementList_type, 0, 0);
   ((_HDDM_ElementList*)list)->subtype = &_BcalShower_type;
   ((_HDDM_ElementList*)list)->list = (HDDM_ElementList<HDDM_Element>*)
    new BcalShowerList(me->elem->addBcalShowers(count, start));
   ((_HDDM_ElementList*)list)->borrowed = 0;
   ((_HDDM_ElementList*)list)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(list), ((_HDDM_ElementList*)list)->subtype, 1);
   return list;
}

static PyObject*
_ReconstructedPhysicsEvent_deleteBcalShowers(PyObject *self, PyObject *args)
{
   int count=-1;
   int start=0;
   if (! PyArg_ParseTuple(args, "|ii", &count, &start)) {
      return NULL;
   }
   _ReconstructedPhysicsEvent *me = (_ReconstructedPhysicsEvent*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "delete attempted on invalid reconstructedPhysicsEvent element");
      return NULL;
   }
   me->elem->deleteBcalShowers(count, start);
   Py_INCREF(Py_None);
   return Py_None;
}

static PyObject*
_ReconstructedPhysicsEvent_getCcalShower(PyObject *self, PyObject *args)
{
   int index=0;
   if (! PyArg_ParseTuple(args, "|i", &index)) {
      return NULL;
   }
   _ReconstructedPhysicsEvent *me = (_ReconstructedPhysicsEvent*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid reconstructedPhysicsEvent element");
      return NULL;
   }
   PyObject *obj = _CcalShower_new(&_CcalShower_type, 0, 0);
   ((_CcalShower*)obj)->elem = &me->elem->getCcalShower(index);
   ((_CcalShower*)obj)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(obj));
   return obj;
}

static PyObject*
_ReconstructedPhysicsEvent_getCcalShowers(PyObject *self, PyObject *args)
{
   _ReconstructedPhysicsEvent *me = (_ReconstructedPhysicsEvent*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid reconstructedPhysicsEvent element");
      return NULL;
   }
   PyObject *list = _HDDM_ElementList_new(&_HDDM_ElementList_type, 0, 0);
   ((_HDDM_ElementList*)list)->subtype = &_CcalShower_type;
   ((_HDDM_ElementList*)list)->list = (HDDM_ElementList<HDDM_Element>*)
    &me->elem->getCcalShowers();
   ((_HDDM_ElementList*)list)->borrowed = 1;
   ((_HDDM_ElementList*)list)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(list), ((_HDDM_ElementList*)list)->subtype, 0);
   return list;
}

static PyObject*
_ReconstructedPhysicsEvent_addCcalShowers(PyObject *self, PyObject *args)
{
   int count=1;
   int start=-1;
   if (! PyArg_ParseTuple(args, "|ii", &count, &start)) {
      return NULL;
   }
   _ReconstructedPhysicsEvent *me = (_ReconstructedPhysicsEvent*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "add attempted on invalid reconstructedPhysicsEvent element");
      return NULL;
   }
   PyObject *list = _HDDM_ElementList_new(&_HDDM_ElementList_type, 0, 0);
   ((_HDDM_ElementList*)list)->subtype = &_CcalShower_type;
   ((_HDDM_ElementList*)list)->list = (HDDM_ElementList<HDDM_Element>*)
    new CcalShowerList(me->elem->addCcalShowers(count, start));
   ((_HDDM_ElementList*)list)->borrowed = 0;
   ((_HDDM_ElementList*)list)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(list), ((_HDDM_ElementList*)list)->subtype, 1);
   return list;
}

static PyObject*
_ReconstructedPhysicsEvent_deleteCcalShowers(PyObject *self, PyObject *args)
{
   int count=-1;
   int start=0;
   if (! PyArg_ParseTuple(args, "|ii", &count, &start)) {
      return NULL;
   }
   _ReconstructedPhysicsEvent *me = (_ReconstructedPhysicsEvent*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "delete attempted on invalid reconstructedPhysicsEvent element");
      return NULL;
   }
   me->elem->deleteCcalShowers(count, start);
   Py_INCREF(Py_None);
   return Py_None;
}

static PyObject*
_ReconstructedPhysicsEvent_getChargedTrack(PyObject *self, PyObject *args)
{
   int index=0;
   if (! PyArg_ParseTuple(args, "|i", &index)) {
      return NULL;
   }
   _ReconstructedPhysicsEvent *me = (_ReconstructedPhysicsEvent*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid reconstructedPhysicsEvent element");
      return NULL;
   }
   PyObject *obj = _ChargedTrack_new(&_ChargedTrack_type, 0, 0);
   ((_ChargedTrack*)obj)->elem = &me->elem->getChargedTrack(index);
   ((_ChargedTrack*)obj)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(obj));
   return obj;
}

static PyObject*
_ReconstructedPhysicsEvent_getChargedTracks(PyObject *self, PyObject *args)
{
   _ReconstructedPhysicsEvent *me = (_ReconstructedPhysicsEvent*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid reconstructedPhysicsEvent element");
      return NULL;
   }
   PyObject *list = _HDDM_ElementList_new(&_HDDM_ElementList_type, 0, 0);
   ((_HDDM_ElementList*)list)->subtype = &_ChargedTrack_type;
   ((_HDDM_ElementList*)list)->list = (HDDM_ElementList<HDDM_Element>*)
    &me->elem->getChargedTracks();
   ((_HDDM_ElementList*)list)->borrowed = 1;
   ((_HDDM_ElementList*)list)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(list), ((_HDDM_ElementList*)list)->subtype, 0);
   return list;
}

static PyObject*
_ReconstructedPhysicsEvent_addChargedTracks(PyObject *self, PyObject *args)
{
   int count=1;
   int start=-1;
   if (! PyArg_ParseTuple(args, "|ii", &count, &start)) {
      return NULL;
   }
   _ReconstructedPhysicsEvent *me = (_ReconstructedPhysicsEvent*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "add attempted on invalid reconstructedPhysicsEvent element");
      return NULL;
   }
   PyObject *list = _HDDM_ElementList_new(&_HDDM_ElementList_type, 0, 0);
   ((_HDDM_ElementList*)list)->subtype = &_ChargedTrack_type;
   ((_HDDM_ElementList*)list)->list = (HDDM_ElementList<HDDM_Element>*)
    new ChargedTrackList(me->elem->addChargedTracks(count, start));
   ((_HDDM_ElementList*)list)->borrowed = 0;
   ((_HDDM_ElementList*)list)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(list), ((_HDDM_ElementList*)list)->subtype, 1);
   return list;
}

static PyObject*
_ReconstructedPhysicsEvent_deleteChargedTracks(PyObject *self, PyObject *args)
{
   int count=-1;
   int start=0;
   if (! PyArg_ParseTuple(args, "|ii", &count, &start)) {
      return NULL;
   }
   _ReconstructedPhysicsEvent *me = (_ReconstructedPhysicsEvent*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "delete attempted on invalid reconstructedPhysicsEvent element");
      return NULL;
   }
   me->elem->deleteChargedTracks(count, start);
   Py_INCREF(Py_None);
   return Py_None;
}

static PyObject*
_ReconstructedPhysicsEvent_getStartHit(PyObject *self, PyObject *args)
{
   int index=0;
   if (! PyArg_ParseTuple(args, "|i", &index)) {
      return NULL;
   }
   _ReconstructedPhysicsEvent *me = (_ReconstructedPhysicsEvent*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid reconstructedPhysicsEvent element");
      return NULL;
   }
   PyObject *obj = _StartHit_new(&_StartHit_type, 0, 0);
   ((_StartHit*)obj)->elem = &me->elem->getStartHit(index);
   ((_StartHit*)obj)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(obj));
   return obj;
}

static PyObject*
_ReconstructedPhysicsEvent_getStartHits(PyObject *self, PyObject *args)
{
   _ReconstructedPhysicsEvent *me = (_ReconstructedPhysicsEvent*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid reconstructedPhysicsEvent element");
      return NULL;
   }
   PyObject *list = _HDDM_ElementList_new(&_HDDM_ElementList_type, 0, 0);
   ((_HDDM_ElementList*)list)->subtype = &_StartHit_type;
   ((_HDDM_ElementList*)list)->list = (HDDM_ElementList<HDDM_Element>*)
    &me->elem->getStartHits();
   ((_HDDM_ElementList*)list)->borrowed = 1;
   ((_HDDM_ElementList*)list)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(list), ((_HDDM_ElementList*)list)->subtype, 0);
   return list;
}

static PyObject*
_ReconstructedPhysicsEvent_addStartHits(PyObject *self, PyObject *args)
{
   int count=1;
   int start=-1;
   if (! PyArg_ParseTuple(args, "|ii", &count, &start)) {
      return NULL;
   }
   _ReconstructedPhysicsEvent *me = (_ReconstructedPhysicsEvent*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "add attempted on invalid reconstructedPhysicsEvent element");
      return NULL;
   }
   PyObject *list = _HDDM_ElementList_new(&_HDDM_ElementList_type, 0, 0);
   ((_HDDM_ElementList*)list)->subtype = &_StartHit_type;
   ((_HDDM_ElementList*)list)->list = (HDDM_ElementList<HDDM_Element>*)
    new StartHitList(me->elem->addStartHits(count, start));
   ((_HDDM_ElementList*)list)->borrowed = 0;
   ((_HDDM_ElementList*)list)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(list), ((_HDDM_ElementList*)list)->subtype, 1);
   return list;
}

static PyObject*
_ReconstructedPhysicsEvent_deleteStartHits(PyObject *self, PyObject *args)
{
   int count=-1;
   int start=0;
   if (! PyArg_ParseTuple(args, "|ii", &count, &start)) {
      return NULL;
   }
   _ReconstructedPhysicsEvent *me = (_ReconstructedPhysicsEvent*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "delete attempted on invalid reconstructedPhysicsEvent element");
      return NULL;
   }
   me->elem->deleteStartHits(count, start);
   Py_INCREF(Py_None);
   return Py_None;
}

static PyObject*
_ReconstructedPhysicsEvent_getCtofPoint(PyObject *self, PyObject *args)
{
   int index=0;
   if (! PyArg_ParseTuple(args, "|i", &index)) {
      return NULL;
   }
   _ReconstructedPhysicsEvent *me = (_ReconstructedPhysicsEvent*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid reconstructedPhysicsEvent element");
      return NULL;
   }
   PyObject *obj = _CtofPoint_new(&_CtofPoint_type, 0, 0);
   ((_CtofPoint*)obj)->elem = &me->elem->getCtofPoint(index);
   ((_CtofPoint*)obj)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(obj));
   return obj;
}

static PyObject*
_ReconstructedPhysicsEvent_getCtofPoints(PyObject *self, PyObject *args)
{
   _ReconstructedPhysicsEvent *me = (_ReconstructedPhysicsEvent*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid reconstructedPhysicsEvent element");
      return NULL;
   }
   PyObject *list = _HDDM_ElementList_new(&_HDDM_ElementList_type, 0, 0);
   ((_HDDM_ElementList*)list)->subtype = &_CtofPoint_type;
   ((_HDDM_ElementList*)list)->list = (HDDM_ElementList<HDDM_Element>*)
    &me->elem->getCtofPoints();
   ((_HDDM_ElementList*)list)->borrowed = 1;
   ((_HDDM_ElementList*)list)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(list), ((_HDDM_ElementList*)list)->subtype, 0);
   return list;
}

static PyObject*
_ReconstructedPhysicsEvent_addCtofPoints(PyObject *self, PyObject *args)
{
   int count=1;
   int start=-1;
   if (! PyArg_ParseTuple(args, "|ii", &count, &start)) {
      return NULL;
   }
   _ReconstructedPhysicsEvent *me = (_ReconstructedPhysicsEvent*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "add attempted on invalid reconstructedPhysicsEvent element");
      return NULL;
   }
   PyObject *list = _HDDM_ElementList_new(&_HDDM_ElementList_type, 0, 0);
   ((_HDDM_ElementList*)list)->subtype = &_CtofPoint_type;
   ((_HDDM_ElementList*)list)->list = (HDDM_ElementList<HDDM_Element>*)
    new CtofPointList(me->elem->addCtofPoints(count, start));
   ((_HDDM_ElementList*)list)->borrowed = 0;
   ((_HDDM_ElementList*)list)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(list), ((_HDDM_ElementList*)list)->subtype, 1);
   return list;
}

static PyObject*
_ReconstructedPhysicsEvent_deleteCtofPoints(PyObject *self, PyObject *args)
{
   int count=-1;
   int start=0;
   if (! PyArg_ParseTuple(args, "|ii", &count, &start)) {
      return NULL;
   }
   _ReconstructedPhysicsEvent *me = (_ReconstructedPhysicsEvent*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "delete attempted on invalid reconstructedPhysicsEvent element");
      return NULL;
   }
   me->elem->deleteCtofPoints(count, start);
   Py_INCREF(Py_None);
   return Py_None;
}

static PyObject*
_ReconstructedPhysicsEvent_getTofPoint(PyObject *self, PyObject *args)
{
   int index=0;
   if (! PyArg_ParseTuple(args, "|i", &index)) {
      return NULL;
   }
   _ReconstructedPhysicsEvent *me = (_ReconstructedPhysicsEvent*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid reconstructedPhysicsEvent element");
      return NULL;
   }
   PyObject *obj = _TofPoint_new(&_TofPoint_type, 0, 0);
   ((_TofPoint*)obj)->elem = &me->elem->getTofPoint(index);
   ((_TofPoint*)obj)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(obj));
   return obj;
}

static PyObject*
_ReconstructedPhysicsEvent_getTofPoints(PyObject *self, PyObject *args)
{
   _ReconstructedPhysicsEvent *me = (_ReconstructedPhysicsEvent*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid reconstructedPhysicsEvent element");
      return NULL;
   }
   PyObject *list = _HDDM_ElementList_new(&_HDDM_ElementList_type, 0, 0);
   ((_HDDM_ElementList*)list)->subtype = &_TofPoint_type;
   ((_HDDM_ElementList*)list)->list = (HDDM_ElementList<HDDM_Element>*)
    &me->elem->getTofPoints();
   ((_HDDM_ElementList*)list)->borrowed = 1;
   ((_HDDM_ElementList*)list)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(list), ((_HDDM_ElementList*)list)->subtype, 0);
   return list;
}

static PyObject*
_ReconstructedPhysicsEvent_addTofPoints(PyObject *self, PyObject *args)
{
   int count=1;
   int start=-1;
   if (! PyArg_ParseTuple(args, "|ii", &count, &start)) {
      return NULL;
   }
   _ReconstructedPhysicsEvent *me = (_ReconstructedPhysicsEvent*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "add attempted on invalid reconstructedPhysicsEvent element");
      return NULL;
   }
   PyObject *list = _HDDM_ElementList_new(&_HDDM_ElementList_type, 0, 0);
   ((_HDDM_ElementList*)list)->subtype = &_TofPoint_type;
   ((_HDDM_ElementList*)list)->list = (HDDM_ElementList<HDDM_Element>*)
    new TofPointList(me->elem->addTofPoints(count, start));
   ((_HDDM_ElementList*)list)->borrowed = 0;
   ((_HDDM_ElementList*)list)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(list), ((_HDDM_ElementList*)list)->subtype, 1);
   return list;
}

static PyObject*
_ReconstructedPhysicsEvent_deleteTofPoints(PyObject *self, PyObject *args)
{
   int count=-1;
   int start=0;
   if (! PyArg_ParseTuple(args, "|ii", &count, &start)) {
      return NULL;
   }
   _ReconstructedPhysicsEvent *me = (_ReconstructedPhysicsEvent*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "delete attempted on invalid reconstructedPhysicsEvent element");
      return NULL;
   }
   me->elem->deleteTofPoints(count, start);
   Py_INCREF(Py_None);
   return Py_None;
}

static PyObject*
_ReconstructedPhysicsEvent_getDircHit(PyObject *self, PyObject *args)
{
   int index=0;
   if (! PyArg_ParseTuple(args, "|i", &index)) {
      return NULL;
   }
   _ReconstructedPhysicsEvent *me = (_ReconstructedPhysicsEvent*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid reconstructedPhysicsEvent element");
      return NULL;
   }
   PyObject *obj = _DircHit_new(&_DircHit_type, 0, 0);
   ((_DircHit*)obj)->elem = &me->elem->getDircHit(index);
   ((_DircHit*)obj)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(obj));
   return obj;
}

static PyObject*
_ReconstructedPhysicsEvent_getDircHits(PyObject *self, PyObject *args)
{
   _ReconstructedPhysicsEvent *me = (_ReconstructedPhysicsEvent*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid reconstructedPhysicsEvent element");
      return NULL;
   }
   PyObject *list = _HDDM_ElementList_new(&_HDDM_ElementList_type, 0, 0);
   ((_HDDM_ElementList*)list)->subtype = &_DircHit_type;
   ((_HDDM_ElementList*)list)->list = (HDDM_ElementList<HDDM_Element>*)
    &me->elem->getDircHits();
   ((_HDDM_ElementList*)list)->borrowed = 1;
   ((_HDDM_ElementList*)list)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(list), ((_HDDM_ElementList*)list)->subtype, 0);
   return list;
}

static PyObject*
_ReconstructedPhysicsEvent_addDircHits(PyObject *self, PyObject *args)
{
   int count=1;
   int start=-1;
   if (! PyArg_ParseTuple(args, "|ii", &count, &start)) {
      return NULL;
   }
   _ReconstructedPhysicsEvent *me = (_ReconstructedPhysicsEvent*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "add attempted on invalid reconstructedPhysicsEvent element");
      return NULL;
   }
   PyObject *list = _HDDM_ElementList_new(&_HDDM_ElementList_type, 0, 0);
   ((_HDDM_ElementList*)list)->subtype = &_DircHit_type;
   ((_HDDM_ElementList*)list)->list = (HDDM_ElementList<HDDM_Element>*)
    new DircHitList(me->elem->addDircHits(count, start));
   ((_HDDM_ElementList*)list)->borrowed = 0;
   ((_HDDM_ElementList*)list)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(list), ((_HDDM_ElementList*)list)->subtype, 1);
   return list;
}

static PyObject*
_ReconstructedPhysicsEvent_deleteDircHits(PyObject *self, PyObject *args)
{
   int count=-1;
   int start=0;
   if (! PyArg_ParseTuple(args, "|ii", &count, &start)) {
      return NULL;
   }
   _ReconstructedPhysicsEvent *me = (_ReconstructedPhysicsEvent*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "delete attempted on invalid reconstructedPhysicsEvent element");
      return NULL;
   }
   me->elem->deleteDircHits(count, start);
   Py_INCREF(Py_None);
   return Py_None;
}

static PyObject*
_ReconstructedPhysicsEvent_getFmwpcHit(PyObject *self, PyObject *args)
{
   int index=0;
   if (! PyArg_ParseTuple(args, "|i", &index)) {
      return NULL;
   }
   _ReconstructedPhysicsEvent *me = (_ReconstructedPhysicsEvent*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid reconstructedPhysicsEvent element");
      return NULL;
   }
   PyObject *obj = _FmwpcHit_new(&_FmwpcHit_type, 0, 0);
   ((_FmwpcHit*)obj)->elem = &me->elem->getFmwpcHit(index);
   ((_FmwpcHit*)obj)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(obj));
   return obj;
}

static PyObject*
_ReconstructedPhysicsEvent_getFmwpcHits(PyObject *self, PyObject *args)
{
   _ReconstructedPhysicsEvent *me = (_ReconstructedPhysicsEvent*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid reconstructedPhysicsEvent element");
      return NULL;
   }
   PyObject *list = _HDDM_ElementList_new(&_HDDM_ElementList_type, 0, 0);
   ((_HDDM_ElementList*)list)->subtype = &_FmwpcHit_type;
   ((_HDDM_ElementList*)list)->list = (HDDM_ElementList<HDDM_Element>*)
    &me->elem->getFmwpcHits();
   ((_HDDM_ElementList*)list)->borrowed = 1;
   ((_HDDM_ElementList*)list)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(list), ((_HDDM_ElementList*)list)->subtype, 0);
   return list;
}

static PyObject*
_ReconstructedPhysicsEvent_addFmwpcHits(PyObject *self, PyObject *args)
{
   int count=1;
   int start=-1;
   if (! PyArg_ParseTuple(args, "|ii", &count, &start)) {
      return NULL;
   }
   _ReconstructedPhysicsEvent *me = (_ReconstructedPhysicsEvent*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "add attempted on invalid reconstructedPhysicsEvent element");
      return NULL;
   }
   PyObject *list = _HDDM_ElementList_new(&_HDDM_ElementList_type, 0, 0);
   ((_HDDM_ElementList*)list)->subtype = &_FmwpcHit_type;
   ((_HDDM_ElementList*)list)->list = (HDDM_ElementList<HDDM_Element>*)
    new FmwpcHitList(me->elem->addFmwpcHits(count, start));
   ((_HDDM_ElementList*)list)->borrowed = 0;
   ((_HDDM_ElementList*)list)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(list), ((_HDDM_ElementList*)list)->subtype, 1);
   return list;
}

static PyObject*
_ReconstructedPhysicsEvent_deleteFmwpcHits(PyObject *self, PyObject *args)
{
   int count=-1;
   int start=0;
   if (! PyArg_ParseTuple(args, "|ii", &count, &start)) {
      return NULL;
   }
   _ReconstructedPhysicsEvent *me = (_ReconstructedPhysicsEvent*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "delete attempted on invalid reconstructedPhysicsEvent element");
      return NULL;
   }
   me->elem->deleteFmwpcHits(count, start);
   Py_INCREF(Py_None);
   return Py_None;
}

static PyObject*
_ReconstructedPhysicsEvent_getRFtime(PyObject *self, PyObject *args)
{
   int index=0;
   if (! PyArg_ParseTuple(args, "|i", &index)) {
      return NULL;
   }
   _ReconstructedPhysicsEvent *me = (_ReconstructedPhysicsEvent*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid reconstructedPhysicsEvent element");
      return NULL;
   }
   PyObject *obj = _RFtime_new(&_RFtime_type, 0, 0);
   ((_RFtime*)obj)->elem = &me->elem->getRFtime();
   ((_RFtime*)obj)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(obj));
   return obj;
}

static PyObject*
_ReconstructedPhysicsEvent_getRFtimes(PyObject *self, PyObject *args)
{
   _ReconstructedPhysicsEvent *me = (_ReconstructedPhysicsEvent*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid reconstructedPhysicsEvent element");
      return NULL;
   }
   PyObject *list = _HDDM_ElementList_new(&_HDDM_ElementList_type, 0, 0);
   ((_HDDM_ElementList*)list)->subtype = &_RFtime_type;
   ((_HDDM_ElementList*)list)->list = (HDDM_ElementList<HDDM_Element>*)
    &me->elem->getRFtimes();
   ((_HDDM_ElementList*)list)->borrowed = 1;
   ((_HDDM_ElementList*)list)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(list), ((_HDDM_ElementList*)list)->subtype, 0);
   return list;
}

static PyObject*
_ReconstructedPhysicsEvent_addRFtimes(PyObject *self, PyObject *args)
{
   int count=1;
   int start=-1;
   if (! PyArg_ParseTuple(args, "|ii", &count, &start)) {
      return NULL;
   }
   _ReconstructedPhysicsEvent *me = (_ReconstructedPhysicsEvent*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "add attempted on invalid reconstructedPhysicsEvent element");
      return NULL;
   }
   PyObject *list = _HDDM_ElementList_new(&_HDDM_ElementList_type, 0, 0);
   ((_HDDM_ElementList*)list)->subtype = &_RFtime_type;
   ((_HDDM_ElementList*)list)->list = (HDDM_ElementList<HDDM_Element>*)
    new RFtimeList(me->elem->addRFtimes(count, start));
   ((_HDDM_ElementList*)list)->borrowed = 0;
   ((_HDDM_ElementList*)list)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(list), ((_HDDM_ElementList*)list)->subtype, 1);
   return list;
}

static PyObject*
_ReconstructedPhysicsEvent_deleteRFtimes(PyObject *self, PyObject *args)
{
   int count=-1;
   int start=0;
   if (! PyArg_ParseTuple(args, "|ii", &count, &start)) {
      return NULL;
   }
   _ReconstructedPhysicsEvent *me = (_ReconstructedPhysicsEvent*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "delete attempted on invalid reconstructedPhysicsEvent element");
      return NULL;
   }
   me->elem->deleteRFtimes(count, start);
   Py_INCREF(Py_None);
   return Py_None;
}

static PyObject*
_ReconstructedPhysicsEvent_getTrigger(PyObject *self, PyObject *args)
{
   int index=0;
   if (! PyArg_ParseTuple(args, "|i", &index)) {
      return NULL;
   }
   _ReconstructedPhysicsEvent *me = (_ReconstructedPhysicsEvent*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid reconstructedPhysicsEvent element");
      return NULL;
   }
   PyObject *obj = _Trigger_new(&_Trigger_type, 0, 0);
   ((_Trigger*)obj)->elem = &me->elem->getTrigger();
   ((_Trigger*)obj)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(obj));
   return obj;
}

static PyObject*
_ReconstructedPhysicsEvent_getTriggers(PyObject *self, PyObject *args)
{
   _ReconstructedPhysicsEvent *me = (_ReconstructedPhysicsEvent*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid reconstructedPhysicsEvent element");
      return NULL;
   }
   PyObject *list = _HDDM_ElementList_new(&_HDDM_ElementList_type, 0, 0);
   ((_HDDM_ElementList*)list)->subtype = &_Trigger_type;
   ((_HDDM_ElementList*)list)->list = (HDDM_ElementList<HDDM_Element>*)
    &me->elem->getTriggers();
   ((_HDDM_ElementList*)list)->borrowed = 1;
   ((_HDDM_ElementList*)list)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(list), ((_HDDM_ElementList*)list)->subtype, 0);
   return list;
}

static PyObject*
_ReconstructedPhysicsEvent_addTriggers(PyObject *self, PyObject *args)
{
   int count=1;
   int start=-1;
   if (! PyArg_ParseTuple(args, "|ii", &count, &start)) {
      return NULL;
   }
   _ReconstructedPhysicsEvent *me = (_ReconstructedPhysicsEvent*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "add attempted on invalid reconstructedPhysicsEvent element");
      return NULL;
   }
   PyObject *list = _HDDM_ElementList_new(&_HDDM_ElementList_type, 0, 0);
   ((_HDDM_ElementList*)list)->subtype = &_Trigger_type;
   ((_HDDM_ElementList*)list)->list = (HDDM_ElementList<HDDM_Element>*)
    new TriggerList(me->elem->addTriggers(count, start));
   ((_HDDM_ElementList*)list)->borrowed = 0;
   ((_HDDM_ElementList*)list)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(list), ((_HDDM_ElementList*)list)->subtype, 1);
   return list;
}

static PyObject*
_ReconstructedPhysicsEvent_deleteTriggers(PyObject *self, PyObject *args)
{
   int count=-1;
   int start=0;
   if (! PyArg_ParseTuple(args, "|ii", &count, &start)) {
      return NULL;
   }
   _ReconstructedPhysicsEvent *me = (_ReconstructedPhysicsEvent*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "delete attempted on invalid reconstructedPhysicsEvent element");
      return NULL;
   }
   me->elem->deleteTriggers(count, start);
   Py_INCREF(Py_None);
   return Py_None;
}

static PyObject*
_ReconstructedPhysicsEvent_getDetectorMatches(PyObject *self, PyObject *args)
{
   int index=0;
   if (! PyArg_ParseTuple(args, "|i", &index)) {
      return NULL;
   }
   _ReconstructedPhysicsEvent *me = (_ReconstructedPhysicsEvent*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid reconstructedPhysicsEvent element");
      return NULL;
   }
   PyObject *obj = _DetectorMatches_new(&_DetectorMatches_type, 0, 0);
   ((_DetectorMatches*)obj)->elem = &me->elem->getDetectorMatches();
   ((_DetectorMatches*)obj)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(obj));
   return obj;
}

static PyObject*
_ReconstructedPhysicsEvent_getDetectorMatcheses(PyObject *self, PyObject *args)
{
   _ReconstructedPhysicsEvent *me = (_ReconstructedPhysicsEvent*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid reconstructedPhysicsEvent element");
      return NULL;
   }
   PyObject *list = _HDDM_ElementList_new(&_HDDM_ElementList_type, 0, 0);
   ((_HDDM_ElementList*)list)->subtype = &_DetectorMatches_type;
   ((_HDDM_ElementList*)list)->list = (HDDM_ElementList<HDDM_Element>*)
    &me->elem->getDetectorMatcheses();
   ((_HDDM_ElementList*)list)->borrowed = 1;
   ((_HDDM_ElementList*)list)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(list), ((_HDDM_ElementList*)list)->subtype, 0);
   return list;
}

static PyObject*
_ReconstructedPhysicsEvent_addDetectorMatcheses(PyObject *self, PyObject *args)
{
   int count=1;
   int start=-1;
   if (! PyArg_ParseTuple(args, "|ii", &count, &start)) {
      return NULL;
   }
   _ReconstructedPhysicsEvent *me = (_ReconstructedPhysicsEvent*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "add attempted on invalid reconstructedPhysicsEvent element");
      return NULL;
   }
   PyObject *list = _HDDM_ElementList_new(&_HDDM_ElementList_type, 0, 0);
   ((_HDDM_ElementList*)list)->subtype = &_DetectorMatches_type;
   ((_HDDM_ElementList*)list)->list = (HDDM_ElementList<HDDM_Element>*)
    new DetectorMatchesList(me->elem->addDetectorMatcheses(count, start));
   ((_HDDM_ElementList*)list)->borrowed = 0;
   ((_HDDM_ElementList*)list)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(list), ((_HDDM_ElementList*)list)->subtype, 1);
   return list;
}

static PyObject*
_ReconstructedPhysicsEvent_deleteDetectorMatcheses(PyObject *self, PyObject *args)
{
   int count=-1;
   int start=0;
   if (! PyArg_ParseTuple(args, "|ii", &count, &start)) {
      return NULL;
   }
   _ReconstructedPhysicsEvent *me = (_ReconstructedPhysicsEvent*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "delete attempted on invalid reconstructedPhysicsEvent element");
      return NULL;
   }
   me->elem->deleteDetectorMatcheses(count, start);
   Py_INCREF(Py_None);
   return Py_None;
}

static PyObject*
_ReconstructedPhysicsEvent_getHitStatistics(PyObject *self, PyObject *args)
{
   int index=0;
   if (! PyArg_ParseTuple(args, "|i", &index)) {
      return NULL;
   }
   _ReconstructedPhysicsEvent *me = (_ReconstructedPhysicsEvent*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid reconstructedPhysicsEvent element");
      return NULL;
   }
   PyObject *obj = _HitStatistics_new(&_HitStatistics_type, 0, 0);
   ((_HitStatistics*)obj)->elem = &me->elem->getHitStatistics();
   ((_HitStatistics*)obj)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(obj));
   return obj;
}

static PyObject*
_ReconstructedPhysicsEvent_getHitStatisticses(PyObject *self, PyObject *args)
{
   _ReconstructedPhysicsEvent *me = (_ReconstructedPhysicsEvent*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid reconstructedPhysicsEvent element");
      return NULL;
   }
   PyObject *list = _HDDM_ElementList_new(&_HDDM_ElementList_type, 0, 0);
   ((_HDDM_ElementList*)list)->subtype = &_HitStatistics_type;
   ((_HDDM_ElementList*)list)->list = (HDDM_ElementList<HDDM_Element>*)
    &me->elem->getHitStatisticses();
   ((_HDDM_ElementList*)list)->borrowed = 1;
   ((_HDDM_ElementList*)list)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(list), ((_HDDM_ElementList*)list)->subtype, 0);
   return list;
}

static PyObject*
_ReconstructedPhysicsEvent_addHitStatisticses(PyObject *self, PyObject *args)
{
   int count=1;
   int start=-1;
   if (! PyArg_ParseTuple(args, "|ii", &count, &start)) {
      return NULL;
   }
   _ReconstructedPhysicsEvent *me = (_ReconstructedPhysicsEvent*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "add attempted on invalid reconstructedPhysicsEvent element");
      return NULL;
   }
   PyObject *list = _HDDM_ElementList_new(&_HDDM_ElementList_type, 0, 0);
   ((_HDDM_ElementList*)list)->subtype = &_HitStatistics_type;
   ((_HDDM_ElementList*)list)->list = (HDDM_ElementList<HDDM_Element>*)
    new HitStatisticsList(me->elem->addHitStatisticses(count, start));
   ((_HDDM_ElementList*)list)->borrowed = 0;
   ((_HDDM_ElementList*)list)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(list), ((_HDDM_ElementList*)list)->subtype, 1);
   return list;
}

static PyObject*
_ReconstructedPhysicsEvent_deleteHitStatisticses(PyObject *self, PyObject *args)
{
   int count=-1;
   int start=0;
   if (! PyArg_ParseTuple(args, "|ii", &count, &start)) {
      return NULL;
   }
   _ReconstructedPhysicsEvent *me = (_ReconstructedPhysicsEvent*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "delete attempted on invalid reconstructedPhysicsEvent element");
      return NULL;
   }
   me->elem->deleteHitStatisticses(count, start);
   Py_INCREF(Py_None);
   return Py_None;
}

static PyObject*
_ReconstructedPhysicsEvent_toString(PyObject *self, PyObject *args=0)
{
   _ReconstructedPhysicsEvent *me = (_ReconstructedPhysicsEvent*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid reconstructedPhysicsEvent element");
      return NULL;
   }
   std::string str(me->elem->toString());
   return PyUnicode_FromString(str.c_str());
}

static PyObject*
_ReconstructedPhysicsEvent_toXML(PyObject *self, PyObject *args=0)
{
   _ReconstructedPhysicsEvent *me = (_ReconstructedPhysicsEvent*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid reconstructedPhysicsEvent element");
      return NULL;
   }
   std::string str(me->elem->toXML());
   return PyUnicode_FromString(str.c_str());
}

static PyGetSetDef _ReconstructedPhysicsEvent_getsetters[] = {
   {(char*)"class",
    (getter)_ReconstructedPhysicsEvent_getClass, 0,
    (char*)"class string",
    NULL},
   {(char*)"eventNo",
    (getter)_ReconstructedPhysicsEvent_getEventNo, (setter)_ReconstructedPhysicsEvent_setEventNo,
    (char*)"eventNo value",
    NULL},
   {(char*)"runNo",
    (getter)_ReconstructedPhysicsEvent_getRunNo, (setter)_ReconstructedPhysicsEvent_setRunNo,
    (char*)"runNo value",
    NULL},
   {(char*)"version",
    (getter)_ReconstructedPhysicsEvent_getVersion, 0,
    (char*)"version string",
    NULL},
   {(char*)"xmlns",
    (getter)_ReconstructedPhysicsEvent_getXmlns, 0,
    (char*)"xmlns string",
    NULL},
   {NULL}  /* Sentinel */
};

static PyMemberDef _ReconstructedPhysicsEvent_members[] = {
   {NULL}  /* Sentinel */
};

static PyMethodDef _ReconstructedPhysicsEvent_methods[] = {
   {"addBcalShowers", _ReconstructedPhysicsEvent_addBcalShowers, METH_VARARGS,
    "extend (or insert into) the list of bcalShower objects for this reconstructedPhysicsEvent"},
   {"addCcalShowers", _ReconstructedPhysicsEvent_addCcalShowers, METH_VARARGS,
    "extend (or insert into) the list of ccalShower objects for this reconstructedPhysicsEvent"},
   {"addCcdbContexts", _ReconstructedPhysicsEvent_addCcdbContexts, METH_VARARGS,
    "extend (or insert into) the list of ccdbContext objects for this reconstructedPhysicsEvent"},
   {"addChargedTracks", _ReconstructedPhysicsEvent_addChargedTracks, METH_VARARGS,
    "extend (or insert into) the list of chargedTrack objects for this reconstructedPhysicsEvent"},
   {"addComments", _ReconstructedPhysicsEvent_addComments, METH_VARARGS,
    "extend (or insert into) the list of comment objects for this reconstructedPhysicsEvent"},
   {"addCtofPoints", _ReconstructedPhysicsEvent_addCtofPoints, METH_VARARGS,
    "extend (or insert into) the list of ctofPoint objects for this reconstructedPhysicsEvent"},
   {"addDataVersionStrings", _ReconstructedPhysicsEvent_addDataVersionStrings, METH_VARARGS,
    "extend (or insert into) the list of dataVersionString objects for this reconstructedPhysicsEvent"},
   {"addDetectorMatcheses", _ReconstructedPhysicsEvent_addDetectorMatcheses, METH_VARARGS,
    "extend (or insert into) the list of detectorMatches objects for this reconstructedPhysicsEvent"},
   {"addDircHits", _ReconstructedPhysicsEvent_addDircHits, METH_VARARGS,
    "extend (or insert into) the list of dircHit objects for this reconstructedPhysicsEvent"},
   {"addFcalHits", _ReconstructedPhysicsEvent_addFcalHits, METH_VARARGS,
    "extend (or insert into) the list of fcalHit objects for this reconstructedPhysicsEvent"},
   {"addFcalShowers", _ReconstructedPhysicsEvent_addFcalShowers, METH_VARARGS,
    "extend (or insert into) the list of fcalShower objects for this reconstructedPhysicsEvent"},
   {"addFmwpcHits", _ReconstructedPhysicsEvent_addFmwpcHits, METH_VARARGS,
    "extend (or insert into) the list of fmwpcHit objects for this reconstructedPhysicsEvent"},
   {"addHitStatisticses", _ReconstructedPhysicsEvent_addHitStatisticses, METH_VARARGS,
    "extend (or insert into) the list of hitStatistics objects for this reconstructedPhysicsEvent"},
   {"addRFtimes", _ReconstructedPhysicsEvent_addRFtimes, METH_VARARGS,
    "extend (or insert into) the list of RFtime objects for this reconstructedPhysicsEvent"},
   {"addReactions", _ReconstructedPhysicsEvent_addReactions, METH_VARARGS,
    "extend (or insert into) the list of reaction objects for this reconstructedPhysicsEvent"},
   {"addStartHits", _ReconstructedPhysicsEvent_addStartHits, METH_VARARGS,
    "extend (or insert into) the list of startHit objects for this reconstructedPhysicsEvent"},
   {"addTaghBeamPhotons", _ReconstructedPhysicsEvent_addTaghBeamPhotons, METH_VARARGS,
    "extend (or insert into) the list of taghBeamPhoton objects for this reconstructedPhysicsEvent"},
   {"addTagmBeamPhotons", _ReconstructedPhysicsEvent_addTagmBeamPhotons, METH_VARARGS,
    "extend (or insert into) the list of tagmBeamPhoton objects for this reconstructedPhysicsEvent"},
   {"addTofPoints", _ReconstructedPhysicsEvent_addTofPoints, METH_VARARGS,
    "extend (or insert into) the list of tofPoint objects for this reconstructedPhysicsEvent"},
   {"addTriggers", _ReconstructedPhysicsEvent_addTriggers, METH_VARARGS,
    "extend (or insert into) the list of trigger objects for this reconstructedPhysicsEvent"},
   {"deleteBcalShowers", _ReconstructedPhysicsEvent_deleteBcalShowers, METH_VARARGS,
    "delete bcalShower objects for this reconstructedPhysicsEvent"},
   {"deleteCcalShowers", _ReconstructedPhysicsEvent_deleteCcalShowers, METH_VARARGS,
    "delete ccalShower objects for this reconstructedPhysicsEvent"},
   {"deleteCcdbContexts", _ReconstructedPhysicsEvent_deleteCcdbContexts, METH_VARARGS,
    "delete ccdbContext objects for this reconstructedPhysicsEvent"},
   {"deleteChargedTracks", _ReconstructedPhysicsEvent_deleteChargedTracks, METH_VARARGS,
    "delete chargedTrack objects for this reconstructedPhysicsEvent"},
   {"deleteComments", _ReconstructedPhysicsEvent_deleteComments, METH_VARARGS,
    "delete comment objects for this reconstructedPhysicsEvent"},
   {"deleteCtofPoints", _ReconstructedPhysicsEvent_deleteCtofPoints, METH_VARARGS,
    "delete ctofPoint objects for this reconstructedPhysicsEvent"},
   {"deleteDataVersionStrings", _ReconstructedPhysicsEvent_deleteDataVersionStrings, METH_VARARGS,
    "delete dataVersionString objects for this reconstructedPhysicsEvent"},
   {"deleteDetectorMatcheses", _ReconstructedPhysicsEvent_deleteDetectorMatcheses, METH_VARARGS,
    "delete detectorMatches objects for this reconstructedPhysicsEvent"},
   {"deleteDircHits", _ReconstructedPhysicsEvent_deleteDircHits, METH_VARARGS,
    "delete dircHit objects for this reconstructedPhysicsEvent"},
   {"deleteFcalHits", _ReconstructedPhysicsEvent_deleteFcalHits, METH_VARARGS,
    "delete fcalHit objects for this reconstructedPhysicsEvent"},
   {"deleteFcalShowers", _ReconstructedPhysicsEvent_deleteFcalShowers, METH_VARARGS,
    "delete fcalShower objects for this reconstructedPhysicsEvent"},
   {"deleteFmwpcHits", _ReconstructedPhysicsEvent_deleteFmwpcHits, METH_VARARGS,
    "delete fmwpcHit objects for this reconstructedPhysicsEvent"},
   {"deleteHitStatisticses", _ReconstructedPhysicsEvent_deleteHitStatisticses, METH_VARARGS,
    "delete hitStatistics objects for this reconstructedPhysicsEvent"},
   {"deleteRFtimes", _ReconstructedPhysicsEvent_deleteRFtimes, METH_VARARGS,
    "delete RFtime objects for this reconstructedPhysicsEvent"},
   {"deleteReactions", _ReconstructedPhysicsEvent_deleteReactions, METH_VARARGS,
    "delete reaction objects for this reconstructedPhysicsEvent"},
   {"deleteStartHits", _ReconstructedPhysicsEvent_deleteStartHits, METH_VARARGS,
    "delete startHit objects for this reconstructedPhysicsEvent"},
   {"deleteTaghBeamPhotons", _ReconstructedPhysicsEvent_deleteTaghBeamPhotons, METH_VARARGS,
    "delete taghBeamPhoton objects for this reconstructedPhysicsEvent"},
   {"deleteTagmBeamPhotons", _ReconstructedPhysicsEvent_deleteTagmBeamPhotons, METH_VARARGS,
    "delete tagmBeamPhoton objects for this reconstructedPhysicsEvent"},
   {"deleteTofPoints", _ReconstructedPhysicsEvent_deleteTofPoints, METH_VARARGS,
    "delete tofPoint objects for this reconstructedPhysicsEvent"},
   {"deleteTriggers", _ReconstructedPhysicsEvent_deleteTriggers, METH_VARARGS,
    "delete trigger objects for this reconstructedPhysicsEvent"},
   {"getBcalShower", _ReconstructedPhysicsEvent_getBcalShower, METH_VARARGS,
    "get an individual bcalShower object from this reconstructedPhysicsEvent"},
   {"getBcalShowers", _ReconstructedPhysicsEvent_getBcalShowers, METH_NOARGS,
    "get list of bcalShower objects for this reconstructedPhysicsEvent"},
   {"getCcalShower", _ReconstructedPhysicsEvent_getCcalShower, METH_VARARGS,
    "get an individual ccalShower object from this reconstructedPhysicsEvent"},
   {"getCcalShowers", _ReconstructedPhysicsEvent_getCcalShowers, METH_NOARGS,
    "get list of ccalShower objects for this reconstructedPhysicsEvent"},
   {"getCcdbContext", _ReconstructedPhysicsEvent_getCcdbContext, METH_VARARGS,
    "get an individual ccdbContext object from this reconstructedPhysicsEvent"},
   {"getCcdbContexts", _ReconstructedPhysicsEvent_getCcdbContexts, METH_NOARGS,
    "get list of ccdbContext objects for this reconstructedPhysicsEvent"},
   {"getChargedTrack", _ReconstructedPhysicsEvent_getChargedTrack, METH_VARARGS,
    "get an individual chargedTrack object from this reconstructedPhysicsEvent"},
   {"getChargedTracks", _ReconstructedPhysicsEvent_getChargedTracks, METH_NOARGS,
    "get list of chargedTrack objects for this reconstructedPhysicsEvent"},
   {"getComment", _ReconstructedPhysicsEvent_getComment, METH_VARARGS,
    "get an individual comment object from this reconstructedPhysicsEvent"},
   {"getComments", _ReconstructedPhysicsEvent_getComments, METH_NOARGS,
    "get list of comment objects for this reconstructedPhysicsEvent"},
   {"getCtofPoint", _ReconstructedPhysicsEvent_getCtofPoint, METH_VARARGS,
    "get an individual ctofPoint object from this reconstructedPhysicsEvent"},
   {"getCtofPoints", _ReconstructedPhysicsEvent_getCtofPoints, METH_NOARGS,
    "get list of ctofPoint objects for this reconstructedPhysicsEvent"},
   {"getDataVersionString", _ReconstructedPhysicsEvent_getDataVersionString, METH_VARARGS,
    "get an individual dataVersionString object from this reconstructedPhysicsEvent"},
   {"getDataVersionStrings", _ReconstructedPhysicsEvent_getDataVersionStrings, METH_NOARGS,
    "get list of dataVersionString objects for this reconstructedPhysicsEvent"},
   {"getDetectorMatches", _ReconstructedPhysicsEvent_getDetectorMatches, METH_VARARGS,
    "get an individual detectorMatches object from this reconstructedPhysicsEvent"},
   {"getDetectorMatcheses", _ReconstructedPhysicsEvent_getDetectorMatcheses, METH_NOARGS,
    "get list of detectorMatches objects for this reconstructedPhysicsEvent"},
   {"getDircHit", _ReconstructedPhysicsEvent_getDircHit, METH_VARARGS,
    "get an individual dircHit object from this reconstructedPhysicsEvent"},
   {"getDircHits", _ReconstructedPhysicsEvent_getDircHits, METH_NOARGS,
    "get list of dircHit objects for this reconstructedPhysicsEvent"},
   {"getFcalHit", _ReconstructedPhysicsEvent_getFcalHit, METH_VARARGS,
    "get an individual fcalHit object from this reconstructedPhysicsEvent"},
   {"getFcalHits", _ReconstructedPhysicsEvent_getFcalHits, METH_NOARGS,
    "get list of fcalHit objects for this reconstructedPhysicsEvent"},
   {"getFcalShower", _ReconstructedPhysicsEvent_getFcalShower, METH_VARARGS,
    "get an individual fcalShower object from this reconstructedPhysicsEvent"},
   {"getFcalShowers", _ReconstructedPhysicsEvent_getFcalShowers, METH_NOARGS,
    "get list of fcalShower objects for this reconstructedPhysicsEvent"},
   {"getFmwpcHit", _ReconstructedPhysicsEvent_getFmwpcHit, METH_VARARGS,
    "get an individual fmwpcHit object from this reconstructedPhysicsEvent"},
   {"getFmwpcHits", _ReconstructedPhysicsEvent_getFmwpcHits, METH_NOARGS,
    "get list of fmwpcHit objects for this reconstructedPhysicsEvent"},
   {"getHitStatistics", _ReconstructedPhysicsEvent_getHitStatistics, METH_VARARGS,
    "get an individual hitStatistics object from this reconstructedPhysicsEvent"},
   {"getHitStatisticses", _ReconstructedPhysicsEvent_getHitStatisticses, METH_NOARGS,
    "get list of hitStatistics objects for this reconstructedPhysicsEvent"},
   {"getRFtime", _ReconstructedPhysicsEvent_getRFtime, METH_VARARGS,
    "get an individual RFtime object from this reconstructedPhysicsEvent"},
   {"getRFtimes", _ReconstructedPhysicsEvent_getRFtimes, METH_NOARGS,
    "get list of RFtime objects for this reconstructedPhysicsEvent"},
   {"getReaction", _ReconstructedPhysicsEvent_getReaction, METH_VARARGS,
    "get an individual reaction object from this reconstructedPhysicsEvent"},
   {"getReactions", _ReconstructedPhysicsEvent_getReactions, METH_NOARGS,
    "get list of reaction objects for this reconstructedPhysicsEvent"},
   {"getStartHit", _ReconstructedPhysicsEvent_getStartHit, METH_VARARGS,
    "get an individual startHit object from this reconstructedPhysicsEvent"},
   {"getStartHits", _ReconstructedPhysicsEvent_getStartHits, METH_NOARGS,
    "get list of startHit objects for this reconstructedPhysicsEvent"},
   {"getTaghBeamPhoton", _ReconstructedPhysicsEvent_getTaghBeamPhoton, METH_VARARGS,
    "get an individual taghBeamPhoton object from this reconstructedPhysicsEvent"},
   {"getTaghBeamPhotons", _ReconstructedPhysicsEvent_getTaghBeamPhotons, METH_NOARGS,
    "get list of taghBeamPhoton objects for this reconstructedPhysicsEvent"},
   {"getTagmBeamPhoton", _ReconstructedPhysicsEvent_getTagmBeamPhoton, METH_VARARGS,
    "get an individual tagmBeamPhoton object from this reconstructedPhysicsEvent"},
   {"getTagmBeamPhotons", _ReconstructedPhysicsEvent_getTagmBeamPhotons, METH_NOARGS,
    "get list of tagmBeamPhoton objects for this reconstructedPhysicsEvent"},
   {"getTofPoint", _ReconstructedPhysicsEvent_getTofPoint, METH_VARARGS,
    "get an individual tofPoint object from this reconstructedPhysicsEvent"},
   {"getTofPoints", _ReconstructedPhysicsEvent_getTofPoints, METH_NOARGS,
    "get list of tofPoint objects for this reconstructedPhysicsEvent"},
   {"getTrigger", _ReconstructedPhysicsEvent_getTrigger, METH_VARARGS,
    "get an individual trigger object from this reconstructedPhysicsEvent"},
   {"getTriggers", _ReconstructedPhysicsEvent_getTriggers, METH_NOARGS,
    "get list of trigger objects for this reconstructedPhysicsEvent"},
   {"toString", _ReconstructedPhysicsEvent_toString, METH_NOARGS,
    "show element as a human-readable string"},
   {"toXML", _ReconstructedPhysicsEvent_toXML, METH_NOARGS,
    "show element as a XML fragment"},
   {NULL}  /* Sentinel */
};

static PyTypeObject _ReconstructedPhysicsEvent_type = {
    PyVarObject_HEAD_INIT(NULL,0)
    "hddm_r.ReconstructedPhysicsEvent",         /*tp_name*/
    sizeof(_ReconstructedPhysicsEvent),          /*tp_basicsize*/
    0,                         /*tp_itemsize*/
    (destructor)_ReconstructedPhysicsEvent_dealloc, /*tp_dealloc*/
    0,                         /*tp_print*/
    0,                         /*tp_getattr*/
    0,                         /*tp_setattr*/
    0,                         /*tp_compare*/
    0,                         /*tp_repr*/
    0,                         /*tp_as_number*/
    0,                         /*tp_as_sequence*/
    0,                         /*tp_as_mapping*/
    0,                         /*tp_hash */
    0,                         /*tp_call*/
    (reprfunc)_ReconstructedPhysicsEvent_toString,         /*tp_str*/
    0,                         /*tp_getattro*/
    0,                         /*tp_setattro*/
    0,                         /*tp_as_buffer*/
    Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE, /*tp_flags*/
    "hddm_r reconstructedPhysicsEvent element",  /* tp_doc */
    0,                         /* tp_traverse */
    0,                         /* tp_clear */
    0,                         /* tp_richcompare */
    0,                         /* tp_weaklistoffset */
    0,                         /* tp_iter */
    0,                         /* tp_iternext */
    _ReconstructedPhysicsEvent_methods,          /* tp_methods */
    _ReconstructedPhysicsEvent_members,          /* tp_members */
    _ReconstructedPhysicsEvent_getsetters,       /* tp_getset */
    &_HDDM_Element_type,       /* tp_base */
    0,                         /* tp_dict */
    0,                         /* tp_descr_get */
    0,                         /* tp_descr_set */
    0,                         /* tp_dictoffset */
    (initproc)_ReconstructedPhysicsEvent_init,   /* tp_init */
    0,                         /* tp_alloc */
    _ReconstructedPhysicsEvent_new,              /* tp_new */
};



// wrap element class hddm_r::HDDM as hddm_r.HDDM

typedef struct {
   PyObject_HEAD
   HDDM *elem;
   PyObject *host;
} _HDDM;

static void
_HDDM_dealloc(_HDDM* self)
{
   if (self->elem != 0) {
      LOG_DEALLOC(Py_TYPE(self), 0, self->host == (PyObject*)self);
      if (self->host == (PyObject*)self)
         delete self->elem;
      else
         My_DECREF(self->host);
   }
   Py_TYPE(self)->tp_free((PyObject*)self);
}

static PyObject*
_HDDM_new(PyTypeObject *type, PyObject *args, PyObject *kwds)
{
   _HDDM *self;
   self = (_HDDM*)type->tp_alloc(type, 0);
   if (self != NULL) {
      self->elem = 0;
      self->host = 0;
   }
   return (PyObject*)self;
}

static int
_HDDM_init(_HDDM *self, PyObject *args, PyObject *kwds)
{
   LOG_NEW(Py_TYPE(self), 0, 1);
   self->elem = new HDDM();
   if (self->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "HDDM new constructor failed");
      return -1;
   }
   self->host = (PyObject*)self;
   return 0;
}

#ifdef HDF5_SUPPORT
static PyObject*
_HDDM_hdf5FileRead(PyObject *self, PyObject *args)
{
   hid_t file_id;
   long int entry = -1;
   if (! PyArg_ParseTuple(args, "k|l", &file_id, &entry)) {
      return NULL;
   }
   _HDDM *me = (_HDDM*)self;
   herr_t result = me->elem->hdf5FileRead(file_id, entry);
   return PyLong_FromLong(result);
}
static PyObject*
_HDDM_hdf5FileWrite(PyObject *self, PyObject *args)
{
   hid_t file_id;
   long int entry = -1;
   if (! PyArg_ParseTuple(args, "k|l", &file_id, &entry)) {
      return NULL;
   }
   _HDDM *me = (_HDDM*)self;
   herr_t result = me->elem->hdf5FileWrite(file_id, entry);
   return PyLong_FromLong(result);
}
#endif
static PyObject*
_HDDM_getClass(_HDDM *self, void *closure)
{
   std::string val(self->elem->getClass());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_HDDM_getVersion(_HDDM *self, void *closure)
{
   std::string val(self->elem->getVersion());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_HDDM_getXmlns(_HDDM *self, void *closure)
{
   std::string val(self->elem->getXmlns());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_HDDM_getCDCAmpdEdxs(PyObject *self, PyObject *args)
{
   _HDDM *me = (_HDDM*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid HDDM element");
      return NULL;
   }
   PyObject *list = _HDDM_ElementList_new(&_HDDM_ElementList_type, 0, 0);
   ((_HDDM_ElementList*)list)->subtype = &_CDCAmpdEdx_type;
   ((_HDDM_ElementList*)list)->list = (HDDM_ElementList<HDDM_Element>*)
    new CDCAmpdEdxList(me->elem->getCDCAmpdEdxs());
   ((_HDDM_ElementList*)list)->borrowed = 0;
   ((_HDDM_ElementList*)list)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(list), ((_HDDM_ElementList*)list)->subtype, 1);
   return list;
}

static PyObject*
_HDDM_getCDCdEdxTruncs(PyObject *self, PyObject *args)
{
   _HDDM *me = (_HDDM*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid HDDM element");
      return NULL;
   }
   PyObject *list = _HDDM_ElementList_new(&_HDDM_ElementList_type, 0, 0);
   ((_HDDM_ElementList*)list)->subtype = &_CDCdEdxTrunc_type;
   ((_HDDM_ElementList*)list)->list = (HDDM_ElementList<HDDM_Element>*)
    new CDCdEdxTruncList(me->elem->getCDCdEdxTruncs());
   ((_HDDM_ElementList*)list)->borrowed = 0;
   ((_HDDM_ElementList*)list)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(list), ((_HDDM_ElementList*)list)->subtype, 1);
   return list;
}

static PyObject*
_HDDM_getFDCdEdxTruncs(PyObject *self, PyObject *args)
{
   _HDDM *me = (_HDDM*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid HDDM element");
      return NULL;
   }
   PyObject *list = _HDDM_ElementList_new(&_HDDM_ElementList_type, 0, 0);
   ((_HDDM_ElementList*)list)->subtype = &_FDCdEdxTrunc_type;
   ((_HDDM_ElementList*)list)->list = (HDDM_ElementList<HDDM_Element>*)
    new FDCdEdxTruncList(me->elem->getFDCdEdxTruncs());
   ((_HDDM_ElementList*)list)->borrowed = 0;
   ((_HDDM_ElementList*)list)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(list), ((_HDDM_ElementList*)list)->subtype, 1);
   return list;
}

static PyObject*
_HDDM_getRFtimes(PyObject *self, PyObject *args)
{
   _HDDM *me = (_HDDM*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid HDDM element");
      return NULL;
   }
   PyObject *list = _HDDM_ElementList_new(&_HDDM_ElementList_type, 0, 0);
   ((_HDDM_ElementList*)list)->subtype = &_RFtime_type;
   ((_HDDM_ElementList*)list)->list = (HDDM_ElementList<HDDM_Element>*)
    new RFtimeList(me->elem->getRFtimes());
   ((_HDDM_ElementList*)list)->borrowed = 0;
   ((_HDDM_ElementList*)list)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(list), ((_HDDM_ElementList*)list)->subtype, 1);
   return list;
}

static PyObject*
_HDDM_getBcalCellses(PyObject *self, PyObject *args)
{
   _HDDM *me = (_HDDM*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid HDDM element");
      return NULL;
   }
   PyObject *list = _HDDM_ElementList_new(&_HDDM_ElementList_type, 0, 0);
   ((_HDDM_ElementList*)list)->subtype = &_BcalCells_type;
   ((_HDDM_ElementList*)list)->list = (HDDM_ElementList<HDDM_Element>*)
    new BcalCellsList(me->elem->getBcalCellses());
   ((_HDDM_ElementList*)list)->borrowed = 0;
   ((_HDDM_ElementList*)list)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(list), ((_HDDM_ElementList*)list)->subtype, 1);
   return list;
}

static PyObject*
_HDDM_getBcalClusters(PyObject *self, PyObject *args)
{
   _HDDM *me = (_HDDM*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid HDDM element");
      return NULL;
   }
   PyObject *list = _HDDM_ElementList_new(&_HDDM_ElementList_type, 0, 0);
   ((_HDDM_ElementList*)list)->subtype = &_BcalCluster_type;
   ((_HDDM_ElementList*)list)->list = (HDDM_ElementList<HDDM_Element>*)
    new BcalClusterList(me->elem->getBcalClusters());
   ((_HDDM_ElementList*)list)->borrowed = 0;
   ((_HDDM_ElementList*)list)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(list), ((_HDDM_ElementList*)list)->subtype, 1);
   return list;
}

static PyObject*
_HDDM_getBcalCorrelationses(PyObject *self, PyObject *args)
{
   _HDDM *me = (_HDDM*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid HDDM element");
      return NULL;
   }
   PyObject *list = _HDDM_ElementList_new(&_HDDM_ElementList_type, 0, 0);
   ((_HDDM_ElementList*)list)->subtype = &_BcalCorrelations_type;
   ((_HDDM_ElementList*)list)->list = (HDDM_ElementList<HDDM_Element>*)
    new BcalCorrelationsList(me->elem->getBcalCorrelationses());
   ((_HDDM_ElementList*)list)->borrowed = 0;
   ((_HDDM_ElementList*)list)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(list), ((_HDDM_ElementList*)list)->subtype, 1);
   return list;
}

static PyObject*
_HDDM_getBcalDOCAtoTracks(PyObject *self, PyObject *args)
{
   _HDDM *me = (_HDDM*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid HDDM element");
      return NULL;
   }
   PyObject *list = _HDDM_ElementList_new(&_HDDM_ElementList_type, 0, 0);
   ((_HDDM_ElementList*)list)->subtype = &_BcalDOCAtoTrack_type;
   ((_HDDM_ElementList*)list)->list = (HDDM_ElementList<HDDM_Element>*)
    new BcalDOCAtoTrackList(me->elem->getBcalDOCAtoTracks());
   ((_HDDM_ElementList*)list)->borrowed = 0;
   ((_HDDM_ElementList*)list)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(list), ((_HDDM_ElementList*)list)->subtype, 1);
   return list;
}

static PyObject*
_HDDM_getBcalLayerses(PyObject *self, PyObject *args)
{
   _HDDM *me = (_HDDM*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid HDDM element");
      return NULL;
   }
   PyObject *list = _HDDM_ElementList_new(&_HDDM_ElementList_type, 0, 0);
   ((_HDDM_ElementList*)list)->subtype = &_BcalLayers_type;
   ((_HDDM_ElementList*)list)->list = (HDDM_ElementList<HDDM_Element>*)
    new BcalLayersList(me->elem->getBcalLayerses());
   ((_HDDM_ElementList*)list)->borrowed = 0;
   ((_HDDM_ElementList*)list)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(list), ((_HDDM_ElementList*)list)->subtype, 1);
   return list;
}

static PyObject*
_HDDM_getBcalMatchParamses(PyObject *self, PyObject *args)
{
   _HDDM *me = (_HDDM*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid HDDM element");
      return NULL;
   }
   PyObject *list = _HDDM_ElementList_new(&_HDDM_ElementList_type, 0, 0);
   ((_HDDM_ElementList*)list)->subtype = &_BcalMatchParams_type;
   ((_HDDM_ElementList*)list)->list = (HDDM_ElementList<HDDM_Element>*)
    new BcalMatchParamsList(me->elem->getBcalMatchParamses());
   ((_HDDM_ElementList*)list)->borrowed = 0;
   ((_HDDM_ElementList*)list)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(list), ((_HDDM_ElementList*)list)->subtype, 1);
   return list;
}

static PyObject*
_HDDM_getBcalShowers(PyObject *self, PyObject *args)
{
   _HDDM *me = (_HDDM*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid HDDM element");
      return NULL;
   }
   PyObject *list = _HDDM_ElementList_new(&_HDDM_ElementList_type, 0, 0);
   ((_HDDM_ElementList*)list)->subtype = &_BcalShower_type;
   ((_HDDM_ElementList*)list)->list = (HDDM_ElementList<HDDM_Element>*)
    new BcalShowerList(me->elem->getBcalShowers());
   ((_HDDM_ElementList*)list)->borrowed = 0;
   ((_HDDM_ElementList*)list)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(list), ((_HDDM_ElementList*)list)->subtype, 1);
   return list;
}

static PyObject*
_HDDM_getCcalBlockses(PyObject *self, PyObject *args)
{
   _HDDM *me = (_HDDM*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid HDDM element");
      return NULL;
   }
   PyObject *list = _HDDM_ElementList_new(&_HDDM_ElementList_type, 0, 0);
   ((_HDDM_ElementList*)list)->subtype = &_CcalBlocks_type;
   ((_HDDM_ElementList*)list)->list = (HDDM_ElementList<HDDM_Element>*)
    new CcalBlocksList(me->elem->getCcalBlockses());
   ((_HDDM_ElementList*)list)->borrowed = 0;
   ((_HDDM_ElementList*)list)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(list), ((_HDDM_ElementList*)list)->subtype, 1);
   return list;
}

static PyObject*
_HDDM_getCcalShowers(PyObject *self, PyObject *args)
{
   _HDDM *me = (_HDDM*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid HDDM element");
      return NULL;
   }
   PyObject *list = _HDDM_ElementList_new(&_HDDM_ElementList_type, 0, 0);
   ((_HDDM_ElementList*)list)->subtype = &_CcalShower_type;
   ((_HDDM_ElementList*)list)->list = (HDDM_ElementList<HDDM_Element>*)
    new CcalShowerList(me->elem->getCcalShowers());
   ((_HDDM_ElementList*)list)->borrowed = 0;
   ((_HDDM_ElementList*)list)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(list), ((_HDDM_ElementList*)list)->subtype, 1);
   return list;
}

static PyObject*
_HDDM_getCcdbContexts(PyObject *self, PyObject *args)
{
   _HDDM *me = (_HDDM*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid HDDM element");
      return NULL;
   }
   PyObject *list = _HDDM_ElementList_new(&_HDDM_ElementList_type, 0, 0);
   ((_HDDM_ElementList*)list)->subtype = &_CcdbContext_type;
   ((_HDDM_ElementList*)list)->list = (HDDM_ElementList<HDDM_Element>*)
    new CcdbContextList(me->elem->getCcdbContexts());
   ((_HDDM_ElementList*)list)->borrowed = 0;
   ((_HDDM_ElementList*)list)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(list), ((_HDDM_ElementList*)list)->subtype, 1);
   return list;
}

static PyObject*
_HDDM_getCdcStrawses(PyObject *self, PyObject *args)
{
   _HDDM *me = (_HDDM*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid HDDM element");
      return NULL;
   }
   PyObject *list = _HDDM_ElementList_new(&_HDDM_ElementList_type, 0, 0);
   ((_HDDM_ElementList*)list)->subtype = &_CdcStraws_type;
   ((_HDDM_ElementList*)list)->list = (HDDM_ElementList<HDDM_Element>*)
    new CdcStrawsList(me->elem->getCdcStrawses());
   ((_HDDM_ElementList*)list)->borrowed = 0;
   ((_HDDM_ElementList*)list)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(list), ((_HDDM_ElementList*)list)->subtype, 1);
   return list;
}

static PyObject*
_HDDM_getChargedTracks(PyObject *self, PyObject *args)
{
   _HDDM *me = (_HDDM*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid HDDM element");
      return NULL;
   }
   PyObject *list = _HDDM_ElementList_new(&_HDDM_ElementList_type, 0, 0);
   ((_HDDM_ElementList*)list)->subtype = &_ChargedTrack_type;
   ((_HDDM_ElementList*)list)->list = (HDDM_ElementList<HDDM_Element>*)
    new ChargedTrackList(me->elem->getChargedTracks());
   ((_HDDM_ElementList*)list)->borrowed = 0;
   ((_HDDM_ElementList*)list)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(list), ((_HDDM_ElementList*)list)->subtype, 1);
   return list;
}

static PyObject*
_HDDM_getComments(PyObject *self, PyObject *args)
{
   _HDDM *me = (_HDDM*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid HDDM element");
      return NULL;
   }
   PyObject *list = _HDDM_ElementList_new(&_HDDM_ElementList_type, 0, 0);
   ((_HDDM_ElementList*)list)->subtype = &_Comment_type;
   ((_HDDM_ElementList*)list)->list = (HDDM_ElementList<HDDM_Element>*)
    new CommentList(me->elem->getComments());
   ((_HDDM_ElementList*)list)->borrowed = 0;
   ((_HDDM_ElementList*)list)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(list), ((_HDDM_ElementList*)list)->subtype, 1);
   return list;
}

static PyObject*
_HDDM_getCtofMatchParamses(PyObject *self, PyObject *args)
{
   _HDDM *me = (_HDDM*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid HDDM element");
      return NULL;
   }
   PyObject *list = _HDDM_ElementList_new(&_HDDM_ElementList_type, 0, 0);
   ((_HDDM_ElementList*)list)->subtype = &_CtofMatchParams_type;
   ((_HDDM_ElementList*)list)->list = (HDDM_ElementList<HDDM_Element>*)
    new CtofMatchParamsList(me->elem->getCtofMatchParamses());
   ((_HDDM_ElementList*)list)->borrowed = 0;
   ((_HDDM_ElementList*)list)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(list), ((_HDDM_ElementList*)list)->subtype, 1);
   return list;
}

static PyObject*
_HDDM_getCtofPoints(PyObject *self, PyObject *args)
{
   _HDDM *me = (_HDDM*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid HDDM element");
      return NULL;
   }
   PyObject *list = _HDDM_ElementList_new(&_HDDM_ElementList_type, 0, 0);
   ((_HDDM_ElementList*)list)->subtype = &_CtofPoint_type;
   ((_HDDM_ElementList*)list)->list = (HDDM_ElementList<HDDM_Element>*)
    new CtofPointList(me->elem->getCtofPoints());
   ((_HDDM_ElementList*)list)->borrowed = 0;
   ((_HDDM_ElementList*)list)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(list), ((_HDDM_ElementList*)list)->subtype, 1);
   return list;
}

static PyObject*
_HDDM_getDEdxDCs(PyObject *self, PyObject *args)
{
   _HDDM *me = (_HDDM*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid HDDM element");
      return NULL;
   }
   PyObject *list = _HDDM_ElementList_new(&_HDDM_ElementList_type, 0, 0);
   ((_HDDM_ElementList*)list)->subtype = &_DEdxDC_type;
   ((_HDDM_ElementList*)list)->list = (HDDM_ElementList<HDDM_Element>*)
    new DEdxDCList(me->elem->getDEdxDCs());
   ((_HDDM_ElementList*)list)->borrowed = 0;
   ((_HDDM_ElementList*)list)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(list), ((_HDDM_ElementList*)list)->subtype, 1);
   return list;
}

static PyObject*
_HDDM_getDataVersionStrings(PyObject *self, PyObject *args)
{
   _HDDM *me = (_HDDM*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid HDDM element");
      return NULL;
   }
   PyObject *list = _HDDM_ElementList_new(&_HDDM_ElementList_type, 0, 0);
   ((_HDDM_ElementList*)list)->subtype = &_DataVersionString_type;
   ((_HDDM_ElementList*)list)->list = (HDDM_ElementList<HDDM_Element>*)
    new DataVersionStringList(me->elem->getDataVersionStrings());
   ((_HDDM_ElementList*)list)->borrowed = 0;
   ((_HDDM_ElementList*)list)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(list), ((_HDDM_ElementList*)list)->subtype, 1);
   return list;
}

static PyObject*
_HDDM_getDetectorMatcheses(PyObject *self, PyObject *args)
{
   _HDDM *me = (_HDDM*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid HDDM element");
      return NULL;
   }
   PyObject *list = _HDDM_ElementList_new(&_HDDM_ElementList_type, 0, 0);
   ((_HDDM_ElementList*)list)->subtype = &_DetectorMatches_type;
   ((_HDDM_ElementList*)list)->list = (HDDM_ElementList<HDDM_Element>*)
    new DetectorMatchesList(me->elem->getDetectorMatcheses());
   ((_HDDM_ElementList*)list)->borrowed = 0;
   ((_HDDM_ElementList*)list)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(list), ((_HDDM_ElementList*)list)->subtype, 1);
   return list;
}

static PyObject*
_HDDM_getDircHits(PyObject *self, PyObject *args)
{
   _HDDM *me = (_HDDM*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid HDDM element");
      return NULL;
   }
   PyObject *list = _HDDM_ElementList_new(&_HDDM_ElementList_type, 0, 0);
   ((_HDDM_ElementList*)list)->subtype = &_DircHit_type;
   ((_HDDM_ElementList*)list)->list = (HDDM_ElementList<HDDM_Element>*)
    new DircHitList(me->elem->getDircHits());
   ((_HDDM_ElementList*)list)->borrowed = 0;
   ((_HDDM_ElementList*)list)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(list), ((_HDDM_ElementList*)list)->subtype, 1);
   return list;
}

static PyObject*
_HDDM_getDircMatchHits(PyObject *self, PyObject *args)
{
   _HDDM *me = (_HDDM*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid HDDM element");
      return NULL;
   }
   PyObject *list = _HDDM_ElementList_new(&_HDDM_ElementList_type, 0, 0);
   ((_HDDM_ElementList*)list)->subtype = &_DircMatchHit_type;
   ((_HDDM_ElementList*)list)->list = (HDDM_ElementList<HDDM_Element>*)
    new DircMatchHitList(me->elem->getDircMatchHits());
   ((_HDDM_ElementList*)list)->borrowed = 0;
   ((_HDDM_ElementList*)list)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(list), ((_HDDM_ElementList*)list)->subtype, 1);
   return list;
}

static PyObject*
_HDDM_getDircMatchParamses(PyObject *self, PyObject *args)
{
   _HDDM *me = (_HDDM*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid HDDM element");
      return NULL;
   }
   PyObject *list = _HDDM_ElementList_new(&_HDDM_ElementList_type, 0, 0);
   ((_HDDM_ElementList*)list)->subtype = &_DircMatchParams_type;
   ((_HDDM_ElementList*)list)->list = (HDDM_ElementList<HDDM_Element>*)
    new DircMatchParamsList(me->elem->getDircMatchParamses());
   ((_HDDM_ElementList*)list)->borrowed = 0;
   ((_HDDM_ElementList*)list)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(list), ((_HDDM_ElementList*)list)->subtype, 1);
   return list;
}

static PyObject*
_HDDM_getDircPMTses(PyObject *self, PyObject *args)
{
   _HDDM *me = (_HDDM*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid HDDM element");
      return NULL;
   }
   PyObject *list = _HDDM_ElementList_new(&_HDDM_ElementList_type, 0, 0);
   ((_HDDM_ElementList*)list)->subtype = &_DircPMTs_type;
   ((_HDDM_ElementList*)list)->list = (HDDM_ElementList<HDDM_Element>*)
    new DircPMTsList(me->elem->getDircPMTses());
   ((_HDDM_ElementList*)list)->borrowed = 0;
   ((_HDDM_ElementList*)list)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(list), ((_HDDM_ElementList*)list)->subtype, 1);
   return list;
}

static PyObject*
_HDDM_getExitParamses(PyObject *self, PyObject *args)
{
   _HDDM *me = (_HDDM*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid HDDM element");
      return NULL;
   }
   PyObject *list = _HDDM_ElementList_new(&_HDDM_ElementList_type, 0, 0);
   ((_HDDM_ElementList*)list)->subtype = &_ExitParams_type;
   ((_HDDM_ElementList*)list)->list = (HDDM_ElementList<HDDM_Element>*)
    new ExitParamsList(me->elem->getExitParamses());
   ((_HDDM_ElementList*)list)->borrowed = 0;
   ((_HDDM_ElementList*)list)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(list), ((_HDDM_ElementList*)list)->subtype, 1);
   return list;
}

static PyObject*
_HDDM_getExpectedhitses(PyObject *self, PyObject *args)
{
   _HDDM *me = (_HDDM*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid HDDM element");
      return NULL;
   }
   PyObject *list = _HDDM_ElementList_new(&_HDDM_ElementList_type, 0, 0);
   ((_HDDM_ElementList*)list)->subtype = &_Expectedhits_type;
   ((_HDDM_ElementList*)list)->list = (HDDM_ElementList<HDDM_Element>*)
    new ExpectedhitsList(me->elem->getExpectedhitses());
   ((_HDDM_ElementList*)list)->borrowed = 0;
   ((_HDDM_ElementList*)list)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(list), ((_HDDM_ElementList*)list)->subtype, 1);
   return list;
}

static PyObject*
_HDDM_getFcalBlockses(PyObject *self, PyObject *args)
{
   _HDDM *me = (_HDDM*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid HDDM element");
      return NULL;
   }
   PyObject *list = _HDDM_ElementList_new(&_HDDM_ElementList_type, 0, 0);
   ((_HDDM_ElementList*)list)->subtype = &_FcalBlocks_type;
   ((_HDDM_ElementList*)list)->list = (HDDM_ElementList<HDDM_Element>*)
    new FcalBlocksList(me->elem->getFcalBlockses());
   ((_HDDM_ElementList*)list)->borrowed = 0;
   ((_HDDM_ElementList*)list)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(list), ((_HDDM_ElementList*)list)->subtype, 1);
   return list;
}

static PyObject*
_HDDM_getFcalCorrelationses(PyObject *self, PyObject *args)
{
   _HDDM *me = (_HDDM*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid HDDM element");
      return NULL;
   }
   PyObject *list = _HDDM_ElementList_new(&_HDDM_ElementList_type, 0, 0);
   ((_HDDM_ElementList*)list)->subtype = &_FcalCorrelations_type;
   ((_HDDM_ElementList*)list)->list = (HDDM_ElementList<HDDM_Element>*)
    new FcalCorrelationsList(me->elem->getFcalCorrelationses());
   ((_HDDM_ElementList*)list)->borrowed = 0;
   ((_HDDM_ElementList*)list)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(list), ((_HDDM_ElementList*)list)->subtype, 1);
   return list;
}

static PyObject*
_HDDM_getFcalDOCAtoTracks(PyObject *self, PyObject *args)
{
   _HDDM *me = (_HDDM*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid HDDM element");
      return NULL;
   }
   PyObject *list = _HDDM_ElementList_new(&_HDDM_ElementList_type, 0, 0);
   ((_HDDM_ElementList*)list)->subtype = &_FcalDOCAtoTrack_type;
   ((_HDDM_ElementList*)list)->list = (HDDM_ElementList<HDDM_Element>*)
    new FcalDOCAtoTrackList(me->elem->getFcalDOCAtoTracks());
   ((_HDDM_ElementList*)list)->borrowed = 0;
   ((_HDDM_ElementList*)list)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(list), ((_HDDM_ElementList*)list)->subtype, 1);
   return list;
}

static PyObject*
_HDDM_getFcalEnergyParamses(PyObject *self, PyObject *args)
{
   _HDDM *me = (_HDDM*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid HDDM element");
      return NULL;
   }
   PyObject *list = _HDDM_ElementList_new(&_HDDM_ElementList_type, 0, 0);
   ((_HDDM_ElementList*)list)->subtype = &_FcalEnergyParams_type;
   ((_HDDM_ElementList*)list)->list = (HDDM_ElementList<HDDM_Element>*)
    new FcalEnergyParamsList(me->elem->getFcalEnergyParamses());
   ((_HDDM_ElementList*)list)->borrowed = 0;
   ((_HDDM_ElementList*)list)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(list), ((_HDDM_ElementList*)list)->subtype, 1);
   return list;
}

static PyObject*
_HDDM_getFcalHits(PyObject *self, PyObject *args)
{
   _HDDM *me = (_HDDM*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid HDDM element");
      return NULL;
   }
   PyObject *list = _HDDM_ElementList_new(&_HDDM_ElementList_type, 0, 0);
   ((_HDDM_ElementList*)list)->subtype = &_FcalHit_type;
   ((_HDDM_ElementList*)list)->list = (HDDM_ElementList<HDDM_Element>*)
    new FcalHitList(me->elem->getFcalHits());
   ((_HDDM_ElementList*)list)->borrowed = 0;
   ((_HDDM_ElementList*)list)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(list), ((_HDDM_ElementList*)list)->subtype, 1);
   return list;
}

static PyObject*
_HDDM_getFcalMatchParamses(PyObject *self, PyObject *args)
{
   _HDDM *me = (_HDDM*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid HDDM element");
      return NULL;
   }
   PyObject *list = _HDDM_ElementList_new(&_HDDM_ElementList_type, 0, 0);
   ((_HDDM_ElementList*)list)->subtype = &_FcalMatchParams_type;
   ((_HDDM_ElementList*)list)->list = (HDDM_ElementList<HDDM_Element>*)
    new FcalMatchParamsList(me->elem->getFcalMatchParamses());
   ((_HDDM_ElementList*)list)->borrowed = 0;
   ((_HDDM_ElementList*)list)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(list), ((_HDDM_ElementList*)list)->subtype, 1);
   return list;
}

static PyObject*
_HDDM_getFcalShowers(PyObject *self, PyObject *args)
{
   _HDDM *me = (_HDDM*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid HDDM element");
      return NULL;
   }
   PyObject *list = _HDDM_ElementList_new(&_HDDM_ElementList_type, 0, 0);
   ((_HDDM_ElementList*)list)->subtype = &_FcalShower_type;
   ((_HDDM_ElementList*)list)->list = (HDDM_ElementList<HDDM_Element>*)
    new FcalShowerList(me->elem->getFcalShowers());
   ((_HDDM_ElementList*)list)->borrowed = 0;
   ((_HDDM_ElementList*)list)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(list), ((_HDDM_ElementList*)list)->subtype, 1);
   return list;
}

static PyObject*
_HDDM_getFcalShowerClassifications(PyObject *self, PyObject *args)
{
   _HDDM *me = (_HDDM*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid HDDM element");
      return NULL;
   }
   PyObject *list = _HDDM_ElementList_new(&_HDDM_ElementList_type, 0, 0);
   ((_HDDM_ElementList*)list)->subtype = &_FcalShowerClassification_type;
   ((_HDDM_ElementList*)list)->list = (HDDM_ElementList<HDDM_Element>*)
    new FcalShowerClassificationList(me->elem->getFcalShowerClassifications());
   ((_HDDM_ElementList*)list)->borrowed = 0;
   ((_HDDM_ElementList*)list)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(list), ((_HDDM_ElementList*)list)->subtype, 1);
   return list;
}

static PyObject*
_HDDM_getFcalShowerNBlockses(PyObject *self, PyObject *args)
{
   _HDDM *me = (_HDDM*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid HDDM element");
      return NULL;
   }
   PyObject *list = _HDDM_ElementList_new(&_HDDM_ElementList_type, 0, 0);
   ((_HDDM_ElementList*)list)->subtype = &_FcalShowerNBlocks_type;
   ((_HDDM_ElementList*)list)->list = (HDDM_ElementList<HDDM_Element>*)
    new FcalShowerNBlocksList(me->elem->getFcalShowerNBlockses());
   ((_HDDM_ElementList*)list)->borrowed = 0;
   ((_HDDM_ElementList*)list)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(list), ((_HDDM_ElementList*)list)->subtype, 1);
   return list;
}

static PyObject*
_HDDM_getFcalShowerPropertiesList(PyObject *self, PyObject *args)
{
   _HDDM *me = (_HDDM*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid HDDM element");
      return NULL;
   }
   PyObject *list = _HDDM_ElementList_new(&_HDDM_ElementList_type, 0, 0);
   ((_HDDM_ElementList*)list)->subtype = &_FcalShowerProperties_type;
   ((_HDDM_ElementList*)list)->list = (HDDM_ElementList<HDDM_Element>*)
    new FcalShowerPropertiesList(me->elem->getFcalShowerPropertiesList());
   ((_HDDM_ElementList*)list)->borrowed = 0;
   ((_HDDM_ElementList*)list)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(list), ((_HDDM_ElementList*)list)->subtype, 1);
   return list;
}

static PyObject*
_HDDM_getFcalSingleHitMatchParamses(PyObject *self, PyObject *args)
{
   _HDDM *me = (_HDDM*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid HDDM element");
      return NULL;
   }
   PyObject *list = _HDDM_ElementList_new(&_HDDM_ElementList_type, 0, 0);
   ((_HDDM_ElementList*)list)->subtype = &_FcalSingleHitMatchParams_type;
   ((_HDDM_ElementList*)list)->list = (HDDM_ElementList<HDDM_Element>*)
    new FcalSingleHitMatchParamsList(me->elem->getFcalSingleHitMatchParamses());
   ((_HDDM_ElementList*)list)->borrowed = 0;
   ((_HDDM_ElementList*)list)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(list), ((_HDDM_ElementList*)list)->subtype, 1);
   return list;
}

static PyObject*
_HDDM_getFdcPseudoses(PyObject *self, PyObject *args)
{
   _HDDM *me = (_HDDM*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid HDDM element");
      return NULL;
   }
   PyObject *list = _HDDM_ElementList_new(&_HDDM_ElementList_type, 0, 0);
   ((_HDDM_ElementList*)list)->subtype = &_FdcPseudos_type;
   ((_HDDM_ElementList*)list)->list = (HDDM_ElementList<HDDM_Element>*)
    new FdcPseudosList(me->elem->getFdcPseudoses());
   ((_HDDM_ElementList*)list)->borrowed = 0;
   ((_HDDM_ElementList*)list)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(list), ((_HDDM_ElementList*)list)->subtype, 1);
   return list;
}

static PyObject*
_HDDM_getFmwpcDatas(PyObject *self, PyObject *args)
{
   _HDDM *me = (_HDDM*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid HDDM element");
      return NULL;
   }
   PyObject *list = _HDDM_ElementList_new(&_HDDM_ElementList_type, 0, 0);
   ((_HDDM_ElementList*)list)->subtype = &_FmwpcData_type;
   ((_HDDM_ElementList*)list)->list = (HDDM_ElementList<HDDM_Element>*)
    new FmwpcDataList(me->elem->getFmwpcDatas());
   ((_HDDM_ElementList*)list)->borrowed = 0;
   ((_HDDM_ElementList*)list)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(list), ((_HDDM_ElementList*)list)->subtype, 1);
   return list;
}

static PyObject*
_HDDM_getFmwpcHits(PyObject *self, PyObject *args)
{
   _HDDM *me = (_HDDM*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid HDDM element");
      return NULL;
   }
   PyObject *list = _HDDM_ElementList_new(&_HDDM_ElementList_type, 0, 0);
   ((_HDDM_ElementList*)list)->subtype = &_FmwpcHit_type;
   ((_HDDM_ElementList*)list)->list = (HDDM_ElementList<HDDM_Element>*)
    new FmwpcHitList(me->elem->getFmwpcHits());
   ((_HDDM_ElementList*)list)->borrowed = 0;
   ((_HDDM_ElementList*)list)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(list), ((_HDDM_ElementList*)list)->subtype, 1);
   return list;
}

static PyObject*
_HDDM_getFmwpcMatchParamses(PyObject *self, PyObject *args)
{
   _HDDM *me = (_HDDM*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid HDDM element");
      return NULL;
   }
   PyObject *list = _HDDM_ElementList_new(&_HDDM_ElementList_type, 0, 0);
   ((_HDDM_ElementList*)list)->subtype = &_FmwpcMatchParams_type;
   ((_HDDM_ElementList*)list)->list = (HDDM_ElementList<HDDM_Element>*)
    new FmwpcMatchParamsList(me->elem->getFmwpcMatchParamses());
   ((_HDDM_ElementList*)list)->borrowed = 0;
   ((_HDDM_ElementList*)list)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(list), ((_HDDM_ElementList*)list)->subtype, 1);
   return list;
}

static PyObject*
_HDDM_getHitStatisticses(PyObject *self, PyObject *args)
{
   _HDDM *me = (_HDDM*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid HDDM element");
      return NULL;
   }
   PyObject *list = _HDDM_ElementList_new(&_HDDM_ElementList_type, 0, 0);
   ((_HDDM_ElementList*)list)->subtype = &_HitStatistics_type;
   ((_HDDM_ElementList*)list)->list = (HDDM_ElementList<HDDM_Element>*)
    new HitStatisticsList(me->elem->getHitStatisticses());
   ((_HDDM_ElementList*)list)->borrowed = 0;
   ((_HDDM_ElementList*)list)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(list), ((_HDDM_ElementList*)list)->subtype, 1);
   return list;
}

static PyObject*
_HDDM_getHitlayerses(PyObject *self, PyObject *args)
{
   _HDDM *me = (_HDDM*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid HDDM element");
      return NULL;
   }
   PyObject *list = _HDDM_ElementList_new(&_HDDM_ElementList_type, 0, 0);
   ((_HDDM_ElementList*)list)->subtype = &_Hitlayers_type;
   ((_HDDM_ElementList*)list)->list = (HDDM_ElementList<HDDM_Element>*)
    new HitlayersList(me->elem->getHitlayerses());
   ((_HDDM_ElementList*)list)->borrowed = 0;
   ((_HDDM_ElementList*)list)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(list), ((_HDDM_ElementList*)list)->subtype, 1);
   return list;
}

static PyObject*
_HDDM_getMcmatchs(PyObject *self, PyObject *args)
{
   _HDDM *me = (_HDDM*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid HDDM element");
      return NULL;
   }
   PyObject *list = _HDDM_ElementList_new(&_HDDM_ElementList_type, 0, 0);
   ((_HDDM_ElementList*)list)->subtype = &_Mcmatch_type;
   ((_HDDM_ElementList*)list)->list = (HDDM_ElementList<HDDM_Element>*)
    new McmatchList(me->elem->getMcmatchs());
   ((_HDDM_ElementList*)list)->borrowed = 0;
   ((_HDDM_ElementList*)list)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(list), ((_HDDM_ElementList*)list)->subtype, 1);
   return list;
}

static PyObject*
_HDDM_getMomenta(PyObject *self, PyObject *args)
{
   _HDDM *me = (_HDDM*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid HDDM element");
      return NULL;
   }
   PyObject *list = _HDDM_ElementList_new(&_HDDM_ElementList_type, 0, 0);
   ((_HDDM_ElementList*)list)->subtype = &_Momentum_type;
   ((_HDDM_ElementList*)list)->list = (HDDM_ElementList<HDDM_Element>*)
    new MomentumList(me->elem->getMomenta());
   ((_HDDM_ElementList*)list)->borrowed = 0;
   ((_HDDM_ElementList*)list)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(list), ((_HDDM_ElementList*)list)->subtype, 1);
   return list;
}

static PyObject*
_HDDM_getOrigins(PyObject *self, PyObject *args)
{
   _HDDM *me = (_HDDM*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid HDDM element");
      return NULL;
   }
   PyObject *list = _HDDM_ElementList_new(&_HDDM_ElementList_type, 0, 0);
   ((_HDDM_ElementList*)list)->subtype = &_Origin_type;
   ((_HDDM_ElementList*)list)->list = (HDDM_ElementList<HDDM_Element>*)
    new OriginList(me->elem->getOrigins());
   ((_HDDM_ElementList*)list)->borrowed = 0;
   ((_HDDM_ElementList*)list)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(list), ((_HDDM_ElementList*)list)->subtype, 1);
   return list;
}

static PyObject*
_HDDM_getPreshowers(PyObject *self, PyObject *args)
{
   _HDDM *me = (_HDDM*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid HDDM element");
      return NULL;
   }
   PyObject *list = _HDDM_ElementList_new(&_HDDM_ElementList_type, 0, 0);
   ((_HDDM_ElementList*)list)->subtype = &_Preshower_type;
   ((_HDDM_ElementList*)list)->list = (HDDM_ElementList<HDDM_Element>*)
    new PreshowerList(me->elem->getPreshowers());
   ((_HDDM_ElementList*)list)->borrowed = 0;
   ((_HDDM_ElementList*)list)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(list), ((_HDDM_ElementList*)list)->subtype, 1);
   return list;
}

static PyObject*
_HDDM_getProducts(PyObject *self, PyObject *args)
{
   _HDDM *me = (_HDDM*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid HDDM element");
      return NULL;
   }
   PyObject *list = _HDDM_ElementList_new(&_HDDM_ElementList_type, 0, 0);
   ((_HDDM_ElementList*)list)->subtype = &_Product_type;
   ((_HDDM_ElementList*)list)->list = (HDDM_ElementList<HDDM_Element>*)
    new ProductList(me->elem->getProducts());
   ((_HDDM_ElementList*)list)->borrowed = 0;
   ((_HDDM_ElementList*)list)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(list), ((_HDDM_ElementList*)list)->subtype, 1);
   return list;
}

static PyObject*
_HDDM_getReactions(PyObject *self, PyObject *args)
{
   _HDDM *me = (_HDDM*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid HDDM element");
      return NULL;
   }
   PyObject *list = _HDDM_ElementList_new(&_HDDM_ElementList_type, 0, 0);
   ((_HDDM_ElementList*)list)->subtype = &_Reaction_type;
   ((_HDDM_ElementList*)list)->list = (HDDM_ElementList<HDDM_Element>*)
    new ReactionList(me->elem->getReactions());
   ((_HDDM_ElementList*)list)->borrowed = 0;
   ((_HDDM_ElementList*)list)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(list), ((_HDDM_ElementList*)list)->subtype, 1);
   return list;
}

static PyObject*
_HDDM_getScMatchParamses(PyObject *self, PyObject *args)
{
   _HDDM *me = (_HDDM*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid HDDM element");
      return NULL;
   }
   PyObject *list = _HDDM_ElementList_new(&_HDDM_ElementList_type, 0, 0);
   ((_HDDM_ElementList*)list)->subtype = &_ScMatchParams_type;
   ((_HDDM_ElementList*)list)->list = (HDDM_ElementList<HDDM_Element>*)
    new ScMatchParamsList(me->elem->getScMatchParamses());
   ((_HDDM_ElementList*)list)->borrowed = 0;
   ((_HDDM_ElementList*)list)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(list), ((_HDDM_ElementList*)list)->subtype, 1);
   return list;
}

static PyObject*
_HDDM_getStartCounterses(PyObject *self, PyObject *args)
{
   _HDDM *me = (_HDDM*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid HDDM element");
      return NULL;
   }
   PyObject *list = _HDDM_ElementList_new(&_HDDM_ElementList_type, 0, 0);
   ((_HDDM_ElementList*)list)->subtype = &_StartCounters_type;
   ((_HDDM_ElementList*)list)->list = (HDDM_ElementList<HDDM_Element>*)
    new StartCountersList(me->elem->getStartCounterses());
   ((_HDDM_ElementList*)list)->borrowed = 0;
   ((_HDDM_ElementList*)list)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(list), ((_HDDM_ElementList*)list)->subtype, 1);
   return list;
}

static PyObject*
_HDDM_getStartHits(PyObject *self, PyObject *args)
{
   _HDDM *me = (_HDDM*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid HDDM element");
      return NULL;
   }
   PyObject *list = _HDDM_ElementList_new(&_HDDM_ElementList_type, 0, 0);
   ((_HDDM_ElementList*)list)->subtype = &_StartHit_type;
   ((_HDDM_ElementList*)list)->list = (HDDM_ElementList<HDDM_Element>*)
    new StartHitList(me->elem->getStartHits());
   ((_HDDM_ElementList*)list)->borrowed = 0;
   ((_HDDM_ElementList*)list)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(list), ((_HDDM_ElementList*)list)->subtype, 1);
   return list;
}

static PyObject*
_HDDM_getTaghBeamPhotons(PyObject *self, PyObject *args)
{
   _HDDM *me = (_HDDM*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid HDDM element");
      return NULL;
   }
   PyObject *list = _HDDM_ElementList_new(&_HDDM_ElementList_type, 0, 0);
   ((_HDDM_ElementList*)list)->subtype = &_TaghBeamPhoton_type;
   ((_HDDM_ElementList*)list)->list = (HDDM_ElementList<HDDM_Element>*)
    new TaghBeamPhotonList(me->elem->getTaghBeamPhotons());
   ((_HDDM_ElementList*)list)->borrowed = 0;
   ((_HDDM_ElementList*)list)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(list), ((_HDDM_ElementList*)list)->subtype, 1);
   return list;
}

static PyObject*
_HDDM_getTaghChannels(PyObject *self, PyObject *args)
{
   _HDDM *me = (_HDDM*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid HDDM element");
      return NULL;
   }
   PyObject *list = _HDDM_ElementList_new(&_HDDM_ElementList_type, 0, 0);
   ((_HDDM_ElementList*)list)->subtype = &_TaghChannel_type;
   ((_HDDM_ElementList*)list)->list = (HDDM_ElementList<HDDM_Element>*)
    new TaghChannelList(me->elem->getTaghChannels());
   ((_HDDM_ElementList*)list)->borrowed = 0;
   ((_HDDM_ElementList*)list)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(list), ((_HDDM_ElementList*)list)->subtype, 1);
   return list;
}

static PyObject*
_HDDM_getTagmBeamPhotons(PyObject *self, PyObject *args)
{
   _HDDM *me = (_HDDM*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid HDDM element");
      return NULL;
   }
   PyObject *list = _HDDM_ElementList_new(&_HDDM_ElementList_type, 0, 0);
   ((_HDDM_ElementList*)list)->subtype = &_TagmBeamPhoton_type;
   ((_HDDM_ElementList*)list)->list = (HDDM_ElementList<HDDM_Element>*)
    new TagmBeamPhotonList(me->elem->getTagmBeamPhotons());
   ((_HDDM_ElementList*)list)->borrowed = 0;
   ((_HDDM_ElementList*)list)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(list), ((_HDDM_ElementList*)list)->subtype, 1);
   return list;
}

static PyObject*
_HDDM_getTagmChannels(PyObject *self, PyObject *args)
{
   _HDDM *me = (_HDDM*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid HDDM element");
      return NULL;
   }
   PyObject *list = _HDDM_ElementList_new(&_HDDM_ElementList_type, 0, 0);
   ((_HDDM_ElementList*)list)->subtype = &_TagmChannel_type;
   ((_HDDM_ElementList*)list)->list = (HDDM_ElementList<HDDM_Element>*)
    new TagmChannelList(me->elem->getTagmChannels());
   ((_HDDM_ElementList*)list)->borrowed = 0;
   ((_HDDM_ElementList*)list)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(list), ((_HDDM_ElementList*)list)->subtype, 1);
   return list;
}

static PyObject*
_HDDM_getTflightPCorrelations(PyObject *self, PyObject *args)
{
   _HDDM *me = (_HDDM*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid HDDM element");
      return NULL;
   }
   PyObject *list = _HDDM_ElementList_new(&_HDDM_ElementList_type, 0, 0);
   ((_HDDM_ElementList*)list)->subtype = &_TflightPCorrelation_type;
   ((_HDDM_ElementList*)list)->list = (HDDM_ElementList<HDDM_Element>*)
    new TflightPCorrelationList(me->elem->getTflightPCorrelations());
   ((_HDDM_ElementList*)list)->borrowed = 0;
   ((_HDDM_ElementList*)list)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(list), ((_HDDM_ElementList*)list)->subtype, 1);
   return list;
}

static PyObject*
_HDDM_getTofDedxs(PyObject *self, PyObject *args)
{
   _HDDM *me = (_HDDM*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid HDDM element");
      return NULL;
   }
   PyObject *list = _HDDM_ElementList_new(&_HDDM_ElementList_type, 0, 0);
   ((_HDDM_ElementList*)list)->subtype = &_TofDedx_type;
   ((_HDDM_ElementList*)list)->list = (HDDM_ElementList<HDDM_Element>*)
    new TofDedxList(me->elem->getTofDedxs());
   ((_HDDM_ElementList*)list)->borrowed = 0;
   ((_HDDM_ElementList*)list)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(list), ((_HDDM_ElementList*)list)->subtype, 1);
   return list;
}

static PyObject*
_HDDM_getTofEnergyDepositions(PyObject *self, PyObject *args)
{
   _HDDM *me = (_HDDM*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid HDDM element");
      return NULL;
   }
   PyObject *list = _HDDM_ElementList_new(&_HDDM_ElementList_type, 0, 0);
   ((_HDDM_ElementList*)list)->subtype = &_TofEnergyDeposition_type;
   ((_HDDM_ElementList*)list)->list = (HDDM_ElementList<HDDM_Element>*)
    new TofEnergyDepositionList(me->elem->getTofEnergyDepositions());
   ((_HDDM_ElementList*)list)->borrowed = 0;
   ((_HDDM_ElementList*)list)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(list), ((_HDDM_ElementList*)list)->subtype, 1);
   return list;
}

static PyObject*
_HDDM_getTofMatchParamses(PyObject *self, PyObject *args)
{
   _HDDM *me = (_HDDM*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid HDDM element");
      return NULL;
   }
   PyObject *list = _HDDM_ElementList_new(&_HDDM_ElementList_type, 0, 0);
   ((_HDDM_ElementList*)list)->subtype = &_TofMatchParams_type;
   ((_HDDM_ElementList*)list)->list = (HDDM_ElementList<HDDM_Element>*)
    new TofMatchParamsList(me->elem->getTofMatchParamses());
   ((_HDDM_ElementList*)list)->borrowed = 0;
   ((_HDDM_ElementList*)list)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(list), ((_HDDM_ElementList*)list)->subtype, 1);
   return list;
}

static PyObject*
_HDDM_getTofPaddleses(PyObject *self, PyObject *args)
{
   _HDDM *me = (_HDDM*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid HDDM element");
      return NULL;
   }
   PyObject *list = _HDDM_ElementList_new(&_HDDM_ElementList_type, 0, 0);
   ((_HDDM_ElementList*)list)->subtype = &_TofPaddles_type;
   ((_HDDM_ElementList*)list)->list = (HDDM_ElementList<HDDM_Element>*)
    new TofPaddlesList(me->elem->getTofPaddleses());
   ((_HDDM_ElementList*)list)->borrowed = 0;
   ((_HDDM_ElementList*)list)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(list), ((_HDDM_ElementList*)list)->subtype, 1);
   return list;
}

static PyObject*
_HDDM_getTofPoints(PyObject *self, PyObject *args)
{
   _HDDM *me = (_HDDM*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid HDDM element");
      return NULL;
   }
   PyObject *list = _HDDM_ElementList_new(&_HDDM_ElementList_type, 0, 0);
   ((_HDDM_ElementList*)list)->subtype = &_TofPoint_type;
   ((_HDDM_ElementList*)list)->list = (HDDM_ElementList<HDDM_Element>*)
    new TofPointList(me->elem->getTofPoints());
   ((_HDDM_ElementList*)list)->borrowed = 0;
   ((_HDDM_ElementList*)list)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(list), ((_HDDM_ElementList*)list)->subtype, 1);
   return list;
}

static PyObject*
_HDDM_getTofStatuses(PyObject *self, PyObject *args)
{
   _HDDM *me = (_HDDM*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid HDDM element");
      return NULL;
   }
   PyObject *list = _HDDM_ElementList_new(&_HDDM_ElementList_type, 0, 0);
   ((_HDDM_ElementList*)list)->subtype = &_TofStatus_type;
   ((_HDDM_ElementList*)list)->list = (HDDM_ElementList<HDDM_Element>*)
    new TofStatusList(me->elem->getTofStatuses());
   ((_HDDM_ElementList*)list)->borrowed = 0;
   ((_HDDM_ElementList*)list)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(list), ((_HDDM_ElementList*)list)->subtype, 1);
   return list;
}

static PyObject*
_HDDM_getTrackFits(PyObject *self, PyObject *args)
{
   _HDDM *me = (_HDDM*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid HDDM element");
      return NULL;
   }
   PyObject *list = _HDDM_ElementList_new(&_HDDM_ElementList_type, 0, 0);
   ((_HDDM_ElementList*)list)->subtype = &_TrackFit_type;
   ((_HDDM_ElementList*)list)->list = (HDDM_ElementList<HDDM_Element>*)
    new TrackFitList(me->elem->getTrackFits());
   ((_HDDM_ElementList*)list)->borrowed = 0;
   ((_HDDM_ElementList*)list)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(list), ((_HDDM_ElementList*)list)->subtype, 1);
   return list;
}

static PyObject*
_HDDM_getTrackFlagses(PyObject *self, PyObject *args)
{
   _HDDM *me = (_HDDM*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid HDDM element");
      return NULL;
   }
   PyObject *list = _HDDM_ElementList_new(&_HDDM_ElementList_type, 0, 0);
   ((_HDDM_ElementList*)list)->subtype = &_TrackFlags_type;
   ((_HDDM_ElementList*)list)->list = (HDDM_ElementList<HDDM_Element>*)
    new TrackFlagsList(me->elem->getTrackFlagses());
   ((_HDDM_ElementList*)list)->borrowed = 0;
   ((_HDDM_ElementList*)list)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(list), ((_HDDM_ElementList*)list)->subtype, 1);
   return list;
}

static PyObject*
_HDDM_getTriggers(PyObject *self, PyObject *args)
{
   _HDDM *me = (_HDDM*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid HDDM element");
      return NULL;
   }
   PyObject *list = _HDDM_ElementList_new(&_HDDM_ElementList_type, 0, 0);
   ((_HDDM_ElementList*)list)->subtype = &_Trigger_type;
   ((_HDDM_ElementList*)list)->list = (HDDM_ElementList<HDDM_Element>*)
    new TriggerList(me->elem->getTriggers());
   ((_HDDM_ElementList*)list)->borrowed = 0;
   ((_HDDM_ElementList*)list)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(list), ((_HDDM_ElementList*)list)->subtype, 1);
   return list;
}

static PyObject*
_HDDM_getTriggerEnergySumses(PyObject *self, PyObject *args)
{
   _HDDM *me = (_HDDM*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid HDDM element");
      return NULL;
   }
   PyObject *list = _HDDM_ElementList_new(&_HDDM_ElementList_type, 0, 0);
   ((_HDDM_ElementList*)list)->subtype = &_TriggerEnergySums_type;
   ((_HDDM_ElementList*)list)->list = (HDDM_ElementList<HDDM_Element>*)
    new TriggerEnergySumsList(me->elem->getTriggerEnergySumses());
   ((_HDDM_ElementList*)list)->borrowed = 0;
   ((_HDDM_ElementList*)list)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(list), ((_HDDM_ElementList*)list)->subtype, 1);
   return list;
}

static PyObject*
_HDDM_getVertices(PyObject *self, PyObject *args)
{
   _HDDM *me = (_HDDM*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid HDDM element");
      return NULL;
   }
   PyObject *list = _HDDM_ElementList_new(&_HDDM_ElementList_type, 0, 0);
   ((_HDDM_ElementList*)list)->subtype = &_Vertex_type;
   ((_HDDM_ElementList*)list)->list = (HDDM_ElementList<HDDM_Element>*)
    new VertexList(me->elem->getVertices());
   ((_HDDM_ElementList*)list)->borrowed = 0;
   ((_HDDM_ElementList*)list)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(list), ((_HDDM_ElementList*)list)->subtype, 1);
   return list;
}

static PyObject*
_HDDM_getWidths(PyObject *self, PyObject *args)
{
   _HDDM *me = (_HDDM*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid HDDM element");
      return NULL;
   }
   PyObject *list = _HDDM_ElementList_new(&_HDDM_ElementList_type, 0, 0);
   ((_HDDM_ElementList*)list)->subtype = &_Width_type;
   ((_HDDM_ElementList*)list)->list = (HDDM_ElementList<HDDM_Element>*)
    new WidthList(me->elem->getWidths());
   ((_HDDM_ElementList*)list)->borrowed = 0;
   ((_HDDM_ElementList*)list)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(list), ((_HDDM_ElementList*)list)->subtype, 1);
   return list;
}

static PyObject*
_HDDM_getReconstructedPhysicsEvent(PyObject *self, PyObject *args)
{
   int index=0;
   if (! PyArg_ParseTuple(args, "|i", &index)) {
      return NULL;
   }
   _HDDM *me = (_HDDM*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid HDDM element");
      return NULL;
   }
   PyObject *obj = _ReconstructedPhysicsEvent_new(&_ReconstructedPhysicsEvent_type, 0, 0);
   ((_ReconstructedPhysicsEvent*)obj)->elem = &me->elem->getReconstructedPhysicsEvent();
   ((_ReconstructedPhysicsEvent*)obj)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(obj));
   return obj;
}

static PyObject*
_HDDM_getReconstructedPhysicsEvents(PyObject *self, PyObject *args)
{
   _HDDM *me = (_HDDM*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid HDDM element");
      return NULL;
   }
   PyObject *list = _HDDM_ElementList_new(&_HDDM_ElementList_type, 0, 0);
   ((_HDDM_ElementList*)list)->subtype = &_ReconstructedPhysicsEvent_type;
   ((_HDDM_ElementList*)list)->list = (HDDM_ElementList<HDDM_Element>*)
    &me->elem->getReconstructedPhysicsEvents();
   ((_HDDM_ElementList*)list)->borrowed = 1;
   ((_HDDM_ElementList*)list)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(list), ((_HDDM_ElementList*)list)->subtype, 0);
   return list;
}

static PyObject*
_HDDM_addReconstructedPhysicsEvents(PyObject *self, PyObject *args)
{
   int count=1;
   int start=-1;
   if (! PyArg_ParseTuple(args, "|ii", &count, &start)) {
      return NULL;
   }
   _HDDM *me = (_HDDM*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "add attempted on invalid HDDM element");
      return NULL;
   }
   PyObject *list = _HDDM_ElementList_new(&_HDDM_ElementList_type, 0, 0);
   ((_HDDM_ElementList*)list)->subtype = &_ReconstructedPhysicsEvent_type;
   ((_HDDM_ElementList*)list)->list = (HDDM_ElementList<HDDM_Element>*)
    new ReconstructedPhysicsEventList(me->elem->addReconstructedPhysicsEvents(count, start));
   ((_HDDM_ElementList*)list)->borrowed = 0;
   ((_HDDM_ElementList*)list)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(list), ((_HDDM_ElementList*)list)->subtype, 1);
   return list;
}

static PyObject*
_HDDM_deleteReconstructedPhysicsEvents(PyObject *self, PyObject *args)
{
   int count=-1;
   int start=0;
   if (! PyArg_ParseTuple(args, "|ii", &count, &start)) {
      return NULL;
   }
   _HDDM *me = (_HDDM*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "delete attempted on invalid HDDM element");
      return NULL;
   }
   me->elem->deleteReconstructedPhysicsEvents(count, start);
   Py_INCREF(Py_None);
   return Py_None;
}

static PyObject*
_HDDM_clear(PyObject *self, PyObject *args)
{
   _HDDM *me = (_HDDM*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid HDDM element");
      return NULL;
   }
   me->elem->clear();
   Py_INCREF(Py_None);
   return Py_None;
}

static PyObject*
_HDDM_toString(PyObject *self, PyObject *args=0)
{
   _HDDM *me = (_HDDM*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid HDDM element");
      return NULL;
   }
   std::string str(me->elem->toString());
   return PyUnicode_FromString(str.c_str());
}

static PyObject*
_HDDM_toXML(PyObject *self, PyObject *args=0)
{
   _HDDM *me = (_HDDM*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid HDDM element");
      return NULL;
   }
   std::string str(me->elem->toXML());
   return PyUnicode_FromString(str.c_str());
}

static PyGetSetDef _HDDM_getsetters[] = {
   {(char*)"class",
    (getter)_HDDM_getClass, 0,
    (char*)"class value",
    NULL},
   {(char*)"version",
    (getter)_HDDM_getVersion, 0,
    (char*)"version value",
    NULL},
   {(char*)"xmlns",
    (getter)_HDDM_getXmlns, 0,
    (char*)"xmlns value",
    NULL},
   {NULL}  /* Sentinel */
};

static PyMemberDef _HDDM_members[] = {
   {NULL}  /* Sentinel */
};

static PyMethodDef _HDDM_methods[] = {
   {"addReconstructedPhysicsEvents", _HDDM_addReconstructedPhysicsEvents, METH_VARARGS,
    "extend (or insert into) the list of reconstructedPhysicsEvent objects for this HDDM"},
   {"clear", _HDDM_clear, METH_NOARGS,
    "clear all contents from this HDDM"},
   {"deleteReconstructedPhysicsEvents", _HDDM_deleteReconstructedPhysicsEvents, METH_VARARGS,
    "delete reconstructedPhysicsEvent objects for this HDDM"},
   {"getBcalCellses", _HDDM_getBcalCellses, METH_NOARGS,
    "get complete list of bcalCells objects for this record"},
   {"getBcalClusters", _HDDM_getBcalClusters, METH_NOARGS,
    "get complete list of bcalCluster objects for this record"},
   {"getBcalCorrelationses", _HDDM_getBcalCorrelationses, METH_NOARGS,
    "get complete list of bcalCorrelations objects for this record"},
   {"getBcalDOCAtoTracks", _HDDM_getBcalDOCAtoTracks, METH_NOARGS,
    "get complete list of bcalDOCAtoTrack objects for this record"},
   {"getBcalLayerses", _HDDM_getBcalLayerses, METH_NOARGS,
    "get complete list of bcalLayers objects for this record"},
   {"getBcalMatchParamses", _HDDM_getBcalMatchParamses, METH_NOARGS,
    "get complete list of bcalMatchParams objects for this record"},
   {"getBcalShowers", _HDDM_getBcalShowers, METH_NOARGS,
    "get complete list of bcalShower objects for this record"},
   {"getCDCAmpdEdxs", _HDDM_getCDCAmpdEdxs, METH_NOARGS,
    "get complete list of CDCAmpdEdx objects for this record"},
   {"getCDCdEdxTruncs", _HDDM_getCDCdEdxTruncs, METH_NOARGS,
    "get complete list of CDCdEdxTrunc objects for this record"},
   {"getCcalBlockses", _HDDM_getCcalBlockses, METH_NOARGS,
    "get complete list of ccalBlocks objects for this record"},
   {"getCcalShowers", _HDDM_getCcalShowers, METH_NOARGS,
    "get complete list of ccalShower objects for this record"},
   {"getCcdbContexts", _HDDM_getCcdbContexts, METH_NOARGS,
    "get complete list of ccdbContext objects for this record"},
   {"getCdcStrawses", _HDDM_getCdcStrawses, METH_NOARGS,
    "get complete list of cdcStraws objects for this record"},
   {"getChargedTracks", _HDDM_getChargedTracks, METH_NOARGS,
    "get complete list of chargedTrack objects for this record"},
   {"getComments", _HDDM_getComments, METH_NOARGS,
    "get complete list of comment objects for this record"},
   {"getCtofMatchParamses", _HDDM_getCtofMatchParamses, METH_NOARGS,
    "get complete list of ctofMatchParams objects for this record"},
   {"getCtofPoints", _HDDM_getCtofPoints, METH_NOARGS,
    "get complete list of ctofPoint objects for this record"},
   {"getDEdxDCs", _HDDM_getDEdxDCs, METH_NOARGS,
    "get complete list of dEdxDC objects for this record"},
   {"getDataVersionStrings", _HDDM_getDataVersionStrings, METH_NOARGS,
    "get complete list of dataVersionString objects for this record"},
   {"getDetectorMatcheses", _HDDM_getDetectorMatcheses, METH_NOARGS,
    "get complete list of detectorMatches objects for this record"},
   {"getDircHits", _HDDM_getDircHits, METH_NOARGS,
    "get complete list of dircHit objects for this record"},
   {"getDircMatchHits", _HDDM_getDircMatchHits, METH_NOARGS,
    "get complete list of dircMatchHit objects for this record"},
   {"getDircMatchParamses", _HDDM_getDircMatchParamses, METH_NOARGS,
    "get complete list of dircMatchParams objects for this record"},
   {"getDircPMTses", _HDDM_getDircPMTses, METH_NOARGS,
    "get complete list of dircPMTs objects for this record"},
   {"getExitParamses", _HDDM_getExitParamses, METH_NOARGS,
    "get complete list of exitParams objects for this record"},
   {"getExpectedhitses", _HDDM_getExpectedhitses, METH_NOARGS,
    "get complete list of expectedhits objects for this record"},
   {"getFDCdEdxTruncs", _HDDM_getFDCdEdxTruncs, METH_NOARGS,
    "get complete list of FDCdEdxTrunc objects for this record"},
   {"getFcalBlockses", _HDDM_getFcalBlockses, METH_NOARGS,
    "get complete list of fcalBlocks objects for this record"},
   {"getFcalCorrelationses", _HDDM_getFcalCorrelationses, METH_NOARGS,
    "get complete list of fcalCorrelations objects for this record"},
   {"getFcalDOCAtoTracks", _HDDM_getFcalDOCAtoTracks, METH_NOARGS,
    "get complete list of fcalDOCAtoTrack objects for this record"},
   {"getFcalEnergyParamses", _HDDM_getFcalEnergyParamses, METH_NOARGS,
    "get complete list of fcalEnergyParams objects for this record"},
   {"getFcalHits", _HDDM_getFcalHits, METH_NOARGS,
    "get complete list of fcalHit objects for this record"},
   {"getFcalMatchParamses", _HDDM_getFcalMatchParamses, METH_NOARGS,
    "get complete list of fcalMatchParams objects for this record"},
   {"getFcalShowerClassifications", _HDDM_getFcalShowerClassifications, METH_NOARGS,
    "get complete list of fcalShowerClassification objects for this record"},
   {"getFcalShowerNBlockses", _HDDM_getFcalShowerNBlockses, METH_NOARGS,
    "get complete list of fcalShowerNBlocks objects for this record"},
   {"getFcalShowerPropertiesList", _HDDM_getFcalShowerPropertiesList, METH_NOARGS,
    "get complete list of fcalShowerProperties objects for this record"},
   {"getFcalShowers", _HDDM_getFcalShowers, METH_NOARGS,
    "get complete list of fcalShower objects for this record"},
   {"getFcalSingleHitMatchParamses", _HDDM_getFcalSingleHitMatchParamses, METH_NOARGS,
    "get complete list of fcalSingleHitMatchParams objects for this record"},
   {"getFdcPseudoses", _HDDM_getFdcPseudoses, METH_NOARGS,
    "get complete list of fdcPseudos objects for this record"},
   {"getFmwpcDatas", _HDDM_getFmwpcDatas, METH_NOARGS,
    "get complete list of fmwpcData objects for this record"},
   {"getFmwpcHits", _HDDM_getFmwpcHits, METH_NOARGS,
    "get complete list of fmwpcHit objects for this record"},
   {"getFmwpcMatchParamses", _HDDM_getFmwpcMatchParamses, METH_NOARGS,
    "get complete list of fmwpcMatchParams objects for this record"},
   {"getHitStatisticses", _HDDM_getHitStatisticses, METH_NOARGS,
    "get complete list of hitStatistics objects for this record"},
   {"getHitlayerses", _HDDM_getHitlayerses, METH_NOARGS,
    "get complete list of hitlayers objects for this record"},
   {"getMcmatchs", _HDDM_getMcmatchs, METH_NOARGS,
    "get complete list of mcmatch objects for this record"},
   {"getMomenta", _HDDM_getMomenta, METH_NOARGS,
    "get complete list of momentum objects for this record"},
   {"getOrigins", _HDDM_getOrigins, METH_NOARGS,
    "get complete list of origin objects for this record"},
   {"getPreshowers", _HDDM_getPreshowers, METH_NOARGS,
    "get complete list of preshower objects for this record"},
   {"getProducts", _HDDM_getProducts, METH_NOARGS,
    "get complete list of product objects for this record"},
   {"getRFtimes", _HDDM_getRFtimes, METH_NOARGS,
    "get complete list of RFtime objects for this record"},
   {"getReactions", _HDDM_getReactions, METH_NOARGS,
    "get complete list of reaction objects for this record"},
   {"getReconstructedPhysicsEvent", _HDDM_getReconstructedPhysicsEvent, METH_VARARGS,
    "get an individual reconstructedPhysicsEvent object from this HDDM"},
   {"getReconstructedPhysicsEvents", _HDDM_getReconstructedPhysicsEvents, METH_NOARGS,
    "get list of reconstructedPhysicsEvent objects for this HDDM"},
   {"getScMatchParamses", _HDDM_getScMatchParamses, METH_NOARGS,
    "get complete list of scMatchParams objects for this record"},
   {"getStartCounterses", _HDDM_getStartCounterses, METH_NOARGS,
    "get complete list of startCounters objects for this record"},
   {"getStartHits", _HDDM_getStartHits, METH_NOARGS,
    "get complete list of startHit objects for this record"},
   {"getTaghBeamPhotons", _HDDM_getTaghBeamPhotons, METH_NOARGS,
    "get complete list of taghBeamPhoton objects for this record"},
   {"getTaghChannels", _HDDM_getTaghChannels, METH_NOARGS,
    "get complete list of taghChannel objects for this record"},
   {"getTagmBeamPhotons", _HDDM_getTagmBeamPhotons, METH_NOARGS,
    "get complete list of tagmBeamPhoton objects for this record"},
   {"getTagmChannels", _HDDM_getTagmChannels, METH_NOARGS,
    "get complete list of tagmChannel objects for this record"},
   {"getTflightPCorrelations", _HDDM_getTflightPCorrelations, METH_NOARGS,
    "get complete list of tflightPCorrelation objects for this record"},
   {"getTofDedxs", _HDDM_getTofDedxs, METH_NOARGS,
    "get complete list of tofDedx objects for this record"},
   {"getTofEnergyDepositions", _HDDM_getTofEnergyDepositions, METH_NOARGS,
    "get complete list of tofEnergyDeposition objects for this record"},
   {"getTofMatchParamses", _HDDM_getTofMatchParamses, METH_NOARGS,
    "get complete list of tofMatchParams objects for this record"},
   {"getTofPaddleses", _HDDM_getTofPaddleses, METH_NOARGS,
    "get complete list of tofPaddles objects for this record"},
   {"getTofPoints", _HDDM_getTofPoints, METH_NOARGS,
    "get complete list of tofPoint objects for this record"},
   {"getTofStatuses", _HDDM_getTofStatuses, METH_NOARGS,
    "get complete list of tofStatus objects for this record"},
   {"getTrackFits", _HDDM_getTrackFits, METH_NOARGS,
    "get complete list of trackFit objects for this record"},
   {"getTrackFlagses", _HDDM_getTrackFlagses, METH_NOARGS,
    "get complete list of trackFlags objects for this record"},
   {"getTriggerEnergySumses", _HDDM_getTriggerEnergySumses, METH_NOARGS,
    "get complete list of triggerEnergySums objects for this record"},
   {"getTriggers", _HDDM_getTriggers, METH_NOARGS,
    "get complete list of trigger objects for this record"},
   {"getVertices", _HDDM_getVertices, METH_NOARGS,
    "get complete list of vertex objects for this record"},
   {"getWidths", _HDDM_getWidths, METH_NOARGS,
    "get complete list of width objects for this record"},
   {"toString", _HDDM_toString, METH_NOARGS,
    "show element as a human-readable string"},
   {"toXML", _HDDM_toXML, METH_NOARGS,
    "show element as a XML fragment"},
#ifdef HDF5_SUPPORT
   {"hdf5FileWrite", _HDDM_hdf5FileWrite, METH_VARARGS,
    "random-access write this hddm record to an output hdf5 file"},
   {"hdf5FileRead", _HDDM_hdf5FileRead, METH_VARARGS,
    "random-access read this hddm record from an input hdf5 file"},
#endif
   {NULL}  /* Sentinel */
};

static PyTypeObject _HDDM_type = {
    PyVarObject_HEAD_INIT(NULL,0)
    "hddm_r.HDDM",         /*tp_name*/
    sizeof(_HDDM),          /*tp_basicsize*/
    0,                         /*tp_itemsize*/
    (destructor)_HDDM_dealloc, /*tp_dealloc*/
    0,                         /*tp_print*/
    0,                         /*tp_getattr*/
    0,                         /*tp_setattr*/
    0,                         /*tp_compare*/
    0,                         /*tp_repr*/
    0,                         /*tp_as_number*/
    0,                         /*tp_as_sequence*/
    0,                         /*tp_as_mapping*/
    0,                         /*tp_hash */
    0,                         /*tp_call*/
    (reprfunc)_HDDM_toString,         /*tp_str*/
    0,                         /*tp_getattro*/
    0,                         /*tp_setattro*/
    0,                         /*tp_as_buffer*/
    Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE, /*tp_flags*/
    "hddm_r HDDM element",  /* tp_doc */
    0,                         /* tp_traverse */
    0,                         /* tp_clear */
    0,                         /* tp_richcompare */
    0,                         /* tp_weaklistoffset */
    0,                         /* tp_iter */
    0,                         /* tp_iternext */
    _HDDM_methods,          /* tp_methods */
    _HDDM_members,          /* tp_members */
    _HDDM_getsetters,       /* tp_getset */
    &_HDDM_Element_type,       /* tp_base */
    0,                         /* tp_dict */
    0,                         /* tp_descr_get */
    0,                         /* tp_descr_set */
    0,                         /* tp_dictoffset */
    (initproc)_HDDM_init,   /* tp_init */
    0,                         /* tp_alloc */
    _HDDM_new,              /* tp_new */
};



// wrap class hddm_r::streamposition as hddm_r.streamposition

typedef struct {
   PyObject_HEAD
   streamposition *streampos;
} _streamposition;

static void
_streamposition_dealloc(_streamposition* self)
{
   if (self->streampos != 0)
      delete self->streampos;
   Py_TYPE(self)->tp_free((PyObject*)self);
}

static PyObject*
_streamposition_new(PyTypeObject *type, PyObject *args, PyObject *kwds)
{
   _streamposition *self;
   self = (_streamposition*)type->tp_alloc(type, 0);
   if (self != NULL)
      self->streampos = 0;
   return (PyObject*)self;
}

static int
_streamposition_init(_streamposition *self, PyObject *args, PyObject *kwds)
{
   const char *kwlist[] = {"start", "offset", "status", NULL};
   uint64_t start = 0;
   uint32_t offset = 0;
   uint32_t status = 0;
   if (PyArg_ParseTuple(args, "") ||
       PyArg_ParseTupleAndKeywords(args, kwds, "kII", (char**)kwlist, 
                                   &start, &offset, &status))
   {
      PyErr_Clear();
      if (self->streampos != 0)
         delete self->streampos;
      self->streampos = new streamposition(start, offset, status);
      return 0;
   }
   return -1; 
}

static PyObject*
_streamposition_richcompare(PyObject *a, PyObject *b, int op)
{
   int res = 0;
   streamposition *apos = ((_streamposition*)a)->streampos;
   streamposition *bpos = ((_streamposition*)b)->streampos;
   if (op == Py_LT)
      res = (*apos < *bpos);
   else if (op == Py_LE)
      res = (*apos <= *bpos);
   else if (op == Py_EQ)
      res = (*apos == *bpos);
   else if (op == Py_NE)
      res = (*apos != *bpos);
   else if (op == Py_GT)
      res = (*apos > *bpos);
   else if (op == Py_GE)
      res = (*apos >= *bpos);
   if (res) {
      Py_INCREF(Py_True);
      return Py_True;
   }
   else {
      Py_INCREF(Py_False);
      return Py_False;
   }
}
static PyObject*
_streamposition_toString(PyObject *self, PyObject *args=0)
{
   std::stringstream ostr;
   ostr << "hddm_r.streamposition("
        << ((_streamposition*)self)->streampos->block_start << ","
        << ((_streamposition*)self)->streampos->block_offset << ","
        << ((_streamposition*)self)->streampos->block_status
        << ")";
   return PyUnicode_FromString(ostr.str().c_str());
}

static PyObject*
_streamposition_toRepr(PyObject *self, PyObject *args=0)
{
   std::stringstream ostr;
   ostr << "\'";
   ostr << "hddm_r.streamposition("
        << ((_streamposition*)self)->streampos->block_start << ","
        << ((_streamposition*)self)->streampos->block_offset << ","
        << ((_streamposition*)self)->streampos->block_status
        << ")";
   ostr << "\'";
   return PyUnicode_FromString(ostr.str().c_str());
}

static PyObject*
_streamposition_getstart(_streamposition *self, void *closure)
{
   return Py_BuildValue("k", self->streampos->block_start);
}

static int
_streamposition_setstart(_streamposition *self, PyObject *value, void *closure)
{
   if (value == NULL) {
      PyErr_SetString(PyExc_TypeError, "unexpected null argument");
      return -1;
   }
   long start = PyInt_AsLong(value);
   if (start < 0 && PyErr_Occurred()) {
      return -1;
   }
   self->streampos->block_start = start;
   return 0;
}

static PyObject*
_streamposition_getoffset(_streamposition *self, void *closure)
{
   return Py_BuildValue("I", self->streampos->block_offset);
}

static int
_streamposition_setoffset(_streamposition *self, PyObject *value, void *closure)
{
   if (value == NULL) {
      PyErr_SetString(PyExc_TypeError, "unexpected null argument");
      return -1;
   }
   long offset = PyInt_AsLong(value);
   if (offset < 0 && PyErr_Occurred()) {
      return -1;
   }
   self->streampos->block_offset = offset;
   return 0;
}

static PyObject*
_streamposition_getstatus(_streamposition *self, void *closure)
{
   return Py_BuildValue("I", self->streampos->block_status);
}

static int
_streamposition_setstatus(_streamposition *self, PyObject *value, void *closure)
{
   if (value == NULL) {
      PyErr_SetString(PyExc_TypeError, "unexpected null argument");
      return -1;
   }
   long status = PyInt_AsLong(value);
   if (status == -1 && PyErr_Occurred()) {
      return -1;
   }
   self->streampos->block_status = status;
   return 0;
}

static PyGetSetDef _streamposition_getsetters[] = {
   {(char*)"start", 
    (getter)_streamposition_getstart, (setter)_streamposition_setstart,
    (char*)"block start position",
    NULL},
   {(char*)"offset", 
    (getter)_streamposition_getoffset, (setter)_streamposition_setoffset,
    (char*)"block offset position",
    NULL},
   {(char*)"status", 
    (getter)_streamposition_getstatus, (setter)_streamposition_setstatus,
    (char*)"block status flags",
    NULL},
   {NULL}  /* Sentinel */
};

static PyMemberDef _streamposition_members[] = {
   {NULL}  /* Sentinel */
};

static PyMethodDef _streamposition_methods[] = {
   {NULL}  /* Sentinel */
};

static PyTypeObject _streamposition_type = {
   PyVarObject_HEAD_INIT(NULL,0)
   "hddm_r.streamposition",   /*tp_name*/
   sizeof(_streamposition),   /*tp_basicsize*/
   0,                         /*tp_itemsize*/
   (destructor)_streamposition_dealloc, /*tp_dealloc*/
   0,                         /*tp_print*/
   0,                         /*tp_getattr*/
   0,                         /*tp_setattr*/
   0,                         /*tp_compare*/
   (reprfunc)_streamposition_toRepr, /*tp_repr*/
   0,                         /*tp_as_number*/
   0,                         /*tp_as_sequence*/
   0,                         /*tp_as_mapping*/
   0,                         /*tp_hash */
   0,                         /*tp_call*/
   (reprfunc)_streamposition_toString, /*tp_str*/
   0,                         /*tp_getattro*/
   0,                         /*tp_setattro*/
   0,                         /*tp_as_buffer*/
   Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE, /*tp_flags*/
   "hddm_r streamposition objects", /* tp_doc */
   0,                         /* tp_traverse */
   0,                         /* tp_clear */
   _streamposition_richcompare, /* tp_richcompare */
   0,                         /* tp_weaklistoffset */
   0,                         /* tp_iter */
   0,                         /* tp_iternext */
   _streamposition_methods,   /* tp_methods */
   _streamposition_members,   /* tp_members */
   _streamposition_getsetters, /* tp_getset */
   0,                         /* tp_base */
   0,                         /* tp_dict */
   0,                         /* tp_descr_get */
   0,                         /* tp_descr_set */
   0,                         /* tp_dictoffset */
   (initproc)_streamposition_init, /* tp_init */
   0,                         /* tp_alloc */
   _streamposition_new,       /* tp_new */
};


// wrap class hddm_r::ostream as hddm_r.ostream

typedef struct {
   PyObject_HEAD
   std::string *fname;
   std::ofstream *fstr;
   ostream *ostr;
} _ostream;

static void
_ostream_dealloc(_ostream* self)
{
   if (self->fname != 0)
      delete self->fname;
   if (self->ostr != 0)
      delete self->ostr;
   if (self->fstr != 0)
      delete self->fstr;
   Py_TYPE(self)->tp_free((PyObject*)self);
}

static PyObject*
_ostream_new(PyTypeObject *type, PyObject *args, PyObject *kwds)
{
   _ostream *self;
   self = (_ostream*)type->tp_alloc(type, 0);
   if (self != NULL) {
      self->fname = 0;
      self->fstr = 0;
      self->ostr = 0;
   }
   return (PyObject*)self;
}

static int
_ostream_init(_ostream *self, PyObject *args, PyObject *kwds)
{
   const char *kwlist[] = {"file", NULL};
   char *filename;
   if (PyArg_ParseTupleAndKeywords(args, kwds, "s", (char**)kwlist, &filename))
   {
      if (self->fname != 0)
         delete self->fname;
      if (self->ostr != 0)
         delete self->ostr;
      if (self->fstr != 0)
         delete self->fstr;
      self->fname = new std::string(filename);
      self->fstr = new std::ofstream(filename);
      if (! self->fstr->good()) {
         PyErr_Format(PyExc_IOError, "Cannot open output file %s", filename);
         return -1;
      }
      try {
         self->ostr = new ostream(*self->fstr);
      }
      catch (std::exception& e) {
         PyErr_SetString(PyExc_RuntimeError, e.what());
         return -1;
      }
      return 0;
   }
   return -1; 
}

static PyObject*
_ostream_getCompression(_ostream *self, void *closure)
{
   return Py_BuildValue("i", self->ostr->getCompression());
}

static int
_ostream_setCompression(_ostream *self, PyObject *value, void *closure)
{
   if (value == NULL) {
      PyErr_SetString(PyExc_TypeError, "unexpected null argument");
      return -1;
   }
   long flags = PyInt_AsLong(value);
   if (flags == -1 && PyErr_Occurred()) {
      return -1;
   }
   try {
      self->ostr->setCompression(flags);
   }
   catch (std::exception& e) {
      PyErr_SetString(PyExc_RuntimeError, e.what());
      return -1;
   }
   return 0;
}

static PyObject*
_ostream_getIntegrityChecks(_ostream *self, void *closure)
{
   PyObject *flags = Py_BuildValue("i", self->ostr->getIntegrityChecks());
   return flags;
}

static int
_ostream_setIntegrityChecks(_ostream *self, PyObject *value, void *closure)
{
   if (value == NULL) {
      PyErr_SetString(PyExc_TypeError, "unexpected null argument");
      return -1;
   }
   long flags = PyInt_AsLong(value);
   if (flags == -1 && PyErr_Occurred()) {
      return -1;
   }
   try {
      self->ostr->setIntegrityChecks(flags);
   }
   catch (std::exception& e) {
      PyErr_SetString(PyExc_RuntimeError, e.what());
      return -1;
   }
   return 0;
}

static PyObject*
_ostream_getPosition(_ostream *self, void *closure)
{
   streamposition *pos = new streamposition();
   if (self->ostr != 0)
      *pos = self->ostr->getPosition();
   PyObject *pos_obj = _streamposition_new(&_streamposition_type, 0, 0);
   ((_streamposition*)pos_obj)->streampos = pos;
   return pos_obj;
}

static PyObject*
_ostream_getRecordsWritten(_ostream *self, void *closure)
{
   size_t records = 0;
   if (self->ostr != 0)
      try {
         records = self->ostr->getRecordsWritten();
      }
      catch (std::exception& e) {
         PyErr_SetString(PyExc_RuntimeError, e.what());
         return NULL;
      }
   return PyLong_FromLongLong(records);
}

static PyObject*
_ostream_getBytesWritten(_ostream *self, void *closure)
{
   size_t bytes = 0;
   if (self->ostr != 0)
      try {
         bytes = self->ostr->getBytesWritten();
      }
      catch (std::exception& e) {
         PyErr_SetString(PyExc_RuntimeError, e.what());
         return NULL;
      }
   return PyLong_FromLongLong(bytes);
}

static PyObject*
_ostream_write(PyObject *self, PyObject *args)
{
   _HDDM *record_obj;
   if (! PyArg_ParseTuple(args, "O!", &_HDDM_type, (PyObject*)&record_obj))
       return NULL;
   ostream *ostr = ((_ostream*)self)->ostr;
   try {
      Py_BEGIN_ALLOW_THREADS
      *ostr << *record_obj->elem;
      Py_END_ALLOW_THREADS
   }
   catch (std::exception& e) {
      PyErr_SetString(PyExc_RuntimeError, e.what());
      return NULL;
   }
   Py_INCREF(Py_None);
   return Py_None;
}

static PyObject*
_ostream_toString(PyObject *self, PyObject *args=0)
{
   std::stringstream ostr;
   if (((_ostream*)self)->fname != 0)
      ostr << "hddm_r.ostream(\""
           << *((_ostream*)self)->fname << "\")";
   else
      ostr << "hddm_r.ostream(NULL)";
   return PyUnicode_FromString(ostr.str().c_str());
}

static PyObject*
_ostream_toRepr(PyObject *self, PyObject *args=0)
{
   std::stringstream ostr;
   ostr << "\'";
   if (((_ostream*)self)->fname != 0)
      ostr << "hddm_r.ostream(\""
           << *((_ostream*)self)->fname << "\")";
   else
      ostr << "hddm_r.ostream()";
   ostr << "\'";
   return PyUnicode_FromString(ostr.str().c_str());
}

static PyGetSetDef _ostream_getsetters[] = {
   {(char*)"compression", 
    (getter)_ostream_getCompression, (setter)_ostream_setCompression,
    (char*)"ostream compression mode (k_no_compression, k_z_compression, ...)",
    NULL},
   {(char*)"integrityChecks", 
    (getter)_ostream_getIntegrityChecks, (setter)_ostream_setIntegrityChecks,
    (char*)"ostream data integrity checking mode (k_no_integrity, ...)",
    NULL},
   {(char*)"position", 
    (getter)_ostream_getPosition, 0,
    (char*)"output stream position",
    NULL},
   {(char*)"recordsWritten", 
    (getter)_ostream_getRecordsWritten, 0,
    (char*)"total records written to ostream",
    NULL},
   {(char*)"bytesWritten", 
    (getter)_ostream_getBytesWritten, 0,
    (char*)"total bytes written to ostream",
    NULL},
   {NULL}  /* Sentinel */
};

static PyMemberDef _ostream_members[] = {
   {NULL}  /* Sentinel */
};

static PyMethodDef _ostream_methods[] = {
   {"write",  _ostream_write, METH_VARARGS,
    "write a HDDM record to the output stream."},
   {NULL}  /* Sentinel */
};

static PyTypeObject _ostream_type = {
    PyVarObject_HEAD_INIT(NULL,0)
    "hddm_r.ostream",          /*tp_name*/
    sizeof(_ostream),          /*tp_basicsize*/
    0,                         /*tp_itemsize*/
    (destructor)_ostream_dealloc, /*tp_dealloc*/
    0,                         /*tp_print*/
    0,                         /*tp_getattr*/
    0,                         /*tp_setattr*/
    0,                         /*tp_compare*/
    (reprfunc)_ostream_toRepr, /*tp_repr*/
    0,                         /*tp_as_number*/
    0,                         /*tp_as_sequence*/
    0,                         /*tp_as_mapping*/
    0,                         /*tp_hash */
    0,                         /*tp_call*/
    (reprfunc)_ostream_toString, /*tp_str*/
    0,                         /*tp_getattro*/
    0,                         /*tp_setattro*/
    0,                         /*tp_as_buffer*/
    Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE, /*tp_flags*/
    "hddm_r output stream",    /* tp_doc */
    0,                         /* tp_traverse */
    0,                         /* tp_clear */
    0,                         /* tp_richcompare */
    0,                         /* tp_weaklistoffset */
    0,                         /* tp_iter */
    0,                         /* tp_iternext */
    _ostream_methods,          /* tp_methods */
    _ostream_members,          /* tp_members */
    _ostream_getsetters,       /* tp_getset */
    0,                         /* tp_base */
    0,                         /* tp_dict */
    0,                         /* tp_descr_get */
    0,                         /* tp_descr_set */
    0,                         /* tp_dictoffset */
    (initproc)_ostream_init,   /* tp_init */
    0,                         /* tp_alloc */
    _ostream_new,              /* tp_new */
};


// wrap class hddm_r::istream as hddm_r.istream

typedef struct {
   PyObject_HEAD
   std::string *fname;
   std::ifstream *fstr;
#ifdef ISTREAM_OVER_HTTP
   httpIstream *tstr;
#endif
#ifdef ISTREAM_OVER_XROOTD
   xrootdIstream *rstr;
#endif
   istream *istr;
} _istream;

static void
_istream_dealloc(_istream* self)
{
   if (self->fname != 0)
      delete self->fname;
   if (self->istr != 0)
      delete self->istr;
   if (self->fstr != 0)
      delete self->fstr;
#ifdef ISTREAM_OVER_HTTP
   if (self->tstr != 0)
      delete self->tstr;
#endif
#ifdef ISTREAM_OVER_XROOTD
   if (self->rstr != 0)
      delete self->rstr;
#endif
   Py_TYPE(self)->tp_free((PyObject*)self);
}

static PyObject*
_istream_new(PyTypeObject *type, PyObject *args, PyObject *kwds)
{
   _istream *self;
   self = (_istream*)type->tp_alloc(type, 0);
   if (self != NULL) {
      self->fname = 0;
      self->fstr = 0;
#ifdef ISTREAM_OVER_HTTP
      self->tstr = 0;
#endif
#ifdef ISTREAM_OVER_XROOTD
      self->rstr = 0;
#endif
      self->istr = 0;
   }
   return (PyObject*)self;
}

static int
_istream_init(_istream *self, PyObject *args, PyObject *kwds)
{
   const char *kwlist[] = {"file", NULL};
   char *filename;
   if (PyArg_ParseTupleAndKeywords(args, kwds, "s", (char**)kwlist, &filename))
   {
      if (self->fname != 0)
         delete self->fname;
      if (self->istr != 0)
         delete self->istr;
      if (self->fstr != 0)
         delete self->fstr;
#ifdef ISTREAM_OVER_HTTP
      if (self->tstr != 0)
         delete self->tstr;
#endif
#ifdef ISTREAM_OVER_XROOTD
      if (self->rstr != 0)
         delete self->rstr;
#endif
      self->fname = new std::string(filename);
      if (strncmp(filename, "http://", 7) == 0 || strncmp(filename, "https://", 8) == 0) {
#ifdef ISTREAM_OVER_HTTP
         try {
            self->tstr = new httpIstream(filename);
         }
         catch (const std::exception& e) {
            PyErr_Format(PyExc_IOError, e.what());
            return -1;
         }
         if (! self->tstr->good()) {
            PyErr_Format(PyExc_IOError, "Cannot open input url %s", filename);
            return -1;
         }
#else
         PyErr_Format(PyExc_IOError, "Input streaming over http[s] disabled, see build options");
         return -1;
#endif
      }
      else if (strncmp(filename, "root://", 7) == 0 || strncmp(filename, "xrootd://", 9) == 0) {
#ifdef ISTREAM_OVER_XROOTD
         try {
            self->rstr = new xrootdIstream(filename);
         }
         catch (const std::exception& e) {
            PyErr_Format(PyExc_IOError, e.what());
            return -1;
         }
         if (! self->rstr->good()) {
            PyErr_Format(PyExc_IOError, "Cannot open input url %s", filename);
            return -1;
         }
#else
         PyErr_Format(PyExc_IOError, "Input streaming over xrootd disabled, see build options");
         return -1;
#endif
      }
      else {
         self->fstr = new std::ifstream(filename);
         if (! self->fstr->good()) {
            PyErr_Format(PyExc_IOError, "Cannot open input file %s", filename);
            return -1;
         }
      }
      try {
         if (self->fstr)
            self->istr = new istream(*self->fstr);
#ifdef ISTREAM_OVER_HTTP
         else if (self->tstr)
            self->istr = new istream(*self->tstr);
#endif
#ifdef ISTREAM_OVER_XROOTD
         else if (self->rstr)
            self->istr = new istream(*self->rstr);
#endif
         else
            PyErr_Format(PyExc_IOError, "Cannot access input file %s", filename);
      }
      catch (std::exception& e) {
         PyErr_SetString(PyExc_RuntimeError, e.what());
         return -1;
      }
      return 0;
   }
   return -1; 
}

static PyObject*
_istream_getCompression(_istream *self, void *closure)
{
   return Py_BuildValue("i", self->istr->getCompression());
}

static PyObject*
_istream_getIntegrityChecks(_istream *self, void *closure)
{
   return Py_BuildValue("i", self->istr->getIntegrityChecks());
}

static PyObject*
_istream_getPosition(_istream *self, void *closure)
{
   streamposition *pos = new streamposition();
   if (self->istr != 0)
      try {
         *pos = self->istr->getPosition();
      }
      catch (std::exception& e) {
         PyErr_SetString(PyExc_RuntimeError, e.what());
         return NULL;
      }
   PyObject *pos_obj = _streamposition_new(&_streamposition_type, 0, 0);
   ((_streamposition*)pos_obj)->streampos = pos;
   return pos_obj;
}

static int
_istream_setPosition(_istream *self, PyObject *value, void *closure)
{
   if (Py_TYPE(value) != &_streamposition_type)
   {
      PyErr_SetString(PyExc_TypeError, "unexpected argument type");
      return -1;
   }
   streamposition *pos = ((_streamposition*)value)->streampos;
   if (pos == 0) {
      PyErr_SetString(PyExc_TypeError, "unexpected null argument");
      return -1;
   }
   try {
      self->istr->setPosition(*pos);
   }
   catch (std::exception& e) {
      PyErr_SetString(PyExc_RuntimeError, e.what());
      return -1;
   }
   return 0;
}

static PyObject*
_istream_getRecordsRead(_istream *self, void *closure)
{
   size_t records = 0;
   if (self->istr != 0)
      try {
         records = self->istr->getRecordsRead();
      }
      catch (std::exception& e) {
         PyErr_SetString(PyExc_RuntimeError, e.what());
         return NULL;
      }
   return PyLong_FromLongLong(records);
}

static PyObject*
_istream_getBytesRead(_istream *self, void *closure)
{
   size_t bytes = 0;
   if (self->istr != 0)
      try {
         bytes = self->istr->getBytesRead();
      }
      catch (std::exception& e) {
         PyErr_SetString(PyExc_RuntimeError, e.what());
         return NULL;
      }
   return PyLong_FromLongLong(bytes);
}

static PyObject*
_istream_skip(PyObject *self, PyObject *args)
{
   int count=0;
   if (! PyArg_ParseTuple(args, "I", &count)) {
      PyErr_SetString(PyExc_TypeError, "missing argument in skip");
      return NULL;
   }
   else if (count < 0) {
      PyErr_SetString(PyExc_TypeError, "skip count cannot be negative");
      return NULL;
   }
   istream *istr = ((_istream*)self)->istr;
   if (istr == 0) {
      PyErr_SetString(PyExc_TypeError, "unexpected null istream ptr");
      return NULL;
   }
   istr->skip(count);
   return PyLong_FromLong(0);
}

static PyObject*
_istream_read(PyObject *self, PyObject *args)
{
   istream *istr = ((_istream*)self)->istr;
   if (istr == 0) {
      PyErr_SetString(PyExc_TypeError, "unexpected null input stream");
      return NULL;
   }
   _HDDM *record_obj = (_HDDM*)_HDDM_new(&_HDDM_type, 0, 0);
   record_obj->elem = new HDDM();
   record_obj->host = (P