<!-- markdownlint-disable -->
<div align="center">
<h1>GHASToolkit</h1>
<img src="https://raw.githubusercontent.com/GeekMasher/ghastoolkit/main/docs/static/ghastoolkit.png" />

[![GitHub](https://img.shields.io/badge/github-%23121011.svg?style=for-the-badge&logo=github&logoColor=white)][github]
[![GitHub Actions](https://img.shields.io/github/actions/workflow/status/geekmasher/ghastoolkit/python-package.yml?style=for-the-badge)][github]
[![GitHub Issues](https://img.shields.io/github/issues/geekmasher/ghastoolkit?style=for-the-badge)][github-issues]
[![GitHub Stars](https://img.shields.io/github/stars/geekmasher/ghastoolkit?style=for-the-badge)][github]
[![Python Versions](https://img.shields.io/pypi/pyversions/ghastoolkit?style=for-the-badge)][pypi]
[![License](https://img.shields.io/github/license/Ileriayo/markdown-badges?style=for-the-badge)][license]

</div>
<!-- markdownlint-restore -->

## Overview

[GitHub Advanced Security (GHAS)][advanced-security] Python Toolkit to make the lives of everyone that uses GHAS a little easier.

## ✨ Features

- API Client for all GHAS Features
  - Code Scanning
  - Secret Scanning
  - Dependency Graph
  - Security Advisories
  - Dependabot / Security Alerts
- CodeQL Management
  - Database Management
  - Packs / Query Management

## 📦 Installing

To install `ghastoolkit`, you can use `pip` or one of `pypi` family's of tools to install:

```bash
# pip 
pip install ghastoolkit

# pipenv
pipenv install ghastoolkit

# poetry
poetry add ghastoolkit
```

## 🏃 Usage

To see how to use `ghastoolkit`, [take a look at the docs][docs].

## 🧑‍🤝‍🧑 Maintainers / Contributors

<!-- ALL-CONTRIBUTORS-LIST:START - Do not remove or modify this section -->
<!-- prettier-ignore-start -->
<!-- markdownlint-disable -->

<!-- markdownlint-restore -->
<!-- prettier-ignore-end -->

<!-- ALL-CONTRIBUTORS-LIST:END -->

## 🦸 Support

Please create [GitHub Issues][github-issues] if there are bugs or feature requests.

This project uses [Semantic Versioning (v2)][semver] and with major releases, breaking changes will occur.

## 📓 License

This project is licensed under the terms of the MIT open source license.
Please refer to [MIT][license] for the full terms.

<!-- Resources -->

[license]: ./LICENSE
[pypi]: https://pypi.org/project/ghastoolkit
[github]: https://github.com/GeekMasher/ghastoolkit
[github-issues]: https://github.com/GeekMasher/ghastoolkit/issues

[docs]: https://geekmasher.github.io/ghastoolkit
[advanced-security]: https://github.com/features/security

[semver]: https://semver.org/
