"""SplineHalfDesign"""

from __future__ import annotations

from typing import TYPE_CHECKING, TypeVar, Union, Tuple

from mastapy._internal.type_enforcement import enforce_parameter_types
from mastapy._internal import constructor, conversion
from mastapy._internal.implicit import overridable
from mastapy._internal.overridable_constructor import _unpack_overridable
from mastapy.detailed_rigid_connectors import _1387
from mastapy._internal.cast_exception import CastException
from mastapy._internal.python_net import python_net_import

_SPLINE_HALF_DESIGN = python_net_import(
    "SMT.MastaAPI.DetailedRigidConnectors.Splines", "SplineHalfDesign"
)

if TYPE_CHECKING:
    from mastapy.detailed_rigid_connectors.splines import _1397, _1414
    from mastapy.detailed_rigid_connectors.splines.tolerances_and_deviations import (
        _1420,
    )


__docformat__ = "restructuredtext en"
__all__ = ("SplineHalfDesign",)


Self = TypeVar("Self", bound="SplineHalfDesign")


class SplineHalfDesign(_1387.DetailedRigidConnectorHalfDesign):
    """SplineHalfDesign

    This is a mastapy class.
    """

    TYPE = _SPLINE_HALF_DESIGN
    _CastSelf = TypeVar("_CastSelf", bound="_Cast_SplineHalfDesign")

    class _Cast_SplineHalfDesign:
        """Special nested class for casting SplineHalfDesign to subclasses."""

        def __init__(
            self: "SplineHalfDesign._Cast_SplineHalfDesign", parent: "SplineHalfDesign"
        ):
            self._parent = parent

        @property
        def detailed_rigid_connector_half_design(
            self: "SplineHalfDesign._Cast_SplineHalfDesign",
        ):
            return self._parent._cast(_1387.DetailedRigidConnectorHalfDesign)

        @property
        def custom_spline_half_design(self: "SplineHalfDesign._Cast_SplineHalfDesign"):
            from mastapy.detailed_rigid_connectors.splines import _1388

            return self._parent._cast(_1388.CustomSplineHalfDesign)

        @property
        def din5480_spline_half_design(self: "SplineHalfDesign._Cast_SplineHalfDesign"):
            from mastapy.detailed_rigid_connectors.splines import _1391

            return self._parent._cast(_1391.DIN5480SplineHalfDesign)

        @property
        def gbt3478_spline_half_design(self: "SplineHalfDesign._Cast_SplineHalfDesign"):
            from mastapy.detailed_rigid_connectors.splines import _1395

            return self._parent._cast(_1395.GBT3478SplineHalfDesign)

        @property
        def iso4156_spline_half_design(self: "SplineHalfDesign._Cast_SplineHalfDesign"):
            from mastapy.detailed_rigid_connectors.splines import _1398

            return self._parent._cast(_1398.ISO4156SplineHalfDesign)

        @property
        def sae_spline_half_design(self: "SplineHalfDesign._Cast_SplineHalfDesign"):
            from mastapy.detailed_rigid_connectors.splines import _1406

            return self._parent._cast(_1406.SAESplineHalfDesign)

        @property
        def standard_spline_half_design(
            self: "SplineHalfDesign._Cast_SplineHalfDesign",
        ):
            from mastapy.detailed_rigid_connectors.splines import _1418

            return self._parent._cast(_1418.StandardSplineHalfDesign)

        @property
        def spline_half_design(
            self: "SplineHalfDesign._Cast_SplineHalfDesign",
        ) -> "SplineHalfDesign":
            return self._parent

        def __getattr__(self: "SplineHalfDesign._Cast_SplineHalfDesign", name: str):
            try:
                return self.__dict__[name]
            except KeyError:
                class_name = "".join(n.capitalize() for n in name.split("_"))
                raise CastException(
                    f'Detected an invalid cast. Cannot cast to type "{class_name}"'
                ) from None

    def __init__(self: Self, instance_to_wrap: "SplineHalfDesign.TYPE"):
        super().__init__(instance_to_wrap)
        self._freeze()

    @property
    def allowable_bending_stress(self: Self) -> "float":
        """float"""
        temp = self.wrapped.AllowableBendingStress

        if temp is None:
            return 0.0

        return temp

    @allowable_bending_stress.setter
    @enforce_parameter_types
    def allowable_bending_stress(self: Self, value: "float"):
        self.wrapped.AllowableBendingStress = float(value) if value is not None else 0.0

    @property
    def allowable_bursting_stress(self: Self) -> "float":
        """float"""
        temp = self.wrapped.AllowableBurstingStress

        if temp is None:
            return 0.0

        return temp

    @allowable_bursting_stress.setter
    @enforce_parameter_types
    def allowable_bursting_stress(self: Self, value: "float"):
        self.wrapped.AllowableBurstingStress = (
            float(value) if value is not None else 0.0
        )

    @property
    def allowable_compressive_stress(self: Self) -> "float":
        """float"""
        temp = self.wrapped.AllowableCompressiveStress

        if temp is None:
            return 0.0

        return temp

    @allowable_compressive_stress.setter
    @enforce_parameter_types
    def allowable_compressive_stress(self: Self, value: "float"):
        self.wrapped.AllowableCompressiveStress = (
            float(value) if value is not None else 0.0
        )

    @property
    def allowable_contact_stress(self: Self) -> "float":
        """float"""
        temp = self.wrapped.AllowableContactStress

        if temp is None:
            return 0.0

        return temp

    @allowable_contact_stress.setter
    @enforce_parameter_types
    def allowable_contact_stress(self: Self, value: "float"):
        self.wrapped.AllowableContactStress = float(value) if value is not None else 0.0

    @property
    def allowable_shear_stress(self: Self) -> "float":
        """float"""
        temp = self.wrapped.AllowableShearStress

        if temp is None:
            return 0.0

        return temp

    @allowable_shear_stress.setter
    @enforce_parameter_types
    def allowable_shear_stress(self: Self, value: "float"):
        self.wrapped.AllowableShearStress = float(value) if value is not None else 0.0

    @property
    def ball_or_pin_diameter(self: Self) -> "overridable.Overridable_float":
        """Overridable[float]"""
        temp = self.wrapped.BallOrPinDiameter

        if temp is None:
            return 0.0

        return constructor.new_from_mastapy(
            "mastapy._internal.implicit.overridable", "Overridable_float"
        )(temp)

    @ball_or_pin_diameter.setter
    @enforce_parameter_types
    def ball_or_pin_diameter(self: Self, value: "Union[float, Tuple[float, bool]]"):
        wrapper_type = overridable.Overridable_float.wrapper_type()
        enclosed_type = overridable.Overridable_float.implicit_type()
        value, is_overridden = _unpack_overridable(value)
        value = wrapper_type[enclosed_type](
            enclosed_type(value) if value is not None else 0.0, is_overridden
        )
        self.wrapped.BallOrPinDiameter = value

    @property
    def base_diameter(self: Self) -> "float":
        """float

        Note:
            This property is readonly.
        """
        temp = self.wrapped.BaseDiameter

        if temp is None:
            return 0.0

        return temp

    @property
    def core_hardness_h_rc(self: Self) -> "float":
        """float"""
        temp = self.wrapped.CoreHardnessHRc

        if temp is None:
            return 0.0

        return temp

    @core_hardness_h_rc.setter
    @enforce_parameter_types
    def core_hardness_h_rc(self: Self, value: "float"):
        self.wrapped.CoreHardnessHRc = float(value) if value is not None else 0.0

    @property
    def designation(self: Self) -> "str":
        """str

        Note:
            This property is readonly.
        """
        temp = self.wrapped.Designation

        if temp is None:
            return ""

        return temp

    @property
    def form_diameter(self: Self) -> "float":
        """float

        Note:
            This property is readonly.
        """
        temp = self.wrapped.FormDiameter

        if temp is None:
            return 0.0

        return temp

    @property
    def heat_treatment(self: Self) -> "_1397.HeatTreatmentTypes":
        """mastapy.detailed_rigid_connectors.splines.HeatTreatmentTypes"""
        temp = self.wrapped.HeatTreatment

        if temp is None:
            return None

        value = conversion.pn_to_mp_enum(
            temp, "SMT.MastaAPI.DetailedRigidConnectors.Splines.HeatTreatmentTypes"
        )

        if value is None:
            return None

        return constructor.new_from_mastapy(
            "mastapy.detailed_rigid_connectors.splines._1397", "HeatTreatmentTypes"
        )(value)

    @heat_treatment.setter
    @enforce_parameter_types
    def heat_treatment(self: Self, value: "_1397.HeatTreatmentTypes"):
        value = conversion.mp_to_pn_enum(
            value, "SMT.MastaAPI.DetailedRigidConnectors.Splines.HeatTreatmentTypes"
        )
        self.wrapped.HeatTreatment = value

    @property
    def major_diameter(self: Self) -> "float":
        """float

        Note:
            This property is readonly.
        """
        temp = self.wrapped.MajorDiameter

        if temp is None:
            return 0.0

        return temp

    @property
    def maximum_actual_space_width(self: Self) -> "float":
        """float"""
        temp = self.wrapped.MaximumActualSpaceWidth

        if temp is None:
            return 0.0

        return temp

    @maximum_actual_space_width.setter
    @enforce_parameter_types
    def maximum_actual_space_width(self: Self, value: "float"):
        self.wrapped.MaximumActualSpaceWidth = (
            float(value) if value is not None else 0.0
        )

    @property
    def maximum_actual_tooth_thickness(self: Self) -> "float":
        """float"""
        temp = self.wrapped.MaximumActualToothThickness

        if temp is None:
            return 0.0

        return temp

    @maximum_actual_tooth_thickness.setter
    @enforce_parameter_types
    def maximum_actual_tooth_thickness(self: Self, value: "float"):
        self.wrapped.MaximumActualToothThickness = (
            float(value) if value is not None else 0.0
        )

    @property
    def maximum_chordal_span_over_teeth(self: Self) -> "float":
        """float"""
        temp = self.wrapped.MaximumChordalSpanOverTeeth

        if temp is None:
            return 0.0

        return temp

    @maximum_chordal_span_over_teeth.setter
    @enforce_parameter_types
    def maximum_chordal_span_over_teeth(self: Self, value: "float"):
        self.wrapped.MaximumChordalSpanOverTeeth = (
            float(value) if value is not None else 0.0
        )

    @property
    def maximum_dimension_over_balls(self: Self) -> "float":
        """float"""
        temp = self.wrapped.MaximumDimensionOverBalls

        if temp is None:
            return 0.0

        return temp

    @maximum_dimension_over_balls.setter
    @enforce_parameter_types
    def maximum_dimension_over_balls(self: Self, value: "float"):
        self.wrapped.MaximumDimensionOverBalls = (
            float(value) if value is not None else 0.0
        )

    @property
    def maximum_effective_tooth_thickness(self: Self) -> "float":
        """float"""
        temp = self.wrapped.MaximumEffectiveToothThickness

        if temp is None:
            return 0.0

        return temp

    @maximum_effective_tooth_thickness.setter
    @enforce_parameter_types
    def maximum_effective_tooth_thickness(self: Self, value: "float"):
        self.wrapped.MaximumEffectiveToothThickness = (
            float(value) if value is not None else 0.0
        )

    @property
    def maximum_major_diameter(self: Self) -> "float":
        """float

        Note:
            This property is readonly.
        """
        temp = self.wrapped.MaximumMajorDiameter

        if temp is None:
            return 0.0

        return temp

    @property
    def maximum_minor_diameter(self: Self) -> "float":
        """float

        Note:
            This property is readonly.
        """
        temp = self.wrapped.MaximumMinorDiameter

        if temp is None:
            return 0.0

        return temp

    @property
    def mean_actual_space_width(self: Self) -> "float":
        """float

        Note:
            This property is readonly.
        """
        temp = self.wrapped.MeanActualSpaceWidth

        if temp is None:
            return 0.0

        return temp

    @property
    def mean_actual_tooth_thickness(self: Self) -> "float":
        """float

        Note:
            This property is readonly.
        """
        temp = self.wrapped.MeanActualToothThickness

        if temp is None:
            return 0.0

        return temp

    @property
    def minimum_actual_space_width(self: Self) -> "float":
        """float"""
        temp = self.wrapped.MinimumActualSpaceWidth

        if temp is None:
            return 0.0

        return temp

    @minimum_actual_space_width.setter
    @enforce_parameter_types
    def minimum_actual_space_width(self: Self, value: "float"):
        self.wrapped.MinimumActualSpaceWidth = (
            float(value) if value is not None else 0.0
        )

    @property
    def minimum_actual_tooth_thickness(self: Self) -> "float":
        """float"""
        temp = self.wrapped.MinimumActualToothThickness

        if temp is None:
            return 0.0

        return temp

    @minimum_actual_tooth_thickness.setter
    @enforce_parameter_types
    def minimum_actual_tooth_thickness(self: Self, value: "float"):
        self.wrapped.MinimumActualToothThickness = (
            float(value) if value is not None else 0.0
        )

    @property
    def minimum_chordal_span_over_teeth(self: Self) -> "float":
        """float"""
        temp = self.wrapped.MinimumChordalSpanOverTeeth

        if temp is None:
            return 0.0

        return temp

    @minimum_chordal_span_over_teeth.setter
    @enforce_parameter_types
    def minimum_chordal_span_over_teeth(self: Self, value: "float"):
        self.wrapped.MinimumChordalSpanOverTeeth = (
            float(value) if value is not None else 0.0
        )

    @property
    def minimum_dimension_over_balls(self: Self) -> "float":
        """float"""
        temp = self.wrapped.MinimumDimensionOverBalls

        if temp is None:
            return 0.0

        return temp

    @minimum_dimension_over_balls.setter
    @enforce_parameter_types
    def minimum_dimension_over_balls(self: Self, value: "float"):
        self.wrapped.MinimumDimensionOverBalls = (
            float(value) if value is not None else 0.0
        )

    @property
    def minimum_effective_space_width(self: Self) -> "float":
        """float"""
        temp = self.wrapped.MinimumEffectiveSpaceWidth

        if temp is None:
            return 0.0

        return temp

    @minimum_effective_space_width.setter
    @enforce_parameter_types
    def minimum_effective_space_width(self: Self, value: "float"):
        self.wrapped.MinimumEffectiveSpaceWidth = (
            float(value) if value is not None else 0.0
        )

    @property
    def minimum_major_diameter(self: Self) -> "float":
        """float

        Note:
            This property is readonly.
        """
        temp = self.wrapped.MinimumMajorDiameter

        if temp is None:
            return 0.0

        return temp

    @property
    def minimum_minor_diameter(self: Self) -> "float":
        """float

        Note:
            This property is readonly.
        """
        temp = self.wrapped.MinimumMinorDiameter

        if temp is None:
            return 0.0

        return temp

    @property
    def minor_diameter(self: Self) -> "float":
        """float

        Note:
            This property is readonly.
        """
        temp = self.wrapped.MinorDiameter

        if temp is None:
            return 0.0

        return temp

    @property
    def name(self: Self) -> "str":
        """str

        Note:
            This property is readonly.
        """
        temp = self.wrapped.Name

        if temp is None:
            return ""

        return temp

    @property
    def nominal_chordal_span_over_teeth(self: Self) -> "float":
        """float

        Note:
            This property is readonly.
        """
        temp = self.wrapped.NominalChordalSpanOverTeeth

        if temp is None:
            return 0.0

        return temp

    @property
    def nominal_dimension_over_balls(self: Self) -> "float":
        """float

        Note:
            This property is readonly.
        """
        temp = self.wrapped.NominalDimensionOverBalls

        if temp is None:
            return 0.0

        return temp

    @property
    def number_of_teeth_for_chordal_span_test(
        self: Self,
    ) -> "overridable.Overridable_float":
        """Overridable[float]"""
        temp = self.wrapped.NumberOfTeethForChordalSpanTest

        if temp is None:
            return 0.0

        return constructor.new_from_mastapy(
            "mastapy._internal.implicit.overridable", "Overridable_float"
        )(temp)

    @number_of_teeth_for_chordal_span_test.setter
    @enforce_parameter_types
    def number_of_teeth_for_chordal_span_test(
        self: Self, value: "Union[float, Tuple[float, bool]]"
    ):
        wrapper_type = overridable.Overridable_float.wrapper_type()
        enclosed_type = overridable.Overridable_float.implicit_type()
        value, is_overridden = _unpack_overridable(value)
        value = wrapper_type[enclosed_type](
            enclosed_type(value) if value is not None else 0.0, is_overridden
        )
        self.wrapped.NumberOfTeethForChordalSpanTest = value

    @property
    def pointed_flank_diameter(self: Self) -> "float":
        """float

        Note:
            This property is readonly.
        """
        temp = self.wrapped.PointedFlankDiameter

        if temp is None:
            return 0.0

        return temp

    @property
    def root_fillet_radius(self: Self) -> "float":
        """float"""
        temp = self.wrapped.RootFilletRadius

        if temp is None:
            return 0.0

        return temp

    @root_fillet_radius.setter
    @enforce_parameter_types
    def root_fillet_radius(self: Self, value: "float"):
        self.wrapped.RootFilletRadius = float(value) if value is not None else 0.0

    @property
    def root_fillet_radius_factor(self: Self) -> "float":
        """float"""
        temp = self.wrapped.RootFilletRadiusFactor

        if temp is None:
            return 0.0

        return temp

    @root_fillet_radius_factor.setter
    @enforce_parameter_types
    def root_fillet_radius_factor(self: Self, value: "float"):
        self.wrapped.RootFilletRadiusFactor = float(value) if value is not None else 0.0

    @property
    def surface_hardness_h_rc(self: Self) -> "float":
        """float"""
        temp = self.wrapped.SurfaceHardnessHRc

        if temp is None:
            return 0.0

        return temp

    @surface_hardness_h_rc.setter
    @enforce_parameter_types
    def surface_hardness_h_rc(self: Self, value: "float"):
        self.wrapped.SurfaceHardnessHRc = float(value) if value is not None else 0.0

    @property
    def theoretical_dimension_over_balls(self: Self) -> "float":
        """float

        Note:
            This property is readonly.
        """
        temp = self.wrapped.TheoreticalDimensionOverBalls

        if temp is None:
            return 0.0

        return temp

    @property
    def tooth_height(self: Self) -> "float":
        """float

        Note:
            This property is readonly.
        """
        temp = self.wrapped.ToothHeight

        if temp is None:
            return 0.0

        return temp

    @property
    def fit_and_tolerance(self: Self) -> "_1420.FitAndTolerance":
        """mastapy.detailed_rigid_connectors.splines.tolerances_and_deviations.FitAndTolerance

        Note:
            This property is readonly.
        """
        temp = self.wrapped.FitAndTolerance

        if temp is None:
            return None

        type_ = temp.GetType()
        return constructor.new(type_.Namespace, type_.Name)(temp)

    @property
    def spline_joint_design(self: Self) -> "_1414.SplineJointDesign":
        """mastapy.detailed_rigid_connectors.splines.SplineJointDesign

        Note:
            This property is readonly.
        """
        temp = self.wrapped.SplineJointDesign

        if temp is None:
            return None

        type_ = temp.GetType()
        return constructor.new(type_.Namespace, type_.Name)(temp)

    @property
    def cast_to(self: Self) -> "SplineHalfDesign._Cast_SplineHalfDesign":
        return self._Cast_SplineHalfDesign(self)
