"""WormGrindingProcessProfileCalculation"""

from __future__ import annotations

from typing import TYPE_CHECKING, TypeVar

from mastapy._internal.type_enforcement import enforce_parameter_types
from mastapy._internal import constructor, conversion
from mastapy.gears.manufacturing.cylindrical.hobbing_process_simulation_new import _694
from mastapy._internal.cast_exception import CastException
from mastapy._internal.python_net import python_net_import

_WORM_GRINDING_PROCESS_PROFILE_CALCULATION = python_net_import(
    "SMT.MastaAPI.Gears.Manufacturing.Cylindrical.HobbingProcessSimulationNew",
    "WormGrindingProcessProfileCalculation",
)

if TYPE_CHECKING:
    from mastapy.gears.gear_designs.cylindrical import _1026
    from mastapy.utility_gui.charts import _1867
    from mastapy.gears.manufacturing.cylindrical.hobbing_process_simulation_new import (
        _662,
    )


__docformat__ = "restructuredtext en"
__all__ = ("WormGrindingProcessProfileCalculation",)


Self = TypeVar("Self", bound="WormGrindingProcessProfileCalculation")


class WormGrindingProcessProfileCalculation(_694.WormGrindingProcessCalculation):
    """WormGrindingProcessProfileCalculation

    This is a mastapy class.
    """

    TYPE = _WORM_GRINDING_PROCESS_PROFILE_CALCULATION
    _CastSelf = TypeVar(
        "_CastSelf", bound="_Cast_WormGrindingProcessProfileCalculation"
    )

    class _Cast_WormGrindingProcessProfileCalculation:
        """Special nested class for casting WormGrindingProcessProfileCalculation to subclasses."""

        def __init__(
            self: "WormGrindingProcessProfileCalculation._Cast_WormGrindingProcessProfileCalculation",
            parent: "WormGrindingProcessProfileCalculation",
        ):
            self._parent = parent

        @property
        def worm_grinding_process_calculation(
            self: "WormGrindingProcessProfileCalculation._Cast_WormGrindingProcessProfileCalculation",
        ):
            return self._parent._cast(_694.WormGrindingProcessCalculation)

        @property
        def process_calculation(
            self: "WormGrindingProcessProfileCalculation._Cast_WormGrindingProcessProfileCalculation",
        ):
            from mastapy.gears.manufacturing.cylindrical.hobbing_process_simulation_new import (
                _680,
            )

            return self._parent._cast(_680.ProcessCalculation)

        @property
        def worm_grinding_process_profile_calculation(
            self: "WormGrindingProcessProfileCalculation._Cast_WormGrindingProcessProfileCalculation",
        ) -> "WormGrindingProcessProfileCalculation":
            return self._parent

        def __getattr__(
            self: "WormGrindingProcessProfileCalculation._Cast_WormGrindingProcessProfileCalculation",
            name: str,
        ):
            try:
                return self.__dict__[name]
            except KeyError:
                class_name = "".join(n.capitalize() for n in name.split("_"))
                raise CastException(
                    f'Detected an invalid cast. Cannot cast to type "{class_name}"'
                ) from None

    def __init__(
        self: Self, instance_to_wrap: "WormGrindingProcessProfileCalculation.TYPE"
    ):
        super().__init__(instance_to_wrap)
        self._freeze()

    @property
    def chart_display_method(
        self: Self,
    ) -> "_1026.CylindricalGearProfileMeasurementType":
        """mastapy.gears.gear_designs.cylindrical.CylindricalGearProfileMeasurementType"""
        temp = self.wrapped.ChartDisplayMethod

        if temp is None:
            return None

        value = conversion.pn_to_mp_enum(
            temp,
            "SMT.MastaAPI.Gears.GearDesigns.Cylindrical.CylindricalGearProfileMeasurementType",
        )

        if value is None:
            return None

        return constructor.new_from_mastapy(
            "mastapy.gears.gear_designs.cylindrical._1026",
            "CylindricalGearProfileMeasurementType",
        )(value)

    @chart_display_method.setter
    @enforce_parameter_types
    def chart_display_method(
        self: Self, value: "_1026.CylindricalGearProfileMeasurementType"
    ):
        value = conversion.mp_to_pn_enum(
            value,
            "SMT.MastaAPI.Gears.GearDesigns.Cylindrical.CylindricalGearProfileMeasurementType",
        )
        self.wrapped.ChartDisplayMethod = value

    @property
    def left_flank_profile_modification_chart(
        self: Self,
    ) -> "_1867.TwoDChartDefinition":
        """mastapy.utility_gui.charts.TwoDChartDefinition

        Note:
            This property is readonly.
        """
        temp = self.wrapped.LeftFlankProfileModificationChart

        if temp is None:
            return None

        type_ = temp.GetType()
        return constructor.new(type_.Namespace, type_.Name)(temp)

    @property
    def number_of_profile_bands(self: Self) -> "int":
        """int"""
        temp = self.wrapped.NumberOfProfileBands

        if temp is None:
            return 0

        return temp

    @number_of_profile_bands.setter
    @enforce_parameter_types
    def number_of_profile_bands(self: Self, value: "int"):
        self.wrapped.NumberOfProfileBands = int(value) if value is not None else 0

    @property
    def result_z_plane(self: Self) -> "float":
        """float"""
        temp = self.wrapped.ResultZPlane

        if temp is None:
            return 0.0

        return temp

    @result_z_plane.setter
    @enforce_parameter_types
    def result_z_plane(self: Self, value: "float"):
        self.wrapped.ResultZPlane = float(value) if value is not None else 0.0

    @property
    def right_flank_profile_modification_chart(
        self: Self,
    ) -> "_1867.TwoDChartDefinition":
        """mastapy.utility_gui.charts.TwoDChartDefinition

        Note:
            This property is readonly.
        """
        temp = self.wrapped.RightFlankProfileModificationChart

        if temp is None:
            return None

        type_ = temp.GetType()
        return constructor.new(type_.Namespace, type_.Name)(temp)

    @property
    def left_flank(self: Self) -> "_662.CalculateProfileDeviationAccuracy":
        """mastapy.gears.manufacturing.cylindrical.hobbing_process_simulation_new.CalculateProfileDeviationAccuracy

        Note:
            This property is readonly.
        """
        temp = self.wrapped.LeftFlank

        if temp is None:
            return None

        type_ = temp.GetType()
        return constructor.new(type_.Namespace, type_.Name)(temp)

    @property
    def right_flank(self: Self) -> "_662.CalculateProfileDeviationAccuracy":
        """mastapy.gears.manufacturing.cylindrical.hobbing_process_simulation_new.CalculateProfileDeviationAccuracy

        Note:
            This property is readonly.
        """
        temp = self.wrapped.RightFlank

        if temp is None:
            return None

        type_ = temp.GetType()
        return constructor.new(type_.Namespace, type_.Name)(temp)

    @property
    def cast_to(
        self: Self,
    ) -> "WormGrindingProcessProfileCalculation._Cast_WormGrindingProcessProfileCalculation":
        return self._Cast_WormGrindingProcessProfileCalculation(self)
