"""OilSealModalAnalysis"""

from __future__ import annotations

from typing import TYPE_CHECKING, TypeVar

from mastapy._internal import constructor
from mastapy.system_model.analyses_and_results.modal_analyses import _4608
from mastapy._internal.cast_exception import CastException
from mastapy._internal.python_net import python_net_import

_OIL_SEAL_MODAL_ANALYSIS = python_net_import(
    "SMT.MastaAPI.SystemModel.AnalysesAndResults.ModalAnalyses", "OilSealModalAnalysis"
)

if TYPE_CHECKING:
    from mastapy.system_model.part_model import _2466
    from mastapy.system_model.analyses_and_results.static_loads import _6927
    from mastapy.system_model.analyses_and_results.system_deflections import _2784


__docformat__ = "restructuredtext en"
__all__ = ("OilSealModalAnalysis",)


Self = TypeVar("Self", bound="OilSealModalAnalysis")


class OilSealModalAnalysis(_4608.ConnectorModalAnalysis):
    """OilSealModalAnalysis

    This is a mastapy class.
    """

    TYPE = _OIL_SEAL_MODAL_ANALYSIS
    _CastSelf = TypeVar("_CastSelf", bound="_Cast_OilSealModalAnalysis")

    class _Cast_OilSealModalAnalysis:
        """Special nested class for casting OilSealModalAnalysis to subclasses."""

        def __init__(
            self: "OilSealModalAnalysis._Cast_OilSealModalAnalysis",
            parent: "OilSealModalAnalysis",
        ):
            self._parent = parent

        @property
        def connector_modal_analysis(
            self: "OilSealModalAnalysis._Cast_OilSealModalAnalysis",
        ):
            return self._parent._cast(_4608.ConnectorModalAnalysis)

        @property
        def mountable_component_modal_analysis(
            self: "OilSealModalAnalysis._Cast_OilSealModalAnalysis",
        ):
            from mastapy.system_model.analyses_and_results.modal_analyses import _4658

            return self._parent._cast(_4658.MountableComponentModalAnalysis)

        @property
        def component_modal_analysis(
            self: "OilSealModalAnalysis._Cast_OilSealModalAnalysis",
        ):
            from mastapy.system_model.analyses_and_results.modal_analyses import _4597

            return self._parent._cast(_4597.ComponentModalAnalysis)

        @property
        def part_modal_analysis(
            self: "OilSealModalAnalysis._Cast_OilSealModalAnalysis",
        ):
            from mastapy.system_model.analyses_and_results.modal_analyses import _4662

            return self._parent._cast(_4662.PartModalAnalysis)

        @property
        def part_static_load_analysis_case(
            self: "OilSealModalAnalysis._Cast_OilSealModalAnalysis",
        ):
            from mastapy.system_model.analyses_and_results.analysis_cases import _7548

            return self._parent._cast(_7548.PartStaticLoadAnalysisCase)

        @property
        def part_analysis_case(self: "OilSealModalAnalysis._Cast_OilSealModalAnalysis"):
            from mastapy.system_model.analyses_and_results.analysis_cases import _7545

            return self._parent._cast(_7545.PartAnalysisCase)

        @property
        def part_analysis(self: "OilSealModalAnalysis._Cast_OilSealModalAnalysis"):
            from mastapy.system_model.analyses_and_results import _2657

            return self._parent._cast(_2657.PartAnalysis)

        @property
        def design_entity_single_context_analysis(
            self: "OilSealModalAnalysis._Cast_OilSealModalAnalysis",
        ):
            from mastapy.system_model.analyses_and_results import _2653

            return self._parent._cast(_2653.DesignEntitySingleContextAnalysis)

        @property
        def design_entity_analysis(
            self: "OilSealModalAnalysis._Cast_OilSealModalAnalysis",
        ):
            from mastapy.system_model.analyses_and_results import _2651

            return self._parent._cast(_2651.DesignEntityAnalysis)

        @property
        def oil_seal_modal_analysis(
            self: "OilSealModalAnalysis._Cast_OilSealModalAnalysis",
        ) -> "OilSealModalAnalysis":
            return self._parent

        def __getattr__(
            self: "OilSealModalAnalysis._Cast_OilSealModalAnalysis", name: str
        ):
            try:
                return self.__dict__[name]
            except KeyError:
                class_name = "".join(n.capitalize() for n in name.split("_"))
                raise CastException(
                    f'Detected an invalid cast. Cannot cast to type "{class_name}"'
                ) from None

    def __init__(self: Self, instance_to_wrap: "OilSealModalAnalysis.TYPE"):
        super().__init__(instance_to_wrap)
        self._freeze()

    @property
    def component_design(self: Self) -> "_2466.OilSeal":
        """mastapy.system_model.part_model.OilSeal

        Note:
            This property is readonly.
        """
        temp = self.wrapped.ComponentDesign

        if temp is None:
            return None

        type_ = temp.GetType()
        return constructor.new(type_.Namespace, type_.Name)(temp)

    @property
    def component_load_case(self: Self) -> "_6927.OilSealLoadCase":
        """mastapy.system_model.analyses_and_results.static_loads.OilSealLoadCase

        Note:
            This property is readonly.
        """
        temp = self.wrapped.ComponentLoadCase

        if temp is None:
            return None

        type_ = temp.GetType()
        return constructor.new(type_.Namespace, type_.Name)(temp)

    @property
    def system_deflection_results(self: Self) -> "_2784.OilSealSystemDeflection":
        """mastapy.system_model.analyses_and_results.system_deflections.OilSealSystemDeflection

        Note:
            This property is readonly.
        """
        temp = self.wrapped.SystemDeflectionResults

        if temp is None:
            return None

        type_ = temp.GetType()
        return constructor.new(type_.Namespace, type_.Name)(temp)

    @property
    def cast_to(self: Self) -> "OilSealModalAnalysis._Cast_OilSealModalAnalysis":
        return self._Cast_OilSealModalAnalysis(self)
