"""GuideDxfModelModalAnalysisAtAStiffness"""

from __future__ import annotations

from typing import TYPE_CHECKING, TypeVar

from mastapy._internal import constructor
from mastapy.system_model.analyses_and_results.modal_analyses_at_a_stiffness import (
    _4882,
)
from mastapy._internal.cast_exception import CastException
from mastapy._internal.python_net import python_net_import

_GUIDE_DXF_MODEL_MODAL_ANALYSIS_AT_A_STIFFNESS = python_net_import(
    "SMT.MastaAPI.SystemModel.AnalysesAndResults.ModalAnalysesAtAStiffness",
    "GuideDxfModelModalAnalysisAtAStiffness",
)

if TYPE_CHECKING:
    from mastapy.system_model.part_model import _2455
    from mastapy.system_model.analyses_and_results.static_loads import _6897


__docformat__ = "restructuredtext en"
__all__ = ("GuideDxfModelModalAnalysisAtAStiffness",)


Self = TypeVar("Self", bound="GuideDxfModelModalAnalysisAtAStiffness")


class GuideDxfModelModalAnalysisAtAStiffness(_4882.ComponentModalAnalysisAtAStiffness):
    """GuideDxfModelModalAnalysisAtAStiffness

    This is a mastapy class.
    """

    TYPE = _GUIDE_DXF_MODEL_MODAL_ANALYSIS_AT_A_STIFFNESS
    _CastSelf = TypeVar(
        "_CastSelf", bound="_Cast_GuideDxfModelModalAnalysisAtAStiffness"
    )

    class _Cast_GuideDxfModelModalAnalysisAtAStiffness:
        """Special nested class for casting GuideDxfModelModalAnalysisAtAStiffness to subclasses."""

        def __init__(
            self: "GuideDxfModelModalAnalysisAtAStiffness._Cast_GuideDxfModelModalAnalysisAtAStiffness",
            parent: "GuideDxfModelModalAnalysisAtAStiffness",
        ):
            self._parent = parent

        @property
        def component_modal_analysis_at_a_stiffness(
            self: "GuideDxfModelModalAnalysisAtAStiffness._Cast_GuideDxfModelModalAnalysisAtAStiffness",
        ):
            return self._parent._cast(_4882.ComponentModalAnalysisAtAStiffness)

        @property
        def part_modal_analysis_at_a_stiffness(
            self: "GuideDxfModelModalAnalysisAtAStiffness._Cast_GuideDxfModelModalAnalysisAtAStiffness",
        ):
            from mastapy.system_model.analyses_and_results.modal_analyses_at_a_stiffness import (
                _4938,
            )

            return self._parent._cast(_4938.PartModalAnalysisAtAStiffness)

        @property
        def part_static_load_analysis_case(
            self: "GuideDxfModelModalAnalysisAtAStiffness._Cast_GuideDxfModelModalAnalysisAtAStiffness",
        ):
            from mastapy.system_model.analyses_and_results.analysis_cases import _7548

            return self._parent._cast(_7548.PartStaticLoadAnalysisCase)

        @property
        def part_analysis_case(
            self: "GuideDxfModelModalAnalysisAtAStiffness._Cast_GuideDxfModelModalAnalysisAtAStiffness",
        ):
            from mastapy.system_model.analyses_and_results.analysis_cases import _7545

            return self._parent._cast(_7545.PartAnalysisCase)

        @property
        def part_analysis(
            self: "GuideDxfModelModalAnalysisAtAStiffness._Cast_GuideDxfModelModalAnalysisAtAStiffness",
        ):
            from mastapy.system_model.analyses_and_results import _2657

            return self._parent._cast(_2657.PartAnalysis)

        @property
        def design_entity_single_context_analysis(
            self: "GuideDxfModelModalAnalysisAtAStiffness._Cast_GuideDxfModelModalAnalysisAtAStiffness",
        ):
            from mastapy.system_model.analyses_and_results import _2653

            return self._parent._cast(_2653.DesignEntitySingleContextAnalysis)

        @property
        def design_entity_analysis(
            self: "GuideDxfModelModalAnalysisAtAStiffness._Cast_GuideDxfModelModalAnalysisAtAStiffness",
        ):
            from mastapy.system_model.analyses_and_results import _2651

            return self._parent._cast(_2651.DesignEntityAnalysis)

        @property
        def guide_dxf_model_modal_analysis_at_a_stiffness(
            self: "GuideDxfModelModalAnalysisAtAStiffness._Cast_GuideDxfModelModalAnalysisAtAStiffness",
        ) -> "GuideDxfModelModalAnalysisAtAStiffness":
            return self._parent

        def __getattr__(
            self: "GuideDxfModelModalAnalysisAtAStiffness._Cast_GuideDxfModelModalAnalysisAtAStiffness",
            name: str,
        ):
            try:
                return self.__dict__[name]
            except KeyError:
                class_name = "".join(n.capitalize() for n in name.split("_"))
                raise CastException(
                    f'Detected an invalid cast. Cannot cast to type "{class_name}"'
                ) from None

    def __init__(
        self: Self, instance_to_wrap: "GuideDxfModelModalAnalysisAtAStiffness.TYPE"
    ):
        super().__init__(instance_to_wrap)
        self._freeze()

    @property
    def component_design(self: Self) -> "_2455.GuideDxfModel":
        """mastapy.system_model.part_model.GuideDxfModel

        Note:
            This property is readonly.
        """
        temp = self.wrapped.ComponentDesign

        if temp is None:
            return None

        type_ = temp.GetType()
        return constructor.new(type_.Namespace, type_.Name)(temp)

    @property
    def component_load_case(self: Self) -> "_6897.GuideDxfModelLoadCase":
        """mastapy.system_model.analyses_and_results.static_loads.GuideDxfModelLoadCase

        Note:
            This property is readonly.
        """
        temp = self.wrapped.ComponentLoadCase

        if temp is None:
            return None

        type_ = temp.GetType()
        return constructor.new(type_.Namespace, type_.Name)(temp)

    @property
    def cast_to(
        self: Self,
    ) -> "GuideDxfModelModalAnalysisAtAStiffness._Cast_GuideDxfModelModalAnalysisAtAStiffness":
        return self._Cast_GuideDxfModelModalAnalysisAtAStiffness(self)
