"""Impulse"""

from __future__ import annotations

from typing import TypeVar

from mastapy.utility.units_and_measurements import _1605
from mastapy._internal.cast_exception import CastException
from mastapy._internal.python_net import python_net_import

_IMPULSE = python_net_import(
    "SMT.MastaAPI.Utility.UnitsAndMeasurements.Measurements", "Impulse"
)


__docformat__ = "restructuredtext en"
__all__ = ("Impulse",)


Self = TypeVar("Self", bound="Impulse")


class Impulse(_1605.MeasurementBase):
    """Impulse

    This is a mastapy class.
    """

    TYPE = _IMPULSE
    _CastSelf = TypeVar("_CastSelf", bound="_Cast_Impulse")

    class _Cast_Impulse:
        """Special nested class for casting Impulse to subclasses."""

        def __init__(self: "Impulse._Cast_Impulse", parent: "Impulse"):
            self._parent = parent

        @property
        def measurement_base(self: "Impulse._Cast_Impulse"):
            return self._parent._cast(_1605.MeasurementBase)

        @property
        def impulse(self: "Impulse._Cast_Impulse") -> "Impulse":
            return self._parent

        def __getattr__(self: "Impulse._Cast_Impulse", name: str):
            try:
                return self.__dict__[name]
            except KeyError:
                class_name = "".join(n.capitalize() for n in name.split("_"))
                raise CastException(
                    f'Detected an invalid cast. Cannot cast to type "{class_name}"'
                ) from None

    def __init__(self: Self, instance_to_wrap: "Impulse.TYPE"):
        super().__init__(instance_to_wrap)
        self._freeze()

    @property
    def cast_to(self: Self) -> "Impulse._Cast_Impulse":
        return self._Cast_Impulse(self)
