from enum import Enum
from woningwaardering.vera.bvg.generated import Referentiedata


class Uitexploitatiereden(Enum):
    administratief = Referentiedata(
        code="ADM",
        naam="Administratief",
    )
    """
    De exploitatie van de eenheid van een andere eigenaar is beëindigd
    """

    planmatig_onderhoud = Referentiedata(
        code="PLA",
        naam="Planmatig onderhoud",
    )
    """
    De eenheid is (tijdelijk) uit exploitatie genomen omdat planmatig onderhoud
    plaatsvindt
    """

    renovatie = Referentiedata(
        code="REN",
        naam="Renovatie",
    )
    """
    De eenheid is (tijdelijk) uit exploitatie genomen omdat deze wordt gerenoveerd
    """

    samengevoegd = Referentiedata(
        code="SAM",
        naam="Samengevoegd",
    )
    """
    De eenheid is uit exploitatie genomen omdat deze is samengevoegd met een andere
    eenheid
    """

    sloop = Referentiedata(
        code="SLO",
        naam="Sloop",
    )
    """
    De eenheid is uit exploitatie genomen in afwachting van sloop
    """

    transformatie = Referentiedata(
        code="TRA",
        naam="Transformatie",
    )
    """
    De eenheid is (tijdelijk) uit exploitatie genomen in afwachting van transformatie /
    sanering
    """

    uitruil = Referentiedata(
        code="UIT",
        naam="Uitruil",
    )
    """
    De eenheid is uit exploitatie genomen nadat deze is uitgeruild met een andere
    vastgoedeigenaar
    """

    verkoop_aan_belegger = Referentiedata(
        code="VAB",
        naam="Verkoop aan belegger",
    )
    """
    De eenheid is niet meer in exploitatie omdat deze permanent is verkocht aan een
    belegger
    """

    verkoop_aan_huurder = Referentiedata(
        code="VAH",
        naam="Verkoop aan huurder",
    )
    """
    De eenheid is niet meer in exploitatie omdat deze permanent is verkocht aan een
    (voormalig) huurder
    """

    verkoop_aan_overige_natuurlijke_persoon = Referentiedata(
        code="VAO",
        naam="Verkoop aan overige natuurlijke persoon",
    )
    """
    De eenheid is niet meer in exploitatie omdat deze permanent is verkocht aan een
    overig natuurlijke persoon
    """

    vernieuwbouw = Referentiedata(
        code="VEN",
        naam="Vernieuwbouw",
    )
    """
    De eenheid is (tijdelijk) uit exploitatie genomen omdat deze wordt verniewbouwd
    """

    verkoop_onder_voorwaarden = Referentiedata(
        code="VOV",
        naam="Verkoop onder Voorwaarden",
    )
    """
    De eenheid is niet meer in exploitatie omdat deze is verkocht onder voorwaarden
    (VoV)
    """

    @property
    def code(self) -> str:
        if self.value.code is None:
            raise TypeError("de code van een Referentiedata object mag niet None zijn")
        return self.value.code

    @property
    def naam(self) -> str | None:
        return self.value.naam

    @property
    def parent(self) -> Referentiedata | None:
        return self.value.parent
