from setuptools import setup, find_packages
from codecs import open
from os import path
import sys

sys.path.insert(0, path.dirname(path.abspath(__file__)) + "/../")

import primed_avro


here = path.abspath(path.dirname(__file__))

# Get the long description from the README file
with open(path.join(here, "README.md"), encoding="utf-8") as f:
    long_description = f.read()

# get the dependencies and installs
with open(path.join(here, "requirements.txt"), encoding="utf-8") as f:
    all_reqs = f.read().split("\n")

install_requires = [x.strip() for x in all_reqs if "git+" not in x]
dependency_links = [
    x.strip().replace("git+", "") for x in all_reqs if x.startswith("git+")
]

setup(
    name="primed-avro",
    version=primed_avro.__version__,
    description="A python package that provides functionality to interface with the Confluent Schema Registtry",
    long_description=long_description,
    url="https://gitlab.com/primedio/primed-avro",
    download_url="https://gitlab.com/primedio/primed-avro/tarball/"
    + primed_avro.__version__,
    license="BSD",
    classifiers=[
        "Development Status :: 3 - Alpha",
        "Intended Audience :: Developers",
        "Programming Language :: Python :: 3",
    ],
    keywords="",
    packages=find_packages(exclude=["docs", "tests*"]),
    include_package_data=True,
    author="Matthijs van der Kroon",
    install_requires=install_requires,
    dependency_links=dependency_links,
    author_email="matthijs@primed.io",
)
