# AUTOGENERATED! DO NOT EDIT! File to edit: 00_documentation.ipynb (unless otherwise specified).

__all__ = ['ggdModelDocumentation', 'ModelCard']

# Cell
import json

class ggdModelDocumentation:

    def documentation_path(self):
        pass

    def show_json(self):
        return self.json_doc

    def save_json(self, file_path):
        with open(file_path, 'w') as f:
            json.dump(self.json_doc, f)

    def read_json(self, file_path):
        f = open(file_path)
        self.json_doc = json.load(f)

    def open_questions(self):
        return {
                    v: i
                    for k, v in mdoc.json_doc.items()
                    for v, i in v.items()
                    if i is None
                }

    def fill_info(self, dict):
        for k, v in dict.items():
            self.json_doc[k] = v

    def __setitem__(self, key, value):
        setattr(self, key, value)

    def __getitem__(self, key):
        return getattr(self, key)

    def __str__(self):
        return json.dumps(self.json_doc, indent=4)

    def __repr__(self):
        return f"{self.__class__}()"

# Cell
#export
from .utils import get_username, get_datetime

# Cell
class ModelCard(ggdModelDocumentation):
    def __init__(self, from_template = True):
        if from_template:
            self.start_from_template()

    def start_from_template(self):
        """Creates an empty model card template, then fills it with information that is automatically obtained from the system"""
        self.json_doc = {}
        self.json_doc['model_details'] = {}
        self.json_doc['model_details']['developer'] = get_username()
        self.json_doc['model_details']['datetime'] = get_datetime()
        self.json_doc['model_details']['version'] = "1"
        self.json_doc['model_details']['task'] = None
        self.json_doc['model_details']['framework'] = None
        self.json_doc['model_details']['architecture'] = None
        self.json_doc['model_details']['parameters'] = None
        self.json_doc['model_details']['optimizer'] = None
        self.json_doc['model_details']['type'] = None
        self.json_doc['model_details']['info'] = None
        self.json_doc['model_details']['citation'] = None
        self.json_doc['model_details']['license'] = None
        self.json_doc['model_details']['contact'] = None

        self.json_doc['intended_use'] = {}
        self.json_doc['intended_use']['primary_uses'] = None
        self.json_doc['intended_use']['primary_users'] = None
        self.json_doc['intended_use']['out_of_scope'] = None

        self.json_doc['factors'] = {}
        self.json_doc['factors']['relevant'] = None
        self.json_doc['factors']['evaluation'] = None

        self.json_doc['metrics'] = {}
        self.json_doc['metrics']['performance_measures'] = None
        self.json_doc['metrics']['thresholds'] = None
        self.json_doc['metrics']['variation_approaches'] = None

        self.json_doc['data'] = {}
        self.json_doc['data']['datasets'] = None
        self.json_doc['data']['preprocessing'] = None
        self.json_doc['data']['motivation'] = None

        self.json_doc['ethical_cons'] = {}
        self.json_doc['ethical_cons']['impact'] = None
        self.json_doc['ethical_cons']['risks'] = None
        self.json_doc['ethical_cons']['mitigation'] = None
        self.json_doc['ethical_cons']['avoid'] = None

        self.json_doc['caveats_recomm'] = {}
        self.json_doc['caveats_recomm']['caveats'] = None
        self.json_doc['caveats_recomm']['recommendations'] = None
        self.json_doc['caveats_recomm']['misc_notes'] = None

        return self