import { AccessLevelList } from "../shared/access-level";
import { PolicyStatement } from "../shared";
import { PolicyStatementProps } from "@aws-cdk/aws-iam";
/**
 * (experimental) Statement provider for service [lakeformation](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awslakeformation.html).
 *
 * @experimental
 */
export declare class Lakeformation extends PolicyStatement {
    /**
     * (experimental) Holds the prefix of the service actions, e.g. `ec2`.
     *
     * @experimental
     */
    servicePrefix: string;
    /**
     * (experimental) Grants data lake permissions to one or more principals in a batch.
     *
     * Access Level: Permissions management
     *
     * https://docs.aws.amazon.com/lake-formation/latest/dg/aws-lake-formation-api.html
     *
     * @experimental
     */
    toBatchGrantPermissions(): this;
    /**
     * (experimental) Revokes data lake permissions from one or more principals in a batch.
     *
     * Access Level: Permissions management
     *
     * https://docs.aws.amazon.com/lake-formation/latest/dg/aws-lake-formation-api.html
     *
     * @experimental
     */
    toBatchRevokePermissions(): this;
    /**
     * (experimental) Deregisters a registered location.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/lake-formation/latest/dg/aws-lake-formation-api.html
     *
     * @experimental
     */
    toDeregisterResource(): this;
    /**
     * (experimental) Describes a registered location.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/lake-formation/latest/dg/aws-lake-formation-api.html
     *
     * @experimental
     */
    toDescribeResource(): this;
    /**
     * (experimental) Grants virtual data lake access permissions.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/lake-formation/latest/dg/aws-lake-formation-api.html
     *
     * @experimental
     */
    toGetDataAccess(): this;
    /**
     * (experimental) Retrieves data lake settings such as the list of data lake administrators and database and table default permissions.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/lake-formation/latest/dg/aws-lake-formation-api.html
     *
     * @experimental
     */
    toGetDataLakeSettings(): this;
    /**
     * (experimental) Retrieves permissions attached to resources in the given path.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/lake-formation/latest/dg/aws-lake-formation-api.html
     *
     * @experimental
     */
    toGetEffectivePermissionsForPath(): this;
    /**
     * (experimental) Grants data lake permissions to a principal.
     *
     * Access Level: Permissions management
     *
     * https://docs.aws.amazon.com/lake-formation/latest/dg/aws-lake-formation-api.html
     *
     * @experimental
     */
    toGrantPermissions(): this;
    /**
     * (experimental) Lists permissions filtered by principal or resource.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/lake-formation/latest/dg/aws-lake-formation-api.html
     *
     * @experimental
     */
    toListPermissions(): this;
    /**
     * (experimental) Lists registered locations.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/lake-formation/latest/dg/aws-lake-formation-api.html
     *
     * @experimental
     */
    toListResources(): this;
    /**
     * (experimental) Overwrites data lake settings such as the list of data lake administrators and database and table default permissions.
     *
     * Access Level: Permissions management
     *
     * https://docs.aws.amazon.com/lake-formation/latest/dg/aws-lake-formation-api.html
     *
     * @experimental
     */
    toPutDataLakeSettings(): this;
    /**
     * (experimental) Registers a new location to be managed by Lake Formation.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/lake-formation/latest/dg/aws-lake-formation-api.html
     *
     * @experimental
     */
    toRegisterResource(): this;
    /**
     * (experimental) Revokes data lake permissions from a principal.
     *
     * Access Level: Permissions management
     *
     * https://docs.aws.amazon.com/lake-formation/latest/dg/aws-lake-formation-api.html
     *
     * @experimental
     */
    toRevokePermissions(): this;
    /**
     * (experimental) Updates a registered location.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/lake-formation/latest/dg/aws-lake-formation-api.html
     *
     * @experimental
     */
    toUpdateResource(): this;
    /**
     * @experimental
     */
    protected accessLevelList: AccessLevelList;
    /**
     * (experimental) Statement provider for service [lakeformation](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awslakeformation.html).
     *
     * @experimental
     */
    constructor(props?: PolicyStatementProps);
}
