"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.AccessLevel = void 0;
/**
 * Access level classifications for the actions in a service
 *
 * https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_understand-policy-summary-access-level-summaries.html#access_policies_access-level
 */
var AccessLevel;
(function (AccessLevel) {
    /**
     * Permission to list resources within the service to determine whether an object exists.
     *
     * Actions with this level of access can list objects but cannot see the contents of a resource.
     *
     * For example, the Amazon S3 action `ListBucket` has the List access level.
     */
    AccessLevel["LIST"] = "List";
    /**
     * Permission to read but not edit the contents and attributes of resources in the service.
     *
     * For example, the Amazon S3 actions `GetObject` and `GetBucketLocation` have the Read access level.
     */
    AccessLevel["READ"] = "Read";
    /**
     * Permission to create, delete, or modify resources in the service.
     *
     * For example, the Amazon S3 actions `CreateBucket`, `DeleteBucket` and `PutObject` have the Write access level.
     *
     * Write actions might also allow modifying a resource tag. However, an action that allows only changes to tags has the Tagging access level.
     */
    AccessLevel["WRITE"] = "Write";
    /**
     * Permission to grant or modify resource permissions in the service.
     *
     * For example, most IAM and AWS Organizations actions, as well as actions like the Amazon S3 actions `PutBucketPolicy` and `DeleteBucketPolicy` have the Permissions management access level.
     */
    AccessLevel["PERMISSION_MANAGEMENT"] = "Permissions management";
    /**
     * Permission to perform actions that only change the state of resource tags.
     *
     * For example, the IAM actions `TagRole` and `UntagRole` have the Tagging access level because they allow only tagging or untagging a role. However, the `CreateRole` action allows tagging a role resource when you create that role. Because the action does not only add a tag, it has the Write access level.
     */
    AccessLevel["TAGGING"] = "Tagging";
})(AccessLevel = exports.AccessLevel || (exports.AccessLevel = {}));
//# sourceMappingURL=data:application/json;base64,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