# coding: utf-8

"""
    Carbon

    Connect external data to LLMs, no matter the source.

    The version of the OpenAPI document: 1.0.0
    Generated by: https://konfigthis.com
"""

from dataclasses import dataclass
import typing_extensions
import urllib3
from pydantic import RootModel
from carbon.request_before_hook import request_before_hook
import json
from urllib3._collections import HTTPHeaderDict

from carbon.api_response import AsyncGeneratorResponse
from carbon import api_client, exceptions
from datetime import date, datetime  # noqa: F401
import decimal  # noqa: F401
import functools  # noqa: F401
import io  # noqa: F401
import re  # noqa: F401
import typing  # noqa: F401
import typing_extensions  # noqa: F401
import uuid  # noqa: F401

import frozendict  # noqa: F401

from carbon import schemas  # noqa: F401

from carbon.model.http_validation_error import HTTPValidationError as HTTPValidationErrorSchema
from carbon.model.issue import Issue as IssueSchema

from carbon.type.issue import Issue
from carbon.type.http_validation_error import HTTPValidationError

from ...api_client import Dictionary
from carbon.pydantic.http_validation_error import HTTPValidationError as HTTPValidationErrorPydantic
from carbon.pydantic.issue import Issue as IssuePydantic

from . import path

# Query params
IncludeRemoteDataSchema = schemas.BoolSchema
DataSourceIdSchema = schemas.IntSchema
RepositorySchema = schemas.StrSchema
RequestRequiredQueryParams = typing_extensions.TypedDict(
    'RequestRequiredQueryParams',
    {
    }
)
RequestOptionalQueryParams = typing_extensions.TypedDict(
    'RequestOptionalQueryParams',
    {
        'include_remote_data': typing.Union[IncludeRemoteDataSchema, bool, ],
        'data_source_id': typing.Union[DataSourceIdSchema, decimal.Decimal, int, ],
        'repository': typing.Union[RepositorySchema, str, ],
    },
    total=False
)


class RequestQueryParams(RequestRequiredQueryParams, RequestOptionalQueryParams):
    pass


request_query_include_remote_data = api_client.QueryParameter(
    name="include_remote_data",
    style=api_client.ParameterStyle.FORM,
    schema=IncludeRemoteDataSchema,
    explode=True,
)
request_query_data_source_id = api_client.QueryParameter(
    name="data_source_id",
    style=api_client.ParameterStyle.FORM,
    schema=DataSourceIdSchema,
    explode=True,
)
request_query_repository = api_client.QueryParameter(
    name="repository",
    style=api_client.ParameterStyle.FORM,
    schema=RepositorySchema,
    explode=True,
)
# Path params
IssueNumberSchema = schemas.IntSchema
RequestRequiredPathParams = typing_extensions.TypedDict(
    'RequestRequiredPathParams',
    {
        'issue_number': typing.Union[IssueNumberSchema, decimal.Decimal, int, ],
    }
)
RequestOptionalPathParams = typing_extensions.TypedDict(
    'RequestOptionalPathParams',
    {
    },
    total=False
)


class RequestPathParams(RequestRequiredPathParams, RequestOptionalPathParams):
    pass


request_path_issue_number = api_client.PathParameter(
    name="issue_number",
    style=api_client.ParameterStyle.SIMPLE,
    schema=IssueNumberSchema,
    required=True,
)
_auth = [
    'accessToken',
    'apiKey',
    'customerId',
]
SchemaFor200ResponseBodyApplicationJson = IssueSchema


@dataclass
class ApiResponseFor200(api_client.ApiResponse):
    body: Issue


@dataclass
class ApiResponseFor200Async(api_client.AsyncApiResponse):
    body: Issue


_response_for_200 = api_client.OpenApiResponse(
    response_cls=ApiResponseFor200,
    response_cls_async=ApiResponseFor200Async,
    content={
        'application/json': api_client.MediaType(
            schema=SchemaFor200ResponseBodyApplicationJson),
    },
)
SchemaFor422ResponseBodyApplicationJson = HTTPValidationErrorSchema


@dataclass
class ApiResponseFor422(api_client.ApiResponse):
    body: HTTPValidationError


@dataclass
class ApiResponseFor422Async(api_client.AsyncApiResponse):
    body: HTTPValidationError


_response_for_422 = api_client.OpenApiResponse(
    response_cls=ApiResponseFor422,
    response_cls_async=ApiResponseFor422Async,
    content={
        'application/json': api_client.MediaType(
            schema=SchemaFor422ResponseBodyApplicationJson),
    },
)
_status_code_to_response = {
    '200': _response_for_200,
    '422': _response_for_422,
}
_all_accept_content_types = (
    'application/json',
)


class BaseApi(api_client.Api):

    def _get_issue_mapped_args(
        self,
        issue_number: int,
        include_remote_data: typing.Optional[bool] = None,
        data_source_id: typing.Optional[int] = None,
        repository: typing.Optional[str] = None,
    ) -> api_client.MappedArgs:
        args: api_client.MappedArgs = api_client.MappedArgs()
        _query_params = {}
        _path_params = {}
        if include_remote_data is not None:
            _query_params["include_remote_data"] = include_remote_data
        if data_source_id is not None:
            _query_params["data_source_id"] = data_source_id
        if repository is not None:
            _query_params["repository"] = repository
        if issue_number is not None:
            _path_params["issue_number"] = issue_number
        args.query = _query_params
        args.path = _path_params
        return args

    async def _aget_issue_oapg(
        self,
            query_params: typing.Optional[dict] = {},
            path_params: typing.Optional[dict] = {},
        skip_deserialization: bool = True,
        timeout: typing.Optional[typing.Union[float, typing.Tuple]] = None,
        accept_content_types: typing.Tuple[str] = _all_accept_content_types,
        stream: bool = False,
        **kwargs,
    ) -> typing.Union[
        ApiResponseFor200Async,
        api_client.ApiResponseWithoutDeserializationAsync,
        AsyncGeneratorResponse,
    ]:
        """
        Issue
        :param skip_deserialization: If true then api_response.response will be set but
            api_response.body and api_response.headers will not be deserialized into schema
            class instances
        """
        self._verify_typed_dict_inputs_oapg(RequestQueryParams, query_params)
        self._verify_typed_dict_inputs_oapg(RequestPathParams, path_params)
        used_path = path.value
    
        _path_params = {}
        for parameter in (
            request_path_issue_number,
        ):
            parameter_data = path_params.get(parameter.name, schemas.unset)
            if parameter_data is schemas.unset:
                continue
            serialized_data = parameter.serialize(parameter_data)
            _path_params.update(serialized_data)
    
        for k, v in _path_params.items():
            used_path = used_path.replace('{%s}' % k, v)
    
        prefix_separator_iterator = None
        for parameter in (
            request_query_include_remote_data,
            request_query_data_source_id,
            request_query_repository,
        ):
            parameter_data = query_params.get(parameter.name, schemas.unset)
            if parameter_data is schemas.unset:
                continue
            if prefix_separator_iterator is None:
                prefix_separator_iterator = parameter.get_prefix_separator_iterator()
            serialized_data = parameter.serialize(parameter_data, prefix_separator_iterator)
            for serialized_value in serialized_data.values():
                used_path += serialized_value
    
        _headers = HTTPHeaderDict()
        # TODO add cookie handling
        if accept_content_types:
            for accept_content_type in accept_content_types:
                _headers.add('Accept', accept_content_type)
        method = 'get'.upper()
        request_before_hook(
            resource_path=used_path,
            method=method,
            configuration=self.api_client.configuration,
            path_template='/integrations/data/github/issues/{issue_number}',
            auth_settings=_auth,
            headers=_headers,
        )
    
        response = await self.api_client.async_call_api(
            resource_path=used_path,
            method=method,
            headers=_headers,
            auth_settings=_auth,
            prefix_separator_iterator=prefix_separator_iterator,
            timeout=timeout,
            **kwargs
        )
    
        if stream:
            if not 200 <= response.http_response.status <= 299:
                body = (await response.http_response.content.read()).decode("utf-8")
                raise exceptions.ApiStreamingException(
                    status=response.http_response.status,
                    reason=response.http_response.reason,
                    body=body,
                )
    
            async def stream_iterator():
                """
                iterates over response.http_response.content and closes connection once iteration has finished
                """
                async for line in response.http_response.content:
                    if line == b'\r\n':
                        continue
                    yield line
                response.http_response.close()
                await response.session.close()
            return AsyncGeneratorResponse(
                content=stream_iterator(),
                headers=response.http_response.headers,
                status=response.http_response.status,
                response=response.http_response
            )
    
        response_for_status = _status_code_to_response.get(str(response.http_response.status))
        if response_for_status:
            api_response = await response_for_status.deserialize_async(
                                                    response,
                                                    self.api_client.configuration,
                                                    skip_deserialization=skip_deserialization
                                                )
        else:
            # If response data is JSON then deserialize for SDK consumer convenience
            is_json = api_client.JSONDetector._content_type_is_json(response.http_response.headers.get('Content-Type', ''))
            api_response = api_client.ApiResponseWithoutDeserializationAsync(
                body=await response.http_response.json() if is_json else await response.http_response.text(),
                response=response.http_response,
                round_trip_time=response.round_trip_time,
                status=response.http_response.status,
                headers=response.http_response.headers,
            )
    
        if not 200 <= api_response.status <= 299:
            raise exceptions.ApiException(api_response=api_response)
    
        # cleanup session / response
        response.http_response.close()
        await response.session.close()
    
        return api_response


    def _get_issue_oapg(
        self,
            query_params: typing.Optional[dict] = {},
            path_params: typing.Optional[dict] = {},
        skip_deserialization: bool = True,
        timeout: typing.Optional[typing.Union[float, typing.Tuple]] = None,
        accept_content_types: typing.Tuple[str] = _all_accept_content_types,
        stream: bool = False,
    ) -> typing.Union[
        ApiResponseFor200,
        api_client.ApiResponseWithoutDeserialization,
    ]:
        """
        Issue
        :param skip_deserialization: If true then api_response.response will be set but
            api_response.body and api_response.headers will not be deserialized into schema
            class instances
        """
        self._verify_typed_dict_inputs_oapg(RequestQueryParams, query_params)
        self._verify_typed_dict_inputs_oapg(RequestPathParams, path_params)
        used_path = path.value
    
        _path_params = {}
        for parameter in (
            request_path_issue_number,
        ):
            parameter_data = path_params.get(parameter.name, schemas.unset)
            if parameter_data is schemas.unset:
                continue
            serialized_data = parameter.serialize(parameter_data)
            _path_params.update(serialized_data)
    
        for k, v in _path_params.items():
            used_path = used_path.replace('{%s}' % k, v)
    
        prefix_separator_iterator = None
        for parameter in (
            request_query_include_remote_data,
            request_query_data_source_id,
            request_query_repository,
        ):
            parameter_data = query_params.get(parameter.name, schemas.unset)
            if parameter_data is schemas.unset:
                continue
            if prefix_separator_iterator is None:
                prefix_separator_iterator = parameter.get_prefix_separator_iterator()
            serialized_data = parameter.serialize(parameter_data, prefix_separator_iterator)
            for serialized_value in serialized_data.values():
                used_path += serialized_value
    
        _headers = HTTPHeaderDict()
        # TODO add cookie handling
        if accept_content_types:
            for accept_content_type in accept_content_types:
                _headers.add('Accept', accept_content_type)
        method = 'get'.upper()
        request_before_hook(
            resource_path=used_path,
            method=method,
            configuration=self.api_client.configuration,
            path_template='/integrations/data/github/issues/{issue_number}',
            auth_settings=_auth,
            headers=_headers,
        )
    
        response = self.api_client.call_api(
            resource_path=used_path,
            method=method,
            headers=_headers,
            auth_settings=_auth,
            prefix_separator_iterator=prefix_separator_iterator,
            timeout=timeout,
        )
    
        response_for_status = _status_code_to_response.get(str(response.http_response.status))
        if response_for_status:
            api_response = response_for_status.deserialize(
                                                    response,
                                                    self.api_client.configuration,
                                                    skip_deserialization=skip_deserialization
                                                )
        else:
            # If response data is JSON then deserialize for SDK consumer convenience
            is_json = api_client.JSONDetector._content_type_is_json(response.http_response.headers.get('Content-Type', ''))
            api_response = api_client.ApiResponseWithoutDeserialization(
                body=json.loads(response.http_response.data) if is_json else response.http_response.data,
                response=response.http_response,
                round_trip_time=response.round_trip_time,
                status=response.http_response.status,
                headers=response.http_response.headers,
            )
    
        if not 200 <= api_response.status <= 299:
            raise exceptions.ApiException(api_response=api_response)
    
        return api_response


class GetIssueRaw(BaseApi):
    # this class is used by api classes that refer to endpoints with operationId fn names

    async def aget_issue(
        self,
        issue_number: int,
        include_remote_data: typing.Optional[bool] = None,
        data_source_id: typing.Optional[int] = None,
        repository: typing.Optional[str] = None,
        **kwargs,
    ) -> typing.Union[
        ApiResponseFor200Async,
        api_client.ApiResponseWithoutDeserializationAsync,
        AsyncGeneratorResponse,
    ]:
        args = self._get_issue_mapped_args(
            issue_number=issue_number,
            include_remote_data=include_remote_data,
            data_source_id=data_source_id,
            repository=repository,
        )
        return await self._aget_issue_oapg(
            query_params=args.query,
            path_params=args.path,
            **kwargs,
        )
    
    def get_issue(
        self,
        issue_number: int,
        include_remote_data: typing.Optional[bool] = None,
        data_source_id: typing.Optional[int] = None,
        repository: typing.Optional[str] = None,
    ) -> typing.Union[
        ApiResponseFor200,
        api_client.ApiResponseWithoutDeserialization,
    ]:
        """  """
        args = self._get_issue_mapped_args(
            issue_number=issue_number,
            include_remote_data=include_remote_data,
            data_source_id=data_source_id,
            repository=repository,
        )
        return self._get_issue_oapg(
            query_params=args.query,
            path_params=args.path,
        )

class GetIssue(BaseApi):

    async def aget_issue(
        self,
        issue_number: int,
        include_remote_data: typing.Optional[bool] = None,
        data_source_id: typing.Optional[int] = None,
        repository: typing.Optional[str] = None,
        validate: bool = False,
        **kwargs,
    ) -> IssuePydantic:
        raw_response = await self.raw.aget_issue(
            issue_number=issue_number,
            include_remote_data=include_remote_data,
            data_source_id=data_source_id,
            repository=repository,
            **kwargs,
        )
        if validate:
            return IssuePydantic(**raw_response.body)
        return api_client.construct_model_instance(IssuePydantic, raw_response.body)
    
    
    def get_issue(
        self,
        issue_number: int,
        include_remote_data: typing.Optional[bool] = None,
        data_source_id: typing.Optional[int] = None,
        repository: typing.Optional[str] = None,
        validate: bool = False,
    ) -> IssuePydantic:
        raw_response = self.raw.get_issue(
            issue_number=issue_number,
            include_remote_data=include_remote_data,
            data_source_id=data_source_id,
            repository=repository,
        )
        if validate:
            return IssuePydantic(**raw_response.body)
        return api_client.construct_model_instance(IssuePydantic, raw_response.body)


class ApiForget(BaseApi):
    # this class is used by api classes that refer to endpoints by path and http method names

    async def aget(
        self,
        issue_number: int,
        include_remote_data: typing.Optional[bool] = None,
        data_source_id: typing.Optional[int] = None,
        repository: typing.Optional[str] = None,
        **kwargs,
    ) -> typing.Union[
        ApiResponseFor200Async,
        api_client.ApiResponseWithoutDeserializationAsync,
        AsyncGeneratorResponse,
    ]:
        args = self._get_issue_mapped_args(
            issue_number=issue_number,
            include_remote_data=include_remote_data,
            data_source_id=data_source_id,
            repository=repository,
        )
        return await self._aget_issue_oapg(
            query_params=args.query,
            path_params=args.path,
            **kwargs,
        )
    
    def get(
        self,
        issue_number: int,
        include_remote_data: typing.Optional[bool] = None,
        data_source_id: typing.Optional[int] = None,
        repository: typing.Optional[str] = None,
    ) -> typing.Union[
        ApiResponseFor200,
        api_client.ApiResponseWithoutDeserialization,
    ]:
        """  """
        args = self._get_issue_mapped_args(
            issue_number=issue_number,
            include_remote_data=include_remote_data,
            data_source_id=data_source_id,
            repository=repository,
        )
        return self._get_issue_oapg(
            query_params=args.query,
            path_params=args.path,
        )

