# coding: utf-8

"""
    Carbon

    Connect external data to LLMs, no matter the source.

    The version of the OpenAPI document: 1.0.0
    Generated by: https://konfigthis.com
"""

from dataclasses import dataclass
import typing_extensions
import urllib3
from pydantic import RootModel
from carbon.request_before_hook import request_before_hook
import json
from urllib3._collections import HTTPHeaderDict

from carbon.api_response import AsyncGeneratorResponse
from carbon import api_client, exceptions
from datetime import date, datetime  # noqa: F401
import decimal  # noqa: F401
import functools  # noqa: F401
import io  # noqa: F401
import re  # noqa: F401
import typing  # noqa: F401
import typing_extensions  # noqa: F401
import uuid  # noqa: F401

import frozendict  # noqa: F401

from carbon import schemas  # noqa: F401

from carbon.model.outlook_sync_input import OutlookSyncInput as OutlookSyncInputSchema
from carbon.model.http_validation_error import HTTPValidationError as HTTPValidationErrorSchema
from carbon.model.embedding_generators import EmbeddingGenerators as EmbeddingGeneratorsSchema
from carbon.model.generic_success_response import GenericSuccessResponse as GenericSuccessResponseSchema
from carbon.model.file_sync_config_nullable import FileSyncConfigNullable as FileSyncConfigNullableSchema

from carbon.type.embedding_generators import EmbeddingGenerators
from carbon.type.http_validation_error import HTTPValidationError
from carbon.type.file_sync_config_nullable import FileSyncConfigNullable
from carbon.type.outlook_sync_input import OutlookSyncInput
from carbon.type.generic_success_response import GenericSuccessResponse

from ...api_client import Dictionary
from carbon.pydantic.outlook_sync_input import OutlookSyncInput as OutlookSyncInputPydantic
from carbon.pydantic.http_validation_error import HTTPValidationError as HTTPValidationErrorPydantic
from carbon.pydantic.generic_success_response import GenericSuccessResponse as GenericSuccessResponsePydantic
from carbon.pydantic.embedding_generators import EmbeddingGenerators as EmbeddingGeneratorsPydantic
from carbon.pydantic.file_sync_config_nullable import FileSyncConfigNullable as FileSyncConfigNullablePydantic

from . import path

# body param
SchemaForRequestBodyApplicationJson = OutlookSyncInputSchema


request_body_outlook_sync_input = api_client.RequestBody(
    content={
        'application/json': api_client.MediaType(
            schema=SchemaForRequestBodyApplicationJson),
    },
    required=True,
)
_auth = [
    'accessToken',
    'apiKey',
    'customerId',
]
SchemaFor200ResponseBodyApplicationJson = GenericSuccessResponseSchema


@dataclass
class ApiResponseFor200(api_client.ApiResponse):
    body: GenericSuccessResponse


@dataclass
class ApiResponseFor200Async(api_client.AsyncApiResponse):
    body: GenericSuccessResponse


_response_for_200 = api_client.OpenApiResponse(
    response_cls=ApiResponseFor200,
    response_cls_async=ApiResponseFor200Async,
    content={
        'application/json': api_client.MediaType(
            schema=SchemaFor200ResponseBodyApplicationJson),
    },
)
SchemaFor422ResponseBodyApplicationJson = HTTPValidationErrorSchema


@dataclass
class ApiResponseFor422(api_client.ApiResponse):
    body: HTTPValidationError


@dataclass
class ApiResponseFor422Async(api_client.AsyncApiResponse):
    body: HTTPValidationError


_response_for_422 = api_client.OpenApiResponse(
    response_cls=ApiResponseFor422,
    response_cls_async=ApiResponseFor422Async,
    content={
        'application/json': api_client.MediaType(
            schema=SchemaFor422ResponseBodyApplicationJson),
    },
)
_status_code_to_response = {
    '200': _response_for_200,
    '422': _response_for_422,
}
_all_accept_content_types = (
    'application/json',
)


class BaseApi(api_client.Api):

    def _sync_outlook_mapped_args(
        self,
        filters: typing.Dict[str, typing.Union[bool, date, datetime, dict, float, int, list, str, None]],
        tags: typing.Optional[typing.Optional[typing.Dict[str, typing.Union[bool, date, datetime, dict, float, int, list, str, None]]]] = None,
        folder: typing.Optional[typing.Optional[str]] = None,
        chunk_size: typing.Optional[typing.Optional[int]] = None,
        chunk_overlap: typing.Optional[typing.Optional[int]] = None,
        skip_embedding_generation: typing.Optional[typing.Optional[bool]] = None,
        embedding_model: typing.Optional[EmbeddingGenerators] = None,
        generate_sparse_vectors: typing.Optional[typing.Optional[bool]] = None,
        prepend_filename_to_chunks: typing.Optional[typing.Optional[bool]] = None,
        data_source_id: typing.Optional[typing.Optional[int]] = None,
        request_id: typing.Optional[typing.Optional[str]] = None,
        sync_attachments: typing.Optional[typing.Optional[bool]] = None,
        file_sync_config: typing.Optional[FileSyncConfigNullable] = None,
        incremental_sync: typing.Optional[bool] = None,
    ) -> api_client.MappedArgs:
        args: api_client.MappedArgs = api_client.MappedArgs()
        _body = {}
        if tags is not None:
            _body["tags"] = tags
        if folder is not None:
            _body["folder"] = folder
        if filters is not None:
            _body["filters"] = filters
        if chunk_size is not None:
            _body["chunk_size"] = chunk_size
        if chunk_overlap is not None:
            _body["chunk_overlap"] = chunk_overlap
        if skip_embedding_generation is not None:
            _body["skip_embedding_generation"] = skip_embedding_generation
        if embedding_model is not None:
            _body["embedding_model"] = embedding_model
        if generate_sparse_vectors is not None:
            _body["generate_sparse_vectors"] = generate_sparse_vectors
        if prepend_filename_to_chunks is not None:
            _body["prepend_filename_to_chunks"] = prepend_filename_to_chunks
        if data_source_id is not None:
            _body["data_source_id"] = data_source_id
        if request_id is not None:
            _body["request_id"] = request_id
        if sync_attachments is not None:
            _body["sync_attachments"] = sync_attachments
        if file_sync_config is not None:
            _body["file_sync_config"] = file_sync_config
        if incremental_sync is not None:
            _body["incremental_sync"] = incremental_sync
        args.body = _body
        return args

    async def _async_outlook_oapg(
        self,
        body: typing.Any = None,
        skip_deserialization: bool = True,
        timeout: typing.Optional[typing.Union[float, typing.Tuple]] = None,
        accept_content_types: typing.Tuple[str] = _all_accept_content_types,
        content_type: str = 'application/json',
        stream: bool = False,
        **kwargs,
    ) -> typing.Union[
        ApiResponseFor200Async,
        api_client.ApiResponseWithoutDeserializationAsync,
        AsyncGeneratorResponse,
    ]:
        """
        Outlook Sync
        :param skip_deserialization: If true then api_response.response will be set but
            api_response.body and api_response.headers will not be deserialized into schema
            class instances
        """
        used_path = path.value
    
        _headers = HTTPHeaderDict()
        # TODO add cookie handling
        if accept_content_types:
            for accept_content_type in accept_content_types:
                _headers.add('Accept', accept_content_type)
        method = 'post'.upper()
        _headers.add('Content-Type', content_type)
    
        if body is schemas.unset:
            raise exceptions.ApiValueError(
                'The required body parameter has an invalid value of: unset. Set a valid value instead')
        _fields = None
        _body = None
        request_before_hook(
            resource_path=used_path,
            method=method,
            configuration=self.api_client.configuration,
            path_template='/integrations/outlook/sync',
            body=body,
            auth_settings=_auth,
            headers=_headers,
        )
        serialized_data = request_body_outlook_sync_input.serialize(body, content_type)
        if 'fields' in serialized_data:
            _fields = serialized_data['fields']
        elif 'body' in serialized_data:
            _body = serialized_data['body']
    
        response = await self.api_client.async_call_api(
            resource_path=used_path,
            method=method,
            headers=_headers,
            fields=_fields,
            serialized_body=_body,
            body=body,
            auth_settings=_auth,
            timeout=timeout,
            **kwargs
        )
    
        if stream:
            if not 200 <= response.http_response.status <= 299:
                body = (await response.http_response.content.read()).decode("utf-8")
                raise exceptions.ApiStreamingException(
                    status=response.http_response.status,
                    reason=response.http_response.reason,
                    body=body,
                )
    
            async def stream_iterator():
                """
                iterates over response.http_response.content and closes connection once iteration has finished
                """
                async for line in response.http_response.content:
                    if line == b'\r\n':
                        continue
                    yield line
                response.http_response.close()
                await response.session.close()
            return AsyncGeneratorResponse(
                content=stream_iterator(),
                headers=response.http_response.headers,
                status=response.http_response.status,
                response=response.http_response
            )
    
        response_for_status = _status_code_to_response.get(str(response.http_response.status))
        if response_for_status:
            api_response = await response_for_status.deserialize_async(
                                                    response,
                                                    self.api_client.configuration,
                                                    skip_deserialization=skip_deserialization
                                                )
        else:
            # If response data is JSON then deserialize for SDK consumer convenience
            is_json = api_client.JSONDetector._content_type_is_json(response.http_response.headers.get('Content-Type', ''))
            api_response = api_client.ApiResponseWithoutDeserializationAsync(
                body=await response.http_response.json() if is_json else await response.http_response.text(),
                response=response.http_response,
                round_trip_time=response.round_trip_time,
                status=response.http_response.status,
                headers=response.http_response.headers,
            )
    
        if not 200 <= api_response.status <= 299:
            raise exceptions.ApiException(api_response=api_response)
    
        # cleanup session / response
        response.http_response.close()
        await response.session.close()
    
        return api_response


    def _sync_outlook_oapg(
        self,
        body: typing.Any = None,
        skip_deserialization: bool = True,
        timeout: typing.Optional[typing.Union[float, typing.Tuple]] = None,
        accept_content_types: typing.Tuple[str] = _all_accept_content_types,
        content_type: str = 'application/json',
        stream: bool = False,
    ) -> typing.Union[
        ApiResponseFor200,
        api_client.ApiResponseWithoutDeserialization,
    ]:
        """
        Outlook Sync
        :param skip_deserialization: If true then api_response.response will be set but
            api_response.body and api_response.headers will not be deserialized into schema
            class instances
        """
        used_path = path.value
    
        _headers = HTTPHeaderDict()
        # TODO add cookie handling
        if accept_content_types:
            for accept_content_type in accept_content_types:
                _headers.add('Accept', accept_content_type)
        method = 'post'.upper()
        _headers.add('Content-Type', content_type)
    
        if body is schemas.unset:
            raise exceptions.ApiValueError(
                'The required body parameter has an invalid value of: unset. Set a valid value instead')
        _fields = None
        _body = None
        request_before_hook(
            resource_path=used_path,
            method=method,
            configuration=self.api_client.configuration,
            path_template='/integrations/outlook/sync',
            body=body,
            auth_settings=_auth,
            headers=_headers,
        )
        serialized_data = request_body_outlook_sync_input.serialize(body, content_type)
        if 'fields' in serialized_data:
            _fields = serialized_data['fields']
        elif 'body' in serialized_data:
            _body = serialized_data['body']
    
        response = self.api_client.call_api(
            resource_path=used_path,
            method=method,
            headers=_headers,
            fields=_fields,
            serialized_body=_body,
            body=body,
            auth_settings=_auth,
            timeout=timeout,
        )
    
        response_for_status = _status_code_to_response.get(str(response.http_response.status))
        if response_for_status:
            api_response = response_for_status.deserialize(
                                                    response,
                                                    self.api_client.configuration,
                                                    skip_deserialization=skip_deserialization
                                                )
        else:
            # If response data is JSON then deserialize for SDK consumer convenience
            is_json = api_client.JSONDetector._content_type_is_json(response.http_response.headers.get('Content-Type', ''))
            api_response = api_client.ApiResponseWithoutDeserialization(
                body=json.loads(response.http_response.data) if is_json else response.http_response.data,
                response=response.http_response,
                round_trip_time=response.round_trip_time,
                status=response.http_response.status,
                headers=response.http_response.headers,
            )
    
        if not 200 <= api_response.status <= 299:
            raise exceptions.ApiException(api_response=api_response)
    
        return api_response


class SyncOutlookRaw(BaseApi):
    # this class is used by api classes that refer to endpoints with operationId fn names

    async def async_outlook(
        self,
        filters: typing.Dict[str, typing.Union[bool, date, datetime, dict, float, int, list, str, None]],
        tags: typing.Optional[typing.Optional[typing.Dict[str, typing.Union[bool, date, datetime, dict, float, int, list, str, None]]]] = None,
        folder: typing.Optional[typing.Optional[str]] = None,
        chunk_size: typing.Optional[typing.Optional[int]] = None,
        chunk_overlap: typing.Optional[typing.Optional[int]] = None,
        skip_embedding_generation: typing.Optional[typing.Optional[bool]] = None,
        embedding_model: typing.Optional[EmbeddingGenerators] = None,
        generate_sparse_vectors: typing.Optional[typing.Optional[bool]] = None,
        prepend_filename_to_chunks: typing.Optional[typing.Optional[bool]] = None,
        data_source_id: typing.Optional[typing.Optional[int]] = None,
        request_id: typing.Optional[typing.Optional[str]] = None,
        sync_attachments: typing.Optional[typing.Optional[bool]] = None,
        file_sync_config: typing.Optional[FileSyncConfigNullable] = None,
        incremental_sync: typing.Optional[bool] = None,
        **kwargs,
    ) -> typing.Union[
        ApiResponseFor200Async,
        api_client.ApiResponseWithoutDeserializationAsync,
        AsyncGeneratorResponse,
    ]:
        args = self._sync_outlook_mapped_args(
            filters=filters,
            tags=tags,
            folder=folder,
            chunk_size=chunk_size,
            chunk_overlap=chunk_overlap,
            skip_embedding_generation=skip_embedding_generation,
            embedding_model=embedding_model,
            generate_sparse_vectors=generate_sparse_vectors,
            prepend_filename_to_chunks=prepend_filename_to_chunks,
            data_source_id=data_source_id,
            request_id=request_id,
            sync_attachments=sync_attachments,
            file_sync_config=file_sync_config,
            incremental_sync=incremental_sync,
        )
        return await self._async_outlook_oapg(
            body=args.body,
            **kwargs,
        )
    
    def sync_outlook(
        self,
        filters: typing.Dict[str, typing.Union[bool, date, datetime, dict, float, int, list, str, None]],
        tags: typing.Optional[typing.Optional[typing.Dict[str, typing.Union[bool, date, datetime, dict, float, int, list, str, None]]]] = None,
        folder: typing.Optional[typing.Optional[str]] = None,
        chunk_size: typing.Optional[typing.Optional[int]] = None,
        chunk_overlap: typing.Optional[typing.Optional[int]] = None,
        skip_embedding_generation: typing.Optional[typing.Optional[bool]] = None,
        embedding_model: typing.Optional[EmbeddingGenerators] = None,
        generate_sparse_vectors: typing.Optional[typing.Optional[bool]] = None,
        prepend_filename_to_chunks: typing.Optional[typing.Optional[bool]] = None,
        data_source_id: typing.Optional[typing.Optional[int]] = None,
        request_id: typing.Optional[typing.Optional[str]] = None,
        sync_attachments: typing.Optional[typing.Optional[bool]] = None,
        file_sync_config: typing.Optional[FileSyncConfigNullable] = None,
        incremental_sync: typing.Optional[bool] = None,
    ) -> typing.Union[
        ApiResponseFor200,
        api_client.ApiResponseWithoutDeserialization,
    ]:
        """ Once you have successfully connected your Outlook account, you can choose which emails to sync with us using the filters and folder parameter. \"folder\" should be the folder you want to sync from Outlook. By default we get messages from your inbox folder.   Filters is a JSON object with key value pairs. It also supports AND and OR operations. For now, we support a limited set of keys listed below.  <b>category</b>: Custom categories that you created in Outlook.   <b>after</b> or <b>before</b>: A date in YYYY/mm/dd format (example 2023/12/31). Gets emails after/before a certain date. You can also use them in combination to get emails from a certain period.     <b>is</b>: Can have the following values: flagged   <b>from</b>: Email address of the sender     An example of a basic query with filters can be ```json {     \"filters\": {             \"key\": \"category\",             \"value\": \"Test\"         } } ``` Which will list all emails that have the category \"Test\".    Specifying a custom folder in the same query ```json {     \"folder\": \"Folder Name\",     \"filters\": {             \"key\": \"category\",             \"value\": \"Test\"         } } ```  You can use AND and OR operation in the following way: ```json {     \"filters\": {         \"AND\": [             {                 \"key\": \"after\",                 \"value\": \"2024/01/07\"             },             {                 \"OR\": [                     {                         \"key\": \"category\",                         \"value\": \"Personal\"                     },                     {                         \"key\": \"category\",                         \"value\": \"Test\"                     },                 ]             }         ]     } } ``` This will return emails after 7th of Jan that have either Personal or Test as category.  Note that this is the highest level of nesting we support, i.e. you can't add more AND/OR filters within the OR filter in the above example. """
        args = self._sync_outlook_mapped_args(
            filters=filters,
            tags=tags,
            folder=folder,
            chunk_size=chunk_size,
            chunk_overlap=chunk_overlap,
            skip_embedding_generation=skip_embedding_generation,
            embedding_model=embedding_model,
            generate_sparse_vectors=generate_sparse_vectors,
            prepend_filename_to_chunks=prepend_filename_to_chunks,
            data_source_id=data_source_id,
            request_id=request_id,
            sync_attachments=sync_attachments,
            file_sync_config=file_sync_config,
            incremental_sync=incremental_sync,
        )
        return self._sync_outlook_oapg(
            body=args.body,
        )

class SyncOutlook(BaseApi):

    async def async_outlook(
        self,
        filters: typing.Dict[str, typing.Union[bool, date, datetime, dict, float, int, list, str, None]],
        tags: typing.Optional[typing.Optional[typing.Dict[str, typing.Union[bool, date, datetime, dict, float, int, list, str, None]]]] = None,
        folder: typing.Optional[typing.Optional[str]] = None,
        chunk_size: typing.Optional[typing.Optional[int]] = None,
        chunk_overlap: typing.Optional[typing.Optional[int]] = None,
        skip_embedding_generation: typing.Optional[typing.Optional[bool]] = None,
        embedding_model: typing.Optional[EmbeddingGenerators] = None,
        generate_sparse_vectors: typing.Optional[typing.Optional[bool]] = None,
        prepend_filename_to_chunks: typing.Optional[typing.Optional[bool]] = None,
        data_source_id: typing.Optional[typing.Optional[int]] = None,
        request_id: typing.Optional[typing.Optional[str]] = None,
        sync_attachments: typing.Optional[typing.Optional[bool]] = None,
        file_sync_config: typing.Optional[FileSyncConfigNullable] = None,
        incremental_sync: typing.Optional[bool] = None,
        validate: bool = False,
        **kwargs,
    ) -> GenericSuccessResponsePydantic:
        raw_response = await self.raw.async_outlook(
            filters=filters,
            tags=tags,
            folder=folder,
            chunk_size=chunk_size,
            chunk_overlap=chunk_overlap,
            skip_embedding_generation=skip_embedding_generation,
            embedding_model=embedding_model,
            generate_sparse_vectors=generate_sparse_vectors,
            prepend_filename_to_chunks=prepend_filename_to_chunks,
            data_source_id=data_source_id,
            request_id=request_id,
            sync_attachments=sync_attachments,
            file_sync_config=file_sync_config,
            incremental_sync=incremental_sync,
            **kwargs,
        )
        if validate:
            return GenericSuccessResponsePydantic(**raw_response.body)
        return api_client.construct_model_instance(GenericSuccessResponsePydantic, raw_response.body)
    
    
    def sync_outlook(
        self,
        filters: typing.Dict[str, typing.Union[bool, date, datetime, dict, float, int, list, str, None]],
        tags: typing.Optional[typing.Optional[typing.Dict[str, typing.Union[bool, date, datetime, dict, float, int, list, str, None]]]] = None,
        folder: typing.Optional[typing.Optional[str]] = None,
        chunk_size: typing.Optional[typing.Optional[int]] = None,
        chunk_overlap: typing.Optional[typing.Optional[int]] = None,
        skip_embedding_generation: typing.Optional[typing.Optional[bool]] = None,
        embedding_model: typing.Optional[EmbeddingGenerators] = None,
        generate_sparse_vectors: typing.Optional[typing.Optional[bool]] = None,
        prepend_filename_to_chunks: typing.Optional[typing.Optional[bool]] = None,
        data_source_id: typing.Optional[typing.Optional[int]] = None,
        request_id: typing.Optional[typing.Optional[str]] = None,
        sync_attachments: typing.Optional[typing.Optional[bool]] = None,
        file_sync_config: typing.Optional[FileSyncConfigNullable] = None,
        incremental_sync: typing.Optional[bool] = None,
        validate: bool = False,
    ) -> GenericSuccessResponsePydantic:
        raw_response = self.raw.sync_outlook(
            filters=filters,
            tags=tags,
            folder=folder,
            chunk_size=chunk_size,
            chunk_overlap=chunk_overlap,
            skip_embedding_generation=skip_embedding_generation,
            embedding_model=embedding_model,
            generate_sparse_vectors=generate_sparse_vectors,
            prepend_filename_to_chunks=prepend_filename_to_chunks,
            data_source_id=data_source_id,
            request_id=request_id,
            sync_attachments=sync_attachments,
            file_sync_config=file_sync_config,
            incremental_sync=incremental_sync,
        )
        if validate:
            return GenericSuccessResponsePydantic(**raw_response.body)
        return api_client.construct_model_instance(GenericSuccessResponsePydantic, raw_response.body)


class ApiForpost(BaseApi):
    # this class is used by api classes that refer to endpoints by path and http method names

    async def apost(
        self,
        filters: typing.Dict[str, typing.Union[bool, date, datetime, dict, float, int, list, str, None]],
        tags: typing.Optional[typing.Optional[typing.Dict[str, typing.Union[bool, date, datetime, dict, float, int, list, str, None]]]] = None,
        folder: typing.Optional[typing.Optional[str]] = None,
        chunk_size: typing.Optional[typing.Optional[int]] = None,
        chunk_overlap: typing.Optional[typing.Optional[int]] = None,
        skip_embedding_generation: typing.Optional[typing.Optional[bool]] = None,
        embedding_model: typing.Optional[EmbeddingGenerators] = None,
        generate_sparse_vectors: typing.Optional[typing.Optional[bool]] = None,
        prepend_filename_to_chunks: typing.Optional[typing.Optional[bool]] = None,
        data_source_id: typing.Optional[typing.Optional[int]] = None,
        request_id: typing.Optional[typing.Optional[str]] = None,
        sync_attachments: typing.Optional[typing.Optional[bool]] = None,
        file_sync_config: typing.Optional[FileSyncConfigNullable] = None,
        incremental_sync: typing.Optional[bool] = None,
        **kwargs,
    ) -> typing.Union[
        ApiResponseFor200Async,
        api_client.ApiResponseWithoutDeserializationAsync,
        AsyncGeneratorResponse,
    ]:
        args = self._sync_outlook_mapped_args(
            filters=filters,
            tags=tags,
            folder=folder,
            chunk_size=chunk_size,
            chunk_overlap=chunk_overlap,
            skip_embedding_generation=skip_embedding_generation,
            embedding_model=embedding_model,
            generate_sparse_vectors=generate_sparse_vectors,
            prepend_filename_to_chunks=prepend_filename_to_chunks,
            data_source_id=data_source_id,
            request_id=request_id,
            sync_attachments=sync_attachments,
            file_sync_config=file_sync_config,
            incremental_sync=incremental_sync,
        )
        return await self._async_outlook_oapg(
            body=args.body,
            **kwargs,
        )
    
    def post(
        self,
        filters: typing.Dict[str, typing.Union[bool, date, datetime, dict, float, int, list, str, None]],
        tags: typing.Optional[typing.Optional[typing.Dict[str, typing.Union[bool, date, datetime, dict, float, int, list, str, None]]]] = None,
        folder: typing.Optional[typing.Optional[str]] = None,
        chunk_size: typing.Optional[typing.Optional[int]] = None,
        chunk_overlap: typing.Optional[typing.Optional[int]] = None,
        skip_embedding_generation: typing.Optional[typing.Optional[bool]] = None,
        embedding_model: typing.Optional[EmbeddingGenerators] = None,
        generate_sparse_vectors: typing.Optional[typing.Optional[bool]] = None,
        prepend_filename_to_chunks: typing.Optional[typing.Optional[bool]] = None,
        data_source_id: typing.Optional[typing.Optional[int]] = None,
        request_id: typing.Optional[typing.Optional[str]] = None,
        sync_attachments: typing.Optional[typing.Optional[bool]] = None,
        file_sync_config: typing.Optional[FileSyncConfigNullable] = None,
        incremental_sync: typing.Optional[bool] = None,
    ) -> typing.Union[
        ApiResponseFor200,
        api_client.ApiResponseWithoutDeserialization,
    ]:
        """ Once you have successfully connected your Outlook account, you can choose which emails to sync with us using the filters and folder parameter. \"folder\" should be the folder you want to sync from Outlook. By default we get messages from your inbox folder.   Filters is a JSON object with key value pairs. It also supports AND and OR operations. For now, we support a limited set of keys listed below.  <b>category</b>: Custom categories that you created in Outlook.   <b>after</b> or <b>before</b>: A date in YYYY/mm/dd format (example 2023/12/31). Gets emails after/before a certain date. You can also use them in combination to get emails from a certain period.     <b>is</b>: Can have the following values: flagged   <b>from</b>: Email address of the sender     An example of a basic query with filters can be ```json {     \"filters\": {             \"key\": \"category\",             \"value\": \"Test\"         } } ``` Which will list all emails that have the category \"Test\".    Specifying a custom folder in the same query ```json {     \"folder\": \"Folder Name\",     \"filters\": {             \"key\": \"category\",             \"value\": \"Test\"         } } ```  You can use AND and OR operation in the following way: ```json {     \"filters\": {         \"AND\": [             {                 \"key\": \"after\",                 \"value\": \"2024/01/07\"             },             {                 \"OR\": [                     {                         \"key\": \"category\",                         \"value\": \"Personal\"                     },                     {                         \"key\": \"category\",                         \"value\": \"Test\"                     },                 ]             }         ]     } } ``` This will return emails after 7th of Jan that have either Personal or Test as category.  Note that this is the highest level of nesting we support, i.e. you can't add more AND/OR filters within the OR filter in the above example. """
        args = self._sync_outlook_mapped_args(
            filters=filters,
            tags=tags,
            folder=folder,
            chunk_size=chunk_size,
            chunk_overlap=chunk_overlap,
            skip_embedding_generation=skip_embedding_generation,
            embedding_model=embedding_model,
            generate_sparse_vectors=generate_sparse_vectors,
            prepend_filename_to_chunks=prepend_filename_to_chunks,
            data_source_id=data_source_id,
            request_id=request_id,
            sync_attachments=sync_attachments,
            file_sync_config=file_sync_config,
            incremental_sync=incremental_sync,
        )
        return self._sync_outlook_oapg(
            body=args.body,
        )

