# coding: utf-8

"""
    Carbon

    Connect external data to LLMs, no matter the source.

    The version of the OpenAPI document: 1.0.0
    Generated by: https://konfigthis.com
"""

from dataclasses import dataclass
import typing_extensions
import urllib3
from pydantic import RootModel
from carbon.request_before_hook import request_before_hook
import json
from urllib3._collections import HTTPHeaderDict

from carbon.api_response import AsyncGeneratorResponse
from carbon import api_client, exceptions
from datetime import date, datetime  # noqa: F401
import decimal  # noqa: F401
import functools  # noqa: F401
import io  # noqa: F401
import re  # noqa: F401
import typing  # noqa: F401
import typing_extensions  # noqa: F401
import uuid  # noqa: F401

import frozendict  # noqa: F401

from carbon import schemas  # noqa: F401

from carbon.model.text_embedding_generators import TextEmbeddingGenerators as TextEmbeddingGeneratorsSchema
from carbon.model.http_validation_error import HTTPValidationError as HTTPValidationErrorSchema
from carbon.model.multi_modal_embedding_generators import MultiModalEmbeddingGenerators as MultiModalEmbeddingGeneratorsSchema
from carbon.model.user_file import UserFile as UserFileSchema
from carbon.model.file_content_types_nullable import FileContentTypesNullable as FileContentTypesNullableSchema
from carbon.model.body_create_upload_file_uploadfile_post import BodyCreateUploadFileUploadfilePost as BodyCreateUploadFileUploadfilePostSchema
from carbon.model.transcription_service_nullable import TranscriptionServiceNullable as TranscriptionServiceNullableSchema

from carbon.type.http_validation_error import HTTPValidationError
from carbon.type.file_content_types_nullable import FileContentTypesNullable
from carbon.type.multi_modal_embedding_generators import MultiModalEmbeddingGenerators
from carbon.type.transcription_service_nullable import TranscriptionServiceNullable
from carbon.type.user_file import UserFile
from carbon.type.body_create_upload_file_uploadfile_post import BodyCreateUploadFileUploadfilePost
from carbon.type.text_embedding_generators import TextEmbeddingGenerators

from ...api_client import Dictionary
from carbon.pydantic.multi_modal_embedding_generators import MultiModalEmbeddingGenerators as MultiModalEmbeddingGeneratorsPydantic
from carbon.pydantic.file_content_types_nullable import FileContentTypesNullable as FileContentTypesNullablePydantic
from carbon.pydantic.user_file import UserFile as UserFilePydantic
from carbon.pydantic.http_validation_error import HTTPValidationError as HTTPValidationErrorPydantic
from carbon.pydantic.body_create_upload_file_uploadfile_post import BodyCreateUploadFileUploadfilePost as BodyCreateUploadFileUploadfilePostPydantic
from carbon.pydantic.transcription_service_nullable import TranscriptionServiceNullable as TranscriptionServiceNullablePydantic
from carbon.pydantic.text_embedding_generators import TextEmbeddingGenerators as TextEmbeddingGeneratorsPydantic

# Query params


class ChunkSizeSchema(
    schemas.IntBase,
    schemas.NoneBase,
    schemas.Schema,
    schemas.NoneDecimalMixin
):


    def __new__(
        cls,
        *args: typing.Union[None, decimal.Decimal, int, ],
        _configuration: typing.Optional[schemas.Configuration] = None,
    ) -> 'ChunkSizeSchema':
        return super().__new__(
            cls,
            *args,
            _configuration=_configuration,
        )


class ChunkOverlapSchema(
    schemas.IntBase,
    schemas.NoneBase,
    schemas.Schema,
    schemas.NoneDecimalMixin
):


    def __new__(
        cls,
        *args: typing.Union[None, decimal.Decimal, int, ],
        _configuration: typing.Optional[schemas.Configuration] = None,
    ) -> 'ChunkOverlapSchema':
        return super().__new__(
            cls,
            *args,
            _configuration=_configuration,
        )
SkipEmbeddingGenerationSchema = schemas.BoolSchema
SetPageAsBoundarySchema = schemas.BoolSchema


class EmbeddingModelSchema(
    schemas.ComposedSchema,
):


    class MetaOapg:
        
        @classmethod
        @functools.lru_cache()
        def any_of(cls):
            # we need this here to make our import statements work
            # we must store _composed_schemas in here so the code is only run
            # when we invoke this method. If we kept this at the class
            # level we would get an error because the class level
            # code would be run when this module is imported, and these composed
            # classes don't exist yet because their module has not finished
            # loading
            return [
                TextEmbeddingGeneratorsSchema,
                MultiModalEmbeddingGeneratorsSchema,
            ]


    def __new__(
        cls,
        *args: typing.Union[dict, frozendict.frozendict, str, date, datetime, uuid.UUID, int, float, decimal.Decimal, bool, None, list, tuple, bytes, io.FileIO, io.BufferedReader, ],
        _configuration: typing.Optional[schemas.Configuration] = None,
        **kwargs: typing.Union[schemas.AnyTypeSchema, dict, frozendict.frozendict, str, date, datetime, uuid.UUID, int, float, decimal.Decimal, None, list, tuple, bytes],
    ) -> 'EmbeddingModelSchema':
        return super().__new__(
            cls,
            *args,
            _configuration=_configuration,
            **kwargs,
        )
UseOcrSchema = schemas.BoolSchema
GenerateSparseVectorsSchema = schemas.BoolSchema
PrependFilenameToChunksSchema = schemas.BoolSchema


class MaxItemsPerChunkSchema(
    schemas.IntBase,
    schemas.NoneBase,
    schemas.Schema,
    schemas.NoneDecimalMixin
):


    def __new__(
        cls,
        *args: typing.Union[None, decimal.Decimal, int, ],
        _configuration: typing.Optional[schemas.Configuration] = None,
    ) -> 'MaxItemsPerChunkSchema':
        return super().__new__(
            cls,
            *args,
            _configuration=_configuration,
        )
ParsePdfTablesWithOcrSchema = schemas.BoolSchema
DetectAudioLanguageSchema = schemas.BoolSchema
TranscriptionServiceSchema = TranscriptionServiceNullableSchema
IncludeSpeakerLabelsSchema = schemas.BoolSchema
MediaTypeSchema = FileContentTypesNullableSchema
SplitRowsSchema = schemas.BoolSchema
EnableColdStorageSchema = schemas.BoolSchema


class HotStorageTimeToLiveSchema(
    schemas.IntBase,
    schemas.NoneBase,
    schemas.Schema,
    schemas.NoneDecimalMixin
):


    def __new__(
        cls,
        *args: typing.Union[None, decimal.Decimal, int, ],
        _configuration: typing.Optional[schemas.Configuration] = None,
    ) -> 'HotStorageTimeToLiveSchema':
        return super().__new__(
            cls,
            *args,
            _configuration=_configuration,
        )
GenerateChunksOnlySchema = schemas.BoolSchema
StoreFileOnlySchema = schemas.BoolSchema
RequestRequiredQueryParams = typing_extensions.TypedDict(
    'RequestRequiredQueryParams',
    {
    }
)
RequestOptionalQueryParams = typing_extensions.TypedDict(
    'RequestOptionalQueryParams',
    {
        'chunk_size': typing.Union[ChunkSizeSchema, None, decimal.Decimal, int, ],
        'chunk_overlap': typing.Union[ChunkOverlapSchema, None, decimal.Decimal, int, ],
        'skip_embedding_generation': typing.Union[SkipEmbeddingGenerationSchema, bool, ],
        'set_page_as_boundary': typing.Union[SetPageAsBoundarySchema, bool, ],
        'embedding_model': typing.Union[EmbeddingModelSchema, dict, frozendict.frozendict, str, date, datetime, uuid.UUID, int, float, decimal.Decimal, bool, None, list, tuple, bytes, io.FileIO, io.BufferedReader, ],
        'use_ocr': typing.Union[UseOcrSchema, bool, ],
        'generate_sparse_vectors': typing.Union[GenerateSparseVectorsSchema, bool, ],
        'prepend_filename_to_chunks': typing.Union[PrependFilenameToChunksSchema, bool, ],
        'max_items_per_chunk': typing.Union[MaxItemsPerChunkSchema, None, decimal.Decimal, int, ],
        'parse_pdf_tables_with_ocr': typing.Union[ParsePdfTablesWithOcrSchema, bool, ],
        'detect_audio_language': typing.Union[DetectAudioLanguageSchema, bool, ],
        'transcription_service': typing.Union[TranscriptionServiceSchema, ],
        'include_speaker_labels': typing.Union[IncludeSpeakerLabelsSchema, bool, ],
        'media_type': typing.Union[MediaTypeSchema, ],
        'split_rows': typing.Union[SplitRowsSchema, bool, ],
        'enable_cold_storage': typing.Union[EnableColdStorageSchema, bool, ],
        'hot_storage_time_to_live': typing.Union[HotStorageTimeToLiveSchema, None, decimal.Decimal, int, ],
        'generate_chunks_only': typing.Union[GenerateChunksOnlySchema, bool, ],
        'store_file_only': typing.Union[StoreFileOnlySchema, bool, ],
    },
    total=False
)


class RequestQueryParams(RequestRequiredQueryParams, RequestOptionalQueryParams):
    pass


request_query_chunk_size = api_client.QueryParameter(
    name="chunk_size",
    style=api_client.ParameterStyle.FORM,
    schema=ChunkSizeSchema,
    explode=True,
)
request_query_chunk_overlap = api_client.QueryParameter(
    name="chunk_overlap",
    style=api_client.ParameterStyle.FORM,
    schema=ChunkOverlapSchema,
    explode=True,
)
request_query_skip_embedding_generation = api_client.QueryParameter(
    name="skip_embedding_generation",
    style=api_client.ParameterStyle.FORM,
    schema=SkipEmbeddingGenerationSchema,
    explode=True,
)
request_query_set_page_as_boundary = api_client.QueryParameter(
    name="set_page_as_boundary",
    style=api_client.ParameterStyle.FORM,
    schema=SetPageAsBoundarySchema,
    explode=True,
)
request_query_embedding_model = api_client.QueryParameter(
    name="embedding_model",
    style=api_client.ParameterStyle.FORM,
    schema=EmbeddingModelSchema,
    explode=True,
)
request_query_use_ocr = api_client.QueryParameter(
    name="use_ocr",
    style=api_client.ParameterStyle.FORM,
    schema=UseOcrSchema,
    explode=True,
)
request_query_generate_sparse_vectors = api_client.QueryParameter(
    name="generate_sparse_vectors",
    style=api_client.ParameterStyle.FORM,
    schema=GenerateSparseVectorsSchema,
    explode=True,
)
request_query_prepend_filename_to_chunks = api_client.QueryParameter(
    name="prepend_filename_to_chunks",
    style=api_client.ParameterStyle.FORM,
    schema=PrependFilenameToChunksSchema,
    explode=True,
)
request_query_max_items_per_chunk = api_client.QueryParameter(
    name="max_items_per_chunk",
    style=api_client.ParameterStyle.FORM,
    schema=MaxItemsPerChunkSchema,
    explode=True,
)
request_query_parse_pdf_tables_with_ocr = api_client.QueryParameter(
    name="parse_pdf_tables_with_ocr",
    style=api_client.ParameterStyle.FORM,
    schema=ParsePdfTablesWithOcrSchema,
    explode=True,
)
request_query_detect_audio_language = api_client.QueryParameter(
    name="detect_audio_language",
    style=api_client.ParameterStyle.FORM,
    schema=DetectAudioLanguageSchema,
    explode=True,
)
request_query_transcription_service = api_client.QueryParameter(
    name="transcription_service",
    style=api_client.ParameterStyle.FORM,
    schema=TranscriptionServiceNullableSchema,
    explode=True,
)
request_query_include_speaker_labels = api_client.QueryParameter(
    name="include_speaker_labels",
    style=api_client.ParameterStyle.FORM,
    schema=IncludeSpeakerLabelsSchema,
    explode=True,
)
request_query_media_type = api_client.QueryParameter(
    name="media_type",
    style=api_client.ParameterStyle.FORM,
    schema=FileContentTypesNullableSchema,
    explode=True,
)
request_query_split_rows = api_client.QueryParameter(
    name="split_rows",
    style=api_client.ParameterStyle.FORM,
    schema=SplitRowsSchema,
    explode=True,
)
request_query_enable_cold_storage = api_client.QueryParameter(
    name="enable_cold_storage",
    style=api_client.ParameterStyle.FORM,
    schema=EnableColdStorageSchema,
    explode=True,
)
request_query_hot_storage_time_to_live = api_client.QueryParameter(
    name="hot_storage_time_to_live",
    style=api_client.ParameterStyle.FORM,
    schema=HotStorageTimeToLiveSchema,
    explode=True,
)
request_query_generate_chunks_only = api_client.QueryParameter(
    name="generate_chunks_only",
    style=api_client.ParameterStyle.FORM,
    schema=GenerateChunksOnlySchema,
    explode=True,
)
request_query_store_file_only = api_client.QueryParameter(
    name="store_file_only",
    style=api_client.ParameterStyle.FORM,
    schema=StoreFileOnlySchema,
    explode=True,
)
# body param
SchemaForRequestBodyMultipartFormData = BodyCreateUploadFileUploadfilePostSchema


request_body_body_create_upload_file_uploadfile_post = api_client.RequestBody(
    content={
        'multipart/form-data': api_client.MediaType(
            schema=SchemaForRequestBodyMultipartFormData),
    },
    required=True,
)
SchemaFor200ResponseBodyApplicationJson = UserFileSchema


@dataclass
class ApiResponseFor200(api_client.ApiResponse):
    body: UserFile


@dataclass
class ApiResponseFor200Async(api_client.AsyncApiResponse):
    body: UserFile


_response_for_200 = api_client.OpenApiResponse(
    response_cls=ApiResponseFor200,
    response_cls_async=ApiResponseFor200Async,
    content={
        'application/json': api_client.MediaType(
            schema=SchemaFor200ResponseBodyApplicationJson),
    },
)
SchemaFor422ResponseBodyApplicationJson = HTTPValidationErrorSchema


@dataclass
class ApiResponseFor422(api_client.ApiResponse):
    body: HTTPValidationError


@dataclass
class ApiResponseFor422Async(api_client.AsyncApiResponse):
    body: HTTPValidationError


_response_for_422 = api_client.OpenApiResponse(
    response_cls=ApiResponseFor422,
    response_cls_async=ApiResponseFor422Async,
    content={
        'application/json': api_client.MediaType(
            schema=SchemaFor422ResponseBodyApplicationJson),
    },
)
_all_accept_content_types = (
    'application/json',
)


class BaseApi(api_client.Api):

    def _upload_mapped_args(
        self,
        file: typing.IO,
        chunk_size: typing.Optional[typing.Optional[int]] = None,
        chunk_overlap: typing.Optional[typing.Optional[int]] = None,
        skip_embedding_generation: typing.Optional[bool] = None,
        set_page_as_boundary: typing.Optional[bool] = None,
        embedding_model: typing.Optional[typing.Union[TextEmbeddingGenerators, MultiModalEmbeddingGenerators]] = None,
        use_ocr: typing.Optional[bool] = None,
        generate_sparse_vectors: typing.Optional[bool] = None,
        prepend_filename_to_chunks: typing.Optional[bool] = None,
        max_items_per_chunk: typing.Optional[typing.Optional[int]] = None,
        parse_pdf_tables_with_ocr: typing.Optional[bool] = None,
        detect_audio_language: typing.Optional[bool] = None,
        transcription_service: typing.Optional[TranscriptionServiceNullable] = None,
        include_speaker_labels: typing.Optional[bool] = None,
        media_type: typing.Optional[FileContentTypesNullable] = None,
        split_rows: typing.Optional[bool] = None,
        enable_cold_storage: typing.Optional[bool] = None,
        hot_storage_time_to_live: typing.Optional[typing.Optional[int]] = None,
        generate_chunks_only: typing.Optional[bool] = None,
        store_file_only: typing.Optional[bool] = None,
    ) -> api_client.MappedArgs:
        args: api_client.MappedArgs = api_client.MappedArgs()
        _query_params = {}
        _body = {}
        if file is not None:
            _body["file"] = file
        args.body = _body
        if chunk_size is not None:
            _query_params["chunk_size"] = chunk_size
        if chunk_overlap is not None:
            _query_params["chunk_overlap"] = chunk_overlap
        if skip_embedding_generation is not None:
            _query_params["skip_embedding_generation"] = skip_embedding_generation
        if set_page_as_boundary is not None:
            _query_params["set_page_as_boundary"] = set_page_as_boundary
        if embedding_model is not None:
            _query_params["embedding_model"] = embedding_model
        if use_ocr is not None:
            _query_params["use_ocr"] = use_ocr
        if generate_sparse_vectors is not None:
            _query_params["generate_sparse_vectors"] = generate_sparse_vectors
        if prepend_filename_to_chunks is not None:
            _query_params["prepend_filename_to_chunks"] = prepend_filename_to_chunks
        if max_items_per_chunk is not None:
            _query_params["max_items_per_chunk"] = max_items_per_chunk
        if parse_pdf_tables_with_ocr is not None:
            _query_params["parse_pdf_tables_with_ocr"] = parse_pdf_tables_with_ocr
        if detect_audio_language is not None:
            _query_params["detect_audio_language"] = detect_audio_language
        if transcription_service is not None:
            _query_params["transcription_service"] = transcription_service
        if include_speaker_labels is not None:
            _query_params["include_speaker_labels"] = include_speaker_labels
        if media_type is not None:
            _query_params["media_type"] = media_type
        if split_rows is not None:
            _query_params["split_rows"] = split_rows
        if enable_cold_storage is not None:
            _query_params["enable_cold_storage"] = enable_cold_storage
        if hot_storage_time_to_live is not None:
            _query_params["hot_storage_time_to_live"] = hot_storage_time_to_live
        if generate_chunks_only is not None:
            _query_params["generate_chunks_only"] = generate_chunks_only
        if store_file_only is not None:
            _query_params["store_file_only"] = store_file_only
        args.query = _query_params
        return args

    async def _aupload_oapg(
        self,
        body: typing.Any = None,
            query_params: typing.Optional[dict] = {},
        skip_deserialization: bool = True,
        timeout: typing.Optional[typing.Union[float, typing.Tuple]] = None,
        accept_content_types: typing.Tuple[str] = _all_accept_content_types,
        content_type: str = 'multipart/form-data',
        stream: bool = False,
        **kwargs,
    ) -> typing.Union[
        ApiResponseFor200Async,
        api_client.ApiResponseWithoutDeserializationAsync,
        AsyncGeneratorResponse,
    ]:
        """
        Create Upload File
        :param skip_deserialization: If true then api_response.response will be set but
            api_response.body and api_response.headers will not be deserialized into schema
            class instances
        """
        self._verify_typed_dict_inputs_oapg(RequestQueryParams, query_params)
        used_path = path.value
    
        prefix_separator_iterator = None
        for parameter in (
            request_query_chunk_size,
            request_query_chunk_overlap,
            request_query_skip_embedding_generation,
            request_query_set_page_as_boundary,
            request_query_embedding_model,
            request_query_use_ocr,
            request_query_generate_sparse_vectors,
            request_query_prepend_filename_to_chunks,
            request_query_max_items_per_chunk,
            request_query_parse_pdf_tables_with_ocr,
            request_query_detect_audio_language,
            request_query_transcription_service,
            request_query_include_speaker_labels,
            request_query_media_type,
            request_query_split_rows,
            request_query_enable_cold_storage,
            request_query_hot_storage_time_to_live,
            request_query_generate_chunks_only,
            request_query_store_file_only,
        ):
            parameter_data = query_params.get(parameter.name, schemas.unset)
            if parameter_data is schemas.unset:
                continue
            if prefix_separator_iterator is None:
                prefix_separator_iterator = parameter.get_prefix_separator_iterator()
            serialized_data = parameter.serialize(parameter_data, prefix_separator_iterator)
            for serialized_value in serialized_data.values():
                used_path += serialized_value
    
        _headers = HTTPHeaderDict()
        # TODO add cookie handling
        if accept_content_types:
            for accept_content_type in accept_content_types:
                _headers.add('Accept', accept_content_type)
        method = 'post'.upper()
        _headers.add('Content-Type', content_type)
    
        if body is schemas.unset:
            raise exceptions.ApiValueError(
                'The required body parameter has an invalid value of: unset. Set a valid value instead')
        _fields = None
        _body = None
        request_before_hook(
            resource_path=used_path,
            method=method,
            configuration=self.api_client.configuration,
            path_template='/uploadfile',
            body=body,
            auth_settings=_auth,
            headers=_headers,
        )
        serialized_data = request_body_body_create_upload_file_uploadfile_post.serialize(body, content_type)
        if 'fields' in serialized_data:
            _fields = serialized_data['fields']
        elif 'body' in serialized_data:
            _body = serialized_data['body']
    
        response = await self.api_client.async_call_api(
            resource_path=used_path,
            method=method,
            headers=_headers,
            fields=_fields,
            serialized_body=_body,
            body=body,
            auth_settings=_auth,
            prefix_separator_iterator=prefix_separator_iterator,
            timeout=timeout,
            **kwargs
        )
    
        if stream:
            if not 200 <= response.http_response.status <= 299:
                body = (await response.http_response.content.read()).decode("utf-8")
                raise exceptions.ApiStreamingException(
                    status=response.http_response.status,
                    reason=response.http_response.reason,
                    body=body,
                )
    
            async def stream_iterator():
                """
                iterates over response.http_response.content and closes connection once iteration has finished
                """
                async for line in response.http_response.content:
                    if line == b'\r\n':
                        continue
                    yield line
                response.http_response.close()
                await response.session.close()
            return AsyncGeneratorResponse(
                content=stream_iterator(),
                headers=response.http_response.headers,
                status=response.http_response.status,
                response=response.http_response
            )
    
        response_for_status = _status_code_to_response.get(str(response.http_response.status))
        if response_for_status:
            api_response = await response_for_status.deserialize_async(
                                                    response,
                                                    self.api_client.configuration,
                                                    skip_deserialization=skip_deserialization
                                                )
        else:
            # If response data is JSON then deserialize for SDK consumer convenience
            is_json = api_client.JSONDetector._content_type_is_json(response.http_response.headers.get('Content-Type', ''))
            api_response = api_client.ApiResponseWithoutDeserializationAsync(
                body=await response.http_response.json() if is_json else await response.http_response.text(),
                response=response.http_response,
                round_trip_time=response.round_trip_time,
                status=response.http_response.status,
                headers=response.http_response.headers,
            )
    
        if not 200 <= api_response.status <= 299:
            raise exceptions.ApiException(api_response=api_response)
    
        # cleanup session / response
        response.http_response.close()
        await response.session.close()
    
        return api_response


    def _upload_oapg(
        self,
        body: typing.Any = None,
            query_params: typing.Optional[dict] = {},
        skip_deserialization: bool = True,
        timeout: typing.Optional[typing.Union[float, typing.Tuple]] = None,
        accept_content_types: typing.Tuple[str] = _all_accept_content_types,
        content_type: str = 'multipart/form-data',
        stream: bool = False,
    ) -> typing.Union[
        ApiResponseFor200,
        api_client.ApiResponseWithoutDeserialization,
    ]:
        """
        Create Upload File
        :param skip_deserialization: If true then api_response.response will be set but
            api_response.body and api_response.headers will not be deserialized into schema
            class instances
        """
        self._verify_typed_dict_inputs_oapg(RequestQueryParams, query_params)
        used_path = path.value
    
        prefix_separator_iterator = None
        for parameter in (
            request_query_chunk_size,
            request_query_chunk_overlap,
            request_query_skip_embedding_generation,
            request_query_set_page_as_boundary,
            request_query_embedding_model,
            request_query_use_ocr,
            request_query_generate_sparse_vectors,
            request_query_prepend_filename_to_chunks,
            request_query_max_items_per_chunk,
            request_query_parse_pdf_tables_with_ocr,
            request_query_detect_audio_language,
            request_query_transcription_service,
            request_query_include_speaker_labels,
            request_query_media_type,
            request_query_split_rows,
            request_query_enable_cold_storage,
            request_query_hot_storage_time_to_live,
            request_query_generate_chunks_only,
            request_query_store_file_only,
        ):
            parameter_data = query_params.get(parameter.name, schemas.unset)
            if parameter_data is schemas.unset:
                continue
            if prefix_separator_iterator is None:
                prefix_separator_iterator = parameter.get_prefix_separator_iterator()
            serialized_data = parameter.serialize(parameter_data, prefix_separator_iterator)
            for serialized_value in serialized_data.values():
                used_path += serialized_value
    
        _headers = HTTPHeaderDict()
        # TODO add cookie handling
        if accept_content_types:
            for accept_content_type in accept_content_types:
                _headers.add('Accept', accept_content_type)
        method = 'post'.upper()
        _headers.add('Content-Type', content_type)
    
        if body is schemas.unset:
            raise exceptions.ApiValueError(
                'The required body parameter has an invalid value of: unset. Set a valid value instead')
        _fields = None
        _body = None
        request_before_hook(
            resource_path=used_path,
            method=method,
            configuration=self.api_client.configuration,
            path_template='/uploadfile',
            body=body,
            auth_settings=_auth,
            headers=_headers,
        )
        serialized_data = request_body_body_create_upload_file_uploadfile_post.serialize(body, content_type)
        if 'fields' in serialized_data:
            _fields = serialized_data['fields']
        elif 'body' in serialized_data:
            _body = serialized_data['body']
    
        response = self.api_client.call_api(
            resource_path=used_path,
            method=method,
            headers=_headers,
            fields=_fields,
            serialized_body=_body,
            body=body,
            auth_settings=_auth,
            prefix_separator_iterator=prefix_separator_iterator,
            timeout=timeout,
        )
    
        response_for_status = _status_code_to_response.get(str(response.http_response.status))
        if response_for_status:
            api_response = response_for_status.deserialize(
                                                    response,
                                                    self.api_client.configuration,
                                                    skip_deserialization=skip_deserialization
                                                )
        else:
            # If response data is JSON then deserialize for SDK consumer convenience
            is_json = api_client.JSONDetector._content_type_is_json(response.http_response.headers.get('Content-Type', ''))
            api_response = api_client.ApiResponseWithoutDeserialization(
                body=json.loads(response.http_response.data) if is_json else response.http_response.data,
                response=response.http_response,
                round_trip_time=response.round_trip_time,
                status=response.http_response.status,
                headers=response.http_response.headers,
            )
    
        if not 200 <= api_response.status <= 299:
            raise exceptions.ApiException(api_response=api_response)
    
        return api_response


class UploadRaw(BaseApi):
    # this class is used by api classes that refer to endpoints with operationId fn names

    async def aupload(
        self,
        file: typing.IO,
        chunk_size: typing.Optional[typing.Optional[int]] = None,
        chunk_overlap: typing.Optional[typing.Optional[int]] = None,
        skip_embedding_generation: typing.Optional[bool] = None,
        set_page_as_boundary: typing.Optional[bool] = None,
        embedding_model: typing.Optional[typing.Union[TextEmbeddingGenerators, MultiModalEmbeddingGenerators]] = None,
        use_ocr: typing.Optional[bool] = None,
        generate_sparse_vectors: typing.Optional[bool] = None,
        prepend_filename_to_chunks: typing.Optional[bool] = None,
        max_items_per_chunk: typing.Optional[typing.Optional[int]] = None,
        parse_pdf_tables_with_ocr: typing.Optional[bool] = None,
        detect_audio_language: typing.Optional[bool] = None,
        transcription_service: typing.Optional[TranscriptionServiceNullable] = None,
        include_speaker_labels: typing.Optional[bool] = None,
        media_type: typing.Optional[FileContentTypesNullable] = None,
        split_rows: typing.Optional[bool] = None,
        enable_cold_storage: typing.Optional[bool] = None,
        hot_storage_time_to_live: typing.Optional[typing.Optional[int]] = None,
        generate_chunks_only: typing.Optional[bool] = None,
        store_file_only: typing.Optional[bool] = None,
        **kwargs,
    ) -> typing.Union[
        ApiResponseFor200Async,
        api_client.ApiResponseWithoutDeserializationAsync,
        AsyncGeneratorResponse,
    ]:
        args = self._upload_mapped_args(
            file=file,
            chunk_size=chunk_size,
            chunk_overlap=chunk_overlap,
            skip_embedding_generation=skip_embedding_generation,
            set_page_as_boundary=set_page_as_boundary,
            embedding_model=embedding_model,
            use_ocr=use_ocr,
            generate_sparse_vectors=generate_sparse_vectors,
            prepend_filename_to_chunks=prepend_filename_to_chunks,
            max_items_per_chunk=max_items_per_chunk,
            parse_pdf_tables_with_ocr=parse_pdf_tables_with_ocr,
            detect_audio_language=detect_audio_language,
            transcription_service=transcription_service,
            include_speaker_labels=include_speaker_labels,
            media_type=media_type,
            split_rows=split_rows,
            enable_cold_storage=enable_cold_storage,
            hot_storage_time_to_live=hot_storage_time_to_live,
            generate_chunks_only=generate_chunks_only,
            store_file_only=store_file_only,
        )
        return await self._aupload_oapg(
            body=args.body,
            query_params=args.query,
            **kwargs,
        )
    
    def upload(
        self,
        file: typing.IO,
        chunk_size: typing.Optional[typing.Optional[int]] = None,
        chunk_overlap: typing.Optional[typing.Optional[int]] = None,
        skip_embedding_generation: typing.Optional[bool] = None,
        set_page_as_boundary: typing.Optional[bool] = None,
        embedding_model: typing.Optional[typing.Union[TextEmbeddingGenerators, MultiModalEmbeddingGenerators]] = None,
        use_ocr: typing.Optional[bool] = None,
        generate_sparse_vectors: typing.Optional[bool] = None,
        prepend_filename_to_chunks: typing.Optional[bool] = None,
        max_items_per_chunk: typing.Optional[typing.Optional[int]] = None,
        parse_pdf_tables_with_ocr: typing.Optional[bool] = None,
        detect_audio_language: typing.Optional[bool] = None,
        transcription_service: typing.Optional[TranscriptionServiceNullable] = None,
        include_speaker_labels: typing.Optional[bool] = None,
        media_type: typing.Optional[FileContentTypesNullable] = None,
        split_rows: typing.Optional[bool] = None,
        enable_cold_storage: typing.Optional[bool] = None,
        hot_storage_time_to_live: typing.Optional[typing.Optional[int]] = None,
        generate_chunks_only: typing.Optional[bool] = None,
        store_file_only: typing.Optional[bool] = None,
    ) -> typing.Union[
        ApiResponseFor200,
        api_client.ApiResponseWithoutDeserialization,
    ]:
        """ This endpoint is used to directly upload local files to Carbon. The `POST` request should be a multipart form request. Note that the `set_page_as_boundary` query parameter is applicable only to PDFs for now. When this value is set, PDF chunks are at most one page long. Additional information can be retrieved for each chunk, however, namely the coordinates of the bounding box around the chunk (this can be used for things like text highlighting). Following is a description of all possible query parameters: - `chunk_size`: the chunk size (in tokens) applied when splitting the document - `chunk_overlap`: the chunk overlap (in tokens) applied when splitting the document - `skip_embedding_generation`: whether or not to skip the generation of chunks and embeddings - `set_page_as_boundary`: described above - `embedding_model`: the model used to generate embeddings for the document chunks - `use_ocr`: whether or not to use OCR as a preprocessing step prior to generating chunks. Valid for PDFs, JPEGs, and PNGs - `generate_sparse_vectors`: whether or not to generate sparse vectors for the file. Required for hybrid search. - `prepend_filename_to_chunks`: whether or not to prepend the filename to the chunk text   Carbon supports multiple models for use in generating embeddings for files. For images, we support Vertex AI's multimodal model; for text, we support OpenAI's `text-embedding-ada-002` and Cohere's embed-multilingual-v3.0. The model can be specified via the `embedding_model` parameter (in the POST body for `/embeddings`, and a query  parameter in `/uploadfile`). If no model is supplied, the `text-embedding-ada-002` is used by default. When performing embedding queries, embeddings from files that used the specified model will be considered in the query. For example, if files A and B have embeddings generated with `OPENAI`, and files C and D have embeddings generated with `COHERE_MULTILINGUAL_V3`, then by default, queries will only consider files A and B. If `COHERE_MULTILINGUAL_V3` is specified as the `embedding_model` in `/embeddings`, then only files C and D will be considered. Make sure that the set of all files you want considered for a query have embeddings generated via the same model. For now, **do not** set `VERTEX_MULTIMODAL` as an `embedding_model`. This model is used automatically by Carbon when it detects an image file. """
        args = self._upload_mapped_args(
            file=file,
            chunk_size=chunk_size,
            chunk_overlap=chunk_overlap,
            skip_embedding_generation=skip_embedding_generation,
            set_page_as_boundary=set_page_as_boundary,
            embedding_model=embedding_model,
            use_ocr=use_ocr,
            generate_sparse_vectors=generate_sparse_vectors,
            prepend_filename_to_chunks=prepend_filename_to_chunks,
            max_items_per_chunk=max_items_per_chunk,
            parse_pdf_tables_with_ocr=parse_pdf_tables_with_ocr,
            detect_audio_language=detect_audio_language,
            transcription_service=transcription_service,
            include_speaker_labels=include_speaker_labels,
            media_type=media_type,
            split_rows=split_rows,
            enable_cold_storage=enable_cold_storage,
            hot_storage_time_to_live=hot_storage_time_to_live,
            generate_chunks_only=generate_chunks_only,
            store_file_only=store_file_only,
        )
        return self._upload_oapg(
            body=args.body,
            query_params=args.query,
        )

class Upload(BaseApi):

    async def aupload(
        self,
        file: typing.IO,
        chunk_size: typing.Optional[typing.Optional[int]] = None,
        chunk_overlap: typing.Optional[typing.Optional[int]] = None,
        skip_embedding_generation: typing.Optional[bool] = None,
        set_page_as_boundary: typing.Optional[bool] = None,
        embedding_model: typing.Optional[typing.Union[TextEmbeddingGenerators, MultiModalEmbeddingGenerators]] = None,
        use_ocr: typing.Optional[bool] = None,
        generate_sparse_vectors: typing.Optional[bool] = None,
        prepend_filename_to_chunks: typing.Optional[bool] = None,
        max_items_per_chunk: typing.Optional[typing.Optional[int]] = None,
        parse_pdf_tables_with_ocr: typing.Optional[bool] = None,
        detect_audio_language: typing.Optional[bool] = None,
        transcription_service: typing.Optional[TranscriptionServiceNullable] = None,
        include_speaker_labels: typing.Optional[bool] = None,
        media_type: typing.Optional[FileContentTypesNullable] = None,
        split_rows: typing.Optional[bool] = None,
        enable_cold_storage: typing.Optional[bool] = None,
        hot_storage_time_to_live: typing.Optional[typing.Optional[int]] = None,
        generate_chunks_only: typing.Optional[bool] = None,
        store_file_only: typing.Optional[bool] = None,
        validate: bool = False,
        **kwargs,
    ) -> UserFilePydantic:
        raw_response = await self.raw.aupload(
            file=file,
            chunk_size=chunk_size,
            chunk_overlap=chunk_overlap,
            skip_embedding_generation=skip_embedding_generation,
            set_page_as_boundary=set_page_as_boundary,
            embedding_model=embedding_model,
            use_ocr=use_ocr,
            generate_sparse_vectors=generate_sparse_vectors,
            prepend_filename_to_chunks=prepend_filename_to_chunks,
            max_items_per_chunk=max_items_per_chunk,
            parse_pdf_tables_with_ocr=parse_pdf_tables_with_ocr,
            detect_audio_language=detect_audio_language,
            transcription_service=transcription_service,
            include_speaker_labels=include_speaker_labels,
            media_type=media_type,
            split_rows=split_rows,
            enable_cold_storage=enable_cold_storage,
            hot_storage_time_to_live=hot_storage_time_to_live,
            generate_chunks_only=generate_chunks_only,
            store_file_only=store_file_only,
            **kwargs,
        )
        if validate:
            return UserFilePydantic(**raw_response.body)
        return api_client.construct_model_instance(UserFilePydantic, raw_response.body)
    
    
    def upload(
        self,
        file: typing.IO,
        chunk_size: typing.Optional[typing.Optional[int]] = None,
        chunk_overlap: typing.Optional[typing.Optional[int]] = None,
        skip_embedding_generation: typing.Optional[bool] = None,
        set_page_as_boundary: typing.Optional[bool] = None,
        embedding_model: typing.Optional[typing.Union[TextEmbeddingGenerators, MultiModalEmbeddingGenerators]] = None,
        use_ocr: typing.Optional[bool] = None,
        generate_sparse_vectors: typing.Optional[bool] = None,
        prepend_filename_to_chunks: typing.Optional[bool] = None,
        max_items_per_chunk: typing.Optional[typing.Optional[int]] = None,
        parse_pdf_tables_with_ocr: typing.Optional[bool] = None,
        detect_audio_language: typing.Optional[bool] = None,
        transcription_service: typing.Optional[TranscriptionServiceNullable] = None,
        include_speaker_labels: typing.Optional[bool] = None,
        media_type: typing.Optional[FileContentTypesNullable] = None,
        split_rows: typing.Optional[bool] = None,
        enable_cold_storage: typing.Optional[bool] = None,
        hot_storage_time_to_live: typing.Optional[typing.Optional[int]] = None,
        generate_chunks_only: typing.Optional[bool] = None,
        store_file_only: typing.Optional[bool] = None,
        validate: bool = False,
    ) -> UserFilePydantic:
        raw_response = self.raw.upload(
            file=file,
            chunk_size=chunk_size,
            chunk_overlap=chunk_overlap,
            skip_embedding_generation=skip_embedding_generation,
            set_page_as_boundary=set_page_as_boundary,
            embedding_model=embedding_model,
            use_ocr=use_ocr,
            generate_sparse_vectors=generate_sparse_vectors,
            prepend_filename_to_chunks=prepend_filename_to_chunks,
            max_items_per_chunk=max_items_per_chunk,
            parse_pdf_tables_with_ocr=parse_pdf_tables_with_ocr,
            detect_audio_language=detect_audio_language,
            transcription_service=transcription_service,
            include_speaker_labels=include_speaker_labels,
            media_type=media_type,
            split_rows=split_rows,
            enable_cold_storage=enable_cold_storage,
            hot_storage_time_to_live=hot_storage_time_to_live,
            generate_chunks_only=generate_chunks_only,
            store_file_only=store_file_only,
        )
        if validate:
            return UserFilePydantic(**raw_response.body)
        return api_client.construct_model_instance(UserFilePydantic, raw_response.body)


class ApiForpost(BaseApi):
    # this class is used by api classes that refer to endpoints by path and http method names

    async def apost(
        self,
        file: typing.IO,
        chunk_size: typing.Optional[typing.Optional[int]] = None,
        chunk_overlap: typing.Optional[typing.Optional[int]] = None,
        skip_embedding_generation: typing.Optional[bool] = None,
        set_page_as_boundary: typing.Optional[bool] = None,
        embedding_model: typing.Optional[typing.Union[TextEmbeddingGenerators, MultiModalEmbeddingGenerators]] = None,
        use_ocr: typing.Optional[bool] = None,
        generate_sparse_vectors: typing.Optional[bool] = None,
        prepend_filename_to_chunks: typing.Optional[bool] = None,
        max_items_per_chunk: typing.Optional[typing.Optional[int]] = None,
        parse_pdf_tables_with_ocr: typing.Optional[bool] = None,
        detect_audio_language: typing.Optional[bool] = None,
        transcription_service: typing.Optional[TranscriptionServiceNullable] = None,
        include_speaker_labels: typing.Optional[bool] = None,
        media_type: typing.Optional[FileContentTypesNullable] = None,
        split_rows: typing.Optional[bool] = None,
        enable_cold_storage: typing.Optional[bool] = None,
        hot_storage_time_to_live: typing.Optional[typing.Optional[int]] = None,
        generate_chunks_only: typing.Optional[bool] = None,
        store_file_only: typing.Optional[bool] = None,
        **kwargs,
    ) -> typing.Union[
        ApiResponseFor200Async,
        api_client.ApiResponseWithoutDeserializationAsync,
        AsyncGeneratorResponse,
    ]:
        args = self._upload_mapped_args(
            file=file,
            chunk_size=chunk_size,
            chunk_overlap=chunk_overlap,
            skip_embedding_generation=skip_embedding_generation,
            set_page_as_boundary=set_page_as_boundary,
            embedding_model=embedding_model,
            use_ocr=use_ocr,
            generate_sparse_vectors=generate_sparse_vectors,
            prepend_filename_to_chunks=prepend_filename_to_chunks,
            max_items_per_chunk=max_items_per_chunk,
            parse_pdf_tables_with_ocr=parse_pdf_tables_with_ocr,
            detect_audio_language=detect_audio_language,
            transcription_service=transcription_service,
            include_speaker_labels=include_speaker_labels,
            media_type=media_type,
            split_rows=split_rows,
            enable_cold_storage=enable_cold_storage,
            hot_storage_time_to_live=hot_storage_time_to_live,
            generate_chunks_only=generate_chunks_only,
            store_file_only=store_file_only,
        )
        return await self._aupload_oapg(
            body=args.body,
            query_params=args.query,
            **kwargs,
        )
    
    def post(
        self,
        file: typing.IO,
        chunk_size: typing.Optional[typing.Optional[int]] = None,
        chunk_overlap: typing.Optional[typing.Optional[int]] = None,
        skip_embedding_generation: typing.Optional[bool] = None,
        set_page_as_boundary: typing.Optional[bool] = None,
        embedding_model: typing.Optional[typing.Union[TextEmbeddingGenerators, MultiModalEmbeddingGenerators]] = None,
        use_ocr: typing.Optional[bool] = None,
        generate_sparse_vectors: typing.Optional[bool] = None,
        prepend_filename_to_chunks: typing.Optional[bool] = None,
        max_items_per_chunk: typing.Optional[typing.Optional[int]] = None,
        parse_pdf_tables_with_ocr: typing.Optional[bool] = None,
        detect_audio_language: typing.Optional[bool] = None,
        transcription_service: typing.Optional[TranscriptionServiceNullable] = None,
        include_speaker_labels: typing.Optional[bool] = None,
        media_type: typing.Optional[FileContentTypesNullable] = None,
        split_rows: typing.Optional[bool] = None,
        enable_cold_storage: typing.Optional[bool] = None,
        hot_storage_time_to_live: typing.Optional[typing.Optional[int]] = None,
        generate_chunks_only: typing.Optional[bool] = None,
        store_file_only: typing.Optional[bool] = None,
    ) -> typing.Union[
        ApiResponseFor200,
        api_client.ApiResponseWithoutDeserialization,
    ]:
        """ This endpoint is used to directly upload local files to Carbon. The `POST` request should be a multipart form request. Note that the `set_page_as_boundary` query parameter is applicable only to PDFs for now. When this value is set, PDF chunks are at most one page long. Additional information can be retrieved for each chunk, however, namely the coordinates of the bounding box around the chunk (this can be used for things like text highlighting). Following is a description of all possible query parameters: - `chunk_size`: the chunk size (in tokens) applied when splitting the document - `chunk_overlap`: the chunk overlap (in tokens) applied when splitting the document - `skip_embedding_generation`: whether or not to skip the generation of chunks and embeddings - `set_page_as_boundary`: described above - `embedding_model`: the model used to generate embeddings for the document chunks - `use_ocr`: whether or not to use OCR as a preprocessing step prior to generating chunks. Valid for PDFs, JPEGs, and PNGs - `generate_sparse_vectors`: whether or not to generate sparse vectors for the file. Required for hybrid search. - `prepend_filename_to_chunks`: whether or not to prepend the filename to the chunk text   Carbon supports multiple models for use in generating embeddings for files. For images, we support Vertex AI's multimodal model; for text, we support OpenAI's `text-embedding-ada-002` and Cohere's embed-multilingual-v3.0. The model can be specified via the `embedding_model` parameter (in the POST body for `/embeddings`, and a query  parameter in `/uploadfile`). If no model is supplied, the `text-embedding-ada-002` is used by default. When performing embedding queries, embeddings from files that used the specified model will be considered in the query. For example, if files A and B have embeddings generated with `OPENAI`, and files C and D have embeddings generated with `COHERE_MULTILINGUAL_V3`, then by default, queries will only consider files A and B. If `COHERE_MULTILINGUAL_V3` is specified as the `embedding_model` in `/embeddings`, then only files C and D will be considered. Make sure that the set of all files you want considered for a query have embeddings generated via the same model. For now, **do not** set `VERTEX_MULTIMODAL` as an `embedding_model`. This model is used automatically by Carbon when it detects an image file. """
        args = self._upload_mapped_args(
            file=file,
            chunk_size=chunk_size,
            chunk_overlap=chunk_overlap,
            skip_embedding_generation=skip_embedding_generation,
            set_page_as_boundary=set_page_as_boundary,
            embedding_model=embedding_model,
            use_ocr=use_ocr,
            generate_sparse_vectors=generate_sparse_vectors,
            prepend_filename_to_chunks=prepend_filename_to_chunks,
            max_items_per_chunk=max_items_per_chunk,
            parse_pdf_tables_with_ocr=parse_pdf_tables_with_ocr,
            detect_audio_language=detect_audio_language,
            transcription_service=transcription_service,
            include_speaker_labels=include_speaker_labels,
            media_type=media_type,
            split_rows=split_rows,
            enable_cold_storage=enable_cold_storage,
            hot_storage_time_to_live=hot_storage_time_to_live,
            generate_chunks_only=generate_chunks_only,
            store_file_only=store_file_only,
        )
        return self._upload_oapg(
            body=args.body,
            query_params=args.query,
        )

