# coding: utf-8

"""
    Carbon

    Connect external data to LLMs, no matter the source.

    The version of the OpenAPI document: 1.0.0
    Generated by: https://konfigthis.com
"""

from datetime import datetime, date
import typing
from enum import Enum
from typing_extensions import TypedDict, Literal, TYPE_CHECKING
from pydantic import BaseModel, Field, RootModel, ConfigDict

from carbon.pydantic.issue_pr_nullable import IssuePRNullable
from carbon.pydantic.label import Label
from carbon.pydantic.pr_state import PRState
from carbon.pydantic.user import User
from carbon.pydantic.user_nullable import UserNullable

class Issue(BaseModel):
    title: str = Field(alias='title')

    id: int = Field(alias='id')

    url: str = Field(alias='url')

    html_url: str = Field(alias='html_url')

    number: int = Field(alias='number')

    user: User = Field(alias='user')

    labels: typing.List[Label] = Field(alias='labels')

    state: PRState = Field(alias='state')

    locked: bool = Field(alias='locked')

    num_comments: int = Field(alias='num_comments')

    created_at: str = Field(alias='created_at')

    updated_at: str = Field(alias='updated_at')

    closed_at: typing.Optional[str] = Field(alias='closed_at')

    draft: bool = Field(alias='draft')

    pull_request: IssuePRNullable = Field(alias='pull_request')

    body: str = Field(alias='body')

    closed_by: UserNullable = Field(alias='closed_by')

    model_config = ConfigDict(
        protected_namespaces=(),
        arbitrary_types_allowed=True
    )
