# coding: utf-8

"""
    Carbon

    Connect external data to LLMs, no matter the source.

    The version of the OpenAPI document: 1.0.0
    Generated by: https://konfigthis.com
"""

from datetime import datetime, date
import typing
from enum import Enum
from typing_extensions import TypedDict, Literal, TYPE_CHECKING
from pydantic import BaseModel, Field, RootModel, ConfigDict

from carbon.pydantic.event import Event
from carbon.pydantic.opportunity_status_nullable import OpportunityStatusNullable
from carbon.pydantic.partial_account_nullable import PartialAccountNullable
from carbon.pydantic.partial_contact_nullable import PartialContactNullable
from carbon.pydantic.partial_owner import PartialOwner
from carbon.pydantic.task import Task

class Opportunity(BaseModel):
    description: typing.Optional[str] = Field(alias='description')

    id: str = Field(alias='id')

    owner: PartialOwner = Field(alias='owner')

    name: typing.Optional[str] = Field(alias='name')

    amount: typing.Optional[int] = Field(alias='amount')

    account: PartialAccountNullable = Field(alias='account')

    contact: PartialContactNullable = Field(alias='contact')

    stage: typing.Optional[str] = Field(alias='stage')

    status: OpportunityStatusNullable = Field(alias='status')

    close_date: typing.Optional[str] = Field(alias='close_date')

    last_activity_at: typing.Optional[str] = Field(alias='last_activity_at')

    created_at: str = Field(alias='created_at')

    updated_at: str = Field(alias='updated_at')

    is_deleted: bool = Field(alias='is_deleted')

    remote_data: typing.Optional[typing.Dict[str, typing.Union[bool, date, datetime, dict, float, int, list, str, None]]] = Field(alias='remote_data')

    tasks: typing.Optional[typing.Optional[typing.List[Task]]] = Field(None, alias='tasks')

    events: typing.Optional[typing.Optional[typing.List[Event]]] = Field(None, alias='events')

    model_config = ConfigDict(
        protected_namespaces=(),
        arbitrary_types_allowed=True
    )
