# coding: utf-8

"""
    Carbon

    Connect external data to LLMs, no matter the source.

    The version of the OpenAPI document: 1.0.0
    Generated by: https://konfigthis.com
"""

from datetime import datetime, date
import typing
from enum import Enum
from typing_extensions import TypedDict, Literal, TYPE_CHECKING
from pydantic import BaseModel, Field, RootModel, ConfigDict

from carbon.pydantic.head_or_base import HeadOrBase
from carbon.pydantic.label import Label
from carbon.pydantic.pr_state import PRState
from carbon.pydantic.team import Team
from carbon.pydantic.user import User

class PullRequestExtended(BaseModel):
    title: str = Field(alias='title')

    id: int = Field(alias='id')

    url: str = Field(alias='url')

    number: int = Field(alias='number')

    state: PRState = Field(alias='state')

    user: User = Field(alias='user')

    created_at: str = Field(alias='created_at')

    updated_at: str = Field(alias='updated_at')

    closed_at: typing.Optional[str] = Field(alias='closed_at')

    merged_at: typing.Optional[str] = Field(alias='merged_at')

    requested_reviewers: typing.List[User] = Field(alias='requested_reviewers')

    requested_teams: typing.List[Team] = Field(alias='requested_teams')

    labels: typing.List[Label] = Field(alias='labels')

    draft: bool = Field(alias='draft')

    head: HeadOrBase = Field(alias='head')

    base: HeadOrBase = Field(alias='base')

    remote_data: typing.Optional[typing.Dict[str, typing.Union[bool, date, datetime, dict, float, int, list, str, None]]] = Field(alias='remote_data')

    merged: bool = Field(alias='merged')

    num_comments: int = Field(alias='num_comments')

    num_review_comments: int = Field(alias='num_review_comments')

    num_commits: int = Field(alias='num_commits')

    num_additions: int = Field(alias='num_additions')

    num_deletions: int = Field(alias='num_deletions')

    num_changed_files: int = Field(alias='num_changed_files')

    model_config = ConfigDict(
        protected_namespaces=(),
        arbitrary_types_allowed=True
    )
