# coding: utf-8

"""
    Carbon

    Connect external data to LLMs, no matter the source.

    The version of the OpenAPI document: 1.0.0
    Generated by: https://konfigthis.com
"""

from datetime import datetime, date
import typing
from enum import Enum
from typing_extensions import TypedDict, Literal, TYPE_CHECKING

from carbon.type.event import Event
from carbon.type.opportunity_status_nullable import OpportunityStatusNullable
from carbon.type.partial_account_nullable import PartialAccountNullable
from carbon.type.partial_contact_nullable import PartialContactNullable
from carbon.type.partial_owner import PartialOwner
from carbon.type.task import Task

class RequiredOpportunity(TypedDict):
    description: typing.Optional[str]

    id: str

    owner: PartialOwner

    name: typing.Optional[str]

    amount: typing.Optional[int]

    account: typing.Optional[PartialAccountNullable]

    contact: typing.Optional[PartialContactNullable]

    stage: typing.Optional[str]

    status: typing.Optional[OpportunityStatusNullable]

    close_date: typing.Optional[str]

    last_activity_at: typing.Optional[str]

    created_at: str

    updated_at: str

    is_deleted: bool

    remote_data: typing.Optional[typing.Dict[str, typing.Union[bool, date, datetime, dict, float, int, list, str, None]]]


class OptionalOpportunity(TypedDict, total=False):
    tasks: typing.Optional[typing.List[Task]]

    events: typing.Optional[typing.List[Event]]

class Opportunity(RequiredOpportunity, OptionalOpportunity):
    pass
