# coding: utf-8

"""
    Carbon

    Connect external data to LLMs, no matter the source.

    The version of the OpenAPI document: 1.0.0
    Generated by: https://konfigthis.com
"""

from datetime import datetime, date
import typing
from enum import Enum
from typing_extensions import TypedDict, Literal, TYPE_CHECKING

from carbon.type.embedding_generators import EmbeddingGenerators
from carbon.type.sitemap_scrape_request_css_classes_to_skip import SitemapScrapeRequestCssClassesToSkip
from carbon.type.sitemap_scrape_request_css_selectors_to_skip import SitemapScrapeRequestCssSelectorsToSkip
from carbon.type.sitemap_scrape_request_html_tags_to_skip import SitemapScrapeRequestHtmlTagsToSkip
from carbon.type.sitemap_scrape_request_tags import SitemapScrapeRequestTags
from carbon.type.sitemap_scrape_request_url_paths_to_exclude import SitemapScrapeRequestUrlPathsToExclude
from carbon.type.sitemap_scrape_request_url_paths_to_include import SitemapScrapeRequestUrlPathsToInclude
from carbon.type.sitemap_scrape_request_urls_to_scrape import SitemapScrapeRequestUrlsToScrape

class RequiredSitemapScrapeRequest(TypedDict):
    url: str


class OptionalSitemapScrapeRequest(TypedDict, total=False):
    tags: typing.Optional[SitemapScrapeRequestTags]

    max_pages_to_scrape: typing.Optional[int]

    chunk_size: typing.Optional[int]

    chunk_overlap: typing.Optional[int]

    skip_embedding_generation: typing.Optional[bool]

    enable_auto_sync: typing.Optional[bool]

    generate_sparse_vectors: typing.Optional[bool]

    prepend_filename_to_chunks: typing.Optional[bool]

    html_tags_to_skip: typing.Optional[SitemapScrapeRequestHtmlTagsToSkip]

    css_classes_to_skip: typing.Optional[SitemapScrapeRequestCssClassesToSkip]

    css_selectors_to_skip: typing.Optional[SitemapScrapeRequestCssSelectorsToSkip]

    embedding_model: EmbeddingGenerators

    url_paths_to_include: typing.Optional[SitemapScrapeRequestUrlPathsToInclude]

    url_paths_to_exclude: typing.Optional[SitemapScrapeRequestUrlPathsToExclude]

    urls_to_scrape: typing.Optional[SitemapScrapeRequestUrlsToScrape]

    # Whether the scraper should download css and media from the page (images, fonts, etc). Scrapes          might take longer to finish with this flag enabled, but the success rate is improved.
    download_css_and_media: typing.Optional[bool]

    # If this flag is enabled, the file will be chunked and stored with Carbon,           but no embeddings will be generated. This overrides the skip_embedding_generation flag.
    generate_chunks_only: bool

    # If this flag is enabled, the file will be stored with Carbon, but no processing will be done.
    store_file_only: bool

    # If the default proxies are blocked and not returning results, this flag can be enabled to use              alternate proxies (residential and office). Scrapes might take longer to finish with this flag enabled.         
    use_premium_proxies: bool

class SitemapScrapeRequest(RequiredSitemapScrapeRequest, OptionalSitemapScrapeRequest):
    pass
