# coding: utf-8

"""
    Carbon

    Connect external data to LLMs, no matter the source.

    The version of the OpenAPI document: 1.0.0
    Generated by: https://konfigthis.com
"""

from datetime import datetime, date
import typing
from enum import Enum
from typing_extensions import TypedDict, Literal, TYPE_CHECKING

from carbon.type.cold_storage_props import ColdStorageProps
from carbon.type.embedding_generators import EmbeddingGenerators
from carbon.type.file_content_types_nullable import FileContentTypesNullable
from carbon.type.transcription_service_nullable import TranscriptionServiceNullable

class RequiredUploadFileFromUrlInput(TypedDict):
    url: str


class OptionalUploadFileFromUrlInput(TypedDict, total=False):
    file_name: typing.Optional[str]

    chunk_size: typing.Optional[int]

    chunk_overlap: typing.Optional[int]

    skip_embedding_generation: bool

    set_page_as_boundary: bool

    embedding_model: EmbeddingGenerators

    generate_sparse_vectors: bool

    use_textract: bool

    prepend_filename_to_chunks: bool

    # Number of objects per chunk. For csv, tsv, xlsx, and json files only.
    max_items_per_chunk: typing.Optional[int]

    parse_pdf_tables_with_ocr: bool

    detect_audio_language: bool

    transcription_service: typing.Optional[TranscriptionServiceNullable]

    include_speaker_labels: bool

    media_type: typing.Optional[FileContentTypesNullable]

    split_rows: bool

    cold_storage_params: ColdStorageProps

    # If this flag is enabled, the file will be chunked and stored with Carbon,         but no embeddings will be generated. This overrides the skip_embedding_generation flag.
    generate_chunks_only: bool

    # If this flag is enabled, the file will be stored with Carbon, but no processing will be done.
    store_file_only: bool

class UploadFileFromUrlInput(RequiredUploadFileFromUrlInput, OptionalUploadFileFromUrlInput):
    pass
