# coding: utf-8

"""
    Carbon

    Connect external data to LLMs, no matter the source.

    The version of the OpenAPI document: 1.0.0
    Generated by: https://konfigthis.com
"""

from datetime import datetime, date
import typing
from enum import Enum
from typing_extensions import TypedDict, Literal, TYPE_CHECKING

from carbon.type.chunk_properties_nullable import ChunkPropertiesNullable
from carbon.type.data_source_type import DataSourceType
from carbon.type.embedding_storage_status import EmbeddingStorageStatus
from carbon.type.external_file_sync_statuses import ExternalFileSyncStatuses
from carbon.type.file_statistics_nullable import FileStatisticsNullable
from carbon.type.user_file_embedding_properties import UserFileEmbeddingProperties

class RequiredUserFile(TypedDict):
    id: int

    source: DataSourceType

    organization_id: int

    organization_user_id: typing.Optional[int]

    organization_supplied_user_id: str

    external_file_id: str

    sync_status: ExternalFileSyncStatuses

    skip_embedding_generation: bool

    supports_cold_storage: bool

    embedding_storage_status: EmbeddingStorageStatus

    created_at: datetime

    updated_at: datetime


class OptionalUserFile(TypedDict, total=False):
    tags: typing.Optional[typing.Dict[str, typing.Union[bool, date, datetime, dict, float, int, list, str, None]]]

    organization_user_data_source_id: typing.Optional[int]

    external_url: typing.Optional[str]

    sync_error_message: typing.Optional[str]

    last_sync: typing.Optional[datetime]

    file_statistics: typing.Optional[FileStatisticsNullable]

    file_metadata: typing.Optional[typing.Dict[str, typing.Union[bool, date, datetime, dict, float, int, list, str, None]]]

    embedding_properties: typing.Optional[UserFileEmbeddingProperties]

    chunk_size: typing.Optional[int]

    chunk_overlap: typing.Optional[int]

    chunk_properties: typing.Optional[ChunkPropertiesNullable]

    ocr_properties: typing.Dict[str, typing.Union[bool, date, datetime, dict, float, int, list, str, None]]

    ocr_job_started_at: typing.Optional[datetime]

    name: typing.Optional[str]

    parent_id: typing.Optional[int]

    enable_auto_sync: typing.Optional[bool]

    presigned_url: typing.Optional[str]

    parsed_text_url: typing.Optional[str]

    additional_presigned_urls: typing.Optional[typing.Dict[str, typing.Union[bool, date, datetime, dict, float, int, list, str, None]]]

    source_created_at: typing.Optional[datetime]

    generate_sparse_vectors: typing.Optional[bool]

    request_id: typing.Optional[str]

    upload_id: typing.Optional[str]

    sync_properties: typing.Dict[str, typing.Union[bool, date, datetime, dict, float, int, list, str, None]]

    messages_metadata: typing.Dict[str, typing.Union[bool, date, datetime, dict, float, int, list, str, None]]

    file_contents_deleted: bool

    hot_storage_time_to_live: typing.Optional[int]

class UserFile(RequiredUserFile, OptionalUserFile):
    pass
