# AUTOGENERATED! DO NOT EDIT! File to edit: 00_core.ipynb (unless otherwise specified).

__all__ = ['get_most_severe_mutation_type', 'get_residues', 'get_median_residues']

# Cell
import re
import numpy as np

def get_most_severe_mutation_type(mut_types):
    """
    Annotate the most severe mutation type of the
    predicted mutation types for a guide sequence

    mut_types: string |
    returns: string
    """
    if type(mut_types) == float:
        return 'No edits'
    elif 'Nonsense' in mut_types:
        return 'Nonsense'
    elif 'Splice-acceptor' in mut_types or 'Splice-donor' in mut_types:
        return 'Splice site'
    elif 'Missense' in mut_types:
        return 'Missense'
    elif 'Intron' in mut_types:
        return 'Intron'
    elif 'Silent' in mut_types:
        return 'Silent'
    elif 'UTR' in mut_types:
        return 'UTR'
    elif 'Flank' in mut_types:
        return 'Flank'

def get_residues(predicted_aa_edits):
    """
    Get the residue positions of all amino acid
    predicted edits for a guide sequence

    predicted_aa_edits: string |
    returns: string
    """
    res_string = ''
    if type(predicted_aa_edits) != float:
        edits = [x.strip() for x in re.split(';|,', predicted_aa_edits)]
        for edit in edits:
            if edit == '(NC)':
                res_string += 'non-coding;'
            elif edit == '':
                continue
            else:
                res = [x for x in re.findall('\d+|\D+', edit) if x.isdigit()][0]
                res_string += res
                res_string += ';'
    return res_string

def get_median_residues(mutation_bin, predicted_aa_edits):
    """
    Get the median residue position of predicted
    edit positions

    mutation_bin: string |
    predicted_aa_edits: string |
    returns: float
    """
    residues = get_residues(predicted_aa_edits)
    residues = residues.split(';')
    if (mutation_bin == 'Missense') or (mutation_bin == 'Nonsense') or (mutation_bin == 'Silent'):
        residues = [int(res) for res in residues if res not in ['','non-coding']]
        if len(residues) != 0:
            return np.median(residues)
        else:
            return np.nan
    else:
        return np.nan