"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
"""

import builtins
import collections.abc
import google.protobuf.descriptor
import google.protobuf.field_mask_pb2
import google.protobuf.internal.containers
import google.protobuf.message
import google.protobuf.timestamp_pb2
import sift.calculated_channels.v1.calculated_channels_pb2
import sift.common.type.v1.channel_data_type_pb2
import sift.common.type.v1.resource_identifier_pb2
import sift.common.type.v1.user_defined_functions_pb2
import sift.metadata.v1.metadata_pb2
import typing

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

@typing.final
class CalculatedChannel(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CALCULATED_CHANNEL_ID_FIELD_NUMBER: builtins.int
    ORGANIZATION_ID_FIELD_NUMBER: builtins.int
    CLIENT_KEY_FIELD_NUMBER: builtins.int
    ARCHIVED_DATE_FIELD_NUMBER: builtins.int
    VERSION_ID_FIELD_NUMBER: builtins.int
    VERSION_FIELD_NUMBER: builtins.int
    NAME_FIELD_NUMBER: builtins.int
    DESCRIPTION_FIELD_NUMBER: builtins.int
    CHANGE_MESSAGE_FIELD_NUMBER: builtins.int
    USER_NOTES_FIELD_NUMBER: builtins.int
    UNITS_FIELD_NUMBER: builtins.int
    CREATED_DATE_FIELD_NUMBER: builtins.int
    MODIFIED_DATE_FIELD_NUMBER: builtins.int
    CALCULATED_CHANNEL_CONFIGURATION_FIELD_NUMBER: builtins.int
    CREATED_BY_USER_ID_FIELD_NUMBER: builtins.int
    MODIFIED_BY_USER_ID_FIELD_NUMBER: builtins.int
    FUNCTION_DEPENDENCIES_FIELD_NUMBER: builtins.int
    METADATA_FIELD_NUMBER: builtins.int
    IS_ARCHIVED_FIELD_NUMBER: builtins.int
    calculated_channel_id: builtins.str
    organization_id: builtins.str
    client_key: builtins.str
    version_id: builtins.str
    version: builtins.int
    name: builtins.str
    description: builtins.str
    change_message: builtins.str
    user_notes: builtins.str
    units: builtins.str
    created_by_user_id: builtins.str
    modified_by_user_id: builtins.str
    is_archived: builtins.bool
    """Whether the calculated channel is archived. This is inferred from whether archived_date is set."""
    @property
    def archived_date(self) -> google.protobuf.timestamp_pb2.Timestamp: ...
    @property
    def created_date(self) -> google.protobuf.timestamp_pb2.Timestamp: ...
    @property
    def modified_date(self) -> google.protobuf.timestamp_pb2.Timestamp: ...
    @property
    def calculated_channel_configuration(self) -> global___CalculatedChannelConfiguration: ...
    @property
    def function_dependencies(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[sift.common.type.v1.user_defined_functions_pb2.FunctionDependency]: ...
    @property
    def metadata(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[sift.metadata.v1.metadata_pb2.MetadataValue]: ...
    def __init__(
        self,
        *,
        calculated_channel_id: builtins.str = ...,
        organization_id: builtins.str = ...,
        client_key: builtins.str | None = ...,
        archived_date: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        version_id: builtins.str = ...,
        version: builtins.int = ...,
        name: builtins.str = ...,
        description: builtins.str = ...,
        change_message: builtins.str = ...,
        user_notes: builtins.str = ...,
        units: builtins.str | None = ...,
        created_date: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        modified_date: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        calculated_channel_configuration: global___CalculatedChannelConfiguration | None = ...,
        created_by_user_id: builtins.str = ...,
        modified_by_user_id: builtins.str = ...,
        function_dependencies: collections.abc.Iterable[sift.common.type.v1.user_defined_functions_pb2.FunctionDependency] | None = ...,
        metadata: collections.abc.Iterable[sift.metadata.v1.metadata_pb2.MetadataValue] | None = ...,
        is_archived: builtins.bool = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["_archived_date", b"_archived_date", "_client_key", b"_client_key", "_units", b"_units", "archived_date", b"archived_date", "calculated_channel_configuration", b"calculated_channel_configuration", "client_key", b"client_key", "created_date", b"created_date", "modified_date", b"modified_date", "units", b"units"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["_archived_date", b"_archived_date", "_client_key", b"_client_key", "_units", b"_units", "archived_date", b"archived_date", "calculated_channel_configuration", b"calculated_channel_configuration", "calculated_channel_id", b"calculated_channel_id", "change_message", b"change_message", "client_key", b"client_key", "created_by_user_id", b"created_by_user_id", "created_date", b"created_date", "description", b"description", "function_dependencies", b"function_dependencies", "is_archived", b"is_archived", "metadata", b"metadata", "modified_by_user_id", b"modified_by_user_id", "modified_date", b"modified_date", "name", b"name", "organization_id", b"organization_id", "units", b"units", "user_notes", b"user_notes", "version", b"version", "version_id", b"version_id"]) -> None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing.Literal["_archived_date", b"_archived_date"]) -> typing.Literal["archived_date"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing.Literal["_client_key", b"_client_key"]) -> typing.Literal["client_key"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing.Literal["_units", b"_units"]) -> typing.Literal["units"] | None: ...

global___CalculatedChannel = CalculatedChannel

@typing.final
class CalculatedChannelConfiguration(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ASSET_CONFIGURATION_FIELD_NUMBER: builtins.int
    QUERY_CONFIGURATION_FIELD_NUMBER: builtins.int
    @property
    def asset_configuration(self) -> global___CalculatedChannelAssetConfiguration: ...
    @property
    def query_configuration(self) -> global___CalculatedChannelQueryConfiguration: ...
    def __init__(
        self,
        *,
        asset_configuration: global___CalculatedChannelAssetConfiguration | None = ...,
        query_configuration: global___CalculatedChannelQueryConfiguration | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["asset_configuration", b"asset_configuration", "query_configuration", b"query_configuration"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["asset_configuration", b"asset_configuration", "query_configuration", b"query_configuration"]) -> None: ...

global___CalculatedChannelConfiguration = CalculatedChannelConfiguration

@typing.final
class CalculatedChannelAssetConfiguration(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing.final
    class AssetSelection(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        ASSET_IDS_FIELD_NUMBER: builtins.int
        TAG_IDS_FIELD_NUMBER: builtins.int
        @property
        def asset_ids(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]: ...
        @property
        def tag_ids(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]: ...
        def __init__(
            self,
            *,
            asset_ids: collections.abc.Iterable[builtins.str] | None = ...,
            tag_ids: collections.abc.Iterable[builtins.str] | None = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing.Literal["asset_ids", b"asset_ids", "tag_ids", b"tag_ids"]) -> None: ...

    ALL_ASSETS_FIELD_NUMBER: builtins.int
    SELECTION_FIELD_NUMBER: builtins.int
    all_assets: builtins.bool
    @property
    def selection(self) -> global___CalculatedChannelAssetConfiguration.AssetSelection: ...
    def __init__(
        self,
        *,
        all_assets: builtins.bool = ...,
        selection: global___CalculatedChannelAssetConfiguration.AssetSelection | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["all_assets", b"all_assets", "asset_scope", b"asset_scope", "selection", b"selection"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["all_assets", b"all_assets", "asset_scope", b"asset_scope", "selection", b"selection"]) -> None: ...
    def WhichOneof(self, oneof_group: typing.Literal["asset_scope", b"asset_scope"]) -> typing.Literal["all_assets", "selection"] | None: ...

global___CalculatedChannelAssetConfiguration = CalculatedChannelAssetConfiguration

@typing.final
class CalculatedChannelQueryConfiguration(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing.final
    class Sel(google.protobuf.message.Message):
        """Sift Expression Language."""

        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        EXPRESSION_FIELD_NUMBER: builtins.int
        EXPRESSION_CHANNEL_REFERENCES_FIELD_NUMBER: builtins.int
        expression: builtins.str
        @property
        def expression_channel_references(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___CalculatedChannelAbstractChannelReference]: ...
        def __init__(
            self,
            *,
            expression: builtins.str = ...,
            expression_channel_references: collections.abc.Iterable[global___CalculatedChannelAbstractChannelReference] | None = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing.Literal["expression", b"expression", "expression_channel_references", b"expression_channel_references"]) -> None: ...

    SEL_FIELD_NUMBER: builtins.int
    @property
    def sel(self) -> global___CalculatedChannelQueryConfiguration.Sel: ...
    def __init__(
        self,
        *,
        sel: global___CalculatedChannelQueryConfiguration.Sel | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["query", b"query", "sel", b"sel"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["query", b"query", "sel", b"sel"]) -> None: ...
    def WhichOneof(self, oneof_group: typing.Literal["query", b"query"]) -> typing.Literal["sel"] | None: ...

global___CalculatedChannelQueryConfiguration = CalculatedChannelQueryConfiguration

@typing.final
class CalculatedChannelAbstractChannelReference(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CHANNEL_REFERENCE_FIELD_NUMBER: builtins.int
    CHANNEL_IDENTIFIER_FIELD_NUMBER: builtins.int
    channel_reference: builtins.str
    channel_identifier: builtins.str
    def __init__(
        self,
        *,
        channel_reference: builtins.str = ...,
        channel_identifier: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["channel_identifier", b"channel_identifier", "channel_reference", b"channel_reference"]) -> None: ...

global___CalculatedChannelAbstractChannelReference = CalculatedChannelAbstractChannelReference

@typing.final
class CalculatedChannelValidationResult(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ASSET_ID_FIELD_NUMBER: builtins.int
    ASSET_NAME_FIELD_NUMBER: builtins.int
    TAG_NAMES_FIELD_NUMBER: builtins.int
    MISSING_CHANNELS_FIELD_NUMBER: builtins.int
    asset_id: builtins.str
    asset_name: builtins.str
    """Only included if asset was named in the request"""
    @property
    def tag_names(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """Includes all tags that have this asset"""

    @property
    def missing_channels(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """Names of the channels that asset does not have"""

    def __init__(
        self,
        *,
        asset_id: builtins.str = ...,
        asset_name: builtins.str | None = ...,
        tag_names: collections.abc.Iterable[builtins.str] | None = ...,
        missing_channels: collections.abc.Iterable[builtins.str] | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["_asset_name", b"_asset_name", "asset_name", b"asset_name"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["_asset_name", b"_asset_name", "asset_id", b"asset_id", "asset_name", b"asset_name", "missing_channels", b"missing_channels", "tag_names", b"tag_names"]) -> None: ...
    def WhichOneof(self, oneof_group: typing.Literal["_asset_name", b"_asset_name"]) -> typing.Literal["asset_name"] | None: ...

global___CalculatedChannelValidationResult = CalculatedChannelValidationResult

@typing.final
class GetCalculatedChannelRequest(google.protobuf.message.Message):
    """The request for a call to `CalculatedChannelService_GetCalculatedChannel` to retrieve the latest version of a calculated channel.
    If `calculated_channel_id` is provided then all other arguments will be ignored. The argument `calculated_channel_id`
    should not be used together with `client_key`. The `organization_id` argument is only required
    if using `client_key` and the user belongs to multiple organizations.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CALCULATED_CHANNEL_ID_FIELD_NUMBER: builtins.int
    CLIENT_KEY_FIELD_NUMBER: builtins.int
    ORGANIZATION_ID_FIELD_NUMBER: builtins.int
    calculated_channel_id: builtins.str
    client_key: builtins.str
    organization_id: builtins.str
    def __init__(
        self,
        *,
        calculated_channel_id: builtins.str = ...,
        client_key: builtins.str = ...,
        organization_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["calculated_channel_id", b"calculated_channel_id", "client_key", b"client_key", "organization_id", b"organization_id"]) -> None: ...

global___GetCalculatedChannelRequest = GetCalculatedChannelRequest

@typing.final
class GetCalculatedChannelResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CALCULATED_CHANNEL_FIELD_NUMBER: builtins.int
    @property
    def calculated_channel(self) -> global___CalculatedChannel: ...
    def __init__(
        self,
        *,
        calculated_channel: global___CalculatedChannel | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["calculated_channel", b"calculated_channel"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["calculated_channel", b"calculated_channel"]) -> None: ...

global___GetCalculatedChannelResponse = GetCalculatedChannelResponse

@typing.final
class CreateCalculatedChannelRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAME_FIELD_NUMBER: builtins.int
    DESCRIPTION_FIELD_NUMBER: builtins.int
    USER_NOTES_FIELD_NUMBER: builtins.int
    UNITS_FIELD_NUMBER: builtins.int
    CLIENT_KEY_FIELD_NUMBER: builtins.int
    CALCULATED_CHANNEL_CONFIGURATION_FIELD_NUMBER: builtins.int
    METADATA_FIELD_NUMBER: builtins.int
    name: builtins.str
    description: builtins.str
    user_notes: builtins.str
    units: builtins.str
    client_key: builtins.str
    @property
    def calculated_channel_configuration(self) -> global___CalculatedChannelConfiguration: ...
    @property
    def metadata(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[sift.metadata.v1.metadata_pb2.MetadataValue]: ...
    def __init__(
        self,
        *,
        name: builtins.str = ...,
        description: builtins.str = ...,
        user_notes: builtins.str = ...,
        units: builtins.str | None = ...,
        client_key: builtins.str | None = ...,
        calculated_channel_configuration: global___CalculatedChannelConfiguration | None = ...,
        metadata: collections.abc.Iterable[sift.metadata.v1.metadata_pb2.MetadataValue] | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["_client_key", b"_client_key", "_units", b"_units", "calculated_channel_configuration", b"calculated_channel_configuration", "client_key", b"client_key", "units", b"units"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["_client_key", b"_client_key", "_units", b"_units", "calculated_channel_configuration", b"calculated_channel_configuration", "client_key", b"client_key", "description", b"description", "metadata", b"metadata", "name", b"name", "units", b"units", "user_notes", b"user_notes"]) -> None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing.Literal["_client_key", b"_client_key"]) -> typing.Literal["client_key"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing.Literal["_units", b"_units"]) -> typing.Literal["units"] | None: ...

global___CreateCalculatedChannelRequest = CreateCalculatedChannelRequest

@typing.final
class CreateCalculatedChannelResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CALCULATED_CHANNEL_FIELD_NUMBER: builtins.int
    INAPPLICABLE_ASSETS_FIELD_NUMBER: builtins.int
    @property
    def calculated_channel(self) -> global___CalculatedChannel: ...
    @property
    def inapplicable_assets(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___CalculatedChannelValidationResult]: ...
    def __init__(
        self,
        *,
        calculated_channel: global___CalculatedChannel | None = ...,
        inapplicable_assets: collections.abc.Iterable[global___CalculatedChannelValidationResult] | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["calculated_channel", b"calculated_channel"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["calculated_channel", b"calculated_channel", "inapplicable_assets", b"inapplicable_assets"]) -> None: ...

global___CreateCalculatedChannelResponse = CreateCalculatedChannelResponse

@typing.final
class ListCalculatedChannelsRequest(google.protobuf.message.Message):
    """The request for a call to `CalculatedChannelService_ListCalculatedChannels` to retrieve latest versions of calculated channels."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PAGE_SIZE_FIELD_NUMBER: builtins.int
    PAGE_TOKEN_FIELD_NUMBER: builtins.int
    FILTER_FIELD_NUMBER: builtins.int
    ORGANIZATION_ID_FIELD_NUMBER: builtins.int
    ORDER_BY_FIELD_NUMBER: builtins.int
    page_size: builtins.int
    """The maximum number of calculated channels to return. The service may return fewer than this value.
    If unspecified, at most 50 calculated channels will be returned. The maximum value is 1000; values above
    1000 will be coerced to 1000. Optional.
    """
    page_token: builtins.str
    """A page token, received from a previous `ListCalculatedChannels` call.
    Provide this to retrieve the subsequent page.
    When paginating, all other parameters provided to `ListCalculatedChannels` must match
    the call that provided the page token. Optional.
    """
    filter: builtins.str
    """A [Common Expression Language (CEL)](https://github.com/google/cel-spec) filter string.
    Available fields to filter by are `calculated_channel_id`, `organization_id`, `client_key`, `name`, `description`,
    `asset_id`, `asset_name`, `tag_id`, `tag_name`, `units`, `calculated_channel_version_id`,
    `created_date`, `modified_date`, `created_by_user_id`, `modified_by_user_id`, `is_archived`, and `archived_date`.
    For further information about how to use CELs, please refer to [this guide](https://github.com/google/cel-spec/blob/master/doc/langdef.md#standard-definitions).
    For more information about the fields used for filtering, please refer to [this definition](/docs/api/grpc/protocol-buffers/calculated_channels#calculated_channel). Optional.
    """
    organization_id: builtins.str
    """This field is only required if your user belongs to multiple organizations."""
    order_by: builtins.str
    """How to order the retrieved calculated channels. Formatted as a comma-separated string i.e. "FIELD_NAME[ desc],...".
    Available fields to order_by are `created_date`, `modified_date`, `name`, `description`, `units`, and `archived_date`.
    If left empty, items are ordered by `created_date` in descending order (newest-first).
    For more information about the format of this field, read [this](https://google.aip.dev/132#ordering)
    Example: "created_date desc,modified_date"
    """
    def __init__(
        self,
        *,
        page_size: builtins.int = ...,
        page_token: builtins.str = ...,
        filter: builtins.str = ...,
        organization_id: builtins.str = ...,
        order_by: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["filter", b"filter", "order_by", b"order_by", "organization_id", b"organization_id", "page_size", b"page_size", "page_token", b"page_token"]) -> None: ...

global___ListCalculatedChannelsRequest = ListCalculatedChannelsRequest

@typing.final
class ListCalculatedChannelsResponse(google.protobuf.message.Message):
    """The response of a call to `CalculatedChannelService_ListCalculatedChannels`."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CALCULATED_CHANNELS_FIELD_NUMBER: builtins.int
    NEXT_PAGE_TOKEN_FIELD_NUMBER: builtins.int
    next_page_token: builtins.str
    @property
    def calculated_channels(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___CalculatedChannel]: ...
    def __init__(
        self,
        *,
        calculated_channels: collections.abc.Iterable[global___CalculatedChannel] | None = ...,
        next_page_token: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["calculated_channels", b"calculated_channels", "next_page_token", b"next_page_token"]) -> None: ...

global___ListCalculatedChannelsResponse = ListCalculatedChannelsResponse

@typing.final
class UpdateCalculatedChannelRequest(google.protobuf.message.Message):
    """The request for a call to `CalculatedChannelService_UpdateCalculatedChannel` to update a calculated channel. Updating a calculated
    channel creates a new version of the calculated channel, leaving the previous untouched. If no update is deemed necessary, then the
    the current version is returned. To archive calculated channel, specify `archived_date` in the `update mask` as well as a non-null
    value for `archived_date` in the `calculated_channel` object. To unarchive a calculated channel, specify `archived_date` in the
    `update mask` and a `null` value for `archived_date` in the `calculated_channel` object.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CALCULATED_CHANNEL_FIELD_NUMBER: builtins.int
    UPDATE_MASK_FIELD_NUMBER: builtins.int
    USER_NOTES_FIELD_NUMBER: builtins.int
    user_notes: builtins.str
    """Optional user notes to describe changes."""
    @property
    def calculated_channel(self) -> global___CalculatedChannel:
        """The calculated channel to update."""

    @property
    def update_mask(self) -> google.protobuf.field_mask_pb2.FieldMask:
        """The list of fields to be updated. The fields available to be updated are `name`, `description`, `units`, `metadata`,
        `query_configuration`, `archived_date`, `is_archived`, and `asset_configuration`.
        """

    def __init__(
        self,
        *,
        calculated_channel: global___CalculatedChannel | None = ...,
        update_mask: google.protobuf.field_mask_pb2.FieldMask | None = ...,
        user_notes: builtins.str | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["_user_notes", b"_user_notes", "calculated_channel", b"calculated_channel", "update_mask", b"update_mask", "user_notes", b"user_notes"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["_user_notes", b"_user_notes", "calculated_channel", b"calculated_channel", "update_mask", b"update_mask", "user_notes", b"user_notes"]) -> None: ...
    def WhichOneof(self, oneof_group: typing.Literal["_user_notes", b"_user_notes"]) -> typing.Literal["user_notes"] | None: ...

global___UpdateCalculatedChannelRequest = UpdateCalculatedChannelRequest

@typing.final
class UpdateCalculatedChannelResponse(google.protobuf.message.Message):
    """The response of a call to `CalculatedChannelService_UpdateCalculatedChannel`."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CALCULATED_CHANNEL_FIELD_NUMBER: builtins.int
    INAPPLICABLE_ASSETS_FIELD_NUMBER: builtins.int
    @property
    def calculated_channel(self) -> global___CalculatedChannel: ...
    @property
    def inapplicable_assets(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___CalculatedChannelValidationResult]: ...
    def __init__(
        self,
        *,
        calculated_channel: global___CalculatedChannel | None = ...,
        inapplicable_assets: collections.abc.Iterable[global___CalculatedChannelValidationResult] | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["calculated_channel", b"calculated_channel"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["calculated_channel", b"calculated_channel", "inapplicable_assets", b"inapplicable_assets"]) -> None: ...

global___UpdateCalculatedChannelResponse = UpdateCalculatedChannelResponse

@typing.final
class ListCalculatedChannelVersionsRequest(google.protobuf.message.Message):
    """The request for a call to `CalculatedChannelService_ListCalculatedChannelVersions` to retrieve versions
    of a particular calculated channel. If `calculated_channel_id` is provided then `client_key` is ignored.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CALCULATED_CHANNEL_ID_FIELD_NUMBER: builtins.int
    CLIENT_KEY_FIELD_NUMBER: builtins.int
    PAGE_SIZE_FIELD_NUMBER: builtins.int
    PAGE_TOKEN_FIELD_NUMBER: builtins.int
    FILTER_FIELD_NUMBER: builtins.int
    ORGANIZATION_ID_FIELD_NUMBER: builtins.int
    ORDER_BY_FIELD_NUMBER: builtins.int
    calculated_channel_id: builtins.str
    client_key: builtins.str
    page_size: builtins.int
    """The maximum number of calculated channel versions to return. The service may return fewer than this value.
    If unspecified, at most 50 calculated channels will be returned. The maximum value is 1000; values above
    1000 will be coerced to 1000. Optional.
    """
    page_token: builtins.str
    """A page token, received from a previous `ListCalculatedChannelVersions` call.
    Provide this to retrieve the subsequent page.
    When paginating, all other parameters provided to `ListCalculatedChannelVersions` must match
    the call that provided the page token. Optional.
    """
    filter: builtins.str
    """A [Common Expression Language (CEL)](https://github.com/google/cel-spec) filter string.
    Available fields to filter by are `calculated_channel_id`, `organization_id`, `client_key`, `name`, `description`,
    `asset_id`, `asset_name`, `tag_id`, `tag_name`, `version`, `units`, `calculated_channel_version_id`,
    `created_date`, `modified_date`, `created_by_user_id`, `modified_by_user_id`, `is_archived`, and `archived_date`.
    For further information about how to use CELs, please refer to [this guide](https://github.com/google/cel-spec/blob/master/doc/langdef.md#standard-definitions).
    For more information about the fields used for filtering, please refer to [this definition](/docs/api/grpc/protocol-buffers/calculated_channels#calculated_channel). Optional.
    """
    organization_id: builtins.str
    """This field is only required if your user belongs to multiple organizations."""
    order_by: builtins.str
    """How to order the retrieved calculated channel versions. Formatted as a comma-separated string i.e. "FIELD_NAME[ desc],...".
    Available fields to order_by are 'version', `created_date`, `modified_date`, `name`, `description`, `units`, and `archived_date`.
    If left empty, items are ordered by `created_date` in ascending order (oldest-first).
    For more information about the format of this field, read [this](https://google.aip.dev/132#ordering)
    Example: "created_date desc,modified_date".
    """
    def __init__(
        self,
        *,
        calculated_channel_id: builtins.str = ...,
        client_key: builtins.str = ...,
        page_size: builtins.int = ...,
        page_token: builtins.str = ...,
        filter: builtins.str = ...,
        organization_id: builtins.str = ...,
        order_by: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["calculated_channel_id", b"calculated_channel_id", "client_key", b"client_key", "filter", b"filter", "order_by", b"order_by", "organization_id", b"organization_id", "page_size", b"page_size", "page_token", b"page_token"]) -> None: ...

global___ListCalculatedChannelVersionsRequest = ListCalculatedChannelVersionsRequest

@typing.final
class ListCalculatedChannelVersionsResponse(google.protobuf.message.Message):
    """The response of a call to `CalculatedChannelService_ListCalculatedChannelVersions`."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CALCULATED_CHANNEL_VERSIONS_FIELD_NUMBER: builtins.int
    NEXT_PAGE_TOKEN_FIELD_NUMBER: builtins.int
    next_page_token: builtins.str
    @property
    def calculated_channel_versions(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___CalculatedChannel]: ...
    def __init__(
        self,
        *,
        calculated_channel_versions: collections.abc.Iterable[global___CalculatedChannel] | None = ...,
        next_page_token: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["calculated_channel_versions", b"calculated_channel_versions", "next_page_token", b"next_page_token"]) -> None: ...

global___ListCalculatedChannelVersionsResponse = ListCalculatedChannelVersionsResponse

@typing.final
class ResolveCalculatedChannelRequest(google.protobuf.message.Message):
    """The request for a call to `CalculatedChannelService_ResolveCalculatedChannel` to get the all possible calculated channels.
    1) If the calculated channel has a selection of assets and tags then those assets will be used as a base and then filtered down by the given assets and assets from the run.
    2) If the calculated channel is enabled for all assets then:
      a) If the request has run and assets from the run will be used as a base and then filtered down by the given assets.
      b) If the request has run and no assets then those assets will be used.
      c) If the request has only assets then those assets will be used.
    The `organization_id` argument is only required if using `client_key` and the user belongs to multiple organizations.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    IDENTIFIER_FIELD_NUMBER: builtins.int
    CALCULATED_CHANNEL_CONFIGURATION_FIELD_NUMBER: builtins.int
    ORGANIZATION_ID_FIELD_NUMBER: builtins.int
    ASSETS_FIELD_NUMBER: builtins.int
    RUN_FIELD_NUMBER: builtins.int
    organization_id: builtins.str
    """This field is only required if your user belongs to multiple organizations."""
    @property
    def identifier(self) -> sift.common.type.v1.resource_identifier_pb2.ResourceIdentifier:
        """The calculated channel to resolve."""

    @property
    def calculated_channel_configuration(self) -> global___CalculatedChannelConfiguration:
        """A configuration for the calculated channel to resolve."""

    @property
    def assets(self) -> sift.common.type.v1.resource_identifier_pb2.NamedResources:
        """Assets to be included or filtered through.  See above."""

    @property
    def run(self) -> sift.common.type.v1.resource_identifier_pb2.ResourceIdentifier:
        """Run to get assets to be included or filtered through.  See above."""

    def __init__(
        self,
        *,
        identifier: sift.common.type.v1.resource_identifier_pb2.ResourceIdentifier | None = ...,
        calculated_channel_configuration: global___CalculatedChannelConfiguration | None = ...,
        organization_id: builtins.str = ...,
        assets: sift.common.type.v1.resource_identifier_pb2.NamedResources | None = ...,
        run: sift.common.type.v1.resource_identifier_pb2.ResourceIdentifier | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["_run", b"_run", "assets", b"assets", "calculated_channel", b"calculated_channel", "calculated_channel_configuration", b"calculated_channel_configuration", "identifier", b"identifier", "run", b"run"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["_run", b"_run", "assets", b"assets", "calculated_channel", b"calculated_channel", "calculated_channel_configuration", b"calculated_channel_configuration", "identifier", b"identifier", "organization_id", b"organization_id", "run", b"run"]) -> None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing.Literal["_run", b"_run"]) -> typing.Literal["run"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing.Literal["calculated_channel", b"calculated_channel"]) -> typing.Literal["identifier", "calculated_channel_configuration"] | None: ...

global___ResolveCalculatedChannelRequest = ResolveCalculatedChannelRequest

@typing.final
class ResolvedCalculatedChannel(google.protobuf.message.Message):
    """A specific calculated channel including the asset and exact channels to query."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ASSET_NAME_FIELD_NUMBER: builtins.int
    EXPRESSION_REQUEST_FIELD_NUMBER: builtins.int
    OUTPUT_DATA_TYPE_FIELD_NUMBER: builtins.int
    ASSET_ID_FIELD_NUMBER: builtins.int
    asset_name: builtins.str
    """The name of the specific asset that was resolved."""
    output_data_type: sift.common.type.v1.channel_data_type_pb2.ChannelDataType.ValueType
    asset_id: builtins.str
    @property
    def expression_request(self) -> sift.calculated_channels.v1.calculated_channels_pb2.ExpressionRequest:
        """The expression resolved including channel references."""

    def __init__(
        self,
        *,
        asset_name: builtins.str = ...,
        expression_request: sift.calculated_channels.v1.calculated_channels_pb2.ExpressionRequest | None = ...,
        output_data_type: sift.common.type.v1.channel_data_type_pb2.ChannelDataType.ValueType = ...,
        asset_id: builtins.str = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["expression_request", b"expression_request"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["asset_id", b"asset_id", "asset_name", b"asset_name", "expression_request", b"expression_request", "output_data_type", b"output_data_type"]) -> None: ...

global___ResolvedCalculatedChannel = ResolvedCalculatedChannel

@typing.final
class UnresolvedCalculatedChannel(google.protobuf.message.Message):
    """Any failure in resolution."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ASSET_NAME_FIELD_NUMBER: builtins.int
    ERROR_MESSAGE_FIELD_NUMBER: builtins.int
    asset_name: builtins.str
    """The name of the specific asset that was not resolved."""
    error_message: builtins.str
    def __init__(
        self,
        *,
        asset_name: builtins.str = ...,
        error_message: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["asset_name", b"asset_name", "error_message", b"error_message"]) -> None: ...

global___UnresolvedCalculatedChannel = UnresolvedCalculatedChannel

@typing.final
class ResolveCalculatedChannelResponse(google.protobuf.message.Message):
    """The response of a call to `CalculatedChannelService_ResolveCalculatedChannel`."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CALCULATED_CHANNEL_ID_FIELD_NUMBER: builtins.int
    RESOLVED_FIELD_NUMBER: builtins.int
    UNRESOLVED_FIELD_NUMBER: builtins.int
    calculated_channel_id: builtins.str
    """If provided in the request, the calculated channel resolved."""
    @property
    def resolved(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___ResolvedCalculatedChannel]:
        """All resolved calculated channels."""

    @property
    def unresolved(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___UnresolvedCalculatedChannel]:
        """All assets with any issues in resolution."""

    def __init__(
        self,
        *,
        calculated_channel_id: builtins.str | None = ...,
        resolved: collections.abc.Iterable[global___ResolvedCalculatedChannel] | None = ...,
        unresolved: collections.abc.Iterable[global___UnresolvedCalculatedChannel] | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["_calculated_channel_id", b"_calculated_channel_id", "calculated_channel_id", b"calculated_channel_id"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["_calculated_channel_id", b"_calculated_channel_id", "calculated_channel_id", b"calculated_channel_id", "resolved", b"resolved", "unresolved", b"unresolved"]) -> None: ...
    def WhichOneof(self, oneof_group: typing.Literal["_calculated_channel_id", b"_calculated_channel_id"]) -> typing.Literal["calculated_channel_id"] | None: ...

global___ResolveCalculatedChannelResponse = ResolveCalculatedChannelResponse

@typing.final
class BatchResolveCalculatedChannelsRequest(google.protobuf.message.Message):
    """The request of a call to `CalculatedChannelService_BatchResolveCalculatedChannels`."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    REQUESTS_FIELD_NUMBER: builtins.int
    @property
    def requests(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___ResolveCalculatedChannelRequest]:
        """All calculated channels to resolve."""

    def __init__(
        self,
        *,
        requests: collections.abc.Iterable[global___ResolveCalculatedChannelRequest] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["requests", b"requests"]) -> None: ...

global___BatchResolveCalculatedChannelsRequest = BatchResolveCalculatedChannelsRequest

@typing.final
class BatchResolveCalculatedChannelsResponse(google.protobuf.message.Message):
    """The response of a call to `CalculatedChannelService_BatchResolveCalculatedChannels`."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    RESPONSES_FIELD_NUMBER: builtins.int
    @property
    def responses(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___ResolveCalculatedChannelResponse]:
        """All calculated channels that attempted resolution."""

    def __init__(
        self,
        *,
        responses: collections.abc.Iterable[global___ResolveCalculatedChannelResponse] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["responses", b"responses"]) -> None: ...

global___BatchResolveCalculatedChannelsResponse = BatchResolveCalculatedChannelsResponse

@typing.final
class ListResolvedCalculatedChannelsRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ASSET_ID_FIELD_NUMBER: builtins.int
    RUN_ID_FIELD_NUMBER: builtins.int
    PAGE_SIZE_FIELD_NUMBER: builtins.int
    PAGE_TOKEN_FIELD_NUMBER: builtins.int
    FILTER_FIELD_NUMBER: builtins.int
    ORDER_BY_FIELD_NUMBER: builtins.int
    asset_id: builtins.str
    """Assets or runs to get the resolved calculated channels for. At least one asset or run must be provided."""
    run_id: builtins.str
    page_size: builtins.int
    """The maximum number of calculated channels to return. The service may return fewer than this value.
    If unspecified, at most 50 calculated channels will be returned. The maximum value is 1000; values above
    1000 will be coerced to 1000. Optional.
    """
    page_token: builtins.str
    """A page token, received from a previous `ListCalculatedChannels` call.
    Provide this to retrieve the subsequent page.
    When paginating, all other parameters provided to `ListCalculatedChannels` must match
    the call that provided the page token. Optional.
    """
    filter: builtins.str
    """A [Common Expression Language (CEL)](https://github.com/google/cel-spec) filter string.
    Available fields to filter by are `calculated_channel_id`, `organization_id`, `client_key`, `name`, `description`,
    `asset_id`, `asset_name`, `tag_id`, `tag_name`, `version`, `units`, `calculated_channel_version_id`,
    `created_date`, `modified_date`, `created_by_user_id`, `modified_by_user_id`, `is_archived`, and `archived_date`.
    For further information about how to use CELs, please refer to [this guide](https://github.com/google/cel-spec/blob/master/doc/langdef.md#standard-definitions).
    For more information about the fields used for filtering, please refer to [this definition](/docs/api/grpc/protocol-buffers/calculated_channels#calculated_channel). Optional.
    """
    order_by: builtins.str
    """How to order the retrieved calculated channels. Formatted as a comma-separated string i.e. "FIELD_NAME[ desc],...".
    Available fields to order_by are `created_date` and `modified_date`.
    If left empty, items are ordered by `created_date` in descending order (newest-first).
    For more information about the format of this field, read [this](https://google.aip.dev/132#ordering)
    Example: "created_date desc,modified_date"
    """
    def __init__(
        self,
        *,
        asset_id: builtins.str = ...,
        run_id: builtins.str = ...,
        page_size: builtins.int = ...,
        page_token: builtins.str = ...,
        filter: builtins.str = ...,
        order_by: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["asset_id", b"asset_id", "filter", b"filter", "order_by", b"order_by", "page_size", b"page_size", "page_token", b"page_token", "run_id", b"run_id"]) -> None: ...

global___ListResolvedCalculatedChannelsRequest = ListResolvedCalculatedChannelsRequest

@typing.final
class CalculatedChannelResolution(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CALCULATED_CHANNEL_FIELD_NUMBER: builtins.int
    RESOLVED_FIELD_NUMBER: builtins.int
    UNRESOLVED_FIELD_NUMBER: builtins.int
    @property
    def calculated_channel(self) -> global___CalculatedChannel:
        """The calculated channel resolved."""

    @property
    def resolved(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___ResolvedCalculatedChannel]:
        """All resolved calculated channels."""

    @property
    def unresolved(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___UnresolvedCalculatedChannel]:
        """All assets with any issues in resolution."""

    def __init__(
        self,
        *,
        calculated_channel: global___CalculatedChannel | None = ...,
        resolved: collections.abc.Iterable[global___ResolvedCalculatedChannel] | None = ...,
        unresolved: collections.abc.Iterable[global___UnresolvedCalculatedChannel] | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["_calculated_channel", b"_calculated_channel", "calculated_channel", b"calculated_channel"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["_calculated_channel", b"_calculated_channel", "calculated_channel", b"calculated_channel", "resolved", b"resolved", "unresolved", b"unresolved"]) -> None: ...
    def WhichOneof(self, oneof_group: typing.Literal["_calculated_channel", b"_calculated_channel"]) -> typing.Literal["calculated_channel"] | None: ...

global___CalculatedChannelResolution = CalculatedChannelResolution

@typing.final
class ListResolvedCalculatedChannelsResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CALCULATED_CHANNEL_RESOLUTIONS_FIELD_NUMBER: builtins.int
    NEXT_PAGE_TOKEN_FIELD_NUMBER: builtins.int
    next_page_token: builtins.str
    @property
    def calculated_channel_resolutions(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___CalculatedChannelResolution]: ...
    def __init__(
        self,
        *,
        calculated_channel_resolutions: collections.abc.Iterable[global___CalculatedChannelResolution] | None = ...,
        next_page_token: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["calculated_channel_resolutions", b"calculated_channel_resolutions", "next_page_token", b"next_page_token"]) -> None: ...

global___ListResolvedCalculatedChannelsResponse = ListResolvedCalculatedChannelsResponse
