"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
"""

import builtins
import collections.abc
import google.protobuf.descriptor
import google.protobuf.field_mask_pb2
import google.protobuf.internal.containers
import google.protobuf.message
import google.protobuf.timestamp_pb2
import typing

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

@typing.final
class Policy(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    POLICY_ID_FIELD_NUMBER: builtins.int
    NAME_FIELD_NUMBER: builtins.int
    DESCRIPTION_FIELD_NUMBER: builtins.int
    ORGANIZATION_ID_FIELD_NUMBER: builtins.int
    CREATED_BY_USER_ID_FIELD_NUMBER: builtins.int
    MODIFIED_BY_USER_ID_FIELD_NUMBER: builtins.int
    CREATED_DATE_FIELD_NUMBER: builtins.int
    MODIFIED_DATE_FIELD_NUMBER: builtins.int
    CONFIGURATION_FIELD_NUMBER: builtins.int
    POLICY_VERSION_ID_FIELD_NUMBER: builtins.int
    ARCHIVED_DATE_FIELD_NUMBER: builtins.int
    IS_ARCHIVED_FIELD_NUMBER: builtins.int
    VERSION_FIELD_NUMBER: builtins.int
    VERSION_NOTES_FIELD_NUMBER: builtins.int
    GENERATED_CHANGE_MESSAGE_FIELD_NUMBER: builtins.int
    policy_id: builtins.str
    name: builtins.str
    description: builtins.str
    organization_id: builtins.str
    created_by_user_id: builtins.str
    modified_by_user_id: builtins.str
    policy_version_id: builtins.str
    """Reference to the current policy version ID"""
    is_archived: builtins.bool
    version: builtins.int
    """Optional version number for this policy"""
    version_notes: builtins.str
    """Optional notes for this version"""
    generated_change_message: builtins.str
    """Auto-generated change message for this version"""
    @property
    def created_date(self) -> google.protobuf.timestamp_pb2.Timestamp: ...
    @property
    def modified_date(self) -> google.protobuf.timestamp_pb2.Timestamp: ...
    @property
    def configuration(self) -> global___PolicyConfiguration:
        """Policy rules/configuration"""

    @property
    def archived_date(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """The date the policy was archived."""

    def __init__(
        self,
        *,
        policy_id: builtins.str = ...,
        name: builtins.str = ...,
        description: builtins.str | None = ...,
        organization_id: builtins.str = ...,
        created_by_user_id: builtins.str = ...,
        modified_by_user_id: builtins.str = ...,
        created_date: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        modified_date: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        configuration: global___PolicyConfiguration | None = ...,
        policy_version_id: builtins.str = ...,
        archived_date: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        is_archived: builtins.bool = ...,
        version: builtins.int | None = ...,
        version_notes: builtins.str | None = ...,
        generated_change_message: builtins.str | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["_description", b"_description", "_generated_change_message", b"_generated_change_message", "_version", b"_version", "_version_notes", b"_version_notes", "archived_date", b"archived_date", "configuration", b"configuration", "created_date", b"created_date", "description", b"description", "generated_change_message", b"generated_change_message", "modified_date", b"modified_date", "version", b"version", "version_notes", b"version_notes"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["_description", b"_description", "_generated_change_message", b"_generated_change_message", "_version", b"_version", "_version_notes", b"_version_notes", "archived_date", b"archived_date", "configuration", b"configuration", "created_by_user_id", b"created_by_user_id", "created_date", b"created_date", "description", b"description", "generated_change_message", b"generated_change_message", "is_archived", b"is_archived", "modified_by_user_id", b"modified_by_user_id", "modified_date", b"modified_date", "name", b"name", "organization_id", b"organization_id", "policy_id", b"policy_id", "policy_version_id", b"policy_version_id", "version", b"version", "version_notes", b"version_notes"]) -> None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing.Literal["_description", b"_description"]) -> typing.Literal["description"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing.Literal["_generated_change_message", b"_generated_change_message"]) -> typing.Literal["generated_change_message"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing.Literal["_version", b"_version"]) -> typing.Literal["version"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing.Literal["_version_notes", b"_version_notes"]) -> typing.Literal["version_notes"] | None: ...

global___Policy = Policy

@typing.final
class PolicyConfiguration(google.protobuf.message.Message):
    """PolicyConfiguration represents the configuration and rules for a policy.
    Expects a string containing a policy in the Cedar format
    https://docs.cedarpolicy.com/policies/syntax-policy.html
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CEDAR_POLICY_FIELD_NUMBER: builtins.int
    cedar_policy: builtins.str
    def __init__(
        self,
        *,
        cedar_policy: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["cedar_policy", b"cedar_policy"]) -> None: ...

global___PolicyConfiguration = PolicyConfiguration

@typing.final
class GetPolicyRequest(google.protobuf.message.Message):
    """The request for a call to `PolicyService_GetPolicy`."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    POLICY_ID_FIELD_NUMBER: builtins.int
    policy_id: builtins.str
    def __init__(
        self,
        *,
        policy_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["policy_id", b"policy_id"]) -> None: ...

global___GetPolicyRequest = GetPolicyRequest

@typing.final
class GetPolicyResponse(google.protobuf.message.Message):
    """The response of a call to `PolicyService_GetPolicy`."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    POLICY_FIELD_NUMBER: builtins.int
    @property
    def policy(self) -> global___Policy: ...
    def __init__(
        self,
        *,
        policy: global___Policy | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["policy", b"policy"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["policy", b"policy"]) -> None: ...

global___GetPolicyResponse = GetPolicyResponse

@typing.final
class ListPoliciesRequest(google.protobuf.message.Message):
    """The request for a call to `PolicyService_ListPolicies` to retrieve policies."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PAGE_SIZE_FIELD_NUMBER: builtins.int
    PAGE_TOKEN_FIELD_NUMBER: builtins.int
    FILTER_FIELD_NUMBER: builtins.int
    ORDER_BY_FIELD_NUMBER: builtins.int
    INCLUDE_ARCHIVED_FIELD_NUMBER: builtins.int
    page_size: builtins.int
    """The maximum number of policies to return. The service may return fewer than this value.
    If unspecified, at most 50 policies will be returned. The maximum value is 100; values above
    100 will be coerced to 100. Optional.
    """
    page_token: builtins.str
    """A page token, received from a previous `ListPolicies` call.
    Provide this to retrieve the subsequent page.
    When paginating, all other parameters provided to `ListPolicies` must match
    the call that provided the page token. Optional.
    """
    filter: builtins.str
    """A [Common Expression Language (CEL)](https://github.com/google/cel-spec) filter string.
    Available fields to filter by are `policy_id`, `organization_id`, `name`, `description`,
    `created_by_user_id`, `modified_by_user_id`, `created_date`, `modified_date`, `archived_date`, and `is_archived`.
    For further information about how to use CELs, please refer to [this guide](https://github.com/google/cel-spec/blob/master/doc/langdef.md#standard-definitions).
    For more information about the fields used for filtering, please refer to [this definition](/docs/api/grpc/protocol-buffers/policies#policy). Optional.
    """
    order_by: builtins.str
    """How to order the retrieved policies. Formatted as a comma-separated string i.e. "FIELD_NAME[ desc],...".
    Available fields to order_by are `created_date`, `modified_date`, and `name`.
    If left empty, items are ordered by `created_date` in descending order (newest-first).
    For more information about the format of this field, read [this](https://google.aip.dev/132#ordering)
    Example: "created_date desc,modified_date"
    """
    include_archived: builtins.bool
    """Whether to include archived policies in the response. If false or unset, archived policies are excluded."""
    def __init__(
        self,
        *,
        page_size: builtins.int = ...,
        page_token: builtins.str = ...,
        filter: builtins.str = ...,
        order_by: builtins.str = ...,
        include_archived: builtins.bool = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["filter", b"filter", "include_archived", b"include_archived", "order_by", b"order_by", "page_size", b"page_size", "page_token", b"page_token"]) -> None: ...

global___ListPoliciesRequest = ListPoliciesRequest

@typing.final
class ListPoliciesResponse(google.protobuf.message.Message):
    """The result of a call to `PolicyService_ListPolicies`."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    POLICIES_FIELD_NUMBER: builtins.int
    NEXT_PAGE_TOKEN_FIELD_NUMBER: builtins.int
    next_page_token: builtins.str
    @property
    def policies(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___Policy]: ...
    def __init__(
        self,
        *,
        policies: collections.abc.Iterable[global___Policy] | None = ...,
        next_page_token: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["next_page_token", b"next_page_token", "policies", b"policies"]) -> None: ...

global___ListPoliciesResponse = ListPoliciesResponse

@typing.final
class CreatePolicyRequest(google.protobuf.message.Message):
    """The request for a call to `PolicyService_CreatePolicy` to create a new policy."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAME_FIELD_NUMBER: builtins.int
    DESCRIPTION_FIELD_NUMBER: builtins.int
    CONFIGURATION_FIELD_NUMBER: builtins.int
    VERSION_NOTES_FIELD_NUMBER: builtins.int
    name: builtins.str
    description: builtins.str
    version_notes: builtins.str
    """Optional notes for this version"""
    @property
    def configuration(self) -> global___PolicyConfiguration:
        """Policy rules/configuration"""

    def __init__(
        self,
        *,
        name: builtins.str = ...,
        description: builtins.str | None = ...,
        configuration: global___PolicyConfiguration | None = ...,
        version_notes: builtins.str | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["_description", b"_description", "_version_notes", b"_version_notes", "configuration", b"configuration", "description", b"description", "version_notes", b"version_notes"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["_description", b"_description", "_version_notes", b"_version_notes", "configuration", b"configuration", "description", b"description", "name", b"name", "version_notes", b"version_notes"]) -> None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing.Literal["_description", b"_description"]) -> typing.Literal["description"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing.Literal["_version_notes", b"_version_notes"]) -> typing.Literal["version_notes"] | None: ...

global___CreatePolicyRequest = CreatePolicyRequest

@typing.final
class CreatePolicyResponse(google.protobuf.message.Message):
    """The response of a call to `PolicyService_CreatePolicy`."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    POLICY_FIELD_NUMBER: builtins.int
    @property
    def policy(self) -> global___Policy: ...
    def __init__(
        self,
        *,
        policy: global___Policy | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["policy", b"policy"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["policy", b"policy"]) -> None: ...

global___CreatePolicyResponse = CreatePolicyResponse

@typing.final
class UpdatePolicyRequest(google.protobuf.message.Message):
    """The request for a call to `PolicyService_UpdatePolicy` to update a policy."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    POLICY_FIELD_NUMBER: builtins.int
    UPDATE_MASK_FIELD_NUMBER: builtins.int
    VERSION_NOTES_FIELD_NUMBER: builtins.int
    version_notes: builtins.str
    """Optional notes for the new policy version when configuration changes"""
    @property
    def policy(self) -> global___Policy: ...
    @property
    def update_mask(self) -> google.protobuf.field_mask_pb2.FieldMask:
        """The list of fields to be updated. The fields available to be updated are `name`, `description`, `configuration`, and `is_archived`."""

    def __init__(
        self,
        *,
        policy: global___Policy | None = ...,
        update_mask: google.protobuf.field_mask_pb2.FieldMask | None = ...,
        version_notes: builtins.str | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["_version_notes", b"_version_notes", "policy", b"policy", "update_mask", b"update_mask", "version_notes", b"version_notes"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["_version_notes", b"_version_notes", "policy", b"policy", "update_mask", b"update_mask", "version_notes", b"version_notes"]) -> None: ...
    def WhichOneof(self, oneof_group: typing.Literal["_version_notes", b"_version_notes"]) -> typing.Literal["version_notes"] | None: ...

global___UpdatePolicyRequest = UpdatePolicyRequest

@typing.final
class UpdatePolicyResponse(google.protobuf.message.Message):
    """The response of a call to `PolicyService_UpdatePolicy`."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    POLICY_FIELD_NUMBER: builtins.int
    @property
    def policy(self) -> global___Policy: ...
    def __init__(
        self,
        *,
        policy: global___Policy | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["policy", b"policy"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["policy", b"policy"]) -> None: ...

global___UpdatePolicyResponse = UpdatePolicyResponse

@typing.final
class ArchivePolicyRequest(google.protobuf.message.Message):
    """The request for a call to `PolicyService_ArchivePolicy` to archive a policy."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    POLICY_ID_FIELD_NUMBER: builtins.int
    policy_id: builtins.str
    def __init__(
        self,
        *,
        policy_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["policy_id", b"policy_id"]) -> None: ...

global___ArchivePolicyRequest = ArchivePolicyRequest

@typing.final
class ArchivePolicyResponse(google.protobuf.message.Message):
    """The response of a call to `PolicyService_ArchivePolicy`."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    POLICY_FIELD_NUMBER: builtins.int
    @property
    def policy(self) -> global___Policy: ...
    def __init__(
        self,
        *,
        policy: global___Policy | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["policy", b"policy"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["policy", b"policy"]) -> None: ...

global___ArchivePolicyResponse = ArchivePolicyResponse
