"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
"""

import builtins
import collections.abc
import google.protobuf.descriptor
import google.protobuf.duration_pb2
import google.protobuf.field_mask_pb2
import google.protobuf.internal.containers
import google.protobuf.message
import google.protobuf.timestamp_pb2
import sift.metadata.v1.metadata_pb2
import typing

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

@typing.final
class Run(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    RUN_ID_FIELD_NUMBER: builtins.int
    CREATED_DATE_FIELD_NUMBER: builtins.int
    MODIFIED_DATE_FIELD_NUMBER: builtins.int
    CREATED_BY_USER_ID_FIELD_NUMBER: builtins.int
    MODIFIED_BY_USER_ID_FIELD_NUMBER: builtins.int
    ORGANIZATION_ID_FIELD_NUMBER: builtins.int
    START_TIME_FIELD_NUMBER: builtins.int
    STOP_TIME_FIELD_NUMBER: builtins.int
    IS_PINNED_FIELD_NUMBER: builtins.int
    NAME_FIELD_NUMBER: builtins.int
    DESCRIPTION_FIELD_NUMBER: builtins.int
    TAGS_FIELD_NUMBER: builtins.int
    DEFAULT_REPORT_ID_FIELD_NUMBER: builtins.int
    CLIENT_KEY_FIELD_NUMBER: builtins.int
    METADATA_FIELD_NUMBER: builtins.int
    ASSET_IDS_FIELD_NUMBER: builtins.int
    ARCHIVED_DATE_FIELD_NUMBER: builtins.int
    IS_ADHOC_FIELD_NUMBER: builtins.int
    IS_ARCHIVED_FIELD_NUMBER: builtins.int
    DURATION_FIELD_NUMBER: builtins.int
    run_id: builtins.str
    created_by_user_id: builtins.str
    modified_by_user_id: builtins.str
    organization_id: builtins.str
    is_pinned: builtins.bool
    name: builtins.str
    description: builtins.str
    default_report_id: builtins.str
    client_key: builtins.str
    is_adhoc: builtins.bool
    is_archived: builtins.bool
    """Whether the Run is archived. This is inferred from whether archived_date is set."""
    @property
    def created_date(self) -> google.protobuf.timestamp_pb2.Timestamp: ...
    @property
    def modified_date(self) -> google.protobuf.timestamp_pb2.Timestamp: ...
    @property
    def start_time(self) -> google.protobuf.timestamp_pb2.Timestamp: ...
    @property
    def stop_time(self) -> google.protobuf.timestamp_pb2.Timestamp: ...
    @property
    def tags(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]: ...
    @property
    def metadata(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[sift.metadata.v1.metadata_pb2.MetadataValue]:
        """The metadata values associated with this run."""

    @property
    def asset_ids(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]: ...
    @property
    def archived_date(self) -> google.protobuf.timestamp_pb2.Timestamp: ...
    @property
    def duration(self) -> google.protobuf.duration_pb2.Duration:
        """The duration of the run. Calculated as the difference between stop_time and start_time.
        If the run is ongoing (no stop_time), this represents the duration from start_time to current time.
        """

    def __init__(
        self,
        *,
        run_id: builtins.str = ...,
        created_date: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        modified_date: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        created_by_user_id: builtins.str = ...,
        modified_by_user_id: builtins.str = ...,
        organization_id: builtins.str = ...,
        start_time: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        stop_time: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        is_pinned: builtins.bool = ...,
        name: builtins.str = ...,
        description: builtins.str = ...,
        tags: collections.abc.Iterable[builtins.str] | None = ...,
        default_report_id: builtins.str = ...,
        client_key: builtins.str | None = ...,
        metadata: collections.abc.Iterable[sift.metadata.v1.metadata_pb2.MetadataValue] | None = ...,
        asset_ids: collections.abc.Iterable[builtins.str] | None = ...,
        archived_date: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        is_adhoc: builtins.bool = ...,
        is_archived: builtins.bool = ...,
        duration: google.protobuf.duration_pb2.Duration | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["_archived_date", b"_archived_date", "_client_key", b"_client_key", "_duration", b"_duration", "_start_time", b"_start_time", "_stop_time", b"_stop_time", "archived_date", b"archived_date", "client_key", b"client_key", "created_date", b"created_date", "duration", b"duration", "modified_date", b"modified_date", "start_time", b"start_time", "stop_time", b"stop_time"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["_archived_date", b"_archived_date", "_client_key", b"_client_key", "_duration", b"_duration", "_start_time", b"_start_time", "_stop_time", b"_stop_time", "archived_date", b"archived_date", "asset_ids", b"asset_ids", "client_key", b"client_key", "created_by_user_id", b"created_by_user_id", "created_date", b"created_date", "default_report_id", b"default_report_id", "description", b"description", "duration", b"duration", "is_adhoc", b"is_adhoc", "is_archived", b"is_archived", "is_pinned", b"is_pinned", "metadata", b"metadata", "modified_by_user_id", b"modified_by_user_id", "modified_date", b"modified_date", "name", b"name", "organization_id", b"organization_id", "run_id", b"run_id", "start_time", b"start_time", "stop_time", b"stop_time", "tags", b"tags"]) -> None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing.Literal["_archived_date", b"_archived_date"]) -> typing.Literal["archived_date"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing.Literal["_client_key", b"_client_key"]) -> typing.Literal["client_key"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing.Literal["_duration", b"_duration"]) -> typing.Literal["duration"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing.Literal["_start_time", b"_start_time"]) -> typing.Literal["start_time"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing.Literal["_stop_time", b"_stop_time"]) -> typing.Literal["stop_time"] | None: ...

global___Run = Run

@typing.final
class GetRunRequest(google.protobuf.message.Message):
    """The request for a call to `RunService_GetRun` to retrieve run."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    RUN_ID_FIELD_NUMBER: builtins.int
    run_id: builtins.str
    """The ID of the run to retrieve."""
    def __init__(
        self,
        *,
        run_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["run_id", b"run_id"]) -> None: ...

global___GetRunRequest = GetRunRequest

@typing.final
class GetRunResponse(google.protobuf.message.Message):
    """The response of a call to `RunService_GetRun` containing the requested run."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    RUN_FIELD_NUMBER: builtins.int
    @property
    def run(self) -> global___Run: ...
    def __init__(
        self,
        *,
        run: global___Run | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["run", b"run"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["run", b"run"]) -> None: ...

global___GetRunResponse = GetRunResponse

@typing.final
class ListRunsRequest(google.protobuf.message.Message):
    """The request for a call to `RunService_ListRuns` to retrieve runs."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PAGE_SIZE_FIELD_NUMBER: builtins.int
    PAGE_TOKEN_FIELD_NUMBER: builtins.int
    FILTER_FIELD_NUMBER: builtins.int
    ORDER_BY_FIELD_NUMBER: builtins.int
    page_size: builtins.int
    """The maximum number of runs to return.
    The service may return fewer than this value.
    If unspecified, at most 50 runs will be returned.
    The maximum value is 1000; values above 1000 will be coerced to 1000.
    """
    page_token: builtins.str
    """A page token, received from a previous `ListRuns` call.
    Provide this to retrieve the subsequent page.
    When paginating, all other parameters provided to `ListRuns` must match
    the call that provided the page token.
    """
    filter: builtins.str
    """A [Common Expression Language (CEL)](https://github.com/google/cel-spec) filter string.
    Available fields to filter by are `run_id` `organization_id`, `asset_id`, `asset_name`, `client_key`, `name`, `description`, `created_by_user_id`, `modified_by_user_id`,
    `created_date`, `modified_date`, `start_time`, `stop_time`, `tag_id`, `asset_tag_id`, `duration`, 'duration_string', `annotation_comments_count`, `annotation_state`, `archived_date`, `is_archived`,
    and `metadata`. Metadata can be used in filters by using `metadata.{metadata_key_name}` as the field name.
    `duration` is in the format of elapsed seconds and `duration_string` allows for `h`, `m`, `s`, `ms` suffixes (example: `duration_string > duration('10h'))
    For further information about how to use CELs, please refer to [this guide](https://github.com/google/cel-spec/blob/master/doc/langdef.md#standard-definitions).
    For more information about the fields used for filtering, please refer to [this definition](/docs/api/grpc/protocol-buffers/runs#run). Optional.
    """
    order_by: builtins.str
    """How to order the retrieved runs. Formatted as a comma-separated string i.e. "FIELD_NAME[ desc],...".
    Available fields to order_by are `name`, `description`, `created_date`, `modified_date`, `start_time`, and `stop_time`.
    If left empty, items are ordered by `created_date` in descending order (newest-first).
    For more information about the format of this field, read [this](https://google.aip.dev/132#ordering)
    Example: "created_date desc,modified_date"
    """
    def __init__(
        self,
        *,
        page_size: builtins.int = ...,
        page_token: builtins.str = ...,
        filter: builtins.str = ...,
        order_by: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["filter", b"filter", "order_by", b"order_by", "page_size", b"page_size", "page_token", b"page_token"]) -> None: ...

global___ListRunsRequest = ListRunsRequest

@typing.final
class ListRunsResponse(google.protobuf.message.Message):
    """The response of a call to `RunService_ListRuns` containing requested runs."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    RUNS_FIELD_NUMBER: builtins.int
    NEXT_PAGE_TOKEN_FIELD_NUMBER: builtins.int
    next_page_token: builtins.str
    @property
    def runs(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___Run]: ...
    def __init__(
        self,
        *,
        runs: collections.abc.Iterable[global___Run] | None = ...,
        next_page_token: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["next_page_token", b"next_page_token", "runs", b"runs"]) -> None: ...

global___ListRunsResponse = ListRunsResponse

@typing.final
class CreateRunRequest(google.protobuf.message.Message):
    """The request of a call to `RunService_CreateRuns` to create a new run."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAME_FIELD_NUMBER: builtins.int
    DESCRIPTION_FIELD_NUMBER: builtins.int
    TAGS_FIELD_NUMBER: builtins.int
    START_TIME_FIELD_NUMBER: builtins.int
    STOP_TIME_FIELD_NUMBER: builtins.int
    ORGANIZATION_ID_FIELD_NUMBER: builtins.int
    CLIENT_KEY_FIELD_NUMBER: builtins.int
    METADATA_FIELD_NUMBER: builtins.int
    name: builtins.str
    """The name that will be assigned to the new run."""
    description: builtins.str
    """A description about the new run."""
    organization_id: builtins.str
    """An organization ID is only required if the user belongs to multiple organizations."""
    client_key: builtins.str
    """An arbitrary user-chosen key that uniquely identifies this run. Optional, though it is recommended to provide."""
    @property
    def tags(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """Tags to associate with the new run."""

    @property
    def start_time(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """The time at which data ingestion begins for this new run. It must be before the `stop_time`, and it must
        be provided if a `stop_time` is provided.
        Important note: `start_time` will be automatically computed during data ingestion and will be set
        based on the timestamp of the data for this run.
        """

    @property
    def stop_time(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """The time at which data ingestion for this new run concludes.
        Important note: `stop_time` will be automatically computed during data ingestion and will be
        set based on the timestamp of the data for this run.
        """

    @property
    def metadata(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[sift.metadata.v1.metadata_pb2.MetadataValue]:
        """The metadata values associated with this run."""

    def __init__(
        self,
        *,
        name: builtins.str = ...,
        description: builtins.str = ...,
        tags: collections.abc.Iterable[builtins.str] | None = ...,
        start_time: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        stop_time: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        organization_id: builtins.str = ...,
        client_key: builtins.str | None = ...,
        metadata: collections.abc.Iterable[sift.metadata.v1.metadata_pb2.MetadataValue] | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["_client_key", b"_client_key", "client_key", b"client_key", "start_time", b"start_time", "stop_time", b"stop_time"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["_client_key", b"_client_key", "client_key", b"client_key", "description", b"description", "metadata", b"metadata", "name", b"name", "organization_id", b"organization_id", "start_time", b"start_time", "stop_time", b"stop_time", "tags", b"tags"]) -> None: ...
    def WhichOneof(self, oneof_group: typing.Literal["_client_key", b"_client_key"]) -> typing.Literal["client_key"] | None: ...

global___CreateRunRequest = CreateRunRequest

@typing.final
class CreateRunResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    RUN_FIELD_NUMBER: builtins.int
    @property
    def run(self) -> global___Run: ...
    def __init__(
        self,
        *,
        run: global___Run | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["run", b"run"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["run", b"run"]) -> None: ...

global___CreateRunResponse = CreateRunResponse

@typing.final
class CreateAdhocRunRequest(google.protobuf.message.Message):
    """The request for a call to `RunService_CreateAdhocRun` to create an adhoc run."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAME_FIELD_NUMBER: builtins.int
    DESCRIPTION_FIELD_NUMBER: builtins.int
    START_TIME_FIELD_NUMBER: builtins.int
    STOP_TIME_FIELD_NUMBER: builtins.int
    ASSET_IDS_FIELD_NUMBER: builtins.int
    TAGS_FIELD_NUMBER: builtins.int
    METADATA_FIELD_NUMBER: builtins.int
    CLIENT_KEY_FIELD_NUMBER: builtins.int
    name: builtins.str
    """The name that will be assigned to the new run."""
    description: builtins.str
    """A description about the new run."""
    client_key: builtins.str
    """An arbitrary user-chosen key that uniquely identifies this run. Optional, though it is recommended to provide."""
    @property
    def start_time(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """The time at which data ingestion began for this new run. It must be before the `stop_time`"""

    @property
    def stop_time(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """The time at which data ingestion concluded for this new run."""

    @property
    def asset_ids(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """A list of asset IDs to associate with the new run."""

    @property
    def tags(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """Tags to associate with the new run."""

    @property
    def metadata(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[sift.metadata.v1.metadata_pb2.MetadataValue]:
        """The metadata values associated with this run."""

    def __init__(
        self,
        *,
        name: builtins.str = ...,
        description: builtins.str = ...,
        start_time: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        stop_time: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        asset_ids: collections.abc.Iterable[builtins.str] | None = ...,
        tags: collections.abc.Iterable[builtins.str] | None = ...,
        metadata: collections.abc.Iterable[sift.metadata.v1.metadata_pb2.MetadataValue] | None = ...,
        client_key: builtins.str | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["_client_key", b"_client_key", "client_key", b"client_key", "start_time", b"start_time", "stop_time", b"stop_time"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["_client_key", b"_client_key", "asset_ids", b"asset_ids", "client_key", b"client_key", "description", b"description", "metadata", b"metadata", "name", b"name", "start_time", b"start_time", "stop_time", b"stop_time", "tags", b"tags"]) -> None: ...
    def WhichOneof(self, oneof_group: typing.Literal["_client_key", b"_client_key"]) -> typing.Literal["client_key"] | None: ...

global___CreateAdhocRunRequest = CreateAdhocRunRequest

@typing.final
class CreateAdhocRunResponse(google.protobuf.message.Message):
    """The response of a call to `RunService_CreateAdhocRun` containing the newly created adhoc run."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    RUN_FIELD_NUMBER: builtins.int
    @property
    def run(self) -> global___Run: ...
    def __init__(
        self,
        *,
        run: global___Run | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["run", b"run"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["run", b"run"]) -> None: ...

global___CreateAdhocRunResponse = CreateAdhocRunResponse

@typing.final
class UpdateRunRequest(google.protobuf.message.Message):
    """The request for a call to `RunService_UpdateRun` to update an existing run."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    RUN_FIELD_NUMBER: builtins.int
    UPDATE_MASK_FIELD_NUMBER: builtins.int
    @property
    def run(self) -> global___Run:
        """The run to update. The run's `run_id` field is used to identify the run to update
        and is required.
        """

    @property
    def update_mask(self) -> google.protobuf.field_mask_pb2.FieldMask:
        """The list of fields to be updated. The fields available to be updated are `name`, `description`,
        `start_time`, `stop_time`, `is_pinned`, `client_key`, `tags`,`is_archived`,  and `metadata`.
        Important Note: When updating the `start_time`, please be aware that if a subsequent data ingestion
        commences for this run, the `start_time` will be automatically overwritten and set to the timestamp
        corresponding to the beginning of the latest run. Additionally, `client_key` can only be set once either in run creation or in update.
        Any subsequent attempt to update `client_key` will result in an error.
        """

    def __init__(
        self,
        *,
        run: global___Run | None = ...,
        update_mask: google.protobuf.field_mask_pb2.FieldMask | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["run", b"run", "update_mask", b"update_mask"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["run", b"run", "update_mask", b"update_mask"]) -> None: ...

global___UpdateRunRequest = UpdateRunRequest

@typing.final
class UpdateRunResponse(google.protobuf.message.Message):
    """The response of a call to `RunService_UpdateRun` containing the updated run."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    RUN_FIELD_NUMBER: builtins.int
    @property
    def run(self) -> global___Run: ...
    def __init__(
        self,
        *,
        run: global___Run | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["run", b"run"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["run", b"run"]) -> None: ...

global___UpdateRunResponse = UpdateRunResponse

@typing.final
class CreateAutomaticRunAssociationForAssetsRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    RUN_ID_FIELD_NUMBER: builtins.int
    ASSET_NAMES_FIELD_NUMBER: builtins.int
    run_id: builtins.str
    """The ID of the run to associate the asset with."""
    @property
    def asset_names(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """A list of asset names to automatically associate with the run.
        Any data that is received for these assets will automatically added to the run.
        This applies even if the run has concluded, so long as the new data contains
        timestamps that are between the `start_time` and `stop_time`.
        If any of the assets are already associated with a different run whose run
        period (the period between `start_time` and `end_time`) overlaps with the
        requested run period, an error will be returned.
        """

    def __init__(
        self,
        *,
        run_id: builtins.str = ...,
        asset_names: collections.abc.Iterable[builtins.str] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["asset_names", b"asset_names", "run_id", b"run_id"]) -> None: ...

global___CreateAutomaticRunAssociationForAssetsRequest = CreateAutomaticRunAssociationForAssetsRequest

@typing.final
class CreateAutomaticRunAssociationForAssetsResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    def __init__(
        self,
    ) -> None: ...

global___CreateAutomaticRunAssociationForAssetsResponse = CreateAutomaticRunAssociationForAssetsResponse

@typing.final
class DeleteRunRequest(google.protobuf.message.Message):
    """The request for a call to `RunService_DeleteRun`."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    RUN_ID_FIELD_NUMBER: builtins.int
    run_id: builtins.str
    def __init__(
        self,
        *,
        run_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["run_id", b"run_id"]) -> None: ...

global___DeleteRunRequest = DeleteRunRequest

@typing.final
class DeleteRunResponse(google.protobuf.message.Message):
    """The response of a call to `RunService_DeleteRun`."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    def __init__(
        self,
    ) -> None: ...

global___DeleteRunResponse = DeleteRunResponse

@typing.final
class StopRunRequest(google.protobuf.message.Message):
    """The request for a call to `RunService_StopRun` to stop a run."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    RUN_ID_FIELD_NUMBER: builtins.int
    run_id: builtins.str
    def __init__(
        self,
        *,
        run_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["run_id", b"run_id"]) -> None: ...

global___StopRunRequest = StopRunRequest

@typing.final
class StopRunResponse(google.protobuf.message.Message):
    """The response of a call to `RunService_StopRun` to stop a run."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    def __init__(
        self,
    ) -> None: ...

global___StopRunResponse = StopRunResponse
