"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
"""

import builtins
import collections.abc
import google.protobuf.descriptor
import google.protobuf.field_mask_pb2
import google.protobuf.internal.containers
import google.protobuf.internal.enum_type_wrapper
import google.protobuf.message
import google.protobuf.timestamp_pb2
import sift.metadata.v1.metadata_pb2
import sift.unit.v2.unit_pb2
import sys
import typing

if sys.version_info >= (3, 10):
    import typing as typing_extensions
else:
    import typing_extensions

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

class _TestStatus:
    ValueType = typing.NewType("ValueType", builtins.int)
    V: typing_extensions.TypeAlias = ValueType

class _TestStatusEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_TestStatus.ValueType], builtins.type):
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
    TEST_STATUS_UNSPECIFIED: _TestStatus.ValueType  # 0
    TEST_STATUS_DRAFT: _TestStatus.ValueType  # 1
    """Barebones test report created, waiting for file processing"""
    TEST_STATUS_PASSED: _TestStatus.ValueType  # 2
    TEST_STATUS_FAILED: _TestStatus.ValueType  # 3
    TEST_STATUS_ABORTED: _TestStatus.ValueType  # 4
    TEST_STATUS_ERROR: _TestStatus.ValueType  # 5
    TEST_STATUS_IN_PROGRESS: _TestStatus.ValueType  # 6
    TEST_STATUS_SKIPPED: _TestStatus.ValueType  # 7

class TestStatus(_TestStatus, metaclass=_TestStatusEnumTypeWrapper): ...

TEST_STATUS_UNSPECIFIED: TestStatus.ValueType  # 0
TEST_STATUS_DRAFT: TestStatus.ValueType  # 1
"""Barebones test report created, waiting for file processing"""
TEST_STATUS_PASSED: TestStatus.ValueType  # 2
TEST_STATUS_FAILED: TestStatus.ValueType  # 3
TEST_STATUS_ABORTED: TestStatus.ValueType  # 4
TEST_STATUS_ERROR: TestStatus.ValueType  # 5
TEST_STATUS_IN_PROGRESS: TestStatus.ValueType  # 6
TEST_STATUS_SKIPPED: TestStatus.ValueType  # 7
global___TestStatus = TestStatus

class _TestStepType:
    ValueType = typing.NewType("ValueType", builtins.int)
    V: typing_extensions.TypeAlias = ValueType

class _TestStepTypeEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_TestStepType.ValueType], builtins.type):
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
    TEST_STEP_TYPE_UNSPECIFIED: _TestStepType.ValueType  # 0
    TEST_STEP_TYPE_SEQUENCE: _TestStepType.ValueType  # 1
    """ResultSet/MainSequence - top-level test sequence"""
    TEST_STEP_TYPE_GROUP: _TestStepType.ValueType  # 2
    """TestGroup - logical grouping of test steps"""
    TEST_STEP_TYPE_ACTION: _TestStepType.ValueType  # 3
    """SessionAction - individual executable action"""
    TEST_STEP_TYPE_FLOW_CONTROL: _TestStepType.ValueType  # 4
    """Flow control elements (While, If, etc.)"""

class TestStepType(_TestStepType, metaclass=_TestStepTypeEnumTypeWrapper): ...

TEST_STEP_TYPE_UNSPECIFIED: TestStepType.ValueType  # 0
TEST_STEP_TYPE_SEQUENCE: TestStepType.ValueType  # 1
"""ResultSet/MainSequence - top-level test sequence"""
TEST_STEP_TYPE_GROUP: TestStepType.ValueType  # 2
"""TestGroup - logical grouping of test steps"""
TEST_STEP_TYPE_ACTION: TestStepType.ValueType  # 3
"""SessionAction - individual executable action"""
TEST_STEP_TYPE_FLOW_CONTROL: TestStepType.ValueType  # 4
"""Flow control elements (While, If, etc.)"""
global___TestStepType = TestStepType

class _TestMeasurementType:
    ValueType = typing.NewType("ValueType", builtins.int)
    V: typing_extensions.TypeAlias = ValueType

class _TestMeasurementTypeEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_TestMeasurementType.ValueType], builtins.type):
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
    TEST_MEASUREMENT_TYPE_UNSPECIFIED: _TestMeasurementType.ValueType  # 0
    TEST_MEASUREMENT_TYPE_DOUBLE: _TestMeasurementType.ValueType  # 1
    TEST_MEASUREMENT_TYPE_STRING: _TestMeasurementType.ValueType  # 3
    TEST_MEASUREMENT_TYPE_BOOLEAN: _TestMeasurementType.ValueType  # 4
    TEST_MEASUREMENT_TYPE_LIMIT: _TestMeasurementType.ValueType  # 5

class TestMeasurementType(_TestMeasurementType, metaclass=_TestMeasurementTypeEnumTypeWrapper): ...

TEST_MEASUREMENT_TYPE_UNSPECIFIED: TestMeasurementType.ValueType  # 0
TEST_MEASUREMENT_TYPE_DOUBLE: TestMeasurementType.ValueType  # 1
TEST_MEASUREMENT_TYPE_STRING: TestMeasurementType.ValueType  # 3
TEST_MEASUREMENT_TYPE_BOOLEAN: TestMeasurementType.ValueType  # 4
TEST_MEASUREMENT_TYPE_LIMIT: TestMeasurementType.ValueType  # 5
global___TestMeasurementType = TestMeasurementType

@typing.final
class TestReport(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    TEST_REPORT_ID_FIELD_NUMBER: builtins.int
    STATUS_FIELD_NUMBER: builtins.int
    NAME_FIELD_NUMBER: builtins.int
    TEST_SYSTEM_NAME_FIELD_NUMBER: builtins.int
    TEST_CASE_FIELD_NUMBER: builtins.int
    START_TIME_FIELD_NUMBER: builtins.int
    END_TIME_FIELD_NUMBER: builtins.int
    METADATA_FIELD_NUMBER: builtins.int
    SERIAL_NUMBER_FIELD_NUMBER: builtins.int
    PART_NUMBER_FIELD_NUMBER: builtins.int
    SYSTEM_OPERATOR_FIELD_NUMBER: builtins.int
    ARCHIVED_DATE_FIELD_NUMBER: builtins.int
    IS_ARCHIVED_FIELD_NUMBER: builtins.int
    RUN_ID_FIELD_NUMBER: builtins.int
    test_report_id: builtins.str
    """Unique identifier for the run"""
    status: global___TestStatus.ValueType
    """The status of the test run"""
    name: builtins.str
    """The name of the test run"""
    test_system_name: builtins.str
    """The name of the test system"""
    test_case: builtins.str
    """The test case that was run"""
    serial_number: builtins.str
    """The serial number for the DUT"""
    part_number: builtins.str
    """The part number for the DUT"""
    system_operator: builtins.str
    """Unique identifier for user owner"""
    is_archived: builtins.bool
    """Whether the test run is archived (externally exposed)"""
    run_id: builtins.str
    """The run ID for the test run"""
    @property
    def start_time(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """The start time of the test run"""

    @property
    def end_time(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """The end time of the test run"""

    @property
    def metadata(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[sift.metadata.v1.metadata_pb2.MetadataValue]:
        """The metadata values associated with this test run"""

    @property
    def archived_date(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """The date and time the test run was archived (internal)"""

    def __init__(
        self,
        *,
        test_report_id: builtins.str = ...,
        status: global___TestStatus.ValueType = ...,
        name: builtins.str = ...,
        test_system_name: builtins.str = ...,
        test_case: builtins.str = ...,
        start_time: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        end_time: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        metadata: collections.abc.Iterable[sift.metadata.v1.metadata_pb2.MetadataValue] | None = ...,
        serial_number: builtins.str = ...,
        part_number: builtins.str = ...,
        system_operator: builtins.str = ...,
        archived_date: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        is_archived: builtins.bool = ...,
        run_id: builtins.str = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["archived_date", b"archived_date", "end_time", b"end_time", "start_time", b"start_time"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["archived_date", b"archived_date", "end_time", b"end_time", "is_archived", b"is_archived", "metadata", b"metadata", "name", b"name", "part_number", b"part_number", "run_id", b"run_id", "serial_number", b"serial_number", "start_time", b"start_time", "status", b"status", "system_operator", b"system_operator", "test_case", b"test_case", "test_report_id", b"test_report_id", "test_system_name", b"test_system_name"]) -> None: ...

global___TestReport = TestReport

@typing.final
class TestStep(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    TEST_STEP_ID_FIELD_NUMBER: builtins.int
    TEST_REPORT_ID_FIELD_NUMBER: builtins.int
    PARENT_STEP_ID_FIELD_NUMBER: builtins.int
    NAME_FIELD_NUMBER: builtins.int
    DESCRIPTION_FIELD_NUMBER: builtins.int
    STEP_TYPE_FIELD_NUMBER: builtins.int
    STEP_PATH_FIELD_NUMBER: builtins.int
    STATUS_FIELD_NUMBER: builtins.int
    START_TIME_FIELD_NUMBER: builtins.int
    END_TIME_FIELD_NUMBER: builtins.int
    ERROR_INFO_FIELD_NUMBER: builtins.int
    test_step_id: builtins.str
    """unique identifier for the step"""
    test_report_id: builtins.str
    """pointer to overall test run"""
    parent_step_id: builtins.str
    """pointer to parent step, if any"""
    name: builtins.str
    """Name of the test step for display"""
    description: builtins.str
    """Description of the test step from test controller"""
    step_type: global___TestStepType.ValueType
    """Semantic type of the test step"""
    step_path: builtins.str
    """Hierarchical path (e.g., "1", "1.1", "1.2.3")"""
    status: global___TestStatus.ValueType
    """Status of the test step"""
    @property
    def start_time(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """Start time of the test step"""

    @property
    def end_time(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """End time of the test step"""

    @property
    def error_info(self) -> global___ErrorInfo:
        """Error information of the test step"""

    def __init__(
        self,
        *,
        test_step_id: builtins.str = ...,
        test_report_id: builtins.str = ...,
        parent_step_id: builtins.str = ...,
        name: builtins.str = ...,
        description: builtins.str = ...,
        step_type: global___TestStepType.ValueType = ...,
        step_path: builtins.str = ...,
        status: global___TestStatus.ValueType = ...,
        start_time: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        end_time: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        error_info: global___ErrorInfo | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["end_time", b"end_time", "error_info", b"error_info", "start_time", b"start_time"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["description", b"description", "end_time", b"end_time", "error_info", b"error_info", "name", b"name", "parent_step_id", b"parent_step_id", "start_time", b"start_time", "status", b"status", "step_path", b"step_path", "step_type", b"step_type", "test_report_id", b"test_report_id", "test_step_id", b"test_step_id"]) -> None: ...

global___TestStep = TestStep

@typing.final
class ErrorInfo(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ERROR_CODE_FIELD_NUMBER: builtins.int
    ERROR_MESSAGE_FIELD_NUMBER: builtins.int
    error_code: builtins.int
    error_message: builtins.str
    def __init__(
        self,
        *,
        error_code: builtins.int = ...,
        error_message: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["error_code", b"error_code", "error_message", b"error_message"]) -> None: ...

global___ErrorInfo = ErrorInfo

@typing.final
class TestMeasurement(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    MEASUREMENT_ID_FIELD_NUMBER: builtins.int
    MEASUREMENT_TYPE_FIELD_NUMBER: builtins.int
    NAME_FIELD_NUMBER: builtins.int
    TEST_STEP_ID_FIELD_NUMBER: builtins.int
    TEST_REPORT_ID_FIELD_NUMBER: builtins.int
    NUMERIC_VALUE_FIELD_NUMBER: builtins.int
    STRING_VALUE_FIELD_NUMBER: builtins.int
    BOOLEAN_VALUE_FIELD_NUMBER: builtins.int
    UNIT_FIELD_NUMBER: builtins.int
    NUMERIC_BOUNDS_FIELD_NUMBER: builtins.int
    STRING_BOUNDS_FIELD_NUMBER: builtins.int
    PASSED_FIELD_NUMBER: builtins.int
    TIMESTAMP_FIELD_NUMBER: builtins.int
    measurement_id: builtins.str
    measurement_type: global___TestMeasurementType.ValueType
    name: builtins.str
    test_step_id: builtins.str
    test_report_id: builtins.str
    numeric_value: builtins.float
    string_value: builtins.str
    boolean_value: builtins.bool
    passed: builtins.bool
    @property
    def unit(self) -> sift.unit.v2.unit_pb2.Unit: ...
    @property
    def numeric_bounds(self) -> global___NumericBounds: ...
    @property
    def string_bounds(self) -> global___StringBounds: ...
    @property
    def timestamp(self) -> google.protobuf.timestamp_pb2.Timestamp: ...
    def __init__(
        self,
        *,
        measurement_id: builtins.str = ...,
        measurement_type: global___TestMeasurementType.ValueType = ...,
        name: builtins.str = ...,
        test_step_id: builtins.str = ...,
        test_report_id: builtins.str = ...,
        numeric_value: builtins.float = ...,
        string_value: builtins.str = ...,
        boolean_value: builtins.bool = ...,
        unit: sift.unit.v2.unit_pb2.Unit | None = ...,
        numeric_bounds: global___NumericBounds | None = ...,
        string_bounds: global___StringBounds | None = ...,
        passed: builtins.bool = ...,
        timestamp: google.protobuf.timestamp_pb2.Timestamp | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["boolean_value", b"boolean_value", "bounds", b"bounds", "numeric_bounds", b"numeric_bounds", "numeric_value", b"numeric_value", "string_bounds", b"string_bounds", "string_value", b"string_value", "timestamp", b"timestamp", "unit", b"unit", "value", b"value"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["boolean_value", b"boolean_value", "bounds", b"bounds", "measurement_id", b"measurement_id", "measurement_type", b"measurement_type", "name", b"name", "numeric_bounds", b"numeric_bounds", "numeric_value", b"numeric_value", "passed", b"passed", "string_bounds", b"string_bounds", "string_value", b"string_value", "test_report_id", b"test_report_id", "test_step_id", b"test_step_id", "timestamp", b"timestamp", "unit", b"unit", "value", b"value"]) -> None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing.Literal["bounds", b"bounds"]) -> typing.Literal["numeric_bounds", "string_bounds"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing.Literal["value", b"value"]) -> typing.Literal["numeric_value", "string_value", "boolean_value"] | None: ...

global___TestMeasurement = TestMeasurement

@typing.final
class NumericBounds(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    MIN_FIELD_NUMBER: builtins.int
    MAX_FIELD_NUMBER: builtins.int
    min: builtins.float
    max: builtins.float
    def __init__(
        self,
        *,
        min: builtins.float | None = ...,
        max: builtins.float | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["_max", b"_max", "_min", b"_min", "max", b"max", "min", b"min"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["_max", b"_max", "_min", b"_min", "max", b"max", "min", b"min"]) -> None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing.Literal["_max", b"_max"]) -> typing.Literal["max"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing.Literal["_min", b"_min"]) -> typing.Literal["min"] | None: ...

global___NumericBounds = NumericBounds

@typing.final
class StringBounds(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    EXPECTED_VALUE_FIELD_NUMBER: builtins.int
    expected_value: builtins.str
    def __init__(
        self,
        *,
        expected_value: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["expected_value", b"expected_value"]) -> None: ...

global___StringBounds = StringBounds

@typing.final
class ImportTestReportRequest(google.protobuf.message.Message):
    """Request message for ImportTestReport"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    REMOTE_FILE_ID_FIELD_NUMBER: builtins.int
    remote_file_id: builtins.str
    """The remote file ID containing the XML test data"""
    def __init__(
        self,
        *,
        remote_file_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["remote_file_id", b"remote_file_id"]) -> None: ...

global___ImportTestReportRequest = ImportTestReportRequest

@typing.final
class ImportTestReportResponse(google.protobuf.message.Message):
    """Response message for ImportTestReport"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    TEST_REPORT_FIELD_NUMBER: builtins.int
    @property
    def test_report(self) -> global___TestReport:
        """The imported test report"""

    def __init__(
        self,
        *,
        test_report: global___TestReport | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["test_report", b"test_report"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["test_report", b"test_report"]) -> None: ...

global___ImportTestReportResponse = ImportTestReportResponse

@typing.final
class CreateTestReportRequest(google.protobuf.message.Message):
    """Request message for CreateTestReport"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    STATUS_FIELD_NUMBER: builtins.int
    NAME_FIELD_NUMBER: builtins.int
    TEST_SYSTEM_NAME_FIELD_NUMBER: builtins.int
    TEST_CASE_FIELD_NUMBER: builtins.int
    START_TIME_FIELD_NUMBER: builtins.int
    END_TIME_FIELD_NUMBER: builtins.int
    METADATA_FIELD_NUMBER: builtins.int
    SERIAL_NUMBER_FIELD_NUMBER: builtins.int
    PART_NUMBER_FIELD_NUMBER: builtins.int
    SYSTEM_OPERATOR_FIELD_NUMBER: builtins.int
    RUN_ID_FIELD_NUMBER: builtins.int
    status: global___TestStatus.ValueType
    """The status of the test run"""
    name: builtins.str
    """The name of the test run"""
    test_system_name: builtins.str
    """The name of the test system"""
    test_case: builtins.str
    """The test case that was run"""
    serial_number: builtins.str
    """The serial number for the DUT"""
    part_number: builtins.str
    """The part number for the DUT"""
    system_operator: builtins.str
    """Unique identifier for user owner"""
    run_id: builtins.str
    """The run ID for the test report"""
    @property
    def start_time(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """The start time of the test run"""

    @property
    def end_time(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """The end time of the test run"""

    @property
    def metadata(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[sift.metadata.v1.metadata_pb2.MetadataValue]:
        """The metadata values associated with this test run"""

    def __init__(
        self,
        *,
        status: global___TestStatus.ValueType = ...,
        name: builtins.str = ...,
        test_system_name: builtins.str = ...,
        test_case: builtins.str = ...,
        start_time: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        end_time: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        metadata: collections.abc.Iterable[sift.metadata.v1.metadata_pb2.MetadataValue] | None = ...,
        serial_number: builtins.str = ...,
        part_number: builtins.str = ...,
        system_operator: builtins.str = ...,
        run_id: builtins.str = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["end_time", b"end_time", "start_time", b"start_time"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["end_time", b"end_time", "metadata", b"metadata", "name", b"name", "part_number", b"part_number", "run_id", b"run_id", "serial_number", b"serial_number", "start_time", b"start_time", "status", b"status", "system_operator", b"system_operator", "test_case", b"test_case", "test_system_name", b"test_system_name"]) -> None: ...

global___CreateTestReportRequest = CreateTestReportRequest

@typing.final
class CreateTestReportResponse(google.protobuf.message.Message):
    """Response message for CreateTestReport"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    TEST_REPORT_FIELD_NUMBER: builtins.int
    @property
    def test_report(self) -> global___TestReport:
        """The created test report"""

    def __init__(
        self,
        *,
        test_report: global___TestReport | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["test_report", b"test_report"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["test_report", b"test_report"]) -> None: ...

global___CreateTestReportResponse = CreateTestReportResponse

@typing.final
class GetTestReportRequest(google.protobuf.message.Message):
    """Request message for GetTestReport"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    TEST_REPORT_ID_FIELD_NUMBER: builtins.int
    test_report_id: builtins.str
    """The ID of the test report to get"""
    def __init__(
        self,
        *,
        test_report_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["test_report_id", b"test_report_id"]) -> None: ...

global___GetTestReportRequest = GetTestReportRequest

@typing.final
class GetTestReportResponse(google.protobuf.message.Message):
    """Response message for GetTestReport"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    TEST_REPORT_FIELD_NUMBER: builtins.int
    @property
    def test_report(self) -> global___TestReport:
        """The test report"""

    def __init__(
        self,
        *,
        test_report: global___TestReport | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["test_report", b"test_report"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["test_report", b"test_report"]) -> None: ...

global___GetTestReportResponse = GetTestReportResponse

@typing.final
class ListTestReportsRequest(google.protobuf.message.Message):
    """Request message for ListTestReports"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PAGE_SIZE_FIELD_NUMBER: builtins.int
    PAGE_TOKEN_FIELD_NUMBER: builtins.int
    FILTER_FIELD_NUMBER: builtins.int
    ORDER_BY_FIELD_NUMBER: builtins.int
    page_size: builtins.int
    """The maximum number of test reports to return.
    The service may return fewer than this value.
    If unspecified, at most 50 test reports will be returned.
    The maximum value is 1000; values above 1000 will be coerced to 1000.
    """
    page_token: builtins.str
    """A page token, received from a previous `ListTestReports` call.
    Provide this to retrieve the subsequent page.
    When paginating, all other parameters provided to `ListTestReports` must match
    the call that provided the page token.
    """
    filter: builtins.str
    """A [Common Expression Language (CEL)](https://github.com/google/cel-spec) filter string.
    Available fields to filter by are `test_report_id`, `status`, `name`, `test_system_name`,
    `test_case`, `start_time`, `end_time`, `serial_number`, `created_by_user_id`, `modified_by_user_id`,
    `part_number`, `system_operator`, `run_id`, `archived_date`, and `metadata`.
    Metadata can be used in filters by using `metadata.{metadata_key_name}` as the field name.
    For further information about how to use CELs, please refer to [this guide](https://github.com/google/cel-spec/blob/master/doc/langdef.md#standard-definitions).
    For more information about the fields used for filtering, please refer to [this definition](/docs/api/grpc/protocol-buffers/test-results#testreport). Optional.
    """
    order_by: builtins.str
    """How to order the retrieved test reports. Formatted as a comma-separated string i.e. "FIELD_NAME[ desc],...".
    Available fields to order_by are `test_report_id`, `name`, `test_system_name`, `test_case`, `start_time`, `end_time`,
    `created_date`, and `modified_date`.
    If left empty, items are ordered by `start_time` in descending order (newest-first).
    For more information about the format of this field, read [this](https://google.aip.dev/132#ordering)
    Example: "start_time desc,name"
    """
    def __init__(
        self,
        *,
        page_size: builtins.int = ...,
        page_token: builtins.str = ...,
        filter: builtins.str = ...,
        order_by: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["filter", b"filter", "order_by", b"order_by", "page_size", b"page_size", "page_token", b"page_token"]) -> None: ...

global___ListTestReportsRequest = ListTestReportsRequest

@typing.final
class ListTestReportsResponse(google.protobuf.message.Message):
    """Response message for ListTestReports"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    TEST_REPORTS_FIELD_NUMBER: builtins.int
    NEXT_PAGE_TOKEN_FIELD_NUMBER: builtins.int
    next_page_token: builtins.str
    """The next page token for pagination"""
    @property
    def test_reports(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___TestReport]:
        """The list of test reports"""

    def __init__(
        self,
        *,
        test_reports: collections.abc.Iterable[global___TestReport] | None = ...,
        next_page_token: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["next_page_token", b"next_page_token", "test_reports", b"test_reports"]) -> None: ...

global___ListTestReportsResponse = ListTestReportsResponse

@typing.final
class UpdateTestReportRequest(google.protobuf.message.Message):
    """Request message for UpdateTestReport"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    TEST_REPORT_FIELD_NUMBER: builtins.int
    UPDATE_MASK_FIELD_NUMBER: builtins.int
    @property
    def test_report(self) -> global___TestReport:
        """The test report to update"""

    @property
    def update_mask(self) -> google.protobuf.field_mask_pb2.FieldMask:
        """The field mask specifying which fields to update. The fields available to be updated are
        `status`, `name`, `test_system_name`, `test_case`, `start_time`, `end_time`, `serial_number`,
        `part_number`, `system_operator`, `run_id`, and `is_archived`.
        """

    def __init__(
        self,
        *,
        test_report: global___TestReport | None = ...,
        update_mask: google.protobuf.field_mask_pb2.FieldMask | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["test_report", b"test_report", "update_mask", b"update_mask"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["test_report", b"test_report", "update_mask", b"update_mask"]) -> None: ...

global___UpdateTestReportRequest = UpdateTestReportRequest

@typing.final
class UpdateTestReportResponse(google.protobuf.message.Message):
    """Response message for UpdateTestReport"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    TEST_REPORT_FIELD_NUMBER: builtins.int
    @property
    def test_report(self) -> global___TestReport:
        """The updated test report"""

    def __init__(
        self,
        *,
        test_report: global___TestReport | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["test_report", b"test_report"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["test_report", b"test_report"]) -> None: ...

global___UpdateTestReportResponse = UpdateTestReportResponse

@typing.final
class DeleteTestReportRequest(google.protobuf.message.Message):
    """Request message for DeleteTestReport"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    TEST_REPORT_ID_FIELD_NUMBER: builtins.int
    test_report_id: builtins.str
    """The ID of the test report to delete"""
    def __init__(
        self,
        *,
        test_report_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["test_report_id", b"test_report_id"]) -> None: ...

global___DeleteTestReportRequest = DeleteTestReportRequest

@typing.final
class DeleteTestReportResponse(google.protobuf.message.Message):
    """Response message for DeleteTestReport
    Empty response indicating successful deletion
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    def __init__(
        self,
    ) -> None: ...

global___DeleteTestReportResponse = DeleteTestReportResponse

@typing.final
class CreateTestStepRequest(google.protobuf.message.Message):
    """Request message for CreateTestStep"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    TEST_STEP_FIELD_NUMBER: builtins.int
    @property
    def test_step(self) -> global___TestStep:
        """The test step to create"""

    def __init__(
        self,
        *,
        test_step: global___TestStep | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["test_step", b"test_step"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["test_step", b"test_step"]) -> None: ...

global___CreateTestStepRequest = CreateTestStepRequest

@typing.final
class CreateTestStepResponse(google.protobuf.message.Message):
    """Response message for CreateTestStep"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    TEST_STEP_FIELD_NUMBER: builtins.int
    @property
    def test_step(self) -> global___TestStep:
        """The created test step"""

    def __init__(
        self,
        *,
        test_step: global___TestStep | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["test_step", b"test_step"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["test_step", b"test_step"]) -> None: ...

global___CreateTestStepResponse = CreateTestStepResponse

@typing.final
class ListTestStepsRequest(google.protobuf.message.Message):
    """Request message for ListTestSteps"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PAGE_SIZE_FIELD_NUMBER: builtins.int
    PAGE_TOKEN_FIELD_NUMBER: builtins.int
    FILTER_FIELD_NUMBER: builtins.int
    ORDER_BY_FIELD_NUMBER: builtins.int
    page_size: builtins.int
    """The maximum number of test steps to return.
    The service may return fewer than this value.
    If unspecified, at most 50 test steps will be returned.
    The maximum value is 1000; values above 1000 will be coerced to 1000.
    """
    page_token: builtins.str
    """A page token, received from a previous `ListTestSteps` call.
    Provide this to retrieve the subsequent page.
    When paginating, all other parameters provided to `ListTestSteps` must match
    the call that provided the page token.
    """
    filter: builtins.str
    """A [Common Expression Language (CEL)](https://github.com/google/cel-spec) filter string.
    Available fields to filter by are `test_step_id`, `test_report_id`, `parent_step_id`, `name`,
    `description`, `step_type`, `step_path`, `status`, `start_time`, `end_time`,
    `error_code`, `error_message`, `created_date`, and `modified_date`.
    For further information about how to use CELs, please refer to [this guide](https://github.com/google/cel-spec/blob/master/doc/langdef.md#standard-definitions).
    For more information about the fields used for filtering, please refer to [this definition](/docs/api/grpc/protocol-buffers/test-results#teststep). Optional.
    """
    order_by: builtins.str
    """How to order the retrieved test steps. Formatted as a comma-separated string i.e. "FIELD_NAME[ desc],...".
    Available fields to order_by are `test_step_id`, `name`, `step_type`, `step_path`, `status`,
    `start_time`, `end_time`, `created_date`, and `modified_date`.
    If left empty, items are ordered by `step_path` in ascending order.
    For more information about the format of this field, read [this](https://google.aip.dev/132#ordering)
    Example: "step_path asc,start_time desc"
    """
    def __init__(
        self,
        *,
        page_size: builtins.int = ...,
        page_token: builtins.str = ...,
        filter: builtins.str = ...,
        order_by: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["filter", b"filter", "order_by", b"order_by", "page_size", b"page_size", "page_token", b"page_token"]) -> None: ...

global___ListTestStepsRequest = ListTestStepsRequest

@typing.final
class ListTestStepsResponse(google.protobuf.message.Message):
    """Response message for ListTestSteps"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    TEST_STEPS_FIELD_NUMBER: builtins.int
    NEXT_PAGE_TOKEN_FIELD_NUMBER: builtins.int
    next_page_token: builtins.str
    """The next page token for pagination"""
    @property
    def test_steps(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___TestStep]:
        """The list of test steps"""

    def __init__(
        self,
        *,
        test_steps: collections.abc.Iterable[global___TestStep] | None = ...,
        next_page_token: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["next_page_token", b"next_page_token", "test_steps", b"test_steps"]) -> None: ...

global___ListTestStepsResponse = ListTestStepsResponse

@typing.final
class UpdateTestStepRequest(google.protobuf.message.Message):
    """Request message for UpdateTestStep"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    TEST_STEP_FIELD_NUMBER: builtins.int
    UPDATE_MASK_FIELD_NUMBER: builtins.int
    @property
    def test_step(self) -> global___TestStep:
        """The test step to update"""

    @property
    def update_mask(self) -> google.protobuf.field_mask_pb2.FieldMask:
        """The field mask specifying which fields to update. The fields available to be updated are
        `name`, `description`, `step_type`, `step_path`, `test_case`, `status`,
        `start_time`, `end_time`, and `error_info`.
        """

    def __init__(
        self,
        *,
        test_step: global___TestStep | None = ...,
        update_mask: google.protobuf.field_mask_pb2.FieldMask | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["test_step", b"test_step", "update_mask", b"update_mask"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["test_step", b"test_step", "update_mask", b"update_mask"]) -> None: ...

global___UpdateTestStepRequest = UpdateTestStepRequest

@typing.final
class UpdateTestStepResponse(google.protobuf.message.Message):
    """Response message for UpdateTestStep"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    TEST_STEP_FIELD_NUMBER: builtins.int
    @property
    def test_step(self) -> global___TestStep:
        """The updated test step"""

    def __init__(
        self,
        *,
        test_step: global___TestStep | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["test_step", b"test_step"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["test_step", b"test_step"]) -> None: ...

global___UpdateTestStepResponse = UpdateTestStepResponse

@typing.final
class DeleteTestStepRequest(google.protobuf.message.Message):
    """Request message for DeleteTestStep"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    TEST_STEP_ID_FIELD_NUMBER: builtins.int
    test_step_id: builtins.str
    """The ID of the test step to delete"""
    def __init__(
        self,
        *,
        test_step_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["test_step_id", b"test_step_id"]) -> None: ...

global___DeleteTestStepRequest = DeleteTestStepRequest

@typing.final
class DeleteTestStepResponse(google.protobuf.message.Message):
    """Response message for DeleteTestStep
    Empty response indicating successful deletion
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    def __init__(
        self,
    ) -> None: ...

global___DeleteTestStepResponse = DeleteTestStepResponse

@typing.final
class CreateTestMeasurementRequest(google.protobuf.message.Message):
    """Request message for CreateTestMeasurement"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    TEST_MEASUREMENT_FIELD_NUMBER: builtins.int
    @property
    def test_measurement(self) -> global___TestMeasurement:
        """The test measurement to create"""

    def __init__(
        self,
        *,
        test_measurement: global___TestMeasurement | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["test_measurement", b"test_measurement"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["test_measurement", b"test_measurement"]) -> None: ...

global___CreateTestMeasurementRequest = CreateTestMeasurementRequest

@typing.final
class CreateTestMeasurementResponse(google.protobuf.message.Message):
    """Response message for CreateTestMeasurement"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    TEST_MEASUREMENT_FIELD_NUMBER: builtins.int
    @property
    def test_measurement(self) -> global___TestMeasurement:
        """The created test measurement"""

    def __init__(
        self,
        *,
        test_measurement: global___TestMeasurement | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["test_measurement", b"test_measurement"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["test_measurement", b"test_measurement"]) -> None: ...

global___CreateTestMeasurementResponse = CreateTestMeasurementResponse

@typing.final
class CreateTestMeasurementsRequest(google.protobuf.message.Message):
    """Request message for CreateTestMeasurements"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    TEST_MEASUREMENTS_FIELD_NUMBER: builtins.int
    @property
    def test_measurements(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___TestMeasurement]:
        """The test measurements to create"""

    def __init__(
        self,
        *,
        test_measurements: collections.abc.Iterable[global___TestMeasurement] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["test_measurements", b"test_measurements"]) -> None: ...

global___CreateTestMeasurementsRequest = CreateTestMeasurementsRequest

@typing.final
class CreateTestMeasurementsResponse(google.protobuf.message.Message):
    """Response message for CreateTestMeasurements"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    MEASUREMENTS_CREATED_COUNT_FIELD_NUMBER: builtins.int
    MEASUREMENT_IDS_FIELD_NUMBER: builtins.int
    measurements_created_count: builtins.int
    """The number of test measurements successfully created"""
    @property
    def measurement_ids(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """The IDs of the created test measurements"""

    def __init__(
        self,
        *,
        measurements_created_count: builtins.int = ...,
        measurement_ids: collections.abc.Iterable[builtins.str] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["measurement_ids", b"measurement_ids", "measurements_created_count", b"measurements_created_count"]) -> None: ...

global___CreateTestMeasurementsResponse = CreateTestMeasurementsResponse

@typing.final
class ListTestMeasurementsRequest(google.protobuf.message.Message):
    """Request message for ListTestMeasurements"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PAGE_SIZE_FIELD_NUMBER: builtins.int
    PAGE_TOKEN_FIELD_NUMBER: builtins.int
    FILTER_FIELD_NUMBER: builtins.int
    ORDER_BY_FIELD_NUMBER: builtins.int
    page_size: builtins.int
    """The maximum number of test measurements to return.
    The service may return fewer than this value.
    If unspecified, at most 50 test measurements will be returned.
    The maximum value is 1000; values above 1000 will be coerced to 1000.
    """
    page_token: builtins.str
    """A page token, received from a previous `ListTestMeasurements` call.
    Provide this to retrieve the subsequent page.
    When paginating, all other parameters provided to `ListTestMeasurements` must match
    the call that provided the page token.
    """
    filter: builtins.str
    """A [Common Expression Language (CEL)](https://github.com/google/cel-spec) filter string.
    Available fields to filter by are `measurement_id`, `measurement_type`, `name`, `test_step_id`,
    `test_report_id`, `numeric_value`, `string_value`, `boolean_value`, `passed`, `timestamp`,
    `created_date`, and `modified_date`.
    For further information about how to use CELs, please refer to [this guide](https://github.com/google/cel-spec/blob/master/doc/langdef.md#standard-definitions).
    For more information about the fields used for filtering, please refer to [this definition](/docs/api/grpc/protocol-buffers/test-results#testmeasurement). Optional.
    """
    order_by: builtins.str
    """How to order the retrieved test measurements. Formatted as a comma-separated string i.e. "FIELD_NAME[ desc],...".
    Available fields to order_by are `measurement_id`, `name`, `measurement_type`, `test_step_id`, `test_report_id`,
    `passed`, `timestamp`, `created_date`, and `modified_date`.
    If left empty, items are ordered by `timestamp` in ascending order.
    For more information about the format of this field, read [this](https://google.aip.dev/132#ordering)
    Example: "timestamp asc,name"
    """
    def __init__(
        self,
        *,
        page_size: builtins.int = ...,
        page_token: builtins.str = ...,
        filter: builtins.str = ...,
        order_by: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["filter", b"filter", "order_by", b"order_by", "page_size", b"page_size", "page_token", b"page_token"]) -> None: ...

global___ListTestMeasurementsRequest = ListTestMeasurementsRequest

@typing.final
class ListTestMeasurementsResponse(google.protobuf.message.Message):
    """Response message for ListTestMeasurements"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    TEST_MEASUREMENTS_FIELD_NUMBER: builtins.int
    NEXT_PAGE_TOKEN_FIELD_NUMBER: builtins.int
    next_page_token: builtins.str
    """The next page token for pagination"""
    @property
    def test_measurements(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___TestMeasurement]:
        """The list of test measurements"""

    def __init__(
        self,
        *,
        test_measurements: collections.abc.Iterable[global___TestMeasurement] | None = ...,
        next_page_token: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["next_page_token", b"next_page_token", "test_measurements", b"test_measurements"]) -> None: ...

global___ListTestMeasurementsResponse = ListTestMeasurementsResponse

@typing.final
class CountTestStepsRequest(google.protobuf.message.Message):
    """Request message for CountTestSteps"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    FILTER_FIELD_NUMBER: builtins.int
    filter: builtins.str
    """A [Common Expression Language (CEL)](https://github.com/google/cel-spec) filter string.
    Available fields to filter by are `test_step_id`, `test_report_id`, `parent_step_id`, `name`,
    `description`, `step_type`, `step_path`, `status`, `start_time`, `end_time`,
    `error_code`, `error_message`, `created_date`, and `modified_date`.
    For further information about how to use CELs, please refer to [this guide](https://github.com/google/cel-spec/blob/master/doc/langdef.md#standard-definitions).
    For more information about the fields used for filtering, please refer to [this definition](/docs/api/grpc/protocol-buffers/test-results#teststep). Optional.
    """
    def __init__(
        self,
        *,
        filter: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["filter", b"filter"]) -> None: ...

global___CountTestStepsRequest = CountTestStepsRequest

@typing.final
class CountTestStepsResponse(google.protobuf.message.Message):
    """Response message for CountTestSteps"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    COUNT_FIELD_NUMBER: builtins.int
    count: builtins.int
    """The total count of test steps matching the filter"""
    def __init__(
        self,
        *,
        count: builtins.int = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["count", b"count"]) -> None: ...

global___CountTestStepsResponse = CountTestStepsResponse

@typing.final
class CountTestMeasurementsRequest(google.protobuf.message.Message):
    """Request message for CountTestMeasurements"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    FILTER_FIELD_NUMBER: builtins.int
    filter: builtins.str
    """A [Common Expression Language (CEL)](https://github.com/google/cel-spec) filter string.
    Available fields to filter by are `measurement_id`, `measurement_type`, `name`, `test_step_id`,
    `test_report_id`, `numeric_value`, `string_value`, `boolean_value`, `passed`, `timestamp`,
    `created_date`, and `modified_date`.
    For further information about how to use CELs, please refer to [this guide](https://github.com/google/cel-spec/blob/master/doc/langdef.md#standard-definitions).
    For more information about the fields used for filtering, please refer to [this definition](/docs/api/grpc/protocol-buffers/test-results#testmeasurement). Optional.
    """
    def __init__(
        self,
        *,
        filter: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["filter", b"filter"]) -> None: ...

global___CountTestMeasurementsRequest = CountTestMeasurementsRequest

@typing.final
class CountTestMeasurementsResponse(google.protobuf.message.Message):
    """Response message for CountTestMeasurements"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    COUNT_FIELD_NUMBER: builtins.int
    count: builtins.int
    """The total count of test measurements matching the filter"""
    def __init__(
        self,
        *,
        count: builtins.int = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["count", b"count"]) -> None: ...

global___CountTestMeasurementsResponse = CountTestMeasurementsResponse

@typing.final
class UpdateTestMeasurementRequest(google.protobuf.message.Message):
    """Request message for UpdateTestMeasurement"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    TEST_MEASUREMENT_FIELD_NUMBER: builtins.int
    UPDATE_MASK_FIELD_NUMBER: builtins.int
    @property
    def test_measurement(self) -> global___TestMeasurement:
        """The test measurement to update"""

    @property
    def update_mask(self) -> google.protobuf.field_mask_pb2.FieldMask:
        """The field mask specifying which fields to update. The fields available to be updated are
        `name`, `measurement_type`, `numeric_value`, `string_value`, `boolean_value`, `unit`, `numeric_bounds`,
        `string_bounds`, `passed`, and `timestamp`.
        """

    def __init__(
        self,
        *,
        test_measurement: global___TestMeasurement | None = ...,
        update_mask: google.protobuf.field_mask_pb2.FieldMask | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["test_measurement", b"test_measurement", "update_mask", b"update_mask"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["test_measurement", b"test_measurement", "update_mask", b"update_mask"]) -> None: ...

global___UpdateTestMeasurementRequest = UpdateTestMeasurementRequest

@typing.final
class UpdateTestMeasurementResponse(google.protobuf.message.Message):
    """Response message for UpdateTestMeasurement"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    TEST_MEASUREMENT_FIELD_NUMBER: builtins.int
    @property
    def test_measurement(self) -> global___TestMeasurement:
        """The updated test measurement"""

    def __init__(
        self,
        *,
        test_measurement: global___TestMeasurement | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["test_measurement", b"test_measurement"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["test_measurement", b"test_measurement"]) -> None: ...

global___UpdateTestMeasurementResponse = UpdateTestMeasurementResponse

@typing.final
class DeleteTestMeasurementRequest(google.protobuf.message.Message):
    """Request message for DeleteTestMeasurement"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    MEASUREMENT_ID_FIELD_NUMBER: builtins.int
    measurement_id: builtins.str
    """The ID of the test measurement to delete"""
    def __init__(
        self,
        *,
        measurement_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["measurement_id", b"measurement_id"]) -> None: ...

global___DeleteTestMeasurementRequest = DeleteTestMeasurementRequest

@typing.final
class DeleteTestMeasurementResponse(google.protobuf.message.Message):
    """Response message for DeleteTestMeasurement
    Empty response indicating successful deletion
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    def __init__(
        self,
    ) -> None: ...

global___DeleteTestMeasurementResponse = DeleteTestMeasurementResponse
