/*
 * Decompiled with CFR 0.152.
 */
package com.twosigma.beakerx.kernel.handler;

import com.twosigma.beakerx.evaluator.EvaluationObjectFactory;
import com.twosigma.beakerx.evaluator.SimpleEvaluationObjectFactory;
import com.twosigma.beakerx.handler.KernelHandler;
import com.twosigma.beakerx.jvm.object.EvaluationObject;
import com.twosigma.beakerx.kernel.Code;
import com.twosigma.beakerx.kernel.KernelFunctionality;
import com.twosigma.beakerx.kernel.magic.command.CodeFactory;
import com.twosigma.beakerx.kernel.msg.JupyterMessages;
import com.twosigma.beakerx.kernel.msg.MessageCreator;
import com.twosigma.beakerx.message.Header;
import com.twosigma.beakerx.message.Message;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.FutureTask;

public class ExecuteRequestHandler
extends KernelHandler<Message> {
    private final SimpleEvaluationObjectFactory seof;
    private int executionCount = 0;
    private ExecutorService executorService = Executors.newFixedThreadPool(1);
    private FutureTask<String> current;

    public ExecuteRequestHandler(KernelFunctionality kernel) {
        super(kernel);
        this.seof = new SimpleEvaluationObjectFactory();
    }

    public void handle(Message message) {
        try {
            this.executorService.execute(() -> this.handleMsg(message));
        }
        catch (Exception e) {
            this.handleException(message, e);
        }
    }

    private void handleMsg(Message message) {
        this.current = new FutureTask<String>(() -> {
            try {
                this.runCode(message);
            }
            catch (Exception e) {
                this.handleException(message, e);
            }
            return "ok";
        });
        this.current.run();
    }

    private void runCode(Message message) {
        if (this.kernel.isInterrupting()) {
            Message abortedReply = MessageCreator.buildAbortedReply(message);
            this.kernel.send(abortedReply);
        } else {
            this.kernel.sendBusyMessage(message);
            ++this.executionCount;
            String codeString = this.takeCodeFrom(message);
            this.announceTheCode(message, codeString);
            Code code = new CodeFactory(MessageCreator.get(), (EvaluationObjectFactory)this.seof).create(codeString, message, this.kernel);
            code.execute(this.kernel, this.executionCount);
            this.kernel.sendIdleMessage(message);
        }
    }

    private String takeCodeFrom(Message message) {
        String code = "";
        if (message.getContent() != null && message.getContent().containsKey("code")) {
            code = ((String)message.getContent().get("code")).trim();
        }
        return code;
    }

    private void announceTheCode(Message message, String code) {
        Message reply = new Message(new Header(JupyterMessages.EXECUTE_INPUT, message.getHeader().getSession()));
        reply.setParentHeader(message.getHeader());
        reply.setIdentities(message.getIdentities());
        HashMap<String, Object> map1 = new HashMap<String, Object>(2);
        map1.put("execution_count", this.executionCount);
        map1.put("code", code);
        reply.setContent(map1);
        this.kernel.publish(Collections.singletonList(reply));
    }

    private void handleException(Message message, Exception e) {
        EvaluationObject seo = this.seof.createSeo(this.takeCodeFrom(message), this.kernel, message, this.executionCount);
        seo.error((Object)e);
    }

    @Override
    public void exit() {
    }

    public void interruptKernel() {
        this.waitForTheEndOfTheCurrentCell();
        List<Runnable> cells = this.executorService.shutdownNow();
        cells.forEach(Runnable::run);
        this.executorService = Executors.newFixedThreadPool(1);
    }

    private void waitForTheEndOfTheCurrentCell() {
        if (this.current != null) {
            try {
                this.current.get();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }
}

