/*
 * Decompiled with CFR 0.152.
 */
package com.twosigma.beakerx.kernel.magic.command.functionality;

import com.twosigma.beakerx.kernel.KernelFunctionality;
import com.twosigma.beakerx.kernel.MessageCreatorService;
import com.twosigma.beakerx.kernel.magic.command.MagicCommandExecutionParam;
import com.twosigma.beakerx.kernel.magic.command.MagicCommandFunctionality;
import com.twosigma.beakerx.kernel.magic.command.MavenJarResolver;
import com.twosigma.beakerx.kernel.magic.command.PomFactory;
import com.twosigma.beakerx.kernel.magic.command.PomStyleDependencies;
import com.twosigma.beakerx.kernel.magic.command.functionality.ClasspathAddMvnMagicCommand;
import com.twosigma.beakerx.kernel.magic.command.functionality.ClasspathMagicCommand;
import com.twosigma.beakerx.kernel.magic.command.functionality.MagicCommandUtils;
import com.twosigma.beakerx.kernel.magic.command.outcome.MagicCommandOutcomeItem;
import com.twosigma.beakerx.kernel.magic.command.outcome.MagicCommandOutput;
import com.twosigma.beakerx.kernel.msg.MessageCreator;
import com.twosigma.beakerx.message.Message;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class ClassPathAddMvnCellMagicCommand
extends ClasspathMagicCommand {
    public static final String ADD = "add";
    public static final String MVN = "mvn";
    public static final String CLASSPATH_CELL = "%%classpath";
    public static final String CLASSPATH_ADD_MVN_CELL = "%%classpath add mvn";
    public static final String MVN_CELL_FORMAT_ERROR_MESSAGE = "Wrong command format, should be %%classpath add mvn\n group name version [type classifier] or group:name:version[:type:classifier]\n group name version [type classifier] or group:name:version[:type:classifier]";
    private static final String SPLIT_LINE_REGEX = "\\r?\\n";
    private MavenJarResolver.ResolverParams commandParams;
    private PomFactory pomFactory;

    public ClassPathAddMvnCellMagicCommand(MavenJarResolver.ResolverParams commandParams, KernelFunctionality kernel, MessageCreatorService messageCreatorService) {
        super(kernel, messageCreatorService);
        this.commandParams = commandParams;
        this.pomFactory = new PomFactory();
    }

    public String getMagicCommandName() {
        return CLASSPATH_ADD_MVN_CELL;
    }

    public boolean matchCommand(String command) {
        String[] commandParts = MagicCommandUtils.splitPath((String)command);
        return commandParts.length >= 3 && commandParts[0].equals(CLASSPATH_CELL) && commandParts[1].equals(ADD) && commandParts[2].equals(MVN);
    }

    public MagicCommandOutcomeItem execute(MagicCommandExecutionParam param) {
        String command = param.getCommand();
        Message message = param.getCode().getMessage();
        String commandCodeBlock = param.getCommandCodeBlock();
        return this.execute(command, commandCodeBlock, message);
    }

    public MagicCommandOutcomeItem execute(String command, String commandCodeBlock, Message message) {
        if (this.isPomXmlStyle(commandCodeBlock)) {
            return this.pomXmlStyle(commandCodeBlock, message);
        }
        return this.simpleStyle(command, commandCodeBlock, message);
    }

    private MagicCommandOutcomeItem pomXmlStyle(String commandCodeBlock, Message message) {
        return this.retrieve(mavenJarResolver -> mavenJarResolver.retrieve(new PomStyleDependencies(commandCodeBlock), message));
    }

    private MagicCommandOutcomeItem simpleStyle(String command, String commandCodeBlock, Message message) {
        if (commandCodeBlock != null) {
            command = (String)command + "\n" + commandCodeBlock;
        }
        String[] commandLines = ((String)command).split(SPLIT_LINE_REGEX);
        this.unifyMvnLineFormat(commandLines);
        if (!this.validateCommandLines(commandLines)) {
            return new MagicCommandOutput(MagicCommandOutcomeItem.Status.ERROR, MVN_CELL_FORMAT_ERROR_MESSAGE, MessageCreator.get());
        }
        List<MavenJarResolver.Dependency> dependencies = this.getDepsFromCommand(Arrays.copyOfRange(commandLines, 1, commandLines.length));
        return this.retrieve(mavenJarResolver -> mavenJarResolver.retrieve(dependencies, message));
    }

    private MagicCommandOutcomeItem retrieve(MavenJarResolver.RetriveDeps retriveDeps) {
        ClasspathAddMvnMagicCommand mvnMagicCommand = this.getClasspathAddMvnMagicCommand();
        this.commandParams.setRepos(mvnMagicCommand.getRepos().get());
        MavenJarResolver mavenJarResolver = new MavenJarResolver(this.commandParams, this.pomFactory);
        MavenJarResolver.AddMvnCommandResult result = retriveDeps.getDeps(mavenJarResolver);
        if (result.isJarRetrieved()) {
            return this.handleAddedJars(result.getAddedJarPaths());
        }
        return new MagicCommandOutput(MagicCommandOutcomeItem.Status.ERROR, result.getErrorMessage(), MessageCreator.get());
    }

    private ClasspathAddMvnMagicCommand getClasspathAddMvnMagicCommand() {
        MagicCommandFunctionality mvnMagicCommand = this.kernel.magicCommandConfiguration().getClasspathAddMvnMagicCommand(this.kernel);
        return (ClasspathAddMvnMagicCommand)mvnMagicCommand;
    }

    private List<MavenJarResolver.Dependency> getDepsFromCommand(String[] lines) {
        ArrayList<MavenJarResolver.Dependency> dependencies = new ArrayList<MavenJarResolver.Dependency>();
        for (String line : lines) {
            String[] dependencyData = MagicCommandUtils.splitPath((String)line);
            dependencies.add(MavenJarResolver.Dependency.create(Arrays.asList(dependencyData)));
        }
        return dependencies;
    }

    private boolean validateCommandLines(String[] commandLines) {
        boolean isValid = false;
        for (int i = 1; i < commandLines.length; ++i) {
            String[] strings = MagicCommandUtils.splitPath((String)commandLines[i]);
            if (strings.length <= 2) {
                isValid = false;
                break;
            }
            isValid = true;
        }
        return isValid;
    }

    private void unifyMvnLineFormat(String[] mvnLines) {
        for (int i = 0; i < mvnLines.length; ++i) {
            mvnLines[i] = mvnLines[i].replace(":", " ");
        }
    }

    private boolean isPomXmlStyle(String commandCodeBlock) {
        return commandCodeBlock != null && commandCodeBlock.startsWith("<dependencies>");
    }
}

