/*
 * Decompiled with CFR 0.152.
 */
package com.twosigma.beakerx.kernel.magic.command.functionality;

import com.twosigma.beakerx.kernel.KernelFunctionality;
import com.twosigma.beakerx.kernel.magic.command.MagicCommandExecutionParam;
import com.twosigma.beakerx.kernel.magic.command.MagicCommandFunctionality;
import com.twosigma.beakerx.kernel.magic.command.functionality.ClasspathAddMvnMagicCommand;
import com.twosigma.beakerx.kernel.magic.command.functionality.FileService;
import com.twosigma.beakerx.kernel.magic.command.functionality.MagicCommandUtils;
import com.twosigma.beakerx.kernel.magic.command.outcome.MagicCommandOutcomeItem;
import com.twosigma.beakerx.kernel.magic.command.outcome.MagicCommandOutput;
import com.twosigma.beakerx.kernel.msg.MessageCreator;
import java.io.File;

public class ClasspathResetMagicCommand
implements MagicCommandFunctionality {
    public static final String CLASSPATH_PREFIX = "%classpath";
    public static final String RESET = "reset";
    public static final String CLASSPATH_RESET = "%classpath reset";
    private final FileService fileService;
    private KernelFunctionality kernel;

    public ClasspathResetMagicCommand(KernelFunctionality kernel, FileService fileService) {
        this.kernel = kernel;
        this.fileService = fileService;
    }

    public MagicCommandOutcomeItem execute(MagicCommandExecutionParam param) {
        String command = param.getCommand();
        String[] split = MagicCommandUtils.splitPath((String)command);
        if (split.length != 2) {
            return new MagicCommandOutput(MagicCommandOutcomeItem.Status.ERROR, "Wrong format. %classpath reset", MessageCreator.get());
        }
        ClasspathAddMvnMagicCommand mvnMagicCommand = this.getClasspathAddMvnMagicCommand();
        mvnMagicCommand.resetRepo();
        try {
            this.fileService.delete(new File(mvnMagicCommand.getCommandParams().getPathToCache()));
            this.fileService.delete(new File(mvnMagicCommand.getCommandParams().getPathToNotebookJars()));
        }
        catch (Exception e) {
            return new MagicCommandOutput(MagicCommandOutcomeItem.Status.ERROR, e.getMessage(), MessageCreator.get());
        }
        return new MagicCommandOutput(MagicCommandOutcomeItem.Status.OK, "Reset done, please restart the kernel.", MessageCreator.get());
    }

    public String getMagicCommandName() {
        return CLASSPATH_RESET;
    }

    public boolean matchCommand(String command) {
        String[] commandParts = MagicCommandUtils.splitPath((String)command);
        return commandParts.length == 2 && commandParts[0].equals(CLASSPATH_PREFIX) && commandParts[1].equals(RESET);
    }

    private ClasspathAddMvnMagicCommand getClasspathAddMvnMagicCommand() {
        MagicCommandFunctionality mvnMagicCommand = this.kernel.magicCommandConfiguration().getClasspathAddMvnMagicCommand(this.kernel);
        return (ClasspathAddMvnMagicCommand)mvnMagicCommand;
    }
}

