/*
 * Decompiled with CFR 0.152.
 */
package com.twosigma.beakerx.widget;

import com.twosigma.beakerx.kernel.comm.Buffer;
import com.twosigma.beakerx.kernel.comm.Data;
import com.twosigma.beakerx.kernel.msg.JupyterMessages;
import com.twosigma.beakerx.message.Message;
import com.twosigma.beakerx.mimetype.MIMEContainer;
import com.twosigma.beakerx.widget.ChangeItem;
import com.twosigma.beakerx.widget.DOMWidget;
import com.twosigma.beakerx.widget.Widget;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Output
extends DOMWidget {
    public static final String VIEW_NAME_VALUE = "OutputView";
    public static final String MODEL_NAME_VALUE = "OutputModel";
    public static final String MODEL_MODULE_VALUE = "@jupyter-widgets/output";
    public static final String VIEW_MODULE_VALUE = "@jupyter-widgets/output";
    public static final String OUTPUTS = "outputs";
    public static final String OUTPUT_TYPE = "output_type";
    public static final String NAME = "name";
    public static final String TEXT = "text";
    public static final String STREAM = "stream";
    public static final String STDERR = "stderr";
    public static final String STDOUT = "stdout";
    private List<Map<String, Serializable>> outputs = Collections.synchronizedList(new ArrayList());

    public Output() {
        this.openComm();
    }

    public Output(Message parentMessage) {
        super(parentMessage);
        this.openComm(parentMessage);
    }

    @Override
    public String getModelNameValue() {
        return MODEL_NAME_VALUE;
    }

    @Override
    public String getViewNameValue() {
        return VIEW_NAME_VALUE;
    }

    @Override
    public String getModelModuleValue() {
        return "@jupyter-widgets/output";
    }

    @Override
    public String getViewModuleValue() {
        return "@jupyter-widgets/output";
    }

    @Override
    protected HashMap<String, Object> content(HashMap<String, Object> content) {
        super.content(content);
        content.put("msg_id", "");
        content.put(OUTPUTS, new ArrayList().toArray());
        return content;
    }

    @Override
    public void stateRequestHandler() {
        super.stateRequestHandler();
        this.clearOutput();
    }

    @Override
    public void updateValue(Object value) {
        ArrayList<Message> list = new ArrayList<Message>();
        list.add(this.getComm().createUpdateMessage(Arrays.asList(new ChangeItem("msg_id", (Object)"")), new HashMap()));
        this.getComm().publish(list);
    }

    public void sendStdout(String text) {
        this.send(false, text);
    }

    public void sendStderr(String text) {
        this.send(true, text);
    }

    public void appendStdout(String text) {
        this.sendStdout(text + "\n");
    }

    public void appendStderr(String text) {
        this.sendStderr(text + "\n");
    }

    private synchronized void send(boolean isError, String text) {
        ArrayList<Message> list = new ArrayList<Message>();
        list.add(this.getComm().createUpdateMessage(Arrays.asList(new ChangeItem("msg_id", (Object)this.getComm().getParentMessage().getHeader().getId())), new HashMap()));
        Map<String, Serializable> asMap = this.addOutput(isError, text);
        list.add(this.getComm().createOutputContent(asMap));
        this.getComm().publish(list);
    }

    private void display(HashMap<String, Serializable> content) {
        ArrayList<Message> list = new ArrayList<Message>();
        list.add(this.getComm().createUpdateMessage(Arrays.asList(new ChangeItem("msg_id", (Object)this.getComm().getParentMessage().getHeader().getId())), new HashMap()));
        list.add(this.getComm().createMessage(JupyterMessages.DISPLAY_DATA, Buffer.EMPTY, new Data(content)));
        this.getComm().publish(list);
    }

    private Map<String, Serializable> addOutput(boolean isError, String text) {
        Map<String, Serializable> value = this.createOutput(isError, text);
        this.outputs.add(value);
        return value;
    }

    public void clearOutput() {
        this.outputs = Collections.synchronizedList(new ArrayList());
        this.sendUpdate(OUTPUTS, Collections.emptyList());
    }

    private Map<String, Serializable> createOutput(boolean isError, String text) {
        HashMap<String, Serializable> outputs = new HashMap<String, Serializable>();
        outputs.put(OUTPUT_TYPE, (Serializable)((Object)STREAM));
        outputs.put(NAME, (Serializable)((Object)(isError ? STDERR : STDOUT)));
        outputs.put(TEXT, (Serializable)((Object)text));
        return outputs;
    }

    public void display(MIMEContainer mimeContainer) {
        HashMap<String, Serializable> content = new HashMap<String, Serializable>();
        content.put(mimeContainer.getMime().asString(), (Serializable)mimeContainer.getData());
        this.display(content);
    }

    public void display(List<MIMEContainer> mimeContainers) {
        mimeContainers.forEach(this::display);
    }

    public void displayWidgets(List<Widget> widgets) {
        widgets.forEach(this::display);
    }

    public void display(Widget widget) {
        widget.beforeDisplay();
        HashMap<String, Serializable> content = new HashMap<String, Serializable>();
        HashMap<String, String> vendor = new HashMap<String, String>();
        vendor.put("model_id", widget.getComm().getCommId());
        content.put("application/vnd.jupyter.widget-view+json", vendor);
        this.display(content);
    }

    @Override
    public void display() {
        this.beforeDisplay();
        this.sendDisplay();
    }
}

