/*
 * Decompiled with CFR 0.152.
 */
package com.twosigma.beakerx.clojure.evaluator;

import com.twosigma.beakerx.TryResult;
import com.twosigma.beakerx.clojure.evaluator.ClojureEvaluator;
import com.twosigma.beakerx.evaluator.BaseEvaluator;
import com.twosigma.beakerx.jvm.object.EvaluationObject;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.InvocationTargetException;
import java.util.concurrent.Callable;
import org.jetbrains.annotations.NotNull;

class ClojureCodeRunner
implements Callable<TryResult> {
    private ClojureEvaluator clojureEvaluator;
    private final String theCode;
    private final EvaluationObject theOutput;

    ClojureCodeRunner(ClojureEvaluator clojureEvaluator, String code, EvaluationObject out) {
        this.clojureEvaluator = clojureEvaluator;
        this.theCode = code;
        this.theOutput = out;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TryResult call() throws Exception {
        TryResult either;
        try {
            this.theOutput.setOutputHandler();
            Object o = this.clojureEvaluator.runCode(this.theCode);
            try {
                this.checkingOfCorruptedClojureObjects(o);
                either = TryResult.createResult((Object)o);
            }
            catch (Exception e) {
                either = TryResult.createError((String)("Object: " + o.getClass() + ", value cannot be displayed due to following error: " + e.getMessage()));
            }
        }
        catch (Throwable e) {
            either = this.handleError(e);
        }
        finally {
            this.theOutput.setOutputHandler();
        }
        return this.clojureEvaluator.processResult(either);
    }

    @NotNull
    private TryResult handleError(Throwable e) {
        TryResult.CellError either;
        if (e instanceof InterruptedException || e instanceof InvocationTargetException || e instanceof ThreadDeath) {
            either = TryResult.createError((String)BaseEvaluator.INTERUPTED_MSG);
        } else {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            if (null != e.getCause()) {
                e.getCause().printStackTrace(pw);
            } else {
                e.printStackTrace(pw);
            }
            either = TryResult.createError((String)sw.toString());
        }
        return either;
    }

    private void checkingOfCorruptedClojureObjects(Object o) {
        if (null != o) {
            o.hashCode();
        }
    }
}

