/*
 * Decompiled with CFR 0.152.
 */
package com.twosigma.beakerx.kernel;

import com.twosigma.beakerx.TryResult;
import com.twosigma.beakerx.evaluator.EvaluationObjectFactory;
import com.twosigma.beakerx.jvm.object.EvaluationObject;
import com.twosigma.beakerx.kernel.Code;
import com.twosigma.beakerx.kernel.CodeFrame;
import com.twosigma.beakerx.kernel.KernelFunctionality;
import com.twosigma.beakerx.kernel.magic.command.outcome.MagicCommandOutcomeItem;
import com.twosigma.beakerx.message.Message;
import java.util.Optional;

public class PlainCode
extends CodeFrame {
    private String plainCode;
    private EvaluationObjectFactory evaluationObjectFactory;

    public PlainCode(String plainCode, EvaluationObjectFactory evaluationObjectFactory) {
        this.plainCode = plainCode;
        this.evaluationObjectFactory = evaluationObjectFactory;
    }

    public String getPlainCode() {
        return this.plainCode;
    }

    @Override
    public void executeFrame(Code code, KernelFunctionality kernel, Message message, int executionCount) {
        EvaluationObject seo = this.evaluationObjectFactory.createSeo(this.plainCode, kernel, message, executionCount);
        seo.noResult();
        TryResult either = kernel.executeCode(this.plainCode, seo);
        PlainCode.handleResult(seo, either);
    }

    @Override
    public void executeLastFrame(Code code, KernelFunctionality kernel, Message message, int executionCount) {
        EvaluationObject seo = this.evaluationObjectFactory.createSeo(this.plainCode, kernel, message, executionCount);
        TryResult either = kernel.executeCode(this.plainCode, seo);
        PlainCode.handleResult(seo, either);
    }

    @Override
    public Optional<MagicCommandOutcomeItem> getError() {
        return Optional.empty();
    }
}

