/*
 * Decompiled with CFR 0.152.
 */
package com.twosigma.beakerx.util;

import com.twosigma.beakerx.util.Preconditions;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.stream.Collectors;

public class ClassPath {
    private static final String CLASS_FILE_NAME_EXTENSION = ".class";
    private final Set<ResourceInfo> resources;

    private ClassPath(Set<ResourceInfo> resources) {
        this.resources = resources;
    }

    public boolean packageExists(String packageName) {
        List collect = this.resources.stream().filter(x -> x.getResourceName().replace("/", ".").contains(packageName)).collect(Collectors.toList());
        return !collect.isEmpty();
    }

    public static ClassPath from(ClassLoader classloader) throws IOException {
        Scanner scanner = new Scanner();
        for (Map.Entry<URI, ClassLoader> entry : ClassPath.getClassPathEntries(classloader).entrySet()) {
            scanner.scan(entry.getKey(), entry.getValue());
        }
        return new ClassPath(scanner.getResources());
    }

    static Map<URI, ClassLoader> getClassPathEntries(ClassLoader classloader) {
        HashMap<URI, ClassLoader> entries = new HashMap<URI, ClassLoader>();
        ClassLoader parent = classloader.getParent();
        if (parent != null) {
            entries.putAll(ClassPath.getClassPathEntries(parent));
        }
        if (classloader instanceof URLClassLoader) {
            URLClassLoader urlClassLoader = (URLClassLoader)classloader;
            for (URL entry : urlClassLoader.getURLs()) {
                URI uri;
                try {
                    uri = entry.toURI();
                }
                catch (URISyntaxException e) {
                    throw new IllegalArgumentException(e);
                }
                if (entries.containsKey(uri)) continue;
                entries.put(uri, classloader);
            }
        }
        return new HashMap<URI, ClassLoader>(entries);
    }

    public static String getPackageName(String classFullName) {
        int lastDot = classFullName.lastIndexOf(46);
        return lastDot < 0 ? "" : classFullName.substring(0, lastDot);
    }

    static String getClassName(String filename) {
        int classNameEnd = filename.length() - CLASS_FILE_NAME_EXTENSION.length();
        return filename.substring(0, classNameEnd).replace('/', '.');
    }

    public static class ResourceInfo {
        private final String resourceName;
        final ClassLoader loader;

        static ResourceInfo of(String resourceName, ClassLoader loader) {
            if (resourceName.endsWith(ClassPath.CLASS_FILE_NAME_EXTENSION)) {
                return new ClassInfo(resourceName, loader);
            }
            return new ResourceInfo(resourceName, loader);
        }

        ResourceInfo(String resourceName, ClassLoader loader) {
            this.resourceName = Preconditions.checkNotNull(resourceName);
            this.loader = Preconditions.checkNotNull(loader);
        }

        public final URL url() {
            return Preconditions.checkNotNull(this.loader.getResource(this.resourceName));
        }

        public final String getResourceName() {
            return this.resourceName;
        }

        public int hashCode() {
            return this.resourceName.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj instanceof ResourceInfo) {
                ResourceInfo that = (ResourceInfo)obj;
                return this.resourceName.equals(that.resourceName) && this.loader == that.loader;
            }
            return false;
        }

        public String toString() {
            return this.resourceName;
        }
    }

    public static final class ClassInfo
    extends ResourceInfo {
        private final String className;

        ClassInfo(String resourceName, ClassLoader loader) {
            super(resourceName, loader);
            this.className = ClassPath.getClassName(resourceName);
        }

        public String getPackageName() {
            return ClassPath.getPackageName(this.className);
        }

        public String getName() {
            return this.className;
        }

        public Class<?> load() {
            try {
                return this.loader.loadClass(this.className);
            }
            catch (ClassNotFoundException e) {
                throw new IllegalStateException(e);
            }
        }

        @Override
        public String toString() {
            return this.className;
        }
    }

    static final class Scanner {
        private final Set<ResourceInfo> resources = new HashSet<ResourceInfo>();
        private final Set<URI> scannedUris = new HashSet<URI>();

        Scanner() {
        }

        Set<ResourceInfo> getResources() {
            return this.resources;
        }

        void scan(URI uri, ClassLoader classloader) throws IOException {
            if (uri.getScheme().equals("file") && this.scannedUris.add(uri)) {
                this.scanFrom(new File(uri), classloader);
            }
        }

        void scanFrom(File file, ClassLoader classloader) throws IOException {
            if (!file.exists()) {
                return;
            }
            if (file.isDirectory()) {
                this.scanDirectory(file, classloader);
            } else {
                this.scanJar(file, classloader);
            }
        }

        private void scanDirectory(File directory, ClassLoader classloader) throws IOException {
            this.scanDirectory(directory, classloader, "", new HashSet<File>());
        }

        private void scanDirectory(File directory, ClassLoader classloader, String packagePrefix, Set<File> ancestors) throws IOException {
            File canonical = directory.getCanonicalFile();
            if (ancestors.contains(canonical)) {
                return;
            }
            File[] files = directory.listFiles();
            if (files == null) {
                return;
            }
            HashSet<File> newAncestors = new HashSet<File>();
            newAncestors.addAll(ancestors);
            newAncestors.add(canonical);
            for (File f : files) {
                String name = f.getName();
                if (f.isDirectory()) {
                    this.scanDirectory(f, classloader, packagePrefix + name + "/", newAncestors);
                    continue;
                }
                String resourceName = packagePrefix + name;
                if (resourceName.equals("META-INF/MANIFEST.MF")) continue;
                this.resources.add(ResourceInfo.of(resourceName, classloader));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void scanJar(File file, ClassLoader classloader) throws IOException {
            JarFile jarFile;
            try {
                jarFile = new JarFile(file);
            }
            catch (IOException e) {
                return;
            }
            try {
                for (URI uri : Scanner.getClassPathFromManifest(file, jarFile.getManifest())) {
                    this.scan(uri, classloader);
                }
                Enumeration<JarEntry> entries = jarFile.entries();
                while (entries.hasMoreElements()) {
                    JarEntry entry = entries.nextElement();
                    if (entry.isDirectory() || entry.getName().equals("META-INF/MANIFEST.MF")) continue;
                    this.resources.add(ResourceInfo.of(entry.getName(), classloader));
                }
            }
            finally {
                try {
                    jarFile.close();
                }
                catch (IOException iOException) {}
            }
        }

        static Set<URI> getClassPathFromManifest(File jarFile, Manifest manifest) {
            if (manifest == null) {
                return new HashSet<URI>();
            }
            HashSet<URI> builder = new HashSet<URI>();
            String classpathAttribute = manifest.getMainAttributes().getValue(Attributes.Name.CLASS_PATH.toString());
            if (classpathAttribute != null) {
                for (String path : classpathAttribute.split(" ")) {
                    URI uri;
                    try {
                        uri = Scanner.getClassPathEntry(jarFile, path);
                    }
                    catch (URISyntaxException e) {
                        continue;
                    }
                    builder.add(uri);
                }
            }
            return builder;
        }

        static URI getClassPathEntry(File jarFile, String path) throws URISyntaxException {
            URI uri = new URI(path);
            if (uri.isAbsolute()) {
                return uri;
            }
            return new File(jarFile.getParentFile(), path.replace('/', File.separatorChar)).toURI();
        }
    }
}

