/*
 * Decompiled with CFR 0.152.
 */
package com.twosigma.beakerx.kernel.handler;

import com.twosigma.beakerx.handler.Handler;
import com.twosigma.beakerx.handler.KernelHandler;
import com.twosigma.beakerx.handler.KernelHandlerWrapper;
import com.twosigma.beakerx.kernel.KernelFunctionality;
import com.twosigma.beakerx.kernel.comm.BxComm;
import com.twosigma.beakerx.kernel.comm.Comm;
import com.twosigma.beakerx.kernel.comm.TargetNamesEnum;
import com.twosigma.beakerx.kernel.msg.JupyterMessages;
import com.twosigma.beakerx.message.Header;
import com.twosigma.beakerx.message.Message;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class CommOpenHandler
extends KernelHandler<Message> {
    private static final Logger logger = LoggerFactory.getLogger(CommOpenHandler.class);

    public CommOpenHandler(KernelFunctionality kernel) {
        super(kernel);
    }

    public void handle(Message message) {
        KernelHandlerWrapper.wrapBusyIdle((KernelFunctionality)this.kernel, (Message)message, () -> this.handleMsg(message));
    }

    private void handleMsg(Message message) {
        logger.debug("Processing CommOpenHandler");
        Message reply = null;
        HashMap<String, Object> map = new HashMap<String, Object>(6);
        Map commMap = message.getContent();
        Comm newComm = null;
        if (this.isValidMessage(commMap)) {
            newComm = this.readComm(commMap, message);
            reply = new Message(new Header(JupyterMessages.COMM_OPEN, message.getHeader().getSession()));
            map.put("comm_id", newComm.getCommId());
            map.put("target_name", newComm.getTargetName());
            map.put("data", new HashMap());
            map.put("target_module", newComm.getTargetModule());
        } else {
            reply = new Message(new Header(JupyterMessages.COMM_CLOSE, message.getHeader().getSession()));
            map.put("data", new HashMap());
        }
        if (newComm != null) {
            logger.debug("Comm opened, target name = " + newComm.getTargetName());
            for (Handler<Message> handler : this.getKernelControlChanelHandlers(newComm.getTargetName())) {
                newComm.addMsgCallbackList(new Handler[]{handler});
            }
            this.kernel.addComm(newComm.getCommId(), newComm);
        }
        reply.setContent(map);
        reply.setParentHeader(message.getHeader());
        reply.setIdentities(message.getIdentities());
        this.send(reply);
    }

    public abstract Handler<Message>[] getKernelControlChanelHandlers(String var1);

    public static String getString(Map<String, Serializable> map, String name) {
        return (String)((Object)map.get(name));
    }

    protected Comm readComm(Map<String, Serializable> map, Message message) {
        Comm ret = this.createComm(map, message);
        ret.setData((HashMap)map.get("data"));
        ret.setTargetModule(CommOpenHandler.getString(map, "target_module"));
        return ret;
    }

    private Comm createComm(Map<String, Serializable> map, Message message) {
        String targetName = CommOpenHandler.getString(map, "target_name");
        BxComm ret = TargetNamesEnum.BEAKER_AUTOTRANSLATION.getTargetName().equals(targetName) ? new BxComm(CommOpenHandler.getString(map, "comm_id"), targetName, message) : new BxComm(CommOpenHandler.getString(map, "comm_id"), targetName);
        return ret;
    }

    protected boolean isValidMessage(Map<String, Serializable> map) {
        boolean ret = true;
        ret = ret && map.get("comm_id") != null && map.get("comm_id") instanceof String;
        ret = ret && map.get("target_name") != null && map.get("target_name") instanceof String;
        ret = ret && !this.kernel.isCommPresent(CommOpenHandler.getString(map, "comm_id"));
        return ret;
    }
}

