/*
 * Decompiled with CFR 0.152.
 */
package com.twosigma.beakerx.kernel.magic.command.functionality;

import com.twosigma.beakerx.BeakerXClientManager;
import com.twosigma.beakerx.kernel.magic.command.AsyncOptions;
import com.twosigma.beakerx.kernel.magic.command.functionality.AsyncMagicCommand;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.cli.BasicParser;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.ParseException;

public class AsyncMagicCommandOptions {
    private AsyncOptions asyncOptions = new AsyncOptions();

    public OptionsResult parseOptions(String[] args) {
        BasicParser parser = new BasicParser();
        ArrayList<AsyncMagicCommand.AsyncOptionCommand> commands = new ArrayList<AsyncMagicCommand.AsyncOptionCommand>();
        try {
            CommandLine cmd = parser.parse(this.asyncOptions.getOptions(), args);
            if (cmd.hasOption("then")) {
                commands.add(() -> BeakerXClientManager.get().runByTag(cmd.getOptionValue("then")));
            }
        }
        catch (ParseException e) {
            return new ErrorOptionsResult(e.getMessage());
        }
        return new AsyncOptionsResult(commands);
    }

    private class AsyncOptionsResult
    implements OptionsResult {
        private List<AsyncMagicCommand.AsyncOptionCommand> sparkOptions;

        public AsyncOptionsResult(List<AsyncMagicCommand.AsyncOptionCommand> sparkOptions) {
            this.sparkOptions = sparkOptions;
        }

        @Override
        public boolean hasError() {
            return false;
        }

        @Override
        public String errorMsg() {
            return "";
        }

        @Override
        public List<AsyncMagicCommand.AsyncOptionCommand> options() {
            return this.sparkOptions;
        }
    }

    private class ErrorOptionsResult
    implements OptionsResult {
        private String error;

        public ErrorOptionsResult(String error) {
            this.error = error;
        }

        @Override
        public boolean hasError() {
            return true;
        }

        @Override
        public String errorMsg() {
            return this.error;
        }

        @Override
        public List<AsyncMagicCommand.AsyncOptionCommand> options() {
            return new ArrayList<AsyncMagicCommand.AsyncOptionCommand>();
        }
    }

    public static interface OptionsResult {
        public boolean hasError();

        public String errorMsg();

        public List<AsyncMagicCommand.AsyncOptionCommand> options();
    }
}

