/*
 * Decompiled with CFR 0.152.
 */
package com.twosigma.beakerx.kernel.magic.command.functionality;

import com.twosigma.beakerx.kernel.KernelFunctionality;
import com.twosigma.beakerx.kernel.MessageCreatorService;
import com.twosigma.beakerx.kernel.PathToJar;
import com.twosigma.beakerx.kernel.magic.command.MagicCommandFunctionality;
import com.twosigma.beakerx.kernel.magic.command.functionality.ErrorData;
import com.twosigma.beakerx.kernel.magic.command.outcome.MagicCommandOutcomeItem;
import com.twosigma.beakerx.kernel.magic.command.outcome.MagicCommandOutput;
import com.twosigma.beakerx.kernel.magic.command.outcome.MagicCommandOutputFoldout;
import com.twosigma.beakerx.kernel.msg.MessageCreator;
import com.twosigma.beakerx.util.Preconditions;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public abstract class ClasspathMagicCommand
implements MagicCommandFunctionality {
    protected KernelFunctionality kernel;
    protected MessageCreatorService messageCreatorService;

    public ClasspathMagicCommand(KernelFunctionality kernel, MessageCreatorService messageCreatorService) {
        this.kernel = kernel;
        this.messageCreatorService = messageCreatorService;
    }

    public Collection<String> addJars(Collection<String> path) {
        List<PathToJar> collect = path.stream().map(PathToJar::new).collect(Collectors.toList());
        return this.addJarsToClasspath(collect);
    }

    public Collection<String> addJars(String path) {
        if (this.doesPathContainsWildCards(path).booleanValue()) {
            return this.handleWildCards(path);
        }
        return this.handlePath(path);
    }

    public MagicCommandOutcomeItem handleAddedJars(String path) {
        Collection<String> newAddedJars = this.addJars(path);
        return this.createResult(newAddedJars);
    }

    public MagicCommandOutcomeItem handleAddedJars(Collection<String> paths) {
        Collection<String> newAddedJars = this.addJars(paths);
        return this.createResult(newAddedJars);
    }

    private MagicCommandOutcomeItem createResult(Collection<String> newAddedJars) {
        if (newAddedJars.isEmpty()) {
            return new MagicCommandOutput(MagicCommandOutcomeItem.Status.OK, this.messageCreatorService);
        }
        String header = "Added jar" + (newAddedJars.size() > 1 ? "s: " : ": ");
        MagicCommandOutcomeItem.Status status = MagicCommandOutcomeItem.Status.OK;
        return new MagicCommandOutputFoldout(status, String.join((CharSequence)", ", newAddedJars), header, MessageCreator.get());
    }

    private Collection<String> handlePath(String path) {
        LinkedList<String> addedJarsName = new LinkedList<String>();
        Path currentPath = Paths.get(path, new String[0]);
        List paths = this.kernel.addJarsToClasspath(Collections.singletonList(new PathToJar(path)));
        if (!paths.isEmpty()) {
            addedJarsName.add(currentPath.getFileName().toString());
        }
        return addedJarsName;
    }

    private List<String> handleWildCards(String path) {
        Map<Path, String> paths = this.getPaths(path);
        List<PathToJar> pathsToJars = paths.keySet().stream().map(currentPath -> new PathToJar(currentPath.toString())).collect(Collectors.toList());
        List<String> addedJarsName = this.addJarsToClasspath(pathsToJars);
        return addedJarsName;
    }

    @NotNull
    private List<String> addJarsToClasspath(List<PathToJar> pathsToJars) {
        LinkedList<String> addedJarsName = new LinkedList<String>();
        List addedPaths = this.kernel.addJarsToClasspath(pathsToJars);
        addedJarsName.addAll(addedPaths.stream().map(x -> x.getFileName().toString()).collect(Collectors.toList()));
        return addedJarsName;
    }

    private Map<Path, String> getPaths(String pathWithWildcard) {
        String pathWithoutWildcards = pathWithWildcard.replace("*", "");
        try {
            return Files.list(Paths.get(pathWithoutWildcards, new String[0])).filter(path -> path.toString().toLowerCase().endsWith(".jar")).collect(Collectors.toMap(p -> p, o -> o.getFileName().toString()));
        }
        catch (IOException e) {
            throw new IllegalStateException("Cannot create any jars files in selected path");
        }
    }

    private Boolean doesPathContainsWildCards(String path) {
        return path.contains("*");
    }

    private Boolean containsSingleWildcardSymbol(String path) {
        return path.length() - path.replace("*", "").length() == 1;
    }

    protected ErrorData isValidPath(String path) {
        boolean isEmpty = ((String)Preconditions.checkNotNull((Object)path)).isEmpty();
        if (isEmpty) {
            return new ErrorData(true, "Please provide a path");
        }
        if (this.doesPathContainsWildCards(path).booleanValue()) {
            if (!this.containsSingleWildcardSymbol(path).booleanValue() || !path.endsWith("*")) {
                return new ErrorData(true, "Bad classpath wildcard syntax, path can only end with *");
            }
            if (!Paths.get(path.replace("*", ""), new String[0]).toFile().exists()) {
                return new ErrorData(true, "Bad classpath, directory cannot be create");
            }
        } else if (!Paths.get(path, new String[0]).toFile().exists()) {
            return new ErrorData(true, "Bad classpath, file not found");
        }
        return new ErrorData(false, "");
    }
}

