/*
 * Decompiled with CFR 0.152.
 */
package io.javalin.embeddedserver.jetty.websocket;

import io.javalin.core.PathParser;
import io.javalin.embeddedserver.jetty.websocket.WsSession;
import io.javalin.embeddedserver.jetty.websocket.interfaces.CloseHandler;
import io.javalin.embeddedserver.jetty.websocket.interfaces.ConnectHandler;
import io.javalin.embeddedserver.jetty.websocket.interfaces.ErrorHandler;
import io.javalin.embeddedserver.jetty.websocket.interfaces.MessageHandler;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.eclipse.jetty.websocket.api.Session;
import org.eclipse.jetty.websocket.api.annotations.WebSocket;
import org.jetbrains.annotations.NotNull;

@WebSocket
public class WebSocketHandler {
    private final PathParser pathParser;
    private final ConcurrentMap<Session, Map<String, String>> sessionParams = new ConcurrentHashMap<Session, Map<String, String>>();
    private final ConcurrentMap<Session, String> sessionIds = new ConcurrentHashMap<Session, String>();
    private ConnectHandler connectHandler = null;
    private MessageHandler messageHandler = null;
    private CloseHandler closeHandler = null;
    private ErrorHandler errorHandler = null;

    public WebSocketHandler(@NotNull String contextPath, @NotNull String path) {
        this.pathParser = new PathParser(contextPath + path);
    }

    public void onConnect(@NotNull ConnectHandler connectHandler) {
        this.connectHandler = connectHandler;
    }

    public void onMessage(@NotNull MessageHandler messageHandler) {
        this.messageHandler = messageHandler;
    }

    public void onClose(@NotNull CloseHandler closeHandler) {
        this.closeHandler = closeHandler;
    }

    public void onError(@NotNull ErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
    }

    void onConnect(Session session) throws Exception {
        WsSession wsSession = this.registerAndWrapSession(session);
        if (this.connectHandler != null) {
            this.connectHandler.handle(wsSession);
        }
    }

    void onMessage(Session session, String message) throws Exception {
        WsSession wsSession = this.registerAndWrapSession(session);
        if (this.messageHandler != null) {
            this.messageHandler.handle(wsSession, message);
        }
    }

    void onClose(Session session, int statusCode, String reason) throws Exception {
        WsSession wsSession = this.registerAndWrapSession(session);
        if (this.closeHandler != null) {
            this.closeHandler.handle(wsSession, statusCode, reason);
        }
        this.clearSessionCache(session);
    }

    void onError(Session session, Throwable throwable) throws Exception {
        WsSession wsSession = this.registerAndWrapSession(session);
        if (this.errorHandler != null) {
            this.errorHandler.handle(wsSession, throwable);
        }
    }

    public boolean matches(String requestUri) {
        return this.pathParser.matches(requestUri);
    }

    private void clearSessionCache(Session session) {
        this.sessionIds.remove(session);
        this.sessionParams.remove(session);
    }

    private WsSession registerAndWrapSession(Session session) {
        this.sessionIds.putIfAbsent(session, UUID.randomUUID().toString());
        this.sessionParams.putIfAbsent(session, this.pathParser.extractParams(session.getUpgradeRequest().getRequestURI().getPath()));
        return new WsSession((String)this.sessionIds.get(session), session, (Map)this.sessionParams.get(session));
    }
}

