# File generated from our OpenAPI spec by Stainless. See CONTRIBUTING.md for details.

from __future__ import annotations

from typing import Dict, List, Union, Iterable
from datetime import datetime
from typing_extensions import Literal, Required, Annotated, TypeAlias, TypedDict

from .._utils import PropertyInfo

__all__ = [
    "SessionCreateParams",
    "Credentials",
    "Dimensions",
    "SessionContext",
    "SessionContextCookie",
    "SessionContextCookiePartitionKey",
    "SessionContextIndexedDB",
    "SessionContextIndexedDBData",
    "SessionContextIndexedDBDataRecord",
    "SessionContextIndexedDBDataRecordBlobFile",
    "StealthConfig",
    "UseProxy",
    "UseProxyGeolocation",
    "UseProxyGeolocationGeolocation",
    "UseProxyServer",
]


class SessionCreateParams(TypedDict, total=False):
    block_ads: Annotated[bool, PropertyInfo(alias="blockAds")]
    """Block ads in the browser session. Default is false."""

    concurrency: int
    """Number of sessions to create concurrently (check your plan limit)"""

    credentials: Credentials
    """Configuration for session credentials"""

    dimensions: Dimensions
    """Viewport and browser window dimensions for the session"""

    extension_ids: Annotated[List[str], PropertyInfo(alias="extensionIds")]
    """Array of extension IDs to install in the session.

    Use ['all_ext'] to install all uploaded extensions.
    """

    is_selenium: Annotated[bool, PropertyInfo(alias="isSelenium")]
    """Enable Selenium mode for the browser session (default is false).

    Use this when you plan to connect to the browser session via Selenium.
    """

    namespace: str
    """The namespace the session should be created against. Defaults to "default"."""

    proxy_url: Annotated[str, PropertyInfo(alias="proxyUrl")]
    """Custom proxy URL for the browser session.

    Overrides useProxy, disabling Steel-provided proxies in favor of your specified
    proxy. Format: http(s)://username:password@hostname:port
    """

    region: Literal["lax", "ord", "iad", "bom", "scl", "fra", "hkg"]
    """The desired region for the session to be started in"""

    session_context: Annotated[SessionContext, PropertyInfo(alias="sessionContext")]
    """Session context data to be used in the created session.

    Sessions will start with an empty context by default.
    """

    session_id: Annotated[str, PropertyInfo(alias="sessionId")]
    """Optional custom UUID for the session"""

    solve_captcha: Annotated[bool, PropertyInfo(alias="solveCaptcha")]
    """Enable automatic captcha solving. Default is false."""

    stealth_config: Annotated[StealthConfig, PropertyInfo(alias="stealthConfig")]
    """Stealth configuration for the session"""

    api_timeout: Annotated[int, PropertyInfo(alias="timeout")]
    """Session timeout duration in milliseconds. Default is 300000 (5 minutes)."""

    use_proxy: Annotated[UseProxy, PropertyInfo(alias="useProxy")]
    """Proxy configuration for the session.

    Can be a boolean or array of proxy configurations
    """

    user_agent: Annotated[str, PropertyInfo(alias="userAgent")]
    """Custom user agent string for the browser session"""


class Credentials(TypedDict, total=False):
    auto_submit: Annotated[bool, PropertyInfo(alias="autoSubmit")]

    blur_fields: Annotated[bool, PropertyInfo(alias="blurFields")]

    exact_origin: Annotated[bool, PropertyInfo(alias="exactOrigin")]


class Dimensions(TypedDict, total=False):
    height: Required[int]
    """Height of the session"""

    width: Required[int]
    """Width of the session"""


class SessionContextCookiePartitionKey(TypedDict, total=False):
    has_cross_site_ancestor: Required[Annotated[bool, PropertyInfo(alias="hasCrossSiteAncestor")]]
    """
    Indicates if the cookie has any ancestors that are cross-site to the
    topLevelSite.
    """

    top_level_site: Required[Annotated[str, PropertyInfo(alias="topLevelSite")]]
    """
    The site of the top-level URL the browser was visiting at the start of the
    request to the endpoint that set the cookie.
    """


class SessionContextCookie(TypedDict, total=False):
    name: Required[str]
    """The name of the cookie"""

    value: Required[str]
    """The value of the cookie"""

    domain: str
    """The domain of the cookie"""

    expires: float
    """The expiration date of the cookie"""

    http_only: Annotated[bool, PropertyInfo(alias="httpOnly")]
    """Whether the cookie is HTTP only"""

    partition_key: Annotated[SessionContextCookiePartitionKey, PropertyInfo(alias="partitionKey")]
    """The partition key of the cookie"""

    path: str
    """The path of the cookie"""

    priority: Literal["Low", "Medium", "High"]
    """The priority of the cookie"""

    same_party: Annotated[bool, PropertyInfo(alias="sameParty")]
    """Whether the cookie is a same party cookie"""

    same_site: Annotated[Literal["Strict", "Lax", "None"], PropertyInfo(alias="sameSite")]
    """The same site attribute of the cookie"""

    secure: bool
    """Whether the cookie is secure"""

    session: bool
    """Whether the cookie is a session cookie"""

    size: float
    """The size of the cookie"""

    source_port: Annotated[float, PropertyInfo(alias="sourcePort")]
    """The source port of the cookie"""

    source_scheme: Annotated[Literal["Unset", "NonSecure", "Secure"], PropertyInfo(alias="sourceScheme")]
    """The source scheme of the cookie"""

    url: str
    """The URL of the cookie"""


class SessionContextIndexedDBDataRecordBlobFile(TypedDict, total=False):
    blob_number: Required[Annotated[float, PropertyInfo(alias="blobNumber")]]

    mime_type: Required[Annotated[str, PropertyInfo(alias="mimeType")]]

    size: Required[float]

    filename: str

    last_modified: Annotated[Union[str, datetime], PropertyInfo(alias="lastModified", format="iso8601")]

    path: str


class SessionContextIndexedDBDataRecord(TypedDict, total=False):
    blob_files: Annotated[Iterable[SessionContextIndexedDBDataRecordBlobFile], PropertyInfo(alias="blobFiles")]

    key: object

    value: object


class SessionContextIndexedDBData(TypedDict, total=False):
    id: Required[float]

    name: Required[str]

    records: Required[Iterable[SessionContextIndexedDBDataRecord]]


class SessionContextIndexedDB(TypedDict, total=False):
    id: Required[float]

    data: Required[Iterable[SessionContextIndexedDBData]]

    name: Required[str]


class SessionContext(TypedDict, total=False):
    cookies: Iterable[SessionContextCookie]
    """Cookies to initialize in the session"""

    indexed_db: Annotated[Dict[str, Iterable[SessionContextIndexedDB]], PropertyInfo(alias="indexedDB")]
    """Domain-specific indexedDB items to initialize in the session"""

    local_storage: Annotated[Dict[str, Dict[str, str]], PropertyInfo(alias="localStorage")]
    """Domain-specific localStorage items to initialize in the session"""

    session_storage: Annotated[Dict[str, Dict[str, str]], PropertyInfo(alias="sessionStorage")]
    """Domain-specific sessionStorage items to initialize in the session"""


class StealthConfig(TypedDict, total=False):
    humanize_interactions: Annotated[bool, PropertyInfo(alias="humanizeInteractions")]
    """
    This flag will make the browser act more human-like by moving the mouse in a
    more natural way.
    """

    skip_fingerprint_injection: Annotated[bool, PropertyInfo(alias="skipFingerprintInjection")]
    """This flag will skip the fingerprint generation for the session."""


class UseProxyGeolocationGeolocation(TypedDict, total=False):
    country: Required[
        Literal[
            "US",
            "CA",
            "MX",
            "GB",
            "DE",
            "FR",
            "IT",
            "ES",
            "PL",
            "NL",
            "SE",
            "NO",
            "DK",
            "FI",
            "CH",
            "AT",
            "BE",
            "IE",
            "PT",
            "GR",
            "CZ",
            "HU",
            "RO",
            "BG",
            "SK",
            "SI",
            "HR",
            "EE",
            "LV",
            "LT",
            "LU",
            "MT",
            "CY",
            "IS",
            "LI",
            "MC",
            "SM",
            "VA",
            "JP",
            "KR",
            "CN",
            "HK",
            "TW",
            "SG",
            "AU",
            "NZ",
            "IN",
            "TH",
            "MY",
            "PH",
            "ID",
            "VN",
            "AF",
            "BD",
            "BN",
            "KH",
            "LA",
            "LK",
            "MM",
            "NP",
            "PK",
            "FJ",
            "PG",
            "AE",
            "SA",
            "IL",
            "TR",
            "IR",
            "IQ",
            "JO",
            "KW",
            "LB",
            "OM",
            "QA",
            "BH",
            "YE",
            "SY",
            "ZA",
            "EG",
            "MA",
            "NG",
            "KE",
            "DZ",
            "AO",
            "BW",
            "ET",
            "GH",
            "CI",
            "LY",
            "MZ",
            "RW",
            "SN",
            "TN",
            "UG",
            "ZM",
            "ZW",
            "TZ",
            "MU",
            "SC",
            "BR",
            "AR",
            "CL",
            "CO",
            "PE",
            "VE",
            "EC",
            "UY",
            "PY",
            "BO",
            "CR",
            "CU",
            "DO",
            "GT",
            "HN",
            "JM",
            "NI",
            "PA",
            "SV",
            "TT",
            "BB",
            "BZ",
            "GY",
            "SR",
            "RU",
            "UA",
            "BY",
            "KZ",
            "UZ",
            "AZ",
            "GE",
            "AM",
            "MD",
            "MK",
            "AL",
            "BA",
            "RS",
            "ME",
            "XK",
            "MN",
            "KG",
            "TJ",
            "TM",
        ]
    ]
    """Country code (e.g., 'US', 'GB', 'DE') - ISO 3166-1 alpha-2"""

    city: Literal[
        "A_CORUNA",
        "ABIDJAN",
        "ABU_DHABI",
        "ABUJA",
        "ACAPULCO_DE JUAREZ",
        "ACCRA",
        "ADANA",
        "ADAPAZARI",
        "ADDIS_ABABA",
        "ADELAIDE",
        "AFYONKARAHISAR",
        "AGADIR",
        "AGUAS_LINDAS DE GOIAS",
        "AGUASCALIENTES",
        "AHMEDABAD",
        "AIZAWL",
        "AJMAN",
        "AKRON",
        "AKSARAY",
        "AL_AIN CITY",
        "AL_MANSURAH",
        "AL_QATIF",
        "ALAJUELA",
        "ALBANY",
        "ALBUQUERQUE",
        "ALEXANDRIA",
        "ALGIERS",
        "ALICANTE",
        "ALMADA",
        "ALMATY",
        "ALMERE_STAD",
        "ALVORADA",
        "AMADORA",
        "AMASYA",
        "AMBATO",
        "AMERICANA",
        "AMMAN",
        "AMSTERDAM",
        "ANANINDEUA",
        "ANAPOLIS",
        "ANGELES_CITY",
        "ANGERS",
        "ANGRA_DOS REIS",
        "ANKARA",
        "ANTAKYA",
        "ANTALYA",
        "ANTANANARIVO",
        "ANTIPOLO_CITY",
        "ANTOFAGASTA",
        "ANTWERP",
        "APARECIDA_DE GOIANIA",
        "APODACA",
        "ARACAJU",
        "ARACATUBA",
        "ARAD",
        "ARAGUAINA",
        "ARAPIRACA",
        "ARARAQUARA",
        "AREQUIPA",
        "ARICA",
        "ARLINGTON",
        "ARYANAH",
        "ASTANA",
        "ASUNCION",
        "ASYUT",
        "ATAKUM",
        "ATHENS",
        "ATIBAIA",
        "ATLANTA",
        "AUBURN",
        "AUCKLAND",
        "AURORA",
        "AUSTIN",
        "AVELLANEDA",
        "AYDIN",
        "AZCAPOTZALCO",
        "BACOLOD_CITY",
        "BACOOR",
        "BAGHDAD",
        "BAGUIO_CITY",
        "BAHIA_BLANCA",
        "BAKERSFIELD",
        "BAKU",
        "BALIKESIR",
        "BALIKPAPAN",
        "BALNEARIO_CAMBORIU",
        "BALTIMORE",
        "BANDAR_LAMPUNG",
        "BANDAR_SERI BEGAWAN",
        "BANDUNG",
        "BANGKOK",
        "BANJA_LUKA",
        "BANJARMASIN",
        "BARCELONA",
        "BARI",
        "BARQUISIMETO",
        "BARRA_MANSA",
        "BARRANQUILLA",
        "BARUERI",
        "BATAM",
        "BATANGAS",
        "BATMAN",
        "BATNA_CITY",
        "BATON_ROUGE",
        "BATUMI",
        "BAURU",
        "BEIRUT",
        "BEJAIA",
        "BEKASI",
        "BELEM",
        "BELFAST",
        "BELFORD_ROXO",
        "BELGRADE",
        "BELO_HORIZONTE",
        "BENGALURU",
        "BENI_MELLAL",
        "BERAZATEGUI",
        "BERN",
        "BETIM",
        "BHARATPUR",
        "BHOPAL",
        "BHUBANESWAR",
        "BIALYSTOK",
        "BIEN_HOA",
        "BILBAO",
        "BILECIK",
        "BIRATNAGAR",
        "BIRMINGHAM",
        "BISHKEK",
        "BIZERTE",
        "BLIDA",
        "BLOEMFONTEIN",
        "BLOOMINGTON",
        "BLUMENAU",
        "BOA_VISTA",
        "BOCHUM",
        "BOGOR",
        "BOGOTA",
        "BOISE",
        "BOKSBURG",
        "BOLOGNA",
        "BOLU",
        "BORDEAUX",
        "BOSTON",
        "BOTUCATU",
        "BRADFORD",
        "BRAGA",
        "BRAGANCA_PAULISTA",
        "BRAMPTON",
        "BRASILIA",
        "BRASOV",
        "BRATISLAVA",
        "BREMEN",
        "BRESCIA",
        "BREST",
        "BRIDGETOWN",
        "BRISBANE",
        "BRISTOL",
        "BRNO",
        "BROOKLYN",
        "BRUSSELS",
        "BUCARAMANGA",
        "BUCHAREST",
        "BUDAPEST",
        "BUENOS_AIRES",
        "BUFFALO",
        "BUK_GU",
        "BUKHARA",
        "BURGAS",
        "BURNABY",
        "BURSA",
        "BUTUAN",
        "BYDGOSZCZ",
        "CABANATUAN_CITY",
        "CABO_FRIO",
        "CABUYAO",
        "CACHOEIRO_DE ITAPEMIRIM",
        "CAGAYAN_DE ORO",
        "CAGLIARI",
        "CAIRO",
        "CALAMBA",
        "CALGARY",
        "CALOOCAN_CITY",
        "CAMACARI",
        "CAMARAGIBE",
        "CAMPECHE",
        "CAMPINA_GRANDE",
        "CAMPINAS",
        "CAMPO_GRANDE",
        "CAMPO_LARGO",
        "CAMPOS_DOS GOYTACAZES",
        "CAN_THO",
        "CANOAS",
        "CANTON",
        "CAPE_TOWN",
        "CARACAS",
        "CARAGUATATUBA",
        "CARAPICUIBA",
        "CARDIFF",
        "CARIACICA",
        "CARMONA",
        "CARTAGENA",
        "CARUARU",
        "CASABLANCA",
        "CASCAVEL",
        "CASEROS",
        "CASTANHAL",
        "CASTRIES",
        "CATALAO",
        "CATAMARCA",
        "CATANDUVA",
        "CATANIA",
        "CAUCAIA",
        "CAXIAS_DO SUL",
        "CEBU_CITY",
        "CENTRAL",
        "CENTRO",
        "CENTURION",
        "CHAGUANAS",
        "CHANDIGARH",
        "CHANDLER",
        "CHANG_HUA",
        "CHAPECO",
        "CHARLESTON",
        "CHARLOTTE",
        "CHELYABINSK",
        "CHENNAI",
        "CHERKASY",
        "CHERNIVTSI",
        "CHIA",
        "CHIANG_MAI",
        "CHICLAYO",
        "CHIHUAHUA_CITY",
        "CHIMBOTE",
        "CHISINAU",
        "CHITTAGONG",
        "CHRISTCHURCH",
        "CINCINNATI",
        "CIREBON",
        "CITY_OF MUNTINLUPA",
        "CIUDAD_DEL ESTE",
        "CIUDAD_GUAYANA",
        "CIUDAD_JUAREZ",
        "CIUDAD_NEZAHUALCOYOTL",
        "CIUDAD_OBREGON",
        "CLEVELAND",
        "CLUJ_NAPOCA",
        "COCHABAMBA",
        "COIMBATORE",
        "COIMBRA",
        "COLOGNE",
        "COLOMBO",
        "COLORADO_SPRINGS",
        "COLUMBIA",
        "COLUMBUS",
        "COMODORO_RIVADAVIA",
        "CONCEPCION",
        "CONCORD",
        "CONSTANTA",
        "CONSTANTINE",
        "CONTAGEM",
        "COPENHAGEN",
        "CORDOBA",
        "CORRIENTES",
        "CORUM",
        "COTIA",
        "COVENTRY",
        "CRAIOVA",
        "CRICIUMA",
        "CROYDON",
        "CUAUTITLAN_IZCALLI",
        "CUCUTA",
        "CUENCA",
        "CUERNAVACA",
        "CUIABA",
        "CULIACAN",
        "CURITIBA",
        "CUSCO",
        "DA_NANG",
        "DAGUPAN",
        "DAKAR",
        "DALLAS",
        "DAMIETTA",
        "DAMMAM",
        "DAR_ES SALAAM",
        "DASMARINAS",
        "DAVAO_CITY",
        "DAYTON",
        "DEBRECEN",
        "DECATUR",
        "DEHRADUN",
        "DELHI",
        "DENIZLI",
        "DENPASAR",
        "DENVER",
        "DEPOK",
        "DERBY",
        "DETROIT",
        "DHAKA",
        "DIADEMA",
        "DIVINOPOLIS",
        "DIYARBAKIR",
        "DJELFA",
        "DNIPRO",
        "DOHA",
        "DORTMUND",
        "DOURADOS",
        "DRESDEN",
        "DUBAI",
        "DUBLIN",
        "DUEZCE",
        "DUISBURG",
        "DUQUE_DE CAXIAS",
        "DURANGO",
        "DURBAN",
        "DUSSELDORF",
        "ECATEPEC",
        "EDINBURGH",
        "EDIRNE",
        "EDMONTON",
        "EL_JADIDA",
        "EL_PASO",
        "ELAZIG",
        "EMBU",
        "ENSENADA",
        "ERBIL",
        "ERZURUM",
        "ESKISEHIR",
        "ESPOO",
        "ESSEN",
        "FAISALABAD",
        "FAYETTEVILLE",
        "FAZENDA_RIO GRANDE",
        "FEIRA_DE SANTANA",
        "FES",
        "FLORENCE",
        "FLORENCIO_VARELA",
        "FLORIANOPOLIS",
        "FONTANA",
        "FORMOSA",
        "FORT_LAUDERDALE",
        "FORT_WAYNE",
        "FORT_WORTH",
        "FORTALEZA",
        "FOZ_DO IGUACU",
        "FRANCA",
        "FRANCISCO_MORATO",
        "FRANCO_DA ROCHA",
        "FRANKFURT_AM MAIN",
        "FREDERICKSBURG",
        "FRESNO",
        "FUNCHAL",
        "GABORONE",
        "GAINESVILLE",
        "GALATI",
        "GANGNAM_GU",
        "GARANHUNS",
        "GATINEAU",
        "GAZIANTEP",
        "GDANSK",
        "GDYNIA",
        "GENERAL_TRIAS",
        "GENEVA",
        "GENOA",
        "GEORGE_TOWN",
        "GEORGETOWN",
        "GHAZIABAD",
        "GHENT",
        "GIJON",
        "GIRESUN",
        "GIZA",
        "GLASGOW",
        "GLENDALE",
        "GLIWICE",
        "GOIANIA",
        "GOMEL",
        "GOTHENBURG",
        "GOVERNADOR_VALADARES",
        "GOYANG_SI",
        "GRANADA",
        "GRAND_RAPIDS",
        "GRAVATAI",
        "GRAZ",
        "GREENSBORO",
        "GREENVILLE",
        "GUADALAJARA",
        "GUADALUPE",
        "GUANGZHOU",
        "GUARAPUAVA",
        "GUARATINGUETA",
        "GUARUJA",
        "GUARULHOS",
        "GUATEMALA_CITY",
        "GUAYAQUIL",
        "GUJRANWALA",
        "GURUGRAM",
        "GUSTAVO_ADOLFO MADERO",
        "GUWAHATI",
        "GWANAK_GU",
        "HACKNEY",
        "HAIFA",
        "HAIPHONG",
        "HAMBURG",
        "HAMILTON",
        "HANOI",
        "HANOVER",
        "HARARE",
        "HAVANA",
        "HELSINKI",
        "HENDERSON",
        "HEREDIA",
        "HERMOSILLO",
        "HIALEAH",
        "HO_CHI MINH CITY",
        "HOLLYWOOD",
        "HOLON",
        "HONOLULU",
        "HORTOLANDIA",
        "HRODNA",
        "HSINCHU",
        "HUANCAYO",
        "HUANUCO",
        "HULL",
        "HURLINGHAM",
        "HYDERABAD",
        "IASI",
        "IBAGUE",
        "ICA",
        "ILAM",
        "ILFORD",
        "ILIGAN",
        "ILOILO_CITY",
        "IMPERATRIZ",
        "IMUS",
        "INCHEON",
        "INDAIATUBA",
        "INDIANAPOLIS",
        "INDORE",
        "IPATINGA",
        "IPOH",
        "IQUIQUE",
        "IRVINE",
        "ISIDRO_CASANOVA",
        "ISLAMABAD",
        "ISLINGTON",
        "ISMAILIA",
        "ISPARTA",
        "ISTANBUL",
        "ITABORAI",
        "ITABUNA",
        "ITAJAI",
        "ITANHAEM",
        "ITAPEVI",
        "ITAQUAQUECETUBA",
        "ITUZAINGO",
        "IZMIR",
        "IZTAPALAPA",
        "JABOATAO_DOS GUARARAPES",
        "JACAREI",
        "JACKSON",
        "JACKSONVILLE",
        "JAIPUR",
        "JAKARTA",
        "JARAGUA_DO SUL",
        "JAU",
        "JEDDAH",
        "JEMBER",
        "JERUSALEM",
        "JOAO_MONLEVADE",
        "JOAO_PESSOA",
        "JODHPUR",
        "JOHANNESBURG",
        "JOHOR_BAHRU",
        "JOINVILLE",
        "JOSE_C PAZ",
        "JOSE_MARIA EZEIZA",
        "JUAREZ",
        "JUAZEIRO_DO NORTE",
        "JUIZ_DE FORA",
        "JUNDIAI",
        "KAHRAMANMARAS",
        "KAMPALA",
        "KANPUR",
        "KANSAS_CITY",
        "KAOHSIUNG_CITY",
        "KARABUK",
        "KARACHI",
        "KARLSRUHE",
        "KARNAL",
        "KASKI",
        "KASTAMONU",
        "KATHMANDU",
        "KATOWICE",
        "KATSINA",
        "KATY",
        "KAUNAS",
        "KAYSERI",
        "KAZAN",
        "KECSKEMET",
        "KEDIRI",
        "KENITRA",
        "KHARKIV",
        "KHMELNYTSKYI",
        "KHON_KAEN",
        "KIELCE",
        "KIGALI",
        "KINGSTON",
        "KIRKLARELI",
        "KISSIMMEE",
        "KITCHENER",
        "KLAIPEDA",
        "KNOXVILLE",
        "KOCHI",
        "KOLKATA",
        "KOLLAM",
        "KONYA",
        "KOSEKOY",
        "KOSICE",
        "KOTA_KINABALU",
        "KOZHIKODE",
        "KRAKOW",
        "KRASNODAR",
        "KRYVYI_RIH",
        "KUALA_LUMPUR",
        "KUCHING",
        "KUTAHYA",
        "KUTAISI",
        "KUWAIT_CITY",
        "KYIV",
        "LA_PAZ",
        "LA_PLATA",
        "LA_RIOJA",
        "LA_SERENA",
        "LAFAYETTE",
        "LAFERRERE",
        "LAGES",
        "LAGOS",
        "LAHORE",
        "LAHUG",
        "LAKE_WORTH",
        "LAKELAND",
        "LANCASTER",
        "LANUS",
        "LAS_PALMAS DE GRAN CANARIA",
        "LAS_PINAS",
        "LAS_VEGAS",
        "LAUSANNE",
        "LAVAL",
        "LAWRENCEVILLE",
        "LE_MANS",
        "LEEDS",
        "LEICESTER",
        "LEIPZIG",
        "LEON",
        "LEXINGTON",
        "LIBREVILLE",
        "LIEGE",
        "LILLE",
        "LIMA",
        "LIMASSOL",
        "LIMEIRA",
        "LINCOLN",
        "LINHARES",
        "LIPA_CITY",
        "LISBON",
        "LIVERPOOL",
        "LJUBLJANA",
        "LODZ",
        "LOJA",
        "LOMAS_DE ZAMORA",
        "LOME",
        "LONDRINA",
        "LONG_BEACH",
        "LONGUEUIL",
        "LOUISVILLE",
        "LUANDA",
        "LUBLIN",
        "LUCENA_CITY",
        "LUCKNOW",
        "LUDHIANA",
        "LUSAKA",
        "LUXEMBOURG",
        "LUZIANIA",
        "LVIV",
        "LYON",
        "MABALACAT",
        "MACAE",
        "MACAO",
        "MACAPA",
        "MACEIO",
        "MACHALA",
        "MADISON",
        "MADRID",
        "MAGE",
        "MAGELANG",
        "MAGNESIA_AD SIPYLUM",
        "MAKASSAR",
        "MAKATI_CITY",
        "MALABON",
        "MALAGA",
        "MALANG",
        "MALAPPURAM",
        "MALDONADO",
        "MALE",
        "MALMO",
        "MANADO",
        "MANAGUA",
        "MANAMA",
        "MANAUS",
        "MANCHESTER",
        "MANDALUYONG_CITY",
        "MANILA",
        "MANIZALES",
        "MANNHEIM",
        "MAPUTO",
        "MAR_DEL PLATA",
        "MARABA",
        "MARACAIBO",
        "MARACANAU",
        "MARACAY",
        "MARDIN",
        "MARIBOR",
        "MARICA",
        "MARIETTA",
        "MARIKINA_CITY",
        "MARILIA",
        "MARINGA",
        "MARRAKESH",
        "MARSEILLE",
        "MAUA",
        "MAZATLAN",
        "MEDAN",
        "MEDELLIN",
        "MEDINA",
        "MEERUT",
        "MEKNES",
        "MELBOURNE",
        "MEMPHIS",
        "MENDOZA",
        "MERIDA",
        "MERKEZ",
        "MERLO",
        "MERSIN",
        "MESA",
        "MEXICALI",
        "MEXICO_CITY",
        "MILAN",
        "MILTON_KEYNES",
        "MILWAUKEE",
        "MINNEAPOLIS",
        "MINSK",
        "MISKOLC",
        "MISSISSAUGA",
        "MOGI_DAS CRUZES",
        "MOHALI",
        "MONROE",
        "MONTE_GRANDE",
        "MONTEGO_BAY",
        "MONTERREY",
        "MONTES_CLAROS",
        "MONTEVIDEO",
        "MONTGOMERY",
        "MONTPELLIER",
        "MONTREAL",
        "MORELIA",
        "MORENO",
        "MORON",
        "MOSSORO",
        "MUGLA",
        "MULTAN",
        "MUMBAI",
        "MUNICH",
        "MURCIA",
        "MUSCAT",
        "MUZAFFARGARH",
        "MYKOLAYIV",
        "NAALDWIJK",
        "NAGA",
        "NAGPUR",
        "NAIROBI",
        "NANTES",
        "NAPLES",
        "NASHVILLE",
        "NASSAU",
        "NASUGBU",
        "NATAL",
        "NAUCALPAN",
        "NAVI_MUMBAI",
        "NEIVA",
        "NEUQUEN",
        "NEVSEHIR",
        "NEW_DELHI",
        "NEW_ORLEANS",
        "NEW_TAIPEI",
        "NEWARK",
        "NEWCASTLE_UPON TYNE",
        "NHA_TRANG",
        "NICE",
        "NICOSIA",
        "NILOPOLIS",
        "NIS",
        "NITEROI",
        "NITRA",
        "NIZHNIY_NOVGOROD",
        "NOGALES",
        "NOIDA",
        "NORTHAMPTON",
        "NORWICH",
        "NOTTINGHAM",
        "NOVA_FRIBURGO",
        "NOVA_IGUACU",
        "NOVI_SAD",
        "NOVO_HAMBURGO",
        "NOVOSIBIRSK",
        "NUREMBERG",
        "OAKLAND",
        "OAXACA_CITY",
        "ODESA",
        "OKLAHOMA_CITY",
        "OLINDA",
        "OLOMOUC",
        "OLONGAPO_CITY",
        "OLSZTYN",
        "OMAHA",
        "ORADEA",
        "ORAN",
        "ORDU",
        "ORLANDO",
        "OSASCO",
        "OSLO",
        "OSMANIYE",
        "OSTRAVA",
        "OTTAWA",
        "OUJDA",
        "OURINHOS",
        "PACHUCA",
        "PADOVA",
        "PALAKKAD",
        "PALEMBANG",
        "PALERMO",
        "PALHOCA",
        "PALMA",
        "PALMAS",
        "PANAMA_CITY",
        "PARAMARIBO",
        "PARANA",
        "PARANAGUA",
        "PARANAQUE_CITY",
        "PARAUAPEBAS",
        "PARIS",
        "PARNAIBA",
        "PARNAMIRIM",
        "PASSO_FUNDO",
        "PASTO",
        "PATAN",
        "PATNA",
        "PATOS_DE MINAS",
        "PAULISTA",
        "PECS",
        "PEKANBARU",
        "PELOTAS",
        "PEORIA",
        "PEREIRA",
        "PERM",
        "PERTH",
        "PESCARA",
        "PESHAWAR",
        "PETAH_TIKVA",
        "PETALING_JAYA",
        "PETROLINA",
        "PETROPOLIS",
        "PHILADELPHIA",
        "PHNOM_PENH",
        "PHOENIX",
        "PILAR",
        "PINDAMONHANGABA",
        "PIRACICABA",
        "PITESTI",
        "PITTSBURGH",
        "PIURA",
        "PLANO",
        "PLOIESTI",
        "PLOVDIV",
        "PLYMOUTH",
        "POCOS_DE CALDAS",
        "PODGORICA",
        "POLTAVA",
        "PONTA_GROSSA",
        "PONTIANAK",
        "POPAYAN",
        "PORT_AU PRINCE",
        "PORT_ELIZABETH",
        "PORT_HARCOURT",
        "PORT_LOUIS",
        "PORT_MONTT",
        "PORT_OF SPAIN",
        "PORT_SAID",
        "PORTLAND",
        "PORTO",
        "PORTO_ALEGRE",
        "PORTO_SEGURO",
        "PORTO_VELHO",
        "PORTOVIEJO",
        "POSADAS",
        "POUSO_ALEGRE",
        "POZNAN",
        "PRAGUE",
        "PRAIA_GRANDE",
        "PRESIDENTE_PRUDENTE",
        "PRETORIA",
        "PRISTINA",
        "PROVIDENCE",
        "PUCALLPA",
        "PUCHONG_BATU DUA BELAS",
        "PUEBLA_CITY",
        "PUNE",
        "QUEBEC",
        "QUEENS",
        "QUEIMADOS",
        "QUERETARO_CITY",
        "QUEZON_CITY",
        "QUILMES",
        "QUITO",
        "RABAT",
        "RAIPUR",
        "RAJKOT",
        "RAJSHAHI",
        "RALEIGH",
        "RAMAT_GAN",
        "RANCAGUA",
        "RANCHI",
        "RAS_AL KHAIMAH",
        "RAWALPINDI",
        "READING",
        "RECIFE",
        "REGINA",
        "RENNES",
        "RENO",
        "RESISTENCIA",
        "REYKJAVIK",
        "REYNOSA",
        "RIBEIRAO_DAS NEVES",
        "RIBEIRAO_PRETO",
        "RICHMOND",
        "RIGA",
        "RIO_BRANCO",
        "RIO_CLARO",
        "RIO_CUARTO",
        "RIO_DE JANEIRO",
        "RIO_DO SUL",
        "RIO_GALLEGOS",
        "RIO_GRANDE",
        "RISHON_LETSIYYON",
        "RIVERSIDE",
        "RIYADH",
        "RIZE",
        "ROCHESTER",
        "ROME",
        "RONDONOPOLIS",
        "ROSARIO",
        "ROSEAU",
        "ROSTOV_ON DON",
        "ROTTERDAM",
        "ROUEN",
        "ROUSSE",
        "RZESZOW",
        "SACRAMENTO",
        "SAGAR",
        "SAINT_PAUL",
        "SALE",
        "SALT_LAKE CITY",
        "SALTA",
        "SALTILLO",
        "SALVADOR",
        "SAMARA",
        "SAMARINDA",
        "SAMARKAND",
        "SAMSUN",
        "SAN_ANTONIO",
        "SAN_DIEGO",
        "SAN_FERNANDO",
        "SAN_FRANCISCO",
        "SAN_JOSE",
        "SAN_JOSE DEL MONTE",
        "SAN_JUAN",
        "SAN_JUSTO",
        "SAN_LUIS",
        "SAN_LUIS POTOSI CITY",
        "SAN_MIGUEL",
        "SAN_MIGUEL DE TUCUMAN",
        "SAN_PABLO CITY",
        "SAN_PEDRO",
        "SAN_PEDRO SULA",
        "SAN_SALVADOR",
        "SAN_SALVADOR DE JUJUY",
        "SANAA",
        "SANLIURFA",
        "SANTA_CRUZ",
        "SANTA_CRUZ DE TENERIFE",
        "SANTA_CRUZ DO SUL",
        "SANTA_FE",
        "SANTA_LUZIA",
        "SANTA_MARIA",
        "SANTA_MARTA",
        "SANTA_ROSA",
        "SANTAREM",
        "SANTIAGO",
        "SANTIAGO_DE CALI",
        "SANTIAGO_DE LOS CABALLEROS",
        "SANTO_ANDRE",
        "SANTO_DOMINGO",
        "SANTO_DOMINGO ESTE",
        "SANTOS",
        "SAO_BERNARDO DO CAMPO",
        "SAO_CARLOS",
        "SAO_GONCALO",
        "SAO_JOAO DE MERITI",
        "SAO_JOSE",
        "SAO_JOSE DO RIO PRETO",
        "SAO_JOSE DOS CAMPOS",
        "SAO_JOSE DOS PINHAIS",
        "SAO_LEOPOLDO",
        "SAO_LUIS",
        "SAO_PAULO",
        "SAO_VICENTE",
        "SARAJEVO",
        "SASKATOON",
        "SCARBOROUGH",
        "SEATTLE",
        "SEMARANG",
        "SEO_GU",
        "SEONGNAM_SI",
        "SEOUL",
        "SERRA",
        "SETE_LAGOAS",
        "SETIF",
        "SETUBAL",
        "SEVILLE",
        "SFAX",
        "SHAH_ALAM",
        "SHANGHAI",
        "SHARJAH",
        "SHEFFIELD",
        "SHENZHEN",
        "SHIMLA",
        "SIAULIAI",
        "SIBIU",
        "SIDOARJO",
        "SIKAR",
        "SILVER_SPRING",
        "SINOP",
        "SIVAS",
        "SKIKDA",
        "SKOPJE",
        "SLOUGH",
        "SOBRAL",
        "SOFIA",
        "SOROCABA",
        "SOUSSE",
        "SOUTH_TANGERANG",
        "SOUTHAMPTON",
        "SOUTHWARK",
        "SPLIT",
        "SPOKANE",
        "SPRING",
        "SPRINGFIELD",
        "ST_LOUIS",
        "ST_PETERSBURG",
        "STARA_ZAGORA",
        "STATEN_ISLAND",
        "STOCKHOLM",
        "STOCKTON",
        "STOKE_ON TRENT",
        "STRASBOURG",
        "STUTTGART",
        "SUMARE",
        "SURABAYA",
        "SURAKARTA",
        "SURAT",
        "SURREY",
        "SUWON",
        "SUZANO",
        "SYDNEY",
        "SZCZECIN",
        "SZEGED",
        "SZEKESFEHERVAR",
        "TABOAO_DA SERRA",
        "TACNA",
        "TACOMA",
        "TAGUIG",
        "TAICHUNG",
        "TAINAN_CITY",
        "TAIPEI",
        "TALAVERA",
        "TALCA",
        "TALLAHASSEE",
        "TALLINN",
        "TAMPA",
        "TAMPERE",
        "TAMPICO",
        "TANGERANG",
        "TANGIER",
        "TANTA",
        "TANZA",
        "TAOYUAN_DISTRICT",
        "TAPPAHANNOCK",
        "TARLAC_CITY",
        "TASHKENT",
        "TASIKMALAYA",
        "TATUI",
        "TAUBATE",
        "TBILISI",
        "TEGUCIGALPA",
        "TEHRAN",
        "TEIXEIRA_DE FREITAS",
        "TEKIRDAG",
        "TEL_AVIV",
        "TEMUCO",
        "TEPIC",
        "TERESINA",
        "TERNOPIL",
        "TERRASSA",
        "TETOUAN",
        "THANE",
        "THE_BRONX",
        "THE_HAGUE",
        "THESSALONIKI",
        "THIRUVANANTHAPURAM",
        "THRISSUR",
        "TIJUANA",
        "TIMISOARA",
        "TIRANA",
        "TLALNEPANTLA",
        "TLAXCALA_CITY",
        "TLEMCEN",
        "TOKAT_PROVINCE",
        "TOKYO",
        "TOLUCA",
        "TORONTO",
        "TORREON",
        "TOULOUSE",
        "TRABZON",
        "TRUJILLO",
        "TUBARAO",
        "TUCSON",
        "TUGUEGARAO_CITY",
        "TULSA",
        "TUNIS",
        "TUNJA",
        "TURIN",
        "TUXTLA_GUTIERREZ",
        "TUZLA",
        "UBERABA",
        "UBERLANDIA",
        "UFA",
        "ULAN_BATOR",
        "UMEDA",
        "URDANETA",
        "USAK",
        "VADODARA",
        "VALENCIA",
        "VALINHOS",
        "VALLADOLID",
        "VALLEDUPAR",
        "VALPARAISO",
        "VALPARAISO_DE GOIAS",
        "VAN",
        "VANCOUVER",
        "VARANASI",
        "VARGINHA",
        "VARNA",
        "VARZEA_PAULISTA",
        "VENUSTIANO_CARRANZA",
        "VERACRUZ",
        "VERONA",
        "VIAMAO",
        "VICTORIA",
        "VIENNA",
        "VIENTIANE",
        "VIGO",
        "VIJAYAWADA",
        "VILA_NOVA DE GAIA",
        "VILA_VELHA",
        "VILLA_BALLESTER",
        "VILLAVICENCIO",
        "VILNIUS",
        "VINA_DEL MAR",
        "VINNYTSIA",
        "VIRGINIA_BEACH",
        "VISAKHAPATNAM",
        "VITORIA",
        "VITORIA_DA CONQUISTA",
        "VITORIA_DE SANTO ANTAO",
        "VOLTA_REDONDA",
        "VORONEZH",
        "WARSAW",
        "WASHINGTON",
        "WELLINGTON",
        "WEST_PALM BEACH",
        "WICHITA",
        "WILLEMSTAD",
        "WILMINGTON",
        "WINDHOEK",
        "WINDSOR",
        "WINNIPEG",
        "WOLVERHAMPTON",
        "WOODBRIDGE",
        "WROCLAW",
        "WUPPERTAL",
        "XALAPA",
        "YALOVA",
        "YANGON",
        "YEKATERINBURG",
        "YEREVAN",
        "YOGYAKARTA",
        "YOKOHAMA",
        "YONGIN_SI",
        "ZABRZE",
        "ZAGAZIG",
        "ZAGREB",
        "ZAMBOANGA_CITY",
        "ZAPOPAN",
        "ZAPORIZHZHYA",
        "ZARAGOZA",
        "ZHONGLI_DISTRICT",
        "ZIELONA_GORA",
        "ZONGULDAK",
        "ZURICH",
    ]
    """City name (e.g., 'NEW_YORK', 'LOS_ANGELES')"""

    state: Literal[
        "AL",
        "AK",
        "AZ",
        "AR",
        "CA",
        "CO",
        "CT",
        "DE",
        "FL",
        "GA",
        "HI",
        "ID",
        "IL",
        "IN",
        "IA",
        "KS",
        "KY",
        "LA",
        "ME",
        "MD",
        "MA",
        "MI",
        "MN",
        "MS",
        "MO",
        "MT",
        "NE",
        "NV",
        "NH",
        "NJ",
        "NM",
        "NY",
        "NC",
        "ND",
        "OH",
        "OK",
        "OR",
        "PA",
        "RI",
        "SC",
        "SD",
        "TN",
        "TX",
        "UT",
        "VT",
        "VA",
        "WA",
        "WV",
        "WI",
        "WY",
        "DC",
        "PR",
        "GU",
        "VI",
    ]
    """State code (e.g., 'NY', 'CA') - US states only"""


class UseProxyGeolocation(TypedDict, total=False):
    geolocation: Required[UseProxyGeolocationGeolocation]
    """Geographic location for the proxy"""


class UseProxyServer(TypedDict, total=False):
    server: Required[str]
    """Proxy server URL"""


UseProxy: TypeAlias = Union[bool, UseProxyGeolocation, UseProxyServer, object]
