"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const core_1 = require("@aws-cdk/core");
const lib_1 = require("../lib");
const user_1 = require("../lib/user");
const app = new core_1.App();
const stack = new core_1.Stack(app, 'aws-cdk-iam-managed-policy');
const user = new user_1.User(stack, 'MyUser');
const policy = new lib_1.ManagedPolicy(stack, 'OneManagedPolicy', {
    managedPolicyName: 'Default',
    description: 'My Policy',
    path: '/some/path/',
});
policy.addStatements(new lib_1.PolicyStatement({ resources: ['*'], actions: ['sqs:SendMessage'] }));
policy.attachToUser(user);
const policy2 = new lib_1.ManagedPolicy(stack, 'TwoManagedPolicy');
policy2.addStatements(new lib_1.PolicyStatement({ resources: ['*'], actions: ['lambda:InvokeFunction'] }));
user.addManagedPolicy(policy2);
const policy3 = lib_1.ManagedPolicy.fromAwsManagedPolicyName('SecurityAudit');
user.addManagedPolicy(policy3);
app.synth();
//# sourceMappingURL=data:application/json;base64,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