

from __future__ import annotations 
from typing import (
    List
)
from pydantic.version import VERSION  as PYDANTIC_VERSION 
if int(PYDANTIC_VERSION[0])>=2:
    from pydantic import (
        BaseModel,
        ConfigDict
    )
else:
    from pydantic import (
        BaseModel
    )

metamodel_version = "None"
version = "None"


class ConfiguredBaseModel(BaseModel):
    model_config = ConfigDict(
        validate_assignment = True,
        validate_default = True,
        extra = "allow",
        arbitrary_types_allowed = True,
        use_enum_values = True,
        strict = False,
    )
    pass

class Part(ConfiguredBaseModel):
    id: str
    type : str
    is_required : bool

class VariantLabel(ConfiguredBaseModel):


    id: str 
    separator: str 
    type: str 
    parts: List[Part] 


# Model rebuild
# see https://pydantic-docs.helpmanual.io/usage/models/#rebuilding-a-model
VariantLabel.model_rebuild()
