"""
Categorized lists of DoOR receptors and sensory neuron types.
"""

ODORANT_RECEPTORS = [
    "Or1a",
    "Or2a",
    "Or7a",
    "Or9a",
    "Or10a",
    "Or13a",
    "Or19a",
    "Or22a",
    "Or22b",
    "Or23a",
    "Or30a",
    "Or33a",
    "Or33b",
    "Or33c",
    "Or35a",
    "Or42a",
    "Or42b",
    "Or43a",
    "Or43b",
    "Or45a",
    "Or45b",
    "Or46a",
    "Or47a",
    "Or47b",
    "Or49a",
    "Or49b",
    "Or56a",
    "Or59a",
    "Or59b",
    "Or59c",
    "Or65a",
    "Or67a",
    "Or67b",
    "Or67c",
    "Or69a",
    "Or71a",
    "Or74a",
    "Or82a",
    "Or83c",
    "Or85a",
    "Or85b",
    "Or85c",
    "Or85d",
    "Or85e",
    "Or85f",
    "Or88a",
    "Or92a",
    "Or94a",
    "Or94b",
    "Or98a",
]

IONOTROPIC_RECEPTORS = [
    "Ir8a",
    "Ir25a",
    "Ir31a",
    "Ir41a",
    "Ir64a",
    "Ir75a",
    "Ir75d",
    "Ir76a",
    "Ir76b",
    "Ir84a",
    "Ir92a",
    "Ir20a",
    "Ir21a",
    "Ir40a",
    "Ir52a",
    "Ir52c",
    "Ir52d",
    "Ir56d",
    "Ir60a",
    "Ir68a",
    "Ir93a",
]

GUSTATORY_RECEPTORS = [
    "Gr10a",
    "Gr21a",
    "Gr28a",
    "Gr28b",
    "Gr32a",
    "Gr33a",
    "Gr39a",
    "Gr47a",
    "Gr54a",
    "Gr58a",
    "Gr58b",
    "Gr58c",
    "Gr59a",
    "Gr59b",
    "Gr59c",
    "Gr59d",
    "Gr59e",
    "Gr59f",
    "Gr61a",
    "Gr63a",
    "Gr64a",
    "Gr64b",
    "Gr64c",
    "Gr64d",
    "Gr64e",
    "Gr64f",
    "Gr66a",
    "Gr68a",
    "Gr89a",
    "Gr93a",
    "Gr97a",
    "Gr98a",
    "Gr98b",
    "Gr98c",
    "Gr98d",
]

NEURON_TYPES = [
    "ab1A",
    "ab1B",
    "ab1C",
    "ab1D",
    "ab2A",
    "ab2B",
    "ab3A",
    "ab3B",
    "ab4A",
    "ab4B",
    "ab5A",
    "ab5B",
    "ac1",
    "ac2",
    "ac3",
    "ac4",
    "pb1A",
    "pb1B",
    "pb2A",
    "pb2B",
    "pb3A",
    "pb3B",
]

RECEPTOR_GROUPS = {
    "or": ODORANT_RECEPTORS,
    "ir": IONOTROPIC_RECEPTORS,
    "gr": GUSTATORY_RECEPTORS,
    "neuron": NEURON_TYPES,
}
